/* imap-engine-create-email.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-engine-create-email.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION (geary_imap_engine_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))

typedef struct _GearyImapEngineReplayOperation GearyImapEngineReplayOperation;
typedef struct _GearyImapEngineReplayOperationClass GearyImapEngineReplayOperationClass;
typedef struct _GearyImapEngineReplayOperationPrivate GearyImapEngineReplayOperationPrivate;

#define GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER (geary_imap_db_email_identifier_get_type ())
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))

typedef struct _GearyImapDBEmailIdentifier GearyImapDBEmailIdentifier;
typedef struct _GearyImapDBEmailIdentifierClass GearyImapDBEmailIdentifierClass;
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE
} GearyImapEngineReplayOperationStatus;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_STATUS (geary_imap_engine_replay_operation_status_get_type ())

#define GEARY_IMAP_TYPE_FOLDER_SESSION (geary_imap_folder_session_get_type ())
#define GEARY_IMAP_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSession))
#define GEARY_IMAP_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))
#define GEARY_IMAP_IS_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_IS_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_FOLDER_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))

typedef struct _GearyImapFolderSession GearyImapFolderSession;
typedef struct _GearyImapFolderSessionClass GearyImapFolderSessionClass;

#define GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION (geary_imap_engine_send_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_SEND_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, GearyImapEngineSendReplayOperation))
#define GEARY_IMAP_ENGINE_SEND_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, GearyImapEngineSendReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_SEND_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_SEND_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_SEND_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, GearyImapEngineSendReplayOperationClass))

typedef struct _GearyImapEngineSendReplayOperation GearyImapEngineSendReplayOperation;
typedef struct _GearyImapEngineSendReplayOperationClass GearyImapEngineSendReplayOperationClass;
typedef struct _GearyImapEngineSendReplayOperationPrivate GearyImapEngineSendReplayOperationPrivate;

#define GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL (geary_imap_engine_create_email_get_type ())
#define GEARY_IMAP_ENGINE_CREATE_EMAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL, GearyImapEngineCreateEmail))
#define GEARY_IMAP_ENGINE_CREATE_EMAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL, GearyImapEngineCreateEmailClass))
#define GEARY_IMAP_ENGINE_IS_CREATE_EMAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL))
#define GEARY_IMAP_ENGINE_IS_CREATE_EMAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL))
#define GEARY_IMAP_ENGINE_CREATE_EMAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL, GearyImapEngineCreateEmailClass))

typedef struct _GearyImapEngineCreateEmail GearyImapEngineCreateEmail;
typedef struct _GearyImapEngineCreateEmailClass GearyImapEngineCreateEmailClass;
typedef struct _GearyImapEngineCreateEmailPrivate GearyImapEngineCreateEmailPrivate;

#define GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER (geary_imap_engine_minimal_folder_get_type ())
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))

typedef struct _GearyImapEngineMinimalFolder GearyImapEngineMinimalFolder;
typedef struct _GearyImapEngineMinimalFolderClass GearyImapEngineMinimalFolderClass;
enum  {
	GEARY_IMAP_ENGINE_CREATE_EMAIL_0_PROPERTY,
	GEARY_IMAP_ENGINE_CREATE_EMAIL_CREATED_ID_PROPERTY,
	GEARY_IMAP_ENGINE_CREATE_EMAIL_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_create_email_properties[GEARY_IMAP_ENGINE_CREATE_EMAIL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_THROW,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE
} GearyImapEngineReplayOperationOnError;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_ON_ERROR (geary_imap_engine_replay_operation_on_error_get_type ())

#define GEARY_IMAP_DB_TYPE_FOLDER (geary_imap_db_folder_get_type ())
#define GEARY_IMAP_DB_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolder))
#define GEARY_IMAP_DB_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))
#define GEARY_IMAP_DB_IS_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_IS_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))

typedef struct _GearyImapDBFolder GearyImapDBFolder;
typedef struct _GearyImapDBFolderClass GearyImapDBFolderClass;

#define GEARY_TYPE_CONTACT_HARVESTER (geary_contact_harvester_get_type ())
#define GEARY_CONTACT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_TYPE_CONTACT_HARVESTER, GearyContactHarvester))
#define GEARY_IS_CONTACT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_TYPE_CONTACT_HARVESTER))
#define GEARY_CONTACT_HARVESTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEARY_TYPE_CONTACT_HARVESTER, GearyContactHarvesterIface))

typedef struct _GearyContactHarvester GearyContactHarvester;
typedef struct _GearyContactHarvesterIface GearyContactHarvesterIface;
typedef struct _GearyImapEngineCreateEmailReplayRemoteAsyncData GearyImapEngineCreateEmailReplayRemoteAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyImapEngineCreateEmailCheckCancelledData GearyImapEngineCreateEmailCheckCancelledData;

struct _GearyImapEngineReplayOperation {
	GearyBaseObject parent_instance;
	GearyImapEngineReplayOperationPrivate * priv;
};

struct _GearyImapEngineReplayOperationClass {
	GearyBaseObjectClass parent_class;
	void (*notify_remote_removed_position) (GearyImapEngineReplayOperation* self, GearyImapSequenceNumber* removed);
	void (*notify_remote_removed_ids) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*get_ids_to_be_remote_removed) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*replay_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GearyImapEngineReplayOperationStatus (*replay_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*replay_remote_async) (GearyImapEngineReplayOperation* self, GearyImapFolderSession* remote, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*replay_remote_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*backout_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*backout_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	gchar* (*describe_state) (GearyImapEngineReplayOperation* self);
};

struct _GearyImapEngineSendReplayOperation {
	GearyImapEngineReplayOperation parent_instance;
	GearyImapEngineSendReplayOperationPrivate * priv;
};

struct _GearyImapEngineSendReplayOperationClass {
	GearyImapEngineReplayOperationClass parent_class;
};

struct _GearyImapEngineCreateEmail {
	GearyImapEngineSendReplayOperation parent_instance;
	GearyImapEngineCreateEmailPrivate * priv;
};

struct _GearyImapEngineCreateEmailClass {
	GearyImapEngineSendReplayOperationClass parent_class;
};

struct _GearyImapEngineCreateEmailPrivate {
	GearyEmailIdentifier* _created_id;
	GearyImapEngineMinimalFolder* engine;
	GearyRFC822Message* rfc822;
	GearyEmailFlags* flags;
	GDateTime* date_received;
	GCancellable* cancellable;
};

struct _GearyContactHarvesterIface {
	GTypeInterface parent_iface;
	void (*harvest_from_email) (GearyContactHarvester* self, GeeCollection* messages, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*harvest_from_email_finish) (GearyContactHarvester* self, GAsyncResult* _res_, GError** error);
};

struct _GearyImapEngineCreateEmailReplayRemoteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineCreateEmail* self;
	GearyImapFolderSession* remote;
	GCancellable* _tmp0_;
	GError* _tmp1_;
	GearyRFC822Message* _tmp2_;
	GearyEmailIdentifier* _tmp3_;
	GearyRFC822Message* _tmp4_;
	GearyEmailFlags* _tmp5_;
	GDateTime* _tmp6_;
	GearyEmailIdentifier* _tmp7_;
	GearyEmailIdentifier* _tmp8_;
	GearyEmail* created;
	GearyEmailIdentifier* _tmp9_;
	GearyEmail* _tmp10_;
	GeeMap* results;
	GearyImapEngineMinimalFolder* _tmp11_;
	GearyImapDBFolder* _tmp12_;
	GearyImapDBFolder* _tmp13_;
	GearyEmail* _tmp14_;
	GearyIterable* _tmp15_;
	GearyIterable* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GearyImapEngineMinimalFolder* _tmp19_;
	GearyContactHarvester* _tmp20_;
	GearyContactHarvester* _tmp21_;
	GCancellable* _tmp22_;
	GeeMap* _tmp23_;
	GeeMap* _tmp24_;
	GeeMap* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GeeMap* _tmp28_;
	GeeSet* _tmp29_;
	GeeSet* _tmp30_;
	GeeSet* _tmp31_;
	gpointer _tmp32_;
	GearyEmail* _tmp33_;
	GearyEmailIdentifier* _tmp34_;
	GearyEmailIdentifier* _tmp35_;
	GError* _inner_error0_;
};

struct _GearyImapEngineCreateEmailCheckCancelledData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineCreateEmail* self;
	GearyImapFolderSession* remote;
	GCancellable* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GearyEmailIdentifier* _tmp2_;
	GearyImapUID* _tmp3_;
	GearyImapUID* _tmp4_;
	GearyImapMessageSet* _tmp5_;
	GearyImapMessageSet* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	GError* _tmp9_;
	GError* _inner_error0_;
};

static gint GearyImapEngineCreateEmail_private_offset;
static gpointer geary_imap_engine_create_email_parent_class = NULL;

VALA_EXTERN GType geary_imap_engine_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_email_identifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_folder_session_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_send_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_create_email_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_minimal_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_async (GearyImapEngineReplayOperation* self,
                                                             GearyImapFolderSession* remote,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_describe_state (GearyImapEngineReplayOperation* self);
VALA_EXTERN GearyEmailIdentifier* geary_imap_engine_create_email_get_created_id (GearyImapEngineCreateEmail* self);
static void geary_imap_engine_create_email_set_created_id (GearyImapEngineCreateEmail* self,
                                                    GearyEmailIdentifier* value);
VALA_EXTERN GearyImapEngineCreateEmail* geary_imap_engine_create_email_new (GearyImapEngineMinimalFolder* engine,
                                                                GearyRFC822Message* rfc822,
                                                                GearyEmailFlags* flags,
                                                                GDateTime* date_received,
                                                                GCancellable* cancellable);
VALA_EXTERN GearyImapEngineCreateEmail* geary_imap_engine_create_email_construct (GType object_type,
                                                                      GearyImapEngineMinimalFolder* engine,
                                                                      GearyRFC822Message* rfc822,
                                                                      GearyEmailFlags* flags,
                                                                      GDateTime* date_received,
                                                                      GCancellable* cancellable);
VALA_EXTERN GType geary_imap_engine_replay_operation_on_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapEngineSendReplayOperation* geary_imap_engine_send_replay_operation_construct_only_remote (GType object_type,
                                                                                                   const gchar* name,
                                                                                                   GearyImapEngineReplayOperationOnError on_remote_error);
static void geary_imap_engine_create_email_real_replay_remote_async_data_free (gpointer _data);
static void geary_imap_engine_create_email_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                              GearyImapFolderSession* remote,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static gboolean geary_imap_engine_create_email_real_replay_remote_async_co (GearyImapEngineCreateEmailReplayRemoteAsyncData* _data_);
VALA_EXTERN void geary_imap_folder_session_create_email_async (GearyImapFolderSession* self,
                                                   GearyRFC822Message* message,
                                                   GearyEmailFlags* flags,
                                                   GDateTime* date_received,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN GearyEmailIdentifier* geary_imap_folder_session_create_email_finish (GearyImapFolderSession* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error);
static void geary_imap_engine_create_email_replay_remote_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static void geary_imap_engine_create_email_check_cancelled (GearyImapEngineCreateEmail* self,
                                                     GearyImapFolderSession* remote,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void geary_imap_engine_create_email_check_cancelled_finish (GearyImapEngineCreateEmail* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
VALA_EXTERN GType geary_imap_db_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapDBFolder* geary_imap_engine_minimal_folder_get_local_folder (GearyImapEngineMinimalFolder* self);
VALA_EXTERN GType geary_contact_harvester_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_db_folder_create_or_merge_email_async (GearyImapDBFolder* self,
                                                       GeeCollection* emails,
                                                       gboolean update_totals,
                                                       GearyContactHarvester* harvester,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN GeeMap* geary_imap_db_folder_create_or_merge_email_finish (GearyImapDBFolder* self,
                                                           GAsyncResult* _res_,
                                                           GError** error);
VALA_EXTERN GearyContactHarvester* geary_imap_engine_minimal_folder_get_harvester (GearyImapEngineMinimalFolder* self);
static gchar* geary_imap_engine_create_email_real_describe_state (GearyImapEngineReplayOperation* base);
static void geary_imap_engine_create_email_check_cancelled_data_free (gpointer _data);
static gboolean geary_imap_engine_create_email_check_cancelled_co (GearyImapEngineCreateEmailCheckCancelledData* _data_);
VALA_EXTERN void geary_imap_folder_session_remove_email_async (GearyImapFolderSession* self,
                                                   GeeList* msg_sets,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void geary_imap_folder_session_remove_email_finish (GearyImapFolderSession* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
VALA_EXTERN GearyImapUID* geary_imap_db_email_identifier_get_uid (GearyImapDBEmailIdentifier* self);
static void geary_imap_engine_create_email_check_cancelled_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void geary_imap_engine_create_email_finalize (GObject * obj);
static GType geary_imap_engine_create_email_get_type_once (void);
static void _vala_geary_imap_engine_create_email_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_geary_imap_engine_create_email_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

static inline gpointer
geary_imap_engine_create_email_get_instance_private (GearyImapEngineCreateEmail* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEngineCreateEmail_private_offset);
}

GearyEmailIdentifier*
geary_imap_engine_create_email_get_created_id (GearyImapEngineCreateEmail* self)
{
	GearyEmailIdentifier* result;
	GearyEmailIdentifier* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_CREATE_EMAIL (self), NULL);
	_tmp0_ = self->priv->_created_id;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_engine_create_email_set_created_id (GearyImapEngineCreateEmail* self,
                                               GearyEmailIdentifier* value)
{
	GearyEmailIdentifier* old_value;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_CREATE_EMAIL (self));
	old_value = geary_imap_engine_create_email_get_created_id (self);
	if (old_value != value) {
		GearyEmailIdentifier* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_created_id);
		self->priv->_created_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_engine_create_email_properties[GEARY_IMAP_ENGINE_CREATE_EMAIL_CREATED_ID_PROPERTY]);
	}
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

GearyImapEngineCreateEmail*
geary_imap_engine_create_email_construct (GType object_type,
                                          GearyImapEngineMinimalFolder* engine,
                                          GearyRFC822Message* rfc822,
                                          GearyEmailFlags* flags,
                                          GDateTime* date_received,
                                          GCancellable* cancellable)
{
	GearyImapEngineCreateEmail * self = NULL;
	GearyImapEngineMinimalFolder* _tmp0_;
	GearyRFC822Message* _tmp1_;
	GearyEmailFlags* _tmp2_;
	GDateTime* _tmp3_;
	GCancellable* _tmp4_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER (engine), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (rfc822), NULL);
	g_return_val_if_fail ((flags == NULL) || GEARY_IS_EMAIL_FLAGS (flags), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (GearyImapEngineCreateEmail*) geary_imap_engine_send_replay_operation_construct_only_remote (object_type, "CreateEmail", GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY);
	_tmp0_ = _g_object_ref0 (engine);
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp0_;
	_tmp1_ = _g_object_ref0 (rfc822);
	_g_object_unref0 (self->priv->rfc822);
	self->priv->rfc822 = _tmp1_;
	_tmp2_ = _g_object_ref0 (flags);
	_g_object_unref0 (self->priv->flags);
	self->priv->flags = _tmp2_;
	_tmp3_ = _g_date_time_ref0 (date_received);
	_g_date_time_unref0 (self->priv->date_received);
	self->priv->date_received = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp4_;
	return self;
}

GearyImapEngineCreateEmail*
geary_imap_engine_create_email_new (GearyImapEngineMinimalFolder* engine,
                                    GearyRFC822Message* rfc822,
                                    GearyEmailFlags* flags,
                                    GDateTime* date_received,
                                    GCancellable* cancellable)
{
	return geary_imap_engine_create_email_construct (GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL, engine, rfc822, flags, date_received, cancellable);
}

static void
geary_imap_engine_create_email_real_replay_remote_async_data_free (gpointer _data)
{
	GearyImapEngineCreateEmailReplayRemoteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineCreateEmailReplayRemoteAsyncData, _data_);
}

static void
geary_imap_engine_create_email_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                         GearyImapFolderSession* remote,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GearyImapEngineCreateEmail * self;
	GearyImapEngineCreateEmailReplayRemoteAsyncData* _data_;
	GearyImapEngineCreateEmail* _tmp0_;
	GearyImapFolderSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_SESSION (remote));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL, GearyImapEngineCreateEmail);
	_data_ = g_slice_new0 (GearyImapEngineCreateEmailReplayRemoteAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_create_email_real_replay_remote_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp1_;
	geary_imap_engine_create_email_real_replay_remote_async_co (_data_);
}

static void
geary_imap_engine_create_email_replay_remote_finish (GearyImapEngineReplayOperation* base,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	GearyImapEngineCreateEmailReplayRemoteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_create_email_replay_remote_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	GearyImapEngineCreateEmailReplayRemoteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_create_email_real_replay_remote_async_co (_data_);
}

static gboolean
geary_imap_engine_create_email_real_replay_remote_async_co (GearyImapEngineCreateEmailReplayRemoteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cancellable;
	if (g_cancellable_is_cancelled (_data_->_tmp0_)) {
		_data_->_tmp1_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "CreateEmail op cancelled immediately");
		_data_->_inner_error0_ = _data_->_tmp1_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->rfc822;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp4_ = _data_->self->priv->rfc822;
		_data_->_tmp5_ = _data_->self->priv->flags;
		_data_->_tmp6_ = _data_->self->priv->date_received;
		_data_->_state_ = 1;
		geary_imap_folder_session_create_email_async (_data_->remote, _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, geary_imap_engine_create_email_replay_remote_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = geary_imap_folder_session_create_email_finish (_data_->remote, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		geary_imap_engine_create_email_set_created_id (_data_->self, _data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp3_);
	}
	_g_object_unref0 (_data_->self->priv->rfc822);
	_data_->self->priv->rfc822 = NULL;
	_data_->_state_ = 2;
	geary_imap_engine_create_email_check_cancelled (_data_->self, _data_->remote, geary_imap_engine_create_email_replay_remote_async_ready, _data_);
	return FALSE;
	_state_2:
	geary_imap_engine_create_email_check_cancelled_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->self->priv->_created_id;
	if (_data_->_tmp8_ != NULL) {
		_data_->_tmp9_ = _data_->self->priv->_created_id;
		_data_->_tmp10_ = geary_email_new (_data_->_tmp9_);
		_data_->created = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->self->priv->engine;
		_data_->_tmp12_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->created;
		_data_->_tmp15_ = geary_iterate (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp14_, NULL);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = geary_iterable_to_array_list (_data_->_tmp16_, NULL, NULL, NULL);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = _data_->self->priv->engine;
		_data_->_tmp20_ = geary_imap_engine_minimal_folder_get_harvester (_data_->_tmp19_);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = _data_->self->priv->cancellable;
		_data_->_state_ = 3;
		geary_imap_db_folder_create_or_merge_email_async (_data_->_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, GEE_TYPE_COLLECTION, GeeCollection), TRUE, _data_->_tmp21_, _data_->_tmp22_, geary_imap_engine_create_email_replay_remote_async_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp23_ = geary_imap_db_folder_create_or_merge_email_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp24_ = _data_->_tmp23_;
		_g_object_unref0 (_data_->_tmp18_);
		_g_object_unref0 (_data_->_tmp16_);
		_data_->results = _data_->_tmp24_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->created);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp25_ = _data_->results;
		_data_->_tmp26_ = gee_map_get_size (_data_->_tmp25_);
		_data_->_tmp27_ = _data_->_tmp26_;
		if (_data_->_tmp27_ > 0) {
			_data_->_tmp28_ = _data_->results;
			_data_->_tmp29_ = gee_map_get_keys (_data_->_tmp28_);
			_data_->_tmp30_ = _data_->_tmp29_;
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp32_ = geary_collection_first (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, GEE_TYPE_COLLECTION, GeeCollection));
			_data_->_tmp33_ = (GearyEmail*) _data_->_tmp32_;
			_data_->_tmp34_ = geary_email_get_id (_data_->_tmp33_);
			_data_->_tmp35_ = _data_->_tmp34_;
			geary_imap_engine_create_email_set_created_id (_data_->self, _data_->_tmp35_);
			_g_object_unref0 (_data_->_tmp33_);
			_g_object_unref0 (_data_->_tmp31_);
		} else {
			geary_imap_engine_create_email_set_created_id (_data_->self, NULL);
		}
		_g_object_unref0 (_data_->results);
		_g_object_unref0 (_data_->created);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
geary_imap_engine_create_email_real_describe_state (GearyImapEngineReplayOperation* base)
{
	GearyImapEngineCreateEmail * self;
	gchar* _tmp0_ = NULL;
	GearyEmailIdentifier* _tmp1_;
	gchar* _tmp5_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL, GearyImapEngineCreateEmail);
	_tmp1_ = self->priv->_created_id;
	if (_tmp1_ != NULL) {
		GearyEmailIdentifier* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_created_id;
		_tmp3_ = geary_email_identifier_to_string (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("none");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = g_strdup_printf ("created_id: %s", _tmp0_);
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}

static void
geary_imap_engine_create_email_check_cancelled_data_free (gpointer _data)
{
	GearyImapEngineCreateEmailCheckCancelledData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineCreateEmailCheckCancelledData, _data_);
}

static void
geary_imap_engine_create_email_check_cancelled (GearyImapEngineCreateEmail* self,
                                                GearyImapFolderSession* remote,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GearyImapEngineCreateEmailCheckCancelledData* _data_;
	GearyImapEngineCreateEmail* _tmp0_;
	GearyImapFolderSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_CREATE_EMAIL (self));
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_SESSION (remote));
	_data_ = g_slice_new0 (GearyImapEngineCreateEmailCheckCancelledData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_create_email_check_cancelled_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp1_;
	geary_imap_engine_create_email_check_cancelled_co (_data_);
}

static void
geary_imap_engine_create_email_check_cancelled_finish (GearyImapEngineCreateEmail* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	GearyImapEngineCreateEmailCheckCancelledData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_create_email_check_cancelled_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	GearyImapEngineCreateEmailCheckCancelledData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_create_email_check_cancelled_co (_data_);
}

static gboolean
geary_imap_engine_create_email_check_cancelled_co (GearyImapEngineCreateEmailCheckCancelledData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cancellable;
	if (g_cancellable_is_cancelled (_data_->_tmp0_)) {
		_data_->_tmp1_ = _data_->self->priv->_created_id;
		if (_data_->_tmp1_ != NULL) {
			_data_->_tmp2_ = _data_->self->priv->_created_id;
			_data_->_tmp3_ = geary_imap_db_email_identifier_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier));
			_data_->_tmp4_ = _data_->_tmp3_;
			_data_->_tmp5_ = geary_imap_message_set_new_uid (_data_->_tmp4_);
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_tmp7_ = geary_imap_message_set_to_list (_data_->_tmp6_);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_state_ = 1;
			geary_imap_folder_session_remove_email_async (_data_->remote, _data_->_tmp8_, NULL, geary_imap_engine_create_email_check_cancelled_ready, _data_);
			return FALSE;
			_state_1:
			geary_imap_folder_session_remove_email_finish (_data_->remote, _data_->_res_, &_data_->_inner_error0_);
			_g_object_unref0 (_data_->_tmp8_);
			_g_object_unref0 (_data_->_tmp6_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp9_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "CreateEmail op cancelled after create");
		_data_->_inner_error0_ = _data_->_tmp9_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_create_email_class_init (GearyImapEngineCreateEmailClass * klass,
                                           gpointer klass_data)
{
	geary_imap_engine_create_email_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEngineCreateEmail_private_offset);
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_async = (void (*) (GearyImapEngineReplayOperation*, GearyImapFolderSession*, GAsyncReadyCallback, gpointer)) geary_imap_engine_create_email_real_replay_remote_async;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_finish = (void (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_create_email_replay_remote_finish;
	((GearyImapEngineReplayOperationClass *) klass)->describe_state = (gchar* (*) (GearyImapEngineReplayOperation*)) geary_imap_engine_create_email_real_describe_state;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_engine_create_email_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_engine_create_email_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_engine_create_email_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_ENGINE_CREATE_EMAIL_CREATED_ID_PROPERTY, geary_imap_engine_create_email_properties[GEARY_IMAP_ENGINE_CREATE_EMAIL_CREATED_ID_PROPERTY] = g_param_spec_object ("created-id", "created-id", "created-id", GEARY_TYPE_EMAIL_IDENTIFIER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_engine_create_email_instance_init (GearyImapEngineCreateEmail * self,
                                              gpointer klass)
{
	self->priv = geary_imap_engine_create_email_get_instance_private (self);
	self->priv->_created_id = NULL;
}

static void
geary_imap_engine_create_email_finalize (GObject * obj)
{
	GearyImapEngineCreateEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL, GearyImapEngineCreateEmail);
	_g_object_unref0 (self->priv->_created_id);
	_g_object_unref0 (self->priv->engine);
	_g_object_unref0 (self->priv->rfc822);
	_g_object_unref0 (self->priv->flags);
	_g_date_time_unref0 (self->priv->date_received);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (geary_imap_engine_create_email_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_imap_engine_create_email_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineCreateEmailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_create_email_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineCreateEmail), 0, (GInstanceInitFunc) geary_imap_engine_create_email_instance_init, NULL };
	GType geary_imap_engine_create_email_type_id;
	geary_imap_engine_create_email_type_id = g_type_register_static (GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, "GearyImapEngineCreateEmail", &g_define_type_info, 0);
	GearyImapEngineCreateEmail_private_offset = g_type_add_instance_private (geary_imap_engine_create_email_type_id, sizeof (GearyImapEngineCreateEmailPrivate));
	return geary_imap_engine_create_email_type_id;
}

GType
geary_imap_engine_create_email_get_type (void)
{
	static gsize geary_imap_engine_create_email_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_create_email_type_id__once)) {
		GType geary_imap_engine_create_email_type_id;
		geary_imap_engine_create_email_type_id = geary_imap_engine_create_email_get_type_once ();
		g_once_init_leave (&geary_imap_engine_create_email_type_id__once, geary_imap_engine_create_email_type_id);
	}
	return geary_imap_engine_create_email_type_id__once;
}

static void
_vala_geary_imap_engine_create_email_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GearyImapEngineCreateEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL, GearyImapEngineCreateEmail);
	switch (property_id) {
		case GEARY_IMAP_ENGINE_CREATE_EMAIL_CREATED_ID_PROPERTY:
		g_value_set_object (value, geary_imap_engine_create_email_get_created_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_engine_create_email_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GearyImapEngineCreateEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_ENGINE_TYPE_CREATE_EMAIL, GearyImapEngineCreateEmail);
	switch (property_id) {
		case GEARY_IMAP_ENGINE_CREATE_EMAIL_CREATED_ID_PROPERTY:
		geary_imap_engine_create_email_set_created_id (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

