/* imap-unquoted-string-parameter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-unquoted-string-parameter.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_UNQUOTED_STRING_PARAMETER_0_PROPERTY,
	GEARY_IMAP_UNQUOTED_STRING_PARAMETER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_unquoted_string_parameter_properties[GEARY_IMAP_UNQUOTED_STRING_PARAMETER_NUM_PROPERTIES];

static gpointer geary_imap_unquoted_string_parameter_parent_class = NULL;

static void geary_imap_unquoted_string_parameter_real_serialize (GearyImapParameter* base,
                                                          GearyImapSerializer* ser,
                                                          GCancellable* cancellable,
                                                          GError** error);
static gchar* geary_imap_unquoted_string_parameter_real_to_string (GearyImapParameter* base);
static GType geary_imap_unquoted_string_parameter_get_type_once (void);

GearyImapUnquotedStringParameter*
geary_imap_unquoted_string_parameter_construct (GType object_type,
                                                const gchar* ascii)
{
	GearyImapUnquotedStringParameter * self = NULL;
	g_return_val_if_fail (ascii != NULL, NULL);
	self = (GearyImapUnquotedStringParameter*) geary_imap_string_parameter_construct (object_type, ascii);
	return self;
}

GearyImapUnquotedStringParameter*
geary_imap_unquoted_string_parameter_new (const gchar* ascii)
{
	return geary_imap_unquoted_string_parameter_construct (GEARY_IMAP_TYPE_UNQUOTED_STRING_PARAMETER, ascii);
}

/**
     * {@inheritDoc}
     */
static void
geary_imap_unquoted_string_parameter_real_serialize (GearyImapParameter* base,
                                                     GearyImapSerializer* ser,
                                                     GCancellable* cancellable,
                                                     GError** error)
{
	GearyImapUnquotedStringParameter * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_UNQUOTED_STRING_PARAMETER, GearyImapUnquotedStringParameter);
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = geary_imap_string_parameter_get_ascii (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter));
	_tmp1_ = _tmp0_;
	geary_imap_serializer_push_unquoted_string (ser, _tmp1_, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/**
     * {@inheritDoc}
     */
static gchar*
geary_imap_unquoted_string_parameter_real_to_string (GearyImapParameter* base)
{
	GearyImapUnquotedStringParameter * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_UNQUOTED_STRING_PARAMETER, GearyImapUnquotedStringParameter);
	_tmp0_ = geary_imap_string_parameter_get_ascii (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
geary_imap_unquoted_string_parameter_class_init (GearyImapUnquotedStringParameterClass * klass,
                                                 gpointer klass_data)
{
	geary_imap_unquoted_string_parameter_parent_class = g_type_class_peek_parent (klass);
	((GearyImapParameterClass *) klass)->serialize = (void (*) (GearyImapParameter*, GearyImapSerializer*, GCancellable*, GError**)) geary_imap_unquoted_string_parameter_real_serialize;
	((GearyImapParameterClass *) klass)->to_string = (gchar* (*) (GearyImapParameter*)) geary_imap_unquoted_string_parameter_real_to_string;
}

static void
geary_imap_unquoted_string_parameter_instance_init (GearyImapUnquotedStringParameter * self,
                                                    gpointer klass)
{
}

/**
 * A representation of an IMAP string that is not quoted.
 *
 * This class does not check if quoting is required.  Use {@link DataFormat.is_quoting_required}
 * or {@link StringParameter.get_best_for}.
 *
 * The difference between this class and {@link AtomParameter} is that this can be used in any
 * circumstance where a string can (or is) represented without quotes or literal data, whereas an
 * atom has strict definitions about where it's found.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-4.1]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_unquoted_string_parameter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapUnquotedStringParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_unquoted_string_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapUnquotedStringParameter), 0, (GInstanceInitFunc) geary_imap_unquoted_string_parameter_instance_init, NULL };
	GType geary_imap_unquoted_string_parameter_type_id;
	geary_imap_unquoted_string_parameter_type_id = g_type_register_static (GEARY_IMAP_TYPE_STRING_PARAMETER, "GearyImapUnquotedStringParameter", &g_define_type_info, 0);
	return geary_imap_unquoted_string_parameter_type_id;
}

GType
geary_imap_unquoted_string_parameter_get_type (void)
{
	static gsize geary_imap_unquoted_string_parameter_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_unquoted_string_parameter_type_id__once)) {
		GType geary_imap_unquoted_string_parameter_type_id;
		geary_imap_unquoted_string_parameter_type_id = geary_imap_unquoted_string_parameter_get_type_once ();
		g_once_init_leave (&geary_imap_unquoted_string_parameter_type_id__once, geary_imap_unquoted_string_parameter_type_id);
	}
	return geary_imap_unquoted_string_parameter_type_id__once;
}

