// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module VkSubDecoder
//
// (impl) generated by codegen/vulkan/vulkan-docs/scripts/genvk.py -registry
// codegen/vulkan/vulkan-docs/xml/vk.xml -registryGfxstream
// codegen/vulkan/vulkan-docs/xml/vk_gfxstream.xml cereal -o host/vulkan/cereal
//
// Please do not modify directly;
// re-run gfxstream-protocols/scripts/generate-vulkan-sources.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o
// $CEREAL_OUTPUT_DIR
//
#define MAX_STACK_ITEMS 16
#define MAX_PACKET_LENGTH (400 * 1024 * 1024)  // 400MB
size_t subDecode(VulkanMemReadingStream* readStream, VulkanDispatch* vk, void* boxed_dispatchHandle,
                 void* dispatchHandle, VkDeviceSize dataSize, const void* pData,
                 const VkDecoderContext& context) {
    auto& metricsLogger = *context.metricsLogger;
    uint32_t count = 0;
    unsigned char* buf = (unsigned char*)pData;
    android::base::BumpPool* pool = readStream->pool();
    unsigned char* ptr = (unsigned char*)pData;
    const unsigned char* const end = (const unsigned char*)buf + dataSize;
    VkDecoderGlobalState* globalstate = VkDecoderGlobalState::get();
    while (end - ptr >= 8) {
        uint32_t opcode = *(uint32_t*)ptr;
        uint32_t packetLen = *(uint32_t*)(ptr + 4);

        // packetLen should be at least 8 (op code and packet length) and should not be excessively
        // large
        if (packetLen < 8 || packetLen > MAX_PACKET_LENGTH) {
            WARN("Bad packet length %d detected, subdecode may fail", packetLen);
            metricsLogger.logMetricEvent(MetricEventBadPacketLength{.len = packetLen});
        }

        if (end - ptr < packetLen) return ptr - (unsigned char*)buf;
        readStream->setBuf((uint8_t*)(ptr + 8));
        uint8_t* readStreamPtr = readStream->getBuf();
        uint8_t** readStreamPtrPtr = &readStreamPtr;
        switch (opcode) {
#ifdef VK_VERSION_1_0
            case OP_vkBeginCommandBuffer: {
                android::base::beginTrace("vkBeginCommandBuffer subdecode");
                const VkCommandBufferBeginInfo* pBeginInfo;
                VkCommandBufferBeginInfo stack_pBeginInfo[1];
                pBeginInfo = (VkCommandBufferBeginInfo*)stack_pBeginInfo;
                reservedunmarshal_VkCommandBufferBeginInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                           (VkCommandBufferBeginInfo*)(pBeginInfo),
                                                           readStreamPtrPtr);
                if (pBeginInfo) {
                    transform_tohost_VkCommandBufferBeginInfo(
                        globalstate, (VkCommandBufferBeginInfo*)(pBeginInfo));
                }
                VkResult vkBeginCommandBuffer_VkResult_return = (VkResult)0;
                vkBeginCommandBuffer_VkResult_return = this->on_vkBeginCommandBuffer(
                    pool, (VkCommandBuffer)(boxed_dispatchHandle), pBeginInfo, context);
                if ((vkBeginCommandBuffer_VkResult_return) == VK_ERROR_DEVICE_LOST)
                    this->on_DeviceLost();
                this->on_CheckOutOfMemory(vkBeginCommandBuffer_VkResult_return, opcode, context);
                android::base::endTrace();
                break;
            }
            case OP_vkEndCommandBuffer: {
                android::base::beginTrace("vkEndCommandBuffer subdecode");
                VkResult vkEndCommandBuffer_VkResult_return = (VkResult)0;
                vkEndCommandBuffer_VkResult_return = this->on_vkEndCommandBuffer(
                    pool, (VkCommandBuffer)(boxed_dispatchHandle), context);
                if ((vkEndCommandBuffer_VkResult_return) == VK_ERROR_DEVICE_LOST)
                    this->on_DeviceLost();
                this->on_CheckOutOfMemory(vkEndCommandBuffer_VkResult_return, opcode, context);
                android::base::endTrace();
                break;
            }
            case OP_vkResetCommandBuffer: {
                android::base::beginTrace("vkResetCommandBuffer subdecode");
                VkCommandBufferResetFlags flags;
                memcpy((VkCommandBufferResetFlags*)&flags, *readStreamPtrPtr,
                       sizeof(VkCommandBufferResetFlags));
                *readStreamPtrPtr += sizeof(VkCommandBufferResetFlags);
                VkResult vkResetCommandBuffer_VkResult_return = (VkResult)0;
                vkResetCommandBuffer_VkResult_return = this->on_vkResetCommandBuffer(
                    pool, (VkCommandBuffer)(boxed_dispatchHandle), flags);
                if ((vkResetCommandBuffer_VkResult_return) == VK_ERROR_DEVICE_LOST)
                    this->on_DeviceLost();
                this->on_CheckOutOfMemory(vkResetCommandBuffer_VkResult_return, opcode, context);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBindPipeline: {
                android::base::beginTrace("vkCmdBindPipeline subdecode");
                VkPipelineBindPoint pipelineBindPoint;
                VkPipeline pipeline;
                memcpy((VkPipelineBindPoint*)&pipelineBindPoint, *readStreamPtrPtr,
                       sizeof(VkPipelineBindPoint));
                *readStreamPtrPtr += sizeof(VkPipelineBindPoint);
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkPipeline*)&pipeline = (VkPipeline)unbox_VkPipeline((VkPipeline)(*&cgen_var_0));
                this->on_vkCmdBindPipeline(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                           pipelineBindPoint, pipeline);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetViewport: {
                android::base::beginTrace("vkCmdSetViewport subdecode");
                uint32_t firstViewport;
                uint32_t viewportCount;
                const VkViewport* pViewports;
                VkViewport stack_pViewports[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&firstViewport, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&viewportCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((viewportCount)) <= MAX_STACK_ITEMS) {
                    pViewports = (VkViewport*)stack_pViewports;
                } else {
                    readStream->alloc((void**)&pViewports,
                                      ((viewportCount)) * sizeof(const VkViewport));
                }
                for (uint32_t i = 0; i < (uint32_t)((viewportCount)); ++i) {
                    reservedunmarshal_VkViewport(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                 (VkViewport*)(pViewports + i), readStreamPtrPtr);
                }
                if (pViewports) {
                    for (uint32_t i = 0; i < (uint32_t)((viewportCount)); ++i) {
                        transform_tohost_VkViewport(globalstate, (VkViewport*)(pViewports + i));
                    }
                }
                vk->vkCmdSetViewport((VkCommandBuffer)dispatchHandle, firstViewport, viewportCount,
                                     pViewports);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetScissor: {
                android::base::beginTrace("vkCmdSetScissor subdecode");
                uint32_t firstScissor;
                uint32_t scissorCount;
                const VkRect2D* pScissors;
                VkRect2D stack_pScissors[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&firstScissor, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&scissorCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((scissorCount)) <= MAX_STACK_ITEMS) {
                    pScissors = (VkRect2D*)stack_pScissors;
                } else {
                    readStream->alloc((void**)&pScissors,
                                      ((scissorCount)) * sizeof(const VkRect2D));
                }
                for (uint32_t i = 0; i < (uint32_t)((scissorCount)); ++i) {
                    reservedunmarshal_VkRect2D(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                               (VkRect2D*)(pScissors + i), readStreamPtrPtr);
                }
                if (pScissors) {
                    for (uint32_t i = 0; i < (uint32_t)((scissorCount)); ++i) {
                        transform_tohost_VkRect2D(globalstate, (VkRect2D*)(pScissors + i));
                    }
                }
                vk->vkCmdSetScissor((VkCommandBuffer)dispatchHandle, firstScissor, scissorCount,
                                    pScissors);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetLineWidth: {
                android::base::beginTrace("vkCmdSetLineWidth subdecode");
                float lineWidth;
                memcpy((float*)&lineWidth, *readStreamPtrPtr, sizeof(float));
                *readStreamPtrPtr += sizeof(float);
                vk->vkCmdSetLineWidth((VkCommandBuffer)dispatchHandle, lineWidth);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthBias: {
                android::base::beginTrace("vkCmdSetDepthBias subdecode");
                float depthBiasConstantFactor;
                float depthBiasClamp;
                float depthBiasSlopeFactor;
                memcpy((float*)&depthBiasConstantFactor, *readStreamPtrPtr, sizeof(float));
                *readStreamPtrPtr += sizeof(float);
                memcpy((float*)&depthBiasClamp, *readStreamPtrPtr, sizeof(float));
                *readStreamPtrPtr += sizeof(float);
                memcpy((float*)&depthBiasSlopeFactor, *readStreamPtrPtr, sizeof(float));
                *readStreamPtrPtr += sizeof(float);
                vk->vkCmdSetDepthBias((VkCommandBuffer)dispatchHandle, depthBiasConstantFactor,
                                      depthBiasClamp, depthBiasSlopeFactor);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetBlendConstants: {
                android::base::beginTrace("vkCmdSetBlendConstants subdecode");
                float blendConstants[4];
                memcpy((float*)blendConstants, *readStreamPtrPtr, 4 * sizeof(const float));
                *readStreamPtrPtr += 4 * sizeof(const float);
                vk->vkCmdSetBlendConstants((VkCommandBuffer)dispatchHandle, blendConstants);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthBounds: {
                android::base::beginTrace("vkCmdSetDepthBounds subdecode");
                float minDepthBounds;
                float maxDepthBounds;
                memcpy((float*)&minDepthBounds, *readStreamPtrPtr, sizeof(float));
                *readStreamPtrPtr += sizeof(float);
                memcpy((float*)&maxDepthBounds, *readStreamPtrPtr, sizeof(float));
                *readStreamPtrPtr += sizeof(float);
                vk->vkCmdSetDepthBounds((VkCommandBuffer)dispatchHandle, minDepthBounds,
                                        maxDepthBounds);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetStencilCompareMask: {
                android::base::beginTrace("vkCmdSetStencilCompareMask subdecode");
                VkStencilFaceFlags faceMask;
                uint32_t compareMask;
                memcpy((VkStencilFaceFlags*)&faceMask, *readStreamPtrPtr,
                       sizeof(VkStencilFaceFlags));
                *readStreamPtrPtr += sizeof(VkStencilFaceFlags);
                memcpy((uint32_t*)&compareMask, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdSetStencilCompareMask((VkCommandBuffer)dispatchHandle, faceMask,
                                               compareMask);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetStencilWriteMask: {
                android::base::beginTrace("vkCmdSetStencilWriteMask subdecode");
                VkStencilFaceFlags faceMask;
                uint32_t writeMask;
                memcpy((VkStencilFaceFlags*)&faceMask, *readStreamPtrPtr,
                       sizeof(VkStencilFaceFlags));
                *readStreamPtrPtr += sizeof(VkStencilFaceFlags);
                memcpy((uint32_t*)&writeMask, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdSetStencilWriteMask((VkCommandBuffer)dispatchHandle, faceMask, writeMask);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetStencilReference: {
                android::base::beginTrace("vkCmdSetStencilReference subdecode");
                VkStencilFaceFlags faceMask;
                uint32_t reference;
                memcpy((VkStencilFaceFlags*)&faceMask, *readStreamPtrPtr,
                       sizeof(VkStencilFaceFlags));
                *readStreamPtrPtr += sizeof(VkStencilFaceFlags);
                memcpy((uint32_t*)&reference, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdSetStencilReference((VkCommandBuffer)dispatchHandle, faceMask, reference);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBindDescriptorSets: {
                android::base::beginTrace("vkCmdBindDescriptorSets subdecode");
                VkPipelineBindPoint pipelineBindPoint;
                VkPipelineLayout layout;
                uint32_t firstSet;
                uint32_t descriptorSetCount;
                const VkDescriptorSet* pDescriptorSets;
                VkDescriptorSet stack_pDescriptorSets[MAX_STACK_ITEMS];
                uint32_t dynamicOffsetCount;
                const uint32_t* pDynamicOffsets;
                uint32_t stack_pDynamicOffsets[MAX_STACK_ITEMS];
                memcpy((VkPipelineBindPoint*)&pipelineBindPoint, *readStreamPtrPtr,
                       sizeof(VkPipelineBindPoint));
                *readStreamPtrPtr += sizeof(VkPipelineBindPoint);
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkPipelineLayout*)&layout =
                    (VkPipelineLayout)unbox_VkPipelineLayout((VkPipelineLayout)(*&cgen_var_0));
                memcpy((uint32_t*)&firstSet, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&descriptorSetCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((descriptorSetCount)) <= MAX_STACK_ITEMS) {
                    pDescriptorSets = (VkDescriptorSet*)stack_pDescriptorSets;
                } else {
                    readStream->alloc((void**)&pDescriptorSets,
                                      ((descriptorSetCount)) * sizeof(const VkDescriptorSet));
                }
                if (((descriptorSetCount))) {
                    uint8_t* cgen_var_1_ptr = (uint8_t*)(*readStreamPtrPtr);
                    *readStreamPtrPtr += 8 * ((descriptorSetCount));
                    for (uint32_t k = 0; k < ((descriptorSetCount)); ++k) {
                        uint64_t tmpval;
                        memcpy(&tmpval, cgen_var_1_ptr + k * 8, sizeof(uint64_t));
                        *(((VkDescriptorSet*)pDescriptorSets) + k) =
                            (VkDescriptorSet)unbox_VkDescriptorSet((VkDescriptorSet)tmpval);
                    }
                }
                memcpy((uint32_t*)&dynamicOffsetCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((dynamicOffsetCount)) <= MAX_STACK_ITEMS) {
                    pDynamicOffsets = (uint32_t*)stack_pDynamicOffsets;
                } else {
                    readStream->alloc((void**)&pDynamicOffsets,
                                      ((dynamicOffsetCount)) * sizeof(const uint32_t));
                }
                memcpy((uint32_t*)pDynamicOffsets, *readStreamPtrPtr,
                       ((dynamicOffsetCount)) * sizeof(const uint32_t));
                *readStreamPtrPtr += ((dynamicOffsetCount)) * sizeof(const uint32_t);
                this->on_vkCmdBindDescriptorSets(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                                 pipelineBindPoint, layout, firstSet,
                                                 descriptorSetCount, pDescriptorSets,
                                                 dynamicOffsetCount, pDynamicOffsets);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBindIndexBuffer: {
                android::base::beginTrace("vkCmdBindIndexBuffer subdecode");
                VkBuffer buffer;
                VkDeviceSize offset;
                VkIndexType indexType;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                memcpy((VkDeviceSize*)&offset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((VkIndexType*)&indexType, *readStreamPtrPtr, sizeof(VkIndexType));
                *readStreamPtrPtr += sizeof(VkIndexType);
                vk->vkCmdBindIndexBuffer((VkCommandBuffer)dispatchHandle, buffer, offset,
                                         indexType);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBindVertexBuffers: {
                android::base::beginTrace("vkCmdBindVertexBuffers subdecode");
                uint32_t firstBinding;
                uint32_t bindingCount;
                const VkBuffer* pBuffers;
                VkBuffer stack_pBuffers[MAX_STACK_ITEMS];
                const VkDeviceSize* pOffsets;
                VkDeviceSize stack_pOffsets[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&firstBinding, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&bindingCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((bindingCount)) <= MAX_STACK_ITEMS) {
                    pBuffers = (VkBuffer*)stack_pBuffers;
                } else {
                    readStream->alloc((void**)&pBuffers, ((bindingCount)) * sizeof(const VkBuffer));
                }
                if (((bindingCount))) {
                    uint8_t* cgen_var_0_ptr = (uint8_t*)(*readStreamPtrPtr);
                    *readStreamPtrPtr += 8 * ((bindingCount));
                    for (uint32_t k = 0; k < ((bindingCount)); ++k) {
                        uint64_t tmpval;
                        memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                        *(((VkBuffer*)pBuffers) + k) = (VkBuffer)unbox_VkBuffer((VkBuffer)tmpval);
                    }
                }
                if (((bindingCount)) <= MAX_STACK_ITEMS) {
                    pOffsets = (VkDeviceSize*)stack_pOffsets;
                } else {
                    readStream->alloc((void**)&pOffsets,
                                      ((bindingCount)) * sizeof(const VkDeviceSize));
                }
                memcpy((VkDeviceSize*)pOffsets, *readStreamPtrPtr,
                       ((bindingCount)) * sizeof(const VkDeviceSize));
                *readStreamPtrPtr += ((bindingCount)) * sizeof(const VkDeviceSize);
                vk->vkCmdBindVertexBuffers((VkCommandBuffer)dispatchHandle, firstBinding,
                                           bindingCount, pBuffers, pOffsets);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdDraw: {
                android::base::beginTrace("vkCmdDraw subdecode");
                uint32_t vertexCount;
                uint32_t instanceCount;
                uint32_t firstVertex;
                uint32_t firstInstance;
                memcpy((uint32_t*)&vertexCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&instanceCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&firstVertex, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&firstInstance, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdDraw((VkCommandBuffer)dispatchHandle, vertexCount, instanceCount,
                              firstVertex, firstInstance);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdDrawIndexed: {
                android::base::beginTrace("vkCmdDrawIndexed subdecode");
                uint32_t indexCount;
                uint32_t instanceCount;
                uint32_t firstIndex;
                int32_t vertexOffset;
                uint32_t firstInstance;
                memcpy((uint32_t*)&indexCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&instanceCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&firstIndex, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((int32_t*)&vertexOffset, *readStreamPtrPtr, sizeof(int32_t));
                *readStreamPtrPtr += sizeof(int32_t);
                memcpy((uint32_t*)&firstInstance, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdDrawIndexed((VkCommandBuffer)dispatchHandle, indexCount, instanceCount,
                                     firstIndex, vertexOffset, firstInstance);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdDrawIndirect: {
                android::base::beginTrace("vkCmdDrawIndirect subdecode");
                VkBuffer buffer;
                VkDeviceSize offset;
                uint32_t drawCount;
                uint32_t stride;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                memcpy((VkDeviceSize*)&offset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((uint32_t*)&drawCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&stride, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdDrawIndirect((VkCommandBuffer)dispatchHandle, buffer, offset, drawCount,
                                      stride);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdDrawIndexedIndirect: {
                android::base::beginTrace("vkCmdDrawIndexedIndirect subdecode");
                VkBuffer buffer;
                VkDeviceSize offset;
                uint32_t drawCount;
                uint32_t stride;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                memcpy((VkDeviceSize*)&offset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((uint32_t*)&drawCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&stride, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdDrawIndexedIndirect((VkCommandBuffer)dispatchHandle, buffer, offset,
                                             drawCount, stride);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdDispatch: {
                android::base::beginTrace("vkCmdDispatch subdecode");
                uint32_t groupCountX;
                uint32_t groupCountY;
                uint32_t groupCountZ;
                memcpy((uint32_t*)&groupCountX, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&groupCountY, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&groupCountZ, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdDispatch((VkCommandBuffer)dispatchHandle, groupCountX, groupCountY,
                                  groupCountZ);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdDispatchIndirect: {
                android::base::beginTrace("vkCmdDispatchIndirect subdecode");
                VkBuffer buffer;
                VkDeviceSize offset;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                memcpy((VkDeviceSize*)&offset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                vk->vkCmdDispatchIndirect((VkCommandBuffer)dispatchHandle, buffer, offset);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyBuffer: {
                android::base::beginTrace("vkCmdCopyBuffer subdecode");
                VkBuffer srcBuffer;
                VkBuffer dstBuffer;
                uint32_t regionCount;
                const VkBufferCopy* pRegions;
                VkBufferCopy stack_pRegions[MAX_STACK_ITEMS];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&srcBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                uint64_t cgen_var_1;
                memcpy((uint64_t*)&cgen_var_1, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&dstBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_1));
                memcpy((uint32_t*)&regionCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((regionCount)) <= MAX_STACK_ITEMS) {
                    pRegions = (VkBufferCopy*)stack_pRegions;
                } else {
                    readStream->alloc((void**)&pRegions,
                                      ((regionCount)) * sizeof(const VkBufferCopy));
                }
                for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                    reservedunmarshal_VkBufferCopy(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkBufferCopy*)(pRegions + i), readStreamPtrPtr);
                }
                if (pRegions) {
                    for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                        transform_tohost_VkBufferCopy(globalstate, (VkBufferCopy*)(pRegions + i));
                    }
                }
                vk->vkCmdCopyBuffer((VkCommandBuffer)dispatchHandle, srcBuffer, dstBuffer,
                                    regionCount, pRegions);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyImage: {
                android::base::beginTrace("vkCmdCopyImage subdecode");
                VkImage srcImage;
                VkImageLayout srcImageLayout;
                VkImage dstImage;
                VkImageLayout dstImageLayout;
                uint32_t regionCount;
                const VkImageCopy* pRegions;
                VkImageCopy stack_pRegions[MAX_STACK_ITEMS];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkImage*)&srcImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
                memcpy((VkImageLayout*)&srcImageLayout, *readStreamPtrPtr, sizeof(VkImageLayout));
                *readStreamPtrPtr += sizeof(VkImageLayout);
                uint64_t cgen_var_1;
                memcpy((uint64_t*)&cgen_var_1, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkImage*)&dstImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_1));
                memcpy((VkImageLayout*)&dstImageLayout, *readStreamPtrPtr, sizeof(VkImageLayout));
                *readStreamPtrPtr += sizeof(VkImageLayout);
                memcpy((uint32_t*)&regionCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((regionCount)) <= MAX_STACK_ITEMS) {
                    pRegions = (VkImageCopy*)stack_pRegions;
                } else {
                    readStream->alloc((void**)&pRegions,
                                      ((regionCount)) * sizeof(const VkImageCopy));
                }
                for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                    reservedunmarshal_VkImageCopy(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                  (VkImageCopy*)(pRegions + i), readStreamPtrPtr);
                }
                if (pRegions) {
                    for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                        transform_tohost_VkImageCopy(globalstate, (VkImageCopy*)(pRegions + i));
                    }
                }
                this->on_vkCmdCopyImage(pool, (VkCommandBuffer)(boxed_dispatchHandle), srcImage,
                                        srcImageLayout, dstImage, dstImageLayout, regionCount,
                                        pRegions);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBlitImage: {
                android::base::beginTrace("vkCmdBlitImage subdecode");
                VkImage srcImage;
                VkImageLayout srcImageLayout;
                VkImage dstImage;
                VkImageLayout dstImageLayout;
                uint32_t regionCount;
                const VkImageBlit* pRegions;
                VkImageBlit stack_pRegions[MAX_STACK_ITEMS];
                VkFilter filter;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkImage*)&srcImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
                memcpy((VkImageLayout*)&srcImageLayout, *readStreamPtrPtr, sizeof(VkImageLayout));
                *readStreamPtrPtr += sizeof(VkImageLayout);
                uint64_t cgen_var_1;
                memcpy((uint64_t*)&cgen_var_1, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkImage*)&dstImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_1));
                memcpy((VkImageLayout*)&dstImageLayout, *readStreamPtrPtr, sizeof(VkImageLayout));
                *readStreamPtrPtr += sizeof(VkImageLayout);
                memcpy((uint32_t*)&regionCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((regionCount)) <= MAX_STACK_ITEMS) {
                    pRegions = (VkImageBlit*)stack_pRegions;
                } else {
                    readStream->alloc((void**)&pRegions,
                                      ((regionCount)) * sizeof(const VkImageBlit));
                }
                for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                    reservedunmarshal_VkImageBlit(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                  (VkImageBlit*)(pRegions + i), readStreamPtrPtr);
                }
                memcpy((VkFilter*)&filter, *readStreamPtrPtr, sizeof(VkFilter));
                *readStreamPtrPtr += sizeof(VkFilter);
                if (pRegions) {
                    for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                        transform_tohost_VkImageBlit(globalstate, (VkImageBlit*)(pRegions + i));
                    }
                }
                vk->vkCmdBlitImage((VkCommandBuffer)dispatchHandle, srcImage, srcImageLayout,
                                   dstImage, dstImageLayout, regionCount, pRegions, filter);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyBufferToImage: {
                android::base::beginTrace("vkCmdCopyBufferToImage subdecode");
                VkBuffer srcBuffer;
                VkImage dstImage;
                VkImageLayout dstImageLayout;
                uint32_t regionCount;
                const VkBufferImageCopy* pRegions;
                VkBufferImageCopy stack_pRegions[MAX_STACK_ITEMS];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&srcBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                uint64_t cgen_var_1;
                memcpy((uint64_t*)&cgen_var_1, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkImage*)&dstImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_1));
                memcpy((VkImageLayout*)&dstImageLayout, *readStreamPtrPtr, sizeof(VkImageLayout));
                *readStreamPtrPtr += sizeof(VkImageLayout);
                memcpy((uint32_t*)&regionCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((regionCount)) <= MAX_STACK_ITEMS) {
                    pRegions = (VkBufferImageCopy*)stack_pRegions;
                } else {
                    readStream->alloc((void**)&pRegions,
                                      ((regionCount)) * sizeof(const VkBufferImageCopy));
                }
                for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                    reservedunmarshal_VkBufferImageCopy(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                        (VkBufferImageCopy*)(pRegions + i),
                                                        readStreamPtrPtr);
                }
                if (pRegions) {
                    for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                        transform_tohost_VkBufferImageCopy(globalstate,
                                                           (VkBufferImageCopy*)(pRegions + i));
                    }
                }
                this->on_vkCmdCopyBufferToImage(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                                srcBuffer, dstImage, dstImageLayout, regionCount,
                                                pRegions, context);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyImageToBuffer: {
                android::base::beginTrace("vkCmdCopyImageToBuffer subdecode");
                VkImage srcImage;
                VkImageLayout srcImageLayout;
                VkBuffer dstBuffer;
                uint32_t regionCount;
                const VkBufferImageCopy* pRegions;
                VkBufferImageCopy stack_pRegions[MAX_STACK_ITEMS];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkImage*)&srcImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
                memcpy((VkImageLayout*)&srcImageLayout, *readStreamPtrPtr, sizeof(VkImageLayout));
                *readStreamPtrPtr += sizeof(VkImageLayout);
                uint64_t cgen_var_1;
                memcpy((uint64_t*)&cgen_var_1, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&dstBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_1));
                memcpy((uint32_t*)&regionCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((regionCount)) <= MAX_STACK_ITEMS) {
                    pRegions = (VkBufferImageCopy*)stack_pRegions;
                } else {
                    readStream->alloc((void**)&pRegions,
                                      ((regionCount)) * sizeof(const VkBufferImageCopy));
                }
                for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                    reservedunmarshal_VkBufferImageCopy(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                        (VkBufferImageCopy*)(pRegions + i),
                                                        readStreamPtrPtr);
                }
                if (pRegions) {
                    for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                        transform_tohost_VkBufferImageCopy(globalstate,
                                                           (VkBufferImageCopy*)(pRegions + i));
                    }
                }
                this->on_vkCmdCopyImageToBuffer(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                                srcImage, srcImageLayout, dstBuffer, regionCount,
                                                pRegions);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdUpdateBuffer: {
                android::base::beginTrace("vkCmdUpdateBuffer subdecode");
                VkBuffer dstBuffer;
                VkDeviceSize dstOffset;
                VkDeviceSize dataSize;
                const void* pData;
                uint8_t* stack_pData[MAX_STACK_ITEMS];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&dstBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                memcpy((VkDeviceSize*)&dstOffset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((VkDeviceSize*)&dataSize, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                if (((dataSize)) <= MAX_STACK_ITEMS) {
                    pData = (void*)stack_pData;
                } else {
                    readStream->alloc((void**)&pData, ((dataSize)) * sizeof(const uint8_t));
                }
                memcpy((void*)pData, *readStreamPtrPtr, ((dataSize)) * sizeof(const uint8_t));
                *readStreamPtrPtr += ((dataSize)) * sizeof(const uint8_t);
                vk->vkCmdUpdateBuffer((VkCommandBuffer)dispatchHandle, dstBuffer, dstOffset,
                                      dataSize, pData);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdFillBuffer: {
                android::base::beginTrace("vkCmdFillBuffer subdecode");
                VkBuffer dstBuffer;
                VkDeviceSize dstOffset;
                VkDeviceSize size;
                uint32_t data;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&dstBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                memcpy((VkDeviceSize*)&dstOffset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((VkDeviceSize*)&size, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((uint32_t*)&data, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdFillBuffer((VkCommandBuffer)dispatchHandle, dstBuffer, dstOffset, size,
                                    data);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdClearColorImage: {
                android::base::beginTrace("vkCmdClearColorImage subdecode");
                VkImage image;
                VkImageLayout imageLayout;
                const VkClearColorValue* pColor;
                VkClearColorValue stack_pColor[1];
                uint32_t rangeCount;
                const VkImageSubresourceRange* pRanges;
                VkImageSubresourceRange stack_pRanges[MAX_STACK_ITEMS];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkImage*)&image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
                memcpy((VkImageLayout*)&imageLayout, *readStreamPtrPtr, sizeof(VkImageLayout));
                *readStreamPtrPtr += sizeof(VkImageLayout);
                pColor = (VkClearColorValue*)stack_pColor;
                reservedunmarshal_VkClearColorValue(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                    (VkClearColorValue*)(pColor), readStreamPtrPtr);
                memcpy((uint32_t*)&rangeCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((rangeCount)) <= MAX_STACK_ITEMS) {
                    pRanges = (VkImageSubresourceRange*)stack_pRanges;
                } else {
                    readStream->alloc((void**)&pRanges,
                                      ((rangeCount)) * sizeof(const VkImageSubresourceRange));
                }
                for (uint32_t i = 0; i < (uint32_t)((rangeCount)); ++i) {
                    reservedunmarshal_VkImageSubresourceRange(
                        readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                        (VkImageSubresourceRange*)(pRanges + i), readStreamPtrPtr);
                }
                if (pColor) {
                    transform_tohost_VkClearColorValue(globalstate, (VkClearColorValue*)(pColor));
                }
                if (pRanges) {
                    for (uint32_t i = 0; i < (uint32_t)((rangeCount)); ++i) {
                        transform_tohost_VkImageSubresourceRange(
                            globalstate, (VkImageSubresourceRange*)(pRanges + i));
                    }
                }
                vk->vkCmdClearColorImage((VkCommandBuffer)dispatchHandle, image, imageLayout,
                                         pColor, rangeCount, pRanges);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdClearDepthStencilImage: {
                android::base::beginTrace("vkCmdClearDepthStencilImage subdecode");
                VkImage image;
                VkImageLayout imageLayout;
                const VkClearDepthStencilValue* pDepthStencil;
                VkClearDepthStencilValue stack_pDepthStencil[1];
                uint32_t rangeCount;
                const VkImageSubresourceRange* pRanges;
                VkImageSubresourceRange stack_pRanges[MAX_STACK_ITEMS];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkImage*)&image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
                memcpy((VkImageLayout*)&imageLayout, *readStreamPtrPtr, sizeof(VkImageLayout));
                *readStreamPtrPtr += sizeof(VkImageLayout);
                pDepthStencil = (VkClearDepthStencilValue*)stack_pDepthStencil;
                reservedunmarshal_VkClearDepthStencilValue(
                    readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                    (VkClearDepthStencilValue*)(pDepthStencil), readStreamPtrPtr);
                memcpy((uint32_t*)&rangeCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((rangeCount)) <= MAX_STACK_ITEMS) {
                    pRanges = (VkImageSubresourceRange*)stack_pRanges;
                } else {
                    readStream->alloc((void**)&pRanges,
                                      ((rangeCount)) * sizeof(const VkImageSubresourceRange));
                }
                for (uint32_t i = 0; i < (uint32_t)((rangeCount)); ++i) {
                    reservedunmarshal_VkImageSubresourceRange(
                        readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                        (VkImageSubresourceRange*)(pRanges + i), readStreamPtrPtr);
                }
                if (pDepthStencil) {
                    transform_tohost_VkClearDepthStencilValue(
                        globalstate, (VkClearDepthStencilValue*)(pDepthStencil));
                }
                if (pRanges) {
                    for (uint32_t i = 0; i < (uint32_t)((rangeCount)); ++i) {
                        transform_tohost_VkImageSubresourceRange(
                            globalstate, (VkImageSubresourceRange*)(pRanges + i));
                    }
                }
                vk->vkCmdClearDepthStencilImage((VkCommandBuffer)dispatchHandle, image, imageLayout,
                                                pDepthStencil, rangeCount, pRanges);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdClearAttachments: {
                android::base::beginTrace("vkCmdClearAttachments subdecode");
                uint32_t attachmentCount;
                const VkClearAttachment* pAttachments;
                VkClearAttachment stack_pAttachments[MAX_STACK_ITEMS];
                uint32_t rectCount;
                const VkClearRect* pRects;
                VkClearRect stack_pRects[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&attachmentCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((attachmentCount)) <= MAX_STACK_ITEMS) {
                    pAttachments = (VkClearAttachment*)stack_pAttachments;
                } else {
                    readStream->alloc((void**)&pAttachments,
                                      ((attachmentCount)) * sizeof(const VkClearAttachment));
                }
                for (uint32_t i = 0; i < (uint32_t)((attachmentCount)); ++i) {
                    reservedunmarshal_VkClearAttachment(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                        (VkClearAttachment*)(pAttachments + i),
                                                        readStreamPtrPtr);
                }
                memcpy((uint32_t*)&rectCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((rectCount)) <= MAX_STACK_ITEMS) {
                    pRects = (VkClearRect*)stack_pRects;
                } else {
                    readStream->alloc((void**)&pRects, ((rectCount)) * sizeof(const VkClearRect));
                }
                for (uint32_t i = 0; i < (uint32_t)((rectCount)); ++i) {
                    reservedunmarshal_VkClearRect(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                  (VkClearRect*)(pRects + i), readStreamPtrPtr);
                }
                if (pAttachments) {
                    for (uint32_t i = 0; i < (uint32_t)((attachmentCount)); ++i) {
                        transform_tohost_VkClearAttachment(globalstate,
                                                           (VkClearAttachment*)(pAttachments + i));
                    }
                }
                if (pRects) {
                    for (uint32_t i = 0; i < (uint32_t)((rectCount)); ++i) {
                        transform_tohost_VkClearRect(globalstate, (VkClearRect*)(pRects + i));
                    }
                }
                vk->vkCmdClearAttachments((VkCommandBuffer)dispatchHandle, attachmentCount,
                                          pAttachments, rectCount, pRects);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdResolveImage: {
                android::base::beginTrace("vkCmdResolveImage subdecode");
                VkImage srcImage;
                VkImageLayout srcImageLayout;
                VkImage dstImage;
                VkImageLayout dstImageLayout;
                uint32_t regionCount;
                const VkImageResolve* pRegions;
                VkImageResolve stack_pRegions[MAX_STACK_ITEMS];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkImage*)&srcImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
                memcpy((VkImageLayout*)&srcImageLayout, *readStreamPtrPtr, sizeof(VkImageLayout));
                *readStreamPtrPtr += sizeof(VkImageLayout);
                uint64_t cgen_var_1;
                memcpy((uint64_t*)&cgen_var_1, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkImage*)&dstImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_1));
                memcpy((VkImageLayout*)&dstImageLayout, *readStreamPtrPtr, sizeof(VkImageLayout));
                *readStreamPtrPtr += sizeof(VkImageLayout);
                memcpy((uint32_t*)&regionCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((regionCount)) <= MAX_STACK_ITEMS) {
                    pRegions = (VkImageResolve*)stack_pRegions;
                } else {
                    readStream->alloc((void**)&pRegions,
                                      ((regionCount)) * sizeof(const VkImageResolve));
                }
                for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                    reservedunmarshal_VkImageResolve(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                     (VkImageResolve*)(pRegions + i),
                                                     readStreamPtrPtr);
                }
                if (pRegions) {
                    for (uint32_t i = 0; i < (uint32_t)((regionCount)); ++i) {
                        transform_tohost_VkImageResolve(globalstate,
                                                        (VkImageResolve*)(pRegions + i));
                    }
                }
                vk->vkCmdResolveImage((VkCommandBuffer)dispatchHandle, srcImage, srcImageLayout,
                                      dstImage, dstImageLayout, regionCount, pRegions);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetEvent: {
                android::base::beginTrace("vkCmdSetEvent subdecode");
                VkEvent event;
                VkPipelineStageFlags stageMask;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkEvent*)&event = (VkEvent)unbox_VkEvent((VkEvent)(*&cgen_var_0));
                memcpy((VkPipelineStageFlags*)&stageMask, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags);
                vk->vkCmdSetEvent((VkCommandBuffer)dispatchHandle, event, stageMask);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdResetEvent: {
                android::base::beginTrace("vkCmdResetEvent subdecode");
                VkEvent event;
                VkPipelineStageFlags stageMask;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkEvent*)&event = (VkEvent)unbox_VkEvent((VkEvent)(*&cgen_var_0));
                memcpy((VkPipelineStageFlags*)&stageMask, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags);
                vk->vkCmdResetEvent((VkCommandBuffer)dispatchHandle, event, stageMask);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdWaitEvents: {
                android::base::beginTrace("vkCmdWaitEvents subdecode");
                uint32_t eventCount;
                const VkEvent* pEvents;
                VkEvent stack_pEvents[MAX_STACK_ITEMS];
                VkPipelineStageFlags srcStageMask;
                VkPipelineStageFlags dstStageMask;
                uint32_t memoryBarrierCount;
                const VkMemoryBarrier* pMemoryBarriers;
                VkMemoryBarrier stack_pMemoryBarriers[MAX_STACK_ITEMS];
                uint32_t bufferMemoryBarrierCount;
                const VkBufferMemoryBarrier* pBufferMemoryBarriers;
                VkBufferMemoryBarrier stack_pBufferMemoryBarriers[MAX_STACK_ITEMS];
                uint32_t imageMemoryBarrierCount;
                const VkImageMemoryBarrier* pImageMemoryBarriers;
                VkImageMemoryBarrier stack_pImageMemoryBarriers[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&eventCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((eventCount)) <= MAX_STACK_ITEMS) {
                    pEvents = (VkEvent*)stack_pEvents;
                } else {
                    readStream->alloc((void**)&pEvents, ((eventCount)) * sizeof(const VkEvent));
                }
                if (((eventCount))) {
                    uint8_t* cgen_var_0_ptr = (uint8_t*)(*readStreamPtrPtr);
                    *readStreamPtrPtr += 8 * ((eventCount));
                    for (uint32_t k = 0; k < ((eventCount)); ++k) {
                        uint64_t tmpval;
                        memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                        *(((VkEvent*)pEvents) + k) = (VkEvent)unbox_VkEvent((VkEvent)tmpval);
                    }
                }
                memcpy((VkPipelineStageFlags*)&srcStageMask, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags);
                memcpy((VkPipelineStageFlags*)&dstStageMask, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags);
                memcpy((uint32_t*)&memoryBarrierCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((memoryBarrierCount)) <= MAX_STACK_ITEMS) {
                    pMemoryBarriers = (VkMemoryBarrier*)stack_pMemoryBarriers;
                } else {
                    readStream->alloc((void**)&pMemoryBarriers,
                                      ((memoryBarrierCount)) * sizeof(const VkMemoryBarrier));
                }
                for (uint32_t i = 0; i < (uint32_t)((memoryBarrierCount)); ++i) {
                    reservedunmarshal_VkMemoryBarrier(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                      (VkMemoryBarrier*)(pMemoryBarriers + i),
                                                      readStreamPtrPtr);
                }
                memcpy((uint32_t*)&bufferMemoryBarrierCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((bufferMemoryBarrierCount)) <= MAX_STACK_ITEMS) {
                    pBufferMemoryBarriers = (VkBufferMemoryBarrier*)stack_pBufferMemoryBarriers;
                } else {
                    readStream->alloc(
                        (void**)&pBufferMemoryBarriers,
                        ((bufferMemoryBarrierCount)) * sizeof(const VkBufferMemoryBarrier));
                }
                for (uint32_t i = 0; i < (uint32_t)((bufferMemoryBarrierCount)); ++i) {
                    reservedunmarshal_VkBufferMemoryBarrier(
                        readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                        (VkBufferMemoryBarrier*)(pBufferMemoryBarriers + i), readStreamPtrPtr);
                }
                memcpy((uint32_t*)&imageMemoryBarrierCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((imageMemoryBarrierCount)) <= MAX_STACK_ITEMS) {
                    pImageMemoryBarriers = (VkImageMemoryBarrier*)stack_pImageMemoryBarriers;
                } else {
                    readStream->alloc(
                        (void**)&pImageMemoryBarriers,
                        ((imageMemoryBarrierCount)) * sizeof(const VkImageMemoryBarrier));
                }
                for (uint32_t i = 0; i < (uint32_t)((imageMemoryBarrierCount)); ++i) {
                    reservedunmarshal_VkImageMemoryBarrier(
                        readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                        (VkImageMemoryBarrier*)(pImageMemoryBarriers + i), readStreamPtrPtr);
                }
                if (pMemoryBarriers) {
                    for (uint32_t i = 0; i < (uint32_t)((memoryBarrierCount)); ++i) {
                        transform_tohost_VkMemoryBarrier(globalstate,
                                                         (VkMemoryBarrier*)(pMemoryBarriers + i));
                    }
                }
                if (pBufferMemoryBarriers) {
                    for (uint32_t i = 0; i < (uint32_t)((bufferMemoryBarrierCount)); ++i) {
                        transform_tohost_VkBufferMemoryBarrier(
                            globalstate, (VkBufferMemoryBarrier*)(pBufferMemoryBarriers + i));
                    }
                }
                if (pImageMemoryBarriers) {
                    for (uint32_t i = 0; i < (uint32_t)((imageMemoryBarrierCount)); ++i) {
                        transform_tohost_VkImageMemoryBarrier(
                            globalstate, (VkImageMemoryBarrier*)(pImageMemoryBarriers + i));
                    }
                }
                vk->vkCmdWaitEvents((VkCommandBuffer)dispatchHandle, eventCount, pEvents,
                                    srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers,
                                    bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                    imageMemoryBarrierCount, pImageMemoryBarriers);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdPipelineBarrier: {
                android::base::beginTrace("vkCmdPipelineBarrier subdecode");
                VkPipelineStageFlags srcStageMask;
                VkPipelineStageFlags dstStageMask;
                VkDependencyFlags dependencyFlags;
                uint32_t memoryBarrierCount;
                const VkMemoryBarrier* pMemoryBarriers;
                VkMemoryBarrier stack_pMemoryBarriers[MAX_STACK_ITEMS];
                uint32_t bufferMemoryBarrierCount;
                const VkBufferMemoryBarrier* pBufferMemoryBarriers;
                VkBufferMemoryBarrier stack_pBufferMemoryBarriers[MAX_STACK_ITEMS];
                uint32_t imageMemoryBarrierCount;
                const VkImageMemoryBarrier* pImageMemoryBarriers;
                VkImageMemoryBarrier stack_pImageMemoryBarriers[MAX_STACK_ITEMS];
                memcpy((VkPipelineStageFlags*)&srcStageMask, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags);
                memcpy((VkPipelineStageFlags*)&dstStageMask, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags);
                memcpy((VkDependencyFlags*)&dependencyFlags, *readStreamPtrPtr,
                       sizeof(VkDependencyFlags));
                *readStreamPtrPtr += sizeof(VkDependencyFlags);
                memcpy((uint32_t*)&memoryBarrierCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((memoryBarrierCount)) <= MAX_STACK_ITEMS) {
                    pMemoryBarriers = (VkMemoryBarrier*)stack_pMemoryBarriers;
                } else {
                    readStream->alloc((void**)&pMemoryBarriers,
                                      ((memoryBarrierCount)) * sizeof(const VkMemoryBarrier));
                }
                for (uint32_t i = 0; i < (uint32_t)((memoryBarrierCount)); ++i) {
                    reservedunmarshal_VkMemoryBarrier(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                      (VkMemoryBarrier*)(pMemoryBarriers + i),
                                                      readStreamPtrPtr);
                }
                memcpy((uint32_t*)&bufferMemoryBarrierCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((bufferMemoryBarrierCount)) <= MAX_STACK_ITEMS) {
                    pBufferMemoryBarriers = (VkBufferMemoryBarrier*)stack_pBufferMemoryBarriers;
                } else {
                    readStream->alloc(
                        (void**)&pBufferMemoryBarriers,
                        ((bufferMemoryBarrierCount)) * sizeof(const VkBufferMemoryBarrier));
                }
                for (uint32_t i = 0; i < (uint32_t)((bufferMemoryBarrierCount)); ++i) {
                    reservedunmarshal_VkBufferMemoryBarrier(
                        readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                        (VkBufferMemoryBarrier*)(pBufferMemoryBarriers + i), readStreamPtrPtr);
                }
                memcpy((uint32_t*)&imageMemoryBarrierCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((imageMemoryBarrierCount)) <= MAX_STACK_ITEMS) {
                    pImageMemoryBarriers = (VkImageMemoryBarrier*)stack_pImageMemoryBarriers;
                } else {
                    readStream->alloc(
                        (void**)&pImageMemoryBarriers,
                        ((imageMemoryBarrierCount)) * sizeof(const VkImageMemoryBarrier));
                }
                for (uint32_t i = 0; i < (uint32_t)((imageMemoryBarrierCount)); ++i) {
                    reservedunmarshal_VkImageMemoryBarrier(
                        readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                        (VkImageMemoryBarrier*)(pImageMemoryBarriers + i), readStreamPtrPtr);
                }
                if (pMemoryBarriers) {
                    for (uint32_t i = 0; i < (uint32_t)((memoryBarrierCount)); ++i) {
                        transform_tohost_VkMemoryBarrier(globalstate,
                                                         (VkMemoryBarrier*)(pMemoryBarriers + i));
                    }
                }
                if (pBufferMemoryBarriers) {
                    for (uint32_t i = 0; i < (uint32_t)((bufferMemoryBarrierCount)); ++i) {
                        transform_tohost_VkBufferMemoryBarrier(
                            globalstate, (VkBufferMemoryBarrier*)(pBufferMemoryBarriers + i));
                    }
                }
                if (pImageMemoryBarriers) {
                    for (uint32_t i = 0; i < (uint32_t)((imageMemoryBarrierCount)); ++i) {
                        transform_tohost_VkImageMemoryBarrier(
                            globalstate, (VkImageMemoryBarrier*)(pImageMemoryBarriers + i));
                    }
                }
                this->on_vkCmdPipelineBarrier(
                    pool, (VkCommandBuffer)(boxed_dispatchHandle), srcStageMask, dstStageMask,
                    dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount,
                    pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBeginQuery: {
                android::base::beginTrace("vkCmdBeginQuery subdecode");
                VkQueryPool queryPool;
                uint32_t query;
                VkQueryControlFlags flags;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkQueryPool*)&queryPool =
                    (VkQueryPool)unbox_VkQueryPool((VkQueryPool)(*&cgen_var_0));
                memcpy((uint32_t*)&query, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((VkQueryControlFlags*)&flags, *readStreamPtrPtr,
                       sizeof(VkQueryControlFlags));
                *readStreamPtrPtr += sizeof(VkQueryControlFlags);
                vk->vkCmdBeginQuery((VkCommandBuffer)dispatchHandle, queryPool, query, flags);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdEndQuery: {
                android::base::beginTrace("vkCmdEndQuery subdecode");
                VkQueryPool queryPool;
                uint32_t query;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkQueryPool*)&queryPool =
                    (VkQueryPool)unbox_VkQueryPool((VkQueryPool)(*&cgen_var_0));
                memcpy((uint32_t*)&query, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdEndQuery((VkCommandBuffer)dispatchHandle, queryPool, query);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdResetQueryPool: {
                android::base::beginTrace("vkCmdResetQueryPool subdecode");
                VkQueryPool queryPool;
                uint32_t firstQuery;
                uint32_t queryCount;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkQueryPool*)&queryPool =
                    (VkQueryPool)unbox_VkQueryPool((VkQueryPool)(*&cgen_var_0));
                memcpy((uint32_t*)&firstQuery, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&queryCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdResetQueryPool((VkCommandBuffer)dispatchHandle, queryPool, firstQuery,
                                        queryCount);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdWriteTimestamp: {
                android::base::beginTrace("vkCmdWriteTimestamp subdecode");
                VkPipelineStageFlagBits pipelineStage;
                VkQueryPool queryPool;
                uint32_t query;
                memcpy((VkPipelineStageFlagBits*)&pipelineStage, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlagBits));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlagBits);
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkQueryPool*)&queryPool =
                    (VkQueryPool)unbox_VkQueryPool((VkQueryPool)(*&cgen_var_0));
                memcpy((uint32_t*)&query, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdWriteTimestamp((VkCommandBuffer)dispatchHandle, pipelineStage, queryPool,
                                        query);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyQueryPoolResults: {
                android::base::beginTrace("vkCmdCopyQueryPoolResults subdecode");
                VkQueryPool queryPool;
                uint32_t firstQuery;
                uint32_t queryCount;
                VkBuffer dstBuffer;
                VkDeviceSize dstOffset;
                VkDeviceSize stride;
                VkQueryResultFlags flags;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkQueryPool*)&queryPool =
                    (VkQueryPool)unbox_VkQueryPool((VkQueryPool)(*&cgen_var_0));
                memcpy((uint32_t*)&firstQuery, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&queryCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                uint64_t cgen_var_1;
                memcpy((uint64_t*)&cgen_var_1, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&dstBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_1));
                memcpy((VkDeviceSize*)&dstOffset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((VkDeviceSize*)&stride, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((VkQueryResultFlags*)&flags, *readStreamPtrPtr, sizeof(VkQueryResultFlags));
                *readStreamPtrPtr += sizeof(VkQueryResultFlags);
                this->on_vkCmdCopyQueryPoolResults(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                                   queryPool, firstQuery, queryCount, dstBuffer,
                                                   dstOffset, stride, flags);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdPushConstants: {
                android::base::beginTrace("vkCmdPushConstants subdecode");
                VkPipelineLayout layout;
                VkShaderStageFlags stageFlags;
                uint32_t offset;
                uint32_t size;
                const void* pValues;
                uint8_t* stack_pValues[MAX_STACK_ITEMS];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkPipelineLayout*)&layout =
                    (VkPipelineLayout)unbox_VkPipelineLayout((VkPipelineLayout)(*&cgen_var_0));
                memcpy((VkShaderStageFlags*)&stageFlags, *readStreamPtrPtr,
                       sizeof(VkShaderStageFlags));
                *readStreamPtrPtr += sizeof(VkShaderStageFlags);
                memcpy((uint32_t*)&offset, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&size, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((size)) <= MAX_STACK_ITEMS) {
                    pValues = (void*)stack_pValues;
                } else {
                    readStream->alloc((void**)&pValues, ((size)) * sizeof(const uint8_t));
                }
                memcpy((void*)pValues, *readStreamPtrPtr, ((size)) * sizeof(const uint8_t));
                *readStreamPtrPtr += ((size)) * sizeof(const uint8_t);
                vk->vkCmdPushConstants((VkCommandBuffer)dispatchHandle, layout, stageFlags, offset,
                                       size, pValues);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBeginRenderPass: {
                android::base::beginTrace("vkCmdBeginRenderPass subdecode");
                const VkRenderPassBeginInfo* pRenderPassBegin;
                VkRenderPassBeginInfo stack_pRenderPassBegin[1];
                VkSubpassContents contents;
                pRenderPassBegin = (VkRenderPassBeginInfo*)stack_pRenderPassBegin;
                reservedunmarshal_VkRenderPassBeginInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                        (VkRenderPassBeginInfo*)(pRenderPassBegin),
                                                        readStreamPtrPtr);
                memcpy((VkSubpassContents*)&contents, *readStreamPtrPtr, sizeof(VkSubpassContents));
                *readStreamPtrPtr += sizeof(VkSubpassContents);
                if (pRenderPassBegin) {
                    transform_tohost_VkRenderPassBeginInfo(
                        globalstate, (VkRenderPassBeginInfo*)(pRenderPassBegin));
                }
                vk->vkCmdBeginRenderPass((VkCommandBuffer)dispatchHandle, pRenderPassBegin,
                                         contents);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdNextSubpass: {
                android::base::beginTrace("vkCmdNextSubpass subdecode");
                VkSubpassContents contents;
                memcpy((VkSubpassContents*)&contents, *readStreamPtrPtr, sizeof(VkSubpassContents));
                *readStreamPtrPtr += sizeof(VkSubpassContents);
                vk->vkCmdNextSubpass((VkCommandBuffer)dispatchHandle, contents);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdEndRenderPass: {
                android::base::beginTrace("vkCmdEndRenderPass subdecode");
                vk->vkCmdEndRenderPass((VkCommandBuffer)dispatchHandle);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdExecuteCommands: {
                android::base::beginTrace("vkCmdExecuteCommands subdecode");
                uint32_t commandBufferCount;
                const VkCommandBuffer* pCommandBuffers;
                VkCommandBuffer stack_pCommandBuffers[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&commandBufferCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((commandBufferCount)) <= MAX_STACK_ITEMS) {
                    pCommandBuffers = (VkCommandBuffer*)stack_pCommandBuffers;
                } else {
                    readStream->alloc((void**)&pCommandBuffers,
                                      ((commandBufferCount)) * sizeof(const VkCommandBuffer));
                }
                if (((commandBufferCount))) {
                    uint8_t* cgen_var_0_ptr = (uint8_t*)(*readStreamPtrPtr);
                    *readStreamPtrPtr += 8 * ((commandBufferCount));
                    for (uint32_t k = 0; k < ((commandBufferCount)); ++k) {
                        uint64_t tmpval;
                        memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                        *(((VkCommandBuffer*)pCommandBuffers) + k) =
                            (VkCommandBuffer)unbox_VkCommandBuffer((VkCommandBuffer)tmpval);
                    }
                }
                this->on_vkCmdExecuteCommands(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                              commandBufferCount, pCommandBuffers);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_VERSION_1_1
            case OP_vkCmdSetDeviceMask: {
                android::base::beginTrace("vkCmdSetDeviceMask subdecode");
                uint32_t deviceMask;
                memcpy((uint32_t*)&deviceMask, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdSetDeviceMask((VkCommandBuffer)dispatchHandle, deviceMask);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdDispatchBase: {
                android::base::beginTrace("vkCmdDispatchBase subdecode");
                uint32_t baseGroupX;
                uint32_t baseGroupY;
                uint32_t baseGroupZ;
                uint32_t groupCountX;
                uint32_t groupCountY;
                uint32_t groupCountZ;
                memcpy((uint32_t*)&baseGroupX, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&baseGroupY, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&baseGroupZ, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&groupCountX, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&groupCountY, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&groupCountZ, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdDispatchBase((VkCommandBuffer)dispatchHandle, baseGroupX, baseGroupY,
                                      baseGroupZ, groupCountX, groupCountY, groupCountZ);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_VERSION_1_2
            case OP_vkCmdDrawIndirectCount: {
                android::base::beginTrace("vkCmdDrawIndirectCount subdecode");
                VkBuffer buffer;
                VkDeviceSize offset;
                VkBuffer countBuffer;
                VkDeviceSize countBufferOffset;
                uint32_t maxDrawCount;
                uint32_t stride;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                memcpy((VkDeviceSize*)&offset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                uint64_t cgen_var_1;
                memcpy((uint64_t*)&cgen_var_1, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&countBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_1));
                memcpy((VkDeviceSize*)&countBufferOffset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((uint32_t*)&maxDrawCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&stride, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdDrawIndirectCount((VkCommandBuffer)dispatchHandle, buffer, offset,
                                           countBuffer, countBufferOffset, maxDrawCount, stride);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdDrawIndexedIndirectCount: {
                android::base::beginTrace("vkCmdDrawIndexedIndirectCount subdecode");
                VkBuffer buffer;
                VkDeviceSize offset;
                VkBuffer countBuffer;
                VkDeviceSize countBufferOffset;
                uint32_t maxDrawCount;
                uint32_t stride;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                memcpy((VkDeviceSize*)&offset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                uint64_t cgen_var_1;
                memcpy((uint64_t*)&cgen_var_1, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&countBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_1));
                memcpy((VkDeviceSize*)&countBufferOffset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((uint32_t*)&maxDrawCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&stride, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdDrawIndexedIndirectCount((VkCommandBuffer)dispatchHandle, buffer, offset,
                                                  countBuffer, countBufferOffset, maxDrawCount,
                                                  stride);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBeginRenderPass2: {
                android::base::beginTrace("vkCmdBeginRenderPass2 subdecode");
                const VkRenderPassBeginInfo* pRenderPassBegin;
                VkRenderPassBeginInfo stack_pRenderPassBegin[1];
                const VkSubpassBeginInfo* pSubpassBeginInfo;
                VkSubpassBeginInfo stack_pSubpassBeginInfo[1];
                pRenderPassBegin = (VkRenderPassBeginInfo*)stack_pRenderPassBegin;
                reservedunmarshal_VkRenderPassBeginInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                        (VkRenderPassBeginInfo*)(pRenderPassBegin),
                                                        readStreamPtrPtr);
                pSubpassBeginInfo = (VkSubpassBeginInfo*)stack_pSubpassBeginInfo;
                reservedunmarshal_VkSubpassBeginInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                     (VkSubpassBeginInfo*)(pSubpassBeginInfo),
                                                     readStreamPtrPtr);
                if (pRenderPassBegin) {
                    transform_tohost_VkRenderPassBeginInfo(
                        globalstate, (VkRenderPassBeginInfo*)(pRenderPassBegin));
                }
                if (pSubpassBeginInfo) {
                    transform_tohost_VkSubpassBeginInfo(globalstate,
                                                        (VkSubpassBeginInfo*)(pSubpassBeginInfo));
                }
                vk->vkCmdBeginRenderPass2((VkCommandBuffer)dispatchHandle, pRenderPassBegin,
                                          pSubpassBeginInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdNextSubpass2: {
                android::base::beginTrace("vkCmdNextSubpass2 subdecode");
                const VkSubpassBeginInfo* pSubpassBeginInfo;
                VkSubpassBeginInfo stack_pSubpassBeginInfo[1];
                const VkSubpassEndInfo* pSubpassEndInfo;
                VkSubpassEndInfo stack_pSubpassEndInfo[1];
                pSubpassBeginInfo = (VkSubpassBeginInfo*)stack_pSubpassBeginInfo;
                reservedunmarshal_VkSubpassBeginInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                     (VkSubpassBeginInfo*)(pSubpassBeginInfo),
                                                     readStreamPtrPtr);
                pSubpassEndInfo = (VkSubpassEndInfo*)stack_pSubpassEndInfo;
                reservedunmarshal_VkSubpassEndInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkSubpassEndInfo*)(pSubpassEndInfo),
                                                   readStreamPtrPtr);
                if (pSubpassBeginInfo) {
                    transform_tohost_VkSubpassBeginInfo(globalstate,
                                                        (VkSubpassBeginInfo*)(pSubpassBeginInfo));
                }
                if (pSubpassEndInfo) {
                    transform_tohost_VkSubpassEndInfo(globalstate,
                                                      (VkSubpassEndInfo*)(pSubpassEndInfo));
                }
                vk->vkCmdNextSubpass2((VkCommandBuffer)dispatchHandle, pSubpassBeginInfo,
                                      pSubpassEndInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdEndRenderPass2: {
                android::base::beginTrace("vkCmdEndRenderPass2 subdecode");
                const VkSubpassEndInfo* pSubpassEndInfo;
                VkSubpassEndInfo stack_pSubpassEndInfo[1];
                pSubpassEndInfo = (VkSubpassEndInfo*)stack_pSubpassEndInfo;
                reservedunmarshal_VkSubpassEndInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkSubpassEndInfo*)(pSubpassEndInfo),
                                                   readStreamPtrPtr);
                if (pSubpassEndInfo) {
                    transform_tohost_VkSubpassEndInfo(globalstate,
                                                      (VkSubpassEndInfo*)(pSubpassEndInfo));
                }
                vk->vkCmdEndRenderPass2((VkCommandBuffer)dispatchHandle, pSubpassEndInfo);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_VERSION_1_3
            case OP_vkCmdSetEvent2: {
                android::base::beginTrace("vkCmdSetEvent2 subdecode");
                VkEvent event;
                const VkDependencyInfo* pDependencyInfo;
                VkDependencyInfo stack_pDependencyInfo[1];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkEvent*)&event = (VkEvent)unbox_VkEvent((VkEvent)(*&cgen_var_0));
                pDependencyInfo = (VkDependencyInfo*)stack_pDependencyInfo;
                reservedunmarshal_VkDependencyInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkDependencyInfo*)(pDependencyInfo),
                                                   readStreamPtrPtr);
                if (pDependencyInfo) {
                    transform_tohost_VkDependencyInfo(globalstate,
                                                      (VkDependencyInfo*)(pDependencyInfo));
                }
                vk->vkCmdSetEvent2((VkCommandBuffer)dispatchHandle, event, pDependencyInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdResetEvent2: {
                android::base::beginTrace("vkCmdResetEvent2 subdecode");
                VkEvent event;
                VkPipelineStageFlags2 stageMask;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkEvent*)&event = (VkEvent)unbox_VkEvent((VkEvent)(*&cgen_var_0));
                memcpy((VkPipelineStageFlags2*)&stageMask, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags2));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags2);
                vk->vkCmdResetEvent2((VkCommandBuffer)dispatchHandle, event, stageMask);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdWaitEvents2: {
                android::base::beginTrace("vkCmdWaitEvents2 subdecode");
                uint32_t eventCount;
                const VkEvent* pEvents;
                VkEvent stack_pEvents[MAX_STACK_ITEMS];
                const VkDependencyInfo* pDependencyInfos;
                VkDependencyInfo stack_pDependencyInfos[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&eventCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((eventCount)) <= MAX_STACK_ITEMS) {
                    pEvents = (VkEvent*)stack_pEvents;
                } else {
                    readStream->alloc((void**)&pEvents, ((eventCount)) * sizeof(const VkEvent));
                }
                if (((eventCount))) {
                    uint8_t* cgen_var_0_ptr = (uint8_t*)(*readStreamPtrPtr);
                    *readStreamPtrPtr += 8 * ((eventCount));
                    for (uint32_t k = 0; k < ((eventCount)); ++k) {
                        uint64_t tmpval;
                        memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                        *(((VkEvent*)pEvents) + k) = (VkEvent)unbox_VkEvent((VkEvent)tmpval);
                    }
                }
                if (((eventCount)) <= MAX_STACK_ITEMS) {
                    pDependencyInfos = (VkDependencyInfo*)stack_pDependencyInfos;
                } else {
                    readStream->alloc((void**)&pDependencyInfos,
                                      ((eventCount)) * sizeof(const VkDependencyInfo));
                }
                for (uint32_t i = 0; i < (uint32_t)((eventCount)); ++i) {
                    reservedunmarshal_VkDependencyInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                       (VkDependencyInfo*)(pDependencyInfos + i),
                                                       readStreamPtrPtr);
                }
                if (pDependencyInfos) {
                    for (uint32_t i = 0; i < (uint32_t)((eventCount)); ++i) {
                        transform_tohost_VkDependencyInfo(
                            globalstate, (VkDependencyInfo*)(pDependencyInfos + i));
                    }
                }
                vk->vkCmdWaitEvents2((VkCommandBuffer)dispatchHandle, eventCount, pEvents,
                                     pDependencyInfos);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdPipelineBarrier2: {
                android::base::beginTrace("vkCmdPipelineBarrier2 subdecode");
                const VkDependencyInfo* pDependencyInfo;
                VkDependencyInfo stack_pDependencyInfo[1];
                pDependencyInfo = (VkDependencyInfo*)stack_pDependencyInfo;
                reservedunmarshal_VkDependencyInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkDependencyInfo*)(pDependencyInfo),
                                                   readStreamPtrPtr);
                if (pDependencyInfo) {
                    transform_tohost_VkDependencyInfo(globalstate,
                                                      (VkDependencyInfo*)(pDependencyInfo));
                }
                vk->vkCmdPipelineBarrier2((VkCommandBuffer)dispatchHandle, pDependencyInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdWriteTimestamp2: {
                android::base::beginTrace("vkCmdWriteTimestamp2 subdecode");
                VkPipelineStageFlags2 stage;
                VkQueryPool queryPool;
                uint32_t query;
                memcpy((VkPipelineStageFlags2*)&stage, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags2));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags2);
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkQueryPool*)&queryPool =
                    (VkQueryPool)unbox_VkQueryPool((VkQueryPool)(*&cgen_var_0));
                memcpy((uint32_t*)&query, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdWriteTimestamp2((VkCommandBuffer)dispatchHandle, stage, queryPool, query);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyBuffer2: {
                android::base::beginTrace("vkCmdCopyBuffer2 subdecode");
                const VkCopyBufferInfo2* pCopyBufferInfo;
                VkCopyBufferInfo2 stack_pCopyBufferInfo[1];
                pCopyBufferInfo = (VkCopyBufferInfo2*)stack_pCopyBufferInfo;
                reservedunmarshal_VkCopyBufferInfo2(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                    (VkCopyBufferInfo2*)(pCopyBufferInfo),
                                                    readStreamPtrPtr);
                if (pCopyBufferInfo) {
                    transform_tohost_VkCopyBufferInfo2(globalstate,
                                                       (VkCopyBufferInfo2*)(pCopyBufferInfo));
                }
                vk->vkCmdCopyBuffer2((VkCommandBuffer)dispatchHandle, pCopyBufferInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyImage2: {
                android::base::beginTrace("vkCmdCopyImage2 subdecode");
                const VkCopyImageInfo2* pCopyImageInfo;
                VkCopyImageInfo2 stack_pCopyImageInfo[1];
                pCopyImageInfo = (VkCopyImageInfo2*)stack_pCopyImageInfo;
                reservedunmarshal_VkCopyImageInfo2(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkCopyImageInfo2*)(pCopyImageInfo),
                                                   readStreamPtrPtr);
                if (pCopyImageInfo) {
                    transform_tohost_VkCopyImageInfo2(globalstate,
                                                      (VkCopyImageInfo2*)(pCopyImageInfo));
                }
                this->on_vkCmdCopyImage2(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                         pCopyImageInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyBufferToImage2: {
                android::base::beginTrace("vkCmdCopyBufferToImage2 subdecode");
                const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo;
                VkCopyBufferToImageInfo2 stack_pCopyBufferToImageInfo[1];
                pCopyBufferToImageInfo = (VkCopyBufferToImageInfo2*)stack_pCopyBufferToImageInfo;
                reservedunmarshal_VkCopyBufferToImageInfo2(
                    readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                    (VkCopyBufferToImageInfo2*)(pCopyBufferToImageInfo), readStreamPtrPtr);
                if (pCopyBufferToImageInfo) {
                    transform_tohost_VkCopyBufferToImageInfo2(
                        globalstate, (VkCopyBufferToImageInfo2*)(pCopyBufferToImageInfo));
                }
                this->on_vkCmdCopyBufferToImage2(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                                 pCopyBufferToImageInfo, context);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyImageToBuffer2: {
                android::base::beginTrace("vkCmdCopyImageToBuffer2 subdecode");
                const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo;
                VkCopyImageToBufferInfo2 stack_pCopyImageToBufferInfo[1];
                pCopyImageToBufferInfo = (VkCopyImageToBufferInfo2*)stack_pCopyImageToBufferInfo;
                reservedunmarshal_VkCopyImageToBufferInfo2(
                    readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                    (VkCopyImageToBufferInfo2*)(pCopyImageToBufferInfo), readStreamPtrPtr);
                if (pCopyImageToBufferInfo) {
                    transform_tohost_VkCopyImageToBufferInfo2(
                        globalstate, (VkCopyImageToBufferInfo2*)(pCopyImageToBufferInfo));
                }
                this->on_vkCmdCopyImageToBuffer2(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                                 pCopyImageToBufferInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBlitImage2: {
                android::base::beginTrace("vkCmdBlitImage2 subdecode");
                const VkBlitImageInfo2* pBlitImageInfo;
                VkBlitImageInfo2 stack_pBlitImageInfo[1];
                pBlitImageInfo = (VkBlitImageInfo2*)stack_pBlitImageInfo;
                reservedunmarshal_VkBlitImageInfo2(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkBlitImageInfo2*)(pBlitImageInfo),
                                                   readStreamPtrPtr);
                if (pBlitImageInfo) {
                    transform_tohost_VkBlitImageInfo2(globalstate,
                                                      (VkBlitImageInfo2*)(pBlitImageInfo));
                }
                vk->vkCmdBlitImage2((VkCommandBuffer)dispatchHandle, pBlitImageInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdResolveImage2: {
                android::base::beginTrace("vkCmdResolveImage2 subdecode");
                const VkResolveImageInfo2* pResolveImageInfo;
                VkResolveImageInfo2 stack_pResolveImageInfo[1];
                pResolveImageInfo = (VkResolveImageInfo2*)stack_pResolveImageInfo;
                reservedunmarshal_VkResolveImageInfo2(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                      (VkResolveImageInfo2*)(pResolveImageInfo),
                                                      readStreamPtrPtr);
                if (pResolveImageInfo) {
                    transform_tohost_VkResolveImageInfo2(globalstate,
                                                         (VkResolveImageInfo2*)(pResolveImageInfo));
                }
                vk->vkCmdResolveImage2((VkCommandBuffer)dispatchHandle, pResolveImageInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBeginRendering: {
                android::base::beginTrace("vkCmdBeginRendering subdecode");
                const VkRenderingInfo* pRenderingInfo;
                VkRenderingInfo stack_pRenderingInfo[1];
                pRenderingInfo = (VkRenderingInfo*)stack_pRenderingInfo;
                reservedunmarshal_VkRenderingInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                  (VkRenderingInfo*)(pRenderingInfo),
                                                  readStreamPtrPtr);
                if (pRenderingInfo) {
                    transform_tohost_VkRenderingInfo(globalstate,
                                                     (VkRenderingInfo*)(pRenderingInfo));
                }
                vk->vkCmdBeginRendering((VkCommandBuffer)dispatchHandle, pRenderingInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdEndRendering: {
                android::base::beginTrace("vkCmdEndRendering subdecode");
                vk->vkCmdEndRendering((VkCommandBuffer)dispatchHandle);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetCullMode: {
                android::base::beginTrace("vkCmdSetCullMode subdecode");
                VkCullModeFlags cullMode;
                memcpy((VkCullModeFlags*)&cullMode, *readStreamPtrPtr, sizeof(VkCullModeFlags));
                *readStreamPtrPtr += sizeof(VkCullModeFlags);
                vk->vkCmdSetCullMode((VkCommandBuffer)dispatchHandle, cullMode);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetFrontFace: {
                android::base::beginTrace("vkCmdSetFrontFace subdecode");
                VkFrontFace frontFace;
                memcpy((VkFrontFace*)&frontFace, *readStreamPtrPtr, sizeof(VkFrontFace));
                *readStreamPtrPtr += sizeof(VkFrontFace);
                vk->vkCmdSetFrontFace((VkCommandBuffer)dispatchHandle, frontFace);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetPrimitiveTopology: {
                android::base::beginTrace("vkCmdSetPrimitiveTopology subdecode");
                VkPrimitiveTopology primitiveTopology;
                memcpy((VkPrimitiveTopology*)&primitiveTopology, *readStreamPtrPtr,
                       sizeof(VkPrimitiveTopology));
                *readStreamPtrPtr += sizeof(VkPrimitiveTopology);
                vk->vkCmdSetPrimitiveTopology((VkCommandBuffer)dispatchHandle, primitiveTopology);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetViewportWithCount: {
                android::base::beginTrace("vkCmdSetViewportWithCount subdecode");
                uint32_t viewportCount;
                const VkViewport* pViewports;
                VkViewport stack_pViewports[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&viewportCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((viewportCount)) <= MAX_STACK_ITEMS) {
                    pViewports = (VkViewport*)stack_pViewports;
                } else {
                    readStream->alloc((void**)&pViewports,
                                      ((viewportCount)) * sizeof(const VkViewport));
                }
                for (uint32_t i = 0; i < (uint32_t)((viewportCount)); ++i) {
                    reservedunmarshal_VkViewport(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                 (VkViewport*)(pViewports + i), readStreamPtrPtr);
                }
                if (pViewports) {
                    for (uint32_t i = 0; i < (uint32_t)((viewportCount)); ++i) {
                        transform_tohost_VkViewport(globalstate, (VkViewport*)(pViewports + i));
                    }
                }
                vk->vkCmdSetViewportWithCount((VkCommandBuffer)dispatchHandle, viewportCount,
                                              pViewports);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetScissorWithCount: {
                android::base::beginTrace("vkCmdSetScissorWithCount subdecode");
                uint32_t scissorCount;
                const VkRect2D* pScissors;
                VkRect2D stack_pScissors[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&scissorCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((scissorCount)) <= MAX_STACK_ITEMS) {
                    pScissors = (VkRect2D*)stack_pScissors;
                } else {
                    readStream->alloc((void**)&pScissors,
                                      ((scissorCount)) * sizeof(const VkRect2D));
                }
                for (uint32_t i = 0; i < (uint32_t)((scissorCount)); ++i) {
                    reservedunmarshal_VkRect2D(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                               (VkRect2D*)(pScissors + i), readStreamPtrPtr);
                }
                if (pScissors) {
                    for (uint32_t i = 0; i < (uint32_t)((scissorCount)); ++i) {
                        transform_tohost_VkRect2D(globalstate, (VkRect2D*)(pScissors + i));
                    }
                }
                vk->vkCmdSetScissorWithCount((VkCommandBuffer)dispatchHandle, scissorCount,
                                             pScissors);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBindVertexBuffers2: {
                android::base::beginTrace("vkCmdBindVertexBuffers2 subdecode");
                uint32_t firstBinding;
                uint32_t bindingCount;
                const VkBuffer* pBuffers;
                VkBuffer stack_pBuffers[MAX_STACK_ITEMS];
                const VkDeviceSize* pOffsets;
                VkDeviceSize stack_pOffsets[MAX_STACK_ITEMS];
                const VkDeviceSize* pSizes;
                VkDeviceSize stack_pSizes[MAX_STACK_ITEMS];
                const VkDeviceSize* pStrides;
                VkDeviceSize stack_pStrides[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&firstBinding, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&bindingCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                // WARNING PTR CHECK
                memcpy((VkBuffer**)&pBuffers, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pBuffers);
                *readStreamPtrPtr += 8;
                if (pBuffers) {
                    if (((bindingCount)) <= MAX_STACK_ITEMS) {
                        pBuffers = (VkBuffer*)stack_pBuffers;
                    } else {
                        readStream->alloc((void**)&pBuffers,
                                          ((bindingCount)) * sizeof(const VkBuffer));
                    }
                    if (((bindingCount))) {
                        uint8_t* cgen_var_0_0_ptr = (uint8_t*)(*readStreamPtrPtr);
                        *readStreamPtrPtr += 8 * ((bindingCount));
                        for (uint32_t k = 0; k < ((bindingCount)); ++k) {
                            uint64_t tmpval;
                            memcpy(&tmpval, cgen_var_0_0_ptr + k * 8, sizeof(uint64_t));
                            *(((VkBuffer*)pBuffers) + k) =
                                (VkBuffer)unbox_VkBuffer((VkBuffer)tmpval);
                        }
                    }
                }
                if (((bindingCount)) <= MAX_STACK_ITEMS) {
                    pOffsets = (VkDeviceSize*)stack_pOffsets;
                } else {
                    readStream->alloc((void**)&pOffsets,
                                      ((bindingCount)) * sizeof(const VkDeviceSize));
                }
                memcpy((VkDeviceSize*)pOffsets, *readStreamPtrPtr,
                       ((bindingCount)) * sizeof(const VkDeviceSize));
                *readStreamPtrPtr += ((bindingCount)) * sizeof(const VkDeviceSize);
                // WARNING PTR CHECK
                memcpy((VkDeviceSize**)&pSizes, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pSizes);
                *readStreamPtrPtr += 8;
                if (pSizes) {
                    if (((bindingCount)) <= MAX_STACK_ITEMS) {
                        pSizes = (VkDeviceSize*)stack_pSizes;
                    } else {
                        readStream->alloc((void**)&pSizes,
                                          ((bindingCount)) * sizeof(const VkDeviceSize));
                    }
                    memcpy((VkDeviceSize*)pSizes, *readStreamPtrPtr,
                           ((bindingCount)) * sizeof(const VkDeviceSize));
                    *readStreamPtrPtr += ((bindingCount)) * sizeof(const VkDeviceSize);
                }
                // WARNING PTR CHECK
                memcpy((VkDeviceSize**)&pStrides, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pStrides);
                *readStreamPtrPtr += 8;
                if (pStrides) {
                    if (((bindingCount)) <= MAX_STACK_ITEMS) {
                        pStrides = (VkDeviceSize*)stack_pStrides;
                    } else {
                        readStream->alloc((void**)&pStrides,
                                          ((bindingCount)) * sizeof(const VkDeviceSize));
                    }
                    memcpy((VkDeviceSize*)pStrides, *readStreamPtrPtr,
                           ((bindingCount)) * sizeof(const VkDeviceSize));
                    *readStreamPtrPtr += ((bindingCount)) * sizeof(const VkDeviceSize);
                }
                vk->vkCmdBindVertexBuffers2((VkCommandBuffer)dispatchHandle, firstBinding,
                                            bindingCount, pBuffers, pOffsets, pSizes, pStrides);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthTestEnable: {
                android::base::beginTrace("vkCmdSetDepthTestEnable subdecode");
                VkBool32 depthTestEnable;
                memcpy((VkBool32*)&depthTestEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetDepthTestEnable((VkCommandBuffer)dispatchHandle, depthTestEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthWriteEnable: {
                android::base::beginTrace("vkCmdSetDepthWriteEnable subdecode");
                VkBool32 depthWriteEnable;
                memcpy((VkBool32*)&depthWriteEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetDepthWriteEnable((VkCommandBuffer)dispatchHandle, depthWriteEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthCompareOp: {
                android::base::beginTrace("vkCmdSetDepthCompareOp subdecode");
                VkCompareOp depthCompareOp;
                memcpy((VkCompareOp*)&depthCompareOp, *readStreamPtrPtr, sizeof(VkCompareOp));
                *readStreamPtrPtr += sizeof(VkCompareOp);
                vk->vkCmdSetDepthCompareOp((VkCommandBuffer)dispatchHandle, depthCompareOp);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthBoundsTestEnable: {
                android::base::beginTrace("vkCmdSetDepthBoundsTestEnable subdecode");
                VkBool32 depthBoundsTestEnable;
                memcpy((VkBool32*)&depthBoundsTestEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetDepthBoundsTestEnable((VkCommandBuffer)dispatchHandle,
                                                  depthBoundsTestEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetStencilTestEnable: {
                android::base::beginTrace("vkCmdSetStencilTestEnable subdecode");
                VkBool32 stencilTestEnable;
                memcpy((VkBool32*)&stencilTestEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetStencilTestEnable((VkCommandBuffer)dispatchHandle, stencilTestEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetStencilOp: {
                android::base::beginTrace("vkCmdSetStencilOp subdecode");
                VkStencilFaceFlags faceMask;
                VkStencilOp failOp;
                VkStencilOp passOp;
                VkStencilOp depthFailOp;
                VkCompareOp compareOp;
                memcpy((VkStencilFaceFlags*)&faceMask, *readStreamPtrPtr,
                       sizeof(VkStencilFaceFlags));
                *readStreamPtrPtr += sizeof(VkStencilFaceFlags);
                memcpy((VkStencilOp*)&failOp, *readStreamPtrPtr, sizeof(VkStencilOp));
                *readStreamPtrPtr += sizeof(VkStencilOp);
                memcpy((VkStencilOp*)&passOp, *readStreamPtrPtr, sizeof(VkStencilOp));
                *readStreamPtrPtr += sizeof(VkStencilOp);
                memcpy((VkStencilOp*)&depthFailOp, *readStreamPtrPtr, sizeof(VkStencilOp));
                *readStreamPtrPtr += sizeof(VkStencilOp);
                memcpy((VkCompareOp*)&compareOp, *readStreamPtrPtr, sizeof(VkCompareOp));
                *readStreamPtrPtr += sizeof(VkCompareOp);
                vk->vkCmdSetStencilOp((VkCommandBuffer)dispatchHandle, faceMask, failOp, passOp,
                                      depthFailOp, compareOp);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetRasterizerDiscardEnable: {
                android::base::beginTrace("vkCmdSetRasterizerDiscardEnable subdecode");
                VkBool32 rasterizerDiscardEnable;
                memcpy((VkBool32*)&rasterizerDiscardEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetRasterizerDiscardEnable((VkCommandBuffer)dispatchHandle,
                                                    rasterizerDiscardEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthBiasEnable: {
                android::base::beginTrace("vkCmdSetDepthBiasEnable subdecode");
                VkBool32 depthBiasEnable;
                memcpy((VkBool32*)&depthBiasEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetDepthBiasEnable((VkCommandBuffer)dispatchHandle, depthBiasEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetPrimitiveRestartEnable: {
                android::base::beginTrace("vkCmdSetPrimitiveRestartEnable subdecode");
                VkBool32 primitiveRestartEnable;
                memcpy((VkBool32*)&primitiveRestartEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetPrimitiveRestartEnable((VkCommandBuffer)dispatchHandle,
                                                   primitiveRestartEnable);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_KHR_surface
#endif
#ifdef VK_KHR_swapchain
#endif
#ifdef VK_KHR_xcb_surface
#endif
#ifdef VK_KHR_android_surface
#endif
#ifdef VK_KHR_win32_surface
#endif
#ifdef VK_KHR_dynamic_rendering
            case OP_vkCmdBeginRenderingKHR: {
                android::base::beginTrace("vkCmdBeginRenderingKHR subdecode");
                const VkRenderingInfo* pRenderingInfo;
                VkRenderingInfo stack_pRenderingInfo[1];
                pRenderingInfo = (VkRenderingInfo*)stack_pRenderingInfo;
                reservedunmarshal_VkRenderingInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                  (VkRenderingInfo*)(pRenderingInfo),
                                                  readStreamPtrPtr);
                if (pRenderingInfo) {
                    transform_tohost_VkRenderingInfo(globalstate,
                                                     (VkRenderingInfo*)(pRenderingInfo));
                }
                vk->vkCmdBeginRenderingKHR((VkCommandBuffer)dispatchHandle, pRenderingInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdEndRenderingKHR: {
                android::base::beginTrace("vkCmdEndRenderingKHR subdecode");
                vk->vkCmdEndRenderingKHR((VkCommandBuffer)dispatchHandle);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_KHR_get_physical_device_properties2
#endif
#ifdef VK_KHR_maintenance1
#endif
#ifdef VK_KHR_external_memory_capabilities
#endif
#ifdef VK_KHR_external_memory
#endif
#ifdef VK_KHR_external_memory_win32
#endif
#ifdef VK_KHR_external_memory_fd
#endif
#ifdef VK_KHR_external_semaphore_capabilities
#endif
#ifdef VK_KHR_external_semaphore
#endif
#ifdef VK_KHR_external_semaphore_win32
#endif
#ifdef VK_KHR_external_semaphore_fd
#endif
#ifdef VK_KHR_shader_float16_int8
#endif
#ifdef VK_KHR_incremental_present
#endif
#ifdef VK_KHR_descriptor_update_template
#endif
#ifdef VK_KHR_imageless_framebuffer
#endif
#ifdef VK_KHR_create_renderpass2
            case OP_vkCmdBeginRenderPass2KHR: {
                android::base::beginTrace("vkCmdBeginRenderPass2KHR subdecode");
                const VkRenderPassBeginInfo* pRenderPassBegin;
                VkRenderPassBeginInfo stack_pRenderPassBegin[1];
                const VkSubpassBeginInfo* pSubpassBeginInfo;
                VkSubpassBeginInfo stack_pSubpassBeginInfo[1];
                pRenderPassBegin = (VkRenderPassBeginInfo*)stack_pRenderPassBegin;
                reservedunmarshal_VkRenderPassBeginInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                        (VkRenderPassBeginInfo*)(pRenderPassBegin),
                                                        readStreamPtrPtr);
                pSubpassBeginInfo = (VkSubpassBeginInfo*)stack_pSubpassBeginInfo;
                reservedunmarshal_VkSubpassBeginInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                     (VkSubpassBeginInfo*)(pSubpassBeginInfo),
                                                     readStreamPtrPtr);
                if (pRenderPassBegin) {
                    transform_tohost_VkRenderPassBeginInfo(
                        globalstate, (VkRenderPassBeginInfo*)(pRenderPassBegin));
                }
                if (pSubpassBeginInfo) {
                    transform_tohost_VkSubpassBeginInfo(globalstate,
                                                        (VkSubpassBeginInfo*)(pSubpassBeginInfo));
                }
                vk->vkCmdBeginRenderPass2KHR((VkCommandBuffer)dispatchHandle, pRenderPassBegin,
                                             pSubpassBeginInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdNextSubpass2KHR: {
                android::base::beginTrace("vkCmdNextSubpass2KHR subdecode");
                const VkSubpassBeginInfo* pSubpassBeginInfo;
                VkSubpassBeginInfo stack_pSubpassBeginInfo[1];
                const VkSubpassEndInfo* pSubpassEndInfo;
                VkSubpassEndInfo stack_pSubpassEndInfo[1];
                pSubpassBeginInfo = (VkSubpassBeginInfo*)stack_pSubpassBeginInfo;
                reservedunmarshal_VkSubpassBeginInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                     (VkSubpassBeginInfo*)(pSubpassBeginInfo),
                                                     readStreamPtrPtr);
                pSubpassEndInfo = (VkSubpassEndInfo*)stack_pSubpassEndInfo;
                reservedunmarshal_VkSubpassEndInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkSubpassEndInfo*)(pSubpassEndInfo),
                                                   readStreamPtrPtr);
                if (pSubpassBeginInfo) {
                    transform_tohost_VkSubpassBeginInfo(globalstate,
                                                        (VkSubpassBeginInfo*)(pSubpassBeginInfo));
                }
                if (pSubpassEndInfo) {
                    transform_tohost_VkSubpassEndInfo(globalstate,
                                                      (VkSubpassEndInfo*)(pSubpassEndInfo));
                }
                vk->vkCmdNextSubpass2KHR((VkCommandBuffer)dispatchHandle, pSubpassBeginInfo,
                                         pSubpassEndInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdEndRenderPass2KHR: {
                android::base::beginTrace("vkCmdEndRenderPass2KHR subdecode");
                const VkSubpassEndInfo* pSubpassEndInfo;
                VkSubpassEndInfo stack_pSubpassEndInfo[1];
                pSubpassEndInfo = (VkSubpassEndInfo*)stack_pSubpassEndInfo;
                reservedunmarshal_VkSubpassEndInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkSubpassEndInfo*)(pSubpassEndInfo),
                                                   readStreamPtrPtr);
                if (pSubpassEndInfo) {
                    transform_tohost_VkSubpassEndInfo(globalstate,
                                                      (VkSubpassEndInfo*)(pSubpassEndInfo));
                }
                vk->vkCmdEndRenderPass2KHR((VkCommandBuffer)dispatchHandle, pSubpassEndInfo);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_KHR_external_fence_capabilities
#endif
#ifdef VK_KHR_external_fence
#endif
#ifdef VK_KHR_external_fence_fd
#endif
#ifdef VK_KHR_maintenance2
#endif
#ifdef VK_KHR_dedicated_allocation
#endif
#ifdef VK_KHR_storage_buffer_storage_class
#endif
#ifdef VK_KHR_get_memory_requirements2
#endif
#ifdef VK_KHR_image_format_list
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
#endif
#ifdef VK_KHR_bind_memory2
#endif
#ifdef VK_KHR_maintenance3
#endif
#ifdef VK_KHR_shader_subgroup_extended_types
#endif
#ifdef VK_KHR_vulkan_memory_model
#endif
#ifdef VK_KHR_shader_terminate_invocation
#endif
#ifdef VK_KHR_buffer_device_address
#endif
#ifdef VK_KHR_pipeline_executable_properties
#endif
#ifdef VK_KHR_shader_integer_dot_product
#endif
#ifdef VK_KHR_shader_non_semantic_info
#endif
#ifdef VK_KHR_synchronization2
            case OP_vkCmdSetEvent2KHR: {
                android::base::beginTrace("vkCmdSetEvent2KHR subdecode");
                VkEvent event;
                const VkDependencyInfo* pDependencyInfo;
                VkDependencyInfo stack_pDependencyInfo[1];
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkEvent*)&event = (VkEvent)unbox_VkEvent((VkEvent)(*&cgen_var_0));
                pDependencyInfo = (VkDependencyInfo*)stack_pDependencyInfo;
                reservedunmarshal_VkDependencyInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkDependencyInfo*)(pDependencyInfo),
                                                   readStreamPtrPtr);
                if (pDependencyInfo) {
                    transform_tohost_VkDependencyInfo(globalstate,
                                                      (VkDependencyInfo*)(pDependencyInfo));
                }
                vk->vkCmdSetEvent2KHR((VkCommandBuffer)dispatchHandle, event, pDependencyInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdResetEvent2KHR: {
                android::base::beginTrace("vkCmdResetEvent2KHR subdecode");
                VkEvent event;
                VkPipelineStageFlags2 stageMask;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkEvent*)&event = (VkEvent)unbox_VkEvent((VkEvent)(*&cgen_var_0));
                memcpy((VkPipelineStageFlags2*)&stageMask, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags2));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags2);
                vk->vkCmdResetEvent2KHR((VkCommandBuffer)dispatchHandle, event, stageMask);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdWaitEvents2KHR: {
                android::base::beginTrace("vkCmdWaitEvents2KHR subdecode");
                uint32_t eventCount;
                const VkEvent* pEvents;
                VkEvent stack_pEvents[MAX_STACK_ITEMS];
                const VkDependencyInfo* pDependencyInfos;
                VkDependencyInfo stack_pDependencyInfos[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&eventCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((eventCount)) <= MAX_STACK_ITEMS) {
                    pEvents = (VkEvent*)stack_pEvents;
                } else {
                    readStream->alloc((void**)&pEvents, ((eventCount)) * sizeof(const VkEvent));
                }
                if (((eventCount))) {
                    uint8_t* cgen_var_0_ptr = (uint8_t*)(*readStreamPtrPtr);
                    *readStreamPtrPtr += 8 * ((eventCount));
                    for (uint32_t k = 0; k < ((eventCount)); ++k) {
                        uint64_t tmpval;
                        memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                        *(((VkEvent*)pEvents) + k) = (VkEvent)unbox_VkEvent((VkEvent)tmpval);
                    }
                }
                if (((eventCount)) <= MAX_STACK_ITEMS) {
                    pDependencyInfos = (VkDependencyInfo*)stack_pDependencyInfos;
                } else {
                    readStream->alloc((void**)&pDependencyInfos,
                                      ((eventCount)) * sizeof(const VkDependencyInfo));
                }
                for (uint32_t i = 0; i < (uint32_t)((eventCount)); ++i) {
                    reservedunmarshal_VkDependencyInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                       (VkDependencyInfo*)(pDependencyInfos + i),
                                                       readStreamPtrPtr);
                }
                if (pDependencyInfos) {
                    for (uint32_t i = 0; i < (uint32_t)((eventCount)); ++i) {
                        transform_tohost_VkDependencyInfo(
                            globalstate, (VkDependencyInfo*)(pDependencyInfos + i));
                    }
                }
                vk->vkCmdWaitEvents2KHR((VkCommandBuffer)dispatchHandle, eventCount, pEvents,
                                        pDependencyInfos);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdPipelineBarrier2KHR: {
                android::base::beginTrace("vkCmdPipelineBarrier2KHR subdecode");
                const VkDependencyInfo* pDependencyInfo;
                VkDependencyInfo stack_pDependencyInfo[1];
                pDependencyInfo = (VkDependencyInfo*)stack_pDependencyInfo;
                reservedunmarshal_VkDependencyInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkDependencyInfo*)(pDependencyInfo),
                                                   readStreamPtrPtr);
                if (pDependencyInfo) {
                    transform_tohost_VkDependencyInfo(globalstate,
                                                      (VkDependencyInfo*)(pDependencyInfo));
                }
                vk->vkCmdPipelineBarrier2KHR((VkCommandBuffer)dispatchHandle, pDependencyInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdWriteTimestamp2KHR: {
                android::base::beginTrace("vkCmdWriteTimestamp2KHR subdecode");
                VkPipelineStageFlags2 stage;
                VkQueryPool queryPool;
                uint32_t query;
                memcpy((VkPipelineStageFlags2*)&stage, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags2));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags2);
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkQueryPool*)&queryPool =
                    (VkQueryPool)unbox_VkQueryPool((VkQueryPool)(*&cgen_var_0));
                memcpy((uint32_t*)&query, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdWriteTimestamp2KHR((VkCommandBuffer)dispatchHandle, stage, queryPool,
                                            query);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdWriteBufferMarker2AMD: {
                android::base::beginTrace("vkCmdWriteBufferMarker2AMD subdecode");
                VkPipelineStageFlags2 stage;
                VkBuffer dstBuffer;
                VkDeviceSize dstOffset;
                uint32_t marker;
                memcpy((VkPipelineStageFlags2*)&stage, *readStreamPtrPtr,
                       sizeof(VkPipelineStageFlags2));
                *readStreamPtrPtr += sizeof(VkPipelineStageFlags2);
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&dstBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                memcpy((VkDeviceSize*)&dstOffset, *readStreamPtrPtr, sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((uint32_t*)&marker, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdWriteBufferMarker2AMD((VkCommandBuffer)dispatchHandle, stage, dstBuffer,
                                               dstOffset, marker);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
#endif
#ifdef VK_KHR_copy_commands2
            case OP_vkCmdCopyBuffer2KHR: {
                android::base::beginTrace("vkCmdCopyBuffer2KHR subdecode");
                const VkCopyBufferInfo2* pCopyBufferInfo;
                VkCopyBufferInfo2 stack_pCopyBufferInfo[1];
                pCopyBufferInfo = (VkCopyBufferInfo2*)stack_pCopyBufferInfo;
                reservedunmarshal_VkCopyBufferInfo2(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                    (VkCopyBufferInfo2*)(pCopyBufferInfo),
                                                    readStreamPtrPtr);
                if (pCopyBufferInfo) {
                    transform_tohost_VkCopyBufferInfo2(globalstate,
                                                       (VkCopyBufferInfo2*)(pCopyBufferInfo));
                }
                vk->vkCmdCopyBuffer2KHR((VkCommandBuffer)dispatchHandle, pCopyBufferInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyImage2KHR: {
                android::base::beginTrace("vkCmdCopyImage2KHR subdecode");
                const VkCopyImageInfo2* pCopyImageInfo;
                VkCopyImageInfo2 stack_pCopyImageInfo[1];
                pCopyImageInfo = (VkCopyImageInfo2*)stack_pCopyImageInfo;
                reservedunmarshal_VkCopyImageInfo2(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkCopyImageInfo2*)(pCopyImageInfo),
                                                   readStreamPtrPtr);
                if (pCopyImageInfo) {
                    transform_tohost_VkCopyImageInfo2(globalstate,
                                                      (VkCopyImageInfo2*)(pCopyImageInfo));
                }
                this->on_vkCmdCopyImage2KHR(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                            pCopyImageInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyBufferToImage2KHR: {
                android::base::beginTrace("vkCmdCopyBufferToImage2KHR subdecode");
                const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo;
                VkCopyBufferToImageInfo2 stack_pCopyBufferToImageInfo[1];
                pCopyBufferToImageInfo = (VkCopyBufferToImageInfo2*)stack_pCopyBufferToImageInfo;
                reservedunmarshal_VkCopyBufferToImageInfo2(
                    readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                    (VkCopyBufferToImageInfo2*)(pCopyBufferToImageInfo), readStreamPtrPtr);
                if (pCopyBufferToImageInfo) {
                    transform_tohost_VkCopyBufferToImageInfo2(
                        globalstate, (VkCopyBufferToImageInfo2*)(pCopyBufferToImageInfo));
                }
                this->on_vkCmdCopyBufferToImage2KHR(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                                    pCopyBufferToImageInfo, context);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdCopyImageToBuffer2KHR: {
                android::base::beginTrace("vkCmdCopyImageToBuffer2KHR subdecode");
                const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo;
                VkCopyImageToBufferInfo2 stack_pCopyImageToBufferInfo[1];
                pCopyImageToBufferInfo = (VkCopyImageToBufferInfo2*)stack_pCopyImageToBufferInfo;
                reservedunmarshal_VkCopyImageToBufferInfo2(
                    readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                    (VkCopyImageToBufferInfo2*)(pCopyImageToBufferInfo), readStreamPtrPtr);
                if (pCopyImageToBufferInfo) {
                    transform_tohost_VkCopyImageToBufferInfo2(
                        globalstate, (VkCopyImageToBufferInfo2*)(pCopyImageToBufferInfo));
                }
                this->on_vkCmdCopyImageToBuffer2KHR(pool, (VkCommandBuffer)(boxed_dispatchHandle),
                                                    pCopyImageToBufferInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBlitImage2KHR: {
                android::base::beginTrace("vkCmdBlitImage2KHR subdecode");
                const VkBlitImageInfo2* pBlitImageInfo;
                VkBlitImageInfo2 stack_pBlitImageInfo[1];
                pBlitImageInfo = (VkBlitImageInfo2*)stack_pBlitImageInfo;
                reservedunmarshal_VkBlitImageInfo2(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                   (VkBlitImageInfo2*)(pBlitImageInfo),
                                                   readStreamPtrPtr);
                if (pBlitImageInfo) {
                    transform_tohost_VkBlitImageInfo2(globalstate,
                                                      (VkBlitImageInfo2*)(pBlitImageInfo));
                }
                vk->vkCmdBlitImage2KHR((VkCommandBuffer)dispatchHandle, pBlitImageInfo);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdResolveImage2KHR: {
                android::base::beginTrace("vkCmdResolveImage2KHR subdecode");
                const VkResolveImageInfo2* pResolveImageInfo;
                VkResolveImageInfo2 stack_pResolveImageInfo[1];
                pResolveImageInfo = (VkResolveImageInfo2*)stack_pResolveImageInfo;
                reservedunmarshal_VkResolveImageInfo2(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                      (VkResolveImageInfo2*)(pResolveImageInfo),
                                                      readStreamPtrPtr);
                if (pResolveImageInfo) {
                    transform_tohost_VkResolveImageInfo2(globalstate,
                                                         (VkResolveImageInfo2*)(pResolveImageInfo));
                }
                vk->vkCmdResolveImage2KHR((VkCommandBuffer)dispatchHandle, pResolveImageInfo);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_KHR_format_feature_flags2
#endif
#ifdef VK_KHR_maintenance4
#endif
#ifdef VK_ANDROID_native_buffer
#endif
#ifdef VK_EXT_transform_feedback
            case OP_vkCmdBindTransformFeedbackBuffersEXT: {
                android::base::beginTrace("vkCmdBindTransformFeedbackBuffersEXT subdecode");
                uint32_t firstBinding;
                uint32_t bindingCount;
                const VkBuffer* pBuffers;
                VkBuffer stack_pBuffers[MAX_STACK_ITEMS];
                const VkDeviceSize* pOffsets;
                VkDeviceSize stack_pOffsets[MAX_STACK_ITEMS];
                const VkDeviceSize* pSizes;
                VkDeviceSize stack_pSizes[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&firstBinding, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&bindingCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((bindingCount)) <= MAX_STACK_ITEMS) {
                    pBuffers = (VkBuffer*)stack_pBuffers;
                } else {
                    readStream->alloc((void**)&pBuffers, ((bindingCount)) * sizeof(const VkBuffer));
                }
                if (((bindingCount))) {
                    uint8_t* cgen_var_0_ptr = (uint8_t*)(*readStreamPtrPtr);
                    *readStreamPtrPtr += 8 * ((bindingCount));
                    for (uint32_t k = 0; k < ((bindingCount)); ++k) {
                        uint64_t tmpval;
                        memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                        *(((VkBuffer*)pBuffers) + k) = (VkBuffer)unbox_VkBuffer((VkBuffer)tmpval);
                    }
                }
                if (((bindingCount)) <= MAX_STACK_ITEMS) {
                    pOffsets = (VkDeviceSize*)stack_pOffsets;
                } else {
                    readStream->alloc((void**)&pOffsets,
                                      ((bindingCount)) * sizeof(const VkDeviceSize));
                }
                memcpy((VkDeviceSize*)pOffsets, *readStreamPtrPtr,
                       ((bindingCount)) * sizeof(const VkDeviceSize));
                *readStreamPtrPtr += ((bindingCount)) * sizeof(const VkDeviceSize);
                // WARNING PTR CHECK
                memcpy((VkDeviceSize**)&pSizes, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pSizes);
                *readStreamPtrPtr += 8;
                if (pSizes) {
                    if (((bindingCount)) <= MAX_STACK_ITEMS) {
                        pSizes = (VkDeviceSize*)stack_pSizes;
                    } else {
                        readStream->alloc((void**)&pSizes,
                                          ((bindingCount)) * sizeof(const VkDeviceSize));
                    }
                    memcpy((VkDeviceSize*)pSizes, *readStreamPtrPtr,
                           ((bindingCount)) * sizeof(const VkDeviceSize));
                    *readStreamPtrPtr += ((bindingCount)) * sizeof(const VkDeviceSize);
                }
                vk->vkCmdBindTransformFeedbackBuffersEXT((VkCommandBuffer)dispatchHandle,
                                                         firstBinding, bindingCount, pBuffers,
                                                         pOffsets, pSizes);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBeginTransformFeedbackEXT: {
                android::base::beginTrace("vkCmdBeginTransformFeedbackEXT subdecode");
                uint32_t firstCounterBuffer;
                uint32_t counterBufferCount;
                const VkBuffer* pCounterBuffers;
                VkBuffer stack_pCounterBuffers[MAX_STACK_ITEMS];
                const VkDeviceSize* pCounterBufferOffsets;
                VkDeviceSize stack_pCounterBufferOffsets[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&firstCounterBuffer, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&counterBufferCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                // WARNING PTR CHECK
                memcpy((VkBuffer**)&pCounterBuffers, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pCounterBuffers);
                *readStreamPtrPtr += 8;
                if (pCounterBuffers) {
                    if (((counterBufferCount)) <= MAX_STACK_ITEMS) {
                        pCounterBuffers = (VkBuffer*)stack_pCounterBuffers;
                    } else {
                        readStream->alloc((void**)&pCounterBuffers,
                                          ((counterBufferCount)) * sizeof(const VkBuffer));
                    }
                    if (((counterBufferCount))) {
                        uint8_t* cgen_var_0_0_ptr = (uint8_t*)(*readStreamPtrPtr);
                        *readStreamPtrPtr += 8 * ((counterBufferCount));
                        for (uint32_t k = 0; k < ((counterBufferCount)); ++k) {
                            uint64_t tmpval;
                            memcpy(&tmpval, cgen_var_0_0_ptr + k * 8, sizeof(uint64_t));
                            *(((VkBuffer*)pCounterBuffers) + k) =
                                (VkBuffer)unbox_VkBuffer((VkBuffer)tmpval);
                        }
                    }
                }
                // WARNING PTR CHECK
                memcpy((VkDeviceSize**)&pCounterBufferOffsets, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pCounterBufferOffsets);
                *readStreamPtrPtr += 8;
                if (pCounterBufferOffsets) {
                    if (((counterBufferCount)) <= MAX_STACK_ITEMS) {
                        pCounterBufferOffsets = (VkDeviceSize*)stack_pCounterBufferOffsets;
                    } else {
                        readStream->alloc((void**)&pCounterBufferOffsets,
                                          ((counterBufferCount)) * sizeof(const VkDeviceSize));
                    }
                    memcpy((VkDeviceSize*)pCounterBufferOffsets, *readStreamPtrPtr,
                           ((counterBufferCount)) * sizeof(const VkDeviceSize));
                    *readStreamPtrPtr += ((counterBufferCount)) * sizeof(const VkDeviceSize);
                }
                vk->vkCmdBeginTransformFeedbackEXT((VkCommandBuffer)dispatchHandle,
                                                   firstCounterBuffer, counterBufferCount,
                                                   pCounterBuffers, pCounterBufferOffsets);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdEndTransformFeedbackEXT: {
                android::base::beginTrace("vkCmdEndTransformFeedbackEXT subdecode");
                uint32_t firstCounterBuffer;
                uint32_t counterBufferCount;
                const VkBuffer* pCounterBuffers;
                VkBuffer stack_pCounterBuffers[MAX_STACK_ITEMS];
                const VkDeviceSize* pCounterBufferOffsets;
                VkDeviceSize stack_pCounterBufferOffsets[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&firstCounterBuffer, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&counterBufferCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                // WARNING PTR CHECK
                memcpy((VkBuffer**)&pCounterBuffers, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pCounterBuffers);
                *readStreamPtrPtr += 8;
                if (pCounterBuffers) {
                    if (((counterBufferCount)) <= MAX_STACK_ITEMS) {
                        pCounterBuffers = (VkBuffer*)stack_pCounterBuffers;
                    } else {
                        readStream->alloc((void**)&pCounterBuffers,
                                          ((counterBufferCount)) * sizeof(const VkBuffer));
                    }
                    if (((counterBufferCount))) {
                        uint8_t* cgen_var_0_0_ptr = (uint8_t*)(*readStreamPtrPtr);
                        *readStreamPtrPtr += 8 * ((counterBufferCount));
                        for (uint32_t k = 0; k < ((counterBufferCount)); ++k) {
                            uint64_t tmpval;
                            memcpy(&tmpval, cgen_var_0_0_ptr + k * 8, sizeof(uint64_t));
                            *(((VkBuffer*)pCounterBuffers) + k) =
                                (VkBuffer)unbox_VkBuffer((VkBuffer)tmpval);
                        }
                    }
                }
                // WARNING PTR CHECK
                memcpy((VkDeviceSize**)&pCounterBufferOffsets, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pCounterBufferOffsets);
                *readStreamPtrPtr += 8;
                if (pCounterBufferOffsets) {
                    if (((counterBufferCount)) <= MAX_STACK_ITEMS) {
                        pCounterBufferOffsets = (VkDeviceSize*)stack_pCounterBufferOffsets;
                    } else {
                        readStream->alloc((void**)&pCounterBufferOffsets,
                                          ((counterBufferCount)) * sizeof(const VkDeviceSize));
                    }
                    memcpy((VkDeviceSize*)pCounterBufferOffsets, *readStreamPtrPtr,
                           ((counterBufferCount)) * sizeof(const VkDeviceSize));
                    *readStreamPtrPtr += ((counterBufferCount)) * sizeof(const VkDeviceSize);
                }
                vk->vkCmdEndTransformFeedbackEXT((VkCommandBuffer)dispatchHandle,
                                                 firstCounterBuffer, counterBufferCount,
                                                 pCounterBuffers, pCounterBufferOffsets);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBeginQueryIndexedEXT: {
                android::base::beginTrace("vkCmdBeginQueryIndexedEXT subdecode");
                VkQueryPool queryPool;
                uint32_t query;
                VkQueryControlFlags flags;
                uint32_t index;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkQueryPool*)&queryPool =
                    (VkQueryPool)unbox_VkQueryPool((VkQueryPool)(*&cgen_var_0));
                memcpy((uint32_t*)&query, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((VkQueryControlFlags*)&flags, *readStreamPtrPtr,
                       sizeof(VkQueryControlFlags));
                *readStreamPtrPtr += sizeof(VkQueryControlFlags);
                memcpy((uint32_t*)&index, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdBeginQueryIndexedEXT((VkCommandBuffer)dispatchHandle, queryPool, query,
                                              flags, index);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdEndQueryIndexedEXT: {
                android::base::beginTrace("vkCmdEndQueryIndexedEXT subdecode");
                VkQueryPool queryPool;
                uint32_t query;
                uint32_t index;
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkQueryPool*)&queryPool =
                    (VkQueryPool)unbox_VkQueryPool((VkQueryPool)(*&cgen_var_0));
                memcpy((uint32_t*)&query, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&index, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdEndQueryIndexedEXT((VkCommandBuffer)dispatchHandle, queryPool, query,
                                            index);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdDrawIndirectByteCountEXT: {
                android::base::beginTrace("vkCmdDrawIndirectByteCountEXT subdecode");
                uint32_t instanceCount;
                uint32_t firstInstance;
                VkBuffer counterBuffer;
                VkDeviceSize counterBufferOffset;
                uint32_t counterOffset;
                uint32_t vertexStride;
                memcpy((uint32_t*)&instanceCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&firstInstance, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                uint64_t cgen_var_0;
                memcpy((uint64_t*)&cgen_var_0, *readStreamPtrPtr, 1 * 8);
                *readStreamPtrPtr += 1 * 8;
                *(VkBuffer*)&counterBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
                memcpy((VkDeviceSize*)&counterBufferOffset, *readStreamPtrPtr,
                       sizeof(VkDeviceSize));
                *readStreamPtrPtr += sizeof(VkDeviceSize);
                memcpy((uint32_t*)&counterOffset, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&vertexStride, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdDrawIndirectByteCountEXT((VkCommandBuffer)dispatchHandle, instanceCount,
                                                  firstInstance, counterBuffer, counterBufferOffset,
                                                  counterOffset, vertexStride);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_AMD_gpu_shader_half_float
#endif
#ifdef VK_EXT_texture_compression_astc_hdr
#endif
#ifdef VK_EXT_swapchain_colorspace
#endif
#ifdef VK_EXT_queue_family_foreign
#endif
#ifdef VK_EXT_debug_utils
#endif
#ifdef VK_ANDROID_external_memory_android_hardware_buffer
#endif
#ifdef VK_EXT_inline_uniform_block
#endif
#ifdef VK_EXT_shader_stencil_export
#endif
#ifdef VK_EXT_pipeline_creation_feedback
#endif
#ifdef VK_NV_shader_subgroup_partitioned
#endif
#ifdef VK_EXT_metal_surface
#endif
#ifdef VK_EXT_subgroup_size_control
#endif
#ifdef VK_EXT_tooling_info
#endif
#ifdef VK_EXT_provoking_vertex
#endif
#ifdef VK_EXT_line_rasterization
            case OP_vkCmdSetLineStippleEXT: {
                android::base::beginTrace("vkCmdSetLineStippleEXT subdecode");
                uint32_t lineStippleFactor;
                uint16_t lineStipplePattern;
                memcpy((uint32_t*)&lineStippleFactor, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint16_t*)&lineStipplePattern, *readStreamPtrPtr, sizeof(uint16_t));
                *readStreamPtrPtr += sizeof(uint16_t);
                vk->vkCmdSetLineStippleEXT((VkCommandBuffer)dispatchHandle, lineStippleFactor,
                                           lineStipplePattern);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_EXT_index_type_uint8
#endif
#ifdef VK_EXT_extended_dynamic_state
            case OP_vkCmdSetCullModeEXT: {
                android::base::beginTrace("vkCmdSetCullModeEXT subdecode");
                VkCullModeFlags cullMode;
                memcpy((VkCullModeFlags*)&cullMode, *readStreamPtrPtr, sizeof(VkCullModeFlags));
                *readStreamPtrPtr += sizeof(VkCullModeFlags);
                vk->vkCmdSetCullModeEXT((VkCommandBuffer)dispatchHandle, cullMode);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetFrontFaceEXT: {
                android::base::beginTrace("vkCmdSetFrontFaceEXT subdecode");
                VkFrontFace frontFace;
                memcpy((VkFrontFace*)&frontFace, *readStreamPtrPtr, sizeof(VkFrontFace));
                *readStreamPtrPtr += sizeof(VkFrontFace);
                vk->vkCmdSetFrontFaceEXT((VkCommandBuffer)dispatchHandle, frontFace);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetPrimitiveTopologyEXT: {
                android::base::beginTrace("vkCmdSetPrimitiveTopologyEXT subdecode");
                VkPrimitiveTopology primitiveTopology;
                memcpy((VkPrimitiveTopology*)&primitiveTopology, *readStreamPtrPtr,
                       sizeof(VkPrimitiveTopology));
                *readStreamPtrPtr += sizeof(VkPrimitiveTopology);
                vk->vkCmdSetPrimitiveTopologyEXT((VkCommandBuffer)dispatchHandle,
                                                 primitiveTopology);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetViewportWithCountEXT: {
                android::base::beginTrace("vkCmdSetViewportWithCountEXT subdecode");
                uint32_t viewportCount;
                const VkViewport* pViewports;
                VkViewport stack_pViewports[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&viewportCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((viewportCount)) <= MAX_STACK_ITEMS) {
                    pViewports = (VkViewport*)stack_pViewports;
                } else {
                    readStream->alloc((void**)&pViewports,
                                      ((viewportCount)) * sizeof(const VkViewport));
                }
                for (uint32_t i = 0; i < (uint32_t)((viewportCount)); ++i) {
                    reservedunmarshal_VkViewport(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                 (VkViewport*)(pViewports + i), readStreamPtrPtr);
                }
                if (pViewports) {
                    for (uint32_t i = 0; i < (uint32_t)((viewportCount)); ++i) {
                        transform_tohost_VkViewport(globalstate, (VkViewport*)(pViewports + i));
                    }
                }
                vk->vkCmdSetViewportWithCountEXT((VkCommandBuffer)dispatchHandle, viewportCount,
                                                 pViewports);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetScissorWithCountEXT: {
                android::base::beginTrace("vkCmdSetScissorWithCountEXT subdecode");
                uint32_t scissorCount;
                const VkRect2D* pScissors;
                VkRect2D stack_pScissors[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&scissorCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                if (((scissorCount)) <= MAX_STACK_ITEMS) {
                    pScissors = (VkRect2D*)stack_pScissors;
                } else {
                    readStream->alloc((void**)&pScissors,
                                      ((scissorCount)) * sizeof(const VkRect2D));
                }
                for (uint32_t i = 0; i < (uint32_t)((scissorCount)); ++i) {
                    reservedunmarshal_VkRect2D(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                               (VkRect2D*)(pScissors + i), readStreamPtrPtr);
                }
                if (pScissors) {
                    for (uint32_t i = 0; i < (uint32_t)((scissorCount)); ++i) {
                        transform_tohost_VkRect2D(globalstate, (VkRect2D*)(pScissors + i));
                    }
                }
                vk->vkCmdSetScissorWithCountEXT((VkCommandBuffer)dispatchHandle, scissorCount,
                                                pScissors);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdBindVertexBuffers2EXT: {
                android::base::beginTrace("vkCmdBindVertexBuffers2EXT subdecode");
                uint32_t firstBinding;
                uint32_t bindingCount;
                const VkBuffer* pBuffers;
                VkBuffer stack_pBuffers[MAX_STACK_ITEMS];
                const VkDeviceSize* pOffsets;
                VkDeviceSize stack_pOffsets[MAX_STACK_ITEMS];
                const VkDeviceSize* pSizes;
                VkDeviceSize stack_pSizes[MAX_STACK_ITEMS];
                const VkDeviceSize* pStrides;
                VkDeviceSize stack_pStrides[MAX_STACK_ITEMS];
                memcpy((uint32_t*)&firstBinding, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&bindingCount, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                // WARNING PTR CHECK
                memcpy((VkBuffer**)&pBuffers, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pBuffers);
                *readStreamPtrPtr += 8;
                if (pBuffers) {
                    if (((bindingCount)) <= MAX_STACK_ITEMS) {
                        pBuffers = (VkBuffer*)stack_pBuffers;
                    } else {
                        readStream->alloc((void**)&pBuffers,
                                          ((bindingCount)) * sizeof(const VkBuffer));
                    }
                    if (((bindingCount))) {
                        uint8_t* cgen_var_0_0_ptr = (uint8_t*)(*readStreamPtrPtr);
                        *readStreamPtrPtr += 8 * ((bindingCount));
                        for (uint32_t k = 0; k < ((bindingCount)); ++k) {
                            uint64_t tmpval;
                            memcpy(&tmpval, cgen_var_0_0_ptr + k * 8, sizeof(uint64_t));
                            *(((VkBuffer*)pBuffers) + k) =
                                (VkBuffer)unbox_VkBuffer((VkBuffer)tmpval);
                        }
                    }
                }
                if (((bindingCount)) <= MAX_STACK_ITEMS) {
                    pOffsets = (VkDeviceSize*)stack_pOffsets;
                } else {
                    readStream->alloc((void**)&pOffsets,
                                      ((bindingCount)) * sizeof(const VkDeviceSize));
                }
                memcpy((VkDeviceSize*)pOffsets, *readStreamPtrPtr,
                       ((bindingCount)) * sizeof(const VkDeviceSize));
                *readStreamPtrPtr += ((bindingCount)) * sizeof(const VkDeviceSize);
                // WARNING PTR CHECK
                memcpy((VkDeviceSize**)&pSizes, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pSizes);
                *readStreamPtrPtr += 8;
                if (pSizes) {
                    if (((bindingCount)) <= MAX_STACK_ITEMS) {
                        pSizes = (VkDeviceSize*)stack_pSizes;
                    } else {
                        readStream->alloc((void**)&pSizes,
                                          ((bindingCount)) * sizeof(const VkDeviceSize));
                    }
                    memcpy((VkDeviceSize*)pSizes, *readStreamPtrPtr,
                           ((bindingCount)) * sizeof(const VkDeviceSize));
                    *readStreamPtrPtr += ((bindingCount)) * sizeof(const VkDeviceSize);
                }
                // WARNING PTR CHECK
                memcpy((VkDeviceSize**)&pStrides, (*readStreamPtrPtr), 8);
                android::base::Stream::fromBe64((uint8_t*)&pStrides);
                *readStreamPtrPtr += 8;
                if (pStrides) {
                    if (((bindingCount)) <= MAX_STACK_ITEMS) {
                        pStrides = (VkDeviceSize*)stack_pStrides;
                    } else {
                        readStream->alloc((void**)&pStrides,
                                          ((bindingCount)) * sizeof(const VkDeviceSize));
                    }
                    memcpy((VkDeviceSize*)pStrides, *readStreamPtrPtr,
                           ((bindingCount)) * sizeof(const VkDeviceSize));
                    *readStreamPtrPtr += ((bindingCount)) * sizeof(const VkDeviceSize);
                }
                vk->vkCmdBindVertexBuffers2EXT((VkCommandBuffer)dispatchHandle, firstBinding,
                                               bindingCount, pBuffers, pOffsets, pSizes, pStrides);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthTestEnableEXT: {
                android::base::beginTrace("vkCmdSetDepthTestEnableEXT subdecode");
                VkBool32 depthTestEnable;
                memcpy((VkBool32*)&depthTestEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetDepthTestEnableEXT((VkCommandBuffer)dispatchHandle, depthTestEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthWriteEnableEXT: {
                android::base::beginTrace("vkCmdSetDepthWriteEnableEXT subdecode");
                VkBool32 depthWriteEnable;
                memcpy((VkBool32*)&depthWriteEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetDepthWriteEnableEXT((VkCommandBuffer)dispatchHandle, depthWriteEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthCompareOpEXT: {
                android::base::beginTrace("vkCmdSetDepthCompareOpEXT subdecode");
                VkCompareOp depthCompareOp;
                memcpy((VkCompareOp*)&depthCompareOp, *readStreamPtrPtr, sizeof(VkCompareOp));
                *readStreamPtrPtr += sizeof(VkCompareOp);
                vk->vkCmdSetDepthCompareOpEXT((VkCommandBuffer)dispatchHandle, depthCompareOp);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthBoundsTestEnableEXT: {
                android::base::beginTrace("vkCmdSetDepthBoundsTestEnableEXT subdecode");
                VkBool32 depthBoundsTestEnable;
                memcpy((VkBool32*)&depthBoundsTestEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetDepthBoundsTestEnableEXT((VkCommandBuffer)dispatchHandle,
                                                     depthBoundsTestEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetStencilTestEnableEXT: {
                android::base::beginTrace("vkCmdSetStencilTestEnableEXT subdecode");
                VkBool32 stencilTestEnable;
                memcpy((VkBool32*)&stencilTestEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetStencilTestEnableEXT((VkCommandBuffer)dispatchHandle,
                                                 stencilTestEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetStencilOpEXT: {
                android::base::beginTrace("vkCmdSetStencilOpEXT subdecode");
                VkStencilFaceFlags faceMask;
                VkStencilOp failOp;
                VkStencilOp passOp;
                VkStencilOp depthFailOp;
                VkCompareOp compareOp;
                memcpy((VkStencilFaceFlags*)&faceMask, *readStreamPtrPtr,
                       sizeof(VkStencilFaceFlags));
                *readStreamPtrPtr += sizeof(VkStencilFaceFlags);
                memcpy((VkStencilOp*)&failOp, *readStreamPtrPtr, sizeof(VkStencilOp));
                *readStreamPtrPtr += sizeof(VkStencilOp);
                memcpy((VkStencilOp*)&passOp, *readStreamPtrPtr, sizeof(VkStencilOp));
                *readStreamPtrPtr += sizeof(VkStencilOp);
                memcpy((VkStencilOp*)&depthFailOp, *readStreamPtrPtr, sizeof(VkStencilOp));
                *readStreamPtrPtr += sizeof(VkStencilOp);
                memcpy((VkCompareOp*)&compareOp, *readStreamPtrPtr, sizeof(VkCompareOp));
                *readStreamPtrPtr += sizeof(VkCompareOp);
                vk->vkCmdSetStencilOpEXT((VkCommandBuffer)dispatchHandle, faceMask, failOp, passOp,
                                         depthFailOp, compareOp);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_EXT_swapchain_maintenance1
#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
#endif
#ifdef VK_EXT_texel_buffer_alignment
#endif
#ifdef VK_EXT_device_memory_report
#endif
#ifdef VK_EXT_custom_border_color
#endif
#ifdef VK_EXT_private_data
#endif
#ifdef VK_EXT_pipeline_creation_cache_control
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
#endif
#ifdef VK_EXT_image_robustness
#endif
#ifdef VK_EXT_image_compression_control
#endif
#ifdef VK_EXT_4444_formats
#endif
#ifdef VK_EXT_primitive_topology_list_restart
#endif
#ifdef VK_EXT_extended_dynamic_state2
            case OP_vkCmdSetPatchControlPointsEXT: {
                android::base::beginTrace("vkCmdSetPatchControlPointsEXT subdecode");
                uint32_t patchControlPoints;
                memcpy((uint32_t*)&patchControlPoints, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                vk->vkCmdSetPatchControlPointsEXT((VkCommandBuffer)dispatchHandle,
                                                  patchControlPoints);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetRasterizerDiscardEnableEXT: {
                android::base::beginTrace("vkCmdSetRasterizerDiscardEnableEXT subdecode");
                VkBool32 rasterizerDiscardEnable;
                memcpy((VkBool32*)&rasterizerDiscardEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetRasterizerDiscardEnableEXT((VkCommandBuffer)dispatchHandle,
                                                       rasterizerDiscardEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetDepthBiasEnableEXT: {
                android::base::beginTrace("vkCmdSetDepthBiasEnableEXT subdecode");
                VkBool32 depthBiasEnable;
                memcpy((VkBool32*)&depthBiasEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetDepthBiasEnableEXT((VkCommandBuffer)dispatchHandle, depthBiasEnable);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetLogicOpEXT: {
                android::base::beginTrace("vkCmdSetLogicOpEXT subdecode");
                VkLogicOp logicOp;
                memcpy((VkLogicOp*)&logicOp, *readStreamPtrPtr, sizeof(VkLogicOp));
                *readStreamPtrPtr += sizeof(VkLogicOp);
                vk->vkCmdSetLogicOpEXT((VkCommandBuffer)dispatchHandle, logicOp);
                android::base::endTrace();
                break;
            }
            case OP_vkCmdSetPrimitiveRestartEnableEXT: {
                android::base::beginTrace("vkCmdSetPrimitiveRestartEnableEXT subdecode");
                VkBool32 primitiveRestartEnable;
                memcpy((VkBool32*)&primitiveRestartEnable, *readStreamPtrPtr, sizeof(VkBool32));
                *readStreamPtrPtr += sizeof(VkBool32);
                vk->vkCmdSetPrimitiveRestartEnableEXT((VkCommandBuffer)dispatchHandle,
                                                      primitiveRestartEnable);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_GOOGLE_gfxstream
            case OP_vkBeginCommandBufferAsyncGOOGLE: {
                android::base::beginTrace("vkBeginCommandBufferAsyncGOOGLE subdecode");
                const VkCommandBufferBeginInfo* pBeginInfo;
                VkCommandBufferBeginInfo stack_pBeginInfo[1];
                pBeginInfo = (VkCommandBufferBeginInfo*)stack_pBeginInfo;
                reservedunmarshal_VkCommandBufferBeginInfo(readStream, VK_STRUCTURE_TYPE_MAX_ENUM,
                                                           (VkCommandBufferBeginInfo*)(pBeginInfo),
                                                           readStreamPtrPtr);
                if (pBeginInfo) {
                    transform_tohost_VkCommandBufferBeginInfo(
                        globalstate, (VkCommandBufferBeginInfo*)(pBeginInfo));
                }
                this->on_vkBeginCommandBufferAsyncGOOGLE(
                    pool, (VkCommandBuffer)(boxed_dispatchHandle), pBeginInfo, context);
                android::base::endTrace();
                break;
            }
            case OP_vkEndCommandBufferAsyncGOOGLE: {
                android::base::beginTrace("vkEndCommandBufferAsyncGOOGLE subdecode");
                this->on_vkEndCommandBufferAsyncGOOGLE(
                    pool, (VkCommandBuffer)(boxed_dispatchHandle), context);
                android::base::endTrace();
                break;
            }
            case OP_vkResetCommandBufferAsyncGOOGLE: {
                android::base::beginTrace("vkResetCommandBufferAsyncGOOGLE subdecode");
                VkCommandBufferResetFlags flags;
                memcpy((VkCommandBufferResetFlags*)&flags, *readStreamPtrPtr,
                       sizeof(VkCommandBufferResetFlags));
                *readStreamPtrPtr += sizeof(VkCommandBufferResetFlags);
                this->on_vkResetCommandBufferAsyncGOOGLE(
                    pool, (VkCommandBuffer)(boxed_dispatchHandle), flags);
                android::base::endTrace();
                break;
            }
            case OP_vkCommandBufferHostSyncGOOGLE: {
                android::base::beginTrace("vkCommandBufferHostSyncGOOGLE subdecode");
                uint32_t needHostSync;
                uint32_t sequenceNumber;
                memcpy((uint32_t*)&needHostSync, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                memcpy((uint32_t*)&sequenceNumber, *readStreamPtrPtr, sizeof(uint32_t));
                *readStreamPtrPtr += sizeof(uint32_t);
                this->on_vkCommandBufferHostSyncGOOGLE(
                    pool, (VkCommandBuffer)(boxed_dispatchHandle), needHostSync, sequenceNumber);
                android::base::endTrace();
                break;
            }
#endif
#ifdef VK_EXT_load_store_op_none
#endif
#ifdef VK_EXT_image_compression_control_swapchain
#endif
            default: {
                GFXSTREAM_ABORT(::emugl::FatalError(::emugl::ABORT_REASON_OTHER))
                    << "Unrecognized opcode " << opcode;
            }
        }
        ++count;
        if (count % 1000 == 0) {
            pool->freeAll();
        };
        ptr += packetLen;
    }
    pool->freeAll();
    return ptr - (unsigned char*)buf;
    ;
}
