/* ActivityMonitor.c generated by valac 0.56.17, the Vala compiler
 * generated from ActivityMonitor.vala, do not modify */

/* ActivityMonitor.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <glib.h>
#include "common.h"
#include <glib-object.h>
#include <string.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_0_PROPERTY,
	BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_activity_activity_monitor_properties[BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_DETECTED_IDLE_SIGNAL,
	BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_DETECTED_ACTIVITY_SIGNAL,
	BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_NUM_SIGNALS
};
static guint break_timer_daemon_activity_activity_monitor_signals[BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_NUM_SIGNALS] = {0};

struct _BreakTimerDaemonActivityActivityMonitorPrivate {
	BreakTimerDaemonUtilPausableTimeout* poll_activity_timeout;
	BreakTimerDaemonActivityUserActivity last_activity;
	gint64 last_active_timestamp;
	BreakTimerCommonISessionStatus* session_status;
	BreakTimerDaemonActivityActivityMonitorBackend* backend;
};

static gint BreakTimerDaemonActivityActivityMonitor_private_offset;
static gpointer break_timer_daemon_activity_activity_monitor_parent_class = NULL;
static GInitableIface * break_timer_daemon_activity_activity_monitor_g_initable_parent_iface = NULL;

static void break_timer_daemon_activity_activity_monitor_poll_activity_cb (BreakTimerDaemonActivityActivityMonitor* self,
                                                                    BreakTimerDaemonUtilPausableTimeout* timeout,
                                                                    gint delta_millisecs);
static void _break_timer_daemon_activity_activity_monitor_poll_activity_cb_break_timer_daemon_util_pausable_timeout_timeout_cb (BreakTimerDaemonUtilPausableTimeout* timeout,
                                                                                                                         gint delta_millisecs,
                                                                                                                         gpointer self);
static void break_timer_daemon_activity_activity_monitor_unlocked_cb (BreakTimerDaemonActivityActivityMonitor* self);
static void _break_timer_daemon_activity_activity_monitor_unlocked_cb_break_timer_common_isession_status_unlocked (BreakTimerCommonISessionStatus* _sender,
                                                                                                            gpointer self);
static gboolean break_timer_daemon_activity_activity_monitor_real_init (GInitable* base,
                                                                 GCancellable* cancellable,
                                                                 GError** error);
static void break_timer_daemon_activity_activity_monitor_collect_activity (BreakTimerDaemonActivityActivityMonitor* self,
                                                                    BreakTimerDaemonActivityUserActivity* result);
static void break_timer_daemon_activity_activity_monitor_add_activity (BreakTimerDaemonActivityActivityMonitor* self,
                                                                BreakTimerDaemonActivityUserActivity* activity);
static void break_timer_daemon_activity_activity_monitor_finalize (GObject * obj);
static GType break_timer_daemon_activity_activity_monitor_get_type_once (void);

static inline gpointer
break_timer_daemon_activity_activity_monitor_get_instance_private (BreakTimerDaemonActivityActivityMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonActivityActivityMonitor_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_break_timer_daemon_activity_activity_monitor_poll_activity_cb_break_timer_daemon_util_pausable_timeout_timeout_cb (BreakTimerDaemonUtilPausableTimeout* timeout,
                                                                                                                    gint delta_millisecs,
                                                                                                                    gpointer self)
{
	break_timer_daemon_activity_activity_monitor_poll_activity_cb ((BreakTimerDaemonActivityActivityMonitor*) self, timeout, delta_millisecs);
}

static void
_break_timer_daemon_activity_activity_monitor_unlocked_cb_break_timer_common_isession_status_unlocked (BreakTimerCommonISessionStatus* _sender,
                                                                                                       gpointer self)
{
	break_timer_daemon_activity_activity_monitor_unlocked_cb ((BreakTimerDaemonActivityActivityMonitor*) self);
}

BreakTimerDaemonActivityActivityMonitor*
break_timer_daemon_activity_activity_monitor_construct (GType object_type,
                                                        BreakTimerCommonISessionStatus* session_status,
                                                        BreakTimerDaemonActivityActivityMonitorBackend* backend)
{
	BreakTimerDaemonActivityActivityMonitor * self = NULL;
	BreakTimerCommonISessionStatus* _tmp0_;
	BreakTimerDaemonActivityActivityMonitorBackend* _tmp1_;
	BreakTimerDaemonUtilPausableTimeout* _tmp2_;
	g_return_val_if_fail (session_status != NULL, NULL);
	g_return_val_if_fail (backend != NULL, NULL);
	self = (BreakTimerDaemonActivityActivityMonitor*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (session_status);
	_g_object_unref0 (self->priv->session_status);
	self->priv->session_status = _tmp0_;
	_tmp1_ = _g_object_ref0 (backend);
	_g_object_unref0 (self->priv->backend);
	self->priv->backend = _tmp1_;
	_tmp2_ = break_timer_daemon_util_pausable_timeout_new (_break_timer_daemon_activity_activity_monitor_poll_activity_cb_break_timer_daemon_util_pausable_timeout_timeout_cb, self, 1);
	_g_object_unref0 (self->priv->poll_activity_timeout);
	self->priv->poll_activity_timeout = _tmp2_;
	g_signal_connect_object (session_status, "unlocked", (GCallback) _break_timer_daemon_activity_activity_monitor_unlocked_cb_break_timer_common_isession_status_unlocked, self, 0);
	memset (&self->priv->last_activity, 0, sizeof (BreakTimerDaemonActivityUserActivity));
	return self;
}

BreakTimerDaemonActivityActivityMonitor*
break_timer_daemon_activity_activity_monitor_new (BreakTimerCommonISessionStatus* session_status,
                                                  BreakTimerDaemonActivityActivityMonitorBackend* backend)
{
	return break_timer_daemon_activity_activity_monitor_construct (BREAK_TIMER_DAEMON_ACTIVITY_TYPE_ACTIVITY_MONITOR, session_status, backend);
}

static gboolean
break_timer_daemon_activity_activity_monitor_real_init (GInitable* base,
                                                        GCancellable* cancellable,
                                                        GError** error)
{
	BreakTimerDaemonActivityActivityMonitor * self;
	gboolean result;
	self = (BreakTimerDaemonActivityActivityMonitor*) base;
	result = TRUE;
	return result;
}

JsonObject*
break_timer_daemon_activity_activity_monitor_serialize (BreakTimerDaemonActivityActivityMonitor* self)
{
	JsonObject* json_root = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = json_object_new ();
	json_root = _tmp0_;
	json_object_set_int_member (json_root, "last_active_timestamp", self->priv->last_active_timestamp);
	_tmp1_ = break_timer_daemon_activity_user_activity_serialize (&self->priv->last_activity);
	json_object_set_object_member (json_root, "last_activity", _tmp1_);
	result = json_root;
	return result;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

void
break_timer_daemon_activity_activity_monitor_deserialize (BreakTimerDaemonActivityActivityMonitor* self,
                                                          JsonObject** json_root)
{
	JsonObject* last_activity_json = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	BreakTimerDaemonActivityUserActivity _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (*json_root != NULL);
	self->priv->last_active_timestamp = json_object_get_int_member (*json_root, "last_active_timestamp");
	_tmp0_ = json_object_get_object_member (*json_root, "last_activity");
	_tmp1_ = _json_object_ref0 (_tmp0_);
	last_activity_json = _tmp1_;
	break_timer_daemon_activity_user_activity_deserialize (&last_activity_json, &_tmp2_);
	self->priv->last_activity = _tmp2_;
	_json_object_unref0 (last_activity_json);
}

void
break_timer_daemon_activity_activity_monitor_start (BreakTimerDaemonActivityActivityMonitor* self)
{
	BreakTimerDaemonUtilPausableTimeout* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->poll_activity_timeout;
	break_timer_daemon_util_pausable_timeout_start (_tmp0_);
}

void
break_timer_daemon_activity_activity_monitor_stop (BreakTimerDaemonActivityActivityMonitor* self)
{
	BreakTimerDaemonUtilPausableTimeout* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->poll_activity_timeout;
	break_timer_daemon_util_pausable_timeout_stop (_tmp0_);
}

void
break_timer_daemon_activity_activity_monitor_poll_activity (BreakTimerDaemonActivityActivityMonitor* self)
{
	BreakTimerDaemonActivityUserActivity activity = {0};
	BreakTimerDaemonActivityUserActivity _tmp0_ = {0};
	gchar* _tmp1_;
	gchar* _tmp2_;
	BreakTimerDaemonActivityUserActivity _tmp3_;
	g_return_if_fail (self != NULL);
	break_timer_daemon_activity_activity_monitor_collect_activity (self, &_tmp0_);
	activity = _tmp0_;
	_tmp1_ = break_timer_daemon_activity_user_activity_to_string (&activity);
	_tmp2_ = _tmp1_;
	g_debug ("ActivityMonitor.vala:76: Detected activity: %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = activity;
	break_timer_daemon_activity_activity_monitor_add_activity (self, &_tmp3_);
}

static void
break_timer_daemon_activity_activity_monitor_poll_activity_cb (BreakTimerDaemonActivityActivityMonitor* self,
                                                               BreakTimerDaemonUtilPausableTimeout* timeout,
                                                               gint delta_millisecs)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeout != NULL);
	break_timer_daemon_activity_activity_monitor_poll_activity (self);
}

static void
break_timer_daemon_activity_activity_monitor_unlocked_cb (BreakTimerDaemonActivityActivityMonitor* self)
{
	BreakTimerDaemonActivityUserActivity activity = {0};
	BreakTimerDaemonActivityUserActivity _tmp0_ = {0};
	BreakTimerDaemonActivityUserActivity _tmp1_;
	g_return_if_fail (self != NULL);
	memset (&_tmp0_, 0, sizeof (BreakTimerDaemonActivityUserActivity));
	_tmp0_.type = BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_TYPE_UNLOCK;
	_tmp0_.idle_time = (gint64) 0;
	_tmp0_.time_correction = (gint64) 0;
	activity = _tmp0_;
	_tmp1_ = activity;
	break_timer_daemon_activity_activity_monitor_add_activity (self, &_tmp1_);
}

static void
break_timer_daemon_activity_activity_monitor_add_activity (BreakTimerDaemonActivityActivityMonitor* self,
                                                           BreakTimerDaemonActivityUserActivity* activity)
{
	BreakTimerDaemonActivityUserActivity _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (activity != NULL);
	_tmp0_ = *activity;
	self->priv->last_activity = _tmp0_;
	if (break_timer_daemon_activity_user_activity_is_active (activity)) {
		BreakTimerDaemonActivityUserActivity _tmp1_;
		self->priv->last_active_timestamp = break_timer_common_time_unit_get_real_time_seconds ();
		_tmp1_ = *activity;
		g_signal_emit (self, break_timer_daemon_activity_activity_monitor_signals[BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_DETECTED_ACTIVITY_SIGNAL], 0, &_tmp1_);
	} else {
		BreakTimerDaemonActivityUserActivity _tmp2_;
		_tmp2_ = *activity;
		g_signal_emit (self, break_timer_daemon_activity_activity_monitor_signals[BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_DETECTED_IDLE_SIGNAL], 0, &_tmp2_);
	}
}

/**
     * Determines user activity level since the last call to this function.
     * This function is ugly and stateful, so it shouldn't be called from
     * more than one place.
     * @returns a struct with information about the user's current activity
     */
static void
break_timer_daemon_activity_activity_monitor_collect_activity (BreakTimerDaemonActivityActivityMonitor* self,
                                                               BreakTimerDaemonActivityUserActivity* result)
{
	BreakTimerDaemonActivityUserActivity activity = {0};
	gint64 sleep_time = 0LL;
	BreakTimerDaemonActivityActivityMonitorBackend* _tmp0_;
	gint64 idle_time = 0LL;
	BreakTimerDaemonActivityActivityMonitorBackend* _tmp1_;
	gint64 time_since_active = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->backend;
	sleep_time = break_timer_daemon_activity_activity_monitor_backend_pop_sleep_time (_tmp0_);
	_tmp1_ = self->priv->backend;
	idle_time = break_timer_daemon_activity_activity_monitor_backend_get_idle_seconds (_tmp1_);
	time_since_active = (gint64) (break_timer_common_time_unit_get_real_time_seconds () - self->priv->last_active_timestamp);
	if (sleep_time > ((gint64) BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_SLEEP_TIME_CORRECTION_THRESHOLD)) {
		BreakTimerDaemonActivityUserActivity _tmp2_ = {0};
		memset (&_tmp2_, 0, sizeof (BreakTimerDaemonActivityUserActivity));
		_tmp2_.type = BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_TYPE_SLEEP;
		_tmp2_.idle_time = (gint64) 0;
		_tmp2_.time_correction = sleep_time;
		activity = _tmp2_;
	} else {
		BreakTimerCommonISessionStatus* _tmp3_;
		_tmp3_ = self->priv->session_status;
		if (break_timer_common_isession_status_is_locked (_tmp3_)) {
			BreakTimerDaemonActivityUserActivity _tmp4_ = {0};
			memset (&_tmp4_, 0, sizeof (BreakTimerDaemonActivityUserActivity));
			_tmp4_.type = BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_TYPE_LOCKED;
			_tmp4_.idle_time = idle_time;
			_tmp4_.time_correction = (gint64) 0;
			activity = _tmp4_;
		} else {
			gboolean _tmp5_ = FALSE;
			if (idle_time == ((gint64) 0)) {
				_tmp5_ = TRUE;
			} else {
				BreakTimerDaemonActivityUserActivity _tmp6_;
				_tmp6_ = self->priv->last_activity;
				_tmp5_ = idle_time < _tmp6_.idle_time;
			}
			if (_tmp5_) {
				BreakTimerDaemonActivityUserActivity _tmp7_ = {0};
				memset (&_tmp7_, 0, sizeof (BreakTimerDaemonActivityUserActivity));
				_tmp7_.type = BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_TYPE_INPUT;
				_tmp7_.idle_time = idle_time;
				_tmp7_.time_correction = (gint64) 0;
				activity = _tmp7_;
			} else {
				BreakTimerDaemonActivityUserActivity _tmp8_ = {0};
				memset (&_tmp8_, 0, sizeof (BreakTimerDaemonActivityUserActivity));
				_tmp8_.type = BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_TYPE_NONE;
				_tmp8_.idle_time = idle_time;
				_tmp8_.time_correction = (gint64) 0;
				activity = _tmp8_;
			}
		}
	}
	activity.time_since_active = time_since_active;
	*result = activity;
	return;
}

static void
break_timer_daemon_activity_activity_monitor_class_init (BreakTimerDaemonActivityActivityMonitorClass * klass,
                                                         gpointer klass_data)
{
	break_timer_daemon_activity_activity_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonActivityActivityMonitor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_activity_activity_monitor_finalize;
	break_timer_daemon_activity_activity_monitor_signals[BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_DETECTED_IDLE_SIGNAL] = g_signal_new ("detected-idle", BREAK_TIMER_DAEMON_ACTIVITY_TYPE_ACTIVITY_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, BREAK_TIMER_DAEMON_ACTIVITY_TYPE_USER_ACTIVITY);
	break_timer_daemon_activity_activity_monitor_signals[BREAK_TIMER_DAEMON_ACTIVITY_ACTIVITY_MONITOR_DETECTED_ACTIVITY_SIGNAL] = g_signal_new ("detected-activity", BREAK_TIMER_DAEMON_ACTIVITY_TYPE_ACTIVITY_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, BREAK_TIMER_DAEMON_ACTIVITY_TYPE_USER_ACTIVITY);
}

static void
break_timer_daemon_activity_activity_monitor_g_initable_interface_init (GInitableIface * iface,
                                                                        gpointer iface_data)
{
	break_timer_daemon_activity_activity_monitor_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*) (GInitable*, GCancellable*, GError**)) break_timer_daemon_activity_activity_monitor_real_init;
}

static void
break_timer_daemon_activity_activity_monitor_instance_init (BreakTimerDaemonActivityActivityMonitor * self,
                                                            gpointer klass)
{
	self->priv = break_timer_daemon_activity_activity_monitor_get_instance_private (self);
}

static void
break_timer_daemon_activity_activity_monitor_finalize (GObject * obj)
{
	BreakTimerDaemonActivityActivityMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_ACTIVITY_TYPE_ACTIVITY_MONITOR, BreakTimerDaemonActivityActivityMonitor);
	_g_object_unref0 (self->priv->poll_activity_timeout);
	_g_object_unref0 (self->priv->session_status);
	_g_object_unref0 (self->priv->backend);
	G_OBJECT_CLASS (break_timer_daemon_activity_activity_monitor_parent_class)->finalize (obj);
}

static GType
break_timer_daemon_activity_activity_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonActivityActivityMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_activity_activity_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonActivityActivityMonitor), 0, (GInstanceInitFunc) break_timer_daemon_activity_activity_monitor_instance_init, NULL };
	static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) break_timer_daemon_activity_activity_monitor_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType break_timer_daemon_activity_activity_monitor_type_id;
	break_timer_daemon_activity_activity_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerDaemonActivityActivityMonitor", &g_define_type_info, 0);
	g_type_add_interface_static (break_timer_daemon_activity_activity_monitor_type_id, g_initable_get_type (), &g_initable_info);
	BreakTimerDaemonActivityActivityMonitor_private_offset = g_type_add_instance_private (break_timer_daemon_activity_activity_monitor_type_id, sizeof (BreakTimerDaemonActivityActivityMonitorPrivate));
	return break_timer_daemon_activity_activity_monitor_type_id;
}

GType
break_timer_daemon_activity_activity_monitor_get_type (void)
{
	static volatile gsize break_timer_daemon_activity_activity_monitor_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_activity_activity_monitor_type_id__once)) {
		GType break_timer_daemon_activity_activity_monitor_type_id;
		break_timer_daemon_activity_activity_monitor_type_id = break_timer_daemon_activity_activity_monitor_get_type_once ();
		g_once_init_leave (&break_timer_daemon_activity_activity_monitor_type_id__once, break_timer_daemon_activity_activity_monitor_type_id);
	}
	return break_timer_daemon_activity_activity_monitor_type_id__once;
}

