/* Transition.c generated by valac 0.56.17, the Vala compiler
 * generated from Transition.vala, do not modify */

/* Transition.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "settings.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BREAK_TIMER_SETTINGS_WIDGETS_PROPERTY_TRANSITION_0_PROPERTY,
	BREAK_TIMER_SETTINGS_WIDGETS_PROPERTY_TRANSITION_NUM_PROPERTIES
};
static GParamSpec* break_timer_settings_widgets_property_transition_properties[BREAK_TIMER_SETTINGS_WIDGETS_PROPERTY_TRANSITION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

struct _BreakTimerSettingsWidgetsPropertyTransitionPrivate {
	GtkWidget* widget;
	gchar* property_name;
	BreakTimerSettingsWidgetsPropertyTransitionCalculateValue calculate_value;
	gpointer calculate_value_target;
	GType property_type;
	BreakTimerSettingsWidgetsPropertyTransitionEasingFunction easing_function;
	GValue start_value;
	GValue target_value;
	gint64 start_frame_time;
	gint64 end_frame_time;
	guint tick_callback_id;
};

static gint BreakTimerSettingsWidgetsPropertyTransition_private_offset;
static gpointer break_timer_settings_widgets_property_transition_parent_class = NULL;

static gdouble break_timer_settings_widgets_property_transition_easing_function_linear (BreakTimerSettingsWidgetsPropertyTransitionEasingFunction self,
                                                                                 gdouble time);
static gdouble break_timer_settings_widgets_property_transition_easing_function_ease_out_cubic (BreakTimerSettingsWidgetsPropertyTransitionEasingFunction self,
                                                                                         gdouble time);
static void break_timer_settings_widgets_property_transition_get_target_property (BreakTimerSettingsWidgetsPropertyTransition* self,
                                                                           GValue* result);
static gboolean break_timer_settings_widgets_property_transition_tick_callback (BreakTimerSettingsWidgetsPropertyTransition* self,
                                                                         GtkWidget* widget,
                                                                         GdkFrameClock* frame_clock);
static gboolean _break_timer_settings_widgets_property_transition_tick_callback_gtk_tick_callback (GtkWidget* widget,
                                                                                            GdkFrameClock* frame_clock,
                                                                                            gpointer self);
static void break_timer_settings_widgets_property_transition_set_target_property (BreakTimerSettingsWidgetsPropertyTransition* self,
                                                                           GValue* target_value);
static gboolean break_timer_settings_widgets_property_transition_set_frame (BreakTimerSettingsWidgetsPropertyTransition* self,
                                                                     gint64 frame_time);
static void break_timer_settings_widgets_property_transition_finalize (GObject * obj);
static GType break_timer_settings_widgets_property_transition_get_type_once (void);

static inline gpointer
break_timer_settings_widgets_property_transition_get_instance_private (BreakTimerSettingsWidgetsPropertyTransition* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerSettingsWidgetsPropertyTransition_private_offset);
}

gdouble
break_timer_settings_widgets_property_transition_easing_function_calculate (BreakTimerSettingsWidgetsPropertyTransitionEasingFunction self,
                                                                            gdouble time)
{
	gdouble result;
	switch (self) {
		case BREAK_TIMER_SETTINGS_WIDGETS_PROPERTY_TRANSITION_EASING_FUNCTION_LINEAR:
		{
			result = break_timer_settings_widgets_property_transition_easing_function_linear (self, time);
			return result;
		}
		case BREAK_TIMER_SETTINGS_WIDGETS_PROPERTY_TRANSITION_EASING_FUNCTION_EASE_OUT_CUBIC:
		{
			result = break_timer_settings_widgets_property_transition_easing_function_ease_out_cubic (self, time);
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static gdouble
break_timer_settings_widgets_property_transition_easing_function_linear (BreakTimerSettingsWidgetsPropertyTransitionEasingFunction self,
                                                                         gdouble time)
{
	gdouble result;
	result = time;
	return result;
}

static gdouble
break_timer_settings_widgets_property_transition_easing_function_ease_out_cubic (BreakTimerSettingsWidgetsPropertyTransitionEasingFunction self,
                                                                                 gdouble time)
{
	gdouble ease = 0.0;
	gdouble result;
	ease = time - 1;
	result = ((ease * ease) * ease) + 1;
	return result;
}

static GType
break_timer_settings_widgets_property_transition_easing_function_get_type_once (void)
{
	static const GEnumValue values[] = {{BREAK_TIMER_SETTINGS_WIDGETS_PROPERTY_TRANSITION_EASING_FUNCTION_LINEAR, "BREAK_TIMER_SETTINGS_WIDGETS_PROPERTY_TRANSITION_EASING_FUNCTION_LINEAR", "linear"}, {BREAK_TIMER_SETTINGS_WIDGETS_PROPERTY_TRANSITION_EASING_FUNCTION_EASE_OUT_CUBIC, "BREAK_TIMER_SETTINGS_WIDGETS_PROPERTY_TRANSITION_EASING_FUNCTION_EASE_OUT_CUBIC", "ease-out-cubic"}, {0, NULL, NULL}};
	GType break_timer_settings_widgets_property_transition_easing_function_type_id;
	break_timer_settings_widgets_property_transition_easing_function_type_id = g_enum_register_static ("BreakTimerSettingsWidgetsPropertyTransitionEasingFunction", values);
	return break_timer_settings_widgets_property_transition_easing_function_type_id;
}

GType
break_timer_settings_widgets_property_transition_easing_function_get_type (void)
{
	static volatile gsize break_timer_settings_widgets_property_transition_easing_function_type_id__once = 0;
	if (g_once_init_enter (&break_timer_settings_widgets_property_transition_easing_function_type_id__once)) {
		GType break_timer_settings_widgets_property_transition_easing_function_type_id;
		break_timer_settings_widgets_property_transition_easing_function_type_id = break_timer_settings_widgets_property_transition_easing_function_get_type_once ();
		g_once_init_leave (&break_timer_settings_widgets_property_transition_easing_function_type_id__once, break_timer_settings_widgets_property_transition_easing_function_type_id);
	}
	return break_timer_settings_widgets_property_transition_easing_function_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_param_spec_ref0 (gpointer self)
{
	return self ? g_param_spec_ref (self) : NULL;
}

BreakTimerSettingsWidgetsPropertyTransition*
break_timer_settings_widgets_property_transition_construct (GType object_type,
                                                            GtkWidget* widget,
                                                            const gchar* property_name,
                                                            BreakTimerSettingsWidgetsPropertyTransitionCalculateValue calculate_value,
                                                            gpointer calculate_value_target)
{
	BreakTimerSettingsWidgetsPropertyTransition * self = NULL;
	GtkWidget* _tmp0_;
	gchar* _tmp1_;
	GParamSpec* property_paramspec = NULL;
	GObjectClass* _tmp2_;
	GParamSpec* _tmp3_;
	GParamSpec* _tmp4_;
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (property_name != NULL, NULL);
	self = (BreakTimerSettingsWidgetsPropertyTransition*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp0_;
	_tmp1_ = g_strdup (property_name);
	_g_free0 (self->priv->property_name);
	self->priv->property_name = _tmp1_;
	self->priv->calculate_value = calculate_value;
	self->priv->calculate_value_target = calculate_value_target;
	_tmp2_ = G_OBJECT_GET_CLASS ((GObject*) widget);
	_tmp3_ = g_object_class_find_property (_tmp2_, property_name);
	_tmp4_ = _g_param_spec_ref0 (_tmp3_);
	property_paramspec = _tmp4_;
	g_assert_nonnull (property_paramspec);
	self->priv->property_type = property_paramspec->value_type;
	self->priv->tick_callback_id = (guint) 0;
	_g_param_spec_unref0 (property_paramspec);
	return self;
}

BreakTimerSettingsWidgetsPropertyTransition*
break_timer_settings_widgets_property_transition_new (GtkWidget* widget,
                                                      const gchar* property_name,
                                                      BreakTimerSettingsWidgetsPropertyTransitionCalculateValue calculate_value,
                                                      gpointer calculate_value_target)
{
	return break_timer_settings_widgets_property_transition_construct (BREAK_TIMER_SETTINGS_WIDGETS_TYPE_PROPERTY_TRANSITION, widget, property_name, calculate_value, calculate_value_target);
}

static gboolean
_break_timer_settings_widgets_property_transition_tick_callback_gtk_tick_callback (GtkWidget* widget,
                                                                                   GdkFrameClock* frame_clock,
                                                                                   gpointer self)
{
	gboolean result;
	result = break_timer_settings_widgets_property_transition_tick_callback ((BreakTimerSettingsWidgetsPropertyTransition*) self, widget, frame_clock);
	return result;
}

gboolean
break_timer_settings_widgets_property_transition_start (BreakTimerSettingsWidgetsPropertyTransition* self,
                                                        GValue* target_value,
                                                        BreakTimerSettingsWidgetsPropertyTransitionEasingFunction easing_function,
                                                        gint64 duration_microseconds)
{
	GValue _tmp0_ = {0};
	GValue _tmp1_;
	GdkFrameClock* frame_clock = NULL;
	GtkWidget* _tmp2_;
	GdkFrameClock* _tmp3_;
	GdkFrameClock* _tmp4_;
	GdkFrameClock* _tmp5_;
	GValue _tmp7_;
	GValue _tmp8_;
	GValue _tmp9_ = {0};
	GdkFrameClock* _tmp10_;
	GValue _tmp11_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target_value != NULL, FALSE);
	break_timer_settings_widgets_property_transition_get_target_property (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	g_warn_if_fail (G_VALUE_TYPE (target_value) == G_VALUE_TYPE (&_tmp1_));
	G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL;
	_tmp2_ = self->priv->widget;
	_tmp3_ = gtk_widget_get_frame_clock (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	frame_clock = _tmp4_;
	_tmp5_ = frame_clock;
	if (_tmp5_ == NULL) {
		GValue _tmp6_;
		_tmp6_ = *target_value;
		result = break_timer_settings_widgets_property_transition_skip (self, &_tmp6_);
		_g_object_unref0 (frame_clock);
		return result;
	}
	_tmp7_ = *target_value;
	_tmp8_ = _tmp7_;
	if (G_IS_VALUE (&_tmp8_)) {
		g_value_init (&_tmp9_, G_VALUE_TYPE (&_tmp8_));
		g_value_copy (&_tmp8_, &_tmp9_);
	} else {
		_tmp9_ = _tmp8_;
	}
	G_IS_VALUE (&self->priv->target_value) ? (g_value_unset (&self->priv->target_value), NULL) : NULL;
	self->priv->target_value = _tmp9_;
	self->priv->easing_function = easing_function;
	_tmp10_ = frame_clock;
	self->priv->start_frame_time = gdk_frame_clock_get_frame_time (_tmp10_);
	self->priv->end_frame_time = self->priv->start_frame_time + duration_microseconds;
	break_timer_settings_widgets_property_transition_get_target_property (self, &_tmp11_);
	G_IS_VALUE (&self->priv->start_value) ? (g_value_unset (&self->priv->start_value), NULL) : NULL;
	self->priv->start_value = _tmp11_;
	if (self->priv->tick_callback_id == ((guint) 0)) {
		GtkWidget* _tmp12_;
		_tmp12_ = self->priv->widget;
		self->priv->tick_callback_id = gtk_widget_add_tick_callback (_tmp12_, _break_timer_settings_widgets_property_transition_tick_callback_gtk_tick_callback, g_object_ref (self), g_object_unref);
	}
	result = TRUE;
	_g_object_unref0 (frame_clock);
	return result;
}

gboolean
break_timer_settings_widgets_property_transition_skip (BreakTimerSettingsWidgetsPropertyTransition* self,
                                                       GValue* target_value)
{
	GValue _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (target_value != NULL, FALSE);
	_tmp0_ = *target_value;
	break_timer_settings_widgets_property_transition_set_target_property (self, &_tmp0_);
	result = TRUE;
	return result;
}

static void
break_timer_settings_widgets_property_transition_get_target_property (BreakTimerSettingsWidgetsPropertyTransition* self,
                                                                      GValue* result)
{
	GValue _result_ = {0};
	GValue _tmp0_ = {0};
	GtkWidget* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_value_init (&_tmp0_, self->priv->property_type);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->widget;
	_tmp2_ = self->priv->property_name;
	g_object_get_property ((GObject*) _tmp1_, _tmp2_, &_result_);
	*result = _result_;
	return;
}

static void
break_timer_settings_widgets_property_transition_set_target_property (BreakTimerSettingsWidgetsPropertyTransition* self,
                                                                      GValue* target_value)
{
	GtkWidget* _tmp0_;
	const gchar* _tmp1_;
	GValue _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target_value != NULL);
	_tmp0_ = self->priv->widget;
	_tmp1_ = self->priv->property_name;
	_tmp2_ = *target_value;
	g_object_set_property ((GObject*) _tmp0_, _tmp1_, &_tmp2_);
}

static gboolean
break_timer_settings_widgets_property_transition_tick_callback (BreakTimerSettingsWidgetsPropertyTransition* self,
                                                                GtkWidget* widget,
                                                                GdkFrameClock* frame_clock)
{
	gint64 now = 0LL;
	gboolean is_complete = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame_clock != NULL, FALSE);
	now = gdk_frame_clock_get_frame_time (frame_clock);
	is_complete = break_timer_settings_widgets_property_transition_set_frame (self, now);
	if (is_complete) {
		self->priv->tick_callback_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	} else {
		result = G_SOURCE_CONTINUE;
		return result;
	}
}

static gboolean
break_timer_settings_widgets_property_transition_set_frame (BreakTimerSettingsWidgetsPropertyTransition* self,
                                                            gint64 frame_time)
{
	gboolean is_complete = FALSE;
	gint64 time_delta = 0LL;
	gint64 time_total = 0LL;
	gdouble ease = 0.0;
	BreakTimerSettingsWidgetsPropertyTransitionCalculateValue _tmp0_;
	gpointer _tmp0__target;
	GValue _tmp1_;
	GValue _tmp2_;
	GValue _tmp3_ = {0};
	GValue _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	is_complete = frame_time >= self->priv->end_frame_time;
	if (is_complete) {
		frame_time = self->priv->end_frame_time;
	}
	time_delta = frame_time - self->priv->start_frame_time;
	time_total = self->priv->end_frame_time - self->priv->start_frame_time;
	ease = break_timer_settings_widgets_property_transition_easing_function_calculate (self->priv->easing_function, ((gdouble) time_delta) / time_total);
	_tmp0_ = self->priv->calculate_value;
	_tmp0__target = self->priv->calculate_value_target;
	_tmp1_ = self->priv->start_value;
	_tmp2_ = self->priv->target_value;
	_tmp0_ (&_tmp1_, &_tmp2_, ease, &_tmp3_, _tmp0__target);
	_tmp4_ = _tmp3_;
	break_timer_settings_widgets_property_transition_set_target_property (self, &_tmp4_);
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	result = is_complete;
	return result;
}

void
break_timer_settings_widgets_property_transition_calculate_value_double (GValue* start_value,
                                                                         GValue* end_value,
                                                                         gdouble ease,
                                                                         GValue* result)
{
	GValue _tmp0_ = {0};
	g_return_if_fail (start_value != NULL);
	g_return_if_fail (end_value != NULL);
	g_value_init (&_tmp0_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp0_, g_value_get_double (start_value) + (ease * (g_value_get_double (end_value) - g_value_get_double (start_value))));
	*result = _tmp0_;
	return;
}

static void
break_timer_settings_widgets_property_transition_class_init (BreakTimerSettingsWidgetsPropertyTransitionClass * klass,
                                                             gpointer klass_data)
{
	break_timer_settings_widgets_property_transition_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerSettingsWidgetsPropertyTransition_private_offset);
	G_OBJECT_CLASS (klass)->finalize = break_timer_settings_widgets_property_transition_finalize;
}

static void
break_timer_settings_widgets_property_transition_instance_init (BreakTimerSettingsWidgetsPropertyTransition * self,
                                                                gpointer klass)
{
	self->priv = break_timer_settings_widgets_property_transition_get_instance_private (self);
}

static void
break_timer_settings_widgets_property_transition_finalize (GObject * obj)
{
	BreakTimerSettingsWidgetsPropertyTransition * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_SETTINGS_WIDGETS_TYPE_PROPERTY_TRANSITION, BreakTimerSettingsWidgetsPropertyTransition);
	_g_object_unref0 (self->priv->widget);
	_g_free0 (self->priv->property_name);
	G_IS_VALUE (&self->priv->start_value) ? (g_value_unset (&self->priv->start_value), NULL) : NULL;
	G_IS_VALUE (&self->priv->target_value) ? (g_value_unset (&self->priv->target_value), NULL) : NULL;
	G_OBJECT_CLASS (break_timer_settings_widgets_property_transition_parent_class)->finalize (obj);
}

/**
 * Transition utility designed for Gtk.Widget's tick callback mechanism. Create
 * an instance of this class with a particular output property for intermediate
 * states, as well as a function to compute the value of that property given a
 * start and end value and a easing ratio between the two.
 */
static GType
break_timer_settings_widgets_property_transition_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerSettingsWidgetsPropertyTransitionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_settings_widgets_property_transition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerSettingsWidgetsPropertyTransition), 0, (GInstanceInitFunc) break_timer_settings_widgets_property_transition_instance_init, NULL };
	GType break_timer_settings_widgets_property_transition_type_id;
	break_timer_settings_widgets_property_transition_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerSettingsWidgetsPropertyTransition", &g_define_type_info, 0);
	BreakTimerSettingsWidgetsPropertyTransition_private_offset = g_type_add_instance_private (break_timer_settings_widgets_property_transition_type_id, sizeof (BreakTimerSettingsWidgetsPropertyTransitionPrivate));
	return break_timer_settings_widgets_property_transition_type_id;
}

GType
break_timer_settings_widgets_property_transition_get_type (void)
{
	static volatile gsize break_timer_settings_widgets_property_transition_type_id__once = 0;
	if (g_once_init_enter (&break_timer_settings_widgets_property_transition_type_id__once)) {
		GType break_timer_settings_widgets_property_transition_type_id;
		break_timer_settings_widgets_property_transition_type_id = break_timer_settings_widgets_property_transition_get_type_once ();
		g_once_init_leave (&break_timer_settings_widgets_property_transition_type_id__once, break_timer_settings_widgets_property_transition_type_id);
	}
	return break_timer_settings_widgets_property_transition_type_id__once;
}

