/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "calls-call-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_tone,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Calls.Call
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CallsDBusCallsCall
 * @title: CallsDBusCallsCall
 * @short_description: Generated C code for the org.gnome.Calls.Call D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Calls-Call.top_of_page">org.gnome.Calls.Call</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Calls.Call ---- */

static const _ExtendedGDBusMethodInfo _calls_dbus_calls_call_method_info_accept =
{
  {
    -1,
    (gchar *) "Accept",
    NULL,
    NULL,
    NULL
  },
  "handle-accept",
  FALSE
};

static const _ExtendedGDBusMethodInfo _calls_dbus_calls_call_method_info_hangup =
{
  {
    -1,
    (gchar *) "Hangup",
    NULL,
    NULL,
    NULL
  },
  "handle-hangup",
  FALSE
};

static const _ExtendedGDBusArgInfo _calls_dbus_calls_call_method_info_send_dtmf_IN_ARG_tone =
{
  {
    -1,
    (gchar *) "tone",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _calls_dbus_calls_call_method_info_send_dtmf_IN_ARG_pointers[] =
{
  &_calls_dbus_calls_call_method_info_send_dtmf_IN_ARG_tone.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _calls_dbus_calls_call_method_info_send_dtmf =
{
  {
    -1,
    (gchar *) "SendDtmf",
    (GDBusArgInfo **) &_calls_dbus_calls_call_method_info_send_dtmf_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-send-dtmf",
  FALSE
};

static const _ExtendedGDBusMethodInfo _calls_dbus_calls_call_method_info_silence =
{
  {
    -1,
    (gchar *) "Silence",
    NULL,
    NULL,
    NULL
  },
  "handle-silence",
  FALSE
};

static const GDBusMethodInfo * const _calls_dbus_calls_call_method_info_pointers[] =
{
  &_calls_dbus_calls_call_method_info_accept.parent_struct,
  &_calls_dbus_calls_call_method_info_hangup.parent_struct,
  &_calls_dbus_calls_call_method_info_send_dtmf.parent_struct,
  &_calls_dbus_calls_call_method_info_silence.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _calls_dbus_calls_call_property_info_inbound =
{
  {
    -1,
    (gchar *) "Inbound",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "inbound",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _calls_dbus_calls_call_property_info_state =
{
  {
    -1,
    (gchar *) "State",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "state",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _calls_dbus_calls_call_property_info_id =
{
  {
    -1,
    (gchar *) "Id",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "id",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _calls_dbus_calls_call_property_info_display_name =
{
  {
    -1,
    (gchar *) "DisplayName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "display-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _calls_dbus_calls_call_property_info_image_path =
{
  {
    -1,
    (gchar *) "ImagePath",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "image-path",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _calls_dbus_calls_call_property_info_protocol =
{
  {
    -1,
    (gchar *) "Protocol",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "protocol",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _calls_dbus_calls_call_property_info_encrypted =
{
  {
    -1,
    (gchar *) "Encrypted",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "encrypted",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _calls_dbus_calls_call_property_info_can_dtmf =
{
  {
    -1,
    (gchar *) "CanDtmf",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-dtmf",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _calls_dbus_calls_call_property_info_hints =
{
  {
    -1,
    (gchar *) "Hints",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "hints",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _calls_dbus_calls_call_property_info_pointers[] =
{
  &_calls_dbus_calls_call_property_info_inbound.parent_struct,
  &_calls_dbus_calls_call_property_info_state.parent_struct,
  &_calls_dbus_calls_call_property_info_id.parent_struct,
  &_calls_dbus_calls_call_property_info_display_name.parent_struct,
  &_calls_dbus_calls_call_property_info_image_path.parent_struct,
  &_calls_dbus_calls_call_property_info_protocol.parent_struct,
  &_calls_dbus_calls_call_property_info_encrypted.parent_struct,
  &_calls_dbus_calls_call_property_info_can_dtmf.parent_struct,
  &_calls_dbus_calls_call_property_info_hints.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _calls_dbus_calls_call_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Calls.Call",
    (GDBusMethodInfo **) &_calls_dbus_calls_call_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_calls_dbus_calls_call_property_info_pointers,
    NULL
  },
  "calls-call",
};


/**
 * calls_dbus_calls_call_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Calls-Call.top_of_page">org.gnome.Calls.Call</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
calls_dbus_calls_call_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_calls_dbus_calls_call_interface_info.parent_struct;
}

/**
 * calls_dbus_calls_call_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #CallsDBusCallsCall interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
calls_dbus_calls_call_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "inbound");
  g_object_class_override_property (klass, property_id_begin++, "state");
  g_object_class_override_property (klass, property_id_begin++, "id");
  g_object_class_override_property (klass, property_id_begin++, "display-name");
  g_object_class_override_property (klass, property_id_begin++, "image-path");
  g_object_class_override_property (klass, property_id_begin++, "protocol");
  g_object_class_override_property (klass, property_id_begin++, "encrypted");
  g_object_class_override_property (klass, property_id_begin++, "can-dtmf");
  g_object_class_override_property (klass, property_id_begin++, "hints");
  return property_id_begin - 1;
}


inline static void
calls_dbus_calls_call_method_marshal_accept (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
calls_dbus_calls_call_method_marshal_hangup (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
calls_dbus_calls_call_method_marshal_send_dtmf (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
calls_dbus_calls_call_method_marshal_silence (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * CallsDBusCallsCall:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-Call.top_of_page">org.gnome.Calls.Call</link>.
 */

/**
 * CallsDBusCallsCallIface:
 * @parent_iface: The parent interface.
 * @handle_accept: Handler for the #CallsDBusCallsCall::handle-accept signal.
 * @handle_hangup: Handler for the #CallsDBusCallsCall::handle-hangup signal.
 * @handle_send_dtmf: Handler for the #CallsDBusCallsCall::handle-send-dtmf signal.
 * @handle_silence: Handler for the #CallsDBusCallsCall::handle-silence signal.
 * @get_can_dtmf: Getter for the #CallsDBusCallsCall:can-dtmf property.
 * @get_display_name: Getter for the #CallsDBusCallsCall:display-name property.
 * @get_encrypted: Getter for the #CallsDBusCallsCall:encrypted property.
 * @get_hints: Getter for the #CallsDBusCallsCall:hints property.
 * @get_id: Getter for the #CallsDBusCallsCall:id property.
 * @get_image_path: Getter for the #CallsDBusCallsCall:image-path property.
 * @get_inbound: Getter for the #CallsDBusCallsCall:inbound property.
 * @get_protocol: Getter for the #CallsDBusCallsCall:protocol property.
 * @get_state: Getter for the #CallsDBusCallsCall:state property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-Call.top_of_page">org.gnome.Calls.Call</link>.
 */

typedef CallsDBusCallsCallIface CallsDBusCallsCallInterface;
G_DEFINE_INTERFACE (CallsDBusCallsCall, calls_dbus_calls_call, G_TYPE_OBJECT)

static void
calls_dbus_calls_call_default_init (CallsDBusCallsCallIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * CallsDBusCallsCall::handle-accept:
   * @object: A #CallsDBusCallsCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Calls-Call.Accept">Accept()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call calls_dbus_calls_call_complete_accept() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-accept",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CallsDBusCallsCallIface, handle_accept),
    g_signal_accumulator_true_handled,
    NULL,
      calls_dbus_calls_call_method_marshal_accept,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * CallsDBusCallsCall::handle-hangup:
   * @object: A #CallsDBusCallsCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Calls-Call.Hangup">Hangup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call calls_dbus_calls_call_complete_hangup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hangup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CallsDBusCallsCallIface, handle_hangup),
    g_signal_accumulator_true_handled,
    NULL,
      calls_dbus_calls_call_method_marshal_hangup,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * CallsDBusCallsCall::handle-send-dtmf:
   * @object: A #CallsDBusCallsCall.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_tone: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Calls-Call.SendDtmf">SendDtmf()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call calls_dbus_calls_call_complete_send_dtmf() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-send-dtmf",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CallsDBusCallsCallIface, handle_send_dtmf),
    g_signal_accumulator_true_handled,
    NULL,
      calls_dbus_calls_call_method_marshal_send_dtmf,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * CallsDBusCallsCall::handle-silence:
   * @object: A #CallsDBusCallsCall.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Calls-Call.Silence">Silence()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call calls_dbus_calls_call_complete_silence() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-silence",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (CallsDBusCallsCallIface, handle_silence),
    g_signal_accumulator_true_handled,
    NULL,
      calls_dbus_calls_call_method_marshal_silence,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * CallsDBusCallsCall:inbound:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Calls-Call.Inbound">"Inbound"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("inbound", "Inbound", "Inbound", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CallsDBusCallsCall:state:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Calls-Call.State">"State"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("state", "State", "State", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CallsDBusCallsCall:id:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Calls-Call.Id">"Id"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("id", "Id", "Id", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CallsDBusCallsCall:display-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Calls-Call.DisplayName">"DisplayName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("display-name", "DisplayName", "DisplayName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CallsDBusCallsCall:image-path:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Calls-Call.ImagePath">"ImagePath"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("image-path", "ImagePath", "ImagePath", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CallsDBusCallsCall:protocol:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Calls-Call.Protocol">"Protocol"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("protocol", "Protocol", "Protocol", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CallsDBusCallsCall:encrypted:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Calls-Call.Encrypted">"Encrypted"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("encrypted", "Encrypted", "Encrypted", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CallsDBusCallsCall:can-dtmf:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Calls-Call.CanDtmf">"CanDtmf"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-dtmf", "CanDtmf", "CanDtmf", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * CallsDBusCallsCall:hints:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Calls-Call.Hints">"Hints"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("hints", "Hints", "Hints", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * calls_dbus_calls_call_get_inbound: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Calls-Call.Inbound">"Inbound"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
calls_dbus_calls_call_get_inbound (CallsDBusCallsCall *object)
{
  g_return_val_if_fail (CALLS_DBUS_IS_CALLS_CALL (object), FALSE);

  return CALLS_DBUS_CALLS_CALL_GET_IFACE (object)->get_inbound (object);
}

/**
 * calls_dbus_calls_call_set_inbound: (skip)
 * @object: A #CallsDBusCallsCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Calls-Call.Inbound">"Inbound"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
calls_dbus_calls_call_set_inbound (CallsDBusCallsCall *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "inbound", value, NULL);
}

/**
 * calls_dbus_calls_call_get_state: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Calls-Call.State">"State"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
calls_dbus_calls_call_get_state (CallsDBusCallsCall *object)
{
  g_return_val_if_fail (CALLS_DBUS_IS_CALLS_CALL (object), 0);

  return CALLS_DBUS_CALLS_CALL_GET_IFACE (object)->get_state (object);
}

/**
 * calls_dbus_calls_call_set_state: (skip)
 * @object: A #CallsDBusCallsCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Calls-Call.State">"State"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
calls_dbus_calls_call_set_state (CallsDBusCallsCall *object, guint value)
{
  g_object_set (G_OBJECT (object), "state", value, NULL);
}

/**
 * calls_dbus_calls_call_get_id: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Calls-Call.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use calls_dbus_calls_call_dup_id() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
calls_dbus_calls_call_get_id (CallsDBusCallsCall *object)
{
  g_return_val_if_fail (CALLS_DBUS_IS_CALLS_CALL (object), NULL);

  return CALLS_DBUS_CALLS_CALL_GET_IFACE (object)->get_id (object);
}

/**
 * calls_dbus_calls_call_dup_id: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Calls-Call.Id">"Id"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
calls_dbus_calls_call_dup_id (CallsDBusCallsCall *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "id", &value, NULL);
  return value;
}

/**
 * calls_dbus_calls_call_set_id: (skip)
 * @object: A #CallsDBusCallsCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Calls-Call.Id">"Id"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
calls_dbus_calls_call_set_id (CallsDBusCallsCall *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "id", value, NULL);
}

/**
 * calls_dbus_calls_call_get_display_name: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Calls-Call.DisplayName">"DisplayName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use calls_dbus_calls_call_dup_display_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
calls_dbus_calls_call_get_display_name (CallsDBusCallsCall *object)
{
  g_return_val_if_fail (CALLS_DBUS_IS_CALLS_CALL (object), NULL);

  return CALLS_DBUS_CALLS_CALL_GET_IFACE (object)->get_display_name (object);
}

/**
 * calls_dbus_calls_call_dup_display_name: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Calls-Call.DisplayName">"DisplayName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
calls_dbus_calls_call_dup_display_name (CallsDBusCallsCall *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "display-name", &value, NULL);
  return value;
}

/**
 * calls_dbus_calls_call_set_display_name: (skip)
 * @object: A #CallsDBusCallsCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Calls-Call.DisplayName">"DisplayName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
calls_dbus_calls_call_set_display_name (CallsDBusCallsCall *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "display-name", value, NULL);
}

/**
 * calls_dbus_calls_call_get_image_path: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Calls-Call.ImagePath">"ImagePath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use calls_dbus_calls_call_dup_image_path() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
calls_dbus_calls_call_get_image_path (CallsDBusCallsCall *object)
{
  g_return_val_if_fail (CALLS_DBUS_IS_CALLS_CALL (object), NULL);

  return CALLS_DBUS_CALLS_CALL_GET_IFACE (object)->get_image_path (object);
}

/**
 * calls_dbus_calls_call_dup_image_path: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Calls-Call.ImagePath">"ImagePath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
calls_dbus_calls_call_dup_image_path (CallsDBusCallsCall *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "image-path", &value, NULL);
  return value;
}

/**
 * calls_dbus_calls_call_set_image_path: (skip)
 * @object: A #CallsDBusCallsCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Calls-Call.ImagePath">"ImagePath"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
calls_dbus_calls_call_set_image_path (CallsDBusCallsCall *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "image-path", value, NULL);
}

/**
 * calls_dbus_calls_call_get_protocol: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Calls-Call.Protocol">"Protocol"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use calls_dbus_calls_call_dup_protocol() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
calls_dbus_calls_call_get_protocol (CallsDBusCallsCall *object)
{
  g_return_val_if_fail (CALLS_DBUS_IS_CALLS_CALL (object), NULL);

  return CALLS_DBUS_CALLS_CALL_GET_IFACE (object)->get_protocol (object);
}

/**
 * calls_dbus_calls_call_dup_protocol: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Calls-Call.Protocol">"Protocol"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
calls_dbus_calls_call_dup_protocol (CallsDBusCallsCall *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "protocol", &value, NULL);
  return value;
}

/**
 * calls_dbus_calls_call_set_protocol: (skip)
 * @object: A #CallsDBusCallsCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Calls-Call.Protocol">"Protocol"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
calls_dbus_calls_call_set_protocol (CallsDBusCallsCall *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "protocol", value, NULL);
}

/**
 * calls_dbus_calls_call_get_encrypted: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Calls-Call.Encrypted">"Encrypted"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
calls_dbus_calls_call_get_encrypted (CallsDBusCallsCall *object)
{
  g_return_val_if_fail (CALLS_DBUS_IS_CALLS_CALL (object), FALSE);

  return CALLS_DBUS_CALLS_CALL_GET_IFACE (object)->get_encrypted (object);
}

/**
 * calls_dbus_calls_call_set_encrypted: (skip)
 * @object: A #CallsDBusCallsCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Calls-Call.Encrypted">"Encrypted"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
calls_dbus_calls_call_set_encrypted (CallsDBusCallsCall *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "encrypted", value, NULL);
}

/**
 * calls_dbus_calls_call_get_can_dtmf: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Calls-Call.CanDtmf">"CanDtmf"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
calls_dbus_calls_call_get_can_dtmf (CallsDBusCallsCall *object)
{
  g_return_val_if_fail (CALLS_DBUS_IS_CALLS_CALL (object), FALSE);

  return CALLS_DBUS_CALLS_CALL_GET_IFACE (object)->get_can_dtmf (object);
}

/**
 * calls_dbus_calls_call_set_can_dtmf: (skip)
 * @object: A #CallsDBusCallsCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Calls-Call.CanDtmf">"CanDtmf"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
calls_dbus_calls_call_set_can_dtmf (CallsDBusCallsCall *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-dtmf", value, NULL);
}

/**
 * calls_dbus_calls_call_get_hints: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Calls-Call.Hints">"Hints"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use calls_dbus_calls_call_dup_hints() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
calls_dbus_calls_call_get_hints (CallsDBusCallsCall *object)
{
  g_return_val_if_fail (CALLS_DBUS_IS_CALLS_CALL (object), NULL);

  return CALLS_DBUS_CALLS_CALL_GET_IFACE (object)->get_hints (object);
}

/**
 * calls_dbus_calls_call_dup_hints: (skip)
 * @object: A #CallsDBusCallsCall.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Calls-Call.Hints">"Hints"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
calls_dbus_calls_call_dup_hints (CallsDBusCallsCall *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "hints", &value, NULL);
  return value;
}

/**
 * calls_dbus_calls_call_set_hints: (skip)
 * @object: A #CallsDBusCallsCall.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Calls-Call.Hints">"Hints"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
calls_dbus_calls_call_set_hints (CallsDBusCallsCall *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "hints", value, NULL);
}

/**
 * calls_dbus_calls_call_call_accept:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-Call.Accept">Accept()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_calls_call_call_accept_finish() to get the result of the operation.
 *
 * See calls_dbus_calls_call_call_accept_sync() for the synchronous, blocking version of this method.
 */
void
calls_dbus_calls_call_call_accept (
    CallsDBusCallsCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Accept",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * calls_dbus_calls_call_call_accept_finish:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_calls_call_call_accept().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with calls_dbus_calls_call_call_accept().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_calls_call_call_accept_finish (
    CallsDBusCallsCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_calls_call_call_accept_sync:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-Call.Accept">Accept()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_calls_call_call_accept() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_calls_call_call_accept_sync (
    CallsDBusCallsCall *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Accept",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_calls_call_call_hangup:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-Call.Hangup">Hangup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_calls_call_call_hangup_finish() to get the result of the operation.
 *
 * See calls_dbus_calls_call_call_hangup_sync() for the synchronous, blocking version of this method.
 */
void
calls_dbus_calls_call_call_hangup (
    CallsDBusCallsCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Hangup",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * calls_dbus_calls_call_call_hangup_finish:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_calls_call_call_hangup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with calls_dbus_calls_call_call_hangup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_calls_call_call_hangup_finish (
    CallsDBusCallsCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_calls_call_call_hangup_sync:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-Call.Hangup">Hangup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_calls_call_call_hangup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_calls_call_call_hangup_sync (
    CallsDBusCallsCall *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Hangup",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_calls_call_call_send_dtmf:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @arg_tone: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-Call.SendDtmf">SendDtmf()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_calls_call_call_send_dtmf_finish() to get the result of the operation.
 *
 * See calls_dbus_calls_call_call_send_dtmf_sync() for the synchronous, blocking version of this method.
 */
void
calls_dbus_calls_call_call_send_dtmf (
    CallsDBusCallsCall *proxy,
    const gchar *arg_tone,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SendDtmf",
    g_variant_new ("(s)",
                   arg_tone),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * calls_dbus_calls_call_call_send_dtmf_finish:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_calls_call_call_send_dtmf().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with calls_dbus_calls_call_call_send_dtmf().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_calls_call_call_send_dtmf_finish (
    CallsDBusCallsCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_calls_call_call_send_dtmf_sync:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @arg_tone: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-Call.SendDtmf">SendDtmf()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_calls_call_call_send_dtmf() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_calls_call_call_send_dtmf_sync (
    CallsDBusCallsCall *proxy,
    const gchar *arg_tone,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SendDtmf",
    g_variant_new ("(s)",
                   arg_tone),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_calls_call_call_silence:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-Call.Silence">Silence()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_calls_call_call_silence_finish() to get the result of the operation.
 *
 * See calls_dbus_calls_call_call_silence_sync() for the synchronous, blocking version of this method.
 */
void
calls_dbus_calls_call_call_silence (
    CallsDBusCallsCall *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Silence",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * calls_dbus_calls_call_call_silence_finish:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_calls_call_call_silence().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with calls_dbus_calls_call_call_silence().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_calls_call_call_silence_finish (
    CallsDBusCallsCall *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_calls_call_call_silence_sync:
 * @proxy: A #CallsDBusCallsCallProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Calls-Call.Silence">Silence()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_calls_call_call_silence() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
calls_dbus_calls_call_call_silence_sync (
    CallsDBusCallsCall *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Silence",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * calls_dbus_calls_call_complete_accept:
 * @object: A #CallsDBusCallsCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Calls-Call.Accept">Accept()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
calls_dbus_calls_call_complete_accept (
    CallsDBusCallsCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * calls_dbus_calls_call_complete_hangup:
 * @object: A #CallsDBusCallsCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Calls-Call.Hangup">Hangup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
calls_dbus_calls_call_complete_hangup (
    CallsDBusCallsCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * calls_dbus_calls_call_complete_send_dtmf:
 * @object: A #CallsDBusCallsCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Calls-Call.SendDtmf">SendDtmf()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
calls_dbus_calls_call_complete_send_dtmf (
    CallsDBusCallsCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * calls_dbus_calls_call_complete_silence:
 * @object: A #CallsDBusCallsCall.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Calls-Call.Silence">Silence()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
calls_dbus_calls_call_complete_silence (
    CallsDBusCallsCall *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * CallsDBusCallsCallProxy:
 *
 * The #CallsDBusCallsCallProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CallsDBusCallsCallProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CallsDBusCallsCallProxy.
 */

struct _CallsDBusCallsCallProxyPrivate
{
  GData *qdata;
};

static void calls_dbus_calls_call_proxy_iface_init (CallsDBusCallsCallIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CallsDBusCallsCallProxy, calls_dbus_calls_call_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (CallsDBusCallsCallProxy)
                         G_IMPLEMENT_INTERFACE (CALLS_DBUS_TYPE_CALLS_CALL, calls_dbus_calls_call_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CallsDBusCallsCallProxy, calls_dbus_calls_call_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CALLS_DBUS_TYPE_CALLS_CALL, calls_dbus_calls_call_proxy_iface_init))

#endif
static void
calls_dbus_calls_call_proxy_finalize (GObject *object)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (calls_dbus_calls_call_proxy_parent_class)->finalize (object);
}

static void
calls_dbus_calls_call_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _calls_dbus_calls_call_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
calls_dbus_calls_call_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Calls.Call: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
calls_dbus_calls_call_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _calls_dbus_calls_call_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Calls.Call", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) calls_dbus_calls_call_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
calls_dbus_calls_call_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_calls_dbus_calls_call_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CALLS_DBUS_TYPE_CALLS_CALL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CALLS_DBUS_TYPE_CALLS_CALL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
calls_dbus_calls_call_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_calls_dbus_calls_call_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_calls_dbus_calls_call_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
calls_dbus_calls_call_proxy_get_inbound (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Inbound");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
calls_dbus_calls_call_proxy_get_state (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "State");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
calls_dbus_calls_call_proxy_get_id (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Id");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
calls_dbus_calls_call_proxy_get_display_name (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DisplayName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
calls_dbus_calls_call_proxy_get_image_path (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ImagePath");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
calls_dbus_calls_call_proxy_get_protocol (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Protocol");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
calls_dbus_calls_call_proxy_get_encrypted (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Encrypted");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
calls_dbus_calls_call_proxy_get_can_dtmf (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanDtmf");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
calls_dbus_calls_call_proxy_get_hints (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallProxy *proxy = CALLS_DBUS_CALLS_CALL_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Hints");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
calls_dbus_calls_call_proxy_init (CallsDBusCallsCallProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = calls_dbus_calls_call_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CALLS_DBUS_TYPE_CALLS_CALL_PROXY, CallsDBusCallsCallProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), calls_dbus_calls_call_interface_info ());
}

static void
calls_dbus_calls_call_proxy_class_init (CallsDBusCallsCallProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = calls_dbus_calls_call_proxy_finalize;
  gobject_class->get_property = calls_dbus_calls_call_proxy_get_property;
  gobject_class->set_property = calls_dbus_calls_call_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = calls_dbus_calls_call_proxy_g_signal;
  proxy_class->g_properties_changed = calls_dbus_calls_call_proxy_g_properties_changed;

  calls_dbus_calls_call_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CallsDBusCallsCallProxyPrivate));
#endif
}

static void
calls_dbus_calls_call_proxy_iface_init (CallsDBusCallsCallIface *iface)
{
  iface->get_inbound = calls_dbus_calls_call_proxy_get_inbound;
  iface->get_state = calls_dbus_calls_call_proxy_get_state;
  iface->get_id = calls_dbus_calls_call_proxy_get_id;
  iface->get_display_name = calls_dbus_calls_call_proxy_get_display_name;
  iface->get_image_path = calls_dbus_calls_call_proxy_get_image_path;
  iface->get_protocol = calls_dbus_calls_call_proxy_get_protocol;
  iface->get_encrypted = calls_dbus_calls_call_proxy_get_encrypted;
  iface->get_can_dtmf = calls_dbus_calls_call_proxy_get_can_dtmf;
  iface->get_hints = calls_dbus_calls_call_proxy_get_hints;
}

/**
 * calls_dbus_calls_call_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-Call.top_of_page">org.gnome.Calls.Call</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_calls_call_proxy_new_finish() to get the result of the operation.
 *
 * See calls_dbus_calls_call_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
calls_dbus_calls_call_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CALLS_DBUS_TYPE_CALLS_CALL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Calls.Call", NULL);
}

/**
 * calls_dbus_calls_call_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_calls_call_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with calls_dbus_calls_call_proxy_new().
 *
 * Returns: (transfer full) (type CallsDBusCallsCallProxy): The constructed proxy object or %NULL if @error is set.
 */
CallsDBusCallsCall *
calls_dbus_calls_call_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CALLS_DBUS_CALLS_CALL (ret);
  else
    return NULL;
}

/**
 * calls_dbus_calls_call_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-Call.top_of_page">org.gnome.Calls.Call</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_calls_call_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CallsDBusCallsCallProxy): The constructed proxy object or %NULL if @error is set.
 */
CallsDBusCallsCall *
calls_dbus_calls_call_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CALLS_DBUS_TYPE_CALLS_CALL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Calls.Call", NULL);
  if (ret != NULL)
    return CALLS_DBUS_CALLS_CALL (ret);
  else
    return NULL;
}


/**
 * calls_dbus_calls_call_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like calls_dbus_calls_call_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_calls_call_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See calls_dbus_calls_call_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
calls_dbus_calls_call_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CALLS_DBUS_TYPE_CALLS_CALL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Calls.Call", NULL);
}

/**
 * calls_dbus_calls_call_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_calls_call_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with calls_dbus_calls_call_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type CallsDBusCallsCallProxy): The constructed proxy object or %NULL if @error is set.
 */
CallsDBusCallsCall *
calls_dbus_calls_call_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CALLS_DBUS_CALLS_CALL (ret);
  else
    return NULL;
}

/**
 * calls_dbus_calls_call_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like calls_dbus_calls_call_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_calls_call_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CallsDBusCallsCallProxy): The constructed proxy object or %NULL if @error is set.
 */
CallsDBusCallsCall *
calls_dbus_calls_call_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CALLS_DBUS_TYPE_CALLS_CALL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Calls.Call", NULL);
  if (ret != NULL)
    return CALLS_DBUS_CALLS_CALL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * CallsDBusCallsCallSkeleton:
 *
 * The #CallsDBusCallsCallSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CallsDBusCallsCallSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CallsDBusCallsCallSkeleton.
 */

struct _CallsDBusCallsCallSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_calls_dbus_calls_call_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CALLS_DBUS_TYPE_CALLS_CALL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CALLS_DBUS_TYPE_CALLS_CALL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_calls_dbus_calls_call_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_calls_dbus_calls_call_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_calls_dbus_calls_call_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_calls_dbus_calls_call_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _calls_dbus_calls_call_skeleton_vtable =
{
  _calls_dbus_calls_call_skeleton_handle_method_call,
  _calls_dbus_calls_call_skeleton_handle_get_property,
  _calls_dbus_calls_call_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
calls_dbus_calls_call_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return calls_dbus_calls_call_interface_info ();
}

static GDBusInterfaceVTable *
calls_dbus_calls_call_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_calls_dbus_calls_call_skeleton_vtable;
}

static GVariant *
calls_dbus_calls_call_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_calls_dbus_calls_call_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _calls_dbus_calls_call_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _calls_dbus_calls_call_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _calls_dbus_calls_call_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Calls.Call", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _calls_dbus_calls_call_emit_changed (gpointer user_data);

static void
calls_dbus_calls_call_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _calls_dbus_calls_call_emit_changed (skeleton);
}

static void calls_dbus_calls_call_skeleton_iface_init (CallsDBusCallsCallIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (CallsDBusCallsCallSkeleton, calls_dbus_calls_call_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (CallsDBusCallsCallSkeleton)
                         G_IMPLEMENT_INTERFACE (CALLS_DBUS_TYPE_CALLS_CALL, calls_dbus_calls_call_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (CallsDBusCallsCallSkeleton, calls_dbus_calls_call_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CALLS_DBUS_TYPE_CALLS_CALL, calls_dbus_calls_call_skeleton_iface_init))

#endif
static void
calls_dbus_calls_call_skeleton_finalize (GObject *object)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  guint n;
  for (n = 0; n < 9; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (calls_dbus_calls_call_skeleton_parent_class)->finalize (object);
}

static void
calls_dbus_calls_call_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_calls_dbus_calls_call_emit_changed (gpointer user_data)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Calls.Call",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_calls_dbus_calls_call_schedule_emit_changed (CallsDBusCallsCallSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
calls_dbus_calls_call_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _calls_dbus_calls_call_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _calls_dbus_calls_call_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
calls_dbus_calls_call_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _calls_dbus_calls_call_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _calls_dbus_calls_call_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
calls_dbus_calls_call_skeleton_init (CallsDBusCallsCallSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = calls_dbus_calls_call_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CALLS_DBUS_TYPE_CALLS_CALL_SKELETON, CallsDBusCallsCallSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 9);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_VARIANT);
}

static gboolean 
calls_dbus_calls_call_skeleton_get_inbound (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
calls_dbus_calls_call_skeleton_get_state (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
calls_dbus_calls_call_skeleton_get_id (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
calls_dbus_calls_call_skeleton_get_display_name (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
calls_dbus_calls_call_skeleton_get_image_path (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
calls_dbus_calls_call_skeleton_get_protocol (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
calls_dbus_calls_call_skeleton_get_encrypted (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
calls_dbus_calls_call_skeleton_get_can_dtmf (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
calls_dbus_calls_call_skeleton_get_hints (CallsDBusCallsCall *object)
{
  CallsDBusCallsCallSkeleton *skeleton = CALLS_DBUS_CALLS_CALL_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
calls_dbus_calls_call_skeleton_class_init (CallsDBusCallsCallSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = calls_dbus_calls_call_skeleton_finalize;
  gobject_class->get_property = calls_dbus_calls_call_skeleton_get_property;
  gobject_class->set_property = calls_dbus_calls_call_skeleton_set_property;
  gobject_class->notify       = calls_dbus_calls_call_skeleton_notify;


  calls_dbus_calls_call_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = calls_dbus_calls_call_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = calls_dbus_calls_call_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = calls_dbus_calls_call_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = calls_dbus_calls_call_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (CallsDBusCallsCallSkeletonPrivate));
#endif
}

static void
calls_dbus_calls_call_skeleton_iface_init (CallsDBusCallsCallIface *iface)
{
  iface->get_inbound = calls_dbus_calls_call_skeleton_get_inbound;
  iface->get_state = calls_dbus_calls_call_skeleton_get_state;
  iface->get_id = calls_dbus_calls_call_skeleton_get_id;
  iface->get_display_name = calls_dbus_calls_call_skeleton_get_display_name;
  iface->get_image_path = calls_dbus_calls_call_skeleton_get_image_path;
  iface->get_protocol = calls_dbus_calls_call_skeleton_get_protocol;
  iface->get_encrypted = calls_dbus_calls_call_skeleton_get_encrypted;
  iface->get_can_dtmf = calls_dbus_calls_call_skeleton_get_can_dtmf;
  iface->get_hints = calls_dbus_calls_call_skeleton_get_hints;
}

/**
 * calls_dbus_calls_call_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-Call.top_of_page">org.gnome.Calls.Call</link>.
 *
 * Returns: (transfer full) (type CallsDBusCallsCallSkeleton): The skeleton object.
 */
CallsDBusCallsCall *
calls_dbus_calls_call_skeleton_new (void)
{
  return CALLS_DBUS_CALLS_CALL (g_object_new (CALLS_DBUS_TYPE_CALLS_CALL_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CallsDBusObject
 * @title: CallsDBusObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #CallsDBusObject, #CallsDBusObjectProxy, and #CallsDBusObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * CallsDBusObject:
 *
 * The #CallsDBusObject type is a specialized container of interfaces.
 */

/**
 * CallsDBusObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #CallsDBusObject interface.
 */

typedef CallsDBusObjectIface CallsDBusObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (CallsDBusObject, calls_dbus_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
calls_dbus_object_default_init (CallsDBusObjectIface *iface)
{
  /**
   * CallsDBusObject:calls-call:
   *
   * The #CallsDBusCallsCall instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-Call.top_of_page">org.gnome.Calls.Call</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("calls-call", "calls-call", "calls-call", CALLS_DBUS_TYPE_CALLS_CALL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * calls_dbus_object_get_calls_call:
 * @object: A #CallsDBusObject.
 *
 * Gets the #CallsDBusCallsCall instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-Call.top_of_page">org.gnome.Calls.Call</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #CallsDBusCallsCall that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
CallsDBusCallsCall *calls_dbus_object_get_calls_call (CallsDBusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Calls.Call");
  if (ret == NULL)
    return NULL;
  return CALLS_DBUS_CALLS_CALL (ret);
}


/**
 * calls_dbus_object_peek_calls_call: (skip)
 * @object: A #CallsDBusObject.
 *
 * Like calls_dbus_object_get_calls_call() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #CallsDBusCallsCall or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
CallsDBusCallsCall *calls_dbus_object_peek_calls_call (CallsDBusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Calls.Call");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return CALLS_DBUS_CALLS_CALL (ret);
}


static void
calls_dbus_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * CallsDBusObjectProxy:
 *
 * The #CallsDBusObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CallsDBusObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CallsDBusObjectProxy.
 */

static void
calls_dbus_object_proxy__calls_dbus_object_iface_init (CallsDBusObjectIface *iface G_GNUC_UNUSED)
{
}

static void
calls_dbus_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = calls_dbus_object_notify;
  iface->interface_removed = calls_dbus_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (CallsDBusObjectProxy, calls_dbus_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (CALLS_DBUS_TYPE_OBJECT, calls_dbus_object_proxy__calls_dbus_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, calls_dbus_object_proxy__g_dbus_object_iface_init))

static void
calls_dbus_object_proxy_init (CallsDBusObjectProxy *object G_GNUC_UNUSED)
{
}

static void
calls_dbus_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
calls_dbus_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  CallsDBusObjectProxy *object = CALLS_DBUS_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Calls.Call");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
calls_dbus_object_proxy_class_init (CallsDBusObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = calls_dbus_object_proxy_set_property;
  gobject_class->get_property = calls_dbus_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "calls-call");
}

/**
 * calls_dbus_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
CallsDBusObjectProxy *
calls_dbus_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return CALLS_DBUS_OBJECT_PROXY (g_object_new (CALLS_DBUS_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * CallsDBusObjectSkeleton:
 *
 * The #CallsDBusObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CallsDBusObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CallsDBusObjectSkeleton.
 */

static void
calls_dbus_object_skeleton__calls_dbus_object_iface_init (CallsDBusObjectIface *iface G_GNUC_UNUSED)
{
}


static void
calls_dbus_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = calls_dbus_object_notify;
  iface->interface_removed = calls_dbus_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (CallsDBusObjectSkeleton, calls_dbus_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (CALLS_DBUS_TYPE_OBJECT, calls_dbus_object_skeleton__calls_dbus_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, calls_dbus_object_skeleton__g_dbus_object_iface_init))

static void
calls_dbus_object_skeleton_init (CallsDBusObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
calls_dbus_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  CallsDBusObjectSkeleton *object = CALLS_DBUS_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (CALLS_DBUS_IS_CALLS_CALL (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.gnome.Calls.Call");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
calls_dbus_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  CallsDBusObjectSkeleton *object = CALLS_DBUS_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.gnome.Calls.Call");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
calls_dbus_object_skeleton_class_init (CallsDBusObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = calls_dbus_object_skeleton_set_property;
  gobject_class->get_property = calls_dbus_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "calls-call");
}

/**
 * calls_dbus_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
CallsDBusObjectSkeleton *
calls_dbus_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return CALLS_DBUS_OBJECT_SKELETON (g_object_new (CALLS_DBUS_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * calls_dbus_object_skeleton_set_calls_call:
 * @object: A #CallsDBusObjectSkeleton.
 * @interface_: (nullable): A #CallsDBusCallsCall or %NULL to clear the interface.
 *
 * Sets the #CallsDBusCallsCall instance for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Calls-Call.top_of_page">org.gnome.Calls.Call</link> on @object.
 */
void calls_dbus_object_skeleton_set_calls_call (CallsDBusObjectSkeleton *object, CallsDBusCallsCall *interface_)
{
  g_object_set (G_OBJECT (object), "calls-call", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:CallsDBusObjectManagerClient
 * @title: CallsDBusObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses calls_dbus_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * CallsDBusObjectManagerClient:
 *
 * The #CallsDBusObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * CallsDBusObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #CallsDBusObjectManagerClient.
 */

G_DEFINE_TYPE (CallsDBusObjectManagerClient, calls_dbus_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
calls_dbus_object_manager_client_init (CallsDBusObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
calls_dbus_object_manager_client_class_init (CallsDBusObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * calls_dbus_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #CallsDBusObjectProxy.
 */
GType
calls_dbus_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return CALLS_DBUS_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.gnome.Calls.Call", (gpointer) (guintptr) (CALLS_DBUS_TYPE_CALLS_CALL_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) (guintptr) (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * calls_dbus_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using calls_dbus_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_object_manager_client_new_finish() to get the result of the operation.
 *
 * See calls_dbus_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
calls_dbus_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (CALLS_DBUS_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", calls_dbus_object_manager_client_get_proxy_type, NULL);
}

/**
 * calls_dbus_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with calls_dbus_object_manager_client_new().
 *
 * Returns: (transfer full) (type CallsDBusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
calls_dbus_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * calls_dbus_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using calls_dbus_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CallsDBusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
calls_dbus_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (CALLS_DBUS_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", calls_dbus_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * calls_dbus_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like calls_dbus_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call calls_dbus_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See calls_dbus_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
calls_dbus_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (CALLS_DBUS_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", calls_dbus_object_manager_client_get_proxy_type, NULL);
}

/**
 * calls_dbus_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to calls_dbus_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with calls_dbus_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type CallsDBusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
calls_dbus_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * calls_dbus_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like calls_dbus_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See calls_dbus_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type CallsDBusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
calls_dbus_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (CALLS_DBUS_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", calls_dbus_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


