/* stopwatch-face.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from stopwatch-face.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2020  Bilal Elmoussaoui <bil.elmoussaoui@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <adwaita.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;
typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())
typedef enum  {
	CLOCKS_BUTTON_MODE_NEW,
	CLOCKS_BUTTON_MODE_NONE
} ClocksButtonMode;

#define CLOCKS_TYPE_BUTTON_MODE (clocks_button_mode_get_type ())

#define CLOCKS_STOPWATCH_TYPE_FACE (clocks_stopwatch_face_get_type ())
#define CLOCKS_STOPWATCH_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace))
#define CLOCKS_STOPWATCH_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFaceClass))
#define CLOCKS_STOPWATCH_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_FACE))
#define CLOCKS_STOPWATCH_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_FACE))
#define CLOCKS_STOPWATCH_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFaceClass))

typedef struct _ClocksStopwatchFace ClocksStopwatchFace;
typedef struct _ClocksStopwatchFaceClass ClocksStopwatchFaceClass;
typedef struct _ClocksStopwatchFacePrivate ClocksStopwatchFacePrivate;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;
typedef enum  {
	CLOCKS_STOPWATCH_FACE_STATE_RESET,
	CLOCKS_STOPWATCH_FACE_STATE_RUNNING,
	CLOCKS_STOPWATCH_FACE_STATE_STOPPED
} ClocksStopwatchFaceState;

#define CLOCKS_STOPWATCH_FACE_TYPE_STATE (clocks_stopwatch_face_state_get_type ())
enum  {
	CLOCKS_STOPWATCH_FACE_0_PROPERTY,
	CLOCKS_STOPWATCH_FACE_LABEL_PROPERTY,
	CLOCKS_STOPWATCH_FACE_ICON_NAME_PROPERTY,
	CLOCKS_STOPWATCH_FACE_HEADER_BAR_PROPERTY,
	CLOCKS_STOPWATCH_FACE_PANEL_ID_PROPERTY,
	CLOCKS_STOPWATCH_FACE_BUTTON_MODE_PROPERTY,
	CLOCKS_STOPWATCH_FACE_NEW_LABEL_PROPERTY,
	CLOCKS_STOPWATCH_FACE_STATE_PROPERTY,
	CLOCKS_STOPWATCH_FACE_NUM_PROPERTIES
};
static GParamSpec* clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_NUM_PROPERTIES];
typedef enum  {
	CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_LAP,
	CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_SPLIT,
	CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_TOTAL
} ClocksStopwatchFaceLapsColumn;

#define CLOCKS_STOPWATCH_FACE_TYPE_LAPS_COLUMN (clocks_stopwatch_face_laps_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

#define CLOCKS_STOPWATCH_TYPE_LAP (clocks_stopwatch_lap_get_type ())
#define CLOCKS_STOPWATCH_LAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLap))
#define CLOCKS_STOPWATCH_LAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLapClass))
#define CLOCKS_STOPWATCH_IS_LAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_LAP))
#define CLOCKS_STOPWATCH_IS_LAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_LAP))
#define CLOCKS_STOPWATCH_LAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLapClass))

typedef struct _ClocksStopwatchLap ClocksStopwatchLap;
typedef struct _ClocksStopwatchLapClass ClocksStopwatchLapClass;
typedef struct _ClocksStopwatchLapPrivate ClocksStopwatchLapPrivate;

#define CLOCKS_STOPWATCH_TYPE_LAPS_ROW (clocks_stopwatch_laps_row_get_type ())
#define CLOCKS_STOPWATCH_LAPS_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRow))
#define CLOCKS_STOPWATCH_LAPS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRowClass))
#define CLOCKS_STOPWATCH_IS_LAPS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_LAPS_ROW))
#define CLOCKS_STOPWATCH_IS_LAPS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_LAPS_ROW))
#define CLOCKS_STOPWATCH_LAPS_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_LAPS_ROW, ClocksStopwatchLapsRowClass))

typedef struct _ClocksStopwatchLapsRow ClocksStopwatchLapsRow;
typedef struct _ClocksStopwatchLapsRowClass ClocksStopwatchLapsRowClass;

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
	ClocksButtonMode (*get_button_mode) (ClocksClock* self);
	void (*set_button_mode) (ClocksClock* self, ClocksButtonMode value);
	const gchar* (*get_new_label) (ClocksClock* self);
};

struct _ClocksStopwatchFace {
	GtkBox parent_instance;
	ClocksStopwatchFacePrivate * priv;
};

struct _ClocksStopwatchFaceClass {
	GtkBoxClass parent_class;
};

struct _ClocksStopwatchFacePrivate {
	GListStore* laps;
	gchar* _label;
	gchar* _icon_name;
	ClocksHeaderBar* _header_bar;
	ClocksPanelId _panel_id;
	ClocksButtonMode _button_mode;
	gchar* _new_label;
	ClocksStopwatchFaceState _state;
	GTimer* timer;
	guint tick_id;
	gint stored_hour;
	gint stored_minute;
	gint stored_second;
	gdouble stored_millisecond;
	gint current_lap;
	GtkLabel* hours_label;
	GtkLabel* minutes_label;
	GtkLabel* seconds_label;
	GtkLabel* milliseconds_label;
	GtkBox* time_container;
	GtkRevealer* laps_revealer;
	GtkBox* container;
	GtkButton* start_btn;
	GtkButton* clear_btn;
	GtkListBox* laps_list;
};

struct _ClocksStopwatchLap {
	GObject parent_instance;
	ClocksStopwatchLapPrivate * priv;
	gint index;
	gdouble duration;
};

struct _ClocksStopwatchLapClass {
	GObjectClass parent_class;
};

static gint ClocksStopwatchFace_private_offset;
static gpointer clocks_stopwatch_face_parent_class = NULL;
static ClocksClockIface * clocks_stopwatch_face_clocks_clock_parent_iface = NULL;

VALA_EXTERN GType clocks_panel_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksClock, g_object_unref)
VALA_EXTERN GType clocks_stopwatch_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksStopwatchFace, g_object_unref)
VALA_EXTERN GType clocks_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksHeaderBar, g_object_unref)
VALA_EXTERN GType clocks_stopwatch_face_state_get_type (void) G_GNUC_CONST ;
static GType clocks_stopwatch_face_laps_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void clocks_stopwatch_face_on_start_btn_clicked (ClocksStopwatchFace* self,
                                                 GtkButton* button);
VALA_EXTERN ClocksStopwatchFaceState clocks_stopwatch_face_get_state (ClocksStopwatchFace* self);
static void clocks_stopwatch_face_start (ClocksStopwatchFace* self);
static void clocks_stopwatch_face_stop (ClocksStopwatchFace* self);
static void _clocks_stopwatch_face_on_start_btn_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void clocks_stopwatch_face_on_clear_btn_clicked (ClocksStopwatchFace* self,
                                                 GtkButton* button);
static void clocks_stopwatch_face_reset (ClocksStopwatchFace* self);
static void clocks_stopwatch_face_lap (ClocksStopwatchFace* self);
static void _clocks_stopwatch_face_on_clear_btn_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void clocks_stopwatch_face_set_state (ClocksStopwatchFace* self,
                                      ClocksStopwatchFaceState value);
static void clocks_stopwatch_face_add_tick (ClocksStopwatchFace* self);
static void clocks_stopwatch_face_remove_tick (ClocksStopwatchFace* self);
static gboolean clocks_stopwatch_face_update_time_label (ClocksStopwatchFace* self);
static gdouble clocks_stopwatch_face_total_laps_duration (ClocksStopwatchFace* self);
VALA_EXTERN GType clocks_stopwatch_lap_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksStopwatchLap, g_object_unref)
VALA_EXTERN ClocksStopwatchLap* clocks_stopwatch_lap_new (gint index,
                                              gdouble duration);
VALA_EXTERN ClocksStopwatchLap* clocks_stopwatch_lap_construct (GType object_type,
                                                    gint index,
                                                    gdouble duration);
static gboolean ___lambda31_ (ClocksStopwatchFace* self,
                       GtkWidget* c);
static gboolean ____lambda31__gtk_tick_callback (GtkWidget* widget,
                                          GdkFrameClock* frame_clock,
                                          gpointer self);
VALA_EXTERN void clocks_utils_time_to_hms (gdouble t,
                               gint* h,
                               gint* m,
                               gint* s,
                               gdouble* remainder);
static gboolean clocks_stopwatch_face_real_grab_focus (GtkWidget* base);
static gboolean clocks_stopwatch_face_real_escape_pressed (ClocksClock* base);
VALA_EXTERN ClocksStopwatchFace* clocks_stopwatch_face_new (void);
VALA_EXTERN ClocksStopwatchFace* clocks_stopwatch_face_construct (GType object_type);
VALA_EXTERN const gchar* clocks_stopwatch_face_get_label (ClocksStopwatchFace* self);
VALA_EXTERN void clocks_stopwatch_face_set_label (ClocksStopwatchFace* self,
                                      const gchar* value);
VALA_EXTERN const gchar* clocks_stopwatch_face_get_icon_name (ClocksStopwatchFace* self);
VALA_EXTERN void clocks_stopwatch_face_set_icon_name (ClocksStopwatchFace* self,
                                          const gchar* value);
VALA_EXTERN ClocksHeaderBar* clocks_stopwatch_face_get_header_bar (ClocksStopwatchFace* self);
VALA_EXTERN void clocks_stopwatch_face_set_header_bar (ClocksStopwatchFace* self,
                                           ClocksHeaderBar* value);
static GObject * clocks_stopwatch_face_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
VALA_EXTERN void clocks_clock_set_panel_id (ClocksClock* self,
                                ClocksPanelId value);
static GtkWidget* _clocks_stopwatch_face___lambda32_ (ClocksStopwatchFace* self,
                                               GObject* lap);
VALA_EXTERN GType clocks_stopwatch_laps_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksStopwatchLapsRow, g_object_unref)
VALA_EXTERN ClocksStopwatchLapsRow* clocks_stopwatch_laps_row_new (ClocksStopwatchLap* current,
                                                       ClocksStopwatchLap* before);
VALA_EXTERN ClocksStopwatchLapsRow* clocks_stopwatch_laps_row_construct (GType object_type,
                                                             ClocksStopwatchLap* current,
                                                             ClocksStopwatchLap* before);
static GtkWidget* __clocks_stopwatch_face___lambda32__gtk_list_box_create_widget_func (GObject* item,
                                                                                gpointer self);
static void _clocks_stopwatch_face___lambda33_ (ClocksStopwatchFace* self);
static void __clocks_stopwatch_face___lambda33__g_list_model_items_changed (GListModel* _sender,
                                                                     guint position,
                                                                     guint removed,
                                                                     guint added,
                                                                     gpointer self);
static void _clocks_stopwatch_face___lambda34_ (ClocksStopwatchFace* self,
                                         GtkWidget* w);
static void __clocks_stopwatch_face___lambda34__gtk_widget_map (GtkWidget* _sender,
                                                         gpointer self);
static void _clocks_stopwatch_face___lambda35_ (ClocksStopwatchFace* self,
                                         GtkWidget* w);
static void __clocks_stopwatch_face___lambda35__gtk_widget_unmap (GtkWidget* _sender,
                                                           gpointer self);
VALA_EXTERN gboolean clocks_clock_escape_pressed (ClocksClock* self);
VALA_EXTERN ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
VALA_EXTERN ClocksButtonMode clocks_clock_get_button_mode (ClocksClock* self);
VALA_EXTERN void clocks_clock_set_button_mode (ClocksClock* self,
                                   ClocksButtonMode value);
VALA_EXTERN const gchar* clocks_clock_get_new_label (ClocksClock* self);
static void clocks_stopwatch_face_finalize (GObject * obj);
static GType clocks_stopwatch_face_get_type_once (void);
static void _vala_clocks_stopwatch_face_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_clocks_stopwatch_face_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
clocks_stopwatch_face_get_instance_private (ClocksStopwatchFace* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksStopwatchFace_private_offset);
}

 G_GNUC_NO_INLINE static GType
clocks_stopwatch_face_state_get_type_once (void)
{
	static const GEnumValue values[] = {{CLOCKS_STOPWATCH_FACE_STATE_RESET, "CLOCKS_STOPWATCH_FACE_STATE_RESET", "reset"}, {CLOCKS_STOPWATCH_FACE_STATE_RUNNING, "CLOCKS_STOPWATCH_FACE_STATE_RUNNING", "running"}, {CLOCKS_STOPWATCH_FACE_STATE_STOPPED, "CLOCKS_STOPWATCH_FACE_STATE_STOPPED", "stopped"}, {0, NULL, NULL}};
	GType clocks_stopwatch_face_state_type_id;
	clocks_stopwatch_face_state_type_id = g_enum_register_static ("ClocksStopwatchFaceState", values);
	return clocks_stopwatch_face_state_type_id;
}

GType
clocks_stopwatch_face_state_get_type (void)
{
	static gsize clocks_stopwatch_face_state_type_id__once = 0;
	if (g_once_init_enter (&clocks_stopwatch_face_state_type_id__once)) {
		GType clocks_stopwatch_face_state_type_id;
		clocks_stopwatch_face_state_type_id = clocks_stopwatch_face_state_get_type_once ();
		g_once_init_leave (&clocks_stopwatch_face_state_type_id__once, clocks_stopwatch_face_state_type_id);
	}
	return clocks_stopwatch_face_state_type_id__once;
}

 G_GNUC_NO_INLINE static GType
clocks_stopwatch_face_laps_column_get_type_once (void)
{
	static const GEnumValue values[] = {{CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_LAP, "CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_LAP", "lap"}, {CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_SPLIT, "CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_SPLIT", "split"}, {CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_TOTAL, "CLOCKS_STOPWATCH_FACE_LAPS_COLUMN_TOTAL", "total"}, {0, NULL, NULL}};
	GType clocks_stopwatch_face_laps_column_type_id;
	clocks_stopwatch_face_laps_column_type_id = g_enum_register_static ("ClocksStopwatchFaceLapsColumn", values);
	return clocks_stopwatch_face_laps_column_type_id;
}

static GType
clocks_stopwatch_face_laps_column_get_type (void)
{
	static gsize clocks_stopwatch_face_laps_column_type_id__once = 0;
	if (g_once_init_enter (&clocks_stopwatch_face_laps_column_type_id__once)) {
		GType clocks_stopwatch_face_laps_column_type_id;
		clocks_stopwatch_face_laps_column_type_id = clocks_stopwatch_face_laps_column_get_type_once ();
		g_once_init_leave (&clocks_stopwatch_face_laps_column_type_id__once, clocks_stopwatch_face_laps_column_type_id);
	}
	return clocks_stopwatch_face_laps_column_type_id__once;
}

static void
clocks_stopwatch_face_on_start_btn_clicked (ClocksStopwatchFace* self,
                                            GtkButton* button)
{
	ClocksStopwatchFaceState _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case CLOCKS_STOPWATCH_FACE_STATE_RESET:
		case CLOCKS_STOPWATCH_FACE_STATE_STOPPED:
		{
			clocks_stopwatch_face_start (self);
			break;
		}
		case CLOCKS_STOPWATCH_FACE_STATE_RUNNING:
		{
			clocks_stopwatch_face_stop (self);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
_clocks_stopwatch_face_on_start_btn_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	clocks_stopwatch_face_on_start_btn_clicked ((ClocksStopwatchFace*) self, _sender);
}

static void
clocks_stopwatch_face_on_clear_btn_clicked (ClocksStopwatchFace* self,
                                            GtkButton* button)
{
	ClocksStopwatchFaceState _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case CLOCKS_STOPWATCH_FACE_STATE_STOPPED:
		{
			GtkButton* _tmp1_;
			_tmp1_ = self->priv->start_btn;
			gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
			clocks_stopwatch_face_reset (self);
			break;
		}
		case CLOCKS_STOPWATCH_FACE_STATE_RUNNING:
		{
			clocks_stopwatch_face_lap (self);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static void
_clocks_stopwatch_face_on_clear_btn_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	clocks_stopwatch_face_on_clear_btn_clicked ((ClocksStopwatchFace*) self, _sender);
}

static void
clocks_stopwatch_face_start (ClocksStopwatchFace* self)
{
	ClocksStopwatchFaceState _tmp0_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CLOCKS_STOPWATCH_FACE_STATE_RESET) {
		GTimer* _tmp1_;
		_tmp1_ = self->priv->timer;
		g_timer_start (_tmp1_);
	} else {
		GTimer* _tmp2_;
		_tmp2_ = self->priv->timer;
		g_timer_continue (_tmp2_);
	}
	clocks_stopwatch_face_set_state (self, CLOCKS_STOPWATCH_FACE_STATE_RUNNING);
	clocks_stopwatch_face_add_tick (self);
	_tmp3_ = self->priv->start_btn;
	gtk_button_set_label (_tmp3_, _ ("_Pause"));
	_tmp4_ = self->priv->start_btn;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp4_, "suggested-action");
	_tmp5_ = self->priv->clear_btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = self->priv->clear_btn;
	gtk_button_set_label (_tmp6_, _ ("_Lap"));
	_tmp7_ = self->priv->clear_btn;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp7_, "destructive-action");
	_tmp8_ = self->priv->time_container;
	gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "running-stopwatch");
	_tmp9_ = self->priv->time_container;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp9_, "paused-stopwatch");
	_tmp10_ = self->priv->time_container;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp10_, "stopped-stopwatch");
}

static void
clocks_stopwatch_face_stop (ClocksStopwatchFace* self)
{
	GTimer* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	g_timer_stop (_tmp0_);
	clocks_stopwatch_face_set_state (self, CLOCKS_STOPWATCH_FACE_STATE_STOPPED);
	clocks_stopwatch_face_remove_tick (self);
	_tmp1_ = self->priv->start_btn;
	gtk_button_set_label (_tmp1_, _ ("R_esume"));
	_tmp2_ = self->priv->start_btn;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp2_, "destructive-action");
	_tmp3_ = self->priv->start_btn;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, "suggested-action");
	_tmp4_ = self->priv->clear_btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = self->priv->clear_btn;
	gtk_button_set_label (_tmp5_, _ ("_Clear"));
	_tmp6_ = self->priv->clear_btn;
	gtk_widget_add_css_class ((GtkWidget*) _tmp6_, "destructive-action");
	_tmp7_ = self->priv->time_container;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, "paused-stopwatch");
	_tmp8_ = self->priv->time_container;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp8_, "running-stopwatch");
	_tmp9_ = self->priv->time_container;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp9_, "stopped-stopwatch");
}

static void
clocks_stopwatch_face_reset (ClocksStopwatchFace* self)
{
	GtkRevealer* _tmp0_;
	GTimer* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GListStore* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->laps_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	_tmp1_ = self->priv->timer;
	g_timer_reset (_tmp1_);
	clocks_stopwatch_face_set_state (self, CLOCKS_STOPWATCH_FACE_STATE_RESET);
	clocks_stopwatch_face_remove_tick (self);
	clocks_stopwatch_face_update_time_label (self);
	self->priv->current_lap = 0;
	_tmp2_ = self->priv->start_btn;
	gtk_button_set_label (_tmp2_, _ ("St_art"));
	_tmp3_ = self->priv->start_btn;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, "suggested-action");
	_tmp4_ = self->priv->clear_btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
	_tmp5_ = self->priv->clear_btn;
	gtk_button_set_label (_tmp5_, _ ("_Lap"));
	_tmp6_ = self->priv->clear_btn;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp6_, "destructive-action");
	_tmp7_ = self->priv->time_container;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, "stopped-stopwatch");
	_tmp8_ = self->priv->time_container;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp8_, "paused-stopwatch");
	_tmp9_ = self->priv->time_container;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp9_, "running-stopwatch");
	_tmp10_ = self->priv->laps;
	g_list_store_remove_all (_tmp10_);
}

static gdouble
clocks_stopwatch_face_total_laps_duration (ClocksStopwatchFace* self)
{
	gdouble total = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	total = (gdouble) 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				ClocksStopwatchLap* lap = NULL;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				ClocksStopwatchLap* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->laps;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->laps;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) i);
				lap = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLap);
				_tmp5_ = lap;
				total += _tmp5_->duration;
				_g_object_unref0 (lap);
			}
		}
	}
	result = total;
	return result;
}

static void
clocks_stopwatch_face_lap (ClocksStopwatchFace* self)
{
	GtkRevealer* _tmp0_;
	gdouble e = 0.0;
	GTimer* _tmp1_;
	gdouble lap_duration = 0.0;
	ClocksStopwatchLap* lap = NULL;
	ClocksStopwatchLap* _tmp2_;
	GListStore* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->current_lap = self->priv->current_lap + 1;
	_tmp0_ = self->priv->laps_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, self->priv->current_lap >= 1);
	_tmp1_ = self->priv->timer;
	e = g_timer_elapsed (_tmp1_, NULL);
	lap_duration = e - clocks_stopwatch_face_total_laps_duration (self);
	_tmp2_ = clocks_stopwatch_lap_new (self->priv->current_lap, lap_duration);
	lap = _tmp2_;
	_tmp3_ = self->priv->laps;
	g_list_store_insert (_tmp3_, (guint) 0, (GObject*) lap);
	_g_object_unref0 (lap);
}

static gboolean
___lambda31_ (ClocksStopwatchFace* self,
              GtkWidget* c)
{
	gboolean result;
	g_return_val_if_fail (c != NULL, FALSE);
	result = clocks_stopwatch_face_update_time_label (self);
	return result;
}

static gboolean
____lambda31__gtk_tick_callback (GtkWidget* widget,
                                 GdkFrameClock* frame_clock,
                                 gpointer self)
{
	gboolean result;
	result = ___lambda31_ ((ClocksStopwatchFace*) self, widget);
	return result;
}

static void
clocks_stopwatch_face_add_tick (ClocksStopwatchFace* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->tick_id == ((guint) 0)) {
		self->priv->tick_id = gtk_widget_add_tick_callback ((GtkWidget*) self, ____lambda31__gtk_tick_callback, g_object_ref (self), g_object_unref);
	}
}

static void
clocks_stopwatch_face_remove_tick (ClocksStopwatchFace* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->tick_id != ((guint) 0)) {
		gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->tick_id);
		self->priv->tick_id = (guint) 0;
	}
}

static gboolean
clocks_stopwatch_face_update_time_label (ClocksStopwatchFace* self)
{
	gint h = 0;
	gint m = 0;
	gint s = 0;
	gdouble r = 0.0;
	ClocksStopwatchFaceState _tmp0_;
	gint ds = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	h = 0;
	m = 0;
	s = 0;
	r = (gdouble) 0;
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != CLOCKS_STOPWATCH_FACE_STATE_RESET) {
		GTimer* _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gdouble _tmp5_ = 0.0;
		_tmp1_ = self->priv->timer;
		clocks_utils_time_to_hms (g_timer_elapsed (_tmp1_, NULL), &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
		h = _tmp2_;
		m = _tmp3_;
		s = _tmp4_;
		r = _tmp5_;
	}
	ds = (gint) (r * 10);
	if (self->priv->stored_hour != h) {
		GtkLabel* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->hours_label;
		_tmp7_ = g_strdup_printf ("%02i\u200E", h);
		_tmp8_ = _tmp7_;
		gtk_label_set_label (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		self->priv->stored_hour = h;
	}
	if (self->priv->stored_minute != m) {
		GtkLabel* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = self->priv->minutes_label;
		_tmp10_ = g_strdup_printf ("%02i\u200E", m);
		_tmp11_ = _tmp10_;
		gtk_label_set_label (_tmp9_, _tmp11_);
		_g_free0 (_tmp11_);
		self->priv->stored_minute = m;
	}
	if (self->priv->stored_second != s) {
		GtkLabel* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = self->priv->seconds_label;
		_tmp13_ = g_strdup_printf ("%02i", s);
		_tmp14_ = _tmp13_;
		gtk_label_set_label (_tmp12_, _tmp14_);
		_g_free0 (_tmp14_);
		self->priv->stored_second = s;
	}
	if (self->priv->stored_millisecond != ((gdouble) ds)) {
		GtkLabel* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = self->priv->milliseconds_label;
		_tmp16_ = g_strdup_printf ("%i", ds);
		_tmp17_ = _tmp16_;
		gtk_label_set_label (_tmp15_, _tmp17_);
		_g_free0 (_tmp17_);
		self->priv->stored_millisecond = (gdouble) ds;
	}
	result = TRUE;
	return result;
}

static gboolean
clocks_stopwatch_face_real_grab_focus (GtkWidget* base)
{
	ClocksStopwatchFace * self;
	GtkButton* _tmp0_;
	gboolean result;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = self->priv->start_btn;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
clocks_stopwatch_face_real_escape_pressed (ClocksClock* base)
{
	ClocksStopwatchFace * self;
	ClocksStopwatchFaceState _tmp0_;
	gboolean result;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case CLOCKS_STOPWATCH_FACE_STATE_RESET:
		{
			result = FALSE;
			return result;
		}
		case CLOCKS_STOPWATCH_FACE_STATE_STOPPED:
		{
			clocks_stopwatch_face_reset (self);
			break;
		}
		case CLOCKS_STOPWATCH_FACE_STATE_RUNNING:
		{
			clocks_stopwatch_face_stop (self);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	result = TRUE;
	return result;
}

ClocksStopwatchFace*
clocks_stopwatch_face_construct (GType object_type)
{
	ClocksStopwatchFace * self = NULL;
	self = (ClocksStopwatchFace*) g_object_new (object_type, NULL);
	return self;
}

ClocksStopwatchFace*
clocks_stopwatch_face_new (void)
{
	return clocks_stopwatch_face_construct (CLOCKS_STOPWATCH_TYPE_FACE);
}

const gchar*
clocks_stopwatch_face_get_label (ClocksStopwatchFace* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
clocks_stopwatch_face_set_label (ClocksStopwatchFace* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_stopwatch_face_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_LABEL_PROPERTY]);
	}
}

const gchar*
clocks_stopwatch_face_get_icon_name (ClocksStopwatchFace* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

void
clocks_stopwatch_face_set_icon_name (ClocksStopwatchFace* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_stopwatch_face_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_ICON_NAME_PROPERTY]);
	}
}

ClocksHeaderBar*
clocks_stopwatch_face_get_header_bar (ClocksStopwatchFace* self)
{
	ClocksHeaderBar* result;
	ClocksHeaderBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
clocks_stopwatch_face_set_header_bar (ClocksStopwatchFace* self,
                                      ClocksHeaderBar* value)
{
	ClocksHeaderBar* old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_stopwatch_face_get_header_bar (self);
	if (old_value != value) {
		ClocksHeaderBar* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_header_bar);
		self->priv->_header_bar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_HEADER_BAR_PROPERTY]);
	}
}

static ClocksPanelId
clocks_stopwatch_face_real_get_panel_id (ClocksClock* base)
{
	ClocksPanelId result;
	ClocksStopwatchFace* self;
	self = (ClocksStopwatchFace*) base;
	result = self->priv->_panel_id;
	return result;
}

static void
clocks_stopwatch_face_real_set_panel_id (ClocksClock* base,
                                         ClocksPanelId value)
{
	ClocksStopwatchFace* self;
	ClocksPanelId old_value;
	self = (ClocksStopwatchFace*) base;
	old_value = clocks_stopwatch_face_real_get_panel_id (base);
	if (old_value != value) {
		self->priv->_panel_id = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_PANEL_ID_PROPERTY]);
	}
}

static ClocksButtonMode
clocks_stopwatch_face_real_get_button_mode (ClocksClock* base)
{
	ClocksButtonMode result;
	ClocksStopwatchFace* self;
	self = (ClocksStopwatchFace*) base;
	result = self->priv->_button_mode;
	return result;
}

static void
clocks_stopwatch_face_real_set_button_mode (ClocksClock* base,
                                            ClocksButtonMode value)
{
	ClocksStopwatchFace* self;
	ClocksButtonMode old_value;
	self = (ClocksStopwatchFace*) base;
	old_value = clocks_stopwatch_face_real_get_button_mode (base);
	if (old_value != value) {
		self->priv->_button_mode = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_BUTTON_MODE_PROPERTY]);
	}
}

static const gchar*
clocks_stopwatch_face_real_get_new_label (ClocksClock* base)
{
	const gchar* result;
	ClocksStopwatchFace* self;
	const gchar* _tmp0_;
	self = (ClocksStopwatchFace*) base;
	_tmp0_ = self->priv->_new_label;
	result = _tmp0_;
	return result;
}

ClocksStopwatchFaceState
clocks_stopwatch_face_get_state (ClocksStopwatchFace* self)
{
	ClocksStopwatchFaceState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
clocks_stopwatch_face_set_state (ClocksStopwatchFace* self,
                                 ClocksStopwatchFaceState value)
{
	ClocksStopwatchFaceState old_value;
	g_return_if_fail (self != NULL);
	old_value = clocks_stopwatch_face_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_STATE_PROPERTY]);
	}
}

static GtkWidget*
_clocks_stopwatch_face___lambda32_ (ClocksStopwatchFace* self,
                                    GObject* lap)
{
	guint total_items = 0U;
	GListStore* _tmp0_;
	ClocksStopwatchLap* before = NULL;
	ClocksStopwatchLapsRow* lap_row = NULL;
	ClocksStopwatchLap* _tmp3_;
	ClocksStopwatchLapsRow* _tmp4_;
	GtkWidget* result;
	g_return_val_if_fail (lap != NULL, NULL);
	_tmp0_ = self->priv->laps;
	total_items = g_list_model_get_n_items ((GListModel*) _tmp0_);
	before = NULL;
	if (total_items > ((guint) 1)) {
		GListStore* _tmp1_;
		GObject* _tmp2_;
		_tmp1_ = self->priv->laps;
		_tmp2_ = g_list_model_get_item ((GListModel*) _tmp1_, (guint) 1);
		_g_object_unref0 (before);
		before = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLap);
	}
	_tmp3_ = before;
	_tmp4_ = clocks_stopwatch_laps_row_new (G_TYPE_CHECK_INSTANCE_CAST (lap, CLOCKS_STOPWATCH_TYPE_LAP, ClocksStopwatchLap), _tmp3_);
	g_object_ref_sink (_tmp4_);
	lap_row = _tmp4_;
	result = (GtkWidget*) lap_row;
	_g_object_unref0 (before);
	return result;
}

static GtkWidget*
__clocks_stopwatch_face___lambda32__gtk_list_box_create_widget_func (GObject* item,
                                                                     gpointer self)
{
	GtkWidget* result;
	result = _clocks_stopwatch_face___lambda32_ ((ClocksStopwatchFace*) self, item);
	return result;
}

static void
_clocks_stopwatch_face___lambda33_ (ClocksStopwatchFace* self)
{
	GListStore* _tmp0_;
	_tmp0_ = self->priv->laps;
	if (g_list_model_get_n_items ((GListModel*) _tmp0_) == ((guint) 0)) {
		GtkBox* _tmp1_;
		_tmp1_ = self->priv->container;
		gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	} else {
		GtkBox* _tmp2_;
		_tmp2_ = self->priv->container;
		gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_FILL);
	}
}

static void
__clocks_stopwatch_face___lambda33__g_list_model_items_changed (GListModel* _sender,
                                                                guint position,
                                                                guint removed,
                                                                guint added,
                                                                gpointer self)
{
	_clocks_stopwatch_face___lambda33_ ((ClocksStopwatchFace*) self);
}

static void
_clocks_stopwatch_face___lambda34_ (ClocksStopwatchFace* self,
                                    GtkWidget* w)
{
	ClocksStopwatchFaceState _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CLOCKS_STOPWATCH_FACE_STATE_RUNNING) {
		clocks_stopwatch_face_update_time_label (self);
		clocks_stopwatch_face_add_tick (self);
	}
}

static void
__clocks_stopwatch_face___lambda34__gtk_widget_map (GtkWidget* _sender,
                                                    gpointer self)
{
	_clocks_stopwatch_face___lambda34_ ((ClocksStopwatchFace*) self, _sender);
}

static void
_clocks_stopwatch_face___lambda35_ (ClocksStopwatchFace* self,
                                    GtkWidget* w)
{
	ClocksStopwatchFaceState _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CLOCKS_STOPWATCH_FACE_STATE_RUNNING) {
		clocks_stopwatch_face_remove_tick (self);
	}
}

static void
__clocks_stopwatch_face___lambda35__gtk_widget_unmap (GtkWidget* _sender,
                                                      gpointer self)
{
	_clocks_stopwatch_face___lambda35_ ((ClocksStopwatchFace*) self, _sender);
}

static GObject *
clocks_stopwatch_face_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ClocksStopwatchFace * self;
	GListStore* _tmp0_;
	GTimer* _tmp1_;
	GtkBox* _tmp2_;
	GtkListBox* _tmp3_;
	GListStore* _tmp4_;
	GListStore* _tmp5_;
	parent_class = G_OBJECT_CLASS (clocks_stopwatch_face_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace);
	clocks_clock_set_panel_id ((ClocksClock*) self, CLOCKS_PANEL_ID_STOPWATCH);
	_tmp0_ = g_list_store_new (CLOCKS_STOPWATCH_TYPE_LAP);
	_g_object_unref0 (self->priv->laps);
	self->priv->laps = _tmp0_;
	_tmp1_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp1_;
	self->priv->tick_id = (guint) 0;
	_tmp2_ = self->priv->time_container;
	gtk_widget_set_direction ((GtkWidget*) _tmp2_, GTK_TEXT_DIR_LTR);
	_tmp3_ = self->priv->laps_list;
	_tmp4_ = self->priv->laps;
	gtk_list_box_bind_model (_tmp3_, (GListModel*) _tmp4_, __clocks_stopwatch_face___lambda32__gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp5_ = self->priv->laps;
	g_signal_connect_object ((GListModel*) _tmp5_, "items-changed", (GCallback) __clocks_stopwatch_face___lambda33__g_list_model_items_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) __clocks_stopwatch_face___lambda34__gtk_widget_map, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "unmap", (GCallback) __clocks_stopwatch_face___lambda35__gtk_widget_unmap, self, 0);
	clocks_stopwatch_face_reset (self);
	return obj;
}

static void
clocks_stopwatch_face_class_init (ClocksStopwatchFaceClass * klass,
                                  gpointer klass_data)
{
	clocks_stopwatch_face_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksStopwatchFace_private_offset);
	((GtkWidgetClass *) klass)->grab_focus = (gboolean (*) (GtkWidget*)) clocks_stopwatch_face_real_grab_focus;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_stopwatch_face_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_stopwatch_face_set_property;
	G_OBJECT_CLASS (klass)->constructor = clocks_stopwatch_face_constructor;
	G_OBJECT_CLASS (klass)->finalize = clocks_stopwatch_face_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_LABEL_PROPERTY, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_ICON_NAME_PROPERTY, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_HEADER_BAR_PROPERTY, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_HEADER_BAR_PROPERTY] = g_param_spec_object ("header-bar", "header-bar", "header-bar", CLOCKS_TYPE_HEADER_BAR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_PANEL_ID_PROPERTY, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_PANEL_ID_PROPERTY] = g_param_spec_enum ("panel-id", "panel-id", "panel-id", CLOCKS_TYPE_PANEL_ID, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_BUTTON_MODE_PROPERTY, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_BUTTON_MODE_PROPERTY] = g_param_spec_enum ("button-mode", "button-mode", "button-mode", CLOCKS_TYPE_BUTTON_MODE, CLOCKS_BUTTON_MODE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_NEW_LABEL_PROPERTY, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_NEW_LABEL_PROPERTY] = g_param_spec_string ("new-label", "new-label", "new-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_STOPWATCH_FACE_STATE_PROPERTY, clocks_stopwatch_face_properties[CLOCKS_STOPWATCH_FACE_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CLOCKS_STOPWATCH_FACE_TYPE_STATE, CLOCKS_STOPWATCH_FACE_STATE_RESET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/stopwatch-face.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hours_label", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, hours_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "minutes_label", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, minutes_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "seconds_label", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, seconds_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "milliseconds_label", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, milliseconds_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_container", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, time_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "laps_revealer", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, laps_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "container", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "start_btn", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, start_btn));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clear_btn", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, clear_btn));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "laps_list", FALSE, ClocksStopwatchFace_private_offset + G_STRUCT_OFFSET (ClocksStopwatchFacePrivate, laps_list));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_start_btn_clicked", G_CALLBACK(_clocks_stopwatch_face_on_start_btn_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_clear_btn_clicked", G_CALLBACK(_clocks_stopwatch_face_on_clear_btn_clicked_gtk_button_clicked));
}

static void
clocks_stopwatch_face_clocks_clock_interface_init (ClocksClockIface * iface,
                                                   gpointer iface_data)
{
	clocks_stopwatch_face_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->escape_pressed = (gboolean (*) (ClocksClock*)) clocks_stopwatch_face_real_escape_pressed;
	iface->get_panel_id = clocks_stopwatch_face_real_get_panel_id;
	iface->set_panel_id = clocks_stopwatch_face_real_set_panel_id;
	iface->get_button_mode = clocks_stopwatch_face_real_get_button_mode;
	iface->set_button_mode = clocks_stopwatch_face_real_set_button_mode;
	iface->get_new_label = clocks_stopwatch_face_real_get_new_label;
}

static void
clocks_stopwatch_face_instance_init (ClocksStopwatchFace * self,
                                     gpointer klass)
{
	self->priv = clocks_stopwatch_face_get_instance_private (self);
	self->priv->_button_mode = CLOCKS_BUTTON_MODE_NONE;
	self->priv->_new_label = NULL;
	self->priv->_state = CLOCKS_STOPWATCH_FACE_STATE_RESET;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_stopwatch_face_finalize (GObject * obj)
{
	ClocksStopwatchFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace);
	_g_object_unref0 (self->priv->laps);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_icon_name);
	_g_object_unref0 (self->priv->_header_bar);
	_g_free0 (self->priv->_new_label);
	_g_timer_destroy0 (self->priv->timer);
	G_OBJECT_CLASS (clocks_stopwatch_face_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_stopwatch_face_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksStopwatchFaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_stopwatch_face_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksStopwatchFace), 0, (GInstanceInitFunc) clocks_stopwatch_face_instance_init, NULL };
	static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_stopwatch_face_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType clocks_stopwatch_face_type_id;
	clocks_stopwatch_face_type_id = g_type_register_static (gtk_box_get_type (), "ClocksStopwatchFace", &g_define_type_info, 0);
	g_type_add_interface_static (clocks_stopwatch_face_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
	ClocksStopwatchFace_private_offset = g_type_add_instance_private (clocks_stopwatch_face_type_id, sizeof (ClocksStopwatchFacePrivate));
	return clocks_stopwatch_face_type_id;
}

GType
clocks_stopwatch_face_get_type (void)
{
	static gsize clocks_stopwatch_face_type_id__once = 0;
	if (g_once_init_enter (&clocks_stopwatch_face_type_id__once)) {
		GType clocks_stopwatch_face_type_id;
		clocks_stopwatch_face_type_id = clocks_stopwatch_face_get_type_once ();
		g_once_init_leave (&clocks_stopwatch_face_type_id__once, clocks_stopwatch_face_type_id);
	}
	return clocks_stopwatch_face_type_id__once;
}

static void
_vala_clocks_stopwatch_face_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ClocksStopwatchFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace);
	switch (property_id) {
		case CLOCKS_STOPWATCH_FACE_LABEL_PROPERTY:
		g_value_set_string (value, clocks_stopwatch_face_get_label (self));
		break;
		case CLOCKS_STOPWATCH_FACE_ICON_NAME_PROPERTY:
		g_value_set_string (value, clocks_stopwatch_face_get_icon_name (self));
		break;
		case CLOCKS_STOPWATCH_FACE_HEADER_BAR_PROPERTY:
		g_value_set_object (value, clocks_stopwatch_face_get_header_bar (self));
		break;
		case CLOCKS_STOPWATCH_FACE_PANEL_ID_PROPERTY:
		g_value_set_enum (value, clocks_clock_get_panel_id ((ClocksClock*) self));
		break;
		case CLOCKS_STOPWATCH_FACE_BUTTON_MODE_PROPERTY:
		g_value_set_enum (value, clocks_clock_get_button_mode ((ClocksClock*) self));
		break;
		case CLOCKS_STOPWATCH_FACE_NEW_LABEL_PROPERTY:
		g_value_set_string (value, clocks_clock_get_new_label ((ClocksClock*) self));
		break;
		case CLOCKS_STOPWATCH_FACE_STATE_PROPERTY:
		g_value_set_enum (value, clocks_stopwatch_face_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_stopwatch_face_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ClocksStopwatchFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace);
	switch (property_id) {
		case CLOCKS_STOPWATCH_FACE_LABEL_PROPERTY:
		clocks_stopwatch_face_set_label (self, g_value_get_string (value));
		break;
		case CLOCKS_STOPWATCH_FACE_ICON_NAME_PROPERTY:
		clocks_stopwatch_face_set_icon_name (self, g_value_get_string (value));
		break;
		case CLOCKS_STOPWATCH_FACE_HEADER_BAR_PROPERTY:
		clocks_stopwatch_face_set_header_bar (self, g_value_get_object (value));
		break;
		case CLOCKS_STOPWATCH_FACE_PANEL_ID_PROPERTY:
		clocks_clock_set_panel_id ((ClocksClock*) self, g_value_get_enum (value));
		break;
		case CLOCKS_STOPWATCH_FACE_BUTTON_MODE_PROPERTY:
		clocks_clock_set_button_mode ((ClocksClock*) self, g_value_get_enum (value));
		break;
		case CLOCKS_STOPWATCH_FACE_STATE_PROPERTY:
		clocks_stopwatch_face_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

