/* gnome-mines.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gnome-mines.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include "libgnome-games-support.h"
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <locale.h>

#define MINES_KEY_XSIZE "xsize"
#define MINES_XSIZE_MIN 4
#define MINES_XSIZE_MAX 100
#define MINES_KEY_YSIZE "ysize"
#define MINES_YSIZE_MIN 4
#define MINES_YSIZE_MAX 100
#define MINES_KEY_NMINES "nmines"
#define MINES_KEY_MODE "mode"
#define MINES_KEY_USE_QUESTION_MARKS "use-question-marks"
#define MINES_KEY_USE_AUTOFLAG "use-autoflag"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MINES (mines_get_type ())
#define MINES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINES, Mines))
#define MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINES, MinesClass))
#define IS_MINES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINES))
#define IS_MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINES))
#define MINES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINES, MinesClass))

typedef struct _Mines Mines;
typedef struct _MinesClass MinesClass;
typedef struct _MinesPrivate MinesPrivate;

#define TYPE_THEME_SELECTOR_DIALOG (theme_selector_dialog_get_type ())
#define THEME_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_SELECTOR_DIALOG, ThemeSelectorDialog))
#define THEME_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_SELECTOR_DIALOG, ThemeSelectorDialogClass))
#define IS_THEME_SELECTOR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_SELECTOR_DIALOG))
#define IS_THEME_SELECTOR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_SELECTOR_DIALOG))
#define THEME_SELECTOR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_SELECTOR_DIALOG, ThemeSelectorDialogClass))

typedef struct _ThemeSelectorDialog ThemeSelectorDialog;
typedef struct _ThemeSelectorDialogClass ThemeSelectorDialogClass;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
enum  {
	MINES_0_PROPERTY,
	MINES_NUM_PROPERTIES
};
static GParamSpec* mines_properties[MINES_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_LOCATION (location_get_type ())
#define LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCATION, Location))
#define LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCATION, LocationClass))
#define IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCATION))
#define IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCATION))
#define LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCATION, LocationClass))

typedef struct _Location Location;
typedef struct _LocationClass LocationClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

#define TYPE_MINE_WINDOW (mine_window_get_type ())
#define MINE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINE_WINDOW, MineWindow))
#define MINE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINE_WINDOW, MineWindowClass))
#define IS_MINE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINE_WINDOW))
#define IS_MINE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINE_WINDOW))
#define MINE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINE_WINDOW, MineWindowClass))

typedef struct _MineWindow MineWindow;
typedef struct _MineWindowClass MineWindowClass;

struct _Mines {
	AdwApplication parent_instance;
	MinesPrivate * priv;
};

struct _MinesClass {
	AdwApplicationClass parent_class;
};

struct _MinesPrivate {
	GSettings* settings;
	GtkWidget* main_screen;
	GtkBox* main_screen_layout;
	GtkBox* main_screen_sidebar;
	GtkButton* play_pause_button;
	GtkButton* replay_button;
	GtkButton* new_game_button;
	GtkOverlay* minefield_overlay;
	GtkBox* paused_box;
	GtkStack* stack;
	ThemeSelectorDialog* theme_dialog;
	GtkLabel* clock_label;
	GtkMenuButton* menu_button;
	GdkToplevel* surface;
	AdwApplicationWindow* window;
	GtkOrientation current_layout;
	gboolean pause_requested;
	gboolean window_skip_configure;
	GamesScoresContext* context;
	Minefield* minefield;
	MinefieldView* minefield_view;
	GtkLabel* flag_label;
	GtkSpinButton* mines_spin;
	GSimpleAction* new_game_action;
	GSimpleAction* repeat_size_action;
	GSimpleAction* pause_action;
	GSimpleAction** size_actions;
	gint size_actions_length1;
	gint _size_actions_size_;
	GtkAspectFrame* new_game_screen;
	GtkAspectFrame* custom_game_screen;
	GtkGestureClick* view_click_controller;
};

struct _Minefield {
	GObject parent_instance;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	Location** locations;
	gint locations_length1;
	gint locations_length2;
	gboolean exploded;
	gboolean placed_mines;
	gboolean _use_autoflag;
};

struct _MinefieldClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	Mines* self;
	gboolean start_directly;
	gint mode;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gboolean was_paused;
};

static gint Mines_private_offset;
static gpointer mines_parent_class = NULL;
static gint mines_game_mode;
static gint mines_game_mode = -1;

VALA_EXTERN GType mines_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Mines, g_object_unref)
VALA_EXTERN GType theme_selector_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeSelectorDialog, g_object_unref)
VALA_EXTERN GType minefield_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Minefield, g_object_unref)
VALA_EXTERN GType minefield_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MinefieldView, g_object_unref)
static void mines_new_game_cb (Mines* self);
static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void mines_silent_new_game_cb (Mines* self);
static void _mines_silent_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void mines_repeat_size_cb (Mines* self);
static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void mines_small_size_clicked_cb (Mines* self);
static void _mines_small_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void mines_medium_size_clicked_cb (Mines* self);
static void _mines_medium_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void mines_large_size_clicked_cb (Mines* self);
static void _mines_large_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void mines_show_custom_game_screen (Mines* self);
static void _mines_show_custom_game_screen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void mines_show_new_game_screen (Mines* self);
static void _mines_show_new_game_screen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void mines_custom_size_clicked_cb (Mines* self);
static void _mines_custom_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void mines_toggle_pause_cb (Mines* self);
static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void mines_scores_cb (Mines* self);
static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void mines_preferences_cb (Mines* self);
static void _mines_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void mines_quit_cb (Mines* self);
static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self);
static void mines_help_cb (Mines* self);
static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self);
static void mines_about_cb (Mines* self);
static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void mines_menu_cb (Mines* self);
static void _mines_menu_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self);
VALA_EXTERN Mines* mines_new (void);
VALA_EXTERN Mines* mines_construct (GType object_type);
static void mines_real_startup (GApplication* base);
static void mines_create_window (Mines* self);
static inline void mines_init_state_watcher (Mines* self);
static void _mines_init_state_watcher_gtk_widget_map (GtkWidget* _sender,
                                               gpointer self);
static inline void mines_on_window_focus_change (Mines* self);
static void _mines_on_window_focus_change_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
VALA_EXTERN MinefieldView* minefield_view_new (GSettings* settings);
VALA_EXTERN MinefieldView* minefield_view_construct (GType object_type,
                                         GSettings* settings);
static inline void mines_view_button_press_event (Mines* self,
                                    GtkGestureClick* _view_click_controller,
                                    gint n_press,
                                    gdouble x,
                                    gdouble y);
static void _mines_view_button_press_event_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                               gint n_press,
                                                               gdouble x,
                                                               gdouble y,
                                                               gpointer self);
static void mines_startup_new_game_screen (Mines* self,
                                    GtkBuilder* builder);
static void mines_startup_custom_game_screen (Mines* self,
                                       GtkBuilder* builder);
static GamesScoresCategory* mines_create_category_from_key (Mines* self,
                                                     const gchar* key);
static GamesScoresCategory* _mines_create_category_from_key_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                 gpointer self);
static gchar* mines_translate_and_strip_underlines (Mines* self,
                                             const gchar* key);
static void mines_start_game (Mines* self);
static gchar* mines_make_minefield_description (Mines* self,
                                         gint width,
                                         gint height,
                                         gint n_mines);
static void mines_xsize_spin_cb (Mines* self,
                          GtkSpinButton* spin);
static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                         gpointer self);
static void mines_ysize_spin_cb (Mines* self,
                          GtkSpinButton* spin);
static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                         gpointer self);
static void mines_mines_spin_cb (Mines* self,
                          GtkSpinButton* spin);
static void _mines_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                         gpointer self);
static void mines_set_mines_limit (Mines* self);
static void mines_set_main_screen_layout (Mines* self,
                                   GtkOrientation orientation);
static inline void mines_on_layout (Mines* self,
                      GdkSurface* _surface,
                      gint width,
                      gint height);
VALA_EXTERN void minefield_set_paused (Minefield* self,
                           gboolean value);
VALA_EXTERN gboolean minefield_is_clock_started (Minefield* self);
VALA_EXTERN void mines_start (Mines* self);
static void _mines_on_layout_gdk_surface_layout (GdkSurface* _sender,
                                          gint width,
                                          gint height,
                                          gpointer self);
static void mines_real_shutdown (GApplication* base);
static gint mines_real_handle_local_options (GApplication* base,
                                      GVariantDict* options);
static void mines_real_activate (GApplication* base);
VALA_EXTERN gboolean minefield_get_paused (Minefield* self);
static void mines_update_flag_label (Mines* self);
VALA_EXTERN guint minefield_get_n_flags (Minefield* self);
VALA_EXTERN GType location_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Location, g_object_unref)
static void mines_show_scores (Mines* self);
VALA_EXTERN ThemeSelectorDialog* theme_selector_dialog_new (AdwApplicationWindow* window);
VALA_EXTERN ThemeSelectorDialog* theme_selector_dialog_construct (GType object_type,
                                                      AdwApplicationWindow* window);
static void mines_ask_start_new_game (Mines* self,
                               gboolean start_directly,
                               gint mode);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN guint minefield_get_n_cleared (Minefield* self);
VALA_EXTERN gboolean minefield_get_is_complete (Minefield* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void mines_size_actions_toggle (Mines* self,
                                gboolean enabled);
static void ___lambda15_ (Block2Data* _data2_,
                   AdwAlertDialog* _dialog,
                   const gchar* response);
static void ____lambda15__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                              const gchar* response,
                                              gpointer self);
static void mines_disable_game_buttons (Mines* self);
static void mines_set_play_pause_visuals_unpaused (Mines* self);
static void mines_set_replay_tooltip (Mines* self,
                               const gchar* tooltip_text);
static void mines_enable_game_buttons (Mines* self);
VALA_EXTERN Minefield* minefield_new (guint width,
                          guint height,
                          guint n_mines);
VALA_EXTERN Minefield* minefield_construct (GType object_type,
                                guint width,
                                guint height,
                                guint n_mines);
static void mines_marks_changed_cb (Mines* self,
                             Minefield* minefield);
static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender,
                                                      gpointer self);
static void mines_explode_cb (Mines* self,
                       Minefield* minefield);
static void _mines_explode_cb_minefield_explode (Minefield* _sender,
                                          gpointer self);
static void mines_cleared_cb (Mines* self,
                       Minefield* minefield);
static void _mines_cleared_cb_minefield_cleared (Minefield* _sender,
                                          gpointer self);
static void mines_tick_cb (Mines* self);
static void _mines_tick_cb_minefield_tick (Minefield* _sender,
                                    gpointer self);
static void mines_paused_changed_cb (Mines* self);
static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender,
                                                        gpointer self);
static void mines_clock_started_cb (Mines* self);
static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender,
                                                      gpointer self);
VALA_EXTERN void minefield_view_set_minefield (MinefieldView* self,
                                   Minefield* value);
static void mines_set_play_pause_visuals (Mines* self,
                                   const gchar* icon_name,
                                   const gchar* tooltip_text);
static void mines_set_play_pause_visuals_paused (Mines* self);
static void mines_set_game_buttons_enabled (Mines* self,
                                     gboolean value);
VALA_EXTERN gdouble minefield_get_elapsed (Minefield* self);
static void mines_game_ended (Mines* self);
static void _mines_repeat_size_cb_games_scores_context_new_game_func (gpointer self);
static void _mines_quit_cb_games_scores_context_quit_app_func (gpointer self);
static void __lambda16_ (Mines* self,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda16__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static gfloat mines_percent_mines (Mines* self);
static void mines_set_mode (Mines* self,
                     gint mode);
static gint mines_main (gchar** args,
                 gint args_length1);
VALA_EXTERN GType mine_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MineWindow, g_object_unref)
static void mines_finalize (GObject * obj);
static GType mines_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry MINES_option_entries[5] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Print release version and exit"), NULL}, {"small", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Small game"), NULL}, {"medium", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Medium game"), NULL}, {"big", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Big game"), NULL}, {0}};
static const GActionEntry MINES_action_entries[16] = {{"new-game", _mines_new_game_cb_gsimple_action_activate_callback}, {"silent-new-game", _mines_silent_new_game_cb_gsimple_action_activate_callback}, {"repeat-size", _mines_repeat_size_cb_gsimple_action_activate_callback}, {"small-size", _mines_small_size_clicked_cb_gsimple_action_activate_callback}, {"medium-size", _mines_medium_size_clicked_cb_gsimple_action_activate_callback}, {"large-size", _mines_large_size_clicked_cb_gsimple_action_activate_callback}, {"custom-size", _mines_show_custom_game_screen_gsimple_action_activate_callback}, {"cancel-custom", _mines_show_new_game_screen_gsimple_action_activate_callback}, {"start-custom", _mines_custom_size_clicked_cb_gsimple_action_activate_callback}, {"pause", _mines_toggle_pause_cb_gsimple_action_activate_callback}, {"scores", _mines_scores_cb_gsimple_action_activate_callback}, {"preferences", _mines_preferences_cb_gsimple_action_activate_callback}, {"quit", _mines_quit_cb_gsimple_action_activate_callback}, {"help", _mines_help_cb_gsimple_action_activate_callback}, {"about", _mines_about_cb_gsimple_action_activate_callback}, {"menu", _mines_menu_cb_gsimple_action_activate_callback}};

static inline gpointer
mines_get_instance_private (Mines* self)
{
	return G_STRUCT_MEMBER_P (self, Mines_private_offset);
}

static void
_mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	mines_new_game_cb ((Mines*) self);
}

static void
_mines_silent_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	mines_silent_new_game_cb ((Mines*) self);
}

static void
_mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	mines_repeat_size_cb ((Mines*) self);
}

static void
_mines_small_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	mines_small_size_clicked_cb ((Mines*) self);
}

static void
_mines_medium_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	mines_medium_size_clicked_cb ((Mines*) self);
}

static void
_mines_large_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	mines_large_size_clicked_cb ((Mines*) self);
}

static void
_mines_show_custom_game_screen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	mines_show_custom_game_screen ((Mines*) self);
}

static void
_mines_show_new_game_screen_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	mines_show_new_game_screen ((Mines*) self);
}

static void
_mines_custom_size_clicked_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	mines_custom_size_clicked_cb ((Mines*) self);
}

static void
_mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	mines_toggle_pause_cb ((Mines*) self);
}

static void
_mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	mines_scores_cb ((Mines*) self);
}

static void
_mines_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	mines_preferences_cb ((Mines*) self);
}

static void
_mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                 GVariant* parameter,
                                                 gpointer self)
{
	mines_quit_cb ((Mines*) self);
}

static void
_mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                 GVariant* parameter,
                                                 gpointer self)
{
	mines_help_cb ((Mines*) self);
}

static void
_mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	mines_about_cb ((Mines*) self);
}

static void
_mines_menu_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                 GVariant* parameter,
                                                 gpointer self)
{
	mines_menu_cb ((Mines*) self);
}

Mines*
mines_construct (GType object_type)
{
	Mines * self = NULL;
	self = (Mines*) g_object_new (object_type, "application-id", "org.gnome.Mines", "flags", G_APPLICATION_FLAGS_NONE, "resource-base-path", "/org/gnome/Mines", NULL);
	g_application_add_main_option_entries ((GApplication*) self, MINES_option_entries);
	return self;
}

Mines*
mines_new (void)
{
	return mines_construct (TYPE_MINES);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mines_real_startup (GApplication* base)
{
	Mines * self;
	GSettings* _tmp0_;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction** _tmp11_;
	gint _tmp11__length1;
	GAction* _tmp12_;
	GSimpleAction* _tmp13_;
	GSimpleAction** _tmp14_;
	gint _tmp14__length1;
	GAction* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction** _tmp17_;
	gint _tmp17__length1;
	GAction* _tmp18_;
	GSimpleAction* _tmp19_;
	GSimpleAction** _tmp20_;
	gint _tmp20__length1;
	GAction* _tmp21_;
	GSimpleAction* _tmp22_;
	GSettings* _tmp23_;
	GAction* _tmp24_;
	GAction* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar** _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar** _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar** _tmp49_;
	gchar** _tmp50_;
	gint _tmp50__length1;
	gchar* _tmp51_;
	gchar** _tmp52_;
	gchar** _tmp53_;
	gint _tmp53__length1;
	gchar* _tmp54_;
	gchar** _tmp55_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar** _tmp59_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	gchar* _tmp61_;
	gchar** _tmp62_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	g_set_application_name (_ ("Mines"));
	g_set_prgname ("org.gnome.Mines");
	_tmp0_ = g_settings_new ("org.gnome.Mines");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	if (mines_game_mode != -1) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->settings;
		g_settings_set_int (_tmp1_, MINES_KEY_MODE, mines_game_mode);
	}
	g_action_map_add_action_entries ((GActionMap*) self, MINES_action_entries, (gint) G_N_ELEMENTS (MINES_action_entries), self);
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp3_;
	_tmp4_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp4_, TRUE);
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "repeat-size");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp5_) : NULL);
	_g_object_unref0 (self->priv->repeat_size_action);
	self->priv->repeat_size_action = _tmp6_;
	_tmp7_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp7_, FALSE);
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp8_) : NULL);
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp9_;
	_tmp10_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp10_, FALSE);
	_tmp11_ = self->priv->size_actions;
	_tmp11__length1 = self->priv->size_actions_length1;
	_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "small-size");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp12_) : NULL);
	_g_object_unref0 (_tmp11_[0]);
	_tmp11_[0] = _tmp13_;
	_tmp14_ = self->priv->size_actions;
	_tmp14__length1 = self->priv->size_actions_length1;
	_tmp15_ = g_action_map_lookup_action ((GActionMap*) self, "medium-size");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp15_) : NULL);
	_g_object_unref0 (_tmp14_[1]);
	_tmp14_[1] = _tmp16_;
	_tmp17_ = self->priv->size_actions;
	_tmp17__length1 = self->priv->size_actions_length1;
	_tmp18_ = g_action_map_lookup_action ((GActionMap*) self, "large-size");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp18_) : NULL);
	_g_object_unref0 (_tmp17_[2]);
	_tmp17_[2] = _tmp19_;
	_tmp20_ = self->priv->size_actions;
	_tmp20__length1 = self->priv->size_actions_length1;
	_tmp21_ = g_action_map_lookup_action ((GActionMap*) self, "custom-size");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp21_) : NULL);
	_g_object_unref0 (_tmp20_[3]);
	_tmp20_[3] = _tmp22_;
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_create_action (_tmp23_, MINES_KEY_USE_QUESTION_MARKS);
	_tmp25_ = _tmp24_;
	g_action_map_add_action ((GActionMap*) self, _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = g_strdup ("<Control>n");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = g_strdup ("Escape");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.silent-new-game", _tmp31_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = g_strdup ("<Control>r");
	_tmp33_ = g_new0 (gchar*, 1 + 1);
	_tmp33_[0] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.repeat-size", _tmp34_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	_tmp35_ = g_strdup ("1");
	_tmp36_ = g_strdup ("KP_1");
	_tmp37_ = g_new0 (gchar*, 2 + 1);
	_tmp37_[0] = _tmp35_;
	_tmp37_[1] = _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp38__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.small-size", _tmp38_);
	_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
	_tmp39_ = g_strdup ("2");
	_tmp40_ = g_strdup ("KP_2");
	_tmp41_ = g_new0 (gchar*, 2 + 1);
	_tmp41_[0] = _tmp39_;
	_tmp41_[1] = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp42__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.medium-size", _tmp42_);
	_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
	_tmp43_ = g_strdup ("3");
	_tmp44_ = g_strdup ("KP_3");
	_tmp45_ = g_new0 (gchar*, 2 + 1);
	_tmp45_[0] = _tmp43_;
	_tmp45_[1] = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp46__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.large-size", _tmp46_);
	_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_free), NULL);
	_tmp47_ = g_strdup ("4");
	_tmp48_ = g_strdup ("KP_4");
	_tmp49_ = g_new0 (gchar*, 2 + 1);
	_tmp49_[0] = _tmp47_;
	_tmp49_[1] = _tmp48_;
	_tmp50_ = _tmp49_;
	_tmp50__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.custom-size", _tmp50_);
	_tmp50_ = (_vala_array_free (_tmp50_, _tmp50__length1, (GDestroyNotify) g_free), NULL);
	_tmp51_ = g_strdup ("Pause");
	_tmp52_ = g_new0 (gchar*, 1 + 1);
	_tmp52_[0] = _tmp51_;
	_tmp53_ = _tmp52_;
	_tmp53__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp53_);
	_tmp53_ = (_vala_array_free (_tmp53_, _tmp53__length1, (GDestroyNotify) g_free), NULL);
	_tmp54_ = g_strdup ("F1");
	_tmp55_ = g_new0 (gchar*, 1 + 1);
	_tmp55_[0] = _tmp54_;
	_tmp56_ = _tmp55_;
	_tmp56__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp56_);
	_tmp56_ = (_vala_array_free (_tmp56_, _tmp56__length1, (GDestroyNotify) g_free), NULL);
	_tmp57_ = g_strdup ("<Control>q");
	_tmp58_ = g_strdup ("<Control>w");
	_tmp59_ = g_new0 (gchar*, 2 + 1);
	_tmp59_[0] = _tmp57_;
	_tmp59_[1] = _tmp58_;
	_tmp60_ = _tmp59_;
	_tmp60__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp60_);
	_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
	_tmp61_ = g_strdup ("F10");
	_tmp62_ = g_new0 (gchar*, 1 + 1);
	_tmp62_[0] = _tmp61_;
	_tmp63_ = _tmp62_;
	_tmp63__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.menu", _tmp63_);
	_tmp63_ = (_vala_array_free (_tmp63_, _tmp63__length1, (GDestroyNotify) g_free), NULL);
}

static void
_mines_init_state_watcher_gtk_widget_map (GtkWidget* _sender,
                                          gpointer self)
{
	mines_init_state_watcher ((Mines*) self);
}

static void
_mines_on_window_focus_change_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	mines_on_window_focus_change ((Mines*) self);
}

static void
_mines_view_button_press_event_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                          gint n_press,
                                                          gdouble x,
                                                          gdouble y,
                                                          gpointer self)
{
	mines_view_button_press_event ((Mines*) self, _sender, n_press, x, y);
}

static GamesScoresCategory*
_mines_create_category_from_key_games_scores_context_category_request_func (const gchar* category_key,
                                                                            gpointer self)
{
	GamesScoresCategory* result;
	result = mines_create_category_from_key ((Mines*) self, category_key);
	return result;
}

static void
mines_create_window (Mines* self)
{
	GtkBuilder* ui_builder = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp3_;
	AdwApplicationWindow* _tmp4_;
	AdwApplicationWindow* _tmp5_;
	AdwApplicationWindow* _tmp6_;
	AdwApplicationWindow* _tmp7_;
	GObject* _tmp8_;
	GtkMenuButton* _tmp9_;
	GSettings* _tmp10_;
	MinefieldView* _tmp11_;
	GObject* _tmp12_;
	GtkStack* _tmp13_;
	GObject* _tmp14_;
	GtkOverlay* _tmp15_;
	GtkOverlay* _tmp16_;
	MinefieldView* _tmp17_;
	GObject* _tmp18_;
	GtkBox* _tmp19_;
	GtkGestureClick* _tmp20_;
	GtkGestureClick* _tmp21_;
	GtkBox* _tmp22_;
	GtkGestureClick* _tmp23_;
	GtkEventController* _tmp24_;
	GtkOverlay* _tmp25_;
	GtkBox* _tmp26_;
	GObject* _tmp27_;
	GtkWidget* _tmp28_;
	GObject* _tmp29_;
	GtkBox* _tmp30_;
	GObject* _tmp31_;
	GtkBox* _tmp32_;
	AdwApplicationWindow* _tmp33_;
	GamesScoresContext* _tmp34_;
	GObject* _tmp35_;
	GtkLabel* _tmp36_;
	GObject* _tmp37_;
	GtkLabel* _tmp38_;
	GObject* _tmp39_;
	GtkButton* _tmp40_;
	GObject* _tmp41_;
	GtkButton* _tmp42_;
	GObject* _tmp43_;
	GtkButton* _tmp44_;
	GtkButton* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_new ();
	ui_builder = _tmp0_;
	{
		gtk_builder_add_from_resource (ui_builder, "/org/gnome/Mines/interface.ui", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("gnome-mines.vala:175: Could not load game UI: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (ui_builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = gtk_builder_get_object (ui_builder, "main_window");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, adw_application_window_get_type (), AdwApplicationWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp4_;
	_tmp5_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "map", (GCallback) _mines_init_state_watcher_gtk_widget_map, self, 0);
	_tmp6_ = self->priv->window;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::is-active", (GCallback) _mines_on_window_focus_change_g_object_notify, self, 0);
	_tmp7_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp7_);
	_tmp8_ = gtk_builder_get_object (ui_builder, "menu_button");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_menu_button_get_type (), GtkMenuButton));
	_g_object_unref0 (self->priv->menu_button);
	self->priv->menu_button = _tmp9_;
	_tmp10_ = self->priv->settings;
	_tmp11_ = minefield_view_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->minefield_view);
	self->priv->minefield_view = _tmp11_;
	_tmp12_ = gtk_builder_get_object (ui_builder, "stack");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp13_;
	_tmp14_ = gtk_builder_get_object (ui_builder, "minefield_overlay");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_overlay_get_type (), GtkOverlay));
	_g_object_unref0 (self->priv->minefield_overlay);
	self->priv->minefield_overlay = _tmp15_;
	_tmp16_ = self->priv->minefield_overlay;
	_tmp17_ = self->priv->minefield_view;
	gtk_overlay_set_child (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = gtk_builder_get_object (ui_builder, "paused_box");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->paused_box);
	self->priv->paused_box = _tmp19_;
	_tmp20_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->view_click_controller);
	self->priv->view_click_controller = _tmp20_;
	_tmp21_ = self->priv->view_click_controller;
	g_signal_connect_object (_tmp21_, "pressed", (GCallback) _mines_view_button_press_event_gtk_gesture_click_pressed, self, 0);
	_tmp22_ = self->priv->paused_box;
	_tmp23_ = self->priv->view_click_controller;
	_tmp24_ = _g_object_ref0 ((GtkEventController*) _tmp23_);
	gtk_widget_add_controller ((GtkWidget*) _tmp22_, _tmp24_);
	_tmp25_ = self->priv->minefield_overlay;
	_tmp26_ = self->priv->paused_box;
	gtk_overlay_add_overlay (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = gtk_builder_get_object (ui_builder, "main_screen");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->main_screen);
	self->priv->main_screen = _tmp28_;
	_tmp29_ = gtk_builder_get_object (ui_builder, "main_screen_layout");
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->main_screen_layout);
	self->priv->main_screen_layout = _tmp30_;
	_tmp31_ = gtk_builder_get_object (ui_builder, "main_screen_sidebar");
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->main_screen_sidebar);
	self->priv->main_screen_sidebar = _tmp32_;
	mines_startup_new_game_screen (self, ui_builder);
	mines_startup_custom_game_screen (self, ui_builder);
	_tmp33_ = self->priv->window;
	_tmp34_ = games_scores_context_new ("org.gnome.Mines", _ ("Minefield:"), (GtkWindow*) _tmp33_, _mines_create_category_from_key_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_TIME_LESS_IS_BETTER, NULL);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp34_;
	_tmp35_ = gtk_builder_get_object (ui_builder, "flag_label");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->flag_label);
	self->priv->flag_label = _tmp36_;
	_tmp37_ = gtk_builder_get_object (ui_builder, "clock_label");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp38_;
	_tmp39_ = gtk_builder_get_object (ui_builder, "play_pause_button");
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->play_pause_button);
	self->priv->play_pause_button = _tmp40_;
	_tmp41_ = gtk_builder_get_object (ui_builder, "replay_button");
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->replay_button);
	self->priv->replay_button = _tmp42_;
	_tmp43_ = gtk_builder_get_object (ui_builder, "new_game_button");
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp44_;
	_tmp45_ = self->priv->new_game_button;
	_tmp46_ = mines_translate_and_strip_underlines (self, "Change _Difficulty");
	_tmp47_ = _tmp46_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp45_, _tmp47_);
	_g_free0 (_tmp47_);
	if (mines_game_mode != -1) {
		mines_start_game (self);
	}
	_g_object_unref0 (ui_builder);
}

static GamesScoresCategory*
mines_create_category_from_key (Mines* self,
                                const gchar* key)
{
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint width = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gint height = 0;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gint num_mines = 0;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GamesScoresCategory* _tmp13_;
	GamesScoresCategory* _tmp14_;
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (key, "-", 0);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	if (_tmp2__length1 != 3) {
		result = NULL;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp3_ = tokens;
	_tmp3__length1 = tokens_length1;
	_tmp4_ = _tmp3_[0];
	width = atoi (_tmp4_);
	_tmp5_ = tokens;
	_tmp5__length1 = tokens_length1;
	_tmp6_ = _tmp5_[1];
	height = atoi (_tmp6_);
	_tmp7_ = tokens;
	_tmp7__length1 = tokens_length1;
	_tmp8_ = _tmp7_[2];
	num_mines = atoi (_tmp8_);
	if (width <= 0) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = height <= 0;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = num_mines <= 0;
	}
	if (_tmp9_) {
		result = NULL;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp11_ = g_strdup_printf (ngettext ("%d × %d, %d mine", "%d × %d, %d mines", (gulong) num_mines), width, height, num_mines);
	_tmp12_ = _tmp11_;
	_tmp13_ = games_scores_category_new (key, _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	result = _tmp14_;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
mines_startup_new_game_screen (Mines* self,
                               GtkBuilder* builder)
{
	GObject* _tmp0_;
	GtkAspectFrame* _tmp1_;
	GtkButton* button = NULL;
	GObject* _tmp2_;
	GtkButton* _tmp3_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkLabel* _tmp8_;
	GtkButton* _tmp9_;
	GtkLabel* _tmp10_;
	GObject* _tmp11_;
	GtkButton* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkLabel* _tmp17_;
	GtkButton* _tmp18_;
	GtkLabel* _tmp19_;
	GObject* _tmp20_;
	GtkButton* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GtkLabel* _tmp26_;
	GtkButton* _tmp27_;
	GtkLabel* _tmp28_;
	GObject* _tmp29_;
	GtkButton* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GtkLabel* _tmp35_;
	GtkButton* _tmp36_;
	GtkLabel* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = gtk_builder_get_object (builder, "new_game_screen");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->new_game_screen);
	self->priv->new_game_screen = _tmp1_;
	_tmp2_ = gtk_builder_get_object (builder, "small_size_btn");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_button_get_type (), GtkButton));
	button = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp4_);
	label = _tmp4_;
	_tmp5_ = label;
	_tmp6_ = mines_make_minefield_description (self, 8, 8, 10);
	_tmp7_ = _tmp6_;
	gtk_label_set_markup (_tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = label;
	gtk_label_set_justify (_tmp8_, GTK_JUSTIFY_CENTER);
	_tmp9_ = button;
	_tmp10_ = label;
	gtk_button_set_child (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = gtk_builder_get_object (builder, "medium_size_btn");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp12_;
	_tmp13_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (label);
	label = _tmp13_;
	_tmp14_ = label;
	_tmp15_ = mines_make_minefield_description (self, 16, 16, 40);
	_tmp16_ = _tmp15_;
	gtk_label_set_markup (_tmp14_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = label;
	gtk_label_set_justify (_tmp17_, GTK_JUSTIFY_CENTER);
	_tmp18_ = button;
	_tmp19_ = label;
	gtk_button_set_child (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = gtk_builder_get_object (builder, "large_size_btn");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp21_;
	_tmp22_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (label);
	label = _tmp22_;
	_tmp23_ = label;
	_tmp24_ = mines_make_minefield_description (self, 30, 16, 99);
	_tmp25_ = _tmp24_;
	gtk_label_set_markup (_tmp23_, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = label;
	gtk_label_set_justify (_tmp26_, GTK_JUSTIFY_CENTER);
	_tmp27_ = button;
	_tmp28_ = label;
	gtk_button_set_child (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = gtk_builder_get_object (builder, "custom_size_btn");
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp30_;
	_tmp31_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (label);
	label = _tmp31_;
	_tmp32_ = label;
	_tmp33_ = g_strconcat ("<span size='xx-large' weight='heavy'>?</span>\n", g_dpgettext2 (NULL, "board size", _ ("Custom")), NULL);
	_tmp34_ = _tmp33_;
	gtk_label_set_markup_with_mnemonic (_tmp32_, _tmp34_);
	_g_free0 (_tmp34_);
	_tmp35_ = label;
	gtk_label_set_justify (_tmp35_, GTK_JUSTIFY_CENTER);
	_tmp36_ = button;
	_tmp37_ = label;
	gtk_button_set_child (_tmp36_, (GtkWidget*) _tmp37_);
	_g_object_unref0 (label);
	_g_object_unref0 (button);
}

static void
_mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                    gpointer self)
{
	mines_xsize_spin_cb ((Mines*) self, _sender);
}

static void
_mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                    gpointer self)
{
	mines_ysize_spin_cb ((Mines*) self, _sender);
}

static void
_mines_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                    gpointer self)
{
	mines_mines_spin_cb ((Mines*) self, _sender);
}

static void
mines_startup_custom_game_screen (Mines* self,
                                  GtkBuilder* builder)
{
	GObject* _tmp0_;
	GtkAspectFrame* _tmp1_;
	GtkSpinButton* field_width_entry = NULL;
	GObject* _tmp2_;
	GtkSpinButton* _tmp3_;
	GSettings* _tmp4_;
	GtkSpinButton* field_height_entry = NULL;
	GObject* _tmp5_;
	GtkSpinButton* _tmp6_;
	GSettings* _tmp7_;
	GObject* _tmp8_;
	GtkSpinButton* _tmp9_;
	GtkSpinButton* _tmp10_;
	GtkSpinButton* _tmp11_;
	GtkSpinButton* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = gtk_builder_get_object (builder, "custom_game_screen");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->custom_game_screen);
	self->priv->custom_game_screen = _tmp1_;
	_tmp2_ = gtk_builder_get_object (builder, "width_spin_btn");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_spin_button_get_type (), GtkSpinButton));
	field_width_entry = _tmp3_;
	gtk_spin_button_set_range (field_width_entry, (gdouble) MINES_XSIZE_MIN, (gdouble) MINES_XSIZE_MAX);
	g_signal_connect_object (field_width_entry, "value-changed", (GCallback) _mines_xsize_spin_cb_gtk_spin_button_value_changed, self, 0);
	gtk_spin_button_set_increments (field_width_entry, (gdouble) 1, (gdouble) 1);
	_tmp4_ = self->priv->settings;
	gtk_spin_button_set_value (field_width_entry, (gdouble) g_settings_get_int (_tmp4_, MINES_KEY_XSIZE));
	_tmp5_ = gtk_builder_get_object (builder, "height_spin_btn");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_spin_button_get_type (), GtkSpinButton));
	field_height_entry = _tmp6_;
	gtk_spin_button_set_range (field_height_entry, (gdouble) MINES_YSIZE_MIN, (gdouble) MINES_YSIZE_MAX);
	g_signal_connect_object (field_height_entry, "value-changed", (GCallback) _mines_ysize_spin_cb_gtk_spin_button_value_changed, self, 0);
	gtk_spin_button_set_increments (field_height_entry, (gdouble) 1, (gdouble) 1);
	_tmp7_ = self->priv->settings;
	gtk_spin_button_set_value (field_height_entry, (gdouble) g_settings_get_int (_tmp7_, MINES_KEY_YSIZE));
	_tmp8_ = gtk_builder_get_object (builder, "mines_spin_btn");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_spin_button_get_type (), GtkSpinButton));
	_g_object_unref0 (self->priv->mines_spin);
	self->priv->mines_spin = _tmp9_;
	_tmp10_ = self->priv->mines_spin;
	gtk_spin_button_set_range (_tmp10_, (gdouble) 1, (gdouble) 100);
	_tmp11_ = self->priv->mines_spin;
	gtk_spin_button_set_increments (_tmp11_, (gdouble) 1, (gdouble) 1);
	_tmp12_ = self->priv->mines_spin;
	g_signal_connect_object (_tmp12_, "value-changed", (GCallback) _mines_mines_spin_cb_gtk_spin_button_value_changed, self, 0);
	mines_set_mines_limit (self);
	_g_object_unref0 (field_height_entry);
	_g_object_unref0 (field_width_entry);
}

static void
mines_set_main_screen_layout (Mines* self,
                              GtkOrientation orientation)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	g_return_if_fail (self != NULL);
	if (orientation == self->priv->current_layout) {
		return;
	}
	_tmp0_ = self->priv->main_screen_layout;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp0_, orientation);
	_tmp1_ = self->priv->main_screen_sidebar;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp1_, self->priv->current_layout);
	self->priv->current_layout = orientation;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
mines_translate_and_strip_underlines (Mines* self,
                                      const gchar* key)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = string_replace (_ (key), "_", "");
	result = _tmp0_;
	return result;
}

static inline void
mines_on_layout (Mines* self,
                 GdkSurface* _surface,
                 gint width,
                 gint height)
{
	GtkOrientation _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_surface != NULL);
	if (width > height) {
		_tmp0_ = GTK_ORIENTATION_HORIZONTAL;
	} else {
		_tmp0_ = GTK_ORIENTATION_VERTICAL;
	}
	mines_set_main_screen_layout (self, _tmp0_);
}

static inline void
mines_on_window_focus_change (Mines* self)
{
	AdwApplicationWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	g_object_get ((GtkWindow*) _tmp0_, "is-active", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		Minefield* _tmp5_;
		_tmp5_ = self->priv->minefield;
		if (_tmp5_ != NULL) {
			_tmp4_ = !self->priv->pause_requested;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gboolean _tmp6_ = FALSE;
			ThemeSelectorDialog* _tmp7_;
			_tmp7_ = self->priv->theme_dialog;
			if (_tmp7_ == NULL) {
				_tmp6_ = TRUE;
			} else {
				ThemeSelectorDialog* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				_tmp8_ = self->priv->theme_dialog;
				_tmp9_ = gtk_widget_get_visible ((GtkWidget*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp6_ = _tmp10_ == FALSE;
			}
			_tmp3_ = _tmp6_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			Minefield* _tmp11_;
			_tmp11_ = self->priv->minefield;
			minefield_set_paused (_tmp11_, FALSE);
		}
	} else {
		gboolean _tmp12_ = FALSE;
		Minefield* _tmp13_;
		_tmp13_ = self->priv->minefield;
		if (_tmp13_ != NULL) {
			Minefield* _tmp14_;
			_tmp14_ = self->priv->minefield;
			_tmp12_ = minefield_is_clock_started (_tmp14_);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			Minefield* _tmp15_;
			_tmp15_ = self->priv->minefield;
			minefield_set_paused (_tmp15_, TRUE);
		}
	}
}

static gchar*
mines_make_minefield_description (Mines* self,
                                  gint width,
                                  gint height,
                                  gint n_mines)
{
	gchar* size_label = NULL;
	gchar* _tmp0_;
	gchar* mines_label = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%d × %d", width, height);
	size_label = _tmp0_;
	_tmp1_ = g_strdup_printf (ngettext ("<b>%d</b> mine", "<b>%d</b> mines", (gulong) n_mines), n_mines);
	mines_label = _tmp1_;
	_tmp2_ = g_strdup_printf ("<span size='x-large' weight='ultrabold'>%s</span>\n%s", size_label, mines_label);
	result = _tmp2_;
	_g_free0 (mines_label);
	_g_free0 (size_label);
	return result;
}

void
mines_start (Mines* self)
{
	AdwApplicationWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
	mines_show_new_game_screen (self);
}

static void
_mines_on_layout_gdk_surface_layout (GdkSurface* _sender,
                                     gint width,
                                     gint height,
                                     gpointer self)
{
	mines_on_layout ((Mines*) self, _sender, width, height);
}

static inline void
mines_init_state_watcher (Mines* self)
{
	GdkSurface* nullable_surface = NULL;
	AdwApplicationWindow* _tmp0_;
	GdkSurface* _tmp1_;
	GdkSurface* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GdkSurface* _tmp4_;
	GdkSurface* _tmp6_;
	GdkToplevel* _tmp7_;
	GdkToplevel* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = gtk_native_get_surface ((GtkNative*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	nullable_surface = _tmp2_;
	_tmp4_ = nullable_surface;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GdkSurface* _tmp5_;
		_tmp5_ = nullable_surface;
		_tmp3_ = !G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_surface_get_type (), GdkSurface), gdk_toplevel_get_type ());
	}
	if (_tmp3_) {
		g_assert_not_reached ();
	}
	_tmp6_ = nullable_surface;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gdk_surface_get_type (), GdkSurface), gdk_toplevel_get_type (), GdkToplevel));
	_g_object_unref0 (self->priv->surface);
	self->priv->surface = _tmp7_;
	_tmp8_ = self->priv->surface;
	g_signal_connect_object ((GdkSurface*) _tmp8_, "layout", (GCallback) _mines_on_layout_gdk_surface_layout, self, 0);
	_g_object_unref0 (nullable_surface);
}

static void
mines_real_shutdown (GApplication* base)
{
	Mines * self;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
}

static gint
mines_real_handle_local_options (GApplication* base,
                                 GVariantDict* options)
{
	Mines * self;
	gint result;
	self = (Mines*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "%1$s %2$s\n", "gnome-mines", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (g_variant_dict_contains (options, "small")) {
		mines_game_mode = 0;
	}
	if (g_variant_dict_contains (options, "medium")) {
		mines_game_mode = 1;
	}
	if (g_variant_dict_contains (options, "big")) {
		mines_game_mode = 2;
	}
	result = -1;
	return result;
}

static void
mines_real_activate (GApplication* base)
{
	Mines * self;
	AdwApplicationWindow* _tmp0_;
	AdwApplicationWindow* _tmp1_;
	self = (Mines*) base;
	_tmp0_ = self->priv->window;
	if (_tmp0_ == NULL) {
		mines_create_window (self);
	}
	_tmp1_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp1_);
}

static inline void
mines_view_button_press_event (Mines* self,
                               GtkGestureClick* _view_click_controller,
                               gint n_press,
                               gdouble x,
                               gdouble y)
{
	Minefield* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	Minefield* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_view_click_controller != NULL);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->minefield;
	minefield_set_paused (_tmp3_, FALSE);
	self->priv->pause_requested = FALSE;
}

static void
mines_quit_cb (Mines* self)
{
	AdwApplicationWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		AdwApplicationWindow* _tmp1_;
		_tmp1_ = self->priv->window;
		gtk_window_close ((GtkWindow*) _tmp1_);
	}
}

static void
mines_update_flag_label (Mines* self)
{
	GtkLabel* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	Minefield* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flag_label;
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_n_flags (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->minefield;
	_tmp5_ = g_strdup_printf ("%u/%u", _tmp3_, _tmp4_->n_mines);
	_tmp6_ = _tmp5_;
	gtk_label_set_text (_tmp0_, _tmp6_);
	_g_free0 (_tmp6_);
}

static void
mines_show_scores (Mines* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	games_scores_context_present_dialog (_tmp0_);
}

static void
mines_scores_cb (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_show_scores (self);
}

static void
mines_preferences_cb (Mines* self)
{
	AdwApplicationWindow* _tmp0_;
	ThemeSelectorDialog* _tmp1_;
	ThemeSelectorDialog* _tmp2_;
	AdwApplicationWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = theme_selector_dialog_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->theme_dialog);
	self->priv->theme_dialog = _tmp1_;
	_tmp2_ = self->priv->theme_dialog;
	_tmp3_ = self->priv->window;
	adw_dialog_present ((AdwDialog*) _tmp2_, (GtkWidget*) _tmp3_);
}

static void
mines_show_custom_game_screen (Mines* self)
{
	Minefield* _tmp0_;
	GtkStack* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp1_, "custom_game");
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Mines* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Mines* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda15_ (Block2Data* _data2_,
              AdwAlertDialog* _dialog,
              const gchar* response)
{
	Block1Data* _data1_;
	Mines* self;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (_dialog != NULL);
	g_return_if_fail (response != NULL);
	g_signal_emit_by_name ((GtkWidget*) _dialog, "destroy");
	if (g_strcmp0 (response, "accept") != 0) {
		Minefield* _tmp0_;
		_tmp0_ = self->priv->minefield;
		minefield_set_paused (_tmp0_, _data2_->was_paused);
	} else {
		if (_data1_->start_directly) {
			gboolean _tmp1_ = FALSE;
			if (_data1_->mode != -1) {
				GSettings* _tmp2_;
				_tmp2_ = self->priv->settings;
				_tmp1_ = _data1_->mode != g_settings_get_int (_tmp2_, MINES_KEY_MODE);
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				GSettings* _tmp3_;
				_tmp3_ = self->priv->settings;
				g_settings_set_int (_tmp3_, MINES_KEY_MODE, _data1_->mode);
			}
			mines_start_game (self);
		} else {
			mines_show_new_game_screen (self);
		}
	}
	mines_size_actions_toggle (self, TRUE);
}

static void
____lambda15__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                         const gchar* response,
                                         gpointer self)
{
	___lambda15_ (self, _sender, response);
}

static void
mines_ask_start_new_game (Mines* self,
                          gboolean start_directly,
                          gint mode)
{
	Block1Data* _data1_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Minefield* _tmp3_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->start_directly = start_directly;
	_data1_->mode = mode;
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		_tmp4_ = self->priv->minefield;
		_tmp5_ = minefield_get_n_cleared (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ > ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Minefield* _tmp7_;
		_tmp7_ = self->priv->minefield;
		_tmp1_ = !_tmp7_->exploded;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Minefield* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->minefield;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = !_tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Block2Data* _data2_;
		Minefield* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		Minefield* _tmp14_;
		AdwAlertDialog* dialog = NULL;
		AdwAlertDialog* _tmp15_;
		AdwAlertDialog* _tmp16_;
		AdwAlertDialog* _tmp17_;
		AdwAlertDialog* _tmp18_;
		AdwAlertDialog* _tmp19_;
		AdwAlertDialog* _tmp20_;
		AdwAlertDialog* _tmp21_;
		AdwApplicationWindow* _tmp22_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		_tmp11_ = self->priv->minefield;
		_tmp12_ = minefield_get_paused (_tmp11_);
		_tmp13_ = _tmp12_;
		_data2_->was_paused = _tmp13_;
		_tmp14_ = self->priv->minefield;
		minefield_set_paused (_tmp14_, TRUE);
		mines_size_actions_toggle (self, FALSE);
		_tmp15_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("Do you want to start a new game?"), "%s");
		g_object_ref_sink (_tmp15_);
		dialog = _tmp15_;
		_tmp16_ = dialog;
		adw_alert_dialog_set_body (_tmp16_, _ ("If you start a new game, your current progress will be lost."));
		_tmp17_ = dialog;
		adw_alert_dialog_add_responses (_tmp17_, "accept", _ ("Start New Game"), "delete_event", _ ("Keep Current Game"), NULL);
		_tmp18_ = dialog;
		g_signal_connect_data (_tmp18_, "response", (GCallback) ____lambda15__adw_alert_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_tmp19_ = dialog;
		adw_alert_dialog_set_default_response (_tmp19_, "delete_event");
		_tmp20_ = dialog;
		adw_alert_dialog_set_response_appearance (_tmp20_, "accept", ADW_RESPONSE_DESTRUCTIVE);
		_tmp21_ = dialog;
		_tmp22_ = self->priv->window;
		adw_dialog_present ((AdwDialog*) _tmp21_, (GtkWidget*) _tmp22_);
		_g_object_unref0 (dialog);
		block2_data_unref (_data2_);
		_data2_ = NULL;
	} else {
		if (_data1_->start_directly) {
			gboolean _tmp23_ = FALSE;
			if (_data1_->mode != -1) {
				GSettings* _tmp24_;
				_tmp24_ = self->priv->settings;
				_tmp23_ = _data1_->mode != g_settings_get_int (_tmp24_, MINES_KEY_MODE);
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				GSettings* _tmp25_;
				_tmp25_ = self->priv->settings;
				g_settings_set_int (_tmp25_, MINES_KEY_MODE, _data1_->mode);
			}
			mines_start_game (self);
		} else {
			mines_show_new_game_screen (self);
		}
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
mines_show_new_game_screen (Mines* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	Minefield* _tmp3_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GtkStack* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "new_game") == 0) {
		return;
	}
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		_tmp4_ = self->priv->minefield;
		minefield_set_paused (_tmp4_, TRUE);
		self->priv->pause_requested = FALSE;
		_tmp5_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp5_, NULL, self);
	}
	_g_object_unref0 (self->priv->minefield);
	self->priv->minefield = NULL;
	_tmp6_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp6_, FALSE);
	_tmp7_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp7_, FALSE);
	_tmp8_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp8_, "new_game");
	mines_disable_game_buttons (self);
}

static void
mines_size_actions_toggle (Mines* self,
                           gboolean enabled)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GSimpleAction** _tmp2_;
				gint _tmp2__length1;
				GSimpleAction** _tmp3_;
				gint _tmp3__length1;
				GSimpleAction* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->size_actions;
				_tmp2__length1 = self->priv->size_actions_length1;
				if (!(i < _tmp2__length1)) {
					break;
				}
				_tmp3_ = self->priv->size_actions;
				_tmp3__length1 = self->priv->size_actions_length1;
				_tmp4_ = _tmp3_[i];
				g_simple_action_set_enabled (_tmp4_, enabled);
			}
		}
	}
}

static void
_mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender,
                                                 gpointer self)
{
	mines_marks_changed_cb ((Mines*) self, _sender);
}

static void
_mines_explode_cb_minefield_explode (Minefield* _sender,
                                     gpointer self)
{
	mines_explode_cb ((Mines*) self, _sender);
}

static void
_mines_cleared_cb_minefield_cleared (Minefield* _sender,
                                     gpointer self)
{
	mines_cleared_cb ((Mines*) self, _sender);
}

static void
_mines_tick_cb_minefield_tick (Minefield* _sender,
                               gpointer self)
{
	mines_tick_cb ((Mines*) self);
}

static void
_mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender,
                                                   gpointer self)
{
	mines_paused_changed_cb ((Mines*) self);
}

static void
_mines_clock_started_cb_minefield_clock_started (Minefield* _sender,
                                                 gpointer self)
{
	mines_clock_started_cb ((Mines*) self);
}

static void
mines_start_game (Mines* self)
{
	MinefieldView* _tmp0_;
	GSimpleAction* _tmp1_;
	gint x = 0;
	gint y = 0;
	gint n = 0;
	GSettings* _tmp2_;
	Minefield* _tmp6_;
	Minefield* _tmp8_;
	Minefield* _tmp9_;
	Minefield* _tmp10_;
	Minefield* _tmp11_;
	Minefield* _tmp12_;
	Minefield* _tmp13_;
	Minefield* _tmp14_;
	MinefieldView* _tmp15_;
	Minefield* _tmp16_;
	Minefield* _tmp17_;
	GtkStack* _tmp18_;
	GSimpleAction* _tmp19_;
	g_return_if_fail (self != NULL);
	self->priv->window_skip_configure = TRUE;
	_tmp0_ = self->priv->minefield_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	mines_set_play_pause_visuals_unpaused (self);
	mines_set_replay_tooltip (self, _ ("St_art Over"));
	mines_enable_game_buttons (self);
	_tmp2_ = self->priv->settings;
	switch (g_settings_get_int (_tmp2_, MINES_KEY_MODE)) {
		case 0:
		{
			x = 8;
			y = 8;
			n = 10;
			break;
		}
		case 1:
		{
			x = 16;
			y = 16;
			n = 40;
			break;
		}
		case 2:
		{
			x = 30;
			y = 16;
			n = 99;
			break;
		}
		default:
		case 3:
		{
			GSettings* _tmp3_;
			GSettings* _tmp4_;
			GSettings* _tmp5_;
			_tmp3_ = self->priv->settings;
			x = CLAMP (g_settings_get_int (_tmp3_, MINES_KEY_XSIZE), MINES_XSIZE_MIN, MINES_XSIZE_MAX);
			_tmp4_ = self->priv->settings;
			y = CLAMP (g_settings_get_int (_tmp4_, MINES_KEY_YSIZE), MINES_YSIZE_MIN, MINES_YSIZE_MAX);
			_tmp5_ = self->priv->settings;
			n = CLAMP (g_settings_get_int (_tmp5_, MINES_KEY_NMINES), 1, (x * y) - 10);
			break;
		}
	}
	_tmp6_ = self->priv->minefield;
	if (_tmp6_ != NULL) {
		Minefield* _tmp7_;
		_tmp7_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp7_, NULL, self);
	}
	_tmp8_ = minefield_new ((guint) x, (guint) y, (guint) n);
	_g_object_unref0 (self->priv->minefield);
	self->priv->minefield = _tmp8_;
	_tmp9_ = self->priv->minefield;
	g_signal_connect_object (_tmp9_, "marks-changed", (GCallback) _mines_marks_changed_cb_minefield_marks_changed, self, 0);
	_tmp10_ = self->priv->minefield;
	g_signal_connect_object (_tmp10_, "explode", (GCallback) _mines_explode_cb_minefield_explode, self, 0);
	_tmp11_ = self->priv->minefield;
	g_signal_connect_object (_tmp11_, "cleared", (GCallback) _mines_cleared_cb_minefield_cleared, self, 0);
	_tmp12_ = self->priv->minefield;
	g_signal_connect_object (_tmp12_, "tick", (GCallback) _mines_tick_cb_minefield_tick, self, 0);
	_tmp13_ = self->priv->minefield;
	g_signal_connect_object (_tmp13_, "paused-changed", (GCallback) _mines_paused_changed_cb_minefield_paused_changed, self, 0);
	_tmp14_ = self->priv->minefield;
	g_signal_connect_object (_tmp14_, "clock-started", (GCallback) _mines_clock_started_cb_minefield_clock_started, self, 0);
	_tmp15_ = self->priv->minefield_view;
	_tmp16_ = self->priv->minefield;
	minefield_view_set_minefield (_tmp15_, _tmp16_);
	mines_update_flag_label (self);
	_tmp17_ = self->priv->minefield;
	minefield_set_paused (_tmp17_, FALSE);
	self->priv->pause_requested = FALSE;
	_tmp18_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp18_, "game");
	_tmp19_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp19_, FALSE);
	mines_tick_cb (self);
}

static void
mines_set_play_pause_visuals_unpaused (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_set_play_pause_visuals (self, "media-playback-pause-symbolic", _ ("_Pause"));
}

static void
mines_set_play_pause_visuals_paused (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_set_play_pause_visuals (self, "media-playback-start-symbolic", _ ("_Resume"));
}

static void
mines_set_play_pause_visuals (Mines* self,
                              const gchar* icon_name,
                              const gchar* tooltip_text)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	g_return_if_fail (tooltip_text != NULL);
	_tmp0_ = self->priv->play_pause_button;
	gtk_button_set_icon_name (_tmp0_, icon_name);
	_tmp1_ = self->priv->play_pause_button;
	_tmp2_ = mines_translate_and_strip_underlines (self, tooltip_text);
	_tmp3_ = _tmp2_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
}

static void
mines_set_replay_tooltip (Mines* self,
                          const gchar* tooltip_text)
{
	GtkButton* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tooltip_text != NULL);
	_tmp0_ = self->priv->replay_button;
	_tmp1_ = mines_translate_and_strip_underlines (self, tooltip_text);
	_tmp2_ = _tmp1_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
mines_enable_game_buttons (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_set_game_buttons_enabled (self, TRUE);
}

static void
mines_disable_game_buttons (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_set_game_buttons_enabled (self, FALSE);
}

static void
mines_set_game_buttons_enabled (Mines* self,
                                gboolean value)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_game_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
	_tmp1_ = self->priv->replay_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, value);
	_tmp2_ = self->priv->play_pause_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, value);
}

static void
mines_new_game_cb (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_ask_start_new_game (self, FALSE, -1);
}

static void
mines_silent_new_game_cb (Mines* self)
{
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp2_;
		guint _tmp3_;
		guint _tmp4_;
		_tmp2_ = self->priv->minefield;
		_tmp3_ = minefield_get_n_cleared (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == ((guint) 0);
	}
	if (_tmp0_) {
		mines_show_new_game_screen (self);
	}
}

static void
mines_repeat_size_cb (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_ask_start_new_game (self, TRUE, -1);
}

static void
mines_toggle_pause_cb (Mines* self)
{
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = !self->priv->pause_requested;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->pause_requested = TRUE;
	} else {
		Minefield* _tmp4_;
		Minefield* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		Minefield* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp4_ = self->priv->minefield;
		_tmp5_ = self->priv->minefield;
		_tmp6_ = minefield_get_paused (_tmp5_);
		_tmp7_ = _tmp6_;
		minefield_set_paused (_tmp4_, !_tmp7_);
		_tmp8_ = self->priv->minefield;
		_tmp9_ = minefield_get_paused (_tmp8_);
		_tmp10_ = _tmp9_;
		self->priv->pause_requested = _tmp10_;
	}
}

static void
mines_paused_changed_cb (Mines* self)
{
	Minefield* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkBox* _tmp6_;
	Minefield* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		mines_set_play_pause_visuals_paused (self);
	} else {
		Minefield* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		_tmp3_ = self->priv->minefield;
		_tmp4_ = minefield_get_elapsed (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ > ((gdouble) 0)) {
			mines_set_play_pause_visuals_unpaused (self);
		}
	}
	_tmp6_ = self->priv->paused_box;
	_tmp7_ = self->priv->minefield;
	_tmp8_ = minefield_get_paused (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp9_);
}

static void
mines_marks_changed_cb (Mines* self,
                        Minefield* minefield)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	mines_update_flag_label (self);
}

static void
mines_explode_cb (Mines* self,
                  Minefield* minefield)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	mines_game_ended (self);
}

static void
mines_game_ended (Mines* self)
{
	GSimpleAction* _tmp0_;
	GtkButton* _tmp1_;
	GSimpleAction* _tmp2_;
	GtkButton* _tmp3_;
	g_return_if_fail (self != NULL);
	mines_set_replay_tooltip (self, _ ("Play _Again"));
	_tmp0_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->replay_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp2_, TRUE);
	_tmp3_ = self->priv->play_pause_button;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
}

static void
_mines_repeat_size_cb_games_scores_context_new_game_func (gpointer self)
{
	mines_repeat_size_cb ((Mines*) self);
}

static void
_mines_quit_cb_games_scores_context_quit_app_func (gpointer self)
{
	mines_quit_cb ((Mines*) self);
}

static void
__lambda16_ (Mines* self,
             GObject* object,
             GAsyncResult* _result_)
{
	GSimpleAction* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->context;
		games_scores_context_add_score_full_finish (_tmp0_, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("gnome-mines.vala:681: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
	mines_game_ended (self);
}

static void
___lambda16__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda16_ ((Mines*) self, source_object, res);
	g_object_unref (self);
}

static void
mines_cleared_cb (Mines* self,
                  Minefield* minefield)
{
	guint duration = 0U;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gchar* key = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GSimpleAction* _tmp18_;
	GamesScoresContext* _tmp19_;
	GamesScoresCategory* _tmp20_;
	GamesScoresCategory* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = minefield_get_elapsed (minefield);
	_tmp1_ = _tmp0_;
	duration = (guint) (_tmp1_ + 0.5);
	_tmp2_ = g_strdup_printf ("%u", minefield->width);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "-", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%u", minefield->height);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "-", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%u", minefield->n_mines);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	key = _tmp15_;
	_tmp16_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp16_, FALSE);
	_tmp17_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp17_, FALSE);
	_tmp18_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp18_, FALSE);
	_tmp19_ = self->priv->context;
	_tmp20_ = mines_create_category_from_key (self, key);
	_tmp21_ = _tmp20_;
	games_scores_context_add_score_full (_tmp19_, (glong) duration, _tmp21_, _mines_repeat_size_cb_games_scores_context_new_game_func, self, _mines_quit_cb_games_scores_context_quit_app_func, self, NULL, ___lambda16__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (_tmp21_);
	_g_free0 (key);
}

static void
mines_clock_started_cb (Mines* self)
{
	GtkButton* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	mines_set_play_pause_visuals_unpaused (self);
	_tmp0_ = self->priv->replay_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	_tmp2_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp2_, TRUE);
}

static void
mines_tick_cb (Mines* self)
{
	gint elapsed = 0;
	Minefield* _tmp0_;
	gint hours = 0;
	gint minutes = 0;
	gint seconds = 0;
	g_return_if_fail (self != NULL);
	elapsed = 0;
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_;
		gdouble _tmp2_;
		gdouble _tmp3_;
		_tmp1_ = self->priv->minefield;
		_tmp2_ = minefield_get_elapsed (_tmp1_);
		_tmp3_ = _tmp2_;
		elapsed = (gint) (_tmp3_ + 0.5);
	}
	hours = elapsed / 3600;
	minutes = (elapsed - (hours * 3600)) / 60;
	seconds = (elapsed - (hours * 3600)) - (minutes * 60);
	if (hours > 0) {
		GtkLabel* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->clock_label;
		_tmp5_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", hours, minutes, seconds);
		_tmp6_ = _tmp5_;
		gtk_label_set_text (_tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		GtkLabel* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->priv->clock_label;
		_tmp8_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", minutes, seconds);
		_tmp9_ = _tmp8_;
		gtk_label_set_text (_tmp7_, _tmp9_);
		_g_free0 (_tmp9_);
	}
}

static void
mines_menu_cb (Mines* self)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->menu_button;
	g_signal_emit_by_name (_tmp0_, "activate");
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
mines_about_cb (Mines* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint authors_length1;
	gint _authors_size_;
	gchar** artists = NULL;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint artists_length1;
	gint _artists_size_;
	gchar** documenters = NULL;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint documenters_length1;
	gint _documenters_size_;
	AdwAboutDialog* about = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	AdwAboutDialog* _tmp22_ = NULL;
	GtkWindow* _tmp23_;
	GtkWindow* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Szekeres Istvan (Pista)");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_strdup ("Robert Roth");
	_tmp3_ = g_strdup ("Horacio J. Peña");
	_tmp4_ = g_strdup ("Steve Chaplin");
	_tmp5_ = g_strdup ("Callum McKenzie");
	_tmp6_ = g_new0 (gchar*, 6 + 1);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	authors = _tmp6_;
	authors_length1 = 6;
	_authors_size_ = authors_length1;
	_tmp7_ = g_strdup ("Richard Hoelscher");
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	artists = _tmp8_;
	artists_length1 = 1;
	_artists_size_ = artists_length1;
	_tmp9_ = g_strdup ("Ekaterina Gerasimova");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	documenters = _tmp10_;
	documenters_length1 = 1;
	_documenters_size_ = documenters_length1;
	_tmp11_ = g_strdup (_ ("Mines"));
	_tmp12_ = g_strdup ("org.gnome.Mines");
	_tmp13_ = g_strdup (_ ("The GNOME Project"));
	_tmp14_ = (authors != NULL) ? _vala_array_dup1 (authors, authors_length1) : authors;
	_tmp14__length1 = authors_length1;
	_tmp15_ = g_strdup (_ ("Clear explosive mines off the board"));
	_tmp16_ = g_strdup ("Copyright © 1997–2008 Free Software Foundation, Inc.");
	_tmp17_ = (artists != NULL) ? _vala_array_dup2 (artists, artists_length1) : artists;
	_tmp17__length1 = artists_length1;
	_tmp18_ = (documenters != NULL) ? _vala_array_dup3 (documenters, documenters_length1) : documenters;
	_tmp18__length1 = documenters_length1;
	_tmp19_ = g_strdup (_ ("translator-credits"));
	_tmp20_ = g_strdup (VERSION);
	_tmp21_ = g_strdup ("https://wiki.gnome.org/Apps/Mines");
	_tmp22_ = (AdwAboutDialog*) adw_about_dialog_new ();
	adw_about_dialog_set_application_name (_tmp22_, _tmp11_);
	_g_free0 (_tmp11_);
	adw_about_dialog_set_application_icon (_tmp22_, _tmp12_);
	_g_free0 (_tmp12_);
	adw_about_dialog_set_developer_name (_tmp22_, _tmp13_);
	_g_free0 (_tmp13_);
	adw_about_dialog_set_developers (_tmp22_, _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_comments (_tmp22_, _tmp15_);
	_g_free0 (_tmp15_);
	adw_about_dialog_set_copyright (_tmp22_, _tmp16_);
	_g_free0 (_tmp16_);
	adw_about_dialog_set_license_type (_tmp22_, GTK_LICENSE_GPL_3_0);
	adw_about_dialog_set_artists (_tmp22_, _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_documenters (_tmp22_, _tmp18_);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_translator_credits (_tmp22_, _tmp19_);
	_g_free0 (_tmp19_);
	adw_about_dialog_set_version (_tmp22_, _tmp20_);
	_g_free0 (_tmp20_);
	adw_about_dialog_set_website (_tmp22_, _tmp21_);
	_g_free0 (_tmp21_);
	g_object_ref_sink (_tmp22_);
	about = _tmp22_;
	_tmp23_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp24_ = _tmp23_;
	adw_dialog_present ((AdwDialog*) about, (GtkWidget*) _tmp24_);
	_g_object_unref0 (about);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static gfloat
mines_percent_mines (Mines* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->settings;
	_tmp2_ = self->priv->settings;
	result = (100.0f * ((gfloat) g_settings_get_int (_tmp0_, MINES_KEY_NMINES))) / (g_settings_get_int (_tmp1_, MINES_KEY_XSIZE) * g_settings_get_int (_tmp2_, MINES_KEY_YSIZE));
	return result;
}

static void
mines_set_mines_limit (Mines* self)
{
	gint size = 0;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gint max_mines = 0;
	gint min_mines = 0;
	GtkSpinButton* _tmp2_;
	GtkSpinButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->settings;
	size = g_settings_get_int (_tmp0_, MINES_KEY_XSIZE) * g_settings_get_int (_tmp1_, MINES_KEY_YSIZE);
	max_mines = (gint) round ((gdouble) ((100.0f * ((gfloat) (size - 10))) / size));
	min_mines = MAX (1, (gint) round ((gdouble) (100.0f / size)));
	_tmp2_ = self->priv->mines_spin;
	gtk_spin_button_set_range (_tmp2_, (gdouble) min_mines, (gdouble) max_mines);
	_tmp3_ = self->priv->mines_spin;
	gtk_spin_button_set_value (_tmp3_, (gdouble) ((gint) round ((gdouble) mines_percent_mines (self))));
}

static void
mines_xsize_spin_cb (Mines* self,
                     GtkSpinButton* spin)
{
	gint xsize = 0;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	xsize = gtk_spin_button_get_value_as_int (spin);
	_tmp0_ = self->priv->settings;
	if (xsize == g_settings_get_int (_tmp0_, MINES_KEY_XSIZE)) {
		return;
	}
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, MINES_KEY_XSIZE, xsize);
	mines_set_mines_limit (self);
}

static void
mines_ysize_spin_cb (Mines* self,
                     GtkSpinButton* spin)
{
	gint ysize = 0;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	ysize = gtk_spin_button_get_value_as_int (spin);
	_tmp0_ = self->priv->settings;
	if (ysize == g_settings_get_int (_tmp0_, MINES_KEY_YSIZE)) {
		return;
	}
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, MINES_KEY_YSIZE, ysize);
	mines_set_mines_limit (self);
}

static void
mines_mines_spin_cb (Mines* self,
                     GtkSpinButton* spin)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	if (fabs (mines_percent_mines (self) - gtk_spin_button_get_value (spin)) <= ((gdouble) 0.5f)) {
		return;
	}
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->settings;
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp0_, MINES_KEY_NMINES, (gint) round ((gtk_spin_button_get_value (spin) * (g_settings_get_int (_tmp1_, MINES_KEY_XSIZE) * g_settings_get_int (_tmp2_, MINES_KEY_YSIZE))) / 100.0f));
}

static void
mines_set_mode (Mines* self,
                gint mode)
{
	g_return_if_fail (self != NULL);
	g_application_activate ((GApplication*) self);
	mines_ask_start_new_game (self, TRUE, mode);
}

static void
mines_small_size_clicked_cb (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 0);
}

static void
mines_medium_size_clicked_cb (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 1);
}

static void
mines_large_size_clicked_cb (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 2);
}

static void
mines_custom_size_clicked_cb (Mines* self)
{
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 3);
}

static void
mines_help_cb (Mines* self)
{
	AdwApplicationWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_show_uri ((GtkWindow*) _tmp0_, "help:gnome-mines", (guint32) GDK_CURRENT_TIME);
}

static gint
mines_main (gchar** args,
            gint args_length1)
{
	Mines* app = NULL;
	Mines* _tmp0_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_type_ensure (TYPE_MINE_WINDOW);
	_tmp0_ = mines_new ();
	app = _tmp0_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return mines_main (argv, argc);
}

static void
mines_class_init (MinesClass * klass,
                  gpointer klass_data)
{
	mines_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Mines_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) mines_real_startup;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) mines_real_shutdown;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) mines_real_handle_local_options;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) mines_real_activate;
	G_OBJECT_CLASS (klass)->finalize = mines_finalize;
}

static void
mines_instance_init (Mines * self,
                     gpointer klass)
{
	GSimpleAction** _tmp0_;
	self->priv = mines_get_instance_private (self);
	self->priv->current_layout = GTK_ORIENTATION_VERTICAL;
	_tmp0_ = g_new0 (GSimpleAction*, 4 + 1);
	self->priv->size_actions = _tmp0_;
	self->priv->size_actions_length1 = 4;
	self->priv->_size_actions_size_ = self->priv->size_actions_length1;
}

static void
mines_finalize (GObject * obj)
{
	Mines * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINES, Mines);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->main_screen);
	_g_object_unref0 (self->priv->main_screen_layout);
	_g_object_unref0 (self->priv->main_screen_sidebar);
	_g_object_unref0 (self->priv->play_pause_button);
	_g_object_unref0 (self->priv->replay_button);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->minefield_overlay);
	_g_object_unref0 (self->priv->paused_box);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->theme_dialog);
	_g_object_unref0 (self->priv->clock_label);
	_g_object_unref0 (self->priv->menu_button);
	_g_object_unref0 (self->priv->surface);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->minefield);
	_g_object_unref0 (self->priv->minefield_view);
	_g_object_unref0 (self->priv->flag_label);
	_g_object_unref0 (self->priv->mines_spin);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->repeat_size_action);
	_g_object_unref0 (self->priv->pause_action);
	self->priv->size_actions = (_vala_array_free (self->priv->size_actions, self->priv->size_actions_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->new_game_screen);
	_g_object_unref0 (self->priv->custom_game_screen);
	_g_object_unref0 (self->priv->view_click_controller);
	G_OBJECT_CLASS (mines_parent_class)->finalize (obj);
}

static GType
mines_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MinesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mines_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mines), 0, (GInstanceInitFunc) mines_instance_init, NULL };
	GType mines_type_id;
	mines_type_id = g_type_register_static (adw_application_get_type (), "Mines", &g_define_type_info, 0);
	Mines_private_offset = g_type_add_instance_private (mines_type_id, sizeof (MinesPrivate));
	return mines_type_id;
}

GType
mines_get_type (void)
{
	static volatile gsize mines_type_id__once = 0;
	if (g_once_init_enter (&mines_type_id__once)) {
		GType mines_type_id;
		mines_type_id = mines_get_type_once ();
		g_once_init_leave (&mines_type_id__once, mines_type_id);
	}
	return mines_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

