// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::ffi;
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwPreferencesGroup")]
    pub struct PreferencesGroup(Object<ffi::AdwPreferencesGroup, ffi::AdwPreferencesGroupClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::adw_preferences_group_get_type(),
    }
}

impl PreferencesGroup {
    pub const NONE: Option<&'static PreferencesGroup> = None;

    #[doc(alias = "adw_preferences_group_new")]
    pub fn new() -> PreferencesGroup {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::adw_preferences_group_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`PreferencesGroup`] objects.
    ///
    /// This method returns an instance of [`PreferencesGroupBuilder`](crate::builders::PreferencesGroupBuilder) which can be used to create [`PreferencesGroup`] objects.
    pub fn builder() -> PreferencesGroupBuilder {
        PreferencesGroupBuilder::new()
    }
}

impl Default for PreferencesGroup {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`PreferencesGroup`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct PreferencesGroupBuilder {
    builder: glib::object::ObjectBuilder<'static, PreferencesGroup>,
}

impl PreferencesGroupBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn description(self, description: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("description", description.into()),
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    pub fn header_suffix(self, header_suffix: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("header-suffix", header_suffix.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    pub fn separate_rows(self, separate_rows: bool) -> Self {
        Self {
            builder: self.builder.property("separate-rows", separate_rows),
        }
    }

    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`PreferencesGroup`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> PreferencesGroup {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::PreferencesGroup>> Sealed for T {}
}

pub trait PreferencesGroupExt: IsA<PreferencesGroup> + sealed::Sealed + 'static {
    #[doc(alias = "adw_preferences_group_add")]
    fn add(&self, child: &impl IsA<gtk::Widget>) {
        unsafe {
            ffi::adw_preferences_group_add(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_preferences_group_get_description")]
    #[doc(alias = "get_description")]
    fn description(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_preferences_group_get_description(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "adw_preferences_group_get_header_suffix")]
    #[doc(alias = "get_header_suffix")]
    #[doc(alias = "header-suffix")]
    fn header_suffix(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::adw_preferences_group_get_header_suffix(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    #[doc(alias = "adw_preferences_group_get_separate_rows")]
    #[doc(alias = "get_separate_rows")]
    #[doc(alias = "separate-rows")]
    fn is_separate_rows(&self) -> bool {
        unsafe {
            from_glib(ffi::adw_preferences_group_get_separate_rows(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_preferences_group_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_preferences_group_get_title(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_preferences_group_remove")]
    fn remove(&self, child: &impl IsA<gtk::Widget>) {
        unsafe {
            ffi::adw_preferences_group_remove(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_preferences_group_set_description")]
    #[doc(alias = "description")]
    fn set_description(&self, description: Option<&str>) {
        unsafe {
            ffi::adw_preferences_group_set_description(
                self.as_ref().to_glib_none().0,
                description.to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "adw_preferences_group_set_header_suffix")]
    #[doc(alias = "header-suffix")]
    fn set_header_suffix(&self, suffix: Option<&impl IsA<gtk::Widget>>) {
        unsafe {
            ffi::adw_preferences_group_set_header_suffix(
                self.as_ref().to_glib_none().0,
                suffix.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    #[doc(alias = "adw_preferences_group_set_separate_rows")]
    #[doc(alias = "separate-rows")]
    fn set_separate_rows(&self, separate_rows: bool) {
        unsafe {
            ffi::adw_preferences_group_set_separate_rows(
                self.as_ref().to_glib_none().0,
                separate_rows.into_glib(),
            );
        }
    }

    #[doc(alias = "adw_preferences_group_set_title")]
    #[doc(alias = "title")]
    fn set_title(&self, title: &str) {
        unsafe {
            ffi::adw_preferences_group_set_title(
                self.as_ref().to_glib_none().0,
                title.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "description")]
    fn connect_description_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_description_trampoline<
            P: IsA<PreferencesGroup>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwPreferencesGroup,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PreferencesGroup::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::description\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_description_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_1")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_1")))]
    #[doc(alias = "header-suffix")]
    fn connect_header_suffix_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_header_suffix_trampoline<
            P: IsA<PreferencesGroup>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwPreferencesGroup,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PreferencesGroup::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::header-suffix\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_header_suffix_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_6")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_6")))]
    #[doc(alias = "separate-rows")]
    fn connect_separate_rows_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_separate_rows_trampoline<
            P: IsA<PreferencesGroup>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwPreferencesGroup,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PreferencesGroup::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::separate-rows\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_separate_rows_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<
            P: IsA<PreferencesGroup>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::AdwPreferencesGroup,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(PreferencesGroup::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_title_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<PreferencesGroup>> PreferencesGroupExt for O {}
