/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 * vi:set noexpandtab tabstop=8 shiftwidth=8:
 *
 * Copyright (C) 2013 Richard Hughes <richard@hughsie.com>
 * Copyright (C) 2016 Kalev Lember <klember@redhat.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#pragma once

#include <gio/gdesktopappinfo.h>
#include <gtk/gtk.h>

#include "gnome-software-private.h"

G_BEGIN_DECLS

typedef void (*GsRemoveFunc) (GtkWidget *container,
			      GtkWidget *child);

void	 gs_widget_remove_all		(GtkWidget	*container,
					 GsRemoveFunc    remove_func);
void	 gs_grab_focus_when_mapped	(GtkWidget	*widget);

void	 gs_app_notify_installed	(GsApp		*app);
GtkResponseType
	gs_app_notify_unavailable	(GsApp		*app,
					 GtkWidget	*parent);

gboolean	 gs_utils_is_current_desktop	(const gchar	*name);
gchar		*gs_utils_set_key_colors_in_css	(const gchar	*css,
						 GsApp		*app);
void		 gs_utils_widget_set_css	(GtkWidget	*widget,
						 GtkCssProvider	**provider,
						 const gchar	*css);
const gchar	*gs_utils_get_error_value	(const GError	*error);
void		 gs_utils_show_error_dialog	(GtkWidget	*parent,
						 const gchar	*title,
						 const gchar	*msg,
						 const gchar	*details);
void		 gs_utils_show_error_dialog_simple
						(GtkWidget   *parent,
						 const gchar *title,
						 const gchar *text);
gboolean	 gs_utils_ask_user_accepts	(GtkWidget	*parent,
						 const gchar	*title,
						 const gchar	*msg,
						 const gchar	*details,
						 const gchar	*accept_label);
gchar		*gs_utils_build_unique_id_kind	(AsComponentKind kind,
						 const gchar	*id);
gboolean	 gs_utils_list_has_component_fuzzy	(GsAppList	*list,
						 GsApp		*app);
void		 gs_utils_reboot_notify		(GsAppList	*list,
						 gboolean	 is_install);
gchar		*gs_utils_time_to_datestring	(gint64		 unix_time_seconds);
gchar		*gs_utils_time_to_timestring	(gint64		 unix_time_seconds);
void		 gs_utils_invoke_reboot_async	(GCancellable	*cancellable,
						 GAsyncReadyCallback ready_callback,
						 gpointer	 user_data);
gboolean	 gs_utils_invoke_reboot_finish	(GObject	*source_object,
						 GAsyncResult	*result,
						 GError		**error);
gboolean	gs_utils_split_time_difference	(gint64 unix_time_seconds,
						 gint *out_minutes_ago,
						 gint *out_hours_ago,
						 gint *out_days_ago,
						 gint *out_weeks_ago,
						 gint *out_months_ago,
						 gint *out_years_ago);
gchar		*gs_utils_format_size		(guint64 size_bytes,
						 gboolean *out_is_markup);
void		 gs_show_uri			(GtkWindow *parent,
						 const char *uri);

/**
 * GsAppDataDirState:
 * @GS_APP_DATA_DIR_STATE_UNKNOWN: App data dir is unknown, probably because
 *   the app isn’t sandboxed so could store data anywhere in the file system.
 * @GS_APP_DATA_DIR_STATE_EXISTS: App data dir is known and exists.
 * @GS_APP_DATA_DIR_STATE_NONEXISTENT: App data dir is known and does not exist.
 *
 * State of an app’s data directory.
 *
 * This is used by gs_utils_get_app_data_dir() to indicate whether an app’s data
 * directory exists and/or is known to be sandboxed.
 *
 * Since: 49
 */
typedef enum {
	GS_APP_DATA_DIR_STATE_UNKNOWN = 0,
	GS_APP_DATA_DIR_STATE_EXISTS,
	GS_APP_DATA_DIR_STATE_NONEXISTENT,
} GsAppDataDirState;

GsAppDataDirState gs_utils_get_app_data_dir	(GsApp *app,
						 char **out_data_dir);
gboolean	 gs_utils_remove_app_data_dir	(GsApp *app,
						 GsPluginLoader *plugin_loader);

char		*gs_utils_format_bus_policy_title (const GsBusPolicy *bus_policy);
const char	*gs_utils_format_bus_policy_subtitle (const GsBusPolicy *bus_policy);

G_END_DECLS
