{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Base class for objects implementing different rendering methods.
-- 
-- @GdkDrawContext@ is the base object used by contexts implementing different
-- rendering methods, such as t'GI.Gdk.Objects.CairoContext.CairoContext' or t'GI.Gdk.Objects.GLContext.GLContext'.
-- It provides shared functionality between those contexts.
-- 
-- You will always interact with one of those subclasses.
-- 
-- A @GdkDrawContext@ is always associated with a single toplevel surface.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.DrawContext
    ( 

-- * Exported types
    DrawContext(..)                         ,
    IsDrawContext                           ,
    toDrawContext                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beginFrame]("GI.Gdk.Objects.DrawContext#g:method:beginFrame"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [endFrame]("GI.Gdk.Objects.DrawContext#g:method:endFrame"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isInFrame]("GI.Gdk.Objects.DrawContext#g:method:isInFrame"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.DrawContext#g:method:getDisplay"), [getFrameRegion]("GI.Gdk.Objects.DrawContext#g:method:getFrameRegion"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gdk.Objects.DrawContext#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDrawContextMethod                ,
#endif

-- ** beginFrame #method:beginFrame#

#if defined(ENABLE_OVERLOADING)
    DrawContextBeginFrameMethodInfo         ,
#endif
    drawContextBeginFrame                   ,


-- ** endFrame #method:endFrame#

#if defined(ENABLE_OVERLOADING)
    DrawContextEndFrameMethodInfo           ,
#endif
    drawContextEndFrame                     ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    DrawContextGetDisplayMethodInfo         ,
#endif
    drawContextGetDisplay                   ,


-- ** getFrameRegion #method:getFrameRegion#

#if defined(ENABLE_OVERLOADING)
    DrawContextGetFrameRegionMethodInfo     ,
#endif
    drawContextGetFrameRegion               ,


-- ** getSurface #method:getSurface#

#if defined(ENABLE_OVERLOADING)
    DrawContextGetSurfaceMethodInfo         ,
#endif
    drawContextGetSurface                   ,


-- ** isInFrame #method:isInFrame#

#if defined(ENABLE_OVERLOADING)
    DrawContextIsInFrameMethodInfo          ,
#endif
    drawContextIsInFrame                    ,




 -- * Properties


-- ** display #attr:display#
-- | The @GdkDisplay@ used to create the @GdkDrawContext@.

#if defined(ENABLE_OVERLOADING)
    DrawContextDisplayPropertyInfo          ,
#endif
    constructDrawContextDisplay             ,
#if defined(ENABLE_OVERLOADING)
    drawContextDisplay                      ,
#endif
    getDrawContextDisplay                   ,


-- ** surface #attr:surface#
-- | The @GdkSurface@ the context is bound to.

#if defined(ENABLE_OVERLOADING)
    DrawContextSurfacePropertyInfo          ,
#endif
    constructDrawContextSurface             ,
#if defined(ENABLE_OVERLOADING)
    drawContextSurface                      ,
#endif
    getDrawContextSurface                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface

#endif

-- | Memory-managed wrapper type.
newtype DrawContext = DrawContext (SP.ManagedPtr DrawContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype DrawContext where
    toManagedPtr (DrawContext p) = p

foreign import ccall "gdk_draw_context_get_type"
    c_gdk_draw_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject DrawContext where
    glibType = c_gdk_draw_context_get_type

instance B.Types.GObject DrawContext

-- | Type class for types which can be safely cast to t'DrawContext', for instance with `toDrawContext`.
class (SP.GObject o, O.IsDescendantOf DrawContext o) => IsDrawContext o
instance (SP.GObject o, O.IsDescendantOf DrawContext o) => IsDrawContext o

instance O.HasParentTypes DrawContext
type instance O.ParentTypes DrawContext = '[GObject.Object.Object]

-- | Cast to t'DrawContext', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDrawContext :: (MIO.MonadIO m, IsDrawContext o) => o -> m DrawContext
toDrawContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo DrawContext

-- | Convert t'DrawContext' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DrawContext) where
    gvalueGType_ = c_gdk_draw_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DrawContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DrawContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DrawContext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDrawContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDrawContextMethod "beginFrame" o = DrawContextBeginFrameMethodInfo
    ResolveDrawContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDrawContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDrawContextMethod "endFrame" o = DrawContextEndFrameMethodInfo
    ResolveDrawContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDrawContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDrawContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDrawContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDrawContextMethod "isInFrame" o = DrawContextIsInFrameMethodInfo
    ResolveDrawContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDrawContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDrawContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDrawContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDrawContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDrawContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDrawContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDrawContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDrawContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDrawContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDrawContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDrawContextMethod "getDisplay" o = DrawContextGetDisplayMethodInfo
    ResolveDrawContextMethod "getFrameRegion" o = DrawContextGetFrameRegionMethodInfo
    ResolveDrawContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDrawContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDrawContextMethod "getSurface" o = DrawContextGetSurfaceMethodInfo
    ResolveDrawContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDrawContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDrawContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDrawContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDrawContextMethod t DrawContext, O.OverloadedMethod info DrawContext p) => OL.IsLabel t (DrawContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDrawContextMethod t DrawContext, O.OverloadedMethod info DrawContext p, R.HasField t DrawContext p) => R.HasField t DrawContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDrawContextMethod t DrawContext, O.OverloadedMethodInfo info DrawContext) => OL.IsLabel t (O.MethodProxy info DrawContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drawContext #display
-- @
getDrawContextDisplay :: (MonadIO m, IsDrawContext o) => o -> m (Maybe Gdk.Display.Display)
getDrawContextDisplay obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Construct a t'GValueConstruct' with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDrawContextDisplay :: (IsDrawContext o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructDrawContextDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DrawContextDisplayPropertyInfo
instance AttrInfo DrawContextDisplayPropertyInfo where
    type AttrAllowedOps DrawContextDisplayPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DrawContextDisplayPropertyInfo = IsDrawContext
    type AttrSetTypeConstraint DrawContextDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint DrawContextDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType DrawContextDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType DrawContextDisplayPropertyInfo = (Maybe Gdk.Display.Display)
    type AttrLabel DrawContextDisplayPropertyInfo = "display"
    type AttrOrigin DrawContextDisplayPropertyInfo = DrawContext
    attrGet = getDrawContextDisplay
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructDrawContextDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawContext.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-DrawContext.html#g:attr:display"
        })
#endif

-- VVV Prop "surface"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Surface"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@surface@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drawContext #surface
-- @
getDrawContextSurface :: (MonadIO m, IsDrawContext o) => o -> m (Maybe Gdk.Surface.Surface)
getDrawContextSurface obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "surface" Gdk.Surface.Surface

-- | Construct a t'GValueConstruct' with valid value for the “@surface@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDrawContextSurface :: (IsDrawContext o, MIO.MonadIO m, Gdk.Surface.IsSurface a) => a -> m (GValueConstruct o)
constructDrawContextSurface val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "surface" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DrawContextSurfacePropertyInfo
instance AttrInfo DrawContextSurfacePropertyInfo where
    type AttrAllowedOps DrawContextSurfacePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DrawContextSurfacePropertyInfo = IsDrawContext
    type AttrSetTypeConstraint DrawContextSurfacePropertyInfo = Gdk.Surface.IsSurface
    type AttrTransferTypeConstraint DrawContextSurfacePropertyInfo = Gdk.Surface.IsSurface
    type AttrTransferType DrawContextSurfacePropertyInfo = Gdk.Surface.Surface
    type AttrGetType DrawContextSurfacePropertyInfo = (Maybe Gdk.Surface.Surface)
    type AttrLabel DrawContextSurfacePropertyInfo = "surface"
    type AttrOrigin DrawContextSurfacePropertyInfo = DrawContext
    attrGet = getDrawContextSurface
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Surface.Surface v
    attrConstruct = constructDrawContextSurface
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawContext.surface"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-DrawContext.html#g:attr:surface"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DrawContext
type instance O.AttributeList DrawContext = DrawContextAttributeList
type DrawContextAttributeList = ('[ '("display", DrawContextDisplayPropertyInfo), '("surface", DrawContextSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
drawContextDisplay :: AttrLabelProxy "display"
drawContextDisplay = AttrLabelProxy

drawContextSurface :: AttrLabelProxy "surface"
drawContextSurface = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DrawContext = DrawContextSignalList
type DrawContextSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DrawContext::begin_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the `GdkDrawContext` used to draw the frame. The context must\n  have a surface."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "region"
--           , argType =
--               TInterface Name { namespace = "cairo" , name = "Region" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "minimum region that should be drawn"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_draw_context_begin_frame" gdk_draw_context_begin_frame :: 
    Ptr DrawContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DrawContext"})
    Ptr Cairo.Region.Region ->              -- region : TInterface (Name {namespace = "cairo", name = "Region"})
    IO ()

{-# DEPRECATED drawContextBeginFrame ["(Since version 4.16)","Drawing directly to the surface is no longer recommended.","  Use @GskRenderNode@ and @GskRenderer@."] #-}
-- | Indicates that you are beginning the process of redrawing /@region@/
-- on the /@context@/\'s surface.
-- 
-- Calling this function begins a drawing operation using /@context@/ on the
-- surface that /@context@/ was created from. The actual requirements and
-- guarantees for the drawing operation vary for different implementations
-- of drawing, so a t'GI.Gdk.Objects.CairoContext.CairoContext' and a t'GI.Gdk.Objects.GLContext.GLContext'
-- need to be treated differently.
-- 
-- A call to this function is a requirement for drawing and must be
-- followed by a call to 'GI.Gdk.Objects.DrawContext.drawContextEndFrame', which will
-- complete the drawing operation and ensure the contents become visible
-- on screen.
-- 
-- Note that the /@region@/ passed to this function is the minimum region that
-- needs to be drawn and depending on implementation, windowing system and
-- hardware in use, it might be necessary to draw a larger region. Drawing
-- implementation must use 'GI.Gdk.Objects.DrawContext.drawContextGetFrameRegion' to
-- query the region that must be drawn.
-- 
-- When using GTK, the widget system automatically places calls to
-- 'GI.Gdk.Objects.DrawContext.drawContextBeginFrame' and 'GI.Gdk.Objects.DrawContext.drawContextEndFrame' via the
-- use of <http://developer.gnome.org/gdk/stable/../gsk4/class.Renderer.html GskRenderer>s, so application code
-- does not need to call these functions explicitly.
drawContextBeginFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrawContext a) =>
    a
    -- ^ /@context@/: the @GdkDrawContext@ used to draw the frame. The context must
    --   have a surface.
    -> Cairo.Region.Region
    -- ^ /@region@/: minimum region that should be drawn
    -> m ()
drawContextBeginFrame context region = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    region' <- unsafeManagedPtrGetPtr region
    gdk_draw_context_begin_frame context' region'
    touchManagedPtr context
    touchManagedPtr region
    return ()

#if defined(ENABLE_OVERLOADING)
data DrawContextBeginFrameMethodInfo
instance (signature ~ (Cairo.Region.Region -> m ()), MonadIO m, IsDrawContext a) => O.OverloadedMethod DrawContextBeginFrameMethodInfo a signature where
    overloadedMethod = drawContextBeginFrame

instance O.OverloadedMethodInfo DrawContextBeginFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawContext.drawContextBeginFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-DrawContext.html#v:drawContextBeginFrame"
        })


#endif

-- method DrawContext::end_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrawContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_draw_context_end_frame" gdk_draw_context_end_frame :: 
    Ptr DrawContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DrawContext"})
    IO ()

{-# DEPRECATED drawContextEndFrame ["(Since version 4.16)","Drawing directly to the surface is no longer recommended.","  Use @GskRenderNode@ and @GskRenderer@."] #-}
-- | Ends a drawing operation started with 'GI.Gdk.Objects.DrawContext.drawContextBeginFrame'.
-- 
-- This makes the drawing available on screen.
-- See 'GI.Gdk.Objects.DrawContext.drawContextBeginFrame' for more details about drawing.
-- 
-- When using a t'GI.Gdk.Objects.GLContext.GLContext', this function may call @glFlush()@
-- implicitly before returning; it is not recommended to call @glFlush()@
-- explicitly before calling this function.
drawContextEndFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrawContext a) =>
    a
    -- ^ /@context@/: a @GdkDrawContext@
    -> m ()
drawContextEndFrame context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gdk_draw_context_end_frame context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data DrawContextEndFrameMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDrawContext a) => O.OverloadedMethod DrawContextEndFrameMethodInfo a signature where
    overloadedMethod = drawContextEndFrame

instance O.OverloadedMethodInfo DrawContextEndFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawContext.drawContextEndFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-DrawContext.html#v:drawContextEndFrame"
        })


#endif

-- method DrawContext::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrawContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_draw_context_get_display" gdk_draw_context_get_display :: 
    Ptr DrawContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DrawContext"})
    IO (Ptr Gdk.Display.Display)

-- | Retrieves the @GdkDisplay@ the /@context@/ is created for
drawContextGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrawContext a) =>
    a
    -- ^ /@context@/: a @GdkDrawContext@
    -> m (Maybe Gdk.Display.Display)
    -- ^ __Returns:__ the @GdkDisplay@
drawContextGetDisplay context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_draw_context_get_display context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Display.Display) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DrawContextGetDisplayMethodInfo
instance (signature ~ (m (Maybe Gdk.Display.Display)), MonadIO m, IsDrawContext a) => O.OverloadedMethod DrawContextGetDisplayMethodInfo a signature where
    overloadedMethod = drawContextGetDisplay

instance O.OverloadedMethodInfo DrawContextGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawContext.drawContextGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-DrawContext.html#v:drawContextGetDisplay"
        })


#endif

-- method DrawContext::get_frame_region
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrawContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Region" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_draw_context_get_frame_region" gdk_draw_context_get_frame_region :: 
    Ptr DrawContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DrawContext"})
    IO (Ptr Cairo.Region.Region)

{-# DEPRECATED drawContextGetFrameRegion ["(Since version 4.16)","Drawing directly to the surface is no longer recommended.","  Use @GskRenderNode@ and @GskRenderer@."] #-}
-- | Retrieves the region that is currently being repainted.
-- 
-- After a call to 'GI.Gdk.Objects.DrawContext.drawContextBeginFrame' this function will
-- return a union of the region passed to that function and the area of the
-- surface that the /@context@/ determined needs to be repainted.
-- 
-- If /@context@/ is not in between calls to 'GI.Gdk.Objects.DrawContext.drawContextBeginFrame'
-- and 'GI.Gdk.Objects.DrawContext.drawContextEndFrame', 'P.Nothing' will be returned.
drawContextGetFrameRegion ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrawContext a) =>
    a
    -- ^ /@context@/: a @GdkDrawContext@
    -> m (Maybe Cairo.Region.Region)
    -- ^ __Returns:__ a Cairo region
drawContextGetFrameRegion context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_draw_context_get_frame_region context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Cairo.Region.Region) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DrawContextGetFrameRegionMethodInfo
instance (signature ~ (m (Maybe Cairo.Region.Region)), MonadIO m, IsDrawContext a) => O.OverloadedMethod DrawContextGetFrameRegionMethodInfo a signature where
    overloadedMethod = drawContextGetFrameRegion

instance O.OverloadedMethodInfo DrawContextGetFrameRegionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawContext.drawContextGetFrameRegion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-DrawContext.html#v:drawContextGetFrameRegion"
        })


#endif

-- method DrawContext::get_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrawContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_draw_context_get_surface" gdk_draw_context_get_surface :: 
    Ptr DrawContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DrawContext"})
    IO (Ptr Gdk.Surface.Surface)

-- | Retrieves the surface that /@context@/ is bound to.
drawContextGetSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrawContext a) =>
    a
    -- ^ /@context@/: a @GdkDrawContext@
    -> m (Maybe Gdk.Surface.Surface)
    -- ^ __Returns:__ a @GdkSurface@
drawContextGetSurface context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_draw_context_get_surface context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Surface.Surface) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DrawContextGetSurfaceMethodInfo
instance (signature ~ (m (Maybe Gdk.Surface.Surface)), MonadIO m, IsDrawContext a) => O.OverloadedMethod DrawContextGetSurfaceMethodInfo a signature where
    overloadedMethod = drawContextGetSurface

instance O.OverloadedMethodInfo DrawContextGetSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawContext.drawContextGetSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-DrawContext.html#v:drawContextGetSurface"
        })


#endif

-- method DrawContext::is_in_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrawContext`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_draw_context_is_in_frame" gdk_draw_context_is_in_frame :: 
    Ptr DrawContext ->                      -- context : TInterface (Name {namespace = "Gdk", name = "DrawContext"})
    IO CInt

{-# DEPRECATED drawContextIsInFrame ["(Since version 4.16)","Drawing directly to the surface is no longer recommended.","  Use @GskRenderNode@ and @GskRenderer@."] #-}
-- | Returns 'P.True' if /@context@/ is in the process of drawing to its surface.
-- 
-- This is the case between calls to 'GI.Gdk.Objects.DrawContext.drawContextBeginFrame'
-- and 'GI.Gdk.Objects.DrawContext.drawContextEndFrame'. In this situation, drawing commands
-- may be effecting the contents of the /@context@/\'s surface.
drawContextIsInFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrawContext a) =>
    a
    -- ^ /@context@/: a @GdkDrawContext@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the context is between 'GI.Gdk.Objects.DrawContext.drawContextBeginFrame'
    --   and 'GI.Gdk.Objects.DrawContext.drawContextEndFrame' calls.
drawContextIsInFrame context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_draw_context_is_in_frame context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DrawContextIsInFrameMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDrawContext a) => O.OverloadedMethod DrawContextIsInFrameMethodInfo a signature where
    overloadedMethod = drawContextIsInFrame

instance O.OverloadedMethodInfo DrawContextIsInFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawContext.drawContextIsInFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-DrawContext.html#v:drawContextIsInFrame"
        })


#endif


