#include "main.h"
#include "sysdeps.h"
#include "hatari-glue.h"
#include "maccess.h"
#include "memory.h"
#include "custom.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#include "debugmem.h"
#define SET_ALWAYS_CFLG(x) SET_CFLG(x)
#define SET_ALWAYS_NFLG(x) SET_NFLG(x)
/* OR.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0000_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* OR.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0010_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* OR.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0018_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* OR.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0020_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* OR.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0028_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* OR.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0030_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 22; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* OR.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0038_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* OR.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0039_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ORSR.B #<data>.W */
uae_u32 REGPARAM2 op_003c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 4;
	CurrentInstrCycles = 16; 
	MakeSR();
	uae_s16 src = regs.irc;
	src &= 0xFF;
	regs.sr |= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/0) */
/* 4 0,0   */

/* OR.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0040_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* OR.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0050_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* OR.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0058_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* OR.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0060_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* OR.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0068_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* OR.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0070_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* OR.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0078_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* OR.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0079_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ORSR.W #<data>.W */
uae_u32 REGPARAM2 op_007c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 4;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	uae_s16 src = regs.irc;
	regs.sr |= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/0) */
/* 4 0,0   */

/* OR.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0080_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_dreg(regs, dstreg) = (src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/0) */
/* 6 0,0   */

/* OR.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0090_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* OR.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0098_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* OR.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_00a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 0,0   */

/* OR.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_00a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* OR.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_00b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 34; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 34 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 34 * CYCLE_UNIT / 2 + count_cycles;
}
/* 34 (6/2) */
/* 8 4,0   */

/* OR.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_00b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* OR.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_00b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 36 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(10);
	return 36 * CYCLE_UNIT / 2 + count_cycles;
}
/* 36 (7/2) */
/* 10 0,0   */

/* BTST.L Dn,Dn */
uae_u32 REGPARAM2 op_0100_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	return 6 * CYCLE_UNIT / 2 + count_cycles;
}
/* 6 (1/0) */
/* 2 0,0   */

/* MVPMR.W (d16,An),Dn */
uae_u32 REGPARAM2 op_0108_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	CurrentInstrCycles = 16; 
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u16 val  = (get_byte_000(mempa) & 0xff) << 8;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		exception2_read(opcode, mempa + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	val |= (get_byte_000(mempa + 2) & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, mempa + 2, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 4 0,0   */

/* BTST.B Dn,(An) */
uae_u32 REGPARAM2 op_0110_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 2 0,0   */

/* BTST.B Dn,(An)+ */
uae_u32 REGPARAM2 op_0118_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 2 0,0   */

/* BTST.B Dn,-(An) */
uae_u32 REGPARAM2 op_0120_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 10; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10 (2/0) */
/* 2 0,0   */

/* BTST.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_0128_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* BTST.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0130_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 4,0   */

/* BTST.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_0138_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* BTST.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_0139_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* BTST.B Dn,(d16,PC) */
uae_u32 REGPARAM2 op_013a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_getpci() + 2;
	dsta += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* BTST.B Dn,(d8,PC,Xn) */
uae_u32 REGPARAM2 op_013b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 4,0   */

/* BTST.B Dn,#<data>.B */
uae_u32 REGPARAM2 op_013c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 10; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10 (2/0) */
/* 4 0,0   */

/* BCHG.L Dn,Dn */
uae_u32 REGPARAM2 op_0140_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 31;
	if (src > 15) {
		count_cycles +=  2 * CYCLE_UNIT / 2;
	}
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return 6 * CYCLE_UNIT / 2 + count_cycles;
}
/* 6+ (1/0) */
/* 2 0,0   */

/* MVPMR.L (d16,An),Dn */
uae_u32 REGPARAM2 op_0148_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	CurrentInstrCycles = 24; 
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 val  = (get_byte_000(mempa) & 0xff) << 24;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		exception2_read(opcode, mempa + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	val |= (get_byte_000(mempa + 2) & 0xff) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, mempa + 2, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0x0000ffff) | val;
	val |= (get_byte_000(mempa + 4) & 0xff) << 8;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		exception2_read(opcode, mempa + 4, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	val |= (get_byte_000(mempa + 6) & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, mempa + 6, 0x0, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_dreg(regs, dstreg) = (val);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (6/0) */
/* 4 0,0   */

/* BCHG.B Dn,(An) */
uae_u32 REGPARAM2 op_0150_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 2 0,0   */

/* BCHG.B Dn,(An)+ */
uae_u32 REGPARAM2 op_0158_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 2 0,0   */

/* BCHG.B Dn,-(An) */
uae_u32 REGPARAM2 op_0160_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/1) */
/* 2 0,0   */

/* BCHG.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_0168_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BCHG.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0170_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* BCHG.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_0178_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BCHG.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_0179_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* BCLR.L Dn,Dn */
uae_u32 REGPARAM2 op_0180_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 8;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 31;
	if (src > 15) {
		count_cycles +=  2 * CYCLE_UNIT / 2;
	}
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/0) */
/* 2 0,0   */

/* MVPRM.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_0188_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_byte_000(mempa, src >> 8);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		uae_u16 val = src;
		exception2_write(opcode, mempa + 0, 0x100, val, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_byte_000(mempa + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		uae_u16 val = src;
		exception2_write(opcode, mempa + 2, 0x100, val, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/2) */
/* 4 0,0   */

/* BCLR.B Dn,(An) */
uae_u32 REGPARAM2 op_0190_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/1) */
/* 2 0,0   */

/* BCLR.B Dn,(An)+ */
uae_u32 REGPARAM2 op_0198_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/1) */
/* 2 0,0   */

/* BCLR.B Dn,-(An) */
uae_u32 REGPARAM2 op_01a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/1) */
/* 2 0,0   */

/* BCLR.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_01a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BCLR.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_01b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/1) */
/* 4 4,0   */

/* BCLR.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_01b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BCLR.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_01b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	CurrentInstrCycles = 22; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 0,0   */

/* BSET.L Dn,Dn */
uae_u32 REGPARAM2 op_01c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 31;
	if (src > 15) {
		count_cycles +=  2 * CYCLE_UNIT / 2;
	}
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return 6 * CYCLE_UNIT / 2 + count_cycles;
}
/* 6+ (1/0) */
/* 2 0,0   */

/* MVPRM.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_01c8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_byte_000(mempa, src >> 24);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		uae_u16 val = src >> 16;
		exception2_write(opcode, mempa + 0, 0x100, val, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_byte_000(mempa + 2, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		uae_u16 val = src >> 16;
		exception2_write(opcode, mempa + 2, 0x100, val, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_byte_000(mempa + 4, src >> 8);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		uae_u16 val = src >> 0;
		exception2_write(opcode, mempa + 4, 0x100, val, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_byte_000(mempa + 6, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		uae_u16 val = src >> 0;
		exception2_write(opcode, mempa + 6, 0x100, val, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (2/4) */
/* 4 0,0   */

/* BSET.B Dn,(An) */
uae_u32 REGPARAM2 op_01d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 2 0,0   */

/* BSET.B Dn,(An)+ */
uae_u32 REGPARAM2 op_01d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 2 0,0   */

/* BSET.B Dn,-(An) */
uae_u32 REGPARAM2 op_01e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/1) */
/* 2 0,0   */

/* BSET.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_01e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BSET.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_01f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* BSET.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_01f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BSET.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_01f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* AND.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0200_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* AND.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0210_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* AND.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0218_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* AND.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0220_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* AND.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0228_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* AND.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0230_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 22; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* AND.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0238_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* AND.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0239_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ANDSR.B #<data>.W */
uae_u32 REGPARAM2 op_023c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 5;
	CurrentInstrCycles = 16; 
	MakeSR();
	uae_s16 src = regs.irc;
	src &= 0xFF;
	src |= 0xff00;
	regs.sr &= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/0) */
/* 4 0,0   */

/* AND.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0240_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* AND.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0250_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* AND.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0258_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* AND.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0260_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* AND.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0268_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* AND.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0270_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* AND.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0278_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* AND.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0279_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ANDSR.W #<data>.W */
uae_u32 REGPARAM2 op_027c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 5;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	uae_s16 src = regs.irc;
	regs.sr &= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/0) */
/* 4 0,0   */

/* AND.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0280_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_dreg(regs, dstreg) = (src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/0) */
/* 6 0,0   */

/* AND.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0290_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* AND.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0298_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* AND.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_02a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 0,0   */

/* AND.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_02a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* AND.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_02b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 34; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 34 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 34 * CYCLE_UNIT / 2 + count_cycles;
}
/* 34 (6/2) */
/* 8 4,0   */

/* AND.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_02b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* AND.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_02b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 36 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(10);
	return 36 * CYCLE_UNIT / 2 + count_cycles;
}
/* 36 (7/2) */
/* 10 0,0   */

/* SUB.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0400_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* SUB.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0410_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* SUB.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0418_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* SUB.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0420_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* SUB.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0428_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* SUB.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0430_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 22; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* SUB.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0438_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* SUB.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0439_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* SUB.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0440_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* SUB.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0450_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* SUB.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0458_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* SUB.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0460_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* SUB.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0468_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* SUB.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0470_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* SUB.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0478_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* SUB.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0479_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* SUB.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0480_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		dreg_68000_long_replace_low(dstreg, bnewv);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 6 0,0   */

/* SUB.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0490_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* SUB.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0498_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* SUB.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_04a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 0,0   */

/* SUB.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_04a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* SUB.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_04b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 34; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 34 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 34 * CYCLE_UNIT / 2 + count_cycles;
}
/* 34 (6/2) */
/* 8 4,0   */

/* SUB.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_04b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* SUB.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_04b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 36 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(10);
	return 36 * CYCLE_UNIT / 2 + count_cycles;
}
/* 36 (7/2) */
/* 10 0,0   */

/* ADD.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0600_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* ADD.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0610_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* ADD.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0618_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* ADD.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0620_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* ADD.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0628_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* ADD.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0630_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 22; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* ADD.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0638_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* ADD.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0639_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ADD.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0640_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* ADD.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0650_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* ADD.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0658_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* ADD.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0660_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* ADD.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0668_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* ADD.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0670_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* ADD.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0678_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* ADD.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0679_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ADD.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0680_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		dreg_68000_long_replace_low(dstreg, bnewv);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 6 0,0   */

/* ADD.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0690_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* ADD.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0698_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* ADD.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_06a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 0,0   */

/* ADD.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_06a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* ADD.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_06b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 34; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 34 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 34 * CYCLE_UNIT / 2 + count_cycles;
}
/* 34 (6/2) */
/* 8 4,0   */

/* ADD.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_06b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* ADD.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_06b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return 36 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(10);
	return 36 * CYCLE_UNIT / 2 + count_cycles;
}
/* 36 (7/2) */
/* 10 0,0   */

/* BTST.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_0800_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10 (2/0) */
/* 4 0,0   */

/* BTST.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_0810_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* BTST.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0818_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* BTST.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0820_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 14; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 0,0   */

/* BTST.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0828_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0830_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (4/0) */
/* 6 4,0   */

/* BTST.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0838_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* BTST.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0839_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 21;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (5/0) */
/* 8 0,0   */

/* BTST.B #<data>.W,(d16,PC) */
uae_u32 REGPARAM2 op_083a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,PC,Xn) */
uae_u32 REGPARAM2 op_083b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	uaecptr tmppc = m68k_getpci() + 4;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(tmppc, get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (4/0) */
/* 6 4,0   */

/* BCHG.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_0840_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 31;
	if (src > 15) {
		count_cycles +=  2 * CYCLE_UNIT / 2;
	}
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (2/0) */
/* 4 0,0   */

/* BCHG.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_0850_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BCHG.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0858_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BCHG.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0860_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BCHG.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0868_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* BCHG.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0870_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* BCHG.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0878_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 22;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* BCHG.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0879_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 22;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* BCLR.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_0880_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 31;
	if (src > 15) {
		count_cycles +=  2 * CYCLE_UNIT / 2;
	}
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12+ (2/0) */
/* 4 0,0   */

/* BCLR.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_0890_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BCLR.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0898_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BCLR.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_08a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/1) */
/* 4 0,0   */

/* BCLR.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_08a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 0,0   */

/* BCLR.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_08b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/1) */
/* 6 4,0   */

/* BCLR.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_08b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 23;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 0,0   */

/* BCLR.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_08b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 23;
	CurrentInstrCycles = 26; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (5/1) */
/* 8 0,0   */

/* BSET.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_08c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 31;
	if (src > 15) {
		count_cycles +=  2 * CYCLE_UNIT / 2;
	}
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (2/0) */
/* 4 0,0   */

/* BSET.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_08d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BSET.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_08d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BSET.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_08e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BSET.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_08e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* BSET.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_08f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* BSET.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_08f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 24;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* BSET.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_08f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 24;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* EOR.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0a00_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* EOR.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0a10_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* EOR.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0a18_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* EOR.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0a20_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* EOR.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0a28_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* EOR.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0a30_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 22; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* EOR.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0a38_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* EOR.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0a39_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* EORSR.B #<data>.W */
uae_u32 REGPARAM2 op_0a3c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 6;
	CurrentInstrCycles = 16; 
	MakeSR();
	uae_s16 src = regs.irc;
	src &= 0xFF;
	regs.sr ^= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/0) */
/* 4 0,0   */

/* EOR.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0a40_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* EOR.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0a50_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* EOR.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0a58_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* EOR.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0a60_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* EOR.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0a68_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* EOR.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0a70_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* EOR.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0a78_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* EOR.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0a79_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* EORSR.W #<data>.W */
uae_u32 REGPARAM2 op_0a7c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 6;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	uae_s16 src = regs.irc;
	regs.sr ^= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/0) */
/* 4 0,0   */

/* EOR.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0a80_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_dreg(regs, dstreg) = (src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/0) */
/* 6 0,0   */

/* EOR.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0a90_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* EOR.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0a98_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* EOR.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_0aa0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 0,0   */

/* EOR.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_0aa8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* EOR.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0ab0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 34; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 34 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 34 * CYCLE_UNIT / 2 + count_cycles;
}
/* 34 (6/2) */
/* 8 4,0   */

/* EOR.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_0ab8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* EOR.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_0ab9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 36 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(10);
	return 36 * CYCLE_UNIT / 2 + count_cycles;
}
/* 36 (7/2) */
/* 10 0,0   */

/* CMP.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0c00_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* CMP.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0c10_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* CMP.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0c18_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* CMP.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0c20_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 0,0   */

/* CMP.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0c28_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* CMP.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0c30_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (4/0) */
/* 6 4,0   */

/* CMP.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0c38_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* CMP.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0c39_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 dst = get_byte_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (5/0) */
/* 8 0,0   */

/* CMP.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0c40_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* CMP.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0c50_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* CMP.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0c58_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* CMP.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0c60_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 0,0   */

/* CMP.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0c68_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* CMP.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0c70_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (4/0) */
/* 6 4,0   */

/* CMP.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0c78_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* CMP.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0c79_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = get_word_000(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (5/0) */
/* 8 0,0   */

/* CMP.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0c80_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	m68k_incpci(6);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 6 0,0   */

/* CMP.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0c90_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (5/0) */
/* 6 0,0   */

/* CMP.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0c98_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (5/0) */
/* 6 0,0   */

/* CMP.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_0ca0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 22; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (5/0) */
/* 6 0,0   */

/* CMP.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_0ca8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (6/0) */
/* 8 0,0   */

/* CMP.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0cb0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 26; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (6/0) */
/* 8 4,0   */

/* CMP.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_0cb8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (6/0) */
/* 8 0,0   */

/* CMP.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_0cb9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 dst = get_word_000(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	dst |= get_word_000(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(10);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (7/0) */
/* 10 0,0   */

/* MOVES.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e10_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 18; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return 14 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 0, 0x0, 1);
			return 14 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e18_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 0, 0x0, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e20_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		m68k_areg(regs, dstreg) = dsta;
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			m68k_areg(regs, dstreg) = srca;
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x0, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e28_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x0, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/0) */
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e30_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x0, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/0) */
/* 6 4,4   */

#endif
/* MOVES.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e38_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x0, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/0) */
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e39_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_word_000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		dsta |= get_word_000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_word_000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		srca |= get_word_000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x0, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(8);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/0) */
/* 8 0,0   */

#endif
/* MOVES.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e50_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 18; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(6);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return 14 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 1, 1);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 14 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e58_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		if (dsta & 1) {
			m68k_areg(regs, dstreg) += 2 + 0;
			regs.irc = extra;
			if (dstreg + 8 == ((extra >> 12) & 15)) {
				src += 2;
			}
			m68k_incpci(6);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_areg(regs, dstreg) += 2;
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		if (srca & 1) {
			m68k_areg(regs, dstreg) += 2 + 0;
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 1, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			m68k_areg(regs, dstreg) += 2 + 0;
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_areg(regs, dstreg) += 2;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e60_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 2;
		if (dsta & 1) {
			regs.irc = extra;
			if (dstreg + 8 == ((extra >> 12) & 15)) {
				src += -2;
			}
			m68k_areg(regs, dstreg) = dsta;
			m68k_incpci(6);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_areg(regs, dstreg) = dsta;
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 2;
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) = srca;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 1, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			m68k_areg(regs, dstreg) = srca;
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e68_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 1, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/0) */
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e70_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(8);
			exception3_read_access(opcode, srca, 1, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/0) */
/* 6 4,4   */

#endif
/* MOVES.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e78_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(8);
			exception3_read_access(opcode, srca, 1, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/0) */
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e79_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_word_000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		dsta |= get_word_000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(10);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_word_000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		srca |= get_word_000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(10);
			exception3_read_access(opcode, srca, 1, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(8);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/0) */
/* 8 0,0   */

#endif
/* MOVES.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e90_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 22; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(6);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return 14 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta + 2, src); 
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return 18 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 2, 1);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 14 * CYCLE_UNIT / 2 + count_cycles;
		}
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 2, 0x1, 1);
			return 18 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/0) */
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e98_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		if (dsta & 1) {
			regs.irc = extra;
			if (dstreg + 8 == ((extra >> 12) & 15)) {
				src += 2;
			}
			m68k_areg(regs, dstreg) += 4;
			m68k_incpci(6);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_areg(regs, dstreg) += 4;
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			m68k_areg(regs, dstreg) += 4;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta + 2, src); 
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			m68k_areg(regs, dstreg) += 4;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) += 4;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 2, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) += 4;
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) += 4;
			exception2_read(opcode, srca + 2, 0x1, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_areg(regs, dstreg) += 4;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/0) */
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ea0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 4;
		if (dsta & 1) {
			regs.irc = extra;
			if (dstreg + 8 == ((extra >> 12) & 15)) {
				src += -2;
			}
			m68k_incpci(6);
			m68k_areg(regs, dstreg) = dsta;
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_areg(regs, dstreg) = dsta;
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta + 2, src); 
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 4;
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			m68k_areg(regs, dstreg) = srca;
			exception3_read_access(opcode, srca, 2, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) = srca;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			m68k_areg(regs, dstreg) = srca;
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) = srca;
			m68k_incpci(2);
			exception2_read(opcode, srca + 2, 0x1, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/0) */
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ea8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta + 2, src); 
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 2, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 2, 0x1, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/0) */
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0eb0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 28; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta + 2, src); 
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return 24 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(8);
			exception3_read_access(opcode, srca, 2, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 2, 0x1, 1);
			return 24 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/0) */
/* 6 4,4   */

#endif
/* MOVES.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0eb8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta + 2, src); 
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(8);
			exception3_read_access(opcode, srca, 2, 1);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 2, 0x1, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/0) */
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0eb9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 28; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_word_000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		dsta |= get_word_000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(10);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		dfc_nommu_put_word(dsta + 2, src); 
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return 24 * CYCLE_UNIT / 2 + count_cycles;
		}
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_word_000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return 12 * CYCLE_UNIT / 2 + count_cycles;
		}
		srca |= get_word_000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(10);
			exception3_read_access(opcode, srca, 2, 1);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return 20 * CYCLE_UNIT / 2 + count_cycles;
		}
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 2, 0x1, 1);
			return 24 * CYCLE_UNIT / 2 + count_cycles;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(8);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (6/0) */
/* 8 0,0   */

#endif
/* MOVE.B Dn,Dn */
uae_u32 REGPARAM2 op_1000_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVE.B (An),Dn */
uae_u32 REGPARAM2 op_1010_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVE.B (An)+,Dn */
uae_u32 REGPARAM2 op_1018_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVE.B -(An),Dn */
uae_u32 REGPARAM2 op_1020_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10 (2/0) */
/* 2 0,0   */

/* MOVE.B (d16,An),Dn */
uae_u32 REGPARAM2 op_1028_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_1030_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVE.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_1038_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_1039_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* MOVE.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_103a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_103b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVE.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_103c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* MOVE.B Dn,(An) */
uae_u32 REGPARAM2 op_1080_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	int loop_mode = regs.loop_mode;
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4+ (0/1) */
/* 2 0,0   */

/* MOVE.B (An),(An) */
uae_u32 REGPARAM2 op_1090_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.B (An)+,(An) */
uae_u32 REGPARAM2 op_1098_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.B -(An),(An) */
uae_u32 REGPARAM2 op_10a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (1/1) */
/* 2 0,0   */

/* MOVE.B (d16,An),(An) */
uae_u32 REGPARAM2 op_10a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An) */
uae_u32 REGPARAM2 op_10b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B (xxx).W,(An) */
uae_u32 REGPARAM2 op_10b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (xxx).L,(An) */
uae_u32 REGPARAM2 op_10b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d16,PC),(An) */
uae_u32 REGPARAM2 op_10ba_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 op_10bb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_10bc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.B Dn,(An)+ */
uae_u32 REGPARAM2 op_10c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	int loop_mode = regs.loop_mode;
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4+ (0/1) */
/* 2 0,0   */

/* MOVE.B (An),(An)+ */
uae_u32 REGPARAM2 op_10d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.B (An)+,(An)+ */
uae_u32 REGPARAM2 op_10d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.B -(An),(An)+ */
uae_u32 REGPARAM2 op_10e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (1/1) */
/* 2 0,0   */

/* MOVE.B (d16,An),(An)+ */
uae_u32 REGPARAM2 op_10e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 op_10f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B (xxx).W,(An)+ */
uae_u32 REGPARAM2 op_10f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (xxx).L,(An)+ */
uae_u32 REGPARAM2 op_10f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d16,PC),(An)+ */
uae_u32 REGPARAM2 op_10fa_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 op_10fb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_10fc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.B Dn,-(An) */
uae_u32 REGPARAM2 op_1100_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.B (An),-(An) */
uae_u32 REGPARAM2 op_1110_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.B (An)+,-(An) */
uae_u32 REGPARAM2 op_1118_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.B -(An),-(An) */
uae_u32 REGPARAM2 op_1120_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 6 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (1/1) */
/* 2 0,0   */

/* MOVE.B (d16,An),-(An) */
uae_u32 REGPARAM2 op_1128_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 op_1130_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B (xxx).W,-(An) */
uae_u32 REGPARAM2 op_1138_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (xxx).L,-(An) */
uae_u32 REGPARAM2 op_1139_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d16,PC),-(An) */
uae_u32 REGPARAM2 op_113a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 op_113b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_113c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_1140_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.B (An),(d16,An) */
uae_u32 REGPARAM2 op_1150_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (An)+,(d16,An) */
uae_u32 REGPARAM2 op_1158_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B -(An),(d16,An) */
uae_u32 REGPARAM2 op_1160_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* MOVE.B (d16,An),(d16,An) */
uae_u32 REGPARAM2 op_1168_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 op_1170_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.B (xxx).W,(d16,An) */
uae_u32 REGPARAM2 op_1178_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (xxx).L,(d16,An) */
uae_u32 REGPARAM2 op_1179_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.B (d16,PC),(d16,An) */
uae_u32 REGPARAM2 op_117a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 op_117b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_117c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_1180_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/1) */
/* 4 4,0   */

/* MOVE.B (An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_1190_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 op_1198_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/1) */
/* 4 4,0   */

/* MOVE.B (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/1) */
/* 6 6,4   */

/* MOVE.B (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_11b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.B (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_11b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (5/1) */
/* 8 4,0   */

/* MOVE.B (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11ba_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11bb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/1) */
/* 6 6,4   */

/* MOVE.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_11bc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 6 4,0   */

/* MOVE.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_11c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.B (An),(xxx).W */
uae_u32 REGPARAM2 op_11d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (An)+,(xxx).W */
uae_u32 REGPARAM2 op_11d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B -(An),(xxx).W */
uae_u32 REGPARAM2 op_11e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* MOVE.B (d16,An),(xxx).W */
uae_u32 REGPARAM2 op_11e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 op_11f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.B (xxx).W,(xxx).W */
uae_u32 REGPARAM2 op_11f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (xxx).L,(xxx).W */
uae_u32 REGPARAM2 op_11f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.B (d16,PC),(xxx).W */
uae_u32 REGPARAM2 op_11fa_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 op_11fb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_11fc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_13c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.B (An),(xxx).L */
uae_u32 REGPARAM2 op_13d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (An)+,(xxx).L */
uae_u32 REGPARAM2 op_13d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B -(An),(xxx).L */
uae_u32 REGPARAM2 op_13e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 0,0   */

/* MOVE.B (d16,An),(xxx).L */
uae_u32 REGPARAM2 op_13e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 op_13f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (5/1) */
/* 8 8,0   */

/* MOVE.B (xxx).W,(xxx).L */
uae_u32 REGPARAM2 op_13f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.B (xxx).L,(xxx).L */
uae_u32 REGPARAM2 op_13f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(8) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(10);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (6/1) */
/* 10 0,0   */

/* MOVE.B (d16,PC),(xxx).L */
uae_u32 REGPARAM2 op_13fa_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 op_13fb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (5/1) */
/* 8 8,0   */

/* MOVE.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_13fc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	put_byte_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 8 0,0   */

/* MOVE.L Dn,Dn */
uae_u32 REGPARAM2 op_2000_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVE.L An,Dn */
uae_u32 REGPARAM2 op_2008_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVE.L (An),Dn */
uae_u32 REGPARAM2 op_2010_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 2 0,0   */

/* MOVE.L (An)+,Dn */
uae_u32 REGPARAM2 op_2018_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 2 0,0   */

/* MOVE.L -(An),Dn */
uae_u32 REGPARAM2 op_2020_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 2 0,0   */

/* MOVE.L (d16,An),Dn */
uae_u32 REGPARAM2 op_2028_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_2030_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (4/0) */
/* 4 4,0   */

/* MOVE.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_2038_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVE.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_2039_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (5/0) */
/* 6 0,0   */

/* MOVE.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_203a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_203b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (4/0) */
/* 4 4,0   */

/* MOVE.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_203c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 6 0,0   */

/* MOVEA.L Dn,An */
uae_u32 REGPARAM2 op_2040_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVEA.L An,An */
uae_u32 REGPARAM2 op_2048_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVEA.L (An),An */
uae_u32 REGPARAM2 op_2050_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 2 0,0   */

/* MOVEA.L (An)+,An */
uae_u32 REGPARAM2 op_2058_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 4;
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 2 0,0   */

/* MOVEA.L -(An),An */
uae_u32 REGPARAM2 op_2060_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 2 0,0   */

/* MOVEA.L (d16,An),An */
uae_u32 REGPARAM2 op_2068_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVEA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 op_2070_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (4/0) */
/* 4 4,0   */

/* MOVEA.L (xxx).W,An */
uae_u32 REGPARAM2 op_2078_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVEA.L (xxx).L,An */
uae_u32 REGPARAM2 op_2079_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (5/0) */
/* 6 0,0   */

/* MOVEA.L (d16,PC),An */
uae_u32 REGPARAM2 op_207a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVEA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_207b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (4/0) */
/* 4 4,0   */

/* MOVEA.L #<data>.L,An */
uae_u32 REGPARAM2 op_207c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 6 0,0   */

/* MOVE.L Dn,(An) */
uae_u32 REGPARAM2 op_2080_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (0/2) */
/* 2 0,0   */

/* MOVE.L An,(An) */
uae_u32 REGPARAM2 op_2088_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (0/2) */
/* 2 0,0   */

/* MOVE.L (An),(An) */
uae_u32 REGPARAM2 op_2090_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16+ (2/2) */
/* 2 0,0   */

/* MOVE.L (An)+,(An) */
uae_u32 REGPARAM2 op_2098_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16+ (2/2) */
/* 2 0,0   */

/* MOVE.L -(An),(An) */
uae_u32 REGPARAM2 op_20a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 18 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18+ (2/2) */
/* 2 0,0   */

/* MOVE.L (d16,An),(An) */
uae_u32 REGPARAM2 op_20a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An) */
uae_u32 REGPARAM2 op_20b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L (xxx).W,(An) */
uae_u32 REGPARAM2 op_20b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (xxx).L,(An) */
uae_u32 REGPARAM2 op_20b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d16,PC),(An) */
uae_u32 REGPARAM2 op_20ba_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 op_20bb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_20bc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MOVE.L Dn,(An)+ */
uae_u32 REGPARAM2 op_20c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (0/2) */
/* 2 0,0   */

/* MOVE.L An,(An)+ */
uae_u32 REGPARAM2 op_20c8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (0/2) */
/* 2 0,0   */

/* MOVE.L (An),(An)+ */
uae_u32 REGPARAM2 op_20d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16+ (2/2) */
/* 2 0,0   */

/* MOVE.L (An)+,(An)+ */
uae_u32 REGPARAM2 op_20d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 16 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16+ (2/2) */
/* 2 0,0   */

/* MOVE.L -(An),(An)+ */
uae_u32 REGPARAM2 op_20e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 18 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18+ (2/2) */
/* 2 0,0   */

/* MOVE.L (d16,An),(An)+ */
uae_u32 REGPARAM2 op_20e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 op_20f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L (xxx).W,(An)+ */
uae_u32 REGPARAM2 op_20f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (xxx).L,(An)+ */
uae_u32 REGPARAM2 op_20f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d16,PC),(An)+ */
uae_u32 REGPARAM2 op_20fa_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 op_20fb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_20fc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(8);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MOVE.L Dn,-(An) */
uae_u32 REGPARAM2 op_2100_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (1/2) */
/* 2 0,0   */

/* MOVE.L An,-(An) */
uae_u32 REGPARAM2 op_2108_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (1/2) */
/* 2 0,0   */

/* MOVE.L (An),-(An) */
uae_u32 REGPARAM2 op_2110_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 4;
			ccr_68000_long_move_ae_LZN(src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16+ (2/2) */
/* 2 0,0   */

/* MOVE.L (An)+,-(An) */
uae_u32 REGPARAM2 op_2118_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 4;
			ccr_68000_long_move_ae_LZN(src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16+ (2/2) */
/* 2 0,0   */

/* MOVE.L -(An),-(An) */
uae_u32 REGPARAM2 op_2120_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 4;
			ccr_68000_long_move_ae_LZN(src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18+ (2/2) */
/* 2 0,0   */

/* MOVE.L (d16,An),-(An) */
uae_u32 REGPARAM2 op_2128_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 op_2130_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L (xxx).W,-(An) */
uae_u32 REGPARAM2 op_2138_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (xxx).L,-(An) */
uae_u32 REGPARAM2 op_2139_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d16,PC),-(An) */
uae_u32 REGPARAM2 op_213a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 op_213b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_213c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta, src >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MOVE.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_2140_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		SET_NFLG(src < 0);
		if((src & 0xffff0000)) SET_ZFLG(0);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/2) */
/* 4 0,0   */

/* MOVE.L An,(d16,An) */
uae_u32 REGPARAM2 op_2148_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		SET_NFLG(src < 0);
		if((src & 0xffff0000)) SET_ZFLG(0);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/2) */
/* 4 0,0   */

/* MOVE.L (An),(d16,An) */
uae_u32 REGPARAM2 op_2150_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (An)+,(d16,An) */
uae_u32 REGPARAM2 op_2158_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L -(An),(d16,An) */
uae_u32 REGPARAM2 op_2160_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 0,0   */

/* MOVE.L (d16,An),(d16,An) */
uae_u32 REGPARAM2 op_2168_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 op_2170_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 6,0   */

/* MOVE.L (xxx).W,(d16,An) */
uae_u32 REGPARAM2 op_2178_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (xxx).L,(d16,An) */
uae_u32 REGPARAM2 op_2179_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 8, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* MOVE.L (d16,PC),(d16,An) */
uae_u32 REGPARAM2 op_217a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 op_217b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 6,0   */

/* MOVE.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_217c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_HNZ(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 8 0,0   */

/* MOVE.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_2180_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		SET_NFLG(src < 0);
		if((src & 0xffff0000)) SET_ZFLG(0);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (2/2) */
/* 4 4,0   */

/* MOVE.L An,(d8,An,Xn) */
uae_u32 REGPARAM2 op_2188_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		SET_NFLG(src < 0);
		if((src & 0xffff0000)) SET_ZFLG(0);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (2/2) */
/* 4 4,0   */

/* MOVE.L (An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_2190_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 op_2198_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (4/2) */
/* 4 4,0   */

/* MOVE.L (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 4,0   */

/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (5/2) */
/* 6 6,4   */

/* MOVE.L (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_21b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 4,0   */

/* MOVE.L (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_21b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 34; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 8, 0);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 34 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 34 * CYCLE_UNIT / 2 + count_cycles;
}
/* 34 (6/2) */
/* 8 4,0   */

/* MOVE.L (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21ba_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 4,0   */

/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21bb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (5/2) */
/* 6 6,4   */

/* MOVE.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_21bc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_HNZ(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 8 4,0   */

/* MOVE.L Dn,(xxx).W */
uae_u32 REGPARAM2 op_21c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/2) */
/* 4 0,0   */

/* MOVE.L An,(xxx).W */
uae_u32 REGPARAM2 op_21c8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/2) */
/* 4 0,0   */

/* MOVE.L (An),(xxx).W */
uae_u32 REGPARAM2 op_21d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (An)+,(xxx).W */
uae_u32 REGPARAM2 op_21d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L -(An),(xxx).W */
uae_u32 REGPARAM2 op_21e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 0,0   */

/* MOVE.L (d16,An),(xxx).W */
uae_u32 REGPARAM2 op_21e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 op_21f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 6,0   */

/* MOVE.L (xxx).W,(xxx).W */
uae_u32 REGPARAM2 op_21f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (xxx).L,(xxx).W */
uae_u32 REGPARAM2 op_21f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 8, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* MOVE.L (d16,PC),(xxx).W */
uae_u32 REGPARAM2 op_21fa_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 op_21fb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 6,0   */

/* MOVE.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_21fc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 8, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 8 0,0   */

/* MOVE.L Dn,(xxx).L */
uae_u32 REGPARAM2 op_23c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MOVE.L An,(xxx).L */
uae_u32 REGPARAM2 op_23c8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MOVE.L (An),(xxx).L */
uae_u32 REGPARAM2 op_23d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 4, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (An)+,(xxx).L */
uae_u32 REGPARAM2 op_23d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 4, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L -(An),(xxx).L */
uae_u32 REGPARAM2 op_23e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 4, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 30 * CYCLE_UNIT / 2 + count_cycles;
}
/* 30 (5/2) */
/* 6 0,0   */

/* MOVE.L (d16,An),(xxx).L */
uae_u32 REGPARAM2 op_23e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 op_23f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 34; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 6, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 34 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 34 * CYCLE_UNIT / 2 + count_cycles;
}
/* 34 (6/2) */
/* 8 8,0   */

/* MOVE.L (xxx).W,(xxx).L */
uae_u32 REGPARAM2 op_23f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* MOVE.L (xxx).L,(xxx).L */
uae_u32 REGPARAM2 op_23f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 36; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(8) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 8, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(10);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 36 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 36 * CYCLE_UNIT / 2 + count_cycles;
}
/* 36 (7/2) */
/* 10 0,0   */

/* MOVE.L (d16,PC),(xxx).L */
uae_u32 REGPARAM2 op_23fa_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 32 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 32 * CYCLE_UNIT / 2 + count_cycles;
}
/* 32 (6/2) */
/* 8 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 op_23fb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 34; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 6, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 30 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 34 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 34 * CYCLE_UNIT / 2 + count_cycles;
}
/* 34 (6/2) */
/* 8 8,0   */

/* MOVE.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_23fc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 10, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(10);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	put_word_000(dsta + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(10);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 10 0,0   */

/* MOVE.W Dn,Dn */
uae_u32 REGPARAM2 op_3000_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVE.W An,Dn */
uae_u32 REGPARAM2 op_3008_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVE.W (An),Dn */
uae_u32 REGPARAM2 op_3010_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVE.W (An)+,Dn */
uae_u32 REGPARAM2 op_3018_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVE.W -(An),Dn */
uae_u32 REGPARAM2 op_3020_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10 (2/0) */
/* 2 0,0   */

/* MOVE.W (d16,An),Dn */
uae_u32 REGPARAM2 op_3028_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_3030_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVE.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_3038_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_3039_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* MOVE.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_303a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_303b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVE.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_303c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* MOVEA.W Dn,An */
uae_u32 REGPARAM2 op_3040_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVEA.W An,An */
uae_u32 REGPARAM2 op_3048_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVEA.W (An),An */
uae_u32 REGPARAM2 op_3050_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVEA.W (An)+,An */
uae_u32 REGPARAM2 op_3058_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVEA.W -(An),An */
uae_u32 REGPARAM2 op_3060_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10 (2/0) */
/* 2 0,0   */

/* MOVEA.W (d16,An),An */
uae_u32 REGPARAM2 op_3068_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVEA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 op_3070_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVEA.W (xxx).W,An */
uae_u32 REGPARAM2 op_3078_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVEA.W (xxx).L,An */
uae_u32 REGPARAM2 op_3079_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (4/0) */
/* 6 0,0   */

/* MOVEA.W (d16,PC),An */
uae_u32 REGPARAM2 op_307a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVEA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_307b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVEA.W #<data>.W,An */
uae_u32 REGPARAM2 op_307c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* MOVE.W Dn,(An) */
uae_u32 REGPARAM2 op_3080_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	int loop_mode = regs.loop_mode;
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4+ (0/1) */
/* 2 0,0   */

/* MOVE.W An,(An) */
uae_u32 REGPARAM2 op_3088_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	int loop_mode = regs.loop_mode;
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4+ (0/1) */
/* 2 0,0   */

/* MOVE.W (An),(An) */
uae_u32 REGPARAM2 op_3090_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.W (An)+,(An) */
uae_u32 REGPARAM2 op_3098_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.W -(An),(An) */
uae_u32 REGPARAM2 op_30a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (1/1) */
/* 2 0,0   */

/* MOVE.W (d16,An),(An) */
uae_u32 REGPARAM2 op_30a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An) */
uae_u32 REGPARAM2 op_30b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W (xxx).W,(An) */
uae_u32 REGPARAM2 op_30b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (xxx).L,(An) */
uae_u32 REGPARAM2 op_30b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d16,PC),(An) */
uae_u32 REGPARAM2 op_30ba_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 op_30bb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_30bc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regflags.cznv = oldflags.cznv;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W Dn,(An)+ */
uae_u32 REGPARAM2 op_30c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	int loop_mode = regs.loop_mode;
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4+ (0/1) */
/* 2 0,0   */

/* MOVE.W An,(An)+ */
uae_u32 REGPARAM2 op_30c8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	int loop_mode = regs.loop_mode;
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4+ (0/1) */
/* 2 0,0   */

/* MOVE.W (An),(An)+ */
uae_u32 REGPARAM2 op_30d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.W (An)+,(An)+ */
uae_u32 REGPARAM2 op_30d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.W -(An),(An)+ */
uae_u32 REGPARAM2 op_30e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_000_prefetch(2);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (1/1) */
/* 2 0,0   */

/* MOVE.W (d16,An),(An)+ */
uae_u32 REGPARAM2 op_30e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 op_30f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W (xxx).W,(An)+ */
uae_u32 REGPARAM2 op_30f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (xxx).L,(An)+ */
uae_u32 REGPARAM2 op_30f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d16,PC),(An)+ */
uae_u32 REGPARAM2 op_30fa_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 op_30fb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_30fc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W Dn,-(An) */
uae_u32 REGPARAM2 op_3100_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.W An,-(An) */
uae_u32 REGPARAM2 op_3108_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.W (An),-(An) */
uae_u32 REGPARAM2 op_3110_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 2;
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.W (An)+,-(An) */
uae_u32 REGPARAM2 op_3118_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 2;
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* MOVE.W -(An),-(An) */
uae_u32 REGPARAM2 op_3120_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 2;
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 6 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (1/1) */
/* 2 0,0   */

/* MOVE.W (d16,An),-(An) */
uae_u32 REGPARAM2 op_3128_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 op_3130_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W (xxx).W,-(An) */
uae_u32 REGPARAM2 op_3138_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (xxx).L,-(An) */
uae_u32 REGPARAM2 op_3139_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(8);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d16,PC),-(An) */
uae_u32 REGPARAM2 op_313a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 op_313b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_313c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_3140_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W An,(d16,An) */
uae_u32 REGPARAM2 op_3148_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W (An),(d16,An) */
uae_u32 REGPARAM2 op_3150_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (An)+,(d16,An) */
uae_u32 REGPARAM2 op_3158_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W -(An),(d16,An) */
uae_u32 REGPARAM2 op_3160_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* MOVE.W (d16,An),(d16,An) */
uae_u32 REGPARAM2 op_3168_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 op_3170_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.W (xxx).W,(d16,An) */
uae_u32 REGPARAM2 op_3178_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (xxx).L,(d16,An) */
uae_u32 REGPARAM2 op_3179_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.W (d16,PC),(d16,An) */
uae_u32 REGPARAM2 op_317a_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 op_317b_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_317c_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_3180_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/1) */
/* 4 4,0   */

/* MOVE.W An,(d8,An,Xn) */
uae_u32 REGPARAM2 op_3188_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/1) */
/* 4 4,0   */

/* MOVE.W (An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_3190_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 op_3198_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/1) */
/* 4 4,0   */

/* MOVE.W (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/1) */
/* 6 6,4   */

/* MOVE.W (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_31b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.W (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_31b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (5/1) */
/* 8 4,0   */

/* MOVE.W (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31ba_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31bb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/1) */
/* 6 6,4   */

/* MOVE.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_31bc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	BusCyclePenalty += 2;
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 6 4,0   */

/* MOVE.W Dn,(xxx).W */
uae_u32 REGPARAM2 op_31c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W An,(xxx).W */
uae_u32 REGPARAM2 op_31c8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W (An),(xxx).W */
uae_u32 REGPARAM2 op_31d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (An)+,(xxx).W */
uae_u32 REGPARAM2 op_31d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W -(An),(xxx).W */
uae_u32 REGPARAM2 op_31e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 0,0   */

/* MOVE.W (d16,An),(xxx).W */
uae_u32 REGPARAM2 op_31e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 op_31f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.W (xxx).W,(xxx).W */
uae_u32 REGPARAM2 op_31f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (xxx).L,(xxx).W */
uae_u32 REGPARAM2 op_31f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.W (d16,PC),(xxx).W */
uae_u32 REGPARAM2 op_31fa_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 op_31fb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_31fc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.W Dn,(xxx).L */
uae_u32 REGPARAM2 op_33c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.W An,(xxx).L */
uae_u32 REGPARAM2 op_33c8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.W (An),(xxx).L */
uae_u32 REGPARAM2 op_33d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (An)+,(xxx).L */
uae_u32 REGPARAM2 op_33d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W -(An),(xxx).L */
uae_u32 REGPARAM2 op_33e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_word_000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/1) */
/* 6 0,0   */

/* MOVE.W (d16,An),(xxx).L */
uae_u32 REGPARAM2 op_33e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 op_33f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (5/1) */
/* 8 8,0   */

/* MOVE.W (xxx).W,(xxx).L */
uae_u32 REGPARAM2 op_33f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.W (xxx).L,(xxx).L */
uae_u32 REGPARAM2 op_33f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(8) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(10);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (6/1) */
/* 10 0,0   */

/* MOVE.W (d16,PC),(xxx).L */
uae_u32 REGPARAM2 op_33fa_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 op_33fb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	get_word_000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (5/1) */
/* 8 8,0   */

/* MOVE.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_33fc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uaecptr dsta;
	dsta = get_word_000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	dsta |= get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 8 0,0   */

/* NEGX.B Dn */
uae_u32 REGPARAM2 op_4000_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* NEGX.B (An) */
uae_u32 REGPARAM2 op_4010_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_byte_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* NEGX.B (An)+ */
uae_u32 REGPARAM2 op_4018_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_byte_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* NEGX.B -(An) */
uae_u32 REGPARAM2 op_4020_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 6 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_byte_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (1/1) */
/* 2 0,0   */

/* NEGX.B (d16,An) */
uae_u32 REGPARAM2 op_4028_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEGX.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4030_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NEGX.B (xxx).W */
uae_u32 REGPARAM2 op_4038_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEGX.B (xxx).L */
uae_u32 REGPARAM2 op_4039_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* NEGX.W Dn */
uae_u32 REGPARAM2 op_4040_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* NEGX.W (An) */
uae_u32 REGPARAM2 op_4050_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_word_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* NEGX.W (An)+ */
uae_u32 REGPARAM2 op_4058_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_word_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* NEGX.W -(An) */
uae_u32 REGPARAM2 op_4060_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 6 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_word_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (1/1) */
/* 2 0,0   */

/* NEGX.W (d16,An) */
uae_u32 REGPARAM2 op_4068_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEGX.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4070_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NEGX.W (xxx).W */
uae_u32 REGPARAM2 op_4078_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEGX.W (xxx).L */
uae_u32 REGPARAM2 op_4079_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* NEGX.L Dn */
uae_u32 REGPARAM2 op_4080_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		dreg_68000_long_replace_low(srcreg, newv);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	m68k_dreg(regs, srcreg) = (newv);
	m68k_incpci(2);
	return 6 * CYCLE_UNIT / 2 + count_cycles;
}
/* 6 (1/0) */
/* 2 0,0   */

/* NEGX.L (An) */
uae_u32 REGPARAM2 op_4090_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			int bflgs = ((uae_s16)(src)) < 0;
			int bflgo = ((uae_s16)(0)) < 0;
			int bflgn = ((uae_s16)(newv)) < 0;
			SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
			SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
			SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
			SET_NFLG(((uae_s16)(newv)) < 0);
			SET_XFLG(GET_CFLG());
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_word_000(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16+ (2/2) */
/* 2 0,0   */

/* NEGX.L (An)+ */
uae_u32 REGPARAM2 op_4098_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 4;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			int bflgs = ((uae_s16)(src)) < 0;
			int bflgo = ((uae_s16)(0)) < 0;
			int bflgn = ((uae_s16)(newv)) < 0;
			SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
			SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
			SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
			SET_NFLG(((uae_s16)(newv)) < 0);
			SET_XFLG(GET_CFLG());
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 8 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_word_000(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16+ (2/2) */
/* 2 0,0   */

/* NEGX.L -(An) */
uae_u32 REGPARAM2 op_40a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 18; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			int bflgs = ((uae_s16)(src)) < 0;
			int bflgo = ((uae_s16)(0)) < 0;
			int bflgn = ((uae_s16)(newv)) < 0;
			SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
			SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
			SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
			SET_NFLG(((uae_s16)(newv)) < 0);
			SET_XFLG(GET_CFLG());
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_word_000(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18+ (2/2) */
/* 2 0,0   */

/* NEGX.L (d16,An) */
uae_u32 REGPARAM2 op_40a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(newv)) < 0;
		SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
		SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
		SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
		SET_NFLG(((uae_s16)(newv)) < 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* NEGX.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_40b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(newv)) < 0;
		SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
		SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
		SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
		SET_NFLG(((uae_s16)(newv)) < 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return 26 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 26 * CYCLE_UNIT / 2 + count_cycles;
}
/* 26 (4/2) */
/* 4 4,0   */

/* NEGX.L (xxx).W */
uae_u32 REGPARAM2 op_40b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(newv)) < 0;
		SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
		SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
		SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
		SET_NFLG(((uae_s16)(newv)) < 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 24 * CYCLE_UNIT / 2 + count_cycles;
}
/* 24 (4/2) */
/* 4 0,0   */

/* NEGX.L (xxx).L */
uae_u32 REGPARAM2 op_40b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s32 src = get_word_000(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	src |= get_word_000(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(newv)) < 0;
		SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
		SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
		SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
		SET_NFLG(((uae_s16)(newv)) < 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return 24 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, newv >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return 28 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 28 * CYCLE_UNIT / 2 + count_cycles;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MVSR2.W Dn */
uae_u32 REGPARAM2 op_40c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 4;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MVSR2.W (An) */
uae_u32 REGPARAM2 op_40d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 10; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10 (1/1) */
/* 2 0,0   */

/* MVSR2.W (An)+ */
uae_u32 REGPARAM2 op_40d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (1/1) */
/* 2 0,0   */

/* MVSR2.W -(An) */
uae_u32 REGPARAM2 op_40e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg(regs, srcreg) = srca;
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (1/1) */
/* 2 0,0   */

/* MVSR2.W (d16,An) */
uae_u32 REGPARAM2 op_40e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MVSR2.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_40f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/1) */
/* 4 4,0   */

/* MVSR2.W (xxx).W */
uae_u32 REGPARAM2 op_40f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MVSR2.W (xxx).L */
uae_u32 REGPARAM2 op_40f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(8);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

/* CHK.W Dn,Dn */
uae_u32 REGPARAM2 op_4180_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 10; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10 (1/0) */
/* 2 0,0   */

/* CHK.W (An),Dn */
uae_u32 REGPARAM2 op_4190_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/0) */
/* 2 0,0   */

/* CHK.W (An)+,Dn */
uae_u32 REGPARAM2 op_4198_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/0) */
/* 2 0,0   */

/* CHK.W -(An),Dn */
uae_u32 REGPARAM2 op_41a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/0) */
/* 2 0,0   */

/* CHK.W (d16,An),Dn */
uae_u32 REGPARAM2 op_41a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/0) */
/* 4 0,0   */

/* CHK.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_41b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/0) */
/* 4 4,0   */

/* CHK.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_41b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/0) */
/* 4 0,0   */

/* CHK.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_41b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 22 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 22 * CYCLE_UNIT / 2 + count_cycles;
}
/* 22 (4/0) */
/* 6 0,0   */

/* CHK.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_41ba_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/0) */
/* 4 0,0   */

/* CHK.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_41bb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/0) */
/* 4 4,0   */

/* CHK.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_41bc_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 14; 
	uae_s16 src = get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	setchkundefinedflags(src, dst, 1);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/0) */
/* 4 0,0   */

/* LEA.L (An),An */
uae_u32 REGPARAM2 op_41d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, dstreg) = (srca);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* LEA.L (d16,An),An */
uae_u32 REGPARAM2 op_41e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (srca);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* LEA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 op_41f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (srca);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/0) */
/* 4 4,0   */

/* LEA.L (xxx).W,An */
uae_u32 REGPARAM2 op_41f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (srca);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* LEA.L (xxx).L,An */
uae_u32 REGPARAM2 op_41f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (srca);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (3/0) */
/* 6 0,0   */

/* LEA.L (d16,PC),An */
uae_u32 REGPARAM2 op_41fa_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (srca);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8 (2/0) */
/* 4 0,0   */

/* LEA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_41fb_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	srca = get_disp_ea_000(tmppc, get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, dstreg) = (srca);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 14 * CYCLE_UNIT / 2 + count_cycles;
}
/* 14 (2/0) */
/* 4 4,0   */

/* CLR.B Dn */
uae_u32 REGPARAM2 op_4200_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((0) & 0xff);
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* CLR.B (An) */
uae_u32 REGPARAM2 op_4210_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	put_byte_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4+ (0/1) */
/* 2 0,0   */

/* CLR.B (An)+ */
uae_u32 REGPARAM2 op_4218_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	put_byte_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) -= areg_byteinc[srcreg];
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4+ (0/1) */
/* 2 0,0   */

/* CLR.B -(An) */
uae_u32 REGPARAM2 op_4220_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 6;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 2 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	put_byte_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 6 * CYCLE_UNIT / 2 + count_cycles;
}
/* 6+ (0/1) */
/* 2 0,0   */

/* CLR.B (d16,An) */
uae_u32 REGPARAM2 op_4228_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* CLR.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4230_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/1) */
/* 4 4,0   */

/* CLR.B (xxx).W */
uae_u32 REGPARAM2 op_4238_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* CLR.B (xxx).L */
uae_u32 REGPARAM2 op_4239_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	put_byte_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

/* CLR.W Dn */
uae_u32 REGPARAM2 op_4240_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((0) & 0xffff);
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* CLR.W (An) */
uae_u32 REGPARAM2 op_4250_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	put_word_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4+ (0/1) */
/* 2 0,0   */

/* CLR.W (An)+ */
uae_u32 REGPARAM2 op_4258_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	if(srca & 1) {
		m68k_areg(regs, srcreg) -= 2;
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	put_word_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) -= 2;
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4+ (0/1) */
/* 2 0,0   */

/* CLR.W -(An) */
uae_u32 REGPARAM2 op_4260_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 6;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg(regs, srcreg) = srca;
	if(srca & 1) {
		m68k_areg(regs, srcreg) += 2;
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 2 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	put_word_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) += 2;
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 6 * CYCLE_UNIT / 2 + count_cycles;
}
/* 6+ (0/1) */
/* 2 0,0   */

/* CLR.W (d16,An) */
uae_u32 REGPARAM2 op_4268_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(srca & 1) {
		get_word_000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(0)) == 0);
		SET_NFLG(((uae_s16)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* CLR.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4270_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(srca & 1) {
		get_word_000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(0)) == 0);
		SET_NFLG(((uae_s16)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/1) */
/* 4 4,0   */

/* CLR.W (xxx).W */
uae_u32 REGPARAM2 op_4278_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(srca & 1) {
		get_word_000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(0)) == 0);
		SET_NFLG(((uae_s16)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

/* CLR.W (xxx).L */
uae_u32 REGPARAM2 op_4279_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(srca & 1) {
		get_word_000_prefetch(8);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(0)) == 0);
		SET_NFLG(((uae_s16)(0)) < 0);
		m68k_incpci(8);
		exception3_write(opcode, srca, 1, 0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	put_word_000(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

/* CLR.L Dn */
uae_u32 REGPARAM2 op_4280_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 6;  
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	m68k_dreg(regs, srcreg) = (0);
	m68k_incpci(2);
	return 6 * CYCLE_UNIT / 2 + count_cycles;
}
/* 6 (1/0) */
/* 2 0,0   */

/* CLR.L (An) */
uae_u32 REGPARAM2 op_4290_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	put_word_000(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, 0 >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (0/2) */
/* 2 0,0   */

/* CLR.L (An)+ */
uae_u32 REGPARAM2 op_4298_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 4;
	if(srca & 1) {
		m68k_areg(regs, srcreg) -= 4;
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	put_word_000(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) -= 4;
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, 0 >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) -= 4;
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (0/2) */
/* 2 0,0   */

/* CLR.L -(An) */
uae_u32 REGPARAM2 op_42a0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	m68k_areg(regs, srcreg) = srca;
	if(srca & 1) {
		m68k_areg(regs, srcreg) += 4;
		srca += 2;
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 2 * CYCLE_UNIT / 2 + count_cycles;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	put_word_000(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) += 4;
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, 0 >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) += 4;
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (0/2) */
/* 2 0,0   */

/* CLR.L (d16,An) */
uae_u32 REGPARAM2 op_42a8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(srca & 1) {
		srca += 2;
		get_word_000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s32)(0)) == 0);
		SET_NFLG(((uae_s32)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_word_000(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, 0 >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/2) */
/* 4 0,0   */

/* CLR.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_42b0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 20; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(srca & 1) {
		srca += 2;
		get_word_000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s32)(0)) == 0);
		SET_NFLG(((uae_s32)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_word_000(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, 0 >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (2/2) */
/* 4 4,0   */

/* CLR.L (xxx).W */
uae_u32 REGPARAM2 op_42b8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(srca & 1) {
		srca += 2;
		get_word_000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s32)(0)) == 0);
		SET_NFLG(((uae_s32)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_word_000(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, 0 >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/2) */
/* 4 0,0   */

/* CLR.L (xxx).L */
uae_u32 REGPARAM2 op_42b9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 20; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if(srca & 1) {
		srca += 2;
		get_word_000_prefetch(8);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s32)(0)) == 0);
		SET_NFLG(((uae_s32)(0)) < 0);
		m68k_incpci(8);
		exception3_write(opcode, srca, 1, 0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	put_word_000(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, 0 >> 16); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42c0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 4;  
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42d0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10 (1/1) */
/* 2 0,0   */

#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42d8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (1/1) */
/* 2 0,0   */

#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42e0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg(regs, srcreg) = srca;
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (1/1) */
/* 2 0,0   */

#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42e8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42f0_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (2/1) */
/* 4 4,0   */

#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42f8_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 12 * CYCLE_UNIT / 2 + count_cycles;
}
/* 12 (2/1) */
/* 4 0,0   */

#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42f9_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	MakeSR();
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(8);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	put_word_000(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 6 0,0   */

#endif
/* NEG.B Dn */
uae_u32 REGPARAM2 op_4400_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* NEG.B (An) */
uae_u32 REGPARAM2 op_4410_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_byte_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* NEG.B (An)+ */
uae_u32 REGPARAM2 op_4418_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_byte_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* NEG.B -(An) */
uae_u32 REGPARAM2 op_4420_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 6 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_byte_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (1/1) */
/* 2 0,0   */

/* NEG.B (d16,An) */
uae_u32 REGPARAM2 op_4428_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEG.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4430_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NEG.B (xxx).W */
uae_u32 REGPARAM2 op_4438_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEG.B (xxx).L */
uae_u32 REGPARAM2 op_4439_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s8 src = get_byte_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_byte_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return 20 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(6);
	return 20 * CYCLE_UNIT / 2 + count_cycles;
}
/* 20 (4/1) */
/* 6 0,0   */

/* NEG.W Dn */
uae_u32 REGPARAM2 op_4440_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(2);
	return 4 * CYCLE_UNIT / 2 + count_cycles;
}
/* 4 (1/0) */
/* 2 0,0   */

/* NEG.W (An) */
uae_u32 REGPARAM2 op_4450_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_word_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* NEG.W (An)+ */
uae_u32 REGPARAM2 op_4458_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 0 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) += 2;
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 4 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_word_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 8 * CYCLE_UNIT / 2 + count_cycles;
}
/* 8+ (1/1) */
/* 2 0,0   */

/* NEG.W -(An) */
uae_u32 REGPARAM2 op_4460_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return 2 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_000_prefetch(4);
		count_cycles += 4 * CYCLE_UNIT / 2;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return 6 * CYCLE_UNIT / 2 + count_cycles;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		count_cycles += (loop_mode & 0xfffe) * CYCLE_UNIT / 2;
		loop_mode = 1;
	}
	put_word_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return 10 * CYCLE_UNIT / 2 + count_cycles;
}
/* 10+ (1/1) */
/* 2 0,0   */

/* NEG.W (d16,An) */
uae_u32 REGPARAM2 op_4468_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEG.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4470_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	BusCyclePenalty += 2;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return 6 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 10 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 14 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return 18 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 18 * CYCLE_UNIT / 2 + count_cycles;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NEG.W (xxx).W */
uae_u32 REGPARAM2 op_4478_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return 12 * CYCLE_UNIT / 2 + count_cycles;
	}
	opcode = regs.ir;
	put_word_000(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return 16 * CYCLE_UNIT / 2 + count_cycles;
	}
	m68k_incpci(4);
	return 16 * CYCLE_UNIT / 2 + count_cycles;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEG.W (xxx).L */
uae_u32 REGPARAM2 op_4479_11_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return 4 * CYCLE_UNIT / 2 + count_cycles;
	}
	srca |= get_word_000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return 8 * CYCLE_UNIT / 2 + count_cycles;
	}
	uae_s16 src = get_word_000(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6