/*
 * Copyright 2019-2025 The OpenSSL Project Authors. All Rights Reserved.
 *
 * Licensed under the Apache License 2.0 (the "License").  You may not use
 * this file except in compliance with the License.  You can obtain a copy
 * in the file LICENSE in the source distribution or at
 * https://www.openssl.org/source/license.html
 */


#include <string.h>
#include <openssl/err.h>
#include <openssl/proverr.h>
#include "prov/digestcommon.h"
#include "internal/common.h"

/* Machine generated by util/perl/OpenSSL/paramnames.pm */
#ifndef digest_default_get_params_list
static const OSSL_PARAM digest_default_get_params_list[] = {
    OSSL_PARAM_size_t(OSSL_DIGEST_PARAM_BLOCK_SIZE, NULL),
    OSSL_PARAM_size_t(OSSL_DIGEST_PARAM_SIZE, NULL),
    OSSL_PARAM_int(OSSL_DIGEST_PARAM_XOF, NULL),
    OSSL_PARAM_int(OSSL_DIGEST_PARAM_ALGID_ABSENT, NULL),
    OSSL_PARAM_END
};
#endif

#ifndef digest_default_get_params_st
struct digest_default_get_params_st {
    OSSL_PARAM *aldid;
    OSSL_PARAM *bsize;
    OSSL_PARAM *size;
    OSSL_PARAM *xof;
};
#endif

#ifndef digest_default_get_params_decoder
static int digest_default_get_params_decoder
    (const OSSL_PARAM *p, struct digest_default_get_params_st *r)
{
    const char *s;

    memset(r, 0, sizeof(*r));
    if (p != NULL)
        for (; (s = p->key) != NULL; p++)
            switch(s[0]) {
            default:
                break;
            case 'a':
                if (ossl_likely(strcmp("lgid-absent", s + 1) == 0)) {
                    /* OSSL_DIGEST_PARAM_ALGID_ABSENT */
                    if (ossl_unlikely(r->aldid != NULL)) {
                        ERR_raise_data(ERR_LIB_PROV, PROV_R_REPEATED_PARAMETER,
                                       "param %s is repeated", s);
                        return 0;
                    }
                    r->aldid = (OSSL_PARAM *)p;
                }
                break;
            case 'b':
                if (ossl_likely(strcmp("locksize", s + 1) == 0)) {
                    /* OSSL_DIGEST_PARAM_BLOCK_SIZE */
                    if (ossl_unlikely(r->bsize != NULL)) {
                        ERR_raise_data(ERR_LIB_PROV, PROV_R_REPEATED_PARAMETER,
                                       "param %s is repeated", s);
                        return 0;
                    }
                    r->bsize = (OSSL_PARAM *)p;
                }
                break;
            case 's':
                if (ossl_likely(strcmp("ize", s + 1) == 0)) {
                    /* OSSL_DIGEST_PARAM_SIZE */
                    if (ossl_unlikely(r->size != NULL)) {
                        ERR_raise_data(ERR_LIB_PROV, PROV_R_REPEATED_PARAMETER,
                                       "param %s is repeated", s);
                        return 0;
                    }
                    r->size = (OSSL_PARAM *)p;
                }
                break;
            case 'x':
                if (ossl_likely(strcmp("of", s + 1) == 0)) {
                    /* OSSL_DIGEST_PARAM_XOF */
                    if (ossl_unlikely(r->xof != NULL)) {
                        ERR_raise_data(ERR_LIB_PROV, PROV_R_REPEATED_PARAMETER,
                                       "param %s is repeated", s);
                        return 0;
                    }
                    r->xof = (OSSL_PARAM *)p;
                }
            }
    return 1;
}
#endif
/* End of machine generated */

int ossl_digest_default_get_params(OSSL_PARAM params[], size_t blksz,
                                   size_t paramsz, unsigned long flags)
{
    struct digest_default_get_params_st p;

    if (!digest_default_get_params_decoder(params, &p))
        return 0;

    if (p.bsize != NULL && !OSSL_PARAM_set_size_t(p.bsize, blksz)) {
        ERR_raise(ERR_LIB_PROV, PROV_R_FAILED_TO_SET_PARAMETER);
        return 0;
    }
    if (p.size != NULL && !OSSL_PARAM_set_size_t(p.size, paramsz)) {
        ERR_raise(ERR_LIB_PROV, PROV_R_FAILED_TO_SET_PARAMETER);
        return 0;
    }
    if (p.xof != NULL
        && !OSSL_PARAM_set_int(p.xof, (flags & PROV_DIGEST_FLAG_XOF) != 0)) {
        ERR_raise(ERR_LIB_PROV, PROV_R_FAILED_TO_SET_PARAMETER);
        return 0;
    }
    if (p.aldid != NULL
        && !OSSL_PARAM_set_int(p.aldid, (flags & PROV_DIGEST_FLAG_ALGID_ABSENT) != 0)) {
        ERR_raise(ERR_LIB_PROV, PROV_R_FAILED_TO_SET_PARAMETER);
        return 0;
    }
    return 1;
}

const OSSL_PARAM *ossl_digest_default_gettable_params(void *provctx)
{
    return digest_default_get_params_list;
}
