// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

#ifndef CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_I_CALENDAR_PROPS_HXX
#define CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_I_CALENDAR_PROPS_HXX

#ifndef XSD_CXX11
#define XSD_CXX11
#endif

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (LIBXSD_VERSION != 400002000000000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< char, type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< char, ncname, type > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  typedef ::xsd::cxx::tree::content_order content_order;
  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info< char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap< char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream< char > list_stream;
  typedef ::xsd::cxx::tree::as_double< double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal< decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::unique_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace icalendar_2_0
{
  class BasePropertyType;
  class ArrayOfProperties;
  class TextPropertyType;
  class TextListPropertyType;
  class CalAddressPropertyType;
  class IntegerPropertyType;
  class UriPropertyType;
  class UtcOffsetPropertyType;
  class DatetimePropertyType;
  class UtcDatetimePropertyType;
  class DateDatetimePropertyType;
  class RecurPropertyType;
  class CalscaleValueType;
  class CalscalePropType;
  class MethodPropType;
  class ProdidPropType;
  class VersionPropType;
  class AttachPropType;
  class CategoriesPropType;
  class ClassPropType;
  class CommentPropType;
  class DescriptionPropType;
  class GeoPropType;
  class LocationPropType;
  class PercentCompletePropType;
  class PriorityPropType;
  class ResourcesPropType;
  class StatusPropType;
  class SummaryPropType;
  class CompletedPropType;
  class DtendPropType;
  class DuePropType;
  class DtstartPropType;
  class DurationPropType;
  class FreebusyPropType;
  class TranspPropType;
  class TzidPropType;
  class TznamePropType;
  class TzoffsetfromPropType;
  class TzoffsettoPropType;
  class TzurlPropType;
  class AttendeePropType;
  class ContactPropType;
  class OrganizerPropType;
  class RecurrenceIdPropType;
  class RelatedToPropType;
  class UrlPropType;
  class UidPropType;
  class ExdatePropType;
  class RdatePropType;
  class RrulePropType;
  class ExrulePropType;
  class ActionPropType;
  class RepeatPropType;
  class TriggerPropType;
  class CreatedPropType;
  class DtstampPropType;
  class LastModifiedPropType;
  class SequencePropType;
  class RequestStatusPropType;
}


#include <memory>    // ::std::unique_ptr
#include <limits>    // std::numeric_limits
#include <algorithm> // std::binary_search
#include <utility>   // std::move

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

#include "iCalendar-params.hxx"

namespace icalendar_2_0
{
  class BasePropertyType: public ::xml_schema::type
  {
    public:
    // parameters
    //
    typedef ::icalendar_2_0::ArrayOfParameters parameters_type;
    typedef ::xsd::cxx::tree::optional< parameters_type > parameters_optional;
    typedef ::xsd::cxx::tree::traits< parameters_type, char > parameters_traits;

    const parameters_optional&
    parameters () const;

    parameters_optional&
    parameters ();

    void
    parameters (const parameters_type& x);

    void
    parameters (const parameters_optional& x);

    void
    parameters (::std::unique_ptr< parameters_type > p);

    // Constructors.
    //
    BasePropertyType ();

    BasePropertyType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    BasePropertyType (const BasePropertyType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual BasePropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const = 0;

    BasePropertyType&
    operator= (const BasePropertyType& x);

    virtual 
    ~BasePropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    parameters_optional parameters_;
  };

  class ArrayOfProperties: public ::xml_schema::type
  {
    public:
    // baseProperty
    //
    typedef ::icalendar_2_0::BasePropertyType baseProperty_type;
    typedef ::xsd::cxx::tree::sequence< baseProperty_type > baseProperty_sequence;
    typedef baseProperty_sequence::iterator baseProperty_iterator;
    typedef baseProperty_sequence::const_iterator baseProperty_const_iterator;
    typedef ::xsd::cxx::tree::traits< baseProperty_type, char > baseProperty_traits;

    const baseProperty_sequence&
    baseProperty () const;

    baseProperty_sequence&
    baseProperty ();

    void
    baseProperty (const baseProperty_sequence& s);

    // Constructors.
    //
    ArrayOfProperties ();

    ArrayOfProperties (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ArrayOfProperties (const ArrayOfProperties& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual ArrayOfProperties*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ArrayOfProperties&
    operator= (const ArrayOfProperties& x);

    virtual 
    ~ArrayOfProperties ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    baseProperty_sequence baseProperty_;
  };

  class TextPropertyType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    // Constructors.
    //
    TextPropertyType (const text_type&);

    TextPropertyType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    TextPropertyType (const TextPropertyType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual TextPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TextPropertyType&
    operator= (const TextPropertyType& x);

    virtual 
    ~TextPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
  };

  class TextListPropertyType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::sequence< text_type > text_sequence;
    typedef text_sequence::iterator text_iterator;
    typedef text_sequence::const_iterator text_const_iterator;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_sequence&
    text () const;

    text_sequence&
    text ();

    void
    text (const text_sequence& s);

    // Constructors.
    //
    TextListPropertyType ();

    TextListPropertyType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    TextListPropertyType (const TextListPropertyType& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual TextListPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TextListPropertyType&
    operator= (const TextListPropertyType& x);

    virtual 
    ~TextListPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    text_sequence text_;
  };

  class CalAddressPropertyType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // cal-address
    //
    typedef ::icalendar_2_0::CalAddressType cal_address_type;
    typedef ::xsd::cxx::tree::traits< cal_address_type, char > cal_address_traits;

    const cal_address_type&
    cal_address () const;

    cal_address_type&
    cal_address ();

    void
    cal_address (const cal_address_type& x);

    void
    cal_address (::std::unique_ptr< cal_address_type > p);

    // Constructors.
    //
    CalAddressPropertyType (const cal_address_type&);

    CalAddressPropertyType (const ::xercesc::DOMElement& e,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    CalAddressPropertyType (const CalAddressPropertyType& x,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    virtual CalAddressPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CalAddressPropertyType&
    operator= (const CalAddressPropertyType& x);

    virtual 
    ~CalAddressPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< cal_address_type > cal_address_;
  };

  class IntegerPropertyType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // integer
    //
    typedef ::xml_schema::integer integer_type;
    typedef ::xsd::cxx::tree::traits< integer_type, char > integer_traits;

    const integer_type&
    integer () const;

    integer_type&
    integer ();

    void
    integer (const integer_type& x);

    // Constructors.
    //
    IntegerPropertyType (const integer_type&);

    IntegerPropertyType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    IntegerPropertyType (const IntegerPropertyType& x,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    virtual IntegerPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    IntegerPropertyType&
    operator= (const IntegerPropertyType& x);

    virtual 
    ~IntegerPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< integer_type > integer_;
  };

  class UriPropertyType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // uri
    //
    typedef ::icalendar_2_0::UriType uri_type;
    typedef ::xsd::cxx::tree::traits< uri_type, char > uri_traits;

    const uri_type&
    uri () const;

    uri_type&
    uri ();

    void
    uri (const uri_type& x);

    void
    uri (::std::unique_ptr< uri_type > p);

    // Constructors.
    //
    UriPropertyType (const uri_type&);

    UriPropertyType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    UriPropertyType (const UriPropertyType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual UriPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    UriPropertyType&
    operator= (const UriPropertyType& x);

    virtual 
    ~UriPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uri_type > uri_;
  };

  class UtcOffsetPropertyType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // utc-offset
    //
    typedef ::icalendar_2_0::UtcOffsetType utc_offset_type;
    typedef ::xsd::cxx::tree::traits< utc_offset_type, char > utc_offset_traits;

    const utc_offset_type&
    utc_offset () const;

    utc_offset_type&
    utc_offset ();

    void
    utc_offset (const utc_offset_type& x);

    void
    utc_offset (::std::unique_ptr< utc_offset_type > p);

    // Constructors.
    //
    UtcOffsetPropertyType (const utc_offset_type&);

    UtcOffsetPropertyType (const ::xercesc::DOMElement& e,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    UtcOffsetPropertyType (const UtcOffsetPropertyType& x,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    virtual UtcOffsetPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    UtcOffsetPropertyType&
    operator= (const UtcOffsetPropertyType& x);

    virtual 
    ~UtcOffsetPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< utc_offset_type > utc_offset_;
  };

  class DatetimePropertyType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // date-time
    //
    typedef ::icalendar_2_0::DateTimeType date_time_type;
    typedef ::xsd::cxx::tree::traits< date_time_type, char > date_time_traits;

    const date_time_type&
    date_time () const;

    date_time_type&
    date_time ();

    void
    date_time (const date_time_type& x);

    void
    date_time (::std::unique_ptr< date_time_type > p);

    // Constructors.
    //
    DatetimePropertyType (const date_time_type&);

    DatetimePropertyType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    DatetimePropertyType (const DatetimePropertyType& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual DatetimePropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DatetimePropertyType&
    operator= (const DatetimePropertyType& x);

    virtual 
    ~DatetimePropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< date_time_type > date_time_;
  };

  class UtcDatetimePropertyType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // utc-date-time
    //
    typedef ::icalendar_2_0::UTCDateTimeType utc_date_time_type;
    typedef ::xsd::cxx::tree::optional< utc_date_time_type > utc_date_time_optional;
    typedef ::xsd::cxx::tree::traits< utc_date_time_type, char > utc_date_time_traits;

    const utc_date_time_optional&
    utc_date_time () const;

    utc_date_time_optional&
    utc_date_time ();

    void
    utc_date_time (const utc_date_time_type& x);

    void
    utc_date_time (const utc_date_time_optional& x);

    void
    utc_date_time (::std::unique_ptr< utc_date_time_type > p);

    // date-time
    //
    typedef ::icalendar_2_0::DateTimeType date_time_type;
    typedef ::xsd::cxx::tree::optional< date_time_type > date_time_optional;
    typedef ::xsd::cxx::tree::traits< date_time_type, char > date_time_traits;

    const date_time_optional&
    date_time () const;

    date_time_optional&
    date_time ();

    void
    date_time (const date_time_type& x);

    void
    date_time (const date_time_optional& x);

    void
    date_time (::std::unique_ptr< date_time_type > p);

    // Constructors.
    //
    UtcDatetimePropertyType ();

    UtcDatetimePropertyType (const ::xercesc::DOMElement& e,
                             ::xml_schema::flags f = 0,
                             ::xml_schema::container* c = 0);

    UtcDatetimePropertyType (const UtcDatetimePropertyType& x,
                             ::xml_schema::flags f = 0,
                             ::xml_schema::container* c = 0);

    virtual UtcDatetimePropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    UtcDatetimePropertyType&
    operator= (const UtcDatetimePropertyType& x);

    virtual 
    ~UtcDatetimePropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    utc_date_time_optional utc_date_time_;
    date_time_optional date_time_;
  };

  class DateDatetimePropertyType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // date-time
    //
    typedef ::icalendar_2_0::DateTimeType date_time_type;
    typedef ::xsd::cxx::tree::optional< date_time_type > date_time_optional;
    typedef ::xsd::cxx::tree::traits< date_time_type, char > date_time_traits;

    const date_time_optional&
    date_time () const;

    date_time_optional&
    date_time ();

    void
    date_time (const date_time_type& x);

    void
    date_time (const date_time_optional& x);

    void
    date_time (::std::unique_ptr< date_time_type > p);

    // date
    //
    typedef ::xml_schema::date date_type;
    typedef ::xsd::cxx::tree::optional< date_type > date_optional;
    typedef ::xsd::cxx::tree::traits< date_type, char > date_traits;

    const date_optional&
    date () const;

    date_optional&
    date ();

    void
    date (const date_type& x);

    void
    date (const date_optional& x);

    void
    date (::std::unique_ptr< date_type > p);

    // Constructors.
    //
    DateDatetimePropertyType ();

    DateDatetimePropertyType (const ::xercesc::DOMElement& e,
                              ::xml_schema::flags f = 0,
                              ::xml_schema::container* c = 0);

    DateDatetimePropertyType (const DateDatetimePropertyType& x,
                              ::xml_schema::flags f = 0,
                              ::xml_schema::container* c = 0);

    virtual DateDatetimePropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DateDatetimePropertyType&
    operator= (const DateDatetimePropertyType& x);

    virtual 
    ~DateDatetimePropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    date_time_optional date_time_;
    date_optional date_;
  };

  class RecurPropertyType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // recur
    //
    typedef ::icalendar_2_0::RecurType recur_type;
    typedef ::xsd::cxx::tree::traits< recur_type, char > recur_traits;

    const recur_type&
    recur () const;

    recur_type&
    recur ();

    void
    recur (const recur_type& x);

    void
    recur (::std::unique_ptr< recur_type > p);

    // Constructors.
    //
    RecurPropertyType (const recur_type&);

    RecurPropertyType (::std::unique_ptr< recur_type >);

    RecurPropertyType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    RecurPropertyType (const RecurPropertyType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual RecurPropertyType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    RecurPropertyType&
    operator= (const RecurPropertyType& x);

    virtual 
    ~RecurPropertyType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< recur_type > recur_;
  };

  class CalscaleValueType: public ::xml_schema::string
  {
    public:
    enum value
    {
      GREGORIAN
    };

    CalscaleValueType (value v);

    CalscaleValueType (const char* v);

    CalscaleValueType (const ::std::string& v);

    CalscaleValueType (const ::xml_schema::string& v);

    CalscaleValueType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    CalscaleValueType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    CalscaleValueType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    CalscaleValueType (const CalscaleValueType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    CalscaleValueType&
    operator= (const CalscaleValueType&) = default;
#endif

    virtual CalscaleValueType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CalscaleValueType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_CalscaleValueType_convert ();
    }

    protected:
    value
    _xsd_CalscaleValueType_convert () const;

    public:
    static const char* const _xsd_CalscaleValueType_literals_[1];
    static const value _xsd_CalscaleValueType_indexes_[1];
  };

  class CalscalePropType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // text
    //
    typedef ::icalendar_2_0::CalscaleValueType text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    // Constructors.
    //
    CalscalePropType (const text_type&);

    CalscalePropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    CalscalePropType (const CalscalePropType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual CalscalePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CalscalePropType&
    operator= (const CalscalePropType& x);

    virtual 
    ~CalscalePropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
  };

  class MethodPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    MethodPropType (const text_type&);

    MethodPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    MethodPropType (const MethodPropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual MethodPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    MethodPropType&
    operator= (const MethodPropType&) = default;
#endif

    virtual 
    ~MethodPropType ();
  };

  class ProdidPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    ProdidPropType (const text_type&);

    ProdidPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    ProdidPropType (const ProdidPropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual ProdidPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ProdidPropType&
    operator= (const ProdidPropType&) = default;
#endif

    virtual 
    ~ProdidPropType ();
  };

  class VersionPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    VersionPropType (const text_type&);

    VersionPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    VersionPropType (const VersionPropType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual VersionPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    VersionPropType&
    operator= (const VersionPropType&) = default;
#endif

    virtual 
    ~VersionPropType ();
  };

  class AttachPropType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // uri
    //
    typedef ::icalendar_2_0::UriType uri_type;
    typedef ::xsd::cxx::tree::optional< uri_type > uri_optional;
    typedef ::xsd::cxx::tree::traits< uri_type, char > uri_traits;

    const uri_optional&
    uri () const;

    uri_optional&
    uri ();

    void
    uri (const uri_type& x);

    void
    uri (const uri_optional& x);

    void
    uri (::std::unique_ptr< uri_type > p);

    // binary
    //
    typedef ::xml_schema::string binary_type;
    typedef ::xsd::cxx::tree::optional< binary_type > binary_optional;
    typedef ::xsd::cxx::tree::traits< binary_type, char > binary_traits;

    const binary_optional&
    binary () const;

    binary_optional&
    binary ();

    void
    binary (const binary_type& x);

    void
    binary (const binary_optional& x);

    void
    binary (::std::unique_ptr< binary_type > p);

    // Constructors.
    //
    AttachPropType ();

    AttachPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    AttachPropType (const AttachPropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual AttachPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    AttachPropType&
    operator= (const AttachPropType& x);

    virtual 
    ~AttachPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    uri_optional uri_;
    binary_optional binary_;
  };

  class CategoriesPropType: public ::icalendar_2_0::TextListPropertyType
  {
    public:
    // Constructors.
    //
    CategoriesPropType ();

    CategoriesPropType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    CategoriesPropType (const CategoriesPropType& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual CategoriesPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    CategoriesPropType&
    operator= (const CategoriesPropType&) = default;
#endif

    virtual 
    ~CategoriesPropType ();
  };

  class ClassPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    ClassPropType (const text_type&);

    ClassPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    ClassPropType (const ClassPropType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual ClassPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ClassPropType&
    operator= (const ClassPropType&) = default;
#endif

    virtual 
    ~ClassPropType ();
  };

  class CommentPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    CommentPropType (const text_type&);

    CommentPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    CommentPropType (const CommentPropType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual CommentPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    CommentPropType&
    operator= (const CommentPropType&) = default;
#endif

    virtual 
    ~CommentPropType ();
  };

  class DescriptionPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    DescriptionPropType (const text_type&);

    DescriptionPropType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    DescriptionPropType (const DescriptionPropType& x,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    virtual DescriptionPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DescriptionPropType&
    operator= (const DescriptionPropType&) = default;
#endif

    virtual 
    ~DescriptionPropType ();
  };

  class GeoPropType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // latitude
    //
    typedef ::xml_schema::float_ latitude_type;
    typedef ::xsd::cxx::tree::traits< latitude_type, char > latitude_traits;

    const latitude_type&
    latitude () const;

    latitude_type&
    latitude ();

    void
    latitude (const latitude_type& x);

    // longitude
    //
    typedef ::xml_schema::float_ longitude_type;
    typedef ::xsd::cxx::tree::traits< longitude_type, char > longitude_traits;

    const longitude_type&
    longitude () const;

    longitude_type&
    longitude ();

    void
    longitude (const longitude_type& x);

    // Constructors.
    //
    GeoPropType (const latitude_type&,
                 const longitude_type&);

    GeoPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    GeoPropType (const GeoPropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual GeoPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    GeoPropType&
    operator= (const GeoPropType& x);

    virtual 
    ~GeoPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< latitude_type > latitude_;
    ::xsd::cxx::tree::one< longitude_type > longitude_;
  };

  class LocationPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    LocationPropType (const text_type&);

    LocationPropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    LocationPropType (const LocationPropType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual LocationPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    LocationPropType&
    operator= (const LocationPropType&) = default;
#endif

    virtual 
    ~LocationPropType ();
  };

  class PercentCompletePropType: public ::icalendar_2_0::IntegerPropertyType
  {
    public:
    // Constructors.
    //
    PercentCompletePropType (const integer_type&);

    PercentCompletePropType (const ::xercesc::DOMElement& e,
                             ::xml_schema::flags f = 0,
                             ::xml_schema::container* c = 0);

    PercentCompletePropType (const PercentCompletePropType& x,
                             ::xml_schema::flags f = 0,
                             ::xml_schema::container* c = 0);

    virtual PercentCompletePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    PercentCompletePropType&
    operator= (const PercentCompletePropType&) = default;
#endif

    virtual 
    ~PercentCompletePropType ();
  };

  class PriorityPropType: public ::icalendar_2_0::IntegerPropertyType
  {
    public:
    // Constructors.
    //
    PriorityPropType (const integer_type&);

    PriorityPropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    PriorityPropType (const PriorityPropType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual PriorityPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    PriorityPropType&
    operator= (const PriorityPropType&) = default;
#endif

    virtual 
    ~PriorityPropType ();
  };

  class ResourcesPropType: public ::icalendar_2_0::TextListPropertyType
  {
    public:
    // Constructors.
    //
    ResourcesPropType ();

    ResourcesPropType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ResourcesPropType (const ResourcesPropType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual ResourcesPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ResourcesPropType&
    operator= (const ResourcesPropType&) = default;
#endif

    virtual 
    ~ResourcesPropType ();
  };

  class StatusPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    StatusPropType (const text_type&);

    StatusPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    StatusPropType (const StatusPropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual StatusPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    StatusPropType&
    operator= (const StatusPropType&) = default;
#endif

    virtual 
    ~StatusPropType ();
  };

  class SummaryPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    SummaryPropType (const text_type&);

    SummaryPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    SummaryPropType (const SummaryPropType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual SummaryPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    SummaryPropType&
    operator= (const SummaryPropType&) = default;
#endif

    virtual 
    ~SummaryPropType ();
  };

  class CompletedPropType: public ::icalendar_2_0::UtcDatetimePropertyType
  {
    public:
    // Constructors.
    //
    CompletedPropType ();

    CompletedPropType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    CompletedPropType (const CompletedPropType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual CompletedPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    CompletedPropType&
    operator= (const CompletedPropType&) = default;
#endif

    virtual 
    ~CompletedPropType ();
  };

  class DtendPropType: public ::icalendar_2_0::DateDatetimePropertyType
  {
    public:
    // Constructors.
    //
    DtendPropType ();

    DtendPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    DtendPropType (const DtendPropType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual DtendPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DtendPropType&
    operator= (const DtendPropType&) = default;
#endif

    virtual 
    ~DtendPropType ();
  };

  class DuePropType: public ::icalendar_2_0::DateDatetimePropertyType
  {
    public:
    // Constructors.
    //
    DuePropType ();

    DuePropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    DuePropType (const DuePropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual DuePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DuePropType&
    operator= (const DuePropType&) = default;
#endif

    virtual 
    ~DuePropType ();
  };

  class DtstartPropType: public ::icalendar_2_0::DateDatetimePropertyType
  {
    public:
    // Constructors.
    //
    DtstartPropType ();

    DtstartPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    DtstartPropType (const DtstartPropType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual DtstartPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DtstartPropType&
    operator= (const DtstartPropType&) = default;
#endif

    virtual 
    ~DtstartPropType ();
  };

  class DurationPropType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // duration
    //
    typedef ::icalendar_2_0::DurationValueType duration_type;
    typedef ::xsd::cxx::tree::traits< duration_type, char > duration_traits;

    const duration_type&
    duration () const;

    duration_type&
    duration ();

    void
    duration (const duration_type& x);

    void
    duration (::std::unique_ptr< duration_type > p);

    // Constructors.
    //
    DurationPropType (const duration_type&);

    DurationPropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    DurationPropType (const DurationPropType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual DurationPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DurationPropType&
    operator= (const DurationPropType& x);

    virtual 
    ~DurationPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< duration_type > duration_;
  };

  class FreebusyPropType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // period
    //
    typedef ::icalendar_2_0::PeriodType period_type;
    typedef ::xsd::cxx::tree::sequence< period_type > period_sequence;
    typedef period_sequence::iterator period_iterator;
    typedef period_sequence::const_iterator period_const_iterator;
    typedef ::xsd::cxx::tree::traits< period_type, char > period_traits;

    const period_sequence&
    period () const;

    period_sequence&
    period ();

    void
    period (const period_sequence& s);

    // Constructors.
    //
    FreebusyPropType ();

    FreebusyPropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    FreebusyPropType (const FreebusyPropType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual FreebusyPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    FreebusyPropType&
    operator= (const FreebusyPropType& x);

    virtual 
    ~FreebusyPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    period_sequence period_;
  };

  class TranspPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    TranspPropType (const text_type&);

    TranspPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    TranspPropType (const TranspPropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual TranspPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    TranspPropType&
    operator= (const TranspPropType&) = default;
#endif

    virtual 
    ~TranspPropType ();
  };

  class TzidPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    TzidPropType (const text_type&);

    TzidPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    TzidPropType (const TzidPropType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual TzidPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    TzidPropType&
    operator= (const TzidPropType&) = default;
#endif

    virtual 
    ~TzidPropType ();
  };

  class TznamePropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    TznamePropType (const text_type&);

    TznamePropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    TznamePropType (const TznamePropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual TznamePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    TznamePropType&
    operator= (const TznamePropType&) = default;
#endif

    virtual 
    ~TznamePropType ();
  };

  class TzoffsetfromPropType: public ::icalendar_2_0::UtcOffsetPropertyType
  {
    public:
    // Constructors.
    //
    TzoffsetfromPropType (const utc_offset_type&);

    TzoffsetfromPropType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    TzoffsetfromPropType (const TzoffsetfromPropType& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual TzoffsetfromPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    TzoffsetfromPropType&
    operator= (const TzoffsetfromPropType&) = default;
#endif

    virtual 
    ~TzoffsetfromPropType ();
  };

  class TzoffsettoPropType: public ::icalendar_2_0::UtcOffsetPropertyType
  {
    public:
    // Constructors.
    //
    TzoffsettoPropType (const utc_offset_type&);

    TzoffsettoPropType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    TzoffsettoPropType (const TzoffsettoPropType& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual TzoffsettoPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    TzoffsettoPropType&
    operator= (const TzoffsettoPropType&) = default;
#endif

    virtual 
    ~TzoffsettoPropType ();
  };

  class TzurlPropType: public ::icalendar_2_0::UriPropertyType
  {
    public:
    // Constructors.
    //
    TzurlPropType (const uri_type&);

    TzurlPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    TzurlPropType (const TzurlPropType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual TzurlPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    TzurlPropType&
    operator= (const TzurlPropType&) = default;
#endif

    virtual 
    ~TzurlPropType ();
  };

  class AttendeePropType: public ::icalendar_2_0::CalAddressPropertyType
  {
    public:
    // Constructors.
    //
    AttendeePropType (const cal_address_type&);

    AttendeePropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    AttendeePropType (const AttendeePropType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual AttendeePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    AttendeePropType&
    operator= (const AttendeePropType&) = default;
#endif

    virtual 
    ~AttendeePropType ();
  };

  class ContactPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    ContactPropType (const text_type&);

    ContactPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    ContactPropType (const ContactPropType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual ContactPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ContactPropType&
    operator= (const ContactPropType&) = default;
#endif

    virtual 
    ~ContactPropType ();
  };

  class OrganizerPropType: public ::icalendar_2_0::CalAddressPropertyType
  {
    public:
    // Constructors.
    //
    OrganizerPropType (const cal_address_type&);

    OrganizerPropType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    OrganizerPropType (const OrganizerPropType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual OrganizerPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    OrganizerPropType&
    operator= (const OrganizerPropType&) = default;
#endif

    virtual 
    ~OrganizerPropType ();
  };

  class RecurrenceIdPropType: public ::icalendar_2_0::DateDatetimePropertyType
  {
    public:
    // Constructors.
    //
    RecurrenceIdPropType ();

    RecurrenceIdPropType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    RecurrenceIdPropType (const RecurrenceIdPropType& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual RecurrenceIdPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    RecurrenceIdPropType&
    operator= (const RecurrenceIdPropType&) = default;
#endif

    virtual 
    ~RecurrenceIdPropType ();
  };

  class RelatedToPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    RelatedToPropType (const text_type&);

    RelatedToPropType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    RelatedToPropType (const RelatedToPropType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual RelatedToPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    RelatedToPropType&
    operator= (const RelatedToPropType&) = default;
#endif

    virtual 
    ~RelatedToPropType ();
  };

  class UrlPropType: public ::icalendar_2_0::UriPropertyType
  {
    public:
    // Constructors.
    //
    UrlPropType (const uri_type&);

    UrlPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    UrlPropType (const UrlPropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual UrlPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    UrlPropType&
    operator= (const UrlPropType&) = default;
#endif

    virtual 
    ~UrlPropType ();
  };

  class UidPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    UidPropType (const text_type&);

    UidPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    UidPropType (const UidPropType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual UidPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    UidPropType&
    operator= (const UidPropType&) = default;
#endif

    virtual 
    ~UidPropType ();
  };

  class ExdatePropType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // date-time
    //
    typedef ::icalendar_2_0::DateTimeType date_time_type;
    typedef ::xsd::cxx::tree::sequence< date_time_type > date_time_sequence;
    typedef date_time_sequence::iterator date_time_iterator;
    typedef date_time_sequence::const_iterator date_time_const_iterator;
    typedef ::xsd::cxx::tree::traits< date_time_type, char > date_time_traits;

    const date_time_sequence&
    date_time () const;

    date_time_sequence&
    date_time ();

    void
    date_time (const date_time_sequence& s);

    // date
    //
    typedef ::xml_schema::date date_type;
    typedef ::xsd::cxx::tree::sequence< date_type > date_sequence;
    typedef date_sequence::iterator date_iterator;
    typedef date_sequence::const_iterator date_const_iterator;
    typedef ::xsd::cxx::tree::traits< date_type, char > date_traits;

    const date_sequence&
    date () const;

    date_sequence&
    date ();

    void
    date (const date_sequence& s);

    // Constructors.
    //
    ExdatePropType ();

    ExdatePropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    ExdatePropType (const ExdatePropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual ExdatePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ExdatePropType&
    operator= (const ExdatePropType& x);

    virtual 
    ~ExdatePropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    date_time_sequence date_time_;
    date_sequence date_;
  };

  class RdatePropType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // date
    //
    typedef ::xml_schema::date date_type;
    typedef ::xsd::cxx::tree::sequence< date_type > date_sequence;
    typedef date_sequence::iterator date_iterator;
    typedef date_sequence::const_iterator date_const_iterator;
    typedef ::xsd::cxx::tree::traits< date_type, char > date_traits;

    const date_sequence&
    date () const;

    date_sequence&
    date ();

    void
    date (const date_sequence& s);

    // date-time
    //
    typedef ::icalendar_2_0::DateTimeType date_time_type;
    typedef ::xsd::cxx::tree::sequence< date_time_type > date_time_sequence;
    typedef date_time_sequence::iterator date_time_iterator;
    typedef date_time_sequence::const_iterator date_time_const_iterator;
    typedef ::xsd::cxx::tree::traits< date_time_type, char > date_time_traits;

    const date_time_sequence&
    date_time () const;

    date_time_sequence&
    date_time ();

    void
    date_time (const date_time_sequence& s);

    // period
    //
    typedef ::icalendar_2_0::PeriodType period_type;
    typedef ::xsd::cxx::tree::sequence< period_type > period_sequence;
    typedef period_sequence::iterator period_iterator;
    typedef period_sequence::const_iterator period_const_iterator;
    typedef ::xsd::cxx::tree::traits< period_type, char > period_traits;

    const period_sequence&
    period () const;

    period_sequence&
    period ();

    void
    period (const period_sequence& s);

    // Constructors.
    //
    RdatePropType ();

    RdatePropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    RdatePropType (const RdatePropType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual RdatePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    RdatePropType&
    operator= (const RdatePropType& x);

    virtual 
    ~RdatePropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    date_sequence date_;
    date_time_sequence date_time_;
    period_sequence period_;
  };

  class RrulePropType: public ::icalendar_2_0::RecurPropertyType
  {
    public:
    // Constructors.
    //
    RrulePropType (const recur_type&);

    RrulePropType (::std::unique_ptr< recur_type >);

    RrulePropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    RrulePropType (const RrulePropType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual RrulePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    RrulePropType&
    operator= (const RrulePropType&) = default;
#endif

    virtual 
    ~RrulePropType ();
  };

  class ExrulePropType: public ::icalendar_2_0::RecurPropertyType
  {
    public:
    // Constructors.
    //
    ExrulePropType (const recur_type&);

    ExrulePropType (::std::unique_ptr< recur_type >);

    ExrulePropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    ExrulePropType (const ExrulePropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual ExrulePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ExrulePropType&
    operator= (const ExrulePropType&) = default;
#endif

    virtual 
    ~ExrulePropType ();
  };

  class ActionPropType: public ::icalendar_2_0::TextPropertyType
  {
    public:
    // Constructors.
    //
    ActionPropType (const text_type&);

    ActionPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    ActionPropType (const ActionPropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual ActionPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ActionPropType&
    operator= (const ActionPropType&) = default;
#endif

    virtual 
    ~ActionPropType ();
  };

  class RepeatPropType: public ::icalendar_2_0::IntegerPropertyType
  {
    public:
    // Constructors.
    //
    RepeatPropType (const integer_type&);

    RepeatPropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    RepeatPropType (const RepeatPropType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual RepeatPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    RepeatPropType&
    operator= (const RepeatPropType&) = default;
#endif

    virtual 
    ~RepeatPropType ();
  };

  class TriggerPropType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // duration
    //
    typedef ::icalendar_2_0::DurationValueType duration_type;
    typedef ::xsd::cxx::tree::optional< duration_type > duration_optional;
    typedef ::xsd::cxx::tree::traits< duration_type, char > duration_traits;

    const duration_optional&
    duration () const;

    duration_optional&
    duration ();

    void
    duration (const duration_type& x);

    void
    duration (const duration_optional& x);

    void
    duration (::std::unique_ptr< duration_type > p);

    // date-time
    //
    typedef ::icalendar_2_0::DateTimeType date_time_type;
    typedef ::xsd::cxx::tree::optional< date_time_type > date_time_optional;
    typedef ::xsd::cxx::tree::traits< date_time_type, char > date_time_traits;

    const date_time_optional&
    date_time () const;

    date_time_optional&
    date_time ();

    void
    date_time (const date_time_type& x);

    void
    date_time (const date_time_optional& x);

    void
    date_time (::std::unique_ptr< date_time_type > p);

    // Constructors.
    //
    TriggerPropType ();

    TriggerPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    TriggerPropType (const TriggerPropType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual TriggerPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TriggerPropType&
    operator= (const TriggerPropType& x);

    virtual 
    ~TriggerPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    duration_optional duration_;
    date_time_optional date_time_;
  };

  class CreatedPropType: public ::icalendar_2_0::UtcDatetimePropertyType
  {
    public:
    // Constructors.
    //
    CreatedPropType ();

    CreatedPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    CreatedPropType (const CreatedPropType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual CreatedPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    CreatedPropType&
    operator= (const CreatedPropType&) = default;
#endif

    virtual 
    ~CreatedPropType ();
  };

  class DtstampPropType: public ::icalendar_2_0::UtcDatetimePropertyType
  {
    public:
    // Constructors.
    //
    DtstampPropType ();

    DtstampPropType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    DtstampPropType (const DtstampPropType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual DtstampPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DtstampPropType&
    operator= (const DtstampPropType&) = default;
#endif

    virtual 
    ~DtstampPropType ();
  };

  class LastModifiedPropType: public ::icalendar_2_0::UtcDatetimePropertyType
  {
    public:
    // Constructors.
    //
    LastModifiedPropType ();

    LastModifiedPropType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    LastModifiedPropType (const LastModifiedPropType& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual LastModifiedPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    LastModifiedPropType&
    operator= (const LastModifiedPropType&) = default;
#endif

    virtual 
    ~LastModifiedPropType ();
  };

  class SequencePropType: public ::icalendar_2_0::IntegerPropertyType
  {
    public:
    // Constructors.
    //
    SequencePropType (const integer_type&);

    SequencePropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    SequencePropType (const SequencePropType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual SequencePropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    SequencePropType&
    operator= (const SequencePropType&) = default;
#endif

    virtual 
    ~SequencePropType ();
  };

  class RequestStatusPropType: public ::icalendar_2_0::BasePropertyType
  {
    public:
    // code
    //
    typedef ::xml_schema::string code_type;
    typedef ::xsd::cxx::tree::traits< code_type, char > code_traits;

    const code_type&
    code () const;

    code_type&
    code ();

    void
    code (const code_type& x);

    void
    code (::std::unique_ptr< code_type > p);

    // description
    //
    typedef ::xml_schema::string description_type;
    typedef ::xsd::cxx::tree::traits< description_type, char > description_traits;

    const description_type&
    description () const;

    description_type&
    description ();

    void
    description (const description_type& x);

    void
    description (::std::unique_ptr< description_type > p);

    // extdata
    //
    typedef ::xml_schema::string extdata_type;
    typedef ::xsd::cxx::tree::traits< extdata_type, char > extdata_traits;

    const extdata_type&
    extdata () const;

    extdata_type&
    extdata ();

    void
    extdata (const extdata_type& x);

    void
    extdata (::std::unique_ptr< extdata_type > p);

    // Constructors.
    //
    RequestStatusPropType (const code_type&,
                           const description_type&,
                           const extdata_type&);

    RequestStatusPropType (const ::xercesc::DOMElement& e,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    RequestStatusPropType (const RequestStatusPropType& x,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    virtual RequestStatusPropType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    RequestStatusPropType&
    operator= (const RequestStatusPropType& x);

    virtual 
    ~RequestStatusPropType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< code_type > code_;
    ::xsd::cxx::tree::one< description_type > description_;
    ::xsd::cxx::tree::one< extdata_type > extdata_;
  };
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace icalendar_2_0
{
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace icalendar_2_0
{
  void
  operator<< (::xercesc::DOMElement&, const BasePropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const ArrayOfProperties&);

  void
  operator<< (::xercesc::DOMElement&, const TextPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const TextListPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const CalAddressPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const IntegerPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const UriPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const UtcOffsetPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const DatetimePropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const UtcDatetimePropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const DateDatetimePropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const RecurPropertyType&);

  void
  operator<< (::xercesc::DOMElement&, const CalscaleValueType&);

  void
  operator<< (::xercesc::DOMAttr&, const CalscaleValueType&);

  void
  operator<< (::xml_schema::list_stream&,
              const CalscaleValueType&);

  void
  operator<< (::xercesc::DOMElement&, const CalscalePropType&);

  void
  operator<< (::xercesc::DOMElement&, const MethodPropType&);

  void
  operator<< (::xercesc::DOMElement&, const ProdidPropType&);

  void
  operator<< (::xercesc::DOMElement&, const VersionPropType&);

  void
  operator<< (::xercesc::DOMElement&, const AttachPropType&);

  void
  operator<< (::xercesc::DOMElement&, const CategoriesPropType&);

  void
  operator<< (::xercesc::DOMElement&, const ClassPropType&);

  void
  operator<< (::xercesc::DOMElement&, const CommentPropType&);

  void
  operator<< (::xercesc::DOMElement&, const DescriptionPropType&);

  void
  operator<< (::xercesc::DOMElement&, const GeoPropType&);

  void
  operator<< (::xercesc::DOMElement&, const LocationPropType&);

  void
  operator<< (::xercesc::DOMElement&, const PercentCompletePropType&);

  void
  operator<< (::xercesc::DOMElement&, const PriorityPropType&);

  void
  operator<< (::xercesc::DOMElement&, const ResourcesPropType&);

  void
  operator<< (::xercesc::DOMElement&, const StatusPropType&);

  void
  operator<< (::xercesc::DOMElement&, const SummaryPropType&);

  void
  operator<< (::xercesc::DOMElement&, const CompletedPropType&);

  void
  operator<< (::xercesc::DOMElement&, const DtendPropType&);

  void
  operator<< (::xercesc::DOMElement&, const DuePropType&);

  void
  operator<< (::xercesc::DOMElement&, const DtstartPropType&);

  void
  operator<< (::xercesc::DOMElement&, const DurationPropType&);

  void
  operator<< (::xercesc::DOMElement&, const FreebusyPropType&);

  void
  operator<< (::xercesc::DOMElement&, const TranspPropType&);

  void
  operator<< (::xercesc::DOMElement&, const TzidPropType&);

  void
  operator<< (::xercesc::DOMElement&, const TznamePropType&);

  void
  operator<< (::xercesc::DOMElement&, const TzoffsetfromPropType&);

  void
  operator<< (::xercesc::DOMElement&, const TzoffsettoPropType&);

  void
  operator<< (::xercesc::DOMElement&, const TzurlPropType&);

  void
  operator<< (::xercesc::DOMElement&, const AttendeePropType&);

  void
  operator<< (::xercesc::DOMElement&, const ContactPropType&);

  void
  operator<< (::xercesc::DOMElement&, const OrganizerPropType&);

  void
  operator<< (::xercesc::DOMElement&, const RecurrenceIdPropType&);

  void
  operator<< (::xercesc::DOMElement&, const RelatedToPropType&);

  void
  operator<< (::xercesc::DOMElement&, const UrlPropType&);

  void
  operator<< (::xercesc::DOMElement&, const UidPropType&);

  void
  operator<< (::xercesc::DOMElement&, const ExdatePropType&);

  void
  operator<< (::xercesc::DOMElement&, const RdatePropType&);

  void
  operator<< (::xercesc::DOMElement&, const RrulePropType&);

  void
  operator<< (::xercesc::DOMElement&, const ExrulePropType&);

  void
  operator<< (::xercesc::DOMElement&, const ActionPropType&);

  void
  operator<< (::xercesc::DOMElement&, const RepeatPropType&);

  void
  operator<< (::xercesc::DOMElement&, const TriggerPropType&);

  void
  operator<< (::xercesc::DOMElement&, const CreatedPropType&);

  void
  operator<< (::xercesc::DOMElement&, const DtstampPropType&);

  void
  operator<< (::xercesc::DOMElement&, const LastModifiedPropType&);

  void
  operator<< (::xercesc::DOMElement&, const SequencePropType&);

  void
  operator<< (::xercesc::DOMElement&, const RequestStatusPropType&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_I_CALENDAR_PROPS_HXX
