/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: SystemZ.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                FeatureBitset &MissingFeatures,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0) {
    FeatureBitset MissingFeatures;
    return MatchInstructionImpl(Operands, Inst, ErrorInfo, MissingFeatures,
                                matchingInlineAsm, VariantID);
  }

  ParseStatus MatchOperandParserImpl(
    OperandVector &Operands,
    StringRef Mnemonic,
    bool ParseForAllFeatures = false);
  ParseStatus tryCustomParseOperand(
    OperandVector &Operands,
    unsigned MCK);

#endif // GET_ASSEMBLER_HEADER


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_FeatureSoftFloatBit = 37,
  Feature_FeatureBackChainBit = 1,
  Feature_FeatureUnalignedSymbolsBit = 40,
  Feature_FeatureDistinctOpsBit = 6,
  Feature_FeatureFastSerializationBit = 11,
  Feature_FeatureFPExtensionBit = 10,
  Feature_FeatureHighWordBit = 13,
  Feature_FeatureInterlockedAccess1Bit = 15,
  Feature_FeatureLoadStoreOnCondBit = 18,
  Feature_FeaturePopulationCountBit = 32,
  Feature_FeatureMessageSecurityAssist3Bit = 20,
  Feature_FeatureMessageSecurityAssist4Bit = 21,
  Feature_FeatureResetReferenceBitsMultipleBit = 36,
  Feature_FeatureExecutionHintBit = 9,
  Feature_FeatureLoadAndTrapBit = 16,
  Feature_FeatureMiscellaneousExtensionsBit = 27,
  Feature_FeatureProcessorAssistBit = 34,
  Feature_FeatureTransactionalExecutionBit = 39,
  Feature_FeatureDFPZonedConversionBit = 4,
  Feature_FeatureEnhancedDAT2Bit = 7,
  Feature_FeatureLoadAndZeroRightmostByteBit = 17,
  Feature_FeatureLoadStoreOnCond2Bit = 19,
  Feature_FeatureMessageSecurityAssist5Bit = 22,
  Feature_FeatureDFPPackedConversionBit = 3,
  Feature_FeatureVectorBit = 41,
  Feature_FeatureMiscellaneousExtensions2Bit = 28,
  Feature_FeatureGuardedStorageBit = 12,
  Feature_FeatureMessageSecurityAssist7Bit = 23,
  Feature_FeatureMessageSecurityAssist8Bit = 24,
  Feature_FeatureVectorEnhancements1Bit = 42,
  Feature_FeatureVectorPackedDecimalBit = 45,
  Feature_FeatureInsertReferenceBitsMultipleBit = 14,
  Feature_FeatureTestPendingExternalInterruptionBit = 38,
  Feature_FeatureMiscellaneousExtensions3Bit = 29,
  Feature_FeatureMessageSecurityAssist9Bit = 25,
  Feature_FeatureVectorEnhancements2Bit = 43,
  Feature_FeatureVectorPackedDecimalEnhancementBit = 46,
  Feature_FeatureEnhancedSortBit = 8,
  Feature_FeatureDeflateConversionBit = 5,
  Feature_FeatureVectorPackedDecimalEnhancement2Bit = 47,
  Feature_FeatureNNPAssistBit = 31,
  Feature_FeatureBEAREnhancementBit = 0,
  Feature_FeatureResetDATProtectionBit = 35,
  Feature_FeatureProcessorActivityInstrumentationBit = 33,
  Feature_FeatureMiscellaneousExtensions4Bit = 30,
  Feature_FeatureVectorEnhancements3Bit = 44,
  Feature_FeatureVectorPackedDecimalEnhancement3Bit = 48,
  Feature_FeatureMessageSecurityAssist12Bit = 26,
  Feature_FeatureConcurrentFunctionsBit = 2,
};

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_FeatureSoftFloatBit: return "soft-float";
  case Feature_FeatureBackChainBit: return "backchain";
  case Feature_FeatureUnalignedSymbolsBit: return "unaligned-symbols";
  case Feature_FeatureDistinctOpsBit: return "distinct-ops";
  case Feature_FeatureFastSerializationBit: return "fast-serialization";
  case Feature_FeatureFPExtensionBit: return "fp-extension";
  case Feature_FeatureHighWordBit: return "high-word";
  case Feature_FeatureInterlockedAccess1Bit: return "interlocked-access1";
  case Feature_FeatureLoadStoreOnCondBit: return "load-store-on-cond";
  case Feature_FeaturePopulationCountBit: return "population-count";
  case Feature_FeatureMessageSecurityAssist3Bit: return "message-security-assist-extension3";
  case Feature_FeatureMessageSecurityAssist4Bit: return "message-security-assist-extension4";
  case Feature_FeatureResetReferenceBitsMultipleBit: return "reset-reference-bits-multiple";
  case Feature_FeatureExecutionHintBit: return "execution-hint";
  case Feature_FeatureLoadAndTrapBit: return "load-and-trap";
  case Feature_FeatureMiscellaneousExtensionsBit: return "miscellaneous-extensions";
  case Feature_FeatureProcessorAssistBit: return "processor-assist";
  case Feature_FeatureTransactionalExecutionBit: return "transactional-execution";
  case Feature_FeatureDFPZonedConversionBit: return "dfp-zoned-conversion";
  case Feature_FeatureEnhancedDAT2Bit: return "enhanced-dat-2";
  case Feature_FeatureLoadAndZeroRightmostByteBit: return "load-and-zero-rightmost-byte";
  case Feature_FeatureLoadStoreOnCond2Bit: return "load-store-on-cond-2";
  case Feature_FeatureMessageSecurityAssist5Bit: return "message-security-assist-extension5";
  case Feature_FeatureDFPPackedConversionBit: return "dfp-packed-conversion";
  case Feature_FeatureVectorBit: return "vector";
  case Feature_FeatureMiscellaneousExtensions2Bit: return "miscellaneous-extensions-2";
  case Feature_FeatureGuardedStorageBit: return "guarded-storage";
  case Feature_FeatureMessageSecurityAssist7Bit: return "message-security-assist-extension7";
  case Feature_FeatureMessageSecurityAssist8Bit: return "message-security-assist-extension8";
  case Feature_FeatureVectorEnhancements1Bit: return "vector-enhancements-1";
  case Feature_FeatureVectorPackedDecimalBit: return "vector-packed-decimal";
  case Feature_FeatureInsertReferenceBitsMultipleBit: return "insert-reference-bits-multiple";
  case Feature_FeatureTestPendingExternalInterruptionBit: return "test-pending-external-interruption";
  case Feature_FeatureMiscellaneousExtensions3Bit: return "miscellaneous-extensions-3";
  case Feature_FeatureMessageSecurityAssist9Bit: return "message-security-assist-extension9";
  case Feature_FeatureVectorEnhancements2Bit: return "vector-enhancements-2";
  case Feature_FeatureVectorPackedDecimalEnhancementBit: return "vector-packed-decimal-enhancement";
  case Feature_FeatureEnhancedSortBit: return "enhanced-sort";
  case Feature_FeatureDeflateConversionBit: return "deflate-conversion";
  case Feature_FeatureVectorPackedDecimalEnhancement2Bit: return "vector-packed-decimal-enhancement-2";
  case Feature_FeatureNNPAssistBit: return "nnp-assist";
  case Feature_FeatureBEAREnhancementBit: return "bear-enhancement";
  case Feature_FeatureResetDATProtectionBit: return "reset-dat-protection";
  case Feature_FeatureProcessorActivityInstrumentationBit: return "processor-activity-instrumentation";
  case Feature_FeatureMiscellaneousExtensions4Bit: return "miscellaneous-extensions-4";
  case Feature_FeatureVectorEnhancements3Bit: return "vector-enhancements-3";
  case Feature_FeatureVectorPackedDecimalEnhancement3Bit: return "vector-packed-decimal-enhancement-3";
  case Feature_FeatureMessageSecurityAssist12Bit: return "message-security-assist-extension12";
  case Feature_FeatureConcurrentFunctionsBit: return "concurrent-functions";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (VariantID) {
  case 0:
      switch (Mnemonic.size()) {
      default: break;
      case 4:	 // 11 strings to match.
        if (memcmp(Mnemonic.data()+0, "br", 2) != 0)
          break;
        switch (Mnemonic[2]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jge";	 // "brel"
          return;
        case 'h':	 // 2 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'e':	 // 1 string to match.
            Mnemonic = "jhe";	 // "brhe"
            return;
          case 'l':	 // 1 string to match.
            Mnemonic = "jgh";	 // "brhl"
            return;
          }
          break;
        case 'l':	 // 3 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'e':	 // 1 string to match.
            Mnemonic = "jle";	 // "brle"
            return;
          case 'h':	 // 1 string to match.
            Mnemonic = "jlh";	 // "brlh"
            return;
          case 'l':	 // 1 string to match.
            Mnemonic = "jgl";	 // "brll"
            return;
          }
          break;
        case 'm':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jgm";	 // "brml"
          return;
        case 'o':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jgo";	 // "brol"
          return;
        case 'p':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jgp";	 // "brpl"
          return;
        case 'u':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jg";	 // "brul"
          return;
        case 'z':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jgz";	 // "brzl"
          return;
        }
        break;
      case 5:	 // 13 strings to match.
        if (memcmp(Mnemonic.data()+0, "br", 2) != 0)
          break;
        switch (Mnemonic[2]) {
        default: break;
        case 'h':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "el", 2) != 0)
            break;
          Mnemonic = "jghe";	 // "brhel"
          return;
        case 'l':	 // 2 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'e':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgle";	 // "brlel"
            return;
          case 'h':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jglh";	 // "brlhl"
            return;
          }
          break;
        case 'n':	 // 10 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'e':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgne";	 // "brnel"
            return;
          case 'h':	 // 2 strings to match.
            switch (Mnemonic[4]) {
            default: break;
            case 'e':	 // 1 string to match.
              Mnemonic = "jnhe";	 // "brnhe"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "jgnh";	 // "brnhl"
              return;
            }
            break;
          case 'l':	 // 3 strings to match.
            switch (Mnemonic[4]) {
            default: break;
            case 'e':	 // 1 string to match.
              Mnemonic = "jnle";	 // "brnle"
              return;
            case 'h':	 // 1 string to match.
              Mnemonic = "jnlh";	 // "brnlh"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "jgnl";	 // "brnll"
              return;
            }
            break;
          case 'm':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgnm";	 // "brnml"
            return;
          case 'o':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgno";	 // "brnol"
            return;
          case 'p':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgnp";	 // "brnpl"
            return;
          case 'z':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgnz";	 // "brnzl"
            return;
          }
          break;
        }
        break;
      case 6:	 // 3 strings to match.
        if (memcmp(Mnemonic.data()+0, "brn", 3) != 0)
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'h':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+4, "el", 2) != 0)
            break;
          Mnemonic = "jgnhe";	 // "brnhel"
          return;
        case 'l':	 // 2 strings to match.
          switch (Mnemonic[4]) {
          default: break;
          case 'e':	 // 1 string to match.
            if (Mnemonic[5] != 'l')
              break;
            Mnemonic = "jgnle";	 // "brnlel"
            return;
          case 'h':	 // 1 string to match.
            if (Mnemonic[5] != 'l')
              break;
            Mnemonic = "jgnlh";	 // "brnlhl"
            return;
          }
          break;
        }
        break;
      }
    break;
  case 1:
      switch (Mnemonic.size()) {
      default: break;
      case 4:	 // 8 strings to match.
        if (memcmp(Mnemonic.data()+0, "br", 2) != 0)
          break;
        switch (Mnemonic[2]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jle";	 // "brel"
          return;
        case 'h':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlh";	 // "brhl"
          return;
        case 'l':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jll";	 // "brll"
          return;
        case 'm':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlm";	 // "brml"
          return;
        case 'o':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlo";	 // "brol"
          return;
        case 'p':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlp";	 // "brpl"
          return;
        case 'u':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlu";	 // "brul"
          return;
        case 'z':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlz";	 // "brzl"
          return;
        }
        break;
      case 5:	 // 7 strings to match.
        if (memcmp(Mnemonic.data()+0, "brn", 3) != 0)
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlne";	 // "brnel"
          return;
        case 'h':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlnh";	 // "brnhl"
          return;
        case 'l':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlnl";	 // "brnll"
          return;
        case 'm':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlnm";	 // "brnml"
          return;
        case 'o':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlno";	 // "brnol"
          return;
        case 'p':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlnp";	 // "brnpl"
          return;
        case 'z':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlnz";	 // "brnzl"
          return;
        }
        break;
      }
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 2:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "jc", 2) != 0)
      break;
    Mnemonic = "brc";	 // "jc"
    return;
  case 3:	 // 11 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'b':	 // 8 strings to match.
      if (Mnemonic[1] != 'r')
        break;
      switch (Mnemonic[2]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "je";	 // "bre"
        return;
      case 'h':	 // 1 string to match.
        Mnemonic = "jh";	 // "brh"
        return;
      case 'l':	 // 1 string to match.
        Mnemonic = "jl";	 // "brl"
        return;
      case 'm':	 // 1 string to match.
        Mnemonic = "jm";	 // "brm"
        return;
      case 'o':	 // 1 string to match.
        Mnemonic = "jo";	 // "bro"
        return;
      case 'p':	 // 1 string to match.
        Mnemonic = "jp";	 // "brp"
        return;
      case 'u':	 // 1 string to match.
        Mnemonic = "j";	 // "bru"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "jz";	 // "brz"
        return;
      }
      break;
    case 'j':	 // 3 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Mnemonic[2] != 's')
          break;
        Mnemonic = "bras";	 // "jas"
        return;
      case 'c':	 // 1 string to match.
        if (Mnemonic[2] != 't')
          break;
        Mnemonic = "brct";	 // "jct"
        return;
      case 'x':	 // 1 string to match.
        if (Mnemonic[2] != 'h')
          break;
        Mnemonic = "brxh";	 // "jxh"
        return;
      }
      break;
    }
    break;
  case 4:	 // 12 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'b':	 // 7 strings to match.
      if (memcmp(Mnemonic.data()+1, "rn", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "jne";	 // "brne"
        return;
      case 'h':	 // 1 string to match.
        Mnemonic = "jnh";	 // "brnh"
        return;
      case 'l':	 // 1 string to match.
        Mnemonic = "jnl";	 // "brnl"
        return;
      case 'm':	 // 1 string to match.
        Mnemonic = "jnm";	 // "brnm"
        return;
      case 'o':	 // 1 string to match.
        Mnemonic = "jno";	 // "brno"
        return;
      case 'p':	 // 1 string to match.
        Mnemonic = "jnp";	 // "brnp"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "jnz";	 // "brnz"
        return;
      }
      break;
    case 'j':	 // 5 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "sl", 2) != 0)
          break;
        Mnemonic = "brasl";	 // "jasl"
        return;
      case 'c':	 // 2 strings to match.
        if (Mnemonic[2] != 't')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'g':	 // 1 string to match.
          Mnemonic = "brctg";	 // "jctg"
          return;
        case 'h':	 // 1 string to match.
          Mnemonic = "brcth";	 // "jcth"
          return;
        }
        break;
      case 'x':	 // 2 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'h':	 // 1 string to match.
          if (Mnemonic[3] != 'g')
            break;
          Mnemonic = "brxhg";	 // "jxhg"
          return;
        case 'l':	 // 1 string to match.
          if (Mnemonic[3] != 'e')
            break;
          Mnemonic = "brxle";	 // "jxle"
          return;
        }
        break;
      }
      break;
    }
    break;
  case 5:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "jxleg", 5) != 0)
      break;
    Mnemonic = "brxlg";	 // "jxleg"
    return;
  }
}

enum {
  Tie0_1_1,
  Tie1_1_1,
  Tie2_1_1,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie1_1_1 */ { 1, 1, 1 },
  /* Tie2_1_1 */ { 2, 1, 1 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_95_addRegOperands,
  CVT_95_addBDXAddrOperands,
  CVT_95_addImmOperands,
  CVT_95_addBDAddrOperands,
  CVT_95_addBDLAddrOperands,
  CVT_95_addImmTLSOperands,
  CVT_95_addLXAAddrOperands,
  CVT_95_addBDRAddrOperands,
  CVT_imm_95_0,
  CVT_95_addBDVAddrOperands,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__FP641_0__Tie0_1_1__FP641_1,
  Convert__FP641_0__FP641_1__FP641_2,
  Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3,
  Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__FP321_0__Tie0_1_1__FP321_1,
  Convert__GR321_0__Tie0_1_1__S32Imm1_1,
  Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1,
  Convert__GR641_0__Tie0_1_1__S32Imm1_1,
  Convert__GR641_0__Tie0_1_1__GR321_1,
  Convert__GR641_0__Tie0_1_1__S16Imm1_1,
  Convert__GR641_0__GR641_1__S16Imm1_2,
  Convert__GR641_0__Tie0_1_1__GR641_1,
  Convert__GR641_0__GR641_1__GR641_2,
  Convert__BDAddr64Disp202_0__S8Imm1_1,
  Convert__GRH321_0__GRH321_1__GRH321_2,
  Convert__GRH321_0__GRH321_1__GR321_2,
  Convert__GR321_0__Tie0_1_1__S16Imm1_1,
  Convert__GR321_0__GR321_1__S16Imm1_2,
  Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1,
  Convert__GRH321_0__Tie0_1_1__S32Imm1_1,
  Convert__GR321_0__Tie0_1_1__GR321_1,
  Convert__GR321_0__Tie0_1_1__U32Imm1_1,
  Convert__GR641_0__Tie0_1_1__U32Imm1_1,
  Convert__GR321_0__GR321_1__GR321_2,
  Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1,
  Convert__FP1281_0__Tie0_1_1__FP1281_1,
  Convert__FP1281_0__FP1281_1__FP1281_2,
  Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3,
  Convert__BDXAddr64Disp123_0,
  Convert__GR641_0__GR641_1,
  Convert__GR641_0__BDXAddr64Disp123_1,
  Convert__GR641_0__ADDR641_1,
  Convert__U4Imm1_0__BDXAddr64Disp123_1,
  Convert__U4Imm1_0__GR641_1,
  Convert__GR321_0__Tie0_1_1__GR641_1,
  Convert__ADDR641_0,
  Convert__BDXAddr64Disp203_0,
  Convert__U4Imm1_0__BDXAddr64Disp203_1,
  Convert__U4Imm1_0__PCRel161_1__BDAddr64Disp122_2,
  Convert__U4Imm1_0__PCRel121_1__PCRel241_2,
  Convert__GR641_0__PCRelTLS162_1,
  Convert__GR641_0__PCRelTLS322_1,
  Convert__U4Imm1_0__PCRel161_1,
  Convert__U4Imm1_0__PCRel321_1,
  Convert__GR321_0__Tie0_1_1__PCRel161_1,
  Convert__GR641_0__Tie0_1_1__PCRel161_1,
  Convert__GRH321_0__Tie0_1_1__PCRel321_1,
  Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2,
  Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2,
  Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2,
  Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2,
  Convert__GR321_0__BDXAddr64Disp123_1,
  Convert__GR321_0__BDAddr64Disp122_1__BDAddr64Disp122_2,
  Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2,
  Convert__FP641_0__BDXAddr64Disp123_1,
  Convert__FP641_0__FP641_1,
  Convert__FP641_0__GR321_1,
  Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3,
  Convert__FP641_0__GR641_1,
  Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3,
  Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2,
  Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp122_2,
  Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2,
  Convert__FP321_0__BDXAddr64Disp123_1,
  Convert__FP321_0__FP321_1,
  Convert__FP321_0__GR321_1,
  Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3,
  Convert__FP321_0__GR641_1,
  Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3,
  Convert__FP1281_0__FP1281_1,
  Convert__BDAddr64Disp122_0,
  Convert__GR321_0__U4Imm1_1__FP641_2,
  Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3,
  Convert__GR321_0__U4Imm1_1__FP321_2,
  Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3,
  Convert__GR321_0__S32Imm1_1,
  Convert__GR321_0__U4Imm1_1__FP1281_2,
  Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3,
  Convert__GR641_0__BDXAddr64Disp203_1,
  Convert__GR641_0__U4Imm1_1__FP641_2,
  Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3,
  Convert__GR641_0__U4Imm1_1__FP321_2,
  Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3,
  Convert__GR641_0__S32Imm1_1,
  Convert__GR641_0__GR321_1,
  Convert__GR641_0__PCRel321_1,
  Convert__GR641_0__S16Imm1_1,
  Convert__BDAddr64Disp122_0__S16Imm1_1,
  Convert__GR641_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2,
  Convert__GR641_0__S8Imm1_1__U4Imm1_2__PCRel161_3,
  Convert__GR641_0__S8Imm1_1__PCRel161_2,
  Convert__GR641_0__S16Imm1_1__U4Imm1_2,
  Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR641_0__GR641_1__BDAddr64Disp122_2,
  Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3,
  Convert__GR641_0__GR641_1__PCRel161_2,
  Convert__GR641_0__GR641_1__U4Imm1_2,
  Convert__GR641_0__U4Imm1_1__FP1281_2,
  Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3,
  Convert__GRH321_0__BDXAddr64Disp203_1,
  Convert__GRH321_0__GRH321_1,
  Convert__GR321_0__S16Imm1_1,
  Convert__GRH321_0__GR321_1,
  Convert__GR321_0__PCRel321_1,
  Convert__GR321_0__BDXAddr64Disp203_1,
  Convert__GR321_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2,
  Convert__GRH321_0__S32Imm1_1,
  Convert__GR321_0__S8Imm1_1__U4Imm1_2__PCRel161_3,
  Convert__GR321_0__S8Imm1_1__PCRel161_2,
  Convert__GR321_0__S16Imm1_1__U4Imm1_2,
  Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1,
  Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1,
  Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1,
  Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2,
  Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2,
  Convert__BDAddr64Disp122_0__U16Imm1_1,
  Convert__GR321_0__U32Imm1_1,
  Convert__GR321_0__U16Imm1_1__U4Imm1_2,
  Convert__GR321_0__U16Imm1_1,
  Convert__GR641_0__U32Imm1_1,
  Convert__GR641_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2,
  Convert__GR641_0__U8Imm1_1__U4Imm1_2__PCRel161_3,
  Convert__GR641_0__U8Imm1_1__PCRel161_2,
  Convert__GR641_0__U16Imm1_1__U4Imm1_2,
  Convert__GR641_0__U16Imm1_1,
  Convert__GR641_0__BDAddr64Disp202_2__U4Imm1_1,
  Convert__GR641_0__BDAddr64Disp202_1,
  Convert__BDAddr64Disp122_0__U8Imm1_1,
  Convert__GR321_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2,
  Convert__GRH321_0__U32Imm1_1,
  Convert__GR321_0__U8Imm1_1__U4Imm1_2__PCRel161_3,
  Convert__GR321_0__U8Imm1_1__PCRel161_2,
  Convert__BDAddr64Disp202_0__U8Imm1_1,
  Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2,
  Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2,
  Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2,
  Convert__GR321_0__GR321_1,
  Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR321_0__GR321_1__BDAddr64Disp122_2,
  Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3,
  Convert__GR321_0__GR321_1__PCRel161_2,
  Convert__GR321_0__GR321_1__U4Imm1_2,
  Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1,
  Convert__GR321_0__BDAddr64Disp202_2__U4Imm1_1,
  Convert__GR321_0__BDAddr64Disp202_1,
  Convert__FP641_0__FP641_2__FP641_1,
  Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2,
  Convert__AR321_0__AR321_1,
  Convert__GR1281_0__GR1281_2__GR641_1,
  Convert__GR1281_0__GR1281_2__GR641_1__U4Imm1_3,
  Convert_NoOperands,
  Convert__GR641_0__FP641_1__U4Imm1_2,
  Convert__GR1281_0__Tie0_1_1__GR641_1,
  Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2,
  Convert__GR1281_0__FP1281_1__U4Imm1_2,
  Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp202_2,
  Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2,
  Convert__GR641_0__FP641_1,
  Convert__GR1281_0__FP1281_1,
  Convert__FP1281_0__GR321_1,
  Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3,
  Convert__FP1281_0__GR641_1,
  Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3,
  Convert__FP1281_0__GR1281_1,
  Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__GR641_2,
  Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3,
  Convert__FP321_0__FP321_1__Tie0_1_1__FP321_2__U4Imm1_3,
  Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1,
  Convert__GR1281_0__Tie0_1_1__GR321_1,
  Convert__GR321_0__AR321_1,
  Convert__GR641_0__GR641_1__BDAddr32Disp202_2,
  Convert__GR321_0__GR641_1,
  Convert__GR641_0__FP1281_1,
  Convert__GR321_0,
  Convert__GR641_0,
  Convert__GR321_0__Tie0_1_1,
  Convert__GR1281_0__GR321_1,
  Convert__ADDR641_0__BDXAddr64Disp123_1,
  Convert__ADDR641_0__PCRel321_1,
  Convert__FP641_0__U4Imm1_1__FP641_2,
  Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3,
  Convert__FP321_0__U4Imm1_1__FP321_2,
  Convert__FP321_0__U4Imm1_1__FP321_2__U4Imm1_3,
  Convert__FP1281_0__U4Imm1_1__FP1281_2,
  Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3,
  Convert__GR1281_0__GR641_1,
  Convert__GR641_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp122_2,
  Convert__GRH321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2,
  Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2,
  Convert__GR641_0__GR641_2__GR641_1,
  Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3,
  Convert__FP641_0__GR641_2__FP641_1,
  Convert__FP1281_0__GR641_2__FP1281_1,
  Convert__GRH321_0__Tie0_1_1__U16Imm1_1,
  Convert__GR321_0__Tie0_1_1__U16Imm1_1,
  Convert__GR641_0__GR321_1__GR321_2,
  Convert__GR641_0__GR321_1__GR321_2__U4Imm1_3,
  Convert__PCRel161_0,
  Convert__PCRel321_0,
  Convert__GR1281_1__GR641_0__Tie0_1_1,
  Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2,
  Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1,
  Convert__GR321_0__GR321_1__BDAddr64Disp202_2,
  Convert__GR641_0__GR641_1__BDAddr64Disp202_2,
  Convert__AR321_0__AR321_1__BDAddr64Disp122_2,
  Convert__AR321_0__AR321_1__BDAddr64Disp202_2,
  Convert__BDAddr64Disp122_0__BDAddr64Disp122_1,
  Convert__GR321_0__BDXAddr64Disp123_1__U4Imm1_2,
  Convert__CR641_0__CR641_1__BDAddr64Disp122_2,
  Convert__CR641_0__CR641_1__BDAddr64Disp202_2,
  Convert__FP641_0__FP321_1,
  Convert__FP641_0__FP321_1__U4Imm1_2,
  Convert__VR1281_0__BDXAddr64Disp123_1,
  Convert__FP641_0__FP1281_1,
  Convert__FP641_0__BDXAddr64Disp203_1,
  Convert__FP321_0__FP641_1,
  Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3,
  Convert__FP321_0__FP1281_1,
  Convert__FP321_0__BDXAddr64Disp203_1,
  Convert__GR641_0__LXAAddr64Disp203_1,
  Convert__GR641_0__GR641_1__BDAddr64Disp122_2__BDAddr64Disp122_3,
  Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2,
  Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2,
  Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1,
  Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2,
  Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1,
  Convert__GRH321_0__Tie0_1_1__GRH321_1__U4Imm1_2,
  Convert__GRH321_0__Tie0_1_1__GRH321_1,
  Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2,
  Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1,
  Convert__GR641_0__Tie0_1_1__S16Imm1_1__U4Imm1_2,
  Convert__GR641_0__Tie0_1_1__GR641_1__U4Imm1_2,
  Convert__GRH321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2,
  Convert__GRH321_0__Tie0_1_1__S16Imm1_1,
  Convert__GR321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2,
  Convert__GR321_0__Tie0_1_1__GR321_1__U4Imm1_2,
  Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2,
  Convert__GR1281_0__BDXAddr64Disp203_1,
  Convert__BDAddr64Disp202_0,
  Convert__GR641_0__GR641_1__Tie0_1_1__GR641_2__U4Imm1_3,
  Convert__FP1281_0__BDXAddr64Disp123_1,
  Convert__FP1281_0__FP641_1,
  Convert__FP1281_0__FP641_1__U4Imm1_2,
  Convert__FP1281_0__FP321_1,
  Convert__FP641_0,
  Convert__FP321_0,
  Convert__FP1281_0,
  Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2,
  Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2,
  Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2,
  Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2,
  Convert__FP641_0__Tie0_1_1__FP321_1,
  Convert__GR1281_0__GR641_1__GR641_2,
  Convert__GR1281_0,
  Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2,
  Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__FP1281_0__Tie0_1_1__FP641_1,
  Convert__FP1281_0__FP641_1__BDXAddr64Disp123_2,
  Convert__FP641_0__FP641_1__BDXAddr64Disp123_2,
  Convert__FP1281_0__FP641_1__FP641_2,
  Convert__U4Imm1_0__U4Imm1_1,
  Convert__GRH321_0__Tie0_1_1__U32Imm1_1,
  Convert__GR641_0__GR641_1__imm_95_0,
  Convert__GR321_0__GR321_1__imm_95_0,
  Convert__GR641_1__GR321_0__Tie0_1_1,
  Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1,
  Convert__GR641_0__BDAddr64Disp122_1__GR641_2__BDAddr64Disp122_3,
  Convert__GR641_0__Tie0_1_1,
  Convert__FP1281_0__FP1281_1__Tie0_1_1__FP1281_2__U4Imm1_3,
  Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4,
  Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4,
  Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4,
  Convert__GR321_0__GR321_1__BDAddr32Disp202_2,
  Convert__FP641_0__FP641_1__Tie0_1_1__GR321_2__U4Imm1_3,
  Convert__FP1281_0__FP1281_1__Tie0_1_1__GR321_2__U4Imm1_3,
  Convert__AR321_0__GR321_1,
  Convert__GRH321_0__GRH321_2__GRH321_1__U4Imm1_3,
  Convert__GRH321_0__GRH321_2__GRH321_1,
  Convert__GR321_0__GR321_2__GR321_1__U4Imm1_3,
  Convert__GR321_0__GR321_2__GR321_1,
  Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1,
  Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1,
  Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2,
  Convert__BDAddr32Disp122_0,
  Convert__BDLAddr64Disp12Len43_0__BDAddr32Disp122_1__U4Imm1_2,
  Convert__GR321_0__GR641_1__U4Imm1_2,
  Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0,
  Convert__GR321_0__BDAddr64Disp202_1__U4Imm1_2,
  Convert__GRH321_0__BDAddr64Disp202_1__U4Imm1_2,
  Convert__GRH321_0__BDAddr64Disp202_1,
  Convert__GR641_0__BDAddr64Disp202_1__U4Imm1_2,
  Convert__U8Imm1_0,
  Convert__FP321_0__U4Imm1_1__FP641_2,
  Convert__GRH321_0__U16Imm1_1,
  Convert__BDLAddr64Disp12Len43_0,
  Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1,
  Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2,
  Convert__GR641_1__GR1281_0__Tie1_1_1,
  Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2,
  Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3,
  Convert__VR1281_0__VR1281_1__VR1281_2,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3,
  Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3,
  Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__U4Imm1_2,
  Convert__VR1281_0__VR1281_1,
  Convert__GR321_0__VR1281_1__U4Imm1_2,
  Convert__GR321_0__VR1281_1__U4Imm1_2__U4Imm1_3,
  Convert__GR641_0__VR1281_1__U4Imm1_2,
  Convert__GR641_0__VR1281_1__U4Imm1_2__U4Imm1_3,
  Convert__VR1281_0__GR321_1__U8Imm1_2__U4Imm1_3,
  Convert__VR1281_0__GR641_1__U8Imm1_2__U4Imm1_3,
  Convert__VR1281_0__VR1281_1__U8Imm1_2__U4Imm1_3,
  Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4,
  Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3,
  Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3,
  Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U8Imm1_4,
  Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0,
  Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0,
  Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5,
  Convert__VR1281_0__VR1281_1__U12Imm1_2__U4Imm1_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__U12Imm1_2,
  Convert__VR1281_0__U16Imm1_1,
  Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U2Imm1_2,
  Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U1Imm1_2,
  Convert__VR1281_0__U8Imm1_1__U8Imm1_2__U4Imm1_3,
  Convert__VR1281_0__U8Imm1_1__U8Imm1_2,
  Convert__VR1281_0__VR1281_1__U4Imm1_2__imm_95_0,
  Convert__VR1281_0__VR1281_1__imm_95_0,
  Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2,
  Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U4Imm1_2,
  Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2,
  Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2,
  Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2,
  Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U4Imm1_2,
  Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U2Imm1_2,
  Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U1Imm1_2,
  Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U3Imm1_2,
  Convert__GR641_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3,
  Convert__GR641_0__VR1281_1__BDAddr32Disp122_2,
  Convert__VR1281_0__U16Imm1_1__U4Imm1_2,
  Convert__VR1281_0__GR321_1__BDAddr64Disp122_2,
  Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2,
  Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3,
  Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2,
  Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2__U4Imm1_3,
  Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2,
  Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2,
  Convert__VR1281_0__GR641_1__GR641_2,
  Convert__VR1281_0__VR1281_1__VR1281_1,
  Convert__VR1281_0,
  Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__U16Imm1_2__U4Imm1_3,
  Convert__VR1281_0__VR1281_1__U16Imm1_2,
  Convert__VR1281_0__S16Imm1_1__U4Imm1_2,
  Convert__VR1281_0__S16Imm1_1,
  Convert__VR1281_0__BDVAddr64Disp123_1__U2Imm1_2,
  Convert__VR1281_0__BDVAddr64Disp123_1__U1Imm1_2,
  Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3,
  Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2,
  Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2,
  Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0,
  Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3,
  Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3,
  Convert__VR641_0__VR641_1__VR641_2,
  Convert__VR321_0__VR321_1__VR321_2,
  Convert__VR641_0__VR641_1,
  Convert__VR321_0__VR321_1,
  Convert__VR1281_0__VR641_1,
  Convert__VR641_0__VR321_1,
  Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3,
  Convert__VR641_0__VR1281_1__U4Imm1_2__U4Imm1_3,
  Convert__VR641_0__VR641_1__VR641_2__VR641_3,
  Convert__VR321_0__VR321_1__VR321_2__VR321_3,
  Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3,
  Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3,
  Convert__VR641_0__VR641_1__U4Imm1_2,
  Convert__VR321_0__VR321_1__U4Imm1_2,
  Convert__VR641_0__VR641_1__U12Imm1_2,
  Convert__VR321_0__VR321_1__U12Imm1_2,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][13] = {
  // Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP641_0__Tie0_1_1__FP641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__FP641_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP321_0__Tie0_1_1__FP321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_1__S16Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_1__GR641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__BDAddr64Disp202_0__S8Imm1_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GRH321_0__GRH321_1__GRH321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GRH321_0__GRH321_1__GR321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__GR321_1__S16Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__GR321_1__GR321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1
  { CVT_95_addBDLAddrOperands, 1, CVT_95_addBDLAddrOperands, 2, CVT_Done },
  // Convert__FP1281_0__Tie0_1_1__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__FP1281_1__FP1281_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__BDXAddr64Disp123_0
  { CVT_95_addBDXAddrOperands, 1, CVT_Done },
  // Convert__GR641_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__ADDR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__U4Imm1_0__BDXAddr64Disp123_1
  { CVT_95_addImmOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__U4Imm1_0__GR641_1
  { CVT_95_addImmOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__ADDR641_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__BDXAddr64Disp203_0
  { CVT_95_addBDXAddrOperands, 1, CVT_Done },
  // Convert__U4Imm1_0__BDXAddr64Disp203_1
  { CVT_95_addImmOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__U4Imm1_0__PCRel161_1__BDAddr64Disp122_2
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__U4Imm1_0__PCRel121_1__PCRel241_2
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__PCRelTLS162_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmTLSOperands, 2, CVT_Done },
  // Convert__GR641_0__PCRelTLS322_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmTLSOperands, 2, CVT_Done },
  // Convert__U4Imm1_0__PCRel161_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__U4Imm1_0__PCRel321_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__PCRel161_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__PCRel161_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__PCRel321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR321_0__BDAddr64Disp122_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__FP641_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP641_0__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP641_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDLAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__FP321_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP321_0__FP321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP321_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP321_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__BDAddr64Disp122_0
  { CVT_95_addBDAddrOperands, 1, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP321_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP1281_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP321_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__PCRel321_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__BDAddr64Disp122_0__S16Imm1_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__S8Imm1_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__S8Imm1_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR641_0__GR641_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__GR641_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP1281_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GRH321_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GRH321_0__GRH321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GRH321_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__PCRel321_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR321_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GRH321_0__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__S8Imm1_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__S8Imm1_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1
  { CVT_95_addBDLAddrOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__BDAddr64Disp122_0__U16Imm1_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__U8Imm1_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__U8Imm1_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__U16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__BDAddr64Disp202_2__U4Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__BDAddr64Disp122_0__U8Imm1_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GRH321_0__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U8Imm1_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__U8Imm1_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__BDAddr64Disp202_0__U8Imm1_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR321_0__GR321_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__GR321_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__GR321_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__GR321_0__BDAddr64Disp202_2__U4Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__FP641_0__FP641_2__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDLAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__AR321_0__AR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR1281_0__GR1281_2__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR1281_0__GR1281_2__GR641_1__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert_NoOperands
  { CVT_Done },
  // Convert__GR641_0__FP641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__GR641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2
  { CVT_95_addBDAddrOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR1281_0__FP1281_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR1281_0__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__GR1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__GR641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP321_0__FP321_1__Tie0_1_1__FP321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__GR321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__AR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_1__BDAddr32Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__GR641_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__GR321_0__Tie0_1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__GR1281_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__ADDR641_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__ADDR641_0__PCRel321_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__FP641_0__U4Imm1_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__FP321_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__FP321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__U4Imm1_1__FP1281_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR1281_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_2__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP641_0__GR641_2__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__GR641_2__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__GR321_1__GR321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR641_0__GR321_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__PCRel161_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__PCRel321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__GR1281_1__GR641_0__Tie0_1_1
  { CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Tied, Tie2_1_1, CVT_Done },
  // Convert__GR321_0__GR321_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__AR321_0__AR321_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__AR321_0__AR321_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__BDAddr64Disp122_0__BDAddr64Disp122_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GR321_0__BDXAddr64Disp123_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__CR641_0__CR641_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__CR641_0__CR641_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__FP641_0__FP321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__FP321_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP641_0__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP321_0__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP321_0__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP321_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__LXAAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addLXAAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_1__BDAddr64Disp122_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__GRH321_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__GRH321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR321_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR1281_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__BDAddr64Disp202_0
  { CVT_95_addBDAddrOperands, 1, CVT_Done },
  // Convert__GR641_0__GR641_1__Tie0_1_1__GR641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP1281_0__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__FP641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__FP1281_0__FP321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__FP321_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__FP1281_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDXAddrOperands, 3, CVT_Done },
  // Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDXAddrOperands, 3, CVT_Done },
  // Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP641_0__Tie0_1_1__FP321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR1281_0__GR641_1__GR641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR1281_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2
  { CVT_95_addBDRAddrOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP1281_0__Tie0_1_1__FP641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__FP641_1__BDXAddr64Disp123_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDXAddrOperands, 3, CVT_Done },
  // Convert__FP641_0__FP641_1__BDXAddr64Disp123_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDXAddrOperands, 3, CVT_Done },
  // Convert__FP1281_0__FP641_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__U4Imm1_0__U4Imm1_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_1__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__GR321_0__GR321_1__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__GR641_1__GR321_0__Tie0_1_1
  { CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addBDLAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__BDAddr64Disp122_1__GR641_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR641_0__Tie0_1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__FP1281_0__FP1281_1__Tie0_1_1__FP1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__GR321_0__GR321_1__BDAddr32Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__FP641_0__FP641_1__Tie0_1_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__FP1281_1__Tie0_1_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AR321_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GRH321_0__GRH321_2__GRH321_1__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GRH321_0__GRH321_2__GRH321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__GR321_2__GR321_1__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__GR321_2__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDXAddrOperands, 3, CVT_Done },
  // Convert__BDAddr32Disp122_0
  { CVT_95_addBDAddrOperands, 1, CVT_Done },
  // Convert__BDLAddr64Disp12Len43_0__BDAddr32Disp122_1__U4Imm1_2
  { CVT_95_addBDLAddrOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__GR641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__GR321_0__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__U8Imm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GRH321_0__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__BDLAddr64Disp12Len43_0
  { CVT_95_addBDLAddrOperands, 1, CVT_Done },
  // Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_1__GR1281_0__Tie1_1_1
  { CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 1, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2
  { CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 1, CVT_Tied, Tie1_1_1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__VR1281_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__VR1281_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__VR1281_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__VR1281_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__GR321_1__U8Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__GR641_1__U8Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U8Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U8Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U12Imm1_2__U4Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U12Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U2Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDVAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U1Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDVAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__U8Imm1_1__U8Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__U8Imm1_1__U8Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U4Imm1_2__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR1281_0__VR1281_1__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U2Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U1Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U3Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__VR1281_1__BDAddr32Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__U16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__GR321_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__GR641_1__GR641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__VR1281_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U16Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U16Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__VR1281_0__BDVAddr64Disp123_1__U2Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDVAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__BDVAddr64Disp123_1__U1Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDVAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR641_0__VR641_1__VR641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__VR321_0__VR321_1__VR321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__VR641_0__VR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__VR321_0__VR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__VR1281_0__VR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__VR641_0__VR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR641_0__VR1281_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR641_0__VR641_1__VR641_2__VR641_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__VR321_0__VR321_1__VR321_2__VR321_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR641_0__VR641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR321_0__VR321_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR641_0__VR641_1__U12Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR321_0__VR321_1__U12Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
};

void SystemZAsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    unsigned OpIdx = *(p + 1);
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(*(p + 1) < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[*(p + 1)][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_95_addRegOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_95_addBDXAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addBDXAddrOperands(Inst, 3);
      break;
    case CVT_95_addImmOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addBDAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addBDAddrOperands(Inst, 2);
      break;
    case CVT_95_addBDLAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addBDLAddrOperands(Inst, 3);
      break;
    case CVT_95_addImmTLSOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addImmTLSOperands(Inst, 2);
      break;
    case CVT_95_addLXAAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addLXAAddrOperands(Inst, 3);
      break;
    case CVT_95_addBDRAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addBDRAddrOperands(Inst, 3);
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_95_addBDVAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addBDVAddrOperands(Inst, 3);
      break;
    }
  }
}

void SystemZAsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_95_addRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addBDXAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addBDAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addBDLAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addImmTLSOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addLXAAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addBDRAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addBDVAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK_LAST_TOKEN = OptionalMatchClass,
  MCK_CCR, // register class 'CCR'
  MCK_FPCRegs, // register class 'FPCRegs'
  MCK_ADDR128Bit, // register class 'ADDR128Bit'
  MCK_FP128Bit, // register class 'FP128Bit'
  MCK_GR128Bit, // register class 'GR128Bit'
  MCK_ADDR32Bit, // register class 'ADDR32Bit'
  MCK_ADDR64Bit, // register class 'ADDR64Bit'
  MCK_AR32Bit, // register class 'AR32Bit'
  MCK_CR64Bit, // register class 'CR64Bit'
  MCK_FP32Bit, // register class 'FP32Bit'
  MCK_FP64Bit, // register class 'FP64Bit'
  MCK_GR32Bit, // register class 'GR32Bit'
  MCK_GR64Bit, // register class 'GR64Bit'
  MCK_GRH32Bit, // register class 'GRH32Bit'
  MCK_VF128Bit, // register class 'VF128Bit'
  MCK_Reg13, // derived register class
  MCK_GRX32Bit, // register class 'GRX32Bit'
  MCK_VR128Bit, // register class 'VR128Bit'
  MCK_VR32Bit, // register class 'VR32Bit'
  MCK_VR64Bit, // register class 'VR64Bit'
  MCK_AnyRegBit, // register class 'AnyRegBit'
  MCK_LAST_REGISTER = MCK_AnyRegBit,
  MCK_ADDR128, // user defined class 'ADDR128AsmOperand'
  MCK_ADDR32, // user defined class 'ADDR32AsmOperand'
  MCK_ADDR64, // user defined class 'ADDR64AsmOperand'
  MCK_AR32, // user defined class 'AR32AsmOperand'
  MCK_AnyReg, // user defined class 'AnyRegAsmOperand'
  MCK_BDAddr32Disp12, // user defined class 'BDAddr32Disp12'
  MCK_BDAddr32Disp20, // user defined class 'BDAddr32Disp20'
  MCK_BDAddr64Disp12, // user defined class 'BDAddr64Disp12'
  MCK_BDAddr64Disp20, // user defined class 'BDAddr64Disp20'
  MCK_BDLAddr64Disp12Len4, // user defined class 'BDLAddr64Disp12Len4'
  MCK_BDLAddr64Disp12Len8, // user defined class 'BDLAddr64Disp12Len8'
  MCK_BDRAddr64Disp12, // user defined class 'BDRAddr64Disp12'
  MCK_BDVAddr64Disp12, // user defined class 'BDVAddr64Disp12'
  MCK_BDXAddr64Disp12, // user defined class 'BDXAddr64Disp12'
  MCK_BDXAddr64Disp20, // user defined class 'BDXAddr64Disp20'
  MCK_CR64, // user defined class 'CR64AsmOperand'
  MCK_FP128, // user defined class 'FP128AsmOperand'
  MCK_FP32, // user defined class 'FP32AsmOperand'
  MCK_FP64, // user defined class 'FP64AsmOperand'
  MCK_GR128, // user defined class 'GR128AsmOperand'
  MCK_GR32, // user defined class 'GR32AsmOperand'
  MCK_GR64, // user defined class 'GR64AsmOperand'
  MCK_GRH32, // user defined class 'GRH32AsmOperand'
  MCK_GRX32, // user defined class 'GRX32AsmOperand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_LXAAddr64Disp20, // user defined class 'LXAAddr64Disp20'
  MCK_PCRel12, // user defined class 'PCRel12'
  MCK_PCRel16, // user defined class 'PCRel16'
  MCK_PCRel24, // user defined class 'PCRel24'
  MCK_PCRel32, // user defined class 'PCRel32'
  MCK_PCRelTLS16, // user defined class 'PCRelTLS16'
  MCK_PCRelTLS32, // user defined class 'PCRelTLS32'
  MCK_S16Imm, // user defined class 'S16Imm'
  MCK_S32Imm, // user defined class 'S32Imm'
  MCK_S8Imm, // user defined class 'S8Imm'
  MCK_U12Imm, // user defined class 'U12Imm'
  MCK_U16Imm, // user defined class 'U16Imm'
  MCK_U1Imm, // user defined class 'U1Imm'
  MCK_U2Imm, // user defined class 'U2Imm'
  MCK_U32Imm, // user defined class 'U32Imm'
  MCK_U3Imm, // user defined class 'U3Imm'
  MCK_U48Imm, // user defined class 'U48Imm'
  MCK_U4Imm, // user defined class 'U4Imm'
  MCK_U8Imm, // user defined class 'U8Imm'
  MCK_VF128, // user defined class 'VF128AsmOperand'
  MCK_VR128, // user defined class 'VR128AsmOperand'
  MCK_VR32, // user defined class 'VR32AsmOperand'
  MCK_VR64, // user defined class 'VR64AsmOperand'
  NumMatchClassKinds
};

} // end anonymous namespace

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  return MCTargetAsmParser::Match_InvalidOperand;
}

static MatchClassKind matchTokenString(StringRef Name) {
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  [[maybe_unused]] static constexpr struct {
    uint32_t Offset;
    uint16_t Start;
    uint16_t Length;
  } Table[] = {
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 6, 1},
    {1, 0, 0},
    {1, 0, 0},
    {1, 13, 6},
    {7, 14, 9},
    {16, 0, 0},
    {16, 0, 0},
    {16, 20, 1},
    {17, 17, 6},
    {23, 18, 1},
    {24, 22, 1},
    {25, 18, 1},
    {26, 17, 6},
    {32, 22, 1},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
    {33, 0, 0},
  };

  static constexpr uint8_t Data[] = {
    0xC3,
    0x80,
    0xE3,
    0x97,
    0x01,
  };

  auto &Entry = Table[A];
  unsigned Idx = B - Entry.Start;
  if (Idx >= Entry.Length)
    return false;
  Idx += Entry.Offset;
  return (Data[Idx / 8] >> (Idx % 8)) & 1;
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  SystemZOperand &Operand = (SystemZOperand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  case MCK_ADDR128: {
    DiagnosticPredicate DP(Operand.isADDR128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ADDR32: {
    DiagnosticPredicate DP(Operand.isADDR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ADDR64: {
    DiagnosticPredicate DP(Operand.isADDR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_AR32: {
    DiagnosticPredicate DP(Operand.isAR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_AnyReg: {
    DiagnosticPredicate DP(Operand.isAnyReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDAddr32Disp12: {
    DiagnosticPredicate DP(Operand.isBDAddr32Disp12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDAddr32Disp20: {
    DiagnosticPredicate DP(Operand.isBDAddr32Disp20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDAddr64Disp12: {
    DiagnosticPredicate DP(Operand.isBDAddr64Disp12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDAddr64Disp20: {
    DiagnosticPredicate DP(Operand.isBDAddr64Disp20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDLAddr64Disp12Len4: {
    DiagnosticPredicate DP(Operand.isBDLAddr64Disp12Len4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDLAddr64Disp12Len8: {
    DiagnosticPredicate DP(Operand.isBDLAddr64Disp12Len8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDRAddr64Disp12: {
    DiagnosticPredicate DP(Operand.isBDRAddr64Disp12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDVAddr64Disp12: {
    DiagnosticPredicate DP(Operand.isBDVAddr64Disp12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDXAddr64Disp12: {
    DiagnosticPredicate DP(Operand.isBDXAddr64Disp12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDXAddr64Disp20: {
    DiagnosticPredicate DP(Operand.isBDXAddr64Disp20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_CR64: {
    DiagnosticPredicate DP(Operand.isCR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FP128: {
    DiagnosticPredicate DP(Operand.isFP128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FP32: {
    DiagnosticPredicate DP(Operand.isFP32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FP64: {
    DiagnosticPredicate DP(Operand.isFP64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GR128: {
    DiagnosticPredicate DP(Operand.isGR128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GR32: {
    DiagnosticPredicate DP(Operand.isGR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GR64: {
    DiagnosticPredicate DP(Operand.isGR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GRH32: {
    DiagnosticPredicate DP(Operand.isGRH32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GRX32: {
    DiagnosticPredicate DP(Operand.isGRX32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_LXAAddr64Disp20: {
    DiagnosticPredicate DP(Operand.isLXAAddr64Disp20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRel12: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRel16: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRel24: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRel32: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRelTLS16: {
    DiagnosticPredicate DP(Operand.isImmTLS());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRelTLS32: {
    DiagnosticPredicate DP(Operand.isImmTLS());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_S16Imm: {
    DiagnosticPredicate DP(Operand.isS16Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_S32Imm: {
    DiagnosticPredicate DP(Operand.isS32Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_S8Imm: {
    DiagnosticPredicate DP(Operand.isS8Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U12Imm: {
    DiagnosticPredicate DP(Operand.isU12Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U16Imm: {
    DiagnosticPredicate DP(Operand.isU16Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U1Imm: {
    DiagnosticPredicate DP(Operand.isU1Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U2Imm: {
    DiagnosticPredicate DP(Operand.isU2Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U32Imm: {
    DiagnosticPredicate DP(Operand.isU32Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U3Imm: {
    DiagnosticPredicate DP(Operand.isU3Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U48Imm: {
    DiagnosticPredicate DP(Operand.isU48Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U4Imm: {
    DiagnosticPredicate DP(Operand.isU4Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U8Imm: {
    DiagnosticPredicate DP(Operand.isU8Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VF128: {
    DiagnosticPredicate DP(Operand.isVF128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VR128: {
    DiagnosticPredicate DP(Operand.isVR128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VR32: {
    DiagnosticPredicate DP(Operand.isVR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VR64: {
    DiagnosticPredicate DP(Operand.isVR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  } // end switch (Kind)

  if (Operand.isReg()) {
    static constexpr uint16_t Table[SystemZ::NUM_TARGET_REGS] = {
      InvalidMatchClass,
      MCK_CCR,
      MCK_FPCRegs,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_GR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_GR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
    };

    MCRegister Reg = Operand.getReg();
    MatchClassKind OpKind = Reg.isPhysical() ? (MatchClassKind)Table[Reg.id()] : InvalidMatchClass;
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK_CCR: return "MCK_CCR";
  case MCK_FPCRegs: return "MCK_FPCRegs";
  case MCK_ADDR128Bit: return "MCK_ADDR128Bit";
  case MCK_FP128Bit: return "MCK_FP128Bit";
  case MCK_GR128Bit: return "MCK_GR128Bit";
  case MCK_ADDR32Bit: return "MCK_ADDR32Bit";
  case MCK_ADDR64Bit: return "MCK_ADDR64Bit";
  case MCK_AR32Bit: return "MCK_AR32Bit";
  case MCK_CR64Bit: return "MCK_CR64Bit";
  case MCK_FP32Bit: return "MCK_FP32Bit";
  case MCK_FP64Bit: return "MCK_FP64Bit";
  case MCK_GR32Bit: return "MCK_GR32Bit";
  case MCK_GR64Bit: return "MCK_GR64Bit";
  case MCK_GRH32Bit: return "MCK_GRH32Bit";
  case MCK_VF128Bit: return "MCK_VF128Bit";
  case MCK_Reg13: return "MCK_Reg13";
  case MCK_GRX32Bit: return "MCK_GRX32Bit";
  case MCK_VR128Bit: return "MCK_VR128Bit";
  case MCK_VR32Bit: return "MCK_VR32Bit";
  case MCK_VR64Bit: return "MCK_VR64Bit";
  case MCK_AnyRegBit: return "MCK_AnyRegBit";
  case MCK_ADDR128: return "MCK_ADDR128";
  case MCK_ADDR32: return "MCK_ADDR32";
  case MCK_ADDR64: return "MCK_ADDR64";
  case MCK_AR32: return "MCK_AR32";
  case MCK_AnyReg: return "MCK_AnyReg";
  case MCK_BDAddr32Disp12: return "MCK_BDAddr32Disp12";
  case MCK_BDAddr32Disp20: return "MCK_BDAddr32Disp20";
  case MCK_BDAddr64Disp12: return "MCK_BDAddr64Disp12";
  case MCK_BDAddr64Disp20: return "MCK_BDAddr64Disp20";
  case MCK_BDLAddr64Disp12Len4: return "MCK_BDLAddr64Disp12Len4";
  case MCK_BDLAddr64Disp12Len8: return "MCK_BDLAddr64Disp12Len8";
  case MCK_BDRAddr64Disp12: return "MCK_BDRAddr64Disp12";
  case MCK_BDVAddr64Disp12: return "MCK_BDVAddr64Disp12";
  case MCK_BDXAddr64Disp12: return "MCK_BDXAddr64Disp12";
  case MCK_BDXAddr64Disp20: return "MCK_BDXAddr64Disp20";
  case MCK_CR64: return "MCK_CR64";
  case MCK_FP128: return "MCK_FP128";
  case MCK_FP32: return "MCK_FP32";
  case MCK_FP64: return "MCK_FP64";
  case MCK_GR128: return "MCK_GR128";
  case MCK_GR32: return "MCK_GR32";
  case MCK_GR64: return "MCK_GR64";
  case MCK_GRH32: return "MCK_GRH32";
  case MCK_GRX32: return "MCK_GRX32";
  case MCK_Imm: return "MCK_Imm";
  case MCK_LXAAddr64Disp20: return "MCK_LXAAddr64Disp20";
  case MCK_PCRel12: return "MCK_PCRel12";
  case MCK_PCRel16: return "MCK_PCRel16";
  case MCK_PCRel24: return "MCK_PCRel24";
  case MCK_PCRel32: return "MCK_PCRel32";
  case MCK_PCRelTLS16: return "MCK_PCRelTLS16";
  case MCK_PCRelTLS32: return "MCK_PCRelTLS32";
  case MCK_S16Imm: return "MCK_S16Imm";
  case MCK_S32Imm: return "MCK_S32Imm";
  case MCK_S8Imm: return "MCK_S8Imm";
  case MCK_U12Imm: return "MCK_U12Imm";
  case MCK_U16Imm: return "MCK_U16Imm";
  case MCK_U1Imm: return "MCK_U1Imm";
  case MCK_U2Imm: return "MCK_U2Imm";
  case MCK_U32Imm: return "MCK_U32Imm";
  case MCK_U3Imm: return "MCK_U3Imm";
  case MCK_U48Imm: return "MCK_U48Imm";
  case MCK_U4Imm: return "MCK_U4Imm";
  case MCK_U8Imm: return "MCK_U8Imm";
  case MCK_VF128: return "MCK_VF128";
  case MCK_VR128: return "MCK_VR128";
  case MCK_VR32: return "MCK_VR32";
  case MCK_VR64: return "MCK_VR64";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset SystemZAsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (FB[SystemZ::FeatureSoftFloat])
    Features.set(Feature_FeatureSoftFloatBit);
  if (FB[SystemZ::FeatureBackChain])
    Features.set(Feature_FeatureBackChainBit);
  if (FB[SystemZ::FeatureUnalignedSymbols])
    Features.set(Feature_FeatureUnalignedSymbolsBit);
  if (FB[SystemZ::FeatureDistinctOps])
    Features.set(Feature_FeatureDistinctOpsBit);
  if (FB[SystemZ::FeatureFastSerialization])
    Features.set(Feature_FeatureFastSerializationBit);
  if (FB[SystemZ::FeatureFPExtension])
    Features.set(Feature_FeatureFPExtensionBit);
  if (FB[SystemZ::FeatureHighWord])
    Features.set(Feature_FeatureHighWordBit);
  if (FB[SystemZ::FeatureInterlockedAccess1])
    Features.set(Feature_FeatureInterlockedAccess1Bit);
  if (FB[SystemZ::FeatureLoadStoreOnCond])
    Features.set(Feature_FeatureLoadStoreOnCondBit);
  if (FB[SystemZ::FeaturePopulationCount])
    Features.set(Feature_FeaturePopulationCountBit);
  if (FB[SystemZ::FeatureMessageSecurityAssist3])
    Features.set(Feature_FeatureMessageSecurityAssist3Bit);
  if (FB[SystemZ::FeatureMessageSecurityAssist4])
    Features.set(Feature_FeatureMessageSecurityAssist4Bit);
  if (FB[SystemZ::FeatureResetReferenceBitsMultiple])
    Features.set(Feature_FeatureResetReferenceBitsMultipleBit);
  if (FB[SystemZ::FeatureExecutionHint])
    Features.set(Feature_FeatureExecutionHintBit);
  if (FB[SystemZ::FeatureLoadAndTrap])
    Features.set(Feature_FeatureLoadAndTrapBit);
  if (FB[SystemZ::FeatureMiscellaneousExtensions])
    Features.set(Feature_FeatureMiscellaneousExtensionsBit);
  if (FB[SystemZ::FeatureProcessorAssist])
    Features.set(Feature_FeatureProcessorAssistBit);
  if (FB[SystemZ::FeatureTransactionalExecution])
    Features.set(Feature_FeatureTransactionalExecutionBit);
  if (FB[SystemZ::FeatureDFPZonedConversion])
    Features.set(Feature_FeatureDFPZonedConversionBit);
  if (FB[SystemZ::FeatureEnhancedDAT2])
    Features.set(Feature_FeatureEnhancedDAT2Bit);
  if (FB[SystemZ::FeatureLoadAndZeroRightmostByte])
    Features.set(Feature_FeatureLoadAndZeroRightmostByteBit);
  if (FB[SystemZ::FeatureLoadStoreOnCond2])
    Features.set(Feature_FeatureLoadStoreOnCond2Bit);
  if (FB[SystemZ::FeatureMessageSecurityAssist5])
    Features.set(Feature_FeatureMessageSecurityAssist5Bit);
  if (FB[SystemZ::FeatureDFPPackedConversion])
    Features.set(Feature_FeatureDFPPackedConversionBit);
  if (FB[SystemZ::FeatureVector])
    Features.set(Feature_FeatureVectorBit);
  if (FB[SystemZ::FeatureMiscellaneousExtensions2])
    Features.set(Feature_FeatureMiscellaneousExtensions2Bit);
  if (FB[SystemZ::FeatureGuardedStorage])
    Features.set(Feature_FeatureGuardedStorageBit);
  if (FB[SystemZ::FeatureMessageSecurityAssist7])
    Features.set(Feature_FeatureMessageSecurityAssist7Bit);
  if (FB[SystemZ::FeatureMessageSecurityAssist8])
    Features.set(Feature_FeatureMessageSecurityAssist8Bit);
  if (FB[SystemZ::FeatureVectorEnhancements1])
    Features.set(Feature_FeatureVectorEnhancements1Bit);
  if (FB[SystemZ::FeatureVectorPackedDecimal])
    Features.set(Feature_FeatureVectorPackedDecimalBit);
  if (FB[SystemZ::FeatureInsertReferenceBitsMultiple])
    Features.set(Feature_FeatureInsertReferenceBitsMultipleBit);
  if (FB[SystemZ::FeatureTestPendingExternalInterruption])
    Features.set(Feature_FeatureTestPendingExternalInterruptionBit);
  if (FB[SystemZ::FeatureMiscellaneousExtensions3])
    Features.set(Feature_FeatureMiscellaneousExtensions3Bit);
  if (FB[SystemZ::FeatureMessageSecurityAssist9])
    Features.set(Feature_FeatureMessageSecurityAssist9Bit);
  if (FB[SystemZ::FeatureVectorEnhancements2])
    Features.set(Feature_FeatureVectorEnhancements2Bit);
  if (FB[SystemZ::FeatureVectorPackedDecimalEnhancement])
    Features.set(Feature_FeatureVectorPackedDecimalEnhancementBit);
  if (FB[SystemZ::FeatureEnhancedSort])
    Features.set(Feature_FeatureEnhancedSortBit);
  if (FB[SystemZ::FeatureDeflateConversion])
    Features.set(Feature_FeatureDeflateConversionBit);
  if (FB[SystemZ::FeatureVectorPackedDecimalEnhancement2])
    Features.set(Feature_FeatureVectorPackedDecimalEnhancement2Bit);
  if (FB[SystemZ::FeatureNNPAssist])
    Features.set(Feature_FeatureNNPAssistBit);
  if (FB[SystemZ::FeatureBEAREnhancement])
    Features.set(Feature_FeatureBEAREnhancementBit);
  if (FB[SystemZ::FeatureResetDATProtection])
    Features.set(Feature_FeatureResetDATProtectionBit);
  if (FB[SystemZ::FeatureProcessorActivityInstrumentation])
    Features.set(Feature_FeatureProcessorActivityInstrumentationBit);
  if (FB[SystemZ::FeatureMiscellaneousExtensions4])
    Features.set(Feature_FeatureMiscellaneousExtensions4Bit);
  if (FB[SystemZ::FeatureVectorEnhancements3])
    Features.set(Feature_FeatureVectorEnhancements3Bit);
  if (FB[SystemZ::FeatureVectorPackedDecimalEnhancement3])
    Features.set(Feature_FeatureVectorPackedDecimalEnhancement3Bit);
  if (FB[SystemZ::FeatureMessageSecurityAssist12])
    Features.set(Feature_FeatureMessageSecurityAssist12Bit);
  if (FB[SystemZ::FeatureConcurrentFunctions])
    Features.set(Feature_FeatureConcurrentFunctionsBit);
  return Features;
}

static bool checkAsmTiedOperandConstraints(const SystemZAsmParser&AsmParser,
                               unsigned Kind, const OperandVector &Operands,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p + 1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (!AsmParser.areEqualRegs(*SrcOp1, *SrcOp2)) {
          ErrorInfo = OpndNum2;
          return false;
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char MnemonicTable[] =
    "\000\001a\002ad\003adb\004adbr\003adr\004adtr\005adtra\002ae\003aeb\004"
    "aebr\003aer\003afi\002ag\003agf\004agfi\004agfr\003agh\004aghi\005aghik"
    "\003agr\004agrk\004agsi\002ah\005ahhhr\005ahhlr\003ahi\004ahik\003ahy\003"
    "aih\002al\003alc\004alcg\005alcgr\004alcr\004alfi\003alg\004algf\005alg"
    "fi\005algfr\007alghsik\004algr\005algrk\005algsi\006alhhhr\006alhhlr\006"
    "alhsik\003alr\004alrk\004alsi\005alsih\006alsihn\003aly\002ap\002ar\003"
    "ark\003asi\002au\003aur\002aw\003awr\004axbr\003axr\004axtr\005axtra\002"
    "ay\001b\004bakr\003bal\004balr\003bas\004basr\005bassm\002bc\003bcr\003"
    "bct\004bctg\005bctgr\004bctr\005bdepg\002be\003ber\005bextg\002bh\003bh"
    "e\004bher\003bhr\002bi\003bic\003bie\003bih\004bihe\003bil\004bile\004b"
    "ilh\003bim\004bine\004binh\005binhe\004binl\005binle\005binlh\004binm\004"
    "bino\004binp\004binz\003bio\003bip\003biz\002bl\003ble\004bler\003blh\004"
    "blhr\003blr\002bm\003bmr\003bne\004bner\003bnh\004bnhe\005bnher\004bnhr"
    "\003bnl\004bnle\005bnler\004bnlh\005bnlhr\004bnlr\003bnm\004bnmr\003bno"
    "\004bnor\003bnp\004bnpr\003bnz\004bnzr\002bo\003bor\002bp\003bpp\003bpr"
    "\004bprp\002br\004bras\005brasl\003brc\004brcl\004brct\005brctg\005brct"
    "h\004brxh\005brxhg\005brxle\005brxlg\003bsa\003bsg\003bsm\003bxh\004bxh"
    "g\004bxle\005bxleg\002bz\003bzr\001c\003cal\004calg\005calgf\002cd\003c"
    "db\004cdbr\005cdfbr\006cdfbra\004cdfr\005cdftr\005cdgbr\006cdgbra\004cd"
    "gr\005cdgtr\006cdgtra\006cdlfbr\006cdlftr\006cdlgbr\006cdlgtr\004cdpt\003"
    "cdr\003cds\004cdsg\005cdstr\004cdsy\004cdtr\005cdutr\004cdzt\002ce\003c"
    "eb\004cebr\005cedtr\005cefbr\006cefbra\004cefr\005cegbr\006cegbra\004ce"
    "gr\006celfbr\006celgbr\003cer\005cextr\003cfc\005cfdbr\006cfdbra\004cfd"
    "r\005cfdtr\005cfebr\006cfebra\004cfer\003cfi\005cfxbr\006cfxbra\004cfxr"
    "\005cfxtr\002cg\005cgdbr\006cgdbra\004cgdr\005cgdtr\006cgdtra\005cgebr\006"
    "cgebra\004cger\003cgf\004cgfi\004cgfr\005cgfrl\003cgh\004cghi\005cghrl\005"
    "cghsi\004cgib\005cgibe\005cgibh\006cgibhe\005cgibl\006cgible\006cgiblh\006"
    "cgibne\006cgibnh\007cgibnhe\006cgibnl\007cgibnle\007cgibnlh\004cgij\005"
    "cgije\005cgijh\006cgijhe\005cgijl\006cgijle\006cgijlh\006cgijne\006cgij"
    "nh\007cgijnhe\006cgijnl\007cgijnle\007cgijnlh\004cgit\005cgite\005cgith"
    "\006cgithe\005cgitl\006cgitle\006cgitlh\006cgitne\006cgitnh\007cgitnhe\006"
    "cgitnl\007cgitnle\007cgitnlh\003cgr\004cgrb\005cgrbe\005cgrbh\006cgrbhe"
    "\005cgrbl\006cgrble\006cgrblh\006cgrbne\006cgrbnh\007cgrbnhe\006cgrbnl\007"
    "cgrbnle\007cgrbnlh\004cgrj\005cgrje\005cgrjh\006cgrjhe\005cgrjl\006cgrj"
    "le\006cgrjlh\006cgrjne\006cgrjnh\007cgrjnhe\006cgrjnl\007cgrjnle\007cgr"
    "jnlh\004cgrl\004cgrt\005cgrte\005cgrth\006cgrthe\005cgrtl\006cgrtle\006"
    "cgrtlh\006cgrtne\006cgrtnh\007cgrtnhe\006cgrtnl\007cgrtnle\007cgrtnlh\005"
    "cgxbr\006cgxbra\004cgxr\005cgxtr\006cgxtra\002ch\003chf\004chhr\005chhs"
    "i\003chi\004chlr\004chrl\004chsi\003chy\003cib\004cibe\004cibh\005cibhe"
    "\004cibl\005cible\005ciblh\005cibne\005cibnh\006cibnhe\005cibnl\006cibn"
    "le\006cibnlh\003cih\003cij\004cije\004cijh\005cijhe\004cijl\005cijle\005"
    "cijlh\005cijne\005cijnh\006cijnhe\005cijnl\006cijnle\006cijnlh\003cit\004"
    "cite\004cith\005cithe\004citl\005citle\005citlh\005citne\005citnh\006ci"
    "tnhe\005citnl\006citnle\006citnlh\004cksm\002cl\003clc\004clcl\005clcle"
    "\005clclu\006clfdbr\006clfdtr\006clfebr\006clfhsi\004clfi\005clfit\006c"
    "lfite\006clfith\007clfithe\006clfitl\007clfitle\007clfitlh\007clfitne\007"
    "clfitnh\010clfitnhe\007clfitnl\010clfitnle\010clfitnlh\006clfxbr\006clf"
    "xtr\003clg\006clgdbr\006clgdtr\006clgebr\004clgf\005clgfi\005clgfr\006c"
    "lgfrl\006clghrl\006clghsi\005clgib\006clgibe\006clgibh\007clgibhe\006cl"
    "gibl\007clgible\007clgiblh\007clgibne\007clgibnh\010clgibnhe\007clgibnl"
    "\010clgibnle\010clgibnlh\005clgij\006clgije\006clgijh\007clgijhe\006clg"
    "ijl\007clgijle\007clgijlh\007clgijne\007clgijnh\010clgijnhe\007clgijnl\010"
    "clgijnle\010clgijnlh\005clgit\006clgite\006clgith\007clgithe\006clgitl\007"
    "clgitle\007clgitlh\007clgitne\007clgitnh\010clgitnhe\007clgitnl\010clgi"
    "tnle\010clgitnlh\004clgr\005clgrb\006clgrbe\006clgrbh\007clgrbhe\006clg"
    "rbl\007clgrble\007clgrblh\007clgrbne\007clgrbnh\010clgrbnhe\007clgrbnl\010"
    "clgrbnle\010clgrbnlh\005clgrj\006clgrje\006clgrjh\007clgrjhe\006clgrjl\007"
    "clgrjle\007clgrjlh\007clgrjne\007clgrjnh\010clgrjnhe\007clgrjnl\010clgr"
    "jnle\010clgrjnlh\005clgrl\005clgrt\006clgrte\006clgrth\007clgrthe\006cl"
    "grtl\007clgrtle\007clgrtlh\007clgrtne\007clgrtnh\010clgrtnhe\007clgrtnl"
    "\010clgrtnle\010clgrtnlh\004clgt\005clgte\005clgth\006clgthe\005clgtl\006"
    "clgtle\006clgtlh\006clgtne\006clgtnh\007clgtnhe\006clgtnl\007clgtnle\007"
    "clgtnlh\006clgxbr\006clgxtr\004clhf\005clhhr\006clhhsi\005clhlr\005clhr"
    "l\003cli\004clib\005clibe\005clibh\006clibhe\005clibl\006clible\006clib"
    "lh\006clibne\006clibnh\007clibnhe\006clibnl\007clibnle\007clibnlh\004cl"
    "ih\004clij\005clije\005clijh\006clijhe\005clijl\006clijle\006clijlh\006"
    "clijne\006clijnh\007clijnhe\006clijnl\007clijnle\007clijnlh\004cliy\003"
    "clm\004clmh\004clmy\003clr\004clrb\005clrbe\005clrbh\006clrbhe\005clrbl"
    "\006clrble\006clrblh\006clrbne\006clrbnh\007clrbnhe\006clrbnl\007clrbnl"
    "e\007clrbnlh\004clrj\005clrje\005clrjh\006clrjhe\005clrjl\006clrjle\006"
    "clrjlh\006clrjne\006clrjnh\007clrjnhe\006clrjnl\007clrjnle\007clrjnlh\004"
    "clrl\004clrt\005clrte\005clrth\006clrthe\005clrtl\006clrtle\006clrtlh\006"
    "clrtne\006clrtnh\007clrtnhe\006clrtnl\007clrtnle\007clrtnlh\004clst\003"
    "clt\004clte\004clth\005clthe\004cltl\005cltle\005cltlh\005cltne\005cltn"
    "h\006cltnhe\005cltnl\006cltnle\006cltnlh\003cly\004clzg\005cmpsc\002cp\004"
    "cpdt\005cpsdr\004cpxt\004cpya\002cr\003crb\004crbe\004crbh\005crbhe\004"
    "crbl\005crble\005crblh\005crbne\005crbnh\006crbnhe\005crbnl\006crbnle\006"
    "crbnlh\005crdte\003crj\004crje\004crjh\005crjhe\004crjl\005crjle\005crj"
    "lh\005crjne\005crjnh\006crjnhe\005crjnl\006crjnle\006crjnlh\003crl\003c"
    "rt\004crte\004crth\005crthe\004crtl\005crtle\005crtlh\005crtne\005crtnh"
    "\006crtnhe\005crtnl\006crtnle\006crtnlh\002cs\004csch\005csdtr\003csg\003"
    "csp\004cspg\004csst\005csxtr\003csy\004ctzg\004cu12\004cu14\004cu21\004"
    "cu24\004cu41\004cu42\005cudtr\004cuse\005cutfu\005cuutf\005cuxtr\003cvb"
    "\004cvbg\004cvby\003cvd\004cvdg\004cvdy\004cxbr\005cxfbr\006cxfbra\004c"
    "xfr\005cxftr\005cxgbr\006cxgbra\004cxgr\005cxgtr\006cxgtra\006cxlfbr\006"
    "cxlftr\006cxlgbr\006cxlgtr\004cxpt\003cxr\005cxstr\004cxtr\005cxutr\004"
    "cxzt\002cy\004czdt\004czxt\001d\002dd\003ddb\004ddbr\003ddr\004ddtr\005"
    "ddtra\002de\003deb\004debr\003der\006dfltcc\004diag\005didbr\005diebr\002"
    "dl\003dlg\004dlgr\003dlr\002dp\002dr\003dsg\004dsgf\005dsgfr\004dsgr\004"
    "dxbr\003dxr\004dxtr\005dxtra\003ear\004ecag\005ecctr\005ecpga\004ectg\002"
    "ed\004edmk\005eedtr\005eextr\004efpc\005epair\004epar\005epctr\004epsw\004"
    "ereg\005eregg\005esair\004esar\005esdtr\004esea\004esta\005esxtr\004etn"
    "d\002ex\004exrl\005fidbr\006fidbra\004fidr\005fidtr\005fiebr\006fiebra\004"
    "fier\005fixbr\006fixbra\004fixr\005fixtr\005flogr\003hdr\003her\004hsch"
    "\003iac\002ic\003icm\004icmh\004icmy\003icy\004idte\005iedtr\005iextr\004"
    "iihf\004iihh\004iihl\004iilf\004iilh\004iill\003ipk\003ipm\004ipte\004i"
    "rbm\004iske\004ivsk\001j\002je\002jg\003jge\003jgh\004jghe\003jgl\004jg"
    "le\004jglh\003jgm\004jgne\004jgnh\005jgnhe\004jgnl\005jgnle\005jgnlh\004"
    "jgnm\004jgno\005jgnop\004jgnp\004jgnz\003jgo\003jgp\003jgz\002jh\003jhe"
    "\002jl\003jle\003jlh\003jll\003jlm\004jlne\004jlnh\004jlnl\004jlnm\004j"
    "lno\005jlnop\004jlnp\004jlnz\003jlo\003jlp\003jlu\003jlz\002jm\003jne\003"
    "jnh\004jnhe\003jnl\004jnle\004jnlh\003jnm\003jno\004jnop\003jnp\003jnz\002"
    "jo\002jp\002jz\003kdb\004kdbr\004kdsa\004kdtr\003keb\004kebr\004kimd\004"
    "klmd\002km\003kma\004kmac\003kmc\005kmctr\003kmf\003kmo\004kxbr\004kxtr"
    "\001l\002la\003laa\004laag\004laal\005laalg\003lae\004laey\003lam\004la"
    "my\003lan\004lang\003lao\004laog\004larl\004lasp\003lat\003lax\004laxg\003"
    "lay\002lb\005lbear\003lbh\003lbr\004lcbb\005lcctl\005lcdbr\005lcdfr\004"
    "lcdr\005lcebr\004lcer\005lcgfr\004lcgr\003lcr\004lctl\005lctlg\005lcxbr"
    "\004lcxr\002ld\003lde\004ldeb\005ldebr\004lder\005ldetr\004ldgr\003ldr\004"
    "ldrv\005ldxbr\006ldxbra\004ldxr\005ldxtr\003ldy\002le\005ledbr\006ledbr"
    "a\004ledr\005ledtr\003ler\004lerv\005lexbr\006lexbra\004lexr\003ley\004"
    "lfas\003lfh\005lfhat\003lfi\004lfpc\002lg\004lgat\003lgb\004lgbr\004lgd"
    "r\003lgf\004lgfi\004lgfr\005lgfrl\003lgg\003lgh\004lghi\004lghr\005lghr"
    "l\003lgr\004lgrl\004lgsc\002lh\003lhh\003lhi\003lhr\004lhrl\003lhy\003l"
    "lc\004llch\004llcr\004llgc\005llgcr\004llgf\006llgfat\005llgfi\005llgfr"
    "\006llgfrl\006llgfsg\004llgh\005llghi\005llghr\006llghrl\004llgt\006llg"
    "tat\005llgtr\003llh\004llhh\004llhr\005llhrl\005llihf\005llihh\005llihl"
    "\005llilf\005llilh\005llill\005llxab\005llxaf\005llxag\005llxah\005llxa"
    "q\006llzrgf\002lm\003lmd\003lmg\003lmh\003lmy\005lndbr\005lndfr\004lndr"
    "\005lnebr\004lner\005lngfr\004lngr\003lnr\005lnxbr\004lnxr\003loc\004lo"
    "ce\005locfh\006locfhe\006locfhh\007locfhhe\006locfhl\007locfhle\007locf"
    "hlh\006locfhm\007locfhne\007locfhnh\010locfhnhe\007locfhnl\010locfhnle\010"
    "locfhnlh\007locfhnm\007locfhno\007locfhnp\007locfhnz\006locfho\006locfh"
    "p\006locfhr\007locfhre\007locfhrh\010locfhrhe\007locfhrl\010locfhrle\010"
    "locfhrlh\007locfhrm\010locfhrne\010locfhrnh\tlocfhrnhe\010locfhrnl\tloc"
    "fhrnle\tlocfhrnlh\010locfhrnm\010locfhrno\010locfhrnp\010locfhrnz\007lo"
    "cfhro\007locfhrp\007locfhrz\006locfhz\004locg\005locge\005locgh\006locg"
    "he\006locghi\007locghie\007locghih\010locghihe\007locghil\010locghile\010"
    "locghilh\007locghim\010locghine\010locghinh\tlocghinhe\010locghinl\tloc"
    "ghinle\tlocghinlh\010locghinm\010locghino\010locghinp\010locghinz\007lo"
    "cghio\007locghip\007locghiz\005locgl\006locgle\006locglh\005locgm\006lo"
    "cgne\006locgnh\007locgnhe\006locgnl\007locgnle\007locgnlh\006locgnm\006"
    "locgno\006locgnp\006locgnz\005locgo\005locgp\005locgr\006locgre\006locg"
    "rh\007locgrhe\006locgrl\007locgrle\007locgrlh\006locgrm\007locgrne\007l"
    "ocgrnh\010locgrnhe\007locgrnl\010locgrnle\010locgrnlh\007locgrnm\007loc"
    "grno\007locgrnp\007locgrnz\006locgro\006locgrp\006locgrz\005locgz\004lo"
    "ch\005loche\006lochhi\007lochhie\007lochhih\010lochhihe\007lochhil\010l"
    "ochhile\010lochhilh\007lochhim\010lochhine\010lochhinh\tlochhinhe\010lo"
    "chhinl\tlochhinle\tlochhinlh\010lochhinm\010lochhino\010lochhinp\010loc"
    "hhinz\007lochhio\007lochhip\007lochhiz\005lochi\006lochie\006lochih\007"
    "lochihe\006lochil\007lochile\007lochilh\006lochim\007lochine\007lochinh"
    "\010lochinhe\007lochinl\010lochinle\010lochinlh\007lochinm\007lochino\007"
    "lochinp\007lochinz\006lochio\006lochip\006lochiz\004locl\005locle\005lo"
    "clh\004locm\005locne\005locnh\006locnhe\005locnl\006locnle\006locnlh\005"
    "locnm\005locno\005locnp\005locnz\004loco\004locp\004locr\005locre\005lo"
    "crh\006locrhe\005locrl\006locrle\006locrlh\005locrm\006locrne\006locrnh"
    "\007locrnhe\006locrnl\007locrnle\007locrnlh\006locrnm\006locrno\006locr"
    "np\006locrnz\005locro\005locrp\005locrz\004locz\005lpctl\003lpd\005lpdb"
    "r\005lpdfr\004lpdg\004lpdr\005lpebr\004lper\005lpgfr\004lpgr\003lpp\003"
    "lpq\003lpr\004lpsw\005lpswe\006lpswey\005lptea\005lpxbr\004lpxr\002lr\003"
    "lra\004lrag\004lray\004lrdr\004lrer\003lrl\003lrv\004lrvg\005lrvgr\004l"
    "rvh\004lrvr\005lsctl\002lt\005ltdbr\004ltdr\005ltdtr\005ltebr\004lter\003"
    "ltg\004ltgf\005ltgfr\004ltgr\003ltr\005ltxbr\004ltxr\005ltxtr\004lura\005"
    "lurag\004lxab\004lxaf\004lxag\004lxah\004lxaq\003lxd\004lxdb\005lxdbr\004"
    "lxdr\005lxdtr\003lxe\004lxeb\005lxebr\004lxer\003lxr\002ly\004lzdr\004l"
    "zer\004lzrf\004lzrg\004lzxr\001m\003mad\004madb\005madbr\004madr\003mae"
    "\004maeb\005maebr\004maer\003may\004mayh\005mayhr\004mayl\005maylr\004m"
    "ayr\002mc\002md\003mdb\004mdbr\003mde\004mdeb\005mdebr\004mder\003mdr\004"
    "mdtr\005mdtra\002me\003mee\004meeb\005meebr\004meer\003mer\003mfy\002mg"
    "\003mgh\004mghi\004mgrk\002mh\003mhi\003mhy\002ml\003mlg\004mlgr\003mlr"
    "\002mp\002mr\002ms\003msc\004msch\003msd\004msdb\005msdbr\004msdr\003ms"
    "e\004mseb\005msebr\004mser\004msfi\003msg\004msgc\004msgf\005msgfi\005m"
    "sgfr\004msgr\006msgrkc\003msr\005msrkc\004msta\003msy\003mvc\005mvcdk\005"
    "mvcin\004mvck\004mvcl\005mvcle\005mvclu\005mvcos\004mvcp\005mvcrl\004mv"
    "cs\005mvcsk\005mvghi\005mvhhi\004mvhi\003mvi\004mviy\003mvn\003mvo\004m"
    "vpg\004mvst\003mvz\004mxbr\003mxd\004mxdb\005mxdbr\004mxdr\003mxr\004mx"
    "tr\005mxtra\002my\003myh\004myhr\003myl\004mylr\003myr\001n\002nc\005nc"
    "grk\004ncrk\002ng\003ngr\004ngrk\002ni\004niai\004nihf\004nihh\004nihl\004"
    "nilf\004nilh\004nill\003niy\005nngrk\004nnpa\004nnrk\005nogrk\003nop\004"
    "nopr\004nork\005notgr\004notr\002nr\003nrk\005ntstg\005nxgrk\004nxrk\002"
    "ny\001o\002oc\005ocgrk\004ocrk\002og\003ogr\004ogrk\002oi\004oihf\004oi"
    "hh\004oihl\004oilf\004oilh\004oill\003oiy\002or\003ork\002oy\004pack\004"
    "palb\002pc\003pcc\005pckmo\004pfcr\003pfd\005pfdrl\004pfmf\004pfpo\004p"
    "gin\005pgout\003pka\003pku\003plo\006popcnt\003ppa\004ppno\002pr\004prn"
    "o\002pt\003ptf\004ptff\003pti\004ptlb\005qadtr\005qaxtr\005qctri\005qpa"
    "ci\003qsi\004rchp\003rdp\005risbg\006risbgn\007risbgnz\006risbgz\006ris"
    "bhg\006risblg\003rll\004rllg\005rnsbg\005rosbg\002rp\004rrbe\004rrbm\005"
    "rrdtr\005rrxtr\004rsch\005rxsbg\001s\003sac\004sacf\003sal\005sam24\005"
    "sam31\005sam64\003sar\005scctr\004schm\003sck\004sckc\005sckpf\002sd\003"
    "sdb\004sdbr\003sdr\004sdtr\005sdtra\002se\003seb\004sebr\006selfhr\007s"
    "elfhre\007selfhrh\010selfhrhe\007selfhrl\010selfhrle\010selfhrlh\007sel"
    "fhrm\010selfhrne\010selfhrnh\tselfhrnhe\010selfhrnl\tselfhrnle\tselfhrn"
    "lh\010selfhrnm\010selfhrno\010selfhrnp\010selfhrnz\007selfhro\007selfhr"
    "p\007selfhrz\005selgr\006selgre\006selgrh\007selgrhe\006selgrl\007selgr"
    "le\007selgrlh\006selgrm\007selgrne\007selgrnh\010selgrnhe\007selgrnl\010"
    "selgrnle\010selgrnlh\007selgrnm\007selgrno\007selgrnp\007selgrnz\006sel"
    "gro\006selgrp\006selgrz\004selr\005selre\005selrh\006selrhe\005selrl\006"
    "selrle\006selrlh\005selrm\006selrne\006selrnh\007selrnhe\006selrnl\007s"
    "elrnle\007selrnlh\006selrnm\006selrno\006selrnp\006selrnz\005selro\005s"
    "elrp\005selrz\003ser\005sfasr\004sfpc\002sg\003sgf\004sgfr\003sgh\003sg"
    "r\004sgrk\002sh\005shhhr\005shhlr\003shy\003sie\004siga\004sigp\002sl\003"
    "sla\004slag\004slak\003slb\004slbg\005slbgr\004slbr\004slda\004sldl\004"
    "sldt\004slfi\003slg\004slgf\005slgfi\005slgfr\004slgr\005slgrk\006slhhh"
    "r\006slhhlr\003sll\004sllg\004sllk\003slr\004slrk\004slxt\003sly\005sor"
    "tl\002sp\005spctr\004spka\003spm\003spt\003spx\003sqd\004sqdb\005sqdbr\004"
    "sqdr\003sqe\004sqeb\005sqebr\004sqer\005sqxbr\004sqxr\002sr\003sra\004s"
    "rag\004srak\004srda\004srdl\004srdt\003srk\003srl\004srlg\004srlk\004sr"
    "nm\005srnmb\005srnmt\003srp\004srst\005srstu\004srxt\005ssair\004ssar\004"
    "ssch\004sske\003ssm\002st\004stam\005stamy\004stap\006stbear\003stc\004"
    "stch\004stck\005stckc\005stcke\005stckf\004stcm\005stcmh\005stcmy\005st"
    "cps\005stcrw\005stctg\005stctl\004stcy\003std\005stdrv\004stdy\003ste\005"
    "sterv\004stey\004stfh\004stfl\005stfle\005stfpc\003stg\005stgrl\005stgs"
    "c\003sth\004sthh\005sthrl\004sthy\005stidp\003stm\004stmg\004stmh\004st"
    "my\005stnsm\004stoc\005stoce\006stocfh\007stocfhe\007stocfhh\010stocfhh"
    "e\007stocfhl\010stocfhle\010stocfhlh\007stocfhm\010stocfhne\010stocfhnh"
    "\tstocfhnhe\010stocfhnl\tstocfhnle\tstocfhnlh\010stocfhnm\010stocfhno\010"
    "stocfhnp\010stocfhnz\007stocfho\007stocfhp\007stocfhz\005stocg\006stocg"
    "e\006stocgh\007stocghe\006stocgl\007stocgle\007stocglh\006stocgm\007sto"
    "cgne\007stocgnh\010stocgnhe\007stocgnl\010stocgnle\010stocgnlh\007stocg"
    "nm\007stocgno\007stocgnp\007stocgnz\006stocgo\006stocgp\006stocgz\005st"
    "och\006stoche\005stocl\006stocle\006stoclh\005stocm\006stocne\006stocnh"
    "\007stocnhe\006stocnl\007stocnle\007stocnlh\006stocnm\006stocno\006stoc"
    "np\006stocnz\005stoco\005stocp\005stocz\005stosm\004stpq\004stpt\004stp"
    "x\005strag\004strl\004strv\005strvg\005strvh\005stsch\004stsi\005stura\005"
    "sturg\003sty\002su\003sur\003svc\002sw\003swr\004sxbr\003sxr\004sxtr\005"
    "sxtra\002sy\006tabort\003tam\003tar\002tb\004tbdr\005tbedr\006tbegin\007"
    "tbeginc\004tcdb\004tceb\004tcxb\005tdcdt\005tdcet\005tdcxt\005tdgdt\005"
    "tdget\005tdgxt\004tend\005thder\004thdr\002tm\003tmh\004tmhh\004tmhl\003"
    "tml\004tmlh\004tmll\003tmy\002tp\004tpei\003tpi\005tprot\002tr\005trace"
    "\005tracg\005trap2\005trap4\003tre\004troo\004trot\003trt\004trte\004tr"
    "to\004trtr\005trtre\004trtt\002ts\004tsch\004unpk\005unpka\005unpku\003"
    "upt\002va\003vab\003vac\004vacc\005vaccb\005vaccc\006vacccq\005vaccf\005"
    "vaccg\005vacch\005vaccq\004vacq\003vaf\003vag\003vah\003vap\003vaq\004v"
    "avg\005vavgb\005vavgf\005vavgg\005vavgh\005vavgl\006vavglb\006vavglf\006"
    "vavglg\006vavglh\006vavglq\005vavgq\006vblend\007vblendb\007vblendf\007"
    "vblendg\007vblendh\007vblendq\006vbperm\004vcdg\005vcdgb\005vcdlg\006vc"
    "dlgb\005vcefb\006vcelfb\004vceq\005vceqb\006vceqbs\005vceqf\006vceqfs\005"
    "vceqg\006vceqgs\005vceqh\006vceqhs\005vceqq\006vceqqs\005vcfeb\004vcfn\005"
    "vcfpl\005vcfps\004vcgd\005vcgdb\003vch\004vchb\005vchbs\004vchf\005vchf"
    "s\004vchg\005vchgs\004vchh\005vchhs\004vchl\005vchlb\006vchlbs\005vchlf"
    "\006vchlfs\005vchlg\006vchlgs\005vchlh\006vchlhs\005vchlq\006vchlqs\004"
    "vchq\005vchqs\005vcksm\006vclfeb\006vclfnh\006vclfnl\005vclfp\005vclgd\006"
    "vclgdb\004vclz\005vclzb\006vclzdp\005vclzf\005vclzg\005vclzh\005vclzq\004"
    "vcnf\003vcp\005vcrnf\005vcsfp\005vcsph\004vctz\005vctzb\005vctzf\005vct"
    "zg\005vctzh\005vctzq\004vcvb\005vcvbg\005vcvbq\004vcvd\005vcvdg\005vcvd"
    "q\002vd\003vdf\003vdg\003vdl\004vdlf\004vdlg\004vdlq\003vdp\003vdq\003v"
    "ec\004vecb\004vecf\004vecg\004vech\004vecl\005veclb\005veclf\005veclg\005"
    "veclh\005veclq\004vecq\005verim\006verimb\006verimf\006verimg\006verimh"
    "\005verll\006verllb\006verllf\006verllg\006verllh\006verllv\007verllvb\007"
    "verllvf\007verllvg\007verllvh\004vesl\005veslb\005veslf\005veslg\005ves"
    "lh\005veslv\006veslvb\006veslvf\006veslvg\006veslvh\005vesra\006vesrab\006"
    "vesraf\006vesrag\006vesrah\006vesrav\007vesravb\007vesravf\007vesravg\007"
    "vesravh\005vesrl\006vesrlb\006vesrlf\006vesrlg\006vesrlh\006vesrlv\007v"
    "esrlvb\007vesrlvf\007vesrlvg\007vesrlvh\005veval\003vfa\005vfadb\004vfa"
    "e\005vfaeb\006vfaebs\005vfaef\006vfaefs\005vfaeh\006vfaehs\006vfaezb\007"
    "vfaezbs\006vfaezf\007vfaezfs\006vfaezh\007vfaezhs\005vfasb\004vfce\006v"
    "fcedb\007vfcedbs\006vfcesb\007vfcesbs\004vfch\006vfchdb\007vfchdbs\005v"
    "fche\007vfchedb\010vfchedbs\007vfchesb\010vfchesbs\006vfchsb\007vfchsbs"
    "\003vfd\005vfddb\005vfdsb\004vfee\005vfeeb\006vfeebs\005vfeef\006vfeefs"
    "\005vfeeh\006vfeehs\006vfeezb\007vfeezbs\006vfeezf\007vfeezfs\006vfeezh"
    "\007vfeezhs\005vfene\006vfeneb\007vfenebs\006vfenef\007vfenefs\006vfene"
    "h\007vfenehs\007vfenezb\010vfenezbs\007vfenezf\010vfenezfs\007vfenezh\010"
    "vfenezhs\003vfi\005vfidb\005vfisb\006vfkedb\007vfkedbs\006vfkesb\007vfk"
    "esbs\006vfkhdb\007vfkhdbs\007vfkhedb\010vfkhedbs\007vfkhesb\010vfkhesbs"
    "\006vfkhsb\007vfkhsbs\006vflcdb\006vflcsb\004vfll\005vflls\006vflndb\006"
    "vflnsb\006vflpdb\006vflpsb\004vflr\005vflrd\003vfm\004vfma\006vfmadb\006"
    "vfmasb\005vfmax\007vfmaxdb\007vfmaxsb\005vfmdb\005vfmin\007vfmindb\007v"
    "fminsb\004vfms\005vfmsb\006vfmsdb\006vfmssb\005vfnma\007vfnmadb\007vfnm"
    "asb\005vfnms\007vfnmsdb\007vfnmssb\005vfpso\007vfpsodb\007vfpsosb\003vf"
    "s\005vfsdb\004vfsq\006vfsqdb\006vfsqsb\005vfssb\005vftci\007vftcidb\007"
    "vftcisb\004vgbm\004vgef\004vgeg\004vgem\005vgemb\005vgemf\005vgemg\005v"
    "gemh\005vgemq\004vgfm\005vgfma\006vgfmab\006vgfmaf\006vgfmag\006vgfmah\005"
    "vgfmb\005vgfmf\005vgfmg\005vgfmh\003vgm\004vgmb\004vgmf\004vgmg\004vgmh"
    "\005vistr\006vistrb\007vistrbs\006vistrf\007vistrfs\006vistrh\007vistrh"
    "s\002vl\004vlbb\004vlbr\005vlbrf\005vlbrg\005vlbrh\005vlbrq\007vlbrrep\010"
    "vlbrrepf\010vlbrrepg\010vlbrreph\003vlc\004vlcb\004vlcf\004vlcg\004vlch"
    "\004vlcq\004vlde\005vldeb\004vleb\006vlebrf\006vlebrg\006vlebrh\004vled"
    "\005vledb\004vlef\004vleg\004vleh\005vleib\005vleif\005vleig\005vleih\004"
    "vler\005vlerf\005vlerg\005vlerh\004vlgv\005vlgvb\005vlgvf\005vlgvg\005v"
    "lgvh\004vlip\003vll\007vllebrz\010vllebrze\010vllebrzf\010vllebrzg\010v"
    "llebrzh\005vllez\006vllezb\006vllezf\006vllezg\006vllezh\007vllezlf\003"
    "vlm\003vlp\004vlpb\004vlpf\004vlpg\004vlph\004vlpq\003vlr\005vlrep\006v"
    "lrepb\006vlrepf\006vlrepg\006vlreph\004vlrl\005vlrlr\004vlvg\005vlvgb\005"
    "vlvgf\005vlvgg\005vlvgh\005vlvgp\004vmae\005vmaeb\005vmaef\005vmaeg\005"
    "vmaeh\004vmah\005vmahb\005vmahf\005vmahg\005vmahh\005vmahq\004vmal\005v"
    "malb\005vmale\006vmaleb\006vmalef\006vmaleg\006vmaleh\005vmalf\005vmalg"
    "\005vmalh\006vmalhb\006vmalhf\006vmalhg\006vmalhh\006vmalhq\006vmalhw\005"
    "vmalo\006vmalob\006vmalof\006vmalog\006vmaloh\005vmalq\004vmao\005vmaob"
    "\005vmaof\005vmaog\005vmaoh\003vme\004vmeb\004vmef\004vmeg\004vmeh\003v"
    "mh\004vmhb\004vmhf\004vmhg\004vmhh\004vmhq\003vml\004vmlb\004vmle\005vm"
    "leb\005vmlef\005vmleg\005vmleh\004vmlf\004vmlg\004vmlh\005vmlhb\005vmlh"
    "f\005vmlhg\005vmlhh\005vmlhq\005vmlhw\004vmlo\005vmlob\005vmlof\005vmlo"
    "g\005vmloh\004vmlq\003vmn\004vmnb\004vmnf\004vmng\004vmnh\004vmnl\005vm"
    "nlb\005vmnlf\005vmnlg\005vmnlh\005vmnlq\004vmnq\003vmo\004vmob\004vmof\004"
    "vmog\004vmoh\003vmp\004vmrh\005vmrhb\005vmrhf\005vmrhg\005vmrhh\004vmrl"
    "\005vmrlb\005vmrlf\005vmrlg\005vmrlh\004vmsl\005vmslg\004vmsp\003vmx\004"
    "vmxb\004vmxf\004vmxg\004vmxh\004vmxl\005vmxlb\005vmxlf\005vmxlg\005vmxl"
    "h\005vmxlq\004vmxq\002vn\003vnc\003vnn\003vno\004vnot\003vnx\002vo\003v"
    "oc\004vone\004vpdi\005vperm\003vpk\004vpkf\004vpkg\004vpkh\005vpkls\006"
    "vpklsf\007vpklsfs\006vpklsg\007vpklsgs\006vpklsh\007vpklshs\004vpks\005"
    "vpksf\006vpksfs\005vpksg\006vpksgs\005vpksh\006vpkshs\004vpkz\005vpkzr\006"
    "vpopct\007vpopctb\007vpopctf\007vpopctg\007vpopcth\005vpsop\002vr\004vr"
    "ep\005vrepb\005vrepf\005vrepg\005vreph\005vrepi\006vrepib\006vrepif\006"
    "vrepig\006vrepih\003vrf\003vrg\003vrl\004vrlf\004vrlg\004vrlq\003vrp\003"
    "vrq\002vs\003vsb\006vsbcbi\007vsbcbiq\004vsbi\005vsbiq\005vscbi\006vscb"
    "ib\006vscbif\006vscbig\006vscbih\006vscbiq\005vscef\005vsceg\006vschdp\005"
    "vschp\006vschsp\006vschxp\006vscshp\004vsdp\004vseg\005vsegb\005vsegf\005"
    "vsegh\004vsel\003vsf\003vsg\003vsh\003vsl\004vslb\004vsld\005vsldb\003v"
    "sp\003vsq\004vsra\005vsrab\004vsrd\004vsrl\005vsrlb\004vsrp\005vsrpr\003"
    "vst\005vstbr\006vstbrf\006vstbrg\006vstbrh\006vstbrq\005vsteb\007vstebr"
    "f\007vstebrg\007vstebrh\005vstef\005vsteg\005vsteh\005vster\006vsterf\006"
    "vsterg\006vsterh\004vstl\004vstm\005vstrc\006vstrcb\007vstrcbs\006vstrc"
    "f\007vstrcfs\006vstrch\007vstrchs\007vstrczb\010vstrczbs\007vstrczf\010"
    "vstrczfs\007vstrczh\010vstrczhs\005vstrl\006vstrlr\005vstrs\006vstrsb\006"
    "vstrsf\006vstrsh\007vstrszb\007vstrszf\007vstrszh\004vsum\005vsumb\005v"
    "sumg\006vsumgf\006vsumgh\005vsumh\005vsumq\006vsumqf\006vsumqg\003vtm\003"
    "vtp\003vtz\004vuph\005vuphb\005vuphf\005vuphg\005vuphh\005vupkz\006vupk"
    "zh\006vupkzl\004vupl\005vuplb\005vuplf\005vuplg\005vuplh\006vuplhb\006v"
    "uplhf\006vuplhg\006vuplhh\006vuplhw\005vupll\006vupllb\006vupllf\006vup"
    "llg\006vupllh\002vx\005vzero\005wcdgb\006wcdlgb\005wcefb\006wcelfb\005w"
    "cfeb\005wcgdb\006wclfeb\006wclgdb\005wfadb\005wfasb\005wfaxb\003wfc\005"
    "wfcdb\006wfcedb\007wfcedbs\006wfcesb\007wfcesbs\006wfcexb\007wfcexbs\006"
    "wfchdb\007wfchdbs\007wfchedb\010wfchedbs\007wfchesb\010wfchesbs\007wfch"
    "exb\010wfchexbs\006wfchsb\007wfchsbs\006wfchxb\007wfchxbs\005wfcsb\005w"
    "fcxb\005wfddb\005wfdsb\005wfdxb\005wfidb\005wfisb\005wfixb\003wfk\005wf"
    "kdb\006wfkedb\007wfkedbs\006wfkesb\007wfkesbs\006wfkexb\007wfkexbs\006w"
    "fkhdb\007wfkhdbs\007wfkhedb\010wfkhedbs\007wfkhesb\010wfkhesbs\007wfkhe"
    "xb\010wfkhexbs\006wfkhsb\007wfkhsbs\006wfkhxb\007wfkhxbs\005wfksb\005wf"
    "kxb\006wflcdb\006wflcsb\006wflcxb\005wflld\005wflls\006wflndb\006wflnsb"
    "\006wflnxb\006wflpdb\006wflpsb\006wflpxb\005wflrd\005wflrx\006wfmadb\006"
    "wfmasb\006wfmaxb\007wfmaxdb\007wfmaxsb\007wfmaxxb\005wfmdb\007wfmindb\007"
    "wfminsb\007wfminxb\005wfmsb\006wfmsdb\006wfmssb\006wfmsxb\005wfmxb\007w"
    "fnmadb\007wfnmasb\007wfnmaxb\007wfnmsdb\007wfnmssb\007wfnmsxb\007wfpsod"
    "b\007wfpsosb\007wfpsoxb\005wfsdb\006wfsqdb\006wfsqsb\006wfsqxb\005wfssb"
    "\005wfsxb\007wftcidb\007wftcisb\007wftcixb\005wldeb\005wledb\001x\002xc"
    "\002xg\003xgr\004xgrk\002xi\004xihf\004xilf\003xiy\002xr\003xrk\004xsch"
    "\002xy\003zap";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_FeatureBEAREnhancement,
  AMFBS_FeatureConcurrentFunctions,
  AMFBS_FeatureDFPPackedConversion,
  AMFBS_FeatureDFPZonedConversion,
  AMFBS_FeatureDeflateConversion,
  AMFBS_FeatureDistinctOps,
  AMFBS_FeatureEnhancedDAT2,
  AMFBS_FeatureEnhancedSort,
  AMFBS_FeatureExecutionHint,
  AMFBS_FeatureFPExtension,
  AMFBS_FeatureGuardedStorage,
  AMFBS_FeatureHighWord,
  AMFBS_FeatureInsertReferenceBitsMultiple,
  AMFBS_FeatureInterlockedAccess1,
  AMFBS_FeatureLoadAndTrap,
  AMFBS_FeatureLoadAndZeroRightmostByte,
  AMFBS_FeatureLoadStoreOnCond,
  AMFBS_FeatureLoadStoreOnCond2,
  AMFBS_FeatureMessageSecurityAssist12,
  AMFBS_FeatureMessageSecurityAssist3,
  AMFBS_FeatureMessageSecurityAssist4,
  AMFBS_FeatureMessageSecurityAssist5,
  AMFBS_FeatureMessageSecurityAssist7,
  AMFBS_FeatureMessageSecurityAssist8,
  AMFBS_FeatureMessageSecurityAssist9,
  AMFBS_FeatureMiscellaneousExtensions,
  AMFBS_FeatureMiscellaneousExtensions2,
  AMFBS_FeatureMiscellaneousExtensions3,
  AMFBS_FeatureMiscellaneousExtensions4,
  AMFBS_FeatureNNPAssist,
  AMFBS_FeaturePopulationCount,
  AMFBS_FeatureProcessorActivityInstrumentation,
  AMFBS_FeatureProcessorAssist,
  AMFBS_FeatureResetDATProtection,
  AMFBS_FeatureResetReferenceBitsMultiple,
  AMFBS_FeatureTestPendingExternalInterruption,
  AMFBS_FeatureTransactionalExecution,
  AMFBS_FeatureVector,
  AMFBS_FeatureVectorEnhancements1,
  AMFBS_FeatureVectorEnhancements2,
  AMFBS_FeatureVectorEnhancements3,
  AMFBS_FeatureVectorPackedDecimal,
  AMFBS_FeatureVectorPackedDecimalEnhancement,
  AMFBS_FeatureVectorPackedDecimalEnhancement2,
  AMFBS_FeatureVectorPackedDecimalEnhancement3,
  AMFBS_FeatureVector_FeatureNNPAssist,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_FeatureBEAREnhancementBit, },
  {Feature_FeatureConcurrentFunctionsBit, },
  {Feature_FeatureDFPPackedConversionBit, },
  {Feature_FeatureDFPZonedConversionBit, },
  {Feature_FeatureDeflateConversionBit, },
  {Feature_FeatureDistinctOpsBit, },
  {Feature_FeatureEnhancedDAT2Bit, },
  {Feature_FeatureEnhancedSortBit, },
  {Feature_FeatureExecutionHintBit, },
  {Feature_FeatureFPExtensionBit, },
  {Feature_FeatureGuardedStorageBit, },
  {Feature_FeatureHighWordBit, },
  {Feature_FeatureInsertReferenceBitsMultipleBit, },
  {Feature_FeatureInterlockedAccess1Bit, },
  {Feature_FeatureLoadAndTrapBit, },
  {Feature_FeatureLoadAndZeroRightmostByteBit, },
  {Feature_FeatureLoadStoreOnCondBit, },
  {Feature_FeatureLoadStoreOnCond2Bit, },
  {Feature_FeatureMessageSecurityAssist12Bit, },
  {Feature_FeatureMessageSecurityAssist3Bit, },
  {Feature_FeatureMessageSecurityAssist4Bit, },
  {Feature_FeatureMessageSecurityAssist5Bit, },
  {Feature_FeatureMessageSecurityAssist7Bit, },
  {Feature_FeatureMessageSecurityAssist8Bit, },
  {Feature_FeatureMessageSecurityAssist9Bit, },
  {Feature_FeatureMiscellaneousExtensionsBit, },
  {Feature_FeatureMiscellaneousExtensions2Bit, },
  {Feature_FeatureMiscellaneousExtensions3Bit, },
  {Feature_FeatureMiscellaneousExtensions4Bit, },
  {Feature_FeatureNNPAssistBit, },
  {Feature_FeaturePopulationCountBit, },
  {Feature_FeatureProcessorActivityInstrumentationBit, },
  {Feature_FeatureProcessorAssistBit, },
  {Feature_FeatureResetDATProtectionBit, },
  {Feature_FeatureResetReferenceBitsMultipleBit, },
  {Feature_FeatureTestPendingExternalInterruptionBit, },
  {Feature_FeatureTransactionalExecutionBit, },
  {Feature_FeatureVectorBit, },
  {Feature_FeatureVectorEnhancements1Bit, },
  {Feature_FeatureVectorEnhancements2Bit, },
  {Feature_FeatureVectorEnhancements3Bit, },
  {Feature_FeatureVectorPackedDecimalBit, },
  {Feature_FeatureVectorPackedDecimalEnhancementBit, },
  {Feature_FeatureVectorPackedDecimalEnhancement2Bit, },
  {Feature_FeatureVectorPackedDecimalEnhancement3Bit, },
  {Feature_FeatureVectorBit, Feature_FeatureNNPAssistBit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint8_t Classes[6];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 1 /* a */, SystemZ::A, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 3 /* ad */, SystemZ::AD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 6 /* adb */, SystemZ::ADB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10 /* adbr */, SystemZ::ADBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 15 /* adr */, SystemZ::ADR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 19 /* adtr */, SystemZ::ADTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 24 /* adtra */, SystemZ::ADTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 30 /* ae */, SystemZ::AE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 33 /* aeb */, SystemZ::AEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 37 /* aebr */, SystemZ::AEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 42 /* aer */, SystemZ::AER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 46 /* afi */, SystemZ::AFI, Convert__GR321_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 50 /* ag */, SystemZ::AG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 53 /* agf */, SystemZ::AGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 57 /* agfi */, SystemZ::AGFI, Convert__GR641_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 62 /* agfr */, SystemZ::AGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 67 /* agh */, SystemZ::AGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 71 /* aghi */, SystemZ::AGHI, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 76 /* aghik */, SystemZ::AGHIK, Convert__GR641_0__GR641_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_S16Imm }, },
  { 82 /* agr */, SystemZ::AGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 86 /* agrk */, SystemZ::AGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 91 /* agsi */, SystemZ::AGSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 96 /* ah */, SystemZ::AH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 99 /* ahhhr */, SystemZ::AHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 105 /* ahhlr */, SystemZ::AHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 111 /* ahi */, SystemZ::AHI, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 115 /* ahik */, SystemZ::AHIK, Convert__GR321_0__GR321_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_S16Imm }, },
  { 120 /* ahy */, SystemZ::AHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 124 /* aih */, SystemZ::AIH, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 128 /* al */, SystemZ::AL, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 131 /* alc */, SystemZ::ALC, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 135 /* alcg */, SystemZ::ALCG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 140 /* alcgr */, SystemZ::ALCGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 146 /* alcr */, SystemZ::ALCR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 151 /* alfi */, SystemZ::ALFI, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 156 /* alg */, SystemZ::ALG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 160 /* algf */, SystemZ::ALGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 165 /* algfi */, SystemZ::ALGFI, Convert__GR641_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 171 /* algfr */, SystemZ::ALGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 177 /* alghsik */, SystemZ::ALGHSIK, Convert__GR641_0__GR641_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_S16Imm }, },
  { 185 /* algr */, SystemZ::ALGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 190 /* algrk */, SystemZ::ALGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 196 /* algsi */, SystemZ::ALGSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 202 /* alhhhr */, SystemZ::ALHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 209 /* alhhlr */, SystemZ::ALHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 216 /* alhsik */, SystemZ::ALHSIK, Convert__GR321_0__GR321_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_S16Imm }, },
  { 223 /* alr */, SystemZ::ALR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 227 /* alrk */, SystemZ::ALRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 232 /* alsi */, SystemZ::ALSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 237 /* alsih */, SystemZ::ALSIH, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 243 /* alsihn */, SystemZ::ALSIHN, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 250 /* aly */, SystemZ::ALY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 254 /* ap */, SystemZ::AP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 257 /* ar */, SystemZ::AR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 260 /* ark */, SystemZ::ARK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 264 /* asi */, SystemZ::ASI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 268 /* au */, SystemZ::AU, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 271 /* aur */, SystemZ::AUR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 275 /* aw */, SystemZ::AW, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 278 /* awr */, SystemZ::AWR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 282 /* axbr */, SystemZ::AXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 287 /* axr */, SystemZ::AXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 291 /* axtr */, SystemZ::AXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 296 /* axtra */, SystemZ::AXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 302 /* ay */, SystemZ::AY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 305 /* b */, SystemZ::B, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 307 /* bakr */, SystemZ::BAKR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 312 /* bal */, SystemZ::BAL, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 316 /* balr */, SystemZ::BALR, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 321 /* bas */, SystemZ::BAS, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 325 /* basr */, SystemZ::BASR, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 330 /* bassm */, SystemZ::BASSM, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 336 /* bc */, SystemZ::BCAsm, Convert__U4Imm1_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_U4Imm, MCK_BDXAddr64Disp12 }, },
  { 339 /* bcr */, SystemZ::BCRAsm, Convert__U4Imm1_0__GR641_1, AMFBS_None, { MCK_U4Imm, MCK_GR64 }, },
  { 343 /* bct */, SystemZ::BCT, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 347 /* bctg */, SystemZ::BCTG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 352 /* bctgr */, SystemZ::BCTGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 358 /* bctr */, SystemZ::BCTR, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 363 /* bdepg */, SystemZ::BDEPG, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 369 /* be */, SystemZ::BAsmE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 372 /* ber */, SystemZ::BRAsmE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 376 /* bextg */, SystemZ::BEXTG, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 382 /* bh */, SystemZ::BAsmH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 385 /* bhe */, SystemZ::BAsmHE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 389 /* bher */, SystemZ::BRAsmHE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 394 /* bhr */, SystemZ::BRAsmH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 398 /* bi */, SystemZ::BI, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 401 /* bic */, SystemZ::BICAsm, Convert__U4Imm1_0__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_U4Imm, MCK_BDXAddr64Disp20 }, },
  { 405 /* bie */, SystemZ::BIAsmE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 409 /* bih */, SystemZ::BIAsmH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 413 /* bihe */, SystemZ::BIAsmHE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 418 /* bil */, SystemZ::BIAsmL, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 422 /* bile */, SystemZ::BIAsmLE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 427 /* bilh */, SystemZ::BIAsmLH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 432 /* bim */, SystemZ::BIAsmM, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 436 /* bine */, SystemZ::BIAsmNE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 441 /* binh */, SystemZ::BIAsmNH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 446 /* binhe */, SystemZ::BIAsmNHE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 452 /* binl */, SystemZ::BIAsmNL, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 457 /* binle */, SystemZ::BIAsmNLE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 463 /* binlh */, SystemZ::BIAsmNLH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 469 /* binm */, SystemZ::BIAsmNM, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 474 /* bino */, SystemZ::BIAsmNO, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 479 /* binp */, SystemZ::BIAsmNP, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 484 /* binz */, SystemZ::BIAsmNZ, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 489 /* bio */, SystemZ::BIAsmO, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 493 /* bip */, SystemZ::BIAsmP, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 497 /* biz */, SystemZ::BIAsmZ, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 501 /* bl */, SystemZ::BAsmL, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 504 /* ble */, SystemZ::BAsmLE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 508 /* bler */, SystemZ::BRAsmLE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 513 /* blh */, SystemZ::BAsmLH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 517 /* blhr */, SystemZ::BRAsmLH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 522 /* blr */, SystemZ::BRAsmL, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 526 /* bm */, SystemZ::BAsmM, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 529 /* bmr */, SystemZ::BRAsmM, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 533 /* bne */, SystemZ::BAsmNE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 537 /* bner */, SystemZ::BRAsmNE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 542 /* bnh */, SystemZ::BAsmNH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 546 /* bnhe */, SystemZ::BAsmNHE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 551 /* bnher */, SystemZ::BRAsmNHE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 557 /* bnhr */, SystemZ::BRAsmNH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 562 /* bnl */, SystemZ::BAsmNL, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 566 /* bnle */, SystemZ::BAsmNLE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 571 /* bnler */, SystemZ::BRAsmNLE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 577 /* bnlh */, SystemZ::BAsmNLH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 582 /* bnlhr */, SystemZ::BRAsmNLH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 588 /* bnlr */, SystemZ::BRAsmNL, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 593 /* bnm */, SystemZ::BAsmNM, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 597 /* bnmr */, SystemZ::BRAsmNM, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 602 /* bno */, SystemZ::BAsmNO, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 606 /* bnor */, SystemZ::BRAsmNO, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 611 /* bnp */, SystemZ::BAsmNP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 615 /* bnpr */, SystemZ::BRAsmNP, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 620 /* bnz */, SystemZ::BAsmNZ, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 624 /* bnzr */, SystemZ::BRAsmNZ, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 629 /* bo */, SystemZ::BAsmO, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 632 /* bor */, SystemZ::BRAsmO, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 636 /* bp */, SystemZ::BAsmP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 639 /* bpp */, SystemZ::BPP, Convert__U4Imm1_0__PCRel161_1__BDAddr64Disp122_2, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_PCRel16, MCK_BDAddr64Disp12 }, },
  { 643 /* bpr */, SystemZ::BRAsmP, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 647 /* bprp */, SystemZ::BPRP, Convert__U4Imm1_0__PCRel121_1__PCRel241_2, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_PCRel12, MCK_PCRel24 }, },
  { 652 /* br */, SystemZ::BR, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 655 /* bras */, SystemZ::BRAS, Convert__GR641_0__PCRelTLS162_1, AMFBS_None, { MCK_GR64, MCK_PCRelTLS16 }, },
  { 660 /* brasl */, SystemZ::BRASL, Convert__GR641_0__PCRelTLS322_1, AMFBS_None, { MCK_GR64, MCK_PCRelTLS32 }, },
  { 666 /* brc */, SystemZ::BRCAsm, Convert__U4Imm1_0__PCRel161_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel16 }, },
  { 670 /* brcl */, SystemZ::BRCLAsm, Convert__U4Imm1_0__PCRel321_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel32 }, },
  { 675 /* brct */, SystemZ::BRCT, Convert__GR321_0__Tie0_1_1__PCRel161_1, AMFBS_None, { MCK_GR32, MCK_PCRel16 }, },
  { 680 /* brctg */, SystemZ::BRCTG, Convert__GR641_0__Tie0_1_1__PCRel161_1, AMFBS_None, { MCK_GR64, MCK_PCRel16 }, },
  { 686 /* brcth */, SystemZ::BRCTH, Convert__GRH321_0__Tie0_1_1__PCRel321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_PCRel32 }, },
  { 692 /* brxh */, SystemZ::BRXH, Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 697 /* brxhg */, SystemZ::BRXHG, Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 703 /* brxle */, SystemZ::BRXLE, Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 709 /* brxlg */, SystemZ::BRXLG, Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 715 /* bsa */, SystemZ::BSA, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 719 /* bsg */, SystemZ::BSG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 723 /* bsm */, SystemZ::BSM, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 727 /* bxh */, SystemZ::BXH, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 731 /* bxhg */, SystemZ::BXHG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 736 /* bxle */, SystemZ::BXLE, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 741 /* bxleg */, SystemZ::BXLEG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 747 /* bz */, SystemZ::BAsmZ, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 750 /* bzr */, SystemZ::BRAsmZ, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 754 /* c */, SystemZ::C, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 756 /* cal */, SystemZ::CAL, Convert__GR321_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR32, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 760 /* calg */, SystemZ::CALG, Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 765 /* calgf */, SystemZ::CALGF, Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 771 /* cd */, SystemZ::CD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 774 /* cdb */, SystemZ::CDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 778 /* cdbr */, SystemZ::CDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 783 /* cdfbr */, SystemZ::CDFBR, Convert__FP641_0__GR321_1, AMFBS_None, { MCK_FP64, MCK_GR32 }, },
  { 789 /* cdfbra */, SystemZ::CDFBRA, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 796 /* cdfr */, SystemZ::CDFR, Convert__FP641_0__GR321_1, AMFBS_None, { MCK_FP64, MCK_GR32 }, },
  { 801 /* cdftr */, SystemZ::CDFTR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 807 /* cdgbr */, SystemZ::CDGBR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 813 /* cdgbra */, SystemZ::CDGBRA, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 820 /* cdgr */, SystemZ::CDGR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 825 /* cdgtr */, SystemZ::CDGTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 831 /* cdgtra */, SystemZ::CDGTRA, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 838 /* cdlfbr */, SystemZ::CDLFBR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 845 /* cdlftr */, SystemZ::CDLFTR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 852 /* cdlgbr */, SystemZ::CDLGBR, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 859 /* cdlgtr */, SystemZ::CDLGTR, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 866 /* cdpt */, SystemZ::CDPT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 871 /* cdr */, SystemZ::CDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 875 /* cds */, SystemZ::CDS, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp12 }, },
  { 879 /* cdsg */, SystemZ::CDSG, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp20 }, },
  { 884 /* cdstr */, SystemZ::CDSTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 890 /* cdsy */, SystemZ::CDSY, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp20 }, },
  { 895 /* cdtr */, SystemZ::CDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 900 /* cdutr */, SystemZ::CDUTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 906 /* cdzt */, SystemZ::CDZT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 911 /* ce */, SystemZ::CE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 914 /* ceb */, SystemZ::CEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 918 /* cebr */, SystemZ::CEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 923 /* cedtr */, SystemZ::CEDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 929 /* cefbr */, SystemZ::CEFBR, Convert__FP321_0__GR321_1, AMFBS_None, { MCK_FP32, MCK_GR32 }, },
  { 935 /* cefbra */, SystemZ::CEFBRA, Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 942 /* cefr */, SystemZ::CEFR, Convert__FP321_0__GR321_1, AMFBS_None, { MCK_FP32, MCK_GR32 }, },
  { 947 /* cegbr */, SystemZ::CEGBR, Convert__FP321_0__GR641_1, AMFBS_None, { MCK_FP32, MCK_GR64 }, },
  { 953 /* cegbra */, SystemZ::CEGBRA, Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 960 /* cegr */, SystemZ::CEGR, Convert__FP321_0__GR641_1, AMFBS_None, { MCK_FP32, MCK_GR64 }, },
  { 965 /* celfbr */, SystemZ::CELFBR, Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 972 /* celgbr */, SystemZ::CELGBR, Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 979 /* cer */, SystemZ::CER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 983 /* cextr */, SystemZ::CEXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 989 /* cfc */, SystemZ::CFC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 993 /* cfdbr */, SystemZ::CFDBR, Convert__GR321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP64 }, },
  { 999 /* cfdbra */, SystemZ::CFDBRA, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1006 /* cfdr */, SystemZ::CFDR, Convert__GR321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP64 }, },
  { 1011 /* cfdtr */, SystemZ::CFDTR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1017 /* cfebr */, SystemZ::CFEBR, Convert__GR321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP32 }, },
  { 1023 /* cfebra */, SystemZ::CFEBRA, Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 1030 /* cfer */, SystemZ::CFER, Convert__GR321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP32 }, },
  { 1035 /* cfi */, SystemZ::CFI, Convert__GR321_0__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 1039 /* cfxbr */, SystemZ::CFXBR, Convert__GR321_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP128 }, },
  { 1045 /* cfxbra */, SystemZ::CFXBRA, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1052 /* cfxr */, SystemZ::CFXR, Convert__GR321_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP128 }, },
  { 1057 /* cfxtr */, SystemZ::CFXTR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1063 /* cg */, SystemZ::CG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1066 /* cgdbr */, SystemZ::CGDBR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1072 /* cgdbra */, SystemZ::CGDBRA, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1079 /* cgdr */, SystemZ::CGDR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1084 /* cgdtr */, SystemZ::CGDTR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1090 /* cgdtra */, SystemZ::CGDTRA, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1097 /* cgebr */, SystemZ::CGEBR, Convert__GR641_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP32 }, },
  { 1103 /* cgebra */, SystemZ::CGEBRA, Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 1110 /* cger */, SystemZ::CGER, Convert__GR641_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP32 }, },
  { 1115 /* cgf */, SystemZ::CGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1119 /* cgfi */, SystemZ::CGFI, Convert__GR641_0__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 1124 /* cgfr */, SystemZ::CGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 1129 /* cgfrl */, SystemZ::CGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1135 /* cgh */, SystemZ::CGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1139 /* cghi */, SystemZ::CGHI, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1144 /* cghrl */, SystemZ::CGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1150 /* cghsi */, SystemZ::CGHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1156 /* cgib */, SystemZ::CGIBAsm, Convert__GR641_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1161 /* cgibe */, SystemZ::CGIBAsmE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1167 /* cgibh */, SystemZ::CGIBAsmH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1173 /* cgibhe */, SystemZ::CGIBAsmHE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1180 /* cgibl */, SystemZ::CGIBAsmL, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1186 /* cgible */, SystemZ::CGIBAsmLE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1193 /* cgiblh */, SystemZ::CGIBAsmLH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1200 /* cgibne */, SystemZ::CGIBAsmNE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1207 /* cgibnh */, SystemZ::CGIBAsmNH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1214 /* cgibnhe */, SystemZ::CGIBAsmNHE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1222 /* cgibnl */, SystemZ::CGIBAsmNL, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1229 /* cgibnle */, SystemZ::CGIBAsmNLE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1237 /* cgibnlh */, SystemZ::CGIBAsmNLH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1245 /* cgij */, SystemZ::CGIJAsm, Convert__GR641_0__S8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 1250 /* cgije */, SystemZ::CGIJAsmE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1256 /* cgijh */, SystemZ::CGIJAsmH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1262 /* cgijhe */, SystemZ::CGIJAsmHE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1269 /* cgijl */, SystemZ::CGIJAsmL, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1275 /* cgijle */, SystemZ::CGIJAsmLE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1282 /* cgijlh */, SystemZ::CGIJAsmLH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1289 /* cgijne */, SystemZ::CGIJAsmNE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1296 /* cgijnh */, SystemZ::CGIJAsmNH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1303 /* cgijnhe */, SystemZ::CGIJAsmNHE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1311 /* cgijnl */, SystemZ::CGIJAsmNL, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1318 /* cgijnle */, SystemZ::CGIJAsmNLE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1326 /* cgijnlh */, SystemZ::CGIJAsmNLH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1334 /* cgit */, SystemZ::CGITAsm, Convert__GR641_0__S16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_S16Imm, MCK_U4Imm }, },
  { 1339 /* cgite */, SystemZ::CGITAsmE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1345 /* cgith */, SystemZ::CGITAsmH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1351 /* cgithe */, SystemZ::CGITAsmHE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1358 /* cgitl */, SystemZ::CGITAsmL, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1364 /* cgitle */, SystemZ::CGITAsmLE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1371 /* cgitlh */, SystemZ::CGITAsmLH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1378 /* cgitne */, SystemZ::CGITAsmNE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1385 /* cgitnh */, SystemZ::CGITAsmNH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1392 /* cgitnhe */, SystemZ::CGITAsmNHE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1400 /* cgitnl */, SystemZ::CGITAsmNL, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1407 /* cgitnle */, SystemZ::CGITAsmNLE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1415 /* cgitnlh */, SystemZ::CGITAsmNLH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1423 /* cgr */, SystemZ::CGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1427 /* cgrb */, SystemZ::CGRBAsm, Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1432 /* cgrbe */, SystemZ::CGRBAsmE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1438 /* cgrbh */, SystemZ::CGRBAsmH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1444 /* cgrbhe */, SystemZ::CGRBAsmHE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1451 /* cgrbl */, SystemZ::CGRBAsmL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1457 /* cgrble */, SystemZ::CGRBAsmLE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1464 /* cgrblh */, SystemZ::CGRBAsmLH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1471 /* cgrbne */, SystemZ::CGRBAsmNE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1478 /* cgrbnh */, SystemZ::CGRBAsmNH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1485 /* cgrbnhe */, SystemZ::CGRBAsmNHE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1493 /* cgrbnl */, SystemZ::CGRBAsmNL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1500 /* cgrbnle */, SystemZ::CGRBAsmNLE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1508 /* cgrbnlh */, SystemZ::CGRBAsmNLH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1516 /* cgrj */, SystemZ::CGRJAsm, Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_PCRel16 }, },
  { 1521 /* cgrje */, SystemZ::CGRJAsmE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1527 /* cgrjh */, SystemZ::CGRJAsmH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1533 /* cgrjhe */, SystemZ::CGRJAsmHE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1540 /* cgrjl */, SystemZ::CGRJAsmL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1546 /* cgrjle */, SystemZ::CGRJAsmLE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1553 /* cgrjlh */, SystemZ::CGRJAsmLH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1560 /* cgrjne */, SystemZ::CGRJAsmNE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1567 /* cgrjnh */, SystemZ::CGRJAsmNH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1574 /* cgrjnhe */, SystemZ::CGRJAsmNHE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1582 /* cgrjnl */, SystemZ::CGRJAsmNL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1589 /* cgrjnle */, SystemZ::CGRJAsmNLE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1597 /* cgrjnlh */, SystemZ::CGRJAsmNLH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1605 /* cgrl */, SystemZ::CGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1610 /* cgrt */, SystemZ::CGRTAsm, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 1615 /* cgrte */, SystemZ::CGRTAsmE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1621 /* cgrth */, SystemZ::CGRTAsmH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1627 /* cgrthe */, SystemZ::CGRTAsmHE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1634 /* cgrtl */, SystemZ::CGRTAsmL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1640 /* cgrtle */, SystemZ::CGRTAsmLE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1647 /* cgrtlh */, SystemZ::CGRTAsmLH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1654 /* cgrtne */, SystemZ::CGRTAsmNE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1661 /* cgrtnh */, SystemZ::CGRTAsmNH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1668 /* cgrtnhe */, SystemZ::CGRTAsmNHE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1676 /* cgrtnl */, SystemZ::CGRTAsmNL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1683 /* cgrtnle */, SystemZ::CGRTAsmNLE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1691 /* cgrtnlh */, SystemZ::CGRTAsmNLH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1699 /* cgxbr */, SystemZ::CGXBR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1705 /* cgxbra */, SystemZ::CGXBRA, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1712 /* cgxr */, SystemZ::CGXR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1717 /* cgxtr */, SystemZ::CGXTR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1723 /* cgxtra */, SystemZ::CGXTRA, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1730 /* ch */, SystemZ::CH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 1733 /* chf */, SystemZ::CHF, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 1737 /* chhr */, SystemZ::CHHR, Convert__GRH321_0__GRH321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32 }, },
  { 1742 /* chhsi */, SystemZ::CHHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1748 /* chi */, SystemZ::CHI, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1752 /* chlr */, SystemZ::CHLR, Convert__GRH321_0__GR321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR32 }, },
  { 1757 /* chrl */, SystemZ::CHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 1762 /* chsi */, SystemZ::CHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1767 /* chy */, SystemZ::CHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 1771 /* cib */, SystemZ::CIBAsm, Convert__GR321_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1775 /* cibe */, SystemZ::CIBAsmE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1780 /* cibh */, SystemZ::CIBAsmH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1785 /* cibhe */, SystemZ::CIBAsmHE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1791 /* cibl */, SystemZ::CIBAsmL, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1796 /* cible */, SystemZ::CIBAsmLE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1802 /* ciblh */, SystemZ::CIBAsmLH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1808 /* cibne */, SystemZ::CIBAsmNE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1814 /* cibnh */, SystemZ::CIBAsmNH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1820 /* cibnhe */, SystemZ::CIBAsmNHE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1827 /* cibnl */, SystemZ::CIBAsmNL, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1833 /* cibnle */, SystemZ::CIBAsmNLE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1840 /* cibnlh */, SystemZ::CIBAsmNLH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1847 /* cih */, SystemZ::CIH, Convert__GRH321_0__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 1851 /* cij */, SystemZ::CIJAsm, Convert__GR321_0__S8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 1855 /* cije */, SystemZ::CIJAsmE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1860 /* cijh */, SystemZ::CIJAsmH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1865 /* cijhe */, SystemZ::CIJAsmHE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1871 /* cijl */, SystemZ::CIJAsmL, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1876 /* cijle */, SystemZ::CIJAsmLE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1882 /* cijlh */, SystemZ::CIJAsmLH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1888 /* cijne */, SystemZ::CIJAsmNE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1894 /* cijnh */, SystemZ::CIJAsmNH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1900 /* cijnhe */, SystemZ::CIJAsmNHE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1907 /* cijnl */, SystemZ::CIJAsmNL, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1913 /* cijnle */, SystemZ::CIJAsmNLE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1920 /* cijnlh */, SystemZ::CIJAsmNLH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1927 /* cit */, SystemZ::CITAsm, Convert__GR321_0__S16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_S16Imm, MCK_U4Imm }, },
  { 1931 /* cite */, SystemZ::CITAsmE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1936 /* cith */, SystemZ::CITAsmH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1941 /* cithe */, SystemZ::CITAsmHE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1947 /* citl */, SystemZ::CITAsmL, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1952 /* citle */, SystemZ::CITAsmLE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1958 /* citlh */, SystemZ::CITAsmLH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1964 /* citne */, SystemZ::CITAsmNE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1970 /* citnh */, SystemZ::CITAsmNH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1976 /* citnhe */, SystemZ::CITAsmNHE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1983 /* citnl */, SystemZ::CITAsmNL, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1989 /* citnle */, SystemZ::CITAsmNLE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1996 /* citnlh */, SystemZ::CITAsmNLH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 2003 /* cksm */, SystemZ::CKSM, Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 2008 /* cl */, SystemZ::CL, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 2011 /* clc */, SystemZ::CLC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 2015 /* clcl */, SystemZ::CLCL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 2020 /* clcle */, SystemZ::CLCLE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 2026 /* clclu */, SystemZ::CLCLU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp20 }, },
  { 2032 /* clfdbr */, SystemZ::CLFDBR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2039 /* clfdtr */, SystemZ::CLFDTR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2046 /* clfebr */, SystemZ::CLFEBR, Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 2053 /* clfhsi */, SystemZ::CLFHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2060 /* clfi */, SystemZ::CLFI, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 2065 /* clfit */, SystemZ::CLFITAsm, Convert__GR321_0__U16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_U16Imm, MCK_U4Imm }, },
  { 2071 /* clfite */, SystemZ::CLFITAsmE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2078 /* clfith */, SystemZ::CLFITAsmH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2085 /* clfithe */, SystemZ::CLFITAsmHE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2093 /* clfitl */, SystemZ::CLFITAsmL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2100 /* clfitle */, SystemZ::CLFITAsmLE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2108 /* clfitlh */, SystemZ::CLFITAsmLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2116 /* clfitne */, SystemZ::CLFITAsmNE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2124 /* clfitnh */, SystemZ::CLFITAsmNH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2132 /* clfitnhe */, SystemZ::CLFITAsmNHE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2141 /* clfitnl */, SystemZ::CLFITAsmNL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2149 /* clfitnle */, SystemZ::CLFITAsmNLE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2158 /* clfitnlh */, SystemZ::CLFITAsmNLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2167 /* clfxbr */, SystemZ::CLFXBR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2174 /* clfxtr */, SystemZ::CLFXTR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2181 /* clg */, SystemZ::CLG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 2185 /* clgdbr */, SystemZ::CLGDBR, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2192 /* clgdtr */, SystemZ::CLGDTR, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2199 /* clgebr */, SystemZ::CLGEBR, Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 2206 /* clgf */, SystemZ::CLGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 2211 /* clgfi */, SystemZ::CLGFI, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 2217 /* clgfr */, SystemZ::CLGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 2223 /* clgfrl */, SystemZ::CLGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2230 /* clghrl */, SystemZ::CLGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2237 /* clghsi */, SystemZ::CLGHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2244 /* clgib */, SystemZ::CLGIBAsm, Convert__GR641_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 2250 /* clgibe */, SystemZ::CLGIBAsmE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2257 /* clgibh */, SystemZ::CLGIBAsmH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2264 /* clgibhe */, SystemZ::CLGIBAsmHE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2272 /* clgibl */, SystemZ::CLGIBAsmL, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2279 /* clgible */, SystemZ::CLGIBAsmLE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2287 /* clgiblh */, SystemZ::CLGIBAsmLH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2295 /* clgibne */, SystemZ::CLGIBAsmNE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2303 /* clgibnh */, SystemZ::CLGIBAsmNH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2311 /* clgibnhe */, SystemZ::CLGIBAsmNHE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2320 /* clgibnl */, SystemZ::CLGIBAsmNL, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2328 /* clgibnle */, SystemZ::CLGIBAsmNLE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2337 /* clgibnlh */, SystemZ::CLGIBAsmNLH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2346 /* clgij */, SystemZ::CLGIJAsm, Convert__GR641_0__U8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 2352 /* clgije */, SystemZ::CLGIJAsmE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2359 /* clgijh */, SystemZ::CLGIJAsmH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2366 /* clgijhe */, SystemZ::CLGIJAsmHE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2374 /* clgijl */, SystemZ::CLGIJAsmL, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2381 /* clgijle */, SystemZ::CLGIJAsmLE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2389 /* clgijlh */, SystemZ::CLGIJAsmLH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2397 /* clgijne */, SystemZ::CLGIJAsmNE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2405 /* clgijnh */, SystemZ::CLGIJAsmNH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2413 /* clgijnhe */, SystemZ::CLGIJAsmNHE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2422 /* clgijnl */, SystemZ::CLGIJAsmNL, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2430 /* clgijnle */, SystemZ::CLGIJAsmNLE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2439 /* clgijnlh */, SystemZ::CLGIJAsmNLH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2448 /* clgit */, SystemZ::CLGITAsm, Convert__GR641_0__U16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_U16Imm, MCK_U4Imm }, },
  { 2454 /* clgite */, SystemZ::CLGITAsmE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2461 /* clgith */, SystemZ::CLGITAsmH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2468 /* clgithe */, SystemZ::CLGITAsmHE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2476 /* clgitl */, SystemZ::CLGITAsmL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2483 /* clgitle */, SystemZ::CLGITAsmLE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2491 /* clgitlh */, SystemZ::CLGITAsmLH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2499 /* clgitne */, SystemZ::CLGITAsmNE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2507 /* clgitnh */, SystemZ::CLGITAsmNH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2515 /* clgitnhe */, SystemZ::CLGITAsmNHE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2524 /* clgitnl */, SystemZ::CLGITAsmNL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2532 /* clgitnle */, SystemZ::CLGITAsmNLE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2541 /* clgitnlh */, SystemZ::CLGITAsmNLH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2550 /* clgr */, SystemZ::CLGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2555 /* clgrb */, SystemZ::CLGRBAsm, Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 2561 /* clgrbe */, SystemZ::CLGRBAsmE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2568 /* clgrbh */, SystemZ::CLGRBAsmH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2575 /* clgrbhe */, SystemZ::CLGRBAsmHE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2583 /* clgrbl */, SystemZ::CLGRBAsmL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2590 /* clgrble */, SystemZ::CLGRBAsmLE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2598 /* clgrblh */, SystemZ::CLGRBAsmLH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2606 /* clgrbne */, SystemZ::CLGRBAsmNE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2614 /* clgrbnh */, SystemZ::CLGRBAsmNH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2622 /* clgrbnhe */, SystemZ::CLGRBAsmNHE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2631 /* clgrbnl */, SystemZ::CLGRBAsmNL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2639 /* clgrbnle */, SystemZ::CLGRBAsmNLE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2648 /* clgrbnlh */, SystemZ::CLGRBAsmNLH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2657 /* clgrj */, SystemZ::CLGRJAsm, Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_PCRel16 }, },
  { 2663 /* clgrje */, SystemZ::CLGRJAsmE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2670 /* clgrjh */, SystemZ::CLGRJAsmH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2677 /* clgrjhe */, SystemZ::CLGRJAsmHE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2685 /* clgrjl */, SystemZ::CLGRJAsmL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2692 /* clgrjle */, SystemZ::CLGRJAsmLE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2700 /* clgrjlh */, SystemZ::CLGRJAsmLH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2708 /* clgrjne */, SystemZ::CLGRJAsmNE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2716 /* clgrjnh */, SystemZ::CLGRJAsmNH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2724 /* clgrjnhe */, SystemZ::CLGRJAsmNHE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2733 /* clgrjnl */, SystemZ::CLGRJAsmNL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2741 /* clgrjnle */, SystemZ::CLGRJAsmNLE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2750 /* clgrjnlh */, SystemZ::CLGRJAsmNLH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2759 /* clgrl */, SystemZ::CLGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2765 /* clgrt */, SystemZ::CLGRTAsm, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 2771 /* clgrte */, SystemZ::CLGRTAsmE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2778 /* clgrth */, SystemZ::CLGRTAsmH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2785 /* clgrthe */, SystemZ::CLGRTAsmHE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2793 /* clgrtl */, SystemZ::CLGRTAsmL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2800 /* clgrtle */, SystemZ::CLGRTAsmLE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2808 /* clgrtlh */, SystemZ::CLGRTAsmLH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2816 /* clgrtne */, SystemZ::CLGRTAsmNE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2824 /* clgrtnh */, SystemZ::CLGRTAsmNH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2832 /* clgrtnhe */, SystemZ::CLGRTAsmNHE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2841 /* clgrtnl */, SystemZ::CLGRTAsmNL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2849 /* clgrtnle */, SystemZ::CLGRTAsmNLE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2858 /* clgrtnlh */, SystemZ::CLGRTAsmNLH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2867 /* clgt */, SystemZ::CLGTAsm, Convert__GR641_0__BDAddr64Disp202_2__U4Imm1_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 2872 /* clgte */, SystemZ::CLGTAsmE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2878 /* clgth */, SystemZ::CLGTAsmH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2884 /* clgthe */, SystemZ::CLGTAsmHE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2891 /* clgtl */, SystemZ::CLGTAsmL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2897 /* clgtle */, SystemZ::CLGTAsmLE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2904 /* clgtlh */, SystemZ::CLGTAsmLH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2911 /* clgtne */, SystemZ::CLGTAsmNE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2918 /* clgtnh */, SystemZ::CLGTAsmNH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2925 /* clgtnhe */, SystemZ::CLGTAsmNHE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2933 /* clgtnl */, SystemZ::CLGTAsmNL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2940 /* clgtnle */, SystemZ::CLGTAsmNLE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2948 /* clgtnlh */, SystemZ::CLGTAsmNLH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2956 /* clgxbr */, SystemZ::CLGXBR, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2963 /* clgxtr */, SystemZ::CLGXTR, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2970 /* clhf */, SystemZ::CLHF, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 2975 /* clhhr */, SystemZ::CLHHR, Convert__GRH321_0__GRH321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32 }, },
  { 2981 /* clhhsi */, SystemZ::CLHHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2988 /* clhlr */, SystemZ::CLHLR, Convert__GRH321_0__GR321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR32 }, },
  { 2994 /* clhrl */, SystemZ::CLHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 3000 /* cli */, SystemZ::CLI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 3004 /* clib */, SystemZ::CLIBAsm, Convert__GR321_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3009 /* clibe */, SystemZ::CLIBAsmE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3015 /* clibh */, SystemZ::CLIBAsmH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3021 /* clibhe */, SystemZ::CLIBAsmHE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3028 /* clibl */, SystemZ::CLIBAsmL, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3034 /* clible */, SystemZ::CLIBAsmLE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3041 /* cliblh */, SystemZ::CLIBAsmLH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3048 /* clibne */, SystemZ::CLIBAsmNE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3055 /* clibnh */, SystemZ::CLIBAsmNH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3062 /* clibnhe */, SystemZ::CLIBAsmNHE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3070 /* clibnl */, SystemZ::CLIBAsmNL, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3077 /* clibnle */, SystemZ::CLIBAsmNLE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3085 /* clibnlh */, SystemZ::CLIBAsmNLH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3093 /* clih */, SystemZ::CLIH, Convert__GRH321_0__U32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_U32Imm }, },
  { 3098 /* clij */, SystemZ::CLIJAsm, Convert__GR321_0__U8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 3103 /* clije */, SystemZ::CLIJAsmE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3109 /* clijh */, SystemZ::CLIJAsmH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3115 /* clijhe */, SystemZ::CLIJAsmHE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3122 /* clijl */, SystemZ::CLIJAsmL, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3128 /* clijle */, SystemZ::CLIJAsmLE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3135 /* clijlh */, SystemZ::CLIJAsmLH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3142 /* clijne */, SystemZ::CLIJAsmNE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3149 /* clijnh */, SystemZ::CLIJAsmNH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3156 /* clijnhe */, SystemZ::CLIJAsmNHE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3164 /* clijnl */, SystemZ::CLIJAsmNL, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3171 /* clijnle */, SystemZ::CLIJAsmNLE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3179 /* clijnlh */, SystemZ::CLIJAsmNLH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3187 /* cliy */, SystemZ::CLIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 3192 /* clm */, SystemZ::CLM, Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3196 /* clmh */, SystemZ::CLMH, Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3201 /* clmy */, SystemZ::CLMY, Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3206 /* clr */, SystemZ::CLR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3210 /* clrb */, SystemZ::CLRBAsm, Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3215 /* clrbe */, SystemZ::CLRBAsmE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3221 /* clrbh */, SystemZ::CLRBAsmH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3227 /* clrbhe */, SystemZ::CLRBAsmHE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3234 /* clrbl */, SystemZ::CLRBAsmL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3240 /* clrble */, SystemZ::CLRBAsmLE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3247 /* clrblh */, SystemZ::CLRBAsmLH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3254 /* clrbne */, SystemZ::CLRBAsmNE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3261 /* clrbnh */, SystemZ::CLRBAsmNH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3268 /* clrbnhe */, SystemZ::CLRBAsmNHE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3276 /* clrbnl */, SystemZ::CLRBAsmNL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3283 /* clrbnle */, SystemZ::CLRBAsmNLE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3291 /* clrbnlh */, SystemZ::CLRBAsmNLH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3299 /* clrj */, SystemZ::CLRJAsm, Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_PCRel16 }, },
  { 3304 /* clrje */, SystemZ::CLRJAsmE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3310 /* clrjh */, SystemZ::CLRJAsmH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3316 /* clrjhe */, SystemZ::CLRJAsmHE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3323 /* clrjl */, SystemZ::CLRJAsmL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3329 /* clrjle */, SystemZ::CLRJAsmLE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3336 /* clrjlh */, SystemZ::CLRJAsmLH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3343 /* clrjne */, SystemZ::CLRJAsmNE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3350 /* clrjnh */, SystemZ::CLRJAsmNH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3357 /* clrjnhe */, SystemZ::CLRJAsmNHE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3365 /* clrjnl */, SystemZ::CLRJAsmNL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3372 /* clrjnle */, SystemZ::CLRJAsmNLE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3380 /* clrjnlh */, SystemZ::CLRJAsmNLH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3388 /* clrl */, SystemZ::CLRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 3393 /* clrt */, SystemZ::CLRTAsm, Convert__GR321_0__GR321_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 3398 /* clrte */, SystemZ::CLRTAsmE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3404 /* clrth */, SystemZ::CLRTAsmH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3410 /* clrthe */, SystemZ::CLRTAsmHE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3417 /* clrtl */, SystemZ::CLRTAsmL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3423 /* clrtle */, SystemZ::CLRTAsmLE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3430 /* clrtlh */, SystemZ::CLRTAsmLH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3437 /* clrtne */, SystemZ::CLRTAsmNE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3444 /* clrtnh */, SystemZ::CLRTAsmNH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3451 /* clrtnhe */, SystemZ::CLRTAsmNHE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3459 /* clrtnl */, SystemZ::CLRTAsmNL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3466 /* clrtnle */, SystemZ::CLRTAsmNLE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3474 /* clrtnlh */, SystemZ::CLRTAsmNLH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3482 /* clst */, SystemZ::CLST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3487 /* clt */, SystemZ::CLTAsm, Convert__GR321_0__BDAddr64Disp202_2__U4Imm1_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3491 /* clte */, SystemZ::CLTAsmE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3496 /* clth */, SystemZ::CLTAsmH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3501 /* clthe */, SystemZ::CLTAsmHE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3507 /* cltl */, SystemZ::CLTAsmL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3512 /* cltle */, SystemZ::CLTAsmLE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3518 /* cltlh */, SystemZ::CLTAsmLH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3524 /* cltne */, SystemZ::CLTAsmNE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3530 /* cltnh */, SystemZ::CLTAsmNH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3536 /* cltnhe */, SystemZ::CLTAsmNHE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3543 /* cltnl */, SystemZ::CLTAsmNL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3549 /* cltnle */, SystemZ::CLTAsmNLE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3556 /* cltnlh */, SystemZ::CLTAsmNLH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3563 /* cly */, SystemZ::CLY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3567 /* clzg */, SystemZ::CLZG, Convert__GR641_0__GR641_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64 }, },
  { 3572 /* cmpsc */, SystemZ::CMPSC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3578 /* cp */, SystemZ::CP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 3581 /* cpdt */, SystemZ::CPDT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 3586 /* cpsdr */, SystemZ::CPSDRdd, Convert__FP641_0__FP641_2__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 3592 /* cpxt */, SystemZ::CPXT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 3597 /* cpya */, SystemZ::CPYA, Convert__AR321_0__AR321_1, AMFBS_None, { MCK_AR32, MCK_AR32 }, },
  { 3602 /* cr */, SystemZ::CR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3605 /* crb */, SystemZ::CRBAsm, Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3609 /* crbe */, SystemZ::CRBAsmE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3614 /* crbh */, SystemZ::CRBAsmH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3619 /* crbhe */, SystemZ::CRBAsmHE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3625 /* crbl */, SystemZ::CRBAsmL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3630 /* crble */, SystemZ::CRBAsmLE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3636 /* crblh */, SystemZ::CRBAsmLH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3642 /* crbne */, SystemZ::CRBAsmNE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3648 /* crbnh */, SystemZ::CRBAsmNH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3654 /* crbnhe */, SystemZ::CRBAsmNHE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3661 /* crbnl */, SystemZ::CRBAsmNL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3667 /* crbnle */, SystemZ::CRBAsmNLE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3674 /* crbnlh */, SystemZ::CRBAsmNLH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3681 /* crdte */, SystemZ::CRDTEOpt, Convert__GR1281_0__GR1281_2__GR641_1, AMFBS_FeatureEnhancedDAT2, { MCK_GR128, MCK_GR64, MCK_GR128 }, },
  { 3681 /* crdte */, SystemZ::CRDTE, Convert__GR1281_0__GR1281_2__GR641_1__U4Imm1_3, AMFBS_FeatureEnhancedDAT2, { MCK_GR128, MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 3687 /* crj */, SystemZ::CRJAsm, Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_PCRel16 }, },
  { 3691 /* crje */, SystemZ::CRJAsmE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3696 /* crjh */, SystemZ::CRJAsmH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3701 /* crjhe */, SystemZ::CRJAsmHE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3707 /* crjl */, SystemZ::CRJAsmL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3712 /* crjle */, SystemZ::CRJAsmLE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3718 /* crjlh */, SystemZ::CRJAsmLH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3724 /* crjne */, SystemZ::CRJAsmNE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3730 /* crjnh */, SystemZ::CRJAsmNH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3736 /* crjnhe */, SystemZ::CRJAsmNHE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3743 /* crjnl */, SystemZ::CRJAsmNL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3749 /* crjnle */, SystemZ::CRJAsmNLE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3756 /* crjnlh */, SystemZ::CRJAsmNLH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3763 /* crl */, SystemZ::CRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 3767 /* crt */, SystemZ::CRTAsm, Convert__GR321_0__GR321_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 3771 /* crte */, SystemZ::CRTAsmE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3776 /* crth */, SystemZ::CRTAsmH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3781 /* crthe */, SystemZ::CRTAsmHE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3787 /* crtl */, SystemZ::CRTAsmL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3792 /* crtle */, SystemZ::CRTAsmLE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3798 /* crtlh */, SystemZ::CRTAsmLH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3804 /* crtne */, SystemZ::CRTAsmNE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3810 /* crtnh */, SystemZ::CRTAsmNH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3816 /* crtnhe */, SystemZ::CRTAsmNHE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3823 /* crtnl */, SystemZ::CRTAsmNL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3829 /* crtnle */, SystemZ::CRTAsmNLE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3836 /* crtnlh */, SystemZ::CRTAsmNLH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3843 /* cs */, SystemZ::CS, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3846 /* csch */, SystemZ::CSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 3851 /* csdtr */, SystemZ::CSDTR, Convert__GR641_0__FP641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_FP64, MCK_U4Imm }, },
  { 3857 /* csg */, SystemZ::CSG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 3861 /* csp */, SystemZ::CSP, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 3865 /* cspg */, SystemZ::CSPG, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 3870 /* csst */, SystemZ::CSST, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 3875 /* csxtr */, SystemZ::CSXTR, Convert__GR1281_0__FP1281_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_FP128, MCK_U4Imm }, },
  { 3881 /* csy */, SystemZ::CSY, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3885 /* ctzg */, SystemZ::CTZG, Convert__GR641_0__GR641_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64 }, },
  { 3890 /* cu12 */, SystemZ::CU12Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3890 /* cu12 */, SystemZ::CU12, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3895 /* cu14 */, SystemZ::CU14Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3895 /* cu14 */, SystemZ::CU14, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3900 /* cu21 */, SystemZ::CU21Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3900 /* cu21 */, SystemZ::CU21, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3905 /* cu24 */, SystemZ::CU24Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3905 /* cu24 */, SystemZ::CU24, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3910 /* cu41 */, SystemZ::CU41, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3915 /* cu42 */, SystemZ::CU42, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3920 /* cudtr */, SystemZ::CUDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 3926 /* cuse */, SystemZ::CUSE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3931 /* cutfu */, SystemZ::CUTFUOpt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3931 /* cutfu */, SystemZ::CUTFU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3937 /* cuutf */, SystemZ::CUUTFOpt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3937 /* cuutf */, SystemZ::CUUTF, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3943 /* cuxtr */, SystemZ::CUXTR, Convert__GR1281_0__FP1281_1, AMFBS_None, { MCK_GR128, MCK_FP128 }, },
  { 3949 /* cvb */, SystemZ::CVB, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 3953 /* cvbg */, SystemZ::CVBG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 3958 /* cvby */, SystemZ::CVBY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3963 /* cvd */, SystemZ::CVD, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 3967 /* cvdg */, SystemZ::CVDG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 3972 /* cvdy */, SystemZ::CVDY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3977 /* cxbr */, SystemZ::CXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 3982 /* cxfbr */, SystemZ::CXFBR, Convert__FP1281_0__GR321_1, AMFBS_None, { MCK_FP128, MCK_GR32 }, },
  { 3988 /* cxfbra */, SystemZ::CXFBRA, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 3995 /* cxfr */, SystemZ::CXFR, Convert__FP1281_0__GR321_1, AMFBS_None, { MCK_FP128, MCK_GR32 }, },
  { 4000 /* cxftr */, SystemZ::CXFTR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4006 /* cxgbr */, SystemZ::CXGBR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4012 /* cxgbra */, SystemZ::CXGBRA, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4019 /* cxgr */, SystemZ::CXGR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4024 /* cxgtr */, SystemZ::CXGTR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4030 /* cxgtra */, SystemZ::CXGTRA, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4037 /* cxlfbr */, SystemZ::CXLFBR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4044 /* cxlftr */, SystemZ::CXLFTR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4051 /* cxlgbr */, SystemZ::CXLGBR, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4058 /* cxlgtr */, SystemZ::CXLGTR, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4065 /* cxpt */, SystemZ::CXPT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4070 /* cxr */, SystemZ::CXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4074 /* cxstr */, SystemZ::CXSTR, Convert__FP1281_0__GR1281_1, AMFBS_None, { MCK_FP128, MCK_GR128 }, },
  { 4080 /* cxtr */, SystemZ::CXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4085 /* cxutr */, SystemZ::CXUTR, Convert__FP1281_0__GR1281_1, AMFBS_None, { MCK_FP128, MCK_GR128 }, },
  { 4091 /* cxzt */, SystemZ::CXZT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4096 /* cy */, SystemZ::CY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4099 /* czdt */, SystemZ::CZDT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4104 /* czxt */, SystemZ::CZXT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4109 /* d */, SystemZ::D, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp12 }, },
  { 4111 /* dd */, SystemZ::DD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4114 /* ddb */, SystemZ::DDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4118 /* ddbr */, SystemZ::DDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4123 /* ddr */, SystemZ::DDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4127 /* ddtr */, SystemZ::DDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 4132 /* ddtra */, SystemZ::DDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 4138 /* de */, SystemZ::DE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4141 /* deb */, SystemZ::DEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4145 /* debr */, SystemZ::DEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4150 /* der */, SystemZ::DER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4154 /* dfltcc */, SystemZ::DFLTCC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__GR641_2, AMFBS_FeatureDeflateConversion, { MCK_GR128, MCK_GR128, MCK_GR64 }, },
  { 4161 /* diag */, SystemZ::DIAG, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 4166 /* didbr */, SystemZ::DIDBR, Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 4172 /* diebr */, SystemZ::DIEBR, Convert__FP321_0__FP321_1__Tie0_1_1__FP321_2__U4Imm1_3, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32, MCK_U4Imm }, },
  { 4178 /* dl */, SystemZ::DL, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4181 /* dlg */, SystemZ::DLG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4185 /* dlgr */, SystemZ::DLGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4190 /* dlr */, SystemZ::DLR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4194 /* dp */, SystemZ::DP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 4197 /* dr */, SystemZ::DR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4200 /* dsg */, SystemZ::DSG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4204 /* dsgf */, SystemZ::DSGF, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4209 /* dsgfr */, SystemZ::DSGFR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4215 /* dsgr */, SystemZ::DSGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4220 /* dxbr */, SystemZ::DXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4225 /* dxr */, SystemZ::DXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4229 /* dxtr */, SystemZ::DXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 4234 /* dxtra */, SystemZ::DXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 4240 /* ear */, SystemZ::EAR, Convert__GR321_0__AR321_1, AMFBS_None, { MCK_GR32, MCK_AR32 }, },
  { 4244 /* ecag */, SystemZ::ECAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 4249 /* ecctr */, SystemZ::ECCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4255 /* ecpga */, SystemZ::ECPGA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4261 /* ectg */, SystemZ::ECTG, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 4266 /* ed */, SystemZ::ED, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 4269 /* edmk */, SystemZ::EDMK, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 4274 /* eedtr */, SystemZ::EEDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 4280 /* eextr */, SystemZ::EEXTR, Convert__GR641_0__FP1281_1, AMFBS_None, { MCK_GR64, MCK_FP128 }, },
  { 4286 /* efpc */, SystemZ::EFPC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4291 /* epair */, SystemZ::EPAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 4297 /* epar */, SystemZ::EPAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4302 /* epctr */, SystemZ::EPCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4308 /* epsw */, SystemZ::EPSW, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4313 /* ereg */, SystemZ::EREG, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4318 /* eregg */, SystemZ::EREGG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4324 /* esair */, SystemZ::ESAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 4330 /* esar */, SystemZ::ESAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4335 /* esdtr */, SystemZ::ESDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 4341 /* esea */, SystemZ::ESEA, Convert__GR321_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 4346 /* esta */, SystemZ::ESTA, Convert__GR1281_0__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4351 /* esxtr */, SystemZ::ESXTR, Convert__GR641_0__FP1281_1, AMFBS_None, { MCK_GR64, MCK_FP128 }, },
  { 4357 /* etnd */, SystemZ::ETND, Convert__GR321_0, AMFBS_FeatureTransactionalExecution, { MCK_GR32 }, },
  { 4362 /* ex */, SystemZ::EX, Convert__ADDR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_ADDR64, MCK_BDXAddr64Disp12 }, },
  { 4365 /* exrl */, SystemZ::EXRL, Convert__ADDR641_0__PCRel321_1, AMFBS_None, { MCK_ADDR64, MCK_PCRel32 }, },
  { 4370 /* fidbr */, SystemZ::FIDBR, Convert__FP641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64 }, },
  { 4376 /* fidbra */, SystemZ::FIDBRA, Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 4383 /* fidr */, SystemZ::FIDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4388 /* fidtr */, SystemZ::FIDTR, Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 4394 /* fiebr */, SystemZ::FIEBR, Convert__FP321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP32 }, },
  { 4400 /* fiebra */, SystemZ::FIEBRA, Convert__FP321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 4407 /* fier */, SystemZ::FIER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4412 /* fixbr */, SystemZ::FIXBR, Convert__FP1281_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128 }, },
  { 4418 /* fixbra */, SystemZ::FIXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 4425 /* fixr */, SystemZ::FIXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4430 /* fixtr */, SystemZ::FIXTR, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 4436 /* flogr */, SystemZ::FLOGR, Convert__GR1281_0__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4442 /* hdr */, SystemZ::HDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4446 /* her */, SystemZ::HER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4450 /* hsch */, SystemZ::HSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 4455 /* iac */, SystemZ::IAC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4459 /* ic */, SystemZ::IC, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4462 /* icm */, SystemZ::ICM, Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 4466 /* icmh */, SystemZ::ICMH, Convert__GRH321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 4471 /* icmy */, SystemZ::ICMY, Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 4476 /* icy */, SystemZ::ICY, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4480 /* idte */, SystemZ::IDTEOpt, Convert__GR641_0__GR641_2__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4480 /* idte */, SystemZ::IDTE, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 4485 /* iedtr */, SystemZ::IEDTR, Convert__FP641_0__GR641_2__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_GR64 }, },
  { 4491 /* iextr */, SystemZ::IEXTR, Convert__FP1281_0__GR641_2__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_GR64 }, },
  { 4497 /* iihf */, SystemZ::IIHF, Convert__GRH321_0__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 4502 /* iihh */, SystemZ::IIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 4507 /* iihl */, SystemZ::IIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 4512 /* iilf */, SystemZ::IILF, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 4517 /* iilh */, SystemZ::IILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 4522 /* iill */, SystemZ::IILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 4527 /* ipk */, SystemZ::IPK, Convert_NoOperands, AMFBS_None, {  }, },
  { 4531 /* ipm */, SystemZ::IPM, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4535 /* ipte */, SystemZ::IPTEOptOpt, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 4535 /* ipte */, SystemZ::IPTEOpt, Convert__GR641_0__GR321_1__GR321_2, AMFBS_None, { MCK_GR64, MCK_GR32, MCK_GR32 }, },
  { 4535 /* ipte */, SystemZ::IPTE, Convert__GR641_0__GR321_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 4540 /* irbm */, SystemZ::IRBM, Convert__GR641_0__GR641_1, AMFBS_FeatureInsertReferenceBitsMultiple, { MCK_GR64, MCK_GR64 }, },
  { 4545 /* iske */, SystemZ::ISKE, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4550 /* ivsk */, SystemZ::IVSK, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4555 /* j */, SystemZ::J, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4557 /* je */, SystemZ::JAsmE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4560 /* jg */, SystemZ::JG, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4563 /* jge */, SystemZ::JGAsmE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4567 /* jgh */, SystemZ::JGAsmH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4571 /* jghe */, SystemZ::JGAsmHE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4576 /* jgl */, SystemZ::JGAsmL, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4580 /* jgle */, SystemZ::JGAsmLE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4585 /* jglh */, SystemZ::JGAsmLH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4590 /* jgm */, SystemZ::JGAsmM, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4594 /* jgne */, SystemZ::JGAsmNE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4599 /* jgnh */, SystemZ::JGAsmNH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4604 /* jgnhe */, SystemZ::JGAsmNHE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4610 /* jgnl */, SystemZ::JGAsmNL, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4615 /* jgnle */, SystemZ::JGAsmNLE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4621 /* jgnlh */, SystemZ::JGAsmNLH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4627 /* jgnm */, SystemZ::JGAsmNM, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4632 /* jgno */, SystemZ::JGAsmNO, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4637 /* jgnop */, SystemZ::JGNOP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4643 /* jgnp */, SystemZ::JGAsmNP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4648 /* jgnz */, SystemZ::JGAsmNZ, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4653 /* jgo */, SystemZ::JGAsmO, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4657 /* jgp */, SystemZ::JGAsmP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4661 /* jgz */, SystemZ::JGAsmZ, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4665 /* jh */, SystemZ::JAsmH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4668 /* jhe */, SystemZ::JAsmHE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4672 /* jl */, SystemZ::JAsmL, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4675 /* jle */, SystemZ::JAsmLE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4679 /* jlh */, SystemZ::JAsmLH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4748 /* jm */, SystemZ::JAsmM, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4751 /* jne */, SystemZ::JAsmNE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4755 /* jnh */, SystemZ::JAsmNH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4759 /* jnhe */, SystemZ::JAsmNHE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4764 /* jnl */, SystemZ::JAsmNL, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4768 /* jnle */, SystemZ::JAsmNLE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4773 /* jnlh */, SystemZ::JAsmNLH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4778 /* jnm */, SystemZ::JAsmNM, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4782 /* jno */, SystemZ::JAsmNO, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4786 /* jnop */, SystemZ::JNOP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4791 /* jnp */, SystemZ::JAsmNP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4795 /* jnz */, SystemZ::JAsmNZ, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4799 /* jo */, SystemZ::JAsmO, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4802 /* jp */, SystemZ::JAsmP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4805 /* jz */, SystemZ::JAsmZ, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4808 /* kdb */, SystemZ::KDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4812 /* kdbr */, SystemZ::KDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4817 /* kdsa */, SystemZ::KDSA, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_FeatureMessageSecurityAssist9, { MCK_GR64, MCK_GR128 }, },
  { 4822 /* kdtr */, SystemZ::KDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4827 /* keb */, SystemZ::KEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4831 /* kebr */, SystemZ::KEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4836 /* kimd */, SystemZ::KIMD, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4836 /* kimd */, SystemZ::KIMDOpt, Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_FeatureMessageSecurityAssist12, { MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 4841 /* klmd */, SystemZ::KLMD, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4841 /* klmd */, SystemZ::KLMDOpt, Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_FeatureMessageSecurityAssist12, { MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 4846 /* km */, SystemZ::KM, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 4849 /* kma */, SystemZ::KMA, Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1, AMFBS_FeatureMessageSecurityAssist8, { MCK_GR128, MCK_GR128, MCK_GR128 }, },
  { 4853 /* kmac */, SystemZ::KMAC, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4858 /* kmc */, SystemZ::KMC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 4862 /* kmctr */, SystemZ::KMCTR, Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128, MCK_GR128 }, },
  { 4868 /* kmf */, SystemZ::KMF, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128 }, },
  { 4872 /* kmo */, SystemZ::KMO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128 }, },
  { 4876 /* kxbr */, SystemZ::KXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4881 /* kxtr */, SystemZ::KXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4886 /* l */, SystemZ::L, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 4888 /* la */, SystemZ::LA, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4891 /* laa */, SystemZ::LAA, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4895 /* laag */, SystemZ::LAAG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4900 /* laal */, SystemZ::LAAL, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4905 /* laalg */, SystemZ::LAALG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4911 /* lae */, SystemZ::LAE, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4915 /* laey */, SystemZ::LAEY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4920 /* lam */, SystemZ::LAM, Convert__AR321_0__AR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp12 }, },
  { 4924 /* lamy */, SystemZ::LAMY, Convert__AR321_0__AR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp20 }, },
  { 4929 /* lan */, SystemZ::LAN, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4933 /* lang */, SystemZ::LANG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4938 /* lao */, SystemZ::LAO, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4942 /* laog */, SystemZ::LAOG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4947 /* larl */, SystemZ::LARL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 4952 /* lasp */, SystemZ::LASP, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 4957 /* lat */, SystemZ::LAT, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4961 /* lax */, SystemZ::LAX, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4965 /* laxg */, SystemZ::LAXG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4970 /* lay */, SystemZ::LAY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4974 /* lb */, SystemZ::LB, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4977 /* lbear */, SystemZ::LBEAR, Convert__BDAddr64Disp122_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp12 }, },
  { 4983 /* lbh */, SystemZ::LBH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 4987 /* lbr */, SystemZ::LBR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4991 /* lcbb */, SystemZ::LCBB, Convert__GR321_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_GR32, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 4996 /* lcctl */, SystemZ::LCCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5002 /* lcdbr */, SystemZ::LCDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5008 /* lcdfr */, SystemZ::LCDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5014 /* lcdr */, SystemZ::LCDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5019 /* lcebr */, SystemZ::LCEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5025 /* lcer */, SystemZ::LCER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5030 /* lcgfr */, SystemZ::LCGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5036 /* lcgr */, SystemZ::LCGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5041 /* lcr */, SystemZ::LCR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5045 /* lctl */, SystemZ::LCTL, Convert__CR641_0__CR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp12 }, },
  { 5050 /* lctlg */, SystemZ::LCTLG, Convert__CR641_0__CR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp20 }, },
  { 5056 /* lcxbr */, SystemZ::LCXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5062 /* lcxr */, SystemZ::LCXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5067 /* ld */, SystemZ::LD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5070 /* lde */, SystemZ::LDE, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5074 /* ldeb */, SystemZ::LDEB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5079 /* ldebr */, SystemZ::LDEBR, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 5085 /* lder */, SystemZ::LDER, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 5090 /* ldetr */, SystemZ::LDETR, Convert__FP641_0__FP321_1__U4Imm1_2, AMFBS_None, { MCK_FP64, MCK_FP32, MCK_U4Imm }, },
  { 5096 /* ldgr */, SystemZ::LDGR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 5101 /* ldr */, SystemZ::LDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5105 /* ldrv */, SystemZ::VLLEBRZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 5110 /* ldxbr */, SystemZ::LDXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5116 /* ldxbra */, SystemZ::LDXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5123 /* ldxr */, SystemZ::LDXR, Convert__FP641_0__FP1281_1, AMFBS_None, { MCK_FP64, MCK_FP128 }, },
  { 5128 /* ldxtr */, SystemZ::LDXTR, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5134 /* ldy */, SystemZ::LDY, Convert__FP641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp20 }, },
  { 5138 /* le */, SystemZ::LE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 5141 /* ledbr */, SystemZ::LEDBR, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 5147 /* ledbra */, SystemZ::LEDBRA, Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 5154 /* ledr */, SystemZ::LEDR, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 5159 /* ledtr */, SystemZ::LEDTR, Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 5165 /* ler */, SystemZ::LER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5169 /* lerv */, SystemZ::VLLEBRZE, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 5174 /* lexbr */, SystemZ::LEXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5180 /* lexbra */, SystemZ::LEXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5187 /* lexr */, SystemZ::LEXR, Convert__FP321_0__FP1281_1, AMFBS_None, { MCK_FP32, MCK_FP128 }, },
  { 5192 /* ley */, SystemZ::LEY, Convert__FP321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp20 }, },
  { 5196 /* lfas */, SystemZ::LFAS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5201 /* lfh */, SystemZ::LFH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5205 /* lfhat */, SystemZ::LFHAT, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5211 /* lfi */, SystemZ::IILF, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 5215 /* lfpc */, SystemZ::LFPC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5220 /* lg */, SystemZ::LG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5223 /* lgat */, SystemZ::LGAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5228 /* lgb */, SystemZ::LGB, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5232 /* lgbr */, SystemZ::LGBR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5237 /* lgdr */, SystemZ::LGDR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 5242 /* lgf */, SystemZ::LGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5246 /* lgfi */, SystemZ::LGFI, Convert__GR641_0__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 5251 /* lgfr */, SystemZ::LGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5256 /* lgfrl */, SystemZ::LGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5262 /* lgg */, SystemZ::LGG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5266 /* lgh */, SystemZ::LGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5270 /* lghi */, SystemZ::LGHI, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 5275 /* lghr */, SystemZ::LGHR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5280 /* lghrl */, SystemZ::LGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5286 /* lgr */, SystemZ::LGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5290 /* lgrl */, SystemZ::LGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5295 /* lgsc */, SystemZ::LGSC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5300 /* lh */, SystemZ::LH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 5303 /* lhh */, SystemZ::LHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5307 /* lhi */, SystemZ::LHI, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 5311 /* lhr */, SystemZ::LHR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5315 /* lhrl */, SystemZ::LHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 5320 /* lhy */, SystemZ::LHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5324 /* llc */, SystemZ::LLC, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5328 /* llch */, SystemZ::LLCH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5333 /* llcr */, SystemZ::LLCR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5338 /* llgc */, SystemZ::LLGC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5343 /* llgcr */, SystemZ::LLGCR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5349 /* llgf */, SystemZ::LLGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5354 /* llgfat */, SystemZ::LLGFAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5361 /* llgfi */, SystemZ::LLILF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5367 /* llgfr */, SystemZ::LLGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5373 /* llgfrl */, SystemZ::LLGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5380 /* llgfsg */, SystemZ::LLGFSG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5387 /* llgh */, SystemZ::LLGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5392 /* llghi */, SystemZ::LLILL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5398 /* llghr */, SystemZ::LLGHR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5404 /* llghrl */, SystemZ::LLGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5411 /* llgt */, SystemZ::LLGT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5416 /* llgtat */, SystemZ::LLGTAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5423 /* llgtr */, SystemZ::LLGTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5429 /* llh */, SystemZ::LLH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5433 /* llhh */, SystemZ::LLHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5438 /* llhr */, SystemZ::LLHR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5443 /* llhrl */, SystemZ::LLHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 5449 /* llihf */, SystemZ::LLIHF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5455 /* llihh */, SystemZ::LLIHH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5461 /* llihl */, SystemZ::LLIHL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5467 /* llilf */, SystemZ::LLILF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5473 /* llilh */, SystemZ::LLILH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5479 /* llill */, SystemZ::LLILL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5485 /* llxab */, SystemZ::LLXAB, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5491 /* llxaf */, SystemZ::LLXAF, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5497 /* llxag */, SystemZ::LLXAG, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5503 /* llxah */, SystemZ::LLXAH, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5509 /* llxaq */, SystemZ::LLXAQ, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5515 /* llzrgf */, SystemZ::LLZRGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5522 /* lm */, SystemZ::LM, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 5525 /* lmd */, SystemZ::LMD, Convert__GR641_0__GR641_1__BDAddr64Disp122_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 5529 /* lmg */, SystemZ::LMG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5533 /* lmh */, SystemZ::LMH, Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5537 /* lmy */, SystemZ::LMY, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 5541 /* lndbr */, SystemZ::LNDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5547 /* lndfr */, SystemZ::LNDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5553 /* lndr */, SystemZ::LNDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5558 /* lnebr */, SystemZ::LNEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5564 /* lner */, SystemZ::LNER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5569 /* lngfr */, SystemZ::LNGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5575 /* lngr */, SystemZ::LNGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5580 /* lnr */, SystemZ::LNR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5584 /* lnxbr */, SystemZ::LNXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5590 /* lnxr */, SystemZ::LNXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5595 /* loc */, SystemZ::LOCAsm, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5599 /* loce */, SystemZ::LOCAsmE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 5604 /* locfh */, SystemZ::LOCFHAsm, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5610 /* locfhe */, SystemZ::LOCFHAsmE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5617 /* locfhh */, SystemZ::LOCFHAsmH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5624 /* locfhhe */, SystemZ::LOCFHAsmHE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5632 /* locfhl */, SystemZ::LOCFHAsmL, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5639 /* locfhle */, SystemZ::LOCFHAsmLE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5647 /* locfhlh */, SystemZ::LOCFHAsmLH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5655 /* locfhm */, SystemZ::LOCFHAsmM, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5662 /* locfhne */, SystemZ::LOCFHAsmNE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5670 /* locfhnh */, SystemZ::LOCFHAsmNH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5678 /* locfhnhe */, SystemZ::LOCFHAsmNHE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5687 /* locfhnl */, SystemZ::LOCFHAsmNL, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5695 /* locfhnle */, SystemZ::LOCFHAsmNLE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5704 /* locfhnlh */, SystemZ::LOCFHAsmNLH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5713 /* locfhnm */, SystemZ::LOCFHAsmNM, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5721 /* locfhno */, SystemZ::LOCFHAsmNO, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5729 /* locfhnp */, SystemZ::LOCFHAsmNP, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5737 /* locfhnz */, SystemZ::LOCFHAsmNZ, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5745 /* locfho */, SystemZ::LOCFHAsmO, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5752 /* locfhp */, SystemZ::LOCFHAsmP, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5759 /* locfhr */, SystemZ::LOCFHRAsm, Convert__GRH321_0__Tie0_1_1__GRH321_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32, MCK_U4Imm }, },
  { 5766 /* locfhre */, SystemZ::LOCFHRAsmE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5774 /* locfhrh */, SystemZ::LOCFHRAsmH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5782 /* locfhrhe */, SystemZ::LOCFHRAsmHE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5791 /* locfhrl */, SystemZ::LOCFHRAsmL, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5799 /* locfhrle */, SystemZ::LOCFHRAsmLE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5808 /* locfhrlh */, SystemZ::LOCFHRAsmLH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5817 /* locfhrm */, SystemZ::LOCFHRAsmM, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5825 /* locfhrne */, SystemZ::LOCFHRAsmNE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5834 /* locfhrnh */, SystemZ::LOCFHRAsmNH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5843 /* locfhrnhe */, SystemZ::LOCFHRAsmNHE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5853 /* locfhrnl */, SystemZ::LOCFHRAsmNL, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5862 /* locfhrnle */, SystemZ::LOCFHRAsmNLE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5872 /* locfhrnlh */, SystemZ::LOCFHRAsmNLH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5882 /* locfhrnm */, SystemZ::LOCFHRAsmNM, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5891 /* locfhrno */, SystemZ::LOCFHRAsmNO, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5900 /* locfhrnp */, SystemZ::LOCFHRAsmNP, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5909 /* locfhrnz */, SystemZ::LOCFHRAsmNZ, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5918 /* locfhro */, SystemZ::LOCFHRAsmO, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5926 /* locfhrp */, SystemZ::LOCFHRAsmP, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5934 /* locfhrz */, SystemZ::LOCFHRAsmZ, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5942 /* locfhz */, SystemZ::LOCFHAsmZ, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5949 /* locg */, SystemZ::LOCGAsm, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5954 /* locge */, SystemZ::LOCGAsmE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5960 /* locgh */, SystemZ::LOCGAsmH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5966 /* locghe */, SystemZ::LOCGAsmHE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5973 /* locghi */, SystemZ::LOCGHIAsm, Convert__GR641_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm, MCK_U4Imm }, },
  { 5980 /* locghie */, SystemZ::LOCGHIAsmE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 5988 /* locghih */, SystemZ::LOCGHIAsmH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 5996 /* locghihe */, SystemZ::LOCGHIAsmHE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6005 /* locghil */, SystemZ::LOCGHIAsmL, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6013 /* locghile */, SystemZ::LOCGHIAsmLE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6022 /* locghilh */, SystemZ::LOCGHIAsmLH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6031 /* locghim */, SystemZ::LOCGHIAsmM, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6039 /* locghine */, SystemZ::LOCGHIAsmNE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6048 /* locghinh */, SystemZ::LOCGHIAsmNH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6057 /* locghinhe */, SystemZ::LOCGHIAsmNHE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6067 /* locghinl */, SystemZ::LOCGHIAsmNL, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6076 /* locghinle */, SystemZ::LOCGHIAsmNLE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6086 /* locghinlh */, SystemZ::LOCGHIAsmNLH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6096 /* locghinm */, SystemZ::LOCGHIAsmNM, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6105 /* locghino */, SystemZ::LOCGHIAsmNO, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6114 /* locghinp */, SystemZ::LOCGHIAsmNP, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6123 /* locghinz */, SystemZ::LOCGHIAsmNZ, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6132 /* locghio */, SystemZ::LOCGHIAsmO, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6140 /* locghip */, SystemZ::LOCGHIAsmP, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6148 /* locghiz */, SystemZ::LOCGHIAsmZ, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6156 /* locgl */, SystemZ::LOCGAsmL, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6162 /* locgle */, SystemZ::LOCGAsmLE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6169 /* locglh */, SystemZ::LOCGAsmLH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6176 /* locgm */, SystemZ::LOCGAsmM, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6182 /* locgne */, SystemZ::LOCGAsmNE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6189 /* locgnh */, SystemZ::LOCGAsmNH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6196 /* locgnhe */, SystemZ::LOCGAsmNHE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6204 /* locgnl */, SystemZ::LOCGAsmNL, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6211 /* locgnle */, SystemZ::LOCGAsmNLE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6219 /* locgnlh */, SystemZ::LOCGAsmNLH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6227 /* locgnm */, SystemZ::LOCGAsmNM, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6234 /* locgno */, SystemZ::LOCGAsmNO, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6241 /* locgnp */, SystemZ::LOCGAsmNP, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6248 /* locgnz */, SystemZ::LOCGAsmNZ, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6255 /* locgo */, SystemZ::LOCGAsmO, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6261 /* locgp */, SystemZ::LOCGAsmP, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6267 /* locgr */, SystemZ::LOCGRAsm, Convert__GR641_0__Tie0_1_1__GR641_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 6273 /* locgre */, SystemZ::LOCGRAsmE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6280 /* locgrh */, SystemZ::LOCGRAsmH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6287 /* locgrhe */, SystemZ::LOCGRAsmHE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6295 /* locgrl */, SystemZ::LOCGRAsmL, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6302 /* locgrle */, SystemZ::LOCGRAsmLE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6310 /* locgrlh */, SystemZ::LOCGRAsmLH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6318 /* locgrm */, SystemZ::LOCGRAsmM, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6325 /* locgrne */, SystemZ::LOCGRAsmNE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6333 /* locgrnh */, SystemZ::LOCGRAsmNH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6341 /* locgrnhe */, SystemZ::LOCGRAsmNHE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6350 /* locgrnl */, SystemZ::LOCGRAsmNL, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6358 /* locgrnle */, SystemZ::LOCGRAsmNLE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6367 /* locgrnlh */, SystemZ::LOCGRAsmNLH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6376 /* locgrnm */, SystemZ::LOCGRAsmNM, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6384 /* locgrno */, SystemZ::LOCGRAsmNO, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6392 /* locgrnp */, SystemZ::LOCGRAsmNP, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6400 /* locgrnz */, SystemZ::LOCGRAsmNZ, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6408 /* locgro */, SystemZ::LOCGRAsmO, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6415 /* locgrp */, SystemZ::LOCGRAsmP, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6422 /* locgrz */, SystemZ::LOCGRAsmZ, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6429 /* locgz */, SystemZ::LOCGAsmZ, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6435 /* loch */, SystemZ::LOCAsmH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6440 /* loche */, SystemZ::LOCAsmHE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6446 /* lochhi */, SystemZ::LOCHHIAsm, Convert__GRH321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm, MCK_U4Imm }, },
  { 6453 /* lochhie */, SystemZ::LOCHHIAsmE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6461 /* lochhih */, SystemZ::LOCHHIAsmH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6469 /* lochhihe */, SystemZ::LOCHHIAsmHE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6478 /* lochhil */, SystemZ::LOCHHIAsmL, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6486 /* lochhile */, SystemZ::LOCHHIAsmLE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6495 /* lochhilh */, SystemZ::LOCHHIAsmLH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6504 /* lochhim */, SystemZ::LOCHHIAsmM, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6512 /* lochhine */, SystemZ::LOCHHIAsmNE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6521 /* lochhinh */, SystemZ::LOCHHIAsmNH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6530 /* lochhinhe */, SystemZ::LOCHHIAsmNHE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6540 /* lochhinl */, SystemZ::LOCHHIAsmNL, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6549 /* lochhinle */, SystemZ::LOCHHIAsmNLE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6559 /* lochhinlh */, SystemZ::LOCHHIAsmNLH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6569 /* lochhinm */, SystemZ::LOCHHIAsmNM, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6578 /* lochhino */, SystemZ::LOCHHIAsmNO, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6587 /* lochhinp */, SystemZ::LOCHHIAsmNP, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6596 /* lochhinz */, SystemZ::LOCHHIAsmNZ, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6605 /* lochhio */, SystemZ::LOCHHIAsmO, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6613 /* lochhip */, SystemZ::LOCHHIAsmP, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6621 /* lochhiz */, SystemZ::LOCHHIAsmZ, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6629 /* lochi */, SystemZ::LOCHIAsm, Convert__GR321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm, MCK_U4Imm }, },
  { 6635 /* lochie */, SystemZ::LOCHIAsmE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6642 /* lochih */, SystemZ::LOCHIAsmH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6649 /* lochihe */, SystemZ::LOCHIAsmHE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6657 /* lochil */, SystemZ::LOCHIAsmL, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6664 /* lochile */, SystemZ::LOCHIAsmLE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6672 /* lochilh */, SystemZ::LOCHIAsmLH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6680 /* lochim */, SystemZ::LOCHIAsmM, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6687 /* lochine */, SystemZ::LOCHIAsmNE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6695 /* lochinh */, SystemZ::LOCHIAsmNH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6703 /* lochinhe */, SystemZ::LOCHIAsmNHE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6712 /* lochinl */, SystemZ::LOCHIAsmNL, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6720 /* lochinle */, SystemZ::LOCHIAsmNLE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6729 /* lochinlh */, SystemZ::LOCHIAsmNLH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6738 /* lochinm */, SystemZ::LOCHIAsmNM, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6746 /* lochino */, SystemZ::LOCHIAsmNO, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6754 /* lochinp */, SystemZ::LOCHIAsmNP, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6762 /* lochinz */, SystemZ::LOCHIAsmNZ, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6770 /* lochio */, SystemZ::LOCHIAsmO, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6777 /* lochip */, SystemZ::LOCHIAsmP, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6784 /* lochiz */, SystemZ::LOCHIAsmZ, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6791 /* locl */, SystemZ::LOCAsmL, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6796 /* locle */, SystemZ::LOCAsmLE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6802 /* loclh */, SystemZ::LOCAsmLH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6808 /* locm */, SystemZ::LOCAsmM, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6813 /* locne */, SystemZ::LOCAsmNE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6819 /* locnh */, SystemZ::LOCAsmNH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6825 /* locnhe */, SystemZ::LOCAsmNHE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6832 /* locnl */, SystemZ::LOCAsmNL, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6838 /* locnle */, SystemZ::LOCAsmNLE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6845 /* locnlh */, SystemZ::LOCAsmNLH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6852 /* locnm */, SystemZ::LOCAsmNM, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6858 /* locno */, SystemZ::LOCAsmNO, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6864 /* locnp */, SystemZ::LOCAsmNP, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6870 /* locnz */, SystemZ::LOCAsmNZ, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6876 /* loco */, SystemZ::LOCAsmO, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6881 /* locp */, SystemZ::LOCAsmP, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6886 /* locr */, SystemZ::LOCRAsm, Convert__GR321_0__Tie0_1_1__GR321_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 6891 /* locre */, SystemZ::LOCRAsmE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6897 /* locrh */, SystemZ::LOCRAsmH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6903 /* locrhe */, SystemZ::LOCRAsmHE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6910 /* locrl */, SystemZ::LOCRAsmL, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6916 /* locrle */, SystemZ::LOCRAsmLE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6923 /* locrlh */, SystemZ::LOCRAsmLH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6930 /* locrm */, SystemZ::LOCRAsmM, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6936 /* locrne */, SystemZ::LOCRAsmNE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6943 /* locrnh */, SystemZ::LOCRAsmNH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6950 /* locrnhe */, SystemZ::LOCRAsmNHE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6958 /* locrnl */, SystemZ::LOCRAsmNL, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6965 /* locrnle */, SystemZ::LOCRAsmNLE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6973 /* locrnlh */, SystemZ::LOCRAsmNLH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6981 /* locrnm */, SystemZ::LOCRAsmNM, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6988 /* locrno */, SystemZ::LOCRAsmNO, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6995 /* locrnp */, SystemZ::LOCRAsmNP, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7002 /* locrnz */, SystemZ::LOCRAsmNZ, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7009 /* locro */, SystemZ::LOCRAsmO, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7015 /* locrp */, SystemZ::LOCRAsmP, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7021 /* locrz */, SystemZ::LOCRAsmZ, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7027 /* locz */, SystemZ::LOCAsmZ, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 7032 /* lpctl */, SystemZ::LPCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7038 /* lpd */, SystemZ::LPD, Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR128, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7042 /* lpdbr */, SystemZ::LPDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7048 /* lpdfr */, SystemZ::LPDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7054 /* lpdg */, SystemZ::LPDG, Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR128, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7059 /* lpdr */, SystemZ::LPDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7064 /* lpebr */, SystemZ::LPEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7070 /* lper */, SystemZ::LPER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7075 /* lpgfr */, SystemZ::LPGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7081 /* lpgr */, SystemZ::LPGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7086 /* lpp */, SystemZ::LPP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7090 /* lpq */, SystemZ::LPQ, Convert__GR1281_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7094 /* lpr */, SystemZ::LPR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7098 /* lpsw */, SystemZ::LPSW, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7103 /* lpswe */, SystemZ::LPSWE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7109 /* lpswey */, SystemZ::LPSWEY, Convert__BDAddr64Disp202_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp20 }, },
  { 7116 /* lptea */, SystemZ::LPTEA, Convert__GR641_0__GR641_1__Tie0_1_1__GR641_2__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 7122 /* lpxbr */, SystemZ::LPXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7128 /* lpxr */, SystemZ::LPXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7133 /* lr */, SystemZ::LR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7136 /* lra */, SystemZ::LRA, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 7140 /* lrag */, SystemZ::LRAG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7145 /* lray */, SystemZ::LRAY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7150 /* lrdr */, SystemZ::LRDR, Convert__FP641_0__FP1281_1, AMFBS_None, { MCK_FP64, MCK_FP128 }, },
  { 7155 /* lrer */, SystemZ::LRER, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 7160 /* lrl */, SystemZ::LRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 7164 /* lrv */, SystemZ::LRV, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7168 /* lrvg */, SystemZ::LRVG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7173 /* lrvgr */, SystemZ::LRVGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7179 /* lrvh */, SystemZ::LRVH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7184 /* lrvr */, SystemZ::LRVR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7189 /* lsctl */, SystemZ::LSCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7195 /* lt */, SystemZ::LT, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7198 /* ltdbr */, SystemZ::LTDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7204 /* ltdr */, SystemZ::LTDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7209 /* ltdtr */, SystemZ::LTDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7215 /* ltebr */, SystemZ::LTEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7221 /* lter */, SystemZ::LTER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7226 /* ltg */, SystemZ::LTG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7230 /* ltgf */, SystemZ::LTGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7235 /* ltgfr */, SystemZ::LTGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7241 /* ltgr */, SystemZ::LTGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7246 /* ltr */, SystemZ::LTR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7250 /* ltxbr */, SystemZ::LTXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7256 /* ltxr */, SystemZ::LTXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7261 /* ltxtr */, SystemZ::LTXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7267 /* lura */, SystemZ::LURA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 7272 /* lurag */, SystemZ::LURAG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7278 /* lxab */, SystemZ::LXAB, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7283 /* lxaf */, SystemZ::LXAF, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7288 /* lxag */, SystemZ::LXAG, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7293 /* lxah */, SystemZ::LXAH, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7298 /* lxaq */, SystemZ::LXAQ, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7303 /* lxd */, SystemZ::LXD, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7307 /* lxdb */, SystemZ::LXDB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7312 /* lxdbr */, SystemZ::LXDBR, Convert__FP1281_0__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7318 /* lxdr */, SystemZ::LXDR, Convert__FP1281_0__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7323 /* lxdtr */, SystemZ::LXDTR, Convert__FP1281_0__FP641_1__U4Imm1_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_U4Imm }, },
  { 7329 /* lxe */, SystemZ::LXE, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7333 /* lxeb */, SystemZ::LXEB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7338 /* lxebr */, SystemZ::LXEBR, Convert__FP1281_0__FP321_1, AMFBS_None, { MCK_FP128, MCK_FP32 }, },
  { 7344 /* lxer */, SystemZ::LXER, Convert__FP1281_0__FP321_1, AMFBS_None, { MCK_FP128, MCK_FP32 }, },
  { 7349 /* lxr */, SystemZ::LXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7353 /* ly */, SystemZ::LY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7356 /* lzdr */, SystemZ::LZDR, Convert__FP641_0, AMFBS_None, { MCK_FP64 }, },
  { 7361 /* lzer */, SystemZ::LZER, Convert__FP321_0, AMFBS_None, { MCK_FP32 }, },
  { 7366 /* lzrf */, SystemZ::LZRF, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7371 /* lzrg */, SystemZ::LZRG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7376 /* lzxr */, SystemZ::LZXR, Convert__FP1281_0, AMFBS_None, { MCK_FP128 }, },
  { 7381 /* m */, SystemZ::M, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp12 }, },
  { 7383 /* mad */, SystemZ::MAD, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7387 /* madb */, SystemZ::MADB, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7392 /* madbr */, SystemZ::MADBR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7398 /* madr */, SystemZ::MADR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7403 /* mae */, SystemZ::MAE, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7407 /* maeb */, SystemZ::MAEB, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7412 /* maebr */, SystemZ::MAEBR, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7418 /* maer */, SystemZ::MAER, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7423 /* may */, SystemZ::MAY, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7427 /* mayh */, SystemZ::MAYH, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7432 /* mayhr */, SystemZ::MAYHR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7438 /* mayl */, SystemZ::MAYL, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7443 /* maylr */, SystemZ::MAYLR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7449 /* mayr */, SystemZ::MAYR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7454 /* mc */, SystemZ::MC, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7457 /* md */, SystemZ::MD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7460 /* mdb */, SystemZ::MDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7464 /* mdbr */, SystemZ::MDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7469 /* mde */, SystemZ::MDE, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7473 /* mdeb */, SystemZ::MDEB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7478 /* mdebr */, SystemZ::MDEBR, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7484 /* mder */, SystemZ::MDER, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7489 /* mdr */, SystemZ::MDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7493 /* mdtr */, SystemZ::MDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7498 /* mdtra */, SystemZ::MDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 7504 /* me */, SystemZ::ME, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7507 /* mee */, SystemZ::MEE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7511 /* meeb */, SystemZ::MEEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7516 /* meebr */, SystemZ::MEEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7522 /* meer */, SystemZ::MEER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7527 /* mer */, SystemZ::MER, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7531 /* mfy */, SystemZ::MFY, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7535 /* mg */, SystemZ::MG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7538 /* mgh */, SystemZ::MGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7542 /* mghi */, SystemZ::MGHI, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 7547 /* mgrk */, SystemZ::MGRK, Convert__GR1281_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR128, MCK_GR64, MCK_GR64 }, },
  { 7552 /* mh */, SystemZ::MH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7555 /* mhi */, SystemZ::MHI, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 7559 /* mhy */, SystemZ::MHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7563 /* ml */, SystemZ::ML, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7566 /* mlg */, SystemZ::MLG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7570 /* mlgr */, SystemZ::MLGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 7575 /* mlr */, SystemZ::MLR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 7579 /* mp */, SystemZ::MP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 7582 /* mr */, SystemZ::MR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 7585 /* ms */, SystemZ::MS, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7588 /* msc */, SystemZ::MSC, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7592 /* msch */, SystemZ::MSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7597 /* msd */, SystemZ::MSD, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7601 /* msdb */, SystemZ::MSDB, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7606 /* msdbr */, SystemZ::MSDBR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7612 /* msdr */, SystemZ::MSDR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7617 /* mse */, SystemZ::MSE, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7621 /* mseb */, SystemZ::MSEB, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7626 /* msebr */, SystemZ::MSEBR, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7632 /* mser */, SystemZ::MSER, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7637 /* msfi */, SystemZ::MSFI, Convert__GR321_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 7642 /* msg */, SystemZ::MSG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7646 /* msgc */, SystemZ::MSGC, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7651 /* msgf */, SystemZ::MSGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7656 /* msgfi */, SystemZ::MSGFI, Convert__GR641_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 7662 /* msgfr */, SystemZ::MSGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7668 /* msgr */, SystemZ::MSGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7673 /* msgrkc */, SystemZ::MSGRKC, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7680 /* msr */, SystemZ::MSR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7684 /* msrkc */, SystemZ::MSRKC, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7690 /* msta */, SystemZ::MSTA, Convert__GR1281_0, AMFBS_None, { MCK_GR128 }, },
  { 7695 /* msy */, SystemZ::MSY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7699 /* mvc */, SystemZ::MVC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7703 /* mvcdk */, SystemZ::MVCDK, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7709 /* mvcin */, SystemZ::MVCIN, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7715 /* mvck */, SystemZ::MVCK, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7720 /* mvcl */, SystemZ::MVCL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 7725 /* mvcle */, SystemZ::MVCLE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 7731 /* mvclu */, SystemZ::MVCLU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp20 }, },
  { 7737 /* mvcos */, SystemZ::MVCOS, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7743 /* mvcp */, SystemZ::MVCP, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7748 /* mvcrl */, SystemZ::MVCRL, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7754 /* mvcs */, SystemZ::MVCS, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7759 /* mvcsk */, SystemZ::MVCSK, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7765 /* mvghi */, SystemZ::MVGHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7771 /* mvhhi */, SystemZ::MVHHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7777 /* mvhi */, SystemZ::MVHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7782 /* mvi */, SystemZ::MVI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7786 /* mviy */, SystemZ::MVIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 7791 /* mvn */, SystemZ::MVN, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7795 /* mvo */, SystemZ::MVO, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 7799 /* mvpg */, SystemZ::MVPG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7804 /* mvst */, SystemZ::MVST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7809 /* mvz */, SystemZ::MVZ, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7813 /* mxbr */, SystemZ::MXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7818 /* mxd */, SystemZ::MXD, Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7822 /* mxdb */, SystemZ::MXDB, Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7827 /* mxdbr */, SystemZ::MXDBR, Convert__FP1281_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7833 /* mxdr */, SystemZ::MXDR, Convert__FP1281_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7838 /* mxr */, SystemZ::MXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7842 /* mxtr */, SystemZ::MXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 7847 /* mxtra */, SystemZ::MXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 7853 /* my */, SystemZ::MY, Convert__FP1281_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7856 /* myh */, SystemZ::MYH, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7860 /* myhr */, SystemZ::MYHR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7865 /* myl */, SystemZ::MYL, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7869 /* mylr */, SystemZ::MYLR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7874 /* myr */, SystemZ::MYR, Convert__FP1281_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_FP64 }, },
  { 7878 /* n */, SystemZ::N, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7880 /* nc */, SystemZ::NC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7883 /* ncgrk */, SystemZ::NCGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7889 /* ncrk */, SystemZ::NCRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7894 /* ng */, SystemZ::NG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7897 /* ngr */, SystemZ::NGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7901 /* ngrk */, SystemZ::NGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7906 /* ni */, SystemZ::NI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7909 /* niai */, SystemZ::NIAI, Convert__U4Imm1_0__U4Imm1_1, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_U4Imm }, },
  { 7914 /* nihf */, SystemZ::NIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 7919 /* nihh */, SystemZ::NIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 7924 /* nihl */, SystemZ::NIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 7929 /* nilf */, SystemZ::NILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 7934 /* nilh */, SystemZ::NILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 7939 /* nill */, SystemZ::NILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 7944 /* niy */, SystemZ::NIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 7948 /* nngrk */, SystemZ::NNGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7954 /* nnpa */, SystemZ::NNPA, Convert_NoOperands, AMFBS_FeatureNNPAssist, {  }, },
  { 7959 /* nnrk */, SystemZ::NNRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7964 /* nogrk */, SystemZ::NOGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7970 /* nop */, SystemZ::NOPOpt, Convert_NoOperands, AMFBS_None, {  }, },
  { 7970 /* nop */, SystemZ::NOP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 7974 /* nopr */, SystemZ::NOPROpt, Convert_NoOperands, AMFBS_None, {  }, },
  { 7974 /* nopr */, SystemZ::NOPR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 7979 /* nork */, SystemZ::NORK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7984 /* notgr */, SystemZ::NOTGR, Convert__GR641_0__GR641_1__imm_95_0, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64 }, },
  { 7990 /* notr */, SystemZ::NOTR, Convert__GR321_0__GR321_1__imm_95_0, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32 }, },
  { 7995 /* nr */, SystemZ::NR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7998 /* nrk */, SystemZ::NRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8002 /* ntstg */, SystemZ::NTSTG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureTransactionalExecution, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8008 /* nxgrk */, SystemZ::NXGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8014 /* nxrk */, SystemZ::NXRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8019 /* ny */, SystemZ::NY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8022 /* o */, SystemZ::O, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8024 /* oc */, SystemZ::OC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 8027 /* ocgrk */, SystemZ::OCGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8033 /* ocrk */, SystemZ::OCRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8038 /* og */, SystemZ::OG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8041 /* ogr */, SystemZ::OGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8045 /* ogrk */, SystemZ::OGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8050 /* oi */, SystemZ::OI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 8053 /* oihf */, SystemZ::OIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 8058 /* oihh */, SystemZ::OIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 8063 /* oihl */, SystemZ::OIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 8068 /* oilf */, SystemZ::OILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 8073 /* oilh */, SystemZ::OILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 8078 /* oill */, SystemZ::OILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 8083 /* oiy */, SystemZ::OIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 8087 /* or */, SystemZ::OR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 8090 /* ork */, SystemZ::ORK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8094 /* oy */, SystemZ::OY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8097 /* pack */, SystemZ::PACK, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 8102 /* palb */, SystemZ::PALB, Convert_NoOperands, AMFBS_None, {  }, },
  { 8107 /* pc */, SystemZ::PC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8110 /* pcc */, SystemZ::PCC, Convert_NoOperands, AMFBS_FeatureMessageSecurityAssist4, {  }, },
  { 8114 /* pckmo */, SystemZ::PCKMO, Convert_NoOperands, AMFBS_FeatureMessageSecurityAssist3, {  }, },
  { 8120 /* pfcr */, SystemZ::PFCR, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 8125 /* pfd */, SystemZ::PFD, Convert__U4Imm1_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_U4Imm, MCK_BDXAddr64Disp20 }, },
  { 8129 /* pfdrl */, SystemZ::PFDRL, Convert__U4Imm1_0__PCRel321_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel32 }, },
  { 8135 /* pfmf */, SystemZ::PFMF, Convert__GR641_1__GR321_0__Tie0_1_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8140 /* pfpo */, SystemZ::PFPO, Convert_NoOperands, AMFBS_None, {  }, },
  { 8145 /* pgin */, SystemZ::PGIN, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8150 /* pgout */, SystemZ::PGOUT, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8156 /* pka */, SystemZ::PKA, Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDLAddr64Disp12Len8 }, },
  { 8160 /* pku */, SystemZ::PKU, Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDLAddr64Disp12Len8 }, },
  { 8164 /* plo */, SystemZ::PLO, Convert__GR641_0__BDAddr64Disp122_1__GR641_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_BDAddr64Disp12, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 8168 /* popcnt */, SystemZ::POPCNT, Convert__GR641_0__GR641_1, AMFBS_FeaturePopulationCount, { MCK_GR64, MCK_GR64 }, },
  { 8168 /* popcnt */, SystemZ::POPCNTOpt, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8175 /* ppa */, SystemZ::PPA, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_FeatureProcessorAssist, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8179 /* ppno */, SystemZ::PPNO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist5, { MCK_GR128, MCK_GR128 }, },
  { 8184 /* pr */, SystemZ::PR, Convert_NoOperands, AMFBS_None, {  }, },
  { 8187 /* prno */, SystemZ::PRNO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist7, { MCK_GR128, MCK_GR128 }, },
  { 8192 /* pt */, SystemZ::PT, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8195 /* ptf */, SystemZ::PTF, Convert__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 8199 /* ptff */, SystemZ::PTFF, Convert_NoOperands, AMFBS_None, {  }, },
  { 8204 /* pti */, SystemZ::PTI, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8208 /* ptlb */, SystemZ::PTLB, Convert_NoOperands, AMFBS_None, {  }, },
  { 8213 /* qadtr */, SystemZ::QADTR, Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 8219 /* qaxtr */, SystemZ::QAXTR, Convert__FP1281_0__FP1281_1__Tie0_1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 8225 /* qctri */, SystemZ::QCTRI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8231 /* qpaci */, SystemZ::QPACI, Convert__BDAddr64Disp122_0, AMFBS_FeatureProcessorActivityInstrumentation, { MCK_BDAddr64Disp12 }, },
  { 8237 /* qsi */, SystemZ::QSI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8241 /* rchp */, SystemZ::RCHP, Convert_NoOperands, AMFBS_None, {  }, },
  { 8246 /* rdp */, SystemZ::RDPOpt, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureResetDATProtection, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8246 /* rdp */, SystemZ::RDP, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_FeatureResetDATProtection, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8250 /* risbg */, SystemZ::RISBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8256 /* risbgn */, SystemZ::RISBGN, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8263 /* risbgnz */, SystemZ::RISBGNZ, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8271 /* risbgz */, SystemZ::RISBGZ, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8278 /* risbhg */, SystemZ::RISBHG, Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8285 /* risblg */, SystemZ::RISBLG, Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureHighWord, { MCK_GR32, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8292 /* rll */, SystemZ::RLL, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 8296 /* rllg */, SystemZ::RLLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 8301 /* rnsbg */, SystemZ::RNSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8307 /* rosbg */, SystemZ::ROSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8313 /* rp */, SystemZ::RP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8316 /* rrbe */, SystemZ::RRBE, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8321 /* rrbm */, SystemZ::RRBM, Convert__GR641_0__GR641_1, AMFBS_FeatureResetReferenceBitsMultiple, { MCK_GR64, MCK_GR64 }, },
  { 8326 /* rrdtr */, SystemZ::RRDTR, Convert__FP641_0__FP641_1__Tie0_1_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_GR32, MCK_U4Imm }, },
  { 8332 /* rrxtr */, SystemZ::RRXTR, Convert__FP1281_0__FP1281_1__Tie0_1_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_GR32, MCK_U4Imm }, },
  { 8338 /* rsch */, SystemZ::RSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 8343 /* rxsbg */, SystemZ::RXSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8349 /* s */, SystemZ::S, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8351 /* sac */, SystemZ::SAC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8355 /* sacf */, SystemZ::SACF, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8360 /* sal */, SystemZ::SAL, Convert_NoOperands, AMFBS_None, {  }, },
  { 8364 /* sam24 */, SystemZ::SAM24, Convert_NoOperands, AMFBS_None, {  }, },
  { 8370 /* sam31 */, SystemZ::SAM31, Convert_NoOperands, AMFBS_None, {  }, },
  { 8376 /* sam64 */, SystemZ::SAM64, Convert_NoOperands, AMFBS_None, {  }, },
  { 8382 /* sar */, SystemZ::SAR, Convert__AR321_0__GR321_1, AMFBS_None, { MCK_AR32, MCK_GR32 }, },
  { 8386 /* scctr */, SystemZ::SCCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8392 /* schm */, SystemZ::SCHM, Convert_NoOperands, AMFBS_None, {  }, },
  { 8397 /* sck */, SystemZ::SCK, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8401 /* sckc */, SystemZ::SCKC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8406 /* sckpf */, SystemZ::SCKPF, Convert_NoOperands, AMFBS_None, {  }, },
  { 8412 /* sd */, SystemZ::SD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 8415 /* sdb */, SystemZ::SDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 8419 /* sdbr */, SystemZ::SDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 8424 /* sdr */, SystemZ::SDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 8428 /* sdtr */, SystemZ::SDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 8433 /* sdtra */, SystemZ::SDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 8439 /* se */, SystemZ::SE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 8442 /* seb */, SystemZ::SEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 8446 /* sebr */, SystemZ::SEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 8451 /* selfhr */, SystemZ::SELFHRAsm, Convert__GRH321_0__GRH321_2__GRH321_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32, MCK_U4Imm }, },
  { 8458 /* selfhre */, SystemZ::SELFHRAsmE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8466 /* selfhrh */, SystemZ::SELFHRAsmH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8474 /* selfhrhe */, SystemZ::SELFHRAsmHE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8483 /* selfhrl */, SystemZ::SELFHRAsmL, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8491 /* selfhrle */, SystemZ::SELFHRAsmLE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8500 /* selfhrlh */, SystemZ::SELFHRAsmLH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8509 /* selfhrm */, SystemZ::SELFHRAsmM, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8517 /* selfhrne */, SystemZ::SELFHRAsmNE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8526 /* selfhrnh */, SystemZ::SELFHRAsmNH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8535 /* selfhrnhe */, SystemZ::SELFHRAsmNHE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8545 /* selfhrnl */, SystemZ::SELFHRAsmNL, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8554 /* selfhrnle */, SystemZ::SELFHRAsmNLE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8564 /* selfhrnlh */, SystemZ::SELFHRAsmNLH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8574 /* selfhrnm */, SystemZ::SELFHRAsmNM, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8583 /* selfhrno */, SystemZ::SELFHRAsmNO, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8592 /* selfhrnp */, SystemZ::SELFHRAsmNP, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8601 /* selfhrnz */, SystemZ::SELFHRAsmNZ, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8610 /* selfhro */, SystemZ::SELFHRAsmO, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8618 /* selfhrp */, SystemZ::SELFHRAsmP, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8626 /* selfhrz */, SystemZ::SELFHRAsmZ, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8634 /* selgr */, SystemZ::SELGRAsm, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8640 /* selgre */, SystemZ::SELGRAsmE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8647 /* selgrh */, SystemZ::SELGRAsmH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8654 /* selgrhe */, SystemZ::SELGRAsmHE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8662 /* selgrl */, SystemZ::SELGRAsmL, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8669 /* selgrle */, SystemZ::SELGRAsmLE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8677 /* selgrlh */, SystemZ::SELGRAsmLH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8685 /* selgrm */, SystemZ::SELGRAsmM, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8692 /* selgrne */, SystemZ::SELGRAsmNE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8700 /* selgrnh */, SystemZ::SELGRAsmNH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8708 /* selgrnhe */, SystemZ::SELGRAsmNHE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8717 /* selgrnl */, SystemZ::SELGRAsmNL, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8725 /* selgrnle */, SystemZ::SELGRAsmNLE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8734 /* selgrnlh */, SystemZ::SELGRAsmNLH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8743 /* selgrnm */, SystemZ::SELGRAsmNM, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8751 /* selgrno */, SystemZ::SELGRAsmNO, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8759 /* selgrnp */, SystemZ::SELGRAsmNP, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8767 /* selgrnz */, SystemZ::SELGRAsmNZ, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8775 /* selgro */, SystemZ::SELGRAsmO, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8782 /* selgrp */, SystemZ::SELGRAsmP, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8789 /* selgrz */, SystemZ::SELGRAsmZ, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8796 /* selr */, SystemZ::SELRAsm, Convert__GR321_0__GR321_2__GR321_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 8801 /* selre */, SystemZ::SELRAsmE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8807 /* selrh */, SystemZ::SELRAsmH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8813 /* selrhe */, SystemZ::SELRAsmHE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8820 /* selrl */, SystemZ::SELRAsmL, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8826 /* selrle */, SystemZ::SELRAsmLE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8833 /* selrlh */, SystemZ::SELRAsmLH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8840 /* selrm */, SystemZ::SELRAsmM, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8846 /* selrne */, SystemZ::SELRAsmNE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8853 /* selrnh */, SystemZ::SELRAsmNH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8860 /* selrnhe */, SystemZ::SELRAsmNHE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8868 /* selrnl */, SystemZ::SELRAsmNL, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8875 /* selrnle */, SystemZ::SELRAsmNLE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8883 /* selrnlh */, SystemZ::SELRAsmNLH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8891 /* selrnm */, SystemZ::SELRAsmNM, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8898 /* selrno */, SystemZ::SELRAsmNO, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8905 /* selrnp */, SystemZ::SELRAsmNP, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8912 /* selrnz */, SystemZ::SELRAsmNZ, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8919 /* selro */, SystemZ::SELRAsmO, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8925 /* selrp */, SystemZ::SELRAsmP, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8931 /* selrz */, SystemZ::SELRAsmZ, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8937 /* ser */, SystemZ::SER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 8941 /* sfasr */, SystemZ::SFASR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 8947 /* sfpc */, SystemZ::SFPC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 8952 /* sg */, SystemZ::SG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8955 /* sgf */, SystemZ::SGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8959 /* sgfr */, SystemZ::SGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 8964 /* sgh */, SystemZ::SGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8968 /* sgr */, SystemZ::SGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8972 /* sgrk */, SystemZ::SGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8977 /* sh */, SystemZ::SH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8980 /* shhhr */, SystemZ::SHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8986 /* shhlr */, SystemZ::SHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 8992 /* shy */, SystemZ::SHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8996 /* sie */, SystemZ::SIE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9000 /* siga */, SystemZ::SIGA, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9005 /* sigp */, SystemZ::SIGP, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 9010 /* sl */, SystemZ::SL, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9013 /* sla */, SystemZ::SLA, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9017 /* slag */, SystemZ::SLAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9022 /* slak */, SystemZ::SLAK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9027 /* slb */, SystemZ::SLB, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9031 /* slbg */, SystemZ::SLBG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9036 /* slbgr */, SystemZ::SLBGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9042 /* slbr */, SystemZ::SLBR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9047 /* slda */, SystemZ::SLDA, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9052 /* sldl */, SystemZ::SLDL, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9057 /* sldt */, SystemZ::SLDT, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9062 /* slfi */, SystemZ::SLFI, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 9067 /* slg */, SystemZ::SLG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9071 /* slgf */, SystemZ::SLGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9076 /* slgfi */, SystemZ::SLGFI, Convert__GR641_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 9082 /* slgfr */, SystemZ::SLGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 9088 /* slgr */, SystemZ::SLGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9093 /* slgrk */, SystemZ::SLGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 9099 /* slhhhr */, SystemZ::SLHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 9106 /* slhhlr */, SystemZ::SLHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 9113 /* sll */, SystemZ::SLL, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9117 /* sllg */, SystemZ::SLLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9122 /* sllk */, SystemZ::SLLK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9127 /* slr */, SystemZ::SLR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9131 /* slrk */, SystemZ::SLRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 9136 /* slxt */, SystemZ::SLXT, Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 9141 /* sly */, SystemZ::SLY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9145 /* sortl */, SystemZ::SORTL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureEnhancedSort, { MCK_GR128, MCK_GR128 }, },
  { 9151 /* sp */, SystemZ::SP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 9154 /* spctr */, SystemZ::SPCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9160 /* spka */, SystemZ::SPKA, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9165 /* spm */, SystemZ::SPM, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 9169 /* spt */, SystemZ::SPT, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9173 /* spx */, SystemZ::SPX, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9177 /* sqd */, SystemZ::SQD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9181 /* sqdb */, SystemZ::SQDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9186 /* sqdbr */, SystemZ::SQDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 9192 /* sqdr */, SystemZ::SQDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 9197 /* sqe */, SystemZ::SQE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9201 /* sqeb */, SystemZ::SQEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9206 /* sqebr */, SystemZ::SQEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 9212 /* sqer */, SystemZ::SQER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 9217 /* sqxbr */, SystemZ::SQXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 9223 /* sqxr */, SystemZ::SQXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 9228 /* sr */, SystemZ::SR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9231 /* sra */, SystemZ::SRA, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9235 /* srag */, SystemZ::SRAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9240 /* srak */, SystemZ::SRAK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9245 /* srda */, SystemZ::SRDA, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9250 /* srdl */, SystemZ::SRDL, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9255 /* srdt */, SystemZ::SRDT, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9260 /* srk */, SystemZ::SRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 9264 /* srl */, SystemZ::SRL, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9268 /* srlg */, SystemZ::SRLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9273 /* srlk */, SystemZ::SRLK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9278 /* srnm */, SystemZ::SRNM, Convert__BDAddr32Disp122_0, AMFBS_None, { MCK_BDAddr32Disp12 }, },
  { 9283 /* srnmb */, SystemZ::SRNMB, Convert__BDAddr32Disp122_0, AMFBS_FeatureFPExtension, { MCK_BDAddr32Disp12 }, },
  { 9289 /* srnmt */, SystemZ::SRNMT, Convert__BDAddr32Disp122_0, AMFBS_None, { MCK_BDAddr32Disp12 }, },
  { 9295 /* srp */, SystemZ::SRP, Convert__BDLAddr64Disp12Len43_0__BDAddr32Disp122_1__U4Imm1_2, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 9299 /* srst */, SystemZ::SRST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9304 /* srstu */, SystemZ::SRSTU, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9310 /* srxt */, SystemZ::SRXT, Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 9315 /* ssair */, SystemZ::SSAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 9321 /* ssar */, SystemZ::SSAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 9326 /* ssch */, SystemZ::SSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9331 /* sske */, SystemZ::SSKEOpt, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 9331 /* sske */, SystemZ::SSKE, Convert__GR321_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR64, MCK_U4Imm }, },
  { 9336 /* ssm */, SystemZ::SSM, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9340 /* st */, SystemZ::ST, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9343 /* stam */, SystemZ::STAM, Convert__AR321_0__AR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp12 }, },
  { 9348 /* stamy */, SystemZ::STAMY, Convert__AR321_0__AR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp20 }, },
  { 9354 /* stap */, SystemZ::STAP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9359 /* stbear */, SystemZ::STBEAR, Convert__BDAddr64Disp122_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp12 }, },
  { 9366 /* stc */, SystemZ::STC, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9370 /* stch */, SystemZ::STCH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9375 /* stck */, SystemZ::STCK, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9380 /* stckc */, SystemZ::STCKC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9386 /* stcke */, SystemZ::STCKE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9392 /* stckf */, SystemZ::STCKF, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9398 /* stcm */, SystemZ::STCM, Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 9403 /* stcmh */, SystemZ::STCMH, Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 9409 /* stcmy */, SystemZ::STCMY, Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 9415 /* stcps */, SystemZ::STCPS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9421 /* stcrw */, SystemZ::STCRW, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9427 /* stctg */, SystemZ::STCTG, Convert__CR641_0__CR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp20 }, },
  { 9433 /* stctl */, SystemZ::STCTL, Convert__CR641_0__CR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp12 }, },
  { 9439 /* stcy */, SystemZ::STCY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9444 /* std */, SystemZ::STD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9448 /* stdrv */, SystemZ::VSTEBRG, Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 9454 /* stdy */, SystemZ::STDY, Convert__FP641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp20 }, },
  { 9459 /* ste */, SystemZ::STE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9463 /* sterv */, SystemZ::VSTEBRF, Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 9469 /* stey */, SystemZ::STEY, Convert__FP321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp20 }, },
  { 9474 /* stfh */, SystemZ::STFH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9479 /* stfl */, SystemZ::STFL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9484 /* stfle */, SystemZ::STFLE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9490 /* stfpc */, SystemZ::STFPC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9496 /* stg */, SystemZ::STG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9500 /* stgrl */, SystemZ::STGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 9506 /* stgsc */, SystemZ::STGSC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9512 /* sth */, SystemZ::STH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9516 /* sthh */, SystemZ::STHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9521 /* sthrl */, SystemZ::STHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 9527 /* sthy */, SystemZ::STHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9532 /* stidp */, SystemZ::STIDP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9538 /* stm */, SystemZ::STM, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 9542 /* stmg */, SystemZ::STMG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9547 /* stmh */, SystemZ::STMH, Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9552 /* stmy */, SystemZ::STMY, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9557 /* stnsm */, SystemZ::STNSM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 9563 /* stoc */, SystemZ::STOCAsm, Convert__GR321_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9568 /* stoce */, SystemZ::STOCAsmE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9574 /* stocfh */, SystemZ::STOCFHAsm, Convert__GRH321_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9581 /* stocfhe */, SystemZ::STOCFHAsmE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9589 /* stocfhh */, SystemZ::STOCFHAsmH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9597 /* stocfhhe */, SystemZ::STOCFHAsmHE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9606 /* stocfhl */, SystemZ::STOCFHAsmL, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9614 /* stocfhle */, SystemZ::STOCFHAsmLE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9623 /* stocfhlh */, SystemZ::STOCFHAsmLH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9632 /* stocfhm */, SystemZ::STOCFHAsmM, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9640 /* stocfhne */, SystemZ::STOCFHAsmNE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9649 /* stocfhnh */, SystemZ::STOCFHAsmNH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9658 /* stocfhnhe */, SystemZ::STOCFHAsmNHE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9668 /* stocfhnl */, SystemZ::STOCFHAsmNL, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9677 /* stocfhnle */, SystemZ::STOCFHAsmNLE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9687 /* stocfhnlh */, SystemZ::STOCFHAsmNLH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9697 /* stocfhnm */, SystemZ::STOCFHAsmNM, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9706 /* stocfhno */, SystemZ::STOCFHAsmNO, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9715 /* stocfhnp */, SystemZ::STOCFHAsmNP, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9724 /* stocfhnz */, SystemZ::STOCFHAsmNZ, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9733 /* stocfho */, SystemZ::STOCFHAsmO, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9741 /* stocfhp */, SystemZ::STOCFHAsmP, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9749 /* stocfhz */, SystemZ::STOCFHAsmZ, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9757 /* stocg */, SystemZ::STOCGAsm, Convert__GR641_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9763 /* stocge */, SystemZ::STOCGAsmE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9770 /* stocgh */, SystemZ::STOCGAsmH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9777 /* stocghe */, SystemZ::STOCGAsmHE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9785 /* stocgl */, SystemZ::STOCGAsmL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9792 /* stocgle */, SystemZ::STOCGAsmLE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9800 /* stocglh */, SystemZ::STOCGAsmLH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9808 /* stocgm */, SystemZ::STOCGAsmM, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9815 /* stocgne */, SystemZ::STOCGAsmNE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9823 /* stocgnh */, SystemZ::STOCGAsmNH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9831 /* stocgnhe */, SystemZ::STOCGAsmNHE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9840 /* stocgnl */, SystemZ::STOCGAsmNL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9848 /* stocgnle */, SystemZ::STOCGAsmNLE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9857 /* stocgnlh */, SystemZ::STOCGAsmNLH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9866 /* stocgnm */, SystemZ::STOCGAsmNM, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9874 /* stocgno */, SystemZ::STOCGAsmNO, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9882 /* stocgnp */, SystemZ::STOCGAsmNP, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9890 /* stocgnz */, SystemZ::STOCGAsmNZ, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9898 /* stocgo */, SystemZ::STOCGAsmO, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9905 /* stocgp */, SystemZ::STOCGAsmP, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9912 /* stocgz */, SystemZ::STOCGAsmZ, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9919 /* stoch */, SystemZ::STOCAsmH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9925 /* stoche */, SystemZ::STOCAsmHE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9932 /* stocl */, SystemZ::STOCAsmL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9938 /* stocle */, SystemZ::STOCAsmLE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9945 /* stoclh */, SystemZ::STOCAsmLH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9952 /* stocm */, SystemZ::STOCAsmM, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9958 /* stocne */, SystemZ::STOCAsmNE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9965 /* stocnh */, SystemZ::STOCAsmNH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9972 /* stocnhe */, SystemZ::STOCAsmNHE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9980 /* stocnl */, SystemZ::STOCAsmNL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9987 /* stocnle */, SystemZ::STOCAsmNLE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9995 /* stocnlh */, SystemZ::STOCAsmNLH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10003 /* stocnm */, SystemZ::STOCAsmNM, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10010 /* stocno */, SystemZ::STOCAsmNO, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10017 /* stocnp */, SystemZ::STOCAsmNP, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10024 /* stocnz */, SystemZ::STOCAsmNZ, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10031 /* stoco */, SystemZ::STOCAsmO, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10037 /* stocp */, SystemZ::STOCAsmP, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10043 /* stocz */, SystemZ::STOCAsmZ, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10049 /* stosm */, SystemZ::STOSM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 10055 /* stpq */, SystemZ::STPQ, Convert__GR1281_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 10060 /* stpt */, SystemZ::STPT, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10065 /* stpx */, SystemZ::STPX, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10070 /* strag */, SystemZ::STRAG, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 10076 /* strl */, SystemZ::STRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 10081 /* strv */, SystemZ::STRV, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10086 /* strvg */, SystemZ::STRVG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 10092 /* strvh */, SystemZ::STRVH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10098 /* stsch */, SystemZ::STSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10104 /* stsi */, SystemZ::STSI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10109 /* stura */, SystemZ::STURA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 10115 /* sturg */, SystemZ::STURG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 10121 /* sty */, SystemZ::STY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10125 /* su */, SystemZ::SU, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10128 /* sur */, SystemZ::SUR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 10132 /* svc */, SystemZ::SVC, Convert__U8Imm1_0, AMFBS_None, { MCK_U8Imm }, },
  { 10136 /* sw */, SystemZ::SW, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10139 /* swr */, SystemZ::SWR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 10143 /* sxbr */, SystemZ::SXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 10148 /* sxr */, SystemZ::SXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 10152 /* sxtr */, SystemZ::SXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 10157 /* sxtra */, SystemZ::SXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 10163 /* sy */, SystemZ::SY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10166 /* tabort */, SystemZ::TABORT, Convert__BDAddr64Disp122_0, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12 }, },
  { 10173 /* tam */, SystemZ::TAM, Convert_NoOperands, AMFBS_None, {  }, },
  { 10177 /* tar */, SystemZ::TAR, Convert__AR321_0__GR321_1, AMFBS_None, { MCK_AR32, MCK_GR32 }, },
  { 10181 /* tb */, SystemZ::TB, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 10184 /* tbdr */, SystemZ::TBDR, Convert__FP641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64 }, },
  { 10189 /* tbedr */, SystemZ::TBEDR, Convert__FP321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP64 }, },
  { 10195 /* tbegin */, SystemZ::TBEGIN, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 10202 /* tbeginc */, SystemZ::TBEGINC, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 10210 /* tcdb */, SystemZ::TCDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10215 /* tceb */, SystemZ::TCEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10220 /* tcxb */, SystemZ::TCXB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10225 /* tdcdt */, SystemZ::TDCDT, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10231 /* tdcet */, SystemZ::TDCET, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10237 /* tdcxt */, SystemZ::TDCXT, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10243 /* tdgdt */, SystemZ::TDGDT, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10249 /* tdget */, SystemZ::TDGET, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10255 /* tdgxt */, SystemZ::TDGXT, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10261 /* tend */, SystemZ::TEND, Convert_NoOperands, AMFBS_FeatureTransactionalExecution, {  }, },
  { 10266 /* thder */, SystemZ::THDER, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 10272 /* thdr */, SystemZ::THDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 10277 /* tm */, SystemZ::TM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 10280 /* tmh */, SystemZ::TMLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10284 /* tmhh */, SystemZ::TMHH, Convert__GRH321_0__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 10289 /* tmhl */, SystemZ::TMHL, Convert__GRH321_0__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 10294 /* tml */, SystemZ::TMLL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10298 /* tmlh */, SystemZ::TMLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10303 /* tmll */, SystemZ::TMLL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10308 /* tmy */, SystemZ::TMY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 10312 /* tp */, SystemZ::TP, Convert__BDLAddr64Disp12Len43_0, AMFBS_None, { MCK_BDLAddr64Disp12Len4 }, },
  { 10315 /* tpei */, SystemZ::TPEI, Convert__GR641_0__GR641_1, AMFBS_FeatureTestPendingExternalInterruption, { MCK_GR64, MCK_GR64 }, },
  { 10320 /* tpi */, SystemZ::TPI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10324 /* tprot */, SystemZ::TPROT, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 10330 /* tr */, SystemZ::TR, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10333 /* trace */, SystemZ::TRACE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 10339 /* tracg */, SystemZ::TRACG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 10345 /* trap2 */, SystemZ::TRAP2, Convert_NoOperands, AMFBS_None, {  }, },
  { 10351 /* trap4 */, SystemZ::TRAP4, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10357 /* tre */, SystemZ::TRE, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10361 /* troo */, SystemZ::TROOOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10361 /* troo */, SystemZ::TROO, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10366 /* trot */, SystemZ::TROTOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10366 /* trot */, SystemZ::TROT, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10371 /* trt */, SystemZ::TRT, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10375 /* trte */, SystemZ::TRTEOpt, Convert__GR641_1__GR1281_0__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10375 /* trte */, SystemZ::TRTE, Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10380 /* trto */, SystemZ::TRTOOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10380 /* trto */, SystemZ::TRTO, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10385 /* trtr */, SystemZ::TRTR, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10390 /* trtre */, SystemZ::TRTREOpt, Convert__GR641_1__GR1281_0__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10390 /* trtre */, SystemZ::TRTRE, Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10396 /* trtt */, SystemZ::TRTTOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10396 /* trtt */, SystemZ::TRTT, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10401 /* ts */, SystemZ::TS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10404 /* tsch */, SystemZ::TSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10409 /* unpk */, SystemZ::UNPK, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 10414 /* unpka */, SystemZ::UNPKA, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10420 /* unpku */, SystemZ::UNPKU, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10426 /* upt */, SystemZ::UPT, Convert_NoOperands, AMFBS_None, {  }, },
  { 10430 /* va */, SystemZ::VA, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10433 /* vab */, SystemZ::VAB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10437 /* vac */, SystemZ::VAC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10441 /* vacc */, SystemZ::VACC, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10446 /* vaccb */, SystemZ::VACCB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10452 /* vaccc */, SystemZ::VACCC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10458 /* vacccq */, SystemZ::VACCCQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10465 /* vaccf */, SystemZ::VACCF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10471 /* vaccg */, SystemZ::VACCG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10477 /* vacch */, SystemZ::VACCH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10483 /* vaccq */, SystemZ::VACCQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10489 /* vacq */, SystemZ::VACQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10494 /* vaf */, SystemZ::VAF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10498 /* vag */, SystemZ::VAG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10502 /* vah */, SystemZ::VAH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10506 /* vap */, SystemZ::VAP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 10510 /* vaq */, SystemZ::VAQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10514 /* vavg */, SystemZ::VAVG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10519 /* vavgb */, SystemZ::VAVGB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10525 /* vavgf */, SystemZ::VAVGF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10531 /* vavgg */, SystemZ::VAVGG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10537 /* vavgh */, SystemZ::VAVGH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10543 /* vavgl */, SystemZ::VAVGL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10549 /* vavglb */, SystemZ::VAVGLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10556 /* vavglf */, SystemZ::VAVGLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10563 /* vavglg */, SystemZ::VAVGLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10570 /* vavglh */, SystemZ::VAVGLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10577 /* vavglq */, SystemZ::VAVGLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10584 /* vavgq */, SystemZ::VAVGQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10590 /* vblend */, SystemZ::VBLEND, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10597 /* vblendb */, SystemZ::VBLENDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10605 /* vblendf */, SystemZ::VBLENDF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10613 /* vblendg */, SystemZ::VBLENDG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10621 /* vblendh */, SystemZ::VBLENDH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10629 /* vblendq */, SystemZ::VBLENDQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10637 /* vbperm */, SystemZ::VBPERM, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10644 /* vcdg */, SystemZ::VCDG, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10649 /* vcdgb */, SystemZ::VCDGB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10655 /* vcdlg */, SystemZ::VCDLG, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10661 /* vcdlgb */, SystemZ::VCDLGB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10668 /* vcefb */, SystemZ::VCEFB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10674 /* vcelfb */, SystemZ::VCELFB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10681 /* vceq */, SystemZ::VCEQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10686 /* vceqb */, SystemZ::VCEQB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10692 /* vceqbs */, SystemZ::VCEQBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10699 /* vceqf */, SystemZ::VCEQF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10705 /* vceqfs */, SystemZ::VCEQFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10712 /* vceqg */, SystemZ::VCEQG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10718 /* vceqgs */, SystemZ::VCEQGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10725 /* vceqh */, SystemZ::VCEQH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10731 /* vceqhs */, SystemZ::VCEQHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10738 /* vceqq */, SystemZ::VCEQQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10744 /* vceqqs */, SystemZ::VCEQQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10751 /* vcfeb */, SystemZ::VCFEB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10757 /* vcfn */, SystemZ::VCFN, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10762 /* vcfpl */, SystemZ::VCFPL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10768 /* vcfps */, SystemZ::VCFPS, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10774 /* vcgd */, SystemZ::VCGD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10779 /* vcgdb */, SystemZ::VCGDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10785 /* vch */, SystemZ::VCH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10789 /* vchb */, SystemZ::VCHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10794 /* vchbs */, SystemZ::VCHBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10800 /* vchf */, SystemZ::VCHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10805 /* vchfs */, SystemZ::VCHFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10811 /* vchg */, SystemZ::VCHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10816 /* vchgs */, SystemZ::VCHGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10822 /* vchh */, SystemZ::VCHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10827 /* vchhs */, SystemZ::VCHHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10833 /* vchl */, SystemZ::VCHL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10838 /* vchlb */, SystemZ::VCHLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10844 /* vchlbs */, SystemZ::VCHLBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10851 /* vchlf */, SystemZ::VCHLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10857 /* vchlfs */, SystemZ::VCHLFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10864 /* vchlg */, SystemZ::VCHLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10870 /* vchlgs */, SystemZ::VCHLGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10877 /* vchlh */, SystemZ::VCHLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10883 /* vchlhs */, SystemZ::VCHLHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10890 /* vchlq */, SystemZ::VCHLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10896 /* vchlqs */, SystemZ::VCHLQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10903 /* vchq */, SystemZ::VCHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10908 /* vchqs */, SystemZ::VCHQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10914 /* vcksm */, SystemZ::VCKSM, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10920 /* vclfeb */, SystemZ::VCLFEB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10927 /* vclfnh */, SystemZ::VCLFNH, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10934 /* vclfnl */, SystemZ::VCLFNL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10941 /* vclfp */, SystemZ::VCLFP, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10947 /* vclgd */, SystemZ::VCLGD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10953 /* vclgdb */, SystemZ::VCLGDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10960 /* vclz */, SystemZ::VCLZ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10965 /* vclzb */, SystemZ::VCLZB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10971 /* vclzdp */, SystemZ::VCLZDP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10978 /* vclzf */, SystemZ::VCLZF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10984 /* vclzg */, SystemZ::VCLZG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10990 /* vclzh */, SystemZ::VCLZH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10996 /* vclzq */, SystemZ::VCLZQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11002 /* vcnf */, SystemZ::VCNF, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11007 /* vcp */, SystemZ::VCP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11011 /* vcrnf */, SystemZ::VCRNF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11017 /* vcsfp */, SystemZ::VCSFP, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11023 /* vcsph */, SystemZ::VCSPH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11029 /* vctz */, SystemZ::VCTZ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11034 /* vctzb */, SystemZ::VCTZB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11040 /* vctzf */, SystemZ::VCTZF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11046 /* vctzg */, SystemZ::VCTZG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11052 /* vctzh */, SystemZ::VCTZH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11058 /* vctzq */, SystemZ::VCTZQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11064 /* vcvb */, SystemZ::VCVB, Convert__GR321_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_GR32, MCK_VR128, MCK_U4Imm }, },
  { 11064 /* vcvb */, SystemZ::VCVBOpt, Convert__GR321_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement, { MCK_GR32, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11069 /* vcvbg */, SystemZ::VCVBG, Convert__GR641_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_GR64, MCK_VR128, MCK_U4Imm }, },
  { 11069 /* vcvbg */, SystemZ::VCVBGOpt, Convert__GR641_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement, { MCK_GR64, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11075 /* vcvbq */, SystemZ::VCVBQ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11081 /* vcvd */, SystemZ::VCVD, Convert__VR1281_0__GR321_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_U8Imm, MCK_U4Imm }, },
  { 11086 /* vcvdg */, SystemZ::VCVDG, Convert__VR1281_0__GR641_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR64, MCK_U8Imm, MCK_U4Imm }, },
  { 11092 /* vcvdq */, SystemZ::VCVDQ, Convert__VR1281_0__VR1281_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11098 /* vd */, SystemZ::VD, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11101 /* vdf */, SystemZ::VDF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11105 /* vdg */, SystemZ::VDG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11109 /* vdl */, SystemZ::VDL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11113 /* vdlf */, SystemZ::VDLF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11118 /* vdlg */, SystemZ::VDLG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11123 /* vdlq */, SystemZ::VDLQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11128 /* vdp */, SystemZ::VDP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11132 /* vdq */, SystemZ::VDQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11136 /* vec */, SystemZ::VEC, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11140 /* vecb */, SystemZ::VECB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11145 /* vecf */, SystemZ::VECF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11150 /* vecg */, SystemZ::VECG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11155 /* vech */, SystemZ::VECH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11160 /* vecl */, SystemZ::VECL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11165 /* veclb */, SystemZ::VECLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11171 /* veclf */, SystemZ::VECLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11177 /* veclg */, SystemZ::VECLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11183 /* veclh */, SystemZ::VECLH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11189 /* veclq */, SystemZ::VECLQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11195 /* vecq */, SystemZ::VECQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11200 /* verim */, SystemZ::VERIM, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11206 /* verimb */, SystemZ::VERIMB, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11213 /* verimf */, SystemZ::VERIMF, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11220 /* verimg */, SystemZ::VERIMG, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11227 /* verimh */, SystemZ::VERIMH, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11234 /* verll */, SystemZ::VERLL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11240 /* verllb */, SystemZ::VERLLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11247 /* verllf */, SystemZ::VERLLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11254 /* verllg */, SystemZ::VERLLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11261 /* verllh */, SystemZ::VERLLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11268 /* verllv */, SystemZ::VERLLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11275 /* verllvb */, SystemZ::VERLLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11283 /* verllvf */, SystemZ::VERLLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11291 /* verllvg */, SystemZ::VERLLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11299 /* verllvh */, SystemZ::VERLLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11307 /* vesl */, SystemZ::VESL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11312 /* veslb */, SystemZ::VESLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11318 /* veslf */, SystemZ::VESLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11324 /* veslg */, SystemZ::VESLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11330 /* veslh */, SystemZ::VESLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11336 /* veslv */, SystemZ::VESLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11342 /* veslvb */, SystemZ::VESLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11349 /* veslvf */, SystemZ::VESLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11356 /* veslvg */, SystemZ::VESLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11363 /* veslvh */, SystemZ::VESLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11370 /* vesra */, SystemZ::VESRA, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11376 /* vesrab */, SystemZ::VESRAB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11383 /* vesraf */, SystemZ::VESRAF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11390 /* vesrag */, SystemZ::VESRAG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11397 /* vesrah */, SystemZ::VESRAH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11404 /* vesrav */, SystemZ::VESRAV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11411 /* vesravb */, SystemZ::VESRAVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11419 /* vesravf */, SystemZ::VESRAVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11427 /* vesravg */, SystemZ::VESRAVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11435 /* vesravh */, SystemZ::VESRAVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11443 /* vesrl */, SystemZ::VESRL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11449 /* vesrlb */, SystemZ::VESRLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11456 /* vesrlf */, SystemZ::VESRLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11463 /* vesrlg */, SystemZ::VESRLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11470 /* vesrlh */, SystemZ::VESRLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11477 /* vesrlv */, SystemZ::VESRLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11484 /* vesrlvb */, SystemZ::VESRLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11492 /* vesrlvf */, SystemZ::VESRLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11500 /* vesrlvg */, SystemZ::VESRLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11508 /* vesrlvh */, SystemZ::VESRLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11516 /* veval */, SystemZ::VEVAL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U8Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11522 /* vfa */, SystemZ::VFA, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11526 /* vfadb */, SystemZ::VFADB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11532 /* vfae */, SystemZ::VFAE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11532 /* vfae */, SystemZ::VFAE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11537 /* vfaeb */, SystemZ::VFAEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11537 /* vfaeb */, SystemZ::VFAEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11543 /* vfaebs */, SystemZ::VFAEBS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11543 /* vfaebs */, SystemZ::VFAEBS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11550 /* vfaef */, SystemZ::VFAEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11550 /* vfaef */, SystemZ::VFAEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11556 /* vfaefs */, SystemZ::VFAEFS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11556 /* vfaefs */, SystemZ::VFAEFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11563 /* vfaeh */, SystemZ::VFAEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11563 /* vfaeh */, SystemZ::VFAEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11569 /* vfaehs */, SystemZ::VFAEHS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11569 /* vfaehs */, SystemZ::VFAEHS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11576 /* vfaezb */, SystemZ::VFAEZB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11576 /* vfaezb */, SystemZ::VFAEZB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11583 /* vfaezbs */, SystemZ::VFAEZBS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11583 /* vfaezbs */, SystemZ::VFAEZBS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11591 /* vfaezf */, SystemZ::VFAEZF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11591 /* vfaezf */, SystemZ::VFAEZF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11598 /* vfaezfs */, SystemZ::VFAEZFS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11598 /* vfaezfs */, SystemZ::VFAEZFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11606 /* vfaezh */, SystemZ::VFAEZH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11606 /* vfaezh */, SystemZ::VFAEZH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11613 /* vfaezhs */, SystemZ::VFAEZHS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11613 /* vfaezhs */, SystemZ::VFAEZHS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11621 /* vfasb */, SystemZ::VFASB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11627 /* vfce */, SystemZ::VFCE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11632 /* vfcedb */, SystemZ::VFCEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11639 /* vfcedbs */, SystemZ::VFCEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11647 /* vfcesb */, SystemZ::VFCESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11654 /* vfcesbs */, SystemZ::VFCESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11662 /* vfch */, SystemZ::VFCH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11667 /* vfchdb */, SystemZ::VFCHDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11674 /* vfchdbs */, SystemZ::VFCHDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11682 /* vfche */, SystemZ::VFCHE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11688 /* vfchedb */, SystemZ::VFCHEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11696 /* vfchedbs */, SystemZ::VFCHEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11705 /* vfchesb */, SystemZ::VFCHESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11713 /* vfchesbs */, SystemZ::VFCHESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11722 /* vfchsb */, SystemZ::VFCHSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11729 /* vfchsbs */, SystemZ::VFCHSBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11737 /* vfd */, SystemZ::VFD, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11741 /* vfddb */, SystemZ::VFDDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11747 /* vfdsb */, SystemZ::VFDSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11753 /* vfee */, SystemZ::VFEE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11753 /* vfee */, SystemZ::VFEE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11758 /* vfeeb */, SystemZ::VFEEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11758 /* vfeeb */, SystemZ::VFEEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11764 /* vfeebs */, SystemZ::VFEEBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11771 /* vfeef */, SystemZ::VFEEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11771 /* vfeef */, SystemZ::VFEEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11777 /* vfeefs */, SystemZ::VFEEFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11784 /* vfeeh */, SystemZ::VFEEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11784 /* vfeeh */, SystemZ::VFEEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11790 /* vfeehs */, SystemZ::VFEEHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11797 /* vfeezb */, SystemZ::VFEEZB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11804 /* vfeezbs */, SystemZ::VFEEZBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11812 /* vfeezf */, SystemZ::VFEEZF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11819 /* vfeezfs */, SystemZ::VFEEZFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11827 /* vfeezh */, SystemZ::VFEEZH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11834 /* vfeezhs */, SystemZ::VFEEZHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11842 /* vfene */, SystemZ::VFENE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11842 /* vfene */, SystemZ::VFENE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11848 /* vfeneb */, SystemZ::VFENEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11848 /* vfeneb */, SystemZ::VFENEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11855 /* vfenebs */, SystemZ::VFENEBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11863 /* vfenef */, SystemZ::VFENEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11863 /* vfenef */, SystemZ::VFENEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11870 /* vfenefs */, SystemZ::VFENEFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11878 /* vfeneh */, SystemZ::VFENEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11878 /* vfeneh */, SystemZ::VFENEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11885 /* vfenehs */, SystemZ::VFENEHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11893 /* vfenezb */, SystemZ::VFENEZB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11901 /* vfenezbs */, SystemZ::VFENEZBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11910 /* vfenezf */, SystemZ::VFENEZF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11918 /* vfenezfs */, SystemZ::VFENEZFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11927 /* vfenezh */, SystemZ::VFENEZH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11935 /* vfenezhs */, SystemZ::VFENEZHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11944 /* vfi */, SystemZ::VFI, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11948 /* vfidb */, SystemZ::VFIDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11954 /* vfisb */, SystemZ::VFISB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11960 /* vfkedb */, SystemZ::VFKEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11967 /* vfkedbs */, SystemZ::VFKEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11975 /* vfkesb */, SystemZ::VFKESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11982 /* vfkesbs */, SystemZ::VFKESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11990 /* vfkhdb */, SystemZ::VFKHDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11997 /* vfkhdbs */, SystemZ::VFKHDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12005 /* vfkhedb */, SystemZ::VFKHEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12013 /* vfkhedbs */, SystemZ::VFKHEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12022 /* vfkhesb */, SystemZ::VFKHESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12030 /* vfkhesbs */, SystemZ::VFKHESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12039 /* vfkhsb */, SystemZ::VFKHSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12046 /* vfkhsbs */, SystemZ::VFKHSBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12054 /* vflcdb */, SystemZ::VFLCDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12061 /* vflcsb */, SystemZ::VFLCSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12068 /* vfll */, SystemZ::VFLL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12073 /* vflls */, SystemZ::VFLLS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12079 /* vflndb */, SystemZ::VFLNDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12086 /* vflnsb */, SystemZ::VFLNSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12093 /* vflpdb */, SystemZ::VFLPDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12100 /* vflpsb */, SystemZ::VFLPSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12107 /* vflr */, SystemZ::VFLR, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12112 /* vflrd */, SystemZ::VFLRD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12118 /* vfm */, SystemZ::VFM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12122 /* vfma */, SystemZ::VFMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12127 /* vfmadb */, SystemZ::VFMADB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12134 /* vfmasb */, SystemZ::VFMASB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12141 /* vfmax */, SystemZ::VFMAX, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12147 /* vfmaxdb */, SystemZ::VFMAXDB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12155 /* vfmaxsb */, SystemZ::VFMAXSB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12163 /* vfmdb */, SystemZ::VFMDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12169 /* vfmin */, SystemZ::VFMIN, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12175 /* vfmindb */, SystemZ::VFMINDB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12183 /* vfminsb */, SystemZ::VFMINSB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12191 /* vfms */, SystemZ::VFMS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12196 /* vfmsb */, SystemZ::VFMSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12202 /* vfmsdb */, SystemZ::VFMSDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12209 /* vfmssb */, SystemZ::VFMSSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12216 /* vfnma */, SystemZ::VFNMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12222 /* vfnmadb */, SystemZ::VFNMADB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12230 /* vfnmasb */, SystemZ::VFNMASB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12238 /* vfnms */, SystemZ::VFNMS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12244 /* vfnmsdb */, SystemZ::VFNMSDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12252 /* vfnmssb */, SystemZ::VFNMSSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12260 /* vfpso */, SystemZ::VFPSO, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12266 /* vfpsodb */, SystemZ::VFPSODB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12274 /* vfpsosb */, SystemZ::VFPSOSB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12282 /* vfs */, SystemZ::VFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12286 /* vfsdb */, SystemZ::VFSDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12292 /* vfsq */, SystemZ::VFSQ, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12297 /* vfsqdb */, SystemZ::VFSQDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12304 /* vfsqsb */, SystemZ::VFSQSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12311 /* vfssb */, SystemZ::VFSSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12317 /* vftci */, SystemZ::VFTCI, Convert__VR1281_0__VR1281_1__U12Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U12Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12323 /* vftcidb */, SystemZ::VFTCIDB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 12331 /* vftcisb */, SystemZ::VFTCISB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 12339 /* vgbm */, SystemZ::VGBM, Convert__VR1281_0__U16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_U16Imm }, },
  { 12344 /* vgef */, SystemZ::VGEF, Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U2Imm }, },
  { 12349 /* vgeg */, SystemZ::VGEG, Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U1Imm }, },
  { 12354 /* vgem */, SystemZ::VGEM, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12359 /* vgemb */, SystemZ::VGEMB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12365 /* vgemf */, SystemZ::VGEMF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12371 /* vgemg */, SystemZ::VGEMG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12377 /* vgemh */, SystemZ::VGEMH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12383 /* vgemq */, SystemZ::VGEMQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12389 /* vgfm */, SystemZ::VGFM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12394 /* vgfma */, SystemZ::VGFMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12400 /* vgfmab */, SystemZ::VGFMAB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12407 /* vgfmaf */, SystemZ::VGFMAF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12414 /* vgfmag */, SystemZ::VGFMAG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12421 /* vgfmah */, SystemZ::VGFMAH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12428 /* vgfmb */, SystemZ::VGFMB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12434 /* vgfmf */, SystemZ::VGFMF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12440 /* vgfmg */, SystemZ::VGFMG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12446 /* vgfmh */, SystemZ::VGFMH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12452 /* vgm */, SystemZ::VGM, Convert__VR1281_0__U8Imm1_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 12456 /* vgmb */, SystemZ::VGMB, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12461 /* vgmf */, SystemZ::VGMF, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12466 /* vgmg */, SystemZ::VGMG, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12471 /* vgmh */, SystemZ::VGMH, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12476 /* vistr */, SystemZ::VISTR, Convert__VR1281_0__VR1281_1__U4Imm1_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12476 /* vistr */, SystemZ::VISTR, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12482 /* vistrb */, SystemZ::VISTRB, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12482 /* vistrb */, SystemZ::VISTRB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12489 /* vistrbs */, SystemZ::VISTRBS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12497 /* vistrf */, SystemZ::VISTRF, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12497 /* vistrf */, SystemZ::VISTRF, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12504 /* vistrfs */, SystemZ::VISTRFS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12512 /* vistrh */, SystemZ::VISTRH, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12512 /* vistrh */, SystemZ::VISTRH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12519 /* vistrhs */, SystemZ::VISTRHS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12527 /* vl */, SystemZ::VL, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12527 /* vl */, SystemZ::VLAlign, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12530 /* vlbb */, SystemZ::VLBB, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12535 /* vlbr */, SystemZ::VLBR, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12540 /* vlbrf */, SystemZ::VLBRF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12546 /* vlbrg */, SystemZ::VLBRG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12552 /* vlbrh */, SystemZ::VLBRH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12558 /* vlbrq */, SystemZ::VLBRQ, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12564 /* vlbrrep */, SystemZ::VLBRREP, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12572 /* vlbrrepf */, SystemZ::VLBRREPF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12581 /* vlbrrepg */, SystemZ::VLBRREPG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12590 /* vlbrreph */, SystemZ::VLBRREPH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12599 /* vlc */, SystemZ::VLC, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12603 /* vlcb */, SystemZ::VLCB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12608 /* vlcf */, SystemZ::VLCF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12613 /* vlcg */, SystemZ::VLCG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12618 /* vlch */, SystemZ::VLCH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12623 /* vlcq */, SystemZ::VLCQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12628 /* vlde */, SystemZ::VLDE, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12633 /* vldeb */, SystemZ::VLDEB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12639 /* vleb */, SystemZ::VLEB, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12644 /* vlebrf */, SystemZ::VLEBRF, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 12651 /* vlebrg */, SystemZ::VLEBRG, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 12658 /* vlebrh */, SystemZ::VLEBRH, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 12665 /* vled */, SystemZ::VLED, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12670 /* vledb */, SystemZ::VLEDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12676 /* vlef */, SystemZ::VLEF, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 12681 /* vleg */, SystemZ::VLEG, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 12686 /* vleh */, SystemZ::VLEH, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 12691 /* vleib */, SystemZ::VLEIB, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U4Imm }, },
  { 12697 /* vleif */, SystemZ::VLEIF, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U2Imm }, },
  { 12703 /* vleig */, SystemZ::VLEIG, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U1Imm }, },
  { 12709 /* vleih */, SystemZ::VLEIH, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U3Imm }, },
  { 12715 /* vler */, SystemZ::VLER, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12720 /* vlerf */, SystemZ::VLERF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12726 /* vlerg */, SystemZ::VLERG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12732 /* vlerh */, SystemZ::VLERH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12738 /* vlgv */, SystemZ::VLGV, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 12743 /* vlgvb */, SystemZ::VLGVB, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12749 /* vlgvf */, SystemZ::VLGVF, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12755 /* vlgvg */, SystemZ::VLGVG, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12761 /* vlgvh */, SystemZ::VLGVH, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12767 /* vlip */, SystemZ::VLIP, Convert__VR1281_0__U16Imm1_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_U16Imm, MCK_U4Imm }, },
  { 12772 /* vll */, SystemZ::VLL, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 12776 /* vllebrz */, SystemZ::VLLEBRZ, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12784 /* vllebrze */, SystemZ::VLLEBRZE, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12793 /* vllebrzf */, SystemZ::VLLEBRZF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12802 /* vllebrzg */, SystemZ::VLLEBRZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12811 /* vllebrzh */, SystemZ::VLLEBRZH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12820 /* vllez */, SystemZ::VLLEZ, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12826 /* vllezb */, SystemZ::VLLEZB, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12833 /* vllezf */, SystemZ::VLLEZF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12840 /* vllezg */, SystemZ::VLLEZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12847 /* vllezh */, SystemZ::VLLEZH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12854 /* vllezlf */, SystemZ::VLLEZLF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12862 /* vlm */, SystemZ::VLM, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12 }, },
  { 12862 /* vlm */, SystemZ::VLMAlign, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12, MCK_U4Imm }, },
  { 12866 /* vlp */, SystemZ::VLP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12870 /* vlpb */, SystemZ::VLPB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12875 /* vlpf */, SystemZ::VLPF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12880 /* vlpg */, SystemZ::VLPG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12885 /* vlph */, SystemZ::VLPH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12890 /* vlpq */, SystemZ::VLPQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12895 /* vlr */, SystemZ::VLR, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12899 /* vlrep */, SystemZ::VLREP, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12905 /* vlrepb */, SystemZ::VLREPB, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12912 /* vlrepf */, SystemZ::VLREPF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12919 /* vlrepg */, SystemZ::VLREPG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12926 /* vlreph */, SystemZ::VLREPH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12933 /* vlrl */, SystemZ::VLRL, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 12938 /* vlrlr */, SystemZ::VLRLR, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 12944 /* vlvg */, SystemZ::VLVG, Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 12949 /* vlvgb */, SystemZ::VLVGB, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12955 /* vlvgf */, SystemZ::VLVGF, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12961 /* vlvgg */, SystemZ::VLVGG, Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_BDAddr32Disp12 }, },
  { 12967 /* vlvgh */, SystemZ::VLVGH, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12973 /* vlvgp */, SystemZ::VLVGP, Convert__VR1281_0__GR641_1__GR641_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_GR64 }, },
  { 12979 /* vmae */, SystemZ::VMAE, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12984 /* vmaeb */, SystemZ::VMAEB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12990 /* vmaef */, SystemZ::VMAEF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12996 /* vmaeg */, SystemZ::VMAEG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13002 /* vmaeh */, SystemZ::VMAEH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13008 /* vmah */, SystemZ::VMAH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13013 /* vmahb */, SystemZ::VMAHB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13019 /* vmahf */, SystemZ::VMAHF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13025 /* vmahg */, SystemZ::VMAHG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13031 /* vmahh */, SystemZ::VMAHH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13037 /* vmahq */, SystemZ::VMAHQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13043 /* vmal */, SystemZ::VMAL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13048 /* vmalb */, SystemZ::VMALB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13054 /* vmale */, SystemZ::VMALE, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13060 /* vmaleb */, SystemZ::VMALEB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13067 /* vmalef */, SystemZ::VMALEF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13074 /* vmaleg */, SystemZ::VMALEG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13081 /* vmaleh */, SystemZ::VMALEH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13088 /* vmalf */, SystemZ::VMALF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13094 /* vmalg */, SystemZ::VMALG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13100 /* vmalh */, SystemZ::VMALH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13106 /* vmalhb */, SystemZ::VMALHB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13113 /* vmalhf */, SystemZ::VMALHF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13120 /* vmalhg */, SystemZ::VMALHG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13127 /* vmalhh */, SystemZ::VMALHH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13134 /* vmalhq */, SystemZ::VMALHQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13141 /* vmalhw */, SystemZ::VMALHW, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13148 /* vmalo */, SystemZ::VMALO, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13154 /* vmalob */, SystemZ::VMALOB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13161 /* vmalof */, SystemZ::VMALOF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13168 /* vmalog */, SystemZ::VMALOG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13175 /* vmaloh */, SystemZ::VMALOH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13182 /* vmalq */, SystemZ::VMALQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13188 /* vmao */, SystemZ::VMAO, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13193 /* vmaob */, SystemZ::VMAOB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13199 /* vmaof */, SystemZ::VMAOF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13205 /* vmaog */, SystemZ::VMAOG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13211 /* vmaoh */, SystemZ::VMAOH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13217 /* vme */, SystemZ::VME, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13221 /* vmeb */, SystemZ::VMEB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13226 /* vmef */, SystemZ::VMEF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13231 /* vmeg */, SystemZ::VMEG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13236 /* vmeh */, SystemZ::VMEH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13241 /* vmh */, SystemZ::VMH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13245 /* vmhb */, SystemZ::VMHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13250 /* vmhf */, SystemZ::VMHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13255 /* vmhg */, SystemZ::VMHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13260 /* vmhh */, SystemZ::VMHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13265 /* vmhq */, SystemZ::VMHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13270 /* vml */, SystemZ::VML, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13274 /* vmlb */, SystemZ::VMLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13279 /* vmle */, SystemZ::VMLE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13284 /* vmleb */, SystemZ::VMLEB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13290 /* vmlef */, SystemZ::VMLEF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13296 /* vmleg */, SystemZ::VMLEG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13302 /* vmleh */, SystemZ::VMLEH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13308 /* vmlf */, SystemZ::VMLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13313 /* vmlg */, SystemZ::VMLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13318 /* vmlh */, SystemZ::VMLH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13323 /* vmlhb */, SystemZ::VMLHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13329 /* vmlhf */, SystemZ::VMLHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13335 /* vmlhg */, SystemZ::VMLHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13341 /* vmlhh */, SystemZ::VMLHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13347 /* vmlhq */, SystemZ::VMLHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13353 /* vmlhw */, SystemZ::VMLHW, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13359 /* vmlo */, SystemZ::VMLO, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13364 /* vmlob */, SystemZ::VMLOB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13370 /* vmlof */, SystemZ::VMLOF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13376 /* vmlog */, SystemZ::VMLOG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13382 /* vmloh */, SystemZ::VMLOH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13388 /* vmlq */, SystemZ::VMLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13393 /* vmn */, SystemZ::VMN, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13397 /* vmnb */, SystemZ::VMNB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13402 /* vmnf */, SystemZ::VMNF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13407 /* vmng */, SystemZ::VMNG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13412 /* vmnh */, SystemZ::VMNH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13417 /* vmnl */, SystemZ::VMNL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13422 /* vmnlb */, SystemZ::VMNLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13428 /* vmnlf */, SystemZ::VMNLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13434 /* vmnlg */, SystemZ::VMNLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13440 /* vmnlh */, SystemZ::VMNLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13446 /* vmnlq */, SystemZ::VMNLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13452 /* vmnq */, SystemZ::VMNQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13457 /* vmo */, SystemZ::VMO, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13461 /* vmob */, SystemZ::VMOB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13466 /* vmof */, SystemZ::VMOF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13471 /* vmog */, SystemZ::VMOG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13476 /* vmoh */, SystemZ::VMOH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13481 /* vmp */, SystemZ::VMP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13485 /* vmrh */, SystemZ::VMRH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13490 /* vmrhb */, SystemZ::VMRHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13496 /* vmrhf */, SystemZ::VMRHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13502 /* vmrhg */, SystemZ::VMRHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13508 /* vmrhh */, SystemZ::VMRHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13514 /* vmrl */, SystemZ::VMRL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13519 /* vmrlb */, SystemZ::VMRLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13525 /* vmrlf */, SystemZ::VMRLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13531 /* vmrlg */, SystemZ::VMRLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13537 /* vmrlh */, SystemZ::VMRLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13543 /* vmsl */, SystemZ::VMSL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13548 /* vmslg */, SystemZ::VMSLG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13554 /* vmsp */, SystemZ::VMSP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13559 /* vmx */, SystemZ::VMX, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13563 /* vmxb */, SystemZ::VMXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13568 /* vmxf */, SystemZ::VMXF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13573 /* vmxg */, SystemZ::VMXG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13578 /* vmxh */, SystemZ::VMXH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13583 /* vmxl */, SystemZ::VMXL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13588 /* vmxlb */, SystemZ::VMXLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13594 /* vmxlf */, SystemZ::VMXLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13600 /* vmxlg */, SystemZ::VMXLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13606 /* vmxlh */, SystemZ::VMXLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13612 /* vmxlq */, SystemZ::VMXLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13618 /* vmxq */, SystemZ::VMXQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13623 /* vn */, SystemZ::VN, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13626 /* vnc */, SystemZ::VNC, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13630 /* vnn */, SystemZ::VNN, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13634 /* vno */, SystemZ::VNO, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13638 /* vnot */, SystemZ::VNO, Convert__VR1281_0__VR1281_1__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 13643 /* vnx */, SystemZ::VNX, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13647 /* vo */, SystemZ::VO, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13650 /* voc */, SystemZ::VOC, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13654 /* vone */, SystemZ::VONE, Convert__VR1281_0, AMFBS_FeatureVector, { MCK_VR128 }, },
  { 13659 /* vpdi */, SystemZ::VPDI, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13664 /* vperm */, SystemZ::VPERM, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13670 /* vpk */, SystemZ::VPK, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13674 /* vpkf */, SystemZ::VPKF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13679 /* vpkg */, SystemZ::VPKG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13684 /* vpkh */, SystemZ::VPKH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13689 /* vpkls */, SystemZ::VPKLS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13695 /* vpklsf */, SystemZ::VPKLSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13702 /* vpklsfs */, SystemZ::VPKLSFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13710 /* vpklsg */, SystemZ::VPKLSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13717 /* vpklsgs */, SystemZ::VPKLSGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13725 /* vpklsh */, SystemZ::VPKLSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13732 /* vpklshs */, SystemZ::VPKLSHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13740 /* vpks */, SystemZ::VPKS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13745 /* vpksf */, SystemZ::VPKSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13751 /* vpksfs */, SystemZ::VPKSFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13758 /* vpksg */, SystemZ::VPKSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13764 /* vpksgs */, SystemZ::VPKSGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13771 /* vpksh */, SystemZ::VPKSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13777 /* vpkshs */, SystemZ::VPKSHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13784 /* vpkz */, SystemZ::VPKZ, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 13789 /* vpkzr */, SystemZ::VPKZR, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13795 /* vpopct */, SystemZ::VPOPCT, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13802 /* vpopctb */, SystemZ::VPOPCTB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13810 /* vpopctf */, SystemZ::VPOPCTF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13818 /* vpopctg */, SystemZ::VPOPCTG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13826 /* vpopcth */, SystemZ::VPOPCTH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13834 /* vpsop */, SystemZ::VPSOP, Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 13840 /* vr */, SystemZ::VR, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13843 /* vrep */, SystemZ::VREP, Convert__VR1281_0__VR1281_1__U16Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm, MCK_U4Imm }, },
  { 13848 /* vrepb */, SystemZ::VREPB, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13854 /* vrepf */, SystemZ::VREPF, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13860 /* vrepg */, SystemZ::VREPG, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13866 /* vreph */, SystemZ::VREPH, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13872 /* vrepi */, SystemZ::VREPI, Convert__VR1281_0__S16Imm1_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U4Imm }, },
  { 13878 /* vrepib */, SystemZ::VREPIB, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13885 /* vrepif */, SystemZ::VREPIF, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13892 /* vrepig */, SystemZ::VREPIG, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13899 /* vrepih */, SystemZ::VREPIH, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13906 /* vrf */, SystemZ::VRF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13910 /* vrg */, SystemZ::VRG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13914 /* vrl */, SystemZ::VRL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13918 /* vrlf */, SystemZ::VRLF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13923 /* vrlg */, SystemZ::VRLG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13928 /* vrlq */, SystemZ::VRLQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13933 /* vrp */, SystemZ::VRP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13937 /* vrq */, SystemZ::VRQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13941 /* vs */, SystemZ::VS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13944 /* vsb */, SystemZ::VSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13948 /* vsbcbi */, SystemZ::VSBCBI, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13955 /* vsbcbiq */, SystemZ::VSBCBIQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13963 /* vsbi */, SystemZ::VSBI, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13968 /* vsbiq */, SystemZ::VSBIQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13974 /* vscbi */, SystemZ::VSCBI, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13980 /* vscbib */, SystemZ::VSCBIB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13987 /* vscbif */, SystemZ::VSCBIF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13994 /* vscbig */, SystemZ::VSCBIG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14001 /* vscbih */, SystemZ::VSCBIH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14008 /* vscbiq */, SystemZ::VSCBIQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14015 /* vscef */, SystemZ::VSCEF, Convert__VR1281_0__BDVAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U2Imm }, },
  { 14021 /* vsceg */, SystemZ::VSCEG, Convert__VR1281_0__BDVAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U1Imm }, },
  { 14027 /* vschdp */, SystemZ::VSCHDP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14034 /* vschp */, SystemZ::VSCHP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14040 /* vschsp */, SystemZ::VSCHSP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14047 /* vschxp */, SystemZ::VSCHXP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14054 /* vscshp */, SystemZ::VSCSHP, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14061 /* vsdp */, SystemZ::VSDP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14066 /* vseg */, SystemZ::VSEG, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14071 /* vsegb */, SystemZ::VSEGB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14077 /* vsegf */, SystemZ::VSEGF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14083 /* vsegh */, SystemZ::VSEGH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14089 /* vsel */, SystemZ::VSEL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14094 /* vsf */, SystemZ::VSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14098 /* vsg */, SystemZ::VSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14102 /* vsh */, SystemZ::VSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14106 /* vsl */, SystemZ::VSL, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14110 /* vslb */, SystemZ::VSLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14115 /* vsld */, SystemZ::VSLD, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14120 /* vsldb */, SystemZ::VSLDB, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14126 /* vsp */, SystemZ::VSP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14130 /* vsq */, SystemZ::VSQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14134 /* vsra */, SystemZ::VSRA, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14139 /* vsrab */, SystemZ::VSRAB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14145 /* vsrd */, SystemZ::VSRD, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14150 /* vsrl */, SystemZ::VSRL, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14155 /* vsrlb */, SystemZ::VSRLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14161 /* vsrp */, SystemZ::VSRP, Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 14166 /* vsrpr */, SystemZ::VSRPR, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14172 /* vst */, SystemZ::VST, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14172 /* vst */, SystemZ::VSTAlign, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14176 /* vstbr */, SystemZ::VSTBR, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14182 /* vstbrf */, SystemZ::VSTBRF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14189 /* vstbrg */, SystemZ::VSTBRG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14196 /* vstbrh */, SystemZ::VSTBRH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14203 /* vstbrq */, SystemZ::VSTBRQ, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14210 /* vsteb */, SystemZ::VSTEB, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14216 /* vstebrf */, SystemZ::VSTEBRF, Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 14224 /* vstebrg */, SystemZ::VSTEBRG, Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 14232 /* vstebrh */, SystemZ::VSTEBRH, Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 14240 /* vstef */, SystemZ::VSTEF, Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 14246 /* vsteg */, SystemZ::VSTEG, Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 14252 /* vsteh */, SystemZ::VSTEH, Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 14258 /* vster */, SystemZ::VSTER, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14264 /* vsterf */, SystemZ::VSTERF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14271 /* vsterg */, SystemZ::VSTERG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14278 /* vsterh */, SystemZ::VSTERH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14285 /* vstl */, SystemZ::VSTL, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 14290 /* vstm */, SystemZ::VSTM, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12 }, },
  { 14290 /* vstm */, SystemZ::VSTMAlign, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12, MCK_U4Imm }, },
  { 14295 /* vstrc */, SystemZ::VSTRC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14295 /* vstrc */, SystemZ::VSTRC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14301 /* vstrcb */, SystemZ::VSTRCB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14301 /* vstrcb */, SystemZ::VSTRCB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14308 /* vstrcbs */, SystemZ::VSTRCBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14308 /* vstrcbs */, SystemZ::VSTRCBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14316 /* vstrcf */, SystemZ::VSTRCF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14316 /* vstrcf */, SystemZ::VSTRCF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14323 /* vstrcfs */, SystemZ::VSTRCFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14323 /* vstrcfs */, SystemZ::VSTRCFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14331 /* vstrch */, SystemZ::VSTRCH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14331 /* vstrch */, SystemZ::VSTRCH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14338 /* vstrchs */, SystemZ::VSTRCHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14338 /* vstrchs */, SystemZ::VSTRCHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14346 /* vstrczb */, SystemZ::VSTRCZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14346 /* vstrczb */, SystemZ::VSTRCZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14354 /* vstrczbs */, SystemZ::VSTRCZBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14354 /* vstrczbs */, SystemZ::VSTRCZBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14363 /* vstrczf */, SystemZ::VSTRCZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14363 /* vstrczf */, SystemZ::VSTRCZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14371 /* vstrczfs */, SystemZ::VSTRCZFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14371 /* vstrczfs */, SystemZ::VSTRCZFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14380 /* vstrczh */, SystemZ::VSTRCZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14380 /* vstrczh */, SystemZ::VSTRCZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14388 /* vstrczhs */, SystemZ::VSTRCZHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14388 /* vstrczhs */, SystemZ::VSTRCZHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14397 /* vstrl */, SystemZ::VSTRL, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 14403 /* vstrlr */, SystemZ::VSTRLR, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 14410 /* vstrs */, SystemZ::VSTRS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14410 /* vstrs */, SystemZ::VSTRS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14416 /* vstrsb */, SystemZ::VSTRSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14416 /* vstrsb */, SystemZ::VSTRSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14423 /* vstrsf */, SystemZ::VSTRSF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14423 /* vstrsf */, SystemZ::VSTRSF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14430 /* vstrsh */, SystemZ::VSTRSH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14430 /* vstrsh */, SystemZ::VSTRSH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14437 /* vstrszb */, SystemZ::VSTRSZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14445 /* vstrszf */, SystemZ::VSTRSZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14453 /* vstrszh */, SystemZ::VSTRSZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14461 /* vsum */, SystemZ::VSUM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14466 /* vsumb */, SystemZ::VSUMB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14472 /* vsumg */, SystemZ::VSUMG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14478 /* vsumgf */, SystemZ::VSUMGF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14485 /* vsumgh */, SystemZ::VSUMGH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14492 /* vsumh */, SystemZ::VSUMH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14498 /* vsumq */, SystemZ::VSUMQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14504 /* vsumqf */, SystemZ::VSUMQF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14511 /* vsumqg */, SystemZ::VSUMQG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14518 /* vtm */, SystemZ::VTM, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14522 /* vtp */, SystemZ::VTP, Convert__VR1281_0, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128 }, },
  { 14522 /* vtp */, SystemZ::VTPOpt, Convert__VR1281_0__U16Imm1_1, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_U16Imm }, },
  { 14526 /* vtz */, SystemZ::VTZ, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 14530 /* vuph */, SystemZ::VUPH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14535 /* vuphb */, SystemZ::VUPHB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14541 /* vuphf */, SystemZ::VUPHF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14547 /* vuphg */, SystemZ::VUPHG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14553 /* vuphh */, SystemZ::VUPHH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14559 /* vupkz */, SystemZ::VUPKZ, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 14565 /* vupkzh */, SystemZ::VUPKZH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14572 /* vupkzl */, SystemZ::VUPKZL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14579 /* vupl */, SystemZ::VUPL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14584 /* vuplb */, SystemZ::VUPLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14590 /* vuplf */, SystemZ::VUPLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14596 /* vuplg */, SystemZ::VUPLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14602 /* vuplh */, SystemZ::VUPLH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14608 /* vuplhb */, SystemZ::VUPLHB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14615 /* vuplhf */, SystemZ::VUPLHF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14622 /* vuplhg */, SystemZ::VUPLHG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14629 /* vuplhh */, SystemZ::VUPLHH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14636 /* vuplhw */, SystemZ::VUPLHW, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14643 /* vupll */, SystemZ::VUPLL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14649 /* vupllb */, SystemZ::VUPLLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14656 /* vupllf */, SystemZ::VUPLLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14663 /* vupllg */, SystemZ::VUPLLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14670 /* vupllh */, SystemZ::VUPLLH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14677 /* vx */, SystemZ::VX, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14680 /* vzero */, SystemZ::VZERO, Convert__VR1281_0, AMFBS_FeatureVector, { MCK_VR128 }, },
  { 14686 /* wcdgb */, SystemZ::WCDGB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14692 /* wcdlgb */, SystemZ::WCDLGB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14699 /* wcefb */, SystemZ::WCEFB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14705 /* wcelfb */, SystemZ::WCELFB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14712 /* wcfeb */, SystemZ::WCFEB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14718 /* wcgdb */, SystemZ::WCGDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14724 /* wclfeb */, SystemZ::WCLFEB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14731 /* wclgdb */, SystemZ::WCLGDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14738 /* wfadb */, SystemZ::WFADB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14744 /* wfasb */, SystemZ::WFASB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14750 /* wfaxb */, SystemZ::WFAXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14756 /* wfc */, SystemZ::WFC, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14760 /* wfcdb */, SystemZ::WFCDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 14766 /* wfcedb */, SystemZ::WFCEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14773 /* wfcedbs */, SystemZ::WFCEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14781 /* wfcesb */, SystemZ::WFCESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14788 /* wfcesbs */, SystemZ::WFCESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14796 /* wfcexb */, SystemZ::WFCEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14803 /* wfcexbs */, SystemZ::WFCEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14811 /* wfchdb */, SystemZ::WFCHDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14818 /* wfchdbs */, SystemZ::WFCHDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14826 /* wfchedb */, SystemZ::WFCHEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14834 /* wfchedbs */, SystemZ::WFCHEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14843 /* wfchesb */, SystemZ::WFCHESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14851 /* wfchesbs */, SystemZ::WFCHESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14860 /* wfchexb */, SystemZ::WFCHEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14868 /* wfchexbs */, SystemZ::WFCHEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14877 /* wfchsb */, SystemZ::WFCHSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14884 /* wfchsbs */, SystemZ::WFCHSBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14892 /* wfchxb */, SystemZ::WFCHXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14899 /* wfchxbs */, SystemZ::WFCHXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14907 /* wfcsb */, SystemZ::WFCSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 14913 /* wfcxb */, SystemZ::WFCXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 14919 /* wfddb */, SystemZ::WFDDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14925 /* wfdsb */, SystemZ::WFDSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14931 /* wfdxb */, SystemZ::WFDXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14937 /* wfidb */, SystemZ::WFIDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14943 /* wfisb */, SystemZ::WFISB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14949 /* wfixb */, SystemZ::WFIXB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14955 /* wfk */, SystemZ::WFK, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14959 /* wfkdb */, SystemZ::WFKDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 14965 /* wfkedb */, SystemZ::WFKEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14972 /* wfkedbs */, SystemZ::WFKEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14980 /* wfkesb */, SystemZ::WFKESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14987 /* wfkesbs */, SystemZ::WFKESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14995 /* wfkexb */, SystemZ::WFKEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15002 /* wfkexbs */, SystemZ::WFKEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15010 /* wfkhdb */, SystemZ::WFKHDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15017 /* wfkhdbs */, SystemZ::WFKHDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15025 /* wfkhedb */, SystemZ::WFKHEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15033 /* wfkhedbs */, SystemZ::WFKHEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15042 /* wfkhesb */, SystemZ::WFKHESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15050 /* wfkhesbs */, SystemZ::WFKHESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15059 /* wfkhexb */, SystemZ::WFKHEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15067 /* wfkhexbs */, SystemZ::WFKHEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15076 /* wfkhsb */, SystemZ::WFKHSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15083 /* wfkhsbs */, SystemZ::WFKHSBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15091 /* wfkhxb */, SystemZ::WFKHXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15098 /* wfkhxbs */, SystemZ::WFKHXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15106 /* wfksb */, SystemZ::WFKSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15112 /* wfkxb */, SystemZ::WFKXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15118 /* wflcdb */, SystemZ::WFLCDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15125 /* wflcsb */, SystemZ::WFLCSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15132 /* wflcxb */, SystemZ::WFLCXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15139 /* wflld */, SystemZ::WFLLD, Convert__VR1281_0__VR641_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR64 }, },
  { 15145 /* wflls */, SystemZ::WFLLS, Convert__VR641_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR32 }, },
  { 15151 /* wflndb */, SystemZ::WFLNDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15158 /* wflnsb */, SystemZ::WFLNSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15165 /* wflnxb */, SystemZ::WFLNXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15172 /* wflpdb */, SystemZ::WFLPDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15179 /* wflpsb */, SystemZ::WFLPSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15186 /* wflpxb */, SystemZ::WFLPXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15193 /* wflrd */, SystemZ::WFLRD, Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 15199 /* wflrx */, SystemZ::WFLRX, Convert__VR641_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 15205 /* wfmadb */, SystemZ::WFMADB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15212 /* wfmasb */, SystemZ::WFMASB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15219 /* wfmaxb */, SystemZ::WFMAXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15226 /* wfmaxdb */, SystemZ::WFMAXDB, Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15234 /* wfmaxsb */, SystemZ::WFMAXSB, Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15242 /* wfmaxxb */, SystemZ::WFMAXXB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15250 /* wfmdb */, SystemZ::WFMDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15256 /* wfmindb */, SystemZ::WFMINDB, Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15264 /* wfminsb */, SystemZ::WFMINSB, Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15272 /* wfminxb */, SystemZ::WFMINXB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15280 /* wfmsb */, SystemZ::WFMSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15286 /* wfmsdb */, SystemZ::WFMSDB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15293 /* wfmssb */, SystemZ::WFMSSB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15300 /* wfmsxb */, SystemZ::WFMSXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15307 /* wfmxb */, SystemZ::WFMXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15313 /* wfnmadb */, SystemZ::WFNMADB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15321 /* wfnmasb */, SystemZ::WFNMASB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15329 /* wfnmaxb */, SystemZ::WFNMAXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15337 /* wfnmsdb */, SystemZ::WFNMSDB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15345 /* wfnmssb */, SystemZ::WFNMSSB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15353 /* wfnmsxb */, SystemZ::WFNMSXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15361 /* wfpsodb */, SystemZ::WFPSODB, Convert__VR641_0__VR641_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15369 /* wfpsosb */, SystemZ::WFPSOSB, Convert__VR321_0__VR321_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15377 /* wfpsoxb */, SystemZ::WFPSOXB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15385 /* wfsdb */, SystemZ::WFSDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15391 /* wfsqdb */, SystemZ::WFSQDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15398 /* wfsqsb */, SystemZ::WFSQSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15405 /* wfsqxb */, SystemZ::WFSQXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15412 /* wfssb */, SystemZ::WFSSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15418 /* wfsxb */, SystemZ::WFSXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15424 /* wftcidb */, SystemZ::WFTCIDB, Convert__VR641_0__VR641_1__U12Imm1_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U12Imm }, },
  { 15432 /* wftcisb */, SystemZ::WFTCISB, Convert__VR321_0__VR321_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U12Imm }, },
  { 15440 /* wftcixb */, SystemZ::WFTCIXB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 15448 /* wldeb */, SystemZ::WLDEB, Convert__VR641_0__VR321_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR32 }, },
  { 15454 /* wledb */, SystemZ::WLEDB, Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR32, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 15460 /* x */, SystemZ::X, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 15462 /* xc */, SystemZ::XC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 15465 /* xg */, SystemZ::XG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 15468 /* xgr */, SystemZ::XGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 15472 /* xgrk */, SystemZ::XGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 15477 /* xi */, SystemZ::XI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 15480 /* xihf */, SystemZ::XIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 15485 /* xilf */, SystemZ::XILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 15490 /* xiy */, SystemZ::XIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 15494 /* xr */, SystemZ::XR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 15497 /* xrk */, SystemZ::XRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 15501 /* xsch */, SystemZ::XSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 15506 /* xy */, SystemZ::XY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 15509 /* zap */, SystemZ::ZAP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
};

static const MatchEntry MatchTable1[] = {
  { 1 /* a */, SystemZ::A, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 3 /* ad */, SystemZ::AD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 6 /* adb */, SystemZ::ADB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10 /* adbr */, SystemZ::ADBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 15 /* adr */, SystemZ::ADR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 19 /* adtr */, SystemZ::ADTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 24 /* adtra */, SystemZ::ADTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 30 /* ae */, SystemZ::AE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 33 /* aeb */, SystemZ::AEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 37 /* aebr */, SystemZ::AEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 42 /* aer */, SystemZ::AER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 46 /* afi */, SystemZ::AFI, Convert__GR321_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 50 /* ag */, SystemZ::AG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 53 /* agf */, SystemZ::AGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 57 /* agfi */, SystemZ::AGFI, Convert__GR641_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 62 /* agfr */, SystemZ::AGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 67 /* agh */, SystemZ::AGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 71 /* aghi */, SystemZ::AGHI, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 76 /* aghik */, SystemZ::AGHIK, Convert__GR641_0__GR641_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_S16Imm }, },
  { 82 /* agr */, SystemZ::AGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 86 /* agrk */, SystemZ::AGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 91 /* agsi */, SystemZ::AGSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 96 /* ah */, SystemZ::AH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 99 /* ahhhr */, SystemZ::AHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 105 /* ahhlr */, SystemZ::AHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 111 /* ahi */, SystemZ::AHI, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 115 /* ahik */, SystemZ::AHIK, Convert__GR321_0__GR321_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_S16Imm }, },
  { 120 /* ahy */, SystemZ::AHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 124 /* aih */, SystemZ::AIH, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 128 /* al */, SystemZ::AL, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 131 /* alc */, SystemZ::ALC, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 135 /* alcg */, SystemZ::ALCG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 140 /* alcgr */, SystemZ::ALCGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 146 /* alcr */, SystemZ::ALCR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 151 /* alfi */, SystemZ::ALFI, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 156 /* alg */, SystemZ::ALG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 160 /* algf */, SystemZ::ALGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 165 /* algfi */, SystemZ::ALGFI, Convert__GR641_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 171 /* algfr */, SystemZ::ALGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 177 /* alghsik */, SystemZ::ALGHSIK, Convert__GR641_0__GR641_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_S16Imm }, },
  { 185 /* algr */, SystemZ::ALGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 190 /* algrk */, SystemZ::ALGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 196 /* algsi */, SystemZ::ALGSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 202 /* alhhhr */, SystemZ::ALHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 209 /* alhhlr */, SystemZ::ALHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 216 /* alhsik */, SystemZ::ALHSIK, Convert__GR321_0__GR321_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_S16Imm }, },
  { 223 /* alr */, SystemZ::ALR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 227 /* alrk */, SystemZ::ALRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 232 /* alsi */, SystemZ::ALSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 237 /* alsih */, SystemZ::ALSIH, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 243 /* alsihn */, SystemZ::ALSIHN, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 250 /* aly */, SystemZ::ALY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 254 /* ap */, SystemZ::AP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 257 /* ar */, SystemZ::AR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 260 /* ark */, SystemZ::ARK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 264 /* asi */, SystemZ::ASI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 268 /* au */, SystemZ::AU, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 271 /* aur */, SystemZ::AUR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 275 /* aw */, SystemZ::AW, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 278 /* awr */, SystemZ::AWR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 282 /* axbr */, SystemZ::AXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 287 /* axr */, SystemZ::AXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 291 /* axtr */, SystemZ::AXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 296 /* axtra */, SystemZ::AXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 302 /* ay */, SystemZ::AY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 305 /* b */, SystemZ::B, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 307 /* bakr */, SystemZ::BAKR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 312 /* bal */, SystemZ::BAL, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 316 /* balr */, SystemZ::BALR, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 321 /* bas */, SystemZ::BAS, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 325 /* basr */, SystemZ::BASR, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 330 /* bassm */, SystemZ::BASSM, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 336 /* bc */, SystemZ::BCAsm, Convert__U4Imm1_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_U4Imm, MCK_BDXAddr64Disp12 }, },
  { 339 /* bcr */, SystemZ::BCRAsm, Convert__U4Imm1_0__GR641_1, AMFBS_None, { MCK_U4Imm, MCK_GR64 }, },
  { 343 /* bct */, SystemZ::BCT, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 347 /* bctg */, SystemZ::BCTG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 352 /* bctgr */, SystemZ::BCTGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 358 /* bctr */, SystemZ::BCTR, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 363 /* bdepg */, SystemZ::BDEPG, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 369 /* be */, SystemZ::BAsmE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 372 /* ber */, SystemZ::BRAsmE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 376 /* bextg */, SystemZ::BEXTG, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 382 /* bh */, SystemZ::BAsmH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 394 /* bhr */, SystemZ::BRAsmH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 398 /* bi */, SystemZ::BI, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 401 /* bic */, SystemZ::BICAsm, Convert__U4Imm1_0__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_U4Imm, MCK_BDXAddr64Disp20 }, },
  { 405 /* bie */, SystemZ::BIAsmE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 409 /* bih */, SystemZ::BIAsmH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 418 /* bil */, SystemZ::BIAsmL, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 432 /* bim */, SystemZ::BIAsmM, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 436 /* bine */, SystemZ::BIAsmNE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 441 /* binh */, SystemZ::BIAsmNH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 452 /* binl */, SystemZ::BIAsmNL, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 469 /* binm */, SystemZ::BIAsmNM, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 474 /* bino */, SystemZ::BIAsmNO, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 479 /* binp */, SystemZ::BIAsmNP, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 484 /* binz */, SystemZ::BIAsmNZ, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 489 /* bio */, SystemZ::BIAsmO, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 493 /* bip */, SystemZ::BIAsmP, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 497 /* biz */, SystemZ::BIAsmZ, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 501 /* bl */, SystemZ::BAsmL, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 522 /* blr */, SystemZ::BRAsmL, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 526 /* bm */, SystemZ::BAsmM, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 529 /* bmr */, SystemZ::BRAsmM, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 533 /* bne */, SystemZ::BAsmNE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 537 /* bner */, SystemZ::BRAsmNE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 542 /* bnh */, SystemZ::BAsmNH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 557 /* bnhr */, SystemZ::BRAsmNH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 562 /* bnl */, SystemZ::BAsmNL, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 588 /* bnlr */, SystemZ::BRAsmNL, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 593 /* bnm */, SystemZ::BAsmNM, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 597 /* bnmr */, SystemZ::BRAsmNM, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 602 /* bno */, SystemZ::BAsmNO, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 606 /* bnor */, SystemZ::BRAsmNO, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 611 /* bnp */, SystemZ::BAsmNP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 615 /* bnpr */, SystemZ::BRAsmNP, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 620 /* bnz */, SystemZ::BAsmNZ, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 624 /* bnzr */, SystemZ::BRAsmNZ, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 629 /* bo */, SystemZ::BAsmO, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 632 /* bor */, SystemZ::BRAsmO, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 636 /* bp */, SystemZ::BAsmP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 639 /* bpp */, SystemZ::BPP, Convert__U4Imm1_0__PCRel161_1__BDAddr64Disp122_2, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_PCRel16, MCK_BDAddr64Disp12 }, },
  { 643 /* bpr */, SystemZ::BRAsmP, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 647 /* bprp */, SystemZ::BPRP, Convert__U4Imm1_0__PCRel121_1__PCRel241_2, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_PCRel12, MCK_PCRel24 }, },
  { 652 /* br */, SystemZ::BR, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 655 /* bras */, SystemZ::BRAS, Convert__GR641_0__PCRelTLS162_1, AMFBS_None, { MCK_GR64, MCK_PCRelTLS16 }, },
  { 660 /* brasl */, SystemZ::BRASL, Convert__GR641_0__PCRelTLS322_1, AMFBS_None, { MCK_GR64, MCK_PCRelTLS32 }, },
  { 666 /* brc */, SystemZ::BRCAsm, Convert__U4Imm1_0__PCRel161_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel16 }, },
  { 670 /* brcl */, SystemZ::BRCLAsm, Convert__U4Imm1_0__PCRel321_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel32 }, },
  { 675 /* brct */, SystemZ::BRCT, Convert__GR321_0__Tie0_1_1__PCRel161_1, AMFBS_None, { MCK_GR32, MCK_PCRel16 }, },
  { 680 /* brctg */, SystemZ::BRCTG, Convert__GR641_0__Tie0_1_1__PCRel161_1, AMFBS_None, { MCK_GR64, MCK_PCRel16 }, },
  { 686 /* brcth */, SystemZ::BRCTH, Convert__GRH321_0__Tie0_1_1__PCRel321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_PCRel32 }, },
  { 692 /* brxh */, SystemZ::BRXH, Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 697 /* brxhg */, SystemZ::BRXHG, Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 703 /* brxle */, SystemZ::BRXLE, Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 709 /* brxlg */, SystemZ::BRXLG, Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 715 /* bsa */, SystemZ::BSA, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 719 /* bsg */, SystemZ::BSG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 723 /* bsm */, SystemZ::BSM, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 727 /* bxh */, SystemZ::BXH, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 731 /* bxhg */, SystemZ::BXHG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 736 /* bxle */, SystemZ::BXLE, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 741 /* bxleg */, SystemZ::BXLEG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 747 /* bz */, SystemZ::BAsmZ, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 750 /* bzr */, SystemZ::BRAsmZ, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 754 /* c */, SystemZ::C, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 756 /* cal */, SystemZ::CAL, Convert__GR321_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR32, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 760 /* calg */, SystemZ::CALG, Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 765 /* calgf */, SystemZ::CALGF, Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 771 /* cd */, SystemZ::CD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 774 /* cdb */, SystemZ::CDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 778 /* cdbr */, SystemZ::CDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 783 /* cdfbr */, SystemZ::CDFBR, Convert__FP641_0__GR321_1, AMFBS_None, { MCK_FP64, MCK_GR32 }, },
  { 789 /* cdfbra */, SystemZ::CDFBRA, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 796 /* cdfr */, SystemZ::CDFR, Convert__FP641_0__GR321_1, AMFBS_None, { MCK_FP64, MCK_GR32 }, },
  { 801 /* cdftr */, SystemZ::CDFTR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 807 /* cdgbr */, SystemZ::CDGBR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 813 /* cdgbra */, SystemZ::CDGBRA, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 820 /* cdgr */, SystemZ::CDGR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 825 /* cdgtr */, SystemZ::CDGTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 831 /* cdgtra */, SystemZ::CDGTRA, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 838 /* cdlfbr */, SystemZ::CDLFBR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 845 /* cdlftr */, SystemZ::CDLFTR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 852 /* cdlgbr */, SystemZ::CDLGBR, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 859 /* cdlgtr */, SystemZ::CDLGTR, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 866 /* cdpt */, SystemZ::CDPT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 871 /* cdr */, SystemZ::CDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 875 /* cds */, SystemZ::CDS, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp12 }, },
  { 879 /* cdsg */, SystemZ::CDSG, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp20 }, },
  { 884 /* cdstr */, SystemZ::CDSTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 890 /* cdsy */, SystemZ::CDSY, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp20 }, },
  { 895 /* cdtr */, SystemZ::CDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 900 /* cdutr */, SystemZ::CDUTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 906 /* cdzt */, SystemZ::CDZT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 911 /* ce */, SystemZ::CE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 914 /* ceb */, SystemZ::CEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 918 /* cebr */, SystemZ::CEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 923 /* cedtr */, SystemZ::CEDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 929 /* cefbr */, SystemZ::CEFBR, Convert__FP321_0__GR321_1, AMFBS_None, { MCK_FP32, MCK_GR32 }, },
  { 935 /* cefbra */, SystemZ::CEFBRA, Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 942 /* cefr */, SystemZ::CEFR, Convert__FP321_0__GR321_1, AMFBS_None, { MCK_FP32, MCK_GR32 }, },
  { 947 /* cegbr */, SystemZ::CEGBR, Convert__FP321_0__GR641_1, AMFBS_None, { MCK_FP32, MCK_GR64 }, },
  { 953 /* cegbra */, SystemZ::CEGBRA, Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 960 /* cegr */, SystemZ::CEGR, Convert__FP321_0__GR641_1, AMFBS_None, { MCK_FP32, MCK_GR64 }, },
  { 965 /* celfbr */, SystemZ::CELFBR, Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 972 /* celgbr */, SystemZ::CELGBR, Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 979 /* cer */, SystemZ::CER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 983 /* cextr */, SystemZ::CEXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 989 /* cfc */, SystemZ::CFC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 993 /* cfdbr */, SystemZ::CFDBR, Convert__GR321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP64 }, },
  { 999 /* cfdbra */, SystemZ::CFDBRA, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1006 /* cfdr */, SystemZ::CFDR, Convert__GR321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP64 }, },
  { 1011 /* cfdtr */, SystemZ::CFDTR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1017 /* cfebr */, SystemZ::CFEBR, Convert__GR321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP32 }, },
  { 1023 /* cfebra */, SystemZ::CFEBRA, Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 1030 /* cfer */, SystemZ::CFER, Convert__GR321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP32 }, },
  { 1035 /* cfi */, SystemZ::CFI, Convert__GR321_0__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 1039 /* cfxbr */, SystemZ::CFXBR, Convert__GR321_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP128 }, },
  { 1045 /* cfxbra */, SystemZ::CFXBRA, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1052 /* cfxr */, SystemZ::CFXR, Convert__GR321_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP128 }, },
  { 1057 /* cfxtr */, SystemZ::CFXTR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1063 /* cg */, SystemZ::CG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1066 /* cgdbr */, SystemZ::CGDBR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1072 /* cgdbra */, SystemZ::CGDBRA, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1079 /* cgdr */, SystemZ::CGDR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1084 /* cgdtr */, SystemZ::CGDTR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1090 /* cgdtra */, SystemZ::CGDTRA, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1097 /* cgebr */, SystemZ::CGEBR, Convert__GR641_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP32 }, },
  { 1103 /* cgebra */, SystemZ::CGEBRA, Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 1110 /* cger */, SystemZ::CGER, Convert__GR641_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP32 }, },
  { 1115 /* cgf */, SystemZ::CGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1119 /* cgfi */, SystemZ::CGFI, Convert__GR641_0__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 1124 /* cgfr */, SystemZ::CGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 1129 /* cgfrl */, SystemZ::CGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1135 /* cgh */, SystemZ::CGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1139 /* cghi */, SystemZ::CGHI, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1144 /* cghrl */, SystemZ::CGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1150 /* cghsi */, SystemZ::CGHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1156 /* cgib */, SystemZ::CGIBAsm, Convert__GR641_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1161 /* cgibe */, SystemZ::CGIBAsmE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1167 /* cgibh */, SystemZ::CGIBAsmH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1180 /* cgibl */, SystemZ::CGIBAsmL, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1200 /* cgibne */, SystemZ::CGIBAsmNE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1207 /* cgibnh */, SystemZ::CGIBAsmNH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1222 /* cgibnl */, SystemZ::CGIBAsmNL, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1245 /* cgij */, SystemZ::CGIJAsm, Convert__GR641_0__S8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 1250 /* cgije */, SystemZ::CGIJAsmE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1256 /* cgijh */, SystemZ::CGIJAsmH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1269 /* cgijl */, SystemZ::CGIJAsmL, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1289 /* cgijne */, SystemZ::CGIJAsmNE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1296 /* cgijnh */, SystemZ::CGIJAsmNH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1311 /* cgijnl */, SystemZ::CGIJAsmNL, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1334 /* cgit */, SystemZ::CGITAsm, Convert__GR641_0__S16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_S16Imm, MCK_U4Imm }, },
  { 1339 /* cgite */, SystemZ::CGITAsmE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1345 /* cgith */, SystemZ::CGITAsmH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1358 /* cgitl */, SystemZ::CGITAsmL, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1378 /* cgitne */, SystemZ::CGITAsmNE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1385 /* cgitnh */, SystemZ::CGITAsmNH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1400 /* cgitnl */, SystemZ::CGITAsmNL, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1423 /* cgr */, SystemZ::CGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1427 /* cgrb */, SystemZ::CGRBAsm, Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1432 /* cgrbe */, SystemZ::CGRBAsmE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1438 /* cgrbh */, SystemZ::CGRBAsmH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1451 /* cgrbl */, SystemZ::CGRBAsmL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1471 /* cgrbne */, SystemZ::CGRBAsmNE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1478 /* cgrbnh */, SystemZ::CGRBAsmNH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1493 /* cgrbnl */, SystemZ::CGRBAsmNL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1516 /* cgrj */, SystemZ::CGRJAsm, Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_PCRel16 }, },
  { 1521 /* cgrje */, SystemZ::CGRJAsmE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1527 /* cgrjh */, SystemZ::CGRJAsmH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1540 /* cgrjl */, SystemZ::CGRJAsmL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1560 /* cgrjne */, SystemZ::CGRJAsmNE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1567 /* cgrjnh */, SystemZ::CGRJAsmNH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1582 /* cgrjnl */, SystemZ::CGRJAsmNL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1605 /* cgrl */, SystemZ::CGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1610 /* cgrt */, SystemZ::CGRTAsm, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 1615 /* cgrte */, SystemZ::CGRTAsmE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1621 /* cgrth */, SystemZ::CGRTAsmH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1634 /* cgrtl */, SystemZ::CGRTAsmL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1654 /* cgrtne */, SystemZ::CGRTAsmNE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1661 /* cgrtnh */, SystemZ::CGRTAsmNH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1676 /* cgrtnl */, SystemZ::CGRTAsmNL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1699 /* cgxbr */, SystemZ::CGXBR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1705 /* cgxbra */, SystemZ::CGXBRA, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1712 /* cgxr */, SystemZ::CGXR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1717 /* cgxtr */, SystemZ::CGXTR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1723 /* cgxtra */, SystemZ::CGXTRA, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1730 /* ch */, SystemZ::CH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 1733 /* chf */, SystemZ::CHF, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 1737 /* chhr */, SystemZ::CHHR, Convert__GRH321_0__GRH321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32 }, },
  { 1742 /* chhsi */, SystemZ::CHHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1748 /* chi */, SystemZ::CHI, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1752 /* chlr */, SystemZ::CHLR, Convert__GRH321_0__GR321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR32 }, },
  { 1757 /* chrl */, SystemZ::CHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 1762 /* chsi */, SystemZ::CHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1767 /* chy */, SystemZ::CHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 1771 /* cib */, SystemZ::CIBAsm, Convert__GR321_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1775 /* cibe */, SystemZ::CIBAsmE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1780 /* cibh */, SystemZ::CIBAsmH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1791 /* cibl */, SystemZ::CIBAsmL, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1808 /* cibne */, SystemZ::CIBAsmNE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1814 /* cibnh */, SystemZ::CIBAsmNH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1827 /* cibnl */, SystemZ::CIBAsmNL, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1847 /* cih */, SystemZ::CIH, Convert__GRH321_0__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 1851 /* cij */, SystemZ::CIJAsm, Convert__GR321_0__S8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 1855 /* cije */, SystemZ::CIJAsmE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1860 /* cijh */, SystemZ::CIJAsmH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1871 /* cijl */, SystemZ::CIJAsmL, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1888 /* cijne */, SystemZ::CIJAsmNE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1894 /* cijnh */, SystemZ::CIJAsmNH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1907 /* cijnl */, SystemZ::CIJAsmNL, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1927 /* cit */, SystemZ::CITAsm, Convert__GR321_0__S16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_S16Imm, MCK_U4Imm }, },
  { 1931 /* cite */, SystemZ::CITAsmE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1936 /* cith */, SystemZ::CITAsmH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1947 /* citl */, SystemZ::CITAsmL, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1964 /* citne */, SystemZ::CITAsmNE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1970 /* citnh */, SystemZ::CITAsmNH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1983 /* citnl */, SystemZ::CITAsmNL, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 2003 /* cksm */, SystemZ::CKSM, Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 2008 /* cl */, SystemZ::CL, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 2011 /* clc */, SystemZ::CLC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 2015 /* clcl */, SystemZ::CLCL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 2020 /* clcle */, SystemZ::CLCLE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 2026 /* clclu */, SystemZ::CLCLU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp20 }, },
  { 2032 /* clfdbr */, SystemZ::CLFDBR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2039 /* clfdtr */, SystemZ::CLFDTR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2046 /* clfebr */, SystemZ::CLFEBR, Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 2053 /* clfhsi */, SystemZ::CLFHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2060 /* clfi */, SystemZ::CLFI, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 2065 /* clfit */, SystemZ::CLFITAsm, Convert__GR321_0__U16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_U16Imm, MCK_U4Imm }, },
  { 2071 /* clfite */, SystemZ::CLFITAsmE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2078 /* clfith */, SystemZ::CLFITAsmH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2093 /* clfitl */, SystemZ::CLFITAsmL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2116 /* clfitne */, SystemZ::CLFITAsmNE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2124 /* clfitnh */, SystemZ::CLFITAsmNH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2141 /* clfitnl */, SystemZ::CLFITAsmNL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2167 /* clfxbr */, SystemZ::CLFXBR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2174 /* clfxtr */, SystemZ::CLFXTR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2181 /* clg */, SystemZ::CLG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 2185 /* clgdbr */, SystemZ::CLGDBR, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2192 /* clgdtr */, SystemZ::CLGDTR, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2199 /* clgebr */, SystemZ::CLGEBR, Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 2206 /* clgf */, SystemZ::CLGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 2211 /* clgfi */, SystemZ::CLGFI, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 2217 /* clgfr */, SystemZ::CLGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 2223 /* clgfrl */, SystemZ::CLGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2230 /* clghrl */, SystemZ::CLGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2237 /* clghsi */, SystemZ::CLGHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2244 /* clgib */, SystemZ::CLGIBAsm, Convert__GR641_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 2250 /* clgibe */, SystemZ::CLGIBAsmE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2257 /* clgibh */, SystemZ::CLGIBAsmH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2272 /* clgibl */, SystemZ::CLGIBAsmL, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2295 /* clgibne */, SystemZ::CLGIBAsmNE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2303 /* clgibnh */, SystemZ::CLGIBAsmNH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2320 /* clgibnl */, SystemZ::CLGIBAsmNL, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2346 /* clgij */, SystemZ::CLGIJAsm, Convert__GR641_0__U8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 2352 /* clgije */, SystemZ::CLGIJAsmE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2359 /* clgijh */, SystemZ::CLGIJAsmH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2374 /* clgijl */, SystemZ::CLGIJAsmL, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2397 /* clgijne */, SystemZ::CLGIJAsmNE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2405 /* clgijnh */, SystemZ::CLGIJAsmNH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2422 /* clgijnl */, SystemZ::CLGIJAsmNL, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2448 /* clgit */, SystemZ::CLGITAsm, Convert__GR641_0__U16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_U16Imm, MCK_U4Imm }, },
  { 2454 /* clgite */, SystemZ::CLGITAsmE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2461 /* clgith */, SystemZ::CLGITAsmH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2476 /* clgitl */, SystemZ::CLGITAsmL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2499 /* clgitne */, SystemZ::CLGITAsmNE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2507 /* clgitnh */, SystemZ::CLGITAsmNH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2524 /* clgitnl */, SystemZ::CLGITAsmNL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2550 /* clgr */, SystemZ::CLGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2555 /* clgrb */, SystemZ::CLGRBAsm, Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 2561 /* clgrbe */, SystemZ::CLGRBAsmE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2568 /* clgrbh */, SystemZ::CLGRBAsmH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2583 /* clgrbl */, SystemZ::CLGRBAsmL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2606 /* clgrbne */, SystemZ::CLGRBAsmNE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2614 /* clgrbnh */, SystemZ::CLGRBAsmNH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2631 /* clgrbnl */, SystemZ::CLGRBAsmNL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2657 /* clgrj */, SystemZ::CLGRJAsm, Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_PCRel16 }, },
  { 2663 /* clgrje */, SystemZ::CLGRJAsmE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2670 /* clgrjh */, SystemZ::CLGRJAsmH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2685 /* clgrjl */, SystemZ::CLGRJAsmL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2708 /* clgrjne */, SystemZ::CLGRJAsmNE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2716 /* clgrjnh */, SystemZ::CLGRJAsmNH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2733 /* clgrjnl */, SystemZ::CLGRJAsmNL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2759 /* clgrl */, SystemZ::CLGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2765 /* clgrt */, SystemZ::CLGRTAsm, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 2771 /* clgrte */, SystemZ::CLGRTAsmE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2778 /* clgrth */, SystemZ::CLGRTAsmH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2793 /* clgrtl */, SystemZ::CLGRTAsmL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2816 /* clgrtne */, SystemZ::CLGRTAsmNE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2824 /* clgrtnh */, SystemZ::CLGRTAsmNH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2841 /* clgrtnl */, SystemZ::CLGRTAsmNL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2867 /* clgt */, SystemZ::CLGTAsm, Convert__GR641_0__BDAddr64Disp202_2__U4Imm1_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 2872 /* clgte */, SystemZ::CLGTAsmE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2878 /* clgth */, SystemZ::CLGTAsmH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2891 /* clgtl */, SystemZ::CLGTAsmL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2911 /* clgtne */, SystemZ::CLGTAsmNE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2918 /* clgtnh */, SystemZ::CLGTAsmNH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2933 /* clgtnl */, SystemZ::CLGTAsmNL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2956 /* clgxbr */, SystemZ::CLGXBR, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2963 /* clgxtr */, SystemZ::CLGXTR, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2970 /* clhf */, SystemZ::CLHF, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 2975 /* clhhr */, SystemZ::CLHHR, Convert__GRH321_0__GRH321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32 }, },
  { 2981 /* clhhsi */, SystemZ::CLHHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2988 /* clhlr */, SystemZ::CLHLR, Convert__GRH321_0__GR321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR32 }, },
  { 2994 /* clhrl */, SystemZ::CLHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 3000 /* cli */, SystemZ::CLI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 3004 /* clib */, SystemZ::CLIBAsm, Convert__GR321_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3009 /* clibe */, SystemZ::CLIBAsmE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3015 /* clibh */, SystemZ::CLIBAsmH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3028 /* clibl */, SystemZ::CLIBAsmL, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3048 /* clibne */, SystemZ::CLIBAsmNE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3055 /* clibnh */, SystemZ::CLIBAsmNH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3070 /* clibnl */, SystemZ::CLIBAsmNL, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3093 /* clih */, SystemZ::CLIH, Convert__GRH321_0__U32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_U32Imm }, },
  { 3098 /* clij */, SystemZ::CLIJAsm, Convert__GR321_0__U8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 3103 /* clije */, SystemZ::CLIJAsmE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3109 /* clijh */, SystemZ::CLIJAsmH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3122 /* clijl */, SystemZ::CLIJAsmL, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3142 /* clijne */, SystemZ::CLIJAsmNE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3149 /* clijnh */, SystemZ::CLIJAsmNH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3164 /* clijnl */, SystemZ::CLIJAsmNL, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3187 /* cliy */, SystemZ::CLIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 3192 /* clm */, SystemZ::CLM, Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3196 /* clmh */, SystemZ::CLMH, Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3201 /* clmy */, SystemZ::CLMY, Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3206 /* clr */, SystemZ::CLR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3210 /* clrb */, SystemZ::CLRBAsm, Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3215 /* clrbe */, SystemZ::CLRBAsmE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3221 /* clrbh */, SystemZ::CLRBAsmH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3234 /* clrbl */, SystemZ::CLRBAsmL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3254 /* clrbne */, SystemZ::CLRBAsmNE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3261 /* clrbnh */, SystemZ::CLRBAsmNH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3276 /* clrbnl */, SystemZ::CLRBAsmNL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3299 /* clrj */, SystemZ::CLRJAsm, Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_PCRel16 }, },
  { 3304 /* clrje */, SystemZ::CLRJAsmE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3310 /* clrjh */, SystemZ::CLRJAsmH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3323 /* clrjl */, SystemZ::CLRJAsmL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3343 /* clrjne */, SystemZ::CLRJAsmNE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3350 /* clrjnh */, SystemZ::CLRJAsmNH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3365 /* clrjnl */, SystemZ::CLRJAsmNL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3388 /* clrl */, SystemZ::CLRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 3393 /* clrt */, SystemZ::CLRTAsm, Convert__GR321_0__GR321_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 3398 /* clrte */, SystemZ::CLRTAsmE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3404 /* clrth */, SystemZ::CLRTAsmH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3417 /* clrtl */, SystemZ::CLRTAsmL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3437 /* clrtne */, SystemZ::CLRTAsmNE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3444 /* clrtnh */, SystemZ::CLRTAsmNH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3459 /* clrtnl */, SystemZ::CLRTAsmNL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3482 /* clst */, SystemZ::CLST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3487 /* clt */, SystemZ::CLTAsm, Convert__GR321_0__BDAddr64Disp202_2__U4Imm1_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3491 /* clte */, SystemZ::CLTAsmE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3496 /* clth */, SystemZ::CLTAsmH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3507 /* cltl */, SystemZ::CLTAsmL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3524 /* cltne */, SystemZ::CLTAsmNE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3530 /* cltnh */, SystemZ::CLTAsmNH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3543 /* cltnl */, SystemZ::CLTAsmNL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3563 /* cly */, SystemZ::CLY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3567 /* clzg */, SystemZ::CLZG, Convert__GR641_0__GR641_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64 }, },
  { 3572 /* cmpsc */, SystemZ::CMPSC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3578 /* cp */, SystemZ::CP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 3581 /* cpdt */, SystemZ::CPDT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 3586 /* cpsdr */, SystemZ::CPSDRdd, Convert__FP641_0__FP641_2__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 3592 /* cpxt */, SystemZ::CPXT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 3597 /* cpya */, SystemZ::CPYA, Convert__AR321_0__AR321_1, AMFBS_None, { MCK_AR32, MCK_AR32 }, },
  { 3602 /* cr */, SystemZ::CR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3605 /* crb */, SystemZ::CRBAsm, Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3609 /* crbe */, SystemZ::CRBAsmE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3614 /* crbh */, SystemZ::CRBAsmH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3625 /* crbl */, SystemZ::CRBAsmL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3642 /* crbne */, SystemZ::CRBAsmNE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3648 /* crbnh */, SystemZ::CRBAsmNH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3661 /* crbnl */, SystemZ::CRBAsmNL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3681 /* crdte */, SystemZ::CRDTEOpt, Convert__GR1281_0__GR1281_2__GR641_1, AMFBS_FeatureEnhancedDAT2, { MCK_GR128, MCK_GR64, MCK_GR128 }, },
  { 3681 /* crdte */, SystemZ::CRDTE, Convert__GR1281_0__GR1281_2__GR641_1__U4Imm1_3, AMFBS_FeatureEnhancedDAT2, { MCK_GR128, MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 3687 /* crj */, SystemZ::CRJAsm, Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_PCRel16 }, },
  { 3691 /* crje */, SystemZ::CRJAsmE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3696 /* crjh */, SystemZ::CRJAsmH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3707 /* crjl */, SystemZ::CRJAsmL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3724 /* crjne */, SystemZ::CRJAsmNE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3730 /* crjnh */, SystemZ::CRJAsmNH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3743 /* crjnl */, SystemZ::CRJAsmNL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3763 /* crl */, SystemZ::CRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 3767 /* crt */, SystemZ::CRTAsm, Convert__GR321_0__GR321_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 3771 /* crte */, SystemZ::CRTAsmE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3776 /* crth */, SystemZ::CRTAsmH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3787 /* crtl */, SystemZ::CRTAsmL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3804 /* crtne */, SystemZ::CRTAsmNE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3810 /* crtnh */, SystemZ::CRTAsmNH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3823 /* crtnl */, SystemZ::CRTAsmNL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3843 /* cs */, SystemZ::CS, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3846 /* csch */, SystemZ::CSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 3851 /* csdtr */, SystemZ::CSDTR, Convert__GR641_0__FP641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_FP64, MCK_U4Imm }, },
  { 3857 /* csg */, SystemZ::CSG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 3861 /* csp */, SystemZ::CSP, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 3865 /* cspg */, SystemZ::CSPG, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 3870 /* csst */, SystemZ::CSST, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 3875 /* csxtr */, SystemZ::CSXTR, Convert__GR1281_0__FP1281_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_FP128, MCK_U4Imm }, },
  { 3881 /* csy */, SystemZ::CSY, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3885 /* ctzg */, SystemZ::CTZG, Convert__GR641_0__GR641_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64 }, },
  { 3890 /* cu12 */, SystemZ::CU12Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3890 /* cu12 */, SystemZ::CU12, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3895 /* cu14 */, SystemZ::CU14Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3895 /* cu14 */, SystemZ::CU14, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3900 /* cu21 */, SystemZ::CU21Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3900 /* cu21 */, SystemZ::CU21, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3905 /* cu24 */, SystemZ::CU24Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3905 /* cu24 */, SystemZ::CU24, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3910 /* cu41 */, SystemZ::CU41, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3915 /* cu42 */, SystemZ::CU42, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3920 /* cudtr */, SystemZ::CUDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 3926 /* cuse */, SystemZ::CUSE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3931 /* cutfu */, SystemZ::CUTFUOpt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3931 /* cutfu */, SystemZ::CUTFU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3937 /* cuutf */, SystemZ::CUUTFOpt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3937 /* cuutf */, SystemZ::CUUTF, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3943 /* cuxtr */, SystemZ::CUXTR, Convert__GR1281_0__FP1281_1, AMFBS_None, { MCK_GR128, MCK_FP128 }, },
  { 3949 /* cvb */, SystemZ::CVB, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 3953 /* cvbg */, SystemZ::CVBG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 3958 /* cvby */, SystemZ::CVBY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3963 /* cvd */, SystemZ::CVD, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 3967 /* cvdg */, SystemZ::CVDG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 3972 /* cvdy */, SystemZ::CVDY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3977 /* cxbr */, SystemZ::CXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 3982 /* cxfbr */, SystemZ::CXFBR, Convert__FP1281_0__GR321_1, AMFBS_None, { MCK_FP128, MCK_GR32 }, },
  { 3988 /* cxfbra */, SystemZ::CXFBRA, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 3995 /* cxfr */, SystemZ::CXFR, Convert__FP1281_0__GR321_1, AMFBS_None, { MCK_FP128, MCK_GR32 }, },
  { 4000 /* cxftr */, SystemZ::CXFTR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4006 /* cxgbr */, SystemZ::CXGBR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4012 /* cxgbra */, SystemZ::CXGBRA, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4019 /* cxgr */, SystemZ::CXGR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4024 /* cxgtr */, SystemZ::CXGTR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4030 /* cxgtra */, SystemZ::CXGTRA, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4037 /* cxlfbr */, SystemZ::CXLFBR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4044 /* cxlftr */, SystemZ::CXLFTR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4051 /* cxlgbr */, SystemZ::CXLGBR, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4058 /* cxlgtr */, SystemZ::CXLGTR, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4065 /* cxpt */, SystemZ::CXPT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4070 /* cxr */, SystemZ::CXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4074 /* cxstr */, SystemZ::CXSTR, Convert__FP1281_0__GR1281_1, AMFBS_None, { MCK_FP128, MCK_GR128 }, },
  { 4080 /* cxtr */, SystemZ::CXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4085 /* cxutr */, SystemZ::CXUTR, Convert__FP1281_0__GR1281_1, AMFBS_None, { MCK_FP128, MCK_GR128 }, },
  { 4091 /* cxzt */, SystemZ::CXZT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4096 /* cy */, SystemZ::CY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4099 /* czdt */, SystemZ::CZDT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4104 /* czxt */, SystemZ::CZXT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4109 /* d */, SystemZ::D, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp12 }, },
  { 4111 /* dd */, SystemZ::DD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4114 /* ddb */, SystemZ::DDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4118 /* ddbr */, SystemZ::DDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4123 /* ddr */, SystemZ::DDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4127 /* ddtr */, SystemZ::DDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 4132 /* ddtra */, SystemZ::DDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 4138 /* de */, SystemZ::DE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4141 /* deb */, SystemZ::DEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4145 /* debr */, SystemZ::DEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4150 /* der */, SystemZ::DER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4154 /* dfltcc */, SystemZ::DFLTCC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__GR641_2, AMFBS_FeatureDeflateConversion, { MCK_GR128, MCK_GR128, MCK_GR64 }, },
  { 4161 /* diag */, SystemZ::DIAG, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 4166 /* didbr */, SystemZ::DIDBR, Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 4172 /* diebr */, SystemZ::DIEBR, Convert__FP321_0__FP321_1__Tie0_1_1__FP321_2__U4Imm1_3, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32, MCK_U4Imm }, },
  { 4178 /* dl */, SystemZ::DL, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4181 /* dlg */, SystemZ::DLG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4185 /* dlgr */, SystemZ::DLGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4190 /* dlr */, SystemZ::DLR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4194 /* dp */, SystemZ::DP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 4197 /* dr */, SystemZ::DR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4200 /* dsg */, SystemZ::DSG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4204 /* dsgf */, SystemZ::DSGF, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4209 /* dsgfr */, SystemZ::DSGFR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4215 /* dsgr */, SystemZ::DSGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4220 /* dxbr */, SystemZ::DXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4225 /* dxr */, SystemZ::DXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4229 /* dxtr */, SystemZ::DXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 4234 /* dxtra */, SystemZ::DXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 4240 /* ear */, SystemZ::EAR, Convert__GR321_0__AR321_1, AMFBS_None, { MCK_GR32, MCK_AR32 }, },
  { 4244 /* ecag */, SystemZ::ECAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 4249 /* ecctr */, SystemZ::ECCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4255 /* ecpga */, SystemZ::ECPGA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4261 /* ectg */, SystemZ::ECTG, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 4266 /* ed */, SystemZ::ED, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 4269 /* edmk */, SystemZ::EDMK, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 4274 /* eedtr */, SystemZ::EEDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 4280 /* eextr */, SystemZ::EEXTR, Convert__GR641_0__FP1281_1, AMFBS_None, { MCK_GR64, MCK_FP128 }, },
  { 4286 /* efpc */, SystemZ::EFPC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4291 /* epair */, SystemZ::EPAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 4297 /* epar */, SystemZ::EPAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4302 /* epctr */, SystemZ::EPCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4308 /* epsw */, SystemZ::EPSW, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4313 /* ereg */, SystemZ::EREG, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4318 /* eregg */, SystemZ::EREGG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4324 /* esair */, SystemZ::ESAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 4330 /* esar */, SystemZ::ESAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4335 /* esdtr */, SystemZ::ESDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 4341 /* esea */, SystemZ::ESEA, Convert__GR321_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 4346 /* esta */, SystemZ::ESTA, Convert__GR1281_0__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4351 /* esxtr */, SystemZ::ESXTR, Convert__GR641_0__FP1281_1, AMFBS_None, { MCK_GR64, MCK_FP128 }, },
  { 4357 /* etnd */, SystemZ::ETND, Convert__GR321_0, AMFBS_FeatureTransactionalExecution, { MCK_GR32 }, },
  { 4362 /* ex */, SystemZ::EX, Convert__ADDR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_ADDR64, MCK_BDXAddr64Disp12 }, },
  { 4365 /* exrl */, SystemZ::EXRL, Convert__ADDR641_0__PCRel321_1, AMFBS_None, { MCK_ADDR64, MCK_PCRel32 }, },
  { 4370 /* fidbr */, SystemZ::FIDBR, Convert__FP641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64 }, },
  { 4376 /* fidbra */, SystemZ::FIDBRA, Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 4383 /* fidr */, SystemZ::FIDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4388 /* fidtr */, SystemZ::FIDTR, Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 4394 /* fiebr */, SystemZ::FIEBR, Convert__FP321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP32 }, },
  { 4400 /* fiebra */, SystemZ::FIEBRA, Convert__FP321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 4407 /* fier */, SystemZ::FIER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4412 /* fixbr */, SystemZ::FIXBR, Convert__FP1281_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128 }, },
  { 4418 /* fixbra */, SystemZ::FIXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 4425 /* fixr */, SystemZ::FIXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4430 /* fixtr */, SystemZ::FIXTR, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 4436 /* flogr */, SystemZ::FLOGR, Convert__GR1281_0__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4442 /* hdr */, SystemZ::HDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4446 /* her */, SystemZ::HER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4450 /* hsch */, SystemZ::HSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 4455 /* iac */, SystemZ::IAC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4459 /* ic */, SystemZ::IC, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4462 /* icm */, SystemZ::ICM, Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 4466 /* icmh */, SystemZ::ICMH, Convert__GRH321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 4471 /* icmy */, SystemZ::ICMY, Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 4476 /* icy */, SystemZ::ICY, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4480 /* idte */, SystemZ::IDTEOpt, Convert__GR641_0__GR641_2__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4480 /* idte */, SystemZ::IDTE, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 4485 /* iedtr */, SystemZ::IEDTR, Convert__FP641_0__GR641_2__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_GR64 }, },
  { 4491 /* iextr */, SystemZ::IEXTR, Convert__FP1281_0__GR641_2__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_GR64 }, },
  { 4497 /* iihf */, SystemZ::IIHF, Convert__GRH321_0__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 4502 /* iihh */, SystemZ::IIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 4507 /* iihl */, SystemZ::IIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 4512 /* iilf */, SystemZ::IILF, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 4517 /* iilh */, SystemZ::IILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 4522 /* iill */, SystemZ::IILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 4527 /* ipk */, SystemZ::IPK, Convert_NoOperands, AMFBS_None, {  }, },
  { 4531 /* ipm */, SystemZ::IPM, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4535 /* ipte */, SystemZ::IPTEOptOpt, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 4535 /* ipte */, SystemZ::IPTEOpt, Convert__GR641_0__GR321_1__GR321_2, AMFBS_None, { MCK_GR64, MCK_GR32, MCK_GR32 }, },
  { 4535 /* ipte */, SystemZ::IPTE, Convert__GR641_0__GR321_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 4540 /* irbm */, SystemZ::IRBM, Convert__GR641_0__GR641_1, AMFBS_FeatureInsertReferenceBitsMultiple, { MCK_GR64, MCK_GR64 }, },
  { 4545 /* iske */, SystemZ::ISKE, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4550 /* ivsk */, SystemZ::IVSK, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4555 /* j */, SystemZ::J, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4557 /* je */, SystemZ::JAsmE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4665 /* jh */, SystemZ::JAsmH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4672 /* jl */, SystemZ::JAsmL, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4675 /* jle */, SystemZ::JGAsmE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4679 /* jlh */, SystemZ::JGAsmH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4683 /* jll */, SystemZ::JGAsmL, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4687 /* jlm */, SystemZ::JGAsmM, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4691 /* jlne */, SystemZ::JGAsmNE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4696 /* jlnh */, SystemZ::JGAsmNH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4701 /* jlnl */, SystemZ::JGAsmNL, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4706 /* jlnm */, SystemZ::JGAsmNM, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4711 /* jlno */, SystemZ::JGAsmNO, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4716 /* jlnop */, SystemZ::JGNOP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4722 /* jlnp */, SystemZ::JGAsmNP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4727 /* jlnz */, SystemZ::JGAsmNZ, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4732 /* jlo */, SystemZ::JGAsmO, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4736 /* jlp */, SystemZ::JGAsmP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4740 /* jlu */, SystemZ::JG, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4744 /* jlz */, SystemZ::JGAsmZ, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4748 /* jm */, SystemZ::JAsmM, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4751 /* jne */, SystemZ::JAsmNE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4755 /* jnh */, SystemZ::JAsmNH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4764 /* jnl */, SystemZ::JAsmNL, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4778 /* jnm */, SystemZ::JAsmNM, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4782 /* jno */, SystemZ::JAsmNO, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4786 /* jnop */, SystemZ::JNOP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4791 /* jnp */, SystemZ::JAsmNP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4795 /* jnz */, SystemZ::JAsmNZ, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4799 /* jo */, SystemZ::JAsmO, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4802 /* jp */, SystemZ::JAsmP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4805 /* jz */, SystemZ::JAsmZ, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4808 /* kdb */, SystemZ::KDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4812 /* kdbr */, SystemZ::KDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4817 /* kdsa */, SystemZ::KDSA, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_FeatureMessageSecurityAssist9, { MCK_GR64, MCK_GR128 }, },
  { 4822 /* kdtr */, SystemZ::KDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4827 /* keb */, SystemZ::KEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4831 /* kebr */, SystemZ::KEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4836 /* kimd */, SystemZ::KIMD, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4836 /* kimd */, SystemZ::KIMDOpt, Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_FeatureMessageSecurityAssist12, { MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 4841 /* klmd */, SystemZ::KLMD, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4841 /* klmd */, SystemZ::KLMDOpt, Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_FeatureMessageSecurityAssist12, { MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 4846 /* km */, SystemZ::KM, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 4849 /* kma */, SystemZ::KMA, Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1, AMFBS_FeatureMessageSecurityAssist8, { MCK_GR128, MCK_GR128, MCK_GR128 }, },
  { 4853 /* kmac */, SystemZ::KMAC, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4858 /* kmc */, SystemZ::KMC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 4862 /* kmctr */, SystemZ::KMCTR, Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128, MCK_GR128 }, },
  { 4868 /* kmf */, SystemZ::KMF, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128 }, },
  { 4872 /* kmo */, SystemZ::KMO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128 }, },
  { 4876 /* kxbr */, SystemZ::KXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4881 /* kxtr */, SystemZ::KXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4886 /* l */, SystemZ::L, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 4888 /* la */, SystemZ::LA, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4891 /* laa */, SystemZ::LAA, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4895 /* laag */, SystemZ::LAAG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4900 /* laal */, SystemZ::LAAL, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4905 /* laalg */, SystemZ::LAALG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4911 /* lae */, SystemZ::LAE, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4915 /* laey */, SystemZ::LAEY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4920 /* lam */, SystemZ::LAM, Convert__AR321_0__AR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp12 }, },
  { 4924 /* lamy */, SystemZ::LAMY, Convert__AR321_0__AR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp20 }, },
  { 4929 /* lan */, SystemZ::LAN, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4933 /* lang */, SystemZ::LANG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4938 /* lao */, SystemZ::LAO, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4942 /* laog */, SystemZ::LAOG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4947 /* larl */, SystemZ::LARL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 4952 /* lasp */, SystemZ::LASP, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 4957 /* lat */, SystemZ::LAT, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4961 /* lax */, SystemZ::LAX, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4965 /* laxg */, SystemZ::LAXG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4970 /* lay */, SystemZ::LAY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4974 /* lb */, SystemZ::LB, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4977 /* lbear */, SystemZ::LBEAR, Convert__BDAddr64Disp122_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp12 }, },
  { 4983 /* lbh */, SystemZ::LBH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 4987 /* lbr */, SystemZ::LBR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4991 /* lcbb */, SystemZ::LCBB, Convert__GR321_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_GR32, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 4996 /* lcctl */, SystemZ::LCCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5002 /* lcdbr */, SystemZ::LCDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5008 /* lcdfr */, SystemZ::LCDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5014 /* lcdr */, SystemZ::LCDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5019 /* lcebr */, SystemZ::LCEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5025 /* lcer */, SystemZ::LCER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5030 /* lcgfr */, SystemZ::LCGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5036 /* lcgr */, SystemZ::LCGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5041 /* lcr */, SystemZ::LCR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5045 /* lctl */, SystemZ::LCTL, Convert__CR641_0__CR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp12 }, },
  { 5050 /* lctlg */, SystemZ::LCTLG, Convert__CR641_0__CR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp20 }, },
  { 5056 /* lcxbr */, SystemZ::LCXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5062 /* lcxr */, SystemZ::LCXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5067 /* ld */, SystemZ::LD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5070 /* lde */, SystemZ::LDE, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5074 /* ldeb */, SystemZ::LDEB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5079 /* ldebr */, SystemZ::LDEBR, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 5085 /* lder */, SystemZ::LDER, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 5090 /* ldetr */, SystemZ::LDETR, Convert__FP641_0__FP321_1__U4Imm1_2, AMFBS_None, { MCK_FP64, MCK_FP32, MCK_U4Imm }, },
  { 5096 /* ldgr */, SystemZ::LDGR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 5101 /* ldr */, SystemZ::LDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5105 /* ldrv */, SystemZ::VLLEBRZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 5110 /* ldxbr */, SystemZ::LDXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5116 /* ldxbra */, SystemZ::LDXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5123 /* ldxr */, SystemZ::LDXR, Convert__FP641_0__FP1281_1, AMFBS_None, { MCK_FP64, MCK_FP128 }, },
  { 5128 /* ldxtr */, SystemZ::LDXTR, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5134 /* ldy */, SystemZ::LDY, Convert__FP641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp20 }, },
  { 5138 /* le */, SystemZ::LE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 5141 /* ledbr */, SystemZ::LEDBR, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 5147 /* ledbra */, SystemZ::LEDBRA, Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 5154 /* ledr */, SystemZ::LEDR, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 5159 /* ledtr */, SystemZ::LEDTR, Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 5165 /* ler */, SystemZ::LER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5169 /* lerv */, SystemZ::VLLEBRZE, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 5174 /* lexbr */, SystemZ::LEXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5180 /* lexbra */, SystemZ::LEXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5187 /* lexr */, SystemZ::LEXR, Convert__FP321_0__FP1281_1, AMFBS_None, { MCK_FP32, MCK_FP128 }, },
  { 5192 /* ley */, SystemZ::LEY, Convert__FP321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp20 }, },
  { 5196 /* lfas */, SystemZ::LFAS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5201 /* lfh */, SystemZ::LFH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5205 /* lfhat */, SystemZ::LFHAT, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5211 /* lfi */, SystemZ::IILF, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 5215 /* lfpc */, SystemZ::LFPC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5220 /* lg */, SystemZ::LG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5223 /* lgat */, SystemZ::LGAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5228 /* lgb */, SystemZ::LGB, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5232 /* lgbr */, SystemZ::LGBR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5237 /* lgdr */, SystemZ::LGDR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 5242 /* lgf */, SystemZ::LGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5246 /* lgfi */, SystemZ::LGFI, Convert__GR641_0__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 5251 /* lgfr */, SystemZ::LGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5256 /* lgfrl */, SystemZ::LGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5262 /* lgg */, SystemZ::LGG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5266 /* lgh */, SystemZ::LGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5270 /* lghi */, SystemZ::LGHI, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 5275 /* lghr */, SystemZ::LGHR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5280 /* lghrl */, SystemZ::LGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5286 /* lgr */, SystemZ::LGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5290 /* lgrl */, SystemZ::LGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5295 /* lgsc */, SystemZ::LGSC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5300 /* lh */, SystemZ::LH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 5303 /* lhh */, SystemZ::LHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5307 /* lhi */, SystemZ::LHI, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 5311 /* lhr */, SystemZ::LHR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5315 /* lhrl */, SystemZ::LHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 5320 /* lhy */, SystemZ::LHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5324 /* llc */, SystemZ::LLC, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5328 /* llch */, SystemZ::LLCH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5333 /* llcr */, SystemZ::LLCR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5338 /* llgc */, SystemZ::LLGC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5343 /* llgcr */, SystemZ::LLGCR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5349 /* llgf */, SystemZ::LLGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5354 /* llgfat */, SystemZ::LLGFAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5361 /* llgfi */, SystemZ::LLILF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5367 /* llgfr */, SystemZ::LLGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5373 /* llgfrl */, SystemZ::LLGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5380 /* llgfsg */, SystemZ::LLGFSG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5387 /* llgh */, SystemZ::LLGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5392 /* llghi */, SystemZ::LLILL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5398 /* llghr */, SystemZ::LLGHR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5404 /* llghrl */, SystemZ::LLGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5411 /* llgt */, SystemZ::LLGT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5416 /* llgtat */, SystemZ::LLGTAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5423 /* llgtr */, SystemZ::LLGTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5429 /* llh */, SystemZ::LLH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5433 /* llhh */, SystemZ::LLHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5438 /* llhr */, SystemZ::LLHR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5443 /* llhrl */, SystemZ::LLHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 5449 /* llihf */, SystemZ::LLIHF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5455 /* llihh */, SystemZ::LLIHH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5461 /* llihl */, SystemZ::LLIHL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5467 /* llilf */, SystemZ::LLILF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5473 /* llilh */, SystemZ::LLILH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5479 /* llill */, SystemZ::LLILL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5485 /* llxab */, SystemZ::LLXAB, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5491 /* llxaf */, SystemZ::LLXAF, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5497 /* llxag */, SystemZ::LLXAG, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5503 /* llxah */, SystemZ::LLXAH, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5509 /* llxaq */, SystemZ::LLXAQ, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5515 /* llzrgf */, SystemZ::LLZRGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5522 /* lm */, SystemZ::LM, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 5525 /* lmd */, SystemZ::LMD, Convert__GR641_0__GR641_1__BDAddr64Disp122_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 5529 /* lmg */, SystemZ::LMG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5533 /* lmh */, SystemZ::LMH, Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5537 /* lmy */, SystemZ::LMY, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 5541 /* lndbr */, SystemZ::LNDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5547 /* lndfr */, SystemZ::LNDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5553 /* lndr */, SystemZ::LNDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5558 /* lnebr */, SystemZ::LNEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5564 /* lner */, SystemZ::LNER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5569 /* lngfr */, SystemZ::LNGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5575 /* lngr */, SystemZ::LNGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5580 /* lnr */, SystemZ::LNR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5584 /* lnxbr */, SystemZ::LNXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5590 /* lnxr */, SystemZ::LNXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5595 /* loc */, SystemZ::LOCAsm, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5599 /* loce */, SystemZ::LOCAsmE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 5604 /* locfh */, SystemZ::LOCFHAsm, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5610 /* locfhe */, SystemZ::LOCFHAsmE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5617 /* locfhh */, SystemZ::LOCFHAsmH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5632 /* locfhl */, SystemZ::LOCFHAsmL, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5655 /* locfhm */, SystemZ::LOCFHAsmM, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5662 /* locfhne */, SystemZ::LOCFHAsmNE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5670 /* locfhnh */, SystemZ::LOCFHAsmNH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5687 /* locfhnl */, SystemZ::LOCFHAsmNL, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5713 /* locfhnm */, SystemZ::LOCFHAsmNM, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5721 /* locfhno */, SystemZ::LOCFHAsmNO, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5729 /* locfhnp */, SystemZ::LOCFHAsmNP, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5737 /* locfhnz */, SystemZ::LOCFHAsmNZ, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5745 /* locfho */, SystemZ::LOCFHAsmO, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5752 /* locfhp */, SystemZ::LOCFHAsmP, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5759 /* locfhr */, SystemZ::LOCFHRAsm, Convert__GRH321_0__Tie0_1_1__GRH321_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32, MCK_U4Imm }, },
  { 5766 /* locfhre */, SystemZ::LOCFHRAsmE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5774 /* locfhrh */, SystemZ::LOCFHRAsmH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5791 /* locfhrl */, SystemZ::LOCFHRAsmL, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5817 /* locfhrm */, SystemZ::LOCFHRAsmM, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5825 /* locfhrne */, SystemZ::LOCFHRAsmNE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5834 /* locfhrnh */, SystemZ::LOCFHRAsmNH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5853 /* locfhrnl */, SystemZ::LOCFHRAsmNL, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5882 /* locfhrnm */, SystemZ::LOCFHRAsmNM, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5891 /* locfhrno */, SystemZ::LOCFHRAsmNO, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5900 /* locfhrnp */, SystemZ::LOCFHRAsmNP, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5909 /* locfhrnz */, SystemZ::LOCFHRAsmNZ, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5918 /* locfhro */, SystemZ::LOCFHRAsmO, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5926 /* locfhrp */, SystemZ::LOCFHRAsmP, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5934 /* locfhrz */, SystemZ::LOCFHRAsmZ, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5942 /* locfhz */, SystemZ::LOCFHAsmZ, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5949 /* locg */, SystemZ::LOCGAsm, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5954 /* locge */, SystemZ::LOCGAsmE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5960 /* locgh */, SystemZ::LOCGAsmH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5973 /* locghi */, SystemZ::LOCGHIAsm, Convert__GR641_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm, MCK_U4Imm }, },
  { 5980 /* locghie */, SystemZ::LOCGHIAsmE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 5988 /* locghih */, SystemZ::LOCGHIAsmH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6005 /* locghil */, SystemZ::LOCGHIAsmL, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6031 /* locghim */, SystemZ::LOCGHIAsmM, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6039 /* locghine */, SystemZ::LOCGHIAsmNE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6048 /* locghinh */, SystemZ::LOCGHIAsmNH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6067 /* locghinl */, SystemZ::LOCGHIAsmNL, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6096 /* locghinm */, SystemZ::LOCGHIAsmNM, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6105 /* locghino */, SystemZ::LOCGHIAsmNO, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6114 /* locghinp */, SystemZ::LOCGHIAsmNP, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6123 /* locghinz */, SystemZ::LOCGHIAsmNZ, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6132 /* locghio */, SystemZ::LOCGHIAsmO, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6140 /* locghip */, SystemZ::LOCGHIAsmP, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6148 /* locghiz */, SystemZ::LOCGHIAsmZ, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6156 /* locgl */, SystemZ::LOCGAsmL, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6176 /* locgm */, SystemZ::LOCGAsmM, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6182 /* locgne */, SystemZ::LOCGAsmNE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6189 /* locgnh */, SystemZ::LOCGAsmNH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6204 /* locgnl */, SystemZ::LOCGAsmNL, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6227 /* locgnm */, SystemZ::LOCGAsmNM, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6234 /* locgno */, SystemZ::LOCGAsmNO, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6241 /* locgnp */, SystemZ::LOCGAsmNP, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6248 /* locgnz */, SystemZ::LOCGAsmNZ, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6255 /* locgo */, SystemZ::LOCGAsmO, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6261 /* locgp */, SystemZ::LOCGAsmP, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6267 /* locgr */, SystemZ::LOCGRAsm, Convert__GR641_0__Tie0_1_1__GR641_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 6273 /* locgre */, SystemZ::LOCGRAsmE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6280 /* locgrh */, SystemZ::LOCGRAsmH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6295 /* locgrl */, SystemZ::LOCGRAsmL, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6318 /* locgrm */, SystemZ::LOCGRAsmM, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6325 /* locgrne */, SystemZ::LOCGRAsmNE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6333 /* locgrnh */, SystemZ::LOCGRAsmNH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6350 /* locgrnl */, SystemZ::LOCGRAsmNL, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6376 /* locgrnm */, SystemZ::LOCGRAsmNM, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6384 /* locgrno */, SystemZ::LOCGRAsmNO, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6392 /* locgrnp */, SystemZ::LOCGRAsmNP, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6400 /* locgrnz */, SystemZ::LOCGRAsmNZ, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6408 /* locgro */, SystemZ::LOCGRAsmO, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6415 /* locgrp */, SystemZ::LOCGRAsmP, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6422 /* locgrz */, SystemZ::LOCGRAsmZ, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6429 /* locgz */, SystemZ::LOCGAsmZ, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6435 /* loch */, SystemZ::LOCAsmH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6446 /* lochhi */, SystemZ::LOCHHIAsm, Convert__GRH321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm, MCK_U4Imm }, },
  { 6453 /* lochhie */, SystemZ::LOCHHIAsmE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6461 /* lochhih */, SystemZ::LOCHHIAsmH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6478 /* lochhil */, SystemZ::LOCHHIAsmL, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6504 /* lochhim */, SystemZ::LOCHHIAsmM, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6512 /* lochhine */, SystemZ::LOCHHIAsmNE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6521 /* lochhinh */, SystemZ::LOCHHIAsmNH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6540 /* lochhinl */, SystemZ::LOCHHIAsmNL, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6569 /* lochhinm */, SystemZ::LOCHHIAsmNM, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6578 /* lochhino */, SystemZ::LOCHHIAsmNO, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6587 /* lochhinp */, SystemZ::LOCHHIAsmNP, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6596 /* lochhinz */, SystemZ::LOCHHIAsmNZ, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6605 /* lochhio */, SystemZ::LOCHHIAsmO, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6613 /* lochhip */, SystemZ::LOCHHIAsmP, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6621 /* lochhiz */, SystemZ::LOCHHIAsmZ, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6629 /* lochi */, SystemZ::LOCHIAsm, Convert__GR321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm, MCK_U4Imm }, },
  { 6635 /* lochie */, SystemZ::LOCHIAsmE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6642 /* lochih */, SystemZ::LOCHIAsmH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6657 /* lochil */, SystemZ::LOCHIAsmL, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6680 /* lochim */, SystemZ::LOCHIAsmM, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6687 /* lochine */, SystemZ::LOCHIAsmNE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6695 /* lochinh */, SystemZ::LOCHIAsmNH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6712 /* lochinl */, SystemZ::LOCHIAsmNL, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6738 /* lochinm */, SystemZ::LOCHIAsmNM, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6746 /* lochino */, SystemZ::LOCHIAsmNO, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6754 /* lochinp */, SystemZ::LOCHIAsmNP, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6762 /* lochinz */, SystemZ::LOCHIAsmNZ, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6770 /* lochio */, SystemZ::LOCHIAsmO, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6777 /* lochip */, SystemZ::LOCHIAsmP, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6784 /* lochiz */, SystemZ::LOCHIAsmZ, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6791 /* locl */, SystemZ::LOCAsmL, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6808 /* locm */, SystemZ::LOCAsmM, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6813 /* locne */, SystemZ::LOCAsmNE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6819 /* locnh */, SystemZ::LOCAsmNH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6832 /* locnl */, SystemZ::LOCAsmNL, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6852 /* locnm */, SystemZ::LOCAsmNM, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6858 /* locno */, SystemZ::LOCAsmNO, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6864 /* locnp */, SystemZ::LOCAsmNP, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6870 /* locnz */, SystemZ::LOCAsmNZ, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6876 /* loco */, SystemZ::LOCAsmO, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6881 /* locp */, SystemZ::LOCAsmP, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6886 /* locr */, SystemZ::LOCRAsm, Convert__GR321_0__Tie0_1_1__GR321_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 6891 /* locre */, SystemZ::LOCRAsmE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6897 /* locrh */, SystemZ::LOCRAsmH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6910 /* locrl */, SystemZ::LOCRAsmL, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6930 /* locrm */, SystemZ::LOCRAsmM, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6936 /* locrne */, SystemZ::LOCRAsmNE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6943 /* locrnh */, SystemZ::LOCRAsmNH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6958 /* locrnl */, SystemZ::LOCRAsmNL, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6981 /* locrnm */, SystemZ::LOCRAsmNM, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6988 /* locrno */, SystemZ::LOCRAsmNO, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6995 /* locrnp */, SystemZ::LOCRAsmNP, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7002 /* locrnz */, SystemZ::LOCRAsmNZ, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7009 /* locro */, SystemZ::LOCRAsmO, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7015 /* locrp */, SystemZ::LOCRAsmP, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7021 /* locrz */, SystemZ::LOCRAsmZ, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7027 /* locz */, SystemZ::LOCAsmZ, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 7032 /* lpctl */, SystemZ::LPCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7038 /* lpd */, SystemZ::LPD, Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR128, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7042 /* lpdbr */, SystemZ::LPDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7048 /* lpdfr */, SystemZ::LPDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7054 /* lpdg */, SystemZ::LPDG, Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR128, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7059 /* lpdr */, SystemZ::LPDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7064 /* lpebr */, SystemZ::LPEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7070 /* lper */, SystemZ::LPER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7075 /* lpgfr */, SystemZ::LPGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7081 /* lpgr */, SystemZ::LPGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7086 /* lpp */, SystemZ::LPP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7090 /* lpq */, SystemZ::LPQ, Convert__GR1281_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7094 /* lpr */, SystemZ::LPR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7098 /* lpsw */, SystemZ::LPSW, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7103 /* lpswe */, SystemZ::LPSWE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7109 /* lpswey */, SystemZ::LPSWEY, Convert__BDAddr64Disp202_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp20 }, },
  { 7116 /* lptea */, SystemZ::LPTEA, Convert__GR641_0__GR641_1__Tie0_1_1__GR641_2__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 7122 /* lpxbr */, SystemZ::LPXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7128 /* lpxr */, SystemZ::LPXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7133 /* lr */, SystemZ::LR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7136 /* lra */, SystemZ::LRA, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 7140 /* lrag */, SystemZ::LRAG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7145 /* lray */, SystemZ::LRAY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7150 /* lrdr */, SystemZ::LRDR, Convert__FP641_0__FP1281_1, AMFBS_None, { MCK_FP64, MCK_FP128 }, },
  { 7155 /* lrer */, SystemZ::LRER, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 7160 /* lrl */, SystemZ::LRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 7164 /* lrv */, SystemZ::LRV, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7168 /* lrvg */, SystemZ::LRVG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7173 /* lrvgr */, SystemZ::LRVGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7179 /* lrvh */, SystemZ::LRVH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7184 /* lrvr */, SystemZ::LRVR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7189 /* lsctl */, SystemZ::LSCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7195 /* lt */, SystemZ::LT, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7198 /* ltdbr */, SystemZ::LTDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7204 /* ltdr */, SystemZ::LTDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7209 /* ltdtr */, SystemZ::LTDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7215 /* ltebr */, SystemZ::LTEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7221 /* lter */, SystemZ::LTER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7226 /* ltg */, SystemZ::LTG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7230 /* ltgf */, SystemZ::LTGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7235 /* ltgfr */, SystemZ::LTGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7241 /* ltgr */, SystemZ::LTGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7246 /* ltr */, SystemZ::LTR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7250 /* ltxbr */, SystemZ::LTXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7256 /* ltxr */, SystemZ::LTXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7261 /* ltxtr */, SystemZ::LTXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7267 /* lura */, SystemZ::LURA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 7272 /* lurag */, SystemZ::LURAG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7278 /* lxab */, SystemZ::LXAB, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7283 /* lxaf */, SystemZ::LXAF, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7288 /* lxag */, SystemZ::LXAG, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7293 /* lxah */, SystemZ::LXAH, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7298 /* lxaq */, SystemZ::LXAQ, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7303 /* lxd */, SystemZ::LXD, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7307 /* lxdb */, SystemZ::LXDB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7312 /* lxdbr */, SystemZ::LXDBR, Convert__FP1281_0__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7318 /* lxdr */, SystemZ::LXDR, Convert__FP1281_0__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7323 /* lxdtr */, SystemZ::LXDTR, Convert__FP1281_0__FP641_1__U4Imm1_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_U4Imm }, },
  { 7329 /* lxe */, SystemZ::LXE, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7333 /* lxeb */, SystemZ::LXEB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7338 /* lxebr */, SystemZ::LXEBR, Convert__FP1281_0__FP321_1, AMFBS_None, { MCK_FP128, MCK_FP32 }, },
  { 7344 /* lxer */, SystemZ::LXER, Convert__FP1281_0__FP321_1, AMFBS_None, { MCK_FP128, MCK_FP32 }, },
  { 7349 /* lxr */, SystemZ::LXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7353 /* ly */, SystemZ::LY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7356 /* lzdr */, SystemZ::LZDR, Convert__FP641_0, AMFBS_None, { MCK_FP64 }, },
  { 7361 /* lzer */, SystemZ::LZER, Convert__FP321_0, AMFBS_None, { MCK_FP32 }, },
  { 7366 /* lzrf */, SystemZ::LZRF, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7371 /* lzrg */, SystemZ::LZRG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7376 /* lzxr */, SystemZ::LZXR, Convert__FP1281_0, AMFBS_None, { MCK_FP128 }, },
  { 7381 /* m */, SystemZ::M, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp12 }, },
  { 7383 /* mad */, SystemZ::MAD, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7387 /* madb */, SystemZ::MADB, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7392 /* madbr */, SystemZ::MADBR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7398 /* madr */, SystemZ::MADR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7403 /* mae */, SystemZ::MAE, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7407 /* maeb */, SystemZ::MAEB, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7412 /* maebr */, SystemZ::MAEBR, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7418 /* maer */, SystemZ::MAER, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7423 /* may */, SystemZ::MAY, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7427 /* mayh */, SystemZ::MAYH, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7432 /* mayhr */, SystemZ::MAYHR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7438 /* mayl */, SystemZ::MAYL, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7443 /* maylr */, SystemZ::MAYLR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7449 /* mayr */, SystemZ::MAYR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7454 /* mc */, SystemZ::MC, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7457 /* md */, SystemZ::MD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7460 /* mdb */, SystemZ::MDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7464 /* mdbr */, SystemZ::MDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7469 /* mde */, SystemZ::MDE, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7473 /* mdeb */, SystemZ::MDEB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7478 /* mdebr */, SystemZ::MDEBR, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7484 /* mder */, SystemZ::MDER, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7489 /* mdr */, SystemZ::MDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7493 /* mdtr */, SystemZ::MDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7498 /* mdtra */, SystemZ::MDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 7504 /* me */, SystemZ::ME, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7507 /* mee */, SystemZ::MEE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7511 /* meeb */, SystemZ::MEEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7516 /* meebr */, SystemZ::MEEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7522 /* meer */, SystemZ::MEER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7527 /* mer */, SystemZ::MER, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7531 /* mfy */, SystemZ::MFY, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7535 /* mg */, SystemZ::MG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7538 /* mgh */, SystemZ::MGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7542 /* mghi */, SystemZ::MGHI, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 7547 /* mgrk */, SystemZ::MGRK, Convert__GR1281_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR128, MCK_GR64, MCK_GR64 }, },
  { 7552 /* mh */, SystemZ::MH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7555 /* mhi */, SystemZ::MHI, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 7559 /* mhy */, SystemZ::MHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7563 /* ml */, SystemZ::ML, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7566 /* mlg */, SystemZ::MLG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7570 /* mlgr */, SystemZ::MLGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 7575 /* mlr */, SystemZ::MLR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 7579 /* mp */, SystemZ::MP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 7582 /* mr */, SystemZ::MR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 7585 /* ms */, SystemZ::MS, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7588 /* msc */, SystemZ::MSC, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7592 /* msch */, SystemZ::MSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7597 /* msd */, SystemZ::MSD, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7601 /* msdb */, SystemZ::MSDB, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7606 /* msdbr */, SystemZ::MSDBR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7612 /* msdr */, SystemZ::MSDR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7617 /* mse */, SystemZ::MSE, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7621 /* mseb */, SystemZ::MSEB, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7626 /* msebr */, SystemZ::MSEBR, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7632 /* mser */, SystemZ::MSER, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7637 /* msfi */, SystemZ::MSFI, Convert__GR321_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 7642 /* msg */, SystemZ::MSG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7646 /* msgc */, SystemZ::MSGC, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7651 /* msgf */, SystemZ::MSGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7656 /* msgfi */, SystemZ::MSGFI, Convert__GR641_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 7662 /* msgfr */, SystemZ::MSGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7668 /* msgr */, SystemZ::MSGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7673 /* msgrkc */, SystemZ::MSGRKC, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7680 /* msr */, SystemZ::MSR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7684 /* msrkc */, SystemZ::MSRKC, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7690 /* msta */, SystemZ::MSTA, Convert__GR1281_0, AMFBS_None, { MCK_GR128 }, },
  { 7695 /* msy */, SystemZ::MSY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7699 /* mvc */, SystemZ::MVC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7703 /* mvcdk */, SystemZ::MVCDK, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7709 /* mvcin */, SystemZ::MVCIN, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7715 /* mvck */, SystemZ::MVCK, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7720 /* mvcl */, SystemZ::MVCL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 7725 /* mvcle */, SystemZ::MVCLE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 7731 /* mvclu */, SystemZ::MVCLU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp20 }, },
  { 7737 /* mvcos */, SystemZ::MVCOS, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7743 /* mvcp */, SystemZ::MVCP, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7748 /* mvcrl */, SystemZ::MVCRL, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7754 /* mvcs */, SystemZ::MVCS, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7759 /* mvcsk */, SystemZ::MVCSK, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7765 /* mvghi */, SystemZ::MVGHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7771 /* mvhhi */, SystemZ::MVHHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7777 /* mvhi */, SystemZ::MVHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7782 /* mvi */, SystemZ::MVI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7786 /* mviy */, SystemZ::MVIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 7791 /* mvn */, SystemZ::MVN, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7795 /* mvo */, SystemZ::MVO, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 7799 /* mvpg */, SystemZ::MVPG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7804 /* mvst */, SystemZ::MVST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7809 /* mvz */, SystemZ::MVZ, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7813 /* mxbr */, SystemZ::MXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7818 /* mxd */, SystemZ::MXD, Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7822 /* mxdb */, SystemZ::MXDB, Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7827 /* mxdbr */, SystemZ::MXDBR, Convert__FP1281_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7833 /* mxdr */, SystemZ::MXDR, Convert__FP1281_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7838 /* mxr */, SystemZ::MXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7842 /* mxtr */, SystemZ::MXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 7847 /* mxtra */, SystemZ::MXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 7853 /* my */, SystemZ::MY, Convert__FP1281_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7856 /* myh */, SystemZ::MYH, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7860 /* myhr */, SystemZ::MYHR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7865 /* myl */, SystemZ::MYL, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7869 /* mylr */, SystemZ::MYLR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7874 /* myr */, SystemZ::MYR, Convert__FP1281_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_FP64 }, },
  { 7878 /* n */, SystemZ::N, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7880 /* nc */, SystemZ::NC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7883 /* ncgrk */, SystemZ::NCGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7889 /* ncrk */, SystemZ::NCRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7894 /* ng */, SystemZ::NG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7897 /* ngr */, SystemZ::NGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7901 /* ngrk */, SystemZ::NGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7906 /* ni */, SystemZ::NI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7909 /* niai */, SystemZ::NIAI, Convert__U4Imm1_0__U4Imm1_1, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_U4Imm }, },
  { 7914 /* nihf */, SystemZ::NIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 7919 /* nihh */, SystemZ::NIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 7924 /* nihl */, SystemZ::NIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 7929 /* nilf */, SystemZ::NILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 7934 /* nilh */, SystemZ::NILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 7939 /* nill */, SystemZ::NILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 7944 /* niy */, SystemZ::NIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 7948 /* nngrk */, SystemZ::NNGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7954 /* nnpa */, SystemZ::NNPA, Convert_NoOperands, AMFBS_FeatureNNPAssist, {  }, },
  { 7959 /* nnrk */, SystemZ::NNRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7964 /* nogrk */, SystemZ::NOGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7970 /* nop */, SystemZ::NOPOpt, Convert_NoOperands, AMFBS_None, {  }, },
  { 7970 /* nop */, SystemZ::NOP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 7974 /* nopr */, SystemZ::NOPROpt, Convert_NoOperands, AMFBS_None, {  }, },
  { 7974 /* nopr */, SystemZ::NOPR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 7979 /* nork */, SystemZ::NORK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7984 /* notgr */, SystemZ::NOTGR, Convert__GR641_0__GR641_1__imm_95_0, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64 }, },
  { 7990 /* notr */, SystemZ::NOTR, Convert__GR321_0__GR321_1__imm_95_0, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32 }, },
  { 7995 /* nr */, SystemZ::NR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7998 /* nrk */, SystemZ::NRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8002 /* ntstg */, SystemZ::NTSTG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureTransactionalExecution, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8008 /* nxgrk */, SystemZ::NXGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8014 /* nxrk */, SystemZ::NXRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8019 /* ny */, SystemZ::NY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8022 /* o */, SystemZ::O, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8024 /* oc */, SystemZ::OC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 8027 /* ocgrk */, SystemZ::OCGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8033 /* ocrk */, SystemZ::OCRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8038 /* og */, SystemZ::OG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8041 /* ogr */, SystemZ::OGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8045 /* ogrk */, SystemZ::OGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8050 /* oi */, SystemZ::OI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 8053 /* oihf */, SystemZ::OIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 8058 /* oihh */, SystemZ::OIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 8063 /* oihl */, SystemZ::OIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 8068 /* oilf */, SystemZ::OILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 8073 /* oilh */, SystemZ::OILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 8078 /* oill */, SystemZ::OILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 8083 /* oiy */, SystemZ::OIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 8087 /* or */, SystemZ::OR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 8090 /* ork */, SystemZ::ORK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8094 /* oy */, SystemZ::OY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8097 /* pack */, SystemZ::PACK, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 8102 /* palb */, SystemZ::PALB, Convert_NoOperands, AMFBS_None, {  }, },
  { 8107 /* pc */, SystemZ::PC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8110 /* pcc */, SystemZ::PCC, Convert_NoOperands, AMFBS_FeatureMessageSecurityAssist4, {  }, },
  { 8114 /* pckmo */, SystemZ::PCKMO, Convert_NoOperands, AMFBS_FeatureMessageSecurityAssist3, {  }, },
  { 8120 /* pfcr */, SystemZ::PFCR, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 8125 /* pfd */, SystemZ::PFD, Convert__U4Imm1_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_U4Imm, MCK_BDXAddr64Disp20 }, },
  { 8129 /* pfdrl */, SystemZ::PFDRL, Convert__U4Imm1_0__PCRel321_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel32 }, },
  { 8135 /* pfmf */, SystemZ::PFMF, Convert__GR641_1__GR321_0__Tie0_1_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8140 /* pfpo */, SystemZ::PFPO, Convert_NoOperands, AMFBS_None, {  }, },
  { 8145 /* pgin */, SystemZ::PGIN, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8150 /* pgout */, SystemZ::PGOUT, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8156 /* pka */, SystemZ::PKA, Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDLAddr64Disp12Len8 }, },
  { 8160 /* pku */, SystemZ::PKU, Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDLAddr64Disp12Len8 }, },
  { 8164 /* plo */, SystemZ::PLO, Convert__GR641_0__BDAddr64Disp122_1__GR641_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_BDAddr64Disp12, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 8168 /* popcnt */, SystemZ::POPCNT, Convert__GR641_0__GR641_1, AMFBS_FeaturePopulationCount, { MCK_GR64, MCK_GR64 }, },
  { 8168 /* popcnt */, SystemZ::POPCNTOpt, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8175 /* ppa */, SystemZ::PPA, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_FeatureProcessorAssist, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8179 /* ppno */, SystemZ::PPNO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist5, { MCK_GR128, MCK_GR128 }, },
  { 8184 /* pr */, SystemZ::PR, Convert_NoOperands, AMFBS_None, {  }, },
  { 8187 /* prno */, SystemZ::PRNO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist7, { MCK_GR128, MCK_GR128 }, },
  { 8192 /* pt */, SystemZ::PT, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8195 /* ptf */, SystemZ::PTF, Convert__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 8199 /* ptff */, SystemZ::PTFF, Convert_NoOperands, AMFBS_None, {  }, },
  { 8204 /* pti */, SystemZ::PTI, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8208 /* ptlb */, SystemZ::PTLB, Convert_NoOperands, AMFBS_None, {  }, },
  { 8213 /* qadtr */, SystemZ::QADTR, Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 8219 /* qaxtr */, SystemZ::QAXTR, Convert__FP1281_0__FP1281_1__Tie0_1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 8225 /* qctri */, SystemZ::QCTRI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8231 /* qpaci */, SystemZ::QPACI, Convert__BDAddr64Disp122_0, AMFBS_FeatureProcessorActivityInstrumentation, { MCK_BDAddr64Disp12 }, },
  { 8237 /* qsi */, SystemZ::QSI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8241 /* rchp */, SystemZ::RCHP, Convert_NoOperands, AMFBS_None, {  }, },
  { 8246 /* rdp */, SystemZ::RDPOpt, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureResetDATProtection, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8246 /* rdp */, SystemZ::RDP, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_FeatureResetDATProtection, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8250 /* risbg */, SystemZ::RISBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8256 /* risbgn */, SystemZ::RISBGN, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8263 /* risbgnz */, SystemZ::RISBGNZ, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8271 /* risbgz */, SystemZ::RISBGZ, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8278 /* risbhg */, SystemZ::RISBHG, Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8285 /* risblg */, SystemZ::RISBLG, Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureHighWord, { MCK_GR32, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8292 /* rll */, SystemZ::RLL, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 8296 /* rllg */, SystemZ::RLLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 8301 /* rnsbg */, SystemZ::RNSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8307 /* rosbg */, SystemZ::ROSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8313 /* rp */, SystemZ::RP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8316 /* rrbe */, SystemZ::RRBE, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8321 /* rrbm */, SystemZ::RRBM, Convert__GR641_0__GR641_1, AMFBS_FeatureResetReferenceBitsMultiple, { MCK_GR64, MCK_GR64 }, },
  { 8326 /* rrdtr */, SystemZ::RRDTR, Convert__FP641_0__FP641_1__Tie0_1_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_GR32, MCK_U4Imm }, },
  { 8332 /* rrxtr */, SystemZ::RRXTR, Convert__FP1281_0__FP1281_1__Tie0_1_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_GR32, MCK_U4Imm }, },
  { 8338 /* rsch */, SystemZ::RSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 8343 /* rxsbg */, SystemZ::RXSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8349 /* s */, SystemZ::S, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8351 /* sac */, SystemZ::SAC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8355 /* sacf */, SystemZ::SACF, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8360 /* sal */, SystemZ::SAL, Convert_NoOperands, AMFBS_None, {  }, },
  { 8364 /* sam24 */, SystemZ::SAM24, Convert_NoOperands, AMFBS_None, {  }, },
  { 8370 /* sam31 */, SystemZ::SAM31, Convert_NoOperands, AMFBS_None, {  }, },
  { 8376 /* sam64 */, SystemZ::SAM64, Convert_NoOperands, AMFBS_None, {  }, },
  { 8382 /* sar */, SystemZ::SAR, Convert__AR321_0__GR321_1, AMFBS_None, { MCK_AR32, MCK_GR32 }, },
  { 8386 /* scctr */, SystemZ::SCCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8392 /* schm */, SystemZ::SCHM, Convert_NoOperands, AMFBS_None, {  }, },
  { 8397 /* sck */, SystemZ::SCK, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8401 /* sckc */, SystemZ::SCKC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8406 /* sckpf */, SystemZ::SCKPF, Convert_NoOperands, AMFBS_None, {  }, },
  { 8412 /* sd */, SystemZ::SD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 8415 /* sdb */, SystemZ::SDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 8419 /* sdbr */, SystemZ::SDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 8424 /* sdr */, SystemZ::SDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 8428 /* sdtr */, SystemZ::SDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 8433 /* sdtra */, SystemZ::SDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 8439 /* se */, SystemZ::SE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 8442 /* seb */, SystemZ::SEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 8446 /* sebr */, SystemZ::SEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 8451 /* selfhr */, SystemZ::SELFHRAsm, Convert__GRH321_0__GRH321_2__GRH321_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32, MCK_U4Imm }, },
  { 8458 /* selfhre */, SystemZ::SELFHRAsmE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8466 /* selfhrh */, SystemZ::SELFHRAsmH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8483 /* selfhrl */, SystemZ::SELFHRAsmL, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8509 /* selfhrm */, SystemZ::SELFHRAsmM, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8517 /* selfhrne */, SystemZ::SELFHRAsmNE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8526 /* selfhrnh */, SystemZ::SELFHRAsmNH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8545 /* selfhrnl */, SystemZ::SELFHRAsmNL, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8574 /* selfhrnm */, SystemZ::SELFHRAsmNM, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8583 /* selfhrno */, SystemZ::SELFHRAsmNO, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8592 /* selfhrnp */, SystemZ::SELFHRAsmNP, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8601 /* selfhrnz */, SystemZ::SELFHRAsmNZ, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8610 /* selfhro */, SystemZ::SELFHRAsmO, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8618 /* selfhrp */, SystemZ::SELFHRAsmP, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8626 /* selfhrz */, SystemZ::SELFHRAsmZ, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8634 /* selgr */, SystemZ::SELGRAsm, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8640 /* selgre */, SystemZ::SELGRAsmE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8647 /* selgrh */, SystemZ::SELGRAsmH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8662 /* selgrl */, SystemZ::SELGRAsmL, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8685 /* selgrm */, SystemZ::SELGRAsmM, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8692 /* selgrne */, SystemZ::SELGRAsmNE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8700 /* selgrnh */, SystemZ::SELGRAsmNH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8717 /* selgrnl */, SystemZ::SELGRAsmNL, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8743 /* selgrnm */, SystemZ::SELGRAsmNM, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8751 /* selgrno */, SystemZ::SELGRAsmNO, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8759 /* selgrnp */, SystemZ::SELGRAsmNP, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8767 /* selgrnz */, SystemZ::SELGRAsmNZ, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8775 /* selgro */, SystemZ::SELGRAsmO, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8782 /* selgrp */, SystemZ::SELGRAsmP, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8789 /* selgrz */, SystemZ::SELGRAsmZ, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8796 /* selr */, SystemZ::SELRAsm, Convert__GR321_0__GR321_2__GR321_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 8801 /* selre */, SystemZ::SELRAsmE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8807 /* selrh */, SystemZ::SELRAsmH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8820 /* selrl */, SystemZ::SELRAsmL, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8840 /* selrm */, SystemZ::SELRAsmM, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8846 /* selrne */, SystemZ::SELRAsmNE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8853 /* selrnh */, SystemZ::SELRAsmNH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8868 /* selrnl */, SystemZ::SELRAsmNL, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8891 /* selrnm */, SystemZ::SELRAsmNM, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8898 /* selrno */, SystemZ::SELRAsmNO, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8905 /* selrnp */, SystemZ::SELRAsmNP, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8912 /* selrnz */, SystemZ::SELRAsmNZ, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8919 /* selro */, SystemZ::SELRAsmO, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8925 /* selrp */, SystemZ::SELRAsmP, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8931 /* selrz */, SystemZ::SELRAsmZ, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8937 /* ser */, SystemZ::SER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 8941 /* sfasr */, SystemZ::SFASR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 8947 /* sfpc */, SystemZ::SFPC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 8952 /* sg */, SystemZ::SG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8955 /* sgf */, SystemZ::SGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8959 /* sgfr */, SystemZ::SGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 8964 /* sgh */, SystemZ::SGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8968 /* sgr */, SystemZ::SGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8972 /* sgrk */, SystemZ::SGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8977 /* sh */, SystemZ::SH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8980 /* shhhr */, SystemZ::SHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8986 /* shhlr */, SystemZ::SHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 8992 /* shy */, SystemZ::SHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8996 /* sie */, SystemZ::SIE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9000 /* siga */, SystemZ::SIGA, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9005 /* sigp */, SystemZ::SIGP, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 9010 /* sl */, SystemZ::SL, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9013 /* sla */, SystemZ::SLA, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9017 /* slag */, SystemZ::SLAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9022 /* slak */, SystemZ::SLAK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9027 /* slb */, SystemZ::SLB, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9031 /* slbg */, SystemZ::SLBG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9036 /* slbgr */, SystemZ::SLBGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9042 /* slbr */, SystemZ::SLBR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9047 /* slda */, SystemZ::SLDA, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9052 /* sldl */, SystemZ::SLDL, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9057 /* sldt */, SystemZ::SLDT, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9062 /* slfi */, SystemZ::SLFI, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 9067 /* slg */, SystemZ::SLG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9071 /* slgf */, SystemZ::SLGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9076 /* slgfi */, SystemZ::SLGFI, Convert__GR641_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 9082 /* slgfr */, SystemZ::SLGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 9088 /* slgr */, SystemZ::SLGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9093 /* slgrk */, SystemZ::SLGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 9099 /* slhhhr */, SystemZ::SLHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 9106 /* slhhlr */, SystemZ::SLHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 9113 /* sll */, SystemZ::SLL, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9117 /* sllg */, SystemZ::SLLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9122 /* sllk */, SystemZ::SLLK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9127 /* slr */, SystemZ::SLR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9131 /* slrk */, SystemZ::SLRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 9136 /* slxt */, SystemZ::SLXT, Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 9141 /* sly */, SystemZ::SLY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9145 /* sortl */, SystemZ::SORTL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureEnhancedSort, { MCK_GR128, MCK_GR128 }, },
  { 9151 /* sp */, SystemZ::SP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 9154 /* spctr */, SystemZ::SPCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9160 /* spka */, SystemZ::SPKA, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9165 /* spm */, SystemZ::SPM, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 9169 /* spt */, SystemZ::SPT, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9173 /* spx */, SystemZ::SPX, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9177 /* sqd */, SystemZ::SQD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9181 /* sqdb */, SystemZ::SQDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9186 /* sqdbr */, SystemZ::SQDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 9192 /* sqdr */, SystemZ::SQDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 9197 /* sqe */, SystemZ::SQE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9201 /* sqeb */, SystemZ::SQEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9206 /* sqebr */, SystemZ::SQEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 9212 /* sqer */, SystemZ::SQER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 9217 /* sqxbr */, SystemZ::SQXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 9223 /* sqxr */, SystemZ::SQXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 9228 /* sr */, SystemZ::SR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9231 /* sra */, SystemZ::SRA, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9235 /* srag */, SystemZ::SRAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9240 /* srak */, SystemZ::SRAK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9245 /* srda */, SystemZ::SRDA, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9250 /* srdl */, SystemZ::SRDL, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9255 /* srdt */, SystemZ::SRDT, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9260 /* srk */, SystemZ::SRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 9264 /* srl */, SystemZ::SRL, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9268 /* srlg */, SystemZ::SRLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9273 /* srlk */, SystemZ::SRLK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9278 /* srnm */, SystemZ::SRNM, Convert__BDAddr32Disp122_0, AMFBS_None, { MCK_BDAddr32Disp12 }, },
  { 9283 /* srnmb */, SystemZ::SRNMB, Convert__BDAddr32Disp122_0, AMFBS_FeatureFPExtension, { MCK_BDAddr32Disp12 }, },
  { 9289 /* srnmt */, SystemZ::SRNMT, Convert__BDAddr32Disp122_0, AMFBS_None, { MCK_BDAddr32Disp12 }, },
  { 9295 /* srp */, SystemZ::SRP, Convert__BDLAddr64Disp12Len43_0__BDAddr32Disp122_1__U4Imm1_2, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 9299 /* srst */, SystemZ::SRST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9304 /* srstu */, SystemZ::SRSTU, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9310 /* srxt */, SystemZ::SRXT, Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 9315 /* ssair */, SystemZ::SSAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 9321 /* ssar */, SystemZ::SSAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 9326 /* ssch */, SystemZ::SSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9331 /* sske */, SystemZ::SSKEOpt, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 9331 /* sske */, SystemZ::SSKE, Convert__GR321_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR64, MCK_U4Imm }, },
  { 9336 /* ssm */, SystemZ::SSM, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9340 /* st */, SystemZ::ST, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9343 /* stam */, SystemZ::STAM, Convert__AR321_0__AR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp12 }, },
  { 9348 /* stamy */, SystemZ::STAMY, Convert__AR321_0__AR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp20 }, },
  { 9354 /* stap */, SystemZ::STAP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9359 /* stbear */, SystemZ::STBEAR, Convert__BDAddr64Disp122_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp12 }, },
  { 9366 /* stc */, SystemZ::STC, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9370 /* stch */, SystemZ::STCH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9375 /* stck */, SystemZ::STCK, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9380 /* stckc */, SystemZ::STCKC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9386 /* stcke */, SystemZ::STCKE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9392 /* stckf */, SystemZ::STCKF, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9398 /* stcm */, SystemZ::STCM, Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 9403 /* stcmh */, SystemZ::STCMH, Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 9409 /* stcmy */, SystemZ::STCMY, Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 9415 /* stcps */, SystemZ::STCPS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9421 /* stcrw */, SystemZ::STCRW, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9427 /* stctg */, SystemZ::STCTG, Convert__CR641_0__CR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp20 }, },
  { 9433 /* stctl */, SystemZ::STCTL, Convert__CR641_0__CR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp12 }, },
  { 9439 /* stcy */, SystemZ::STCY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9444 /* std */, SystemZ::STD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9448 /* stdrv */, SystemZ::VSTEBRG, Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 9454 /* stdy */, SystemZ::STDY, Convert__FP641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp20 }, },
  { 9459 /* ste */, SystemZ::STE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9463 /* sterv */, SystemZ::VSTEBRF, Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 9469 /* stey */, SystemZ::STEY, Convert__FP321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp20 }, },
  { 9474 /* stfh */, SystemZ::STFH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9479 /* stfl */, SystemZ::STFL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9484 /* stfle */, SystemZ::STFLE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9490 /* stfpc */, SystemZ::STFPC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9496 /* stg */, SystemZ::STG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9500 /* stgrl */, SystemZ::STGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 9506 /* stgsc */, SystemZ::STGSC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9512 /* sth */, SystemZ::STH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9516 /* sthh */, SystemZ::STHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9521 /* sthrl */, SystemZ::STHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 9527 /* sthy */, SystemZ::STHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9532 /* stidp */, SystemZ::STIDP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9538 /* stm */, SystemZ::STM, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 9542 /* stmg */, SystemZ::STMG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9547 /* stmh */, SystemZ::STMH, Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9552 /* stmy */, SystemZ::STMY, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9557 /* stnsm */, SystemZ::STNSM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 9563 /* stoc */, SystemZ::STOCAsm, Convert__GR321_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9568 /* stoce */, SystemZ::STOCAsmE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9574 /* stocfh */, SystemZ::STOCFHAsm, Convert__GRH321_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9581 /* stocfhe */, SystemZ::STOCFHAsmE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9589 /* stocfhh */, SystemZ::STOCFHAsmH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9606 /* stocfhl */, SystemZ::STOCFHAsmL, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9632 /* stocfhm */, SystemZ::STOCFHAsmM, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9640 /* stocfhne */, SystemZ::STOCFHAsmNE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9649 /* stocfhnh */, SystemZ::STOCFHAsmNH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9668 /* stocfhnl */, SystemZ::STOCFHAsmNL, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9697 /* stocfhnm */, SystemZ::STOCFHAsmNM, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9706 /* stocfhno */, SystemZ::STOCFHAsmNO, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9715 /* stocfhnp */, SystemZ::STOCFHAsmNP, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9724 /* stocfhnz */, SystemZ::STOCFHAsmNZ, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9733 /* stocfho */, SystemZ::STOCFHAsmO, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9741 /* stocfhp */, SystemZ::STOCFHAsmP, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9749 /* stocfhz */, SystemZ::STOCFHAsmZ, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9757 /* stocg */, SystemZ::STOCGAsm, Convert__GR641_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9763 /* stocge */, SystemZ::STOCGAsmE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9770 /* stocgh */, SystemZ::STOCGAsmH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9785 /* stocgl */, SystemZ::STOCGAsmL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9808 /* stocgm */, SystemZ::STOCGAsmM, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9815 /* stocgne */, SystemZ::STOCGAsmNE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9823 /* stocgnh */, SystemZ::STOCGAsmNH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9840 /* stocgnl */, SystemZ::STOCGAsmNL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9866 /* stocgnm */, SystemZ::STOCGAsmNM, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9874 /* stocgno */, SystemZ::STOCGAsmNO, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9882 /* stocgnp */, SystemZ::STOCGAsmNP, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9890 /* stocgnz */, SystemZ::STOCGAsmNZ, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9898 /* stocgo */, SystemZ::STOCGAsmO, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9905 /* stocgp */, SystemZ::STOCGAsmP, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9912 /* stocgz */, SystemZ::STOCGAsmZ, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9919 /* stoch */, SystemZ::STOCAsmH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9932 /* stocl */, SystemZ::STOCAsmL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9952 /* stocm */, SystemZ::STOCAsmM, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9958 /* stocne */, SystemZ::STOCAsmNE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9965 /* stocnh */, SystemZ::STOCAsmNH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9980 /* stocnl */, SystemZ::STOCAsmNL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10003 /* stocnm */, SystemZ::STOCAsmNM, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10010 /* stocno */, SystemZ::STOCAsmNO, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10017 /* stocnp */, SystemZ::STOCAsmNP, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10024 /* stocnz */, SystemZ::STOCAsmNZ, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10031 /* stoco */, SystemZ::STOCAsmO, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10037 /* stocp */, SystemZ::STOCAsmP, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10043 /* stocz */, SystemZ::STOCAsmZ, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10049 /* stosm */, SystemZ::STOSM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 10055 /* stpq */, SystemZ::STPQ, Convert__GR1281_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 10060 /* stpt */, SystemZ::STPT, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10065 /* stpx */, SystemZ::STPX, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10070 /* strag */, SystemZ::STRAG, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 10076 /* strl */, SystemZ::STRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 10081 /* strv */, SystemZ::STRV, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10086 /* strvg */, SystemZ::STRVG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 10092 /* strvh */, SystemZ::STRVH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10098 /* stsch */, SystemZ::STSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10104 /* stsi */, SystemZ::STSI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10109 /* stura */, SystemZ::STURA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 10115 /* sturg */, SystemZ::STURG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 10121 /* sty */, SystemZ::STY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10125 /* su */, SystemZ::SU, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10128 /* sur */, SystemZ::SUR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 10132 /* svc */, SystemZ::SVC, Convert__U8Imm1_0, AMFBS_None, { MCK_U8Imm }, },
  { 10136 /* sw */, SystemZ::SW, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10139 /* swr */, SystemZ::SWR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 10143 /* sxbr */, SystemZ::SXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 10148 /* sxr */, SystemZ::SXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 10152 /* sxtr */, SystemZ::SXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 10157 /* sxtra */, SystemZ::SXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 10163 /* sy */, SystemZ::SY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10166 /* tabort */, SystemZ::TABORT, Convert__BDAddr64Disp122_0, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12 }, },
  { 10173 /* tam */, SystemZ::TAM, Convert_NoOperands, AMFBS_None, {  }, },
  { 10177 /* tar */, SystemZ::TAR, Convert__AR321_0__GR321_1, AMFBS_None, { MCK_AR32, MCK_GR32 }, },
  { 10181 /* tb */, SystemZ::TB, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 10184 /* tbdr */, SystemZ::TBDR, Convert__FP641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64 }, },
  { 10189 /* tbedr */, SystemZ::TBEDR, Convert__FP321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP64 }, },
  { 10195 /* tbegin */, SystemZ::TBEGIN, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 10202 /* tbeginc */, SystemZ::TBEGINC, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 10210 /* tcdb */, SystemZ::TCDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10215 /* tceb */, SystemZ::TCEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10220 /* tcxb */, SystemZ::TCXB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10225 /* tdcdt */, SystemZ::TDCDT, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10231 /* tdcet */, SystemZ::TDCET, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10237 /* tdcxt */, SystemZ::TDCXT, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10243 /* tdgdt */, SystemZ::TDGDT, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10249 /* tdget */, SystemZ::TDGET, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10255 /* tdgxt */, SystemZ::TDGXT, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10261 /* tend */, SystemZ::TEND, Convert_NoOperands, AMFBS_FeatureTransactionalExecution, {  }, },
  { 10266 /* thder */, SystemZ::THDER, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 10272 /* thdr */, SystemZ::THDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 10277 /* tm */, SystemZ::TM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 10280 /* tmh */, SystemZ::TMLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10284 /* tmhh */, SystemZ::TMHH, Convert__GRH321_0__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 10289 /* tmhl */, SystemZ::TMHL, Convert__GRH321_0__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 10294 /* tml */, SystemZ::TMLL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10298 /* tmlh */, SystemZ::TMLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10303 /* tmll */, SystemZ::TMLL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10308 /* tmy */, SystemZ::TMY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 10312 /* tp */, SystemZ::TP, Convert__BDLAddr64Disp12Len43_0, AMFBS_None, { MCK_BDLAddr64Disp12Len4 }, },
  { 10315 /* tpei */, SystemZ::TPEI, Convert__GR641_0__GR641_1, AMFBS_FeatureTestPendingExternalInterruption, { MCK_GR64, MCK_GR64 }, },
  { 10320 /* tpi */, SystemZ::TPI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10324 /* tprot */, SystemZ::TPROT, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 10330 /* tr */, SystemZ::TR, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10333 /* trace */, SystemZ::TRACE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 10339 /* tracg */, SystemZ::TRACG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 10345 /* trap2 */, SystemZ::TRAP2, Convert_NoOperands, AMFBS_None, {  }, },
  { 10351 /* trap4 */, SystemZ::TRAP4, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10357 /* tre */, SystemZ::TRE, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10361 /* troo */, SystemZ::TROOOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10361 /* troo */, SystemZ::TROO, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10366 /* trot */, SystemZ::TROTOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10366 /* trot */, SystemZ::TROT, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10371 /* trt */, SystemZ::TRT, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10375 /* trte */, SystemZ::TRTEOpt, Convert__GR641_1__GR1281_0__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10375 /* trte */, SystemZ::TRTE, Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10380 /* trto */, SystemZ::TRTOOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10380 /* trto */, SystemZ::TRTO, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10385 /* trtr */, SystemZ::TRTR, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10390 /* trtre */, SystemZ::TRTREOpt, Convert__GR641_1__GR1281_0__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10390 /* trtre */, SystemZ::TRTRE, Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10396 /* trtt */, SystemZ::TRTTOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10396 /* trtt */, SystemZ::TRTT, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10401 /* ts */, SystemZ::TS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10404 /* tsch */, SystemZ::TSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10409 /* unpk */, SystemZ::UNPK, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 10414 /* unpka */, SystemZ::UNPKA, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10420 /* unpku */, SystemZ::UNPKU, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10426 /* upt */, SystemZ::UPT, Convert_NoOperands, AMFBS_None, {  }, },
  { 10430 /* va */, SystemZ::VA, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10433 /* vab */, SystemZ::VAB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10437 /* vac */, SystemZ::VAC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10441 /* vacc */, SystemZ::VACC, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10446 /* vaccb */, SystemZ::VACCB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10452 /* vaccc */, SystemZ::VACCC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10458 /* vacccq */, SystemZ::VACCCQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10465 /* vaccf */, SystemZ::VACCF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10471 /* vaccg */, SystemZ::VACCG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10477 /* vacch */, SystemZ::VACCH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10483 /* vaccq */, SystemZ::VACCQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10489 /* vacq */, SystemZ::VACQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10494 /* vaf */, SystemZ::VAF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10498 /* vag */, SystemZ::VAG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10502 /* vah */, SystemZ::VAH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10506 /* vap */, SystemZ::VAP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 10510 /* vaq */, SystemZ::VAQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10514 /* vavg */, SystemZ::VAVG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10519 /* vavgb */, SystemZ::VAVGB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10525 /* vavgf */, SystemZ::VAVGF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10531 /* vavgg */, SystemZ::VAVGG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10537 /* vavgh */, SystemZ::VAVGH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10543 /* vavgl */, SystemZ::VAVGL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10549 /* vavglb */, SystemZ::VAVGLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10556 /* vavglf */, SystemZ::VAVGLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10563 /* vavglg */, SystemZ::VAVGLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10570 /* vavglh */, SystemZ::VAVGLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10577 /* vavglq */, SystemZ::VAVGLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10584 /* vavgq */, SystemZ::VAVGQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10590 /* vblend */, SystemZ::VBLEND, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10597 /* vblendb */, SystemZ::VBLENDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10605 /* vblendf */, SystemZ::VBLENDF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10613 /* vblendg */, SystemZ::VBLENDG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10621 /* vblendh */, SystemZ::VBLENDH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10629 /* vblendq */, SystemZ::VBLENDQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10637 /* vbperm */, SystemZ::VBPERM, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10644 /* vcdg */, SystemZ::VCDG, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10649 /* vcdgb */, SystemZ::VCDGB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10655 /* vcdlg */, SystemZ::VCDLG, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10661 /* vcdlgb */, SystemZ::VCDLGB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10668 /* vcefb */, SystemZ::VCEFB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10674 /* vcelfb */, SystemZ::VCELFB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10681 /* vceq */, SystemZ::VCEQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10686 /* vceqb */, SystemZ::VCEQB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10692 /* vceqbs */, SystemZ::VCEQBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10699 /* vceqf */, SystemZ::VCEQF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10705 /* vceqfs */, SystemZ::VCEQFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10712 /* vceqg */, SystemZ::VCEQG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10718 /* vceqgs */, SystemZ::VCEQGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10725 /* vceqh */, SystemZ::VCEQH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10731 /* vceqhs */, SystemZ::VCEQHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10738 /* vceqq */, SystemZ::VCEQQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10744 /* vceqqs */, SystemZ::VCEQQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10751 /* vcfeb */, SystemZ::VCFEB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10757 /* vcfn */, SystemZ::VCFN, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10762 /* vcfpl */, SystemZ::VCFPL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10768 /* vcfps */, SystemZ::VCFPS, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10774 /* vcgd */, SystemZ::VCGD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10779 /* vcgdb */, SystemZ::VCGDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10785 /* vch */, SystemZ::VCH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10789 /* vchb */, SystemZ::VCHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10794 /* vchbs */, SystemZ::VCHBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10800 /* vchf */, SystemZ::VCHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10805 /* vchfs */, SystemZ::VCHFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10811 /* vchg */, SystemZ::VCHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10816 /* vchgs */, SystemZ::VCHGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10822 /* vchh */, SystemZ::VCHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10827 /* vchhs */, SystemZ::VCHHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10833 /* vchl */, SystemZ::VCHL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10838 /* vchlb */, SystemZ::VCHLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10844 /* vchlbs */, SystemZ::VCHLBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10851 /* vchlf */, SystemZ::VCHLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10857 /* vchlfs */, SystemZ::VCHLFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10864 /* vchlg */, SystemZ::VCHLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10870 /* vchlgs */, SystemZ::VCHLGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10877 /* vchlh */, SystemZ::VCHLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10883 /* vchlhs */, SystemZ::VCHLHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10890 /* vchlq */, SystemZ::VCHLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10896 /* vchlqs */, SystemZ::VCHLQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10903 /* vchq */, SystemZ::VCHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10908 /* vchqs */, SystemZ::VCHQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10914 /* vcksm */, SystemZ::VCKSM, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10920 /* vclfeb */, SystemZ::VCLFEB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10927 /* vclfnh */, SystemZ::VCLFNH, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10934 /* vclfnl */, SystemZ::VCLFNL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10941 /* vclfp */, SystemZ::VCLFP, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10947 /* vclgd */, SystemZ::VCLGD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10953 /* vclgdb */, SystemZ::VCLGDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10960 /* vclz */, SystemZ::VCLZ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10965 /* vclzb */, SystemZ::VCLZB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10971 /* vclzdp */, SystemZ::VCLZDP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10978 /* vclzf */, SystemZ::VCLZF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10984 /* vclzg */, SystemZ::VCLZG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10990 /* vclzh */, SystemZ::VCLZH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10996 /* vclzq */, SystemZ::VCLZQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11002 /* vcnf */, SystemZ::VCNF, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11007 /* vcp */, SystemZ::VCP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11011 /* vcrnf */, SystemZ::VCRNF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11017 /* vcsfp */, SystemZ::VCSFP, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11023 /* vcsph */, SystemZ::VCSPH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11029 /* vctz */, SystemZ::VCTZ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11034 /* vctzb */, SystemZ::VCTZB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11040 /* vctzf */, SystemZ::VCTZF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11046 /* vctzg */, SystemZ::VCTZG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11052 /* vctzh */, SystemZ::VCTZH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11058 /* vctzq */, SystemZ::VCTZQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11064 /* vcvb */, SystemZ::VCVB, Convert__GR321_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_GR32, MCK_VR128, MCK_U4Imm }, },
  { 11064 /* vcvb */, SystemZ::VCVBOpt, Convert__GR321_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement, { MCK_GR32, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11069 /* vcvbg */, SystemZ::VCVBG, Convert__GR641_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_GR64, MCK_VR128, MCK_U4Imm }, },
  { 11069 /* vcvbg */, SystemZ::VCVBGOpt, Convert__GR641_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement, { MCK_GR64, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11075 /* vcvbq */, SystemZ::VCVBQ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11081 /* vcvd */, SystemZ::VCVD, Convert__VR1281_0__GR321_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_U8Imm, MCK_U4Imm }, },
  { 11086 /* vcvdg */, SystemZ::VCVDG, Convert__VR1281_0__GR641_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR64, MCK_U8Imm, MCK_U4Imm }, },
  { 11092 /* vcvdq */, SystemZ::VCVDQ, Convert__VR1281_0__VR1281_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11098 /* vd */, SystemZ::VD, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11101 /* vdf */, SystemZ::VDF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11105 /* vdg */, SystemZ::VDG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11109 /* vdl */, SystemZ::VDL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11113 /* vdlf */, SystemZ::VDLF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11118 /* vdlg */, SystemZ::VDLG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11123 /* vdlq */, SystemZ::VDLQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11128 /* vdp */, SystemZ::VDP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11132 /* vdq */, SystemZ::VDQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11136 /* vec */, SystemZ::VEC, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11140 /* vecb */, SystemZ::VECB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11145 /* vecf */, SystemZ::VECF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11150 /* vecg */, SystemZ::VECG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11155 /* vech */, SystemZ::VECH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11160 /* vecl */, SystemZ::VECL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11165 /* veclb */, SystemZ::VECLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11171 /* veclf */, SystemZ::VECLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11177 /* veclg */, SystemZ::VECLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11183 /* veclh */, SystemZ::VECLH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11189 /* veclq */, SystemZ::VECLQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11195 /* vecq */, SystemZ::VECQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11200 /* verim */, SystemZ::VERIM, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11206 /* verimb */, SystemZ::VERIMB, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11213 /* verimf */, SystemZ::VERIMF, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11220 /* verimg */, SystemZ::VERIMG, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11227 /* verimh */, SystemZ::VERIMH, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11234 /* verll */, SystemZ::VERLL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11240 /* verllb */, SystemZ::VERLLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11247 /* verllf */, SystemZ::VERLLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11254 /* verllg */, SystemZ::VERLLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11261 /* verllh */, SystemZ::VERLLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11268 /* verllv */, SystemZ::VERLLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11275 /* verllvb */, SystemZ::VERLLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11283 /* verllvf */, SystemZ::VERLLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11291 /* verllvg */, SystemZ::VERLLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11299 /* verllvh */, SystemZ::VERLLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11307 /* vesl */, SystemZ::VESL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11312 /* veslb */, SystemZ::VESLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11318 /* veslf */, SystemZ::VESLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11324 /* veslg */, SystemZ::VESLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11330 /* veslh */, SystemZ::VESLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11336 /* veslv */, SystemZ::VESLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11342 /* veslvb */, SystemZ::VESLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11349 /* veslvf */, SystemZ::VESLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11356 /* veslvg */, SystemZ::VESLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11363 /* veslvh */, SystemZ::VESLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11370 /* vesra */, SystemZ::VESRA, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11376 /* vesrab */, SystemZ::VESRAB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11383 /* vesraf */, SystemZ::VESRAF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11390 /* vesrag */, SystemZ::VESRAG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11397 /* vesrah */, SystemZ::VESRAH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11404 /* vesrav */, SystemZ::VESRAV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11411 /* vesravb */, SystemZ::VESRAVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11419 /* vesravf */, SystemZ::VESRAVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11427 /* vesravg */, SystemZ::VESRAVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11435 /* vesravh */, SystemZ::VESRAVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11443 /* vesrl */, SystemZ::VESRL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11449 /* vesrlb */, SystemZ::VESRLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11456 /* vesrlf */, SystemZ::VESRLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11463 /* vesrlg */, SystemZ::VESRLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11470 /* vesrlh */, SystemZ::VESRLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11477 /* vesrlv */, SystemZ::VESRLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11484 /* vesrlvb */, SystemZ::VESRLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11492 /* vesrlvf */, SystemZ::VESRLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11500 /* vesrlvg */, SystemZ::VESRLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11508 /* vesrlvh */, SystemZ::VESRLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11516 /* veval */, SystemZ::VEVAL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U8Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11522 /* vfa */, SystemZ::VFA, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11526 /* vfadb */, SystemZ::VFADB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11532 /* vfae */, SystemZ::VFAE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11532 /* vfae */, SystemZ::VFAE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11537 /* vfaeb */, SystemZ::VFAEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11537 /* vfaeb */, SystemZ::VFAEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11543 /* vfaebs */, SystemZ::VFAEBS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11543 /* vfaebs */, SystemZ::VFAEBS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11550 /* vfaef */, SystemZ::VFAEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11550 /* vfaef */, SystemZ::VFAEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11556 /* vfaefs */, SystemZ::VFAEFS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11556 /* vfaefs */, SystemZ::VFAEFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11563 /* vfaeh */, SystemZ::VFAEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11563 /* vfaeh */, SystemZ::VFAEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11569 /* vfaehs */, SystemZ::VFAEHS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11569 /* vfaehs */, SystemZ::VFAEHS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11576 /* vfaezb */, SystemZ::VFAEZB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11576 /* vfaezb */, SystemZ::VFAEZB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11583 /* vfaezbs */, SystemZ::VFAEZBS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11583 /* vfaezbs */, SystemZ::VFAEZBS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11591 /* vfaezf */, SystemZ::VFAEZF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11591 /* vfaezf */, SystemZ::VFAEZF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11598 /* vfaezfs */, SystemZ::VFAEZFS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11598 /* vfaezfs */, SystemZ::VFAEZFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11606 /* vfaezh */, SystemZ::VFAEZH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11606 /* vfaezh */, SystemZ::VFAEZH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11613 /* vfaezhs */, SystemZ::VFAEZHS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11613 /* vfaezhs */, SystemZ::VFAEZHS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11621 /* vfasb */, SystemZ::VFASB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11627 /* vfce */, SystemZ::VFCE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11632 /* vfcedb */, SystemZ::VFCEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11639 /* vfcedbs */, SystemZ::VFCEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11647 /* vfcesb */, SystemZ::VFCESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11654 /* vfcesbs */, SystemZ::VFCESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11662 /* vfch */, SystemZ::VFCH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11667 /* vfchdb */, SystemZ::VFCHDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11674 /* vfchdbs */, SystemZ::VFCHDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11682 /* vfche */, SystemZ::VFCHE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11688 /* vfchedb */, SystemZ::VFCHEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11696 /* vfchedbs */, SystemZ::VFCHEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11705 /* vfchesb */, SystemZ::VFCHESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11713 /* vfchesbs */, SystemZ::VFCHESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11722 /* vfchsb */, SystemZ::VFCHSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11729 /* vfchsbs */, SystemZ::VFCHSBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11737 /* vfd */, SystemZ::VFD, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11741 /* vfddb */, SystemZ::VFDDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11747 /* vfdsb */, SystemZ::VFDSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11753 /* vfee */, SystemZ::VFEE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11753 /* vfee */, SystemZ::VFEE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11758 /* vfeeb */, SystemZ::VFEEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11758 /* vfeeb */, SystemZ::VFEEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11764 /* vfeebs */, SystemZ::VFEEBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11771 /* vfeef */, SystemZ::VFEEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11771 /* vfeef */, SystemZ::VFEEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11777 /* vfeefs */, SystemZ::VFEEFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11784 /* vfeeh */, SystemZ::VFEEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11784 /* vfeeh */, SystemZ::VFEEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11790 /* vfeehs */, SystemZ::VFEEHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11797 /* vfeezb */, SystemZ::VFEEZB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11804 /* vfeezbs */, SystemZ::VFEEZBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11812 /* vfeezf */, SystemZ::VFEEZF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11819 /* vfeezfs */, SystemZ::VFEEZFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11827 /* vfeezh */, SystemZ::VFEEZH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11834 /* vfeezhs */, SystemZ::VFEEZHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11842 /* vfene */, SystemZ::VFENE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11842 /* vfene */, SystemZ::VFENE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11848 /* vfeneb */, SystemZ::VFENEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11848 /* vfeneb */, SystemZ::VFENEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11855 /* vfenebs */, SystemZ::VFENEBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11863 /* vfenef */, SystemZ::VFENEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11863 /* vfenef */, SystemZ::VFENEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11870 /* vfenefs */, SystemZ::VFENEFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11878 /* vfeneh */, SystemZ::VFENEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11878 /* vfeneh */, SystemZ::VFENEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11885 /* vfenehs */, SystemZ::VFENEHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11893 /* vfenezb */, SystemZ::VFENEZB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11901 /* vfenezbs */, SystemZ::VFENEZBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11910 /* vfenezf */, SystemZ::VFENEZF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11918 /* vfenezfs */, SystemZ::VFENEZFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11927 /* vfenezh */, SystemZ::VFENEZH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11935 /* vfenezhs */, SystemZ::VFENEZHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11944 /* vfi */, SystemZ::VFI, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11948 /* vfidb */, SystemZ::VFIDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11954 /* vfisb */, SystemZ::VFISB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11960 /* vfkedb */, SystemZ::VFKEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11967 /* vfkedbs */, SystemZ::VFKEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11975 /* vfkesb */, SystemZ::VFKESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11982 /* vfkesbs */, SystemZ::VFKESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11990 /* vfkhdb */, SystemZ::VFKHDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11997 /* vfkhdbs */, SystemZ::VFKHDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12005 /* vfkhedb */, SystemZ::VFKHEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12013 /* vfkhedbs */, SystemZ::VFKHEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12022 /* vfkhesb */, SystemZ::VFKHESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12030 /* vfkhesbs */, SystemZ::VFKHESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12039 /* vfkhsb */, SystemZ::VFKHSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12046 /* vfkhsbs */, SystemZ::VFKHSBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12054 /* vflcdb */, SystemZ::VFLCDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12061 /* vflcsb */, SystemZ::VFLCSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12068 /* vfll */, SystemZ::VFLL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12073 /* vflls */, SystemZ::VFLLS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12079 /* vflndb */, SystemZ::VFLNDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12086 /* vflnsb */, SystemZ::VFLNSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12093 /* vflpdb */, SystemZ::VFLPDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12100 /* vflpsb */, SystemZ::VFLPSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12107 /* vflr */, SystemZ::VFLR, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12112 /* vflrd */, SystemZ::VFLRD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12118 /* vfm */, SystemZ::VFM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12122 /* vfma */, SystemZ::VFMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12127 /* vfmadb */, SystemZ::VFMADB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12134 /* vfmasb */, SystemZ::VFMASB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12141 /* vfmax */, SystemZ::VFMAX, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12147 /* vfmaxdb */, SystemZ::VFMAXDB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12155 /* vfmaxsb */, SystemZ::VFMAXSB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12163 /* vfmdb */, SystemZ::VFMDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12169 /* vfmin */, SystemZ::VFMIN, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12175 /* vfmindb */, SystemZ::VFMINDB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12183 /* vfminsb */, SystemZ::VFMINSB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12191 /* vfms */, SystemZ::VFMS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12196 /* vfmsb */, SystemZ::VFMSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12202 /* vfmsdb */, SystemZ::VFMSDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12209 /* vfmssb */, SystemZ::VFMSSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12216 /* vfnma */, SystemZ::VFNMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12222 /* vfnmadb */, SystemZ::VFNMADB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12230 /* vfnmasb */, SystemZ::VFNMASB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12238 /* vfnms */, SystemZ::VFNMS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12244 /* vfnmsdb */, SystemZ::VFNMSDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12252 /* vfnmssb */, SystemZ::VFNMSSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12260 /* vfpso */, SystemZ::VFPSO, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12266 /* vfpsodb */, SystemZ::VFPSODB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12274 /* vfpsosb */, SystemZ::VFPSOSB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12282 /* vfs */, SystemZ::VFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12286 /* vfsdb */, SystemZ::VFSDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12292 /* vfsq */, SystemZ::VFSQ, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12297 /* vfsqdb */, SystemZ::VFSQDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12304 /* vfsqsb */, SystemZ::VFSQSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12311 /* vfssb */, SystemZ::VFSSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12317 /* vftci */, SystemZ::VFTCI, Convert__VR1281_0__VR1281_1__U12Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U12Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12323 /* vftcidb */, SystemZ::VFTCIDB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 12331 /* vftcisb */, SystemZ::VFTCISB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 12339 /* vgbm */, SystemZ::VGBM, Convert__VR1281_0__U16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_U16Imm }, },
  { 12344 /* vgef */, SystemZ::VGEF, Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U2Imm }, },
  { 12349 /* vgeg */, SystemZ::VGEG, Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U1Imm }, },
  { 12354 /* vgem */, SystemZ::VGEM, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12359 /* vgemb */, SystemZ::VGEMB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12365 /* vgemf */, SystemZ::VGEMF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12371 /* vgemg */, SystemZ::VGEMG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12377 /* vgemh */, SystemZ::VGEMH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12383 /* vgemq */, SystemZ::VGEMQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12389 /* vgfm */, SystemZ::VGFM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12394 /* vgfma */, SystemZ::VGFMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12400 /* vgfmab */, SystemZ::VGFMAB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12407 /* vgfmaf */, SystemZ::VGFMAF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12414 /* vgfmag */, SystemZ::VGFMAG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12421 /* vgfmah */, SystemZ::VGFMAH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12428 /* vgfmb */, SystemZ::VGFMB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12434 /* vgfmf */, SystemZ::VGFMF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12440 /* vgfmg */, SystemZ::VGFMG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12446 /* vgfmh */, SystemZ::VGFMH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12452 /* vgm */, SystemZ::VGM, Convert__VR1281_0__U8Imm1_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 12456 /* vgmb */, SystemZ::VGMB, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12461 /* vgmf */, SystemZ::VGMF, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12466 /* vgmg */, SystemZ::VGMG, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12471 /* vgmh */, SystemZ::VGMH, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12476 /* vistr */, SystemZ::VISTR, Convert__VR1281_0__VR1281_1__U4Imm1_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12476 /* vistr */, SystemZ::VISTR, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12482 /* vistrb */, SystemZ::VISTRB, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12482 /* vistrb */, SystemZ::VISTRB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12489 /* vistrbs */, SystemZ::VISTRBS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12497 /* vistrf */, SystemZ::VISTRF, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12497 /* vistrf */, SystemZ::VISTRF, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12504 /* vistrfs */, SystemZ::VISTRFS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12512 /* vistrh */, SystemZ::VISTRH, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12512 /* vistrh */, SystemZ::VISTRH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12519 /* vistrhs */, SystemZ::VISTRHS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12527 /* vl */, SystemZ::VL, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12527 /* vl */, SystemZ::VLAlign, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12530 /* vlbb */, SystemZ::VLBB, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12535 /* vlbr */, SystemZ::VLBR, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12540 /* vlbrf */, SystemZ::VLBRF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12546 /* vlbrg */, SystemZ::VLBRG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12552 /* vlbrh */, SystemZ::VLBRH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12558 /* vlbrq */, SystemZ::VLBRQ, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12564 /* vlbrrep */, SystemZ::VLBRREP, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12572 /* vlbrrepf */, SystemZ::VLBRREPF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12581 /* vlbrrepg */, SystemZ::VLBRREPG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12590 /* vlbrreph */, SystemZ::VLBRREPH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12599 /* vlc */, SystemZ::VLC, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12603 /* vlcb */, SystemZ::VLCB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12608 /* vlcf */, SystemZ::VLCF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12613 /* vlcg */, SystemZ::VLCG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12618 /* vlch */, SystemZ::VLCH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12623 /* vlcq */, SystemZ::VLCQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12628 /* vlde */, SystemZ::VLDE, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12633 /* vldeb */, SystemZ::VLDEB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12639 /* vleb */, SystemZ::VLEB, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12644 /* vlebrf */, SystemZ::VLEBRF, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 12651 /* vlebrg */, SystemZ::VLEBRG, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 12658 /* vlebrh */, SystemZ::VLEBRH, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 12665 /* vled */, SystemZ::VLED, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12670 /* vledb */, SystemZ::VLEDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12676 /* vlef */, SystemZ::VLEF, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 12681 /* vleg */, SystemZ::VLEG, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 12686 /* vleh */, SystemZ::VLEH, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 12691 /* vleib */, SystemZ::VLEIB, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U4Imm }, },
  { 12697 /* vleif */, SystemZ::VLEIF, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U2Imm }, },
  { 12703 /* vleig */, SystemZ::VLEIG, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U1Imm }, },
  { 12709 /* vleih */, SystemZ::VLEIH, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U3Imm }, },
  { 12715 /* vler */, SystemZ::VLER, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12720 /* vlerf */, SystemZ::VLERF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12726 /* vlerg */, SystemZ::VLERG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12732 /* vlerh */, SystemZ::VLERH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12738 /* vlgv */, SystemZ::VLGV, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 12743 /* vlgvb */, SystemZ::VLGVB, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12749 /* vlgvf */, SystemZ::VLGVF, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12755 /* vlgvg */, SystemZ::VLGVG, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12761 /* vlgvh */, SystemZ::VLGVH, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12767 /* vlip */, SystemZ::VLIP, Convert__VR1281_0__U16Imm1_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_U16Imm, MCK_U4Imm }, },
  { 12772 /* vll */, SystemZ::VLL, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 12776 /* vllebrz */, SystemZ::VLLEBRZ, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12784 /* vllebrze */, SystemZ::VLLEBRZE, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12793 /* vllebrzf */, SystemZ::VLLEBRZF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12802 /* vllebrzg */, SystemZ::VLLEBRZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12811 /* vllebrzh */, SystemZ::VLLEBRZH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12820 /* vllez */, SystemZ::VLLEZ, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12826 /* vllezb */, SystemZ::VLLEZB, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12833 /* vllezf */, SystemZ::VLLEZF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12840 /* vllezg */, SystemZ::VLLEZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12847 /* vllezh */, SystemZ::VLLEZH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12854 /* vllezlf */, SystemZ::VLLEZLF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12862 /* vlm */, SystemZ::VLM, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12 }, },
  { 12862 /* vlm */, SystemZ::VLMAlign, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12, MCK_U4Imm }, },
  { 12866 /* vlp */, SystemZ::VLP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12870 /* vlpb */, SystemZ::VLPB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12875 /* vlpf */, SystemZ::VLPF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12880 /* vlpg */, SystemZ::VLPG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12885 /* vlph */, SystemZ::VLPH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12890 /* vlpq */, SystemZ::VLPQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12895 /* vlr */, SystemZ::VLR, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12899 /* vlrep */, SystemZ::VLREP, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12905 /* vlrepb */, SystemZ::VLREPB, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12912 /* vlrepf */, SystemZ::VLREPF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12919 /* vlrepg */, SystemZ::VLREPG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12926 /* vlreph */, SystemZ::VLREPH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12933 /* vlrl */, SystemZ::VLRL, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 12938 /* vlrlr */, SystemZ::VLRLR, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 12944 /* vlvg */, SystemZ::VLVG, Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 12949 /* vlvgb */, SystemZ::VLVGB, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12955 /* vlvgf */, SystemZ::VLVGF, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12961 /* vlvgg */, SystemZ::VLVGG, Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_BDAddr32Disp12 }, },
  { 12967 /* vlvgh */, SystemZ::VLVGH, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12973 /* vlvgp */, SystemZ::VLVGP, Convert__VR1281_0__GR641_1__GR641_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_GR64 }, },
  { 12979 /* vmae */, SystemZ::VMAE, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12984 /* vmaeb */, SystemZ::VMAEB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12990 /* vmaef */, SystemZ::VMAEF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12996 /* vmaeg */, SystemZ::VMAEG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13002 /* vmaeh */, SystemZ::VMAEH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13008 /* vmah */, SystemZ::VMAH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13013 /* vmahb */, SystemZ::VMAHB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13019 /* vmahf */, SystemZ::VMAHF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13025 /* vmahg */, SystemZ::VMAHG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13031 /* vmahh */, SystemZ::VMAHH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13037 /* vmahq */, SystemZ::VMAHQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13043 /* vmal */, SystemZ::VMAL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13048 /* vmalb */, SystemZ::VMALB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13054 /* vmale */, SystemZ::VMALE, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13060 /* vmaleb */, SystemZ::VMALEB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13067 /* vmalef */, SystemZ::VMALEF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13074 /* vmaleg */, SystemZ::VMALEG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13081 /* vmaleh */, SystemZ::VMALEH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13088 /* vmalf */, SystemZ::VMALF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13094 /* vmalg */, SystemZ::VMALG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13100 /* vmalh */, SystemZ::VMALH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13106 /* vmalhb */, SystemZ::VMALHB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13113 /* vmalhf */, SystemZ::VMALHF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13120 /* vmalhg */, SystemZ::VMALHG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13127 /* vmalhh */, SystemZ::VMALHH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13134 /* vmalhq */, SystemZ::VMALHQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13141 /* vmalhw */, SystemZ::VMALHW, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13148 /* vmalo */, SystemZ::VMALO, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13154 /* vmalob */, SystemZ::VMALOB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13161 /* vmalof */, SystemZ::VMALOF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13168 /* vmalog */, SystemZ::VMALOG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13175 /* vmaloh */, SystemZ::VMALOH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13182 /* vmalq */, SystemZ::VMALQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13188 /* vmao */, SystemZ::VMAO, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13193 /* vmaob */, SystemZ::VMAOB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13199 /* vmaof */, SystemZ::VMAOF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13205 /* vmaog */, SystemZ::VMAOG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13211 /* vmaoh */, SystemZ::VMAOH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13217 /* vme */, SystemZ::VME, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13221 /* vmeb */, SystemZ::VMEB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13226 /* vmef */, SystemZ::VMEF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13231 /* vmeg */, SystemZ::VMEG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13236 /* vmeh */, SystemZ::VMEH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13241 /* vmh */, SystemZ::VMH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13245 /* vmhb */, SystemZ::VMHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13250 /* vmhf */, SystemZ::VMHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13255 /* vmhg */, SystemZ::VMHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13260 /* vmhh */, SystemZ::VMHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13265 /* vmhq */, SystemZ::VMHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13270 /* vml */, SystemZ::VML, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13274 /* vmlb */, SystemZ::VMLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13279 /* vmle */, SystemZ::VMLE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13284 /* vmleb */, SystemZ::VMLEB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13290 /* vmlef */, SystemZ::VMLEF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13296 /* vmleg */, SystemZ::VMLEG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13302 /* vmleh */, SystemZ::VMLEH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13308 /* vmlf */, SystemZ::VMLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13313 /* vmlg */, SystemZ::VMLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13318 /* vmlh */, SystemZ::VMLH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13323 /* vmlhb */, SystemZ::VMLHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13329 /* vmlhf */, SystemZ::VMLHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13335 /* vmlhg */, SystemZ::VMLHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13341 /* vmlhh */, SystemZ::VMLHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13347 /* vmlhq */, SystemZ::VMLHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13353 /* vmlhw */, SystemZ::VMLHW, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13359 /* vmlo */, SystemZ::VMLO, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13364 /* vmlob */, SystemZ::VMLOB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13370 /* vmlof */, SystemZ::VMLOF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13376 /* vmlog */, SystemZ::VMLOG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13382 /* vmloh */, SystemZ::VMLOH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13388 /* vmlq */, SystemZ::VMLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13393 /* vmn */, SystemZ::VMN, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13397 /* vmnb */, SystemZ::VMNB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13402 /* vmnf */, SystemZ::VMNF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13407 /* vmng */, SystemZ::VMNG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13412 /* vmnh */, SystemZ::VMNH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13417 /* vmnl */, SystemZ::VMNL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13422 /* vmnlb */, SystemZ::VMNLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13428 /* vmnlf */, SystemZ::VMNLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13434 /* vmnlg */, SystemZ::VMNLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13440 /* vmnlh */, SystemZ::VMNLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13446 /* vmnlq */, SystemZ::VMNLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13452 /* vmnq */, SystemZ::VMNQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13457 /* vmo */, SystemZ::VMO, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13461 /* vmob */, SystemZ::VMOB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13466 /* vmof */, SystemZ::VMOF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13471 /* vmog */, SystemZ::VMOG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13476 /* vmoh */, SystemZ::VMOH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13481 /* vmp */, SystemZ::VMP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13485 /* vmrh */, SystemZ::VMRH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13490 /* vmrhb */, SystemZ::VMRHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13496 /* vmrhf */, SystemZ::VMRHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13502 /* vmrhg */, SystemZ::VMRHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13508 /* vmrhh */, SystemZ::VMRHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13514 /* vmrl */, SystemZ::VMRL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13519 /* vmrlb */, SystemZ::VMRLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13525 /* vmrlf */, SystemZ::VMRLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13531 /* vmrlg */, SystemZ::VMRLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13537 /* vmrlh */, SystemZ::VMRLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13543 /* vmsl */, SystemZ::VMSL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13548 /* vmslg */, SystemZ::VMSLG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13554 /* vmsp */, SystemZ::VMSP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13559 /* vmx */, SystemZ::VMX, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13563 /* vmxb */, SystemZ::VMXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13568 /* vmxf */, SystemZ::VMXF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13573 /* vmxg */, SystemZ::VMXG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13578 /* vmxh */, SystemZ::VMXH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13583 /* vmxl */, SystemZ::VMXL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13588 /* vmxlb */, SystemZ::VMXLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13594 /* vmxlf */, SystemZ::VMXLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13600 /* vmxlg */, SystemZ::VMXLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13606 /* vmxlh */, SystemZ::VMXLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13612 /* vmxlq */, SystemZ::VMXLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13618 /* vmxq */, SystemZ::VMXQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13623 /* vn */, SystemZ::VN, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13626 /* vnc */, SystemZ::VNC, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13630 /* vnn */, SystemZ::VNN, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13634 /* vno */, SystemZ::VNO, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13638 /* vnot */, SystemZ::VNO, Convert__VR1281_0__VR1281_1__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 13643 /* vnx */, SystemZ::VNX, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13647 /* vo */, SystemZ::VO, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13650 /* voc */, SystemZ::VOC, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13654 /* vone */, SystemZ::VONE, Convert__VR1281_0, AMFBS_FeatureVector, { MCK_VR128 }, },
  { 13659 /* vpdi */, SystemZ::VPDI, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13664 /* vperm */, SystemZ::VPERM, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13670 /* vpk */, SystemZ::VPK, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13674 /* vpkf */, SystemZ::VPKF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13679 /* vpkg */, SystemZ::VPKG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13684 /* vpkh */, SystemZ::VPKH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13689 /* vpkls */, SystemZ::VPKLS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13695 /* vpklsf */, SystemZ::VPKLSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13702 /* vpklsfs */, SystemZ::VPKLSFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13710 /* vpklsg */, SystemZ::VPKLSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13717 /* vpklsgs */, SystemZ::VPKLSGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13725 /* vpklsh */, SystemZ::VPKLSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13732 /* vpklshs */, SystemZ::VPKLSHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13740 /* vpks */, SystemZ::VPKS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13745 /* vpksf */, SystemZ::VPKSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13751 /* vpksfs */, SystemZ::VPKSFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13758 /* vpksg */, SystemZ::VPKSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13764 /* vpksgs */, SystemZ::VPKSGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13771 /* vpksh */, SystemZ::VPKSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13777 /* vpkshs */, SystemZ::VPKSHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13784 /* vpkz */, SystemZ::VPKZ, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 13789 /* vpkzr */, SystemZ::VPKZR, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13795 /* vpopct */, SystemZ::VPOPCT, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13802 /* vpopctb */, SystemZ::VPOPCTB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13810 /* vpopctf */, SystemZ::VPOPCTF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13818 /* vpopctg */, SystemZ::VPOPCTG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13826 /* vpopcth */, SystemZ::VPOPCTH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13834 /* vpsop */, SystemZ::VPSOP, Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 13840 /* vr */, SystemZ::VR, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13843 /* vrep */, SystemZ::VREP, Convert__VR1281_0__VR1281_1__U16Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm, MCK_U4Imm }, },
  { 13848 /* vrepb */, SystemZ::VREPB, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13854 /* vrepf */, SystemZ::VREPF, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13860 /* vrepg */, SystemZ::VREPG, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13866 /* vreph */, SystemZ::VREPH, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13872 /* vrepi */, SystemZ::VREPI, Convert__VR1281_0__S16Imm1_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U4Imm }, },
  { 13878 /* vrepib */, SystemZ::VREPIB, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13885 /* vrepif */, SystemZ::VREPIF, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13892 /* vrepig */, SystemZ::VREPIG, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13899 /* vrepih */, SystemZ::VREPIH, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13906 /* vrf */, SystemZ::VRF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13910 /* vrg */, SystemZ::VRG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13914 /* vrl */, SystemZ::VRL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13918 /* vrlf */, SystemZ::VRLF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13923 /* vrlg */, SystemZ::VRLG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13928 /* vrlq */, SystemZ::VRLQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13933 /* vrp */, SystemZ::VRP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13937 /* vrq */, SystemZ::VRQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13941 /* vs */, SystemZ::VS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13944 /* vsb */, SystemZ::VSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13948 /* vsbcbi */, SystemZ::VSBCBI, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13955 /* vsbcbiq */, SystemZ::VSBCBIQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13963 /* vsbi */, SystemZ::VSBI, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13968 /* vsbiq */, SystemZ::VSBIQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13974 /* vscbi */, SystemZ::VSCBI, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13980 /* vscbib */, SystemZ::VSCBIB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13987 /* vscbif */, SystemZ::VSCBIF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13994 /* vscbig */, SystemZ::VSCBIG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14001 /* vscbih */, SystemZ::VSCBIH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14008 /* vscbiq */, SystemZ::VSCBIQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14015 /* vscef */, SystemZ::VSCEF, Convert__VR1281_0__BDVAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U2Imm }, },
  { 14021 /* vsceg */, SystemZ::VSCEG, Convert__VR1281_0__BDVAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U1Imm }, },
  { 14027 /* vschdp */, SystemZ::VSCHDP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14034 /* vschp */, SystemZ::VSCHP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14040 /* vschsp */, SystemZ::VSCHSP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14047 /* vschxp */, SystemZ::VSCHXP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14054 /* vscshp */, SystemZ::VSCSHP, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14061 /* vsdp */, SystemZ::VSDP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14066 /* vseg */, SystemZ::VSEG, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14071 /* vsegb */, SystemZ::VSEGB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14077 /* vsegf */, SystemZ::VSEGF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14083 /* vsegh */, SystemZ::VSEGH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14089 /* vsel */, SystemZ::VSEL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14094 /* vsf */, SystemZ::VSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14098 /* vsg */, SystemZ::VSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14102 /* vsh */, SystemZ::VSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14106 /* vsl */, SystemZ::VSL, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14110 /* vslb */, SystemZ::VSLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14115 /* vsld */, SystemZ::VSLD, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14120 /* vsldb */, SystemZ::VSLDB, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14126 /* vsp */, SystemZ::VSP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14130 /* vsq */, SystemZ::VSQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14134 /* vsra */, SystemZ::VSRA, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14139 /* vsrab */, SystemZ::VSRAB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14145 /* vsrd */, SystemZ::VSRD, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14150 /* vsrl */, SystemZ::VSRL, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14155 /* vsrlb */, SystemZ::VSRLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14161 /* vsrp */, SystemZ::VSRP, Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 14166 /* vsrpr */, SystemZ::VSRPR, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14172 /* vst */, SystemZ::VST, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14172 /* vst */, SystemZ::VSTAlign, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14176 /* vstbr */, SystemZ::VSTBR, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14182 /* vstbrf */, SystemZ::VSTBRF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14189 /* vstbrg */, SystemZ::VSTBRG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14196 /* vstbrh */, SystemZ::VSTBRH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14203 /* vstbrq */, SystemZ::VSTBRQ, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14210 /* vsteb */, SystemZ::VSTEB, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14216 /* vstebrf */, SystemZ::VSTEBRF, Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 14224 /* vstebrg */, SystemZ::VSTEBRG, Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 14232 /* vstebrh */, SystemZ::VSTEBRH, Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 14240 /* vstef */, SystemZ::VSTEF, Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 14246 /* vsteg */, SystemZ::VSTEG, Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 14252 /* vsteh */, SystemZ::VSTEH, Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 14258 /* vster */, SystemZ::VSTER, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14264 /* vsterf */, SystemZ::VSTERF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14271 /* vsterg */, SystemZ::VSTERG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14278 /* vsterh */, SystemZ::VSTERH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14285 /* vstl */, SystemZ::VSTL, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 14290 /* vstm */, SystemZ::VSTM, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12 }, },
  { 14290 /* vstm */, SystemZ::VSTMAlign, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12, MCK_U4Imm }, },
  { 14295 /* vstrc */, SystemZ::VSTRC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14295 /* vstrc */, SystemZ::VSTRC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14301 /* vstrcb */, SystemZ::VSTRCB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14301 /* vstrcb */, SystemZ::VSTRCB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14308 /* vstrcbs */, SystemZ::VSTRCBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14308 /* vstrcbs */, SystemZ::VSTRCBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14316 /* vstrcf */, SystemZ::VSTRCF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14316 /* vstrcf */, SystemZ::VSTRCF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14323 /* vstrcfs */, SystemZ::VSTRCFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14323 /* vstrcfs */, SystemZ::VSTRCFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14331 /* vstrch */, SystemZ::VSTRCH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14331 /* vstrch */, SystemZ::VSTRCH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14338 /* vstrchs */, SystemZ::VSTRCHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14338 /* vstrchs */, SystemZ::VSTRCHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14346 /* vstrczb */, SystemZ::VSTRCZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14346 /* vstrczb */, SystemZ::VSTRCZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14354 /* vstrczbs */, SystemZ::VSTRCZBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14354 /* vstrczbs */, SystemZ::VSTRCZBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14363 /* vstrczf */, SystemZ::VSTRCZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14363 /* vstrczf */, SystemZ::VSTRCZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14371 /* vstrczfs */, SystemZ::VSTRCZFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14371 /* vstrczfs */, SystemZ::VSTRCZFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14380 /* vstrczh */, SystemZ::VSTRCZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14380 /* vstrczh */, SystemZ::VSTRCZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14388 /* vstrczhs */, SystemZ::VSTRCZHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14388 /* vstrczhs */, SystemZ::VSTRCZHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14397 /* vstrl */, SystemZ::VSTRL, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 14403 /* vstrlr */, SystemZ::VSTRLR, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 14410 /* vstrs */, SystemZ::VSTRS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14410 /* vstrs */, SystemZ::VSTRS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14416 /* vstrsb */, SystemZ::VSTRSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14416 /* vstrsb */, SystemZ::VSTRSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14423 /* vstrsf */, SystemZ::VSTRSF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14423 /* vstrsf */, SystemZ::VSTRSF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14430 /* vstrsh */, SystemZ::VSTRSH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14430 /* vstrsh */, SystemZ::VSTRSH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14437 /* vstrszb */, SystemZ::VSTRSZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14445 /* vstrszf */, SystemZ::VSTRSZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14453 /* vstrszh */, SystemZ::VSTRSZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14461 /* vsum */, SystemZ::VSUM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14466 /* vsumb */, SystemZ::VSUMB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14472 /* vsumg */, SystemZ::VSUMG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14478 /* vsumgf */, SystemZ::VSUMGF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14485 /* vsumgh */, SystemZ::VSUMGH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14492 /* vsumh */, SystemZ::VSUMH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14498 /* vsumq */, SystemZ::VSUMQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14504 /* vsumqf */, SystemZ::VSUMQF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14511 /* vsumqg */, SystemZ::VSUMQG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14518 /* vtm */, SystemZ::VTM, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14522 /* vtp */, SystemZ::VTP, Convert__VR1281_0, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128 }, },
  { 14522 /* vtp */, SystemZ::VTPOpt, Convert__VR1281_0__U16Imm1_1, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_U16Imm }, },
  { 14526 /* vtz */, SystemZ::VTZ, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 14530 /* vuph */, SystemZ::VUPH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14535 /* vuphb */, SystemZ::VUPHB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14541 /* vuphf */, SystemZ::VUPHF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14547 /* vuphg */, SystemZ::VUPHG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14553 /* vuphh */, SystemZ::VUPHH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14559 /* vupkz */, SystemZ::VUPKZ, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 14565 /* vupkzh */, SystemZ::VUPKZH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14572 /* vupkzl */, SystemZ::VUPKZL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14579 /* vupl */, SystemZ::VUPL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14584 /* vuplb */, SystemZ::VUPLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14590 /* vuplf */, SystemZ::VUPLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14596 /* vuplg */, SystemZ::VUPLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14602 /* vuplh */, SystemZ::VUPLH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14608 /* vuplhb */, SystemZ::VUPLHB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14615 /* vuplhf */, SystemZ::VUPLHF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14622 /* vuplhg */, SystemZ::VUPLHG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14629 /* vuplhh */, SystemZ::VUPLHH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14636 /* vuplhw */, SystemZ::VUPLHW, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14643 /* vupll */, SystemZ::VUPLL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14649 /* vupllb */, SystemZ::VUPLLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14656 /* vupllf */, SystemZ::VUPLLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14663 /* vupllg */, SystemZ::VUPLLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14670 /* vupllh */, SystemZ::VUPLLH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14677 /* vx */, SystemZ::VX, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14680 /* vzero */, SystemZ::VZERO, Convert__VR1281_0, AMFBS_FeatureVector, { MCK_VR128 }, },
  { 14686 /* wcdgb */, SystemZ::WCDGB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14692 /* wcdlgb */, SystemZ::WCDLGB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14699 /* wcefb */, SystemZ::WCEFB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14705 /* wcelfb */, SystemZ::WCELFB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14712 /* wcfeb */, SystemZ::WCFEB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14718 /* wcgdb */, SystemZ::WCGDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14724 /* wclfeb */, SystemZ::WCLFEB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14731 /* wclgdb */, SystemZ::WCLGDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14738 /* wfadb */, SystemZ::WFADB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14744 /* wfasb */, SystemZ::WFASB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14750 /* wfaxb */, SystemZ::WFAXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14756 /* wfc */, SystemZ::WFC, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14760 /* wfcdb */, SystemZ::WFCDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 14766 /* wfcedb */, SystemZ::WFCEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14773 /* wfcedbs */, SystemZ::WFCEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14781 /* wfcesb */, SystemZ::WFCESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14788 /* wfcesbs */, SystemZ::WFCESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14796 /* wfcexb */, SystemZ::WFCEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14803 /* wfcexbs */, SystemZ::WFCEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14811 /* wfchdb */, SystemZ::WFCHDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14818 /* wfchdbs */, SystemZ::WFCHDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14826 /* wfchedb */, SystemZ::WFCHEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14834 /* wfchedbs */, SystemZ::WFCHEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14843 /* wfchesb */, SystemZ::WFCHESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14851 /* wfchesbs */, SystemZ::WFCHESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14860 /* wfchexb */, SystemZ::WFCHEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14868 /* wfchexbs */, SystemZ::WFCHEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14877 /* wfchsb */, SystemZ::WFCHSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14884 /* wfchsbs */, SystemZ::WFCHSBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14892 /* wfchxb */, SystemZ::WFCHXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14899 /* wfchxbs */, SystemZ::WFCHXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14907 /* wfcsb */, SystemZ::WFCSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 14913 /* wfcxb */, SystemZ::WFCXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 14919 /* wfddb */, SystemZ::WFDDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14925 /* wfdsb */, SystemZ::WFDSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14931 /* wfdxb */, SystemZ::WFDXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14937 /* wfidb */, SystemZ::WFIDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14943 /* wfisb */, SystemZ::WFISB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14949 /* wfixb */, SystemZ::WFIXB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14955 /* wfk */, SystemZ::WFK, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14959 /* wfkdb */, SystemZ::WFKDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 14965 /* wfkedb */, SystemZ::WFKEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14972 /* wfkedbs */, SystemZ::WFKEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14980 /* wfkesb */, SystemZ::WFKESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14987 /* wfkesbs */, SystemZ::WFKESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14995 /* wfkexb */, SystemZ::WFKEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15002 /* wfkexbs */, SystemZ::WFKEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15010 /* wfkhdb */, SystemZ::WFKHDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15017 /* wfkhdbs */, SystemZ::WFKHDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15025 /* wfkhedb */, SystemZ::WFKHEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15033 /* wfkhedbs */, SystemZ::WFKHEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15042 /* wfkhesb */, SystemZ::WFKHESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15050 /* wfkhesbs */, SystemZ::WFKHESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15059 /* wfkhexb */, SystemZ::WFKHEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15067 /* wfkhexbs */, SystemZ::WFKHEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15076 /* wfkhsb */, SystemZ::WFKHSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15083 /* wfkhsbs */, SystemZ::WFKHSBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15091 /* wfkhxb */, SystemZ::WFKHXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15098 /* wfkhxbs */, SystemZ::WFKHXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15106 /* wfksb */, SystemZ::WFKSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15112 /* wfkxb */, SystemZ::WFKXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15118 /* wflcdb */, SystemZ::WFLCDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15125 /* wflcsb */, SystemZ::WFLCSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15132 /* wflcxb */, SystemZ::WFLCXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15139 /* wflld */, SystemZ::WFLLD, Convert__VR1281_0__VR641_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR64 }, },
  { 15145 /* wflls */, SystemZ::WFLLS, Convert__VR641_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR32 }, },
  { 15151 /* wflndb */, SystemZ::WFLNDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15158 /* wflnsb */, SystemZ::WFLNSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15165 /* wflnxb */, SystemZ::WFLNXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15172 /* wflpdb */, SystemZ::WFLPDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15179 /* wflpsb */, SystemZ::WFLPSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15186 /* wflpxb */, SystemZ::WFLPXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15193 /* wflrd */, SystemZ::WFLRD, Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 15199 /* wflrx */, SystemZ::WFLRX, Convert__VR641_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 15205 /* wfmadb */, SystemZ::WFMADB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15212 /* wfmasb */, SystemZ::WFMASB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15219 /* wfmaxb */, SystemZ::WFMAXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15226 /* wfmaxdb */, SystemZ::WFMAXDB, Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15234 /* wfmaxsb */, SystemZ::WFMAXSB, Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15242 /* wfmaxxb */, SystemZ::WFMAXXB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15250 /* wfmdb */, SystemZ::WFMDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15256 /* wfmindb */, SystemZ::WFMINDB, Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15264 /* wfminsb */, SystemZ::WFMINSB, Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15272 /* wfminxb */, SystemZ::WFMINXB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15280 /* wfmsb */, SystemZ::WFMSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15286 /* wfmsdb */, SystemZ::WFMSDB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15293 /* wfmssb */, SystemZ::WFMSSB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15300 /* wfmsxb */, SystemZ::WFMSXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15307 /* wfmxb */, SystemZ::WFMXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15313 /* wfnmadb */, SystemZ::WFNMADB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15321 /* wfnmasb */, SystemZ::WFNMASB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15329 /* wfnmaxb */, SystemZ::WFNMAXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15337 /* wfnmsdb */, SystemZ::WFNMSDB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15345 /* wfnmssb */, SystemZ::WFNMSSB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15353 /* wfnmsxb */, SystemZ::WFNMSXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15361 /* wfpsodb */, SystemZ::WFPSODB, Convert__VR641_0__VR641_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15369 /* wfpsosb */, SystemZ::WFPSOSB, Convert__VR321_0__VR321_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15377 /* wfpsoxb */, SystemZ::WFPSOXB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15385 /* wfsdb */, SystemZ::WFSDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15391 /* wfsqdb */, SystemZ::WFSQDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15398 /* wfsqsb */, SystemZ::WFSQSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15405 /* wfsqxb */, SystemZ::WFSQXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15412 /* wfssb */, SystemZ::WFSSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15418 /* wfsxb */, SystemZ::WFSXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15424 /* wftcidb */, SystemZ::WFTCIDB, Convert__VR641_0__VR641_1__U12Imm1_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U12Imm }, },
  { 15432 /* wftcisb */, SystemZ::WFTCISB, Convert__VR321_0__VR321_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U12Imm }, },
  { 15440 /* wftcixb */, SystemZ::WFTCIXB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 15448 /* wldeb */, SystemZ::WLDEB, Convert__VR641_0__VR321_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR32 }, },
  { 15454 /* wledb */, SystemZ::WLEDB, Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR32, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 15460 /* x */, SystemZ::X, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 15462 /* xc */, SystemZ::XC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 15465 /* xg */, SystemZ::XG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 15468 /* xgr */, SystemZ::XGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 15472 /* xgrk */, SystemZ::XGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 15477 /* xi */, SystemZ::XI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 15480 /* xihf */, SystemZ::XIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 15485 /* xilf */, SystemZ::XILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 15490 /* xiy */, SystemZ::XIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 15494 /* xr */, SystemZ::XR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 15497 /* xrk */, SystemZ::XRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 15501 /* xsch */, SystemZ::XSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 15506 /* xy */, SystemZ::XY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 15509 /* zap */, SystemZ::ZAP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
};

#include "llvm/Support/Debug.h"
#include "llvm/Support/Format.h"

unsigned SystemZAsmParser::
MatchInstructionImpl(const OperandVector &Operands,
                     MCInst &Inst,
                     uint64_t &ErrorInfo,
                     FeatureBitset &MissingFeatures,
                     bool matchingInlineAsm, unsigned VariantID) {
  // Eliminate obvious mismatches.
  if (Operands.size() > 7) {
    ErrorInfo = 7;
    return Match_InvalidOperand;
  }

  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the instruction mnemonic, which is the first token.
  StringRef Mnemonic = ((SystemZOperand &)*Operands[0]).getToken();

  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Some state to try to produce better error messages.
  bool HadMatchOtherThanFeatures = false;
  bool HadMatchOtherThanPredicate = false;
  unsigned RetCode = Match_InvalidOperand;
  MissingFeatures.set();
  // Set ErrorInfo to the operand that mismatches if it is
  // wrong for all instances of the instruction.
  ErrorInfo = ~0ULL;
  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  case 1: Start = std::begin(MatchTable1); End = std::end(MatchTable1); break;
  }
  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  DEBUG_WITH_TYPE("asm-matcher", dbgs() << "AsmMatcher: found " <<
  std::distance(MnemonicRange.first, MnemonicRange.second) <<
  " encodings with mnemonic '" << Mnemonic << "'\n");

  // Return a more specific error code if no mnemonics match.
  if (MnemonicRange.first == MnemonicRange.second)
    return Match_MnemonicFail;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    bool HasRequiredFeatures =
      (AvailableFeatures & RequiredFeatures) == RequiredFeatures;
    DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Trying to match opcode "
                                          << MII.getName(it->Opcode) << "\n");
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());
    bool OperandsValid = true;
    for (unsigned FormalIdx = 0, ActualIdx = 1; FormalIdx != 6; ++FormalIdx) {
      auto Formal = static_cast<MatchClassKind>(it->Classes[FormalIdx]);
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "  Matching formal operand class " << getMatchClassName(Formal)
                             << " against actual operand at index " << ActualIdx);
      if (ActualIdx < Operands.size())
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << " (";
                        Operands[ActualIdx]->print(dbgs()); dbgs() << "): ");
      else
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << ": ");
      if (ActualIdx >= Operands.size()) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "actual operand index out of range\n");
        if (Formal == InvalidMatchClass) {
          break;
        }
        if (isSubclass(Formal, OptionalMatchClass)) {
          continue;
        }
        OperandsValid = false;
        ErrorInfo = ActualIdx;
        break;
      }
      MCParsedAsmOperand &Actual = *Operands[ActualIdx];
      unsigned Diag = validateOperandClass(Actual, Formal);
      if (Diag == Match_Success) {
        DEBUG_WITH_TYPE("asm-matcher",
                        dbgs() << "match success using generic matcher\n");
        ++ActualIdx;
        continue;
      }
      // If the generic handler indicates an invalid operand
      // failure, check for a special case.
      if (Diag != Match_Success) {
        unsigned TargetDiag = validateTargetOperandClass(Actual, Formal);
        if (TargetDiag == Match_Success) {
          DEBUG_WITH_TYPE("asm-matcher",
                          dbgs() << "match success using target matcher\n");
          ++ActualIdx;
          continue;
        }
        // If the target matcher returned a specific error code use
        // that, else use the one from the generic matcher.
        if (TargetDiag != Match_InvalidOperand && HasRequiredFeatures)
          Diag = TargetDiag;
      }
      // If current formal operand wasn't matched and it is optional
      // then try to match next formal operand
      if (Diag == Match_InvalidOperand && isSubclass(Formal, OptionalMatchClass)) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "ignoring optional operand\n");
        continue;
      }
      // If this operand is broken for all of the instances of this
      // mnemonic, keep track of it so we can report loc info.
      // If we already had a match that only failed due to a
      // target predicate, that diagnostic is preferred.
      if (!HadMatchOtherThanPredicate &&
          (it == MnemonicRange.first || ErrorInfo <= ActualIdx)) {
        if (HasRequiredFeatures && (ErrorInfo != ActualIdx || Diag != Match_InvalidOperand))
          RetCode = Diag;
        ErrorInfo = ActualIdx;
      }
      // Otherwise, just reject this instance of the mnemonic.
      OperandsValid = false;
      break;
    }

    if (!OperandsValid) {
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Opcode result: multiple "
                                               "operand mismatches, ignoring "
                                               "this opcode\n");
      continue;
    }
    if (!HasRequiredFeatures) {
      HadMatchOtherThanFeatures = true;
      FeatureBitset NewMissingFeatures = RequiredFeatures & ~AvailableFeatures;
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Missing target features:";
                      for (unsigned I = 0, E = NewMissingFeatures.size(); I != E; ++I)
                        if (NewMissingFeatures[I])
                          dbgs() << ' ' << I;
                      dbgs() << "\n");
      if (NewMissingFeatures.count() <=
          MissingFeatures.count())
        MissingFeatures = NewMissingFeatures;
      continue;
    }

    Inst.clear();

    Inst.setOpcode(it->Opcode);
    // We have a potential match but have not rendered the operands.
    // Check the target predicate to handle any context sensitive
    // constraints.
    // For example, Ties that are referenced multiple times must be
    // checked here to ensure the input is the same for each match
    // constraints. If we leave it any later the ties will have been
    // canonicalized
    unsigned MatchResult;
    if ((MatchResult = checkEarlyTargetMatchPredicate(Inst, Operands)) != Match_Success) {
      Inst.clear();
      DEBUG_WITH_TYPE(
          "asm-matcher",
          dbgs() << "Early target match predicate failed with diag code "
                 << MatchResult << "\n");
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (matchingInlineAsm) {
      convertToMapAndConstraints(it->ConvertFn, Operands);
      if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                          ErrorInfo))
        return Match_InvalidTiedOperand;

      return Match_Success;
    }

    // We have selected a definite instruction, convert the parsed
    // operands into the appropriate MCInst.
    convertToMCInst(it->ConvertFn, Inst, it->Opcode, Operands);

    // We have a potential match. Check the target predicate to
    // handle any context sensitive constraints.
    if ((MatchResult = checkTargetMatchPredicate(Inst)) != Match_Success) {
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "Target match predicate failed with diag code "
                             << MatchResult << "\n");
      Inst.clear();
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                         ErrorInfo))
      return Match_InvalidTiedOperand;

    DEBUG_WITH_TYPE(
        "asm-matcher",
        dbgs() << "Opcode result: complete match, selecting this opcode\n");
    return Match_Success;
  }

  // Okay, we had no match.  Try to return a useful error code.
  if (HadMatchOtherThanPredicate || !HadMatchOtherThanFeatures)
    return RetCode;

  ErrorInfo = 0;
  return Match_MissingFeature;
}

namespace {
  struct OperandMatchEntry {
    uint16_t Mnemonic;
    uint8_t OperandMask;
    uint8_t Class;
    uint8_t RequiredFeaturesIdx;

    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcodeOperand {
    bool operator()(const OperandMatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic()  < RHS;
    }
    bool operator()(StringRef LHS, const OperandMatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const OperandMatchEntry &LHS, const OperandMatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const OperandMatchEntry OperandMatchTable[7006] = {
  /* Operand List Mnemonic, Mask, Operand Class, Features */
  { 1 /* a */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 1 /* a */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1 /* a */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 1 /* a */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3 /* ad */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 3 /* ad */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 3 /* ad */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 3 /* ad */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 6 /* adb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 6 /* adb */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 6 /* adb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 6 /* adb */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 10 /* adbr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 10 /* adbr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 15 /* adr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 15 /* adr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 19 /* adtr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 19 /* adtr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 24 /* adtra */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 24 /* adtra */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 30 /* ae */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 30 /* ae */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 30 /* ae */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 30 /* ae */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 33 /* aeb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 33 /* aeb */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 33 /* aeb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 33 /* aeb */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 37 /* aebr */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 37 /* aebr */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 42 /* aer */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 42 /* aer */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 46 /* afi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 46 /* afi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 50 /* ag */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 50 /* ag */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 50 /* ag */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 50 /* ag */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 53 /* agf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 53 /* agf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 53 /* agf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 53 /* agf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 57 /* agfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 57 /* agfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 62 /* agfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 62 /* agfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 62 /* agfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 62 /* agfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 67 /* agh */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 67 /* agh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions2 },
  { 67 /* agh */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 67 /* agh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions2 },
  { 71 /* aghi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 71 /* aghi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 76 /* aghik */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 76 /* aghik */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 82 /* agr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 82 /* agr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 86 /* agrk */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 86 /* agrk */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 91 /* agsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 91 /* agsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 96 /* ah */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 96 /* ah */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 96 /* ah */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 96 /* ah */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 99 /* ahhhr */, 7 /* 0, 1, 2 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 99 /* ahhhr */, 7 /* 0, 1, 2 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 105 /* ahhlr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 105 /* ahhlr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 105 /* ahhlr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 105 /* ahhlr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 111 /* ahi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 111 /* ahi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 115 /* ahik */, 3 /* 0, 1 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 115 /* ahik */, 3 /* 0, 1 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 120 /* ahy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 120 /* ahy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 120 /* ahy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 120 /* ahy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 124 /* aih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 124 /* aih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 128 /* al */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 128 /* al */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 128 /* al */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 128 /* al */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 131 /* alc */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 131 /* alc */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 131 /* alc */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 131 /* alc */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 135 /* alcg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 135 /* alcg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 135 /* alcg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 135 /* alcg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 140 /* alcgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 140 /* alcgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 146 /* alcr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 146 /* alcr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 151 /* alfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 151 /* alfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 156 /* alg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 156 /* alg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 156 /* alg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 156 /* alg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 160 /* algf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 160 /* algf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 160 /* algf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 160 /* algf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 165 /* algfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 165 /* algfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 171 /* algfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 171 /* algfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 171 /* algfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 171 /* algfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 177 /* alghsik */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 177 /* alghsik */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 185 /* algr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 185 /* algr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 190 /* algrk */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 190 /* algrk */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 196 /* algsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 196 /* algsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 202 /* alhhhr */, 7 /* 0, 1, 2 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 202 /* alhhhr */, 7 /* 0, 1, 2 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 209 /* alhhlr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 209 /* alhhlr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 209 /* alhhlr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 209 /* alhhlr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 216 /* alhsik */, 3 /* 0, 1 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 216 /* alhsik */, 3 /* 0, 1 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 223 /* alr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 223 /* alr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 227 /* alrk */, 7 /* 0, 1, 2 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 227 /* alrk */, 7 /* 0, 1, 2 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 232 /* alsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 232 /* alsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 237 /* alsih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 237 /* alsih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 243 /* alsihn */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 243 /* alsihn */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 250 /* aly */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 250 /* aly */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 250 /* aly */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 250 /* aly */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 254 /* ap */, 3 /* 0, 1 */, MCK_BDLAddr64Disp12Len4, AMFBS_None },
  { 254 /* ap */, 3 /* 0, 1 */, MCK_BDLAddr64Disp12Len4, AMFBS_None },
  { 257 /* ar */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 257 /* ar */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 260 /* ark */, 7 /* 0, 1, 2 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 260 /* ark */, 7 /* 0, 1, 2 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 264 /* asi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 264 /* asi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 268 /* au */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 268 /* au */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 268 /* au */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 268 /* au */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 271 /* aur */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 271 /* aur */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 275 /* aw */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 275 /* aw */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 275 /* aw */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 275 /* aw */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 278 /* awr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 278 /* awr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 282 /* axbr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 282 /* axbr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 287 /* axr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 287 /* axr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 291 /* axtr */, 7 /* 0, 1, 2 */, MCK_FP128, AMFBS_None },
  { 291 /* axtr */, 7 /* 0, 1, 2 */, MCK_FP128, AMFBS_None },
  { 296 /* axtra */, 7 /* 0, 1, 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 296 /* axtra */, 7 /* 0, 1, 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 302 /* ay */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 302 /* ay */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 302 /* ay */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 302 /* ay */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 305 /* b */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 305 /* b */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 307 /* bakr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 307 /* bakr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 312 /* bal */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 312 /* bal */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 312 /* bal */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 312 /* bal */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 316 /* balr */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 316 /* balr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 316 /* balr */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 316 /* balr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 321 /* bas */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 321 /* bas */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 321 /* bas */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 321 /* bas */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 325 /* basr */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 325 /* basr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 325 /* basr */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 325 /* basr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 330 /* bassm */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 330 /* bassm */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 330 /* bassm */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 330 /* bassm */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 336 /* bc */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 336 /* bc */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 339 /* bcr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 339 /* bcr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 343 /* bct */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 343 /* bct */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 343 /* bct */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 343 /* bct */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 347 /* bctg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 347 /* bctg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 347 /* bctg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 347 /* bctg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 352 /* bctgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 352 /* bctgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 358 /* bctr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 358 /* bctr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 358 /* bctr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 358 /* bctr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 363 /* bdepg */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 363 /* bdepg */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 369 /* be */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 369 /* be */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 372 /* ber */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 372 /* ber */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 376 /* bextg */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 376 /* bextg */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 382 /* bh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 382 /* bh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 385 /* bhe */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 389 /* bher */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 394 /* bhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 394 /* bhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 398 /* bi */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 398 /* bi */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 401 /* bic */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 401 /* bic */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 405 /* bie */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 405 /* bie */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 409 /* bih */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 409 /* bih */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 413 /* bihe */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 418 /* bil */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 418 /* bil */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 422 /* bile */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 427 /* bilh */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 432 /* bim */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 432 /* bim */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 436 /* bine */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 436 /* bine */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 441 /* binh */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 441 /* binh */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 446 /* binhe */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 452 /* binl */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 452 /* binl */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 457 /* binle */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 463 /* binlh */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 469 /* binm */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 469 /* binm */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 474 /* bino */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 474 /* bino */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 479 /* binp */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 479 /* binp */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 484 /* binz */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 484 /* binz */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 489 /* bio */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 489 /* bio */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 493 /* bip */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 493 /* bip */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 497 /* biz */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 497 /* biz */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 501 /* bl */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 501 /* bl */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 504 /* ble */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 508 /* bler */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 513 /* blh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 517 /* blhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 522 /* blr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 522 /* blr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 526 /* bm */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 526 /* bm */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 529 /* bmr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 529 /* bmr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 533 /* bne */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 533 /* bne */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 537 /* bner */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 537 /* bner */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 542 /* bnh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 542 /* bnh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 546 /* bnhe */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 551 /* bnher */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 557 /* bnhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 557 /* bnhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 562 /* bnl */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 562 /* bnl */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 566 /* bnle */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 571 /* bnler */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 577 /* bnlh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 582 /* bnlhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 588 /* bnlr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 588 /* bnlr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 593 /* bnm */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 593 /* bnm */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 597 /* bnmr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 597 /* bnmr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 602 /* bno */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 602 /* bno */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 606 /* bnor */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 606 /* bnor */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 611 /* bnp */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 611 /* bnp */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 615 /* bnpr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 615 /* bnpr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 620 /* bnz */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 620 /* bnz */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 624 /* bnzr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 624 /* bnzr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 629 /* bo */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 629 /* bo */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 632 /* bor */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 632 /* bor */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 636 /* bp */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 636 /* bp */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 639 /* bpp */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureExecutionHint },
  { 639 /* bpp */, 2 /* 1 */, MCK_PCRel16, AMFBS_FeatureExecutionHint },
  { 639 /* bpp */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureExecutionHint },
  { 639 /* bpp */, 2 /* 1 */, MCK_PCRel16, AMFBS_FeatureExecutionHint },
  { 643 /* bpr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 643 /* bpr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 647 /* bprp */, 2 /* 1 */, MCK_PCRel12, AMFBS_FeatureExecutionHint },
  { 647 /* bprp */, 4 /* 2 */, MCK_PCRel24, AMFBS_FeatureExecutionHint },
  { 647 /* bprp */, 2 /* 1 */, MCK_PCRel12, AMFBS_FeatureExecutionHint },
  { 647 /* bprp */, 4 /* 2 */, MCK_PCRel24, AMFBS_FeatureExecutionHint },
  { 652 /* br */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 652 /* br */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 655 /* bras */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 655 /* bras */, 2 /* 1 */, MCK_PCRelTLS16, AMFBS_None },
  { 655 /* bras */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 655 /* bras */, 2 /* 1 */, MCK_PCRelTLS16, AMFBS_None },
  { 660 /* brasl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 660 /* brasl */, 2 /* 1 */, MCK_PCRelTLS32, AMFBS_None },
  { 660 /* brasl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 660 /* brasl */, 2 /* 1 */, MCK_PCRelTLS32, AMFBS_None },
  { 666 /* brc */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 666 /* brc */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 670 /* brcl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 670 /* brcl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 675 /* brct */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 675 /* brct */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 675 /* brct */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 675 /* brct */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 680 /* brctg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 680 /* brctg */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 680 /* brctg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 680 /* brctg */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 686 /* brcth */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 686 /* brcth */, 2 /* 1 */, MCK_PCRel32, AMFBS_FeatureHighWord },
  { 686 /* brcth */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 686 /* brcth */, 2 /* 1 */, MCK_PCRel32, AMFBS_FeatureHighWord },
  { 692 /* brxh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 692 /* brxh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 692 /* brxh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 692 /* brxh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 697 /* brxhg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 697 /* brxhg */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 697 /* brxhg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 697 /* brxhg */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 703 /* brxle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 703 /* brxle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 703 /* brxle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 703 /* brxle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 709 /* brxlg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 709 /* brxlg */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 709 /* brxlg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 709 /* brxlg */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 715 /* bsa */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 715 /* bsa */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 719 /* bsg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 719 /* bsg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 723 /* bsm */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 723 /* bsm */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 723 /* bsm */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 723 /* bsm */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 727 /* bxh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 727 /* bxh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 727 /* bxh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 727 /* bxh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 731 /* bxhg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 731 /* bxhg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 731 /* bxhg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 731 /* bxhg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 736 /* bxle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 736 /* bxle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 736 /* bxle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 736 /* bxle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 741 /* bxleg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 741 /* bxleg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 741 /* bxleg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 741 /* bxleg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 747 /* bz */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 747 /* bz */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 750 /* bzr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 750 /* bzr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 754 /* c */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 754 /* c */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 754 /* c */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 754 /* c */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 756 /* cal */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 756 /* cal */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureConcurrentFunctions },
  { 756 /* cal */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 756 /* cal */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureConcurrentFunctions },
  { 760 /* calg */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 760 /* calg */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureConcurrentFunctions },
  { 760 /* calg */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 760 /* calg */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureConcurrentFunctions },
  { 765 /* calgf */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 765 /* calgf */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureConcurrentFunctions },
  { 765 /* calgf */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 765 /* calgf */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureConcurrentFunctions },
  { 771 /* cd */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 771 /* cd */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 771 /* cd */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 771 /* cd */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 774 /* cdb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 774 /* cdb */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 774 /* cdb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 774 /* cdb */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 778 /* cdbr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 778 /* cdbr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 783 /* cdfbr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 783 /* cdfbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 783 /* cdfbr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 783 /* cdfbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 789 /* cdfbra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 789 /* cdfbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 789 /* cdfbra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 789 /* cdfbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 796 /* cdfr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 796 /* cdfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 796 /* cdfr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 796 /* cdfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 801 /* cdftr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 801 /* cdftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 801 /* cdftr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 801 /* cdftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 807 /* cdgbr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 807 /* cdgbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 807 /* cdgbr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 807 /* cdgbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 813 /* cdgbra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 813 /* cdgbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 813 /* cdgbra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 813 /* cdgbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 820 /* cdgr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 820 /* cdgr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 820 /* cdgr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 820 /* cdgr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 825 /* cdgtr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 825 /* cdgtr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 825 /* cdgtr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 825 /* cdgtr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 831 /* cdgtra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 831 /* cdgtra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 831 /* cdgtra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 831 /* cdgtra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 838 /* cdlfbr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 838 /* cdlfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 838 /* cdlfbr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 838 /* cdlfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 845 /* cdlftr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 845 /* cdlftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 845 /* cdlftr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 845 /* cdlftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 852 /* cdlgbr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 852 /* cdlgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 852 /* cdlgbr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 852 /* cdlgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 859 /* cdlgtr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 859 /* cdlgtr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 859 /* cdlgtr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 859 /* cdlgtr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 866 /* cdpt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 866 /* cdpt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPPackedConversion },
  { 866 /* cdpt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 866 /* cdpt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPPackedConversion },
  { 871 /* cdr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 871 /* cdr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 875 /* cds */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 875 /* cds */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 875 /* cds */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 875 /* cds */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 879 /* cdsg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 879 /* cdsg */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 879 /* cdsg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 879 /* cdsg */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 884 /* cdstr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 884 /* cdstr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 884 /* cdstr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 884 /* cdstr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 890 /* cdsy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 890 /* cdsy */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 890 /* cdsy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 890 /* cdsy */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 895 /* cdtr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 895 /* cdtr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 900 /* cdutr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 900 /* cdutr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 900 /* cdutr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 900 /* cdutr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 906 /* cdzt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 906 /* cdzt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPZonedConversion },
  { 906 /* cdzt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 906 /* cdzt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPZonedConversion },
  { 911 /* ce */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 911 /* ce */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 911 /* ce */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 911 /* ce */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 914 /* ceb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 914 /* ceb */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 914 /* ceb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 914 /* ceb */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 918 /* cebr */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 918 /* cebr */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 923 /* cedtr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 923 /* cedtr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 929 /* cefbr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 929 /* cefbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 929 /* cefbr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 929 /* cefbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 935 /* cefbra */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 935 /* cefbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 935 /* cefbra */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 935 /* cefbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 942 /* cefr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 942 /* cefr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 942 /* cefr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 942 /* cefr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 947 /* cegbr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 947 /* cegbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 947 /* cegbr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 947 /* cegbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 953 /* cegbra */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 953 /* cegbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 953 /* cegbra */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 953 /* cegbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 960 /* cegr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 960 /* cegr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 960 /* cegr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 960 /* cegr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 965 /* celfbr */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 965 /* celfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 965 /* celfbr */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 965 /* celfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 972 /* celgbr */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 972 /* celgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 972 /* celgbr */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 972 /* celgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 979 /* cer */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 979 /* cer */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 983 /* cextr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 983 /* cextr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 989 /* cfc */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 989 /* cfc */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 993 /* cfdbr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 993 /* cfdbr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 993 /* cfdbr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 993 /* cfdbr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 999 /* cfdbra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 999 /* cfdbra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 999 /* cfdbra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 999 /* cfdbra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1006 /* cfdr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1006 /* cfdr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1006 /* cfdr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1006 /* cfdr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1011 /* cfdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1011 /* cfdtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1011 /* cfdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1011 /* cfdtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1017 /* cfebr */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1017 /* cfebr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1017 /* cfebr */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1017 /* cfebr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1023 /* cfebra */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 1023 /* cfebra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1023 /* cfebra */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 1023 /* cfebra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1030 /* cfer */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1030 /* cfer */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1030 /* cfer */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1030 /* cfer */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1035 /* cfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1035 /* cfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1039 /* cfxbr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1039 /* cfxbr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1039 /* cfxbr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1039 /* cfxbr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1045 /* cfxbra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1045 /* cfxbra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1045 /* cfxbra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1045 /* cfxbra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1052 /* cfxr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1052 /* cfxr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1052 /* cfxr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1052 /* cfxr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1057 /* cfxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1057 /* cfxtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1057 /* cfxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1057 /* cfxtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1063 /* cg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1063 /* cg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1063 /* cg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1063 /* cg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1066 /* cgdbr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1066 /* cgdbr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1066 /* cgdbr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1066 /* cgdbr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1072 /* cgdbra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1072 /* cgdbra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1072 /* cgdbra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1072 /* cgdbra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1079 /* cgdr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1079 /* cgdr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1079 /* cgdr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1079 /* cgdr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1084 /* cgdtr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1084 /* cgdtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1084 /* cgdtr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1084 /* cgdtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1090 /* cgdtra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1090 /* cgdtra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1090 /* cgdtra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1090 /* cgdtra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1097 /* cgebr */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1097 /* cgebr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1097 /* cgebr */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1097 /* cgebr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1103 /* cgebra */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 1103 /* cgebra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1103 /* cgebra */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 1103 /* cgebra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1110 /* cger */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1110 /* cger */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1110 /* cger */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1110 /* cger */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1115 /* cgf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1115 /* cgf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1115 /* cgf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1115 /* cgf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1119 /* cgfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1119 /* cgfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1124 /* cgfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 1124 /* cgfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1124 /* cgfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 1124 /* cgfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1129 /* cgfrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1129 /* cgfrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1129 /* cgfrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1129 /* cgfrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1135 /* cgh */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1135 /* cgh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1135 /* cgh */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1135 /* cgh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1139 /* cghi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1139 /* cghi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1144 /* cghrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1144 /* cghrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1144 /* cghrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1144 /* cghrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1150 /* cghsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1150 /* cghsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1156 /* cgib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1156 /* cgib */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1156 /* cgib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1156 /* cgib */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1161 /* cgibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1161 /* cgibe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1161 /* cgibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1161 /* cgibe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1167 /* cgibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1167 /* cgibh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1167 /* cgibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1167 /* cgibh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1173 /* cgibhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1173 /* cgibhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1180 /* cgibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1180 /* cgibl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1180 /* cgibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1180 /* cgibl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1186 /* cgible */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1186 /* cgible */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1193 /* cgiblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1193 /* cgiblh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1200 /* cgibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1200 /* cgibne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1200 /* cgibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1200 /* cgibne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1207 /* cgibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1207 /* cgibnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1207 /* cgibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1207 /* cgibnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1214 /* cgibnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1214 /* cgibnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1222 /* cgibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1222 /* cgibnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1222 /* cgibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1222 /* cgibnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1229 /* cgibnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1229 /* cgibnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1237 /* cgibnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1237 /* cgibnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1245 /* cgij */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1245 /* cgij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1245 /* cgij */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1245 /* cgij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1250 /* cgije */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1250 /* cgije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1250 /* cgije */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1250 /* cgije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1256 /* cgijh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1256 /* cgijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1256 /* cgijh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1256 /* cgijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1262 /* cgijhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1262 /* cgijhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1269 /* cgijl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1269 /* cgijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1269 /* cgijl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1269 /* cgijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1275 /* cgijle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1275 /* cgijle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1282 /* cgijlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1282 /* cgijlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1289 /* cgijne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1289 /* cgijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1289 /* cgijne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1289 /* cgijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1296 /* cgijnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1296 /* cgijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1296 /* cgijnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1296 /* cgijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1303 /* cgijnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1303 /* cgijnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1311 /* cgijnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1311 /* cgijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1311 /* cgijnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1311 /* cgijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1318 /* cgijnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1318 /* cgijnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1326 /* cgijnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1326 /* cgijnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1334 /* cgit */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1334 /* cgit */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1339 /* cgite */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1339 /* cgite */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1345 /* cgith */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1345 /* cgith */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1351 /* cgithe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1358 /* cgitl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1358 /* cgitl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1364 /* cgitle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1371 /* cgitlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1378 /* cgitne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1378 /* cgitne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1385 /* cgitnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1385 /* cgitnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1392 /* cgitnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1400 /* cgitnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1400 /* cgitnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1407 /* cgitnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1415 /* cgitnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1423 /* cgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1423 /* cgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1427 /* cgrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1427 /* cgrb */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1427 /* cgrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1427 /* cgrb */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1432 /* cgrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1432 /* cgrbe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1432 /* cgrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1432 /* cgrbe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1438 /* cgrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1438 /* cgrbh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1438 /* cgrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1438 /* cgrbh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1444 /* cgrbhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1444 /* cgrbhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1451 /* cgrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1451 /* cgrbl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1451 /* cgrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1451 /* cgrbl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1457 /* cgrble */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1457 /* cgrble */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1464 /* cgrblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1464 /* cgrblh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1471 /* cgrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1471 /* cgrbne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1471 /* cgrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1471 /* cgrbne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1478 /* cgrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1478 /* cgrbnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1478 /* cgrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1478 /* cgrbnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1485 /* cgrbnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1485 /* cgrbnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1493 /* cgrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1493 /* cgrbnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1493 /* cgrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1493 /* cgrbnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1500 /* cgrbnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1500 /* cgrbnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1508 /* cgrbnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1508 /* cgrbnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1516 /* cgrj */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1516 /* cgrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1516 /* cgrj */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1516 /* cgrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1521 /* cgrje */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1521 /* cgrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1521 /* cgrje */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1521 /* cgrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1527 /* cgrjh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1527 /* cgrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1527 /* cgrjh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1527 /* cgrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1533 /* cgrjhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1533 /* cgrjhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1540 /* cgrjl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1540 /* cgrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1540 /* cgrjl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1540 /* cgrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1546 /* cgrjle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1546 /* cgrjle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1553 /* cgrjlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1553 /* cgrjlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1560 /* cgrjne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1560 /* cgrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1560 /* cgrjne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1560 /* cgrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1567 /* cgrjnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1567 /* cgrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1567 /* cgrjnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1567 /* cgrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1574 /* cgrjnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1574 /* cgrjnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1582 /* cgrjnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1582 /* cgrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1582 /* cgrjnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1582 /* cgrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1589 /* cgrjnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1589 /* cgrjnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1597 /* cgrjnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1597 /* cgrjnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1605 /* cgrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1605 /* cgrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1605 /* cgrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1605 /* cgrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1610 /* cgrt */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1610 /* cgrt */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1615 /* cgrte */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1615 /* cgrte */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1621 /* cgrth */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1621 /* cgrth */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1627 /* cgrthe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1634 /* cgrtl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1634 /* cgrtl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1640 /* cgrtle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1647 /* cgrtlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1654 /* cgrtne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1654 /* cgrtne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1661 /* cgrtnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1661 /* cgrtnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1668 /* cgrtnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1676 /* cgrtnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1676 /* cgrtnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1683 /* cgrtnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1691 /* cgrtnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1699 /* cgxbr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1699 /* cgxbr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1699 /* cgxbr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1699 /* cgxbr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1705 /* cgxbra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1705 /* cgxbra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1705 /* cgxbra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1705 /* cgxbra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1712 /* cgxr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1712 /* cgxr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1712 /* cgxr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1712 /* cgxr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1717 /* cgxtr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1717 /* cgxtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1717 /* cgxtr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1717 /* cgxtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1723 /* cgxtra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1723 /* cgxtra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1723 /* cgxtra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1723 /* cgxtra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1730 /* ch */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 1730 /* ch */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1730 /* ch */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 1730 /* ch */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1733 /* chf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureHighWord },
  { 1733 /* chf */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1733 /* chf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureHighWord },
  { 1733 /* chf */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1737 /* chhr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1737 /* chhr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1742 /* chhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1742 /* chhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1748 /* chi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1748 /* chi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1752 /* chlr */, 2 /* 1 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 1752 /* chlr */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1752 /* chlr */, 2 /* 1 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 1752 /* chlr */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1757 /* chrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1757 /* chrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1757 /* chrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1757 /* chrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1762 /* chsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1762 /* chsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1767 /* chy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1767 /* chy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1767 /* chy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1767 /* chy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1771 /* cib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1771 /* cib */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1771 /* cib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1771 /* cib */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1775 /* cibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1775 /* cibe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1775 /* cibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1775 /* cibe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1780 /* cibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1780 /* cibh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1780 /* cibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1780 /* cibh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1785 /* cibhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1785 /* cibhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1791 /* cibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1791 /* cibl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1791 /* cibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1791 /* cibl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1796 /* cible */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1796 /* cible */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1802 /* ciblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1802 /* ciblh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1808 /* cibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1808 /* cibne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1808 /* cibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1808 /* cibne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1814 /* cibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1814 /* cibnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1814 /* cibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1814 /* cibnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1820 /* cibnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1820 /* cibnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1827 /* cibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1827 /* cibnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1827 /* cibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1827 /* cibnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1833 /* cibnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1833 /* cibnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1840 /* cibnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1840 /* cibnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1847 /* cih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1847 /* cih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1851 /* cij */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1851 /* cij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1851 /* cij */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1851 /* cij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1855 /* cije */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1855 /* cije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1855 /* cije */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1855 /* cije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1860 /* cijh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1860 /* cijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1860 /* cijh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1860 /* cijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1865 /* cijhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1865 /* cijhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1871 /* cijl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1871 /* cijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1871 /* cijl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1871 /* cijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1876 /* cijle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1876 /* cijle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1882 /* cijlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1882 /* cijlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1888 /* cijne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1888 /* cijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1888 /* cijne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1888 /* cijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1894 /* cijnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1894 /* cijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1894 /* cijnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1894 /* cijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1900 /* cijnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1900 /* cijnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1907 /* cijnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1907 /* cijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1907 /* cijnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1907 /* cijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1913 /* cijnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1913 /* cijnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1920 /* cijnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1920 /* cijnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1927 /* cit */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1927 /* cit */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1931 /* cite */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1931 /* cite */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1936 /* cith */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1936 /* cith */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1941 /* cithe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1947 /* citl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1947 /* citl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1952 /* citle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1958 /* citlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1964 /* citne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1964 /* citne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1970 /* citnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1970 /* citnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1976 /* citnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1983 /* citnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1983 /* citnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1989 /* citnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1996 /* citnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2003 /* cksm */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 2003 /* cksm */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2003 /* cksm */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 2003 /* cksm */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2008 /* cl */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 2008 /* cl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2008 /* cl */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 2008 /* cl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2011 /* clc */, 2 /* 1 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2011 /* clc */, 1 /* 0 */, MCK_BDLAddr64Disp12Len8, AMFBS_None },
  { 2011 /* clc */, 2 /* 1 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2011 /* clc */, 1 /* 0 */, MCK_BDLAddr64Disp12Len8, AMFBS_None },
  { 2015 /* clcl */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2015 /* clcl */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2020 /* clcle */, 4 /* 2 */, MCK_BDAddr32Disp12, AMFBS_None },
  { 2020 /* clcle */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2020 /* clcle */, 4 /* 2 */, MCK_BDAddr32Disp12, AMFBS_None },
  { 2020 /* clcle */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2026 /* clclu */, 4 /* 2 */, MCK_BDAddr32Disp20, AMFBS_None },
  { 2026 /* clclu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2026 /* clclu */, 4 /* 2 */, MCK_BDAddr32Disp20, AMFBS_None },
  { 2026 /* clclu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2032 /* clfdbr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2032 /* clfdbr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2032 /* clfdbr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2032 /* clfdbr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2039 /* clfdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2039 /* clfdtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2039 /* clfdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2039 /* clfdtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2046 /* clfebr */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 2046 /* clfebr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2046 /* clfebr */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 2046 /* clfebr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2053 /* clfhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2053 /* clfhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2060 /* clfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2060 /* clfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2065 /* clfit */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2065 /* clfit */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2071 /* clfite */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2071 /* clfite */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2078 /* clfith */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2078 /* clfith */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2085 /* clfithe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2093 /* clfitl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2093 /* clfitl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2100 /* clfitle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2108 /* clfitlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2116 /* clfitne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2116 /* clfitne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2124 /* clfitnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2124 /* clfitnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2132 /* clfitnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2141 /* clfitnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2141 /* clfitnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2149 /* clfitnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2158 /* clfitnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2167 /* clfxbr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2167 /* clfxbr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2167 /* clfxbr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2167 /* clfxbr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2174 /* clfxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2174 /* clfxtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2174 /* clfxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2174 /* clfxtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2181 /* clg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 2181 /* clg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2181 /* clg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 2181 /* clg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2185 /* clgdbr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2185 /* clgdbr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2185 /* clgdbr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2185 /* clgdbr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2192 /* clgdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2192 /* clgdtr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2192 /* clgdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2192 /* clgdtr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2199 /* clgebr */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 2199 /* clgebr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2199 /* clgebr */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 2199 /* clgebr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2206 /* clgf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 2206 /* clgf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2206 /* clgf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 2206 /* clgf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2211 /* clgfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2211 /* clgfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2217 /* clgfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 2217 /* clgfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2217 /* clgfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 2217 /* clgfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2223 /* clgfrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2223 /* clgfrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2223 /* clgfrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2223 /* clgfrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2230 /* clghrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2230 /* clghrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2230 /* clghrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2230 /* clghrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2237 /* clghsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2237 /* clghsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2244 /* clgib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2244 /* clgib */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2244 /* clgib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2244 /* clgib */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2250 /* clgibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2250 /* clgibe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2250 /* clgibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2250 /* clgibe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2257 /* clgibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2257 /* clgibh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2257 /* clgibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2257 /* clgibh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2264 /* clgibhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2264 /* clgibhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2272 /* clgibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2272 /* clgibl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2272 /* clgibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2272 /* clgibl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2279 /* clgible */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2279 /* clgible */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2287 /* clgiblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2287 /* clgiblh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2295 /* clgibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2295 /* clgibne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2295 /* clgibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2295 /* clgibne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2303 /* clgibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2303 /* clgibnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2303 /* clgibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2303 /* clgibnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2311 /* clgibnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2311 /* clgibnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2320 /* clgibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2320 /* clgibnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2320 /* clgibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2320 /* clgibnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2328 /* clgibnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2328 /* clgibnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2337 /* clgibnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2337 /* clgibnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2346 /* clgij */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2346 /* clgij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 2346 /* clgij */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2346 /* clgij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 2352 /* clgije */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2352 /* clgije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2352 /* clgije */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2352 /* clgije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2359 /* clgijh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2359 /* clgijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2359 /* clgijh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2359 /* clgijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2366 /* clgijhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2366 /* clgijhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2374 /* clgijl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2374 /* clgijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2374 /* clgijl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2374 /* clgijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2381 /* clgijle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2381 /* clgijle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2389 /* clgijlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2389 /* clgijlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2397 /* clgijne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2397 /* clgijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2397 /* clgijne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2397 /* clgijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2405 /* clgijnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2405 /* clgijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2405 /* clgijnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2405 /* clgijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2413 /* clgijnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2413 /* clgijnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2422 /* clgijnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2422 /* clgijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2422 /* clgijnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2422 /* clgijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2430 /* clgijnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2430 /* clgijnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2439 /* clgijnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2439 /* clgijnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2448 /* clgit */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2448 /* clgit */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2454 /* clgite */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2454 /* clgite */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2461 /* clgith */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2461 /* clgith */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2468 /* clgithe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2476 /* clgitl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2476 /* clgitl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2483 /* clgitle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2491 /* clgitlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2499 /* clgitne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2499 /* clgitne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2507 /* clgitnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2507 /* clgitnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2515 /* clgitnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2524 /* clgitnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2524 /* clgitnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2532 /* clgitnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2541 /* clgitnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2550 /* clgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2550 /* clgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2555 /* clgrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2555 /* clgrb */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2555 /* clgrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2555 /* clgrb */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2561 /* clgrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2561 /* clgrbe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2561 /* clgrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2561 /* clgrbe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2568 /* clgrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2568 /* clgrbh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2568 /* clgrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2568 /* clgrbh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2575 /* clgrbhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2575 /* clgrbhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2583 /* clgrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2583 /* clgrbl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2583 /* clgrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2583 /* clgrbl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2590 /* clgrble */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2590 /* clgrble */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2598 /* clgrblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2598 /* clgrblh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2606 /* clgrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2606 /* clgrbne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2606 /* clgrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2606 /* clgrbne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2614 /* clgrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2614 /* clgrbnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2614 /* clgrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2614 /* clgrbnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2622 /* clgrbnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2622 /* clgrbnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2631 /* clgrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2631 /* clgrbnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2631 /* clgrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2631 /* clgrbnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2639 /* clgrbnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2639 /* clgrbnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2648 /* clgrbnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2648 /* clgrbnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2657 /* clgrj */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2657 /* clgrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 2657 /* clgrj */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2657 /* clgrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 2663 /* clgrje */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2663 /* clgrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2663 /* clgrje */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2663 /* clgrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2670 /* clgrjh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2670 /* clgrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2670 /* clgrjh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2670 /* clgrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2677 /* clgrjhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2677 /* clgrjhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2685 /* clgrjl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2685 /* clgrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2685 /* clgrjl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2685 /* clgrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2692 /* clgrjle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2692 /* clgrjle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2700 /* clgrjlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2700 /* clgrjlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2708 /* clgrjne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2708 /* clgrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2708 /* clgrjne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2708 /* clgrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2716 /* clgrjnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2716 /* clgrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2716 /* clgrjnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2716 /* clgrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2724 /* clgrjnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2724 /* clgrjnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2733 /* clgrjnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2733 /* clgrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2733 /* clgrjnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2733 /* clgrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2741 /* clgrjnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2741 /* clgrjnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2750 /* clgrjnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2750 /* clgrjnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2759 /* clgrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2759 /* clgrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2759 /* clgrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2759 /* clgrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2765 /* clgrt */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2765 /* clgrt */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2771 /* clgrte */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2771 /* clgrte */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2778 /* clgrth */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2778 /* clgrth */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2785 /* clgrthe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2793 /* clgrtl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2793 /* clgrtl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2800 /* clgrtle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2808 /* clgrtlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2816 /* clgrtne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2816 /* clgrtne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2824 /* clgrtnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2824 /* clgrtnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2832 /* clgrtnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2841 /* clgrtnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2841 /* clgrtnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2849 /* clgrtnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2858 /* clgrtnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2867 /* clgt */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2867 /* clgt */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2867 /* clgt */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2867 /* clgt */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2872 /* clgte */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2872 /* clgte */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2872 /* clgte */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2872 /* clgte */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2878 /* clgth */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2878 /* clgth */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2878 /* clgth */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2878 /* clgth */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2884 /* clgthe */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2884 /* clgthe */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2891 /* clgtl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2891 /* clgtl */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2891 /* clgtl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2891 /* clgtl */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2897 /* clgtle */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2897 /* clgtle */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2904 /* clgtlh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2904 /* clgtlh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2911 /* clgtne */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2911 /* clgtne */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2911 /* clgtne */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2911 /* clgtne */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2918 /* clgtnh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2918 /* clgtnh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2918 /* clgtnh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2918 /* clgtnh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2925 /* clgtnhe */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2925 /* clgtnhe */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2933 /* clgtnl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2933 /* clgtnl */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2933 /* clgtnl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2933 /* clgtnl */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2940 /* clgtnle */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2940 /* clgtnle */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2948 /* clgtnlh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2948 /* clgtnlh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2956 /* clgxbr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2956 /* clgxbr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2956 /* clgxbr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2956 /* clgxbr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2963 /* clgxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2963 /* clgxtr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2963 /* clgxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2963 /* clgxtr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2970 /* clhf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureHighWord },
  { 2970 /* clhf */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2970 /* clhf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureHighWord },
  { 2970 /* clhf */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2975 /* clhhr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2975 /* clhhr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2981 /* clhhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2981 /* clhhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2988 /* clhlr */, 2 /* 1 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 2988 /* clhlr */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2988 /* clhlr */, 2 /* 1 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 2988 /* clhlr */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2994 /* clhrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2994 /* clhrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2994 /* clhrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2994 /* clhrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 3000 /* cli */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3000 /* cli */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3004 /* clib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3004 /* clib */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3004 /* clib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3004 /* clib */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3009 /* clibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3009 /* clibe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3009 /* clibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3009 /* clibe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3015 /* clibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3015 /* clibh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3015 /* clibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3015 /* clibh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3021 /* clibhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3021 /* clibhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3028 /* clibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3028 /* clibl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3028 /* clibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3028 /* clibl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3034 /* clible */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3034 /* clible */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3041 /* cliblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3041 /* cliblh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3048 /* clibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3048 /* clibne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3048 /* clibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3048 /* clibne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3055 /* clibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3055 /* clibnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3055 /* clibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3055 /* clibnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3062 /* clibnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3062 /* clibnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3070 /* clibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3070 /* clibnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3070 /* clibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3070 /* clibnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3077 /* clibnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3077 /* clibnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3085 /* clibnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3085 /* clibnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3093 /* clih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 3093 /* clih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 3098 /* clij */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3098 /* clij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3098 /* clij */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3098 /* clij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3103 /* clije */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3103 /* clije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3103 /* clije */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3103 /* clije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3109 /* clijh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3109 /* clijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3109 /* clijh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3109 /* clijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3115 /* clijhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3115 /* clijhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3122 /* clijl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3122 /* clijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3122 /* clijl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3122 /* clijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3128 /* clijle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3128 /* clijle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3135 /* clijlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3135 /* clijlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3142 /* clijne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3142 /* clijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3142 /* clijne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3142 /* clijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3149 /* clijnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3149 /* clijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3149 /* clijnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3149 /* clijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3156 /* clijnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3156 /* clijnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3164 /* clijnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3164 /* clijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3164 /* clijnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3164 /* clijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3171 /* clijnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3171 /* clijnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3179 /* clijnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3179 /* clijnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3187 /* cliy */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3187 /* cliy */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3192 /* clm */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3192 /* clm */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3192 /* clm */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3192 /* clm */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3196 /* clmh */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3196 /* clmh */, 1 /* 0 */, MCK_GRH32, AMFBS_None },
  { 3196 /* clmh */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3196 /* clmh */, 1 /* 0 */, MCK_GRH32, AMFBS_None },
  { 3201 /* clmy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3201 /* clmy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3201 /* clmy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3201 /* clmy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3206 /* clr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3206 /* clr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3210 /* clrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3210 /* clrb */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3210 /* clrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3210 /* clrb */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3215 /* clrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3215 /* clrbe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3215 /* clrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3215 /* clrbe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3221 /* clrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3221 /* clrbh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3221 /* clrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3221 /* clrbh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3227 /* clrbhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3227 /* clrbhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3234 /* clrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3234 /* clrbl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3234 /* clrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3234 /* clrbl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3240 /* clrble */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3240 /* clrble */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3247 /* clrblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3247 /* clrblh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3254 /* clrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3254 /* clrbne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3254 /* clrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3254 /* clrbne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3261 /* clrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3261 /* clrbnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3261 /* clrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3261 /* clrbnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3268 /* clrbnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3268 /* clrbnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3276 /* clrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3276 /* clrbnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3276 /* clrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3276 /* clrbnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3283 /* clrbnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3283 /* clrbnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3291 /* clrbnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3291 /* clrbnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3299 /* clrj */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3299 /* clrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3299 /* clrj */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3299 /* clrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3304 /* clrje */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3304 /* clrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3304 /* clrje */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3304 /* clrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3310 /* clrjh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3310 /* clrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3310 /* clrjh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3310 /* clrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3316 /* clrjhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3316 /* clrjhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3323 /* clrjl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3323 /* clrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3323 /* clrjl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3323 /* clrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3329 /* clrjle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3329 /* clrjle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3336 /* clrjlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3336 /* clrjlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3343 /* clrjne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3343 /* clrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3343 /* clrjne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3343 /* clrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3350 /* clrjnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3350 /* clrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3350 /* clrjnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3350 /* clrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3357 /* clrjnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3357 /* clrjnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3365 /* clrjnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3365 /* clrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3365 /* clrjnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3365 /* clrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3372 /* clrjnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3372 /* clrjnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3380 /* clrjnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3380 /* clrjnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3388 /* clrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3388 /* clrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 3388 /* clrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3388 /* clrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 3393 /* clrt */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3393 /* clrt */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3398 /* clrte */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3398 /* clrte */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3404 /* clrth */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3404 /* clrth */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3410 /* clrthe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3417 /* clrtl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3417 /* clrtl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3423 /* clrtle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3430 /* clrtlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3437 /* clrtne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3437 /* clrtne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3444 /* clrtnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3444 /* clrtnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3451 /* clrtnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3459 /* clrtnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3459 /* clrtnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3466 /* clrtnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3474 /* clrtnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3482 /* clst */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 3482 /* clst */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 3487 /* clt */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3487 /* clt */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3487 /* clt */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3487 /* clt */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3491 /* clte */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3491 /* clte */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3491 /* clte */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3491 /* clte */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3496 /* clth */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3496 /* clth */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3496 /* clth */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3496 /* clth */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3501 /* clthe */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3501 /* clthe */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3507 /* cltl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3507 /* cltl */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3507 /* cltl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3507 /* cltl */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3512 /* cltle */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3512 /* cltle */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3518 /* cltlh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3518 /* cltlh */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3524 /* cltne */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3524 /* cltne */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3524 /* cltne */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3524 /* cltne */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3530 /* cltnh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3530 /* cltnh */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3530 /* cltnh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3530 /* cltnh */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3536 /* cltnhe */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3536 /* cltnhe */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3543 /* cltnl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3543 /* cltnl */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3543 /* cltnl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3543 /* cltnl */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3549 /* cltnle */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3549 /* cltnle */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3556 /* cltnlh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3556 /* cltnlh */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3563 /* cly */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3563 /* cly */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3563 /* cly */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3563 /* cly */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3567 /* clzg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 3567 /* clzg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 3572 /* cmpsc */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3572 /* cmpsc */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3578 /* cp */, 3 /* 0, 1 */, MCK_BDLAddr64Disp12Len4, AMFBS_None },
  { 3578 /* cp */, 3 /* 0, 1 */, MCK_BDLAddr64Disp12Len4, AMFBS_None },
  { 3581 /* cpdt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 3581 /* cpdt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPPackedConversion },
  { 3581 /* cpdt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 3581 /* cpdt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPPackedConversion },
  { 3586 /* cpsdr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 3586 /* cpsdr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 3592 /* cpxt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 3592 /* cpxt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPPackedConversion },
  { 3592 /* cpxt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 3592 /* cpxt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPPackedConversion },
  { 3597 /* cpya */, 3 /* 0, 1 */, MCK_AR32, AMFBS_None },
  { 3597 /* cpya */, 3 /* 0, 1 */, MCK_AR32, AMFBS_None },
  { 3602 /* cr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3602 /* cr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3605 /* crb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3605 /* crb */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3605 /* crb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3605 /* crb */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3609 /* crbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3609 /* crbe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3609 /* crbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3609 /* crbe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3614 /* crbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3614 /* crbh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3614 /* crbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3614 /* crbh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3619 /* crbhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3619 /* crbhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3625 /* crbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3625 /* crbl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3625 /* crbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3625 /* crbl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3630 /* crble */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3630 /* crble */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3636 /* crblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3636 /* crblh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3642 /* crbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3642 /* crbne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3642 /* crbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3642 /* crbne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3648 /* crbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3648 /* crbnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3648 /* crbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3648 /* crbnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3654 /* crbnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3654 /* crbnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3661 /* crbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3661 /* crbnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3661 /* crbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3661 /* crbnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3667 /* crbnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3667 /* crbnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3674 /* crbnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3674 /* crbnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3681 /* crdte */, 5 /* 0, 2 */, MCK_GR128, AMFBS_FeatureEnhancedDAT2 },
  { 3681 /* crdte */, 2 /* 1 */, MCK_GR64, AMFBS_FeatureEnhancedDAT2 },
  { 3681 /* crdte */, 5 /* 0, 2 */, MCK_GR128, AMFBS_FeatureEnhancedDAT2 },
  { 3681 /* crdte */, 2 /* 1 */, MCK_GR64, AMFBS_FeatureEnhancedDAT2 },
  { 3681 /* crdte */, 5 /* 0, 2 */, MCK_GR128, AMFBS_FeatureEnhancedDAT2 },
  { 3681 /* crdte */, 2 /* 1 */, MCK_GR64, AMFBS_FeatureEnhancedDAT2 },
  { 3681 /* crdte */, 5 /* 0, 2 */, MCK_GR128, AMFBS_FeatureEnhancedDAT2 },
  { 3681 /* crdte */, 2 /* 1 */, MCK_GR64, AMFBS_FeatureEnhancedDAT2 },
  { 3687 /* crj */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3687 /* crj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3687 /* crj */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3687 /* crj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3691 /* crje */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3691 /* crje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3691 /* crje */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3691 /* crje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3696 /* crjh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3696 /* crjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3696 /* crjh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3696 /* crjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3701 /* crjhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3701 /* crjhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3707 /* crjl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3707 /* crjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3707 /* crjl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3707 /* crjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3712 /* crjle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3712 /* crjle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3718 /* crjlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3718 /* crjlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3724 /* crjne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3724 /* crjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3724 /* crjne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3724 /* crjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3730 /* crjnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3730 /* crjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3730 /* crjnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3730 /* crjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3736 /* crjnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3736 /* crjnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3743 /* crjnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3743 /* crjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3743 /* crjnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3743 /* crjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3749 /* crjnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3749 /* crjnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3756 /* crjnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3756 /* crjnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3763 /* crl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3763 /* crl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 3763 /* crl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3763 /* crl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 3767 /* crt */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3767 /* crt */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3771 /* crte */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3771 /* crte */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3776 /* crth */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3776 /* crth */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3781 /* crthe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3787 /* crtl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3787 /* crtl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3792 /* crtle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3798 /* crtlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3804 /* crtne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3804 /* crtne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3810 /* crtnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3810 /* crtnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3816 /* crtnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3823 /* crtnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3823 /* crtnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3829 /* crtnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3836 /* crtnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3843 /* cs */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3843 /* cs */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3843 /* cs */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3843 /* cs */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3851 /* csdtr */, 2 /* 1 */, MCK_FP64, AMFBS_None },
  { 3851 /* csdtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3851 /* csdtr */, 2 /* 1 */, MCK_FP64, AMFBS_None },
  { 3851 /* csdtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3857 /* csg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3857 /* csg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 3857 /* csg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3857 /* csg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 3861 /* csp */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3861 /* csp */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 3861 /* csp */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3861 /* csp */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 3865 /* cspg */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3865 /* cspg */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 3865 /* cspg */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3865 /* cspg */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 3870 /* csst */, 3 /* 0, 1 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3870 /* csst */, 4 /* 2 */, MCK_GR64, AMFBS_None },
  { 3870 /* csst */, 3 /* 0, 1 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3870 /* csst */, 4 /* 2 */, MCK_GR64, AMFBS_None },
  { 3875 /* csxtr */, 2 /* 1 */, MCK_FP128, AMFBS_None },
  { 3875 /* csxtr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3875 /* csxtr */, 2 /* 1 */, MCK_FP128, AMFBS_None },
  { 3875 /* csxtr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3881 /* csy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3881 /* csy */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3881 /* csy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3881 /* csy */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3885 /* ctzg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 3885 /* ctzg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 3890 /* cu12 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3890 /* cu12 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3890 /* cu12 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3890 /* cu12 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3895 /* cu14 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3895 /* cu14 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3895 /* cu14 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3895 /* cu14 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3900 /* cu21 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3900 /* cu21 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3900 /* cu21 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3900 /* cu21 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3905 /* cu24 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3905 /* cu24 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3905 /* cu24 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3905 /* cu24 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3910 /* cu41 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3910 /* cu41 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3915 /* cu42 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3915 /* cu42 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3920 /* cudtr */, 2 /* 1 */, MCK_FP64, AMFBS_None },
  { 3920 /* cudtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3920 /* cudtr */, 2 /* 1 */, MCK_FP64, AMFBS_None },
  { 3920 /* cudtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3926 /* cuse */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3926 /* cuse */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3931 /* cutfu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3931 /* cutfu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3931 /* cutfu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3931 /* cutfu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3937 /* cuutf */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3937 /* cuutf */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3937 /* cuutf */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3937 /* cuutf */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3943 /* cuxtr */, 2 /* 1 */, MCK_FP128, AMFBS_None },
  { 3943 /* cuxtr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3943 /* cuxtr */, 2 /* 1 */, MCK_FP128, AMFBS_None },
  { 3943 /* cuxtr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3949 /* cvb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 3949 /* cvb */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3949 /* cvb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 3949 /* cvb */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3953 /* cvbg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3953 /* cvbg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3953 /* cvbg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3953 /* cvbg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3958 /* cvby */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3958 /* cvby */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3958 /* cvby */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3958 /* cvby */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3963 /* cvd */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 3963 /* cvd */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3963 /* cvd */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 3963 /* cvd */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3967 /* cvdg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3967 /* cvdg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3967 /* cvdg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3967 /* cvdg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3972 /* cvdy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3972 /* cvdy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3972 /* cvdy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3972 /* cvdy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3977 /* cxbr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 3977 /* cxbr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 3982 /* cxfbr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 3982 /* cxfbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 3982 /* cxfbr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 3982 /* cxfbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 3988 /* cxfbra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 3988 /* cxfbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 3988 /* cxfbra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 3988 /* cxfbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 3995 /* cxfr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 3995 /* cxfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 3995 /* cxfr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 3995 /* cxfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 4000 /* cxftr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4000 /* cxftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4000 /* cxftr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4000 /* cxftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4006 /* cxgbr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4006 /* cxgbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4006 /* cxgbr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4006 /* cxgbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4012 /* cxgbra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4012 /* cxgbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4012 /* cxgbra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4012 /* cxgbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4019 /* cxgr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4019 /* cxgr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4019 /* cxgr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4019 /* cxgr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4024 /* cxgtr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4024 /* cxgtr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4024 /* cxgtr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4024 /* cxgtr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4030 /* cxgtra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4030 /* cxgtra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4030 /* cxgtra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4030 /* cxgtra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4037 /* cxlfbr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4037 /* cxlfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4037 /* cxlfbr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4037 /* cxlfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4044 /* cxlftr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4044 /* cxlftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4044 /* cxlftr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4044 /* cxlftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4051 /* cxlgbr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4051 /* cxlgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4051 /* cxlgbr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4051 /* cxlgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4058 /* cxlgtr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4058 /* cxlgtr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4058 /* cxlgtr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4058 /* cxlgtr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4065 /* cxpt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 4065 /* cxpt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPPackedConversion },
  { 4065 /* cxpt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 4065 /* cxpt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPPackedConversion },
  { 4070 /* cxr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 4070 /* cxr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 4074 /* cxstr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4074 /* cxstr */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 4074 /* cxstr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4074 /* cxstr */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 4080 /* cxtr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 4080 /* cxtr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 4085 /* cxutr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4085 /* cxutr */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 4085 /* cxutr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4085 /* cxutr */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 4091 /* cxzt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 4091 /* cxzt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPZonedConversion },
  { 4091 /* cxzt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 4091 /* cxzt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPZonedConversion },
  { 4096 /* cy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4096 /* cy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 4096 /* cy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4096 /* cy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 4099 /* czdt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 4099 /* czdt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPZonedConversion },
  { 4099 /* czdt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 4099 /* czdt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPZonedConversion },
  { 4104 /* czxt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 4104 /* czxt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPZonedConversion },
  { 4104 /* czxt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 4104 /* czxt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPZonedConversion },
  { 4109 /* d */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 4109 /* d */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4109 /* d */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 4109 /* d */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4111 /* dd */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 4111 /* dd */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 4111 /* dd */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 4111 /* dd */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 4114 /* ddb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 4114 /* ddb */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 4114 /* ddb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 4114 /* ddb */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 4118 /* ddbr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 4118 /* ddbr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 4123 /* ddr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 4123 /* ddr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 4127 /* ddtr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 4127 /* ddtr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 4132 /* ddtra */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 4132 /* ddtra */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 4138 /* de */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 4138 /* de */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 4138 /* de */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 4138 /* de */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 4141 /* deb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 4141 /* deb */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 4141 /* deb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 4141 /* deb */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 4145 /* debr */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 4145 /* debr */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 4150 /* der */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 4150 /* der */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 4154 /* dfltcc */, 3 /* 0, 1 */, MCK_GR128, AMFBS_FeatureDeflateConversion },
  { 4154 /* dfltcc */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureDeflateConversion },
  { 4154 /* dfltcc */, 3 /* 0, 1 */, MCK_GR128, AMFBS_FeatureDeflateConversion },
  { 4154 /* dfltcc */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureDeflateConversion },
  { 4161 /* diag */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 4161 /* diag */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 4161 /* diag */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 4161 /* diag */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 4166 /* didbr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 4166 /* didbr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 4172 /* diebr */, 7 /* 0, 1, 2 */, MCK_FP32, AMFBS_None },
  { 4172 /* diebr */, 7 /* 0, 1, 2 */, MCK_FP32, AMFBS_None },
  { 4178 /* dl */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4178 /* dl */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4178 /* dl */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4178 /* dl */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4181 /* dlg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4181 /* dlg */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4181 /* dlg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4181 /* dlg */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4185 /* dlgr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4185 /* dlgr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4185 /* dlgr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4185 /* dlgr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4190 /* dlr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4190 /* dlr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 4190 /* dlr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4190 /* dlr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 4194 /* dp */, 3 /* 0, 1 */, MCK_BDLAddr64Disp12Len4, AMFBS_None },
  { 4194 /* dp */, 3 /* 0, 1 */, MCK_BDLAddr64Disp12Len4, AMFBS_None },
  { 4197 /* dr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4197 /* dr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 4197 /* dr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4197 /* dr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 4200 /* dsg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4200 /* dsg */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4200 /* dsg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4200 /* dsg */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4204 /* dsgf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4204 /* dsgf */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4204 /* dsgf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4204 /* dsgf */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4209 /* dsgfr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 4209 /* dsgfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 4209 /* 