/*
 * Copyright 2022, Oak Ridge National Laboratory.
 * MGARD-X: MultiGrid Adaptive Reduction of Data Portable across GPUs and CPUs
 * Author: Jieyang Chen (chenj3@ornl.gov)
 * Date: March 17, 2022
 */

#include "mgard-x/DataRefactoring/SingleDimension/Coefficient/CoefficientsRestore.hpp"
// clang-format off
namespace mgard_x {

namespace data_refactoring {

namespace single_dimension {

template void CoefficientsRestore<5, double, SERIAL>(
    DIM current_dim, SubArray<1, double, SERIAL> ratio,
    SubArray<5, double, SERIAL> v,
    SubArray<5, double, SERIAL> coarse,
    SubArray<5, double, SERIAL> coeff, int queue_idx);

} // namespace single_dimension

} // namespace data_refactoring

} // namespace mgard_x
// clang-format on
