// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func CopyOrigLinkSlice(dest, src []*otlpprofiles.Link) []*otlpprofiles.Link {
	var newDest []*otlpprofiles.Link
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.Link, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigLink()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigLink(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigLink()
		}
	}
	for i := range src {
		CopyOrigLink(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestLinkSlice() []*otlpprofiles.Link {
	orig := make([]*otlpprofiles.Link, 5)
	orig[0] = NewOrigLink()
	orig[1] = GenTestOrigLink()
	orig[2] = NewOrigLink()
	orig[3] = GenTestOrigLink()
	orig[4] = NewOrigLink()
	return orig
}
