/* Stickers.c generated by valac 0.56.18, the Vala compiler
 * generated from Stickers.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <libxml/tree.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_STICKERS (stickers_get_type ())
#define STICKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STICKERS, Stickers))
#define STICKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STICKERS, StickersClass))
#define IS_STICKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STICKERS))
#define IS_STICKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STICKERS))
#define STICKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STICKERS, StickersClass))

typedef struct _Stickers Stickers;
typedef struct _StickersClass StickersClass;
typedef struct _StickersPrivate StickersPrivate;

#define TYPE_STICKER (sticker_get_type ())
#define STICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STICKER, Sticker))
#define STICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STICKER, StickerClass))
#define IS_STICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STICKER))
#define IS_STICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STICKER))
#define STICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STICKER, StickerClass))

typedef struct _Sticker Sticker;
typedef struct _StickerClass StickerClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _sticker_unref0(var) ((var == NULL) ? NULL : (var = (sticker_unref (var), NULL)))

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
typedef struct _ParamSpecStickers ParamSpecStickers;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Stickers {
	GTypeInstance parent_instance;
	volatile int ref_count;
	StickersPrivate * priv;
};

struct _StickersClass {
	GTypeClass parent_class;
	void (*finalize) (Stickers *self);
};

struct _StickersPrivate {
	GArray* _stickers;
};

struct _ParamSpecStickers {
	GParamSpec parent_instance;
};

static gint Stickers_private_offset;
static gpointer stickers_parent_class = NULL;

VALA_EXTERN gpointer stickers_ref (gpointer instance);
VALA_EXTERN void stickers_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_stickers (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_stickers (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_stickers (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_stickers (const GValue* value);
VALA_EXTERN GType stickers_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Stickers, stickers_unref)
VALA_EXTERN gpointer sticker_ref (gpointer instance);
VALA_EXTERN void sticker_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_sticker (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_sticker (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_sticker (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_sticker (const GValue* value);
VALA_EXTERN GType sticker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sticker, sticker_unref)
VALA_EXTERN Stickers* stickers_new (void);
VALA_EXTERN Stickers* stickers_construct (GType object_type);
static void _sticker_unref0_ (gpointer var);
static void _vala_Sticker_free_function_content_of (gpointer data);
VALA_EXTERN void stickers_clear (Stickers* self);
VALA_EXTERN void stickers_add_sticker (Stickers* self,
                           Sticker* sticker);
VALA_EXTERN void stickers_remove_sticker (Stickers* self,
                              Sticker* sticker);
VALA_EXTERN void stickers_select_sticker (Stickers* self,
                              Sticker* sticker);
VALA_EXTERN Sticker* stickers_is_within (Stickers* self,
                             gdouble x,
                             gdouble y);
VALA_EXTERN gboolean utils_is_within_bounds (gdouble x,
                                 gdouble y,
                                 gdouble bx,
                                 gdouble by,
                                 gdouble bw,
                                 gdouble bh);
VALA_EXTERN gdouble sticker_get_posx (Sticker* self);
VALA_EXTERN gdouble sticker_get_posy (Sticker* self);
VALA_EXTERN gdouble sticker_get_width (Sticker* self);
VALA_EXTERN gdouble sticker_get_height (Sticker* self);
VALA_EXTERN void stickers_add_extents (Stickers* self,
                           gdouble* x1,
                           gdouble* y1,
                           gdouble* x2,
                           gdouble* y2);
VALA_EXTERN xmlNode* stickers_save (Stickers* self);
VALA_EXTERN xmlNode* sticker_save (Sticker* self);
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN void stickers_load (Stickers* self,
                    DrawArea* da,
                    xmlNode* n);
VALA_EXTERN Sticker* sticker_new_from_xml (DrawArea* da,
                               xmlNode* n);
VALA_EXTERN Sticker* sticker_construct_from_xml (GType object_type,
                                     DrawArea* da,
                                     xmlNode* n);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN void stickers_draw_all (Stickers* self,
                        cairo_t* ctx,
                        Theme* theme,
                        gdouble opacity,
                        gboolean exporting);
VALA_EXTERN void sticker_draw (Sticker* self,
                   cairo_t* ctx,
                   Theme* theme,
                   gdouble opacity,
                   gboolean exporting);
static void stickers_finalize (Stickers * obj);
static GType stickers_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
stickers_get_instance_private (Stickers* self)
{
	return G_STRUCT_MEMBER_P (self, Stickers_private_offset);
}

static void
_sticker_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (sticker_unref (var), NULL));
}

static void
_vala_Sticker_free_function_content_of (gpointer data)
{
	Sticker* self;
	self = *((Sticker**) data);
	_sticker_unref0_ (self);
}

Stickers*
stickers_construct (GType object_type)
{
	Stickers* self = NULL;
	GArray* _tmp0_;
	self = (Stickers*) g_type_create_instance (object_type);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (Sticker*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_Sticker_free_function_content_of);
	_g_array_unref0 (self->priv->_stickers);
	self->priv->_stickers = _tmp0_;
	return self;
}

Stickers*
stickers_new (void)
{
	return stickers_construct (TYPE_STICKERS);
}

static gpointer*
vala_g_array_remove_range (GArray* self,
                           guint index,
                           guint length,
                           gint* result_length1)
{
	gpointer* ga = NULL;
	gpointer* _tmp0_;
	gint ga_length1;
	gint _ga_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len >= (index + length), "this.length >= index + length");
	_tmp0_ = g_new0 (gpointer, length);
	ga = _tmp0_;
	ga_length1 = length;
	_ga_size_ = ga_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = ga;
				_tmp3__length1 = ga_length1;
				_tmp4_ = self->data;
				_tmp4__length1 = self->len;
				_tmp5_ = _tmp4_[i + index];
				_tmp4_[i + index] = NULL;
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	g_array_remove_range (self, index, length);
	_tmp6_ = ga;
	_tmp6__length1 = ga_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

void
stickers_clear (Stickers* self)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	Sticker** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_stickers;
	_tmp1_ = self->priv->_stickers;
	_tmp3_ = vala_g_array_remove_range (_tmp0_, (guint) 0, _tmp1_->len, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) sticker_unref), NULL);
}

static gpointer
_sticker_ref0 (gpointer self)
{
	return self ? sticker_ref (self) : NULL;
}

void
stickers_add_sticker (Stickers* self,
                      Sticker* sticker)
{
	GArray* _tmp0_;
	Sticker* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sticker != NULL);
	_tmp0_ = self->priv->_stickers;
	_tmp1_ = _sticker_ref0 (sticker);
	g_array_append_val (_tmp0_, _tmp1_);
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

void
stickers_remove_sticker (Stickers* self,
                         Sticker* sticker)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (sticker != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Sticker* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_stickers;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_stickers;
				_tmp4_ = g_array_index (_tmp3_, Sticker*, (guint) i);
				if (_tmp4_ == sticker) {
					GArray* _tmp5_;
					Sticker* _tmp6_;
					Sticker* _tmp7_;
					_tmp5_ = self->priv->_stickers;
					_tmp6_ = vala_g_array_remove_index (_tmp5_, (guint) i);
					_tmp7_ = _tmp6_;
					_sticker_unref0 (_tmp7_);
					return;
				}
			}
		}
	}
}

void
stickers_select_sticker (Stickers* self,
                         Sticker* sticker)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (sticker != NULL);
	stickers_remove_sticker (self, sticker);
	stickers_add_sticker (self, sticker);
}

Sticker*
stickers_is_within (Stickers* self,
                    gdouble x,
                    gdouble y)
{
	Sticker* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i = 0;
		GArray* _tmp0_;
		_tmp0_ = self->priv->_stickers;
		i = (gint) (_tmp0_->len - 1);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				Sticker* s = NULL;
				GArray* _tmp3_;
				Sticker* _tmp4_;
				Sticker* _tmp5_;
				Sticker* _tmp6_;
				gdouble _tmp7_;
				gdouble _tmp8_;
				Sticker* _tmp9_;
				gdouble _tmp10_;
				gdouble _tmp11_;
				Sticker* _tmp12_;
				gdouble _tmp13_;
				gdouble _tmp14_;
				Sticker* _tmp15_;
				gdouble _tmp16_;
				gdouble _tmp17_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp3_ = self->priv->_stickers;
				_tmp4_ = g_array_index (_tmp3_, Sticker*, (guint) i);
				_tmp5_ = _sticker_ref0 (_tmp4_);
				s = _tmp5_;
				_tmp6_ = s;
				_tmp7_ = sticker_get_posx (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = s;
				_tmp10_ = sticker_get_posy (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = s;
				_tmp13_ = sticker_get_width (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = s;
				_tmp16_ = sticker_get_height (_tmp15_);
				_tmp17_ = _tmp16_;
				if (utils_is_within_bounds (x, y, _tmp8_, _tmp11_, _tmp14_, _tmp17_)) {
					result = s;
					return result;
				}
				_sticker_unref0 (s);
			}
		}
	}
	result = NULL;
	return result;
}

void
stickers_add_extents (Stickers* self,
                      gdouble* x1,
                      gdouble* y1,
                      gdouble* x2,
                      gdouble* y2)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				Sticker* s = NULL;
				GArray* _tmp3_;
				Sticker* _tmp4_;
				Sticker* _tmp5_;
				gdouble _tmp6_ = 0.0;
				Sticker* _tmp7_;
				gdouble _tmp8_;
				gdouble _tmp9_;
				gdouble _tmp13_ = 0.0;
				Sticker* _tmp14_;
				gdouble _tmp15_;
				gdouble _tmp16_;
				gdouble _tmp20_ = 0.0;
				Sticker* _tmp21_;
				gdouble _tmp22_;
				gdouble _tmp23_;
				Sticker* _tmp24_;
				gdouble _tmp25_;
				gdouble _tmp26_;
				gdouble _tmp33_ = 0.0;
				Sticker* _tmp34_;
				gdouble _tmp35_;
				gdouble _tmp36_;
				Sticker* _tmp37_;
				gdouble _tmp38_;
				gdouble _tmp39_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_stickers;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_stickers;
				_tmp4_ = g_array_index (_tmp3_, Sticker*, (guint) i);
				_tmp5_ = _sticker_ref0 (_tmp4_);
				s = _tmp5_;
				_tmp7_ = s;
				_tmp8_ = sticker_get_posx (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_ < (*x1)) {
					Sticker* _tmp10_;
					gdouble _tmp11_;
					gdouble _tmp12_;
					_tmp10_ = s;
					_tmp11_ = sticker_get_posx (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = _tmp12_;
				} else {
					_tmp6_ = *x1;
				}
				*x1 = _tmp6_;
				_tmp14_ = s;
				_tmp15_ = sticker_get_posy (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ < (*y1)) {
					Sticker* _tmp17_;
					gdouble _tmp18_;
					gdouble _tmp19_;
					_tmp17_ = s;
					_tmp18_ = sticker_get_posy (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp13_ = _tmp19_;
				} else {
					_tmp13_ = *y1;
				}
				*y1 = _tmp13_;
				_tmp21_ = s;
				_tmp22_ = sticker_get_posx (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = s;
				_tmp25_ = sticker_get_width (_tmp24_);
				_tmp26_ = _tmp25_;
				if ((_tmp23_ + _tmp26_) > (*x2)) {
					Sticker* _tmp27_;
					gdouble _tmp28_;
					gdouble _tmp29_;
					Sticker* _tmp30_;
					gdouble _tmp31_;
					gdouble _tmp32_;
					_tmp27_ = s;
					_tmp28_ = sticker_get_posx (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = s;
					_tmp31_ = sticker_get_width (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp20_ = _tmp29_ + _tmp32_;
				} else {
					_tmp20_ = *x2;
				}
				*x2 = _tmp20_;
				_tmp34_ = s;
				_tmp35_ = sticker_get_posy (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = s;
				_tmp38_ = sticker_get_height (_tmp37_);
				_tmp39_ = _tmp38_;
				if ((_tmp36_ + _tmp39_) > (*y2)) {
					Sticker* _tmp40_;
					gdouble _tmp41_;
					gdouble _tmp42_;
					Sticker* _tmp43_;
					gdouble _tmp44_;
					gdouble _tmp45_;
					_tmp40_ = s;
					_tmp41_ = sticker_get_posy (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = s;
					_tmp44_ = sticker_get_height (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp33_ = _tmp42_ + _tmp45_;
				} else {
					_tmp33_ = *y2;
				}
				*y2 = _tmp33_;
				_sticker_unref0 (s);
			}
		}
	}
}

xmlNode*
stickers_save (Stickers* self)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp8_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "stickers");
	n = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				xmlNode* _tmp4_;
				GArray* _tmp5_;
				Sticker* _tmp6_;
				xmlNode* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_stickers;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = n;
				_tmp5_ = self->priv->_stickers;
				_tmp6_ = g_array_index (_tmp5_, Sticker*, (guint) i);
				_tmp7_ = sticker_save (_tmp6_);
				xmlAddChild (_tmp4_, _tmp7_);
			}
		}
	}
	_tmp8_ = n;
	result = _tmp8_;
	return result;
}

void
stickers_load (Stickers* self,
               DrawArea* da,
               xmlNode* n)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = n->children;
		it = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				gboolean _tmp5_ = FALSE;
				xmlNode* _tmp6_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = it;
					_tmp3_ = _tmp2_->next;
					it = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = it;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp6_ = it;
				if (_tmp6_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = it;
					_tmp8_ = _tmp7_->name;
					_tmp5_ = g_strcmp0 (_tmp8_, "sticker") == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					Sticker* sticker = NULL;
					xmlNode* _tmp9_;
					Sticker* _tmp10_;
					GArray* _tmp11_;
					Sticker* _tmp12_;
					Sticker* _tmp13_;
					_tmp9_ = it;
					_tmp10_ = sticker_new_from_xml (da, _tmp9_);
					sticker = _tmp10_;
					_tmp11_ = self->priv->_stickers;
					_tmp12_ = sticker;
					_tmp13_ = _sticker_ref0 (_tmp12_);
					g_array_append_val (_tmp11_, _tmp13_);
					_sticker_unref0 (sticker);
				}
			}
		}
	}
}

void
stickers_draw_all (Stickers* self,
                   cairo_t* ctx,
                   Theme* theme,
                   gdouble opacity,
                   gboolean exporting)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Sticker* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_stickers;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_stickers;
				_tmp4_ = g_array_index (_tmp3_, Sticker*, (guint) i);
				sticker_draw (_tmp4_, ctx, theme, opacity, exporting);
			}
		}
	}
}

static void
value_stickers_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_stickers_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		stickers_unref (value->data[0].v_pointer);
	}
}

static void
value_stickers_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = stickers_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_stickers_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_stickers_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Stickers * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = stickers_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_stickers_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	Stickers ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = stickers_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_stickers (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecStickers* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_STICKERS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_stickers (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STICKERS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_stickers (GValue* value,
                    gpointer v_object)
{
	Stickers * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STICKERS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STICKERS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		stickers_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		stickers_unref (old);
	}
}

void
value_take_stickers (GValue* value,
                     gpointer v_object)
{
	Stickers * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_STICKERS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_STICKERS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		stickers_unref (old);
	}
}

static void
stickers_class_init (StickersClass * klass,
                     gpointer klass_data)
{
	stickers_parent_class = g_type_class_peek_parent (klass);
	((StickersClass *) klass)->finalize = stickers_finalize;
	g_type_class_adjust_private_offset (klass, &Stickers_private_offset);
}

static void
stickers_instance_init (Stickers * self,
                        gpointer klass)
{
	self->priv = stickers_get_instance_private (self);
	self->ref_count = 1;
}

static void
stickers_finalize (Stickers * obj)
{
	Stickers * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STICKERS, Stickers);
	g_signal_handlers_destroy (self);
	_g_array_unref0 (self->priv->_stickers);
}

static GType
stickers_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_stickers_init, value_stickers_free_value, value_stickers_copy_value, value_stickers_peek_pointer, "p", value_stickers_collect_value, "p", value_stickers_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (StickersClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) stickers_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Stickers), 0, (GInstanceInitFunc) stickers_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType stickers_type_id;
	stickers_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Stickers", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Stickers_private_offset = g_type_add_instance_private (stickers_type_id, sizeof (StickersPrivate));
	return stickers_type_id;
}

GType
stickers_get_type (void)
{
	static volatile gsize stickers_type_id__once = 0;
	if (g_once_init_enter (&stickers_type_id__once)) {
		GType stickers_type_id;
		stickers_type_id = stickers_get_type_once ();
		g_once_init_leave (&stickers_type_id__once, stickers_type_id);
	}
	return stickers_type_id__once;
}

gpointer
stickers_ref (gpointer instance)
{
	Stickers * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
stickers_unref (gpointer instance)
{
	Stickers * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		STICKERS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

