/* ExportMarkdown.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportMarkdown.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_MARKDOWN (export_markdown_get_type ())
#define EXPORT_MARKDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_MARKDOWN, ExportMarkdown))
#define EXPORT_MARKDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_MARKDOWN, ExportMarkdownClass))
#define IS_EXPORT_MARKDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_MARKDOWN))
#define IS_EXPORT_MARKDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_MARKDOWN))
#define EXPORT_MARKDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_MARKDOWN, ExportMarkdownClass))

typedef struct _ExportMarkdown ExportMarkdown;
typedef struct _ExportMarkdownClass ExportMarkdownClass;
typedef struct _ExportMarkdownPrivate ExportMarkdownPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_NODE_IMAGE (node_image_get_type ())
#define NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_IMAGE, NodeImage))
#define NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_IMAGE, NodeImageClass))
#define IS_NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_IMAGE))
#define IS_NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_IMAGE))
#define NODE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_IMAGE, NodeImageClass))

typedef struct _NodeImage NodeImage;
typedef struct _NodeImageClass NodeImageClass;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _node_image_unref0(var) ((var == NULL) ? NULL : (var = (node_image_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;

#define TYPE_LAYOUTS (layouts_get_type ())
#define LAYOUTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUTS, Layouts))
#define LAYOUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUTS, LayoutsClass))
#define IS_LAYOUTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUTS))
#define IS_LAYOUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUTS))
#define LAYOUTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUTS, LayoutsClass))

typedef struct _Layouts Layouts;
typedef struct _LayoutsClass LayoutsClass;

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;

#define TYPE_STYLES (styles_get_type ())
#define STYLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLES, Styles))
#define STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLES, StylesClass))
#define IS_STYLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLES))
#define IS_STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLES))
#define STYLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLES, StylesClass))

typedef struct _Styles Styles;
typedef struct _StylesClass StylesClass;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
#define _style_unref0(var) ((var == NULL) ? NULL : (var = (style_unref (var), NULL)))

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

#define EXPORT_MARKDOWN_TYPE_HIER (export_markdown_hier_get_type ())
typedef struct _ExportMarkdownHier ExportMarkdownHier;
#define _export_markdown_hier_free0(var) ((var == NULL) ? NULL : (var = (export_markdown_hier_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportMarkdown {
	Export parent_instance;
	ExportMarkdownPrivate * priv;
};

struct _ExportMarkdownClass {
	ExportClass parent_class;
};

struct _ExportMarkdownHier {
	gint spaces;
	Node* node;
};

static gpointer export_markdown_parent_class = NULL;
VALA_EXTERN Styles* style_inspector_styles;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_markdown_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportMarkdown, export_unref)
VALA_EXTERN gboolean export_import (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN void export_add_settings (Export* self,
                          GtkGrid* grid);
VALA_EXTERN void export_save_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN void export_load_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN ExportMarkdown* export_markdown_new (void);
VALA_EXTERN ExportMarkdown* export_markdown_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_markdown_handle_directory (ExportMarkdown* self,
                                           const gchar* fname,
                                           gchar** mdfile,
                                           gchar** imgdir);
VALA_EXTERN gboolean export_get_bool (Export* self,
                          const gchar* name);
static gboolean export_markdown_real_import (Export* base,
                                      const gchar* fname,
                                      DrawArea* da);
static void export_markdown_import_text (ExportMarkdown* self,
                                  const gchar* txt,
                                  DrawArea* da,
                                  const gchar* current_dir);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
static Node* export_markdown_make_node (ExportMarkdown* self,
                                 DrawArea* da,
                                 Node* parent,
                                 const gchar* bullet,
                                 const gchar* task,
                                 const gchar* pre_name,
                                 const gchar* current_dir,
                                 gboolean attach);
VALA_EXTERN gpointer node_image_ref (gpointer instance);
VALA_EXTERN void node_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_image (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_image (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_image (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_image (const GValue* value);
VALA_EXTERN GType node_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeImage, node_image_unref)
VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
VALA_EXTERN ImageManager* draw_area_get_image_manager (DrawArea* self);
VALA_EXTERN NodeImage* node_image_new_from_uri (ImageManager* im,
                                    const gchar* uri,
                                    gint width);
VALA_EXTERN NodeImage* node_image_construct_from_uri (GType object_type,
                                          ImageManager* im,
                                          const gchar* uri,
                                          gint width);
VALA_EXTERN GType layouts_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layouts, g_object_unref)
VALA_EXTERN Layouts* draw_area_get_layouts (DrawArea* self);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN Layout* layouts_get_default (Layouts* self);
VALA_EXTERN Node* node_new_with_name (DrawArea* da,
                          const gchar* n,
                          Layout* layout);
VALA_EXTERN Node* node_construct_with_name (GType object_type,
                                DrawArea* da,
                                const gchar* n,
                                Layout* layout);
VALA_EXTERN gpointer styles_ref (gpointer instance);
VALA_EXTERN void styles_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_styles (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_styles (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_styles (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_styles (const GValue* value);
VALA_EXTERN GType styles_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Styles, styles_unref)
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* styles_get_global_style (Styles* self);
VALA_EXTERN void node_set_style (Node* self,
                     Style* value);
VALA_EXTERN void draw_area_position_root_node (DrawArea* self,
                                   Node* node);
VALA_EXTERN void draw_area_add_root (DrawArea* self,
                         Node* n,
                         gint index);
VALA_EXTERN void draw_area_set_current_node (DrawArea* self,
                                 Node* n);
VALA_EXTERN Style* styles_get_style_for_level (Styles* self,
                                   guint level,
                                   Style* alternative);
VALA_EXTERN guint node_get_level (Node* self);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN void node_attach (Node* self,
                  Node* parent,
                  gint index,
                  Theme* theme,
                  gboolean set_side);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN void node_set_sequence (Node* self,
                        gboolean value);
VALA_EXTERN void node_enable_task (Node* self,
                       gboolean task);
VALA_EXTERN void node_set_task_done (Node* self,
                         gboolean done);
VALA_EXTERN void node_set_image (Node* self,
                     ImageManager* im,
                     NodeImage* ni);
VALA_EXTERN void export_markdown_append_name (ExportMarkdown* self,
                                  Node* node,
                                  const gchar* str);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN void formatted_text_append_text (FormattedText* self,
                                 const gchar* str);
VALA_EXTERN void export_markdown_append_note (ExportMarkdown* self,
                                  Node* node,
                                  const gchar* str);
VALA_EXTERN const gchar* node_get_note (Node* self);
VALA_EXTERN void node_set_note (Node* self,
                    const gchar* value);
static GType export_markdown_hier_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ExportMarkdownHier* export_markdown_hier_dup (const ExportMarkdownHier* self);
static void export_markdown_hier_free (ExportMarkdownHier* self);
static void export_markdown_hier_copy (const ExportMarkdownHier* self,
                                ExportMarkdownHier* dest);
static void export_markdown_hier_destroy (ExportMarkdownHier* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (ExportMarkdownHier, export_markdown_hier_destroy)
static void _export_markdown_hier_free0_ (gpointer var);
static void _vala_ExportMarkdownHier_free_function_content_of (gpointer data);
VALA_EXTERN Node* draw_area_get_current_node (DrawArea* self);
static gboolean export_markdown_real_export (Export* base,
                                      const gchar* fname,
                                      DrawArea* da);
static void export_markdown_export_top_nodes (ExportMarkdown* self,
                                       GFileOutputStream* os,
                                       DrawArea* da,
                                       const gchar* imgdir);
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
static void export_markdown_export_node (ExportMarkdown* self,
                                  GFileOutputStream* os,
                                  ImageManager* im,
                                  Node* node,
                                  const gchar* imgdir,
                                  const gchar* prefix);
static gboolean export_markdown_copy_file (ExportMarkdown* self,
                                    const gchar* imgdir,
                                    const gchar* filename);
VALA_EXTERN gboolean node_is_in_sequence (Node* self);
VALA_EXTERN gint node_index (Node* self);
VALA_EXTERN gboolean node_is_task (Node* self);
VALA_EXTERN gboolean node_is_task_done (Node* self);
VALA_EXTERN NodeImage* node_get_image (Node* self);
VALA_EXTERN gchar* image_manager_get_file (ImageManager* self,
                               gint id);
VALA_EXTERN gint node_image_get_id (NodeImage* self);
VALA_EXTERN gint node_image_get_width (NodeImage* self);
VALA_EXTERN gint node_image_get_height (NodeImage* self);
static void export_markdown_real_add_settings (Export* base,
                                        GtkGrid* grid);
VALA_EXTERN void export_add_setting_bool (Export* self,
                              const gchar* name,
                              GtkGrid* grid,
                              const gchar* label,
                              const gchar* help,
                              gboolean dflt);
static void export_markdown_real_save_settings (Export* base,
                                         xmlNode* node);
static void export_markdown_real_load_settings (Export* base,
                                         xmlNode* node);
VALA_EXTERN void export_set_bool (Export* self,
                      const gchar* name,
                      gboolean value);
static GType export_markdown_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportMarkdown*
export_markdown_construct (GType object_type)
{
	ExportMarkdown* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = g_strdup (".md");
	_tmp1_ = g_strdup (".markdown");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	self = (ExportMarkdown*) export_construct (object_type, "markdown", _ ("Markdown"), _tmp3_, (gint) 2, TRUE, TRUE, FALSE);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportMarkdown*
export_markdown_new (void)
{
	return export_markdown_construct (TYPE_EXPORT_MARKDOWN);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gboolean
export_markdown_handle_directory (ExportMarkdown* self,
                                  const gchar* fname,
                                  gchar** mdfile,
                                  gchar** imgdir)
{
	gchar* _vala_mdfile = NULL;
	gchar* _vala_imgdir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (fname != NULL, FALSE);
	_tmp0_ = g_strdup (fname);
	_g_free0 (_vala_mdfile);
	_vala_mdfile = _tmp0_;
	_tmp1_ = g_strdup (fname);
	_g_free0 (_vala_imgdir);
	_vala_imgdir = _tmp1_;
	if (export_get_bool ((Export*) self, "include-image-links")) {
		gchar* filename = NULL;
		gchar* _tmp2_;
		gchar* dirname = NULL;
		gchar* _tmp3_;
		const gchar* _tmp9_;
		_tmp2_ = g_strdup (fname);
		filename = _tmp2_;
		_tmp3_ = g_strdup (fname);
		dirname = _tmp3_;
		if (g_str_has_suffix (fname, ".md")) {
			gchar** parts = NULL;
			gchar** _tmp4_;
			gchar** _tmp5_;
			gint parts_length1;
			gint _parts_size_;
			gchar** _tmp6_;
			gint _tmp6__length1;
			gchar** _tmp7_;
			gint _tmp7__length1;
			gchar* _tmp8_;
			_tmp5_ = _tmp4_ = g_strsplit (fname, ".", 0);
			parts = _tmp5_;
			parts_length1 = _vala_array_length (_tmp4_);
			_parts_size_ = parts_length1;
			_tmp6_ = parts;
			_tmp6__length1 = parts_length1;
			_tmp7_ = parts;
			_tmp7__length1 = parts_length1;
			_tmp8_ = _vala_g_strjoinv (".", _tmp6_ + 0, (gint) ((_tmp7__length1 - 1) - 0));
			_g_free0 (dirname);
			dirname = _tmp8_;
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp9_ = dirname;
		if (g_mkdir_with_parents (_tmp9_, 0775) == 0) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = dirname;
			_tmp11_ = g_build_filename (_tmp10_, "images", NULL);
			_g_free0 (_vala_imgdir);
			_vala_imgdir = _tmp11_;
			_tmp12_ = _vala_imgdir;
			if (g_mkdir_with_parents (_tmp12_, 0775) == 0) {
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp13_ = dirname;
				_tmp14_ = g_path_get_basename (fname);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_build_filename (_tmp13_, _tmp15_, NULL);
				_g_free0 (_vala_mdfile);
				_vala_mdfile = _tmp16_;
				_g_free0 (_tmp15_);
				result = TRUE;
				_g_free0 (dirname);
				_g_free0 (filename);
				if (mdfile) {
					*mdfile = _vala_mdfile;
				} else {
					_g_free0 (_vala_mdfile);
				}
				if (imgdir) {
					*imgdir = _vala_imgdir;
				} else {
					_g_free0 (_vala_imgdir);
				}
				return result;
			}
		}
		result = FALSE;
		_g_free0 (dirname);
		_g_free0 (filename);
		if (mdfile) {
			*mdfile = _vala_mdfile;
		} else {
			_g_free0 (_vala_mdfile);
		}
		if (imgdir) {
			*imgdir = _vala_imgdir;
		} else {
			_g_free0 (_vala_imgdir);
		}
		return result;
	}
	result = TRUE;
	if (mdfile) {
		*mdfile = _vala_mdfile;
	} else {
		_g_free0 (_vala_mdfile);
	}
	if (imgdir) {
		*imgdir = _vala_imgdir;
	} else {
		_g_free0 (_vala_imgdir);
	}
	return result;
}

static gboolean
export_markdown_real_import (Export* base,
                             const gchar* fname,
                             DrawArea* da)
{
	ExportMarkdown * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* current_dir = NULL;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportMarkdown*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (fname);
	file = _tmp0_;
	_tmp1_ = g_path_get_dirname (fname);
	current_dir = _tmp1_;
	{
		GFileInputStream* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInputStream* _tmp4_;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp5_;
		gsize len = 0UL;
		gchar* _tmp6_ = NULL;
		GDataInputStream* _tmp7_;
		gsize _tmp8_ = 0UL;
		gchar* _tmp9_;
		gchar* str = NULL;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp3_ = file;
		_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __catch0_g_error;
		}
		_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp2_);
		dis = _tmp5_;
		_tmp7_ = dis;
		_tmp9_ = g_data_input_stream_read_upto (_tmp7_, "\0", (gssize) 1, &_tmp8_, NULL, &_inner_error0_);
		len = _tmp8_;
		_tmp6_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dis);
			_g_object_unref0 (_tmp2_);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __catch0_g_error;
		}
		_tmp10_ = g_strconcat (_tmp6_, "\0", NULL);
		str = _tmp10_;
		_tmp11_ = str;
		_tmp12_ = current_dir;
		export_markdown_import_text (self, _tmp11_, da, _tmp12_);
		gtk_widget_queue_draw ((GtkWidget*) da);
		g_signal_emit_by_name (da, "changed");
		_g_free0 (str);
		_g_free0 (_tmp6_);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_free0 (current_dir);
		_g_object_unref0 (file);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_free0 (current_dir);
		_g_object_unref0 (file);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp13_ = FALSE;
		_g_free0 (current_dir);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	result = TRUE;
	_g_free0 (current_dir);
	_g_object_unref0 (file);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static Node*
export_markdown_make_node (ExportMarkdown* self,
                           DrawArea* da,
                           Node* parent,
                           const gchar* bullet,
                           const gchar* task,
                           const gchar* pre_name,
                           const gchar* current_dir,
                           gboolean attach)
{
	NodeImage* image = NULL;
	gchar* name = NULL;
	gchar* _tmp0_;
	Node* node = NULL;
	const gchar* _tmp52_;
	Layouts* _tmp53_;
	Layouts* _tmp54_;
	Layout* _tmp55_;
	Layout* _tmp56_;
	Node* _tmp57_;
	Node* _tmp58_;
	gboolean _tmp75_ = FALSE;
	Node* _tmp85_;
	ImageManager* _tmp86_;
	ImageManager* _tmp87_;
	NodeImage* _tmp88_;
	GError* _inner_error0_ = NULL;
	Node* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (bullet != NULL, NULL);
	g_return_val_if_fail (task != NULL, NULL);
	g_return_val_if_fail (pre_name != NULL, NULL);
	g_return_val_if_fail (current_dir != NULL, NULL);
	image = NULL;
	_tmp0_ = g_strdup (pre_name);
	name = _tmp0_;
	{
		GMatchInfo* match_info = NULL;
		GRegex* re = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		const gchar* _tmp3_;
		GMatchInfo* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp1_ = g_regex_new ("(.*)<img\\s+(.*?)/>(.*)", 0, 0, &_inner_error0_);
		re = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_match_info_unref0 (match_info);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_free0 (name);
			_node_image_unref0 (image);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = re;
		_tmp3_ = name;
		_tmp5_ = g_regex_match (_tmp2_, _tmp3_, 0, &_tmp4_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp4_;
		if (_tmp5_) {
			GRegex* src_re = NULL;
			GRegex* _tmp6_;
			gchar* pretext = NULL;
			GMatchInfo* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* attrs = NULL;
			GMatchInfo* _tmp12_;
			gchar* _tmp13_;
			gchar* posttext = NULL;
			GMatchInfo* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			const gchar* _tmp20_;
			gchar* _tmp28_;
			GRegex* _tmp29_;
			const gchar* _tmp30_;
			GMatchInfo* _tmp31_ = NULL;
			gboolean _tmp32_;
			_tmp6_ = g_regex_new ("src\\s*=\\s*\"(.*?)\"", 0, 0, &_inner_error0_);
			src_re = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_regex_unref0 (re);
				_g_match_info_unref0 (match_info);
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_free0 (name);
				_node_image_unref0 (image);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp7_ = match_info;
			_tmp8_ = g_match_info_fetch (_tmp7_, 1);
			_tmp9_ = _tmp8_;
			_tmp10_ = string_strip (_tmp9_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			pretext = _tmp11_;
			_tmp12_ = match_info;
			_tmp13_ = g_match_info_fetch (_tmp12_, 2);
			attrs = _tmp13_;
			_tmp14_ = match_info;
			_tmp15_ = g_match_info_fetch (_tmp14_, 3);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_strip (_tmp16_);
			_tmp18_ = _tmp17_;
			_g_free0 (_tmp16_);
			posttext = _tmp18_;
			_tmp20_ = pretext;
			if (g_strcmp0 (_tmp20_, "") == 0) {
				const gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp21_ = posttext;
				_tmp22_ = g_strdup (_tmp21_);
				_g_free0 (_tmp19_);
				_tmp19_ = _tmp22_;
			} else {
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp23_ = pretext;
				_tmp24_ = g_strconcat (_tmp23_, " ", NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = posttext;
				_tmp27_ = g_strconcat (_tmp25_, _tmp26_, NULL);
				_g_free0 (_tmp19_);
				_tmp19_ = _tmp27_;
				_g_free0 (_tmp25_);
			}
			_tmp28_ = g_strdup (_tmp19_);
			_g_free0 (name);
			name = _tmp28_;
			_tmp29_ = src_re;
			_tmp30_ = attrs;
			_tmp32_ = g_regex_match (_tmp29_, _tmp30_, 0, &_tmp31_);
			_g_match_info_unref0 (match_info);
			match_info = _tmp31_;
			if (_tmp32_) {
				gchar* file = NULL;
				GMatchInfo* _tmp33_;
				gchar* _tmp34_;
				GRegex* w_re = NULL;
				GRegex* _tmp35_;
				gint width = 0;
				GRegex* _tmp36_;
				const gchar* _tmp37_;
				GMatchInfo* _tmp38_ = NULL;
				gboolean _tmp39_;
				const gchar* _tmp43_;
				ImageManager* _tmp46_;
				ImageManager* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				NodeImage* _tmp51_;
				_tmp33_ = match_info;
				_tmp34_ = g_match_info_fetch (_tmp33_, 1);
				file = _tmp34_;
				_tmp35_ = g_regex_new ("width\\s*=\\s*\"(.*?)\"", 0, 0, &_inner_error0_);
				w_re = _tmp35_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (file);
					_g_free0 (_tmp19_);
					_g_free0 (posttext);
					_g_free0 (attrs);
					_g_free0 (pretext);
					_g_regex_unref0 (src_re);
					_g_regex_unref0 (re);
					_g_match_info_unref0 (match_info);
					if (_inner_error0_->domain == G_REGEX_ERROR) {
						goto __catch0_g_regex_error;
					}
					_g_free0 (name);
					_node_image_unref0 (image);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				width = 200;
				_tmp36_ = w_re;
				_tmp37_ = attrs;
				_tmp39_ = g_regex_match (_tmp36_, _tmp37_, 0, &_tmp38_);
				_g_match_info_unref0 (match_info);
				match_info = _tmp38_;
				if (_tmp39_) {
					GMatchInfo* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp40_ = match_info;
					_tmp41_ = g_match_info_fetch (_tmp40_, 1);
					_tmp42_ = _tmp41_;
					width = atoi (_tmp42_);
					_g_free0 (_tmp42_);
				}
				_tmp43_ = file;
				if (!g_path_is_absolute (_tmp43_)) {
					const gchar* _tmp44_;
					gchar* _tmp45_;
					_tmp44_ = file;
					_tmp45_ = g_build_filename (current_dir, _tmp44_, NULL);
					_g_free0 (file);
					file = _tmp45_;
				}
				_tmp46_ = draw_area_get_image_manager (da);
				_tmp47_ = _tmp46_;
				_tmp48_ = file;
				_tmp49_ = g_strconcat ("file://", _tmp48_, NULL);
				_tmp50_ = _tmp49_;
				_tmp51_ = node_image_new_from_uri (_tmp47_, _tmp50_, width);
				_node_image_unref0 (image);
				image = _tmp51_;
				_g_free0 (_tmp50_);
				_g_regex_unref0 (w_re);
				_g_free0 (file);
			}
			_g_free0 (_tmp19_);
			_g_free0 (posttext);
			_g_free0 (attrs);
			_g_free0 (pretext);
			_g_regex_unref0 (src_re);
		}
		_g_regex_unref0 (re);
		_g_match_info_unref0 (match_info);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (name);
		_node_image_unref0 (image);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp52_ = name;
	_tmp53_ = draw_area_get_layouts (da);
	_tmp54_ = _tmp53_;
	_tmp55_ = layouts_get_default (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = node_new_with_name (da, _tmp52_, _tmp56_);
	_tmp58_ = _tmp57_;
	_g_object_unref0 (_tmp56_);
	node = _tmp58_;
	if (parent == NULL) {
		Node* _tmp59_;
		Styles* _tmp60_;
		Style* _tmp61_;
		Style* _tmp62_;
		_tmp59_ = node;
		_tmp60_ = style_inspector_styles;
		_tmp61_ = styles_get_global_style (_tmp60_);
		_tmp62_ = _tmp61_;
		node_set_style (_tmp59_, _tmp62_);
		_style_unref0 (_tmp62_);
		if (attach) {
			Node* _tmp63_;
			Node* _tmp64_;
			Node* _tmp65_;
			_tmp63_ = node;
			draw_area_position_root_node (da, _tmp63_);
			_tmp64_ = node;
			draw_area_add_root (da, _tmp64_, -1);
			_tmp65_ = node;
			draw_area_set_current_node (da, _tmp65_);
		}
	} else {
		Node* _tmp66_;
		Styles* _tmp67_;
		Style* _tmp68_;
		Style* _tmp69_;
		_tmp66_ = node;
		_tmp67_ = style_inspector_styles;
		_tmp68_ = styles_get_style_for_level (_tmp67_, node_get_level (parent) + 1, NULL);
		_tmp69_ = _tmp68_;
		node_set_style (_tmp66_, _tmp69_);
		_style_unref0 (_tmp69_);
		if (attach) {
			Node* _tmp70_;
			GArray* _tmp71_;
			GArray* _tmp72_;
			Theme* _tmp73_;
			Theme* _tmp74_;
			_tmp70_ = node;
			_tmp71_ = node_children (parent);
			_tmp72_ = _tmp71_;
			_tmp73_ = draw_area_get_theme (da);
			_tmp74_ = _tmp73_;
			node_attach (_tmp70_, parent, (gint) _tmp72_->len, _tmp74_, TRUE);
			_g_object_unref0 (_tmp74_);
			_g_array_unref0 (_tmp72_);
		}
	}
	if (g_regex_match_simple ("\\d+\\.", bullet, 0, 0)) {
		Node* _tmp76_;
		Node* _tmp77_;
		Node* _tmp78_;
		_tmp76_ = node;
		_tmp77_ = node_get_parent (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp75_ = _tmp78_ != NULL;
	} else {
		_tmp75_ = FALSE;
	}
	if (_tmp75_) {
		Node* _tmp79_;
		Node* _tmp80_;
		Node* _tmp81_;
		_tmp79_ = node;
		_tmp80_ = node_get_parent (_tmp79_);
		_tmp81_ = _tmp80_;
		node_set_sequence (_tmp81_, TRUE);
	}
	if (g_strcmp0 (task, "") != 0) {
		Node* _tmp82_;
		gboolean _tmp83_ = FALSE;
		_tmp82_ = node;
		node_enable_task (_tmp82_, TRUE);
		if (g_strcmp0 (task, "x") == 0) {
			_tmp83_ = TRUE;
		} else {
			_tmp83_ = g_strcmp0 (task, "X") == 0;
		}
		if (_tmp83_) {
			Node* _tmp84_;
			_tmp84_ = node;
			node_set_task_done (_tmp84_, TRUE);
		}
	}
	_tmp85_ = node;
	_tmp86_ = draw_area_get_image_manager (da);
	_tmp87_ = _tmp86_;
	_tmp88_ = image;
	node_set_image (_tmp85_, _tmp87_, _tmp88_);
	result = node;
	_g_free0 (name);
	_node_image_unref0 (image);
	return result;
}

void
export_markdown_append_name (ExportMarkdown* self,
                             Node* node,
                             const gchar* str)
{
	CanvasText* _tmp0_;
	CanvasText* _tmp1_;
	FormattedText* _tmp2_;
	FormattedText* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = node_get_name (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = canvas_text_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_strip (str);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (" ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	formatted_text_append_text (_tmp3_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}

void
export_markdown_append_note (ExportMarkdown* self,
                             Node* node,
                             const gchar* str)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = node_get_note (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s\n%s", _tmp1_, str);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_strip (_tmp3_);
	_tmp5_ = _tmp4_;
	node_set_note (node, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}

static void
_export_markdown_hier_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (export_markdown_hier_free (var), NULL));
}

static void
_vala_ExportMarkdownHier_free_function_content_of (gpointer data)
{
	ExportMarkdownHier* self;
	self = *((ExportMarkdownHier**) data);
	_export_markdown_hier_free0_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_export_markdown_hier_dup0 (gpointer self)
{
	return self ? export_markdown_hier_dup (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

static void
export_markdown_import_text (ExportMarkdown* self,
                             const gchar* txt,
                             DrawArea* da,
                             const gchar* current_dir)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (txt != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (current_dir != NULL);
	{
		GArray* stack = NULL;
		GArray* _tmp0_;
		gchar** lines = NULL;
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint lines_length1;
		gint _lines_size_;
		GRegex* re = NULL;
		GRegex* _tmp3_;
		Node* current = NULL;
		Node* _tmp4_;
		Node* _tmp5_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp0_ = g_array_new (TRUE, TRUE, sizeof (ExportMarkdownHier*));
		g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_ExportMarkdownHier_free_function_content_of);
		stack = _tmp0_;
		_tmp2_ = _tmp1_ = g_strsplit (txt, "\n", 0);
		lines = _tmp2_;
		lines_length1 = _vala_array_length (_tmp1_);
		_lines_size_ = lines_length1;
		_tmp3_ = g_regex_new ("^(\\s*)((\\-|\\+|\\*|#|>|\\d+\\.)\\s*)?(\\[([ xX])\\]\\s*)?(.*)$", 0, 0, &_inner_error0_);
		re = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_array_unref0 (stack);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = draw_area_get_current_node (da);
		current = _tmp4_;
		_tmp5_ = current;
		if (_tmp5_ != NULL) {
			GArray* _tmp6_;
			Node* _tmp7_;
			Node* _tmp8_;
			ExportMarkdownHier _tmp9_ = {0};
			ExportMarkdownHier _tmp10_;
			ExportMarkdownHier* _tmp11_;
			_tmp6_ = stack;
			_tmp7_ = current;
			_tmp8_ = _g_object_ref0 (_tmp7_);
			_tmp9_.spaces = -1;
			_g_object_unref0 (_tmp9_.node);
			_tmp9_.node = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp11_ = _export_markdown_hier_dup0 (&_tmp10_);
			g_array_append_val (_tmp6_, _tmp11_);
			export_markdown_hier_destroy (&_tmp10_);
		}
		_tmp12_ = lines;
		_tmp12__length1 = lines_length1;
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp12_;
			line_collection_length1 = _tmp12__length1;
			for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
				gchar* _tmp13_;
				gchar* line = NULL;
				_tmp13_ = g_strdup (line_collection[line_it]);
				line = _tmp13_;
				{
					GMatchInfo* match_info = NULL;
					Node* node = NULL;
					GRegex* _tmp14_;
					const gchar* _tmp15_;
					GMatchInfo* _tmp16_ = NULL;
					gboolean _tmp17_;
					_tmp14_ = re;
					_tmp15_ = line;
					_tmp17_ = g_regex_match (_tmp14_, _tmp15_, 0, &_tmp16_);
					_g_match_info_unref0 (match_info);
					match_info = _tmp16_;
					if (_tmp17_) {
						gint spaces = 0;
						GMatchInfo* _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						gint _tmp23_;
						gint _tmp24_;
						gint _tmp25_;
						gchar* bullet = NULL;
						GMatchInfo* _tmp26_;
						gchar* _tmp27_;
						gchar* task = NULL;
						GMatchInfo* _tmp28_;
						gchar* _tmp29_;
						gchar* str = NULL;
						GMatchInfo* _tmp30_;
						gchar* _tmp31_;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gboolean _tmp35_;
						const gchar* _tmp36_;
						_tmp18_ = match_info;
						_tmp19_ = g_match_info_fetch (_tmp18_, 1);
						_tmp20_ = _tmp19_;
						_tmp21_ = string_replace (_tmp20_, "\t", " ");
						_tmp22_ = _tmp21_;
						_tmp23_ = strlen (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = _tmp24_;
						_g_free0 (_tmp22_);
						_g_free0 (_tmp20_);
						spaces = _tmp25_;
						_tmp26_ = match_info;
						_tmp27_ = g_match_info_fetch (_tmp26_, 3);
						bullet = _tmp27_;
						_tmp28_ = match_info;
						_tmp29_ = g_match_info_fetch (_tmp28_, 5);
						task = _tmp29_;
						_tmp30_ = match_info;
						_tmp31_ = g_match_info_fetch (_tmp30_, 6);
						str = _tmp31_;
						_tmp32_ = str;
						_tmp33_ = string_strip (_tmp32_);
						_tmp34_ = _tmp33_;
						_tmp35_ = g_strcmp0 (_tmp34_, "") == 0;
						_g_free0 (_tmp34_);
						if (_tmp35_) {
							_g_free0 (str);
							_g_free0 (task);
							_g_free0 (bullet);
							_g_object_unref0 (node);
							_g_match_info_unref0 (match_info);
							_g_free0 (line);
							continue;
						}
						_tmp36_ = bullet;
						if (g_strcmp0 (_tmp36_, ">") == 0) {
							GArray* _tmp37_;
							_tmp37_ = stack;
							if (_tmp37_->len > ((guint) 0)) {
								GArray* _tmp38_;
								GArray* _tmp39_;
								Node* _tmp40_;
								const gchar* _tmp41_;
								_tmp38_ = stack;
								_tmp39_ = stack;
								_tmp40_ = (*g_array_index (_tmp38_, ExportMarkdownHier*, _tmp39_->len - 1)).node;
								_tmp41_ = str;
								export_markdown_append_note (self, _tmp40_, _tmp41_);
							}
						} else {
							const gchar* _tmp42_;
							_tmp42_ = bullet;
							if (g_strcmp0 (_tmp42_, "") == 0) {
								GArray* _tmp43_;
								GArray* _tmp44_;
								Node* _tmp45_;
								const gchar* _tmp46_;
								_tmp43_ = stack;
								_tmp44_ = stack;
								_tmp45_ = (*g_array_index (_tmp43_, ExportMarkdownHier*, _tmp44_->len - 1)).node;
								_tmp46_ = str;
								export_markdown_append_name (self, _tmp45_, _tmp46_);
							} else {
								GArray* _tmp47_;
								_tmp47_ = stack;
								if (_tmp47_->len == ((guint) 0)) {
									const gchar* _tmp48_;
									const gchar* _tmp49_;
									const gchar* _tmp50_;
									Node* _tmp51_;
									GArray* _tmp52_;
									Node* _tmp53_;
									Node* _tmp54_;
									ExportMarkdownHier _tmp55_ = {0};
									ExportMarkdownHier _tmp56_;
									ExportMarkdownHier* _tmp57_;
									_tmp48_ = bullet;
									_tmp49_ = task;
									_tmp50_ = str;
									_tmp51_ = export_markdown_make_node (self, da, NULL, _tmp48_, _tmp49_, _tmp50_, current_dir, TRUE);
									_g_object_unref0 (node);
									node = _tmp51_;
									_tmp52_ = stack;
									_tmp53_ = node;
									_tmp54_ = _g_object_ref0 (_tmp53_);
									_tmp55_.spaces = spaces;
									_g_object_unref0 (_tmp55_.node);
									_tmp55_.node = _tmp54_;
									_tmp56_ = _tmp55_;
									_tmp57_ = _export_markdown_hier_dup0 (&_tmp56_);
									g_array_append_val (_tmp52_, _tmp57_);
									export_markdown_hier_destroy (&_tmp56_);
								} else {
									GArray* _tmp58_;
									GArray* _tmp59_;
									_tmp58_ = stack;
									_tmp59_ = stack;
									if (spaces == (*g_array_index (_tmp58_, ExportMarkdownHier*, _tmp59_->len - 1)).spaces) {
										GArray* _tmp60_;
										GArray* _tmp61_;
										Node* _tmp62_;
										Node* _tmp63_;
										Node* _tmp64_;
										const gchar* _tmp65_;
										const gchar* _tmp66_;
										const gchar* _tmp67_;
										Node* _tmp68_;
										GArray* _tmp69_;
										GArray* _tmp70_;
										ExportMarkdownHier* _tmp71_;
										ExportMarkdownHier* _tmp72_;
										GArray* _tmp73_;
										Node* _tmp74_;
										Node* _tmp75_;
										ExportMarkdownHier _tmp76_ = {0};
										ExportMarkdownHier _tmp77_;
										ExportMarkdownHier* _tmp78_;
										_tmp60_ = stack;
										_tmp61_ = stack;
										_tmp62_ = (*g_array_index (_tmp60_, ExportMarkdownHier*, _tmp61_->len - 1)).node;
										_tmp63_ = node_get_parent (_tmp62_);
										_tmp64_ = _tmp63_;
										_tmp65_ = bullet;
										_tmp66_ = task;
										_tmp67_ = str;
										_tmp68_ = export_markdown_make_node (self, da, _tmp64_, _tmp65_, _tmp66_, _tmp67_, current_dir, TRUE);
										_g_object_unref0 (node);
										node = _tmp68_;
										_tmp69_ = stack;
										_tmp70_ = stack;
										_tmp71_ = vala_g_array_remove_index (_tmp69_, _tmp70_->len - 1);
										_tmp72_ = _tmp71_;
										_export_markdown_hier_free0 (_tmp72_);
										_tmp73_ = stack;
										_tmp74_ = node;
										_tmp75_ = _g_object_ref0 (_tmp74_);
										_tmp76_.spaces = spaces;
										_g_object_unref0 (_tmp76_.node);
										_tmp76_.node = _tmp75_;
										_tmp77_ = _tmp76_;
										_tmp78_ = _export_markdown_hier_dup0 (&_tmp77_);
										g_array_append_val (_tmp73_, _tmp78_);
										export_markdown_hier_destroy (&_tmp77_);
									} else {
										GArray* _tmp79_;
										GArray* _tmp80_;
										_tmp79_ = stack;
										_tmp80_ = stack;
										if (spaces > (*g_array_index (_tmp79_, ExportMarkdownHier*, _tmp80_->len - 1)).spaces) {
											GArray* _tmp81_;
											GArray* _tmp82_;
											Node* _tmp83_;
											const gchar* _tmp84_;
											const gchar* _tmp85_;
											const gchar* _tmp86_;
											Node* _tmp87_;
											GArray* _tmp88_;
											Node* _tmp89_;
											Node* _tmp90_;
											ExportMarkdownHier _tmp91_ = {0};
											ExportMarkdownHier _tmp92_;
											ExportMarkdownHier* _tmp93_;
											_tmp81_ = stack;
											_tmp82_ = stack;
											_tmp83_ = (*g_array_index (_tmp81_, ExportMarkdownHier*, _tmp82_->len - 1)).node;
											_tmp84_ = bullet;
											_tmp85_ = task;
											_tmp86_ = str;
											_tmp87_ = export_markdown_make_node (self, da, _tmp83_, _tmp84_, _tmp85_, _tmp86_, current_dir, TRUE);
											_g_object_unref0 (node);
											node = _tmp87_;
											_tmp88_ = stack;
											_tmp89_ = node;
											_tmp90_ = _g_object_ref0 (_tmp89_);
											_tmp91_.spaces = spaces;
											_g_object_unref0 (_tmp91_.node);
											_tmp91_.node = _tmp90_;
											_tmp92_ = _tmp91_;
											_tmp93_ = _export_markdown_hier_dup0 (&_tmp92_);
											g_array_append_val (_tmp88_, _tmp93_);
											export_markdown_hier_destroy (&_tmp92_);
										} else {
											GArray* _tmp102_;
											while (TRUE) {
												gboolean _tmp94_ = FALSE;
												GArray* _tmp95_;
												GArray* _tmp98_;
												GArray* _tmp99_;
												ExportMarkdownHier* _tmp100_;
												ExportMarkdownHier* _tmp101_;
												_tmp95_ = stack;
												if (_tmp95_->len > ((guint) 0)) {
													GArray* _tmp96_;
													GArray* _tmp97_;
													_tmp96_ = stack;
													_tmp97_ = stack;
													_tmp94_ = spaces < (*g_array_index (_tmp96_, ExportMarkdownHier*, _tmp97_->len - 1)).spaces;
												} else {
													_tmp94_ = FALSE;
												}
												if (!_tmp94_) {
													break;
												}
												_tmp98_ = stack;
												_tmp99_ = stack;
												_tmp100_ = vala_g_array_remove_index (_tmp98_, _tmp99_->len - 1);
												_tmp101_ = _tmp100_;
												_export_markdown_hier_free0 (_tmp101_);
											}
											_tmp102_ = stack;
											if (_tmp102_->len == ((guint) 0)) {
												const gchar* _tmp103_;
												const gchar* _tmp104_;
												const gchar* _tmp105_;
												Node* _tmp106_;
												GArray* _tmp107_;
												Node* _tmp108_;
												Node* _tmp109_;
												ExportMarkdownHier _tmp110_ = {0};
												ExportMarkdownHier _tmp111_;
												ExportMarkdownHier* _tmp112_;
												_tmp103_ = bullet;
												_tmp104_ = task;
												_tmp105_ = str;
												_tmp106_ = export_markdown_make_node (self, da, NULL, _tmp103_, _tmp104_, _tmp105_, current_dir, TRUE);
												_g_object_unref0 (node);
												node = _tmp106_;
												_tmp107_ = stack;
												_tmp108_ = node;
												_tmp109_ = _g_object_ref0 (_tmp108_);
												_tmp110_.spaces = spaces;
												_g_object_unref0 (_tmp110_.node);
												_tmp110_.node = _tmp109_;
												_tmp111_ = _tmp110_;
												_tmp112_ = _export_markdown_hier_dup0 (&_tmp111_);
												g_array_append_val (_tmp107_, _tmp112_);
												export_markdown_hier_destroy (&_tmp111_);
											} else {
												GArray* _tmp113_;
												GArray* _tmp114_;
												_tmp113_ = stack;
												_tmp114_ = stack;
												if (spaces == (*g_array_index (_tmp113_, ExportMarkdownHier*, _tmp114_->len - 1)).spaces) {
													GArray* _tmp115_;
													GArray* _tmp116_;
													Node* _tmp117_;
													Node* _tmp118_;
													Node* _tmp119_;
													const gchar* _tmp120_;
													const gchar* _tmp121_;
													const gchar* _tmp122_;
													Node* _tmp123_;
													GArray* _tmp124_;
													GArray* _tmp125_;
													ExportMarkdownHier* _tmp126_;
													ExportMarkdownHier* _tmp127_;
													GArray* _tmp128_;
													Node* _tmp129_;
													Node* _tmp130_;
													ExportMarkdownHier _tmp131_ = {0};
													ExportMarkdownHier _tmp132_;
													ExportMarkdownHier* _tmp133_;
													_tmp115_ = stack;
													_tmp116_ = stack;
													_tmp117_ = (*g_array_index (_tmp115_, ExportMarkdownHier*, _tmp116_->len - 1)).node;
													_tmp118_ = node_get_parent (_tmp117_);
													_tmp119_ = _tmp118_;
													_tmp120_ = bullet;
													_tmp121_ = task;
													_tmp122_ = str;
													_tmp123_ = export_markdown_make_node (self, da, _tmp119_, _tmp120_, _tmp121_, _tmp122_, current_dir, TRUE);
													_g_object_unref0 (node);
													node = _tmp123_;
													_tmp124_ = stack;
													_tmp125_ = stack;
													_tmp126_ = vala_g_array_remove_index (_tmp124_, _tmp125_->len - 1);
													_tmp127_ = _tmp126_;
													_export_markdown_hier_free0 (_tmp127_);
													_tmp128_ = stack;
													_tmp129_ = node;
													_tmp130_ = _g_object_ref0 (_tmp129_);
													_tmp131_.spaces = spaces;
													_g_object_unref0 (_tmp131_.node);
													_tmp131_.node = _tmp130_;
													_tmp132_ = _tmp131_;
													_tmp133_ = _export_markdown_hier_dup0 (&_tmp132_);
													g_array_append_val (_tmp128_, _tmp133_);
													export_markdown_hier_destroy (&_tmp132_);
												} else {
													GArray* _tmp134_;
													GArray* _tmp135_;
													Node* _tmp136_;
													const gchar* _tmp137_;
													const gchar* _tmp138_;
													const gchar* _tmp139_;
													Node* _tmp140_;
													GArray* _tmp141_;
													Node* _tmp142_;
													Node* _tmp143_;
													ExportMarkdownHier _tmp144_ = {0};
													ExportMarkdownHier _tmp145_;
													ExportMarkdownHier* _tmp146_;
													_tmp134_ = stack;
													_tmp135_ = stack;
													_tmp136_ = (*g_array_index (_tmp134_, ExportMarkdownHier*, _tmp135_->len - 1)).node;
													_tmp137_ = bullet;
													_tmp138_ = task;
													_tmp139_ = str;
													_tmp140_ = export_markdown_make_node (self, da, _tmp136_, _tmp137_, _tmp138_, _tmp139_, current_dir, TRUE);
													_g_object_unref0 (node);
													node = _tmp140_;
													_tmp141_ = stack;
													_tmp142_ = node;
													_tmp143_ = _g_object_ref0 (_tmp142_);
													_tmp144_.spaces = spaces;
													_g_object_unref0 (_tmp144_.node);
													_tmp144_.node = _tmp143_;
													_tmp145_ = _tmp144_;
													_tmp146_ = _export_markdown_hier_dup0 (&_tmp145_);
													g_array_append_val (_tmp141_, _tmp146_);
													export_markdown_hier_destroy (&_tmp145_);
												}
											}
										}
									}
								}
							}
						}
						_g_free0 (str);
						_g_free0 (task);
						_g_free0 (bullet);
					}
					_g_object_unref0 (node);
					_g_match_info_unref0 (match_info);
					_g_free0 (line);
				}
			}
		}
		_g_object_unref0 (current);
		_g_regex_unref0 (re);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_array_unref0 (stack);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/****************************************************************/
static gboolean
export_markdown_real_export (Export* base,
                             const gchar* fname,
                             DrawArea* da)
{
	ExportMarkdown * self;
	gchar* filename = NULL;
	gchar* imgdir = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	GFile* file = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	gboolean retval = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportMarkdown*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp2_ = export_markdown_handle_directory (self, fname, &_tmp0_, &_tmp1_);
	_g_free0 (filename);
	filename = _tmp0_;
	_g_free0 (imgdir);
	imgdir = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		_g_free0 (imgdir);
		_g_free0 (filename);
		return result;
	}
	_tmp3_ = filename;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	file = _tmp4_;
	retval = TRUE;
	{
		GFileOutputStream* os = NULL;
		GFile* _tmp5_;
		GFileOutputStream* _tmp6_;
		GFileOutputStream* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = file;
		_tmp6_ = g_file_replace (_tmp5_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		os = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = os;
		_tmp8_ = imgdir;
		export_markdown_export_top_nodes (self, _tmp7_, da, _tmp8_);
		_g_object_unref0 (os);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		retval = FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_object_unref0 (file);
		_g_free0 (imgdir);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = retval;
	_g_object_unref0 (file);
	_g_free0 (imgdir);
	_g_free0 (filename);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
export_markdown_export_top_nodes (ExportMarkdown* self,
                                  GFileOutputStream* os,
                                  DrawArea* da,
                                  const gchar* imgdir)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (imgdir != NULL);
	{
		GArray* nodes = NULL;
		GArray* _tmp0_;
		_tmp0_ = draw_area_get_nodes (da);
		nodes = _tmp0_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					gchar* title = NULL;
					GArray* _tmp4_;
					Node* _tmp5_;
					CanvasText* _tmp6_;
					CanvasText* _tmp7_;
					FormattedText* _tmp8_;
					FormattedText* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					const gchar* _tmp16_;
					guint8* _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_ = 0;
					guint8* _tmp19_;
					gint _tmp19__length1;
					GArray* _tmp20_;
					Node* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					GArray* children = NULL;
					GArray* _tmp38_;
					Node* _tmp39_;
					GArray* _tmp40_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = nodes;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = nodes;
					_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
					_tmp6_ = node_get_name (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = canvas_text_get_text (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = formatted_text_get_text (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_strconcat ("# ", _tmp11_, NULL);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strconcat (_tmp13_, "\n\n", NULL);
					_tmp15_ = _tmp14_;
					_g_free0 (_tmp13_);
					title = _tmp15_;
					_tmp16_ = title;
					_tmp17_ = string_get_data (_tmp16_, &_tmp18_);
					_tmp17__length1 = _tmp18_;
					_tmp19_ = _tmp17_;
					_tmp19__length1 = _tmp17__length1;
					g_output_stream_write ((GOutputStream*) os, _tmp19_, (gsize) _tmp19__length1, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (title);
						_g_array_unref0 (nodes);
						goto __catch0_g_error;
					}
					_tmp20_ = nodes;
					_tmp21_ = g_array_index (_tmp20_, Node*, (guint) i);
					_tmp22_ = node_get_note (_tmp21_);
					_tmp23_ = _tmp22_;
					if (g_strcmp0 (_tmp23_, "") != 0) {
						gchar* note = NULL;
						GArray* _tmp24_;
						Node* _tmp25_;
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						const gchar* _tmp34_;
						guint8* _tmp35_;
						gint _tmp35__length1;
						gint _tmp36_ = 0;
						guint8* _tmp37_;
						gint _tmp37__length1;
						_tmp24_ = nodes;
						_tmp25_ = g_array_index (_tmp24_, Node*, (guint) i);
						_tmp26_ = node_get_note (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = string_replace (_tmp27_, "\n", "\n  > ");
						_tmp29_ = _tmp28_;
						_tmp30_ = g_strconcat ("  > ", _tmp29_, NULL);
						_tmp31_ = _tmp30_;
						_tmp32_ = g_strconcat (_tmp31_, "\n\n", NULL);
						_tmp33_ = _tmp32_;
						_g_free0 (_tmp31_);
						_g_free0 (_tmp29_);
						note = _tmp33_;
						_tmp34_ = note;
						_tmp35_ = string_get_data (_tmp34_, &_tmp36_);
						_tmp35__length1 = _tmp36_;
						_tmp37_ = _tmp35_;
						_tmp37__length1 = _tmp35__length1;
						g_output_stream_write ((GOutputStream*) os, _tmp37_, (gsize) _tmp37__length1, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (note);
							_g_free0 (title);
							_g_array_unref0 (nodes);
							goto __catch0_g_error;
						}
						_g_free0 (note);
					}
					_tmp38_ = nodes;
					_tmp39_ = g_array_index (_tmp38_, Node*, (guint) i);
					_tmp40_ = node_children (_tmp39_);
					children = _tmp40_;
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp41_ = FALSE;
							_tmp41_ = TRUE;
							while (TRUE) {
								GArray* _tmp43_;
								ImageManager* _tmp44_;
								ImageManager* _tmp45_;
								GArray* _tmp46_;
								Node* _tmp47_;
								if (!_tmp41_) {
									gint _tmp42_;
									_tmp42_ = j;
									j = _tmp42_ + 1;
								}
								_tmp41_ = FALSE;
								_tmp43_ = children;
								if (!(((guint) j) < _tmp43_->len)) {
									break;
								}
								_tmp44_ = draw_area_get_image_manager (da);
								_tmp45_ = _tmp44_;
								_tmp46_ = children;
								_tmp47_ = g_array_index (_tmp46_, Node*, (guint) j);
								export_markdown_export_node (self, os, _tmp45_, _tmp47_, imgdir, "  ");
							}
						}
					}
					_g_array_unref0 (children);
					_g_free0 (title);
				}
			}
		}
		_g_array_unref0 (nodes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
export_markdown_copy_file (ExportMarkdown* self,
                           const gchar* imgdir,
                           const gchar* filename)
{
	gchar* basename = NULL;
	gchar* _tmp0_;
	gchar* lname = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* rfile = NULL;
	GFile* _tmp3_;
	GFile* lfile = NULL;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (imgdir != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_path_get_basename (filename);
	basename = _tmp0_;
	_tmp1_ = basename;
	_tmp2_ = g_build_filename (imgdir, _tmp1_, NULL);
	lname = _tmp2_;
	_tmp3_ = g_file_new_for_path (filename);
	rfile = _tmp3_;
	_tmp4_ = lname;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	lfile = _tmp5_;
	{
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = rfile;
		_tmp7_ = lfile;
		g_file_copy (_tmp6_, _tmp7_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_object_unref0 (lfile);
		_g_object_unref0 (rfile);
		_g_free0 (lname);
		_g_free0 (basename);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		_g_object_unref0 (lfile);
		_g_object_unref0 (rfile);
		_g_free0 (lname);
		_g_free0 (basename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	result = TRUE;
	_g_object_unref0 (lfile);
	_g_object_unref0 (rfile);
	_g_free0 (lname);
	_g_free0 (basename);
	return result;
}

static void
export_markdown_export_node (ExportMarkdown* self,
                             GFileOutputStream* os,
                             ImageManager* im,
                             Node* node,
                             const gchar* imgdir,
                             const gchar* prefix)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (os != NULL);
	g_return_if_fail (im != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (imgdir != NULL);
	g_return_if_fail (prefix != NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* title = NULL;
		gchar* _tmp3_;
		gboolean _tmp8_ = FALSE;
		NodeImage* _tmp9_;
		NodeImage* _tmp10_;
		const gchar* _tmp50_;
		CanvasText* _tmp51_;
		CanvasText* _tmp52_;
		FormattedText* _tmp53_;
		FormattedText* _tmp54_;
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		const gchar* _tmp64_;
		guint8* _tmp65_;
		gint _tmp65__length1;
		gint _tmp66_ = 0;
		guint8* _tmp67_;
		gint _tmp67__length1;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		guint8* _tmp88_;
		gint _tmp88__length1;
		gint _tmp89_ = 0;
		guint8* _tmp90_;
		gint _tmp90__length1;
		GArray* children = NULL;
		GArray* _tmp91_;
		if (node_is_in_sequence (node)) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup_printf ("%d. ", node_index (node) + 1);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp1_;
		} else {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("- ");
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = g_strconcat (prefix, _tmp0_, NULL);
		title = _tmp3_;
		if (node_is_task (node)) {
			if (node_is_task_done (node)) {
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = title;
				_tmp5_ = g_strconcat (_tmp4_, "[x] ", NULL);
				_g_free0 (title);
				title = _tmp5_;
			} else {
				const gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp6_ = title;
				_tmp7_ = g_strconcat (_tmp6_, "[ ] ", NULL);
				_g_free0 (title);
				title = _tmp7_;
			}
		}
		_tmp9_ = node_get_image (node);
		_tmp10_ = _tmp9_;
		if (_tmp10_ != NULL) {
			_tmp8_ = export_get_bool ((Export*) self, "include-image-links");
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gchar* file = NULL;
			NodeImage* _tmp11_;
			NodeImage* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp11_ = node_get_image (node);
			_tmp12_ = _tmp11_;
			_tmp13_ = node_image_get_id (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = image_manager_get_file (im, _tmp14_);
			file = _tmp15_;
			_tmp16_ = file;
			if (export_markdown_copy_file (self, imgdir, _tmp16_)) {
				gchar* basename = NULL;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				NodeImage* _tmp25_;
				NodeImage* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				NodeImage* _tmp35_;
				NodeImage* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				_tmp17_ = file;
				_tmp18_ = g_path_get_basename (_tmp17_);
				basename = _tmp18_;
				_tmp19_ = title;
				_tmp20_ = basename;
				_tmp21_ = g_strconcat ("<img src=\"images/", _tmp20_, NULL);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strconcat (_tmp22_, "\" alt=\"image\" width=\"", NULL);
				_tmp24_ = _tmp23_;
				_tmp25_ = node_get_image (node);
				_tmp26_ = _tmp25_;
				_tmp27_ = node_image_get_width (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp24_, _tmp30_, NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strconcat (_tmp32_, "\" height=\"", NULL);
				_tmp34_ = _tmp33_;
				_tmp35_ = node_get_image (node);
				_tmp36_ = _tmp35_;
				_tmp37_ = node_image_get_height (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strdup_printf ("%i", _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_strconcat (_tmp34_, _tmp40_, NULL);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strconcat (_tmp42_, "\"/><br/>\n", NULL);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strconcat (_tmp44_, prefix, NULL);
				_tmp46_ = _tmp45_;
				_tmp47_ = g_strconcat (_tmp46_, "  ", NULL);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strconcat (_tmp19_, _tmp48_, NULL);
				_g_free0 (title);
				title = _tmp49_;
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp22_);
				_g_free0 (basename);
			}
			_g_free0 (file);
		}
		_tmp50_ = title;
		_tmp51_ = node_get_name (node);
		_tmp52_ = _tmp51_;
		_tmp53_ = canvas_text_get_text (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = formatted_text_get_text (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strconcat (prefix, " ", NULL);
		_tmp58_ = _tmp57_;
		_tmp59_ = string_replace (_tmp56_, "\n", _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_strconcat (_tmp60_, "\n", NULL);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_strconcat (_tmp50_, _tmp62_, NULL);
		_g_free0 (title);
		title = _tmp63_;
		_g_free0 (_tmp62_);
		_g_free0 (_tmp60_);
		_g_free0 (_tmp58_);
		_tmp64_ = title;
		_tmp65_ = string_get_data (_tmp64_, &_tmp66_);
		_tmp65__length1 = _tmp66_;
		_tmp67_ = _tmp65_;
		_tmp67__length1 = _tmp65__length1;
		g_output_stream_write ((GOutputStream*) os, _tmp67_, (gsize) _tmp67__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (title);
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp68_ = node_get_note (node);
		_tmp69_ = _tmp68_;
		if (g_strcmp0 (_tmp69_, "") != 0) {
			gchar* note = NULL;
			gchar* _tmp70_;
			gchar* _tmp71_;
			const gchar* _tmp72_;
			const gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			const gchar* _tmp84_;
			guint8* _tmp85_;
			gint _tmp85__length1;
			gint _tmp86_ = 0;
			guint8* _tmp87_;
			gint _tmp87__length1;
			_tmp70_ = g_strconcat (prefix, "  > ", NULL);
			_tmp71_ = _tmp70_;
			_tmp72_ = node_get_note (node);
			_tmp73_ = _tmp72_;
			_tmp74_ = g_strconcat ("\n", prefix, NULL);
			_tmp75_ = _tmp74_;
			_tmp76_ = g_strconcat (_tmp75_, "  > ", NULL);
			_tmp77_ = _tmp76_;
			_tmp78_ = string_replace (_tmp73_, "\n", _tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = g_strconcat (_tmp71_, _tmp79_, NULL);
			_tmp81_ = _tmp80_;
			_tmp82_ = g_strconcat (_tmp81_, "\n", NULL);
			_tmp83_ = _tmp82_;
			_g_free0 (_tmp81_);
			_g_free0 (_tmp79_);
			_g_free0 (_tmp77_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp71_);
			note = _tmp83_;
			_tmp84_ = note;
			_tmp85_ = string_get_data (_tmp84_, &_tmp86_);
			_tmp85__length1 = _tmp86_;
			_tmp87_ = _tmp85_;
			_tmp87__length1 = _tmp85__length1;
			g_output_stream_write ((GOutputStream*) os, _tmp87_, (gsize) _tmp87__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (note);
				_g_free0 (title);
				_g_free0 (_tmp0_);
				goto __catch0_g_error;
			}
			_g_free0 (note);
		}
		_tmp88_ = string_get_data ("\n", &_tmp89_);
		_tmp88__length1 = _tmp89_;
		_tmp90_ = _tmp88_;
		_tmp90__length1 = _tmp88__length1;
		g_output_stream_write ((GOutputStream*) os, _tmp90_, (gsize) _tmp90__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (title);
			_g_free0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp91_ = node_children (node);
		children = _tmp91_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp92_ = FALSE;
				_tmp92_ = TRUE;
				while (TRUE) {
					GArray* _tmp94_;
					GArray* _tmp95_;
					Node* _tmp96_;
					gchar* _tmp97_;
					gchar* _tmp98_;
					if (!_tmp92_) {
						gint _tmp93_;
						_tmp93_ = i;
						i = _tmp93_ + 1;
					}
					_tmp92_ = FALSE;
					_tmp94_ = children;
					if (!(((guint) i) < _tmp94_->len)) {
						break;
					}
					_tmp95_ = children;
					_tmp96_ = g_array_index (_tmp95_, Node*, (guint) i);
					_tmp97_ = g_strconcat (prefix, "  ", NULL);
					_tmp98_ = _tmp97_;
					export_markdown_export_node (self, os, im, _tmp96_, imgdir, _tmp98_);
					_g_free0 (_tmp98_);
				}
			}
		}
		_g_array_unref0 (children);
		_g_free0 (title);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
export_markdown_real_add_settings (Export* base,
                                   GtkGrid* grid)
{
	ExportMarkdown * self;
	self = (ExportMarkdown*) base;
	g_return_if_fail (grid != NULL);
	export_add_setting_bool ((Export*) self, "include-image-links", grid, _ ("Include image links"), _ ("Creates a directory containing the Markdown and embedded images"), FALSE);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
export_markdown_real_save_settings (Export* base,
                                    xmlNode* node)
{
	ExportMarkdown * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (ExportMarkdown*) base;
	_tmp0_ = bool_to_string (export_get_bool ((Export*) self, "include-image-links"));
	_tmp1_ = _tmp0_;
	xmlSetProp (node, (xmlChar*) "include-image-links", (xmlChar*) _tmp1_);
	_g_free0 (_tmp1_);
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
export_markdown_real_load_settings (Export* base,
                                    xmlNode* node)
{
	ExportMarkdown * self;
	gchar* i = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ExportMarkdown*) base;
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "include-image-links");
	i = _tmp0_;
	_tmp1_ = i;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = i;
		export_set_bool ((Export*) self, "include-image-links", bool_parse (_tmp2_));
	}
	_g_free0 (i);
}

static void
export_markdown_hier_copy (const ExportMarkdownHier* self,
                           ExportMarkdownHier* dest)
{
	Node* _tmp0_;
	Node* _tmp1_;
	(*dest).spaces = (*self).spaces;
	_tmp0_ = (*self).node;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).node);
	(*dest).node = _tmp1_;
}

static void
export_markdown_hier_destroy (ExportMarkdownHier* self)
{
	_g_object_unref0 ((*self).node);
}

static ExportMarkdownHier*
export_markdown_hier_dup (const ExportMarkdownHier* self)
{
	ExportMarkdownHier* dup;
	dup = g_new0 (ExportMarkdownHier, 1);
	export_markdown_hier_copy (self, dup);
	return dup;
}

static void
export_markdown_hier_free (ExportMarkdownHier* self)
{
	export_markdown_hier_destroy (self);
	g_free (self);
}

static GType
export_markdown_hier_get_type_once (void)
{
	GType export_markdown_hier_type_id;
	export_markdown_hier_type_id = g_boxed_type_register_static ("ExportMarkdownHier", (GBoxedCopyFunc) export_markdown_hier_dup, (GBoxedFreeFunc) export_markdown_hier_free);
	return export_markdown_hier_type_id;
}

static GType
export_markdown_hier_get_type (void)
{
	static volatile gsize export_markdown_hier_type_id__once = 0;
	if (g_once_init_enter (&export_markdown_hier_type_id__once)) {
		GType export_markdown_hier_type_id;
		export_markdown_hier_type_id = export_markdown_hier_get_type_once ();
		g_once_init_leave (&export_markdown_hier_type_id__once, export_markdown_hier_type_id);
	}
	return export_markdown_hier_type_id__once;
}

static void
export_markdown_class_init (ExportMarkdownClass * klass,
                            gpointer klass_data)
{
	export_markdown_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->import = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_markdown_real_import;
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_markdown_real_export;
	((ExportClass *) klass)->add_settings = (void (*) (Export*, GtkGrid*)) export_markdown_real_add_settings;
	((ExportClass *) klass)->save_settings = (void (*) (Export*, xmlNode*)) export_markdown_real_save_settings;
	((ExportClass *) klass)->load_settings = (void (*) (Export*, xmlNode*)) export_markdown_real_load_settings;
}

static void
export_markdown_instance_init (ExportMarkdown * self,
                               gpointer klass)
{
}

static GType
export_markdown_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportMarkdownClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_markdown_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportMarkdown), 0, (GInstanceInitFunc) export_markdown_instance_init, NULL };
	GType export_markdown_type_id;
	export_markdown_type_id = g_type_register_static (TYPE_EXPORT, "ExportMarkdown", &g_define_type_info, 0);
	return export_markdown_type_id;
}

GType
export_markdown_get_type (void)
{
	static volatile gsize export_markdown_type_id__once = 0;
	if (g_once_init_enter (&export_markdown_type_id__once)) {
		GType export_markdown_type_id;
		export_markdown_type_id = export_markdown_get_type_once ();
		g_once_init_leave (&export_markdown_type_id__once, export_markdown_type_id);
	}
	return export_markdown_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

