/* UndoTextMultiInsert.c generated by valac 0.56.18, the Vala compiler
 * generated from UndoTextMultiInsert.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_INSERT_TEXT (insert_text_get_type ())
typedef struct _InsertText InsertText;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;
typedef struct _UndoItemPrivate UndoItemPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_UNDO_TEXT_ITEM (undo_text_item_get_type ())
#define UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItem))
#define UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))
#define IS_UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_ITEM))
#define IS_UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_ITEM))
#define UNDO_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))

typedef struct _UndoTextItem UndoTextItem;
typedef struct _UndoTextItemClass UndoTextItemClass;
typedef struct _UndoTextItemPrivate UndoTextItemPrivate;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_UNDO_TEXT_MULTI_INSERT (undo_text_multi_insert_get_type ())
#define UNDO_TEXT_MULTI_INSERT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_MULTI_INSERT, UndoTextMultiInsert))
#define UNDO_TEXT_MULTI_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_MULTI_INSERT, UndoTextMultiInsertClass))
#define IS_UNDO_TEXT_MULTI_INSERT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_MULTI_INSERT))
#define IS_UNDO_TEXT_MULTI_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_MULTI_INSERT))
#define UNDO_TEXT_MULTI_INSERT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_MULTI_INSERT, UndoTextMultiInsertClass))

typedef struct _UndoTextMultiInsert UndoTextMultiInsert;
typedef struct _UndoTextMultiInsertClass UndoTextMultiInsertClass;
typedef struct _UndoTextMultiInsertPrivate UndoTextMultiInsertPrivate;
enum  {
	UNDO_TEXT_MULTI_INSERT_0_PROPERTY,
	UNDO_TEXT_MULTI_INSERT_NUM_PROPERTIES
};
static GParamSpec* undo_text_multi_insert_properties[UNDO_TEXT_MULTI_INSERT_NUM_PROPERTIES];
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef enum  {
	UNDO_TEXT_OP_INSERT = 0,
	UNDO_TEXT_OP_DELETE,
	UNDO_TEXT_OP_REPLACE,
	UNDO_TEXT_OP_TAGADD,
	UNDO_TEXT_OP_TAGDEL,
	UNDO_TEXT_OP_TAGCLEAR
} UndoTextOp;

#define TYPE_UNDO_TEXT_OP (undo_text_op_get_type ())

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
#define _insert_text_free0(var) ((var == NULL) ? NULL : (var = (insert_text_free (var), NULL)))

struct _InsertText {
	gint start;
	gchar* text;
};

struct _UndoItem {
	GObject parent_instance;
	UndoItemPrivate * priv;
};

struct _UndoItemClass {
	GObjectClass parent_class;
	void (*undo) (UndoItem* self, DrawArea* da);
	void (*redo) (UndoItem* self, DrawArea* da);
	gboolean (*matches) (UndoItem* self, UndoItem* item);
	void (*replace_with_item) (UndoItem* self, UndoItem* item);
	gchar* (*to_string) (UndoItem* self);
};

struct _UndoTextItem {
	UndoItem parent_instance;
	UndoTextItemPrivate * priv;
};

struct _UndoTextItemClass {
	UndoItemClass parent_class;
	gboolean (*merge) (UndoTextItem* self, CanvasText* ct, UndoTextItem* item);
	void (*undo_text) (UndoTextItem* self, DrawArea* da, CanvasText* ct);
	void (*redo_text) (UndoTextItem* self, DrawArea* da, CanvasText* ct);
};

struct _UndoTextMultiInsert {
	UndoTextItem parent_instance;
	UndoTextMultiInsertPrivate * priv;
};

struct _UndoTextMultiInsertClass {
	UndoTextItemClass parent_class;
};

struct _UndoTextMultiInsertPrivate {
	GArray* _inserts;
};

static gint UndoTextMultiInsert_private_offset;
static gpointer undo_text_multi_insert_parent_class = NULL;

VALA_EXTERN GType insert_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN InsertText* insert_text_dup (const InsertText* self);
VALA_EXTERN void insert_text_free (InsertText* self);
VALA_EXTERN void insert_text_copy (const InsertText* self,
                       InsertText* dest);
VALA_EXTERN void insert_text_destroy (InsertText* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (InsertText, insert_text_destroy)
VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType undo_text_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextItem, g_object_unref)
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType undo_text_multi_insert_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextMultiInsert, g_object_unref)
VALA_EXTERN void undo_text_item_undo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN void undo_text_item_redo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN UndoTextMultiInsert* undo_text_multi_insert_new (GArray* inserts,
                                                 gint start_cursor,
                                                 gint end_cursor);
VALA_EXTERN UndoTextMultiInsert* undo_text_multi_insert_construct (GType object_type,
                                                       GArray* inserts,
                                                       gint start_cursor,
                                                       gint end_cursor);
VALA_EXTERN GType undo_text_op_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UndoTextItem* undo_text_item_new (const gchar* name,
                                  UndoTextOp op,
                                  gint start_cursor,
                                  gint end_cursor);
VALA_EXTERN UndoTextItem* undo_text_item_construct (GType object_type,
                                        const gchar* name,
                                        UndoTextOp op,
                                        gint start_cursor,
                                        gint end_cursor);
static void undo_text_multi_insert_real_undo_text (UndoTextItem* base,
                                            DrawArea* da,
                                            CanvasText* ct);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN void formatted_text_remove_text (FormattedText* self,
                                 gint index,
                                 gint chars);
VALA_EXTERN void canvas_text_set_cursor_only (CanvasText* self,
                                  gint cursor);
VALA_EXTERN gint undo_text_item_get_start_cursor (UndoTextItem* self);
static void undo_text_multi_insert_real_redo_text (UndoTextItem* base,
                                            DrawArea* da,
                                            CanvasText* ct);
VALA_EXTERN void formatted_text_insert_text (FormattedText* self,
                                 gint index,
                                 const gchar* str);
VALA_EXTERN gint undo_text_item_get_end_cursor (UndoTextItem* self);
static void undo_text_multi_insert_finalize (GObject * obj);
static GType undo_text_multi_insert_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
insert_text_copy (const InsertText* self,
                  InsertText* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	(*dest).start = (*self).start;
	_tmp0_ = (*self).text;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).text);
	(*dest).text = _tmp1_;
}

void
insert_text_destroy (InsertText* self)
{
	_g_free0 ((*self).text);
}

InsertText*
insert_text_dup (const InsertText* self)
{
	InsertText* dup;
	dup = g_new0 (InsertText, 1);
	insert_text_copy (self, dup);
	return dup;
}

void
insert_text_free (InsertText* self)
{
	insert_text_destroy (self);
	g_free (self);
}

static GType
insert_text_get_type_once (void)
{
	GType insert_text_type_id;
	insert_text_type_id = g_boxed_type_register_static ("InsertText", (GBoxedCopyFunc) insert_text_dup, (GBoxedFreeFunc) insert_text_free);
	return insert_text_type_id;
}

GType
insert_text_get_type (void)
{
	static volatile gsize insert_text_type_id__once = 0;
	if (g_once_init_enter (&insert_text_type_id__once)) {
		GType insert_text_type_id;
		insert_text_type_id = insert_text_get_type_once ();
		g_once_init_leave (&insert_text_type_id__once, insert_text_type_id);
	}
	return insert_text_type_id__once;
}

static inline gpointer
undo_text_multi_insert_get_instance_private (UndoTextMultiInsert* self)
{
	return G_STRUCT_MEMBER_P (self, UndoTextMultiInsert_private_offset);
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

UndoTextMultiInsert*
undo_text_multi_insert_construct (GType object_type,
                                  GArray* inserts,
                                  gint start_cursor,
                                  gint end_cursor)
{
	UndoTextMultiInsert * self = NULL;
	GArray* _tmp0_;
	g_return_val_if_fail (inserts != NULL, NULL);
	self = (UndoTextMultiInsert*) undo_text_item_construct (object_type, _ ("text insertion"), UNDO_TEXT_OP_INSERT, start_cursor, end_cursor);
	_tmp0_ = _g_array_ref0 (inserts);
	_g_array_unref0 (self->priv->_inserts);
	self->priv->_inserts = _tmp0_;
	return self;
}

UndoTextMultiInsert*
undo_text_multi_insert_new (GArray* inserts,
                            gint start_cursor,
                            gint end_cursor)
{
	return undo_text_multi_insert_construct (TYPE_UNDO_TEXT_MULTI_INSERT, inserts, start_cursor, end_cursor);
}

static gpointer
_insert_text_dup0 (gpointer self)
{
	return self ? insert_text_dup (self) : NULL;
}

static void
undo_text_multi_insert_real_undo_text (UndoTextItem* base,
                                       DrawArea* da,
                                       CanvasText* ct)
{
	UndoTextMultiInsert * self;
	gint _tmp12_;
	gint _tmp13_;
	self = (UndoTextMultiInsert*) base;
	g_return_if_fail (da != NULL);
	g_return_if_fail (ct != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				InsertText* insert = NULL;
				GArray* _tmp3_;
				InsertText* _tmp4_;
				FormattedText* _tmp5_;
				FormattedText* _tmp6_;
				InsertText* _tmp7_;
				InsertText* _tmp8_;
				const gchar* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_inserts;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_inserts;
				_tmp4_ = _insert_text_dup0 (g_array_index (_tmp3_, InsertText*, (guint) i));
				insert = _tmp4_;
				_tmp5_ = canvas_text_get_text (ct);
				_tmp6_ = _tmp5_;
				_tmp7_ = insert;
				_tmp8_ = insert;
				_tmp9_ = (*_tmp8_).text;
				_tmp10_ = strlen (_tmp9_);
				_tmp11_ = _tmp10_;
				formatted_text_remove_text (_tmp6_, (*_tmp7_).start, _tmp11_);
				_insert_text_free0 (insert);
			}
		}
	}
	_tmp12_ = undo_text_item_get_start_cursor ((UndoTextItem*) self);
	_tmp13_ = _tmp12_;
	canvas_text_set_cursor_only (ct, _tmp13_);
	gtk_widget_queue_draw ((GtkWidget*) da);
}

static void
undo_text_multi_insert_real_redo_text (UndoTextItem* base,
                                       DrawArea* da,
                                       CanvasText* ct)
{
	UndoTextMultiInsert * self;
	gint _tmp10_;
	gint _tmp11_;
	self = (UndoTextMultiInsert*) base;
	g_return_if_fail (da != NULL);
	g_return_if_fail (ct != NULL);
	{
		gint i = 0;
		GArray* _tmp0_;
		_tmp0_ = self->priv->_inserts;
		i = (gint) (_tmp0_->len - 1);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				InsertText* insert = NULL;
				GArray* _tmp3_;
				InsertText* _tmp4_;
				FormattedText* _tmp5_;
				FormattedText* _tmp6_;
				InsertText* _tmp7_;
				InsertText* _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp3_ = self->priv->_inserts;
				_tmp4_ = _insert_text_dup0 (g_array_index (_tmp3_, InsertText*, (guint) i));
				insert = _tmp4_;
				_tmp5_ = canvas_text_get_text (ct);
				_tmp6_ = _tmp5_;
				_tmp7_ = insert;
				_tmp8_ = insert;
				_tmp9_ = (*_tmp8_).text;
				formatted_text_insert_text (_tmp6_, (*_tmp7_).start, _tmp9_);
				_insert_text_free0 (insert);
			}
		}
	}
	_tmp10_ = undo_text_item_get_end_cursor ((UndoTextItem*) self);
	_tmp11_ = _tmp10_;
	canvas_text_set_cursor_only (ct, _tmp11_);
	gtk_widget_queue_draw ((GtkWidget*) da);
}

static void
undo_text_multi_insert_class_init (UndoTextMultiInsertClass * klass,
                                   gpointer klass_data)
{
	undo_text_multi_insert_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UndoTextMultiInsert_private_offset);
	((UndoTextItemClass *) klass)->undo_text = (void (*) (UndoTextItem*, DrawArea*, CanvasText*)) undo_text_multi_insert_real_undo_text;
	((UndoTextItemClass *) klass)->redo_text = (void (*) (UndoTextItem*, DrawArea*, CanvasText*)) undo_text_multi_insert_real_redo_text;
	G_OBJECT_CLASS (klass)->finalize = undo_text_multi_insert_finalize;
}

static void
undo_text_multi_insert_instance_init (UndoTextMultiInsert * self,
                                      gpointer klass)
{
	self->priv = undo_text_multi_insert_get_instance_private (self);
}

static void
undo_text_multi_insert_finalize (GObject * obj)
{
	UndoTextMultiInsert * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNDO_TEXT_MULTI_INSERT, UndoTextMultiInsert);
	_g_array_unref0 (self->priv->_inserts);
	G_OBJECT_CLASS (undo_text_multi_insert_parent_class)->finalize (obj);
}

static GType
undo_text_multi_insert_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UndoTextMultiInsertClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) undo_text_multi_insert_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UndoTextMultiInsert), 0, (GInstanceInitFunc) undo_text_multi_insert_instance_init, NULL };
	GType undo_text_multi_insert_type_id;
	undo_text_multi_insert_type_id = g_type_register_static (TYPE_UNDO_TEXT_ITEM, "UndoTextMultiInsert", &g_define_type_info, 0);
	UndoTextMultiInsert_private_offset = g_type_add_instance_private (undo_text_multi_insert_type_id, sizeof (UndoTextMultiInsertPrivate));
	return undo_text_multi_insert_type_id;
}

GType
undo_text_multi_insert_get_type (void)
{
	static volatile gsize undo_text_multi_insert_type_id__once = 0;
	if (g_once_init_enter (&undo_text_multi_insert_type_id__once)) {
		GType undo_text_multi_insert_type_id;
		undo_text_multi_insert_type_id = undo_text_multi_insert_get_type_once ();
		g_once_init_leave (&undo_text_multi_insert_type_id__once, undo_text_multi_insert_type_id);
	}
	return undo_text_multi_insert_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

