/* FILE GENERATED BY /build/naev/src/naev-0.13.3/build/../src/colours_c_gen.py */
#ifdef _WIN32
#include <string.h>
#define strcasecmp _stricmp
#else
#include <strings.h>
#endif

#include <stdlib.h>
#include "colour.h"
#include "log.h"

#define NUM_COLOURS    72

const glColour cAqua = { .r=0.0, .g=0.5225215539683921, .b=1.0, .a=1.0 };
const glColour cAquaBlue = { .r=0.07323895587840543, .g=0.07323895587840543, .b=0.7874122893956174, .a=1.0 };
const glColour cArmour = { .r=0.21404114048223255, .g=0.21404114048223255, .b=0.21404114048223255, .a=1.0 };
const glColour cBlack = { .r=0.0, .g=0.0, .b=0.0, .a=1.0 };
const glColour cBlackHilight = { .r=0.0, .g=0.0, .b=0.0, .a=0.4 };
const glColour cBlue = { .r=0.033104766570885055, .g=0.033104766570885055, .b=0.6038273388553378, .a=1.0 };
const glColour cBrightRed = { .r=1.0, .g=0.31854677812509186, .b=0.31854677812509186, .a=1.0 };
const glColour cBrown = { .r=0.30699931892751636, .g=0.06372379528489175, .b=0.0, .a=1.0 };
const glColour cCyan = { .r=0.0, .g=1.0, .b=1.0, .a=1.0 };
const glColour cDarkBlue = { .r=0.010022825574869039, .g=0.010022825574869039, .b=0.31854677812509186, .a=1.0 };
const glColour cDarkGreen = { .r=0.010022825574869039, .g=0.21404114048223255, .b=0.010022825574869039, .a=1.0 };
const glColour cDarkPurple = { .r=0.4200332886842154, .g=0.027211780951381357, .b=0.3672464682101826, .a=1.0 };
const glColour cDarkRed = { .r=0.31854677812509186, .g=0.010022825574869039, .b=0.010022825574869039, .a=1.0 };
const glColour cEnergy = { .r=0.033104766570885055, .g=0.6038273388553378, .b=0.033104766570885055, .a=1.0 };
const glColour cFontBlue = { .r=0.13286832155381798, .g=0.31854677812509186, .b=1.0, .a=1.0 };
const glColour cFontGreen = { .r=0.31854677812509186, .g=1.0, .b=0.13286832155381798, .a=1.0 };
const glColour cFontGrey = { .r=0.44798841244188325, .g=0.44798841244188325, .b=0.44798841244188325, .a=1.0 };
const glColour cFontOrange = { .r=1.0, .g=0.44798841244188325, .b=0.07323895587840543, .a=1.0 };
const glColour cFontPurple = { .r=1.0, .g=0.07323895587840543, .b=1.0, .a=1.0 };
const glColour cFontRed = { .r=1.0, .g=0.13286832155381798, .b=0.13286832155381798, .a=1.0 };
const glColour cFontWhite = { .r=0.8900054069935289, .g=0.8900054069935289, .b=0.8900054069935289, .a=1.0 };
const glColour cFontYellow = { .r=1.0, .g=1.0, .b=0.21404114048223255, .a=1.0 };
const glColour cFriend = { .r=0.05780543019106723, .g=0.4019777798321958, .b=0.31854677812509186, .a=1.0 };
const glColour cFuel = { .r=0.7874122893956174, .g=0.010022825574869039, .b=0.13286832155381798, .a=1.0 };
const glColour cGold = { .r=1.0, .g=0.6738595407338318, .b=0.0, .a=1.0 };
const glColour cGreen = { .r=0.033104766570885055, .g=0.6038273388553378, .b=0.033104766570885055, .a=1.0 };
const glColour cGrey10 = { .r=0.010022825574869039, .g=0.010022825574869039, .b=0.010022825574869039, .a=1.0 };
const glColour cGrey15 = { .r=0.01960664851623822, .g=0.01960664851623822, .b=0.01960664851623822, .a=1.0 };
const glColour cGrey20 = { .r=0.033104766570885055, .g=0.033104766570885055, .b=0.033104766570885055, .a=1.0 };
const glColour cGrey25 = { .r=0.05087608817155679, .g=0.05087608817155679, .b=0.05087608817155679, .a=1.0 };
const glColour cGrey30 = { .r=0.07323895587840543, .g=0.07323895587840543, .b=0.07323895587840543, .a=1.0 };
const glColour cGrey35 = { .r=0.10048150993772331, .g=0.10048150993772331, .b=0.10048150993772331, .a=1.0 };
const glColour cGrey40 = { .r=0.13286832155381798, .g=0.13286832155381798, .b=0.13286832155381798, .a=1.0 };
const glColour cGrey45 = { .r=0.17064493581555268, .g=0.17064493581555268, .b=0.17064493581555268, .a=1.0 };
const glColour cGrey5 = { .r=0.003935939504088967, .g=0.003935939504088967, .b=0.003935939504088967, .a=1.0 };
const glColour cGrey50 = { .r=0.21404114048223255, .g=0.21404114048223255, .b=0.21404114048223255, .a=1.0 };
const glColour cGrey60 = { .r=0.31854677812509186, .g=0.31854677812509186, .b=0.31854677812509186, .a=1.0 };
const glColour cGrey70 = { .r=0.44798841244188325, .g=0.44798841244188325, .b=0.44798841244188325, .a=1.0 };
const glColour cGrey80 = { .r=0.6038273388553378, .g=0.6038273388553378, .b=0.6038273388553378, .a=1.0 };
const glColour cGrey90 = { .r=0.7874122893956174, .g=0.7874122893956174, .b=0.7874122893956174, .a=1.0 };
const glColour cHostile = { .r=0.6038273388553378, .g=0.05780543019106723, .b=0.31854677812509186, .a=1.0 };
const glColour cInert = { .r=0.7230551289219693, .g=0.7230551289219693, .b=0.7230551289219693, .a=1.0 };
const glColour cLightBlue = { .r=0.13286832155381798, .g=0.13286832155381798, .b=1.0, .a=1.0 };
const glColour cMarkerComputer = { .r=0.033104766570885055, .g=0.4969329950608704, .b=0.8549926081242338, .a=1.0 };
const glColour cMarkerHigh = { .r=0.8549926081242338, .g=0.184474994500441, .b=0.033104766570885055, .a=1.0 };
const glColour cMarkerLow = { .r=0.0, .g=0.31854677812509186, .b=0.24620132670783548, .a=1.0 };
const glColour cMarkerNew = { .r=0.033104766570885055, .g=0.4969329950608704, .b=0.8549926081242338, .a=1.0 };
const glColour cMarkerPlot = { .r=0.8549926081242338, .g=0.033104766570885055, .b=0.184474994500441, .a=1.0 };
const glColour cMidnightBlue = { .r=0.010022825574869039, .g=0.010022825574869039, .b=0.13286832155381798, .a=1.0 };
const glColour cNeutral = { .r=0.7230551289219693, .g=0.6038273388553378, .b=0.184474994500441, .a=1.0 };
const glColour cOrange = { .r=0.7874122893956174, .g=0.44798841244188325, .b=0.010022825574869039, .a=1.0 };
const glColour cOutfitHeavy = { .r=0.6038273388553378, .g=0.13286832155381798, .b=0.1788675039555289, .a=1.0 };
const glColour cOutfitLight = { .r=0.5225215539683921, .g=0.44798841244188325, .b=0.13286832155381798, .a=1.0 };
const glColour cOutfitMedium = { .r=0.021980947079887205, .g=0.3546920614940455, .b=0.6209158623742829, .a=1.0 };
const glColour cPrimeBlue = { .r=0.0, .g=0.0, .b=1.0, .a=1.0 };
const glColour cPrimeGreen = { .r=0.0, .g=1.0, .b=0.0, .a=1.0 };
const glColour cPrimeRed = { .r=1.0, .g=0.0, .b=0.0, .a=1.0 };
const glColour cPurple = { .r=0.7874122893956174, .g=0.010022825574869039, .b=0.7874122893956174, .a=1.0 };
const glColour cRadar_hilight = { .r=0.31854677812509186, .g=1.0, .b=1.0, .a=1.0 };
const glColour cRadar_player = { .r=0.7874122893956174, .g=0.010022825574869039, .b=0.7874122893956174, .a=1.0 };
const glColour cRadar_scanning = { .r=1.0, .g=1.0, .b=0.31854677812509186, .a=1.0 };
const glColour cRadar_tPilot = { .r=1.0, .g=1.0, .b=1.0, .a=1.0 };
const glColour cRadar_tSpob = { .r=1.0, .g=1.0, .b=1.0, .a=1.0 };
const glColour cRadar_viewport = { .r=1.0, .g=1.0, .b=1.0, .a=0.5 };
const glColour cRadar_weap = { .r=0.6038273388553378, .g=0.033104766570885055, .b=0.033104766570885055, .a=1.0 };
const glColour cRed = { .r=0.6038273388553378, .g=0.033104766570885055, .b=0.033104766570885055, .a=1.0 };
const glColour cRestricted = { .r=0.7230551289219693, .g=0.31854677812509186, .b=0.033104766570885055, .a=1.0 };
const glColour cShield = { .r=0.033104766570885055, .g=0.033104766570885055, .b=0.6038273388553378, .a=1.0 };
const glColour cSilver = { .r=0.5225215539683921, .g=0.5225215539683921, .b=0.5225215539683921, .a=1.0 };
const glColour cTransparent = { .r=0.0, .g=0.0, .b=0.0, .a=0.0 };
const glColour cWhite = { .r=1.0, .g=1.0, .b=1.0, .a=1.0 };
const glColour cYellow = { .r=0.6038273388553378, .g=0.6038273388553378, .b=0.0, .a=1.0 };

typedef struct ColourSort_s {
   const char *name;
   const glColour *c;
} ColourSort_t;
const ColourSort_t col_list[NUM_COLOURS] = {
   { .name="Aqua", .c=&cAqua },
   { .name="AquaBlue", .c=&cAquaBlue },
   { .name="Armour", .c=&cArmour },
   { .name="Black", .c=&cBlack },
   { .name="BlackHilight", .c=&cBlackHilight },
   { .name="Blue", .c=&cBlue },
   { .name="BrightRed", .c=&cBrightRed },
   { .name="Brown", .c=&cBrown },
   { .name="Cyan", .c=&cCyan },
   { .name="DarkBlue", .c=&cDarkBlue },
   { .name="DarkGreen", .c=&cDarkGreen },
   { .name="DarkPurple", .c=&cDarkPurple },
   { .name="DarkRed", .c=&cDarkRed },
   { .name="Energy", .c=&cEnergy },
   { .name="FontBlue", .c=&cFontBlue },
   { .name="FontGreen", .c=&cFontGreen },
   { .name="FontGrey", .c=&cFontGrey },
   { .name="FontOrange", .c=&cFontOrange },
   { .name="FontPurple", .c=&cFontPurple },
   { .name="FontRed", .c=&cFontRed },
   { .name="FontWhite", .c=&cFontWhite },
   { .name="FontYellow", .c=&cFontYellow },
   { .name="Friend", .c=&cFriend },
   { .name="Fuel", .c=&cFuel },
   { .name="Gold", .c=&cGold },
   { .name="Green", .c=&cGreen },
   { .name="Grey10", .c=&cGrey10 },
   { .name="Grey15", .c=&cGrey15 },
   { .name="Grey20", .c=&cGrey20 },
   { .name="Grey25", .c=&cGrey25 },
   { .name="Grey30", .c=&cGrey30 },
   { .name="Grey35", .c=&cGrey35 },
   { .name="Grey40", .c=&cGrey40 },
   { .name="Grey45", .c=&cGrey45 },
   { .name="Grey5", .c=&cGrey5 },
   { .name="Grey50", .c=&cGrey50 },
   { .name="Grey60", .c=&cGrey60 },
   { .name="Grey70", .c=&cGrey70 },
   { .name="Grey80", .c=&cGrey80 },
   { .name="Grey90", .c=&cGrey90 },
   { .name="Hostile", .c=&cHostile },
   { .name="Inert", .c=&cInert },
   { .name="LightBlue", .c=&cLightBlue },
   { .name="MarkerComputer", .c=&cMarkerComputer },
   { .name="MarkerHigh", .c=&cMarkerHigh },
   { .name="MarkerLow", .c=&cMarkerLow },
   { .name="MarkerNew", .c=&cMarkerNew },
   { .name="MarkerPlot", .c=&cMarkerPlot },
   { .name="MidnightBlue", .c=&cMidnightBlue },
   { .name="Neutral", .c=&cNeutral },
   { .name="Orange", .c=&cOrange },
   { .name="OutfitHeavy", .c=&cOutfitHeavy },
   { .name="OutfitLight", .c=&cOutfitLight },
   { .name="OutfitMedium", .c=&cOutfitMedium },
   { .name="PrimeBlue", .c=&cPrimeBlue },
   { .name="PrimeGreen", .c=&cPrimeGreen },
   { .name="PrimeRed", .c=&cPrimeRed },
   { .name="Purple", .c=&cPurple },
   { .name="Radar_hilight", .c=&cRadar_hilight },
   { .name="Radar_player", .c=&cRadar_player },
   { .name="Radar_scanning", .c=&cRadar_scanning },
   { .name="Radar_tPilot", .c=&cRadar_tPilot },
   { .name="Radar_tSpob", .c=&cRadar_tSpob },
   { .name="Radar_viewport", .c=&cRadar_viewport },
   { .name="Radar_weap", .c=&cRadar_weap },
   { .name="Red", .c=&cRed },
   { .name="Restricted", .c=&cRestricted },
   { .name="Shield", .c=&cShield },
   { .name="Silver", .c=&cSilver },
   { .name="Transparent", .c=&cTransparent },
   { .name="White", .c=&cWhite },
   { .name="Yellow", .c=&cYellow },

};

static int colour_cmp( const void *p1, const void *p2 )
{
   const ColourSort_t *c1, *c2;
   c1 = (const ColourSort_t*) p1;
   c2 = (const ColourSort_t*) p2;
   return strcasecmp( c1->name, c2->name );
}

const glColour* col_fromName( const char* name )
{
   const ColourSort_t k = { .name = name };
   const ColourSort_t *q = bsearch( &k, col_list, NUM_COLOURS, sizeof(ColourSort_t), colour_cmp );
   if (q==NULL) {
      WARN(_("Unknown colour '%s'!"),name);
      return NULL;
   }
   return q->c;
}