/* ConversationItemModel.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ConversationItemModel.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <camel/camel.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_CONVERSATION_ITEM_MODEL (mail_conversation_item_model_get_type ())
#define MAIL_CONVERSATION_ITEM_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel))
#define MAIL_CONVERSATION_ITEM_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModelClass))
#define MAIL_IS_CONVERSATION_ITEM_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_CONVERSATION_ITEM_MODEL))
#define MAIL_IS_CONVERSATION_ITEM_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_CONVERSATION_ITEM_MODEL))
#define MAIL_CONVERSATION_ITEM_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModelClass))

typedef struct _MailConversationItemModel MailConversationItemModel;
typedef struct _MailConversationItemModelClass MailConversationItemModelClass;
typedef struct _MailConversationItemModelPrivate MailConversationItemModelPrivate;
enum  {
	MAIL_CONVERSATION_ITEM_MODEL_0_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_SERVICE_UID_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_NODE_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_THREAD_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_TIMESTAMP_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_FOLDER_INFO_FLAGS_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_HIDDEN_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_FORMATTED_DATE_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_NUM_MESSAGES_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_FROM_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_TO_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_SUBJECT_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_FLAGGED_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_FORWARDED_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_REPLIED_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_REPLIED_ALL_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_UNREAD_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_DELETED_PROPERTY,
	MAIL_CONVERSATION_ITEM_MODEL_NUM_PROPERTIES
};
static GParamSpec* mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _MailConversationItemModel {
	GObject parent_instance;
	MailConversationItemModelPrivate * priv;
};

struct _MailConversationItemModelClass {
	GObjectClass parent_class;
};

struct _MailConversationItemModelPrivate {
	gchar* _service_uid;
	CamelFolderThreadNode* _node;
	CamelFolderThread* _thread;
	gint64 _timestamp;
	CamelFolderInfoFlags _folder_info_flags;
	gboolean _hidden;
};

static gint MailConversationItemModel_private_offset;
static gpointer mail_conversation_item_model_parent_class = NULL;

VALA_EXTERN GType mail_conversation_item_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailConversationItemModel, g_object_unref)
VALA_EXTERN MailConversationItemModel* mail_conversation_item_model_new (CamelFolderInfoFlags folder_info_flags,
                                                             CamelFolderThreadNode* node,
                                                             CamelFolderThread* thread,
                                                             const gchar* service_uid);
VALA_EXTERN MailConversationItemModel* mail_conversation_item_model_construct (GType object_type,
                                                                   CamelFolderInfoFlags folder_info_flags,
                                                                   CamelFolderThreadNode* node,
                                                                   CamelFolderThread* thread,
                                                                   const gchar* service_uid);
VALA_EXTERN gboolean mail_conversation_item_model_is_older_than (MailConversationItemModel* self,
                                                     CamelFolderThreadNode* other_node);
static gint64 mail_conversation_item_model_get_newest_timestamp (CamelFolderThreadNode* node,
                                                          gint64 highest);
VALA_EXTERN gint64 mail_conversation_item_model_get_timestamp (MailConversationItemModel* self);
static guint mail_conversation_item_model_count_thread_messages (CamelFolderThreadNode* node);
static gboolean mail_conversation_item_model_has_thread_flag (CamelFolderThreadNode* node,
                                                       CamelMessageFlags flag);
VALA_EXTERN const gchar* mail_conversation_item_model_get_service_uid (MailConversationItemModel* self);
static void mail_conversation_item_model_set_service_uid (MailConversationItemModel* self,
                                                   const gchar* value);
VALA_EXTERN CamelFolderThreadNode* mail_conversation_item_model_get_node (MailConversationItemModel* self);
static void mail_conversation_item_model_set_node (MailConversationItemModel* self,
                                            CamelFolderThreadNode* value);
VALA_EXTERN CamelFolderThread* mail_conversation_item_model_get_thread (MailConversationItemModel* self);
static void mail_conversation_item_model_set_thread (MailConversationItemModel* self,
                                              CamelFolderThread* value);
static void mail_conversation_item_model_set_timestamp (MailConversationItemModel* self,
                                                 gint64 value);
VALA_EXTERN CamelFolderInfoFlags mail_conversation_item_model_get_folder_info_flags (MailConversationItemModel* self);
static void mail_conversation_item_model_set_folder_info_flags (MailConversationItemModel* self,
                                                         CamelFolderInfoFlags value);
VALA_EXTERN gboolean mail_conversation_item_model_get_hidden (MailConversationItemModel* self);
VALA_EXTERN void mail_conversation_item_model_set_hidden (MailConversationItemModel* self,
                                              gboolean value);
VALA_EXTERN gchar* mail_conversation_item_model_get_formatted_date (MailConversationItemModel* self);
VALA_EXTERN guint mail_conversation_item_model_get_num_messages (MailConversationItemModel* self);
VALA_EXTERN gchar* mail_conversation_item_model_get_from (MailConversationItemModel* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN gchar* mail_conversation_item_model_get_to (MailConversationItemModel* self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN const gchar* mail_conversation_item_model_get_subject (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_flagged (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_forwarded (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_replied (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_replied_all (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_unread (MailConversationItemModel* self);
VALA_EXTERN gboolean mail_conversation_item_model_get_deleted (MailConversationItemModel* self);
static GObject * mail_conversation_item_model_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void mail_conversation_item_model_finalize (GObject * obj);
static GType mail_conversation_item_model_get_type_once (void);
static void _vala_mail_conversation_item_model_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_mail_conversation_item_model_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
mail_conversation_item_model_get_instance_private (MailConversationItemModel* self)
{
	return G_STRUCT_MEMBER_P (self, MailConversationItemModel_private_offset);
}

MailConversationItemModel*
mail_conversation_item_model_construct (GType object_type,
                                        CamelFolderInfoFlags folder_info_flags,
                                        CamelFolderThreadNode* node,
                                        CamelFolderThread* thread,
                                        const gchar* service_uid)
{
	MailConversationItemModel * self = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (thread != NULL, NULL);
	g_return_val_if_fail (service_uid != NULL, NULL);
	self = (MailConversationItemModel*) g_object_new (object_type, "service-uid", service_uid, "node", node, "thread", thread, "folder-info-flags", folder_info_flags, NULL);
	return self;
}

MailConversationItemModel*
mail_conversation_item_model_new (CamelFolderInfoFlags folder_info_flags,
                                  CamelFolderThreadNode* node,
                                  CamelFolderThread* thread,
                                  const gchar* service_uid)
{
	return mail_conversation_item_model_construct (MAIL_TYPE_CONVERSATION_ITEM_MODEL, folder_info_flags, node, thread, service_uid);
}

gboolean
mail_conversation_item_model_is_older_than (MailConversationItemModel* self,
                                            CamelFolderThreadNode* other_node)
{
	gint64 other_timestamp = 0LL;
	gint64 _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other_node != NULL, FALSE);
	other_timestamp = mail_conversation_item_model_get_newest_timestamp (other_node, (gint64) -1);
	_tmp0_ = self->priv->_timestamp;
	result = _tmp0_ < other_timestamp;
	return result;
}

static guint
mail_conversation_item_model_count_thread_messages (CamelFolderThreadNode* node)
{
	guint i = 0U;
	guint result;
	g_return_val_if_fail (node != NULL, 0U);
	i = (guint) 1;
	{
		CamelFolderThreadNode* child = NULL;
		CamelFolderThreadNode* _tmp0_;
		_tmp0_ = camel_folder_thread_node_get_child (node);
		child = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				CamelFolderThreadNode* _tmp4_;
				CamelFolderThreadNode* _tmp5_;
				if (!_tmp1_) {
					CamelFolderThreadNode* _tmp2_;
					CamelFolderThreadNode* _tmp3_;
					_tmp2_ = child;
					_tmp3_ = camel_folder_thread_node_get_next (_tmp2_);
					child = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = child;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = child;
				i += mail_conversation_item_model_count_thread_messages (_tmp5_);
			}
		}
	}
	result = i;
	return result;
}

static gint64
mail_conversation_item_model_get_newest_timestamp (CamelFolderThreadNode* node,
                                                   gint64 highest)
{
	gint64 time = 0LL;
	CamelMessageInfo* message = NULL;
	void* _tmp0_;
	CamelMessageInfo* _tmp1_;
	gint64 result;
	time = highest;
	if (node == NULL) {
		result = time;
		return result;
	}
	_tmp0_ = camel_folder_thread_node_get_item (node);
	message = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, camel_message_info_get_type (), CamelMessageInfo);
	_tmp1_ = message;
	if (_tmp1_ != NULL) {
		CamelMessageInfo* _tmp2_;
		gint64 _tmp3_;
		gint64 _tmp4_;
		CamelMessageInfo* _tmp5_;
		gint64 _tmp6_;
		gint64 _tmp7_;
		_tmp2_ = message;
		_tmp3_ = camel_message_info_get_date_received (_tmp2_);
		_tmp4_ = _tmp3_;
		time = MAX (time, _tmp4_);
		_tmp5_ = message;
		_tmp6_ = camel_message_info_get_date_sent (_tmp5_);
		_tmp7_ = _tmp6_;
		time = MAX (time, _tmp7_);
	}
	{
		CamelFolderThreadNode* child = NULL;
		CamelFolderThreadNode* _tmp8_;
		_tmp8_ = camel_folder_thread_node_get_child (node);
		child = _tmp8_;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				CamelFolderThreadNode* _tmp12_;
				CamelFolderThreadNode* _tmp13_;
				if (!_tmp9_) {
					CamelFolderThreadNode* _tmp10_;
					CamelFolderThreadNode* _tmp11_;
					_tmp10_ = child;
					_tmp11_ = camel_folder_thread_node_get_next (_tmp10_);
					child = _tmp11_;
				}
				_tmp9_ = FALSE;
				_tmp12_ = child;
				if (!(_tmp12_ != NULL)) {
					break;
				}
				_tmp13_ = child;
				time = mail_conversation_item_model_get_newest_timestamp (_tmp13_, time);
			}
		}
	}
	result = time;
	return result;
}

static gboolean
mail_conversation_item_model_has_thread_flag (CamelFolderThreadNode* node,
                                              CamelMessageFlags flag)
{
	gboolean has_flag = FALSE;
	void* _tmp0_;
	CamelMessageFlags _tmp1_;
	CamelMessageFlags _tmp2_;
	gboolean result;
	if (node == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = camel_folder_thread_node_get_item (node);
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, camel_message_info_get_type (), CamelMessageInfo), "flags", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	has_flag = !((((gint) _tmp2_) & flag) == flag);
	if (!has_flag) {
		{
			CamelFolderThreadNode* child = NULL;
			CamelFolderThreadNode* _tmp3_;
			_tmp3_ = camel_folder_thread_node_get_child (node);
			child = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					CamelFolderThreadNode* _tmp7_;
					CamelFolderThreadNode* _tmp8_;
					if (!_tmp4_) {
						CamelFolderThreadNode* _tmp5_;
						CamelFolderThreadNode* _tmp6_;
						_tmp5_ = child;
						_tmp6_ = camel_folder_thread_node_get_next (_tmp5_);
						child = _tmp6_;
					}
					_tmp4_ = FALSE;
					_tmp7_ = child;
					if (!(_tmp7_ != NULL)) {
						break;
					}
					_tmp8_ = child;
					has_flag = mail_conversation_item_model_has_thread_flag (_tmp8_, flag);
					if (has_flag) {
						break;
					}
				}
			}
		}
	}
	result = has_flag;
	return result;
}

const gchar*
mail_conversation_item_model_get_service_uid (MailConversationItemModel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_service_uid;
	result = _tmp0_;
	return result;
}

static void
mail_conversation_item_model_set_service_uid (MailConversationItemModel* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_item_model_get_service_uid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_service_uid);
		self->priv->_service_uid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_SERVICE_UID_PROPERTY]);
	}
}

CamelFolderThreadNode*
mail_conversation_item_model_get_node (MailConversationItemModel* self)
{
	CamelFolderThreadNode* result;
	CamelFolderThreadNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node;
	result = _tmp0_;
	return result;
}

static void
mail_conversation_item_model_set_node (MailConversationItemModel* self,
                                       CamelFolderThreadNode* value)
{
	CamelFolderThreadNode* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_item_model_get_node (self);
	if (old_value != value) {
		self->priv->_node = value;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_NODE_PROPERTY]);
	}
}

CamelFolderThread*
mail_conversation_item_model_get_thread (MailConversationItemModel* self)
{
	CamelFolderThread* result;
	CamelFolderThread* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_thread;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mail_conversation_item_model_set_thread (MailConversationItemModel* self,
                                         CamelFolderThread* value)
{
	CamelFolderThread* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_item_model_get_thread (self);
	if (old_value != value) {
		CamelFolderThread* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_thread);
		self->priv->_thread = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_THREAD_PROPERTY]);
	}
}

gint64
mail_conversation_item_model_get_timestamp (MailConversationItemModel* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_timestamp;
	return result;
}

static void
mail_conversation_item_model_set_timestamp (MailConversationItemModel* self,
                                            gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_item_model_get_timestamp (self);
	if (old_value != value) {
		self->priv->_timestamp = value;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_TIMESTAMP_PROPERTY]);
	}
}

CamelFolderInfoFlags
mail_conversation_item_model_get_folder_info_flags (MailConversationItemModel* self)
{
	CamelFolderInfoFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_folder_info_flags;
	return result;
}

static void
mail_conversation_item_model_set_folder_info_flags (MailConversationItemModel* self,
                                                    CamelFolderInfoFlags value)
{
	CamelFolderInfoFlags old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_item_model_get_folder_info_flags (self);
	if (old_value != value) {
		self->priv->_folder_info_flags = value;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_FOLDER_INFO_FLAGS_PROPERTY]);
	}
}

gboolean
mail_conversation_item_model_get_hidden (MailConversationItemModel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hidden;
	return result;
}

void
mail_conversation_item_model_set_hidden (MailConversationItemModel* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_conversation_item_model_get_hidden (self);
	if (old_value != value) {
		self->priv->_hidden = value;
		g_object_notify_by_pspec ((GObject *) self, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_HIDDEN_PROPERTY]);
	}
}

gchar*
mail_conversation_item_model_get_formatted_date (MailConversationItemModel* self)
{
	gchar* result;
	gint64 _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_timestamp;
	_tmp1_ = g_date_time_new_from_unix_local (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = granite_date_time_get_relative_datetime (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_date_time_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

guint
mail_conversation_item_model_get_num_messages (MailConversationItemModel* self)
{
	guint result;
	CamelFolderThreadNode* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_node;
	result = mail_conversation_item_model_count_thread_messages (_tmp0_);
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
mail_conversation_item_model_get_from (MailConversationItemModel* self)
{
	gchar* result;
	gchar** senders = NULL;
	gchar** _tmp0_;
	gint senders_length1;
	gint _senders_size_;
	CamelFolderThreadNode* current_node = NULL;
	CamelFolderThreadNode* _tmp1_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	senders = _tmp0_;
	senders_length1 = 0;
	_senders_size_ = senders_length1;
	_tmp1_ = self->priv->_node;
	current_node = _tmp1_;
	while (TRUE) {
		CamelFolderThreadNode* _tmp2_;
		CamelMessageInfo* message = NULL;
		CamelFolderThreadNode* _tmp3_;
		void* _tmp4_;
		CamelMessageInfo* _tmp5_;
		CamelFolderThreadNode* _tmp25_;
		CamelFolderThreadNode* _tmp26_;
		_tmp2_ = current_node;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = current_node;
		_tmp4_ = camel_folder_thread_node_get_item (_tmp3_);
		message = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, camel_message_info_get_type (), CamelMessageInfo);
		_tmp5_ = message;
		if (_tmp5_ != NULL) {
			CamelInternetAddress* address = NULL;
			CamelInternetAddress* _tmp6_;
			CamelInternetAddress* _tmp7_;
			CamelMessageInfo* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp6_ = camel_internet_address_new ();
			address = _tmp6_;
			_tmp7_ = address;
			_tmp8_ = message;
			_tmp9_ = camel_message_info_get_from (_tmp8_);
			_tmp10_ = _tmp9_;
			if (camel_address_decode ((CamelAddress*) _tmp7_, _tmp10_) > 0) {
				const gchar* ia_name = NULL;
				const gchar* ia_address = NULL;
				gchar* sender = NULL;
				CamelInternetAddress* _tmp11_;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				const gchar* _tmp15_;
				const gchar* _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				_tmp11_ = address;
				camel_internet_address_get (_tmp11_, 0, &_tmp12_, &_tmp13_);
				ia_name = _tmp12_;
				ia_address = _tmp13_;
				_tmp15_ = ia_name;
				if (_tmp15_ != NULL) {
					const gchar* _tmp16_;
					_tmp16_ = ia_name;
					_tmp14_ = g_strcmp0 (_tmp16_, "") != 0;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp17_ = ia_name;
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (sender);
					sender = _tmp18_;
				} else {
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp19_ = ia_address;
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (sender);
					sender = _tmp20_;
				}
				_tmp21_ = sender;
				_tmp22_ = senders;
				_tmp22__length1 = senders_length1;
				if (!_vala_string_array_contains (_tmp22_, _tmp22__length1, _tmp21_)) {
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp23_ = sender;
					_tmp24_ = g_strdup (_tmp23_);
					_vala_array_add1 (&senders, &senders_length1, &_senders_size_, _tmp24_);
				}
				_g_free0 (sender);
			}
			_g_object_unref0 (address);
		}
		_tmp25_ = current_node;
		_tmp26_ = camel_folder_thread_node_get_child (_tmp25_);
		current_node = (CamelFolderThreadNode*) _tmp26_;
	}
	_tmp27_ = senders;
	_tmp27__length1 = senders_length1;
	if (_tmp27__length1 > 0) {
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar* _tmp29_;
		_tmp28_ = senders;
		_tmp28__length1 = senders_length1;
		_tmp29_ = _vala_g_strjoinv (_ (", "), _tmp28_, (gint) _tmp28__length1);
		result = _tmp29_;
		senders = (_vala_array_free (senders, senders_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp30_ = g_strdup (_ ("Unknown"));
	result = _tmp30_;
	senders = (_vala_array_free (senders, senders_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar*
mail_conversation_item_model_get_to (MailConversationItemModel* self)
{
	gchar* result;
	gchar** recipients = NULL;
	gchar** _tmp0_;
	gint recipients_length1;
	gint _recipients_size_;
	CamelFolderThreadNode* current_node = NULL;
	CamelFolderThreadNode* _tmp1_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	recipients = _tmp0_;
	recipients_length1 = 0;
	_recipients_size_ = recipients_length1;
	_tmp1_ = self->priv->_node;
	current_node = _tmp1_;
	while (TRUE) {
		CamelFolderThreadNode* _tmp2_;
		CamelMessageInfo* message = NULL;
		CamelFolderThreadNode* _tmp3_;
		void* _tmp4_;
		CamelMessageInfo* _tmp5_;
		CamelFolderThreadNode* _tmp25_;
		CamelFolderThreadNode* _tmp26_;
		_tmp2_ = current_node;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = current_node;
		_tmp4_ = camel_folder_thread_node_get_item (_tmp3_);
		message = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, camel_message_info_get_type (), CamelMessageInfo);
		_tmp5_ = message;
		if (_tmp5_ != NULL) {
			CamelInternetAddress* address = NULL;
			CamelInternetAddress* _tmp6_;
			CamelInternetAddress* _tmp7_;
			CamelMessageInfo* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp6_ = camel_internet_address_new ();
			address = _tmp6_;
			_tmp7_ = address;
			_tmp8_ = message;
			_tmp9_ = camel_message_info_get_to (_tmp8_);
			_tmp10_ = _tmp9_;
			if (camel_address_decode ((CamelAddress*) _tmp7_, _tmp10_) > 0) {
				const gchar* ia_name = NULL;
				const gchar* ia_address = NULL;
				gchar* recipient = NULL;
				CamelInternetAddress* _tmp11_;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				const gchar* _tmp15_;
				const gchar* _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				_tmp11_ = address;
				camel_internet_address_get (_tmp11_, 0, &_tmp12_, &_tmp13_);
				ia_name = _tmp12_;
				ia_address = _tmp13_;
				_tmp15_ = ia_name;
				if (_tmp15_ != NULL) {
					const gchar* _tmp16_;
					_tmp16_ = ia_name;
					_tmp14_ = g_strcmp0 (_tmp16_, "") != 0;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					const gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp17_ = ia_name;
					_tmp18_ = g_strdup (_tmp17_);
					_g_free0 (recipient);
					recipient = _tmp18_;
				} else {
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp19_ = ia_address;
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (recipient);
					recipient = _tmp20_;
				}
				_tmp21_ = recipient;
				_tmp22_ = recipients;
				_tmp22__length1 = recipients_length1;
				if (!_vala_string_array_contains (_tmp22_, _tmp22__length1, _tmp21_)) {
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp23_ = recipient;
					_tmp24_ = g_strdup (_tmp23_);
					_vala_array_add2 (&recipients, &recipients_length1, &_recipients_size_, _tmp24_);
				}
				_g_free0 (recipient);
			}
			_g_object_unref0 (address);
		}
		_tmp25_ = current_node;
		_tmp26_ = camel_folder_thread_node_get_child (_tmp25_);
		current_node = (CamelFolderThreadNode*) _tmp26_;
	}
	_tmp27_ = recipients;
	_tmp27__length1 = recipients_length1;
	if (_tmp27__length1 > 0) {
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar* _tmp29_;
		_tmp28_ = recipients;
		_tmp28__length1 = recipients_length1;
		_tmp29_ = _vala_g_strjoinv (_ (", "), _tmp28_, (gint) _tmp28__length1);
		result = _tmp29_;
		recipients = (_vala_array_free (recipients, recipients_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp30_ = g_strdup (_ ("Unknown"));
	result = _tmp30_;
	recipients = (_vala_array_free (recipients, recipients_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

const gchar*
mail_conversation_item_model_get_subject (MailConversationItemModel* self)
{
	const gchar* result;
	CamelMessageInfo* message = NULL;
	CamelFolderThreadNode* _tmp0_;
	void* _tmp1_;
	CamelMessageInfo* _tmp2_;
	CamelMessageInfo* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node;
	_tmp1_ = camel_folder_thread_node_get_item (_tmp0_);
	message = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, camel_message_info_get_type (), CamelMessageInfo);
	_tmp2_ = message;
	if (_tmp2_ == NULL) {
		result = _ ("Unknown");
		return result;
	}
	_tmp3_ = message;
	_tmp4_ = camel_message_info_get_subject (_tmp3_);
	_tmp5_ = _tmp4_;
	result = _tmp5_;
	return result;
}

gboolean
mail_conversation_item_model_get_flagged (MailConversationItemModel* self)
{
	gboolean result;
	CamelMessageInfo* message = NULL;
	CamelFolderThreadNode* _tmp0_;
	void* _tmp1_;
	CamelMessageInfo* _tmp2_;
	CamelMessageInfo* _tmp3_;
	CamelMessageFlags _tmp4_;
	CamelMessageFlags _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_node;
	_tmp1_ = camel_folder_thread_node_get_item (_tmp0_);
	message = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, camel_message_info_get_type (), CamelMessageInfo);
	_tmp2_ = message;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = message;
	g_object_get (_tmp3_, "flags", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	result = (((gint) _tmp5_) & CAMEL_MESSAGE_FLAGGED) == CAMEL_MESSAGE_FLAGGED;
	return result;
}

gboolean
mail_conversation_item_model_get_forwarded (MailConversationItemModel* self)
{
	gboolean result;
	CamelMessageInfo* message = NULL;
	CamelFolderThreadNode* _tmp0_;
	void* _tmp1_;
	CamelMessageInfo* _tmp2_;
	CamelMessageInfo* _tmp3_;
	CamelMessageFlags _tmp4_;
	CamelMessageFlags _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_node;
	_tmp1_ = camel_folder_thread_node_get_item (_tmp0_);
	message = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, camel_message_info_get_type (), CamelMessageInfo);
	_tmp2_ = message;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = message;
	g_object_get (_tmp3_, "flags", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	result = (((gint) _tmp5_) & CAMEL_MESSAGE_FORWARDED) == CAMEL_MESSAGE_FORWARDED;
	return result;
}

gboolean
mail_conversation_item_model_get_replied (MailConversationItemModel* self)
{
	gboolean result;
	CamelMessageInfo* message = NULL;
	CamelFolderThreadNode* _tmp0_;
	void* _tmp1_;
	CamelMessageInfo* _tmp2_;
	CamelMessageInfo* _tmp3_;
	CamelMessageFlags _tmp4_;
	CamelMessageFlags _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_node;
	_tmp1_ = camel_folder_thread_node_get_item (_tmp0_);
	message = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, camel_message_info_get_type (), CamelMessageInfo);
	_tmp2_ = message;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = message;
	g_object_get (_tmp3_, "flags", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	result = (((gint) _tmp5_) & CAMEL_MESSAGE_ANSWERED) == CAMEL_MESSAGE_ANSWERED;
	return result;
}

gboolean
mail_conversation_item_model_get_replied_all (MailConversationItemModel* self)
{
	gboolean result;
	CamelMessageInfo* message = NULL;
	CamelFolderThreadNode* _tmp0_;
	void* _tmp1_;
	CamelMessageInfo* _tmp2_;
	CamelMessageInfo* _tmp3_;
	CamelMessageFlags _tmp4_;
	CamelMessageFlags _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_node;
	_tmp1_ = camel_folder_thread_node_get_item (_tmp0_);
	message = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, camel_message_info_get_type (), CamelMessageInfo);
	_tmp2_ = message;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = message;
	g_object_get (_tmp3_, "flags", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	result = (((gint) _tmp5_) & CAMEL_MESSAGE_ANSWERED_ALL) == CAMEL_MESSAGE_ANSWERED_ALL;
	return result;
}

gboolean
mail_conversation_item_model_get_unread (MailConversationItemModel* self)
{
	gboolean result;
	CamelFolderThreadNode* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_node;
	result = mail_conversation_item_model_has_thread_flag (_tmp0_, CAMEL_MESSAGE_SEEN);
	return result;
}

gboolean
mail_conversation_item_model_get_deleted (MailConversationItemModel* self)
{
	gboolean result;
	CamelMessageInfo* message = NULL;
	CamelFolderThreadNode* _tmp0_;
	void* _tmp1_;
	CamelMessageInfo* _tmp2_;
	CamelMessageInfo* _tmp3_;
	CamelMessageFlags _tmp4_;
	CamelMessageFlags _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_node;
	_tmp1_ = camel_folder_thread_node_get_item (_tmp0_);
	message = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, camel_message_info_get_type (), CamelMessageInfo);
	_tmp2_ = message;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = message;
	g_object_get (_tmp3_, "flags", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	result = (((gint) _tmp5_) & CAMEL_MESSAGE_DELETED) == CAMEL_MESSAGE_DELETED;
	return result;
}

static GObject *
mail_conversation_item_model_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailConversationItemModel * self;
	CamelFolderThreadNode* _tmp0_;
	parent_class = G_OBJECT_CLASS (mail_conversation_item_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel);
	_tmp0_ = self->priv->_node;
	mail_conversation_item_model_set_timestamp (self, mail_conversation_item_model_get_newest_timestamp (_tmp0_, (gint64) -1));
	return obj;
}

static void
mail_conversation_item_model_class_init (MailConversationItemModelClass * klass,
                                         gpointer klass_data)
{
	mail_conversation_item_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailConversationItemModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_conversation_item_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_conversation_item_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_conversation_item_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_conversation_item_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_SERVICE_UID_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_SERVICE_UID_PROPERTY] = g_param_spec_string ("service-uid", "service-uid", "service-uid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_NODE_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_NODE_PROPERTY] = g_param_spec_pointer ("node", "node", "node", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_THREAD_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_THREAD_PROPERTY] = g_param_spec_object ("thread", "thread", "thread", camel_folder_thread_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_TIMESTAMP_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_TIMESTAMP_PROPERTY] = g_param_spec_int64 ("timestamp", "timestamp", "timestamp", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_FOLDER_INFO_FLAGS_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_FOLDER_INFO_FLAGS_PROPERTY] = g_param_spec_flags ("folder-info-flags", "folder-info-flags", "folder-info-flags", camel_folder_info_flags_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_HIDDEN_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_HIDDEN_PROPERTY] = g_param_spec_boolean ("hidden", "hidden", "hidden", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_FORMATTED_DATE_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_FORMATTED_DATE_PROPERTY] = g_param_spec_string ("formatted-date", "formatted-date", "formatted-date", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_NUM_MESSAGES_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_NUM_MESSAGES_PROPERTY] = g_param_spec_uint ("num-messages", "num-messages", "num-messages", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_FROM_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_FROM_PROPERTY] = g_param_spec_string ("from", "from", "from", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_TO_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_TO_PROPERTY] = g_param_spec_string ("to", "to", "to", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_SUBJECT_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_SUBJECT_PROPERTY] = g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_FLAGGED_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_FLAGGED_PROPERTY] = g_param_spec_boolean ("flagged", "flagged", "flagged", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_FORWARDED_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_FORWARDED_PROPERTY] = g_param_spec_boolean ("forwarded", "forwarded", "forwarded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_REPLIED_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_REPLIED_PROPERTY] = g_param_spec_boolean ("replied", "replied", "replied", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_REPLIED_ALL_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_REPLIED_ALL_PROPERTY] = g_param_spec_boolean ("replied-all", "replied-all", "replied-all", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_UNREAD_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_UNREAD_PROPERTY] = g_param_spec_boolean ("unread", "unread", "unread", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_CONVERSATION_ITEM_MODEL_DELETED_PROPERTY, mail_conversation_item_model_properties[MAIL_CONVERSATION_ITEM_MODEL_DELETED_PROPERTY] = g_param_spec_boolean ("deleted", "deleted", "deleted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
mail_conversation_item_model_instance_init (MailConversationItemModel * self,
                                            gpointer klass)
{
	self->priv = mail_conversation_item_model_get_instance_private (self);
	self->priv->_hidden = FALSE;
}

static void
mail_conversation_item_model_finalize (GObject * obj)
{
	MailConversationItemModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel);
	_g_free0 (self->priv->_service_uid);
	_g_object_unref0 (self->priv->_thread);
	G_OBJECT_CLASS (mail_conversation_item_model_parent_class)->finalize (obj);
}

static GType
mail_conversation_item_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailConversationItemModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_conversation_item_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailConversationItemModel), 0, (GInstanceInitFunc) mail_conversation_item_model_instance_init, NULL };
	GType mail_conversation_item_model_type_id;
	mail_conversation_item_model_type_id = g_type_register_static (G_TYPE_OBJECT, "MailConversationItemModel", &g_define_type_info, 0);
	MailConversationItemModel_private_offset = g_type_add_instance_private (mail_conversation_item_model_type_id, sizeof (MailConversationItemModelPrivate));
	return mail_conversation_item_model_type_id;
}

GType
mail_conversation_item_model_get_type (void)
{
	static volatile gsize mail_conversation_item_model_type_id__once = 0;
	if (g_once_init_enter (&mail_conversation_item_model_type_id__once)) {
		GType mail_conversation_item_model_type_id;
		mail_conversation_item_model_type_id = mail_conversation_item_model_get_type_once ();
		g_once_init_leave (&mail_conversation_item_model_type_id__once, mail_conversation_item_model_type_id);
	}
	return mail_conversation_item_model_type_id__once;
}

static void
_vala_mail_conversation_item_model_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	MailConversationItemModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel);
	switch (property_id) {
		case MAIL_CONVERSATION_ITEM_MODEL_SERVICE_UID_PROPERTY:
		g_value_set_string (value, mail_conversation_item_model_get_service_uid (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_NODE_PROPERTY:
		g_value_set_pointer (value, mail_conversation_item_model_get_node (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_THREAD_PROPERTY:
		g_value_set_object (value, mail_conversation_item_model_get_thread (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_TIMESTAMP_PROPERTY:
		g_value_set_int64 (value, mail_conversation_item_model_get_timestamp (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_FOLDER_INFO_FLAGS_PROPERTY:
		g_value_set_flags (value, mail_conversation_item_model_get_folder_info_flags (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_HIDDEN_PROPERTY:
		g_value_set_boolean (value, mail_conversation_item_model_get_hidden (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_FORMATTED_DATE_PROPERTY:
		g_value_take_string (value, mail_conversation_item_model_get_formatted_date (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_NUM_MESSAGES_PROPERTY:
		g_value_set_uint (value, mail_conversation_item_model_get_num_messages (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_FROM_PROPERTY:
		g_value_take_string (value, mail_conversation_item_model_get_from (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_TO_PROPERTY:
		g_value_take_string (value, mail_conversation_item_model_get_to (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_SUBJECT_PROPERTY:
		g_value_set_string (value, mail_conversation_item_model_get_subject (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_FLAGGED_PROPERTY:
		g_value_set_boolean (value, mail_conversation_item_model_get_flagged (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_FORWARDED_PROPERTY:
		g_value_set_boolean (value, mail_conversation_item_model_get_forwarded (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_REPLIED_PROPERTY:
		g_value_set_boolean (value, mail_conversation_item_model_get_replied (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_REPLIED_ALL_PROPERTY:
		g_value_set_boolean (value, mail_conversation_item_model_get_replied_all (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_UNREAD_PROPERTY:
		g_value_set_boolean (value, mail_conversation_item_model_get_unread (self));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_DELETED_PROPERTY:
		g_value_set_boolean (value, mail_conversation_item_model_get_deleted (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_conversation_item_model_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	MailConversationItemModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_CONVERSATION_ITEM_MODEL, MailConversationItemModel);
	switch (property_id) {
		case MAIL_CONVERSATION_ITEM_MODEL_SERVICE_UID_PROPERTY:
		mail_conversation_item_model_set_service_uid (self, g_value_get_string (value));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_NODE_PROPERTY:
		mail_conversation_item_model_set_node (self, g_value_get_pointer (value));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_THREAD_PROPERTY:
		mail_conversation_item_model_set_thread (self, g_value_get_object (value));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_TIMESTAMP_PROPERTY:
		mail_conversation_item_model_set_timestamp (self, g_value_get_int64 (value));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_FOLDER_INFO_FLAGS_PROPERTY:
		mail_conversation_item_model_set_folder_info_flags (self, g_value_get_flags (value));
		break;
		case MAIL_CONVERSATION_ITEM_MODEL_HIDDEN_PROPERTY:
		mail_conversation_item_model_set_hidden (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

