/* MainView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainView.vala, do not modify */

/*
 * Copyright 2019-2022 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ABSTRACT_VIEW (abstract_view_get_type ())
#define ABSTRACT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_VIEW, AbstractView))
#define ABSTRACT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_VIEW, AbstractViewClass))
#define IS_ABSTRACT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_VIEW))
#define IS_ABSTRACT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_VIEW))
#define ABSTRACT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_VIEW, AbstractViewClass))

typedef struct _AbstractView AbstractView;
typedef struct _AbstractViewClass AbstractViewClass;
typedef struct _AbstractViewPrivate AbstractViewPrivate;

#define SIDELOAD_TYPE_MAIN_VIEW (sideload_main_view_get_type ())
#define SIDELOAD_MAIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_MAIN_VIEW, SideloadMainView))
#define SIDELOAD_MAIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_MAIN_VIEW, SideloadMainViewClass))
#define SIDELOAD_IS_MAIN_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_MAIN_VIEW))
#define SIDELOAD_IS_MAIN_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_MAIN_VIEW))
#define SIDELOAD_MAIN_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_MAIN_VIEW, SideloadMainViewClass))

typedef struct _SideloadMainView SideloadMainView;
typedef struct _SideloadMainViewClass SideloadMainViewClass;
typedef struct _SideloadMainViewPrivate SideloadMainViewPrivate;
enum  {
	SIDELOAD_MAIN_VIEW_0_PROPERTY,
	SIDELOAD_MAIN_VIEW_APP_NAME_PROPERTY,
	SIDELOAD_MAIN_VIEW_NUM_PROPERTIES
};
static GParamSpec* sideload_main_view_properties[SIDELOAD_MAIN_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DEVICES = 1 << 0,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_FULL = 1 << 1,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_READ = 1 << 2,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_ESCAPE_SANDBOX = 1 << 3,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_FULL = 1 << 4,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_OTHER = 1 << 5,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_READ = 1 << 6,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_FULL = 1 << 7,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_READ = 1 << 8,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_NETWORK = 1 << 9,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_NONE = 1 << 10,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SESSION_BUS = 1 << 11,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SETTINGS = 1 << 12,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SYSTEM_BUS = 1 << 13,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_UNKNOWN = 1 << 14,
	SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_X11 = 1 << 15
} SideloadFlatpakFilePermissionsFlags;

#define SIDELOAD_FLATPAK_FILE_TYPE_PERMISSIONS_FLAGS (sideload_flatpak_file_permissions_flags_get_type ())

#define SIDELOAD_TYPE_APPLICATION (sideload_application_get_type ())
#define SIDELOAD_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDELOAD_TYPE_APPLICATION, SideloadApplication))
#define SIDELOAD_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDELOAD_TYPE_APPLICATION, SideloadApplicationClass))
#define SIDELOAD_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDELOAD_TYPE_APPLICATION))
#define SIDELOAD_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDELOAD_TYPE_APPLICATION))
#define SIDELOAD_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDELOAD_TYPE_APPLICATION, SideloadApplicationClass))

typedef struct _SideloadApplication SideloadApplication;
typedef struct _SideloadApplicationClass SideloadApplicationClass;
enum  {
	SIDELOAD_MAIN_VIEW_INSTALL_REQUEST_SIGNAL,
	SIDELOAD_MAIN_VIEW_NUM_SIGNALS
};
static guint sideload_main_view_signals[SIDELOAD_MAIN_VIEW_NUM_SIGNALS] = {0};

struct _AbstractView {
	GtkBox parent_instance;
	AbstractViewPrivate * priv;
	GtkBox* button_box;
	GtkGrid* content_area;
	GtkImage* badge;
	GtkLabel* primary_label;
	GtkLabel* secondary_label;
};

struct _AbstractViewClass {
	GtkBoxClass parent_class;
};

struct _SideloadMainView {
	AbstractView parent_instance;
	SideloadMainViewPrivate * priv;
};

struct _SideloadMainViewClass {
	AbstractViewClass parent_class;
};

struct _SideloadMainViewPrivate {
	GtkGrid* details_grid;
	GtkStack* details_stack;
	GtkLabel* download_size_label;
	GtkImage* updates_icon;
	GtkLabel* updates_label;
	GtkImage* repo_icon;
	GtkLabel* repo_label;
	GtkImage* permissions_image;
	GtkLabel* permissions_label;
};

static gint SideloadMainView_private_offset;
static gpointer sideload_main_view_parent_class = NULL;

VALA_EXTERN GType abstract_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractView, g_object_unref)
VALA_EXTERN GType sideload_main_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadMainView, g_object_unref)
VALA_EXTERN void sideload_main_view_display_bundle_details (SideloadMainView* self,
                                                const gchar* size,
                                                gboolean has_repo,
                                                gboolean extra_repo);
VALA_EXTERN GType sideload_flatpak_file_permissions_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void sideload_main_view_display_ref_details (SideloadMainView* self,
                                             const gchar* size,
                                             gboolean extra_repo,
                                             SideloadFlatpakFilePermissionsFlags permissions_flags);
VALA_EXTERN SideloadMainView* sideload_main_view_new (void);
VALA_EXTERN SideloadMainView* sideload_main_view_construct (GType object_type);
VALA_EXTERN AbstractView* abstract_view_construct (GType object_type);
VALA_EXTERN void sideload_main_view_set_app_name (SideloadMainView* self,
                                      const gchar* value);
static GObject * sideload_main_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
VALA_EXTERN GType sideload_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SideloadApplication, g_object_unref)
VALA_EXTERN gchar* sideload_application_get_appstore_name (SideloadApplication* self);
static void _sideload_main_view___lambda33_ (SideloadMainView* self);
static void __sideload_main_view___lambda33__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void sideload_main_view_finalize (GObject * obj);
static GType sideload_main_view_get_type_once (void);
static void _vala_sideload_main_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
sideload_main_view_get_instance_private (SideloadMainView* self)
{
	return G_STRUCT_MEMBER_P (self, SideloadMainView_private_offset);
}

void
sideload_main_view_display_bundle_details (SideloadMainView* self,
                                           const gchar* size,
                                           gboolean has_repo,
                                           gboolean extra_repo)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkStack* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (size != NULL);
	_tmp0_ = self->priv->download_size_label;
	_tmp1_ = g_strdup_printf (_ ("Install size may be up to %s"), size);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (has_repo) {
		GtkGrid* _tmp3_;
		GtkImage* _tmp4_;
		GtkGrid* _tmp5_;
		GtkLabel* _tmp6_;
		_tmp3_ = self->priv->details_grid;
		_tmp4_ = self->priv->updates_icon;
		gtk_grid_attach (_tmp3_, (GtkWidget*) _tmp4_, 0, 1, 1, 1);
		_tmp5_ = self->priv->details_grid;
		_tmp6_ = self->priv->updates_label;
		gtk_grid_attach (_tmp5_, (GtkWidget*) _tmp6_, 1, 1, 1, 1);
	}
	if (extra_repo) {
		GtkGrid* _tmp7_;
		GtkImage* _tmp8_;
		GtkGrid* _tmp9_;
		GtkLabel* _tmp10_;
		_tmp7_ = self->priv->details_grid;
		_tmp8_ = self->priv->repo_icon;
		gtk_grid_attach (_tmp7_, (GtkWidget*) _tmp8_, 0, 2, 1, 1);
		_tmp9_ = self->priv->details_grid;
		_tmp10_ = self->priv->repo_label;
		gtk_grid_attach (_tmp9_, (GtkWidget*) _tmp10_, 1, 2, 1, 1);
	}
	_tmp11_ = self->priv->details_stack;
	gtk_stack_set_visible_child_name (_tmp11_, "details");
}

void
sideload_main_view_display_ref_details (SideloadMainView* self,
                                        const gchar* size,
                                        gboolean extra_repo,
                                        SideloadFlatpakFilePermissionsFlags permissions_flags)
{
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GtkGrid* _tmp20_;
	GtkImage* _tmp21_;
	GtkGrid* _tmp22_;
	GtkLabel* _tmp23_;
	GtkGrid* _tmp24_;
	GtkImage* _tmp25_;
	GtkGrid* _tmp26_;
	GtkLabel* _tmp27_;
	GtkStack* _tmp32_;
	g_return_if_fail (self != NULL);
	if (size != NULL) {
		GtkLabel* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->download_size_label;
		_tmp1_ = g_strdup_printf (_ ("Download size may be up to %s"), size);
		_tmp2_ = _tmp1_;
		gtk_label_set_label (_tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
	} else {
		GtkLabel* _tmp3_;
		_tmp3_ = self->priv->download_size_label;
		gtk_label_set_label (_tmp3_, _ ("Unknown download size"));
	}
	if ((permissions_flags & SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_ESCAPE_SANDBOX) == SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_ESCAPE_SANDBOX) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = (permissions_flags & SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_FULL) == SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_FULL;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = (permissions_flags & SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SYSTEM_BUS) == SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_SYSTEM_BUS;
	}
	if (_tmp4_) {
		GtkImage* _tmp6_;
		GtkImage* _tmp7_;
		GtkLabel* _tmp8_;
		_tmp6_ = self->priv->permissions_image;
		g_object_set (_tmp6_, "icon-name", "security-low-symbolic", NULL);
		_tmp7_ = self->priv->permissions_image;
		gtk_widget_add_css_class ((GtkWidget*) _tmp7_, "red");
		_tmp8_ = self->priv->permissions_label;
		gtk_label_set_label (_tmp8_, _ ("Requests advanced permissions that could be used to violate your priva" \
"cy or security"));
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		if ((permissions_flags & SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_FULL) == SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_FULL) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = (permissions_flags & SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_READ) == SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_DOWNLOADS_READ;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = (permissions_flags & SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_OTHER) == SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_OTHER;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = (permissions_flags & SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_READ) == SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_FILESYSTEM_READ;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = (permissions_flags & SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_FULL) == SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_FULL;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = (permissions_flags & SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_READ) == SIDELOAD_FLATPAK_FILE_PERMISSIONS_FLAGS_HOME_READ;
		}
		if (_tmp9_) {
			GtkImage* _tmp14_;
			GtkImage* _tmp15_;
			GtkLabel* _tmp16_;
			_tmp14_ = self->priv->permissions_image;
			g_object_set (_tmp14_, "icon-name", "security-low-symbolic", NULL);
			_tmp15_ = self->priv->permissions_image;
			gtk_widget_add_css_class ((GtkWidget*) _tmp15_, "yellow");
			_tmp16_ = self->priv->permissions_label;
			gtk_label_set_label (_tmp16_, _ ("Requests file and folder permissions that could be used to violate you" \
"r privacy"));
		} else {
			GtkImage* _tmp17_;
			GtkImage* _tmp18_;
			GtkLabel* _tmp19_;
			_tmp17_ = self->priv->permissions_image;
			g_object_set (_tmp17_, "icon-name", "security-high-symbolic", NULL);
			_tmp18_ = self->priv->permissions_image;
			gtk_widget_add_css_class ((GtkWidget*) _tmp18_, "green");
			_tmp19_ = self->priv->permissions_label;
			gtk_label_set_label (_tmp19_, _ ("Doesn't request advanced system permissions"));
		}
	}
	_tmp20_ = self->priv->details_grid;
	_tmp21_ = self->priv->permissions_image;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, 1, 1, 1);
	_tmp22_ = self->priv->details_grid;
	_tmp23_ = self->priv->permissions_label;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 1, 1, 1, 1);
	_tmp24_ = self->priv->details_grid;
	_tmp25_ = self->priv->updates_icon;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 0, 2, 1, 1);
	_tmp26_ = self->priv->details_grid;
	_tmp27_ = self->priv->updates_label;
	gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp27_, 1, 2, 1, 1);
	if (extra_repo) {
		GtkGrid* _tmp28_;
		GtkImage* _tmp29_;
		GtkGrid* _tmp30_;
		GtkLabel* _tmp31_;
		_tmp28_ = self->priv->details_grid;
		_tmp29_ = self->priv->repo_icon;
		gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 0, 3, 1, 1);
		_tmp30_ = self->priv->details_grid;
		_tmp31_ = self->priv->repo_label;
		gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 1, 3, 1, 1);
	}
	_tmp32_ = self->priv->details_stack;
	gtk_stack_set_visible_child_name (_tmp32_, "details");
}

SideloadMainView*
sideload_main_view_construct (GType object_type)
{
	SideloadMainView * self = NULL;
	self = (SideloadMainView*) abstract_view_construct (object_type);
	return self;
}

SideloadMainView*
sideload_main_view_new (void)
{
	return sideload_main_view_construct (SIDELOAD_TYPE_MAIN_VIEW);
}

void
sideload_main_view_set_app_name (SideloadMainView* self,
                                 const gchar* value)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((AbstractView*) self)->primary_label;
	_tmp1_ = g_strdup_printf (_ ("Trust and install “%s”?"), value);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_notify_by_pspec ((GObject *) self, sideload_main_view_properties[SIDELOAD_MAIN_VIEW_APP_NAME_PROPERTY]);
}

static void
_sideload_main_view___lambda33_ (SideloadMainView* self)
{
	g_signal_emit (self, sideload_main_view_signals[SIDELOAD_MAIN_VIEW_INSTALL_REQUEST_SIGNAL], 0);
}

static void
__sideload_main_view___lambda33__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	_sideload_main_view___lambda33_ ((SideloadMainView*) self);
}

static GObject *
sideload_main_view_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SideloadMainView * self;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkSpinner* loading_spinner = NULL;
	GtkSpinner* _tmp2_;
	GtkSpinner* _tmp3_;
	GtkLabel* loading_label = NULL;
	GtkLabel* _tmp4_;
	GtkBox* loading_grid = NULL;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkSpinner* _tmp7_;
	GtkBox* _tmp8_;
	GtkLabel* _tmp9_;
	GtkCheckButton* agree_check = NULL;
	GtkCheckButton* _tmp10_;
	GtkCheckButton* _tmp11_;
	GtkImage* download_size_icon = NULL;
	GtkImage* _tmp12_ = NULL;
	GtkImage* _tmp13_;
	GtkImage* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkImage* _tmp20_ = NULL;
	GtkImage* _tmp21_;
	GtkImage* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkImage* _tmp28_ = NULL;
	GtkImage* _tmp29_;
	GtkImage* _tmp30_;
	gchar* appstore_name = NULL;
	GApplication* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	GtkLabel* _tmp38_;
	GtkLabel* _tmp39_;
	GtkLabel* _tmp40_;
	GtkImage* _tmp41_ = NULL;
	GtkImage* _tmp42_;
	GtkLabel* _tmp43_ = NULL;
	GtkGrid* _tmp44_ = NULL;
	GtkGrid* _tmp45_;
	GtkImage* _tmp46_;
	GtkGrid* _tmp47_;
	GtkLabel* _tmp48_;
	GtkGrid* _tmp49_;
	GtkCheckButton* _tmp50_;
	GtkStack* _tmp51_;
	GtkStack* _tmp52_;
	GtkStack* _tmp53_;
	GtkBox* _tmp54_;
	GtkStack* _tmp55_;
	GtkGrid* _tmp56_;
	GtkStack* _tmp57_;
	GtkGrid* _tmp58_;
	GtkStack* _tmp59_;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp60_;
	GtkButton* _tmp61_;
	GtkButton* install_button = NULL;
	GtkButton* _tmp62_;
	GtkButton* _tmp63_;
	GtkBox* _tmp64_;
	GtkButton* _tmp65_;
	GtkBox* _tmp66_;
	GtkButton* _tmp67_;
	GtkCheckButton* _tmp68_;
	GtkButton* _tmp69_;
	GtkCheckButton* _tmp70_;
	GtkButton* _tmp71_;
	parent_class = G_OBJECT_CLASS (sideload_main_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDELOAD_TYPE_MAIN_VIEW, SideloadMainView);
	_tmp0_ = ((AbstractView*) self)->primary_label;
	gtk_label_set_label (_tmp0_, _ ("Trust and install this app?"));
	_tmp1_ = ((AbstractView*) self)->secondary_label;
	gtk_label_set_label (_tmp1_, _ ("This app is provided solely by its developer and has not been reviewed" \
" by elementary for security, privacy, or system integration."));
	_tmp2_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp2_);
	loading_spinner = _tmp2_;
	_tmp3_ = loading_spinner;
	gtk_spinner_start (_tmp3_);
	_tmp4_ = (GtkLabel*) gtk_label_new (_ ("Fetching details"));
	g_object_ref_sink (_tmp4_);
	loading_label = _tmp4_;
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp5_);
	loading_grid = _tmp5_;
	_tmp6_ = loading_grid;
	_tmp7_ = loading_spinner;
	gtk_box_append (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = loading_grid;
	_tmp9_ = loading_label;
	gtk_box_append (_tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("I understand"));
	g_object_ref_sink (_tmp10_);
	agree_check = _tmp10_;
	_tmp11_ = agree_check;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp11_, 12);
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("browser-download-symbolic");
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp12_);
	download_size_icon = _tmp12_;
	_tmp13_ = download_size_icon;
	gtk_widget_add_css_class ((GtkWidget*) _tmp13_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp14_ = download_size_icon;
	gtk_widget_add_css_class ((GtkWidget*) _tmp14_, "green");
	_tmp15_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->download_size_label);
	self->priv->download_size_label = _tmp15_;
	_tmp16_ = self->priv->download_size_label;
	gtk_label_set_selectable (_tmp16_, TRUE);
	_tmp17_ = self->priv->download_size_label;
	gtk_label_set_max_width_chars (_tmp17_, 50);
	_tmp18_ = self->priv->download_size_label;
	gtk_label_set_wrap (_tmp18_, TRUE);
	_tmp19_ = self->priv->download_size_label;
	gtk_label_set_xalign (_tmp19_, (gfloat) 0);
	_tmp20_ = (GtkImage*) gtk_image_new_from_icon_name ("system-software-update-symbolic");
	gtk_widget_set_valign ((GtkWidget*) _tmp20_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->updates_icon);
	self->priv->updates_icon = _tmp20_;
	_tmp21_ = self->priv->updates_icon;
	gtk_widget_add_css_class ((GtkWidget*) _tmp21_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp22_ = self->priv->updates_icon;
	gtk_widget_add_css_class ((GtkWidget*) _tmp22_, "orange");
	_tmp23_ = (GtkLabel*) gtk_label_new (_ ("Updates to this app will not be reviewed by elementary"));
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->updates_label);
	self->priv->updates_label = _tmp23_;
	_tmp24_ = self->priv->updates_label;
	gtk_label_set_selectable (_tmp24_, TRUE);
	_tmp25_ = self->priv->updates_label;
	gtk_label_set_max_width_chars (_tmp25_, 50);
	_tmp26_ = self->priv->updates_label;
	gtk_label_set_wrap (_tmp26_, TRUE);
	_tmp27_ = self->priv->updates_label;
	gtk_label_set_xalign (_tmp27_, (gfloat) 0);
	_tmp28_ = (GtkImage*) gtk_image_new_from_icon_name ("system-software-install-symbolic");
	gtk_widget_set_valign ((GtkWidget*) _tmp28_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->repo_icon);
	self->priv->repo_icon = _tmp28_;
	_tmp29_ = self->priv->repo_icon;
	gtk_widget_add_css_class ((GtkWidget*) _tmp29_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp30_ = self->priv->repo_icon;
	gtk_widget_add_css_class ((GtkWidget*) _tmp30_, "purple");
	_tmp31_ = g_application_get_default ();
	_tmp32_ = sideload_application_get_appstore_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, SIDELOAD_TYPE_APPLICATION, SideloadApplication));
	appstore_name = _tmp32_;
	_tmp33_ = appstore_name;
	_tmp34_ = g_strdup_printf (_ ("Other apps from this distributor may appear in %s"), _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = (GtkLabel*) gtk_label_new (_tmp35_);
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->repo_label);
	self->priv->repo_label = _tmp36_;
	_g_free0 (_tmp35_);
	_tmp37_ = self->priv->repo_label;
	gtk_label_set_selectable (_tmp37_, TRUE);
	_tmp38_ = self->priv->repo_label;
	gtk_label_set_max_width_chars (_tmp38_, 50);
	_tmp39_ = self->priv->repo_label;
	gtk_label_set_wrap (_tmp39_, TRUE);
	_tmp40_ = self->priv->repo_label;
	gtk_label_set_xalign (_tmp40_, (gfloat) 0);
	_tmp41_ = (GtkImage*) gtk_image_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp41_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->permissions_image);
	self->priv->permissions_image = _tmp41_;
	_tmp42_ = self->priv->permissions_image;
	gtk_widget_add_css_class ((GtkWidget*) _tmp42_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp43_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_max_width_chars (_tmp43_, 50);
	gtk_label_set_selectable (_tmp43_, TRUE);
	gtk_label_set_wrap (_tmp43_, TRUE);
	gtk_label_set_xalign (_tmp43_, (gfloat) 0);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->permissions_label);
	self->priv->permissions_label = _tmp43_;
	_tmp44_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp44_, 6);
	gtk_grid_set_row_spacing (_tmp44_, 12);
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->details_grid);
	self->priv->details_grid = _tmp44_;
	_tmp45_ = self->priv->details_grid;
	_tmp46_ = download_size_icon;
	gtk_grid_attach (_tmp45_, (GtkWidget*) _tmp46_, 0, 0, 1, 1);
	_tmp47_ = self->priv->details_grid;
	_tmp48_ = self->priv->download_size_label;
	gtk_grid_attach (_tmp47_, (GtkWidget*) _tmp48_, 1, 0, 1, 1);
	_tmp49_ = self->priv->details_grid;
	_tmp50_ = agree_check;
	gtk_grid_attach (_tmp49_, (GtkWidget*) _tmp50_, 0, 4, 2, 1);
	_tmp51_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp51_);
	_g_object_unref0 (self->priv->details_stack);
	self->priv->details_stack = _tmp51_;
	_tmp52_ = self->priv->details_stack;
	gtk_stack_set_vhomogeneous (_tmp52_, FALSE);
	_tmp53_ = self->priv->details_stack;
	_tmp54_ = loading_grid;
	gtk_stack_add_named (_tmp53_, (GtkWidget*) _tmp54_, "loading");
	_tmp55_ = self->priv->details_stack;
	_tmp56_ = self->priv->details_grid;
	gtk_stack_add_named (_tmp55_, (GtkWidget*) _tmp56_, "details");
	_tmp57_ = self->priv->details_stack;
	gtk_stack_set_visible_child_name (_tmp57_, "loading");
	_tmp58_ = ((AbstractView*) self)->content_area;
	_tmp59_ = self->priv->details_stack;
	gtk_grid_attach (_tmp58_, (GtkWidget*) _tmp59_, 0, 0, 1, 1);
	_tmp60_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp60_);
	cancel_button = _tmp60_;
	_tmp61_ = cancel_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp61_, "app.quit");
	_tmp62_ = (GtkButton*) gtk_button_new_with_label (_ ("Install Anyway"));
	g_object_ref_sink (_tmp62_);
	install_button = _tmp62_;
	_tmp63_ = install_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp63_, GRANITE_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp64_ = ((AbstractView*) self)->button_box;
	_tmp65_ = cancel_button;
	gtk_box_append (_tmp64_, (GtkWidget*) _tmp65_);
	_tmp66_ = ((AbstractView*) self)->button_box;
	_tmp67_ = install_button;
	gtk_box_append (_tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = agree_check;
	_tmp69_ = install_button;
	g_object_bind_property_with_closures ((GObject*) _tmp68_, "active", (GObject*) _tmp69_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp70_ = agree_check;
	gtk_widget_grab_focus ((GtkWidget*) _tmp70_);
	_tmp71_ = install_button;
	g_signal_connect_object (_tmp71_, "clicked", (GCallback) __sideload_main_view___lambda33__gtk_button_clicked, self, 0);
	_g_object_unref0 (install_button);
	_g_object_unref0 (cancel_button);
	_g_free0 (appstore_name);
	_g_object_unref0 (download_size_icon);
	_g_object_unref0 (agree_check);
	_g_object_unref0 (loading_grid);
	_g_object_unref0 (loading_label);
	_g_object_unref0 (loading_spinner);
	return obj;
}

static void
sideload_main_view_class_init (SideloadMainViewClass * klass,
                               gpointer klass_data)
{
	sideload_main_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SideloadMainView_private_offset);
	G_OBJECT_CLASS (klass)->set_property = _vala_sideload_main_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = sideload_main_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = sideload_main_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDELOAD_MAIN_VIEW_APP_NAME_PROPERTY, sideload_main_view_properties[SIDELOAD_MAIN_VIEW_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	sideload_main_view_signals[SIDELOAD_MAIN_VIEW_INSTALL_REQUEST_SIGNAL] = g_signal_new ("install-request", SIDELOAD_TYPE_MAIN_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
sideload_main_view_instance_init (SideloadMainView * self,
                                  gpointer klass)
{
	self->priv = sideload_main_view_get_instance_private (self);
}

static void
sideload_main_view_finalize (GObject * obj)
{
	SideloadMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDELOAD_TYPE_MAIN_VIEW, SideloadMainView);
	_g_object_unref0 (self->priv->details_grid);
	_g_object_unref0 (self->priv->details_stack);
	_g_object_unref0 (self->priv->download_size_label);
	_g_object_unref0 (self->priv->updates_icon);
	_g_object_unref0 (self->priv->updates_label);
	_g_object_unref0 (self->priv->repo_icon);
	_g_object_unref0 (self->priv->repo_label);
	_g_object_unref0 (self->priv->permissions_image);
	_g_object_unref0 (self->priv->permissions_label);
	G_OBJECT_CLASS (sideload_main_view_parent_class)->finalize (obj);
}

static GType
sideload_main_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SideloadMainViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sideload_main_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SideloadMainView), 0, (GInstanceInitFunc) sideload_main_view_instance_init, NULL };
	GType sideload_main_view_type_id;
	sideload_main_view_type_id = g_type_register_static (TYPE_ABSTRACT_VIEW, "SideloadMainView", &g_define_type_info, 0);
	SideloadMainView_private_offset = g_type_add_instance_private (sideload_main_view_type_id, sizeof (SideloadMainViewPrivate));
	return sideload_main_view_type_id;
}

GType
sideload_main_view_get_type (void)
{
	static volatile gsize sideload_main_view_type_id__once = 0;
	if (g_once_init_enter (&sideload_main_view_type_id__once)) {
		GType sideload_main_view_type_id;
		sideload_main_view_type_id = sideload_main_view_get_type_once ();
		g_once_init_leave (&sideload_main_view_type_id__once, sideload_main_view_type_id);
	}
	return sideload_main_view_type_id__once;
}

static void
_vala_sideload_main_view_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	SideloadMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDELOAD_TYPE_MAIN_VIEW, SideloadMainView);
	switch (property_id) {
		case SIDELOAD_MAIN_VIEW_APP_NAME_PROPERTY:
		sideload_main_view_set_app_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

