/* overview.c generated by valac 0.56.17, the Vala compiler
 * generated from overview.vala, do not modify */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <pango/pangocairo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PDFPC_WINDOW_TYPE_OVERVIEW (pdfpc_window_overview_get_type ())
#define PDFPC_WINDOW_OVERVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_WINDOW_TYPE_OVERVIEW, pdfpcWindowOverview))
#define PDFPC_WINDOW_OVERVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_WINDOW_TYPE_OVERVIEW, pdfpcWindowOverviewClass))
#define PDFPC_WINDOW_IS_OVERVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_WINDOW_TYPE_OVERVIEW))
#define PDFPC_WINDOW_IS_OVERVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_WINDOW_TYPE_OVERVIEW))
#define PDFPC_WINDOW_OVERVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_WINDOW_TYPE_OVERVIEW, pdfpcWindowOverviewClass))

typedef struct _pdfpcWindowOverview pdfpcWindowOverview;
typedef struct _pdfpcWindowOverviewClass pdfpcWindowOverviewClass;
typedef struct _pdfpcWindowOverviewPrivate pdfpcWindowOverviewPrivate;

#define PDFPC_TYPE_PRESENTATION_CONTROLLER (pdfpc_presentation_controller_get_type ())
#define PDFPC_PRESENTATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_TYPE_PRESENTATION_CONTROLLER, pdfpcPresentationController))
#define PDFPC_PRESENTATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_TYPE_PRESENTATION_CONTROLLER, pdfpcPresentationControllerClass))
#define PDFPC_IS_PRESENTATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_TYPE_PRESENTATION_CONTROLLER))
#define PDFPC_IS_PRESENTATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_TYPE_PRESENTATION_CONTROLLER))
#define PDFPC_PRESENTATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_TYPE_PRESENTATION_CONTROLLER, pdfpcPresentationControllerClass))

typedef struct _pdfpcPresentationController pdfpcPresentationController;
typedef struct _pdfpcPresentationControllerClass pdfpcPresentationControllerClass;

#define PDFPC_WINDOW_TYPE_CELL_RENDERER_HIGHLIGHT (pdfpc_window_cell_renderer_highlight_get_type ())
#define PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_WINDOW_TYPE_CELL_RENDERER_HIGHLIGHT, pdfpcWindowCellRendererHighlight))
#define PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_WINDOW_TYPE_CELL_RENDERER_HIGHLIGHT, pdfpcWindowCellRendererHighlightClass))
#define PDFPC_WINDOW_IS_CELL_RENDERER_HIGHLIGHT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_WINDOW_TYPE_CELL_RENDERER_HIGHLIGHT))
#define PDFPC_WINDOW_IS_CELL_RENDERER_HIGHLIGHT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_WINDOW_TYPE_CELL_RENDERER_HIGHLIGHT))
#define PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_WINDOW_TYPE_CELL_RENDERER_HIGHLIGHT, pdfpcWindowCellRendererHighlightClass))

typedef struct _pdfpcWindowCellRendererHighlight pdfpcWindowCellRendererHighlight;
typedef struct _pdfpcWindowCellRendererHighlightClass pdfpcWindowCellRendererHighlightClass;
enum  {
	PDFPC_WINDOW_OVERVIEW_0_PROPERTY,
	PDFPC_WINDOW_OVERVIEW_METADATA_PROPERTY,
	PDFPC_WINDOW_OVERVIEW_CURRENT_SLIDE_PROPERTY,
	PDFPC_WINDOW_OVERVIEW_NUM_PROPERTIES
};
static GParamSpec* pdfpc_window_overview_properties[PDFPC_WINDOW_OVERVIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

#define PDFPC_METADATA_TYPE_PDF (pdfpc_metadata_pdf_get_type ())
#define PDFPC_METADATA_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdf))
#define PDFPC_METADATA_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))
#define PDFPC_METADATA_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))

typedef struct _pdfpcMetadataPdf pdfpcMetadataPdf;
typedef struct _pdfpcMetadataPdfClass pdfpcMetadataPdfClass;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _pdfpcWindowCellRendererHighlightPrivate pdfpcWindowCellRendererHighlightPrivate;
enum  {
	PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_0_PROPERTY,
	PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_ID_PROPERTY,
	PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_FONT_DESCRIPTION_PROPERTY,
	PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_METADATA_PROPERTY,
	PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_WIDTH_PROPERTY,
	PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_HEIGHT_PROPERTY,
	PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_NUM_PROPERTIES
};
static GParamSpec* pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_NUM_PROPERTIES];

#define PDFPC_RENDERER_TYPE_PDF (pdfpc_renderer_pdf_get_type ())
#define PDFPC_RENDERER_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdf))
#define PDFPC_RENDERER_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdfClass))
#define PDFPC_RENDERER_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_RENDERER_TYPE_PDF))
#define PDFPC_RENDERER_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_RENDERER_TYPE_PDF))
#define PDFPC_RENDERER_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_RENDERER_TYPE_PDF, pdfpcRendererPdfClass))

typedef struct _pdfpcRendererPdf pdfpcRendererPdf;
typedef struct _pdfpcRendererPdfClass pdfpcRendererPdfClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define PDFPC_PRESENTATION_CONTROLLER_TYPE_SCALED_RECTANGLE (pdfpc_presentation_controller_scaled_rectangle_get_type ())
typedef struct _pdfpcPresentationControllerScaledRectangle pdfpcPresentationControllerScaledRectangle;

#define PDFPC_RENDERER_TYPE_RENDER_ERROR (pdfpc_renderer_render_error_get_type ())

struct _pdfpcWindowOverview {
	GtkScrolledWindow parent_instance;
	pdfpcWindowOverviewPrivate * priv;
	GtkListStore* slides;
	GtkIconView* slides_view;
	gint n_slides;
	gint target_width;
	gint target_height;
	pdfpcPresentationController* controller;
	gint max_width;
	gint max_height;
};

struct _pdfpcWindowOverviewClass {
	GtkScrolledWindowClass parent_class;
};

struct _pdfpcWindowOverviewPrivate {
	gint _current_slide;
	pdfpcWindowCellRendererHighlight* cell_renderer;
};

struct _pdfpcWindowCellRendererHighlight {
	GtkCellRenderer parent_instance;
	pdfpcWindowCellRendererHighlightPrivate * priv;
};

struct _pdfpcWindowCellRendererHighlightClass {
	GtkCellRendererClass parent_class;
};

struct _pdfpcWindowCellRendererHighlightPrivate {
	gint _slide_id;
	PangoFontDescription* _font_description;
	pdfpcMetadataPdf* _metadata;
	gint _slide_width;
	gint _slide_height;
};

struct _pdfpcPresentationControllerScaledRectangle {
	gdouble x;
	gdouble y;
	gdouble width;
	gdouble height;
};

typedef enum  {
	PDFPC_RENDERER_RENDER_ERROR_SLIDE_DOES_NOT_EXIST
} pdfpcRendererRenderError;
#define PDFPC_RENDERER_RENDER_ERROR pdfpc_renderer_render_error_quark ()

static gint pdfpcWindowOverview_private_offset;
static gpointer pdfpc_window_overview_parent_class = NULL;
VALA_EXTERN gint pdfpc_options_min_overview_width;
static gint pdfpcWindowCellRendererHighlight_private_offset;
static gpointer pdfpc_window_cell_renderer_highlight_parent_class = NULL;

VALA_EXTERN GType pdfpc_window_overview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcWindowOverview, g_object_unref)
VALA_EXTERN GType pdfpc_presentation_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcPresentationController, g_object_unref)
VALA_EXTERN GType pdfpc_window_cell_renderer_highlight_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcWindowCellRendererHighlight, g_object_unref)
VALA_EXTERN void pdfpc_window_overview_on_selection_changed (pdfpcWindowOverview* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
VALA_EXTERN void pdfpc_window_overview_set_current_slide (pdfpcWindowOverview* self,
                                              gint value);
VALA_EXTERN pdfpcWindowOverview* pdfpc_window_overview_new (pdfpcPresentationController* controller);
VALA_EXTERN pdfpcWindowOverview* pdfpc_window_overview_construct (GType object_type,
                                                      pdfpcPresentationController* controller);
VALA_EXTERN pdfpcWindowCellRendererHighlight* pdfpc_window_cell_renderer_highlight_new (void);
VALA_EXTERN pdfpcWindowCellRendererHighlight* pdfpc_window_cell_renderer_highlight_construct (GType object_type);
VALA_EXTERN GType pdfpc_metadata_pdf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcMetadataPdf, g_object_unref)
VALA_EXTERN pdfpcMetadataPdf* pdfpc_window_overview_get_metadata (pdfpcWindowOverview* self);
VALA_EXTERN void pdfpc_window_cell_renderer_highlight_set_metadata (pdfpcWindowCellRendererHighlight* self,
                                                        pdfpcMetadataPdf* value);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN void pdfpc_window_cell_renderer_highlight_set_font_description (pdfpcWindowCellRendererHighlight* self,
                                                                PangoFontDescription* value);
VALA_EXTERN gboolean pdfpc_window_overview_on_mouse_move (pdfpcWindowOverview* self,
                                              GtkWidget* source,
                                              GdkEventMotion* event);
static gboolean _pdfpc_window_overview_on_mouse_move_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                              GdkEventMotion* event,
                                                                              gpointer self);
VALA_EXTERN gboolean pdfpc_window_overview_on_mouse_release (pdfpcWindowOverview* self,
                                                 GdkEventButton* event);
static gboolean _pdfpc_window_overview_on_mouse_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                  GdkEventButton* event,
                                                                                  gpointer self);
VALA_EXTERN gboolean pdfpc_window_overview_on_key_press (pdfpcWindowOverview* self,
                                             GtkWidget* source,
                                             GdkEventKey* key);
static gboolean _pdfpc_window_overview_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                         GdkEventKey* event,
                                                                         gpointer self);
static void _pdfpc_window_overview_on_selection_changed_gtk_icon_view_selection_changed (GtkIconView* _sender,
                                                                                  gpointer self);
VALA_EXTERN void pdfpc_window_overview_set_available_space (pdfpcWindowOverview* self,
                                                gint width,
                                                gint height);
VALA_EXTERN void pdfpc_window_overview_prepare_layout (pdfpcWindowOverview* self);
VALA_EXTERN gboolean pdfpc_metadata_pdf_get_is_ready (pdfpcMetadataPdf* self);
VALA_EXTERN gdouble pdfpc_metadata_pdf_get_page_width (pdfpcMetadataPdf* self);
VALA_EXTERN gdouble pdfpc_metadata_pdf_get_page_height (pdfpcMetadataPdf* self);
VALA_EXTERN void pdfpc_window_cell_renderer_highlight_set_slide_width (pdfpcWindowCellRendererHighlight* self,
                                                           gint value);
VALA_EXTERN void pdfpc_window_cell_renderer_highlight_set_slide_height (pdfpcWindowCellRendererHighlight* self,
                                                            gint value);
VALA_EXTERN void pdfpc_window_overview_set_n_slides (pdfpcWindowOverview* self,
                                         gint n);
VALA_EXTERN gint pdfpc_window_overview_get_current_slide (pdfpcWindowOverview* self);
VALA_EXTERN void pdfpc_window_overview_remove_current (pdfpcWindowOverview* self,
                                           gint newn);
VALA_EXTERN void pdfpc_presentation_controller_goto_user_page (pdfpcPresentationController* self,
                                                   gint page_number,
                                                   gboolean useLast);
VALA_EXTERN void pdfpc_presentation_controller_controllables_hide_overview (pdfpcPresentationController* self);
VALA_EXTERN pdfpcMetadataPdf* pdfpc_presentation_controller_get_metadata (pdfpcPresentationController* self);
static void pdfpc_window_overview_finalize (GObject * obj);
static GType pdfpc_window_overview_get_type_once (void);
static void _vala_pdfpc_window_overview_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_pdfpc_window_overview_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void pdfpc_window_cell_renderer_highlight_real_get_size (GtkCellRenderer* base,
                                                         GtkWidget* widget,
                                                         GdkRectangle* cell_area,
                                                         gint* x_offset,
                                                         gint* y_offset,
                                                         gint* width,
                                                         gint* height);
VALA_EXTERN gint pdfpc_window_cell_renderer_highlight_get_slide_width (pdfpcWindowCellRendererHighlight* self);
VALA_EXTERN gint pdfpc_window_cell_renderer_highlight_get_slide_height (pdfpcWindowCellRendererHighlight* self);
static void pdfpc_window_cell_renderer_highlight_real_render (GtkCellRenderer* base,
                                                       cairo_t* cr,
                                                       GtkWidget* widget,
                                                       GdkRectangle* background_area,
                                                       GdkRectangle* cell_area,
                                                       GtkCellRendererState flags);
VALA_EXTERN GType pdfpc_renderer_pdf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcRendererPdf, g_object_unref)
VALA_EXTERN pdfpcMetadataPdf* pdfpc_window_cell_renderer_highlight_get_metadata (pdfpcWindowCellRendererHighlight* self);
VALA_EXTERN pdfpcRendererPdf* pdfpc_metadata_pdf_get_renderer (pdfpcMetadataPdf* self);
VALA_EXTERN gint pdfpc_metadata_pdf_user_slide_to_real_slide (pdfpcMetadataPdf* self,
                                                  gint number,
                                                  gboolean lastSlide);
VALA_EXTERN gint pdfpc_window_cell_renderer_highlight_get_slide_id (pdfpcWindowCellRendererHighlight* self);
VALA_EXTERN GType pdfpc_presentation_controller_scaled_rectangle_get_type (void) G_GNUC_CONST ;
VALA_EXTERN pdfpcPresentationControllerScaledRectangle* pdfpc_presentation_controller_scaled_rectangle_dup (const pdfpcPresentationControllerScaledRectangle* self);
VALA_EXTERN void pdfpc_presentation_controller_scaled_rectangle_free (pdfpcPresentationControllerScaledRectangle* self);
VALA_EXTERN GQuark pdfpc_renderer_render_error_quark (void);
VALA_EXTERN GType pdfpc_renderer_render_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN cairo_surface_t* pdfpc_renderer_pdf_render (pdfpcRendererPdf* self,
                                            gint slide_number,
                                            gboolean notes_area,
                                            gint width,
                                            gint height,
                                            gboolean force_cache,
                                            gboolean permanent_cache,
                                            pdfpcPresentationControllerScaledRectangle* zoom_area,
                                            GError** error);
VALA_EXTERN gboolean pdfpc_metadata_pdf_get_user_slide_hidden (pdfpcMetadataPdf* self,
                                                   gint user_slide);
VALA_EXTERN PangoFontDescription* pdfpc_window_cell_renderer_highlight_get_font_description (pdfpcWindowCellRendererHighlight* self);
VALA_EXTERN void pdfpc_window_cell_renderer_highlight_set_slide_id (pdfpcWindowCellRendererHighlight* self,
                                                        gint value);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static void pdfpc_window_cell_renderer_highlight_finalize (GObject * obj);
static GType pdfpc_window_cell_renderer_highlight_get_type_once (void);
static void _vala_pdfpc_window_cell_renderer_highlight_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_pdfpc_window_cell_renderer_highlight_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
pdfpc_window_overview_get_instance_private (pdfpcWindowOverview* self)
{
	return G_STRUCT_MEMBER_P (self, pdfpcWindowOverview_private_offset);
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

void
pdfpc_window_overview_on_selection_changed (pdfpcWindowOverview* self)
{
	GList* ltp = NULL;
	GtkIconView* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->slides_view;
	_tmp1_ = gtk_icon_view_get_selected_items (_tmp0_);
	ltp = _tmp1_;
	_tmp2_ = ltp;
	if (_tmp2_ != NULL) {
		GtkTreePath* tp = NULL;
		GList* _tmp3_;
		gconstpointer _tmp4_;
		GtkTreePath* _tmp5_;
		GtkTreePath* _tmp6_;
		gint _tmp7_ = 0;
		gint* _tmp8_;
		_tmp3_ = ltp;
		_tmp4_ = _tmp3_->data;
		_tmp5_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp4_);
		tp = _tmp5_;
		_tmp6_ = tp;
		_tmp8_ = gtk_tree_path_get_indices_with_depth (_tmp6_, &_tmp7_);
		if (_tmp8_ != NULL) {
			GtkTreePath* _tmp9_;
			gint _tmp10_ = 0;
			gint* _tmp11_;
			gint _tmp12_;
			_tmp9_ = tp;
			_tmp11_ = gtk_tree_path_get_indices_with_depth (_tmp9_, &_tmp10_);
			_tmp12_ = _tmp11_[0];
			self->priv->_current_slide = _tmp12_;
			__vala_GtkTreePath_free0 (tp);
			(ltp == NULL) ? NULL : (ltp = (_g_list_free___vala_GtkTreePath_free0_ (ltp), NULL));
			return;
		}
		__vala_GtkTreePath_free0 (tp);
	}
	pdfpc_window_overview_set_current_slide (self, self->priv->_current_slide);
	(ltp == NULL) ? NULL : (ltp = (_g_list_free___vala_GtkTreePath_free0_ (ltp), NULL));
}

/**
         * Constructor
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static gboolean
_pdfpc_window_overview_on_mouse_move_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                     GdkEventMotion* event,
                                                                     gpointer self)
{
	gboolean result;
	result = pdfpc_window_overview_on_mouse_move ((pdfpcWindowOverview*) self, _sender, event);
	return result;
}

static gboolean
_pdfpc_window_overview_on_mouse_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self)
{
	gboolean result;
	result = pdfpc_window_overview_on_mouse_release ((pdfpcWindowOverview*) self, event);
	return result;
}

static gboolean
_pdfpc_window_overview_on_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                GdkEventKey* event,
                                                                gpointer self)
{
	gboolean result;
	result = pdfpc_window_overview_on_key_press ((pdfpcWindowOverview*) self, _sender, event);
	return result;
}

static void
_pdfpc_window_overview_on_selection_changed_gtk_icon_view_selection_changed (GtkIconView* _sender,
                                                                             gpointer self)
{
	pdfpc_window_overview_on_selection_changed ((pdfpcWindowOverview*) self);
}

pdfpcWindowOverview*
pdfpc_window_overview_construct (GType object_type,
                                 pdfpcPresentationController* controller)
{
	pdfpcWindowOverview * self = NULL;
	pdfpcPresentationController* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* _tmp3_;
	GtkIconView* _tmp4_;
	GtkIconView* _tmp5_;
	GtkIconView* _tmp6_;
	pdfpcWindowCellRendererHighlight* _tmp7_;
	pdfpcWindowCellRendererHighlight* _tmp8_;
	pdfpcMetadataPdf* _tmp9_;
	pdfpcMetadataPdf* _tmp10_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp11_;
	GtkStyleContext* _tmp12_;
	PangoFontDescription* font_description = NULL;
	PangoFontDescription* _tmp13_ = NULL;
	pdfpcWindowCellRendererHighlight* _tmp14_;
	GtkIconView* _tmp15_;
	pdfpcWindowCellRendererHighlight* _tmp16_;
	GtkIconView* _tmp17_;
	pdfpcWindowCellRendererHighlight* _tmp18_;
	GtkIconView* _tmp19_;
	GtkIconView* _tmp20_;
	GtkIconView* _tmp21_;
	GtkIconView* _tmp22_;
	GtkIconView* _tmp23_;
	GtkIconView* _tmp24_;
	g_return_val_if_fail (controller != NULL, NULL);
	self = (pdfpcWindowOverview*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (controller);
	_g_object_unref0 (self->controller);
	self->controller = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "overviewWindow");
	_tmp2_ = gtk_list_store_new (1, G_TYPE_INT, -1);
	_g_object_unref0 (self->slides);
	self->slides = _tmp2_;
	_tmp3_ = self->slides;
	_tmp4_ = (GtkIconView*) gtk_icon_view_new_with_model ((GtkTreeModel*) _tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->slides_view);
	self->slides_view = _tmp4_;
	_tmp5_ = self->slides_view;
	gtk_icon_view_set_selection_mode (_tmp5_, GTK_SELECTION_SINGLE);
	_tmp6_ = self->slides_view;
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	_tmp7_ = pdfpc_window_cell_renderer_highlight_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->cell_renderer);
	self->priv->cell_renderer = _tmp7_;
	_tmp8_ = self->priv->cell_renderer;
	_tmp9_ = pdfpc_window_overview_get_metadata (self);
	_tmp10_ = _tmp9_;
	pdfpc_window_cell_renderer_highlight_set_metadata (_tmp8_, _tmp10_);
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	style_context = _tmp12_;
	gtk_style_context_get (style_context, gtk_style_context_get_state (style_context), "font", &_tmp13_, NULL, NULL);
	__vala_PangoFontDescription_free0 (font_description);
	font_description = _tmp13_;
	_tmp14_ = self->priv->cell_renderer;
	pdfpc_window_cell_renderer_highlight_set_font_description (_tmp14_, font_description);
	_tmp15_ = self->slides_view;
	_tmp16_ = self->priv->cell_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp15_, (GtkCellRenderer*) _tmp16_, TRUE);
	_tmp17_ = self->slides_view;
	_tmp18_ = self->priv->cell_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp17_, (GtkCellRenderer*) _tmp18_, "slide_id", 0);
	_tmp19_ = self->slides_view;
	gtk_icon_view_set_item_padding (_tmp19_, 0);
	_tmp20_ = self->slides_view;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp20_);
	_tmp21_ = self->slides_view;
	g_signal_connect_object ((GtkWidget*) _tmp21_, "motion-notify-event", (GCallback) _pdfpc_window_overview_on_mouse_move_gtk_widget_motion_notify_event, self, 0);
	_tmp22_ = self->slides_view;
	g_signal_connect_object ((GtkWidget*) _tmp22_, "button-release-event", (GCallback) _pdfpc_window_overview_on_mouse_release_gtk_widget_button_release_event, self, 0);
	_tmp23_ = self->slides_view;
	g_signal_connect_object ((GtkWidget*) _tmp23_, "key-press-event", (GCallback) _pdfpc_window_overview_on_key_press_gtk_widget_key_press_event, self, 0);
	_tmp24_ = self->slides_view;
	g_signal_connect_object (_tmp24_, "selection-changed", (GCallback) _pdfpc_window_overview_on_selection_changed_gtk_icon_view_selection_changed, self, 0);
	__vala_PangoFontDescription_free0 (font_description);
	_g_object_unref0 (style_context);
	return self;
}

pdfpcWindowOverview*
pdfpc_window_overview_new (pdfpcPresentationController* controller)
{
	return pdfpc_window_overview_construct (PDFPC_WINDOW_TYPE_OVERVIEW, controller);
}

void
pdfpc_window_overview_set_available_space (pdfpcWindowOverview* self,
                                           gint width,
                                           gint height)
{
	g_return_if_fail (self != NULL);
	self->max_width = width;
	self->max_height = height;
	pdfpc_window_overview_prepare_layout (self);
}

/**
         * Figure out the sizes for the icons, and create entries in slides
         * for all the slides.
         */
void
pdfpc_window_overview_prepare_layout (pdfpcWindowOverview* self)
{
	pdfpcMetadataPdf* _tmp0_;
	pdfpcMetadataPdf* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gdouble aspect_ratio = 0.0;
	pdfpcMetadataPdf* _tmp4_;
	pdfpcMetadataPdf* _tmp5_;
	pdfpcMetadataPdf* _tmp6_;
	pdfpcMetadataPdf* _tmp7_;
	GtkIconView* _tmp8_;
	gint margin = 0;
	GtkIconView* _tmp9_;
	gint padding = 0;
	GtkIconView* _tmp10_;
	gint row_spacing = 0;
	GtkIconView* _tmp11_;
	gint col_spacing = 0;
	GtkIconView* _tmp12_;
	gint eff_max_width = 0;
	gint eff_max_height = 0;
	gint cols = 0;
	gint widthx = 0;
	gint widthy = 0;
	gint min_width = 0;
	gint rows = 0;
	gint tc = 0;
	GtkIconView* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint full_height = 0;
	pdfpcWindowCellRendererHighlight* _tmp19_;
	pdfpcWindowCellRendererHighlight* _tmp20_;
	GtkListStore* _tmp21_;
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = pdfpc_window_overview_get_metadata (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = pdfpc_metadata_pdf_get_is_ready (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		return;
	}
	if (self->max_width == -1) {
		return;
	}
	_tmp4_ = pdfpc_window_overview_get_metadata (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = pdfpc_window_overview_get_metadata (self);
	_tmp7_ = _tmp6_;
	aspect_ratio = pdfpc_metadata_pdf_get_page_width (_tmp5_) / pdfpc_metadata_pdf_get_page_height (_tmp7_);
	_tmp8_ = self->slides_view;
	gtk_icon_view_set_margin (_tmp8_, 0);
	_tmp9_ = self->slides_view;
	margin = gtk_icon_view_get_margin (_tmp9_);
	_tmp10_ = self->slides_view;
	padding = gtk_icon_view_get_item_padding (_tmp10_) + 1;
	_tmp11_ = self->slides_view;
	row_spacing = gtk_icon_view_get_row_spacing (_tmp11_);
	_tmp12_ = self->slides_view;
	col_spacing = gtk_icon_view_get_column_spacing (_tmp12_);
	eff_max_width = self->max_width - (2 * margin);
	eff_max_height = self->max_height - (2 * margin);
	cols = eff_max_width / ((pdfpc_options_min_overview_width + (2 * padding)) + col_spacing);
	tc = 0;
	self->target_width = 0;
	while (TRUE) {
		gint _tmp13_ = 0;
		if (!(cols > 0)) {
			break;
		}
		widthx = ((eff_max_width / cols) - (2 * padding)) - (2 * col_spacing);
		rows = (gint) ceil ((gdouble) (((gfloat) self->n_slides) / cols));
		widthy = (gint) floor ((((eff_max_height / rows) - (2 * padding)) - (2 * row_spacing)) * aspect_ratio);
		if (widthy < pdfpc_options_min_overview_width) {
			break;
		}
		if (widthx < widthy) {
			_tmp13_ = widthx;
		} else {
			_tmp13_ = widthy;
		}
		min_width = _tmp13_;
		if (min_width >= self->target_width) {
			self->target_width = min_width;
			tc = cols;
		}
		cols -= 1;
	}
	if (self->target_width < pdfpc_options_min_overview_width) {
		GtkIconView* _tmp14_;
		self->target_width = pdfpc_options_min_overview_width;
		_tmp14_ = self->slides_view;
		gtk_icon_view_set_columns (_tmp14_, (eff_max_width - 20) / ((pdfpc_options_min_overview_width + (2 * padding)) + col_spacing));
	} else {
		GtkIconView* _tmp15_;
		_tmp15_ = self->slides_view;
		gtk_icon_view_set_columns (_tmp15_, tc);
	}
	gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
	self->target_height = (gint) round (self->target_width / aspect_ratio);
	_tmp16_ = self->slides_view;
	_tmp17_ = gtk_icon_view_get_columns (_tmp16_);
	_tmp18_ = _tmp17_;
	rows = (gint) ceil ((gdouble) (((gfloat) self->n_slides) / _tmp18_));
	full_height = (rows * ((self->target_height + (2 * padding)) + (2 * row_spacing))) + (2 * margin);
	if (full_height > self->max_height) {
		full_height = self->max_height;
	}
	_tmp19_ = self->priv->cell_renderer;
	pdfpc_window_cell_renderer_highlight_set_slide_width (_tmp19_, self->target_width);
	_tmp20_ = self->priv->cell_renderer;
	pdfpc_window_cell_renderer_highlight_set_slide_height (_tmp20_, self->target_height);
	_tmp21_ = self->slides;
	gtk_list_store_clear (_tmp21_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				GtkListStore* _tmp24_;
				GtkTreeIter _tmp25_ = {0};
				GtkListStore* _tmp26_;
				GtkTreeIter _tmp27_;
				GValue _tmp28_ = {0};
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < self->n_slides)) {
					break;
				}
				_tmp24_ = self->slides;
				gtk_list_store_append (_tmp24_, &_tmp25_);
				iter = _tmp25_;
				_tmp26_ = self->slides;
				_tmp27_ = iter;
				g_value_init (&_tmp28_, G_TYPE_INT);
				g_value_set_int (&_tmp28_, i);
				gtk_list_store_set_value (_tmp26_, &_tmp27_, 0, &_tmp28_);
				G_IS_VALUE (&_tmp28_) ? (g_value_unset (&_tmp28_), NULL) : NULL;
			}
		}
	}
}

/**
         * Set the number of slides. If it is different to what we know, it
         * triggers a rebuilding of the widget.
         */
void
pdfpc_window_overview_set_n_slides (pdfpcWindowOverview* self,
                                    gint n)
{
	g_return_if_fail (self != NULL);
	if (n != self->n_slides) {
		gint currently_selected = 0;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = pdfpc_window_overview_get_current_slide (self);
		_tmp1_ = _tmp0_;
		currently_selected = _tmp1_;
		self->n_slides = n;
		pdfpc_window_overview_prepare_layout (self);
		if (currently_selected >= self->n_slides) {
			currently_selected = self->n_slides - 1;
		}
		pdfpc_window_overview_set_current_slide (self, currently_selected);
	}
}

/**
         * Remove the current slide from the overview, and set the total number
         * of slides to the new value.  Perpare to regenerate the structure the
         * next time the overview is hidden.
         */
void
pdfpc_window_overview_remove_current (pdfpcWindowOverview* self,
                                      gint newn)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	GtkListStore* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	self->n_slides = newn;
	_tmp0_ = self->slides;
	_tmp1_ = pdfpc_window_overview_get_current_slide (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = self->slides;
	gtk_list_store_remove (_tmp6_, &iter);
	_tmp7_ = pdfpc_window_overview_get_current_slide (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ >= self->n_slides) {
		pdfpc_window_overview_set_current_slide (self, self->n_slides - 1);
	}
}

/**
         * We handle some "navigation" key presses ourselves. Others are left to
         * the standard IconView controls, the rest are passed back to the
         * PresentationController.
         */
gboolean
pdfpc_window_overview_on_key_press (pdfpcWindowOverview* self,
                                    GtkWidget* source,
                                    GdkEventKey* key)
{
	gboolean handled = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	handled = TRUE;
	switch (key->keyval) {
		case GDK_KEY_Left:
		case GDK_KEY_Page_Up:
		{
			gint _tmp0_;
			gint _tmp1_;
			_tmp0_ = pdfpc_window_overview_get_current_slide (self);
			_tmp1_ = _tmp0_;
			if (_tmp1_ > 0) {
				gint _tmp2_;
				gint _tmp3_;
				_tmp2_ = pdfpc_window_overview_get_current_slide (self);
				_tmp3_ = _tmp2_;
				pdfpc_window_overview_set_current_slide (self, _tmp3_ - 1);
			}
			break;
		}
		case GDK_KEY_Right:
		case GDK_KEY_Page_Down:
		{
			gint _tmp4_;
			gint _tmp5_;
			_tmp4_ = pdfpc_window_overview_get_current_slide (self);
			_tmp5_ = _tmp4_;
			if (_tmp5_ < (self->n_slides - 1)) {
				gint _tmp6_;
				gint _tmp7_;
				_tmp6_ = pdfpc_window_overview_get_current_slide (self);
				_tmp7_ = _tmp6_;
				pdfpc_window_overview_set_current_slide (self, _tmp7_ + 1);
			}
			break;
		}
		case GDK_KEY_Return:
		{
			gboolean gotoFirst = FALSE;
			pdfpcPresentationController* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gotoFirst = (key->state & GDK_SHIFT_MASK) != 0;
			_tmp8_ = self->controller;
			_tmp9_ = pdfpc_window_overview_get_current_slide (self);
			_tmp10_ = _tmp9_;
			pdfpc_presentation_controller_goto_user_page (_tmp8_, _tmp10_, !gotoFirst);
			break;
		}
		case GDK_KEY_Escape:
		{
			pdfpcPresentationController* _tmp11_;
			_tmp11_ = self->controller;
			pdfpc_presentation_controller_controllables_hide_overview (_tmp11_);
			break;
		}
		default:
		{
			handled = FALSE;
			break;
		}
	}
	result = handled;
	return result;
}

gboolean
pdfpc_window_overview_on_mouse_move (pdfpcWindowOverview* self,
                                     GtkWidget* source,
                                     GdkEventMotion* event)
{
	GtkTreePath* path = NULL;
	GtkIconView* _tmp0_;
	GtkTreePath* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkTreePath* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->slides_view;
	_tmp1_ = gtk_icon_view_get_path_at_pos (_tmp0_, (gint) event->x, (gint) event->y);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ != NULL) {
		GtkTreePath* _tmp4_;
		gint _tmp5_ = 0;
		gint* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp4_ = path;
		_tmp6_ = gtk_tree_path_get_indices_with_depth (_tmp4_, &_tmp5_);
		_tmp7_ = _tmp6_[0];
		_tmp8_ = pdfpc_window_overview_get_current_slide (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = _tmp7_ != _tmp9_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkTreePath* _tmp10_;
		gint _tmp11_ = 0;
		gint* _tmp12_;
		gint _tmp13_;
		_tmp10_ = path;
		_tmp12_ = gtk_tree_path_get_indices_with_depth (_tmp10_, &_tmp11_);
		_tmp13_ = _tmp12_[0];
		pdfpc_window_overview_set_current_slide (self, _tmp13_);
	}
	result = FALSE;
	__vala_GtkTreePath_free0 (path);
	return result;
}

gboolean
pdfpc_window_overview_on_mouse_release (pdfpcWindowOverview* self,
                                        GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 1)) {
		gboolean gotoFirst = FALSE;
		pdfpcPresentationController* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gotoFirst = (event->state & GDK_SHIFT_MASK) != 0;
		_tmp0_ = self->controller;
		_tmp1_ = pdfpc_window_overview_get_current_slide (self);
		_tmp2_ = _tmp1_;
		pdfpc_presentation_controller_goto_user_page (_tmp0_, _tmp2_, !gotoFirst);
	}
	result = FALSE;
	return result;
}

pdfpcMetadataPdf*
pdfpc_window_overview_get_metadata (pdfpcWindowOverview* self)
{
	pdfpcMetadataPdf* result;
	pdfpcPresentationController* _tmp0_;
	pdfpcMetadataPdf* _tmp1_;
	pdfpcMetadataPdf* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->controller;
	_tmp1_ = pdfpc_presentation_controller_get_metadata (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gint
pdfpc_window_overview_get_current_slide (pdfpcWindowOverview* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_slide;
	return result;
}

void
pdfpc_window_overview_set_current_slide (pdfpcWindowOverview* self,
                                         gint value)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkIconView* _tmp1_;
	GtkIconView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_path_new_from_indices (value, -1);
	path = _tmp0_;
	_tmp1_ = self->slides_view;
	gtk_icon_view_select_path (_tmp1_, path);
	_tmp2_ = self->slides_view;
	gtk_icon_view_set_cursor (_tmp2_, path, NULL, FALSE);
	__vala_GtkTreePath_free0 (path);
	g_object_notify_by_pspec ((GObject *) self, pdfpc_window_overview_properties[PDFPC_WINDOW_OVERVIEW_CURRENT_SLIDE_PROPERTY]);
}

static void
pdfpc_window_overview_class_init (pdfpcWindowOverviewClass * klass,
                                  gpointer klass_data)
{
	pdfpc_window_overview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &pdfpcWindowOverview_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pdfpc_window_overview_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pdfpc_window_overview_set_property;
	G_OBJECT_CLASS (klass)->finalize = pdfpc_window_overview_finalize;
	/**
	         * Metadata of the slides
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_WINDOW_OVERVIEW_METADATA_PROPERTY, pdfpc_window_overview_properties[PDFPC_WINDOW_OVERVIEW_METADATA_PROPERTY] = g_param_spec_object ("metadata", "metadata", "metadata", PDFPC_METADATA_TYPE_PDF, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_WINDOW_OVERVIEW_CURRENT_SLIDE_PROPERTY, pdfpc_window_overview_properties[PDFPC_WINDOW_OVERVIEW_CURRENT_SLIDE_PROPERTY] = g_param_spec_int ("current-slide", "current-slide", "current-slide", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
pdfpc_window_overview_instance_init (pdfpcWindowOverview * self,
                                     gpointer klass)
{
	self->priv = pdfpc_window_overview_get_instance_private (self);
	self->n_slides = 0;
	self->max_width = -1;
	self->max_height = -1;
	self->priv->_current_slide = 0;
}

static void
pdfpc_window_overview_finalize (GObject * obj)
{
	pdfpcWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PDFPC_WINDOW_TYPE_OVERVIEW, pdfpcWindowOverview);
	_g_object_unref0 (self->slides);
	_g_object_unref0 (self->slides_view);
	_g_object_unref0 (self->controller);
	_g_object_unref0 (self->priv->cell_renderer);
	G_OBJECT_CLASS (pdfpc_window_overview_parent_class)->finalize (obj);
}

/**
     * An overview of all the slides in the form of a table
     */
static GType
pdfpc_window_overview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (pdfpcWindowOverviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_window_overview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcWindowOverview), 0, (GInstanceInitFunc) pdfpc_window_overview_instance_init, NULL };
	GType pdfpc_window_overview_type_id;
	pdfpc_window_overview_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "pdfpcWindowOverview", &g_define_type_info, 0);
	pdfpcWindowOverview_private_offset = g_type_add_instance_private (pdfpc_window_overview_type_id, sizeof (pdfpcWindowOverviewPrivate));
	return pdfpc_window_overview_type_id;
}

GType
pdfpc_window_overview_get_type (void)
{
	static volatile gsize pdfpc_window_overview_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_window_overview_type_id__once)) {
		GType pdfpc_window_overview_type_id;
		pdfpc_window_overview_type_id = pdfpc_window_overview_get_type_once ();
		g_once_init_leave (&pdfpc_window_overview_type_id__once, pdfpc_window_overview_type_id);
	}
	return pdfpc_window_overview_type_id__once;
}

static void
_vala_pdfpc_window_overview_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	pdfpcWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PDFPC_WINDOW_TYPE_OVERVIEW, pdfpcWindowOverview);
	switch (property_id) {
		case PDFPC_WINDOW_OVERVIEW_METADATA_PROPERTY:
		g_value_set_object (value, pdfpc_window_overview_get_metadata (self));
		break;
		case PDFPC_WINDOW_OVERVIEW_CURRENT_SLIDE_PROPERTY:
		g_value_set_int (value, pdfpc_window_overview_get_current_slide (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pdfpc_window_overview_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	pdfpcWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PDFPC_WINDOW_TYPE_OVERVIEW, pdfpcWindowOverview);
	switch (property_id) {
		case PDFPC_WINDOW_OVERVIEW_CURRENT_SLIDE_PROPERTY:
		pdfpc_window_overview_set_current_slide (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
pdfpc_window_cell_renderer_highlight_get_instance_private (pdfpcWindowCellRendererHighlight* self)
{
	return G_STRUCT_MEMBER_P (self, pdfpcWindowCellRendererHighlight_private_offset);
}

static void
pdfpc_window_cell_renderer_highlight_real_get_size (GtkCellRenderer* base,
                                                    GtkWidget* widget,
                                                    GdkRectangle* cell_area,
                                                    gint* x_offset,
                                                    gint* y_offset,
                                                    gint* width,
                                                    gint* height)
{
	pdfpcWindowCellRendererHighlight * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	gint _tmp0_;
	gint _tmp1_;
	self = (pdfpcWindowCellRendererHighlight*) base;
	g_return_if_fail (widget != NULL);
	_vala_x_offset = 0;
	_vala_y_offset = 0;
	_tmp0_ = self->priv->_slide_width;
	_vala_width = _tmp0_;
	_tmp1_ = self->priv->_slide_height;
	_vala_height = _tmp1_;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static void
pdfpc_window_cell_renderer_highlight_real_render (GtkCellRenderer* base,
                                                  cairo_t* cr,
                                                  GtkWidget* widget,
                                                  GdkRectangle* background_area,
                                                  GdkRectangle* cell_area,
                                                  GtkCellRendererState flags)
{
	pdfpcWindowCellRendererHighlight * self;
	pdfpcRendererPdf* renderer = NULL;
	pdfpcMetadataPdf* _tmp0_;
	pdfpcRendererPdf* _tmp1_;
	pdfpcRendererPdf* _tmp2_;
	pdfpcRendererPdf* _tmp3_;
	cairo_surface_t* slide_to_fill = NULL;
	cairo_surface_t* _tmp11_;
	gboolean hidden = FALSE;
	pdfpcMetadataPdf* _tmp21_;
	gint _tmp22_;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp27_;
	PangoLayout* _tmp28_;
	PangoFontDescription* _tmp29_;
	PangoLayout* _tmp40_;
	GdkRectangle _tmp41_;
	PangoLayout* _tmp42_;
	PangoRectangle logical_extent = {0};
	PangoLayout* _tmp43_;
	PangoRectangle _tmp44_ = {0};
	GdkRectangle _tmp45_;
	GdkRectangle _tmp46_;
	GdkRectangle _tmp47_;
	GdkRectangle _tmp48_;
	PangoRectangle _tmp49_;
	PangoLayout* _tmp50_;
	GError* _inner_error0_ = NULL;
	self = (pdfpcWindowCellRendererHighlight*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	_tmp0_ = self->priv->_metadata;
	_tmp1_ = pdfpc_metadata_pdf_get_renderer (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	renderer = _tmp3_;
	slide_to_fill = NULL;
	_cairo_surface_destroy0 (slide_to_fill);
	slide_to_fill = NULL;
	{
		gint real_slide_id = 0;
		pdfpcMetadataPdf* _tmp4_;
		gint _tmp5_;
		cairo_surface_t* _tmp6_ = NULL;
		gint _tmp7_;
		gint _tmp8_;
		cairo_surface_t* _tmp9_;
		cairo_surface_t* _tmp10_;
		_tmp4_ = self->priv->_metadata;
		_tmp5_ = self->priv->_slide_id;
		real_slide_id = pdfpc_metadata_pdf_user_slide_to_real_slide (_tmp4_, _tmp5_, TRUE);
		_tmp7_ = self->priv->_slide_width;
		_tmp8_ = self->priv->_slide_height;
		_tmp9_ = pdfpc_renderer_pdf_render (renderer, real_slide_id, FALSE, _tmp7_, _tmp8_, TRUE, TRUE, NULL, &_inner_error0_);
		_tmp6_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == PDFPC_RENDERER_RENDER_ERROR) {
				goto __catch0_pdfpc_renderer_render_error;
			}
			_cairo_surface_destroy0 (slide_to_fill);
			_g_object_unref0 (renderer);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp10_ = _tmp6_;
		_tmp6_ = NULL;
		_cairo_surface_destroy0 (slide_to_fill);
		slide_to_fill = _tmp10_;
		_cairo_surface_destroy0 (_tmp6_);
	}
	goto __finally0;
	__catch0_pdfpc_renderer_render_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cairo_surface_destroy0 (slide_to_fill);
		_g_object_unref0 (renderer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp11_ = slide_to_fill;
	if (_tmp11_ == NULL) {
		GdkRectangle _tmp12_;
		GdkRectangle _tmp13_;
		GdkRectangle _tmp14_;
		GdkRectangle _tmp15_;
		cairo_set_source_rgba (cr, 0.5, 0.5, 0.5, (gdouble) 1);
		_tmp12_ = *cell_area;
		_tmp13_ = *cell_area;
		_tmp14_ = *cell_area;
		_tmp15_ = *cell_area;
		cairo_rectangle (cr, (gdouble) _tmp12_.x, (gdouble) _tmp13_.y, (gdouble) _tmp14_.width, (gdouble) _tmp15_.height);
		cairo_fill (cr);
	} else {
		gdouble scale_factor = 0.0;
		gint _tmp16_;
		cairo_surface_t* _tmp17_;
		cairo_surface_t* _tmp18_;
		GdkRectangle _tmp19_;
		GdkRectangle _tmp20_;
		_tmp16_ = self->priv->_slide_width;
		_tmp17_ = slide_to_fill;
		scale_factor = ((gdouble) _tmp16_) / cairo_image_surface_get_width (_tmp17_);
		cairo_scale (cr, scale_factor, scale_factor);
		_tmp18_ = slide_to_fill;
		_tmp19_ = *cell_area;
		_tmp20_ = *cell_area;
		cairo_set_source_surface (cr, _tmp18_, ((gdouble) _tmp19_.x) / scale_factor, ((gdouble) _tmp20_.y) / scale_factor);
		cairo_paint (cr);
		cairo_scale (cr, 1.0 / scale_factor, 1.0 / scale_factor);
	}
	_tmp21_ = self->priv->_metadata;
	_tmp22_ = self->priv->_slide_id;
	hidden = pdfpc_metadata_pdf_get_user_slide_hidden (_tmp21_, _tmp22_);
	if ((flags & GTK_CELL_RENDERER_SELECTED) == 0) {
		GdkRectangle _tmp23_;
		GdkRectangle _tmp24_;
		GdkRectangle _tmp25_;
		GdkRectangle _tmp26_;
		gdouble alpha = 0.0;
		_tmp23_ = *cell_area;
		_tmp24_ = *cell_area;
		_tmp25_ = *cell_area;
		_tmp26_ = *cell_area;
		cairo_rectangle (cr, (gdouble) _tmp23_.x, (gdouble) _tmp24_.y, (gdouble) _tmp25_.width, (gdouble) _tmp26_.height);
		if (hidden) {
			alpha = 0.7;
		} else {
			alpha = 0.4;
		}
		cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, alpha);
		cairo_fill (cr);
	}
	_tmp27_ = pango_cairo_create_layout (cr);
	layout = _tmp27_;
	_tmp28_ = layout;
	_tmp29_ = self->priv->_font_description;
	pango_layout_set_font_description (_tmp28_, _tmp29_);
	if (hidden) {
		PangoLayout* _tmp30_;
		gint _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp30_ = layout;
		_tmp31_ = self->priv->_slide_id;
		_tmp32_ = g_strdup_printf ("%i", _tmp31_ + 1);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strconcat ("<s>", _tmp33_, "</s>", NULL);
		_tmp35_ = _tmp34_;
		pango_layout_set_markup (_tmp30_, _tmp35_, -1);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
	} else {
		PangoLayout* _tmp36_;
		gint _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp36_ = layout;
		_tmp37_ = self->priv->_slide_id;
		_tmp38_ = g_strdup_printf ("%i", _tmp37_ + 1);
		_tmp39_ = _tmp38_;
		pango_layout_set_text (_tmp36_, _tmp39_, -1);
		_g_free0 (_tmp39_);
	}
	_tmp40_ = layout;
	_tmp41_ = *cell_area;
	pango_layout_set_width (_tmp40_, _tmp41_.width);
	_tmp42_ = layout;
	pango_layout_set_alignment (_tmp42_, PANGO_ALIGN_CENTER);
	_tmp43_ = layout;
	pango_layout_get_pixel_extents (_tmp43_, NULL, &_tmp44_);
	logical_extent = _tmp44_;
	_tmp45_ = *cell_area;
	_tmp46_ = *cell_area;
	_tmp47_ = *cell_area;
	_tmp48_ = *cell_area;
	_tmp49_ = logical_extent;
	cairo_move_to (cr, (gdouble) (_tmp45_.x + (_tmp46_.width / 2)), (gdouble) ((_tmp47_.y + (_tmp48_.height / 2)) - (_tmp49_.height / 2)));
	cairo_set_source_rgba (cr, 0.7, 0.7, 0.7, 0.7);
	_tmp50_ = layout;
	pango_cairo_show_layout (cr, _tmp50_);
	_g_object_unref0 (layout);
	_cairo_surface_destroy0 (slide_to_fill);
	_g_object_unref0 (renderer);
}

pdfpcWindowCellRendererHighlight*
pdfpc_window_cell_renderer_highlight_construct (GType object_type)
{
	pdfpcWindowCellRendererHighlight * self = NULL;
	self = (pdfpcWindowCellRendererHighlight*) g_object_new (object_type, NULL);
	return self;
}

pdfpcWindowCellRendererHighlight*
pdfpc_window_cell_renderer_highlight_new (void)
{
	return pdfpc_window_cell_renderer_highlight_construct (PDFPC_WINDOW_TYPE_CELL_RENDERER_HIGHLIGHT);
}

gint
pdfpc_window_cell_renderer_highlight_get_slide_id (pdfpcWindowCellRendererHighlight* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_slide_id;
	return result;
}

void
pdfpc_window_cell_renderer_highlight_set_slide_id (pdfpcWindowCellRendererHighlight* self,
                                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = pdfpc_window_cell_renderer_highlight_get_slide_id (self);
	if (old_value != value) {
		self->priv->_slide_id = value;
		g_object_notify_by_pspec ((GObject *) self, pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_ID_PROPERTY]);
	}
}

PangoFontDescription*
pdfpc_window_cell_renderer_highlight_get_font_description (pdfpcWindowCellRendererHighlight* self)
{
	PangoFontDescription* result;
	PangoFontDescription* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_font_description;
	result = _tmp0_;
	return result;
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

void
pdfpc_window_cell_renderer_highlight_set_font_description (pdfpcWindowCellRendererHighlight* self,
                                                           PangoFontDescription* value)
{
	PangoFontDescription* old_value;
	g_return_if_fail (self != NULL);
	old_value = pdfpc_window_cell_renderer_highlight_get_font_description (self);
	if (old_value != value) {
		PangoFontDescription* _tmp0_;
		_tmp0_ = __vala_PangoFontDescription_copy0 (value);
		__vala_PangoFontDescription_free0 (self->priv->_font_description);
		self->priv->_font_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_FONT_DESCRIPTION_PROPERTY]);
	}
}

pdfpcMetadataPdf*
pdfpc_window_cell_renderer_highlight_get_metadata (pdfpcWindowCellRendererHighlight* self)
{
	pdfpcMetadataPdf* result;
	pdfpcMetadataPdf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_metadata;
	result = _tmp0_;
	return result;
}

void
pdfpc_window_cell_renderer_highlight_set_metadata (pdfpcWindowCellRendererHighlight* self,
                                                   pdfpcMetadataPdf* value)
{
	pdfpcMetadataPdf* old_value;
	g_return_if_fail (self != NULL);
	old_value = pdfpc_window_cell_renderer_highlight_get_metadata (self);
	if (old_value != value) {
		pdfpcMetadataPdf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_metadata);
		self->priv->_metadata = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_METADATA_PROPERTY]);
	}
}

gint
pdfpc_window_cell_renderer_highlight_get_slide_width (pdfpcWindowCellRendererHighlight* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_slide_width;
	return result;
}

void
pdfpc_window_cell_renderer_highlight_set_slide_width (pdfpcWindowCellRendererHighlight* self,
                                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = pdfpc_window_cell_renderer_highlight_get_slide_width (self);
	if (old_value != value) {
		self->priv->_slide_width = value;
		g_object_notify_by_pspec ((GObject *) self, pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_WIDTH_PROPERTY]);
	}
}

gint
pdfpc_window_cell_renderer_highlight_get_slide_height (pdfpcWindowCellRendererHighlight* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_slide_height;
	return result;
}

void
pdfpc_window_cell_renderer_highlight_set_slide_height (pdfpcWindowCellRendererHighlight* self,
                                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = pdfpc_window_cell_renderer_highlight_get_slide_height (self);
	if (old_value != value) {
		self->priv->_slide_height = value;
		g_object_notify_by_pspec ((GObject *) self, pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_HEIGHT_PROPERTY]);
	}
}

static void
pdfpc_window_cell_renderer_highlight_class_init (pdfpcWindowCellRendererHighlightClass * klass,
                                                 gpointer klass_data)
{
	pdfpc_window_cell_renderer_highlight_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &pdfpcWindowCellRendererHighlight_private_offset);
	((GtkCellRendererClass *) klass)->get_size = (void (*) (GtkCellRenderer*, GtkWidget*, GdkRectangle*, gint*, gint*, gint*, gint*)) pdfpc_window_cell_renderer_highlight_real_get_size;
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) pdfpc_window_cell_renderer_highlight_real_render;
	G_OBJECT_CLASS (klass)->get_property = _vala_pdfpc_window_cell_renderer_highlight_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pdfpc_window_cell_renderer_highlight_set_property;
	G_OBJECT_CLASS (klass)->finalize = pdfpc_window_cell_renderer_highlight_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_ID_PROPERTY, pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_ID_PROPERTY] = g_param_spec_int ("slide-id", "slide-id", "slide-id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_FONT_DESCRIPTION_PROPERTY, pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_FONT_DESCRIPTION_PROPERTY] = g_param_spec_boxed ("font-description", "font-description", "font-description", pango_font_description_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_METADATA_PROPERTY, pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_METADATA_PROPERTY] = g_param_spec_object ("metadata", "metadata", "metadata", PDFPC_METADATA_TYPE_PDF, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_WIDTH_PROPERTY, pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_WIDTH_PROPERTY] = g_param_spec_int ("slide-width", "slide-width", "slide-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_HEIGHT_PROPERTY, pdfpc_window_cell_renderer_highlight_properties[PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_HEIGHT_PROPERTY] = g_param_spec_int ("slide-height", "slide-height", "slide-height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
pdfpc_window_cell_renderer_highlight_instance_init (pdfpcWindowCellRendererHighlight * self,
                                                    gpointer klass)
{
	self->priv = pdfpc_window_cell_renderer_highlight_get_instance_private (self);
}

static void
pdfpc_window_cell_renderer_highlight_finalize (GObject * obj)
{
	pdfpcWindowCellRendererHighlight * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PDFPC_WINDOW_TYPE_CELL_RENDERER_HIGHLIGHT, pdfpcWindowCellRendererHighlight);
	__vala_PangoFontDescription_free0 (self->priv->_font_description);
	_g_object_unref0 (self->priv->_metadata);
	G_OBJECT_CLASS (pdfpc_window_cell_renderer_highlight_parent_class)->finalize (obj);
}

static GType
pdfpc_window_cell_renderer_highlight_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (pdfpcWindowCellRendererHighlightClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_window_cell_renderer_highlight_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcWindowCellRendererHighlight), 0, (GInstanceInitFunc) pdfpc_window_cell_renderer_highlight_instance_init, NULL };
	GType pdfpc_window_cell_renderer_highlight_type_id;
	pdfpc_window_cell_renderer_highlight_type_id = g_type_register_static (gtk_cell_renderer_get_type (), "pdfpcWindowCellRendererHighlight", &g_define_type_info, 0);
	pdfpcWindowCellRendererHighlight_private_offset = g_type_add_instance_private (pdfpc_window_cell_renderer_highlight_type_id, sizeof (pdfpcWindowCellRendererHighlightPrivate));
	return pdfpc_window_cell_renderer_highlight_type_id;
}

GType
pdfpc_window_cell_renderer_highlight_get_type (void)
{
	static volatile gsize pdfpc_window_cell_renderer_highlight_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_window_cell_renderer_highlight_type_id__once)) {
		GType pdfpc_window_cell_renderer_highlight_type_id;
		pdfpc_window_cell_renderer_highlight_type_id = pdfpc_window_cell_renderer_highlight_get_type_once ();
		g_once_init_leave (&pdfpc_window_cell_renderer_highlight_type_id__once, pdfpc_window_cell_renderer_highlight_type_id);
	}
	return pdfpc_window_cell_renderer_highlight_type_id__once;
}

static void
_vala_pdfpc_window_cell_renderer_highlight_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	pdfpcWindowCellRendererHighlight * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PDFPC_WINDOW_TYPE_CELL_RENDERER_HIGHLIGHT, pdfpcWindowCellRendererHighlight);
	switch (property_id) {
		case PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_ID_PROPERTY:
		g_value_set_int (value, pdfpc_window_cell_renderer_highlight_get_slide_id (self));
		break;
		case PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_FONT_DESCRIPTION_PROPERTY:
		g_value_set_boxed (value, pdfpc_window_cell_renderer_highlight_get_font_description (self));
		break;
		case PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_METADATA_PROPERTY:
		g_value_set_object (value, pdfpc_window_cell_renderer_highlight_get_metadata (self));
		break;
		case PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_WIDTH_PROPERTY:
		g_value_set_int (value, pdfpc_window_cell_renderer_highlight_get_slide_width (self));
		break;
		case PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_HEIGHT_PROPERTY:
		g_value_set_int (value, pdfpc_window_cell_renderer_highlight_get_slide_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pdfpc_window_cell_renderer_highlight_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	pdfpcWindowCellRendererHighlight * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PDFPC_WINDOW_TYPE_CELL_RENDERER_HIGHLIGHT, pdfpcWindowCellRendererHighlight);
	switch (property_id) {
		case PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_ID_PROPERTY:
		pdfpc_window_cell_renderer_highlight_set_slide_id (self, g_value_get_int (value));
		break;
		case PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_FONT_DESCRIPTION_PROPERTY:
		pdfpc_window_cell_renderer_highlight_set_font_description (self, g_value_get_boxed (value));
		break;
		case PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_METADATA_PROPERTY:
		pdfpc_window_cell_renderer_highlight_set_metadata (self, g_value_get_object (value));
		break;
		case PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_WIDTH_PROPERTY:
		pdfpc_window_cell_renderer_highlight_set_slide_width (self, g_value_get_int (value));
		break;
		case PDFPC_WINDOW_CELL_RENDERER_HIGHLIGHT_SLIDE_HEIGHT_PROPERTY:
		pdfpc_window_cell_renderer_highlight_set_slide_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

