/* Settings.c generated by valac 0.56.17, the Vala compiler
 * generated from Settings.vala, do not modify */

/**/
/*  Copyright (C) 2014 Rico Tzschichholz*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_SETTINGS_0_PROPERTY,
	PLANK_SETTINGS_SETTINGS_PROPERTY,
	PLANK_SETTINGS_BIND_FLAGS_PROPERTY,
	PLANK_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* plank_settings_properties[PLANK_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

struct _PlankSettingsPrivate {
	GSettings* _settings;
	GSettingsBindFlags _bind_flags;
};

static gint PlankSettings_private_offset;
static gpointer plank_settings_parent_class = NULL;

static void plank_settings_real_verify (PlankSettings* self,
                                 const gchar* name);
static GObject * plank_settings_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void plank_settings_finalize (GObject * obj);
static GType plank_settings_get_type_once (void);
static void _vala_plank_settings_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_plank_settings_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
plank_settings_get_instance_private (PlankSettings* self)
{
	return G_STRUCT_MEMBER_P (self, PlankSettings_private_offset);
}

/**
 * {@inheritDoc}
 */
PlankSettings*
plank_settings_construct (GType object_type,
                          const gchar* schema)
{
	PlankSettings * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (schema != NULL, NULL);
	_tmp0_ = g_settings_new (schema);
	_tmp1_ = _tmp0_;
	self = (PlankSettings*) g_object_new (object_type, "settings", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

/**
 * {@inheritDoc}
 */
PlankSettings*
plank_settings_construct_with_path (GType object_type,
                                    const gchar* schema,
                                    const gchar* path)
{
	PlankSettings * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_val_if_fail (schema != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_settings_new_with_path (schema, path);
	_tmp1_ = _tmp0_;
	self = (PlankSettings*) g_object_new (object_type, "settings", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

/**
 * Verify the property given by its name and change the property if necessary.
 *
 * @param name the name of the property
 */
static void
plank_settings_real_verify (PlankSettings* self,
                            const gchar* name)
{
	g_return_if_fail (name != NULL);
}

void
plank_settings_verify (PlankSettings* self,
                       const gchar* name)
{
	PlankSettingsClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_SETTINGS_GET_CLASS (self);
	if (_klass_->verify) {
		_klass_->verify (self, name);
	}
}

/**
 * Resets all properties to their default values.
 */
void
plank_settings_reset_all (PlankSettings* self)
{
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp2_ = _tmp1_ = g_settings_list_keys (_tmp0_);
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp2_;
		key_collection_length1 = _vala_array_length (_tmp1_);
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			const gchar* key = NULL;
			key = key_collection[key_it];
			{
				GSettings* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = self->priv->_settings;
				_tmp4_ = key;
				g_settings_reset (_tmp3_, _tmp4_);
			}
		}
		key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

/**
 * Delays saving changes until apply() is called.
 */
void
plank_settings_delay (PlankSettings* self)
{
	GSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	g_object_get (_tmp0_, "delay-apply", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	plank_logger_verbose ("Settings.delay()", NULL);
	_tmp3_ = self->priv->_settings;
	g_settings_delay (_tmp3_);
}

/**
 * If any settings were changed, apply them now.
 */
void
plank_settings_apply (PlankSettings* self)
{
	GSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GSettings* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_settings;
	g_object_get (_tmp0_, "delay-apply", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	plank_logger_verbose ("Settings.apply()", NULL);
	_tmp3_ = self->priv->_settings;
	g_settings_apply (_tmp3_);
}

GSettings*
plank_settings_get_settings (PlankSettings* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plank_settings_set_settings (PlankSettings* self,
                             GSettings* value)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
}

GSettingsBindFlags
plank_settings_get_bind_flags (PlankSettings* self)
{
	GSettingsBindFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_bind_flags;
	return result;
}

static void
plank_settings_set_bind_flags (PlankSettings* self,
                               GSettingsBindFlags value)
{
	g_return_if_fail (self != NULL);
	self->priv->_bind_flags = value;
}

static gpointer
_g_param_spec_ref0 (gpointer self)
{
	return self ? g_param_spec_ref (self) : NULL;
}

static GObject *
plank_settings_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankSettings * self;
	const gchar* class_type_name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GParamSpec** properties = NULL;
	GObjectClass* _tmp6_;
	guint _tmp7_ = 0;
	GParamSpec** _tmp8_;
	gint properties_length1;
	gint _properties_size_;
	GSettings* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	parent_class = G_OBJECT_CLASS (plank_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_SETTINGS, PlankSettings);
	_tmp0_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self));
	class_type_name = _tmp0_;
	_tmp1_ = class_type_name;
	_tmp2_ = self->priv->_settings;
	g_object_get (_tmp2_, "path", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	g_debug ("Settings.vala:53: Bind '%s' to '%s'", _tmp1_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp8_ = g_object_class_list_properties (_tmp6_, &_tmp7_);
	properties = _tmp8_;
	properties_length1 = _tmp7_;
	_properties_size_ = properties_length1;
	_tmp9_ = self->priv->_settings;
	_tmp11_ = _tmp10_ = g_settings_list_keys (_tmp9_);
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp11_;
		key_collection_length1 = _vala_array_length (_tmp10_);
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			const gchar* key = NULL;
			key = key_collection[key_it];
			{
				GParamSpec* property = NULL;
				GParamSpec** _tmp12_;
				gint _tmp12__length1;
				GParamSpec* _tmp18_;
				const gchar* name = NULL;
				GParamSpec* _tmp19_;
				const gchar* _tmp20_;
				const gchar* nick = NULL;
				GParamSpec* _tmp21_;
				const gchar* _tmp22_;
				GType type = 0UL;
				GParamSpec* _tmp23_;
				GSettings* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_ = FALSE;
				gboolean _tmp33_ = FALSE;
				const gchar* _tmp40_;
				property = NULL;
				_tmp12_ = properties;
				_tmp12__length1 = properties_length1;
				{
					GParamSpec** p_collection = NULL;
					gint p_collection_length1 = 0;
					gint _p_collection_size_ = 0;
					gint p_it = 0;
					p_collection = _tmp12_;
					p_collection_length1 = _tmp12__length1;
					for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
						GParamSpec* p = NULL;
						p = p_collection[p_it];
						{
							GParamSpec* _tmp13_;
							const gchar* _tmp14_;
							const gchar* _tmp15_;
							_tmp13_ = p;
							_tmp14_ = g_param_spec_get_nick (_tmp13_);
							_tmp15_ = key;
							if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
								GParamSpec* _tmp16_;
								GParamSpec* _tmp17_;
								_tmp16_ = p;
								_tmp17_ = _g_param_spec_ref0 (_tmp16_);
								_g_param_spec_unref0 (property);
								property = _tmp17_;
								break;
							}
						}
					}
				}
				_tmp18_ = property;
				if (_tmp18_ == NULL) {
					_g_param_spec_unref0 (property);
					continue;
				}
				_tmp19_ = property;
				_tmp20_ = g_param_spec_get_name (_tmp19_);
				name = _tmp20_;
				_tmp21_ = property;
				_tmp22_ = g_param_spec_get_nick (_tmp21_);
				nick = _tmp22_;
				_tmp23_ = property;
				type = _tmp23_->value_type;
				_tmp24_ = self->priv->_settings;
				g_object_get (_tmp24_, "path", &_tmp25_, NULL);
				_tmp26_ = _tmp25_;
				_tmp27_ = _tmp26_;
				_tmp28_ = nick;
				_tmp29_ = class_type_name;
				_tmp30_ = name;
				plank_logger_verbose ("Bind '%s%s' to '%s.%s'", _tmp27_, _tmp28_, _tmp29_, _tmp30_, NULL);
				_g_free0 (_tmp27_);
				if (G_TYPE_IS_FUNDAMENTAL (type)) {
					_tmp33_ = TRUE;
				} else {
					_tmp33_ = G_TYPE_IS_ENUM (type);
				}
				if (_tmp33_) {
					_tmp32_ = TRUE;
				} else {
					_tmp32_ = G_TYPE_IS_FLAGS (type);
				}
				if (_tmp32_) {
					_tmp31_ = TRUE;
				} else {
					_tmp31_ = type == G_TYPE_STRV;
				}
				if (_tmp31_) {
					GSettings* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					GSettingsBindFlags _tmp37_;
					_tmp34_ = self->priv->_settings;
					_tmp35_ = nick;
					_tmp36_ = name;
					_tmp37_ = self->priv->_bind_flags;
					g_settings_bind (_tmp34_, _tmp35_, (GObject*) self, _tmp36_, _tmp37_);
				} else {
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					_tmp38_ = name;
					_tmp39_ = g_type_name (type);
					g_warning ("Settings.vala:77: Binding of '%s' from type '%s' not supported yet!", _tmp38_, _tmp39_);
				}
				_tmp40_ = name;
				plank_settings_verify (self, _tmp40_);
				_g_param_spec_unref0 (property);
			}
		}
		key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	properties = (g_free (properties), NULL);
	return obj;
}

static void
plank_settings_class_init (PlankSettingsClass * klass,
                           gpointer klass_data)
{
	plank_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankSettings_private_offset);
	((PlankSettingsClass *) klass)->verify = (void (*) (PlankSettings*, const gchar*)) plank_settings_real_verify;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_settings_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_SETTINGS_SETTINGS_PROPERTY, plank_settings_properties[PLANK_SETTINGS_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_SETTINGS_BIND_FLAGS_PROPERTY, plank_settings_properties[PLANK_SETTINGS_BIND_FLAGS_PROPERTY] = g_param_spec_flags ("bind-flags", "bind-flags", "bind-flags", g_settings_bind_flags_get_type (), G_SETTINGS_BIND_DEFAULT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
}

static void
plank_settings_instance_init (PlankSettings * self,
                              gpointer klass)
{
	self->priv = plank_settings_get_instance_private (self);
	self->priv->_bind_flags = G_SETTINGS_BIND_DEFAULT;
}

static void
plank_settings_finalize (GObject * obj)
{
	PlankSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_SETTINGS, PlankSettings);
	_g_object_unref0 (self->priv->_settings);
	G_OBJECT_CLASS (plank_settings_parent_class)->finalize (obj);
}

/**
 * The base class for gsettings-based configuration classes. Defined properties will be bound
 * to the corresponing schema-key of the given schema-path. The property's nick-name must match
 * the schema-key.
 */
static GType
plank_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankSettings), 0, (GInstanceInitFunc) plank_settings_instance_init, NULL };
	GType plank_settings_type_id;
	plank_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankSettings", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PlankSettings_private_offset = g_type_add_instance_private (plank_settings_type_id, sizeof (PlankSettingsPrivate));
	return plank_settings_type_id;
}

GType
plank_settings_get_type (void)
{
	static volatile gsize plank_settings_type_id__once = 0;
	if (g_once_init_enter (&plank_settings_type_id__once)) {
		GType plank_settings_type_id;
		plank_settings_type_id = plank_settings_get_type_once ();
		g_once_init_leave (&plank_settings_type_id__once, plank_settings_type_id);
	}
	return plank_settings_type_id__once;
}

static void
_vala_plank_settings_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	PlankSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_SETTINGS, PlankSettings);
	switch (property_id) {
		case PLANK_SETTINGS_SETTINGS_PROPERTY:
		g_value_set_object (value, plank_settings_get_settings (self));
		break;
		case PLANK_SETTINGS_BIND_FLAGS_PROPERTY:
		g_value_set_flags (value, plank_settings_get_bind_flags (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_settings_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	PlankSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_SETTINGS, PlankSettings);
	switch (property_id) {
		case PLANK_SETTINGS_SETTINGS_PROPERTY:
		plank_settings_set_settings (self, g_value_get_object (value));
		break;
		case PLANK_SETTINGS_BIND_FLAGS_PROPERTY:
		plank_settings_set_bind_flags (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

