/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2026 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtNetwork.h"

#line 135 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qpycore_std_pair.sip"
#include <utility>
#line 29 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkstdpair0100QHostAddress1800.cpp"

#line 26 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtNetwork/qhostaddress.sip"
#include <qhostaddress.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkstdpair0100QHostAddress1800.cpp"


extern "C" {static void assign_std_pair_0100QHostAddress_1800(void *, Py_ssize_t, void *);}
static void assign_std_pair_0100QHostAddress_1800(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<std::pair< ::QHostAddress, int> *>(sipDst)[sipDstIdx] = *reinterpret_cast<std::pair< ::QHostAddress, int> *>(sipSrc);
}


extern "C" {static void *array_std_pair_0100QHostAddress_1800(Py_ssize_t);}
static void *array_std_pair_0100QHostAddress_1800(Py_ssize_t sipNrElem)
{
    return new std::pair< ::QHostAddress, int>[sipNrElem];
}


extern "C" {static void *copy_std_pair_0100QHostAddress_1800(const void *, Py_ssize_t);}
static void *copy_std_pair_0100QHostAddress_1800(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new std::pair< ::QHostAddress, int>(reinterpret_cast<const std::pair< ::QHostAddress, int> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_std_pair_0100QHostAddress_1800(void *, int, void *);}
static void release_std_pair_0100QHostAddress_1800(void *sipCppV, int, void *)
{
    std::pair< ::QHostAddress, int> *sipCpp = reinterpret_cast<std::pair< ::QHostAddress, int> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_std_pair_0100QHostAddress_1800(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_std_pair_0100QHostAddress_1800(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
    std::pair< ::QHostAddress, int> **sipCppPtr = reinterpret_cast<std::pair< ::QHostAddress, int> **>(sipCppPtrV);

#line 154 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qpycore_std_pair.sip"
    if (!sipIsErr)
        return (PySequence_Check(sipPy) && !PyUnicode_Check(sipPy));

    Py_ssize_t len = PySequence_Size(sipPy);

    if (len != 2)
    {
        // A negative length should only be an internal error so let the
        // original exception stand.
        if (len >= 0)
            PyErr_Format(PyExc_TypeError,
                    "sequence has %zd elements but 2 elements are expected",
                    len);

        *sipIsErr = 1;

        return 0;
    }

    PyObject *firstobj = PySequence_GetItem(sipPy, 0);

    if (!firstobj)
    {
        *sipIsErr = 1;

        return 0;
    }

    int firststate;
    QHostAddress *first = reinterpret_cast<QHostAddress *>(
            sipForceConvertToType(firstobj, sipType_QHostAddress, sipTransferObj,
                    SIP_NOT_NONE, &firststate, sipIsErr));
 
    if (*sipIsErr)
    {
        PyErr_Format(PyExc_TypeError,
                "the first element has type '%s' but 'QHostAddress' is expected",
                sipPyTypeName(Py_TYPE(firstobj)));

        return 0;
    }

    PyObject *secondobj = PySequence_GetItem(sipPy, 1);

    if (!secondobj)
    {
        sipReleaseType(first, sipType_QHostAddress, firststate);
        Py_DECREF(firstobj);
        *sipIsErr = 1;

        return 0;
    }

    int second = sipLong_AsInt(secondobj);

    if (PyErr_Occurred())
    {
        if (PyErr_ExceptionMatches(PyExc_TypeError))
            PyErr_Format(PyExc_TypeError,
                    "the second element has type '%s' but 'int' is expected",
                    sipPyTypeName(Py_TYPE(secondobj)));

        Py_DECREF(secondobj);
        sipReleaseType(first, sipType_QHostAddress, firststate);
        Py_DECREF(firstobj);
        *sipIsErr = 1;

        return 0;
    }

    *sipCppPtr = new std::pair<QHostAddress, int>(*first, second);

    Py_DECREF(secondobj);
    sipReleaseType(first, sipType_QHostAddress, firststate);
    Py_DECREF(firstobj);
 
    return sipGetState(sipTransferObj);
#line 150 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkstdpair0100QHostAddress1800.cpp"
}


extern "C" {static PyObject *convertFrom_std_pair_0100QHostAddress_1800(void *, PyObject *);}
static PyObject *convertFrom_std_pair_0100QHostAddress_1800(void *sipCppV, PyObject *sipTransferObj)
{
    std::pair< ::QHostAddress, int> *sipCpp = reinterpret_cast<std::pair< ::QHostAddress, int> *>(sipCppV);

#line 139 "/build/pyqt6/src/pyqt6-6.10.2/sip/QtCore/qpycore_std_pair.sip"
    QHostAddress *first = new QHostAddress(sipCpp->first);
    PyObject *t = sipBuildResult(NULL, "(Ni)", first, sipType_QHostAddress,
            sipTransferObj, sipCpp->second);

    if (!t)
    {
        delete first;

        return 0;
    }

    return t;
#line 172 "/build/pyqt6/src/pyqt6-6.10.2/build/QtNetwork/sipQtNetworkstdpair0100QHostAddress1800.cpp"
}


sipMappedTypeDef sipTypeDef_QtNetwork_std_pair_0100QHostAddress_1800 = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_4680,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_std_pair_0100QHostAddress_1800,
    array_std_pair_0100QHostAddress_1800,
    copy_std_pair_0100QHostAddress_1800,
    release_std_pair_0100QHostAddress_1800,
    convertTo_std_pair_0100QHostAddress_1800,
    convertFrom_std_pair_0100QHostAddress_1800
};
