// ----------------------------------------------------------------------------
//
//  Copyright (C) 2005-2021 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __NFFILT_H
#define __NFFILT_H


#include <string.h>

// -------------------------------------------------------
//
//  Near field compensation filters for degrees 1..8.
//  
//  nc = number of channels.
//  w = c / (r * F), with
//  
//    c = speed of sound (343 m/s)
//    r = distance (m)
//    F = sample rate (Hz)
//
// -------------------------------------------------------


class NFfiltbase
{
public:

    NFfiltbase (int degree, int nchan);
    virtual ~NFfiltbase (void);
    virtual void reset (void) { memset (_z, 0, _nchan * _degree * sizeof (float)); } 
    virtual void init (float w) = 0;
    virtual void process (int nfram, float *inp [], float *out [], float gain = 1.0f) = 0;

protected:

    void init1 (int i, float a);
    void init2 (int i, float a, float b);

    int    _degree;
    int    _nchan;
    float  _g;  // Gain factor.
    float *_d;  // Filter coefficients.
    float *_z;  // Filter state.
};

    
class NFfilt1: public NFfiltbase  
{
public:

    NFfilt1 (int nchan);
    virtual void init (float w);
    virtual void process (int nsam, float *inp [], float *out [], float gain = 1.0f);
};


class NFfilt2: public NFfiltbase  
{
public:

    NFfilt2 (int nchan);
    virtual void init (float w);
    virtual void process (int nsam, float *inp [], float *out [], float gain = 1.0f);
};


class NFfilt3: public NFfiltbase  
{
public:

    NFfilt3 (int nchan);
    virtual void init (float w);
    virtual void process (int nsam, float *inp [], float *out [], float gain = 1.0f);
};


class NFfilt4: public NFfiltbase  
{
public:

    NFfilt4 (int nchan);
    virtual void init (float w);
    virtual void process (int nsam, float *inp [], float *out [], float gain = 1.0f);
};


class NFfilt5: public NFfiltbase  
{
public:

    NFfilt5 (int nchan);
    virtual void init (float w);
    virtual void process (int nsam, float *inp [], float *out [], float gain = 1.0f);
};


class NFfilt6: public NFfiltbase  
{
public:

    NFfilt6 (int nchan);
    virtual void init (float w);
    virtual void process (int nsam, float *inp [], float *out [], float gain = 1.0f);
};


class NFfilt7: public NFfiltbase  
{
public:

    NFfilt7 (int nchan);
    virtual void init (float w);
    virtual void process (int nsam, float *inp [], float *out [], float gain = 1.0f);
};


class NFfilt8: public NFfiltbase  
{
public:

    NFfilt8 (int nchan);
    virtual void init (float w);
    virtual void process (int nsam, float *inp [], float *out [], float gain = 1.0f);
};


#endif
