/* desktop-file-service.c generated by valac 0.56.17, the Vala compiler
 * generated from desktop-file-service.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *             Alberto Aldegheri <albyrock87+dev@gmail.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include "synapse-core.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <gee.h>
#include <locale.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_TYPE_DESKTOP_FILE_ERROR (synapse_desktop_file_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SYNAPSE_DESKTOP_FILE_INFO_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY,
	SYNAPSE_DESKTOP_FILE_INFO_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_0_PROPERTY,
	SYNAPSE_DESKTOP_FILE_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_desktop_file_service_properties[SYNAPSE_DESKTOP_FILE_SERVICE_NUM_PROPERTIES];
#define _synapse_utils_async_once_unref0(var) ((var == NULL) ? NULL : (var = (synapse_utils_async_once_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceInitializeData SynapseDesktopFileServiceInitializeData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceProcessDirectoryData SynapseDesktopFileServiceProcessDirectoryData;
typedef struct _SynapseDesktopFileServiceLoadAllDesktopFilesData SynapseDesktopFileServiceLoadAllDesktopFilesData;
typedef struct _SynapseDesktopFileServiceReloadDesktopFilesData SynapseDesktopFileServiceReloadDesktopFilesData;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _SynapseDesktopFileServiceLoadDesktopFileData SynapseDesktopFileServiceLoadDesktopFileData;
typedef struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData SynapseDesktopFileServiceLoadMimeParentsFromFileData;
enum  {
	SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL,
	SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL,
	SYNAPSE_DESKTOP_FILE_SERVICE_NUM_SIGNALS
};
static guint synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_NUM_SIGNALS] = {0};

typedef enum  {
	SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY
} SynapseDesktopFileError;
#define SYNAPSE_DESKTOP_FILE_ERROR synapse_desktop_file_error_quark ()

struct _SynapseDesktopFileInfoPrivate {
	gchar* _desktop_id;
	gchar* _name;
	gchar* _comment;
	gchar* _icon_name;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _exec;
	gboolean _is_hidden;
	gboolean _is_valid;
	gchar* name_folded;
	SynapseDesktopEnvironmentType _show_in;
};

struct _SynapseDesktopFileServicePrivate {
	SynapseUtilsAsyncOnce* init_once;
	GeeList* directory_monitors;
	GeeList* all_desktop_files;
	GeeList* non_hidden_desktop_files;
	GeeMap* mimetype_map;
	GeeMap* exec_map;
	GeeMap* desktop_id_map;
	GeeMultiMap* mimetype_parent_map;
	SynapseDesktopEnvironmentType session_type;
	const gchar* session_type_str;
	guint timer_id;
};

struct _SynapseDesktopFileServiceInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	SynapseUtilsAsyncOnce* _tmp0_;
	gboolean is_locked;
	SynapseUtilsAsyncOnce* _tmp1_;
	const gchar* _tmp2_;
	SynapseUtilsAsyncOnce* _tmp3_;
};

struct _SynapseDesktopFileServiceProcessDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	GFile* directory;
	gchar* id_prefix;
	GeeSet* monitored_dirs;
	gchar* path;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean exists;
	GeeIterator* _scanned_dir_it;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	GFile* scanned_dir;
	GeeIterator* _tmp10_;
	gpointer _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp17_;
	GList* files;
	GFileEnumerator* _tmp18_;
	GList* _tmp19_;
	GList* _tmp20_;
	GList* f_collection;
	GList* f_it;
	GFileInfo* _tmp21_;
	GFileInfo* f;
	const gchar* name;
	GFileInfo* _tmp22_;
	const gchar* _tmp23_;
	GFileInfo* _tmp24_;
	GFile* subdir;
	const gchar* _tmp25_;
	GFile* _tmp26_;
	gchar* new_prefix;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GFile* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	GFile* _tmp37_;
	GFile* _tmp38_;
	GError* err;
	GError* _tmp39_;
	const gchar* _tmp40_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFileServiceLoadAllDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	gchar** data_dirs;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GeeSet* desktop_file_dirs;
	GeeHashSet* _tmp5_;
	GeeMultiMap* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** data_dir_collection;
	gint data_dir_collection_length1;
	gint _data_dir_collection_size_;
	gint data_dir_it;
	const gchar* data_dir;
	gchar* dir_path;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* directory;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GeeSet* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeIterator* _d_it;
	GeeSet* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _tmp20_;
	GFile* d;
	GeeIterator* _tmp21_;
	gpointer _tmp22_;
	GFileMonitor* monitor;
	GFile* _tmp23_;
	GFileMonitor* _tmp24_;
	GFileMonitor* _tmp25_;
	GeeList* _tmp26_;
	GFileMonitor* _tmp27_;
	GError* err;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFileServiceReloadDesktopFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
};

struct _SynapseDesktopFileServiceLoadDesktopFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	GFile* file;
	gchar* id_prefix;
	guint8* file_contents;
	gint file_contents_length1;
	gint _file_contents_size_;
	gboolean success;
	guint8* _tmp0_;
	gsize _tmp1_;
	gboolean _tmp2_;
	GKeyFile* keyfile;
	GKeyFile* _tmp3_;
	GKeyFile* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gchar* desktop_id;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	SynapseDesktopFileInfo* dfi;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GKeyFile* _tmp13_;
	const gchar* _tmp14_;
	SynapseDesktopFileInfo* _tmp15_;
	SynapseDesktopFileInfo* _tmp16_;
	SynapseDesktopFileInfo* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GeeList* _tmp20_;
	SynapseDesktopFileInfo* _tmp21_;
	gboolean _tmp22_;
	SynapseDesktopFileInfo* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	SynapseDesktopFileInfo* _tmp26_;
	SynapseDesktopEnvironmentType _tmp27_;
	SynapseDesktopEnvironmentType _tmp28_;
	GeeList* _tmp29_;
	SynapseDesktopFileInfo* _tmp30_;
	GError* err;
	GError* _tmp31_;
	const gchar* _tmp32_;
	GError* _inner_error0_;
};

struct _SynapseDesktopFileServiceLoadMimeParentsFromFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseDesktopFileService* self;
	gchar* fi;
	GFile* file;
	GFile* _tmp0_;
	gboolean exists;
	GFile* _tmp1_;
	GFileInputStream* fis;
	GFile* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* dis;
	GFileInputStream* _tmp4_;
	GDataInputStream* _tmp5_;
	gchar* line;
	gchar** mimes;
	gint mimes_length1;
	gint _mimes_size_;
	gint len;
	gchar* _tmp6_;
	GDataInputStream* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	GeeMultiMap* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	GError* _inner_error0_;
};

static gint SynapseDesktopFileInfo_private_offset;
static gpointer synapse_desktop_file_info_parent_class = NULL;
static gint SynapseDesktopFileService_private_offset;
static gpointer synapse_desktop_file_service_parent_class = NULL;
static SynapseDesktopFileService* synapse_desktop_file_service_instance;
static SynapseDesktopFileService* synapse_desktop_file_service_instance = NULL;

VALA_EXTERN GQuark synapse_desktop_file_error_quark (void);
VALA_EXTERN GType synapse_desktop_file_error_get_type (void) G_GNUC_CONST ;
static void synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self,
                                                  GKeyFile* keyfile);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self,
                                              gboolean value);
static void synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self,
                                             gboolean value);
static void synapse_desktop_file_info_finalize (GObject * obj);
static GType synapse_desktop_file_info_get_type_once (void);
static void _vala_synapse_desktop_file_info_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_desktop_file_info_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static SynapseDesktopFileService* synapse_desktop_file_service_new (void);
static SynapseDesktopFileService* synapse_desktop_file_service_construct (GType object_type);
static void synapse_desktop_file_service_initialize_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* _data_);
static void synapse_desktop_file_service_initialize_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self);
static gboolean _synapse_desktop_file_service_initialize_co_gsource_func (gpointer self);
static void synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self,
                                                                 GAsyncResult* _res_);
static gchar* synapse_desktop_file_service_get_cache_file_name (SynapseDesktopFileService* self,
                                                         const gchar* dir_name);
static void synapse_desktop_file_service_process_directory_data_free (gpointer _data);
static void synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self,
                                                     GFile* directory,
                                                     const gchar* id_prefix,
                                                     GeeSet* monitored_dirs,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_);
static gboolean synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* _data_);
static void synapse_desktop_file_service_process_directory_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self,
                                                     GFile* file,
                                                     const gchar* id_prefix,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self,
                                                               const gchar* fi,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self,
                                                                      GAsyncResult* _res_);
static void synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self);
static void _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                          GFile* file,
                                                                                          GFile* other_file,
                                                                                          GFileMonitorEvent event_type,
                                                                                          gpointer self);
static gboolean __lambda8_ (SynapseDesktopFileService* self);
static void synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self,
                                                               GAsyncResult* _res_);
static gboolean ___lambda8__gsource_func (gpointer self);
static void synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* _data_);
static void synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* _data_);
static void synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data);
static gboolean synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_);
static void synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self,
                                                    const gchar* mime,
                                                    GeeSet* ret);
static GObject * synapse_desktop_file_service_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void synapse_desktop_file_service_finalize (GObject * obj);
static GType synapse_desktop_file_service_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

GQuark
synapse_desktop_file_error_quark (void)
{
#line 239 "data-sink.vala"
	return g_quark_from_static_string ("synapse-desktop-file-error-quark");
#line 499 "desktop-file-service.c"
}

static GType
synapse_desktop_file_error_get_type_once (void)
{
	static const GEnumValue values[] = {{SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY", "uninteresting-entry"}, {0, NULL, NULL}};
	GType synapse_desktop_file_error_type_id;
	synapse_desktop_file_error_type_id = g_enum_register_static ("SynapseDesktopFileError", values);
	return synapse_desktop_file_error_type_id;
}

GType
synapse_desktop_file_error_get_type (void)
{
	static volatile gsize synapse_desktop_file_error_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_error_type_id__once)) {
		GType synapse_desktop_file_error_type_id;
		synapse_desktop_file_error_type_id = synapse_desktop_file_error_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_error_type_id__once, synapse_desktop_file_error_type_id);
	}
	return synapse_desktop_file_error_type_id__once;
}

SynapseDesktopEnvironmentType
synapse_desktop_environment_type_from_strings (gchar** environments,
                                               gint environments_length1)
{
	SynapseDesktopEnvironmentType _result_ = 0U;
	SynapseDesktopEnvironmentType result;
#line 51 "desktop-file-service.vala"
	_result_ = 0;
#line 531 "desktop-file-service.c"
	{
		gchar** env_collection = NULL;
		gint env_collection_length1 = 0;
		gint _env_collection_size_ = 0;
		gint env_it = 0;
#line 52 "desktop-file-service.vala"
		env_collection = environments;
#line 52 "desktop-file-service.vala"
		env_collection_length1 = environments_length1;
#line 52 "desktop-file-service.vala"
		for (env_it = 0; env_it < env_collection_length1; env_it = env_it + 1) {
#line 543 "desktop-file-service.c"
			const gchar* env = NULL;
#line 52 "desktop-file-service.vala"
			env = env_collection[env_it];
#line 547 "desktop-file-service.c"
			{
				gchar* env_up = NULL;
				const gchar* _tmp0_;
				gchar* _tmp1_;
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label0 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label1 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label2 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label3 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label4 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label5 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label6 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label7 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label8 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label9 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label10 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label11 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label12 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label13 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label14 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label15 = 0;
#line 55 "desktop-file-service.vala"
				static GQuark _tmp4_label16 = 0;
#line 54 "desktop-file-service.vala"
				_tmp0_ = env;
#line 54 "desktop-file-service.vala"
				_tmp1_ = g_utf8_strup (_tmp0_, (gssize) -1);
#line 54 "desktop-file-service.vala"
				env_up = _tmp1_;
#line 55 "desktop-file-service.vala"
				_tmp2_ = env_up;
#line 55 "desktop-file-service.vala"
				_tmp3_ = _tmp2_;
#line 55 "desktop-file-service.vala"
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
#line 55 "desktop-file-service.vala"
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("GNOME")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 605 "desktop-file-service.c"
						default:
						{
#line 57 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 57 "desktop-file-service.vala"
							break;
#line 612 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("GNOME-FLASHBACK")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 618 "desktop-file-service.c"
						default:
						{
#line 58 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 58 "desktop-file-service.vala"
							break;
#line 625 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("GNOME-XORG")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 631 "desktop-file-service.c"
						default:
						{
#line 59 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 59 "desktop-file-service.vala"
							break;
#line 638 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("UBUNTU")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 644 "desktop-file-service.c"
						default:
						{
#line 60 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 60 "desktop-file-service.vala"
							break;
#line 651 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("UBUNTU-XORG")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 657 "desktop-file-service.c"
						default:
						{
#line 61 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 61 "desktop-file-service.vala"
							break;
#line 664 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label5) ? _tmp4_label5 : (_tmp4_label5 = g_quark_from_static_string ("KDE")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 670 "desktop-file-service.c"
						default:
						{
#line 62 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_KDE;
#line 62 "desktop-file-service.vala"
							break;
#line 677 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label6) ? _tmp4_label6 : (_tmp4_label6 = g_quark_from_static_string ("LXDE")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 683 "desktop-file-service.c"
						default:
						{
#line 63 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_LXDE;
#line 63 "desktop-file-service.vala"
							break;
#line 690 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label7) ? _tmp4_label7 : (_tmp4_label7 = g_quark_from_static_string ("MATE")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 696 "desktop-file-service.c"
						default:
						{
#line 64 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_MATE;
#line 64 "desktop-file-service.vala"
							break;
#line 703 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label8) ? _tmp4_label8 : (_tmp4_label8 = g_quark_from_static_string ("RAZOR")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 709 "desktop-file-service.c"
						default:
						{
#line 65 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_RAZOR;
#line 65 "desktop-file-service.vala"
							break;
#line 716 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label9) ? _tmp4_label9 : (_tmp4_label9 = g_quark_from_static_string ("ROX")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 722 "desktop-file-service.c"
						default:
						{
#line 66 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ROX;
#line 66 "desktop-file-service.vala"
							break;
#line 729 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label10) ? _tmp4_label10 : (_tmp4_label10 = g_quark_from_static_string ("TDE")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 735 "desktop-file-service.c"
						default:
						{
#line 67 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_TDE;
#line 67 "desktop-file-service.vala"
							break;
#line 742 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label11) ? _tmp4_label11 : (_tmp4_label11 = g_quark_from_static_string ("UNITY")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 748 "desktop-file-service.c"
						default:
						{
#line 68 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_UNITY;
#line 68 "desktop-file-service.vala"
							break;
#line 755 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label12) ? _tmp4_label12 : (_tmp4_label12 = g_quark_from_static_string ("XFCE")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 761 "desktop-file-service.c"
						default:
						{
#line 69 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_XFCE;
#line 69 "desktop-file-service.vala"
							break;
#line 768 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label13) ? _tmp4_label13 : (_tmp4_label13 = g_quark_from_static_string ("EDE")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 774 "desktop-file-service.c"
						default:
						{
#line 70 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_EDE;
#line 70 "desktop-file-service.vala"
							break;
#line 781 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label14) ? _tmp4_label14 : (_tmp4_label14 = g_quark_from_static_string ("CINNAMON")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 787 "desktop-file-service.c"
						default:
						{
#line 71 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_CINNAMON;
#line 71 "desktop-file-service.vala"
							break;
#line 794 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label15) ? _tmp4_label15 : (_tmp4_label15 = g_quark_from_static_string ("OLD")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 800 "desktop-file-service.c"
						default:
						{
#line 72 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_OLD;
#line 72 "desktop-file-service.vala"
							break;
#line 807 "desktop-file-service.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label16) ? _tmp4_label16 : (_tmp4_label16 = g_quark_from_static_string ("PANTHEON")))) {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 813 "desktop-file-service.c"
						default:
						{
#line 74 "desktop-file-service.vala"
							_result_ |= SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_PANTHEON;
#line 74 "desktop-file-service.vala"
							break;
#line 820 "desktop-file-service.c"
						}
					}
				} else {
#line 55 "desktop-file-service.vala"
					switch (0) {
#line 826 "desktop-file-service.c"
						default:
						{
							const gchar* _tmp6_;
#line 76 "desktop-file-service.vala"
							_tmp6_ = env;
#line 76 "desktop-file-service.vala"
							g_warning ("desktop-file-service.vala:76: %s is not understood", _tmp6_);
#line 76 "desktop-file-service.vala"
							break;
#line 836 "desktop-file-service.c"
						}
					}
				}
#line 52 "desktop-file-service.vala"
				_g_free0 (env_up);
#line 842 "desktop-file-service.c"
			}
		}
	}
#line 79 "desktop-file-service.vala"
	result = _result_;
#line 79 "desktop-file-service.vala"
	return result;
#line 850 "desktop-file-service.c"
}

static GType
synapse_desktop_environment_type_get_type_once (void)
{
	static const GFlagsValue values[] = {{SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME", "gnome"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_KDE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_KDE", "kde"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_LXDE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_LXDE", "lxde"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_MATE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_MATE", "mate"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_RAZOR, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_RAZOR", "razor"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ROX, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ROX", "rox"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_TDE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_TDE", "tde"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_UNITY, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_UNITY", "unity"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_XFCE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_XFCE", "xfce"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_EDE, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_EDE", "ede"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_CINNAMON, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_CINNAMON", "cinnamon"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_PANTHEON, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_PANTHEON", "pantheon"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_OLD, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_OLD", "old"}, {SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL, "SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL", "all"}, {0, NULL, NULL}};
	GType synapse_desktop_environment_type_type_id;
	synapse_desktop_environment_type_type_id = g_flags_register_static ("SynapseDesktopEnvironmentType", values);
	return synapse_desktop_environment_type_type_id;
}

GType
synapse_desktop_environment_type_get_type (void)
{
	static volatile gsize synapse_desktop_environment_type_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_environment_type_type_id__once)) {
		GType synapse_desktop_environment_type_type_id;
		synapse_desktop_environment_type_type_id = synapse_desktop_environment_type_get_type_once ();
		g_once_init_leave (&synapse_desktop_environment_type_type_id__once, synapse_desktop_environment_type_type_id);
	}
	return synapse_desktop_environment_type_type_id__once;
}

static inline gpointer
synapse_desktop_file_info_get_instance_private (SynapseDesktopFileInfo* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFileInfo_private_offset);
}

const gchar*
synapse_desktop_file_info_get_name_folded (SynapseDesktopFileInfo* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	const gchar* result;
#line 102 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 104 "desktop-file-service.vala"
	_tmp0_ = self->priv->name_folded;
#line 104 "desktop-file-service.vala"
	if (_tmp0_ == NULL) {
#line 892 "desktop-file-service.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 104 "desktop-file-service.vala"
		_tmp1_ = self->priv->_name;
#line 104 "desktop-file-service.vala"
		_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
#line 104 "desktop-file-service.vala"
		_g_free0 (self->priv->name_folded);
#line 104 "desktop-file-service.vala"
		self->priv->name_folded = _tmp2_;
#line 903 "desktop-file-service.c"
	}
#line 105 "desktop-file-service.vala"
	_tmp3_ = self->priv->name_folded;
#line 105 "desktop-file-service.vala"
	result = _tmp3_;
#line 105 "desktop-file-service.vala"
	return result;
#line 911 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_construct_for_keyfile (GType object_type,
                                                 const gchar* path,
                                                 GKeyFile* keyfile,
                                                 const gchar* desktop_id)
{
	SynapseDesktopFileInfo * self = NULL;
#line 110 "desktop-file-service.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 110 "desktop-file-service.vala"
	g_return_val_if_fail (keyfile != NULL, NULL);
#line 110 "desktop-file-service.vala"
	g_return_val_if_fail (desktop_id != NULL, NULL);
#line 113 "desktop-file-service.vala"
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, "filename", path, "desktop-id", desktop_id, NULL);
#line 115 "desktop-file-service.vala"
	synapse_desktop_file_info_init_from_keyfile (self, keyfile);
#line 110 "desktop-file-service.vala"
	return self;
#line 933 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_new_for_keyfile (const gchar* path,
                                           GKeyFile* keyfile,
                                           const gchar* desktop_id)
{
#line 110 "desktop-file-service.vala"
	return synapse_desktop_file_info_construct_for_keyfile (SYNAPSE_TYPE_DESKTOP_FILE_INFO, path, keyfile, desktop_id);
#line 943 "desktop-file-service.c"
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
#line 130 "desktop-file-service.vala"
	for (i = 0; i < stack_length; i++) {
#line 130 "desktop-file-service.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 130 "desktop-file-service.vala"
			return TRUE;
#line 958 "desktop-file-service.c"
		}
	}
#line 130 "desktop-file-service.vala"
	return FALSE;
#line 963 "desktop-file-service.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 165 "desktop-file-service.vala"
	return self ? g_object_ref (self) : NULL;
#line 971 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_init_from_keyfile (SynapseDesktopFileInfo* self,
                                             GKeyFile* keyfile)
{
	GError* _inner_error0_ = NULL;
#line 118 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 118 "desktop-file-service.vala"
	g_return_if_fail (keyfile != NULL);
#line 983 "desktop-file-service.c"
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gboolean _tmp3_ = FALSE;
		GDesktopAppInfo* app_info = NULL;
		GDesktopAppInfo* _tmp8_;
		GDesktopAppInfo* _tmp9_;
		GDesktopAppInfo* _tmp15_;
		const gchar* _tmp16_;
		GDesktopAppInfo* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
		const gchar* _tmp31_ = NULL;
		GDesktopAppInfo* _tmp32_;
		const gchar* _tmp33_;
		GIcon* _tmp34_ = NULL;
		GDesktopAppInfo* _tmp35_;
		GIcon* _tmp36_;
		GIcon* _tmp37_;
		GIcon* icon = NULL;
		GIcon* _tmp39_;
		GIcon* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp50_ = FALSE;
		gboolean _tmp58_ = FALSE;
		gboolean _tmp63_ = FALSE;
		const gchar* _tmp64_;
#line 122 "desktop-file-service.vala"
		_tmp1_ = g_key_file_get_string (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TYPE, &_inner_error0_);
#line 122 "desktop-file-service.vala"
		_tmp0_ = _tmp1_;
#line 122 "desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1024 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 122 "desktop-file-service.vala"
		if (g_strcmp0 (_tmp0_, G_KEY_FILE_DESKTOP_TYPE_APPLICATION) != 0) {
#line 1029 "desktop-file-service.c"
			GError* _tmp2_;
#line 124 "desktop-file-service.vala"
			_tmp2_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Not Application-type desktop entry");
#line 124 "desktop-file-service.vala"
			_inner_error0_ = _tmp2_;
#line 124 "desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1037 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 127 "desktop-file-service.vala"
		_tmp3_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_CATEGORIES, &_inner_error0_);
#line 127 "desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 127 "desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1046 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 127 "desktop-file-service.vala"
		if (_tmp3_) {
#line 1051 "desktop-file-service.c"
			gchar** categories = NULL;
			gsize _tmp4_ = 0;
			gchar** _tmp5_;
			gint categories_length1;
			gint _categories_size_;
			gchar** _tmp6_;
			gint _tmp6__length1;
#line 129 "desktop-file-service.vala"
			_tmp5_ = g_key_file_get_string_list (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_CATEGORIES, &_tmp4_, &_inner_error0_);
#line 129 "desktop-file-service.vala"
			categories = _tmp5_;
#line 129 "desktop-file-service.vala"
			categories_length1 = _tmp4_;
#line 129 "desktop-file-service.vala"
			_categories_size_ = categories_length1;
#line 129 "desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 129 "desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1071 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 130 "desktop-file-service.vala"
			_tmp6_ = categories;
#line 130 "desktop-file-service.vala"
			_tmp6__length1 = categories_length1;
#line 130 "desktop-file-service.vala"
			if (_vala_string_array_contains (_tmp6_, _tmp6__length1, "Screensaver")) {
#line 1080 "desktop-file-service.c"
				GError* _tmp7_;
#line 132 "desktop-file-service.vala"
				_tmp7_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, "Screensaver desktop entry");
#line 132 "desktop-file-service.vala"
				_inner_error0_ = _tmp7_;
#line 132 "desktop-file-service.vala"
				categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
#line 132 "desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1090 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 127 "desktop-file-service.vala"
			categories = (_vala_array_free (categories, categories_length1, (GDestroyNotify) g_free), NULL);
#line 1095 "desktop-file-service.c"
		}
#line 137 "desktop-file-service.vala"
		_tmp8_ = g_desktop_app_info_new_from_keyfile (keyfile);
#line 137 "desktop-file-service.vala"
		_g_object_unref0 (app_info);
#line 137 "desktop-file-service.vala"
		app_info = _tmp8_;
#line 139 "desktop-file-service.vala"
		_tmp9_ = app_info;
#line 139 "desktop-file-service.vala"
		if (_tmp9_ == NULL) {
#line 1107 "desktop-file-service.c"
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GError* _tmp13_;
			GError* _tmp14_;
#line 141 "desktop-file-service.vala"
			_tmp10_ = self->priv->_filename;
#line 141 "desktop-file-service.vala"
			_tmp11_ = g_strdup_printf ("Unable to create AppInfo for %s", _tmp10_);
#line 141 "desktop-file-service.vala"
			_tmp12_ = _tmp11_;
#line 141 "desktop-file-service.vala"
			_tmp13_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, _tmp12_);
#line 141 "desktop-file-service.vala"
			_tmp14_ = _tmp13_;
#line 141 "desktop-file-service.vala"
			_g_free0 (_tmp12_);
#line 141 "desktop-file-service.vala"
			_inner_error0_ = _tmp14_;
#line 141 "desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 141 "desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1131 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 144 "desktop-file-service.vala"
		_tmp15_ = app_info;
#line 144 "desktop-file-service.vala"
		_tmp16_ = g_app_info_get_name ((GAppInfo*) _tmp15_);
#line 144 "desktop-file-service.vala"
		synapse_desktop_file_info_set_name (self, _tmp16_);
#line 145 "desktop-file-service.vala"
		_tmp17_ = app_info;
#line 145 "desktop-file-service.vala"
		_tmp18_ = g_app_info_get_commandline ((GAppInfo*) _tmp17_);
#line 145 "desktop-file-service.vala"
		synapse_desktop_file_info_set_exec (self, _tmp18_);
#line 146 "desktop-file-service.vala"
		_tmp19_ = self->priv->_exec;
#line 146 "desktop-file-service.vala"
		if (_tmp19_ == NULL) {
#line 1150 "desktop-file-service.c"
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GError* _tmp23_;
			GError* _tmp24_;
#line 148 "desktop-file-service.vala"
			_tmp20_ = self->priv->_name;
#line 148 "desktop-file-service.vala"
			_tmp21_ = g_strdup_printf ("Unable to get exec for %s", _tmp20_);
#line 148 "desktop-file-service.vala"
			_tmp22_ = _tmp21_;
#line 148 "desktop-file-service.vala"
			_tmp23_ = g_error_new_literal (SYNAPSE_DESKTOP_FILE_ERROR, SYNAPSE_DESKTOP_FILE_ERROR_UNINTERESTING_ENTRY, _tmp22_);
#line 148 "desktop-file-service.vala"
			_tmp24_ = _tmp23_;
#line 148 "desktop-file-service.vala"
			_g_free0 (_tmp22_);
#line 148 "desktop-file-service.vala"
			_inner_error0_ = _tmp24_;
#line 148 "desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 148 "desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1174 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 152 "desktop-file-service.vala"
		_tmp26_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_HIDDEN, &_inner_error0_);
#line 152 "desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 152 "desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 152 "desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1185 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 152 "desktop-file-service.vala"
		if (_tmp26_) {
#line 1190 "desktop-file-service.c"
			gboolean _tmp27_ = FALSE;
#line 153 "desktop-file-service.vala"
			_tmp27_ = g_key_file_get_boolean (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_HIDDEN, &_inner_error0_);
#line 153 "desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 153 "desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 153 "desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1200 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 153 "desktop-file-service.vala"
			_tmp25_ = _tmp27_;
#line 1205 "desktop-file-service.c"
		} else {
#line 152 "desktop-file-service.vala"
			_tmp25_ = FALSE;
#line 1209 "desktop-file-service.c"
		}
#line 152 "desktop-file-service.vala"
		if (_tmp25_) {
#line 155 "desktop-file-service.vala"
			synapse_desktop_file_info_set_is_hidden (self, TRUE);
#line 1215 "desktop-file-service.c"
		}
#line 157 "desktop-file-service.vala"
		_tmp29_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NO_DISPLAY, &_inner_error0_);
#line 157 "desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 157 "desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 157 "desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1225 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 157 "desktop-file-service.vala"
		if (_tmp29_) {
#line 1230 "desktop-file-service.c"
			gboolean _tmp30_ = FALSE;
#line 158 "desktop-file-service.vala"
			_tmp30_ = g_key_file_get_boolean (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NO_DISPLAY, &_inner_error0_);
#line 158 "desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 158 "desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 158 "desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1240 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 158 "desktop-file-service.vala"
			_tmp28_ = _tmp30_;
#line 1245 "desktop-file-service.c"
		} else {
#line 157 "desktop-file-service.vala"
			_tmp28_ = FALSE;
#line 1249 "desktop-file-service.c"
		}
#line 157 "desktop-file-service.vala"
		if (_tmp28_) {
#line 160 "desktop-file-service.vala"
			synapse_desktop_file_info_set_is_hidden (self, TRUE);
#line 1255 "desktop-file-service.c"
		}
#line 163 "desktop-file-service.vala"
		_tmp32_ = app_info;
#line 163 "desktop-file-service.vala"
		_tmp33_ = g_app_info_get_description ((GAppInfo*) _tmp32_);
#line 163 "desktop-file-service.vala"
		_tmp31_ = _tmp33_;
#line 163 "desktop-file-service.vala"
		if (_tmp31_ == NULL) {
#line 163 "desktop-file-service.vala"
			_tmp31_ = "";
#line 1267 "desktop-file-service.c"
		}
#line 163 "desktop-file-service.vala"
		synapse_desktop_file_info_set_comment (self, _tmp31_);
#line 165 "desktop-file-service.vala"
		_tmp35_ = app_info;
#line 165 "desktop-file-service.vala"
		_tmp36_ = g_app_info_get_icon ((GAppInfo*) _tmp35_);
#line 165 "desktop-file-service.vala"
		_tmp37_ = _g_object_ref0 (_tmp36_);
#line 165 "desktop-file-service.vala"
		_tmp34_ = _tmp37_;
#line 165 "desktop-file-service.vala"
		if (_tmp34_ == NULL) {
#line 1281 "desktop-file-service.c"
			GThemedIcon* _tmp38_;
#line 165 "desktop-file-service.vala"
			_tmp38_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
#line 165 "desktop-file-service.vala"
			_g_object_unref0 (_tmp34_);
#line 165 "desktop-file-service.vala"
			_tmp34_ = (GIcon*) _tmp38_;
#line 1289 "desktop-file-service.c"
		}
#line 165 "desktop-file-service.vala"
		_tmp39_ = _tmp34_;
#line 165 "desktop-file-service.vala"
		_tmp34_ = NULL;
#line 165 "desktop-file-service.vala"
		icon = _tmp39_;
#line 166 "desktop-file-service.vala"
		_tmp40_ = icon;
#line 166 "desktop-file-service.vala"
		_tmp41_ = g_icon_to_string (_tmp40_);
#line 166 "desktop-file-service.vala"
		_tmp42_ = _tmp41_;
#line 166 "desktop-file-service.vala"
		synapse_desktop_file_info_set_icon_name (self, _tmp42_);
#line 166 "desktop-file-service.vala"
		_g_free0 (_tmp42_);
#line 168 "desktop-file-service.vala"
		_tmp43_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_MIME_TYPE, &_inner_error0_);
#line 168 "desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 168 "desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 168 "desktop-file-service.vala"
			_g_object_unref0 (_tmp34_);
#line 168 "desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 168 "desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1319 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 168 "desktop-file-service.vala"
		if (_tmp43_) {
#line 1324 "desktop-file-service.c"
			gchar** _tmp44_ = NULL;
			gsize _tmp45_ = 0;
			gchar** _tmp46_;
			gint _tmp44__length1;
			gint __tmp44__size_;
			gchar** _tmp47_;
			gint _tmp47__length1;
#line 170 "desktop-file-service.vala"
			_tmp46_ = g_key_file_get_string_list (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_MIME_TYPE, &_tmp45_, &_inner_error0_);
#line 170 "desktop-file-service.vala"
			_tmp44_ = _tmp46_;
#line 170 "desktop-file-service.vala"
			_tmp44__length1 = _tmp45_;
#line 170 "desktop-file-service.vala"
			__tmp44__size_ = _tmp44__length1;
#line 170 "desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 170 "desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 170 "desktop-file-service.vala"
				_g_object_unref0 (_tmp34_);
#line 170 "desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 170 "desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1350 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 170 "desktop-file-service.vala"
			_tmp47_ = _tmp44_;
#line 170 "desktop-file-service.vala"
			_tmp47__length1 = _tmp44__length1;
#line 170 "desktop-file-service.vala"
			_tmp44_ = NULL;
#line 170 "desktop-file-service.vala"
			_tmp44__length1 = 0;
#line 170 "desktop-file-service.vala"
			self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
#line 170 "desktop-file-service.vala"
			self->mime_types = _tmp47_;
#line 170 "desktop-file-service.vala"
			self->mime_types_length1 = _tmp47__length1;
#line 168 "desktop-file-service.vala"
			_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
#line 1369 "desktop-file-service.c"
		}
#line 172 "desktop-file-service.vala"
		_tmp48_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TERMINAL, &_inner_error0_);
#line 172 "desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 172 "desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 172 "desktop-file-service.vala"
			_g_object_unref0 (_tmp34_);
#line 172 "desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 172 "desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1383 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 172 "desktop-file-service.vala"
		if (_tmp48_) {
#line 1388 "desktop-file-service.c"
			gboolean _tmp49_ = FALSE;
#line 174 "desktop-file-service.vala"
			_tmp49_ = g_key_file_get_boolean (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TERMINAL, &_inner_error0_);
#line 174 "desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 174 "desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 174 "desktop-file-service.vala"
				_g_object_unref0 (_tmp34_);
#line 174 "desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 174 "desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1402 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 174 "desktop-file-service.vala"
			synapse_desktop_file_info_set_needs_terminal (self, _tmp49_);
#line 1407 "desktop-file-service.c"
		}
#line 176 "desktop-file-service.vala"
		_tmp50_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN, &_inner_error0_);
#line 176 "desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 176 "desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 176 "desktop-file-service.vala"
			_g_object_unref0 (_tmp34_);
#line 176 "desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 176 "desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1421 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 176 "desktop-file-service.vala"
		if (_tmp50_) {
#line 1426 "desktop-file-service.c"
			gchar** _tmp51_ = NULL;
			gsize _tmp52_ = 0;
			gchar** _tmp53_;
			gint _tmp51__length1;
			gint __tmp51__size_;
#line 178 "desktop-file-service.vala"
			_tmp53_ = g_key_file_get_string_list (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN, &_tmp52_, &_inner_error0_);
#line 178 "desktop-file-service.vala"
			_tmp51_ = _tmp53_;
#line 178 "desktop-file-service.vala"
			_tmp51__length1 = _tmp52_;
#line 178 "desktop-file-service.vala"
			__tmp51__size_ = _tmp51__length1;
#line 178 "desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 178 "desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 178 "desktop-file-service.vala"
				_g_object_unref0 (_tmp34_);
#line 178 "desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 178 "desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1450 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 178 "desktop-file-service.vala"
			synapse_desktop_file_info_set_show_in (self, synapse_desktop_environment_type_from_strings (_tmp51_, (gint) _tmp51__length1));
#line 176 "desktop-file-service.vala"
			_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
#line 1457 "desktop-file-service.c"
		} else {
			gboolean _tmp54_ = FALSE;
#line 181 "desktop-file-service.vala"
			_tmp54_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN, &_inner_error0_);
#line 181 "desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 181 "desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 181 "desktop-file-service.vala"
				_g_object_unref0 (_tmp34_);
#line 181 "desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 181 "desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1472 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 181 "desktop-file-service.vala"
			if (_tmp54_) {
#line 1477 "desktop-file-service.c"
				gchar** _tmp55_ = NULL;
				gsize _tmp56_ = 0;
				gchar** _tmp57_;
				gint _tmp55__length1;
				gint __tmp55__size_;
				SynapseDesktopEnvironmentType not_show = 0U;
#line 183 "desktop-file-service.vala"
				_tmp57_ = g_key_file_get_string_list (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN, &_tmp56_, &_inner_error0_);
#line 183 "desktop-file-service.vala"
				_tmp55_ = _tmp57_;
#line 183 "desktop-file-service.vala"
				_tmp55__length1 = _tmp56_;
#line 183 "desktop-file-service.vala"
				__tmp55__size_ = _tmp55__length1;
#line 183 "desktop-file-service.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 183 "desktop-file-service.vala"
					_g_object_unref0 (icon);
#line 183 "desktop-file-service.vala"
					_g_object_unref0 (_tmp34_);
#line 183 "desktop-file-service.vala"
					_g_object_unref0 (app_info);
#line 183 "desktop-file-service.vala"
					_g_free0 (_tmp0_);
#line 1502 "desktop-file-service.c"
					goto __catch0_g_error;
				}
#line 183 "desktop-file-service.vala"
				not_show = synapse_desktop_environment_type_from_strings (_tmp55_, (gint) _tmp55__length1);
#line 185 "desktop-file-service.vala"
				synapse_desktop_file_info_set_show_in (self, SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL ^ not_show);
#line 181 "desktop-file-service.vala"
				_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
#line 1511 "desktop-file-service.c"
			}
		}
#line 187 "desktop-file-service.vala"
		_tmp58_ = g_key_file_has_key (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ACTIONS, &_inner_error0_);
#line 187 "desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 187 "desktop-file-service.vala"
			_g_object_unref0 (icon);
#line 187 "desktop-file-service.vala"
			_g_object_unref0 (_tmp34_);
#line 187 "desktop-file-service.vala"
			_g_object_unref0 (app_info);
#line 187 "desktop-file-service.vala"
			_g_free0 (_tmp0_);
#line 1526 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 187 "desktop-file-service.vala"
		if (_tmp58_) {
#line 1531 "desktop-file-service.c"
			gchar** _tmp59_ = NULL;
			gsize _tmp60_ = 0;
			gchar** _tmp61_;
			gint _tmp59__length1;
			gint __tmp59__size_;
			gchar** _tmp62_;
			gint _tmp62__length1;
#line 188 "desktop-file-service.vala"
			_tmp61_ = g_key_file_get_string_list (keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ACTIONS, &_tmp60_, &_inner_error0_);
#line 188 "desktop-file-service.vala"
			_tmp59_ = _tmp61_;
#line 188 "desktop-file-service.vala"
			_tmp59__length1 = _tmp60_;
#line 188 "desktop-file-service.vala"
			__tmp59__size_ = _tmp59__length1;
#line 188 "desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 188 "desktop-file-service.vala"
				_g_object_unref0 (icon);
#line 188 "desktop-file-service.vala"
				_g_object_unref0 (_tmp34_);
#line 188 "desktop-file-service.vala"
				_g_object_unref0 (app_info);
#line 188 "desktop-file-service.vala"
				_g_free0 (_tmp0_);
#line 1557 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 188 "desktop-file-service.vala"
			_tmp62_ = _tmp59_;
#line 188 "desktop-file-service.vala"
			_tmp62__length1 = _tmp59__length1;
#line 188 "desktop-file-service.vala"
			_tmp59_ = NULL;
#line 188 "desktop-file-service.vala"
			_tmp59__length1 = 0;
#line 188 "desktop-file-service.vala"
			self->actions = (_vala_array_free (self->actions, self->actions_length1, (GDestroyNotify) g_free), NULL);
#line 188 "desktop-file-service.vala"
			self->actions = _tmp62_;
#line 188 "desktop-file-service.vala"
			self->actions_length1 = _tmp62__length1;
#line 187 "desktop-file-service.vala"
			_tmp59_ = (_vala_array_free (_tmp59_, _tmp59__length1, (GDestroyNotify) g_free), NULL);
#line 1576 "desktop-file-service.c"
		}
#line 192 "desktop-file-service.vala"
		_tmp64_ = self->priv->_filename;
#line 192 "desktop-file-service.vala"
		if (g_str_has_suffix (_tmp64_, "gconf-editor.desktop")) {
#line 192 "desktop-file-service.vala"
			_tmp63_ = TRUE;
#line 1584 "desktop-file-service.c"
		} else {
			const gchar* _tmp65_;
#line 193 "desktop-file-service.vala"
			_tmp65_ = self->priv->_filename;
#line 193 "desktop-file-service.vala"
			_tmp63_ = g_str_has_suffix (_tmp65_, "dconf-editor.desktop");
#line 1591 "desktop-file-service.c"
		}
#line 192 "desktop-file-service.vala"
		if (_tmp63_) {
#line 195 "desktop-file-service.vala"
			synapse_desktop_file_info_set_is_hidden (self, FALSE);
#line 1597 "desktop-file-service.c"
		}
#line 120 "desktop-file-service.vala"
		_g_object_unref0 (icon);
#line 120 "desktop-file-service.vala"
		_g_object_unref0 (_tmp34_);
#line 120 "desktop-file-service.vala"
		_g_object_unref0 (app_info);
#line 120 "desktop-file-service.vala"
		_g_free0 (_tmp0_);
#line 1607 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp66_;
		const gchar* _tmp67_;
#line 120 "desktop-file-service.vala"
		err = _inner_error0_;
#line 120 "desktop-file-service.vala"
		_inner_error0_ = NULL;
#line 200 "desktop-file-service.vala"
		_tmp66_ = err;
#line 200 "desktop-file-service.vala"
		_tmp67_ = _tmp66_->message;
#line 200 "desktop-file-service.vala"
		g_warning ("desktop-file-service.vala:200: %s", _tmp67_);
#line 201 "desktop-file-service.vala"
		synapse_desktop_file_info_set_is_valid (self, FALSE);
#line 120 "desktop-file-service.vala"
		_g_error_free0 (err);
#line 1629 "desktop-file-service.c"
	}
	__finally0:
#line 120 "desktop-file-service.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 120 "desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 120 "desktop-file-service.vala"
		g_clear_error (&_inner_error0_);
#line 120 "desktop-file-service.vala"
		return;
#line 1640 "desktop-file-service.c"
	}
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_construct (GType object_type)
{
	SynapseDesktopFileInfo * self = NULL;
#line 83 "desktop-file-service.vala"
	self = (SynapseDesktopFileInfo*) g_object_new (object_type, NULL);
#line 83 "desktop-file-service.vala"
	return self;
#line 1652 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_info_new (void)
{
#line 83 "desktop-file-service.vala"
	return synapse_desktop_file_info_construct (SYNAPSE_TYPE_DESKTOP_FILE_INFO);
#line 1660 "desktop-file-service.c"
}

const gchar*
synapse_desktop_file_info_get_desktop_id (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 85 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "desktop-file-service.vala"
	_tmp0_ = self->priv->_desktop_id;
#line 85 "desktop-file-service.vala"
	result = _tmp0_;
#line 85 "desktop-file-service.vala"
	return result;
#line 1676 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_desktop_id (SynapseDesktopFileInfo* self,
                                          const gchar* value)
{
	gchar* old_value;
#line 85 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 85 "desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_desktop_id (self);
#line 85 "desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1690 "desktop-file-service.c"
		gchar* _tmp0_;
#line 85 "desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 85 "desktop-file-service.vala"
		_g_free0 (self->priv->_desktop_id);
#line 85 "desktop-file-service.vala"
		self->priv->_desktop_id = _tmp0_;
#line 85 "desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY]);
#line 1700 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 86 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "desktop-file-service.vala"
	_tmp0_ = self->priv->_name;
#line 86 "desktop-file-service.vala"
	result = _tmp0_;
#line 86 "desktop-file-service.vala"
	return result;
#line 1717 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_name (SynapseDesktopFileInfo* self,
                                    const gchar* value)
{
	gchar* old_value;
#line 86 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 86 "desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_name (self);
#line 86 "desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1731 "desktop-file-service.c"
		gchar* _tmp0_;
#line 86 "desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 86 "desktop-file-service.vala"
		_g_free0 (self->priv->_name);
#line 86 "desktop-file-service.vala"
		self->priv->_name = _tmp0_;
#line 86 "desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY]);
#line 1741 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_comment (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 87 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "desktop-file-service.vala"
	_tmp0_ = self->priv->_comment;
#line 87 "desktop-file-service.vala"
	result = _tmp0_;
#line 87 "desktop-file-service.vala"
	return result;
#line 1758 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_comment (SynapseDesktopFileInfo* self,
                                       const gchar* value)
{
	gchar* old_value;
#line 87 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 87 "desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_comment (self);
#line 87 "desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1772 "desktop-file-service.c"
		gchar* _tmp0_;
#line 87 "desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 87 "desktop-file-service.vala"
		_g_free0 (self->priv->_comment);
#line 87 "desktop-file-service.vala"
		self->priv->_comment = _tmp0_;
#line 87 "desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY]);
#line 1782 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_icon_name (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 88 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 88 "desktop-file-service.vala"
	_tmp0_ = self->priv->_icon_name;
#line 88 "desktop-file-service.vala"
	result = _tmp0_;
#line 88 "desktop-file-service.vala"
	return result;
#line 1799 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_icon_name (SynapseDesktopFileInfo* self,
                                         const gchar* value)
{
	gchar* old_value;
#line 88 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 88 "desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_icon_name (self);
#line 88 "desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1813 "desktop-file-service.c"
		gchar* _tmp0_;
#line 88 "desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 88 "desktop-file-service.vala"
		_g_free0 (self->priv->_icon_name);
#line 88 "desktop-file-service.vala"
		self->priv->_icon_name = _tmp0_;
#line 88 "desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY]);
#line 1823 "desktop-file-service.c"
	}
}

gboolean
synapse_desktop_file_info_get_needs_terminal (SynapseDesktopFileInfo* self)
{
	gboolean result;
#line 90 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 90 "desktop-file-service.vala"
	result = self->priv->_needs_terminal;
#line 90 "desktop-file-service.vala"
	return result;
#line 1837 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_needs_terminal (SynapseDesktopFileInfo* self,
                                              gboolean value)
{
	gboolean old_value;
#line 90 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 90 "desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_needs_terminal (self);
#line 90 "desktop-file-service.vala"
	if (old_value != value) {
#line 90 "desktop-file-service.vala"
		self->priv->_needs_terminal = value;
#line 90 "desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY]);
#line 1855 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_filename (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 91 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "desktop-file-service.vala"
	_tmp0_ = self->priv->_filename;
#line 91 "desktop-file-service.vala"
	result = _tmp0_;
#line 91 "desktop-file-service.vala"
	return result;
#line 1872 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_filename (SynapseDesktopFileInfo* self,
                                        const gchar* value)
{
	gchar* old_value;
#line 91 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 91 "desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_filename (self);
#line 91 "desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1886 "desktop-file-service.c"
		gchar* _tmp0_;
#line 91 "desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 91 "desktop-file-service.vala"
		_g_free0 (self->priv->_filename);
#line 91 "desktop-file-service.vala"
		self->priv->_filename = _tmp0_;
#line 91 "desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY]);
#line 1896 "desktop-file-service.c"
	}
}

const gchar*
synapse_desktop_file_info_get_exec (SynapseDesktopFileInfo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 93 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "desktop-file-service.vala"
	_tmp0_ = self->priv->_exec;
#line 93 "desktop-file-service.vala"
	result = _tmp0_;
#line 93 "desktop-file-service.vala"
	return result;
#line 1913 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_exec (SynapseDesktopFileInfo* self,
                                    const gchar* value)
{
	gchar* old_value;
#line 93 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 93 "desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_exec (self);
#line 93 "desktop-file-service.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 1927 "desktop-file-service.c"
		gchar* _tmp0_;
#line 93 "desktop-file-service.vala"
		_tmp0_ = g_strdup (value);
#line 93 "desktop-file-service.vala"
		_g_free0 (self->priv->_exec);
#line 93 "desktop-file-service.vala"
		self->priv->_exec = _tmp0_;
#line 93 "desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY]);
#line 1937 "desktop-file-service.c"
	}
}

gboolean
synapse_desktop_file_info_get_is_hidden (SynapseDesktopFileInfo* self)
{
	gboolean result;
#line 95 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 95 "desktop-file-service.vala"
	result = self->priv->_is_hidden;
#line 95 "desktop-file-service.vala"
	return result;
#line 1951 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_set_is_hidden (SynapseDesktopFileInfo* self,
                                         gboolean value)
{
	gboolean old_value;
#line 95 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 95 "desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_is_hidden (self);
#line 95 "desktop-file-service.vala"
	if (old_value != value) {
#line 95 "desktop-file-service.vala"
		self->priv->_is_hidden = value;
#line 95 "desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY]);
#line 1969 "desktop-file-service.c"
	}
}

gboolean
synapse_desktop_file_info_get_is_valid (SynapseDesktopFileInfo* self)
{
	gboolean result;
#line 96 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 96 "desktop-file-service.vala"
	result = self->priv->_is_valid;
#line 96 "desktop-file-service.vala"
	return result;
#line 1983 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_set_is_valid (SynapseDesktopFileInfo* self,
                                        gboolean value)
{
	gboolean old_value;
#line 96 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 96 "desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_is_valid (self);
#line 96 "desktop-file-service.vala"
	if (old_value != value) {
#line 96 "desktop-file-service.vala"
		self->priv->_is_valid = value;
#line 96 "desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY]);
#line 2001 "desktop-file-service.c"
	}
}

SynapseDesktopEnvironmentType
synapse_desktop_file_info_get_show_in (SynapseDesktopFileInfo* self)
{
	SynapseDesktopEnvironmentType result;
#line 108 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 108 "desktop-file-service.vala"
	result = self->priv->_show_in;
#line 108 "desktop-file-service.vala"
	return result;
#line 2015 "desktop-file-service.c"
}

void
synapse_desktop_file_info_set_show_in (SynapseDesktopFileInfo* self,
                                       SynapseDesktopEnvironmentType value)
{
	SynapseDesktopEnvironmentType old_value;
#line 108 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 108 "desktop-file-service.vala"
	old_value = synapse_desktop_file_info_get_show_in (self);
#line 108 "desktop-file-service.vala"
	if (old_value != value) {
#line 108 "desktop-file-service.vala"
		self->priv->_show_in = value;
#line 108 "desktop-file-service.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY]);
#line 2033 "desktop-file-service.c"
	}
}

static void
synapse_desktop_file_info_class_init (SynapseDesktopFileInfoClass * klass,
                                      gpointer klass_data)
{
#line 83 "desktop-file-service.vala"
	synapse_desktop_file_info_parent_class = g_type_class_peek_parent (klass);
#line 83 "desktop-file-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFileInfo_private_offset);
#line 83 "desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_desktop_file_info_get_property;
#line 83 "desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_desktop_file_info_set_property;
#line 83 "desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_info_finalize;
#line 83 "desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 83 "desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 83 "desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY] = g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 83 "desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 83 "desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 83 "desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 83 "desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 83 "desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY] = g_param_spec_boolean ("is-hidden", "is-hidden", "is-hidden", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 83 "desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 83 "desktop-file-service.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY, synapse_desktop_file_info_properties[SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY] = g_param_spec_flags ("show-in", "show-in", "show-in", SYNAPSE_TYPE_DESKTOP_ENVIRONMENT_TYPE, SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2071 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_instance_init (SynapseDesktopFileInfo * self,
                                         gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 83 "desktop-file-service.vala"
	self->priv = synapse_desktop_file_info_get_instance_private (self);
#line 87 "desktop-file-service.vala"
	_tmp0_ = g_strdup ("");
#line 87 "desktop-file-service.vala"
	self->priv->_comment = _tmp0_;
#line 88 "desktop-file-service.vala"
	_tmp1_ = g_strdup ("");
#line 88 "desktop-file-service.vala"
	self->priv->_icon_name = _tmp1_;
#line 90 "desktop-file-service.vala"
	self->priv->_needs_terminal = FALSE;
#line 95 "desktop-file-service.vala"
	self->priv->_is_hidden = FALSE;
#line 96 "desktop-file-service.vala"
	self->priv->_is_valid = TRUE;
#line 98 "desktop-file-service.vala"
	self->actions = NULL;
#line 98 "desktop-file-service.vala"
	self->actions_length1 = 0;
#line 99 "desktop-file-service.vala"
	self->mime_types = NULL;
#line 99 "desktop-file-service.vala"
	self->mime_types_length1 = 0;
#line 101 "desktop-file-service.vala"
	self->priv->name_folded = NULL;
#line 108 "desktop-file-service.vala"
	self->priv->_show_in = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ALL;
#line 2108 "desktop-file-service.c"
}

static void
synapse_desktop_file_info_finalize (GObject * obj)
{
	SynapseDesktopFileInfo * self;
#line 83 "desktop-file-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
#line 85 "desktop-file-service.vala"
	_g_free0 (self->priv->_desktop_id);
#line 86 "desktop-file-service.vala"
	_g_free0 (self->priv->_name);
#line 87 "desktop-file-service.vala"
	_g_free0 (self->priv->_comment);
#line 88 "desktop-file-service.vala"
	_g_free0 (self->priv->_icon_name);
#line 91 "desktop-file-service.vala"
	_g_free0 (self->priv->_filename);
#line 93 "desktop-file-service.vala"
	_g_free0 (self->priv->_exec);
#line 98 "desktop-file-service.vala"
	self->actions = (_vala_array_free (self->actions, self->actions_length1, (GDestroyNotify) g_free), NULL);
#line 99 "desktop-file-service.vala"
	self->mime_types = (_vala_array_free (self->mime_types, self->mime_types_length1, (GDestroyNotify) g_free), NULL);
#line 101 "desktop-file-service.vala"
	_g_free0 (self->priv->name_folded);
#line 83 "desktop-file-service.vala"
	G_OBJECT_CLASS (synapse_desktop_file_info_parent_class)->finalize (obj);
#line 2137 "desktop-file-service.c"
}

static GType
synapse_desktop_file_info_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileInfo), 0, (GInstanceInitFunc) synapse_desktop_file_info_instance_init, NULL };
	GType synapse_desktop_file_info_type_id;
	synapse_desktop_file_info_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileInfo", &g_define_type_info, 0);
	SynapseDesktopFileInfo_private_offset = g_type_add_instance_private (synapse_desktop_file_info_type_id, sizeof (SynapseDesktopFileInfoPrivate));
	return synapse_desktop_file_info_type_id;
}

GType
synapse_desktop_file_info_get_type (void)
{
	static volatile gsize synapse_desktop_file_info_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_info_type_id__once)) {
		GType synapse_desktop_file_info_type_id;
		synapse_desktop_file_info_type_id = synapse_desktop_file_info_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_info_type_id__once, synapse_desktop_file_info_type_id);
	}
	return synapse_desktop_file_info_type_id__once;
}

static void
_vala_synapse_desktop_file_info_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
#line 83 "desktop-file-service.vala"
	switch (property_id) {
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY:
#line 83 "desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_desktop_id (self));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY:
#line 83 "desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_name (self));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY:
#line 83 "desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_comment (self));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY:
#line 83 "desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_icon_name (self));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY:
#line 83 "desktop-file-service.vala"
		g_value_set_boolean (value, synapse_desktop_file_info_get_needs_terminal (self));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY:
#line 83 "desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_filename (self));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY:
#line 83 "desktop-file-service.vala"
		g_value_set_string (value, synapse_desktop_file_info_get_exec (self));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY:
#line 83 "desktop-file-service.vala"
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_hidden (self));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY:
#line 83 "desktop-file-service.vala"
		g_value_set_boolean (value, synapse_desktop_file_info_get_is_valid (self));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY:
#line 83 "desktop-file-service.vala"
		g_value_set_flags (value, synapse_desktop_file_info_get_show_in (self));
#line 83 "desktop-file-service.vala"
		break;
#line 2232 "desktop-file-service.c"
		default:
#line 83 "desktop-file-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 83 "desktop-file-service.vala"
		break;
#line 2238 "desktop-file-service.c"
	}
}

static void
_vala_synapse_desktop_file_info_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseDesktopFileInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_DESKTOP_FILE_INFO, SynapseDesktopFileInfo);
#line 83 "desktop-file-service.vala"
	switch (property_id) {
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_DESKTOP_ID_PROPERTY:
#line 83 "desktop-file-service.vala"
		synapse_desktop_file_info_set_desktop_id (self, g_value_get_string (value));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NAME_PROPERTY:
#line 83 "desktop-file-service.vala"
		synapse_desktop_file_info_set_name (self, g_value_get_string (value));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_COMMENT_PROPERTY:
#line 83 "desktop-file-service.vala"
		synapse_desktop_file_info_set_comment (self, g_value_get_string (value));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_ICON_NAME_PROPERTY:
#line 83 "desktop-file-service.vala"
		synapse_desktop_file_info_set_icon_name (self, g_value_get_string (value));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_NEEDS_TERMINAL_PROPERTY:
#line 83 "desktop-file-service.vala"
		synapse_desktop_file_info_set_needs_terminal (self, g_value_get_boolean (value));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_FILENAME_PROPERTY:
#line 83 "desktop-file-service.vala"
		synapse_desktop_file_info_set_filename (self, g_value_get_string (value));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_EXEC_PROPERTY:
#line 83 "desktop-file-service.vala"
		synapse_desktop_file_info_set_exec (self, g_value_get_string (value));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_HIDDEN_PROPERTY:
#line 83 "desktop-file-service.vala"
		synapse_desktop_file_info_set_is_hidden (self, g_value_get_boolean (value));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_IS_VALID_PROPERTY:
#line 83 "desktop-file-service.vala"
		synapse_desktop_file_info_set_is_valid (self, g_value_get_boolean (value));
#line 83 "desktop-file-service.vala"
		break;
#line 83 "desktop-file-service.vala"
		case SYNAPSE_DESKTOP_FILE_INFO_SHOW_IN_PROPERTY:
#line 83 "desktop-file-service.vala"
		synapse_desktop_file_info_set_show_in (self, g_value_get_flags (value));
#line 83 "desktop-file-service.vala"
		break;
#line 2312 "desktop-file-service.c"
		default:
#line 83 "desktop-file-service.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 83 "desktop-file-service.vala"
		break;
#line 2318 "desktop-file-service.c"
	}
}

static inline gpointer
synapse_desktop_file_service_get_instance_private (SynapseDesktopFileService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseDesktopFileService_private_offset);
}

SynapseDesktopFileService*
synapse_desktop_file_service_get_default (void)
{
	SynapseDesktopFileService* _tmp0_ = NULL;
	SynapseDesktopFileService* _tmp1_;
	SynapseDesktopFileService* _tmp2_;
	SynapseDesktopFileService* _tmp4_;
	SynapseDesktopFileService* result;
#line 214 "desktop-file-service.vala"
	_tmp1_ = synapse_desktop_file_service_instance;
#line 214 "desktop-file-service.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 214 "desktop-file-service.vala"
	_tmp0_ = _tmp2_;
#line 214 "desktop-file-service.vala"
	if (_tmp0_ == NULL) {
#line 2344 "desktop-file-service.c"
		SynapseDesktopFileService* _tmp3_;
#line 214 "desktop-file-service.vala"
		_tmp3_ = synapse_desktop_file_service_new ();
#line 214 "desktop-file-service.vala"
		_g_object_unref0 (_tmp0_);
#line 214 "desktop-file-service.vala"
		_tmp0_ = _tmp3_;
#line 2352 "desktop-file-service.c"
	}
#line 214 "desktop-file-service.vala"
	_tmp4_ = _tmp0_;
#line 214 "desktop-file-service.vala"
	_tmp0_ = NULL;
#line 214 "desktop-file-service.vala"
	result = _tmp4_;
#line 214 "desktop-file-service.vala"
	_g_object_unref0 (_tmp0_);
#line 214 "desktop-file-service.vala"
	return result;
#line 2364 "desktop-file-service.c"
}

static SynapseDesktopFileService*
synapse_desktop_file_service_construct (GType object_type)
{
	SynapseDesktopFileService * self = NULL;
#line 217 "desktop-file-service.vala"
	self = (SynapseDesktopFileService*) g_object_new (object_type, NULL);
#line 217 "desktop-file-service.vala"
	return self;
#line 2375 "desktop-file-service.c"
}

static SynapseDesktopFileService*
synapse_desktop_file_service_new (void)
{
#line 217 "desktop-file-service.vala"
	return synapse_desktop_file_service_construct (SYNAPSE_TYPE_DESKTOP_FILE_SERVICE);
#line 2383 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_initialize_data_free (gpointer _data)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	_data_ = _data;
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceInitializeData, _data_);
#line 2395 "desktop-file-service.c"
}

void
synapse_desktop_file_service_initialize (SynapseDesktopFileService* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
	SynapseDesktopFileService* _tmp0_;
#line 206 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 206 "desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceInitializeData);
#line 206 "desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_initialize_data_free);
#line 206 "desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "desktop-file-service.vala"
	synapse_desktop_file_service_initialize_co (_data_);
#line 2419 "desktop-file-service.c"
}

void
synapse_desktop_file_service_initialize_finish (SynapseDesktopFileService* self,
                                                GAsyncResult* _res_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
#line 206 "desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2429 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_initialize_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	SynapseDesktopFileServiceInitializeData* _data_;
#line 250 "desktop-file-service.vala"
	_data_ = _user_data_;
#line 250 "desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 250 "desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 250 "desktop-file-service.vala"
	synapse_desktop_file_service_initialize_co (_data_);
#line 2446 "desktop-file-service.c"
}

static gboolean
_synapse_desktop_file_service_initialize_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_desktop_file_service_initialize_co (self);
#line 256 "desktop-file-service.vala"
	return result;
#line 2456 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_initialize_co (SynapseDesktopFileServiceInitializeData* _data_)
{
#line 247 "desktop-file-service.vala"
	switch (_data_->_state_) {
#line 247 "desktop-file-service.vala"
		case 0:
#line 2466 "desktop-file-service.c"
		goto _state_0;
#line 247 "desktop-file-service.vala"
		case 1:
#line 2470 "desktop-file-service.c"
		goto _state_1;
#line 247 "desktop-file-service.vala"
		case 2:
#line 2474 "desktop-file-service.c"
		goto _state_2;
#line 247 "desktop-file-service.vala"
		case 3:
#line 2478 "desktop-file-service.c"
		goto _state_3;
		default:
#line 247 "desktop-file-service.vala"
		g_assert_not_reached ();
#line 2483 "desktop-file-service.c"
	}
	_state_0:
#line 249 "desktop-file-service.vala"
	_data_->_tmp0_ = _data_->self->priv->init_once;
#line 249 "desktop-file-service.vala"
	if (synapse_utils_async_once_is_initialized (_data_->_tmp0_)) {
#line 249 "desktop-file-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 249 "desktop-file-service.vala"
		if (_data_->_state_ != 0) {
#line 249 "desktop-file-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 249 "desktop-file-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2498 "desktop-file-service.c"
			}
		}
#line 249 "desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 249 "desktop-file-service.vala"
		return FALSE;
#line 2505 "desktop-file-service.c"
	}
#line 250 "desktop-file-service.vala"
	_data_->_tmp1_ = _data_->self->priv->init_once;
#line 250 "desktop-file-service.vala"
	_data_->_state_ = 1;
#line 250 "desktop-file-service.vala"
	synapse_utils_async_once_enter (_data_->_tmp1_, synapse_desktop_file_service_initialize_ready, _data_);
#line 250 "desktop-file-service.vala"
	return FALSE;
#line 2515 "desktop-file-service.c"
	_state_1:
#line 250 "desktop-file-service.vala"
	_data_->is_locked = synapse_utils_async_once_enter_finish (_data_->_tmp1_, _data_->_res_);
#line 251 "desktop-file-service.vala"
	if (!_data_->is_locked) {
#line 251 "desktop-file-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 251 "desktop-file-service.vala"
		if (_data_->_state_ != 0) {
#line 251 "desktop-file-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 251 "desktop-file-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2529 "desktop-file-service.c"
			}
		}
#line 251 "desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 251 "desktop-file-service.vala"
		return FALSE;
#line 2536 "desktop-file-service.c"
	}
#line 253 "desktop-file-service.vala"
	synapse_desktop_file_service_get_environment_type (_data_->self);
#line 254 "desktop-file-service.vala"
	_data_->_tmp2_ = _data_->self->priv->session_type_str;
#line 254 "desktop-file-service.vala"
	g_desktop_app_info_set_desktop_env (_data_->_tmp2_);
#line 256 "desktop-file-service.vala"
	g_idle_add_full (G_PRIORITY_LOW, _synapse_desktop_file_service_initialize_co_gsource_func, _data_, NULL);
#line 257 "desktop-file-service.vala"
	_data_->_state_ = 2;
#line 257 "desktop-file-service.vala"
	return FALSE;
#line 2550 "desktop-file-service.c"
	_state_2:
	;
#line 259 "desktop-file-service.vala"
	_data_->_state_ = 3;
#line 259 "desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files (_data_->self, synapse_desktop_file_service_initialize_ready, _data_);
#line 259 "desktop-file-service.vala"
	return FALSE;
#line 2559 "desktop-file-service.c"
	_state_3:
#line 259 "desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_finish (_data_->self, _data_->_res_);
#line 261 "desktop-file-service.vala"
	_data_->_tmp3_ = _data_->self->priv->init_once;
#line 261 "desktop-file-service.vala"
	synapse_utils_async_once_leave (_data_->_tmp3_, (gpointer) ((gintptr) TRUE));
#line 247 "desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 247 "desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 247 "desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 247 "desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2575 "desktop-file-service.c"
		}
	}
#line 247 "desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 247 "desktop-file-service.vala"
	return FALSE;
#line 2582 "desktop-file-service.c"
}

SynapseDesktopEnvironmentType
synapse_desktop_file_service_get_environment (SynapseDesktopFileService* self)
{
	SynapseDesktopEnvironmentType result;
#line 267 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 269 "desktop-file-service.vala"
	result = self->priv->session_type;
#line 269 "desktop-file-service.vala"
	return result;
#line 2595 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_get_environment_type (SynapseDesktopFileService* self)
{
	const gchar* session_var = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* session = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
#line 272 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 275 "desktop-file-service.vala"
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 275 "desktop-file-service.vala"
	session_var = _tmp0_;
#line 276 "desktop-file-service.vala"
	_tmp1_ = session_var;
#line 276 "desktop-file-service.vala"
	if (_tmp1_ == NULL) {
#line 2619 "desktop-file-service.c"
		const gchar* _tmp2_;
#line 278 "desktop-file-service.vala"
		_tmp2_ = g_getenv ("DESKTOP_SESSION");
#line 278 "desktop-file-service.vala"
		session_var = _tmp2_;
#line 2625 "desktop-file-service.c"
	}
#line 281 "desktop-file-service.vala"
	_tmp3_ = session_var;
#line 281 "desktop-file-service.vala"
	if (_tmp3_ == NULL) {
#line 281 "desktop-file-service.vala"
		return;
#line 2633 "desktop-file-service.c"
	}
#line 283 "desktop-file-service.vala"
	_tmp4_ = session_var;
#line 283 "desktop-file-service.vala"
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
#line 283 "desktop-file-service.vala"
	session = _tmp5_;
#line 285 "desktop-file-service.vala"
	_tmp6_ = session;
#line 285 "desktop-file-service.vala"
	if (g_str_has_prefix (_tmp6_, "ubuntu")) {
#line 287 "desktop-file-service.vala"
		self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 288 "desktop-file-service.vala"
		self->priv->session_type_str = "Ubuntu";
#line 2649 "desktop-file-service.c"
	} else {
		const gchar* _tmp7_;
#line 290 "desktop-file-service.vala"
		_tmp7_ = session;
#line 290 "desktop-file-service.vala"
		if (g_str_has_prefix (_tmp7_, "unity")) {
#line 292 "desktop-file-service.vala"
			self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_UNITY;
#line 293 "desktop-file-service.vala"
			self->priv->session_type_str = "Unity";
#line 2660 "desktop-file-service.c"
		} else {
			const gchar* _tmp8_;
#line 295 "desktop-file-service.vala"
			_tmp8_ = session;
#line 295 "desktop-file-service.vala"
			if (g_str_has_prefix (_tmp8_, "kde")) {
#line 297 "desktop-file-service.vala"
				self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_KDE;
#line 298 "desktop-file-service.vala"
				self->priv->session_type_str = "KDE";
#line 2671 "desktop-file-service.c"
			} else {
				const gchar* _tmp9_;
#line 300 "desktop-file-service.vala"
				_tmp9_ = session;
#line 300 "desktop-file-service.vala"
				if (g_str_has_prefix (_tmp9_, "gnome")) {
#line 302 "desktop-file-service.vala"
					self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 303 "desktop-file-service.vala"
					self->priv->session_type_str = "GNOME";
#line 2682 "desktop-file-service.c"
				} else {
					const gchar* _tmp10_;
#line 305 "desktop-file-service.vala"
					_tmp10_ = session;
#line 305 "desktop-file-service.vala"
					if (g_str_has_prefix (_tmp10_, "lx")) {
#line 307 "desktop-file-service.vala"
						self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_LXDE;
#line 308 "desktop-file-service.vala"
						self->priv->session_type_str = "LXDE";
#line 2693 "desktop-file-service.c"
					} else {
						const gchar* _tmp11_;
#line 310 "desktop-file-service.vala"
						_tmp11_ = session;
#line 310 "desktop-file-service.vala"
						if (g_str_has_prefix (_tmp11_, "xfce")) {
#line 312 "desktop-file-service.vala"
							self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_XFCE;
#line 313 "desktop-file-service.vala"
							self->priv->session_type_str = "XFCE";
#line 2704 "desktop-file-service.c"
						} else {
							const gchar* _tmp12_;
#line 315 "desktop-file-service.vala"
							_tmp12_ = session;
#line 315 "desktop-file-service.vala"
							if (g_str_has_prefix (_tmp12_, "mate")) {
#line 317 "desktop-file-service.vala"
								self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_MATE;
#line 318 "desktop-file-service.vala"
								self->priv->session_type_str = "MATE";
#line 2715 "desktop-file-service.c"
							} else {
								const gchar* _tmp13_;
#line 320 "desktop-file-service.vala"
								_tmp13_ = session;
#line 320 "desktop-file-service.vala"
								if (g_str_has_prefix (_tmp13_, "razor")) {
#line 322 "desktop-file-service.vala"
									self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_RAZOR;
#line 323 "desktop-file-service.vala"
									self->priv->session_type_str = "Razor";
#line 2726 "desktop-file-service.c"
								} else {
									const gchar* _tmp14_;
#line 325 "desktop-file-service.vala"
									_tmp14_ = session;
#line 325 "desktop-file-service.vala"
									if (g_str_has_prefix (_tmp14_, "tde")) {
#line 327 "desktop-file-service.vala"
										self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_TDE;
#line 328 "desktop-file-service.vala"
										self->priv->session_type_str = "TDE";
#line 2737 "desktop-file-service.c"
									} else {
										const gchar* _tmp15_;
#line 330 "desktop-file-service.vala"
										_tmp15_ = session;
#line 330 "desktop-file-service.vala"
										if (g_str_has_prefix (_tmp15_, "rox")) {
#line 332 "desktop-file-service.vala"
											self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_ROX;
#line 333 "desktop-file-service.vala"
											self->priv->session_type_str = "ROX";
#line 2748 "desktop-file-service.c"
										} else {
											const gchar* _tmp16_;
#line 335 "desktop-file-service.vala"
											_tmp16_ = session;
#line 335 "desktop-file-service.vala"
											if (g_str_has_prefix (_tmp16_, "ede")) {
#line 337 "desktop-file-service.vala"
												self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_EDE;
#line 338 "desktop-file-service.vala"
												self->priv->session_type_str = "EDE";
#line 2759 "desktop-file-service.c"
											} else {
												const gchar* _tmp17_;
#line 340 "desktop-file-service.vala"
												_tmp17_ = session;
#line 340 "desktop-file-service.vala"
												if (g_str_has_prefix (_tmp17_, "cinnamon")) {
#line 342 "desktop-file-service.vala"
													self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_CINNAMON;
#line 343 "desktop-file-service.vala"
													self->priv->session_type_str = "Cinnamon";
#line 2770 "desktop-file-service.c"
												} else {
													const gchar* _tmp18_;
#line 345 "desktop-file-service.vala"
													_tmp18_ = session;
#line 345 "desktop-file-service.vala"
													if (g_str_has_prefix (_tmp18_, "pantheon")) {
#line 347 "desktop-file-service.vala"
														self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_PANTHEON;
#line 348 "desktop-file-service.vala"
														self->priv->session_type_str = "Pantheon";
#line 2781 "desktop-file-service.c"
													} else {
#line 352 "desktop-file-service.vala"
														g_warning ("desktop-file-service.vala:352: Desktop session type is not recognized," \
" assuming GNOME.");
#line 2785 "desktop-file-service.c"
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 272 "desktop-file-service.vala"
	_g_free0 (session);
#line 2801 "desktop-file-service.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 2823 "desktop-file-service.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 2827 "desktop-file-service.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 2833 "desktop-file-service.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 2837 "desktop-file-service.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 2841 "desktop-file-service.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 2849 "desktop-file-service.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2877 "desktop-file-service.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 2886 "desktop-file-service.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2900 "desktop-file-service.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 2909 "desktop-file-service.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 2923 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 2932 "desktop-file-service.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 2941 "desktop-file-service.c"
}

static gchar*
synapse_desktop_file_service_get_cache_file_name (SynapseDesktopFileService* self,
                                                  const gchar* dir_name)
{
	const gchar* locale = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* filename = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
#line 356 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 356 "desktop-file-service.vala"
	g_return_val_if_fail (dir_name != NULL, NULL);
#line 359 "desktop-file-service.vala"
	_tmp0_ = setlocale (LC_MESSAGES, NULL);
#line 359 "desktop-file-service.vala"
	locale = _tmp0_;
#line 360 "desktop-file-service.vala"
	_tmp1_ = locale;
#line 360 "desktop-file-service.vala"
	if (_tmp1_ == NULL) {
#line 360 "desktop-file-service.vala"
		result = NULL;
#line 360 "desktop-file-service.vala"
		return result;
#line 2976 "desktop-file-service.c"
	}
#line 364 "desktop-file-service.vala"
	_tmp2_ = locale;
#line 364 "desktop-file-service.vala"
	_tmp3_ = string_replace (_tmp2_, ".UTF-8", ".utf8");
#line 364 "desktop-file-service.vala"
	_tmp4_ = _tmp3_;
#line 364 "desktop-file-service.vala"
	_tmp5_ = g_strdup_printf ("desktop.%s.cache", _tmp4_);
#line 364 "desktop-file-service.vala"
	_tmp6_ = _tmp5_;
#line 364 "desktop-file-service.vala"
	_g_free0 (_tmp4_);
#line 364 "desktop-file-service.vala"
	filename = _tmp6_;
#line 367 "desktop-file-service.vala"
	_tmp7_ = filename;
#line 367 "desktop-file-service.vala"
	_tmp8_ = g_build_filename (dir_name, _tmp7_, NULL, NULL);
#line 367 "desktop-file-service.vala"
	result = _tmp8_;
#line 367 "desktop-file-service.vala"
	_g_free0 (filename);
#line 367 "desktop-file-service.vala"
	return result;
#line 3002 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory_data_free (gpointer _data)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	_data_ = _data;
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->directory);
#line 206 "desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->monitored_dirs);
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceProcessDirectoryData, _data_);
#line 3020 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory (SynapseDesktopFileService* self,
                                                GFile* directory,
                                                const gchar* id_prefix,
                                                GeeSet* monitored_dirs,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
	SynapseDesktopFileService* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	GeeSet* _tmp3_;
#line 206 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 206 "desktop-file-service.vala"
	g_return_if_fail (directory != NULL);
#line 206 "desktop-file-service.vala"
	g_return_if_fail (id_prefix != NULL);
#line 206 "desktop-file-service.vala"
	g_return_if_fail (monitored_dirs != NULL);
#line 206 "desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceProcessDirectoryData);
#line 206 "desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_process_directory_data_free);
#line 206 "desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "desktop-file-service.vala"
	_tmp1_ = _g_object_ref0 (directory);
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->directory);
#line 206 "desktop-file-service.vala"
	_data_->directory = _tmp1_;
#line 206 "desktop-file-service.vala"
	_tmp2_ = g_strdup (id_prefix);
#line 206 "desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 206 "desktop-file-service.vala"
	_data_->id_prefix = _tmp2_;
#line 206 "desktop-file-service.vala"
	_tmp3_ = _g_object_ref0 (monitored_dirs);
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->monitored_dirs);
#line 206 "desktop-file-service.vala"
	_data_->monitored_dirs = _tmp3_;
#line 206 "desktop-file-service.vala"
	synapse_desktop_file_service_process_directory_co (_data_);
#line 3074 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory_finish (SynapseDesktopFileService* self,
                                                       GAsyncResult* _res_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
#line 206 "desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3084 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_process_directory_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseDesktopFileServiceProcessDirectoryData* _data_;
#line 383 "desktop-file-service.vala"
	_data_ = _user_data_;
#line 383 "desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 383 "desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 383 "desktop-file-service.vala"
	synapse_desktop_file_service_process_directory_co (_data_);
#line 3101 "desktop-file-service.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 374 "desktop-file-service.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 3109 "desktop-file-service.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 374 "desktop-file-service.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 3117 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_process_directory_co (SynapseDesktopFileServiceProcessDirectoryData* _data_)
{
#line 370 "desktop-file-service.vala"
	switch (_data_->_state_) {
#line 370 "desktop-file-service.vala"
		case 0:
#line 3127 "desktop-file-service.c"
		goto _state_0;
#line 370 "desktop-file-service.vala"
		case 1:
#line 3131 "desktop-file-service.c"
		goto _state_1;
#line 370 "desktop-file-service.vala"
		case 2:
#line 3135 "desktop-file-service.c"
		goto _state_2;
#line 370 "desktop-file-service.vala"
		case 3:
#line 3139 "desktop-file-service.c"
		goto _state_3;
#line 370 "desktop-file-service.vala"
		case 4:
#line 3143 "desktop-file-service.c"
		goto _state_4;
#line 370 "desktop-file-service.vala"
		case 5:
#line 3147 "desktop-file-service.c"
		goto _state_5;
		default:
#line 370 "desktop-file-service.vala"
		g_assert_not_reached ();
#line 3152 "desktop-file-service.c"
	}
	_state_0:
	{
#line 376 "desktop-file-service.vala"
		_data_->_tmp0_ = g_file_get_path (_data_->directory);
#line 376 "desktop-file-service.vala"
		_data_->path = _data_->_tmp0_;
#line 378 "desktop-file-service.vala"
		_data_->_tmp2_ = _data_->path;
#line 378 "desktop-file-service.vala"
		if (_data_->_tmp2_ != NULL) {
#line 378 "desktop-file-service.vala"
			_data_->_tmp3_ = _data_->path;
#line 378 "desktop-file-service.vala"
			_data_->_tmp1_ = g_str_has_suffix (_data_->_tmp3_, "menu-xdg");
#line 3168 "desktop-file-service.c"
		} else {
#line 378 "desktop-file-service.vala"
			_data_->_tmp1_ = FALSE;
#line 3172 "desktop-file-service.c"
		}
#line 378 "desktop-file-service.vala"
		if (_data_->_tmp1_) {
#line 378 "desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 378 "desktop-file-service.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 378 "desktop-file-service.vala"
			if (_data_->_state_ != 0) {
#line 378 "desktop-file-service.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 378 "desktop-file-service.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3186 "desktop-file-service.c"
				}
			}
#line 378 "desktop-file-service.vala"
			g_object_unref (_data_->_async_result);
#line 378 "desktop-file-service.vala"
			return FALSE;
#line 3193 "desktop-file-service.c"
		}
#line 380 "desktop-file-service.vala"
		_data_->_tmp5_ = _data_->path;
#line 380 "desktop-file-service.vala"
		if (_data_->_tmp5_ != NULL) {
#line 380 "desktop-file-service.vala"
			_data_->_tmp6_ = _data_->path;
#line 380 "desktop-file-service.vala"
			_data_->_tmp4_ = g_str_has_suffix (_data_->_tmp6_, "/screensavers");
#line 3203 "desktop-file-service.c"
		} else {
#line 380 "desktop-file-service.vala"
			_data_->_tmp4_ = FALSE;
#line 3207 "desktop-file-service.c"
		}
#line 380 "desktop-file-service.vala"
		if (_data_->_tmp4_) {
#line 380 "desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 380 "desktop-file-service.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 380 "desktop-file-service.vala"
			if (_data_->_state_ != 0) {
#line 380 "desktop-file-service.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 380 "desktop-file-service.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3221 "desktop-file-service.c"
				}
			}
#line 380 "desktop-file-service.vala"
			g_object_unref (_data_->_async_result);
#line 380 "desktop-file-service.vala"
			return FALSE;
#line 3228 "desktop-file-service.c"
		}
#line 382 "desktop-file-service.vala"
		_data_->_tmp7_ = _data_->path;
#line 382 "desktop-file-service.vala"
		g_debug ("desktop-file-service.vala:382: Searching for desktop files in: %s", _data_->_tmp7_);
#line 383 "desktop-file-service.vala"
		_data_->_state_ = 1;
#line 383 "desktop-file-service.vala"
		synapse_utils_query_exists_async (_data_->directory, synapse_desktop_file_service_process_directory_ready, _data_);
#line 383 "desktop-file-service.vala"
		return FALSE;
#line 3240 "desktop-file-service.c"
		_state_1:
#line 383 "desktop-file-service.vala"
		_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
#line 384 "desktop-file-service.vala"
		if (!_data_->exists) {
#line 384 "desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 384 "desktop-file-service.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 384 "desktop-file-service.vala"
			if (_data_->_state_ != 0) {
#line 384 "desktop-file-service.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 384 "desktop-file-service.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3256 "desktop-file-service.c"
				}
			}
#line 384 "desktop-file-service.vala"
			g_object_unref (_data_->_async_result);
#line 384 "desktop-file-service.vala"
			return FALSE;
#line 3263 "desktop-file-service.c"
		}
		{
#line 386 "desktop-file-service.vala"
			_data_->_tmp8_ = gee_iterable_iterator ((GeeIterable*) _data_->monitored_dirs);
#line 386 "desktop-file-service.vala"
			_data_->_scanned_dir_it = _data_->_tmp8_;
#line 386 "desktop-file-service.vala"
			while (TRUE) {
#line 386 "desktop-file-service.vala"
				_data_->_tmp9_ = _data_->_scanned_dir_it;
#line 386 "desktop-file-service.vala"
				if (!gee_iterator_next (_data_->_tmp9_)) {
#line 386 "desktop-file-service.vala"
					break;
#line 3278 "desktop-file-service.c"
				}
#line 386 "desktop-file-service.vala"
				_data_->_tmp10_ = _data_->_scanned_dir_it;
#line 386 "desktop-file-service.vala"
				_data_->_tmp11_ = gee_iterator_get (_data_->_tmp10_);
#line 386 "desktop-file-service.vala"
				_data_->scanned_dir = (GFile*) _data_->_tmp11_;
#line 388 "desktop-file-service.vala"
				_data_->_tmp12_ = _data_->path;
#line 388 "desktop-file-service.vala"
				_data_->_tmp13_ = _data_->scanned_dir;
#line 388 "desktop-file-service.vala"
				_data_->_tmp14_ = g_file_get_path (_data_->_tmp13_);
#line 388 "desktop-file-service.vala"
				_data_->_tmp15_ = _data_->_tmp14_;
#line 388 "desktop-file-service.vala"
				_data_->_tmp16_ = g_strcmp0 (_data_->_tmp12_, _data_->_tmp15_) == 0;
#line 388 "desktop-file-service.vala"
				_g_free0 (_data_->_tmp15_);
#line 388 "desktop-file-service.vala"
				if (_data_->_tmp16_) {
#line 388 "desktop-file-service.vala"
					_g_object_unref0 (_data_->scanned_dir);
#line 388 "desktop-file-service.vala"
					_g_object_unref0 (_data_->_scanned_dir_it);
#line 388 "desktop-file-service.vala"
					_g_free0 (_data_->path);
#line 388 "desktop-file-service.vala"
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 388 "desktop-file-service.vala"
					if (_data_->_state_ != 0) {
#line 388 "desktop-file-service.vala"
						while (!g_task_get_completed (_data_->_async_result)) {
#line 388 "desktop-file-service.vala"
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3314 "desktop-file-service.c"
						}
					}
#line 388 "desktop-file-service.vala"
					g_object_unref (_data_->_async_result);
#line 388 "desktop-file-service.vala"
					return FALSE;
#line 3321 "desktop-file-service.c"
				}
#line 386 "desktop-file-service.vala"
				_g_object_unref0 (_data_->scanned_dir);
#line 3325 "desktop-file-service.c"
			}
#line 386 "desktop-file-service.vala"
			_g_object_unref0 (_data_->_scanned_dir_it);
#line 3329 "desktop-file-service.c"
		}
#line 390 "desktop-file-service.vala"
		gee_collection_add ((GeeCollection*) _data_->monitored_dirs, _data_->directory);
#line 391 "desktop-file-service.vala"
		_data_->_state_ = 2;
#line 391 "desktop-file-service.vala"
		g_file_enumerate_children_async (_data_->directory, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, 0, NULL, synapse_desktop_file_service_process_directory_ready, _data_);
#line 391 "desktop-file-service.vala"
		return FALSE;
#line 3339 "desktop-file-service.c"
		_state_2:
#line 391 "desktop-file-service.vala"
		_data_->_tmp17_ = g_file_enumerate_children_finish (_data_->directory, _data_->_res_, &_data_->_inner_error0_);
#line 391 "desktop-file-service.vala"
		_data_->enumerator = _data_->_tmp17_;
#line 391 "desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 391 "desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 3349 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 394 "desktop-file-service.vala"
		_data_->_tmp18_ = _data_->enumerator;
#line 394 "desktop-file-service.vala"
		_data_->_state_ = 3;
#line 394 "desktop-file-service.vala"
		g_file_enumerator_next_files_async (_data_->_tmp18_, 1024, 0, NULL, synapse_desktop_file_service_process_directory_ready, _data_);
#line 394 "desktop-file-service.vala"
		return FALSE;
#line 3360 "desktop-file-service.c"
		_state_3:
#line 394 "desktop-file-service.vala"
		_data_->_tmp19_ = g_file_enumerator_next_files_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error0_);
#line 394 "desktop-file-service.vala"
		_data_->files = _data_->_tmp19_;
#line 394 "desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 394 "desktop-file-service.vala"
			_g_object_unref0 (_data_->enumerator);
#line 394 "desktop-file-service.vala"
			_g_free0 (_data_->path);
#line 3372 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 395 "desktop-file-service.vala"
		_data_->_tmp20_ = _data_->files;
#line 3377 "desktop-file-service.c"
		{
#line 395 "desktop-file-service.vala"
			_data_->f_collection = _data_->_tmp20_;
#line 395 "desktop-file-service.vala"
			for (_data_->f_it = _data_->f_collection; _data_->f_it != NULL; _data_->f_it = _data_->f_it->next) {
#line 395 "desktop-file-service.vala"
				_data_->_tmp21_ = _g_object_ref0 ((GFileInfo*) _data_->f_it->data);
#line 395 "desktop-file-service.vala"
				_data_->f = _data_->_tmp21_;
#line 3387 "desktop-file-service.c"
				{
#line 397 "desktop-file-service.vala"
					_data_->_tmp22_ = _data_->f;
#line 397 "desktop-file-service.vala"
					_data_->_tmp23_ = g_file_info_get_name (_data_->_tmp22_);
#line 397 "desktop-file-service.vala"
					_data_->name = _data_->_tmp23_;
#line 398 "desktop-file-service.vala"
					_data_->_tmp24_ = _data_->f;
#line 398 "desktop-file-service.vala"
					if (g_file_info_get_file_type (_data_->_tmp24_) == G_FILE_TYPE_DIRECTORY) {
#line 401 "desktop-file-service.vala"
						_data_->_tmp25_ = _data_->name;
#line 401 "desktop-file-service.vala"
						_data_->_tmp26_ = g_file_get_child (_data_->directory, _data_->_tmp25_);
#line 401 "desktop-file-service.vala"
						_data_->subdir = _data_->_tmp26_;
#line 402 "desktop-file-service.vala"
						_data_->_tmp27_ = _data_->subdir;
#line 402 "desktop-file-service.vala"
						_data_->_tmp28_ = g_file_get_basename (_data_->_tmp27_);
#line 402 "desktop-file-service.vala"
						_data_->_tmp29_ = _data_->_tmp28_;
#line 402 "desktop-file-service.vala"
						_data_->_tmp30_ = g_strdup_printf ("%s%s-", _data_->id_prefix, _data_->_tmp29_);
#line 402 "desktop-file-service.vala"
						_data_->_tmp31_ = _data_->_tmp30_;
#line 402 "desktop-file-service.vala"
						_g_free0 (_data_->_tmp29_);
#line 402 "desktop-file-service.vala"
						_data_->new_prefix = _data_->_tmp31_;
#line 403 "desktop-file-service.vala"
						_data_->_tmp32_ = _data_->subdir;
#line 403 "desktop-file-service.vala"
						_data_->_tmp33_ = _data_->new_prefix;
#line 403 "desktop-file-service.vala"
						_data_->_state_ = 4;
#line 403 "desktop-file-service.vala"
						synapse_desktop_file_service_process_directory (_data_->self, _data_->_tmp32_, _data_->_tmp33_, _data_->monitored_dirs, synapse_desktop_file_service_process_directory_ready, _data_);
#line 403 "desktop-file-service.vala"
						return FALSE;
#line 3429 "desktop-file-service.c"
						_state_4:
#line 403 "desktop-file-service.vala"
						synapse_desktop_file_service_process_directory_finish (_data_->self, _data_->_res_);
#line 398 "desktop-file-service.vala"
						_g_free0 (_data_->new_prefix);
#line 398 "desktop-file-service.vala"
						_g_object_unref0 (_data_->subdir);
#line 3437 "desktop-file-service.c"
					} else {
#line 408 "desktop-file-service.vala"
						_data_->_tmp34_ = _data_->name;
#line 408 "desktop-file-service.vala"
						if (g_str_has_suffix (_data_->_tmp34_, "synapse.desktop")) {
#line 408 "desktop-file-service.vala"
							_g_object_unref0 (_data_->f);
#line 408 "desktop-file-service.vala"
							continue;
#line 3447 "desktop-file-service.c"
						}
#line 409 "desktop-file-service.vala"
						_data_->_tmp35_ = _data_->name;
#line 409 "desktop-file-service.vala"
						if (g_str_has_suffix (_data_->_tmp35_, ".desktop")) {
#line 411 "desktop-file-service.vala"
							_data_->_tmp36_ = _data_->name;
#line 411 "desktop-file-service.vala"
							_data_->_tmp37_ = g_file_get_child (_data_->directory, _data_->_tmp36_);
#line 411 "desktop-file-service.vala"
							_data_->_tmp38_ = _data_->_tmp37_;
#line 411 "desktop-file-service.vala"
							_data_->_state_ = 5;
#line 411 "desktop-file-service.vala"
							synapse_desktop_file_service_load_desktop_file (_data_->self, _data_->_tmp38_, _data_->id_prefix, synapse_desktop_file_service_process_directory_ready, _data_);
#line 411 "desktop-file-service.vala"
							return FALSE;
#line 3465 "desktop-file-service.c"
							_state_5:
#line 411 "desktop-file-service.vala"
							synapse_desktop_file_service_load_desktop_file_finish (_data_->self, _data_->_res_);
#line 411 "desktop-file-service.vala"
							_g_object_unref0 (_data_->_tmp38_);
#line 3471 "desktop-file-service.c"
						}
					}
#line 395 "desktop-file-service.vala"
					_g_object_unref0 (_data_->f);
#line 3476 "desktop-file-service.c"
				}
			}
		}
#line 374 "desktop-file-service.vala"
		(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
#line 374 "desktop-file-service.vala"
		_g_object_unref0 (_data_->enumerator);
#line 374 "desktop-file-service.vala"
		_g_free0 (_data_->path);
#line 3486 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 374 "desktop-file-service.vala"
		_data_->err = _data_->_inner_error0_;
#line 374 "desktop-file-service.vala"
		_data_->_inner_error0_ = NULL;
#line 418 "desktop-file-service.vala"
		_data_->_tmp39_ = _data_->err;
#line 418 "desktop-file-service.vala"
		_data_->_tmp40_ = _data_->_tmp39_->message;
#line 418 "desktop-file-service.vala"
		g_warning ("desktop-file-service.vala:418: %s", _data_->_tmp40_);
#line 374 "desktop-file-service.vala"
		_g_error_free0 (_data_->err);
#line 3503 "desktop-file-service.c"
	}
	__finally0:
#line 374 "desktop-file-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 374 "desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 374 "desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 374 "desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 374 "desktop-file-service.vala"
		return FALSE;
#line 3516 "desktop-file-service.c"
	}
#line 370 "desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 370 "desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 370 "desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 370 "desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3526 "desktop-file-service.c"
		}
	}
#line 370 "desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 370 "desktop-file-service.vala"
	return FALSE;
#line 3533 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	_data_ = _data;
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceLoadAllDesktopFilesData, _data_);
#line 3545 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files (SynapseDesktopFileService* self,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
	SynapseDesktopFileService* _tmp0_;
#line 206 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 206 "desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadAllDesktopFilesData);
#line 206 "desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_all_desktop_files_data_free);
#line 206 "desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_co (_data_);
#line 3569 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files_finish (SynapseDesktopFileService* self,
                                                            GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
#line 206 "desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3579 "desktop-file-service.c"
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
#line 424 "desktop-file-service.vala"
	if (length >= 0) {
#line 3588 "desktop-file-service.c"
		gchar** result;
		gssize i;
#line 424 "desktop-file-service.vala"
		result = g_new0 (gchar*, length + 1);
#line 424 "desktop-file-service.vala"
		for (i = 0; i < length; i++) {
#line 3595 "desktop-file-service.c"
			gchar* _tmp0_;
#line 424 "desktop-file-service.vala"
			_tmp0_ = g_strdup (self[i]);
#line 424 "desktop-file-service.vala"
			result[i] = _tmp0_;
#line 3601 "desktop-file-service.c"
		}
#line 424 "desktop-file-service.vala"
		return result;
#line 3605 "desktop-file-service.c"
	}
#line 424 "desktop-file-service.vala"
	return NULL;
#line 3609 "desktop-file-service.c"
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 425 "desktop-file-service.vala"
	if ((*length) == (*size)) {
#line 425 "desktop-file-service.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 425 "desktop-file-service.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 3624 "desktop-file-service.c"
	}
#line 425 "desktop-file-service.vala"
	(*array)[(*length)++] = value;
#line 425 "desktop-file-service.vala"
	(*array)[*length] = NULL;
#line 3630 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_all_desktop_files_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_;
#line 435 "desktop-file-service.vala"
	_data_ = _user_data_;
#line 435 "desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 435 "desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 435 "desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_co (_data_);
#line 3647 "desktop-file-service.c"
}

static void
_synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                     GFile* file,
                                                                                     GFile* other_file,
                                                                                     GFileMonitorEvent event_type,
                                                                                     gpointer self)
{
#line 448 "desktop-file-service.vala"
	synapse_desktop_file_service_desktop_file_directory_changed ((SynapseDesktopFileService*) self);
#line 3659 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_load_all_desktop_files_co (SynapseDesktopFileServiceLoadAllDesktopFilesData* _data_)
{
#line 422 "desktop-file-service.vala"
	switch (_data_->_state_) {
#line 422 "desktop-file-service.vala"
		case 0:
#line 3669 "desktop-file-service.c"
		goto _state_0;
#line 422 "desktop-file-service.vala"
		case 1:
#line 3673 "desktop-file-service.c"
		goto _state_1;
#line 422 "desktop-file-service.vala"
		case 2:
#line 3677 "desktop-file-service.c"
		goto _state_2;
		default:
#line 422 "desktop-file-service.vala"
		g_assert_not_reached ();
#line 3682 "desktop-file-service.c"
	}
	_state_0:
#line 424 "desktop-file-service.vala"
	_data_->_tmp1_ = _data_->_tmp0_ = g_get_system_data_dirs ();
#line 424 "desktop-file-service.vala"
	_data_->_tmp2_ = (_data_->_tmp1_ != NULL) ? _vala_array_dup2 (_data_->_tmp1_, _vala_array_length (_data_->_tmp0_)) : _data_->_tmp1_;
#line 424 "desktop-file-service.vala"
	_data_->_tmp2__length1 = _vala_array_length (_data_->_tmp0_);
#line 424 "desktop-file-service.vala"
	_data_->data_dirs = _data_->_tmp2_;
#line 424 "desktop-file-service.vala"
	_data_->data_dirs_length1 = _data_->_tmp2__length1;
#line 424 "desktop-file-service.vala"
	_data_->_data_dirs_size_ = _data_->data_dirs_length1;
#line 425 "desktop-file-service.vala"
	_data_->_tmp3_ = g_get_user_data_dir ();
#line 425 "desktop-file-service.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 425 "desktop-file-service.vala"
	_vala_array_add5 (&_data_->data_dirs, &_data_->data_dirs_length1, &_data_->_data_dirs_size_, _data_->_tmp4_);
#line 427 "desktop-file-service.vala"
	_data_->_tmp5_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 427 "desktop-file-service.vala"
	_data_->desktop_file_dirs = (GeeSet*) _data_->_tmp5_;
#line 429 "desktop-file-service.vala"
	_data_->_tmp6_ = _data_->self->priv->mimetype_parent_map;
#line 429 "desktop-file-service.vala"
	gee_multi_map_clear (_data_->_tmp6_);
#line 431 "desktop-file-service.vala"
	_data_->_tmp7_ = _data_->data_dirs;
#line 431 "desktop-file-service.vala"
	_data_->_tmp7__length1 = _data_->data_dirs_length1;
#line 3715 "desktop-file-service.c"
	{
#line 431 "desktop-file-service.vala"
		_data_->data_dir_collection_length1 = 0;
#line 431 "desktop-file-service.vala"
		_data_->_data_dir_collection_size_ = 0;
#line 431 "desktop-file-service.vala"
		_data_->data_dir_collection = _data_->_tmp7_;
#line 431 "desktop-file-service.vala"
		_data_->data_dir_collection_length1 = _data_->_tmp7__length1;
#line 431 "desktop-file-service.vala"
		for (_data_->data_dir_it = 0; _data_->data_dir_it < _data_->data_dir_collection_length1; _data_->data_dir_it = _data_->data_dir_it + 1) {
#line 431 "desktop-file-service.vala"
			_data_->data_dir = _data_->data_dir_collection[_data_->data_dir_it];
#line 3729 "desktop-file-service.c"
			{
#line 433 "desktop-file-service.vala"
				_data_->_tmp8_ = _data_->data_dir;
#line 433 "desktop-file-service.vala"
				_data_->_tmp9_ = g_build_filename (_data_->_tmp8_, "applications", NULL, NULL);
#line 433 "desktop-file-service.vala"
				_data_->dir_path = _data_->_tmp9_;
#line 434 "desktop-file-service.vala"
				_data_->_tmp10_ = _data_->dir_path;
#line 434 "desktop-file-service.vala"
				_data_->_tmp11_ = g_file_new_for_path (_data_->_tmp10_);
#line 434 "desktop-file-service.vala"
				_data_->directory = _data_->_tmp11_;
#line 435 "desktop-file-service.vala"
				_data_->_tmp12_ = _data_->directory;
#line 435 "desktop-file-service.vala"
				_data_->_tmp13_ = _data_->desktop_file_dirs;
#line 435 "desktop-file-service.vala"
				_data_->_state_ = 1;
#line 435 "desktop-file-service.vala"
				synapse_desktop_file_service_process_directory (_data_->self, _data_->_tmp12_, "", _data_->_tmp13_, synapse_desktop_file_service_load_all_desktop_files_ready, _data_);
#line 435 "desktop-file-service.vala"
				return FALSE;
#line 3753 "desktop-file-service.c"
				_state_1:
#line 435 "desktop-file-service.vala"
				synapse_desktop_file_service_process_directory_finish (_data_->self, _data_->_res_);
#line 436 "desktop-file-service.vala"
				_data_->_tmp14_ = _data_->data_dir;
#line 436 "desktop-file-service.vala"
				_data_->_tmp15_ = g_build_filename (_data_->_tmp14_, "mime", "subclasses", NULL);
#line 436 "desktop-file-service.vala"
				_g_free0 (_data_->dir_path);
#line 436 "desktop-file-service.vala"
				_data_->dir_path = _data_->_tmp15_;
#line 437 "desktop-file-service.vala"
				_data_->_tmp16_ = _data_->dir_path;
#line 437 "desktop-file-service.vala"
				_data_->_state_ = 2;
#line 437 "desktop-file-service.vala"
				synapse_desktop_file_service_load_mime_parents_from_file (_data_->self, _data_->_tmp16_, synapse_desktop_file_service_load_all_desktop_files_ready, _data_);
#line 437 "desktop-file-service.vala"
				return FALSE;
#line 3773 "desktop-file-service.c"
				_state_2:
#line 437 "desktop-file-service.vala"
				synapse_desktop_file_service_load_mime_parents_from_file_finish (_data_->self, _data_->_res_);
#line 431 "desktop-file-service.vala"
				_g_object_unref0 (_data_->directory);
#line 431 "desktop-file-service.vala"
				_g_free0 (_data_->dir_path);
#line 3781 "desktop-file-service.c"
			}
		}
	}
#line 440 "desktop-file-service.vala"
	synapse_desktop_file_service_create_indices (_data_->self);
#line 442 "desktop-file-service.vala"
	_data_->_tmp17_ = gee_array_list_new (g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 442 "desktop-file-service.vala"
	_g_object_unref0 (_data_->self->priv->directory_monitors);
#line 442 "desktop-file-service.vala"
	_data_->self->priv->directory_monitors = (GeeList*) _data_->_tmp17_;
#line 3793 "desktop-file-service.c"
	{
#line 443 "desktop-file-service.vala"
		_data_->_tmp18_ = _data_->desktop_file_dirs;
#line 443 "desktop-file-service.vala"
		_data_->_tmp19_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp18_);
#line 443 "desktop-file-service.vala"
		_data_->_d_it = _data_->_tmp19_;
#line 443 "desktop-file-service.vala"
		while (TRUE) {
#line 443 "desktop-file-service.vala"
			_data_->_tmp20_ = _data_->_d_it;
#line 443 "desktop-file-service.vala"
			if (!gee_iterator_next (_data_->_tmp20_)) {
#line 443 "desktop-file-service.vala"
				break;
#line 3809 "desktop-file-service.c"
			}
#line 443 "desktop-file-service.vala"
			_data_->_tmp21_ = _data_->_d_it;
#line 443 "desktop-file-service.vala"
			_data_->_tmp22_ = gee_iterator_get (_data_->_tmp21_);
#line 443 "desktop-file-service.vala"
			_data_->d = (GFile*) _data_->_tmp22_;
#line 3817 "desktop-file-service.c"
			{
#line 447 "desktop-file-service.vala"
				_data_->_tmp23_ = _data_->d;
#line 447 "desktop-file-service.vala"
				_data_->_tmp24_ = g_file_monitor_directory (_data_->_tmp23_, 0, NULL, &_data_->_inner_error0_);
#line 447 "desktop-file-service.vala"
				_data_->monitor = _data_->_tmp24_;
#line 447 "desktop-file-service.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 3827 "desktop-file-service.c"
					goto __catch0_g_error;
				}
#line 448 "desktop-file-service.vala"
				_data_->_tmp25_ = _data_->monitor;
#line 448 "desktop-file-service.vala"
				g_signal_connect_object (_data_->_tmp25_, "changed", (GCallback) _synapse_desktop_file_service_desktop_file_directory_changed_g_file_monitor_changed, _data_->self, 0);
#line 449 "desktop-file-service.vala"
				_data_->_tmp26_ = _data_->self->priv->directory_monitors;
#line 449 "desktop-file-service.vala"
				_data_->_tmp27_ = _data_->monitor;
#line 449 "desktop-file-service.vala"
				gee_collection_add ((GeeCollection*) _data_->_tmp26_, _data_->_tmp27_);
#line 445 "desktop-file-service.vala"
				_g_object_unref0 (_data_->monitor);
#line 3842 "desktop-file-service.c"
			}
			goto __finally0;
			__catch0_g_error:
			{
#line 445 "desktop-file-service.vala"
				_data_->err = _data_->_inner_error0_;
#line 445 "desktop-file-service.vala"
				_data_->_inner_error0_ = NULL;
#line 453 "desktop-file-service.vala"
				_data_->_tmp28_ = _data_->err;
#line 453 "desktop-file-service.vala"
				_data_->_tmp29_ = _data_->_tmp28_->message;
#line 453 "desktop-file-service.vala"
				g_warning ("desktop-file-service.vala:453: Unable to monitor directory: %s", _data_->_tmp29_);
#line 445 "desktop-file-service.vala"
				_g_error_free0 (_data_->err);
#line 3859 "desktop-file-service.c"
			}
			__finally0:
#line 445 "desktop-file-service.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 445 "desktop-file-service.vala"
				_g_object_unref0 (_data_->d);
#line 445 "desktop-file-service.vala"
				_g_object_unref0 (_data_->_d_it);
#line 445 "desktop-file-service.vala"
				_g_object_unref0 (_data_->desktop_file_dirs);
#line 445 "desktop-file-service.vala"
				_data_->data_dirs = (_vala_array_free (_data_->data_dirs, _data_->data_dirs_length1, (GDestroyNotify) g_free), NULL);
#line 445 "desktop-file-service.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 445 "desktop-file-service.vala"
				g_clear_error (&_data_->_inner_error0_);
#line 445 "desktop-file-service.vala"
				g_object_unref (_data_->_async_result);
#line 445 "desktop-file-service.vala"
				return FALSE;
#line 3880 "desktop-file-service.c"
			}
#line 443 "desktop-file-service.vala"
			_g_object_unref0 (_data_->d);
#line 3884 "desktop-file-service.c"
		}
#line 443 "desktop-file-service.vala"
		_g_object_unref0 (_data_->_d_it);
#line 3888 "desktop-file-service.c"
	}
#line 422 "desktop-file-service.vala"
	_g_object_unref0 (_data_->desktop_file_dirs);
#line 422 "desktop-file-service.vala"
	_data_->data_dirs = (_vala_array_free (_data_->data_dirs, _data_->data_dirs_length1, (GDestroyNotify) g_free), NULL);
#line 422 "desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 422 "desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 422 "desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 422 "desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3902 "desktop-file-service.c"
		}
	}
#line 422 "desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 422 "desktop-file-service.vala"
	return FALSE;
#line 3909 "desktop-file-service.c"
}

static gboolean
__lambda8_ (SynapseDesktopFileService* self)
{
	gboolean result;
#line 472 "desktop-file-service.vala"
	self->priv->timer_id = (guint) 0;
#line 473 "desktop-file-service.vala"
	synapse_desktop_file_service_reload_desktop_files (self, NULL, NULL);
#line 474 "desktop-file-service.vala"
	result = FALSE;
#line 474 "desktop-file-service.vala"
	return result;
#line 3924 "desktop-file-service.c"
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((SynapseDesktopFileService*) self);
#line 471 "desktop-file-service.vala"
	return result;
#line 3934 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_desktop_file_directory_changed (SynapseDesktopFileService* self)
{
#line 463 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 465 "desktop-file-service.vala"
	g_signal_emit (self, synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL], 0);
#line 466 "desktop-file-service.vala"
	if (self->priv->timer_id != ((guint) 0)) {
#line 468 "desktop-file-service.vala"
		g_source_remove (self->priv->timer_id);
#line 3948 "desktop-file-service.c"
	}
#line 471 "desktop-file-service.vala"
	self->priv->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
#line 3952 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files_data_free (gpointer _data)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	_data_ = _data;
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceReloadDesktopFilesData, _data_);
#line 3964 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files (SynapseDesktopFileService* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
	SynapseDesktopFileService* _tmp0_;
#line 206 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 206 "desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceReloadDesktopFilesData);
#line 206 "desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_reload_desktop_files_data_free);
#line 206 "desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "desktop-file-service.vala"
	synapse_desktop_file_service_reload_desktop_files_co (_data_);
#line 3988 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files_finish (SynapseDesktopFileService* self,
                                                          GAsyncResult* _res_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
#line 206 "desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3998 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_reload_desktop_files_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	SynapseDesktopFileServiceReloadDesktopFilesData* _data_;
#line 483 "desktop-file-service.vala"
	_data_ = _user_data_;
#line 483 "desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 483 "desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 483 "desktop-file-service.vala"
	synapse_desktop_file_service_reload_desktop_files_co (_data_);
#line 4015 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_reload_desktop_files_co (SynapseDesktopFileServiceReloadDesktopFilesData* _data_)
{
#line 478 "desktop-file-service.vala"
	switch (_data_->_state_) {
#line 478 "desktop-file-service.vala"
		case 0:
#line 4025 "desktop-file-service.c"
		goto _state_0;
#line 478 "desktop-file-service.vala"
		case 1:
#line 4029 "desktop-file-service.c"
		goto _state_1;
		default:
#line 478 "desktop-file-service.vala"
		g_assert_not_reached ();
#line 4034 "desktop-file-service.c"
	}
	_state_0:
#line 480 "desktop-file-service.vala"
	g_debug ("desktop-file-service.vala:480: Reloading desktop files...");
#line 481 "desktop-file-service.vala"
	_data_->_tmp0_ = _data_->self->priv->all_desktop_files;
#line 481 "desktop-file-service.vala"
	gee_collection_clear ((GeeCollection*) _data_->_tmp0_);
#line 482 "desktop-file-service.vala"
	_data_->_tmp1_ = _data_->self->priv->non_hidden_desktop_files;
#line 482 "desktop-file-service.vala"
	gee_collection_clear ((GeeCollection*) _data_->_tmp1_);
#line 483 "desktop-file-service.vala"
	_data_->_state_ = 1;
#line 483 "desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files (_data_->self, synapse_desktop_file_service_reload_desktop_files_ready, _data_);
#line 483 "desktop-file-service.vala"
	return FALSE;
#line 4053 "desktop-file-service.c"
	_state_1:
#line 483 "desktop-file-service.vala"
	synapse_desktop_file_service_load_all_desktop_files_finish (_data_->self, _data_->_res_);
#line 485 "desktop-file-service.vala"
	g_signal_emit (_data_->self, synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL], 0);
#line 478 "desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 478 "desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 478 "desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 478 "desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4067 "desktop-file-service.c"
		}
	}
#line 478 "desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 478 "desktop-file-service.vala"
	return FALSE;
#line 4074 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	_data_ = _data;
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->file);
#line 206 "desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceLoadDesktopFileData, _data_);
#line 4090 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file (SynapseDesktopFileService* self,
                                                GFile* file,
                                                const gchar* id_prefix,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
	SynapseDesktopFileService* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
#line 206 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 206 "desktop-file-service.vala"
	g_return_if_fail (file != NULL);
#line 206 "desktop-file-service.vala"
	g_return_if_fail (id_prefix != NULL);
#line 206 "desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadDesktopFileData);
#line 206 "desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_desktop_file_data_free);
#line 206 "desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "desktop-file-service.vala"
	_tmp1_ = _g_object_ref0 (file);
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->file);
#line 206 "desktop-file-service.vala"
	_data_->file = _tmp1_;
#line 206 "desktop-file-service.vala"
	_tmp2_ = g_strdup (id_prefix);
#line 206 "desktop-file-service.vala"
	_g_free0 (_data_->id_prefix);
#line 206 "desktop-file-service.vala"
	_data_->id_prefix = _tmp2_;
#line 206 "desktop-file-service.vala"
	synapse_desktop_file_service_load_desktop_file_co (_data_);
#line 4134 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file_finish (SynapseDesktopFileService* self,
                                                       GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
#line 206 "desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4144 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_desktop_file_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadDesktopFileData* _data_;
#line 493 "desktop-file-service.vala"
	_data_ = _user_data_;
#line 493 "desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 493 "desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 493 "desktop-file-service.vala"
	synapse_desktop_file_service_load_desktop_file_co (_data_);
#line 4161 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_load_desktop_file_co (SynapseDesktopFileServiceLoadDesktopFileData* _data_)
{
#line 488 "desktop-file-service.vala"
	switch (_data_->_state_) {
#line 488 "desktop-file-service.vala"
		case 0:
#line 4171 "desktop-file-service.c"
		goto _state_0;
#line 488 "desktop-file-service.vala"
		case 1:
#line 4175 "desktop-file-service.c"
		goto _state_1;
		default:
#line 488 "desktop-file-service.vala"
		g_assert_not_reached ();
#line 4180 "desktop-file-service.c"
	}
	_state_0:
	{
#line 492 "desktop-file-service.vala"
		_data_->file_contents_length1 = 0;
#line 492 "desktop-file-service.vala"
		_data_->_file_contents_size_ = 0;
#line 493 "desktop-file-service.vala"
		_data_->_tmp0_ = NULL;
#line 493 "desktop-file-service.vala"
		_data_->_tmp1_ = 0;
#line 493 "desktop-file-service.vala"
		_data_->_state_ = 1;
#line 493 "desktop-file-service.vala"
		g_file_load_contents_async (_data_->file, NULL, synapse_desktop_file_service_load_desktop_file_ready, _data_);
#line 493 "desktop-file-service.vala"
		return FALSE;
#line 4198 "desktop-file-service.c"
		_state_1:
#line 493 "desktop-file-service.vala"
		_data_->_tmp2_ = g_file_load_contents_finish (_data_->file, _data_->_res_, &_data_->_tmp0_, &_data_->_tmp1_, NULL, &_data_->_inner_error0_);
#line 493 "desktop-file-service.vala"
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 493 "desktop-file-service.vala"
		_data_->file_contents = _data_->_tmp0_;
#line 493 "desktop-file-service.vala"
		_data_->file_contents_length1 = _data_->_tmp1_;
#line 493 "desktop-file-service.vala"
		_data_->_file_contents_size_ = _data_->file_contents_length1;
#line 493 "desktop-file-service.vala"
		_data_->success = _data_->_tmp2_;
#line 493 "desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 493 "desktop-file-service.vala"
			_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 4216 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 495 "desktop-file-service.vala"
		if (_data_->success) {
#line 497 "desktop-file-service.vala"
			_data_->_tmp3_ = g_key_file_new ();
#line 497 "desktop-file-service.vala"
			_data_->keyfile = _data_->_tmp3_;
#line 498 "desktop-file-service.vala"
			_data_->_tmp4_ = _data_->keyfile;
#line 498 "desktop-file-service.vala"
			_data_->_tmp5_ = _data_->file_contents;
#line 498 "desktop-file-service.vala"
			_data_->_tmp5__length1 = _data_->file_contents_length1;
#line 498 "desktop-file-service.vala"
			_data_->_tmp6_ = _data_->file_contents;
#line 498 "desktop-file-service.vala"
			_data_->_tmp6__length1 = _data_->file_contents_length1;
#line 498 "desktop-file-service.vala"
			g_key_file_load_from_data (_data_->_tmp4_, (const gchar*) _data_->_tmp5_, (gsize) _data_->_tmp6__length1, 0, &_data_->_inner_error0_);
#line 498 "desktop-file-service.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 498 "desktop-file-service.vala"
				_g_key_file_unref0 (_data_->keyfile);
#line 498 "desktop-file-service.vala"
				_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 4243 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 501 "desktop-file-service.vala"
			_data_->_tmp7_ = g_file_get_basename (_data_->file);
#line 501 "desktop-file-service.vala"
			_data_->_tmp8_ = _data_->_tmp7_;
#line 501 "desktop-file-service.vala"
			_data_->_tmp9_ = g_strdup_printf ("%s%s", _data_->id_prefix, _data_->_tmp8_);
#line 501 "desktop-file-service.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 501 "desktop-file-service.vala"
			_g_free0 (_data_->_tmp8_);
#line 501 "desktop-file-service.vala"
			_data_->desktop_id = _data_->_tmp10_;
#line 502 "desktop-file-service.vala"
			_data_->_tmp11_ = g_file_get_path (_data_->file);
#line 502 "desktop-file-service.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 502 "desktop-file-service.vala"
			_data_->_tmp13_ = _data_->keyfile;
#line 502 "desktop-file-service.vala"
			_data_->_tmp14_ = _data_->desktop_id;
#line 502 "desktop-file-service.vala"
			_data_->_tmp15_ = synapse_desktop_file_info_new_for_keyfile (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp14_);
#line 502 "desktop-file-service.vala"
			_data_->_tmp16_ = _data_->_tmp15_;
#line 502 "desktop-file-service.vala"
			_g_free0 (_data_->_tmp12_);
#line 502 "desktop-file-service.vala"
			_data_->dfi = _data_->_tmp16_;
#line 505 "desktop-file-service.vala"
			_data_->_tmp17_ = _data_->dfi;
#line 505 "desktop-file-service.vala"
			_data_->_tmp18_ = synapse_desktop_file_info_get_is_valid (_data_->_tmp17_);
#line 505 "desktop-file-service.vala"
			_data_->_tmp19_ = _data_->_tmp18_;
#line 505 "desktop-file-service.vala"
			if (_data_->_tmp19_) {
#line 507 "desktop-file-service.vala"
				_data_->_tmp20_ = _data_->self->priv->all_desktop_files;
#line 507 "desktop-file-service.vala"
				_data_->_tmp21_ = _data_->dfi;
#line 507 "desktop-file-service.vala"
				gee_collection_add ((GeeCollection*) _data_->_tmp20_, _data_->_tmp21_);
#line 508 "desktop-file-service.vala"
				_data_->_tmp23_ = _data_->dfi;
#line 508 "desktop-file-service.vala"
				_data_->_tmp24_ = synapse_desktop_file_info_get_is_hidden (_data_->_tmp23_);
#line 508 "desktop-file-service.vala"
				_data_->_tmp25_ = _data_->_tmp24_;
#line 508 "desktop-file-service.vala"
				if (!_data_->_tmp25_) {
#line 508 "desktop-file-service.vala"
					_data_->_tmp26_ = _data_->dfi;
#line 508 "desktop-file-service.vala"
					_data_->_tmp27_ = synapse_desktop_file_info_get_show_in (_data_->_tmp26_);
#line 508 "desktop-file-service.vala"
					_data_->_tmp28_ = _data_->_tmp27_;
#line 508 "desktop-file-service.vala"
					_data_->_tmp22_ = (_data_->_tmp28_ & _data_->self->priv->session_type) == _data_->self->priv->session_type;
#line 4304 "desktop-file-service.c"
				} else {
#line 508 "desktop-file-service.vala"
					_data_->_tmp22_ = FALSE;
#line 4308 "desktop-file-service.c"
				}
#line 508 "desktop-file-service.vala"
				if (_data_->_tmp22_) {
#line 510 "desktop-file-service.vala"
					_data_->_tmp29_ = _data_->self->priv->non_hidden_desktop_files;
#line 510 "desktop-file-service.vala"
					_data_->_tmp30_ = _data_->dfi;
#line 510 "desktop-file-service.vala"
					gee_collection_add ((GeeCollection*) _data_->_tmp29_, _data_->_tmp30_);
#line 4318 "desktop-file-service.c"
				}
			}
#line 495 "desktop-file-service.vala"
			_g_object_unref0 (_data_->dfi);
#line 495 "desktop-file-service.vala"
			_g_free0 (_data_->desktop_id);
#line 495 "desktop-file-service.vala"
			_g_key_file_unref0 (_data_->keyfile);
#line 4327 "desktop-file-service.c"
		}
#line 490 "desktop-file-service.vala"
		_data_->file_contents = (g_free (_data_->file_contents), NULL);
#line 4331 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 490 "desktop-file-service.vala"
		_data_->err = _data_->_inner_error0_;
#line 490 "desktop-file-service.vala"
		_data_->_inner_error0_ = NULL;
#line 517 "desktop-file-service.vala"
		_data_->_tmp31_ = _data_->err;
#line 517 "desktop-file-service.vala"
		_data_->_tmp32_ = _data_->_tmp31_->message;
#line 517 "desktop-file-service.vala"
		g_warning ("desktop-file-service.vala:517: %s", _data_->_tmp32_);
#line 490 "desktop-file-service.vala"
		_g_error_free0 (_data_->err);
#line 4348 "desktop-file-service.c"
	}
	__finally0:
#line 490 "desktop-file-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 490 "desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 490 "desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 490 "desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 490 "desktop-file-service.vala"
		return FALSE;
#line 4361 "desktop-file-service.c"
	}
#line 488 "desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 488 "desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 488 "desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 488 "desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4371 "desktop-file-service.c"
		}
	}
#line 488 "desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 488 "desktop-file-service.vala"
	return FALSE;
#line 4378 "desktop-file-service.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 4399 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_create_indices (SynapseDesktopFileService* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GRegex* exec_re = NULL;
	GError* _inner_error0_ = NULL;
#line 521 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 524 "desktop-file-service.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, NULL, NULL, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 524 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 524 "desktop-file-service.vala"
	self->priv->mimetype_map = (GeeMap*) _tmp0_;
#line 527 "desktop-file-service.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 527 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->exec_map);
#line 527 "desktop-file-service.vala"
	self->priv->exec_map = (GeeMap*) _tmp1_;
#line 530 "desktop-file-service.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 530 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->desktop_id_map);
#line 530 "desktop-file-service.vala"
	self->priv->desktop_id_map = (GeeMap*) _tmp2_;
#line 4430 "desktop-file-service.c"
	{
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
#line 536 "desktop-file-service.vala"
		_tmp4_ = g_regex_new ("%[fFuU]", 0, 0, &_inner_error0_);
#line 536 "desktop-file-service.vala"
		_tmp3_ = _tmp4_;
#line 536 "desktop-file-service.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4441 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 536 "desktop-file-service.vala"
		_tmp5_ = _tmp3_;
#line 536 "desktop-file-service.vala"
		_tmp3_ = NULL;
#line 536 "desktop-file-service.vala"
		_g_regex_unref0 (exec_re);
#line 536 "desktop-file-service.vala"
		exec_re = _tmp5_;
#line 534 "desktop-file-service.vala"
		_g_regex_unref0 (_tmp3_);
#line 4454 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 534 "desktop-file-service.vala"
		err = _inner_error0_;
#line 534 "desktop-file-service.vala"
		_inner_error0_ = NULL;
#line 540 "desktop-file-service.vala"
		_tmp6_ = err;
#line 540 "desktop-file-service.vala"
		_tmp7_ = _tmp6_->message;
#line 540 "desktop-file-service.vala"
		g_critical ("desktop-file-service.vala:540: %s", _tmp7_);
#line 541 "desktop-file-service.vala"
		_g_error_free0 (err);
#line 541 "desktop-file-service.vala"
		_g_regex_unref0 (exec_re);
#line 541 "desktop-file-service.vala"
		return;
#line 4478 "desktop-file-service.c"
	}
	__finally0:
#line 534 "desktop-file-service.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 534 "desktop-file-service.vala"
		_g_regex_unref0 (exec_re);
#line 534 "desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 534 "desktop-file-service.vala"
		g_clear_error (&_inner_error0_);
#line 534 "desktop-file-service.vala"
		return;
#line 4491 "desktop-file-service.c"
	}
	{
		GeeList* _dfi_list = NULL;
		GeeList* _tmp8_;
		gint _dfi_size = 0;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _dfi_index = 0;
#line 544 "desktop-file-service.vala"
		_tmp8_ = self->priv->all_desktop_files;
#line 544 "desktop-file-service.vala"
		_dfi_list = _tmp8_;
#line 544 "desktop-file-service.vala"
		_tmp9_ = _dfi_list;
#line 544 "desktop-file-service.vala"
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
#line 544 "desktop-file-service.vala"
		_tmp11_ = _tmp10_;
#line 544 "desktop-file-service.vala"
		_dfi_size = _tmp11_;
#line 544 "desktop-file-service.vala"
		_dfi_index = -1;
#line 544 "desktop-file-service.vala"
		while (TRUE) {
#line 4517 "desktop-file-service.c"
			gint _tmp12_;
			gint _tmp13_;
			SynapseDesktopFileInfo* dfi = NULL;
			GeeList* _tmp14_;
			gpointer _tmp15_;
			gchar* exec = NULL;
			gchar* _tmp16_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			GeeList* exec_list = NULL;
			GeeMap* _tmp28_;
			const gchar* _tmp29_;
			gpointer _tmp30_;
			GeeList* _tmp31_;
			GeeList* _tmp36_;
			SynapseDesktopFileInfo* _tmp37_;
			gchar* _tmp38_ = NULL;
			SynapseDesktopFileInfo* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* desktop_id = NULL;
			gchar* _tmp47_;
			GeeMap* _tmp48_;
			const gchar* _tmp49_;
			SynapseDesktopFileInfo* _tmp50_;
			gboolean _tmp51_ = FALSE;
			SynapseDesktopFileInfo* _tmp52_;
			gboolean _tmp53_;
			gboolean _tmp54_;
			SynapseDesktopFileInfo* _tmp57_;
			gchar** _tmp58_;
			gint _tmp58__length1;
#line 544 "desktop-file-service.vala"
			_dfi_index = _dfi_index + 1;
#line 544 "desktop-file-service.vala"
			_tmp12_ = _dfi_index;
#line 544 "desktop-file-service.vala"
			_tmp13_ = _dfi_size;
#line 544 "desktop-file-service.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 544 "desktop-file-service.vala"
				break;
#line 4561 "desktop-file-service.c"
			}
#line 544 "desktop-file-service.vala"
			_tmp14_ = _dfi_list;
#line 544 "desktop-file-service.vala"
			_tmp15_ = gee_list_get (_tmp14_, _dfi_index);
#line 544 "desktop-file-service.vala"
			dfi = (SynapseDesktopFileInfo*) _tmp15_;
#line 546 "desktop-file-service.vala"
			_tmp16_ = g_strdup ("");
#line 546 "desktop-file-service.vala"
			exec = _tmp16_;
#line 4573 "desktop-file-service.c"
			{
				gchar* _tmp17_ = NULL;
				GRegex* _tmp18_;
				SynapseDesktopFileInfo* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
#line 549 "desktop-file-service.vala"
				_tmp18_ = exec_re;
#line 549 "desktop-file-service.vala"
				_tmp19_ = dfi;
#line 549 "desktop-file-service.vala"
				_tmp20_ = synapse_desktop_file_info_get_exec (_tmp19_);
#line 549 "desktop-file-service.vala"
				_tmp21_ = _tmp20_;
#line 549 "desktop-file-service.vala"
				_tmp22_ = g_regex_replace_literal (_tmp18_, _tmp21_, (gssize) -1, 0, "", 0, &_inner_error0_);
#line 549 "desktop-file-service.vala"
				_tmp17_ = _tmp22_;
#line 549 "desktop-file-service.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 549 "desktop-file-service.vala"
					if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 4598 "desktop-file-service.c"
						goto __catch1_g_regex_error;
					}
#line 549 "desktop-file-service.vala"
					_g_free0 (exec);
#line 549 "desktop-file-service.vala"
					_g_object_unref0 (dfi);
#line 549 "desktop-file-service.vala"
					_g_regex_unref0 (exec_re);
#line 549 "desktop-file-service.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 549 "desktop-file-service.vala"
					g_clear_error (&_inner_error0_);
#line 549 "desktop-file-service.vala"
					return;
#line 4613 "desktop-file-service.c"
				}
#line 549 "desktop-file-service.vala"
				_tmp23_ = _tmp17_;
#line 549 "desktop-file-service.vala"
				_tmp17_ = NULL;
#line 549 "desktop-file-service.vala"
				_g_free0 (exec);
#line 549 "desktop-file-service.vala"
				exec = _tmp23_;
#line 547 "desktop-file-service.vala"
				_g_free0 (_tmp17_);
#line 4625 "desktop-file-service.c"
			}
			goto __finally1;
			__catch1_g_regex_error:
			{
				GError* err = NULL;
				GError* _tmp24_;
				const gchar* _tmp25_;
#line 547 "desktop-file-service.vala"
				err = _inner_error0_;
#line 547 "desktop-file-service.vala"
				_inner_error0_ = NULL;
#line 553 "desktop-file-service.vala"
				_tmp24_ = err;
#line 553 "desktop-file-service.vala"
				_tmp25_ = _tmp24_->message;
#line 553 "desktop-file-service.vala"
				g_critical ("desktop-file-service.vala:553: %s", _tmp25_);
#line 547 "desktop-file-service.vala"
				_g_error_free0 (err);
#line 4645 "desktop-file-service.c"
			}
			__finally1:
#line 547 "desktop-file-service.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 547 "desktop-file-service.vala"
				_g_free0 (exec);
#line 547 "desktop-file-service.vala"
				_g_object_unref0 (dfi);
#line 547 "desktop-file-service.vala"
				_g_regex_unref0 (exec_re);
#line 547 "desktop-file-service.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 547 "desktop-file-service.vala"
				g_clear_error (&_inner_error0_);
#line 547 "desktop-file-service.vala"
				return;
#line 4662 "desktop-file-service.c"
			}
#line 555 "desktop-file-service.vala"
			_tmp26_ = exec;
#line 555 "desktop-file-service.vala"
			_tmp27_ = string_strip (_tmp26_);
#line 555 "desktop-file-service.vala"
			_g_free0 (exec);
#line 555 "desktop-file-service.vala"
			exec = _tmp27_;
#line 557 "desktop-file-service.vala"
			_tmp28_ = self->priv->exec_map;
#line 557 "desktop-file-service.vala"
			_tmp29_ = exec;
#line 557 "desktop-file-service.vala"
			_tmp30_ = gee_map_get (_tmp28_, _tmp29_);
#line 557 "desktop-file-service.vala"
			exec_list = (GeeList*) _tmp30_;
#line 558 "desktop-file-service.vala"
			_tmp31_ = exec_list;
#line 558 "desktop-file-service.vala"
			if (_tmp31_ == NULL) {
#line 4684 "desktop-file-service.c"
				GeeArrayList* _tmp32_;
				GeeMap* _tmp33_;
				const gchar* _tmp34_;
				GeeList* _tmp35_;
#line 560 "desktop-file-service.vala"
				_tmp32_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 560 "desktop-file-service.vala"
				_g_object_unref0 (exec_list);
#line 560 "desktop-file-service.vala"
				exec_list = (GeeList*) _tmp32_;
#line 561 "desktop-file-service.vala"
				_tmp33_ = self->priv->exec_map;
#line 561 "desktop-file-service.vala"
				_tmp34_ = exec;
#line 561 "desktop-file-service.vala"
				_tmp35_ = exec_list;
#line 561 "desktop-file-service.vala"
				gee_map_set (_tmp33_, _tmp34_, _tmp35_);
#line 4703 "desktop-file-service.c"
			}
#line 563 "desktop-file-service.vala"
			_tmp36_ = exec_list;
#line 563 "desktop-file-service.vala"
			_tmp37_ = dfi;
#line 563 "desktop-file-service.vala"
			gee_collection_add ((GeeCollection*) _tmp36_, _tmp37_);
#line 566 "desktop-file-service.vala"
			_tmp39_ = dfi;
#line 566 "desktop-file-service.vala"
			_tmp40_ = synapse_desktop_file_info_get_desktop_id (_tmp39_);
#line 566 "desktop-file-service.vala"
			_tmp41_ = _tmp40_;
#line 566 "desktop-file-service.vala"
			_tmp42_ = g_strdup (_tmp41_);
#line 566 "desktop-file-service.vala"
			_tmp38_ = _tmp42_;
#line 566 "desktop-file-service.vala"
			if (_tmp38_ == NULL) {
#line 4723 "desktop-file-service.c"
				SynapseDesktopFileInfo* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
#line 566 "desktop-file-service.vala"
				_tmp43_ = dfi;
#line 566 "desktop-file-service.vala"
				_tmp44_ = synapse_desktop_file_info_get_filename (_tmp43_);
#line 566 "desktop-file-service.vala"
				_tmp45_ = _tmp44_;
#line 566 "desktop-file-service.vala"
				_tmp46_ = g_path_get_basename (_tmp45_);
#line 566 "desktop-file-service.vala"
				_g_free0 (_tmp38_);
#line 566 "desktop-file-service.vala"
				_tmp38_ = _tmp46_;
#line 4740 "desktop-file-service.c"
			}
#line 566 "desktop-file-service.vala"
			_tmp47_ = _tmp38_;
#line 566 "desktop-file-service.vala"
			_tmp38_ = NULL;
#line 566 "desktop-file-service.vala"
			desktop_id = _tmp47_;
#line 567 "desktop-file-service.vala"
			_tmp48_ = self->priv->desktop_id_map;
#line 567 "desktop-file-service.vala"
			_tmp49_ = desktop_id;
#line 567 "desktop-file-service.vala"
			_tmp50_ = dfi;
#line 567 "desktop-file-service.vala"
			gee_map_set (_tmp48_, _tmp49_, _tmp50_);
#line 570 "desktop-file-service.vala"
			_tmp52_ = dfi;
#line 570 "desktop-file-service.vala"
			_tmp53_ = synapse_desktop_file_info_get_is_hidden (_tmp52_);
#line 570 "desktop-file-service.vala"
			_tmp54_ = _tmp53_;
#line 570 "desktop-file-service.vala"
			if (_tmp54_) {
#line 570 "desktop-file-service.vala"
				_tmp51_ = TRUE;
#line 4766 "desktop-file-service.c"
			} else {
				SynapseDesktopFileInfo* _tmp55_;
				gchar** _tmp56_;
				gint _tmp56__length1;
#line 570 "desktop-file-service.vala"
				_tmp55_ = dfi;
#line 570 "desktop-file-service.vala"
				_tmp56_ = _tmp55_->mime_types;
#line 570 "desktop-file-service.vala"
				_tmp56__length1 = _tmp55_->mime_types_length1;
#line 570 "desktop-file-service.vala"
				_tmp51_ = _tmp56_ == NULL;
#line 4779 "desktop-file-service.c"
			}
#line 570 "desktop-file-service.vala"
			if (_tmp51_) {
#line 570 "desktop-file-service.vala"
				_g_free0 (desktop_id);
#line 570 "desktop-file-service.vala"
				_g_free0 (_tmp38_);
#line 570 "desktop-file-service.vala"
				_g_object_unref0 (exec_list);
#line 570 "desktop-file-service.vala"
				_g_free0 (exec);
#line 570 "desktop-file-service.vala"
				_g_object_unref0 (dfi);
#line 570 "desktop-file-service.vala"
				continue;
#line 4795 "desktop-file-service.c"
			}
#line 572 "desktop-file-service.vala"
			_tmp57_ = dfi;
#line 572 "desktop-file-service.vala"
			_tmp58_ = _tmp57_->mime_types;
#line 572 "desktop-file-service.vala"
			_tmp58__length1 = _tmp57_->mime_types_length1;
#line 4803 "desktop-file-service.c"
			{
				gchar** mime_type_collection = NULL;
				gint mime_type_collection_length1 = 0;
				gint _mime_type_collection_size_ = 0;
				gint mime_type_it = 0;
#line 572 "desktop-file-service.vala"
				mime_type_collection = _tmp58_;
#line 572 "desktop-file-service.vala"
				mime_type_collection_length1 = _tmp58__length1;
#line 572 "desktop-file-service.vala"
				for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
#line 4815 "desktop-file-service.c"
					const gchar* mime_type = NULL;
#line 572 "desktop-file-service.vala"
					mime_type = mime_type_collection[mime_type_it];
#line 4819 "desktop-file-service.c"
					{
						GeeList* list = NULL;
						GeeMap* _tmp59_;
						const gchar* _tmp60_;
						gpointer _tmp61_;
						GeeList* _tmp62_;
						GeeList* _tmp67_;
						SynapseDesktopFileInfo* _tmp68_;
#line 574 "desktop-file-service.vala"
						_tmp59_ = self->priv->mimetype_map;
#line 574 "desktop-file-service.vala"
						_tmp60_ = mime_type;
#line 574 "desktop-file-service.vala"
						_tmp61_ = gee_map_get (_tmp59_, _tmp60_);
#line 574 "desktop-file-service.vala"
						list = (GeeList*) _tmp61_;
#line 575 "desktop-file-service.vala"
						_tmp62_ = list;
#line 575 "desktop-file-service.vala"
						if (_tmp62_ == NULL) {
#line 4840 "desktop-file-service.c"
							GeeArrayList* _tmp63_;
							GeeMap* _tmp64_;
							const gchar* _tmp65_;
							GeeList* _tmp66_;
#line 577 "desktop-file-service.vala"
							_tmp63_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 577 "desktop-file-service.vala"
							_g_object_unref0 (list);
#line 577 "desktop-file-service.vala"
							list = (GeeList*) _tmp63_;
#line 578 "desktop-file-service.vala"
							_tmp64_ = self->priv->mimetype_map;
#line 578 "desktop-file-service.vala"
							_tmp65_ = mime_type;
#line 578 "desktop-file-service.vala"
							_tmp66_ = list;
#line 578 "desktop-file-service.vala"
							gee_map_set (_tmp64_, _tmp65_, _tmp66_);
#line 4859 "desktop-file-service.c"
						}
#line 580 "desktop-file-service.vala"
						_tmp67_ = list;
#line 580 "desktop-file-service.vala"
						_tmp68_ = dfi;
#line 580 "desktop-file-service.vala"
						gee_collection_add ((GeeCollection*) _tmp67_, _tmp68_);
#line 572 "desktop-file-service.vala"
						_g_object_unref0 (list);
#line 4869 "desktop-file-service.c"
					}
				}
			}
#line 544 "desktop-file-service.vala"
			_g_free0 (desktop_id);
#line 544 "desktop-file-service.vala"
			_g_free0 (_tmp38_);
#line 544 "desktop-file-service.vala"
			_g_object_unref0 (exec_list);
#line 544 "desktop-file-service.vala"
			_g_free0 (exec);
#line 544 "desktop-file-service.vala"
			_g_object_unref0 (dfi);
#line 4883 "desktop-file-service.c"
		}
	}
#line 521 "desktop-file-service.vala"
	_g_regex_unref0 (exec_re);
#line 4888 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file_data_free (gpointer _data)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	_data_ = _data;
#line 206 "desktop-file-service.vala"
	_g_free0 (_data_->fi);
#line 206 "desktop-file-service.vala"
	_g_object_unref0 (_data_->self);
#line 206 "desktop-file-service.vala"
	g_slice_free (SynapseDesktopFileServiceLoadMimeParentsFromFileData, _data_);
#line 4902 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file (SynapseDesktopFileService* self,
                                                          const gchar* fi,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
	SynapseDesktopFileService* _tmp0_;
	gchar* _tmp1_;
#line 206 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 206 "desktop-file-service.vala"
	g_return_if_fail (fi != NULL);
#line 206 "desktop-file-service.vala"
	_data_ = g_slice_new0 (SynapseDesktopFileServiceLoadMimeParentsFromFileData);
#line 206 "desktop-file-service.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 206 "desktop-file-service.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_desktop_file_service_load_mime_parents_from_file_data_free);
#line 206 "desktop-file-service.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 206 "desktop-file-service.vala"
	_data_->self = _tmp0_;
#line 206 "desktop-file-service.vala"
	_tmp1_ = g_strdup (fi);
#line 206 "desktop-file-service.vala"
	_g_free0 (_data_->fi);
#line 206 "desktop-file-service.vala"
	_data_->fi = _tmp1_;
#line 206 "desktop-file-service.vala"
	synapse_desktop_file_service_load_mime_parents_from_file_co (_data_);
#line 4936 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file_finish (SynapseDesktopFileService* self,
                                                                 GAsyncResult* _res_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
#line 206 "desktop-file-service.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 4946 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_load_mime_parents_from_file_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_;
#line 588 "desktop-file-service.vala"
	_data_ = _user_data_;
#line 588 "desktop-file-service.vala"
	_data_->_source_object_ = source_object;
#line 588 "desktop-file-service.vala"
	_data_->_res_ = _res_;
#line 588 "desktop-file-service.vala"
	synapse_desktop_file_service_load_mime_parents_from_file_co (_data_);
#line 4963 "desktop-file-service.c"
}

static gboolean
synapse_desktop_file_service_load_mime_parents_from_file_co (SynapseDesktopFileServiceLoadMimeParentsFromFileData* _data_)
{
#line 585 "desktop-file-service.vala"
	switch (_data_->_state_) {
#line 585 "desktop-file-service.vala"
		case 0:
#line 4973 "desktop-file-service.c"
		goto _state_0;
#line 585 "desktop-file-service.vala"
		case 1:
#line 4977 "desktop-file-service.c"
		goto _state_1;
#line 585 "desktop-file-service.vala"
		case 2:
#line 4981 "desktop-file-service.c"
		goto _state_2;
#line 585 "desktop-file-service.vala"
		case 3:
#line 4985 "desktop-file-service.c"
		goto _state_3;
		default:
#line 585 "desktop-file-service.vala"
		g_assert_not_reached ();
#line 4990 "desktop-file-service.c"
	}
	_state_0:
#line 587 "desktop-file-service.vala"
	_data_->_tmp0_ = g_file_new_for_path (_data_->fi);
#line 587 "desktop-file-service.vala"
	_data_->file = _data_->_tmp0_;
#line 588 "desktop-file-service.vala"
	_data_->_tmp1_ = _data_->file;
#line 588 "desktop-file-service.vala"
	_data_->_state_ = 1;
#line 588 "desktop-file-service.vala"
	synapse_utils_query_exists_async (_data_->_tmp1_, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
#line 588 "desktop-file-service.vala"
	return FALSE;
#line 5005 "desktop-file-service.c"
	_state_1:
#line 588 "desktop-file-service.vala"
	_data_->exists = synapse_utils_query_exists_finish (_data_->_res_);
#line 589 "desktop-file-service.vala"
	if (!_data_->exists) {
#line 589 "desktop-file-service.vala"
		_g_object_unref0 (_data_->file);
#line 589 "desktop-file-service.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 589 "desktop-file-service.vala"
		if (_data_->_state_ != 0) {
#line 589 "desktop-file-service.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 589 "desktop-file-service.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5021 "desktop-file-service.c"
			}
		}
#line 589 "desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 589 "desktop-file-service.vala"
		return FALSE;
#line 5028 "desktop-file-service.c"
	}
	{
#line 592 "desktop-file-service.vala"
		_data_->_tmp2_ = _data_->file;
#line 592 "desktop-file-service.vala"
		_data_->_state_ = 2;
#line 592 "desktop-file-service.vala"
		g_file_read_async (_data_->_tmp2_, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
#line 592 "desktop-file-service.vala"
		return FALSE;
#line 5039 "desktop-file-service.c"
		_state_2:
#line 592 "desktop-file-service.vala"
		_data_->_tmp3_ = g_file_read_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
#line 592 "desktop-file-service.vala"
		_data_->fis = _data_->_tmp3_;
#line 592 "desktop-file-service.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 5047 "desktop-file-service.c"
			goto __catch0_g_error;
		}
#line 593 "desktop-file-service.vala"
		_data_->_tmp4_ = _data_->fis;
#line 593 "desktop-file-service.vala"
		_data_->_tmp5_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp4_);
#line 593 "desktop-file-service.vala"
		_data_->dis = _data_->_tmp5_;
#line 594 "desktop-file-service.vala"
		_data_->line = NULL;
#line 595 "desktop-file-service.vala"
		_data_->mimes = NULL;
#line 595 "desktop-file-service.vala"
		_data_->mimes_length1 = 0;
#line 595 "desktop-file-service.vala"
		_data_->_mimes_size_ = _data_->mimes_length1;
#line 596 "desktop-file-service.vala"
		_data_->len = 0;
#line 598 "desktop-file-service.vala"
		while (TRUE) {
#line 599 "desktop-file-service.vala"
			_data_->_tmp7_ = _data_->dis;
#line 599 "desktop-file-service.vala"
			_data_->_state_ = 3;
#line 599 "desktop-file-service.vala"
			g_data_input_stream_read_line_async (_data_->_tmp7_, G_PRIORITY_DEFAULT, NULL, synapse_desktop_file_service_load_mime_parents_from_file_ready, _data_);
#line 599 "desktop-file-service.vala"
			return FALSE;
#line 5076 "desktop-file-service.c"
			_state_3:
#line 599 "desktop-file-service.vala"
			_data_->_tmp8_ = g_data_input_stream_read_line_finish (_data_->_tmp7_, _data_->_res_, NULL, &_data_->_inner_error0_);
#line 599 "desktop-file-service.vala"
			_data_->_tmp6_ = _data_->_tmp8_;
#line 599 "desktop-file-service.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 599 "desktop-file-service.vala"
				_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
#line 599 "desktop-file-service.vala"
				_g_free0 (_data_->line);
#line 599 "desktop-file-service.vala"
				_g_object_unref0 (_data_->dis);
#line 599 "desktop-file-service.vala"
				_g_object_unref0 (_data_->fis);
#line 5092 "desktop-file-service.c"
				goto __catch0_g_error;
			}
#line 599 "desktop-file-service.vala"
			_data_->_tmp9_ = _data_->_tmp6_;
#line 599 "desktop-file-service.vala"
			_data_->_tmp6_ = NULL;
#line 599 "desktop-file-service.vala"
			_g_free0 (_data_->line);
#line 599 "desktop-file-service.vala"
			_data_->line = _data_->_tmp9_;
#line 600 "desktop-file-service.vala"
			_data_->_tmp10_ = _data_->line;
#line 600 "desktop-file-service.vala"
			if (_data_->_tmp10_ == NULL) {
#line 600 "desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 600 "desktop-file-service.vala"
				break;
#line 5111 "desktop-file-service.c"
			}
#line 601 "desktop-file-service.vala"
			_data_->_tmp11_ = _data_->line;
#line 601 "desktop-file-service.vala"
			if (g_str_has_prefix (_data_->_tmp11_, "#")) {
#line 601 "desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 601 "desktop-file-service.vala"
				continue;
#line 5121 "desktop-file-service.c"
			}
#line 602 "desktop-file-service.vala"
			_data_->_tmp12_ = _data_->line;
#line 602 "desktop-file-service.vala"
			_data_->_tmp14_ = _data_->_tmp13_ = g_strsplit (_data_->_tmp12_, " ", 0);
#line 602 "desktop-file-service.vala"
			_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
#line 602 "desktop-file-service.vala"
			_data_->mimes = _data_->_tmp14_;
#line 602 "desktop-file-service.vala"
			_data_->mimes_length1 = _vala_array_length (_data_->_tmp13_);
#line 602 "desktop-file-service.vala"
			_data_->_mimes_size_ = _data_->mimes_length1;
#line 603 "desktop-file-service.vala"
			_data_->_tmp15_ = _data_->mimes;
#line 603 "desktop-file-service.vala"
			_data_->_tmp15__length1 = _data_->mimes_length1;
#line 603 "desktop-file-service.vala"
			_data_->len = (gint) g_strv_length (_data_->_tmp15_);
#line 604 "desktop-file-service.vala"
			if (_data_->len != 2) {
#line 604 "desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 604 "desktop-file-service.vala"
				continue;
#line 5147 "desktop-file-service.c"
			}
#line 606 "desktop-file-service.vala"
			_data_->_tmp16_ = _data_->mimes;
#line 606 "desktop-file-service.vala"
			_data_->_tmp16__length1 = _data_->mimes_length1;
#line 606 "desktop-file-service.vala"
			_data_->_tmp17_ = _data_->_tmp16_[0];
#line 606 "desktop-file-service.vala"
			_data_->_tmp18_ = _data_->mimes;
#line 606 "desktop-file-service.vala"
			_data_->_tmp18__length1 = _data_->mimes_length1;
#line 606 "desktop-file-service.vala"
			_data_->_tmp19_ = _data_->_tmp18_[1];
#line 606 "desktop-file-service.vala"
			if (g_strcmp0 (_data_->_tmp17_, _data_->_tmp19_) == 0) {
#line 606 "desktop-file-service.vala"
				_g_free0 (_data_->_tmp6_);
#line 606 "desktop-file-service.vala"
				continue;
#line 5167 "desktop-file-service.c"
			}
#line 608 "desktop-file-service.vala"
			_data_->_tmp20_ = _data_->self->priv->mimetype_parent_map;
#line 608 "desktop-file-service.vala"
			_data_->_tmp21_ = _data_->mimes;
#line 608 "desktop-file-service.vala"
			_data_->_tmp21__length1 = _data_->mimes_length1;
#line 608 "desktop-file-service.vala"
			_data_->_tmp22_ = _data_->_tmp21_[0];
#line 608 "desktop-file-service.vala"
			_data_->_tmp23_ = _data_->mimes;
#line 608 "desktop-file-service.vala"
			_data_->_tmp23__length1 = _data_->mimes_length1;
#line 608 "desktop-file-service.vala"
			_data_->_tmp24_ = _data_->_tmp23_[1];
#line 608 "desktop-file-service.vala"
			gee_multi_map_set (_data_->_tmp20_, _data_->_tmp22_, _data_->_tmp24_);
#line 598 "desktop-file-service.vala"
			_g_free0 (_data_->_tmp6_);
#line 5187 "desktop-file-service.c"
		}
#line 590 "desktop-file-service.vala"
		_data_->mimes = (_vala_array_free (_data_->mimes, _data_->mimes_length1, (GDestroyNotify) g_free), NULL);
#line 590 "desktop-file-service.vala"
		_g_free0 (_data_->line);
#line 590 "desktop-file-service.vala"
		_g_object_unref0 (_data_->dis);
#line 590 "desktop-file-service.vala"
		_g_object_unref0 (_data_->fis);
#line 5197 "desktop-file-service.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 590 "desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 5204 "desktop-file-service.c"
	}
	__finally0:
#line 590 "desktop-file-service.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 590 "desktop-file-service.vala"
		_g_object_unref0 (_data_->file);
#line 590 "desktop-file-service.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 590 "desktop-file-service.vala"
		g_clear_error (&_data_->_inner_error0_);
#line 590 "desktop-file-service.vala"
		g_object_unref (_data_->_async_result);
#line 590 "desktop-file-service.vala"
		return FALSE;
#line 5219 "desktop-file-service.c"
	}
#line 585 "desktop-file-service.vala"
	_g_object_unref0 (_data_->file);
#line 585 "desktop-file-service.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 585 "desktop-file-service.vala"
	if (_data_->_state_ != 0) {
#line 585 "desktop-file-service.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 585 "desktop-file-service.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5231 "desktop-file-service.c"
		}
	}
#line 585 "desktop-file-service.vala"
	g_object_unref (_data_->_async_result);
#line 585 "desktop-file-service.vala"
	return FALSE;
#line 5238 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_add_dfi_for_mime (SynapseDesktopFileService* self,
                                               const gchar* mime,
                                               GeeSet* ret)
{
	GeeList* dfis = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GeeList* _tmp2_;
	GeeCollection* parents = NULL;
	GeeMultiMap* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
#line 613 "desktop-file-service.vala"
	g_return_if_fail (self != NULL);
#line 613 "desktop-file-service.vala"
	g_return_if_fail (mime != NULL);
#line 613 "desktop-file-service.vala"
	g_return_if_fail (ret != NULL);
#line 615 "desktop-file-service.vala"
	_tmp0_ = self->priv->mimetype_map;
#line 615 "desktop-file-service.vala"
	_tmp1_ = gee_map_get (_tmp0_, mime);
#line 615 "desktop-file-service.vala"
	dfis = (GeeList*) _tmp1_;
#line 616 "desktop-file-service.vala"
	_tmp2_ = dfis;
#line 616 "desktop-file-service.vala"
	if (_tmp2_ != NULL) {
#line 5270 "desktop-file-service.c"
		GeeList* _tmp3_;
#line 616 "desktop-file-service.vala"
		_tmp3_ = dfis;
#line 616 "desktop-file-service.vala"
		gee_collection_add_all ((GeeCollection*) ret, (GeeCollection*) _tmp3_);
#line 5276 "desktop-file-service.c"
	}
#line 618 "desktop-file-service.vala"
	_tmp4_ = self->priv->mimetype_parent_map;
#line 618 "desktop-file-service.vala"
	_tmp5_ = gee_multi_map_get (_tmp4_, mime);
#line 618 "desktop-file-service.vala"
	parents = _tmp5_;
#line 619 "desktop-file-service.vala"
	_tmp6_ = parents;
#line 619 "desktop-file-service.vala"
	if (_tmp6_ == NULL) {
#line 619 "desktop-file-service.vala"
		_g_object_unref0 (parents);
#line 619 "desktop-file-service.vala"
		_g_object_unref0 (dfis);
#line 619 "desktop-file-service.vala"
		return;
#line 5294 "desktop-file-service.c"
	}
	{
		GeeIterator* _parent_it = NULL;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
#line 620 "desktop-file-service.vala"
		_tmp7_ = parents;
#line 620 "desktop-file-service.vala"
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
#line 620 "desktop-file-service.vala"
		_parent_it = _tmp8_;
#line 620 "desktop-file-service.vala"
		while (TRUE) {
#line 5308 "desktop-file-service.c"
			GeeIterator* _tmp9_;
			gchar* parent = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			const gchar* _tmp12_;
#line 620 "desktop-file-service.vala"
			_tmp9_ = _parent_it;
#line 620 "desktop-file-service.vala"
			if (!gee_iterator_next (_tmp9_)) {
#line 620 "desktop-file-service.vala"
				break;
#line 5320 "desktop-file-service.c"
			}
#line 620 "desktop-file-service.vala"
			_tmp10_ = _parent_it;
#line 620 "desktop-file-service.vala"
			_tmp11_ = gee_iterator_get (_tmp10_);
#line 620 "desktop-file-service.vala"
			parent = (gchar*) _tmp11_;
#line 621 "desktop-file-service.vala"
			_tmp12_ = parent;
#line 621 "desktop-file-service.vala"
			synapse_desktop_file_service_add_dfi_for_mime (self, _tmp12_, ret);
#line 620 "desktop-file-service.vala"
			_g_free0 (parent);
#line 5334 "desktop-file-service.c"
		}
#line 620 "desktop-file-service.vala"
		_g_object_unref0 (_parent_it);
#line 5338 "desktop-file-service.c"
	}
#line 613 "desktop-file-service.vala"
	_g_object_unref0 (parents);
#line 613 "desktop-file-service.vala"
	_g_object_unref0 (dfis);
#line 5344 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_desktop_files (SynapseDesktopFileService* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
#line 625 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 627 "desktop-file-service.vala"
	_tmp0_ = self->priv->non_hidden_desktop_files;
#line 627 "desktop-file-service.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 627 "desktop-file-service.vala"
	_tmp2_ = _tmp1_;
#line 627 "desktop-file-service.vala"
	result = _tmp2_;
#line 627 "desktop-file-service.vala"
	return result;
#line 5366 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_all_desktop_files (SynapseDesktopFileService* self)
{
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
#line 632 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 634 "desktop-file-service.vala"
	_tmp0_ = self->priv->all_desktop_files;
#line 634 "desktop-file-service.vala"
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
#line 634 "desktop-file-service.vala"
	_tmp2_ = _tmp1_;
#line 634 "desktop-file-service.vala"
	result = _tmp2_;
#line 634 "desktop-file-service.vala"
	return result;
#line 5388 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_desktop_files_for_type (SynapseDesktopFileService* self,
                                                         const gchar* mime_type)
{
	GeeHashSet* dfi_set = NULL;
	GeeHashSet* _tmp0_;
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp1_;
	GeeList* result;
#line 637 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 637 "desktop-file-service.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 639 "desktop-file-service.vala"
	_tmp0_ = gee_hash_set_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 639 "desktop-file-service.vala"
	dfi_set = _tmp0_;
#line 640 "desktop-file-service.vala"
	synapse_desktop_file_service_add_dfi_for_mime (self, mime_type, (GeeSet*) dfi_set);
#line 641 "desktop-file-service.vala"
	_tmp1_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 641 "desktop-file-service.vala"
	ret = _tmp1_;
#line 642 "desktop-file-service.vala"
	gee_array_list_add_all (ret, (GeeCollection*) dfi_set);
#line 643 "desktop-file-service.vala"
	result = (GeeList*) ret;
#line 643 "desktop-file-service.vala"
	_g_object_unref0 (dfi_set);
#line 643 "desktop-file-service.vala"
	return result;
#line 5422 "desktop-file-service.c"
}

GeeList*
synapse_desktop_file_service_get_desktop_files_for_exec (SynapseDesktopFileService* self,
                                                         const gchar* exec)
{
	GeeList* _tmp0_ = NULL;
	GeeMap* _tmp1_;
	gpointer _tmp2_;
	GeeList* _tmp4_;
	GeeList* result;
#line 646 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 646 "desktop-file-service.vala"
	g_return_val_if_fail (exec != NULL, NULL);
#line 648 "desktop-file-service.vala"
	_tmp1_ = self->priv->exec_map;
#line 648 "desktop-file-service.vala"
	_tmp2_ = gee_map_get (_tmp1_, exec);
#line 648 "desktop-file-service.vala"
	_tmp0_ = (GeeList*) _tmp2_;
#line 648 "desktop-file-service.vala"
	if (_tmp0_ == NULL) {
#line 5446 "desktop-file-service.c"
		GeeArrayList* _tmp3_;
#line 648 "desktop-file-service.vala"
		_tmp3_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 648 "desktop-file-service.vala"
		_g_object_unref0 (_tmp0_);
#line 648 "desktop-file-service.vala"
		_tmp0_ = (GeeList*) _tmp3_;
#line 5454 "desktop-file-service.c"
	}
#line 648 "desktop-file-service.vala"
	_tmp4_ = _tmp0_;
#line 648 "desktop-file-service.vala"
	_tmp0_ = NULL;
#line 648 "desktop-file-service.vala"
	result = _tmp4_;
#line 648 "desktop-file-service.vala"
	_g_object_unref0 (_tmp0_);
#line 648 "desktop-file-service.vala"
	return result;
#line 5466 "desktop-file-service.c"
}

SynapseDesktopFileInfo*
synapse_desktop_file_service_get_desktop_file_for_id (SynapseDesktopFileService* self,
                                                      const gchar* desktop_id)
{
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	SynapseDesktopFileInfo* result;
#line 651 "desktop-file-service.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 651 "desktop-file-service.vala"
	g_return_val_if_fail (desktop_id != NULL, NULL);
#line 653 "desktop-file-service.vala"
	_tmp0_ = self->priv->desktop_id_map;
#line 653 "desktop-file-service.vala"
	_tmp1_ = gee_map_get (_tmp0_, desktop_id);
#line 653 "desktop-file-service.vala"
	result = (SynapseDesktopFileInfo*) _tmp1_;
#line 653 "desktop-file-service.vala"
	return result;
#line 5488 "desktop-file-service.c"
}

static GObject *
synapse_desktop_file_service_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseDesktopFileService * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeHashMultiMap* _tmp3_;
	SynapseUtilsAsyncOnce* _tmp4_;
#line 229 "desktop-file-service.vala"
	parent_class = G_OBJECT_CLASS (synapse_desktop_file_service_parent_class);
#line 229 "desktop-file-service.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 229 "desktop-file-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService);
#line 231 "desktop-file-service.vala"
	synapse_desktop_file_service_instance = self;
#line 233 "desktop-file-service.vala"
	_tmp0_ = gee_array_list_new (g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 233 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->directory_monitors);
#line 233 "desktop-file-service.vala"
	self->priv->directory_monitors = (GeeList*) _tmp0_;
#line 234 "desktop-file-service.vala"
	_tmp1_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 234 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->all_desktop_files);
#line 234 "desktop-file-service.vala"
	self->priv->all_desktop_files = (GeeList*) _tmp1_;
#line 235 "desktop-file-service.vala"
	_tmp2_ = gee_array_list_new (SYNAPSE_TYPE_DESKTOP_FILE_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 235 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
#line 235 "desktop-file-service.vala"
	self->priv->non_hidden_desktop_files = (GeeList*) _tmp2_;
#line 236 "desktop-file-service.vala"
	_tmp3_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 236 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_parent_map);
#line 236 "desktop-file-service.vala"
	self->priv->mimetype_parent_map = (GeeMultiMap*) _tmp3_;
#line 237 "desktop-file-service.vala"
	_tmp4_ = synapse_utils_async_once_new (G_TYPE_BOOLEAN, NULL, NULL);
#line 237 "desktop-file-service.vala"
	_synapse_utils_async_once_unref0 (self->priv->init_once);
#line 237 "desktop-file-service.vala"
	self->priv->init_once = _tmp4_;
#line 239 "desktop-file-service.vala"
	synapse_desktop_file_service_initialize (self, NULL, NULL);
#line 229 "desktop-file-service.vala"
	return obj;
#line 5546 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_class_init (SynapseDesktopFileServiceClass * klass,
                                         gpointer klass_data)
{
#line 206 "desktop-file-service.vala"
	synapse_desktop_file_service_parent_class = g_type_class_peek_parent (klass);
#line 206 "desktop-file-service.vala"
	g_type_class_adjust_private_offset (klass, &SynapseDesktopFileService_private_offset);
#line 206 "desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_desktop_file_service_constructor;
#line 206 "desktop-file-service.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_desktop_file_service_finalize;
#line 206 "desktop-file-service.vala"
	synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_STARTED_SIGNAL] = g_signal_new ("reload-started", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 206 "desktop-file-service.vala"
	synapse_desktop_file_service_signals[SYNAPSE_DESKTOP_FILE_SERVICE_RELOAD_DONE_SIGNAL] = g_signal_new ("reload-done", SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 5565 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_instance_init (SynapseDesktopFileService * self,
                                            gpointer klass)
{
#line 206 "desktop-file-service.vala"
	self->priv = synapse_desktop_file_service_get_instance_private (self);
#line 264 "desktop-file-service.vala"
	self->priv->session_type = SYNAPSE_DESKTOP_ENVIRONMENT_TYPE_GNOME;
#line 265 "desktop-file-service.vala"
	self->priv->session_type_str = "GNOME";
#line 458 "desktop-file-service.vala"
	self->priv->timer_id = (guint) 0;
#line 5580 "desktop-file-service.c"
}

static void
synapse_desktop_file_service_finalize (GObject * obj)
{
	SynapseDesktopFileService * self;
#line 206 "desktop-file-service.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_DESKTOP_FILE_SERVICE, SynapseDesktopFileService);
#line 244 "desktop-file-service.vala"
	synapse_desktop_file_service_instance = NULL;
#line 209 "desktop-file-service.vala"
	_synapse_utils_async_once_unref0 (self->priv->init_once);
#line 221 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->directory_monitors);
#line 222 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->all_desktop_files);
#line 223 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->non_hidden_desktop_files);
#line 224 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_map);
#line 225 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->exec_map);
#line 226 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->desktop_id_map);
#line 227 "desktop-file-service.vala"
	_g_object_unref0 (self->priv->mimetype_parent_map);
#line 206 "desktop-file-service.vala"
	G_OBJECT_CLASS (synapse_desktop_file_service_parent_class)->finalize (obj);
#line 5609 "desktop-file-service.c"
}

static GType
synapse_desktop_file_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseDesktopFileServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_desktop_file_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseDesktopFileService), 0, (GInstanceInitFunc) synapse_desktop_file_service_instance_init, NULL };
	GType synapse_desktop_file_service_type_id;
	synapse_desktop_file_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseDesktopFileService", &g_define_type_info, 0);
	SynapseDesktopFileService_private_offset = g_type_add_instance_private (synapse_desktop_file_service_type_id, sizeof (SynapseDesktopFileServicePrivate));
	return synapse_desktop_file_service_type_id;
}

GType
synapse_desktop_file_service_get_type (void)
{
	static volatile gsize synapse_desktop_file_service_type_id__once = 0;
	if (g_once_init_enter (&synapse_desktop_file_service_type_id__once)) {
		GType synapse_desktop_file_service_type_id;
		synapse_desktop_file_service_type_id = synapse_desktop_file_service_get_type_once ();
		g_once_init_leave (&synapse_desktop_file_service_type_id__once, synapse_desktop_file_service_type_id);
	}
	return synapse_desktop_file_service_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 239 "data-sink.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5641 "desktop-file-service.c"
		gssize i;
#line 239 "data-sink.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 239 "data-sink.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 239 "data-sink.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5649 "desktop-file-service.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 239 "data-sink.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 239 "data-sink.vala"
	g_free (array);
#line 5664 "desktop-file-service.c"
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
#line 239 "data-sink.vala"
	if (array) {
#line 239 "data-sink.vala"
		while (((gpointer*) array)[length]) {
#line 239 "data-sink.vala"
			length++;
#line 5678 "desktop-file-service.c"
		}
	}
#line 239 "data-sink.vala"
	return length;
#line 5683 "desktop-file-service.c"
}

