/* zeitgeist-related.c generated by valac 0.56.17, the Vala compiler
 * generated from zeitgeist-related.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 *
 */

#include "plugins.h"
#include <glib.h>
#include <synapse-core.h>
#include <glib-object.h>
#include <zeitgeist.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <zeitgeist-datamodel.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SYNAPSE_ZEITGEIST_RELATED_TYPE_RELATED_ITEM (synapse_zeitgeist_related_related_item_get_type ())
#define SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_ZEITGEIST_RELATED_TYPE_RELATED_ITEM, SynapseZeitgeistRelatedRelatedItem))
#define SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_ZEITGEIST_RELATED_TYPE_RELATED_ITEM, SynapseZeitgeistRelatedRelatedItemClass))
#define SYNAPSE_ZEITGEIST_RELATED_IS_RELATED_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_ZEITGEIST_RELATED_TYPE_RELATED_ITEM))
#define SYNAPSE_ZEITGEIST_RELATED_IS_RELATED_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_ZEITGEIST_RELATED_TYPE_RELATED_ITEM))
#define SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_ZEITGEIST_RELATED_TYPE_RELATED_ITEM, SynapseZeitgeistRelatedRelatedItemClass))

typedef struct _SynapseZeitgeistRelatedRelatedItem SynapseZeitgeistRelatedRelatedItem;
typedef struct _SynapseZeitgeistRelatedRelatedItemClass SynapseZeitgeistRelatedRelatedItemClass;
enum  {
	SYNAPSE_ZEITGEIST_RELATED_0_PROPERTY,
	SYNAPSE_ZEITGEIST_RELATED_ENABLED_PROPERTY,
	SYNAPSE_ZEITGEIST_RELATED_NUM_PROPERTIES
};
static GParamSpec* synapse_zeitgeist_related_properties[SYNAPSE_ZEITGEIST_RELATED_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SynapseZeitgeistRelatedFindRelatedData SynapseZeitgeistRelatedFindRelatedData;
typedef struct _SynapseZeitgeistRelatedRelatedItemPrivate SynapseZeitgeistRelatedRelatedItemPrivate;
enum  {
	SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_0_PROPERTY,
	SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_NUM_PROPERTIES
};
static GParamSpec* synapse_zeitgeist_related_related_item_properties[SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_NUM_PROPERTIES];
typedef struct _SynapseZeitgeistRelatedRelatedItemSearchData SynapseZeitgeistRelatedRelatedItemSearchData;

struct _SynapseZeitgeistRelatedPrivate {
	gboolean _enabled;
	SynapseZeitgeistRelatedRelatedItem* action;
	ZeitgeistLog* zg_log;
};

struct _SynapseZeitgeistRelatedFindRelatedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistRelated* self;
	SynapseQuery q;
	SynapseMatch* m;
	SynapseResultSet* result;
	ZeitgeistEvent* e;
	ZeitgeistSubject* s;
	gboolean _tmp0_;
	GPtrArray* templates;
	GPtrArray* _tmp1_;
	GPtrArray* event_templates;
	GPtrArray* _tmp2_;
	GPtrArray* result_templates;
	GPtrArray* _tmp3_;
	SynapseUriMatch* um;
	SynapseUriMatch* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ZeitgeistSubject* _tmp7_;
	ZeitgeistSubject* _tmp8_;
	SynapseUriMatch* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ZeitgeistEvent* _tmp12_;
	ZeitgeistEvent* _tmp13_;
	ZeitgeistSubject* _tmp14_;
	SynapseApplicationMatch* am;
	gchar* app_id;
	GAppInfo* app_info;
	SynapseApplicationMatch* _tmp15_;
	GAppInfo* _tmp16_;
	GAppInfo* _tmp17_;
	GAppInfo* _tmp18_;
	GAppInfo* _tmp19_;
	const gchar* _tmp20_;
	GAppInfo* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_;
	const gchar* _tmp25_;
	GAppInfo* _tmp26_;
	const gchar* _tmp27_;
	GAppInfo* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	SynapseApplicationMatch* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gboolean _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	ZeitgeistEvent* _tmp43_;
	ZeitgeistEvent* _tmp44_;
	const gchar* _tmp45_;
	GPtrArray* _tmp46_;
	ZeitgeistEvent* _tmp47_;
	ZeitgeistEvent* _tmp48_;
	GPtrArray* _tmp49_;
	ZeitgeistEvent* _tmp50_;
	ZeitgeistEvent* _tmp51_;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
	gint64 end;
	GDateTime* _tmp52_;
	GDateTime* _tmp53_;
	gint64 _tmp54_;
	gint64 start;
	gchar** _tmp55_;
	ZeitgeistLog* _tmp56_;
	ZeitgeistTimeRange* _tmp57_;
	ZeitgeistTimeRange* _tmp58_;
	GPtrArray* _tmp59_;
	GPtrArray* _tmp60_;
	SynapseQuery _tmp61_;
	SynapseQuery _tmp62_;
	GCancellable* _tmp63_;
	gint _tmp64_;
	gchar** _tmp65_;
	gchar** _tmp66_;
	gint _tmp66__length1;
	gint _tmp55__length1;
	gint __tmp55__size_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	gboolean _tmp68_;
	gchar** _tmp69_;
	gint _tmp69__length1;
	gchar** _tmp70_;
	gint _tmp70__length1;
	GPtrArray* _tmp71_;
	GPtrArray* _tmp72_;
	gchar** _tmp73_;
	gint _tmp73__length1;
	gchar** uri_collection;
	gint uri_collection_length1;
	gint _uri_collection_size_;
	gint uri_it;
	const gchar* uri;
	ZeitgeistSubject* _tmp74_;
	ZeitgeistSubject* _tmp75_;
	const gchar* _tmp76_;
	ZeitgeistEvent* _tmp77_;
	ZeitgeistEvent* _tmp78_;
	ZeitgeistSubject* _tmp79_;
	GPtrArray* _tmp80_;
	ZeitgeistEvent* _tmp81_;
	ZeitgeistEvent* _tmp82_;
	GPtrArray* _tmp83_;
	ZeitgeistEvent* _tmp84_;
	ZeitgeistEvent* _tmp85_;
	ZeitgeistResultSet* rs;
	ZeitgeistLog* _tmp86_;
	ZeitgeistTimeRange* _tmp87_;
	ZeitgeistTimeRange* _tmp88_;
	GPtrArray* _tmp89_;
	SynapseQuery _tmp90_;
	SynapseQuery _tmp91_;
	GCancellable* _tmp92_;
	ZeitgeistResultSet* _tmp93_;
	ZeitgeistResultSet* _tmp94_;
	SynapseResultSet* results;
	SynapseResultSet* _tmp95_;
	ZeitgeistResultSet* _tmp96_;
	SynapseQuery _tmp97_;
	GCancellable* _tmp98_;
	SynapseResultSet* _tmp99_;
	GError* err;
	GError* _tmp100_;
	const gchar* _tmp101_;
	GError* _inner_error0_;
};

struct _SynapseZeitgeistRelatedRelatedItem {
	SynapseSearchMatch parent_instance;
	SynapseZeitgeistRelatedRelatedItemPrivate * priv;
};

struct _SynapseZeitgeistRelatedRelatedItemClass {
	SynapseSearchMatchClass parent_class;
};

struct _SynapseZeitgeistRelatedRelatedItemPrivate {
	gint _default_relevancy;
	SynapseZeitgeistRelated* plugin;
};

struct _SynapseZeitgeistRelatedRelatedItemSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseZeitgeistRelatedRelatedItem* self;
	gchar* query;
	SynapseQueryFlags flags;
	SynapseResultSet* dest_result_set;
	GCancellable* cancellable;
	GeeList* result;
	SynapseQuery q;
	GCancellable* _tmp0_;
	SynapseResultSet* results;
	SynapseZeitgeistRelated* _tmp1_;
	SynapseQuery _tmp2_;
	SynapseMatch* _tmp3_;
	SynapseMatch* _tmp4_;
	SynapseResultSet* _tmp5_;
	GeeList* _tmp6_;
	GError* _inner_error0_;
};

static gint SynapseZeitgeistRelated_private_offset;
static gpointer synapse_zeitgeist_related_parent_class = NULL;
static gint SynapseZeitgeistRelatedRelatedItem_private_offset;
static gpointer synapse_zeitgeist_related_related_item_parent_class = NULL;
static SynapseActivatableIface * synapse_zeitgeist_related_synapse_activatable_parent_iface = NULL;
static SynapseActionProviderIface * synapse_zeitgeist_related_synapse_action_provider_parent_iface = NULL;

static GType synapse_zeitgeist_related_related_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void synapse_zeitgeist_related_real_activate (SynapseActivatable* base);
static void synapse_zeitgeist_related_real_deactivate (SynapseActivatable* base);
static void synapse_zeitgeist_related_register_plugin (void);
static void _synapse_zeitgeist_related_register_plugin_synapse_plugin_register_func (void);
static void synapse_zeitgeist_related_find_related_data_free (gpointer _data);
static gboolean synapse_zeitgeist_related_find_related_co (SynapseZeitgeistRelatedFindRelatedData* _data_);
static void _g_object_unref0_ (gpointer var);
static void synapse_zeitgeist_related_find_related_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static SynapseResultSet* synapse_zeitgeist_related_real_find_for_match (SynapseActionProvider* base,
                                                                 SynapseQuery* q,
                                                                 SynapseMatch* match);
static gint synapse_zeitgeist_related_related_item_get_default_relevancy (SynapseZeitgeistRelatedRelatedItem* self);
static void synapse_zeitgeist_related_related_item_real_search_data_free (gpointer _data);
static void synapse_zeitgeist_related_related_item_real_search (SynapseSearchMatch* base,
                                                         const gchar* query,
                                                         SynapseQueryFlags flags,
                                                         SynapseResultSet* dest_result_set,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static gboolean synapse_zeitgeist_related_related_item_real_search_co (SynapseZeitgeistRelatedRelatedItemSearchData* _data_);
static void synapse_zeitgeist_related_related_item_search_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static SynapseZeitgeistRelatedRelatedItem* synapse_zeitgeist_related_related_item_new (SynapseZeitgeistRelated* plugin);
static SynapseZeitgeistRelatedRelatedItem* synapse_zeitgeist_related_related_item_construct (GType object_type,
                                                                                      SynapseZeitgeistRelated* plugin);
static void synapse_zeitgeist_related_related_item_set_default_relevancy (SynapseZeitgeistRelatedRelatedItem* self,
                                                                   gint value);
static void synapse_zeitgeist_related_related_item_finalize (GObject * obj);
static GType synapse_zeitgeist_related_related_item_get_type_once (void);
static void _vala_synapse_zeitgeist_related_related_item_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_synapse_zeitgeist_related_related_item_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static GObject * synapse_zeitgeist_related_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void synapse_zeitgeist_related_finalize (GObject * obj);
static GType synapse_zeitgeist_related_get_type_once (void);
static void _vala_synapse_zeitgeist_related_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_synapse_zeitgeist_related_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synapse_zeitgeist_related_get_instance_private (SynapseZeitgeistRelated* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZeitgeistRelated_private_offset);
}

static void
synapse_zeitgeist_related_real_activate (SynapseActivatable* base)
{
	SynapseZeitgeistRelated * self;
#line 28 "zeitgeist-related.vala"
	self = (SynapseZeitgeistRelated*) base;
#line 345 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_real_deactivate (SynapseActivatable* base)
{
	SynapseZeitgeistRelated * self;
#line 33 "zeitgeist-related.vala"
	self = (SynapseZeitgeistRelated*) base;
#line 354 "zeitgeist-related.c"
}

static void
_synapse_zeitgeist_related_register_plugin_synapse_plugin_register_func (void)
{
#line 70 "zeitgeist-related.vala"
	synapse_zeitgeist_related_register_plugin ();
#line 362 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_register_plugin (void)
{
	SynapsePluginRegistry* _tmp0_;
	SynapsePluginRegistry* _tmp1_;
	SynapseDBusService* _tmp2_;
	SynapseDBusService* _tmp3_;
#line 70 "zeitgeist-related.vala"
	_tmp0_ = synapse_plugin_registry_get_default ();
#line 70 "zeitgeist-related.vala"
	_tmp1_ = _tmp0_;
#line 70 "zeitgeist-related.vala"
	_tmp2_ = synapse_dbus_service_get_default ();
#line 70 "zeitgeist-related.vala"
	_tmp3_ = _tmp2_;
#line 70 "zeitgeist-related.vala"
	synapse_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_ZEITGEIST_RELATED, _ ("Related files"), _ ("Finds files related to other search results using Zeitgeist."), "search", _synapse_zeitgeist_related_register_plugin_synapse_plugin_register_func, synapse_dbus_service_name_is_activatable (_tmp3_, "org.gnome.zeitgeist.Engine"), _ ("Zeitgeist is not installed"));
#line 70 "zeitgeist-related.vala"
	_g_object_unref0 (_tmp3_);
#line 70 "zeitgeist-related.vala"
	_g_object_unref0 (_tmp1_);
#line 386 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_find_related_data_free (gpointer _data)
{
	SynapseZeitgeistRelatedFindRelatedData* _data_;
	_data_ = _data;
#line 24 "zeitgeist-related.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->m);
#line 24 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->result);
#line 24 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->self);
#line 24 "zeitgeist-related.vala"
	g_slice_free (SynapseZeitgeistRelatedFindRelatedData, _data_);
#line 404 "zeitgeist-related.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 24 "zeitgeist-related.vala"
	return self ? g_object_ref (self) : NULL;
#line 412 "zeitgeist-related.c"
}

void
synapse_zeitgeist_related_find_related (SynapseZeitgeistRelated* self,
                                        SynapseQuery* q,
                                        SynapseMatch* m,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	SynapseZeitgeistRelatedFindRelatedData* _data_;
	SynapseZeitgeistRelated* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
	SynapseMatch* _tmp4_;
#line 24 "zeitgeist-related.vala"
	g_return_if_fail (self != NULL);
#line 24 "zeitgeist-related.vala"
	g_return_if_fail (q != NULL);
#line 24 "zeitgeist-related.vala"
	g_return_if_fail (m != NULL);
#line 24 "zeitgeist-related.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistRelatedFindRelatedData);
#line 24 "zeitgeist-related.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 24 "zeitgeist-related.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_related_find_related_data_free);
#line 24 "zeitgeist-related.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "zeitgeist-related.vala"
	_data_->self = _tmp0_;
#line 24 "zeitgeist-related.vala"
	_tmp1_ = *q;
#line 24 "zeitgeist-related.vala"
	_tmp2_ = _tmp1_;
#line 24 "zeitgeist-related.vala"
	synapse_query_copy (&_tmp2_, &_tmp3_);
#line 24 "zeitgeist-related.vala"
	synapse_query_destroy (&_data_->q);
#line 24 "zeitgeist-related.vala"
	_data_->q = _tmp3_;
#line 24 "zeitgeist-related.vala"
	_tmp4_ = _g_object_ref0 (m);
#line 24 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->m);
#line 24 "zeitgeist-related.vala"
	_data_->m = _tmp4_;
#line 24 "zeitgeist-related.vala"
	synapse_zeitgeist_related_find_related_co (_data_);
#line 462 "zeitgeist-related.c"
}

SynapseResultSet*
synapse_zeitgeist_related_find_related_finish (SynapseZeitgeistRelated* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	SynapseResultSet* result;
	SynapseZeitgeistRelatedFindRelatedData* _data_;
#line 24 "zeitgeist-related.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 24 "zeitgeist-related.vala"
	if (NULL == _data_) {
#line 24 "zeitgeist-related.vala"
		return NULL;
#line 478 "zeitgeist-related.c"
	}
#line 24 "zeitgeist-related.vala"
	result = _data_->result;
#line 24 "zeitgeist-related.vala"
	_data_->result = NULL;
#line 24 "zeitgeist-related.vala"
	return result;
#line 486 "zeitgeist-related.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 101 "zeitgeist-related.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 494 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_find_related_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	SynapseZeitgeistRelatedFindRelatedData* _data_;
#line 156 "zeitgeist-related.vala"
	_data_ = _user_data_;
#line 156 "zeitgeist-related.vala"
	_data_->_source_object_ = source_object;
#line 156 "zeitgeist-related.vala"
	_data_->_res_ = _res_;
#line 156 "zeitgeist-related.vala"
	synapse_zeitgeist_related_find_related_co (_data_);
#line 511 "zeitgeist-related.c"
}

static gboolean
synapse_zeitgeist_related_find_related_co (SynapseZeitgeistRelatedFindRelatedData* _data_)
{
#line 95 "zeitgeist-related.vala"
	switch (_data_->_state_) {
#line 95 "zeitgeist-related.vala"
		case 0:
#line 521 "zeitgeist-related.c"
		goto _state_0;
#line 95 "zeitgeist-related.vala"
		case 1:
#line 525 "zeitgeist-related.c"
		goto _state_1;
#line 95 "zeitgeist-related.vala"
		case 2:
#line 529 "zeitgeist-related.c"
		goto _state_2;
#line 95 "zeitgeist-related.vala"
		case 3:
#line 533 "zeitgeist-related.c"
		goto _state_3;
		default:
#line 95 "zeitgeist-related.vala"
		g_assert_not_reached ();
#line 538 "zeitgeist-related.c"
	}
	_state_0:
#line 99 "zeitgeist-related.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->m, SYNAPSE_TYPE_URI_MATCH)) {
#line 99 "zeitgeist-related.vala"
		_data_->_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->m, SYNAPSE_TYPE_APPLICATION_MATCH);
#line 545 "zeitgeist-related.c"
	} else {
#line 99 "zeitgeist-related.vala"
		_data_->_tmp0_ = FALSE;
#line 549 "zeitgeist-related.c"
	}
#line 99 "zeitgeist-related.vala"
	if (_data_->_tmp0_) {
#line 99 "zeitgeist-related.vala"
		_data_->result = NULL;
#line 99 "zeitgeist-related.vala"
		_g_object_unref0 (_data_->s);
#line 99 "zeitgeist-related.vala"
		_g_object_unref0 (_data_->e);
#line 99 "zeitgeist-related.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 99 "zeitgeist-related.vala"
		if (_data_->_state_ != 0) {
#line 99 "zeitgeist-related.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 99 "zeitgeist-related.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 567 "zeitgeist-related.c"
			}
		}
#line 99 "zeitgeist-related.vala"
		g_object_unref (_data_->_async_result);
#line 99 "zeitgeist-related.vala"
		return FALSE;
#line 574 "zeitgeist-related.c"
	}
#line 101 "zeitgeist-related.vala"
	_data_->_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 101 "zeitgeist-related.vala"
	_data_->templates = _data_->_tmp1_;
#line 102 "zeitgeist-related.vala"
	_data_->_tmp2_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 102 "zeitgeist-related.vala"
	_data_->event_templates = _data_->_tmp2_;
#line 103 "zeitgeist-related.vala"
	_data_->_tmp3_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 103 "zeitgeist-related.vala"
	_data_->result_templates = _data_->_tmp3_;
#line 105 "zeitgeist-related.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->m, SYNAPSE_TYPE_URI_MATCH)) {
#line 107 "zeitgeist-related.vala"
		_data_->um = G_TYPE_CHECK_INSTANCE_CAST (_data_->m, SYNAPSE_TYPE_URI_MATCH, SynapseUriMatch);
#line 108 "zeitgeist-related.vala"
		_data_->_tmp4_ = _data_->um;
#line 108 "zeitgeist-related.vala"
		_data_->_tmp5_ = synapse_uri_match_get_uri (_data_->_tmp4_);
#line 108 "zeitgeist-related.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 108 "zeitgeist-related.vala"
		g_debug ("zeitgeist-related.vala:108: searching for items related to %s", _data_->_tmp6_);
#line 110 "zeitgeist-related.vala"
		_data_->_tmp7_ = zeitgeist_subject_new ();
#line 110 "zeitgeist-related.vala"
		_g_object_unref0 (_data_->s);
#line 110 "zeitgeist-related.vala"
		_data_->s = _data_->_tmp7_;
#line 111 "zeitgeist-related.vala"
		_data_->_tmp8_ = _data_->s;
#line 111 "zeitgeist-related.vala"
		_data_->_tmp9_ = _data_->um;
#line 111 "zeitgeist-related.vala"
		_data_->_tmp10_ = synapse_uri_match_get_uri (_data_->_tmp9_);
#line 111 "zeitgeist-related.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 111 "zeitgeist-related.vala"
		zeitgeist_subject_set_uri (_data_->_tmp8_, _data_->_tmp11_);
#line 112 "zeitgeist-related.vala"
		_data_->_tmp12_ = zeitgeist_event_new ();
#line 112 "zeitgeist-related.vala"
		_g_object_unref0 (_data_->e);
#line 112 "zeitgeist-related.vala"
		_data_->e = _data_->_tmp12_;
#line 113 "zeitgeist-related.vala"
		_data_->_tmp13_ = _data_->e;
#line 113 "zeitgeist-related.vala"
		_data_->_tmp14_ = _data_->s;
#line 113 "zeitgeist-related.vala"
		zeitgeist_event_add_subject (_data_->_tmp13_, _data_->_tmp14_);
#line 628 "zeitgeist-related.c"
	} else {
#line 115 "zeitgeist-related.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->m, SYNAPSE_TYPE_APPLICATION_MATCH)) {
#line 117 "zeitgeist-related.vala"
			_data_->am = G_TYPE_CHECK_INSTANCE_CAST (_data_->m, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch);
#line 119 "zeitgeist-related.vala"
			_data_->_tmp15_ = _data_->am;
#line 119 "zeitgeist-related.vala"
			_data_->_tmp16_ = synapse_application_match_get_app_info (_data_->_tmp15_);
#line 119 "zeitgeist-related.vala"
			_data_->_tmp17_ = _data_->_tmp16_;
#line 119 "zeitgeist-related.vala"
			_data_->_tmp18_ = _g_object_ref0 (_data_->_tmp17_);
#line 119 "zeitgeist-related.vala"
			_data_->app_info = _data_->_tmp18_;
#line 120 "zeitgeist-related.vala"
			_data_->_tmp19_ = _data_->app_info;
#line 120 "zeitgeist-related.vala"
			if (_data_->_tmp19_ != NULL) {
#line 122 "zeitgeist-related.vala"
				_data_->_tmp21_ = _data_->app_info;
#line 122 "zeitgeist-related.vala"
				_data_->_tmp22_ = g_app_info_get_id (_data_->_tmp21_);
#line 122 "zeitgeist-related.vala"
				_data_->_tmp20_ = _data_->_tmp22_;
#line 122 "zeitgeist-related.vala"
				if (_data_->_tmp20_ == NULL) {
#line 122 "zeitgeist-related.vala"
					_data_->_tmp20_ = "";
#line 658 "zeitgeist-related.c"
				}
#line 122 "zeitgeist-related.vala"
				_data_->_tmp23_ = g_strdup (_data_->_tmp20_);
#line 122 "zeitgeist-related.vala"
				_g_free0 (_data_->app_id);
#line 122 "zeitgeist-related.vala"
				_data_->app_id = _data_->_tmp23_;
#line 123 "zeitgeist-related.vala"
				_data_->_tmp25_ = _data_->app_id;
#line 123 "zeitgeist-related.vala"
				if (g_strcmp0 (_data_->_tmp25_, "") == 0) {
#line 123 "zeitgeist-related.vala"
					_data_->_tmp26_ = _data_->app_info;
#line 123 "zeitgeist-related.vala"
					_data_->_tmp24_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp26_, G_TYPE_DESKTOP_APP_INFO);
#line 674 "zeitgeist-related.c"
				} else {
#line 123 "zeitgeist-related.vala"
					_data_->_tmp24_ = FALSE;
#line 678 "zeitgeist-related.c"
				}
#line 123 "zeitgeist-related.vala"
				if (_data_->_tmp24_) {
#line 125 "zeitgeist-related.vala"
					_data_->_tmp28_ = _data_->app_info;
#line 125 "zeitgeist-related.vala"
					_data_->_tmp29_ = g_desktop_app_info_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp28_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo));
#line 125 "zeitgeist-related.vala"
					_data_->_tmp27_ = _data_->_tmp29_;
#line 125 "zeitgeist-related.vala"
					if (_data_->_tmp27_ == NULL) {
#line 125 "zeitgeist-related.vala"
						_data_->_tmp27_ = "";
#line 692 "zeitgeist-related.c"
					}
#line 125 "zeitgeist-related.vala"
					_data_->_tmp30_ = g_strdup (_data_->_tmp27_);
#line 125 "zeitgeist-related.vala"
					_g_free0 (_data_->app_id);
#line 125 "zeitgeist-related.vala"
					_data_->app_id = _data_->_tmp30_;
#line 126 "zeitgeist-related.vala"
					_data_->_tmp31_ = _data_->app_id;
#line 126 "zeitgeist-related.vala"
					_data_->_tmp32_ = g_path_get_basename (_data_->_tmp31_);
#line 126 "zeitgeist-related.vala"
					_g_free0 (_data_->app_id);
#line 126 "zeitgeist-related.vala"
					_data_->app_id = _data_->_tmp32_;
#line 708 "zeitgeist-related.c"
				}
			} else {
#line 131 "zeitgeist-related.vala"
				_data_->_tmp33_ = _data_->am;
#line 131 "zeitgeist-related.vala"
				_data_->_tmp34_ = synapse_application_match_get_filename (_data_->_tmp33_);
#line 131 "zeitgeist-related.vala"
				_data_->_tmp35_ = _data_->_tmp34_;
#line 131 "zeitgeist-related.vala"
				_data_->_tmp36_ = g_path_get_basename (_data_->_tmp35_);
#line 131 "zeitgeist-related.vala"
				_g_free0 (_data_->app_id);
#line 131 "zeitgeist-related.vala"
				_data_->app_id = _data_->_tmp36_;
#line 723 "zeitgeist-related.c"
			}
#line 134 "zeitgeist-related.vala"
			_data_->_tmp38_ = _data_->app_id;
#line 134 "zeitgeist-related.vala"
			if (_data_->_tmp38_ == NULL) {
#line 134 "zeitgeist-related.vala"
				_data_->_tmp37_ = TRUE;
#line 731 "zeitgeist-related.c"
			} else {
#line 134 "zeitgeist-related.vala"
				_data_->_tmp39_ = _data_->app_id;
#line 134 "zeitgeist-related.vala"
				_data_->_tmp37_ = g_strcmp0 (_data_->_tmp39_, "") == 0;
#line 737 "zeitgeist-related.c"
			}
#line 134 "zeitgeist-related.vala"
			if (_data_->_tmp37_) {
#line 136 "zeitgeist-related.vala"
				g_warning ("zeitgeist-related.vala:136: Unable to extract application id!");
#line 137 "zeitgeist-related.vala"
				_data_->result = NULL;
#line 137 "zeitgeist-related.vala"
				_g_object_unref0 (_data_->app_info);
#line 137 "zeitgeist-related.vala"
				_g_free0 (_data_->app_id);
#line 137 "zeitgeist-related.vala"
				_g_ptr_array_unref0 (_data_->result_templates);
#line 137 "zeitgeist-related.vala"
				_g_ptr_array_unref0 (_data_->event_templates);
#line 137 "zeitgeist-related.vala"
				_g_ptr_array_unref0 (_data_->templates);
#line 137 "zeitgeist-related.vala"
				_g_object_unref0 (_data_->s);
#line 137 "zeitgeist-related.vala"
				_g_object_unref0 (_data_->e);
#line 137 "zeitgeist-related.vala"
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 137 "zeitgeist-related.vala"
				if (_data_->_state_ != 0) {
#line 137 "zeitgeist-related.vala"
					while (!g_task_get_completed (_data_->_async_result)) {
#line 137 "zeitgeist-related.vala"
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 767 "zeitgeist-related.c"
					}
				}
#line 137 "zeitgeist-related.vala"
				g_object_unref (_data_->_async_result);
#line 137 "zeitgeist-related.vala"
				return FALSE;
#line 774 "zeitgeist-related.c"
			}
#line 140 "zeitgeist-related.vala"
			_data_->_tmp40_ = _data_->app_id;
#line 140 "zeitgeist-related.vala"
			_data_->_tmp41_ = g_strconcat ("application://", _data_->_tmp40_, NULL);
#line 140 "zeitgeist-related.vala"
			_g_free0 (_data_->app_id);
#line 140 "zeitgeist-related.vala"
			_data_->app_id = _data_->_tmp41_;
#line 141 "zeitgeist-related.vala"
			_data_->_tmp42_ = _data_->app_id;
#line 141 "zeitgeist-related.vala"
			g_debug ("zeitgeist-related.vala:141: searching for items related to %s", _data_->_tmp42_);
#line 143 "zeitgeist-related.vala"
			_data_->_tmp43_ = zeitgeist_event_new ();
#line 143 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->e);
#line 143 "zeitgeist-related.vala"
			_data_->e = _data_->_tmp43_;
#line 144 "zeitgeist-related.vala"
			_data_->_tmp44_ = _data_->e;
#line 144 "zeitgeist-related.vala"
			_data_->_tmp45_ = _data_->app_id;
#line 144 "zeitgeist-related.vala"
			zeitgeist_event_set_actor (_data_->_tmp44_, _data_->_tmp45_);
#line 115 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->app_info);
#line 115 "zeitgeist-related.vala"
			_g_free0 (_data_->app_id);
#line 804 "zeitgeist-related.c"
		} else {
#line 146 "zeitgeist-related.vala"
			_data_->result = NULL;
#line 146 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->result_templates);
#line 146 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 146 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 146 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->s);
#line 146 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->e);
#line 146 "zeitgeist-related.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 146 "zeitgeist-related.vala"
			if (_data_->_state_ != 0) {
#line 146 "zeitgeist-related.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 146 "zeitgeist-related.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 826 "zeitgeist-related.c"
				}
			}
#line 146 "zeitgeist-related.vala"
			g_object_unref (_data_->_async_result);
#line 146 "zeitgeist-related.vala"
			return FALSE;
#line 833 "zeitgeist-related.c"
		}
	}
#line 148 "zeitgeist-related.vala"
	_data_->_tmp46_ = _data_->templates;
#line 148 "zeitgeist-related.vala"
	_data_->_tmp47_ = _data_->e;
#line 148 "zeitgeist-related.vala"
	_data_->_tmp48_ = _g_object_ref0 (_data_->_tmp47_);
#line 148 "zeitgeist-related.vala"
	g_ptr_array_add (_data_->_tmp46_, _data_->_tmp48_);
#line 149 "zeitgeist-related.vala"
	_data_->_tmp49_ = _data_->event_templates;
#line 149 "zeitgeist-related.vala"
	_data_->_tmp50_ = _data_->e;
#line 149 "zeitgeist-related.vala"
	_data_->_tmp51_ = _g_object_ref0 (_data_->_tmp50_);
#line 149 "zeitgeist-related.vala"
	g_ptr_array_add (_data_->_tmp49_, _data_->_tmp51_);
#line 852 "zeitgeist-related.c"
	{
#line 153 "zeitgeist-related.vala"
		_data_->uris_length1 = 0;
#line 153 "zeitgeist-related.vala"
		_data_->_uris_size_ = 0;
#line 154 "zeitgeist-related.vala"
		_data_->_tmp52_ = g_date_time_new_now_local ();
#line 154 "zeitgeist-related.vala"
		_data_->_tmp53_ = _data_->_tmp52_;
#line 154 "zeitgeist-related.vala"
		_data_->_tmp54_ = g_date_time_to_unix (_data_->_tmp53_) * 1000;
#line 154 "zeitgeist-related.vala"
		_g_date_time_unref0 (_data_->_tmp53_);
#line 154 "zeitgeist-related.vala"
		_data_->end = _data_->_tmp54_;
#line 155 "zeitgeist-related.vala"
		_data_->start = _data_->end - (ZEITGEIST_TIMESTAMP_WEEK * 8);
#line 156 "zeitgeist-related.vala"
		_data_->_tmp56_ = _data_->self->priv->zg_log;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp57_ = zeitgeist_time_range_new (_data_->start, _data_->end);
#line 156 "zeitgeist-related.vala"
		_data_->_tmp58_ = _data_->_tmp57_;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp59_ = _data_->event_templates;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp60_ = _data_->result_templates;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp61_ = _data_->q;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp62_ = _data_->q;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp63_ = _data_->_tmp62_.cancellable;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp64_ = 0;
#line 156 "zeitgeist-related.vala"
		_data_->_state_ = 1;
#line 156 "zeitgeist-related.vala"
		zeitgeist_log_find_related_uris (_data_->_tmp56_, _data_->_tmp58_, _data_->_tmp59_, _data_->_tmp60_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) _data_->_tmp61_.max_results, ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT, _data_->_tmp63_, synapse_zeitgeist_related_find_related_ready, _data_);
#line 156 "zeitgeist-related.vala"
		return FALSE;
#line 894 "zeitgeist-related.c"
		_state_1:
#line 156 "zeitgeist-related.vala"
		_data_->_tmp65_ = zeitgeist_log_find_related_uris_finish (_data_->_tmp56_, _data_->_res_, &_data_->_tmp64_, &_data_->_inner_error0_);
#line 156 "zeitgeist-related.vala"
		_data_->_tmp66_ = _data_->_tmp65_;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp66__length1 = _data_->_tmp64_;
#line 156 "zeitgeist-related.vala"
		_g_object_unref0 (_data_->_tmp58_);
#line 156 "zeitgeist-related.vala"
		_data_->_tmp55_ = _data_->_tmp66_;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp55__length1 = _data_->_tmp66__length1;
#line 156 "zeitgeist-related.vala"
		_data_->__tmp55__size_ = _data_->_tmp55__length1;
#line 156 "zeitgeist-related.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 156 "zeitgeist-related.vala"
			_data_->uris = (_vala_array_free (_data_->uris, _data_->uris_length1, (GDestroyNotify) g_free), NULL);
#line 914 "zeitgeist-related.c"
			goto __catch0_g_error;
		}
#line 156 "zeitgeist-related.vala"
		_data_->_tmp67_ = _data_->_tmp55_;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp67__length1 = _data_->_tmp55__length1;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp55_ = NULL;
#line 156 "zeitgeist-related.vala"
		_data_->_tmp55__length1 = 0;
#line 156 "zeitgeist-related.vala"
		_data_->uris = (_vala_array_free (_data_->uris, _data_->uris_length1, (GDestroyNotify) g_free), NULL);
#line 156 "zeitgeist-related.vala"
		_data_->uris = _data_->_tmp67_;
#line 156 "zeitgeist-related.vala"
		_data_->uris_length1 = _data_->_tmp67__length1;
#line 156 "zeitgeist-related.vala"
		_data_->_uris_size_ = _data_->uris_length1;
#line 161 "zeitgeist-related.vala"
		_data_->_tmp69_ = _data_->uris;
#line 161 "zeitgeist-related.vala"
		_data_->_tmp69__length1 = _data_->uris_length1;
#line 161 "zeitgeist-related.vala"
		if (_data_->_tmp69_ == NULL) {
#line 161 "zeitgeist-related.vala"
			_data_->_tmp68_ = TRUE;
#line 941 "zeitgeist-related.c"
		} else {
#line 161 "zeitgeist-related.vala"
			_data_->_tmp70_ = _data_->uris;
#line 161 "zeitgeist-related.vala"
			_data_->_tmp70__length1 = _data_->uris_length1;
#line 161 "zeitgeist-related.vala"
			_data_->_tmp68_ = _data_->_tmp70__length1 == 0;
#line 949 "zeitgeist-related.c"
		}
#line 161 "zeitgeist-related.vala"
		if (_data_->_tmp68_) {
#line 163 "zeitgeist-related.vala"
			synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 163 "zeitgeist-related.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 163 "zeitgeist-related.vala"
				_data_->_tmp55_ = (_vala_array_free (_data_->_tmp55_, _data_->_tmp55__length1, (GDestroyNotify) g_free), NULL);
#line 163 "zeitgeist-related.vala"
				_data_->uris = (_vala_array_free (_data_->uris, _data_->uris_length1, (GDestroyNotify) g_free), NULL);
#line 961 "zeitgeist-related.c"
				goto __catch0_g_error;
			}
#line 164 "zeitgeist-related.vala"
			_data_->result = NULL;
#line 164 "zeitgeist-related.vala"
			_data_->_tmp55_ = (_vala_array_free (_data_->_tmp55_, _data_->_tmp55__length1, (GDestroyNotify) g_free), NULL);
#line 164 "zeitgeist-related.vala"
			_data_->uris = (_vala_array_free (_data_->uris, _data_->uris_length1, (GDestroyNotify) g_free), NULL);
#line 164 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->result_templates);
#line 164 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 164 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 164 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->s);
#line 164 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->e);
#line 164 "zeitgeist-related.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 164 "zeitgeist-related.vala"
			if (_data_->_state_ != 0) {
#line 164 "zeitgeist-related.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 164 "zeitgeist-related.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 988 "zeitgeist-related.c"
				}
			}
#line 164 "zeitgeist-related.vala"
			g_object_unref (_data_->_async_result);
#line 164 "zeitgeist-related.vala"
			return FALSE;
#line 995 "zeitgeist-related.c"
		}
#line 167 "zeitgeist-related.vala"
		_data_->_tmp71_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 167 "zeitgeist-related.vala"
		_g_ptr_array_unref0 (_data_->templates);
#line 167 "zeitgeist-related.vala"
		_data_->templates = _data_->_tmp71_;
#line 168 "zeitgeist-related.vala"
		_data_->_tmp72_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 168 "zeitgeist-related.vala"
		_g_ptr_array_unref0 (_data_->event_templates);
#line 168 "zeitgeist-related.vala"
		_data_->event_templates = _data_->_tmp72_;
#line 170 "zeitgeist-related.vala"
		_data_->_tmp73_ = _data_->uris;
#line 170 "zeitgeist-related.vala"
		_data_->_tmp73__length1 = _data_->uris_length1;
#line 1013 "zeitgeist-related.c"
		{
#line 170 "zeitgeist-related.vala"
			_data_->uri_collection_length1 = 0;
#line 170 "zeitgeist-related.vala"
			_data_->_uri_collection_size_ = 0;
#line 170 "zeitgeist-related.vala"
			_data_->uri_collection = _data_->_tmp73_;
#line 170 "zeitgeist-related.vala"
			_data_->uri_collection_length1 = _data_->_tmp73__length1;
#line 170 "zeitgeist-related.vala"
			for (_data_->uri_it = 0; _data_->uri_it < _data_->uri_collection_length1; _data_->uri_it = _data_->uri_it + 1) {
#line 170 "zeitgeist-related.vala"
				_data_->uri = _data_->uri_collection[_data_->uri_it];
#line 1027 "zeitgeist-related.c"
				{
#line 172 "zeitgeist-related.vala"
					_data_->_tmp74_ = zeitgeist_subject_new ();
#line 172 "zeitgeist-related.vala"
					_g_object_unref0 (_data_->s);
#line 172 "zeitgeist-related.vala"
					_data_->s = _data_->_tmp74_;
#line 173 "zeitgeist-related.vala"
					_data_->_tmp75_ = _data_->s;
#line 173 "zeitgeist-related.vala"
					_data_->_tmp76_ = _data_->uri;
#line 173 "zeitgeist-related.vala"
					zeitgeist_subject_set_uri (_data_->_tmp75_, _data_->_tmp76_);
#line 174 "zeitgeist-related.vala"
					_data_->_tmp77_ = zeitgeist_event_new ();
#line 174 "zeitgeist-related.vala"
					_g_object_unref0 (_data_->e);
#line 174 "zeitgeist-related.vala"
					_data_->e = _data_->_tmp77_;
#line 175 "zeitgeist-related.vala"
					_data_->_tmp78_ = _data_->e;
#line 175 "zeitgeist-related.vala"
					_data_->_tmp79_ = _data_->s;
#line 175 "zeitgeist-related.vala"
					zeitgeist_event_add_subject (_data_->_tmp78_, _data_->_tmp79_);
#line 177 "zeitgeist-related.vala"
					_data_->_tmp80_ = _data_->event_templates;
#line 177 "zeitgeist-related.vala"
					_data_->_tmp81_ = _data_->e;
#line 177 "zeitgeist-related.vala"
					_data_->_tmp82_ = _g_object_ref0 (_data_->_tmp81_);
#line 177 "zeitgeist-related.vala"
					g_ptr_array_add (_data_->_tmp80_, _data_->_tmp82_);
#line 178 "zeitgeist-related.vala"
					_data_->_tmp83_ = _data_->templates;
#line 178 "zeitgeist-related.vala"
					_data_->_tmp84_ = _data_->e;
#line 178 "zeitgeist-related.vala"
					_data_->_tmp85_ = _g_object_ref0 (_data_->_tmp84_);
#line 178 "zeitgeist-related.vala"
					g_ptr_array_add (_data_->_tmp83_, _data_->_tmp85_);
#line 1069 "zeitgeist-related.c"
				}
			}
		}
#line 181 "zeitgeist-related.vala"
		_data_->_tmp86_ = _data_->self->priv->zg_log;
#line 181 "zeitgeist-related.vala"
		_data_->_tmp87_ = zeitgeist_time_range_new_anytime ();
#line 181 "zeitgeist-related.vala"
		_data_->_tmp88_ = _data_->_tmp87_;
#line 181 "zeitgeist-related.vala"
		_data_->_tmp89_ = _data_->event_templates;
#line 181 "zeitgeist-related.vala"
		_data_->_tmp90_ = _data_->q;
#line 181 "zeitgeist-related.vala"
		_data_->_tmp91_ = _data_->q;
#line 181 "zeitgeist-related.vala"
		_data_->_tmp92_ = _data_->_tmp91_.cancellable;
#line 181 "zeitgeist-related.vala"
		_data_->_state_ = 2;
#line 181 "zeitgeist-related.vala"
		zeitgeist_log_find_events (_data_->_tmp86_, _data_->_tmp88_, _data_->_tmp89_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) _data_->_tmp90_.max_results, ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, _data_->_tmp92_, synapse_zeitgeist_related_find_related_ready, _data_);
#line 181 "zeitgeist-related.vala"
		return FALSE;
#line 1093 "zeitgeist-related.c"
		_state_2:
#line 181 "zeitgeist-related.vala"
		_data_->_tmp93_ = zeitgeist_log_find_events_finish (_data_->_tmp86_, _data_->_res_, &_data_->_inner_error0_);
#line 181 "zeitgeist-related.vala"
		_data_->_tmp94_ = _data_->_tmp93_;
#line 181 "zeitgeist-related.vala"
		_g_object_unref0 (_data_->_tmp88_);
#line 181 "zeitgeist-related.vala"
		_data_->rs = _data_->_tmp94_;
#line 181 "zeitgeist-related.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 181 "zeitgeist-related.vala"
			_data_->_tmp55_ = (_vala_array_free (_data_->_tmp55_, _data_->_tmp55__length1, (GDestroyNotify) g_free), NULL);
#line 181 "zeitgeist-related.vala"
			_data_->uris = (_vala_array_free (_data_->uris, _data_->uris_length1, (GDestroyNotify) g_free), NULL);
#line 1109 "zeitgeist-related.c"
			goto __catch0_g_error;
		}
#line 188 "zeitgeist-related.vala"
		_data_->_tmp95_ = synapse_result_set_new ();
#line 188 "zeitgeist-related.vala"
		_data_->results = _data_->_tmp95_;
#line 189 "zeitgeist-related.vala"
		_data_->_tmp96_ = _data_->rs;
#line 189 "zeitgeist-related.vala"
		_data_->_tmp97_ = _data_->q;
#line 189 "zeitgeist-related.vala"
		_data_->_tmp98_ = _data_->_tmp97_.cancellable;
#line 189 "zeitgeist-related.vala"
		_data_->_tmp99_ = _data_->results;
#line 189 "zeitgeist-related.vala"
		_data_->_state_ = 3;
#line 189 "zeitgeist-related.vala"
		synapse_zeitgeist_plugin_process_results ("", _data_->_tmp96_, _data_->_tmp98_, _data_->_tmp99_, FALSE, FALSE, synapse_zeitgeist_related_find_related_ready, _data_);
#line 189 "zeitgeist-related.vala"
		return FALSE;
#line 1130 "zeitgeist-related.c"
		_state_3:
#line 189 "zeitgeist-related.vala"
		synapse_zeitgeist_plugin_process_results_finish (_data_->_res_);
#line 192 "zeitgeist-related.vala"
		_data_->result = _data_->results;
#line 192 "zeitgeist-related.vala"
		_g_object_unref0 (_data_->rs);
#line 192 "zeitgeist-related.vala"
		_data_->_tmp55_ = (_vala_array_free (_data_->_tmp55_, _data_->_tmp55__length1, (GDestroyNotify) g_free), NULL);
#line 192 "zeitgeist-related.vala"
		_data_->uris = (_vala_array_free (_data_->uris, _data_->uris_length1, (GDestroyNotify) g_free), NULL);
#line 192 "zeitgeist-related.vala"
		_g_ptr_array_unref0 (_data_->result_templates);
#line 192 "zeitgeist-related.vala"
		_g_ptr_array_unref0 (_data_->event_templates);
#line 192 "zeitgeist-related.vala"
		_g_ptr_array_unref0 (_data_->templates);
#line 192 "zeitgeist-related.vala"
		_g_object_unref0 (_data_->s);
#line 192 "zeitgeist-related.vala"
		_g_object_unref0 (_data_->e);
#line 192 "zeitgeist-related.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 192 "zeitgeist-related.vala"
		if (_data_->_state_ != 0) {
#line 192 "zeitgeist-related.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 192 "zeitgeist-related.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1160 "zeitgeist-related.c"
			}
		}
#line 192 "zeitgeist-related.vala"
		g_object_unref (_data_->_async_result);
#line 192 "zeitgeist-related.vala"
		return FALSE;
#line 1167 "zeitgeist-related.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 151 "zeitgeist-related.vala"
		_data_->err = _data_->_inner_error0_;
#line 151 "zeitgeist-related.vala"
		_data_->_inner_error0_ = NULL;
#line 196 "zeitgeist-related.vala"
		_data_->_tmp100_ = _data_->err;
#line 196 "zeitgeist-related.vala"
		_data_->_tmp101_ = _data_->_tmp100_->message;
#line 196 "zeitgeist-related.vala"
		g_warning ("zeitgeist-related.vala:196: %s", _data_->_tmp101_);
#line 151 "zeitgeist-related.vala"
		_g_error_free0 (_data_->err);
#line 1184 "zeitgeist-related.c"
	}
	__finally0:
#line 151 "zeitgeist-related.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 151 "zeitgeist-related.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 151 "zeitgeist-related.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 151 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->result_templates);
#line 151 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 151 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 151 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->s);
#line 151 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->e);
#line 151 "zeitgeist-related.vala"
			g_object_unref (_data_->_async_result);
#line 151 "zeitgeist-related.vala"
			return FALSE;
#line 1207 "zeitgeist-related.c"
		} else {
#line 151 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->result_templates);
#line 151 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 151 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 151 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->s);
#line 151 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->e);
#line 151 "zeitgeist-related.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 151 "zeitgeist-related.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 151 "zeitgeist-related.vala"
			g_object_unref (_data_->_async_result);
#line 151 "zeitgeist-related.vala"
			return FALSE;
#line 1227 "zeitgeist-related.c"
		}
	}
#line 199 "zeitgeist-related.vala"
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
#line 199 "zeitgeist-related.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 199 "zeitgeist-related.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 199 "zeitgeist-related.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 199 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->result_templates);
#line 199 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 199 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 199 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->s);
#line 199 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->e);
#line 199 "zeitgeist-related.vala"
			g_object_unref (_data_->_async_result);
#line 199 "zeitgeist-related.vala"
			return FALSE;
#line 1252 "zeitgeist-related.c"
		} else {
#line 199 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->result_templates);
#line 199 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->event_templates);
#line 199 "zeitgeist-related.vala"
			_g_ptr_array_unref0 (_data_->templates);
#line 199 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->s);
#line 199 "zeitgeist-related.vala"
			_g_object_unref0 (_data_->e);
#line 199 "zeitgeist-related.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 199 "zeitgeist-related.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 199 "zeitgeist-related.vala"
			g_object_unref (_data_->_async_result);
#line 199 "zeitgeist-related.vala"
			return FALSE;
#line 1272 "zeitgeist-related.c"
		}
	}
#line 201 "zeitgeist-related.vala"
	_data_->result = NULL;
#line 201 "zeitgeist-related.vala"
	_g_ptr_array_unref0 (_data_->result_templates);
#line 201 "zeitgeist-related.vala"
	_g_ptr_array_unref0 (_data_->event_templates);
#line 201 "zeitgeist-related.vala"
	_g_ptr_array_unref0 (_data_->templates);
#line 201 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->s);
#line 201 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->e);
#line 201 "zeitgeist-related.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 201 "zeitgeist-related.vala"
	if (_data_->_state_ != 0) {
#line 201 "zeitgeist-related.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 201 "zeitgeist-related.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1295 "zeitgeist-related.c"
		}
	}
#line 201 "zeitgeist-related.vala"
	g_object_unref (_data_->_async_result);
#line 201 "zeitgeist-related.vala"
	return FALSE;
#line 1302 "zeitgeist-related.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 1323 "zeitgeist-related.c"
}

static SynapseResultSet*
synapse_zeitgeist_related_real_find_for_match (SynapseActionProvider* base,
                                               SynapseQuery* q,
                                               SynapseMatch* match)
{
	SynapseZeitgeistRelated * self;
	SynapseQuery _tmp0_;
	gboolean _tmp1_ = FALSE;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean query_empty = FALSE;
	SynapseQuery _tmp5_;
	const gchar* _tmp6_;
	SynapseResultSet* results = NULL;
	SynapseResultSet* _tmp7_;
	SynapseResultSet* result;
#line 204 "zeitgeist-related.vala"
	self = (SynapseZeitgeistRelated*) base;
#line 204 "zeitgeist-related.vala"
	g_return_val_if_fail (q != NULL, NULL);
#line 204 "zeitgeist-related.vala"
	g_return_val_if_fail (match != NULL, NULL);
#line 212 "zeitgeist-related.vala"
	_tmp0_ = *q;
#line 212 "zeitgeist-related.vala"
	if (_tmp0_.query_type == SYNAPSE_QUERY_FLAGS_ACTIONS) {
#line 212 "zeitgeist-related.vala"
		result = NULL;
#line 212 "zeitgeist-related.vala"
		return result;
#line 1357 "zeitgeist-related.c"
	}
#line 213 "zeitgeist-related.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_URI_MATCH)) {
#line 213 "zeitgeist-related.vala"
		_tmp1_ = TRUE;
#line 1363 "zeitgeist-related.c"
	} else {
#line 213 "zeitgeist-related.vala"
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (match, SYNAPSE_TYPE_APPLICATION_MATCH);
#line 1367 "zeitgeist-related.c"
	}
#line 213 "zeitgeist-related.vala"
	if (!_tmp1_) {
#line 213 "zeitgeist-related.vala"
		result = NULL;
#line 213 "zeitgeist-related.vala"
		return result;
#line 1375 "zeitgeist-related.c"
	}
#line 216 "zeitgeist-related.vala"
	_tmp2_ = *q;
#line 216 "zeitgeist-related.vala"
	_tmp3_ = _tmp2_.query_string;
#line 216 "zeitgeist-related.vala"
	_tmp4_ = string_strip (_tmp3_);
#line 216 "zeitgeist-related.vala"
	_g_free0 ((*q).query_string);
#line 216 "zeitgeist-related.vala"
	(*q).query_string = _tmp4_;
#line 217 "zeitgeist-related.vala"
	_tmp5_ = *q;
#line 217 "zeitgeist-related.vala"
	_tmp6_ = _tmp5_.query_string;
#line 217 "zeitgeist-related.vala"
	query_empty = g_strcmp0 (_tmp6_, "") == 0;
#line 218 "zeitgeist-related.vala"
	_tmp7_ = synapse_result_set_new ();
#line 218 "zeitgeist-related.vala"
	results = _tmp7_;
#line 220 "zeitgeist-related.vala"
	if (query_empty) {
#line 1399 "zeitgeist-related.c"
		SynapseResultSet* _tmp8_;
		SynapseZeitgeistRelatedRelatedItem* _tmp9_;
		SynapseZeitgeistRelatedRelatedItem* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 222 "zeitgeist-related.vala"
		_tmp8_ = results;
#line 222 "zeitgeist-related.vala"
		_tmp9_ = self->priv->action;
#line 222 "zeitgeist-related.vala"
		_tmp10_ = self->priv->action;
#line 222 "zeitgeist-related.vala"
		_tmp11_ = synapse_zeitgeist_related_related_item_get_default_relevancy (_tmp10_);
#line 222 "zeitgeist-related.vala"
		_tmp12_ = _tmp11_;
#line 222 "zeitgeist-related.vala"
		synapse_result_set_add (_tmp8_, (SynapseMatch*) _tmp9_, _tmp12_);
#line 1417 "zeitgeist-related.c"
	} else {
		GeeList* matchers = NULL;
		SynapseQuery _tmp13_;
		const gchar* _tmp14_;
		GeeList* _tmp15_;
#line 226 "zeitgeist-related.vala"
		_tmp13_ = *q;
#line 226 "zeitgeist-related.vala"
		_tmp14_ = _tmp13_.query_string;
#line 226 "zeitgeist-related.vala"
		_tmp15_ = synapse_query_get_matchers_for_query (_tmp14_, 0, G_REGEX_CASELESS);
#line 226 "zeitgeist-related.vala"
		matchers = _tmp15_;
#line 1431 "zeitgeist-related.c"
		{
			GeeList* _matcher_list = NULL;
			GeeList* _tmp16_;
			gint _matcher_size = 0;
			GeeList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _matcher_index = 0;
#line 228 "zeitgeist-related.vala"
			_tmp16_ = matchers;
#line 228 "zeitgeist-related.vala"
			_matcher_list = _tmp16_;
#line 228 "zeitgeist-related.vala"
			_tmp17_ = _matcher_list;
#line 228 "zeitgeist-related.vala"
			_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
#line 228 "zeitgeist-related.vala"
			_tmp19_ = _tmp18_;
#line 228 "zeitgeist-related.vala"
			_matcher_size = _tmp19_;
#line 228 "zeitgeist-related.vala"
			_matcher_index = -1;
#line 228 "zeitgeist-related.vala"
			while (TRUE) {
#line 1456 "zeitgeist-related.c"
				gint _tmp20_;
				gint _tmp21_;
				GeeMapEntry* matcher = NULL;
				GeeList* _tmp22_;
				gpointer _tmp23_;
				GeeMapEntry* _tmp24_;
				gconstpointer _tmp25_;
				gconstpointer _tmp26_;
				SynapseZeitgeistRelatedRelatedItem* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
#line 228 "zeitgeist-related.vala"
				_matcher_index = _matcher_index + 1;
#line 228 "zeitgeist-related.vala"
				_tmp20_ = _matcher_index;
#line 228 "zeitgeist-related.vala"
				_tmp21_ = _matcher_size;
#line 228 "zeitgeist-related.vala"
				if (!(_tmp20_ < _tmp21_)) {
#line 228 "zeitgeist-related.vala"
					break;
#line 1478 "zeitgeist-related.c"
				}
#line 228 "zeitgeist-related.vala"
				_tmp22_ = _matcher_list;
#line 228 "zeitgeist-related.vala"
				_tmp23_ = gee_list_get (_tmp22_, _matcher_index);
#line 228 "zeitgeist-related.vala"
				matcher = (GeeMapEntry*) _tmp23_;
#line 230 "zeitgeist-related.vala"
				_tmp24_ = matcher;
#line 230 "zeitgeist-related.vala"
				_tmp25_ = gee_map_entry_get_key (_tmp24_);
#line 230 "zeitgeist-related.vala"
				_tmp26_ = _tmp25_;
#line 230 "zeitgeist-related.vala"
				_tmp27_ = self->priv->action;
#line 230 "zeitgeist-related.vala"
				_tmp28_ = synapse_match_get_title ((SynapseMatch*) _tmp27_);
#line 230 "zeitgeist-related.vala"
				_tmp29_ = _tmp28_;
#line 230 "zeitgeist-related.vala"
				if (g_regex_match ((GRegex*) _tmp26_, _tmp29_, 0, NULL)) {
#line 1500 "zeitgeist-related.c"
					SynapseResultSet* _tmp30_;
					SynapseZeitgeistRelatedRelatedItem* _tmp31_;
					GeeMapEntry* _tmp32_;
					gconstpointer _tmp33_;
					gconstpointer _tmp34_;
#line 232 "zeitgeist-related.vala"
					_tmp30_ = results;
#line 232 "zeitgeist-related.vala"
					_tmp31_ = self->priv->action;
#line 232 "zeitgeist-related.vala"
					_tmp32_ = matcher;
#line 232 "zeitgeist-related.vala"
					_tmp33_ = gee_map_entry_get_value (_tmp32_);
#line 232 "zeitgeist-related.vala"
					_tmp34_ = _tmp33_;
#line 232 "zeitgeist-related.vala"
					synapse_result_set_add (_tmp30_, (SynapseMatch*) _tmp31_, (gint) ((gintptr) _tmp34_));
#line 233 "zeitgeist-related.vala"
					_g_object_unref0 (matcher);
#line 233 "zeitgeist-related.vala"
					break;
#line 1522 "zeitgeist-related.c"
				}
#line 228 "zeitgeist-related.vala"
				_g_object_unref0 (matcher);
#line 1526 "zeitgeist-related.c"
			}
		}
#line 220 "zeitgeist-related.vala"
		_g_object_unref0 (matchers);
#line 1531 "zeitgeist-related.c"
	}
#line 238 "zeitgeist-related.vala"
	result = results;
#line 238 "zeitgeist-related.vala"
	return result;
#line 1537 "zeitgeist-related.c"
}

SynapseZeitgeistRelated*
synapse_zeitgeist_related_construct (GType object_type)
{
	SynapseZeitgeistRelated * self = NULL;
#line 24 "zeitgeist-related.vala"
	self = (SynapseZeitgeistRelated*) g_object_new (object_type, NULL);
#line 24 "zeitgeist-related.vala"
	return self;
#line 1548 "zeitgeist-related.c"
}

SynapseZeitgeistRelated*
synapse_zeitgeist_related_new (void)
{
#line 24 "zeitgeist-related.vala"
	return synapse_zeitgeist_related_construct (SYNAPSE_TYPE_ZEITGEIST_RELATED);
#line 1556 "zeitgeist-related.c"
}

static gboolean
synapse_zeitgeist_related_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseZeitgeistRelated* self;
#line 26 "zeitgeist-related.vala"
	self = (SynapseZeitgeistRelated*) base;
#line 26 "zeitgeist-related.vala"
	result = self->priv->_enabled;
#line 26 "zeitgeist-related.vala"
	return result;
#line 1570 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_real_set_enabled (SynapseActivatable* base,
                                            gboolean value)
{
	SynapseZeitgeistRelated* self;
	gboolean old_value;
#line 26 "zeitgeist-related.vala"
	self = (SynapseZeitgeistRelated*) base;
#line 26 "zeitgeist-related.vala"
	old_value = synapse_zeitgeist_related_real_get_enabled (base);
#line 26 "zeitgeist-related.vala"
	if (old_value != value) {
#line 26 "zeitgeist-related.vala"
		self->priv->_enabled = value;
#line 26 "zeitgeist-related.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_zeitgeist_related_properties[SYNAPSE_ZEITGEIST_RELATED_ENABLED_PROPERTY]);
#line 1589 "zeitgeist-related.c"
	}
}

static inline gpointer
synapse_zeitgeist_related_related_item_get_instance_private (SynapseZeitgeistRelatedRelatedItem* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseZeitgeistRelatedRelatedItem_private_offset);
}

static void
synapse_zeitgeist_related_related_item_real_search_data_free (gpointer _data)
{
	SynapseZeitgeistRelatedRelatedItemSearchData* _data_;
	_data_ = _data;
#line 38 "zeitgeist-related.vala"
	_g_free0 (_data_->query);
#line 38 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->dest_result_set);
#line 38 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->cancellable);
#line 38 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->result);
#line 38 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->self);
#line 38 "zeitgeist-related.vala"
	g_slice_free (SynapseZeitgeistRelatedRelatedItemSearchData, _data_);
#line 1616 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_related_item_real_search (SynapseSearchMatch* base,
                                                    const gchar* query,
                                                    SynapseQueryFlags flags,
                                                    SynapseResultSet* dest_result_set,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	SynapseZeitgeistRelatedRelatedItem * self;
	SynapseZeitgeistRelatedRelatedItemSearchData* _data_;
	SynapseZeitgeistRelatedRelatedItem* _tmp0_;
	gchar* _tmp1_;
	SynapseResultSet* _tmp2_;
	GCancellable* _tmp3_;
#line 38 "zeitgeist-related.vala"
	g_return_if_fail (query != NULL);
#line 38 "zeitgeist-related.vala"
	self = (SynapseZeitgeistRelatedRelatedItem*) base;
#line 38 "zeitgeist-related.vala"
	_data_ = g_slice_new0 (SynapseZeitgeistRelatedRelatedItemSearchData);
#line 38 "zeitgeist-related.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 38 "zeitgeist-related.vala"
	g_task_set_task_data (_data_->_async_result, _data_, synapse_zeitgeist_related_related_item_real_search_data_free);
#line 38 "zeitgeist-related.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 38 "zeitgeist-related.vala"
	_data_->self = _tmp0_;
#line 38 "zeitgeist-related.vala"
	_tmp1_ = g_strdup (query);
#line 38 "zeitgeist-related.vala"
	_g_free0 (_data_->query);
#line 38 "zeitgeist-related.vala"
	_data_->query = _tmp1_;
#line 38 "zeitgeist-related.vala"
	_data_->flags = flags;
#line 38 "zeitgeist-related.vala"
	_tmp2_ = _g_object_ref0 (dest_result_set);
#line 38 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->dest_result_set);
#line 38 "zeitgeist-related.vala"
	_data_->dest_result_set = _tmp2_;
#line 38 "zeitgeist-related.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 38 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->cancellable);
#line 38 "zeitgeist-related.vala"
	_data_->cancellable = _tmp3_;
#line 38 "zeitgeist-related.vala"
	synapse_zeitgeist_related_related_item_real_search_co (_data_);
#line 1670 "zeitgeist-related.c"
}

static GeeList*
synapse_zeitgeist_related_related_item_search_finish (SynapseSearchMatch* base,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	GeeList* result;
	SynapseZeitgeistRelatedRelatedItemSearchData* _data_;
#line 38 "zeitgeist-related.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 38 "zeitgeist-related.vala"
	if (NULL == _data_) {
#line 38 "zeitgeist-related.vala"
		return NULL;
#line 1686 "zeitgeist-related.c"
	}
#line 38 "zeitgeist-related.vala"
	result = _data_->result;
#line 38 "zeitgeist-related.vala"
	_data_->result = NULL;
#line 38 "zeitgeist-related.vala"
	return result;
#line 1694 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_related_item_search_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	SynapseZeitgeistRelatedRelatedItemSearchData* _data_;
#line 50 "zeitgeist-related.vala"
	_data_ = _user_data_;
#line 50 "zeitgeist-related.vala"
	_data_->_source_object_ = source_object;
#line 50 "zeitgeist-related.vala"
	_data_->_res_ = _res_;
#line 50 "zeitgeist-related.vala"
	synapse_zeitgeist_related_related_item_real_search_co (_data_);
#line 1711 "zeitgeist-related.c"
}

static gboolean
synapse_zeitgeist_related_related_item_real_search_co (SynapseZeitgeistRelatedRelatedItemSearchData* _data_)
{
#line 43 "zeitgeist-related.vala"
	switch (_data_->_state_) {
#line 43 "zeitgeist-related.vala"
		case 0:
#line 1721 "zeitgeist-related.c"
		goto _state_0;
#line 43 "zeitgeist-related.vala"
		case 1:
#line 1725 "zeitgeist-related.c"
		goto _state_1;
		default:
#line 43 "zeitgeist-related.vala"
		g_assert_not_reached ();
#line 1730 "zeitgeist-related.c"
	}
	_state_0:
#line 48 "zeitgeist-related.vala"
	synapse_query_init (&_data_->q, (guint) 0, _data_->query, _data_->flags, (guint) 96);
#line 49 "zeitgeist-related.vala"
	_data_->_tmp0_ = _g_object_ref0 (_data_->cancellable);
#line 49 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->q.cancellable);
#line 49 "zeitgeist-related.vala"
	_data_->q.cancellable = _data_->_tmp0_;
#line 50 "zeitgeist-related.vala"
	_data_->_tmp1_ = _data_->self->priv->plugin;
#line 50 "zeitgeist-related.vala"
	_data_->_tmp2_ = _data_->q;
#line 50 "zeitgeist-related.vala"
	_data_->_tmp3_ = synapse_search_match_get_search_source ((SynapseSearchMatch*) _data_->self);
#line 50 "zeitgeist-related.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 50 "zeitgeist-related.vala"
	_data_->_state_ = 1;
#line 50 "zeitgeist-related.vala"
	synapse_zeitgeist_related_find_related (_data_->_tmp1_, &_data_->_tmp2_, _data_->_tmp4_, synapse_zeitgeist_related_related_item_search_ready, _data_);
#line 50 "zeitgeist-related.vala"
	return FALSE;
#line 1755 "zeitgeist-related.c"
	_state_1:
#line 50 "zeitgeist-related.vala"
	_data_->_tmp5_ = synapse_zeitgeist_related_find_related_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
#line 50 "zeitgeist-related.vala"
	_data_->results = _data_->_tmp5_;
#line 50 "zeitgeist-related.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 50 "zeitgeist-related.vala"
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
#line 50 "zeitgeist-related.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 50 "zeitgeist-related.vala"
			synapse_query_destroy (&_data_->q);
#line 50 "zeitgeist-related.vala"
			g_object_unref (_data_->_async_result);
#line 50 "zeitgeist-related.vala"
			return FALSE;
#line 1773 "zeitgeist-related.c"
		} else {
#line 50 "zeitgeist-related.vala"
			synapse_query_destroy (&_data_->q);
#line 50 "zeitgeist-related.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 50 "zeitgeist-related.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 50 "zeitgeist-related.vala"
			g_object_unref (_data_->_async_result);
#line 50 "zeitgeist-related.vala"
			return FALSE;
#line 1785 "zeitgeist-related.c"
		}
	}
#line 51 "zeitgeist-related.vala"
	synapse_result_set_add_all (_data_->dest_result_set, _data_->results);
#line 53 "zeitgeist-related.vala"
	_data_->_tmp6_ = synapse_result_set_get_sorted_list (_data_->dest_result_set);
#line 53 "zeitgeist-related.vala"
	_data_->result = _data_->_tmp6_;
#line 53 "zeitgeist-related.vala"
	_g_object_unref0 (_data_->results);
#line 53 "zeitgeist-related.vala"
	synapse_query_destroy (&_data_->q);
#line 53 "zeitgeist-related.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 53 "zeitgeist-related.vala"
	if (_data_->_state_ != 0) {
#line 53 "zeitgeist-related.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 53 "zeitgeist-related.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1806 "zeitgeist-related.c"
		}
	}
#line 53 "zeitgeist-related.vala"
	g_object_unref (_data_->_async_result);
#line 53 "zeitgeist-related.vala"
	return FALSE;
#line 1813 "zeitgeist-related.c"
}

static SynapseZeitgeistRelatedRelatedItem*
synapse_zeitgeist_related_related_item_construct (GType object_type,
                                                  SynapseZeitgeistRelated* plugin)
{
	SynapseZeitgeistRelatedRelatedItem * self = NULL;
#line 58 "zeitgeist-related.vala"
	g_return_val_if_fail (plugin != NULL, NULL);
#line 60 "zeitgeist-related.vala"
	self = (SynapseZeitgeistRelatedRelatedItem*) g_object_new (object_type, "has-thumbnail", FALSE, "icon-name", "search", "title", _ ("Find related"), "description", _ ("Find resources related to this result"), NULL);
#line 64 "zeitgeist-related.vala"
	self->priv->plugin = plugin;
#line 58 "zeitgeist-related.vala"
	return self;
#line 1829 "zeitgeist-related.c"
}

static SynapseZeitgeistRelatedRelatedItem*
synapse_zeitgeist_related_related_item_new (SynapseZeitgeistRelated* plugin)
{
#line 58 "zeitgeist-related.vala"
	return synapse_zeitgeist_related_related_item_construct (SYNAPSE_ZEITGEIST_RELATED_TYPE_RELATED_ITEM, plugin);
#line 1837 "zeitgeist-related.c"
}

static gint
synapse_zeitgeist_related_related_item_get_default_relevancy (SynapseZeitgeistRelatedRelatedItem* self)
{
	gint result;
#line 40 "zeitgeist-related.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 40 "zeitgeist-related.vala"
	result = self->priv->_default_relevancy;
#line 40 "zeitgeist-related.vala"
	return result;
#line 1850 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_related_item_set_default_relevancy (SynapseZeitgeistRelatedRelatedItem* self,
                                                              gint value)
{
	gint old_value;
#line 40 "zeitgeist-related.vala"
	g_return_if_fail (self != NULL);
#line 40 "zeitgeist-related.vala"
	old_value = synapse_zeitgeist_related_related_item_get_default_relevancy (self);
#line 40 "zeitgeist-related.vala"
	if (old_value != value) {
#line 40 "zeitgeist-related.vala"
		self->priv->_default_relevancy = value;
#line 40 "zeitgeist-related.vala"
		g_object_notify_by_pspec ((GObject *) self, synapse_zeitgeist_related_related_item_properties[SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_DEFAULT_RELEVANCY_PROPERTY]);
#line 1868 "zeitgeist-related.c"
	}
}

static void
synapse_zeitgeist_related_related_item_class_init (SynapseZeitgeistRelatedRelatedItemClass * klass,
                                                   gpointer klass_data)
{
#line 38 "zeitgeist-related.vala"
	synapse_zeitgeist_related_related_item_parent_class = g_type_class_peek_parent (klass);
#line 38 "zeitgeist-related.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZeitgeistRelatedRelatedItem_private_offset);
#line 38 "zeitgeist-related.vala"
	((SynapseSearchMatchClass *) klass)->search = (void (*) (SynapseSearchMatch*, const gchar*, SynapseQueryFlags, SynapseResultSet*, GCancellable*, GAsyncReadyCallback, gpointer)) synapse_zeitgeist_related_related_item_real_search;
#line 38 "zeitgeist-related.vala"
	((SynapseSearchMatchClass *) klass)->search_finish = (GeeList* (*) (SynapseSearchMatch*, GAsyncResult*, GError**)) synapse_zeitgeist_related_related_item_search_finish;
#line 38 "zeitgeist-related.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeitgeist_related_related_item_get_property;
#line 38 "zeitgeist-related.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeitgeist_related_related_item_set_property;
#line 38 "zeitgeist-related.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_related_related_item_finalize;
#line 38 "zeitgeist-related.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_DEFAULT_RELEVANCY_PROPERTY, synapse_zeitgeist_related_related_item_properties[SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1892 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_related_item_instance_init (SynapseZeitgeistRelatedRelatedItem * self,
                                                      gpointer klass)
{
#line 38 "zeitgeist-related.vala"
	self->priv = synapse_zeitgeist_related_related_item_get_instance_private (self);
#line 40 "zeitgeist-related.vala"
	self->priv->_default_relevancy = (gint) SYNAPSE_MATCH_SCORE_INCREMENT_SMALL;
#line 1903 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_related_item_finalize (GObject * obj)
{
	SynapseZeitgeistRelatedRelatedItem * self;
#line 38 "zeitgeist-related.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_ZEITGEIST_RELATED_TYPE_RELATED_ITEM, SynapseZeitgeistRelatedRelatedItem);
#line 38 "zeitgeist-related.vala"
	G_OBJECT_CLASS (synapse_zeitgeist_related_related_item_parent_class)->finalize (obj);
#line 1914 "zeitgeist-related.c"
}

static GType
synapse_zeitgeist_related_related_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistRelatedRelatedItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_related_related_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistRelatedRelatedItem), 0, (GInstanceInitFunc) synapse_zeitgeist_related_related_item_instance_init, NULL };
	GType synapse_zeitgeist_related_related_item_type_id;
	synapse_zeitgeist_related_related_item_type_id = g_type_register_static (SYNAPSE_TYPE_SEARCH_MATCH, "SynapseZeitgeistRelatedRelatedItem", &g_define_type_info, 0);
	SynapseZeitgeistRelatedRelatedItem_private_offset = g_type_add_instance_private (synapse_zeitgeist_related_related_item_type_id, sizeof (SynapseZeitgeistRelatedRelatedItemPrivate));
	return synapse_zeitgeist_related_related_item_type_id;
}

static GType
synapse_zeitgeist_related_related_item_get_type (void)
{
	static volatile gsize synapse_zeitgeist_related_related_item_type_id__once = 0;
	if (g_once_init_enter (&synapse_zeitgeist_related_related_item_type_id__once)) {
		GType synapse_zeitgeist_related_related_item_type_id;
		synapse_zeitgeist_related_related_item_type_id = synapse_zeitgeist_related_related_item_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_related_related_item_type_id__once, synapse_zeitgeist_related_related_item_type_id);
	}
	return synapse_zeitgeist_related_related_item_type_id__once;
}

static void
_vala_synapse_zeitgeist_related_related_item_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	SynapseZeitgeistRelatedRelatedItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_ZEITGEIST_RELATED_TYPE_RELATED_ITEM, SynapseZeitgeistRelatedRelatedItem);
#line 38 "zeitgeist-related.vala"
	switch (property_id) {
#line 38 "zeitgeist-related.vala"
		case SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "zeitgeist-related.vala"
		g_value_set_int (value, synapse_zeitgeist_related_related_item_get_default_relevancy (self));
#line 38 "zeitgeist-related.vala"
		break;
#line 1955 "zeitgeist-related.c"
		default:
#line 38 "zeitgeist-related.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "zeitgeist-related.vala"
		break;
#line 1961 "zeitgeist-related.c"
	}
}

static void
_vala_synapse_zeitgeist_related_related_item_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	SynapseZeitgeistRelatedRelatedItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_ZEITGEIST_RELATED_TYPE_RELATED_ITEM, SynapseZeitgeistRelatedRelatedItem);
#line 38 "zeitgeist-related.vala"
	switch (property_id) {
#line 38 "zeitgeist-related.vala"
		case SYNAPSE_ZEITGEIST_RELATED_RELATED_ITEM_DEFAULT_RELEVANCY_PROPERTY:
#line 38 "zeitgeist-related.vala"
		synapse_zeitgeist_related_related_item_set_default_relevancy (self, g_value_get_int (value));
#line 38 "zeitgeist-related.vala"
		break;
#line 1981 "zeitgeist-related.c"
		default:
#line 38 "zeitgeist-related.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "zeitgeist-related.vala"
		break;
#line 1987 "zeitgeist-related.c"
	}
}

static GObject *
synapse_zeitgeist_related_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseZeitgeistRelated * self;
	SynapseZeitgeistRelatedRelatedItem* _tmp0_;
	ZeitgeistLog* _tmp1_;
#line 89 "zeitgeist-related.vala"
	parent_class = G_OBJECT_CLASS (synapse_zeitgeist_related_parent_class);
#line 89 "zeitgeist-related.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 89 "zeitgeist-related.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEITGEIST_RELATED, SynapseZeitgeistRelated);
#line 91 "zeitgeist-related.vala"
	_tmp0_ = synapse_zeitgeist_related_related_item_new (self);
#line 91 "zeitgeist-related.vala"
	_g_object_unref0 (self->priv->action);
#line 91 "zeitgeist-related.vala"
	self->priv->action = _tmp0_;
#line 92 "zeitgeist-related.vala"
	_tmp1_ = zeitgeist_log_new ();
#line 92 "zeitgeist-related.vala"
	_g_object_unref0 (self->priv->zg_log);
#line 92 "zeitgeist-related.vala"
	self->priv->zg_log = _tmp1_;
#line 89 "zeitgeist-related.vala"
	return obj;
#line 2021 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_class_init (SynapseZeitgeistRelatedClass * klass,
                                      gpointer klass_data)
{
#line 24 "zeitgeist-related.vala"
	synapse_zeitgeist_related_parent_class = g_type_class_peek_parent (klass);
#line 24 "zeitgeist-related.vala"
	g_type_class_adjust_private_offset (klass, &SynapseZeitgeistRelated_private_offset);
#line 24 "zeitgeist-related.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_zeitgeist_related_get_property;
#line 24 "zeitgeist-related.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_zeitgeist_related_set_property;
#line 24 "zeitgeist-related.vala"
	G_OBJECT_CLASS (klass)->constructor = synapse_zeitgeist_related_constructor;
#line 24 "zeitgeist-related.vala"
	G_OBJECT_CLASS (klass)->finalize = synapse_zeitgeist_related_finalize;
#line 24 "zeitgeist-related.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_ZEITGEIST_RELATED_ENABLED_PROPERTY, synapse_zeitgeist_related_properties[SYNAPSE_ZEITGEIST_RELATED_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 83 "zeitgeist-related.vala"
	synapse_zeitgeist_related_register_plugin ();
#line 2044 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                              gpointer iface_data)
{
#line 24 "zeitgeist-related.vala"
	synapse_zeitgeist_related_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "zeitgeist-related.vala"
	iface->activate = (void (*) (SynapseActivatable*)) synapse_zeitgeist_related_real_activate;
#line 24 "zeitgeist-related.vala"
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_zeitgeist_related_real_deactivate;
#line 24 "zeitgeist-related.vala"
	iface->get_enabled = synapse_zeitgeist_related_real_get_enabled;
#line 24 "zeitgeist-related.vala"
	iface->set_enabled = synapse_zeitgeist_related_real_set_enabled;
#line 2061 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_synapse_action_provider_interface_init (SynapseActionProviderIface * iface,
                                                                  gpointer iface_data)
{
#line 24 "zeitgeist-related.vala"
	synapse_zeitgeist_related_synapse_action_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "zeitgeist-related.vala"
	iface->find_for_match = (SynapseResultSet* (*) (SynapseActionProvider*, SynapseQuery*, SynapseMatch*)) synapse_zeitgeist_related_real_find_for_match;
#line 2072 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_instance_init (SynapseZeitgeistRelated * self,
                                         gpointer klass)
{
#line 24 "zeitgeist-related.vala"
	self->priv = synapse_zeitgeist_related_get_instance_private (self);
#line 26 "zeitgeist-related.vala"
	self->priv->_enabled = TRUE;
#line 2083 "zeitgeist-related.c"
}

static void
synapse_zeitgeist_related_finalize (GObject * obj)
{
	SynapseZeitgeistRelated * self;
#line 24 "zeitgeist-related.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_ZEITGEIST_RELATED, SynapseZeitgeistRelated);
#line 86 "zeitgeist-related.vala"
	_g_object_unref0 (self->priv->action);
#line 87 "zeitgeist-related.vala"
	_g_object_unref0 (self->priv->zg_log);
#line 24 "zeitgeist-related.vala"
	G_OBJECT_CLASS (synapse_zeitgeist_related_parent_class)->finalize (obj);
#line 2098 "zeitgeist-related.c"
}

static GType
synapse_zeitgeist_related_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseZeitgeistRelatedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_zeitgeist_related_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseZeitgeistRelated), 0, (GInstanceInitFunc) synapse_zeitgeist_related_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_zeitgeist_related_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_action_provider_info = { (GInterfaceInitFunc) synapse_zeitgeist_related_synapse_action_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_zeitgeist_related_type_id;
	synapse_zeitgeist_related_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseZeitgeistRelated", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_zeitgeist_related_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_zeitgeist_related_type_id, SYNAPSE_TYPE_ACTION_PROVIDER, &synapse_action_provider_info);
	SynapseZeitgeistRelated_private_offset = g_type_add_instance_private (synapse_zeitgeist_related_type_id, sizeof (SynapseZeitgeistRelatedPrivate));
	return synapse_zeitgeist_related_type_id;
}

GType
synapse_zeitgeist_related_get_type (void)
{
	static volatile gsize synapse_zeitgeist_related_type_id__once = 0;
	if (g_once_init_enter (&synapse_zeitgeist_related_type_id__once)) {
		GType synapse_zeitgeist_related_type_id;
		synapse_zeitgeist_related_type_id = synapse_zeitgeist_related_get_type_once ();
		g_once_init_leave (&synapse_zeitgeist_related_type_id__once, synapse_zeitgeist_related_type_id);
	}
	return synapse_zeitgeist_related_type_id__once;
}

static void
_vala_synapse_zeitgeist_related_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	SynapseZeitgeistRelated * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEITGEIST_RELATED, SynapseZeitgeistRelated);
#line 24 "zeitgeist-related.vala"
	switch (property_id) {
#line 24 "zeitgeist-related.vala"
		case SYNAPSE_ZEITGEIST_RELATED_ENABLED_PROPERTY:
#line 24 "zeitgeist-related.vala"
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
#line 24 "zeitgeist-related.vala"
		break;
#line 2143 "zeitgeist-related.c"
		default:
#line 24 "zeitgeist-related.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "zeitgeist-related.vala"
		break;
#line 2149 "zeitgeist-related.c"
	}
}

static void
_vala_synapse_zeitgeist_related_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	SynapseZeitgeistRelated * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_ZEITGEIST_RELATED, SynapseZeitgeistRelated);
#line 24 "zeitgeist-related.vala"
	switch (property_id) {
#line 24 "zeitgeist-related.vala"
		case SYNAPSE_ZEITGEIST_RELATED_ENABLED_PROPERTY:
#line 24 "zeitgeist-related.vala"
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
#line 24 "zeitgeist-related.vala"
		break;
#line 2169 "zeitgeist-related.c"
		default:
#line 24 "zeitgeist-related.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "zeitgeist-related.vala"
		break;
#line 2175 "zeitgeist-related.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 24 "pastebin-plugin.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 2186 "zeitgeist-related.c"
		gssize i;
#line 24 "pastebin-plugin.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 24 "pastebin-plugin.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 24 "pastebin-plugin.vala"
				destroy_func (((gpointer*) array)[i]);
#line 2194 "zeitgeist-related.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 24 "pastebin-plugin.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 24 "pastebin-plugin.vala"
	g_free (array);
#line 2209 "zeitgeist-related.c"
}

