const char help_lua[] =
"local doc = require('help.en_US')\n"
"\n"
"-- The built-in tutorial contains links to the online\n"
"-- documentation with a <version> placeholder like\n"
"-- https://tarantool.io/en/doc/<version>/<...>. We should replace\n"
"-- the placeholders with a version of a documentation page that\n"
"-- corresponds to a tarantool version a user runs.\n"
"local DOCUMENTATION_VERSION = '2.1'\n"
"\n"
"help = { doc.help }\n"
"tutorial = {}\n"
"tutorial[1] = help[1]\n"
"\n"
"local function help_call()\n"
"    return help\n"
"end\n"
"\n"
"setmetatable(help, { __call = help_call })\n"
"\n"
"local screen_id = 1;\n"
"\n"
"local function tutorial_call(self, action)\n"
"    if action == 'start' then\n"
"        screen_id = 1;\n"
"    elseif action == 'next' or action == 'more' then\n"
"        screen_id = screen_id + 1\n"
"    elseif action == 'prev' then\n"
"        screen_id = screen_id - 1\n"
"    elseif type(action) == 'number' and action % 1 == 0 then\n"
"        screen_id = tonumber(action)\n"
"    elseif action ~= nil then\n"
"        error('Usage: tutorial(\"start\" | \"next\" | \"prev\" | 1 .. '..\n"
"            #doc.tutorial..')')\n"
"    end\n"
"    if screen_id < 1 then\n"
"        screen_id = 1\n"
"    elseif screen_id > #doc.tutorial then\n"
"        screen_id = #doc.tutorial\n"
"    end\n"
"    local res = doc.tutorial[screen_id]\n"
"    -- The parentheses are to discard return values except first\n"
"    -- one.\n"
"    return (res:gsub('<version>', DOCUMENTATION_VERSION))\n"
"end\n"
"\n"
"setmetatable(tutorial, { __call = tutorial_call })\n"
"\n"
"return {\n"
"    help = help;\n"
"    tutorial = tutorial;\n"
"}\n"
""
;
