const char utils_evread_lua[] =
"local bufread = require('utils.bufread')\n"
"local symtab = require('utils.symtab')\n"
"\n"
"local function make_error_handler(fmt, inputfile)\n"
"  return function(err)\n"
"    io.stderr:write(string.format(fmt, inputfile))\n"
"    io.stderr:write(string.format('\\n\\t%s\\n', err))\n"
"    os.exit(1, true)\n"
"  end\n"
"end\n"
"\n"
"return function(parser, inputfile)\n"
"  local _, reader = xpcall(\n"
"    bufread.new,\n"
"    make_error_handler('Failed to open %s.', inputfile),\n"
"    inputfile\n"
"  )\n"
"\n"
"  local _, symbols = xpcall(\n"
"    symtab.parse,\n"
"    make_error_handler('Failed to parse symtab from %s.', inputfile),\n"
"    reader\n"
"  )\n"
"\n"
"  local _, events = xpcall(\n"
"    parser,\n"
"    make_error_handler('Failed to parse profile data from %s.', inputfile),\n"
"    reader,\n"
"    symbols\n"
"  )\n"
"  return events, symbols\n"
"end\n"
""
;
