// python wrapper for ttkMergeTreeTemporalReductionDecoding
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMergeTreeTemporalReductionDecoding.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMergeTreeTemporalReductionDecoding(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMergeTreeTemporalReductionDecoding_ClassNew(); }


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetAssignmentSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAssignmentSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAssignmentSolver(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetAssignmentSolver(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetAssignmentSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAssignmentSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAssignmentSolver() :
      op->ttkMergeTreeTemporalReductionDecoding::GetAssignmentSolver());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetOutputTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputTrees(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetOutputTrees(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetOutputTrees(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputTrees");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOutputTrees() :
      op->ttkMergeTreeTemporalReductionDecoding::GetOutputTrees());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetPlanarLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPlanarLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPlanarLayout(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetPlanarLayout(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetPlanarLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPlanarLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPlanarLayout() :
      op->ttkMergeTreeTemporalReductionDecoding::GetPlanarLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetBranchDecompositionPlanarLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBranchDecompositionPlanarLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBranchDecompositionPlanarLayout(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetBranchDecompositionPlanarLayout(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetBranchDecompositionPlanarLayout(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBranchDecompositionPlanarLayout");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetBranchDecompositionPlanarLayout() :
      op->ttkMergeTreeTemporalReductionDecoding::GetBranchDecompositionPlanarLayout());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetBranchSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBranchSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBranchSpacing(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetBranchSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetBranchSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBranchSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetBranchSpacing() :
      op->ttkMergeTreeTemporalReductionDecoding::GetBranchSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetRescaleTreesIndividually(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRescaleTreesIndividually");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRescaleTreesIndividually(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetRescaleTreesIndividually(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetRescaleTreesIndividually(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRescaleTreesIndividually");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRescaleTreesIndividually() :
      op->ttkMergeTreeTemporalReductionDecoding::GetRescaleTreesIndividually());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetDimensionSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDimensionSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDimensionSpacing(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetDimensionSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetDimensionSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDimensionSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetDimensionSpacing() :
      op->ttkMergeTreeTemporalReductionDecoding::GetDimensionSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetDimensionToShift(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDimensionToShift");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDimensionToShift(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetDimensionToShift(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetDimensionToShift(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDimensionToShift");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDimensionToShift() :
      op->ttkMergeTreeTemporalReductionDecoding::GetDimensionToShift());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImportantPairs(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetImportantPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImportantPairs() :
      op->ttkMergeTreeTemporalReductionDecoding::GetImportantPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetMaximumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaximumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaximumImportantPairs(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetMaximumImportantPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetMaximumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaximumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaximumImportantPairs() :
      op->ttkMergeTreeTemporalReductionDecoding::GetMaximumImportantPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetMinimumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinimumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinimumImportantPairs(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetMinimumImportantPairs(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetMinimumImportantPairs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinimumImportantPairs");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMinimumImportantPairs() :
      op->ttkMergeTreeTemporalReductionDecoding::GetMinimumImportantPairs());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImportantPairsSpacing(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetImportantPairsSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetImportantPairsSpacing() :
      op->ttkMergeTreeTemporalReductionDecoding::GetImportantPairsSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetNonImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNonImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNonImportantPairsSpacing(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetNonImportantPairsSpacing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetNonImportantPairsSpacing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNonImportantPairsSpacing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetNonImportantPairsSpacing() :
      op->ttkMergeTreeTemporalReductionDecoding::GetNonImportantPairsSpacing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetNonImportantPairsProximity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNonImportantPairsProximity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNonImportantPairsProximity(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetNonImportantPairsProximity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetNonImportantPairsProximity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNonImportantPairsProximity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetNonImportantPairsProximity() :
      op->ttkMergeTreeTemporalReductionDecoding::GetNonImportantPairsProximity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetExcludeImportantPairsLower(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExcludeImportantPairsLower");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExcludeImportantPairsLower(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetExcludeImportantPairsLower(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetExcludeImportantPairsLower(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExcludeImportantPairsLower");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetExcludeImportantPairsLower() :
      op->ttkMergeTreeTemporalReductionDecoding::GetExcludeImportantPairsLower());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SetExcludeImportantPairsHigher(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExcludeImportantPairsHigher");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExcludeImportantPairsHigher(temp0);
    }
    else
    {
      op->ttkMergeTreeTemporalReductionDecoding::SetExcludeImportantPairsHigher(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetExcludeImportantPairsHigher(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExcludeImportantPairsHigher");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetExcludeImportantPairsHigher() :
      op->ttkMergeTreeTemporalReductionDecoding::GetExcludeImportantPairsHigher());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMergeTreeTemporalReductionDecoding::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMergeTreeTemporalReductionDecoding::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMergeTreeTemporalReductionDecoding *tempr = ttkMergeTreeTemporalReductionDecoding::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMergeTreeTemporalReductionDecoding *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMergeTreeTemporalReductionDecoding::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMergeTreeTemporalReductionDecoding::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMergeTreeTemporalReductionDecoding_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMergeTreeTemporalReductionDecoding *op = static_cast<ttkMergeTreeTemporalReductionDecoding *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMergeTreeTemporalReductionDecoding::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMergeTreeTemporalReductionDecoding_Methods[] = {
  {"SetAssignmentSolver", PyttkMergeTreeTemporalReductionDecoding_SetAssignmentSolver, METH_VARARGS,
   "SetAssignmentSolver(self, assignmentSolver:int) -> None\nC++: void SetAssignmentSolver(int assignmentSolver)\n\nAutomatically generate getters and setters of filter parameters\nvia vtkMacros.\n"},
  {"GetAssignmentSolver", PyttkMergeTreeTemporalReductionDecoding_GetAssignmentSolver, METH_VARARGS,
   "GetAssignmentSolver(self) -> int\nC++: int GetAssignmentSolver()\n\n"},
  {"SetOutputTrees", PyttkMergeTreeTemporalReductionDecoding_SetOutputTrees, METH_VARARGS,
   "SetOutputTrees(self, _arg:bool) -> None\nC++: virtual void SetOutputTrees(bool _arg)\n\n"},
  {"GetOutputTrees", PyttkMergeTreeTemporalReductionDecoding_GetOutputTrees, METH_VARARGS,
   "GetOutputTrees(self) -> bool\nC++: virtual bool GetOutputTrees()\n\n"},
  {"SetPlanarLayout", PyttkMergeTreeTemporalReductionDecoding_SetPlanarLayout, METH_VARARGS,
   "SetPlanarLayout(self, _arg:bool) -> None\nC++: virtual void SetPlanarLayout(bool _arg)\n\n"},
  {"GetPlanarLayout", PyttkMergeTreeTemporalReductionDecoding_GetPlanarLayout, METH_VARARGS,
   "GetPlanarLayout(self) -> bool\nC++: virtual bool GetPlanarLayout()\n\n"},
  {"SetBranchDecompositionPlanarLayout", PyttkMergeTreeTemporalReductionDecoding_SetBranchDecompositionPlanarLayout, METH_VARARGS,
   "SetBranchDecompositionPlanarLayout(self, _arg:bool) -> None\nC++: virtual void SetBranchDecompositionPlanarLayout(bool _arg)\n\n"},
  {"GetBranchDecompositionPlanarLayout", PyttkMergeTreeTemporalReductionDecoding_GetBranchDecompositionPlanarLayout, METH_VARARGS,
   "GetBranchDecompositionPlanarLayout(self) -> bool\nC++: virtual bool GetBranchDecompositionPlanarLayout()\n\n"},
  {"SetBranchSpacing", PyttkMergeTreeTemporalReductionDecoding_SetBranchSpacing, METH_VARARGS,
   "SetBranchSpacing(self, _arg:float) -> None\nC++: virtual void SetBranchSpacing(double _arg)\n\n"},
  {"GetBranchSpacing", PyttkMergeTreeTemporalReductionDecoding_GetBranchSpacing, METH_VARARGS,
   "GetBranchSpacing(self) -> float\nC++: virtual double GetBranchSpacing()\n\n"},
  {"SetRescaleTreesIndividually", PyttkMergeTreeTemporalReductionDecoding_SetRescaleTreesIndividually, METH_VARARGS,
   "SetRescaleTreesIndividually(self, _arg:bool) -> None\nC++: virtual void SetRescaleTreesIndividually(bool _arg)\n\n"},
  {"GetRescaleTreesIndividually", PyttkMergeTreeTemporalReductionDecoding_GetRescaleTreesIndividually, METH_VARARGS,
   "GetRescaleTreesIndividually(self) -> bool\nC++: virtual bool GetRescaleTreesIndividually()\n\n"},
  {"SetDimensionSpacing", PyttkMergeTreeTemporalReductionDecoding_SetDimensionSpacing, METH_VARARGS,
   "SetDimensionSpacing(self, _arg:float) -> None\nC++: virtual void SetDimensionSpacing(double _arg)\n\n"},
  {"GetDimensionSpacing", PyttkMergeTreeTemporalReductionDecoding_GetDimensionSpacing, METH_VARARGS,
   "GetDimensionSpacing(self) -> float\nC++: virtual double GetDimensionSpacing()\n\n"},
  {"SetDimensionToShift", PyttkMergeTreeTemporalReductionDecoding_SetDimensionToShift, METH_VARARGS,
   "SetDimensionToShift(self, _arg:int) -> None\nC++: virtual void SetDimensionToShift(int _arg)\n\n"},
  {"GetDimensionToShift", PyttkMergeTreeTemporalReductionDecoding_GetDimensionToShift, METH_VARARGS,
   "GetDimensionToShift(self) -> int\nC++: virtual int GetDimensionToShift()\n\n"},
  {"SetImportantPairs", PyttkMergeTreeTemporalReductionDecoding_SetImportantPairs, METH_VARARGS,
   "SetImportantPairs(self, _arg:float) -> None\nC++: virtual void SetImportantPairs(double _arg)\n\n"},
  {"GetImportantPairs", PyttkMergeTreeTemporalReductionDecoding_GetImportantPairs, METH_VARARGS,
   "GetImportantPairs(self) -> float\nC++: virtual double GetImportantPairs()\n\n"},
  {"SetMaximumImportantPairs", PyttkMergeTreeTemporalReductionDecoding_SetMaximumImportantPairs, METH_VARARGS,
   "SetMaximumImportantPairs(self, _arg:int) -> None\nC++: virtual void SetMaximumImportantPairs(int _arg)\n\n"},
  {"GetMaximumImportantPairs", PyttkMergeTreeTemporalReductionDecoding_GetMaximumImportantPairs, METH_VARARGS,
   "GetMaximumImportantPairs(self) -> int\nC++: virtual int GetMaximumImportantPairs()\n\n"},
  {"SetMinimumImportantPairs", PyttkMergeTreeTemporalReductionDecoding_SetMinimumImportantPairs, METH_VARARGS,
   "SetMinimumImportantPairs(self, _arg:int) -> None\nC++: virtual void SetMinimumImportantPairs(int _arg)\n\n"},
  {"GetMinimumImportantPairs", PyttkMergeTreeTemporalReductionDecoding_GetMinimumImportantPairs, METH_VARARGS,
   "GetMinimumImportantPairs(self) -> int\nC++: virtual int GetMinimumImportantPairs()\n\n"},
  {"SetImportantPairsSpacing", PyttkMergeTreeTemporalReductionDecoding_SetImportantPairsSpacing, METH_VARARGS,
   "SetImportantPairsSpacing(self, _arg:float) -> None\nC++: virtual void SetImportantPairsSpacing(double _arg)\n\n"},
  {"GetImportantPairsSpacing", PyttkMergeTreeTemporalReductionDecoding_GetImportantPairsSpacing, METH_VARARGS,
   "GetImportantPairsSpacing(self) -> float\nC++: virtual double GetImportantPairsSpacing()\n\n"},
  {"SetNonImportantPairsSpacing", PyttkMergeTreeTemporalReductionDecoding_SetNonImportantPairsSpacing, METH_VARARGS,
   "SetNonImportantPairsSpacing(self, _arg:float) -> None\nC++: virtual void SetNonImportantPairsSpacing(double _arg)\n\n"},
  {"GetNonImportantPairsSpacing", PyttkMergeTreeTemporalReductionDecoding_GetNonImportantPairsSpacing, METH_VARARGS,
   "GetNonImportantPairsSpacing(self) -> float\nC++: virtual double GetNonImportantPairsSpacing()\n\n"},
  {"SetNonImportantPairsProximity", PyttkMergeTreeTemporalReductionDecoding_SetNonImportantPairsProximity, METH_VARARGS,
   "SetNonImportantPairsProximity(self, _arg:float) -> None\nC++: virtual void SetNonImportantPairsProximity(double _arg)\n\n"},
  {"GetNonImportantPairsProximity", PyttkMergeTreeTemporalReductionDecoding_GetNonImportantPairsProximity, METH_VARARGS,
   "GetNonImportantPairsProximity(self) -> float\nC++: virtual double GetNonImportantPairsProximity()\n\n"},
  {"SetExcludeImportantPairsLower", PyttkMergeTreeTemporalReductionDecoding_SetExcludeImportantPairsLower, METH_VARARGS,
   "SetExcludeImportantPairsLower(self, _arg:str) -> None\nC++: virtual void SetExcludeImportantPairsLower(\n    const std::string &_arg)\n\n"},
  {"GetExcludeImportantPairsLower", PyttkMergeTreeTemporalReductionDecoding_GetExcludeImportantPairsLower, METH_VARARGS,
   "GetExcludeImportantPairsLower(self) -> str\nC++: virtual std::string GetExcludeImportantPairsLower()\n\n"},
  {"SetExcludeImportantPairsHigher", PyttkMergeTreeTemporalReductionDecoding_SetExcludeImportantPairsHigher, METH_VARARGS,
   "SetExcludeImportantPairsHigher(self, _arg:str) -> None\nC++: virtual void SetExcludeImportantPairsHigher(\n    const std::string &_arg)\n\n"},
  {"GetExcludeImportantPairsHigher", PyttkMergeTreeTemporalReductionDecoding_GetExcludeImportantPairsHigher, METH_VARARGS,
   "GetExcludeImportantPairsHigher(self) -> str\nC++: virtual std::string GetExcludeImportantPairsHigher()\n\n"},
  {"IsTypeOf", PyttkMergeTreeTemporalReductionDecoding_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMergeTreeTemporalReductionDecoding_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMergeTreeTemporalReductionDecoding_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> ttkMergeTreeTemporalReductionDecoding\nC++: static ttkMergeTreeTemporalReductionDecoding *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMergeTreeTemporalReductionDecoding_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMergeTreeTemporalReductionDecoding\nC++: ttkMergeTreeTemporalReductionDecoding *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMergeTreeTemporalReductionDecoding_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMergeTreeTemporalReductionDecoding_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMergeTreeTemporalReductionDecoding_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("assignment_solver"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetAssignmentSolver(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetAssignmentSolver(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetAssignmentSolver(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAssignmentSolver/SetAssignmentSolver\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_trees"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetOutputTrees(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetOutputTrees(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetOutputTrees(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputTrees/SetOutputTrees\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("planar_layout"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetPlanarLayout(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetPlanarLayout(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetPlanarLayout(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPlanarLayout/SetPlanarLayout\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_decomposition_planar_layout"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetBranchDecompositionPlanarLayout(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetBranchDecompositionPlanarLayout(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetBranchDecompositionPlanarLayout(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBranchDecompositionPlanarLayout/SetBranchDecompositionPlanarLayout\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("branch_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetBranchSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetBranchSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetBranchSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBranchSpacing/SetBranchSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rescale_trees_individually"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetRescaleTreesIndividually(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetRescaleTreesIndividually(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetRescaleTreesIndividually(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRescaleTreesIndividually/SetRescaleTreesIndividually\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("dimension_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetDimensionSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetDimensionSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetDimensionSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDimensionSpacing/SetDimensionSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("dimension_to_shift"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetDimensionToShift(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetDimensionToShift(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetDimensionToShift(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDimensionToShift/SetDimensionToShift\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("important_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetImportantPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetImportantPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetImportantPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImportantPairs/SetImportantPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("maximum_important_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetMaximumImportantPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetMaximumImportantPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetMaximumImportantPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaximumImportantPairs/SetMaximumImportantPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("minimum_important_pairs"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetMinimumImportantPairs(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetMinimumImportantPairs(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetMinimumImportantPairs(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinimumImportantPairs/SetMinimumImportantPairs\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("important_pairs_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetImportantPairsSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetImportantPairsSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetImportantPairsSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetImportantPairsSpacing/SetImportantPairsSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("non_important_pairs_spacing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetNonImportantPairsSpacing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetNonImportantPairsSpacing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetNonImportantPairsSpacing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNonImportantPairsSpacing/SetNonImportantPairsSpacing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("non_important_pairs_proximity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetNonImportantPairsProximity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetNonImportantPairsProximity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetNonImportantPairsProximity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNonImportantPairsProximity/SetNonImportantPairsProximity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exclude_important_pairs_lower"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetExcludeImportantPairsLower(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetExcludeImportantPairsLower(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetExcludeImportantPairsLower(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExcludeImportantPairsLower/SetExcludeImportantPairsLower\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exclude_important_pairs_higher"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMergeTreeTemporalReductionDecoding_GetExcludeImportantPairsHigher(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetExcludeImportantPairsHigher(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMergeTreeTemporalReductionDecoding_SetExcludeImportantPairsHigher(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExcludeImportantPairsHigher/SetExcludeImportantPairsHigher\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMergeTreeTemporalReductionDecoding_Doc =
  "ttkMergeTreeTemporalReductionDecoding - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Mathieu Pont (mathieu.pont@lip6.fr)\\date 2021.\n\n"
  "TTK VTK-filter that wraps the ttk::MergeTreeTemporalReductionDecoding\n"
  "module.\n\n"
  "This VTK filter uses the ttk::MergeTreeTemporalReductionDecoding\n"
  "module to compute the reconstruction of a reduced sequence of merge\n"
  "trees.\n\n"
  "\\param Input vtkMultiBlockDataSet Key frames.\n"
  "\\param Input vtkTable Interpolation coefficients.\n"
  "\\param Output vtkMultiBlockDataSet Input trees\n\n"
  "See the corresponding standalone program for a usage example:\n"
  "- standalone/MergeTreeTemporalReductionDecoding/main.cpp\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::MergeTreeTemporalReductionDecoding\n"
  "\\sa ttkAlgorithm\n\n"
  "Related publication\n\n"
  "\"Wasserstein Distances, Geodesics and Barycenters of Merge Trees\"\n\n"
  "Mathieu Pont, Jules Vidal, Julie Delon, Julien Tierny.\n\n"
  "Proc. of IEEE VIS 2021.\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2021\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeTemporalReduction/\"\n"
  "  >Merge Tree Temporal Reduction\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMergeTreeTemporalReductionDecoding_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMergeTreeTemporalReductionDecoding.ttkMergeTreeTemporalReductionDecoding", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMergeTreeTemporalReductionDecoding_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMergeTreeTemporalReductionDecoding_StaticNew()
{
  return ttkMergeTreeTemporalReductionDecoding::New();
}

PyObject *PyttkMergeTreeTemporalReductionDecoding_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMergeTreeTemporalReductionDecoding_Type, PyttkMergeTreeTemporalReductionDecoding_Methods,
    "ttkMergeTreeTemporalReductionDecoding",
 &PyttkMergeTreeTemporalReductionDecoding_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMergeTreeTemporalReductionDecoding_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMergeTreeTemporalReductionDecoding(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMergeTreeTemporalReductionDecoding_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMergeTreeTemporalReductionDecoding", o) != 0)
  {
    Py_DECREF(o);
  }

}

