/* dlangwriter.c generated by valac 0.56.17, the Vala compiler
 * generated from dlangwriter.vala, do not modify */

/* Copyright 2013-2015 -- pancake */

#include <vala.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valacodegen.h>
#include <valagee.h>
#include <stdio.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_VALABIND_WRITER (valabind_writer_get_type ())
#define VALABIND_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALABIND_WRITER, ValabindWriter))
#define VALABIND_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALABIND_WRITER, ValabindWriterClass))
#define IS_VALABIND_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALABIND_WRITER))
#define IS_VALABIND_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALABIND_WRITER))
#define VALABIND_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALABIND_WRITER, ValabindWriterClass))

typedef struct _ValabindWriter ValabindWriter;
typedef struct _ValabindWriterClass ValabindWriterClass;
typedef struct _ValabindWriterPrivate ValabindWriterPrivate;

#define TYPE_DLANG_WRITER (dlang_writer_get_type ())
#define DLANG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DLANG_WRITER, DlangWriter))
#define DLANG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DLANG_WRITER, DlangWriterClass))
#define IS_DLANG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DLANG_WRITER))
#define IS_DLANG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DLANG_WRITER))
#define DLANG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DLANG_WRITER, DlangWriterClass))

typedef struct _DlangWriter DlangWriter;
typedef struct _DlangWriterClass DlangWriterClass;
typedef struct _DlangWriterPrivate DlangWriterPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

struct _ValabindWriter {
	ValaCodeVisitor parent_instance;
	ValabindWriterPrivate * priv;
	gchar* modulename;
	gchar* library;
	gboolean pkgmode;
	gboolean camelgetters;
	gchar* pkgname;
	gchar** include_dirs;
	gchar** namespaces;
	ValaCodeContext* context;
	gchar* vapidir;
	GList* source_files;
	GList* packages;
	GList* defines;
	gboolean glibmode;
};

struct _ValabindWriterClass {
	ValaCodeVisitorClass parent_class;
	void (*write) (ValabindWriter* self, const gchar* file);
	gchar* (*get_filename) (ValabindWriter* self, const gchar* base_name);
};

struct _DlangWriter {
	ValabindWriter parent_instance;
	DlangWriterPrivate * priv;
	GList* includefiles;
	GList* methods;
};

struct _DlangWriterClass {
	ValabindWriterClass parent_class;
};

struct _DlangWriterPrivate {
	gchar* classname;
	gchar* classcname;
	gchar* defs;
	gchar* statics;
	gchar* extends;
	gchar* enums;
	gchar* vectors;
	gchar* nspace;
	GHashTable* defined_classes;
};

static gint DlangWriter_private_offset;
static gpointer dlang_writer_parent_class = NULL;

VALA_EXTERN GType valabind_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValabindWriter, vala_code_visitor_unref)
VALA_EXTERN GType dlang_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DlangWriter, vala_code_visitor_unref)
VALA_EXTERN gchar* valabind_writer_get_filename (ValabindWriter* self,
                                     const gchar* base_name);
VALA_EXTERN void valabind_writer_write (ValabindWriter* self,
                            const gchar* file);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
VALA_EXTERN DlangWriter* dlang_writer_new (void);
VALA_EXTERN DlangWriter* dlang_writer_construct (GType object_type);
VALA_EXTERN ValabindWriter* valabind_writer_new (void);
VALA_EXTERN ValabindWriter* valabind_writer_construct (GType object_type);
static gchar* dlang_writer_real_get_filename (ValabindWriter* base,
                                       const gchar* base_name);
static gchar* dlang_writer_get_alias (DlangWriter* self,
                               const gchar* name);
VALA_EXTERN void warning (const gchar* msg);
static gchar* dlang_writer_get_ctype (DlangWriter* self,
                               const gchar* _type);
VALA_EXTERN void error (const gchar* msg);
static inline gboolean dlang_writer_is_generic (DlangWriter* self,
                                  const gchar* type);
static gboolean dlang_writer_is_target_file (DlangWriter* self,
                                      const gchar* path);
static void dlang_writer_real_visit_source_file (ValaCodeVisitor* base,
                                          ValaSourceFile* source);
VALA_EXTERN void dlang_writer_process_includes (DlangWriter* self,
                                    ValaSymbol* s);
VALA_EXTERN void dlang_writer_walk_field (DlangWriter* self,
                              ValaField* f);
VALA_EXTERN gint array_length (ValaArrayType* array);
VALA_EXTERN void dlang_writer_walk_struct (DlangWriter* self,
                               const gchar* pfx,
                               ValaStruct* s);
VALA_EXTERN void dlang_writer_walk_class (DlangWriter* self,
                              const gchar* pfx,
                              ValaClass* c);
VALA_EXTERN void dlang_writer_walk_enum (DlangWriter* self,
                             ValaEnum* e);
VALA_EXTERN void dlang_writer_walk_method (DlangWriter* self,
                               ValaMethod* m);
static void dlang_writer_real_visit_namespace (ValaCodeVisitor* base,
                                        ValaNamespace* ns);
static void dlang_writer_real_write (ValabindWriter* base,
                              const gchar* file);
static void dlang_writer_finalize (ValaCodeVisitor * obj);
static GType dlang_writer_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
dlang_writer_get_instance_private (DlangWriter* self)
{
	return G_STRUCT_MEMBER_P (self, DlangWriter_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}

static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}

DlangWriter*
dlang_writer_construct (GType object_type)
{
	DlangWriter* self = NULL;
	self = (DlangWriter*) valabind_writer_construct (object_type);
	return self;
}

DlangWriter*
dlang_writer_new (void)
{
	return dlang_writer_construct (TYPE_DLANG_WRITER);
}

static gchar*
dlang_writer_real_get_filename (ValabindWriter* base,
                                const gchar* base_name)
{
	DlangWriter * self;
	gchar* _tmp0_;
	gchar* result;
	self = (DlangWriter*) base;
	g_return_val_if_fail (base_name != NULL, NULL);
	_tmp0_ = g_strconcat (base_name, ".d", NULL);
	result = _tmp0_;
	return result;
}

static gchar*
dlang_writer_get_alias (DlangWriter* self,
                        const gchar* name)
{
	gchar* oname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	static GQuark _tmp2_label16 = 0;
	const gchar* _tmp5_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup (name);
	oname = _tmp0_;
	_tmp1_ = name;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (((((((((((((((((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("not_eq")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("or_eq"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("xor_eq"))))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("and_eq"))))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("or"))))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("xor"))))) || (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("not"))))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("and"))))) || (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("break"))))) || (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("while"))))) || (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("print"))))) || (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("new"))))) || (_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("for"))))) || (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("if"))))) || (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("case"))))) || (_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("delete"))))) || (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("continue"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strconcat ("_", name, NULL);
				result = _tmp4_;
				_g_free0 (oname);
				return result;
			}
		}
	}
	_tmp5_ = oname;
	if (g_strcmp0 (name, _tmp5_) != 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = self->priv->classname;
		_tmp7_ = oname;
		_tmp8_ = self->priv->classname;
		_tmp9_ = g_strdup_printf ("%s.%s method renamed to %s.%s", _tmp6_, _tmp7_, _tmp8_, name);
		_tmp10_ = _tmp9_;
		warning (_tmp10_);
		_g_free0 (_tmp10_);
	}
	_tmp11_ = g_strdup (name);
	result = _tmp11_;
	_g_free0 (oname);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
dlang_writer_get_ctype (DlangWriter* self,
                        const gchar* _type)
{
	gchar* type = NULL;
	gchar* _tmp0_;
	gchar* iter_type = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	GQuark _tmp42_ = 0U;
	static GQuark _tmp41_label0 = 0;
	static GQuark _tmp41_label1 = 0;
	static GQuark _tmp41_label2 = 0;
	static GQuark _tmp41_label3 = 0;
	static GQuark _tmp41_label4 = 0;
	static GQuark _tmp41_label5 = 0;
	static GQuark _tmp41_label6 = 0;
	static GQuark _tmp41_label7 = 0;
	static GQuark _tmp41_label8 = 0;
	static GQuark _tmp41_label9 = 0;
	static GQuark _tmp41_label10 = 0;
	static GQuark _tmp41_label11 = 0;
	static GQuark _tmp41_label12 = 0;
	static GQuark _tmp41_label13 = 0;
	static GQuark _tmp41_label14 = 0;
	static GQuark _tmp41_label15 = 0;
	static GQuark _tmp41_label16 = 0;
	static GQuark _tmp41_label17 = 0;
	static GQuark _tmp41_label18 = 0;
	static GQuark _tmp41_label19 = 0;
	static GQuark _tmp41_label20 = 0;
	static GQuark _tmp41_label21 = 0;
	static GQuark _tmp41_label22 = 0;
	static GQuark _tmp41_label23 = 0;
	static GQuark _tmp41_label24 = 0;
	static GQuark _tmp41_label25 = 0;
	static GQuark _tmp41_label26 = 0;
	static GQuark _tmp41_label27 = 0;
	static GQuark _tmp41_label28 = 0;
	static GQuark _tmp41_label29 = 0;
	static GQuark _tmp41_label30 = 0;
	static GQuark _tmp41_label31 = 0;
	static GQuark _tmp41_label32 = 0;
	static GQuark _tmp41_label33 = 0;
	static GQuark _tmp41_label34 = 0;
	static GQuark _tmp41_label35 = 0;
	static GQuark _tmp41_label36 = 0;
	static GQuark _tmp41_label37 = 0;
	static GQuark _tmp41_label38 = 0;
	static GQuark _tmp41_label39 = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (_type != NULL, NULL);
	_tmp0_ = g_strdup (_type);
	type = _tmp0_;
	iter_type = NULL;
	_tmp1_ = type;
	if (g_strcmp0 (_tmp1_, "null") == 0) {
		error ("Cannot resolve type");
	}
	_tmp2_ = type;
	_tmp3_ = self->priv->nspace;
	if (g_str_has_prefix (_tmp2_, _tmp3_)) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = type;
		_tmp5_ = self->priv->nspace;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = string_substring (_tmp4_, (glong) _tmp7_, (glong) -1);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, "*", NULL);
		_g_free0 (type);
		type = _tmp10_;
		_g_free0 (_tmp9_);
	}
	_tmp11_ = type;
	_tmp12_ = string_replace (_tmp11_, ".", "");
	_g_free0 (type);
	type = _tmp12_;
	_tmp13_ = type;
	if (dlang_writer_is_generic (self, _tmp13_)) {
		gint ptr = 0;
		const gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar** _tmp32_;
		gchar** _tmp33_;
		gchar** _tmp34_;
		gint _tmp34__length1;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp14_ = type;
		ptr = string_index_of (_tmp14_, "<", 0);
		if (ptr == -1) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = type;
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (_tmp15_);
			_tmp15_ = _tmp17_;
		} else {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gchar* _tmp22_;
			_tmp18_ = type;
			_tmp19_ = type;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = string_slice (_tmp18_, (glong) ptr, (glong) _tmp21_);
			_g_free0 (_tmp15_);
			_tmp15_ = _tmp22_;
		}
		_tmp23_ = g_strdup (_tmp15_);
		_g_free0 (iter_type);
		iter_type = _tmp23_;
		_tmp24_ = iter_type;
		_tmp25_ = string_replace (_tmp24_, "<", "");
		_g_free0 (iter_type);
		iter_type = _tmp25_;
		_tmp26_ = iter_type;
		_tmp27_ = string_replace (_tmp26_, ">", "");
		_g_free0 (iter_type);
		iter_type = _tmp27_;
		_tmp28_ = iter_type;
		_tmp29_ = self->priv->nspace;
		_tmp30_ = string_replace (_tmp28_, _tmp29_, "");
		_g_free0 (iter_type);
		iter_type = _tmp30_;
		_tmp31_ = type;
		_tmp33_ = _tmp32_ = g_strsplit (_tmp31_, "<", 2);
		_tmp34_ = _tmp33_;
		_tmp34__length1 = _vala_array_length (_tmp32_);
		_tmp35_ = _tmp34_[0];
		_tmp36_ = g_strdup (_tmp35_);
		_g_free0 (type);
		type = _tmp36_;
		_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp15_);
	}
	_tmp37_ = type;
	_tmp38_ = string_replace (_tmp37_, "?", "");
	_g_free0 (type);
	type = _tmp38_;
	_tmp39_ = type;
	_tmp40_ = _tmp39_;
	_tmp42_ = (NULL == _tmp40_) ? 0 : g_quark_from_string (_tmp40_);
	if ((((_tmp42_ == ((0 != _tmp41_label0) ? _tmp41_label0 : (_tmp41_label0 = g_quark_from_static_string ("G")))) || (_tmp42_ == ((0 != _tmp41_label1) ? _tmp41_label1 : (_tmp41_label1 = g_quark_from_static_string ("gconstpointer"))))) || (_tmp42_ == ((0 != _tmp41_label2) ? _tmp41_label2 : (_tmp41_label2 = g_quark_from_static_string ("gpointer"))))) || (_tmp42_ == ((0 != _tmp41_label3) ? _tmp41_label3 : (_tmp41_label3 = g_quark_from_static_string ("void*"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp43_;
				_tmp43_ = g_strdup ("void*");
				result = _tmp43_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp42_ == ((0 != _tmp41_label4) ? _tmp41_label4 : (_tmp41_label4 = g_quark_from_static_string ("gsize")))) {
		switch (0) {
			default:
			{
				gchar* _tmp44_;
				_tmp44_ = g_strdup ("size_t");
				result = _tmp44_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp42_ == ((0 != _tmp41_label5) ? _tmp41_label5 : (_tmp41_label5 = g_quark_from_static_string ("gdouble")))) {
		switch (0) {
			default:
			{
				gchar* _tmp45_;
				_tmp45_ = g_strdup ("double");
				result = _tmp45_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp42_ == ((0 != _tmp41_label6) ? _tmp41_label6 : (_tmp41_label6 = g_quark_from_static_string ("gfloat")))) {
		switch (0) {
			default:
			{
				gchar* _tmp46_;
				_tmp46_ = g_strdup ("float");
				result = _tmp46_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (((_tmp42_ == ((0 != _tmp41_label7) ? _tmp41_label7 : (_tmp41_label7 = g_quark_from_static_string ("ut8")))) || (_tmp42_ == ((0 != _tmp41_label8) ? _tmp41_label8 : (_tmp41_label8 = g_quark_from_static_string ("uint8"))))) || (_tmp42_ == ((0 != _tmp41_label9) ? _tmp41_label9 : (_tmp41_label9 = g_quark_from_static_string ("guint8"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp47_;
				_tmp47_ = g_strdup ("byte");
				result = _tmp47_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp42_ == ((0 != _tmp41_label10) ? _tmp41_label10 : (_tmp41_label10 = g_quark_from_static_string ("gchar**")))) {
		switch (0) {
			default:
			{
				gchar* _tmp48_;
				_tmp48_ = g_strdup ("char **");
				result = _tmp48_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if ((_tmp42_ == ((0 != _tmp41_label11) ? _tmp41_label11 : (_tmp41_label11 = g_quark_from_static_string ("char")))) || (_tmp42_ == ((0 != _tmp41_label12) ? _tmp41_label12 : (_tmp41_label12 = g_quark_from_static_string ("gchar"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp49_;
				_tmp49_ = g_strdup ("char");
				result = _tmp49_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (((_tmp42_ == ((0 != _tmp41_label13) ? _tmp41_label13 : (_tmp41_label13 = g_quark_from_static_string ("gchar*")))) || (_tmp42_ == ((0 != _tmp41_label14) ? _tmp41_label14 : (_tmp41_label14 = g_quark_from_static_string ("string"))))) || (_tmp42_ == ((0 != _tmp41_label15) ? _tmp41_label15 : (_tmp41_label15 = g_quark_from_static_string ("const gchar*"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp50_;
				_tmp50_ = g_strdup ("string");
				result = _tmp50_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp42_ == ((0 != _tmp41_label16) ? _tmp41_label16 : (_tmp41_label16 = g_quark_from_static_string ("void")))) {
		switch (0) {
			default:
			{
				gchar* _tmp51_;
				_tmp51_ = g_strdup ("void");
				result = _tmp51_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (((_tmp42_ == ((0 != _tmp41_label17) ? _tmp41_label17 : (_tmp41_label17 = g_quark_from_static_string ("int[]")))) || (_tmp42_ == ((0 != _tmp41_label18) ? _tmp41_label18 : (_tmp41_label18 = g_quark_from_static_string ("int"))))) || (_tmp42_ == ((0 != _tmp41_label19) ? _tmp41_label19 : (_tmp41_label19 = g_quark_from_static_string ("gint"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp52_;
				_tmp52_ = g_strdup ("int");
				result = _tmp52_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp42_ == ((0 != _tmp41_label20) ? _tmp41_label20 : (_tmp41_label20 = g_quark_from_static_string ("guint")))) {
		switch (0) {
			default:
			{
				gchar* _tmp53_;
				_tmp53_ = g_strdup ("uint");
				result = _tmp53_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp42_ == ((0 != _tmp41_label21) ? _tmp41_label21 : (_tmp41_label21 = g_quark_from_static_string ("glong")))) {
		switch (0) {
			default:
			{
				gchar* _tmp54_;
				_tmp54_ = g_strdup ("long");
				result = _tmp54_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (((_tmp42_ == ((0 != _tmp41_label22) ? _tmp41_label22 : (_tmp41_label22 = g_quark_from_static_string ("st64")))) || (_tmp42_ == ((0 != _tmp41_label23) ? _tmp41_label23 : (_tmp41_label23 = g_quark_from_static_string ("int64"))))) || (_tmp42_ == ((0 != _tmp41_label24) ? _tmp41_label24 : (_tmp41_label24 = g_quark_from_static_string ("gint64"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp55_;
				_tmp55_ = g_strdup ("long");
				result = _tmp55_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (((_tmp42_ == ((0 != _tmp41_label25) ? _tmp41_label25 : (_tmp41_label25 = g_quark_from_static_string ("ut64")))) || (_tmp42_ == ((0 != _tmp41_label26) ? _tmp41_label26 : (_tmp41_label26 = g_quark_from_static_string ("uint64"))))) || (_tmp42_ == ((0 != _tmp41_label27) ? _tmp41_label27 : (_tmp41_label27 = g_quark_from_static_string ("guint64"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp56_;
				_tmp56_ = g_strdup ("ulong");
				result = _tmp56_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if ((_tmp42_ == ((0 != _tmp41_label28) ? _tmp41_label28 : (_tmp41_label28 = g_quark_from_static_string ("uint8*")))) || (_tmp42_ == ((0 != _tmp41_label29) ? _tmp41_label29 : (_tmp41_label29 = g_quark_from_static_string ("guint8*"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp57_;
				_tmp57_ = g_strdup ("byte*");
				result = _tmp57_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if ((_tmp42_ == ((0 != _tmp41_label30) ? _tmp41_label30 : (_tmp41_label30 = g_quark_from_static_string ("guint16")))) || (_tmp42_ == ((0 != _tmp41_label31) ? _tmp41_label31 : (_tmp41_label31 = g_quark_from_static_string ("uint16"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp58_;
				_tmp58_ = g_strdup ("ushort");
				result = _tmp58_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (((_tmp42_ == ((0 != _tmp41_label32) ? _tmp41_label32 : (_tmp41_label32 = g_quark_from_static_string ("ut32")))) || (_tmp42_ == ((0 != _tmp41_label33) ? _tmp41_label33 : (_tmp41_label33 = g_quark_from_static_string ("uint32"))))) || (_tmp42_ == ((0 != _tmp41_label34) ? _tmp41_label34 : (_tmp41_label34 = g_quark_from_static_string ("guint32"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp59_;
				_tmp59_ = g_strdup ("unsigned int");
				result = _tmp59_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if ((_tmp42_ == ((0 != _tmp41_label35) ? _tmp41_label35 : (_tmp41_label35 = g_quark_from_static_string ("bool")))) || (_tmp42_ == ((0 != _tmp41_label36) ? _tmp41_label36 : (_tmp41_label36 = g_quark_from_static_string ("gboolean"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp60_;
				_tmp60_ = g_strdup ("bool");
				result = _tmp60_;
				_g_free0 (iter_type);
				_g_free0 (type);
				return result;
			}
		}
	} else if (_tmp42_ == ((0 != _tmp41_label37) ? _tmp41_label37 : (_tmp41_label37 = g_quark_from_static_string ("RFList")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp61_;
				_tmp61_ = iter_type;
				if (_tmp61_ != NULL) {
					const gchar* _tmp62_;
					gchar* _tmp63_;
					gchar* _tmp64_;
					gchar* _tmp65_;
					gchar* _tmp66_;
					_tmp62_ = iter_type;
					_tmp63_ = g_strconcat ("std::vector<", _tmp62_, NULL);
					_tmp64_ = _tmp63_;
					_tmp65_ = g_strconcat (_tmp64_, ">", NULL);
					_tmp66_ = _tmp65_;
					_g_free0 (_tmp64_);
					result = _tmp66_;
					_g_free0 (iter_type);
					_g_free0 (type);
					return result;
				}
				break;
			}
		}
	} else if (_tmp42_ == ((0 != _tmp41_label38) ? _tmp41_label38 : (_tmp41_label38 = g_quark_from_static_string ("RList")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp67_;
				_tmp67_ = iter_type;
				if (_tmp67_ != NULL) {
					const gchar* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					_tmp68_ = iter_type;
					_tmp69_ = g_strconcat ("std::vector<", _tmp68_, NULL);
					_tmp70_ = _tmp69_;
					_tmp71_ = g_strconcat (_tmp70_, ">", NULL);
					_tmp72_ = _tmp71_;
					_g_free0 (_tmp70_);
					result = _tmp72_;
					_g_free0 (iter_type);
					_g_free0 (type);
					return result;
				}
				break;
			}
		}
	} else if (_tmp42_ == ((0 != _tmp41_label39) ? _tmp41_label39 : (_tmp41_label39 = g_quark_from_static_string ("SdbList")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp73_;
				_tmp73_ = iter_type;
				if (_tmp73_ != NULL) {
					const gchar* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					_tmp74_ = iter_type;
					_tmp75_ = g_strconcat ("std::vector<", _tmp74_, NULL);
					_tmp76_ = _tmp75_;
					_tmp77_ = g_strconcat (_tmp76_, ">", NULL);
					_tmp78_ = _tmp77_;
					_g_free0 (_tmp76_);
					result = _tmp78_;
					_g_free0 (iter_type);
					_g_free0 (type);
					return result;
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp79_;
				gchar* _tmp80_;
				_tmp79_ = type;
				_tmp80_ = g_strconcat ("_", _tmp79_, NULL);
				_g_free0 (type);
				type = _tmp80_;
				break;
			}
		}
	}
	result = type;
	_g_free0 (iter_type);
	return result;
}

static gboolean
dlang_writer_is_target_file (DlangWriter* self,
                             const gchar* path)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = ((ValabindWriter*) self)->source_files;
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp0_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			gchar* _tmp1_;
			gchar* file = NULL;
			_tmp1_ = g_strdup ((const gchar*) file_it->data);
			file = _tmp1_;
			{
				const gchar* _tmp2_;
				_tmp2_ = file;
				if (g_strcmp0 (_tmp2_, path) == 0) {
					result = TRUE;
					_g_free0 (file);
					return result;
				}
				_g_free0 (file);
			}
		}
	}
	result = FALSE;
	return result;
}

static void
dlang_writer_real_visit_source_file (ValaCodeVisitor* base,
                                     ValaSourceFile* source)
{
	DlangWriter * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (DlangWriter*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = vala_source_file_get_filename (source);
	_tmp1_ = _tmp0_;
	if (dlang_writer_is_target_file (self, _tmp1_)) {
		vala_source_file_accept_children (source, (ValaCodeVisitor*) self);
	}
}

void
dlang_writer_process_includes (DlangWriter* self,
                               ValaSymbol* s)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = vala_get_ccode_header_filenames (s);
	_tmp1_ = _tmp0_;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _vala_array_length (_tmp2_);
	_g_free0 (_tmp1_);
	{
		gchar** foo_collection = NULL;
		gint foo_collection_length1 = 0;
		gint _foo_collection_size_ = 0;
		gint foo_it = 0;
		foo_collection = _tmp4_;
		foo_collection_length1 = _tmp4__length1;
		for (foo_it = 0; foo_it < foo_collection_length1; foo_it = foo_it + 1) {
			gchar* _tmp5_;
			gchar* foo = NULL;
			_tmp5_ = g_strdup (foo_collection[foo_it]);
			foo = _tmp5_;
			{
				gboolean include = FALSE;
				GList* _tmp6_;
				include = TRUE;
				_tmp6_ = self->includefiles;
				{
					GList* inc_collection = NULL;
					GList* inc_it = NULL;
					inc_collection = _tmp6_;
					for (inc_it = inc_collection; inc_it != NULL; inc_it = inc_it->next) {
						gchar* _tmp7_;
						gchar* inc = NULL;
						_tmp7_ = g_strdup ((const gchar*) inc_it->data);
						inc = _tmp7_;
						{
							const gchar* _tmp8_;
							const gchar* _tmp9_;
							_tmp8_ = inc;
							_tmp9_ = foo;
							if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
								include = FALSE;
								_g_free0 (inc);
								break;
							}
							_g_free0 (inc);
						}
					}
				}
				if (include) {
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp10_ = foo;
					_tmp11_ = g_strdup (_tmp10_);
					self->includefiles = g_list_prepend (self->includefiles, _tmp11_);
				}
				_g_free0 (foo);
			}
		}
		foo_collection = (_vala_array_free (foo_collection, foo_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
dlang_writer_walk_field (DlangWriter* self,
                         ValaField* f)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* type = NULL;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	gchar* _tmp9_;
	gchar* name = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) f, "CCode", "type", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
	} else {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = vala_get_ccode_name ((ValaCodeNode*) f);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("Type for %s\n", _tmp4_);
		_tmp6_ = _tmp5_;
		warning (_tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	}
	_tmp7_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_code_node_to_string ((ValaCodeNode*) _tmp8_);
	type = _tmp9_;
	_tmp10_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup (_tmp11_);
	name = _tmp12_;
	_tmp13_ = type;
	if (g_strcmp0 (_tmp13_, "G") != 0) {
		const gchar* _tmp14_;
		_tmp14_ = type;
		if (string_index_of (_tmp14_, "<", 0) == -1) {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp15_ = type;
			_tmp16_ = dlang_writer_get_ctype (self, _tmp15_);
			_g_free0 (type);
			type = _tmp16_;
			_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) f);
			_tmp18_ = _tmp17_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array = NULL;
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				ValaArrayType* _tmp21_;
				gint len = 0;
				ValaArrayType* _tmp22_;
				gint _tmp23_ = 0;
				gint sz = 0;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) f);
				_tmp20_ = _tmp19_;
				_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp20_) : NULL);
				array = _tmp21_;
				_tmp22_ = array;
				len = array_length (_tmp22_);
				if (len < 0) {
					_tmp23_ = 0;
				} else {
					_tmp23_ = len;
				}
				sz = _tmp23_;
				_tmp24_ = self->priv->defs;
				_tmp25_ = type;
				_tmp26_ = name;
				_tmp27_ = g_strdup_printf ("  %s %s[%d];\n", _tmp25_, _tmp26_, sz);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp24_, _tmp28_, NULL);
				_g_free0 (self->priv->defs);
				self->priv->defs = _tmp29_;
				_g_free0 (_tmp28_);
				_vala_code_node_unref0 (array);
			} else {
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp30_ = self->priv->defs;
				_tmp31_ = type;
				_tmp32_ = name;
				_tmp33_ = g_strdup_printf ("  %s %s;\n", _tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strconcat (_tmp30_, _tmp34_, NULL);
				_g_free0 (self->priv->defs);
				self->priv->defs = _tmp35_;
				_g_free0 (_tmp34_);
			}
		}
	}
	_g_free0 (name);
	_g_free0 (type);
}

void
dlang_writer_walk_struct (DlangWriter* self,
                          const gchar* pfx,
                          ValaStruct* s)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pfx != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->defs;
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) s);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("struct _%s%s {\n", pfx, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp0_, _tmp4_, NULL);
	_g_free0 (self->priv->defs);
	self->priv->defs = _tmp5_;
	_g_free0 (_tmp4_);
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp6_;
		gint _f_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _f_index = 0;
		_tmp6_ = vala_struct_get_fields (s);
		_f_list = _tmp6_;
		_tmp7_ = _f_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_f_size = _tmp9_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaField* f = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaField* _tmp14_;
			_f_index = _f_index + 1;
			_tmp10_ = _f_index;
			_tmp11_ = _f_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _f_list;
			_tmp13_ = vala_list_get (_tmp12_, _f_index);
			f = (ValaField*) _tmp13_;
			_tmp14_ = f;
			dlang_writer_walk_field (self, _tmp14_);
			_vala_code_node_unref0 (f);
		}
	}
	_tmp15_ = self->priv->defs;
	_tmp16_ = g_strconcat (_tmp15_, "}\n", NULL);
	_g_free0 (self->priv->defs);
	self->priv->defs = _tmp16_;
}

void
dlang_writer_walk_class (DlangWriter* self,
                         const gchar* pfx,
                         ValaClass* c)
{
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean has_constructor = FALSE;
	gboolean has_destructor = FALSE;
	gboolean _tmp37_;
	gboolean _tmp38_;
	GHashTable* _tmp39_;
	const gchar* _tmp40_;
	gconstpointer _tmp41_;
	GHashTable* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gboolean _tmp80_ = FALSE;
	const gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pfx != NULL);
	g_return_if_fail (c != NULL);
	{
		ValaList* _k_list = NULL;
		ValaList* _tmp0_;
		gint _k_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _k_index = 0;
		_tmp0_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) c);
		_k_list = _tmp0_;
		_tmp1_ = _k_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_k_size = _tmp3_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaStruct* k = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			ValaStruct* _tmp10_;
			_k_index = _k_index + 1;
			_tmp4_ = _k_index;
			_tmp5_ = _k_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _k_list;
			_tmp7_ = vala_list_get (_tmp6_, _k_index);
			k = (ValaStruct*) _tmp7_;
			_tmp8_ = vala_symbol_get_name ((ValaSymbol*) c);
			_tmp9_ = _tmp8_;
			_tmp10_ = k;
			dlang_writer_walk_struct (self, _tmp9_, _tmp10_);
			_vala_code_node_unref0 (k);
		}
	}
	{
		ValaList* _k_list = NULL;
		ValaList* _tmp11_;
		gint _k_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _k_index = 0;
		_tmp11_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) c);
		_k_list = _tmp11_;
		_tmp12_ = _k_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_k_size = _tmp14_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaClass* k = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			ValaClass* _tmp21_;
			_k_index = _k_index + 1;
			_tmp15_ = _k_index;
			_tmp16_ = _k_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _k_list;
			_tmp18_ = vala_list_get (_tmp17_, _k_index);
			k = (ValaClass*) _tmp18_;
			_tmp19_ = vala_symbol_get_name ((ValaSymbol*) c);
			_tmp20_ = _tmp19_;
			_tmp21_ = k;
			dlang_writer_walk_class (self, _tmp20_, _tmp21_);
			_vala_code_node_unref0 (k);
		}
	}
	_tmp22_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (pfx, _tmp23_, NULL);
	_g_free0 (self->priv->classname);
	self->priv->classname = _tmp24_;
	_tmp25_ = vala_get_ccode_name ((ValaCodeNode*) c);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("_", _tmp26_, NULL);
	_g_free0 (self->priv->classcname);
	self->priv->classcname = _tmp27_;
	_g_free0 (_tmp26_);
	dlang_writer_process_includes (self, (ValaSymbol*) c);
	has_constructor = FALSE;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp28_;
		gint _m_size = 0;
		ValaList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _m_index = 0;
		_tmp28_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) c);
		_m_list = _tmp28_;
		_tmp29_ = _m_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_m_size = _tmp31_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			ValaMethod* m = NULL;
			ValaList* _tmp34_;
			gpointer _tmp35_;
			ValaMethod* _tmp36_;
			_m_index = _m_index + 1;
			_tmp32_ = _m_index;
			_tmp33_ = _m_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _m_list;
			_tmp35_ = vala_list_get (_tmp34_, _m_index);
			m = (ValaMethod*) _tmp35_;
			_tmp36_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_CREATION_METHOD)) {
				has_constructor = TRUE;
				_vala_code_node_unref0 (m);
				break;
			}
			_vala_code_node_unref0 (m);
		}
	}
	_tmp37_ = vala_class_get_is_compact (c);
	_tmp38_ = _tmp37_;
	has_destructor = !_tmp38_;
	_tmp39_ = self->priv->defined_classes;
	_tmp40_ = self->priv->classname;
	_tmp41_ = g_hash_table_lookup (_tmp39_, _tmp40_);
	if ((gboolean) ((gintptr) _tmp41_)) {
		return;
	}
	_tmp42_ = self->priv->defined_classes;
	_tmp43_ = self->priv->classname;
	_tmp44_ = g_strdup (_tmp43_);
	g_hash_table_insert (_tmp42_, _tmp44_, (gpointer) ((gintptr) TRUE));
	_tmp45_ = self->priv->defs;
	_tmp46_ = self->priv->classcname;
	_tmp47_ = g_strdup_printf ("struct %s {\n", _tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = g_strconcat (_tmp45_, _tmp48_, NULL);
	_g_free0 (self->priv->defs);
	self->priv->defs = _tmp49_;
	_g_free0 (_tmp48_);
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp50_;
		gint _f_size = 0;
		ValaList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _f_index = 0;
		_tmp50_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) c);
		_f_list = _tmp50_;
		_tmp51_ = _f_list;
		_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		_f_size = _tmp53_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp54_;
			gint _tmp55_;
			ValaField* f = NULL;
			ValaList* _tmp56_;
			gpointer _tmp57_;
			ValaField* _tmp58_;
			_f_index = _f_index + 1;
			_tmp54_ = _f_index;
			_tmp55_ = _f_size;
			if (!(_tmp54_ < _tmp55_)) {
				break;
			}
			_tmp56_ = _f_list;
			_tmp57_ = vala_list_get (_tmp56_, _f_index);
			f = (ValaField*) _tmp57_;
			_tmp58_ = f;
			dlang_writer_walk_field (self, _tmp58_);
			_vala_code_node_unref0 (f);
		}
	}
	_tmp59_ = self->priv->defs;
	_tmp60_ = g_strconcat (_tmp59_, "}\n", NULL);
	_g_free0 (self->priv->defs);
	self->priv->defs = _tmp60_;
	_tmp61_ = self->priv->extends;
	_tmp62_ = self->priv->classname;
	_tmp63_ = g_strdup_printf ("class %s {\n", _tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = g_strconcat (_tmp61_, _tmp64_, NULL);
	_g_free0 (self->priv->extends);
	self->priv->extends = _tmp65_;
	_g_free0 (_tmp64_);
	_tmp66_ = self->priv->extends;
	_tmp67_ = self->priv->classcname;
	_tmp68_ = g_strdup_printf ("  %s *self;\n", _tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = g_strconcat (_tmp66_, _tmp69_, NULL);
	_g_free0 (self->priv->extends);
	self->priv->extends = _tmp70_;
	_g_free0 (_tmp69_);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp71_;
		gint _e_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _e_index = 0;
		_tmp71_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) c);
		_e_list = _tmp71_;
		_tmp72_ = _e_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_e_size = _tmp74_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp75_;
			gint _tmp76_;
			ValaEnum* e = NULL;
			ValaList* _tmp77_;
			gpointer _tmp78_;
			ValaEnum* _tmp79_;
			_e_index = _e_index + 1;
			_tmp75_ = _e_index;
			_tmp76_ = _e_size;
			if (!(_tmp75_ < _tmp76_)) {
				break;
			}
			_tmp77_ = _e_list;
			_tmp78_ = vala_list_get (_tmp77_, _e_index);
			e = (ValaEnum*) _tmp78_;
			_tmp79_ = e;
			dlang_writer_walk_enum (self, _tmp79_);
			_vala_code_node_unref0 (e);
		}
	}
	if (has_destructor) {
		_tmp80_ = has_constructor;
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		if (vala_is_reference_counting ((ValaTypeSymbol*) c)) {
			gchar* freefun = NULL;
			gchar* _tmp81_;
			gboolean _tmp82_ = FALSE;
			const gchar* _tmp83_;
			_tmp81_ = vala_get_ccode_unref_function ((ValaObjectTypeSymbol*) c);
			freefun = _tmp81_;
			_tmp83_ = freefun;
			if (_tmp83_ != NULL) {
				const gchar* _tmp84_;
				_tmp84_ = freefun;
				_tmp82_ = g_strcmp0 (_tmp84_, "") != 0;
			} else {
				_tmp82_ = FALSE;
			}
			if (_tmp82_) {
				const gchar* _tmp85_;
				const gchar* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				_tmp85_ = self->priv->extends;
				_tmp86_ = freefun;
				_tmp87_ = g_strdup_printf ("  ~this() { %s (o); }\n", _tmp86_);
				_tmp88_ = _tmp87_;
				_tmp89_ = g_strconcat (_tmp85_, _tmp88_, NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp89_;
				_g_free0 (_tmp88_);
			}
			_g_free0 (freefun);
		} else {
			gchar* freefun = NULL;
			gchar* _tmp90_;
			const gchar* _tmp91_;
			_tmp90_ = vala_get_ccode_free_function ((ValaTypeSymbol*) c);
			freefun = _tmp90_;
			_tmp91_ = freefun;
			if (_tmp91_ != NULL) {
				const gchar* _tmp92_;
				const gchar* _tmp93_;
				gchar* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_;
				_tmp92_ = self->priv->extends;
				_tmp93_ = freefun;
				_tmp94_ = g_strdup_printf ("  ~this() { %s (o); }\n", _tmp93_);
				_tmp95_ = _tmp94_;
				_tmp96_ = g_strconcat (_tmp92_, _tmp95_, NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp96_;
				_g_free0 (_tmp95_);
			}
			_g_free0 (freefun);
		}
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp97_;
		gint _m_size = 0;
		ValaList* _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		gint _m_index = 0;
		_tmp97_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) c);
		_m_list = _tmp97_;
		_tmp98_ = _m_list;
		_tmp99_ = vala_collection_get_size ((ValaCollection*) _tmp98_);
		_tmp100_ = _tmp99_;
		_m_size = _tmp100_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp101_;
			gint _tmp102_;
			ValaMethod* m = NULL;
			ValaList* _tmp103_;
			gpointer _tmp104_;
			ValaMethod* _tmp105_;
			_m_index = _m_index + 1;
			_tmp101_ = _m_index;
			_tmp102_ = _m_size;
			if (!(_tmp101_ < _tmp102_)) {
				break;
			}
			_tmp103_ = _m_list;
			_tmp104_ = vala_list_get (_tmp103_, _m_index);
			m = (ValaMethod*) _tmp104_;
			_tmp105_ = m;
			dlang_writer_walk_method (self, _tmp105_);
			_vala_code_node_unref0 (m);
		}
	}
	_tmp106_ = self->priv->extends;
	_tmp107_ = g_strconcat (_tmp106_, "};\n", NULL);
	_g_free0 (self->priv->extends);
	self->priv->extends = _tmp107_;
	_tmp108_ = g_strdup ("");
	_g_free0 (self->priv->classname);
	self->priv->classname = _tmp108_;
}

void
dlang_writer_walk_enum (DlangWriter* self,
                        ValaEnum* e)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
}

static inline gboolean
dlang_writer_is_generic (DlangWriter* self,
                         const gchar* type)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (string_index_of (type, "<", 0) != -1) {
		_tmp0_ = string_index_of (type, ">", 0) != -1;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
dlang_writer_walk_method (DlangWriter* self,
                          ValaMethod* m)
{
	gboolean first = FALSE;
	gchar* cname = NULL;
	gchar* _tmp0_;
	gchar* alias = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* ret = NULL;
	gchar* def_args = NULL;
	gchar* _tmp4_;
	gchar* cdef_args = NULL;
	gchar* _tmp5_;
	gchar* call_args = NULL;
	gchar* _tmp6_;
	gboolean void_return = FALSE;
	gboolean is_static = FALSE;
	ValaMemberBinding _tmp7_;
	ValaMemberBinding _tmp8_;
	gboolean is_constructor = FALSE;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp24_;
	gchar* pfx = NULL;
	gchar* _tmp25_;
	gchar* cpfx = NULL;
	gchar* _tmp26_;
	const gchar* _tmp114_;
	const gchar* _tmp117_;
	const gchar* _tmp118_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	first = TRUE;
	_tmp0_ = vala_get_ccode_name ((ValaCodeNode*) m);
	cname = _tmp0_;
	_tmp1_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp2_ = _tmp1_;
	_tmp3_ = dlang_writer_get_alias (self, _tmp2_);
	alias = _tmp3_;
	_tmp4_ = g_strdup ("");
	def_args = _tmp4_;
	_tmp5_ = g_strdup ("");
	cdef_args = _tmp5_;
	_tmp6_ = g_strdup ("");
	call_args = _tmp6_;
	_tmp7_ = vala_method_get_binding (m);
	_tmp8_ = _tmp7_;
	is_static = (_tmp8_ & VALA_MEMBER_BINDING_STATIC) != 0;
	is_constructor = G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD);
	_tmp9_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
	_g_free0 (ret);
	ret = _tmp11_;
	_tmp13_ = ret;
	if (dlang_writer_is_generic (self, _tmp13_)) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = ret;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (_tmp12_);
		_tmp12_ = _tmp15_;
	} else {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_get_ccode_name ((ValaCodeNode*) _tmp17_);
		_g_free0 (_tmp12_);
		_tmp12_ = _tmp18_;
	}
	_tmp19_ = dlang_writer_get_ctype (self, _tmp12_);
	_g_free0 (ret);
	ret = _tmp19_;
	_tmp20_ = ret;
	if (_tmp20_ == NULL) {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = cname;
		_tmp22_ = g_strdup_printf ("Cannot resolve return type for %s\n", _tmp21_);
		_tmp23_ = _tmp22_;
		error (_tmp23_);
		_g_free0 (_tmp23_);
	}
	_tmp24_ = ret;
	void_return = g_strcmp0 (_tmp24_, "void") == 0;
	if (vala_symbol_is_private_symbol ((ValaSymbol*) m)) {
		_g_free0 (_tmp12_);
		_g_free0 (call_args);
		_g_free0 (cdef_args);
		_g_free0 (def_args);
		_g_free0 (ret);
		_g_free0 (alias);
		_g_free0 (cname);
		return;
	}
	_tmp25_ = g_strdup ("");
	pfx = _tmp25_;
	_tmp26_ = g_strdup ("");
	cpfx = _tmp26_;
	if (!is_static) {
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp27_ = cdef_args;
		_tmp28_ = self->priv->classcname;
		_tmp29_ = g_strconcat (_tmp28_, "*", NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp27_, _tmp30_, NULL);
		_g_free0 (cdef_args);
		cdef_args = _tmp31_;
		_g_free0 (_tmp30_);
		_tmp32_ = g_strdup (", ");
		_g_free0 (cpfx);
		cpfx = _tmp32_;
		_tmp33_ = g_strdup ("");
		_g_free0 (pfx);
		pfx = _tmp33_;
	}
	{
		ValaList* _foo_list = NULL;
		ValaList* _tmp34_;
		gint _foo_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _foo_index = 0;
		_tmp34_ = vala_callable_get_parameters ((ValaCallable*) m);
		_foo_list = _tmp34_;
		_tmp35_ = _foo_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_foo_size = _tmp37_;
		_foo_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			ValaParameter* foo = NULL;
			ValaList* _tmp40_;
			gpointer _tmp41_;
			gchar* arg_name = NULL;
			ValaParameter* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			ValaDataType* bar = NULL;
			ValaParameter* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			gchar* arg_type = NULL;
			ValaDataType* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			ValaParameter* _tmp59_;
			ValaParameterDirection _tmp60_;
			ValaParameterDirection _tmp61_;
			const gchar* _tmp74_;
			_foo_index = _foo_index + 1;
			_tmp38_ = _foo_index;
			_tmp39_ = _foo_size;
			if (!(_tmp38_ < _tmp39_)) {
				break;
			}
			_tmp40_ = _foo_list;
			_tmp41_ = vala_list_get (_tmp40_, _foo_index);
			foo = (ValaParameter*) _tmp41_;
			_tmp42_ = foo;
			_tmp43_ = vala_symbol_get_name ((ValaSymbol*) _tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strdup (_tmp44_);
			arg_name = _tmp45_;
			_tmp46_ = foo;
			_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (_tmp48_);
			bar = _tmp49_;
			_tmp50_ = bar;
			if (_tmp50_ == NULL) {
				_vala_code_node_unref0 (bar);
				_g_free0 (arg_name);
				_vala_code_node_unref0 (foo);
				continue;
			}
			_tmp51_ = bar;
			_tmp52_ = vala_get_ccode_name ((ValaCodeNode*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = dlang_writer_get_ctype (self, _tmp53_);
			_tmp55_ = _tmp54_;
			_g_free0 (_tmp53_);
			arg_type = _tmp55_;
			if (first) {
				first = FALSE;
			} else {
				gchar* _tmp56_;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				_tmp56_ = g_strdup (", ");
				_g_free0 (pfx);
				pfx = _tmp56_;
				_tmp57_ = pfx;
				_tmp58_ = g_strdup (_tmp57_);
				_g_free0 (cpfx);
				cpfx = _tmp58_;
			}
			_tmp59_ = foo;
			_tmp60_ = vala_parameter_get_direction (_tmp59_);
			_tmp61_ = _tmp60_;
			if (_tmp61_ != VALA_PARAMETER_DIRECTION_IN) {
				gchar* var_name = NULL;
				gchar* _tmp62_;
				ValaParameter* _tmp63_;
				ValaParameterDirection _tmp64_;
				ValaParameterDirection _tmp65_;
				const gchar* _tmp71_;
				_tmp62_ = g_strdup ("");
				var_name = _tmp62_;
				_tmp63_ = foo;
				_tmp64_ = vala_parameter_get_direction (_tmp63_);
				_tmp65_ = _tmp64_;
				if (_tmp65_ == VALA_PARAMETER_DIRECTION_OUT) {
					gchar* _tmp66_;
					_tmp66_ = g_strdup ("ref");
					_g_free0 (var_name);
					var_name = _tmp66_;
				} else {
					ValaParameter* _tmp67_;
					ValaParameterDirection _tmp68_;
					ValaParameterDirection _tmp69_;
					_tmp67_ = foo;
					_tmp68_ = vala_parameter_get_direction (_tmp67_);
					_tmp69_ = _tmp68_;
					if (_tmp69_ == VALA_PARAMETER_DIRECTION_REF) {
						gchar* _tmp70_;
						_tmp70_ = g_strdup ("ref");
						_g_free0 (var_name);
						var_name = _tmp70_;
					}
				}
				_tmp71_ = arg_type;
				if (string_index_of (_tmp71_, "*", 0) == -1) {
					const gchar* _tmp72_;
					gchar* _tmp73_;
					_tmp72_ = arg_type;
					_tmp73_ = g_strconcat (_tmp72_, "*", NULL);
					_g_free0 (arg_type);
					arg_type = _tmp73_;
				}
				_g_free0 (var_name);
			}
			_tmp74_ = arg_type;
			if (g_strcmp0 (_tmp74_, "string") == 0) {
				const gchar* _tmp75_;
				const gchar* _tmp76_;
				const gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				const gchar* _tmp81_;
				const gchar* _tmp82_;
				const gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				const gchar* _tmp87_;
				const gchar* _tmp88_;
				const gchar* _tmp89_;
				const gchar* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				_tmp75_ = call_args;
				_tmp76_ = pfx;
				_tmp77_ = arg_name;
				_tmp78_ = g_strdup_printf ("%s toStringz(%s)", _tmp76_, _tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = g_strconcat (_tmp75_, _tmp79_, NULL);
				_g_free0 (call_args);
				call_args = _tmp80_;
				_g_free0 (_tmp79_);
				_tmp81_ = cdef_args;
				_tmp82_ = cpfx;
				_tmp83_ = arg_name;
				_tmp84_ = g_strdup_printf ("%s%s %s", _tmp82_, "immutable(char*)", _tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = g_strconcat (_tmp81_, _tmp85_, NULL);
				_g_free0 (cdef_args);
				cdef_args = _tmp86_;
				_g_free0 (_tmp85_);
				_tmp87_ = def_args;
				_tmp88_ = pfx;
				_tmp89_ = arg_type;
				_tmp90_ = arg_name;
				_tmp91_ = g_strdup_printf ("%s%s %s", _tmp88_, _tmp89_, _tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = g_strconcat (_tmp87_, _tmp92_, NULL);
				_g_free0 (def_args);
				def_args = _tmp93_;
				_g_free0 (_tmp92_);
			} else {
				const gchar* _tmp94_;
				const gchar* _tmp95_;
				const gchar* _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				gchar* _tmp99_;
				const gchar* _tmp100_;
				const gchar* _tmp101_;
				const gchar* _tmp102_;
				const gchar* _tmp103_;
				gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp106_;
				const gchar* _tmp107_;
				const gchar* _tmp108_;
				const gchar* _tmp109_;
				const gchar* _tmp110_;
				gchar* _tmp111_;
				gchar* _tmp112_;
				gchar* _tmp113_;
				_tmp94_ = call_args;
				_tmp95_ = pfx;
				_tmp96_ = arg_name;
				_tmp97_ = g_strdup_printf ("%s%s", _tmp95_, _tmp96_);
				_tmp98_ = _tmp97_;
				_tmp99_ = g_strconcat (_tmp94_, _tmp98_, NULL);
				_g_free0 (call_args);
				call_args = _tmp99_;
				_g_free0 (_tmp98_);
				_tmp100_ = def_args;
				_tmp101_ = pfx;
				_tmp102_ = arg_type;
				_tmp103_ = arg_name;
				_tmp104_ = g_strdup_printf ("%s%s %s", _tmp101_, _tmp102_, _tmp103_);
				_tmp105_ = _tmp104_;
				_tmp106_ = g_strconcat (_tmp100_, _tmp105_, NULL);
				_g_free0 (def_args);
				def_args = _tmp106_;
				_g_free0 (_tmp105_);
				_tmp107_ = cdef_args;
				_tmp108_ = cpfx;
				_tmp109_ = arg_type;
				_tmp110_ = arg_name;
				_tmp111_ = g_strdup_printf ("%s%s %s", _tmp108_, _tmp109_, _tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = g_strconcat (_tmp107_, _tmp112_, NULL);
				_g_free0 (cdef_args);
				cdef_args = _tmp113_;
				_g_free0 (_tmp112_);
			}
			_g_free0 (arg_type);
			_vala_code_node_unref0 (bar);
			_g_free0 (arg_name);
			_vala_code_node_unref0 (foo);
		}
	}
	_tmp114_ = self->priv->classname;
	if (g_strcmp0 (_tmp114_, "") == 0) {
		const gchar* _tmp115_;
		gchar* _tmp116_;
		is_constructor = FALSE;
		is_static = TRUE;
		_tmp115_ = self->priv->nspace;
		_tmp116_ = g_strdup (_tmp115_);
		_g_free0 (self->priv->classname);
		self->priv->classname = _tmp116_;
	}
	_tmp117_ = self->priv->nspace;
	_tmp118_ = self->priv->classname;
	if (g_strcmp0 (_tmp117_, _tmp118_) == 0) {
		const gchar* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		const gchar* _tmp122_;
		gchar* _tmp123_;
		_tmp119_ = self->priv->nspace;
		_tmp120_ = g_strconcat (_tmp119_, "_", NULL);
		_tmp121_ = _tmp120_;
		_tmp122_ = alias;
		_tmp123_ = g_strconcat (_tmp121_, _tmp122_, NULL);
		_g_free0 (alias);
		alias = _tmp123_;
		_g_free0 (_tmp121_);
	}
	if (is_constructor) {
		const gchar* _tmp124_;
		const gchar* _tmp125_;
		const gchar* _tmp126_;
		const gchar* _tmp127_;
		gchar* _tmp128_;
		gchar* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		const gchar* _tmp133_;
		const gchar* _tmp134_;
		gchar* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		const gchar* _tmp138_;
		const gchar* _tmp139_;
		const gchar* _tmp140_;
		gchar* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		_tmp124_ = self->priv->defs;
		_tmp125_ = self->priv->classcname;
		_tmp126_ = cname;
		_tmp127_ = def_args;
		_tmp128_ = string_replace (_tmp127_, "string", "immutable(char*)");
		_tmp129_ = _tmp128_;
		_tmp130_ = g_strdup_printf ("  %s* %s(%s);\n", _tmp125_, _tmp126_, _tmp129_);
		_tmp131_ = _tmp130_;
		_tmp132_ = g_strconcat (_tmp124_, _tmp131_, NULL);
		_g_free0 (self->priv->defs);
		self->priv->defs = _tmp132_;
		_g_free0 (_tmp131_);
		_g_free0 (_tmp129_);
		_tmp133_ = self->priv->extends;
		_tmp134_ = def_args;
		_tmp135_ = g_strdup_printf ("  this (%s) {\n", _tmp134_);
		_tmp136_ = _tmp135_;
		_tmp137_ = g_strconcat (_tmp133_, _tmp136_, NULL);
		_g_free0 (self->priv->extends);
		self->priv->extends = _tmp137_;
		_g_free0 (_tmp136_);
		_tmp138_ = self->priv->extends;
		_tmp139_ = cname;
		_tmp140_ = call_args;
		_tmp141_ = g_strdup_printf ("    self = %s (%s);\n  }\n", _tmp139_, _tmp140_);
		_tmp142_ = _tmp141_;
		_tmp143_ = g_strconcat (_tmp138_, _tmp142_, NULL);
		_g_free0 (self->priv->extends);
		self->priv->extends = _tmp143_;
		_g_free0 (_tmp142_);
	} else {
		const gchar* _tmp169_;
		if (!is_static) {
			gchar* _tmp144_ = NULL;
			const gchar* _tmp145_;
			gchar* _tmp149_;
			_tmp145_ = call_args;
			if (g_strcmp0 (_tmp145_, "") == 0) {
				gchar* _tmp146_;
				_tmp146_ = g_strdup ("self");
				_g_free0 (_tmp144_);
				_tmp144_ = _tmp146_;
			} else {
				const gchar* _tmp147_;
				gchar* _tmp148_;
				_tmp147_ = call_args;
				_tmp148_ = g_strconcat ("self, ", _tmp147_, NULL);
				_g_free0 (_tmp144_);
				_tmp144_ = _tmp148_;
			}
			_tmp149_ = g_strdup (_tmp144_);
			_g_free0 (call_args);
			call_args = _tmp149_;
			_g_free0 (_tmp144_);
		}
		if (is_static) {
			const gchar* _tmp150_;
			const gchar* _tmp151_;
			const gchar* _tmp152_;
			const gchar* _tmp153_;
			gchar* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			_tmp150_ = self->priv->extends;
			_tmp151_ = ret;
			_tmp152_ = alias;
			_tmp153_ = def_args;
			_tmp154_ = g_strdup_printf ("  %s %s (%s) {\n", _tmp151_, _tmp152_, _tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = g_strconcat (_tmp150_, _tmp155_, NULL);
			_g_free0 (self->priv->extends);
			self->priv->extends = _tmp156_;
			_g_free0 (_tmp155_);
		} else {
			gchar* fret = NULL;
			gchar* _tmp157_;
			const gchar* _tmp158_;
			const gchar* _tmp162_;
			const gchar* _tmp163_;
			const gchar* _tmp164_;
			const gchar* _tmp165_;
			gchar* _tmp166_;
			gchar* _tmp167_;
			gchar* _tmp168_;
			_tmp157_ = g_strdup ("");
			fret = _tmp157_;
			_tmp158_ = alias;
			if (g_strcmp0 (_tmp158_, "free") == 0) {
				gchar* _tmp159_;
				_tmp159_ = g_strdup ("~this");
				_g_free0 (alias);
				alias = _tmp159_;
			} else {
				const gchar* _tmp160_;
				gchar* _tmp161_;
				_tmp160_ = ret;
				_tmp161_ = g_strdup (_tmp160_);
				_g_free0 (fret);
				fret = _tmp161_;
			}
			_tmp162_ = self->priv->extends;
			_tmp163_ = fret;
			_tmp164_ = alias;
			_tmp165_ = def_args;
			_tmp166_ = g_strdup_printf ("  %s %s (%s) {\n", _tmp163_, _tmp164_, _tmp165_);
			_tmp167_ = _tmp166_;
			_tmp168_ = g_strconcat (_tmp162_, _tmp167_, NULL);
			_g_free0 (self->priv->extends);
			self->priv->extends = _tmp168_;
			_g_free0 (_tmp167_);
			_g_free0 (fret);
		}
		_tmp169_ = ret;
		if (string_index_of (_tmp169_, "std::vector", 0) != -1) {
			gint ptr = 0;
			const gchar* _tmp170_;
			gchar* _tmp171_ = NULL;
			gchar* iter_type = NULL;
			gchar* _tmp179_;
			const gchar* _tmp180_;
			gchar* _tmp181_;
			const gchar* _tmp182_;
			gchar* _tmp183_;
			const gchar* _tmp184_;
			ValaDataType* _tmp185_;
			ValaDataType* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			gboolean _tmp189_;
			const gchar* _tmp259_;
			const gchar* _tmp260_;
			const gchar* _tmp261_;
			gchar* _tmp262_;
			gchar* _tmp263_;
			gchar* _tmp264_;
			_tmp170_ = ret;
			ptr = string_index_of (_tmp170_, "<", 0);
			if (ptr == -1) {
				const gchar* _tmp172_;
				gchar* _tmp173_;
				_tmp172_ = ret;
				_tmp173_ = g_strdup (_tmp172_);
				_g_free0 (_tmp171_);
				_tmp171_ = _tmp173_;
			} else {
				const gchar* _tmp174_;
				const gchar* _tmp175_;
				gint _tmp176_;
				gint _tmp177_;
				gchar* _tmp178_;
				_tmp174_ = ret;
				_tmp175_ = ret;
				_tmp176_ = strlen (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = string_slice (_tmp174_, (glong) ptr, (glong) _tmp177_);
				_g_free0 (_tmp171_);
				_tmp171_ = _tmp178_;
			}
			_tmp179_ = g_strdup (_tmp171_);
			iter_type = _tmp179_;
			_tmp180_ = iter_type;
			_tmp181_ = string_replace (_tmp180_, "<", "");
			_g_free0 (iter_type);
			iter_type = _tmp181_;
			_tmp182_ = iter_type;
			_tmp183_ = string_replace (_tmp182_, ">", "");
			_g_free0 (iter_type);
			iter_type = _tmp183_;
			_tmp184_ = iter_type;
			if (g_strcmp0 (_tmp184_, "G*") == 0) {
				error ("Pancake's fault, no <G> type support.\n");
			}
			_tmp185_ = vala_callable_get_return_type ((ValaCallable*) m);
			_tmp186_ = _tmp185_;
			_tmp187_ = vala_code_node_to_string ((ValaCodeNode*) _tmp186_);
			_tmp188_ = _tmp187_;
			_tmp189_ = string_index_of (_tmp188_, "RFList", 0) != -1;
			_g_free0 (_tmp188_);
			if (_tmp189_) {
				const gchar* _tmp190_;
				const gchar* _tmp191_;
				gchar* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				const gchar* _tmp195_;
				gchar* _tmp196_;
				const gchar* _tmp197_;
				const gchar* _tmp198_;
				gchar* _tmp199_;
				gchar* _tmp200_;
				gchar* _tmp201_;
				const gchar* _tmp202_;
				const gchar* _tmp203_;
				const gchar* _tmp204_;
				gchar* _tmp205_;
				gchar* _tmp206_;
				gchar* _tmp207_;
				const gchar* _tmp208_;
				gchar* _tmp209_;
				const gchar* _tmp210_;
				const gchar* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				gchar* _tmp214_;
				const gchar* _tmp215_;
				gchar* _tmp216_;
				const gchar* _tmp217_;
				gchar* _tmp218_;
				const gchar* _tmp219_;
				gchar* _tmp220_;
				_tmp190_ = self->priv->extends;
				_tmp191_ = ret;
				_tmp192_ = g_strdup_printf ("    %s ret;\n", _tmp191_);
				_tmp193_ = _tmp192_;
				_tmp194_ = g_strconcat (_tmp190_, _tmp193_, NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp194_;
				_g_free0 (_tmp193_);
				_tmp195_ = self->priv->extends;
				_tmp196_ = g_strconcat (_tmp195_, "    void** array;\n", NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp196_;
				_tmp197_ = self->priv->extends;
				_tmp198_ = iter_type;
				_tmp199_ = g_strdup_printf ("    %s *item;\n", _tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = g_strconcat (_tmp197_, _tmp200_, NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp201_;
				_g_free0 (_tmp200_);
				_tmp202_ = self->priv->extends;
				_tmp203_ = cname;
				_tmp204_ = call_args;
				_tmp205_ = g_strdup_printf ("    array = %s (%s);\n", _tmp203_, _tmp204_);
				_tmp206_ = _tmp205_;
				_tmp207_ = g_strconcat (_tmp202_, _tmp206_, NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp207_;
				_g_free0 (_tmp206_);
				_tmp208_ = self->priv->extends;
				_tmp209_ = g_strconcat (_tmp208_, "    r_flist_rewind (array);\n", NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp209_;
				_tmp210_ = self->priv->extends;
				_tmp211_ = iter_type;
				_tmp212_ = g_strdup_printf ("    while (*array != 0 && (item = (%s*)(*array++)))\n", _tmp211_);
				_tmp213_ = _tmp212_;
				_tmp214_ = g_strconcat (_tmp210_, _tmp213_, NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp214_;
				_g_free0 (_tmp213_);
				_tmp215_ = self->priv->extends;
				_tmp216_ = g_strconcat (_tmp215_, "        ret.push_back(*item);\n", NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp216_;
				_tmp217_ = self->priv->extends;
				_tmp218_ = g_strconcat (_tmp217_, "    return ret;\n", NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp218_;
				_tmp219_ = self->priv->extends;
				_tmp220_ = g_strconcat (_tmp219_, "  }\n", NULL);
				_g_free0 (self->priv->extends);
				self->priv->extends = _tmp220_;
			} else {
				ValaDataType* _tmp221_;
				ValaDataType* _tmp222_;
				gchar* _tmp223_;
				gchar* _tmp224_;
				gboolean _tmp225_;
				_tmp221_ = vala_callable_get_return_type ((ValaCallable*) m);
				_tmp222_ = _tmp221_;
				_tmp223_ = vala_code_node_to_string ((ValaCodeNode*) _tmp222_);
				_tmp224_ = _tmp223_;
				_tmp225_ = string_index_of (_tmp224_, "RList", 0) != -1;
				_g_free0 (_tmp224_);
				if (_tmp225_) {
					const gchar* _tmp226_;
					const gchar* _tmp227_;
					gchar* _tmp228_;
					gchar* _tmp229_;
					gchar* _tmp230_;
					const gchar* _tmp231_;
					gchar* _tmp232_;
					const gchar* _tmp233_;
					gchar* _tmp234_;
					const gchar* _tmp235_;
					const gchar* _tmp236_;
					gchar* _tmp237_;
					gchar* _tmp238_;
					gchar* _tmp239_;
					const gchar* _tmp240_;
					const gchar* _tmp241_;
					const gchar* _tmp242_;
					gchar* _tmp243_;
					gchar* _tmp244_;
					gchar* _tmp245_;
					const gchar* _tmp246_;
					gchar* _tmp247_;
					const gchar* _tmp248_;
					const gchar* _tmp249_;
					gchar* _tmp250_;
					gchar* _tmp251_;
					gchar* _tmp252_;
					const gchar* _tmp253_;
					gchar* _tmp254_;
					const gchar* _tmp255_;
					gchar* _tmp256_;
					const gchar* _tmp257_;
					gchar* _tmp258_;
					_tmp226_ = self->priv->extends;
					_tmp227_ = ret;
					_tmp228_ = g_strdup_printf ("    %s ret;\n", _tmp227_);
					_tmp229_ = _tmp228_;
					_tmp230_ = g_strconcat (_tmp226_, _tmp229_, NULL);
					_g_free0 (self->priv->extends);
					self->priv->extends = _tmp230_;
					_g_free0 (_tmp229_);
					_tmp231_ = self->priv->extends;
					_tmp232_ = g_strconcat (_tmp231_, "    RList *list;\n", NULL);
					_g_free0 (self->priv->extends);
					self->priv->extends = _tmp232_;
					_tmp233_ = self->priv->extends;
					_tmp234_ = g_strconcat (_tmp233_, "    RListIter *iter;\n", NULL);
					_g_free0 (self->priv->extends);
					self->priv->extends = _tmp234_;
					_tmp235_ = self->priv->extends;
					_tmp236_ = iter_type;
					_tmp237_ = g_strdup_printf ("    %s *item;\n", _tmp236_);
					_tmp238_ = _tmp237_;
					_tmp239_ = g_strconcat (_tmp235_, _tmp238_, NULL);
					_g_free0 (self->priv->extends);
					self->priv->extends = _tmp239_;
					_g_free0 (_tmp238_);
					_tmp240_ = self->priv->extends;
					_tmp241_ = cname;
					_tmp242_ = call_args;
					_tmp243_ = g_strdup_printf ("    list = %s (%s);\n", _tmp241_, _tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = g_strconcat (_tmp240_, _tmp244_, NULL);
					_g_free0 (self->priv->extends);
					self->priv->extends = _tmp245_;
					_g_free0 (_tmp244_);
					_tmp246_ = self->priv->extends;
					_tmp247_ = g_strconcat (_tmp246_, "    if (list)\n", NULL);
					_g_free0 (self->priv->extends);
					self->priv->extends = _tmp247_;
					_tmp248_ = self->priv->extends;
					_tmp249_ = iter_type;
					_tmp250_ = g_strdup_printf ("    for (iter = list->head; iter && (item = (%s*)iter->data); iter = i" \
"ter->n)\n", _tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = g_strconcat (_tmp248_, _tmp251_, NULL);
					_g_free0 (self->priv->extends);
					self->priv->extends = _tmp252_;
					_g_free0 (_tmp251_);
					_tmp253_ = self->priv->extends;
					_tmp254_ = g_strconcat (_tmp253_, "        ret.push_back(*item);\n", NULL);
					_g_free0 (self->priv->extends);
					self->priv->extends = _tmp254_;
					_tmp255_ = self->priv->extends;
					_tmp256_ = g_strconcat (_tmp255_, "    return ret;\n", NULL);
					_g_free0 (self->priv->extends);
					self->priv->extends = _tmp256_;
					_tmp257_ = self->priv->extends;
					_tmp258_ = g_strconcat (_tmp257_, "  }\n", NULL);
					_g_free0 (self->priv->extends);
					self->priv->extends = _tmp258_;
				}
			}
			_tmp259_ = self->priv->vectors;
			_tmp260_ = iter_type;
			_tmp261_ = iter_type;
			_tmp262_ = g_strdup_printf ("  %%template(%sVector) std::vector<%s>;\n", _tmp260_, _tmp261_);
			_tmp263_ = _tmp262_;
			_tmp264_ = g_strconcat (_tmp259_, _tmp263_, NULL);
			_g_free0 (self->priv->vectors);
			self->priv->vectors = _tmp264_;
			_g_free0 (_tmp263_);
			_g_free0 (iter_type);
			_g_free0 (_tmp171_);
		} else {
			const gchar* _tmp265_;
			const gchar* _tmp266_;
			const gchar* _tmp267_;
			const gchar* _tmp268_;
			gchar* _tmp269_;
			gchar* _tmp270_;
			gchar* _tmp271_;
			const gchar* _tmp272_ = NULL;
			const gchar* _tmp273_;
			const gchar* _tmp274_;
			const gchar* _tmp275_;
			gchar* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			_tmp265_ = self->priv->defs;
			_tmp266_ = ret;
			_tmp267_ = cname;
			_tmp268_ = cdef_args;
			_tmp269_ = g_strdup_printf ("  %s %s(%s);\n", _tmp266_, _tmp267_, _tmp268_);
			_tmp270_ = _tmp269_;
			_tmp271_ = g_strconcat (_tmp265_, _tmp270_, NULL);
			_g_free0 (self->priv->defs);
			self->priv->defs = _tmp271_;
			_g_free0 (_tmp270_);
			if (void_return) {
				_tmp272_ = "";
			} else {
				_tmp272_ = "return";
			}
			_tmp273_ = self->priv->extends;
			_tmp274_ = cname;
			_tmp275_ = call_args;
			_tmp276_ = g_strdup_printf ("    %s %s (%s);\n  }\n", _tmp272_, _tmp274_, _tmp275_);
			_tmp277_ = _tmp276_;
			_tmp278_ = g_strconcat (_tmp273_, _tmp277_, NULL);
			_g_free0 (self->priv->extends);
			self->priv->extends = _tmp278_;
			_g_free0 (_tmp277_);
		}
	}
	_g_free0 (cpfx);
	_g_free0 (pfx);
	_g_free0 (_tmp12_);
	_g_free0 (call_args);
	_g_free0 (cdef_args);
	_g_free0 (def_args);
	_g_free0 (ret);
	_g_free0 (alias);
	_g_free0 (cname);
}

static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}

static void
dlang_writer_real_visit_namespace (ValaCodeVisitor* base,
                                   ValaNamespace* ns)
{
	DlangWriter * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	ValaSourceReference* sr = NULL;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaSourceReference* _tmp7_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp71_ = NULL;
	const gchar* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	gchar* classprefix = NULL;
	gchar* _tmp77_;
	self = (DlangWriter*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->classname);
	self->priv->classname = _tmp2_;
	_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_source_reference_ref0 (_tmp4_);
	sr = _tmp5_;
	_tmp7_ = sr;
	if (_tmp7_ != NULL) {
		ValaSourceReference* _tmp8_;
		ValaSourceFile* _tmp9_;
		ValaSourceFile* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = sr;
		_tmp9_ = vala_source_reference_get_file (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_source_file_get_filename (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp6_ = !dlang_writer_is_target_file (self, _tmp12_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_vala_source_reference_unref0 (sr);
		return;
	}
	_tmp13_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (self->priv->nspace);
	self->priv->nspace = _tmp15_;
	dlang_writer_process_includes (self, (ValaSymbol*) ns);
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp16_;
		gint _f_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _f_index = 0;
		_tmp16_ = vala_namespace_get_fields (ns);
		_f_list = _tmp16_;
		_tmp17_ = _f_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_f_size = _tmp19_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			ValaField* f = NULL;
			ValaList* _tmp22_;
			gpointer _tmp23_;
			ValaField* _tmp24_;
			_f_index = _f_index + 1;
			_tmp20_ = _f_index;
			_tmp21_ = _f_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _f_list;
			_tmp23_ = vala_list_get (_tmp22_, _f_index);
			f = (ValaField*) _tmp23_;
			_tmp24_ = f;
			dlang_writer_walk_field (self, _tmp24_);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp25_;
		gint _e_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _e_index = 0;
		_tmp25_ = vala_namespace_get_enums (ns);
		_e_list = _tmp25_;
		_tmp26_ = _e_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_e_size = _tmp28_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			ValaEnum* e = NULL;
			ValaList* _tmp31_;
			gpointer _tmp32_;
			ValaEnum* _tmp33_;
			_e_index = _e_index + 1;
			_tmp29_ = _e_index;
			_tmp30_ = _e_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _e_list;
			_tmp32_ = vala_list_get (_tmp31_, _e_index);
			e = (ValaEnum*) _tmp32_;
			_tmp33_ = e;
			dlang_writer_walk_enum (self, _tmp33_);
			_vala_code_node_unref0 (e);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp34_;
		gint _c_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _c_index = 0;
		_tmp34_ = vala_namespace_get_structs (ns);
		_c_list = _tmp34_;
		_tmp35_ = _c_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_c_size = _tmp37_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			ValaStruct* c = NULL;
			ValaList* _tmp40_;
			gpointer _tmp41_;
			_c_index = _c_index + 1;
			_tmp38_ = _c_index;
			_tmp39_ = _c_size;
			if (!(_tmp38_ < _tmp39_)) {
				break;
			}
			_tmp40_ = _c_list;
			_tmp41_ = vala_list_get (_tmp40_, _c_index);
			c = (ValaStruct*) _tmp41_;
			{
				ValaList* _m_list = NULL;
				ValaStruct* _tmp42_;
				ValaList* _tmp43_;
				gint _m_size = 0;
				ValaList* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				gint _m_index = 0;
				_tmp42_ = c;
				_tmp43_ = vala_struct_get_methods (_tmp42_);
				_m_list = _tmp43_;
				_tmp44_ = _m_list;
				_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
				_tmp46_ = _tmp45_;
				_m_size = _tmp46_;
				_m_index = -1;
				while (TRUE) {
					gint _tmp47_;
					gint _tmp48_;
					ValaMethod* m = NULL;
					ValaList* _tmp49_;
					gpointer _tmp50_;
					ValaMethod* _tmp51_;
					_m_index = _m_index + 1;
					_tmp47_ = _m_index;
					_tmp48_ = _m_size;
					if (!(_tmp47_ < _tmp48_)) {
						break;
					}
					_tmp49_ = _m_list;
					_tmp50_ = vala_list_get (_tmp49_, _m_index);
					m = (ValaMethod*) _tmp50_;
					_tmp51_ = m;
					dlang_writer_walk_method (self, _tmp51_);
					_vala_code_node_unref0 (m);
				}
			}
			{
				ValaList* _f_list = NULL;
				ValaStruct* _tmp52_;
				ValaList* _tmp53_;
				gint _f_size = 0;
				ValaList* _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				gint _f_index = 0;
				_tmp52_ = c;
				_tmp53_ = vala_struct_get_fields (_tmp52_);
				_f_list = _tmp53_;
				_tmp54_ = _f_list;
				_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
				_tmp56_ = _tmp55_;
				_f_size = _tmp56_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp57_;
					gint _tmp58_;
					ValaField* f = NULL;
					ValaList* _tmp59_;
					gpointer _tmp60_;
					ValaField* _tmp61_;
					_f_index = _f_index + 1;
					_tmp57_ = _f_index;
					_tmp58_ = _f_size;
					if (!(_tmp57_ < _tmp58_)) {
						break;
					}
					_tmp59_ = _f_list;
					_tmp60_ = vala_list_get (_tmp59_, _f_index);
					f = (ValaField*) _tmp60_;
					_tmp61_ = f;
					dlang_writer_walk_field (self, _tmp61_);
					_vala_code_node_unref0 (f);
				}
			}
			_vala_code_node_unref0 (c);
		}
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp62_;
		gint _m_size = 0;
		ValaList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _m_index = 0;
		_tmp62_ = vala_namespace_get_methods (ns);
		_m_list = _tmp62_;
		_tmp63_ = _m_list;
		_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_m_size = _tmp65_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp66_;
			gint _tmp67_;
			ValaMethod* m = NULL;
			ValaList* _tmp68_;
			gpointer _tmp69_;
			ValaMethod* _tmp70_;
			_m_index = _m_index + 1;
			_tmp66_ = _m_index;
			_tmp67_ = _m_size;
			if (!(_tmp66_ < _tmp67_)) {
				break;
			}
			_tmp68_ = _m_list;
			_tmp69_ = vala_list_get (_tmp68_, _m_index);
			m = (ValaMethod*) _tmp69_;
			_tmp70_ = m;
			dlang_writer_walk_method (self, _tmp70_);
			_vala_code_node_unref0 (m);
		}
	}
	_tmp72_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp73_ = _tmp72_;
	_tmp74_ = ((ValabindWriter*) self)->modulename;
	if (g_strcmp0 (_tmp73_, _tmp74_) == 0) {
		const gchar* _tmp75_;
		const gchar* _tmp76_;
		_tmp75_ = vala_symbol_get_name ((ValaSymbol*) ns);
		_tmp76_ = _tmp75_;
		_tmp71_ = _tmp76_;
	} else {
		_tmp71_ = "";
	}
	_tmp77_ = g_strdup (_tmp71_);
	classprefix = _tmp77_;
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp78_;
		gint _c_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _c_index = 0;
		_tmp78_ = vala_namespace_get_classes (ns);
		_c_list = _tmp78_;
		_tmp79_ = _c_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_c_size = _tmp81_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			ValaClass* c = NULL;
			ValaList* _tmp84_;
			gpointer _tmp85_;
			const gchar* _tmp86_;
			ValaClass* _tmp87_;
			_c_index = _c_index + 1;
			_tmp82_ = _c_index;
			_tmp83_ = _c_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _c_list;
			_tmp85_ = vala_list_get (_tmp84_, _c_index);
			c = (ValaClass*) _tmp85_;
			_tmp86_ = classprefix;
			_tmp87_ = c;
			dlang_writer_walk_class (self, _tmp86_, _tmp87_);
			_vala_code_node_unref0 (c);
		}
	}
	_g_free0 (classprefix);
	_vala_source_reference_unref0 (sr);
}

static void
dlang_writer_real_write (ValabindWriter* base,
                         const gchar* file)
{
	DlangWriter * self;
	FILE* stream = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	gchar* _tmp4_;
	ValaCodeContext* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	FILE* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	FILE* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	FILE* _tmp18_;
	FILE* _tmp19_;
	FILE* _tmp20_;
	const gchar* _tmp21_;
	FILE* _tmp22_;
	const gchar* _tmp23_;
	FILE* _tmp24_;
	const gchar* _tmp25_;
	FILE* _tmp26_;
	const gchar* _tmp27_;
	self = (DlangWriter*) base;
	g_return_if_fail (file != NULL);
	_tmp0_ = g_fopen (file, "w");
	stream = _tmp0_;
	_tmp1_ = stream;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup_printf ("Cannot open %s for writing", file);
		_tmp3_ = _tmp2_;
		error (_tmp3_);
		_g_free0 (_tmp3_);
	}
	_tmp4_ = g_strdup ("extern(C) {\n");
	_g_free0 (self->priv->defs);
	self->priv->defs = _tmp4_;
	_tmp5_ = ((ValabindWriter*) self)->context;
	vala_code_context_accept (_tmp5_, (ValaCodeVisitor*) self);
	_tmp6_ = self->priv->defs;
	_tmp7_ = g_strconcat (_tmp6_, "  alias int function(int, int) _RNumCallback;\n", NULL);
	_g_free0 (self->priv->defs);
	self->priv->defs = _tmp7_;
	_tmp8_ = self->priv->defs;
	_tmp9_ = g_strconcat (_tmp8_, "}\n", NULL);
	_g_free0 (self->priv->defs);
	self->priv->defs = _tmp9_;
	_tmp10_ = stream;
	_tmp11_ = ((ValabindWriter*) self)->modulename;
	_tmp12_ = g_strdup_printf ("/* valabind autogenerated D bindings for %s */\n", _tmp11_);
	_tmp13_ = _tmp12_;
	fprintf (_tmp10_, "%s", _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = stream;
	_tmp15_ = ((ValabindWriter*) self)->modulename;
	_tmp16_ = g_strdup_printf ("pragma(lib,\"%s\");\n", _tmp15_);
	_tmp17_ = _tmp16_;
	fprintf (_tmp14_, "%s", _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = stream;
	fprintf (_tmp18_, "pragma(lib,\"r_util\");\n");
	_tmp19_ = stream;
	fprintf (_tmp19_, "import std.string;\n");
	_tmp20_ = stream;
	_tmp21_ = self->priv->defs;
	fprintf (_tmp20_, "%s\n", _tmp21_);
	_tmp22_ = stream;
	_tmp23_ = self->priv->enums;
	fprintf (_tmp22_, "%s\n", _tmp23_);
	_tmp24_ = stream;
	_tmp25_ = self->priv->statics;
	fprintf (_tmp24_, "%s\n", _tmp25_);
	_tmp26_ = stream;
	_tmp27_ = self->priv->extends;
	fprintf (_tmp26_, "%s\n", _tmp27_);
	_fclose0 (stream);
}

static void
dlang_writer_class_init (DlangWriterClass * klass,
                         gpointer klass_data)
{
	dlang_writer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = dlang_writer_finalize;
	g_type_class_adjust_private_offset (klass, &DlangWriter_private_offset);
	((ValabindWriterClass *) klass)->get_filename = (gchar* (*) (ValabindWriter*, const gchar*)) dlang_writer_real_get_filename;
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) dlang_writer_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor*, ValaNamespace*)) dlang_writer_real_visit_namespace;
	((ValabindWriterClass *) klass)->write = (void (*) (ValabindWriter*, const gchar*)) dlang_writer_real_write;
}

static void
dlang_writer_instance_init (DlangWriter * self,
                            gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	self->priv = dlang_writer_get_instance_private (self);
	self->includefiles = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->classname = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->defs = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->statics = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->extends = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->enums = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->vectors = _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, NULL);
	self->priv->defined_classes = _tmp8_;
}

static void
dlang_writer_finalize (ValaCodeVisitor * obj)
{
	DlangWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DLANG_WRITER, DlangWriter);
	(self->includefiles == NULL) ? NULL : (self->includefiles = (_g_list_free__g_free0_ (self->includefiles), NULL));
	(self->methods == NULL) ? NULL : (self->methods = (_g_list_free__vala_code_node_unref0_ (self->methods), NULL));
	_g_free0 (self->priv->classname);
	_g_free0 (self->priv->classcname);
	_g_free0 (self->priv->defs);
	_g_free0 (self->priv->statics);
	_g_free0 (self->priv->extends);
	_g_free0 (self->priv->enums);
	_g_free0 (self->priv->vectors);
	_g_free0 (self->priv->nspace);
	_g_hash_table_unref0 (self->priv->defined_classes);
	VALA_CODE_VISITOR_CLASS (dlang_writer_parent_class)->finalize (obj);
}

static GType
dlang_writer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DlangWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dlang_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DlangWriter), 0, (GInstanceInitFunc) dlang_writer_instance_init, NULL };
	GType dlang_writer_type_id;
	dlang_writer_type_id = g_type_register_static (TYPE_VALABIND_WRITER, "DlangWriter", &g_define_type_info, 0);
	DlangWriter_private_offset = g_type_add_instance_private (dlang_writer_type_id, sizeof (DlangWriterPrivate));
	return dlang_writer_type_id;
}

GType
dlang_writer_get_type (void)
{
	static volatile gsize dlang_writer_type_id__once = 0;
	if (g_once_init_enter (&dlang_writer_type_id__once)) {
		GType dlang_writer_type_id;
		dlang_writer_type_id = dlang_writer_get_type_once ();
		g_once_init_leave (&dlang_writer_type_id__once, dlang_writer_type_id);
	}
	return dlang_writer_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

