/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportReceiveStream.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSWebTransportReceiveStreamStats.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebTransportReceiveStreamPrototypeFunction_getStats);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebTransportReceiveStreamConstructor);

class JSWebTransportReceiveStreamPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebTransportReceiveStreamPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebTransportReceiveStreamPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebTransportReceiveStreamPrototype>(vm)) JSWebTransportReceiveStreamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportReceiveStreamPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebTransportReceiveStreamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebTransportReceiveStreamPrototype, JSWebTransportReceiveStreamPrototype::Base);

using JSWebTransportReceiveStreamDOMConstructor = JSDOMConstructorNotConstructable<JSWebTransportReceiveStream>;

template<> const ClassInfo JSWebTransportReceiveStreamDOMConstructor::s_info = { "WebTransportReceiveStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportReceiveStreamDOMConstructor) };

template<> JSValue JSWebTransportReceiveStreamDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSReadableStream::getConstructor(vm, &globalObject);
}

template<> void JSWebTransportReceiveStreamDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "WebTransportReceiveStream"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebTransportReceiveStream::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSWebTransportReceiveStreamPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebTransportReceiveStreamConstructor, 0 } },
    HashTableValue { "getStats"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebTransportReceiveStreamPrototypeFunction_getStats, 0 } },
};

const ClassInfo JSWebTransportReceiveStreamPrototype::s_info = { "WebTransportReceiveStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportReceiveStreamPrototype) };

void JSWebTransportReceiveStreamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebTransportReceiveStream::info(), JSWebTransportReceiveStreamPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebTransportReceiveStream::s_info = { "WebTransportReceiveStream"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebTransportReceiveStream) };

JSWebTransportReceiveStream::JSWebTransportReceiveStream(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebTransportReceiveStream>&& impl)
    : JSReadableStream(structure, globalObject, WTFMove(impl))
{
}

Ref<WebTransportReceiveStream> JSWebTransportReceiveStream::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, WebTransportReceiveStream>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebTransportReceiveStream::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebTransportReceiveStreamPrototype::createStructure(vm, &globalObject, JSReadableStream::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSWebTransportReceiveStreamPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebTransportReceiveStream::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebTransportReceiveStream>(vm, globalObject);
}

JSValue JSWebTransportReceiveStream::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebTransportReceiveStreamDOMConstructor, DOMConstructorID::WebTransportReceiveStream>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebTransportReceiveStreamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebTransportReceiveStreamPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebTransportReceiveStream::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsWebTransportReceiveStreamPrototypeFunction_getStatsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSWebTransportReceiveStream>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLDictionary<WebTransportReceiveStreamStats>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getStats(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebTransportReceiveStreamPrototypeFunction_getStats, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSWebTransportReceiveStream>::call<jsWebTransportReceiveStreamPrototypeFunction_getStatsBody>(*lexicalGlobalObject, *callFrame, "getStats");
}

JSC::GCClient::IsoSubspace* JSWebTransportReceiveStream::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebTransportReceiveStream, UseCustomHeapCellType::No>(vm, "JSWebTransportReceiveStream"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebTransportReceiveStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebTransportReceiveStream = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebTransportReceiveStream.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebTransportReceiveStream = std::forward<decltype(space)>(space); }
    );
}

void JSWebTransportReceiveStream::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebTransportReceiveStream*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebTransportReceiveStream@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25WebTransportReceiveStreamE[]; }
#endif
template<std::same_as<WebTransportReceiveStream> T>
static inline void verifyVTable(WebTransportReceiveStream* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebTransportReceiveStream@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25WebTransportReceiveStreamE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebTransportReceiveStream has subclasses. If WebTransportReceiveStream has subclasses that get passed
        // to toJS() we currently require WebTransportReceiveStream you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebTransportReceiveStream>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebTransportReceiveStream>(impl.ptr());
#endif
    return createWrapper<WebTransportReceiveStream>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebTransportReceiveStream& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebTransportReceiveStream* JSWebTransportReceiveStream::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebTransportReceiveStream*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
