/* theme-gtkcss.c generated by valac 0.56.18, the Vala compiler
 * generated from theme-gtkcss.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2006-2013  Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2023       Arthur Demchenkov <spinal.by@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "libnotes.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <xfce-revision.h>
#include <libxfce4util/libxfce4util.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	XNP_THEME_GTKCSS_0_PROPERTY,
	XNP_THEME_GTKCSS_USE_GTK_STYLE_PROPERTY,
	XNP_THEME_GTKCSS_NUM_PROPERTIES
};
static GParamSpec* xnp_theme_gtkcss_properties[XNP_THEME_GTKCSS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _XnpThemeGtkcssPrivate {
	gchar* css_path_default;
	gchar* css_path_system;
	gchar* css_path_user;
	GtkCssProvider* css_provider_color;
	GtkCssProvider* css_provider_default;
	GtkCssProvider* css_provider_system;
	GtkCssProvider* css_provider_user;
	gboolean _use_gtk_style;
	GdkRGBA bg_color;
};

static gint XnpThemeGtkcss_private_offset;
static gpointer xnp_theme_gtkcss_parent_class = NULL;

static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
static void xnp_theme_gtkcss_load_default_css (XnpThemeGtkcss* self);
static void xnp_theme_gtkcss_load_system_css (XnpThemeGtkcss* self);
static void xnp_theme_gtkcss_load_user_css (XnpThemeGtkcss* self);
static void xnp_theme_gtkcss_finalize (GObject * obj);
static GType xnp_theme_gtkcss_get_type_once (void);
static void _vala_xnp_theme_gtkcss_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_xnp_theme_gtkcss_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
xnp_theme_gtkcss_get_instance_private (XnpThemeGtkcss* self)
{
	return G_STRUCT_MEMBER_P (self, XnpThemeGtkcss_private_offset);
}

XnpThemeGtkcss*
xnp_theme_gtkcss_construct (GType object_type)
{
	XnpThemeGtkcss * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkCssProvider* _tmp3_;
	self = (XnpThemeGtkcss*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup_printf ("%s/gtk-3.0/gtk.css", PKGDATADIR);
	_g_free0 (self->priv->css_path_default);
	self->priv->css_path_default = _tmp0_;
	_tmp1_ = g_strdup_printf ("%s/xdg/xfce4/notes/gtk.css", SYSCONFDIR);
	_g_free0 (self->priv->css_path_system);
	self->priv->css_path_system = _tmp1_;
	_tmp2_ = xfce_resource_save_location (XFCE_RESOURCE_CONFIG, "xfce4/notes/gtk.css", TRUE);
	_g_free0 (self->priv->css_path_user);
	self->priv->css_path_user = _tmp2_;
	_tmp3_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->css_provider_color);
	self->priv->css_provider_color = _tmp3_;
	return self;
}

XnpThemeGtkcss*
xnp_theme_gtkcss_new (void)
{
	return xnp_theme_gtkcss_construct (XNP_TYPE_THEME_GTKCSS);
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

void
xnp_theme_gtkcss_update_color_css (XnpThemeGtkcss* self,
                                   GdkRGBA* rgba)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rgba != NULL);
	{
		GdkRGBA _tmp0_;
		GdkRGBA _tmp1_;
		_tmp0_ = self->priv->bg_color;
		_tmp1_ = *rgba;
		if (_gdk_rgba_equal (&_tmp0_, &_tmp1_) != TRUE) {
			GdkRGBA _tmp2_;
			gchar* css = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			GtkCssProvider* _tmp7_;
			const gchar* _tmp8_;
			_tmp2_ = *rgba;
			self->priv->bg_color = _tmp2_;
			_tmp3_ = gdk_rgba_to_string (&self->priv->bg_color);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strdup_printf ("@define-color notes_bg_color %s;", _tmp4_);
			_tmp6_ = _tmp5_;
			_g_free0 (_tmp4_);
			css = _tmp6_;
			_tmp7_ = self->priv->css_provider_color;
			_tmp8_ = css;
			gtk_css_provider_load_from_data (_tmp7_, _tmp8_, (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (css);
				goto __catch0_g_error;
			}
			_g_free0 (css);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("theme-gtkcss.vala:85: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
xnp_theme_gtkcss_load_default_css (XnpThemeGtkcss* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkCssProvider* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->css_provider_default;
		_tmp1_ = self->priv->css_path_default;
		gtk_css_provider_load_from_path (_tmp0_, _tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("theme-gtkcss.vala:93: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
xnp_theme_gtkcss_load_system_css (XnpThemeGtkcss* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		GtkCssProvider* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = self->priv->css_path_system;
		if (!xnp_file_utils_path_exists (_tmp0_)) {
			return;
		}
		_tmp1_ = self->priv->css_provider_system;
		_tmp2_ = self->priv->css_path_system;
		gtk_css_provider_load_from_path (_tmp1_, _tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("theme-gtkcss.vala:103: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
xnp_theme_gtkcss_load_user_css (XnpThemeGtkcss* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		GtkCssProvider* _tmp4_;
		const gchar* _tmp5_;
		_tmp0_ = self->priv->css_path_user;
		if (!xnp_file_utils_path_exists (_tmp0_)) {
			gchar* css = NULL;
			gchar* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			_tmp1_ = g_strdup ("/* Put your fun stuff here */");
			css = _tmp1_;
			_tmp2_ = self->priv->css_path_user;
			_tmp3_ = css;
			g_file_set_contents (_tmp2_, _tmp3_, (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (css);
				goto __catch0_g_error;
			}
			_g_free0 (css);
		}
		_tmp4_ = self->priv->css_provider_user;
		_tmp5_ = self->priv->css_path_user;
		gtk_css_provider_load_from_path (_tmp4_, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("theme-gtkcss.vala:115: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
xnp_theme_gtkcss_get_use_gtk_style (XnpThemeGtkcss* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_gtk_style;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
xnp_theme_gtkcss_set_use_gtk_style (XnpThemeGtkcss* self,
                                    gboolean value)
{
	GdkScreen* default_screen = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->_use_gtk_style == value) {
		return;
	}
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	default_screen = _tmp1_;
	if (value) {
		GdkScreen* _tmp2_;
		GtkCssProvider* _tmp3_;
		GdkScreen* _tmp4_;
		GtkCssProvider* _tmp5_;
		GdkScreen* _tmp6_;
		GtkCssProvider* _tmp7_;
		GdkScreen* _tmp8_;
		GtkCssProvider* _tmp9_;
		_tmp2_ = default_screen;
		_tmp3_ = self->priv->css_provider_color;
		gtk_style_context_remove_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_);
		_tmp4_ = default_screen;
		_tmp5_ = self->priv->css_provider_default;
		gtk_style_context_remove_provider_for_screen (_tmp4_, (GtkStyleProvider*) _tmp5_);
		_tmp6_ = default_screen;
		_tmp7_ = self->priv->css_provider_system;
		gtk_style_context_remove_provider_for_screen (_tmp6_, (GtkStyleProvider*) _tmp7_);
		_tmp8_ = default_screen;
		_tmp9_ = self->priv->css_provider_user;
		gtk_style_context_remove_provider_for_screen (_tmp8_, (GtkStyleProvider*) _tmp9_);
		_g_object_unref0 (self->priv->css_provider_default);
		self->priv->css_provider_default = NULL;
		_g_object_unref0 (self->priv->css_provider_system);
		self->priv->css_provider_system = NULL;
		_g_object_unref0 (self->priv->css_provider_user);
		self->priv->css_provider_user = NULL;
	} else {
		GtkCssProvider* _tmp10_;
		GtkCssProvider* _tmp11_;
		GtkCssProvider* _tmp12_;
		GdkScreen* _tmp13_;
		GtkCssProvider* _tmp14_;
		GdkScreen* _tmp15_;
		GtkCssProvider* _tmp16_;
		GdkScreen* _tmp17_;
		GtkCssProvider* _tmp18_;
		GdkScreen* _tmp19_;
		GtkCssProvider* _tmp20_;
		_tmp10_ = gtk_css_provider_new ();
		_g_object_unref0 (self->priv->css_provider_default);
		self->priv->css_provider_default = _tmp10_;
		_tmp11_ = gtk_css_provider_new ();
		_g_object_unref0 (self->priv->css_provider_system);
		self->priv->css_provider_system = _tmp11_;
		_tmp12_ = gtk_css_provider_new ();
		_g_object_unref0 (self->priv->css_provider_user);
		self->priv->css_provider_user = _tmp12_;
		_tmp13_ = default_screen;
		_tmp14_ = self->priv->css_provider_color;
		gtk_style_context_add_provider_for_screen (_tmp13_, (GtkStyleProvider*) _tmp14_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_tmp15_ = default_screen;
		_tmp16_ = self->priv->css_provider_default;
		gtk_style_context_add_provider_for_screen (_tmp15_, (GtkStyleProvider*) _tmp16_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_tmp17_ = default_screen;
		_tmp18_ = self->priv->css_provider_system;
		gtk_style_context_add_provider_for_screen (_tmp17_, (GtkStyleProvider*) _tmp18_, (guint) (GTK_STYLE_PROVIDER_PRIORITY_USER - 1));
		_tmp19_ = default_screen;
		_tmp20_ = self->priv->css_provider_user;
		gtk_style_context_add_provider_for_screen (_tmp19_, (GtkStyleProvider*) _tmp20_, (guint) (GTK_STYLE_PROVIDER_PRIORITY_USER + 1));
		xnp_theme_gtkcss_load_default_css (self);
		xnp_theme_gtkcss_load_system_css (self);
		xnp_theme_gtkcss_load_user_css (self);
	}
	self->priv->_use_gtk_style = value;
	_g_object_unref0 (default_screen);
	g_object_notify_by_pspec ((GObject *) self, xnp_theme_gtkcss_properties[XNP_THEME_GTKCSS_USE_GTK_STYLE_PROPERTY]);
}

static void
xnp_theme_gtkcss_class_init (XnpThemeGtkcssClass * klass,
                             gpointer klass_data)
{
	xnp_theme_gtkcss_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpThemeGtkcss_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_theme_gtkcss_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_theme_gtkcss_set_property;
	G_OBJECT_CLASS (klass)->finalize = xnp_theme_gtkcss_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_THEME_GTKCSS_USE_GTK_STYLE_PROPERTY, xnp_theme_gtkcss_properties[XNP_THEME_GTKCSS_USE_GTK_STYLE_PROPERTY] = g_param_spec_boolean ("use-gtk-style", "use-gtk-style", "use-gtk-style", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
xnp_theme_gtkcss_instance_init (XnpThemeGtkcss * self,
                                gpointer klass)
{
	self->priv = xnp_theme_gtkcss_get_instance_private (self);
	self->priv->_use_gtk_style = TRUE;
	self->priv->bg_color = (GdkRGBA) {(gdouble) 0};
}

static void
xnp_theme_gtkcss_finalize (GObject * obj)
{
	XnpThemeGtkcss * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_THEME_GTKCSS, XnpThemeGtkcss);
	_g_free0 (self->priv->css_path_default);
	_g_free0 (self->priv->css_path_system);
	_g_free0 (self->priv->css_path_user);
	_g_object_unref0 (self->priv->css_provider_color);
	_g_object_unref0 (self->priv->css_provider_default);
	_g_object_unref0 (self->priv->css_provider_system);
	_g_object_unref0 (self->priv->css_provider_user);
	G_OBJECT_CLASS (xnp_theme_gtkcss_parent_class)->finalize (obj);
}

static GType
xnp_theme_gtkcss_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpThemeGtkcssClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_theme_gtkcss_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpThemeGtkcss), 0, (GInstanceInitFunc) xnp_theme_gtkcss_instance_init, NULL };
	GType xnp_theme_gtkcss_type_id;
	xnp_theme_gtkcss_type_id = g_type_register_static (G_TYPE_OBJECT, "XnpThemeGtkcss", &g_define_type_info, 0);
	XnpThemeGtkcss_private_offset = g_type_add_instance_private (xnp_theme_gtkcss_type_id, sizeof (XnpThemeGtkcssPrivate));
	return xnp_theme_gtkcss_type_id;
}

GType
xnp_theme_gtkcss_get_type (void)
{
	static volatile gsize xnp_theme_gtkcss_type_id__once = 0;
	if (g_once_init_enter (&xnp_theme_gtkcss_type_id__once)) {
		GType xnp_theme_gtkcss_type_id;
		xnp_theme_gtkcss_type_id = xnp_theme_gtkcss_get_type_once ();
		g_once_init_leave (&xnp_theme_gtkcss_type_id__once, xnp_theme_gtkcss_type_id);
	}
	return xnp_theme_gtkcss_type_id__once;
}

static void
_vala_xnp_theme_gtkcss_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	XnpThemeGtkcss * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_THEME_GTKCSS, XnpThemeGtkcss);
	switch (property_id) {
		case XNP_THEME_GTKCSS_USE_GTK_STYLE_PROPERTY:
		g_value_set_boolean (value, xnp_theme_gtkcss_get_use_gtk_style (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_xnp_theme_gtkcss_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	XnpThemeGtkcss * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_THEME_GTKCSS, XnpThemeGtkcss);
	switch (property_id) {
		case XNP_THEME_GTKCSS_USE_GTK_STYLE_PROPERTY:
		xnp_theme_gtkcss_set_use_gtk_style (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

