//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `IceDiscovery.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceDiscovery_IceDiscovery_h__
#define __IceDiscovery_IceDiscovery_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/Identity.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceDiscovery
{

class LookupReply;
class LookupReplyPrx;
class Lookup;
class LookupPrx;

}

namespace IceDiscovery
{

/**
 * The LookupReply interface is used by IceDiscovery clients to answer requests
 * received on the Lookup interface.
 * \headerfile IceDiscovery/IceDiscovery.h
 */
class LookupReply : public virtual ::Ice::Object
{
public:

    using ProxyType = LookupReplyPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param current The Current object for the invocation.
     */
    virtual void foundObjectById(::Ice::Identity id, ::std::shared_ptr<::Ice::ObjectPrx> prx, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_foundObjectById(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param current The Current object for the invocation.
     */
    virtual void foundAdapterById(::std::string id, ::std::shared_ptr<::Ice::ObjectPrx> prx, bool isReplicaGroup, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_foundAdapterById(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * The Lookup interface is used by IceDiscovery clients to look for objects
 * and adapters using UDP multicast.
 * \headerfile IceDiscovery/IceDiscovery.h
 */
class Lookup : public virtual ::Ice::Object
{
public:

    using ProxyType = LookupPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param current The Current object for the invocation.
     */
    virtual void findObjectById(::std::string domainId, ::Ice::Identity id, ::std::shared_ptr<LookupReplyPrx> reply, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_findObjectById(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param current The Current object for the invocation.
     */
    virtual void findAdapterById(::std::string domainId, ::std::string id, ::std::shared_ptr<LookupReplyPrx> reply, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_findAdapterById(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceDiscovery
{

/**
 * The LookupReply interface is used by IceDiscovery clients to answer requests
 * received on the Lookup interface.
 * \headerfile IceDiscovery/IceDiscovery.h
 */
class LookupReplyPrx : public virtual ::Ice::Proxy<LookupReplyPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param context The Context map to send with the invocation.
     */
    void foundObjectById(const ::Ice::Identity& id, const ::std::shared_ptr<::Ice::ObjectPrx>& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &LookupReplyPrx::_iceI_foundObjectById, id, prx, context).get();
    }

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto foundObjectByIdAsync(const ::Ice::Identity& id, const ::std::shared_ptr<::Ice::ObjectPrx>& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &LookupReplyPrx::_iceI_foundObjectById, id, prx, context);
    }

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    foundObjectByIdAsync(const ::Ice::Identity& id, const ::std::shared_ptr<::Ice::ObjectPrx>& prx,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceDiscovery::LookupReplyPrx::_iceI_foundObjectById, id, prx, context);
    }

    /// \cond INTERNAL
    void _iceI_foundObjectById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Identity&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param context The Context map to send with the invocation.
     */
    void foundAdapterById(const ::std::string& id, const ::std::shared_ptr<::Ice::ObjectPrx>& prx, bool isReplicaGroup, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &LookupReplyPrx::_iceI_foundAdapterById, id, prx, isReplicaGroup, context).get();
    }

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto foundAdapterByIdAsync(const ::std::string& id, const ::std::shared_ptr<::Ice::ObjectPrx>& prx, bool isReplicaGroup, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &LookupReplyPrx::_iceI_foundAdapterById, id, prx, isReplicaGroup, context);
    }

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    foundAdapterByIdAsync(const ::std::string& id, const ::std::shared_ptr<::Ice::ObjectPrx>& prx, bool isReplicaGroup,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceDiscovery::LookupReplyPrx::_iceI_foundAdapterById, id, prx, isReplicaGroup, context);
    }

    /// \cond INTERNAL
    void _iceI_foundAdapterById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::shared_ptr<::Ice::ObjectPrx>&, bool, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    LookupReplyPrx() = default;
    friend ::std::shared_ptr<LookupReplyPrx> IceInternal::createProxy<LookupReplyPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The Lookup interface is used by IceDiscovery clients to look for objects
 * and adapters using UDP multicast.
 * \headerfile IceDiscovery/IceDiscovery.h
 */
class LookupPrx : public virtual ::Ice::Proxy<LookupPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param context The Context map to send with the invocation.
     */
    void findObjectById(const ::std::string& domainId, const ::Ice::Identity& id, const ::std::shared_ptr<LookupReplyPrx>& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &LookupPrx::_iceI_findObjectById, domainId, id, reply, context).get();
    }

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto findObjectByIdAsync(const ::std::string& domainId, const ::Ice::Identity& id, const ::std::shared_ptr<LookupReplyPrx>& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &LookupPrx::_iceI_findObjectById, domainId, id, reply, context);
    }

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    findObjectByIdAsync(const ::std::string& domainId, const ::Ice::Identity& id, const ::std::shared_ptr<LookupReplyPrx>& reply,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceDiscovery::LookupPrx::_iceI_findObjectById, domainId, id, reply, context);
    }

    /// \cond INTERNAL
    void _iceI_findObjectById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Identity&, const ::std::shared_ptr<LookupReplyPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param context The Context map to send with the invocation.
     */
    void findAdapterById(const ::std::string& domainId, const ::std::string& id, const ::std::shared_ptr<LookupReplyPrx>& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &LookupPrx::_iceI_findAdapterById, domainId, id, reply, context).get();
    }

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto findAdapterByIdAsync(const ::std::string& domainId, const ::std::string& id, const ::std::shared_ptr<LookupReplyPrx>& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &LookupPrx::_iceI_findAdapterById, domainId, id, reply, context);
    }

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    findAdapterByIdAsync(const ::std::string& domainId, const ::std::string& id, const ::std::shared_ptr<LookupReplyPrx>& reply,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceDiscovery::LookupPrx::_iceI_findAdapterById, domainId, id, reply, context);
    }

    /// \cond INTERNAL
    void _iceI_findAdapterById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, const ::std::shared_ptr<LookupReplyPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    LookupPrx() = default;
    friend ::std::shared_ptr<LookupPrx> IceInternal::createProxy<LookupPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace IceDiscovery
{

using LookupReplyPtr = ::std::shared_ptr<LookupReply>;
using LookupReplyPrxPtr = ::std::shared_ptr<LookupReplyPrx>;

using LookupPtr = ::std::shared_ptr<Lookup>;
using LookupPrxPtr = ::std::shared_ptr<LookupPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceDiscovery
{

class LookupReply;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< LookupReply>&);
::IceProxy::Ice::Object* upCast(LookupReply*);
/// \endcond

class Lookup;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Lookup>&);
::IceProxy::Ice::Object* upCast(Lookup*);
/// \endcond

}

}

namespace IceDiscovery
{

class LookupReply;
/// \cond INTERNAL
::Ice::Object* upCast(LookupReply*);
/// \endcond
typedef ::IceInternal::Handle< LookupReply> LookupReplyPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceDiscovery::LookupReply> LookupReplyPrx;
typedef LookupReplyPrx LookupReplyPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(LookupReplyPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Lookup;
/// \cond INTERNAL
::Ice::Object* upCast(Lookup*);
/// \endcond
typedef ::IceInternal::Handle< Lookup> LookupPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceDiscovery::Lookup> LookupPrx;
typedef LookupPrx LookupPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(LookupPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceDiscovery
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_LookupReply_foundObjectById.
 */
class Callback_LookupReply_foundObjectById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LookupReply_foundObjectById_Base> Callback_LookupReply_foundObjectByIdPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_LookupReply_foundAdapterById.
 */
class Callback_LookupReply_foundAdapterById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LookupReply_foundAdapterById_Base> Callback_LookupReply_foundAdapterByIdPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_Lookup_findObjectById.
 */
class Callback_Lookup_findObjectById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Lookup_findObjectById_Base> Callback_Lookup_findObjectByIdPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_Lookup_findAdapterById.
 */
class Callback_Lookup_findAdapterById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Lookup_findAdapterById_Base> Callback_Lookup_findAdapterByIdPtr;

}

namespace IceProxy
{

namespace IceDiscovery
{

class LookupReply : public virtual ::Ice::Proxy<LookupReply, ::IceProxy::Ice::Object>
{
public:

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param context The Context map to send with the invocation.
     */
    void foundObjectById(const ::Ice::Identity& id, const ::Ice::ObjectPrx& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_foundObjectById(_iceI_begin_foundObjectById(id, prx, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundObjectById(const ::Ice::Identity& id, const ::Ice::ObjectPrx& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_foundObjectById(id, prx, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundObjectById(const ::Ice::Identity& id, const ::Ice::ObjectPrx& prx, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundObjectById(id, prx, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundObjectById(const ::Ice::Identity& id, const ::Ice::ObjectPrx& prx, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundObjectById(id, prx, context, cb, cookie);
    }

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundObjectById(const ::Ice::Identity& id, const ::Ice::ObjectPrx& prx, const ::IceDiscovery::Callback_LookupReply_foundObjectByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundObjectById(id, prx, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundObjectById(const ::Ice::Identity& id, const ::Ice::ObjectPrx& prx, const ::Ice::Context& context, const ::IceDiscovery::Callback_LookupReply_foundObjectByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundObjectById(id, prx, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_foundObjectById.
     * @param result The asynchronous result object for the invocation.
     */
    void end_foundObjectById(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_foundObjectById(const ::Ice::Identity&, const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param context The Context map to send with the invocation.
     */
    void foundAdapterById(const ::std::string& id, const ::Ice::ObjectPrx& prx, bool isReplicaGroup, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_foundAdapterById(_iceI_begin_foundAdapterById(id, prx, isReplicaGroup, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundAdapterById(const ::std::string& id, const ::Ice::ObjectPrx& prx, bool isReplicaGroup, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_foundAdapterById(id, prx, isReplicaGroup, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundAdapterById(const ::std::string& id, const ::Ice::ObjectPrx& prx, bool isReplicaGroup, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundAdapterById(id, prx, isReplicaGroup, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundAdapterById(const ::std::string& id, const ::Ice::ObjectPrx& prx, bool isReplicaGroup, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundAdapterById(id, prx, isReplicaGroup, context, cb, cookie);
    }

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundAdapterById(const ::std::string& id, const ::Ice::ObjectPrx& prx, bool isReplicaGroup, const ::IceDiscovery::Callback_LookupReply_foundAdapterByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundAdapterById(id, prx, isReplicaGroup, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_foundAdapterById(const ::std::string& id, const ::Ice::ObjectPrx& prx, bool isReplicaGroup, const ::Ice::Context& context, const ::IceDiscovery::Callback_LookupReply_foundAdapterByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_foundAdapterById(id, prx, isReplicaGroup, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_foundAdapterById.
     * @param result The asynchronous result object for the invocation.
     */
    void end_foundAdapterById(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_foundAdapterById(const ::std::string&, const ::Ice::ObjectPrx&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class Lookup : public virtual ::Ice::Proxy<Lookup, ::IceProxy::Ice::Object>
{
public:

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param context The Context map to send with the invocation.
     */
    void findObjectById(const ::std::string& domainId, const ::Ice::Identity& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_findObjectById(_iceI_begin_findObjectById(domainId, id, reply, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::std::string& domainId, const ::Ice::Identity& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findObjectById(domainId, id, reply, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::std::string& domainId, const ::Ice::Identity& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(domainId, id, reply, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::std::string& domainId, const ::Ice::Identity& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(domainId, id, reply, context, cb, cookie);
    }

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::std::string& domainId, const ::Ice::Identity& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::IceDiscovery::Callback_Lookup_findObjectByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(domainId, id, reply, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findObjectById(const ::std::string& domainId, const ::Ice::Identity& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context, const ::IceDiscovery::Callback_Lookup_findObjectByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(domainId, id, reply, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_findObjectById.
     * @param result The asynchronous result object for the invocation.
     */
    void end_findObjectById(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_findObjectById(const ::std::string&, const ::Ice::Identity&, const ::IceDiscovery::LookupReplyPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param context The Context map to send with the invocation.
     */
    void findAdapterById(const ::std::string& domainId, const ::std::string& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_findAdapterById(_iceI_begin_findAdapterById(domainId, id, reply, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& domainId, const ::std::string& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findAdapterById(domainId, id, reply, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& domainId, const ::std::string& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(domainId, id, reply, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& domainId, const ::std::string& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(domainId, id, reply, context, cb, cookie);
    }

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& domainId, const ::std::string& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::IceDiscovery::Callback_Lookup_findAdapterByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(domainId, id, reply, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_findAdapterById(const ::std::string& domainId, const ::std::string& id, const ::IceDiscovery::LookupReplyPrx& reply, const ::Ice::Context& context, const ::IceDiscovery::Callback_Lookup_findAdapterByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAdapterById(domainId, id, reply, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_findAdapterById.
     * @param result The asynchronous result object for the invocation.
     */
    void end_findAdapterById(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_findAdapterById(const ::std::string&, const ::std::string&, const ::IceDiscovery::LookupReplyPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceDiscovery
{

/**
 * The LookupReply interface is used by IceDiscovery clients to answer requests
 * received on the Lookup interface.
 * \headerfile IceDiscovery/IceDiscovery.h
 */
class LookupReply : public virtual ::Ice::Object
{
public:

    typedef LookupReplyPrx ProxyType;
    typedef LookupReplyPtr PointerType;

    virtual ~LookupReply();

#ifdef ICE_CPP11_COMPILER
    LookupReply() = default;
    LookupReply(const LookupReply&) = default;
    LookupReply& operator=(const LookupReply&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Reply to the findObjectById request.
     * @param id The identity of the object.
     * @param prx The proxy of the object.
     * @param current The Current object for the invocation.
     */
    virtual void foundObjectById(const ::Ice::Identity& id, const ::Ice::ObjectPrx& prx, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_foundObjectById(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Reply to the findAdpaterById request.
     * @param id The adapter ID.
     * @param prx The adapter proxy (a dummy proxy created by the adapter).
     * The proxy provides the adapter endpoints.
     * @param isReplicaGroup True if the adapter is also a member of a
     * replica group.
     * @param current The Current object for the invocation.
     */
    virtual void foundAdapterById(const ::std::string& id, const ::Ice::ObjectPrx& prx, bool isReplicaGroup, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_foundAdapterById(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const LookupReply& lhs, const LookupReply& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const LookupReply& lhs, const LookupReply& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * The Lookup interface is used by IceDiscovery clients to look for objects
 * and adapters using UDP multicast.
 * \headerfile IceDiscovery/IceDiscovery.h
 */
class Lookup : public virtual ::Ice::Object
{
public:

    typedef LookupPrx ProxyType;
    typedef LookupPtr PointerType;

    virtual ~Lookup();

#ifdef ICE_CPP11_COMPILER
    Lookup() = default;
    Lookup(const Lookup&) = default;
    Lookup& operator=(const Lookup&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param current The Current object for the invocation.
     */
    virtual void findObjectById(const ::std::string& domainId, const ::Ice::Identity& id, const LookupReplyPrx& reply, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_findObjectById(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param current The Current object for the invocation.
     */
    virtual void findAdapterById(const ::std::string& domainId, const ::std::string& id, const LookupReplyPrx& reply, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_findAdapterById(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Lookup& lhs, const Lookup& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Lookup& lhs, const Lookup& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

namespace IceDiscovery
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_LookupReply_foundObjectById.
 */
template<class T>
class CallbackNC_LookupReply_foundObjectById : public Callback_LookupReply_foundObjectById_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LookupReply_foundObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 */
template<class T> Callback_LookupReply_foundObjectByIdPtr
newCallback_LookupReply_foundObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundObjectById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 */
template<class T> Callback_LookupReply_foundObjectByIdPtr
newCallback_LookupReply_foundObjectById(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundObjectById<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 */
template<class T> Callback_LookupReply_foundObjectByIdPtr
newCallback_LookupReply_foundObjectById(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundObjectById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 */
template<class T> Callback_LookupReply_foundObjectByIdPtr
newCallback_LookupReply_foundObjectById(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundObjectById<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_LookupReply_foundObjectById.
 */
template<class T, typename CT>
class Callback_LookupReply_foundObjectById : public Callback_LookupReply_foundObjectById_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LookupReply_foundObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 */
template<class T, typename CT> Callback_LookupReply_foundObjectByIdPtr
newCallback_LookupReply_foundObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundObjectById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 */
template<class T, typename CT> Callback_LookupReply_foundObjectByIdPtr
newCallback_LookupReply_foundObjectById(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundObjectById<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 */
template<class T, typename CT> Callback_LookupReply_foundObjectByIdPtr
newCallback_LookupReply_foundObjectById(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundObjectById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundObjectById.
 */
template<class T, typename CT> Callback_LookupReply_foundObjectByIdPtr
newCallback_LookupReply_foundObjectById(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundObjectById<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_LookupReply_foundAdapterById.
 */
template<class T>
class CallbackNC_LookupReply_foundAdapterById : public Callback_LookupReply_foundAdapterById_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LookupReply_foundAdapterById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 */
template<class T> Callback_LookupReply_foundAdapterByIdPtr
newCallback_LookupReply_foundAdapterById(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundAdapterById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 */
template<class T> Callback_LookupReply_foundAdapterByIdPtr
newCallback_LookupReply_foundAdapterById(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundAdapterById<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 */
template<class T> Callback_LookupReply_foundAdapterByIdPtr
newCallback_LookupReply_foundAdapterById(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundAdapterById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 */
template<class T> Callback_LookupReply_foundAdapterByIdPtr
newCallback_LookupReply_foundAdapterById(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LookupReply_foundAdapterById<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_LookupReply_foundAdapterById.
 */
template<class T, typename CT>
class Callback_LookupReply_foundAdapterById : public Callback_LookupReply_foundAdapterById_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LookupReply_foundAdapterById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 */
template<class T, typename CT> Callback_LookupReply_foundAdapterByIdPtr
newCallback_LookupReply_foundAdapterById(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundAdapterById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 */
template<class T, typename CT> Callback_LookupReply_foundAdapterByIdPtr
newCallback_LookupReply_foundAdapterById(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundAdapterById<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 */
template<class T, typename CT> Callback_LookupReply_foundAdapterByIdPtr
newCallback_LookupReply_foundAdapterById(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundAdapterById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::LookupReply::begin_foundAdapterById.
 */
template<class T, typename CT> Callback_LookupReply_foundAdapterByIdPtr
newCallback_LookupReply_foundAdapterById(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LookupReply_foundAdapterById<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_Lookup_findObjectById.
 */
template<class T>
class CallbackNC_Lookup_findObjectById : public Callback_Lookup_findObjectById_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Lookup_findObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 */
template<class T> Callback_Lookup_findObjectByIdPtr
newCallback_Lookup_findObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findObjectById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 */
template<class T> Callback_Lookup_findObjectByIdPtr
newCallback_Lookup_findObjectById(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findObjectById<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 */
template<class T> Callback_Lookup_findObjectByIdPtr
newCallback_Lookup_findObjectById(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findObjectById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 */
template<class T> Callback_Lookup_findObjectByIdPtr
newCallback_Lookup_findObjectById(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findObjectById<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_Lookup_findObjectById.
 */
template<class T, typename CT>
class Callback_Lookup_findObjectById : public Callback_Lookup_findObjectById_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Lookup_findObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 */
template<class T, typename CT> Callback_Lookup_findObjectByIdPtr
newCallback_Lookup_findObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findObjectById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 */
template<class T, typename CT> Callback_Lookup_findObjectByIdPtr
newCallback_Lookup_findObjectById(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findObjectById<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 */
template<class T, typename CT> Callback_Lookup_findObjectByIdPtr
newCallback_Lookup_findObjectById(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findObjectById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findObjectById.
 */
template<class T, typename CT> Callback_Lookup_findObjectByIdPtr
newCallback_Lookup_findObjectById(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findObjectById<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_Lookup_findAdapterById.
 */
template<class T>
class CallbackNC_Lookup_findAdapterById : public Callback_Lookup_findAdapterById_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Lookup_findAdapterById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 */
template<class T> Callback_Lookup_findAdapterByIdPtr
newCallback_Lookup_findAdapterById(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findAdapterById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 */
template<class T> Callback_Lookup_findAdapterByIdPtr
newCallback_Lookup_findAdapterById(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findAdapterById<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 */
template<class T> Callback_Lookup_findAdapterByIdPtr
newCallback_Lookup_findAdapterById(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findAdapterById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 */
template<class T> Callback_Lookup_findAdapterByIdPtr
newCallback_Lookup_findAdapterById(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Lookup_findAdapterById<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 * Create a wrapper instance by calling ::IceDiscovery::newCallback_Lookup_findAdapterById.
 */
template<class T, typename CT>
class Callback_Lookup_findAdapterById : public Callback_Lookup_findAdapterById_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Lookup_findAdapterById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 */
template<class T, typename CT> Callback_Lookup_findAdapterByIdPtr
newCallback_Lookup_findAdapterById(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findAdapterById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 */
template<class T, typename CT> Callback_Lookup_findAdapterByIdPtr
newCallback_Lookup_findAdapterById(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findAdapterById<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 */
template<class T, typename CT> Callback_Lookup_findAdapterByIdPtr
newCallback_Lookup_findAdapterById(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findAdapterById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceDiscovery::Lookup::begin_findAdapterById.
 */
template<class T, typename CT> Callback_Lookup_findAdapterByIdPtr
newCallback_Lookup_findAdapterById(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Lookup_findAdapterById<T, CT>(instance, 0, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
