/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding.adapters;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.beansbinding.ext.BeanAdapterProvider;
import org.jdesktop.swingbinding.adapters.BeanAdapterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSpinnerAdapterProvider
implements BeanAdapterProvider {
    private static final String VALUE_P = "value";

    @Override
    public boolean providesAdapter(Class<?> type, String property) {
        return JSpinner.class.isAssignableFrom(type) && property == VALUE_P;
    }

    @Override
    public Object createAdapter(Object source, String property) {
        if (!this.providesAdapter(source.getClass(), property)) {
            throw new IllegalArgumentException();
        }
        return new Adapter((JSpinner)source);
    }

    @Override
    public Class<?> getAdapterClass(Class<?> type) {
        return JSpinner.class.isAssignableFrom(type) ? Adapter.class : null;
    }

    public static final class Adapter
    extends BeanAdapterBase {
        private JSpinner spinner;
        private Handler handler;
        private Object cachedValue;

        private Adapter(JSpinner spinner) {
            super(JSpinnerAdapterProvider.VALUE_P);
            this.spinner = spinner;
        }

        public Object getValue() {
            return this.spinner.getValue();
        }

        public void setValue(Object value) {
            this.spinner.setValue(value);
        }

        protected void listeningStarted() {
            this.handler = new Handler();
            this.cachedValue = this.getValue();
            this.spinner.addChangeListener(this.handler);
            this.spinner.addPropertyChangeListener("model", this.handler);
        }

        protected void listeningStopped() {
            this.spinner.removeChangeListener(this.handler);
            this.spinner.removePropertyChangeListener("model", this.handler);
            this.handler = null;
        }

        private class Handler
        implements ChangeListener,
        PropertyChangeListener {
            private Handler() {
            }

            private void spinnerValueChanged() {
                Object oldValue = Adapter.this.cachedValue;
                Adapter.this.cachedValue = Adapter.this.getValue();
                Adapter.this.firePropertyChange(oldValue, Adapter.this.cachedValue);
            }

            public void stateChanged(ChangeEvent ce) {
                this.spinnerValueChanged();
            }

            public void propertyChange(PropertyChangeEvent pe) {
                this.spinnerValueChanged();
            }
        }
    }
}

