/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.framework.debug.EclipseDebugTrace;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FrameworkDebugOptions
implements DebugOptions,
ServiceTrackerCustomizer {
    private static final String OSGI_DEBUG = "osgi.debug";
    private static final String OSGI_DEBUG_VERBOSE = "osgi.debug.verbose";
    public static final String PROP_TRACEFILE = "osgi.tracefile";
    private final Object lock = new Object();
    private Properties options = null;
    private Properties disabledOptions = null;
    private static FrameworkDebugOptions singleton = null;
    private static final String OPTIONS = ".options";
    protected static final Map debugTraceCache = new HashMap();
    protected File outFile = null;
    protected boolean verboseDebug = Boolean.valueOf(FrameworkProperties.getProperty("osgi.debug.verbose", Boolean.TRUE.toString()));
    private volatile BundleContext context;
    private volatile ServiceTracker listenerTracker;
    static /* synthetic */ Class class$0;

    private FrameworkDebugOptions() {
        URL optionsFile;
        String debugOptionsFilename = FrameworkProperties.getProperty(OSGI_DEBUG);
        if (debugOptionsFilename == null) {
            return;
        }
        this.options = new Properties();
        if (debugOptionsFilename.length() == 0) {
            String userDir = FrameworkProperties.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!userDir.endsWith("/")) {
                userDir = String.valueOf(userDir) + "/";
            }
            debugOptionsFilename = new File(userDir, OPTIONS).toString();
        }
        if ((optionsFile = FrameworkDebugOptions.buildURL(debugOptionsFilename, false)) == null) {
            System.out.println("Unable to construct URL for options file: " + debugOptionsFilename);
            return;
        }
        System.out.print("Debug options:\n    " + optionsFile.toExternalForm());
        try {
            InputStream input = optionsFile.openStream();
            try {
                this.options.load(input);
                System.out.println(" loaded");
            }
            finally {
                input.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(" not found");
        }
        catch (IOException e) {
            System.out.println(" did not parse");
            e.printStackTrace(System.out);
        }
        Iterator<Object> i = this.options.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.options.put(key, ((String)this.options.get(key)).trim());
        }
    }

    public void start(BundleContext bc) {
        this.context = bc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptionsListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerTracker = new ServiceTracker(bc, clazz.getName(), (ServiceTrackerCustomizer)this);
        this.listenerTracker.open();
    }

    public void stop(BundleContext bc) {
        this.listenerTracker.close();
        this.listenerTracker = null;
        this.context = null;
    }

    public static FrameworkDebugOptions getDefault() {
        if (singleton == null) {
            singleton = new FrameworkDebugOptions();
        }
        return singleton;
    }

    private static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        boolean isFile = spec.startsWith("file:");
        try {
            if (isFile) {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(spec.substring(5)).toURL(), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            if (isFile) {
                return null;
            }
            try {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(spec).toURL(), trailingSlash);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = this.getOption(option);
        return optionValue != null ? optionValue.equalsIgnoreCase("true") : defaultValue;
    }

    public String getOption(String option) {
        return this.getOption(option, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOption(String option, String defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                return this.options.getProperty(option, defaultValue);
            }
        }
        return defaultValue;
    }

    public int getIntegerOption(String option, int defaultValue) {
        String value = this.getOption(option);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getOptions() {
        Properties snapShot = new Properties();
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                snapShot.putAll((Map<?, ?>)this.options);
            } else if (this.disabledOptions != null) {
                snapShot.putAll((Map<?, ?>)this.disabledOptions);
            }
        }
        return snapShot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getAllOptions() {
        String[] optionsArray = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                optionsArray = new String[this.options.size()];
                Iterator<Map.Entry<Object, Object>> entrySetIterator = this.options.entrySet().iterator();
                int i = 0;
                while (entrySetIterator.hasNext()) {
                    Map.Entry<Object, Object> entry = entrySetIterator.next();
                    optionsArray[i] = String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue();
                    ++i;
                }
            }
        }
        if (optionsArray == null) {
            optionsArray = new String[1];
        }
        return optionsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOption(String option) {
        if (option == null) {
            return;
        }
        String fireChangedEvent = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null && this.options.remove(option) != null) {
                fireChangedEvent = this.getSymbolicName(option);
            }
        }
        if (fireChangedEvent != null) {
            this.optionsChanged(fireChangedEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOption(String option, String value) {
        if (option == null || value == null) {
            throw new IllegalArgumentException("The option and value must not be null.");
        }
        String fireChangedEvent = null;
        value = value != null ? value.trim() : null;
        Object object = this.lock;
        synchronized (object) {
            if (this.options != null) {
                String currentValue = this.options.getProperty(option);
                if (currentValue != null) {
                    if (!currentValue.equals(value)) {
                        fireChangedEvent = this.getSymbolicName(option);
                    }
                } else if (value != null) {
                    fireChangedEvent = this.getSymbolicName(option);
                }
                if (fireChangedEvent != null) {
                    this.options.put(option, value);
                }
            }
        }
        if (fireChangedEvent != null) {
            this.optionsChanged(fireChangedEvent);
        }
    }

    private String getSymbolicName(String option) {
        int firstSlashIndex = option.indexOf("/");
        if (firstSlashIndex > 0) {
            return option.substring(0, firstSlashIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptions(Map ops) {
        Map.Entry entry;
        if (ops == null) {
            throw new IllegalArgumentException("The options must not be null.");
        }
        Properties newOptions = new Properties();
        Iterator entries = ops.entrySet().iterator();
        while (entries.hasNext()) {
            entry = entries.next();
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) {
                throw new IllegalArgumentException("Option keys and values must be of type String: " + entry.getKey() + "=" + entry.getValue());
            }
            newOptions.put(entry.getKey(), ((String)entry.getValue()).trim());
        }
        HashSet<String> fireChangesTo = null;
        entry = this.lock;
        synchronized (entry) {
            if (this.options == null) {
                this.disabledOptions = newOptions;
                return;
            }
            fireChangesTo = new HashSet<String>();
            Iterator<Object> keys = this.options.keySet().iterator();
            while (keys.hasNext()) {
                String symbolicName;
                String key = (String)keys.next();
                if (newOptions.containsKey(key) || (symbolicName = this.getSymbolicName(key)) == null) continue;
                fireChangesTo.add(symbolicName);
            }
            Iterator<Map.Entry<Object, Object>> newEntries = newOptions.entrySet().iterator();
            while (newEntries.hasNext()) {
                String symbolicName;
                Map.Entry<Object, Object> entry2 = newEntries.next();
                String existingValue = (String)this.options.get(entry2.getKey());
                if (entry2.getValue().equals(existingValue) || (symbolicName = this.getSymbolicName((String)entry2.getKey())) == null) continue;
                fireChangesTo.add(symbolicName);
            }
            this.options = newOptions;
        }
        Iterator iChanges = fireChangesTo.iterator();
        while (iChanges.hasNext()) {
            this.optionsChanged((String)iChanges.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDebugEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.options != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDebugEnabled(boolean enabled) {
        boolean fireChangedEvent = false;
        Object object = this.lock;
        synchronized (object) {
            if (enabled) {
                if (this.options != null) {
                    return;
                }
                EclipseDebugTrace.newSession = true;
                FrameworkProperties.setProperty(OSGI_DEBUG, "");
                if (this.disabledOptions != null) {
                    this.options = this.disabledOptions;
                    this.disabledOptions = null;
                    fireChangedEvent = true;
                } else {
                    this.options = new Properties();
                }
            } else {
                if (this.options == null) {
                    return;
                }
                FrameworkProperties.clearProperty(OSGI_DEBUG);
                if (this.options.size() > 0) {
                    this.disabledOptions = this.options;
                    fireChangedEvent = true;
                }
                this.options = null;
            }
        }
        if (fireChangedEvent) {
            this.optionsChanged("*");
        }
    }

    public final DebugTrace newDebugTrace(String bundleSymbolicName) {
        return this.newDebugTrace(bundleSymbolicName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DebugTrace newDebugTrace(String bundleSymbolicName, Class traceEntryClass) {
        DebugTrace debugTrace = null;
        Map map = debugTraceCache;
        synchronized (map) {
            debugTrace = (DebugTrace)debugTraceCache.get(bundleSymbolicName);
            if (debugTrace == null) {
                debugTrace = new EclipseDebugTrace(bundleSymbolicName, singleton, traceEntryClass);
                debugTraceCache.put(bundleSymbolicName, debugTrace);
            }
        }
        return debugTrace;
    }

    public final File getFile() {
        return this.outFile;
    }

    public synchronized void setFile(File traceFile) {
        this.outFile = traceFile;
        FrameworkProperties.setProperty(PROP_TRACEFILE, this.outFile.getAbsolutePath());
        EclipseDebugTrace.newSession = true;
    }

    boolean isVerbose() {
        return this.verboseDebug;
    }

    public synchronized void setVerbose(boolean verbose) {
        this.verboseDebug = verbose;
        EclipseDebugTrace.newSession = true;
    }

    private void optionsChanged(String bundleSymbolicName) {
        BundleContext bc = this.context;
        if (bc == null) {
            return;
        }
        ServiceReference[] listenerRefs = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.debug.DebugOptionsListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            listenerRefs = bc.getServiceReferences(clazz.getName(), "(listener.symbolic.name=" + bundleSymbolicName + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (listenerRefs == null) {
            return;
        }
        int i = 0;
        while (i < listenerRefs.length) {
            block15: {
                DebugOptionsListener service = (DebugOptionsListener)bc.getService(listenerRefs[i]);
                if (service != null) {
                    try {
                        try {
                            service.optionsChanged(this);
                        }
                        catch (Throwable throwable) {
                            bc.ungetService(listenerRefs[i]);
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        bc.ungetService(listenerRefs[i]);
                        throw throwable;
                    }
                    bc.ungetService(listenerRefs[i]);
                }
            }
            ++i;
        }
    }

    public Object addingService(ServiceReference reference) {
        DebugOptionsListener listener = (DebugOptionsListener)this.context.getService(reference);
        listener.optionsChanged(this);
        return listener;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
    }
}

