/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d.font.encoding;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class CharTableConverter {
    private BufferedReader textFile = null;
    private PrintWriter javaOut = null;
    private int encType = 1;

    public void putHeaders(String pkg, String className) throws IOException {
        this.javaOut.println("//Generated by CharTableConverter");
        this.javaOut.println("//!!DO NOT EDIT");
        this.javaOut.println("package " + pkg + ";");
        this.javaOut.println();
        this.javaOut.println("import java.util.HashMap;");
        this.javaOut.println("import java.util.Map;");
        this.javaOut.println();
        this.javaOut.println("/**");
        this.javaOut.println(" * Generated " + className + " Encoding Table.");
        this.javaOut.println(" *");
        this.javaOut.println(" * @author org.freehep.graphics2d.font.CharTableConverter");
        this.javaOut.println(" */");
        this.javaOut.println("public class " + className + " extends AbstractCharTable {");
        this.javaOut.println("\tprivate Map<Character, String> unicodeToName = new HashMap<Character, String>();");
        this.javaOut.println("\tprivate Map<String, Character> nameToUnicode = new HashMap<String, Character>();");
        this.javaOut.println("\tprivate Map<String, Integer> nameToEnc = new HashMap<String, Integer>();");
        this.javaOut.println("\tprivate String[] encToName = new String[256];");
        this.javaOut.println("\tpublic " + className + "() {");
    }

    public void putMethods(String encoding, String tableName) throws IOException {
        this.javaOut.println("\tpublic String toName(Character c){");
        this.javaOut.println("\t\treturn unicodeToName.get(c);");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("\tpublic String toName(int enc){");
        this.javaOut.println("\t\tif(enc!=0)");
        this.javaOut.println("\t\treturn encToName[enc];");
        this.javaOut.println("\t\treturn null;");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("\tpublic int toEncoding(String name){");
        this.javaOut.println("\t\treturn nameToEnc.get(name).intValue();");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("\tpublic char toUnicode(String name){");
        this.javaOut.println("\t\treturn nameToUnicode.get(name).charValue();");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("\tpublic String getName(){");
        this.javaOut.println("\treturn \"" + tableName + "\";");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("\tpublic String getEncoding(){");
        this.javaOut.println("\t\treturn \"" + encoding + "\";");
        this.javaOut.println("\t}");
        this.javaOut.println();
        this.javaOut.println("}");
        this.javaOut.flush();
        this.javaOut.close();
    }

    public void openFiles(File in, String outName) throws IOException {
        FileInputStream textIn = new FileInputStream(in);
        InputStreamReader textFileReader = new InputStreamReader((InputStream)textIn, "UTF-16");
        File out = new File(outName);
        out.getParentFile().mkdirs();
        FileWriter javaFileWriter = new FileWriter(out);
        this.textFile = new BufferedReader(textFileReader);
        this.javaOut = new PrintWriter(javaFileWriter);
    }

    public void convertTxtToHash(String encoding) throws IOException {
        String buff;
        if (encoding.equals("ISO")) {
            this.encType = 5;
        }
        if (encoding.equals("PDF")) {
            this.encType = 4;
        }
        if (encoding.equals("WIN")) {
            this.encType = 3;
        }
        if (encoding.equals("MAC")) {
            this.encType = 2;
        }
        if (encoding.equals("STD")) {
            this.encType = 1;
        }
        while ((buff = this.textFile.readLine()) != null) {
            Integer encodingInt;
            String hexformat;
            String charCode;
            StringTokenizer st = new StringTokenizer(buff, "\t ");
            if (!st.hasMoreTokens() || (charCode = st.nextToken()).equals("##") || !st.hasMoreTokens()) continue;
            String charName = st.nextToken();
            String enc = "";
            for (int i = 0; i < this.encType; ++i) {
                if (!st.hasMoreTokens()) continue;
                enc = st.nextToken();
            }
            if (charCode.startsWith("\\u")) {
                int cCL = charCode.length();
                this.javaOut.println();
                hexformat = charCode.substring(cCL - 4, cCL);
                this.javaOut.print("\t\t\t");
                this.javaOut.println("unicodeToName.put(new Character((char)0x" + hexformat + "),\"" + charName + "\");");
                this.javaOut.print("\t\t\t");
                this.javaOut.println("nameToUnicode.put(\"" + charName + "\"" + ", new Character((char)0x" + hexformat + "));");
            } else {
                hexformat = "00" + Integer.toHexString(charCode.charAt(0));
                this.javaOut.println();
                this.javaOut.print("\t\t\t");
                this.javaOut.println("unicodeToName.put(new Character((char)0x" + hexformat.substring(hexformat.length() - 4, hexformat.length()) + "),\"" + charName + "\");");
                this.javaOut.print("\t\t\t");
                this.javaOut.println("nameToUnicode.put(\"" + charName + "\"" + ",new Character((char)0x" + hexformat.substring(hexformat.length() - 4, hexformat.length()) + "));");
            }
            if ((encodingInt = Integer.decode(enc)) < 0) continue;
            this.javaOut.print("\t\t\t");
            this.javaOut.println("nameToEnc.put(\"" + charName + "\", new Integer(" + encodingInt + "));");
            this.javaOut.print("\t\t\t");
            this.javaOut.println("encToName[" + encodingInt + "]=\"" + charName + "\";");
        }
        this.javaOut.println();
        this.javaOut.println("\t\t}");
        this.javaOut.println();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 3 || args.length > 4) {
            System.err.println("Usage: CharTableConverter destdir package txtfile [Encoding type]");
            System.exit(0);
        }
        CharTableConverter converter = new CharTableConverter();
        File src = new File(args[2]);
        String encoding = args.length == 4 ? args[3] : "";
        String tableName = src.getName();
        int dot = tableName.indexOf(46);
        if (dot >= 0) {
            tableName = tableName.substring(0, dot);
        }
        String className = encoding + tableName;
        String pkg = args[1];
        String destFile = args[0] + File.separator + pkg.replace('.', File.separatorChar) + File.separator + className + ".java";
        converter.openFiles(src, destFile);
        converter.putHeaders(pkg, className);
        converter.convertTxtToHash(encoding);
        converter.putMethods(encoding, tableName);
    }
}

