## TFSA-2020-003: Denial of service from TFLite implementation of segment sum

### CVE Number
CVE-2020-15213

### Impact
In TensorFlow Lite models using segment sum can trigger a denial of service by
causing an out of memory allocation in the implementation of segment sum. Since
code uses the last element of the tensor holding them to determine the
dimensionality of output tensor, attackers can use a very large value to trigger
a [large
allocation](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/lite/kernels/segment_sum.cc#L39-L48):
```cc
  if (segment_id_size > 0) {
    max_index = segment_ids->data.i32[segment_id_size - 1];
  }
  TfLiteIntArray* output_shape = TfLiteIntArrayCreate(NumDimensions(data));
  output_shape->data[0] = max_index + 1;
  for (int i = 1; i < data_rank; ++i) {
    output_shape->data[i] = data->dims->data[i];
  }
  return context->ResizeTensor(context, output, output_shape);
```

### Vulnerable Versions
TensorFlow 2.2.0, 2.3.0.

### Patches
We have patched the issue in
[204945b](https://github.com/tensorflow/tensorflow/commit/204945b) and will
release patch releases for all affected versions.

We recommend users to upgrade to TensorFlow 2.2.1, or 2.3.1.

### Workarounds
A potential workaround would be to add a custom `Verifier` to limit the maximum
value in the segment ids tensor. This only handles the case when the segment ids
are stored statically in the model, but a similar validation could be done if
the segment ids are generated at runtime, between inference steps.

However, if the segment ids are generated as outputs of a tensor during
inference steps, then there are no possible workaround and users are advised to
upgrade to patched code.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been discovered through a variant analysis of [a
vulnerability reported by members of the Aivul Team from Qihoo
360](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-002.md).
