/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.Library;
import gnu.jel.TestingUtils;
import gnu.jel.tests.DoubleObject;
import gnu.jel.tests.IntegerObject;
import gnu.jel.tests.VariableProvider;
import java.util.HashMap;

public class IntegralPrimitiveOPsTest
extends TestingUtils {
    Library lib;
    Object[] rtp;
    VariableProvider vp;
    Class<?>[] staticLib;
    Class<?>[] dynamicLib;
    HashMap<String, Class<?>> allowedCasts;

    public IntegralPrimitiveOPsTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        this.dynamicLib = new Class[1];
        this.rtp = new Object[1];
        this.vp = new VariableProvider();
        this.staticLib = new Class[2];
        this.staticLib[0] = Class.forName("java.lang.Math");
        this.staticLib[1] = this.vp.getClass();
        this.vp.xvar = 5.0;
        this.vp.strVar = "strVar";
        this.rtp[0] = this.vp;
        this.dynamicLib[0] = this.vp.getClass();
        Class[] dotLib = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.Double"), Class.forName("gnu.jel.reflect.Double"), IntegerObject.class, DoubleObject.class};
        this.vp.addProperty("p1", "p1value");
        this.vp.addProperty("p1.s1", "p1s1value");
        this.vp.addProperty("p1.s2", "p1s2value");
        this.vp.addProperty("p1.d1", VariableProvider.makeJELDoubleObject(1.0));
        this.vp.addProperty("p1.s2.ss1", "p1s2ss1value");
        this.vp.addProperty("p1.b1t", VariableProvider.makeJELBooleanObject(true));
        this.vp.addProperty("p1.b1f", VariableProvider.makeJELBooleanObject(false));
        this.allowedCasts = new HashMap();
        this.allowedCasts.put("String", String.class);
        this.allowedCasts.put("Object", Object.class);
        this.allowedCasts.put("Double", Double.class);
        this.lib = new Library(this.staticLib, this.dynamicLib, dotLib, this.vp, this.allowedCasts);
    }

    public void test1() throws Throwable {
        for (int k = 0; k < 2; ++k) {
            String[][] prefixes = new String[][]{{"val", "val", "val"}, {"arr", "arr", "arr"}};
            String[][] suffixes = new String[][]{{"", "Obj", "JELObj"}, {"[0]", "Obj[0]", "JELObj[0]"}};
            IntegralPrimitiveOPsTest.testUnaryPrimitive(0, 6, this.lib, this.rtp, -1L, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testUnaryPrimitive(1, 5, this.lib, this.rtp, -2L, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testUnaryPrimitive(2, 1, this.lib, this.rtp, 0L, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(0, 45, this.lib, this.rtp, 2, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(1, 45, this.lib, this.rtp, 0, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(2, 45, this.lib, this.rtp, 1, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(3, 45, this.lib, this.rtp, 1, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(4, 45, this.lib, this.rtp, 0, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(5, 26, this.lib, this.rtp, 1, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(6, 26, this.lib, this.rtp, 1, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(7, 26, this.lib, this.rtp, 0, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(8, 46, this.lib, this.rtp, 1, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(9, 46, this.lib, this.rtp, 0, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(10, 45, this.lib, this.rtp, 0, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(11, 45, this.lib, this.rtp, 1, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(12, 45, this.lib, this.rtp, 0, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(13, 45, this.lib, this.rtp, 1, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(14, 25, this.lib, this.rtp, 2, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(15, 25, this.lib, this.rtp, 0, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(16, 25, this.lib, this.rtp, 0, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(17, 1, this.lib, this.rtp, 1, null, prefixes[k], suffixes[k]);
            IntegralPrimitiveOPsTest.testBinaryPrimitive(18, 1, this.lib, this.rtp, 1, null, prefixes[k], suffixes[k]);
        }
    }
}

