/*
 * Copyright 2000-2009 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.fragments.LineFragment;

import java.util.ArrayList;

public class DiffFragmentsProcessor {
  public ArrayList<LineFragment> process(DiffFragment[] fragments) {
    LineFragmentsCollector collector = new LineFragmentsCollector();
    for (int i = 0; i < fragments.length; i++) {
      DiffFragment fragment = fragments[i];
      collector.addDiffFragment(fragment);
    }
    return collector.getFragments();
  }
}
