/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFCatalog;
import gnu.jpdf.PDFInfo;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFXref;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class PDFOutput {
    protected final OutputStream os;
    protected final ByteArrayOutputStream baos;
    protected int offset;
    protected final Vector<PDFXref> offsets;
    protected PDFObject rootID;
    protected PDFObject infoID;

    public PDFOutput(OutputStream outputStream) throws IOException {
        this.os = outputStream;
        this.offset = 0;
        this.offsets = new Vector();
        this.baos = new ByteArrayOutputStream();
        this.baos.write("%PDF-1.2\n".getBytes());
        this.baos.write("%\u00e2\u00e3\u00cf\u00d3\n".getBytes());
        this.offset = this.baos.size();
        this.baos.writeTo(outputStream);
    }

    protected void write(PDFObject pDFObject) throws IOException {
        if (pDFObject instanceof PDFCatalog) {
            this.rootID = pDFObject;
        }
        if (pDFObject instanceof PDFInfo) {
            this.infoID = pDFObject;
        }
        this.offsets.addElement(new PDFXref(pDFObject.getSerialID(), this.offset));
        this.baos.reset();
        pDFObject.write(this.baos);
        this.offset += this.baos.size();
        this.baos.writeTo(this.os);
    }

    protected void close() throws IOException {
        this.os.flush();
        this.baos.reset();
        this.baos.write("xref\n".getBytes());
        int n = 0;
        int n2 = -1;
        Vector<PDFXref> vector = new Vector<PDFXref>();
        vector.addElement(new PDFXref(0, 0, 65535));
        for (PDFXref pDFXref : this.offsets) {
            if (n == -1) {
                n = pDFXref.id;
            }
            if (n2 > -1 && pDFXref.id != n2 + 1) {
                this.writeblock(n, vector);
                vector.removeAllElements();
                n = -1;
            }
            vector.addElement(pDFXref);
            n2 = pDFXref.id;
        }
        if (n > -1) {
            this.writeblock(n, vector);
        }
        this.baos.write("trailer\n<<\n".getBytes());
        this.baos.write("/Size ".getBytes());
        this.baos.write(Integer.toString(this.offsets.size() + 1).getBytes());
        this.baos.write("\n".getBytes());
        if (this.rootID == null) {
            throw new IOException("Root object is not present in document");
        }
        this.baos.write("/Root ".getBytes());
        this.baos.write(this.rootID.toString().getBytes());
        this.baos.write("\n".getBytes());
        if (this.infoID != null) {
            this.baos.write("/Info ".getBytes());
            this.baos.write(this.infoID.toString().getBytes());
            this.baos.write("\n".getBytes());
        }
        this.baos.write(">>\nstartxref\n".getBytes());
        this.baos.write(Integer.toString(this.offset).getBytes());
        this.baos.write("\n%%EOF\n".getBytes());
        this.baos.writeTo(this.os);
        this.os.flush();
    }

    protected void writeblock(int n, Vector<PDFXref> vector) throws IOException {
        this.baos.write(Integer.toString(n).getBytes());
        this.baos.write(" ".getBytes());
        this.baos.write(Integer.toString(vector.size()).getBytes());
        this.baos.write("\n".getBytes());
        for (PDFXref pDFXref : vector) {
            this.baos.write(pDFXref.toString().getBytes());
            this.baos.write("\n".getBytes());
        }
    }
}

