# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, AsyncIterator, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._web_apps_operations import (
    build_add_premier_add_on_request,
    build_add_premier_add_on_slot_request,
    build_analyze_custom_hostname_request,
    build_analyze_custom_hostname_slot_request,
    build_apply_slot_config_to_production_request,
    build_apply_slot_configuration_slot_request,
    build_approve_or_reject_private_endpoint_connection_request,
    build_approve_or_reject_private_endpoint_connection_slot_request,
    build_backup_request,
    build_backup_slot_request,
    build_create_deployment_request,
    build_create_deployment_slot_request,
    build_create_function_request,
    build_create_instance_function_slot_request,
    build_create_instance_ms_deploy_operation_request,
    build_create_instance_ms_deploy_operation_slot_request,
    build_create_ms_deploy_operation_request,
    build_create_ms_deploy_operation_slot_request,
    build_create_or_update_configuration_request,
    build_create_or_update_configuration_slot_request,
    build_create_or_update_domain_ownership_identifier_request,
    build_create_or_update_domain_ownership_identifier_slot_request,
    build_create_or_update_function_secret_request,
    build_create_or_update_function_secret_slot_request,
    build_create_or_update_host_name_binding_request,
    build_create_or_update_host_name_binding_slot_request,
    build_create_or_update_host_secret_request,
    build_create_or_update_host_secret_slot_request,
    build_create_or_update_hybrid_connection_request,
    build_create_or_update_hybrid_connection_slot_request,
    build_create_or_update_public_certificate_request,
    build_create_or_update_public_certificate_slot_request,
    build_create_or_update_relay_service_connection_request,
    build_create_or_update_relay_service_connection_slot_request,
    build_create_or_update_request,
    build_create_or_update_slot_request,
    build_create_or_update_source_control_request,
    build_create_or_update_source_control_slot_request,
    build_create_or_update_swift_virtual_network_connection_with_check_request,
    build_create_or_update_swift_virtual_network_connection_with_check_slot_request,
    build_create_or_update_vnet_connection_gateway_request,
    build_create_or_update_vnet_connection_gateway_slot_request,
    build_create_or_update_vnet_connection_request,
    build_create_or_update_vnet_connection_slot_request,
    build_delete_backup_configuration_request,
    build_delete_backup_configuration_slot_request,
    build_delete_backup_request,
    build_delete_backup_slot_request,
    build_delete_continuous_web_job_request,
    build_delete_continuous_web_job_slot_request,
    build_delete_deployment_request,
    build_delete_deployment_slot_request,
    build_delete_domain_ownership_identifier_request,
    build_delete_domain_ownership_identifier_slot_request,
    build_delete_function_request,
    build_delete_function_secret_request,
    build_delete_function_secret_slot_request,
    build_delete_host_name_binding_request,
    build_delete_host_name_binding_slot_request,
    build_delete_host_secret_request,
    build_delete_host_secret_slot_request,
    build_delete_hybrid_connection_request,
    build_delete_hybrid_connection_slot_request,
    build_delete_instance_function_slot_request,
    build_delete_instance_process_request,
    build_delete_instance_process_slot_request,
    build_delete_premier_add_on_request,
    build_delete_premier_add_on_slot_request,
    build_delete_private_endpoint_connection_request,
    build_delete_private_endpoint_connection_slot_request,
    build_delete_process_request,
    build_delete_process_slot_request,
    build_delete_public_certificate_request,
    build_delete_public_certificate_slot_request,
    build_delete_relay_service_connection_request,
    build_delete_relay_service_connection_slot_request,
    build_delete_request,
    build_delete_site_extension_request,
    build_delete_site_extension_slot_request,
    build_delete_slot_request,
    build_delete_source_control_request,
    build_delete_source_control_slot_request,
    build_delete_swift_virtual_network_request,
    build_delete_swift_virtual_network_slot_request,
    build_delete_triggered_web_job_request,
    build_delete_triggered_web_job_slot_request,
    build_delete_vnet_connection_request,
    build_delete_vnet_connection_slot_request,
    build_discover_backup_request,
    build_discover_backup_slot_request,
    build_generate_new_site_publishing_password_request,
    build_generate_new_site_publishing_password_slot_request,
    build_get_app_setting_key_vault_reference_request,
    build_get_app_setting_key_vault_reference_slot_request,
    build_get_app_settings_key_vault_references_request,
    build_get_app_settings_key_vault_references_slot_request,
    build_get_auth_settings_request,
    build_get_auth_settings_slot_request,
    build_get_auth_settings_v2_request,
    build_get_auth_settings_v2_slot_request,
    build_get_backup_configuration_request,
    build_get_backup_configuration_slot_request,
    build_get_backup_status_request,
    build_get_backup_status_slot_request,
    build_get_configuration_request,
    build_get_configuration_slot_request,
    build_get_configuration_snapshot_request,
    build_get_configuration_snapshot_slot_request,
    build_get_container_logs_zip_request,
    build_get_container_logs_zip_slot_request,
    build_get_continuous_web_job_request,
    build_get_continuous_web_job_slot_request,
    build_get_deployment_request,
    build_get_deployment_slot_request,
    build_get_diagnostic_logs_configuration_request,
    build_get_diagnostic_logs_configuration_slot_request,
    build_get_domain_ownership_identifier_request,
    build_get_domain_ownership_identifier_slot_request,
    build_get_ftp_allowed_request,
    build_get_ftp_allowed_slot_request,
    build_get_function_request,
    build_get_functions_admin_token_request,
    build_get_functions_admin_token_slot_request,
    build_get_host_name_binding_request,
    build_get_host_name_binding_slot_request,
    build_get_hybrid_connection_request,
    build_get_hybrid_connection_slot_request,
    build_get_instance_function_slot_request,
    build_get_instance_info_request,
    build_get_instance_info_slot_request,
    build_get_instance_ms_deploy_log_request,
    build_get_instance_ms_deploy_log_slot_request,
    build_get_instance_ms_deploy_status_request,
    build_get_instance_ms_deploy_status_slot_request,
    build_get_instance_process_dump_request,
    build_get_instance_process_dump_slot_request,
    build_get_instance_process_module_request,
    build_get_instance_process_module_slot_request,
    build_get_instance_process_request,
    build_get_instance_process_slot_request,
    build_get_migrate_my_sql_status_request,
    build_get_migrate_my_sql_status_slot_request,
    build_get_ms_deploy_log_request,
    build_get_ms_deploy_log_slot_request,
    build_get_ms_deploy_status_request,
    build_get_ms_deploy_status_slot_request,
    build_get_network_trace_operation_request,
    build_get_network_trace_operation_slot_request,
    build_get_network_trace_operation_slot_v2_request,
    build_get_network_trace_operation_v2_request,
    build_get_network_traces_request,
    build_get_network_traces_slot_request,
    build_get_network_traces_slot_v2_request,
    build_get_network_traces_v2_request,
    build_get_premier_add_on_request,
    build_get_premier_add_on_slot_request,
    build_get_private_access_request,
    build_get_private_access_slot_request,
    build_get_private_endpoint_connection_list_request,
    build_get_private_endpoint_connection_list_slot_request,
    build_get_private_endpoint_connection_request,
    build_get_private_endpoint_connection_slot_request,
    build_get_private_link_resources_request,
    build_get_private_link_resources_slot_request,
    build_get_process_dump_request,
    build_get_process_dump_slot_request,
    build_get_process_module_request,
    build_get_process_module_slot_request,
    build_get_process_request,
    build_get_process_slot_request,
    build_get_public_certificate_request,
    build_get_public_certificate_slot_request,
    build_get_relay_service_connection_request,
    build_get_relay_service_connection_slot_request,
    build_get_request,
    build_get_scm_allowed_request,
    build_get_scm_allowed_slot_request,
    build_get_site_connection_string_key_vault_reference_request,
    build_get_site_connection_string_key_vault_reference_slot_request,
    build_get_site_connection_string_key_vault_references_request,
    build_get_site_connection_string_key_vault_references_slot_request,
    build_get_site_extension_request,
    build_get_site_extension_slot_request,
    build_get_site_php_error_log_flag_request,
    build_get_site_php_error_log_flag_slot_request,
    build_get_slot_request,
    build_get_source_control_request,
    build_get_source_control_slot_request,
    build_get_swift_virtual_network_connection_request,
    build_get_swift_virtual_network_connection_slot_request,
    build_get_triggered_web_job_history_request,
    build_get_triggered_web_job_history_slot_request,
    build_get_triggered_web_job_request,
    build_get_triggered_web_job_slot_request,
    build_get_vnet_connection_gateway_request,
    build_get_vnet_connection_gateway_slot_request,
    build_get_vnet_connection_request,
    build_get_vnet_connection_slot_request,
    build_get_web_job_request,
    build_get_web_job_slot_request,
    build_get_web_site_container_logs_request,
    build_get_web_site_container_logs_slot_request,
    build_install_site_extension_request,
    build_install_site_extension_slot_request,
    build_is_cloneable_request,
    build_is_cloneable_slot_request,
    build_list_application_settings_request,
    build_list_application_settings_slot_request,
    build_list_azure_storage_accounts_request,
    build_list_azure_storage_accounts_slot_request,
    build_list_backup_status_secrets_request,
    build_list_backup_status_secrets_slot_request,
    build_list_backups_request,
    build_list_backups_slot_request,
    build_list_basic_publishing_credentials_policies_request,
    build_list_basic_publishing_credentials_policies_slot_request,
    build_list_by_resource_group_request,
    build_list_configuration_snapshot_info_request,
    build_list_configuration_snapshot_info_slot_request,
    build_list_configurations_request,
    build_list_configurations_slot_request,
    build_list_connection_strings_request,
    build_list_connection_strings_slot_request,
    build_list_continuous_web_jobs_request,
    build_list_continuous_web_jobs_slot_request,
    build_list_deployment_log_request,
    build_list_deployment_log_slot_request,
    build_list_deployments_request,
    build_list_deployments_slot_request,
    build_list_domain_ownership_identifiers_request,
    build_list_domain_ownership_identifiers_slot_request,
    build_list_function_keys_request,
    build_list_function_keys_slot_request,
    build_list_function_secrets_request,
    build_list_function_secrets_slot_request,
    build_list_functions_request,
    build_list_host_keys_request,
    build_list_host_keys_slot_request,
    build_list_host_name_bindings_request,
    build_list_host_name_bindings_slot_request,
    build_list_hybrid_connections_request,
    build_list_hybrid_connections_slot_request,
    build_list_instance_functions_slot_request,
    build_list_instance_identifiers_request,
    build_list_instance_identifiers_slot_request,
    build_list_instance_process_modules_request,
    build_list_instance_process_modules_slot_request,
    build_list_instance_process_threads_request,
    build_list_instance_process_threads_slot_request,
    build_list_instance_processes_request,
    build_list_instance_processes_slot_request,
    build_list_metadata_request,
    build_list_metadata_slot_request,
    build_list_network_features_request,
    build_list_network_features_slot_request,
    build_list_perf_mon_counters_request,
    build_list_perf_mon_counters_slot_request,
    build_list_premier_add_ons_request,
    build_list_premier_add_ons_slot_request,
    build_list_process_modules_request,
    build_list_process_modules_slot_request,
    build_list_process_threads_request,
    build_list_process_threads_slot_request,
    build_list_processes_request,
    build_list_processes_slot_request,
    build_list_public_certificates_request,
    build_list_public_certificates_slot_request,
    build_list_publishing_credentials_request,
    build_list_publishing_credentials_slot_request,
    build_list_publishing_profile_xml_with_secrets_request,
    build_list_publishing_profile_xml_with_secrets_slot_request,
    build_list_relay_service_connections_request,
    build_list_relay_service_connections_slot_request,
    build_list_request,
    build_list_site_backups_request,
    build_list_site_backups_slot_request,
    build_list_site_extensions_request,
    build_list_site_extensions_slot_request,
    build_list_site_push_settings_request,
    build_list_site_push_settings_slot_request,
    build_list_slot_configuration_names_request,
    build_list_slot_differences_from_production_request,
    build_list_slot_differences_slot_request,
    build_list_slots_request,
    build_list_snapshots_from_dr_secondary_request,
    build_list_snapshots_from_dr_secondary_slot_request,
    build_list_snapshots_request,
    build_list_snapshots_slot_request,
    build_list_sync_function_triggers_request,
    build_list_sync_function_triggers_slot_request,
    build_list_sync_status_request,
    build_list_sync_status_slot_request,
    build_list_triggered_web_job_history_request,
    build_list_triggered_web_job_history_slot_request,
    build_list_triggered_web_jobs_request,
    build_list_triggered_web_jobs_slot_request,
    build_list_usages_request,
    build_list_usages_slot_request,
    build_list_vnet_connections_request,
    build_list_vnet_connections_slot_request,
    build_list_web_jobs_request,
    build_list_web_jobs_slot_request,
    build_migrate_my_sql_request,
    build_migrate_storage_request,
    build_put_private_access_vnet_request,
    build_put_private_access_vnet_slot_request,
    build_recover_site_configuration_snapshot_request,
    build_recover_site_configuration_snapshot_slot_request,
    build_reset_production_slot_config_request,
    build_reset_slot_configuration_slot_request,
    build_restart_request,
    build_restart_slot_request,
    build_restore_from_backup_blob_request,
    build_restore_from_backup_blob_slot_request,
    build_restore_from_deleted_app_request,
    build_restore_from_deleted_app_slot_request,
    build_restore_request,
    build_restore_slot_request,
    build_restore_snapshot_request,
    build_restore_snapshot_slot_request,
    build_run_triggered_web_job_request,
    build_run_triggered_web_job_slot_request,
    build_start_continuous_web_job_request,
    build_start_continuous_web_job_slot_request,
    build_start_network_trace_request,
    build_start_network_trace_slot_request,
    build_start_request,
    build_start_slot_request,
    build_start_web_site_network_trace_operation_request,
    build_start_web_site_network_trace_operation_slot_request,
    build_start_web_site_network_trace_request,
    build_start_web_site_network_trace_slot_request,
    build_stop_continuous_web_job_request,
    build_stop_continuous_web_job_slot_request,
    build_stop_network_trace_request,
    build_stop_network_trace_slot_request,
    build_stop_request,
    build_stop_slot_request,
    build_stop_web_site_network_trace_request,
    build_stop_web_site_network_trace_slot_request,
    build_swap_slot_request,
    build_swap_slot_with_production_request,
    build_sync_function_triggers_request,
    build_sync_function_triggers_slot_request,
    build_sync_functions_request,
    build_sync_functions_slot_request,
    build_sync_repository_request,
    build_sync_repository_slot_request,
    build_update_application_settings_request,
    build_update_application_settings_slot_request,
    build_update_auth_settings_request,
    build_update_auth_settings_slot_request,
    build_update_auth_settings_v2_request,
    build_update_auth_settings_v2_slot_request,
    build_update_azure_storage_accounts_request,
    build_update_azure_storage_accounts_slot_request,
    build_update_backup_configuration_request,
    build_update_backup_configuration_slot_request,
    build_update_configuration_request,
    build_update_configuration_slot_request,
    build_update_connection_strings_request,
    build_update_connection_strings_slot_request,
    build_update_diagnostic_logs_config_request,
    build_update_diagnostic_logs_config_slot_request,
    build_update_domain_ownership_identifier_request,
    build_update_domain_ownership_identifier_slot_request,
    build_update_ftp_allowed_request,
    build_update_ftp_allowed_slot_request,
    build_update_hybrid_connection_request,
    build_update_hybrid_connection_slot_request,
    build_update_metadata_request,
    build_update_metadata_slot_request,
    build_update_premier_add_on_request,
    build_update_premier_add_on_slot_request,
    build_update_relay_service_connection_request,
    build_update_relay_service_connection_slot_request,
    build_update_request,
    build_update_scm_allowed_request,
    build_update_scm_allowed_slot_request,
    build_update_site_push_settings_request,
    build_update_site_push_settings_slot_request,
    build_update_slot_configuration_names_request,
    build_update_slot_request,
    build_update_source_control_request,
    build_update_source_control_slot_request,
    build_update_swift_virtual_network_connection_with_check_request,
    build_update_swift_virtual_network_connection_with_check_slot_request,
    build_update_vnet_connection_gateway_request,
    build_update_vnet_connection_gateway_slot_request,
    build_update_vnet_connection_request,
    build_update_vnet_connection_slot_request,
)
from .._vendor import WebSiteManagementClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class WebAppsOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.web.v2021_01_15.aio.WebSiteManagementClient`'s
        :attr:`web_apps` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.Site"]:
        """Get all apps for a subscription.

        Get all apps for a subscription.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Site or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.WebAppCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("WebAppCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Web/sites"}

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, include_slots: Optional[bool] = None, **kwargs: Any
    ) -> AsyncIterable["_models.Site"]:
        """Gets all web, mobile, and API apps in the specified resource group.

        Gets all web, mobile, and API apps in the specified resource group.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param include_slots: Specify :code:`<strong>true</strong>` to include deployment slots in
         results. The default is false, which only gives you the production slot of all apps. Default
         value is None.
        :type include_slots: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Site or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.WebAppCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    include_slots=include_slots,
                    api_version=api_version,
                    template_url=self.list_by_resource_group.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("WebAppCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites"
    }

    @distributed_trace_async
    async def get(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.Site:
        """Gets the details of a web, mobile, or API app.

        Gets the details of a web, mobile, or API app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Site", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}"
    }

    async def _create_or_update_initial(
        self, resource_group_name: str, name: str, site_envelope: Union[_models.Site, IO], **kwargs: Any
    ) -> _models.Site:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_envelope, (IO, bytes)):
            _content = site_envelope
        else:
            _json = self._serialize.body(site_envelope, "Site")

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_or_update_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("Site", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("Site", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _create_or_update_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}"
    }

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        name: str,
        site_envelope: _models.Site,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: ~azure.mgmt.web.v2021_01_15.models.Site
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        name: str,
        site_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self, resource_group_name: str, name: str, site_envelope: Union[_models.Site, IO], **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Is either a
         Site type or a IO type. Required.
        :type site_envelope: ~azure.mgmt.web.v2021_01_15.models.Site or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                name=name,
                site_envelope=site_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("Site", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create_or_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}"
    }

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        delete_metrics: Optional[bool] = None,
        delete_empty_server_farm: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a web, mobile, or API app, or one of the deployment slots.

        Deletes a web, mobile, or API app, or one of the deployment slots.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app to delete. Required.
        :type name: str
        :param delete_metrics: If true, web app metrics are also deleted. Default value is None.
        :type delete_metrics: bool
        :param delete_empty_server_farm: Specify false if you want to keep empty App Service plan. By
         default, empty App Service plan is deleted. Default value is None.
        :type delete_empty_server_farm: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            delete_metrics=delete_metrics,
            delete_empty_server_farm=delete_empty_server_farm,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}"
    }

    @overload
    async def update(
        self,
        resource_group_name: str,
        name: str,
        site_envelope: _models.SitePatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: ~azure.mgmt.web.v2021_01_15.models.SitePatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        name: str,
        site_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self, resource_group_name: str, name: str, site_envelope: Union[_models.SitePatchResource, IO], **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param site_envelope: A JSON representation of the app properties. See example. Is either a
         SitePatchResource type or a IO type. Required.
        :type site_envelope: ~azure.mgmt.web.v2021_01_15.models.SitePatchResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_envelope, (IO, bytes)):
            _content = site_envelope
        else:
            _json = self._serialize.body(site_envelope, "SitePatchResource")

        request = build_update_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("Site", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("Site", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}"
    }

    @distributed_trace_async
    async def analyze_custom_hostname(
        self, resource_group_name: str, name: str, host_name: Optional[str] = None, **kwargs: Any
    ) -> _models.CustomHostnameAnalysisResult:
        """Analyze a custom hostname.

        Analyze a custom hostname.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param host_name: Custom hostname. Default value is None.
        :type host_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CustomHostnameAnalysisResult or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CustomHostnameAnalysisResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.CustomHostnameAnalysisResult] = kwargs.pop("cls", None)

        request = build_analyze_custom_hostname_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            host_name=host_name,
            api_version=api_version,
            template_url=self.analyze_custom_hostname.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CustomHostnameAnalysisResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    analyze_custom_hostname.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/analyzeCustomHostname"
    }

    @overload
    async def apply_slot_config_to_production(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        slot_swap_entity: _models.CsmSlotEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Required.
        :type slot_swap_entity: ~azure.mgmt.web.v2021_01_15.models.CsmSlotEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def apply_slot_config_to_production(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        slot_swap_entity: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Required.
        :type slot_swap_entity: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def apply_slot_config_to_production(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, slot_swap_entity: Union[_models.CsmSlotEntity, IO], **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Is either
         a CsmSlotEntity type or a IO type. Required.
        :type slot_swap_entity: ~azure.mgmt.web.v2021_01_15.models.CsmSlotEntity or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(slot_swap_entity, (IO, bytes)):
            _content = slot_swap_entity
        else:
            _json = self._serialize.body(slot_swap_entity, "CsmSlotEntity")

        request = build_apply_slot_config_to_production_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.apply_slot_config_to_production.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    apply_slot_config_to_production.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig"
    }

    @overload
    async def backup(
        self,
        resource_group_name: str,
        name: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def backup(
        self, resource_group_name: str, name: str, request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def backup(
        self, resource_group_name: str, name: str, request: Union[_models.BackupRequest, IO], **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Is either a BackupRequest type or a IO type. Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        request = build_backup_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.backup.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    backup.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup"
    }

    @distributed_trace
    def list_backups(self, resource_group_name: str, name: str, **kwargs: Any) -> AsyncIterable["_models.BackupItem"]:
        """Gets existing backups of an app.

        Gets existing backups of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either BackupItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.BackupItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.BackupItemCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_backups_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_backups.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("BackupItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_backups.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups"
    }

    @distributed_trace_async
    async def get_backup_status(
        self, resource_group_name: str, name: str, backup_id: str, **kwargs: Any
    ) -> _models.BackupItem:
        """Gets a backup of an app by its ID.

        Gets a backup of an app by its ID.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        request = build_get_backup_status_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_backup_status.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_backup_status.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}"
    }

    @distributed_trace_async
    async def delete_backup(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, backup_id: str, **kwargs: Any
    ) -> None:
        """Deletes a backup of an app by its ID.

        Deletes a backup of an app by its ID.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_backup_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_backup.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_backup.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}"
    }

    @overload
    async def list_backup_status_secrets(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param request: Information on backup request. Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_backup_status_secrets(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param request: Information on backup request. Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_backup_status_secrets(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: Union[_models.BackupRequest, IO],
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param request: Information on backup request. Is either a BackupRequest type or a IO type.
         Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        request = build_list_backup_status_secrets_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_backup_status_secrets.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_backup_status_secrets.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list"
    }

    async def _restore_initial(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: Union[_models.RestoreRequest, IO],
        **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "RestoreRequest")

        request = build_restore_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._restore_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _restore_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore"
    }

    @overload
    async def begin_restore(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: _models.RestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param request: Information on restore request . Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param request: Information on restore request . Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        request: Union[_models.RestoreRequest, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param request: Information on restore request . Is either a RestoreRequest type or a IO type.
         Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_initial(  # type: ignore
                resource_group_name=resource_group_name,
                name=name,
                backup_id=backup_id,
                request=request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_restore.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore"
    }

    @distributed_trace
    def list_basic_publishing_credentials_policies(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.CsmPublishingCredentialsPoliciesEntity"]:
        """Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.

        Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CsmPublishingCredentialsPoliciesEntity or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PublishingCredentialsPoliciesCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_basic_publishing_credentials_policies_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_basic_publishing_credentials_policies.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PublishingCredentialsPoliciesCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_basic_publishing_credentials_policies.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies"
    }

    @distributed_trace_async
    async def get_ftp_allowed(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Returns whether FTP is allowed on the site or not.

        Returns whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        request = build_get_ftp_allowed_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_ftp_allowed.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_ftp_allowed.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/ftp"
    }

    @overload
    async def update_ftp_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: _models.CsmPublishingCredentialsPoliciesEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_ftp_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_ftp_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: Union[_models.CsmPublishingCredentialsPoliciesEntity, IO],
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Is either a
         CsmPublishingCredentialsPoliciesEntity type or a IO type. Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(csm_publishing_access_policies_entity, (IO, bytes)):
            _content = csm_publishing_access_policies_entity
        else:
            _json = self._serialize.body(
                csm_publishing_access_policies_entity, "CsmPublishingCredentialsPoliciesEntity"
            )

        request = build_update_ftp_allowed_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_ftp_allowed.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_ftp_allowed.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/ftp"
    }

    @distributed_trace_async
    async def get_scm_allowed(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Returns whether Scm basic auth is allowed on the site or not.

        Returns whether Scm basic auth is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        request = build_get_scm_allowed_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_scm_allowed.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_scm_allowed.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/scm"
    }

    @overload
    async def update_scm_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: _models.CsmPublishingCredentialsPoliciesEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_scm_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_scm_allowed(
        self,
        resource_group_name: str,
        name: str,
        csm_publishing_access_policies_entity: Union[_models.CsmPublishingCredentialsPoliciesEntity, IO],
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param csm_publishing_access_policies_entity: Is either a
         CsmPublishingCredentialsPoliciesEntity type or a IO type. Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(csm_publishing_access_policies_entity, (IO, bytes)):
            _content = csm_publishing_access_policies_entity
        else:
            _json = self._serialize.body(
                csm_publishing_access_policies_entity, "CsmPublishingCredentialsPoliciesEntity"
            )

        request = build_update_scm_allowed_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_scm_allowed.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_scm_allowed.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/basicPublishingCredentialsPolicies/scm"
    }

    @distributed_trace
    def list_configurations(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.SiteConfigResource"]:
        """List the configurations of an app.

        List the configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SiteConfigResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.SiteConfigResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteConfigResourceCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_configurations_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_configurations.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SiteConfigResourceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_configurations.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config"
    }

    @overload
    async def update_application_settings(
        self,
        resource_group_name: str,
        name: str,
        app_settings: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param app_settings: Application settings of the app. Required.
        :type app_settings: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_application_settings(
        self,
        resource_group_name: str,
        name: str,
        app_settings: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param app_settings: Application settings of the app. Required.
        :type app_settings: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_application_settings(
        self, resource_group_name: str, name: str, app_settings: Union[_models.StringDictionary, IO], **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param app_settings: Application settings of the app. Is either a StringDictionary type or a IO
         type. Required.
        :type app_settings: ~azure.mgmt.web.v2021_01_15.models.StringDictionary or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_settings, (IO, bytes)):
            _content = app_settings
        else:
            _json = self._serialize.body(app_settings, "StringDictionary")

        request = build_update_application_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_application_settings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_application_settings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings"
    }

    @distributed_trace_async
    async def list_application_settings(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the application settings of an app.

        Gets the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        request = build_list_application_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_application_settings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_application_settings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list"
    }

    @overload
    async def update_auth_settings(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings: _models.SiteAuthSettings,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings: Auth settings associated with web app. Required.
        :type site_auth_settings: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_auth_settings(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings: Auth settings associated with web app. Required.
        :type site_auth_settings: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_auth_settings(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings: Union[_models.SiteAuthSettings, IO],
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings: Auth settings associated with web app. Is either a SiteAuthSettings
         type or a IO type. Required.
        :type site_auth_settings: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteAuthSettings] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_auth_settings, (IO, bytes)):
            _content = site_auth_settings
        else:
            _json = self._serialize.body(site_auth_settings, "SiteAuthSettings")

        request = build_update_auth_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_auth_settings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettings", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_auth_settings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings"
    }

    @distributed_trace_async
    async def get_auth_settings(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.SiteAuthSettings:
        """Gets the Authentication/Authorization settings of an app.

        Gets the Authentication/Authorization settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteAuthSettings] = kwargs.pop("cls", None)

        request = build_get_auth_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_auth_settings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettings", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_auth_settings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list"
    }

    @overload
    async def update_auth_settings_v2(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings_v2: _models.SiteAuthSettingsV2,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Updates site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings_v2: Auth settings associated with web app. Required.
        :type site_auth_settings_v2: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_auth_settings_v2(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings_v2: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Updates site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings_v2: Auth settings associated with web app. Required.
        :type site_auth_settings_v2: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_auth_settings_v2(
        self,
        resource_group_name: str,
        name: str,
        site_auth_settings_v2: Union[_models.SiteAuthSettingsV2, IO],
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Updates site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param site_auth_settings_v2: Auth settings associated with web app. Is either a
         SiteAuthSettingsV2 type or a IO type. Required.
        :type site_auth_settings_v2: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2 or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteAuthSettingsV2] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_auth_settings_v2, (IO, bytes)):
            _content = site_auth_settings_v2
        else:
            _json = self._serialize.body(site_auth_settings_v2, "SiteAuthSettingsV2")

        request = build_update_auth_settings_v2_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_auth_settings_v2.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettingsV2", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_auth_settings_v2.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettingsV2"
    }

    @distributed_trace_async
    async def get_auth_settings_v2(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Gets site's Authentication / Authorization settings for apps via the V2 format.

        Gets site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteAuthSettingsV2] = kwargs.pop("cls", None)

        request = build_get_auth_settings_v2_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_auth_settings_v2.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettingsV2", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_auth_settings_v2.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettingsV2/list"
    }

    @overload
    async def update_azure_storage_accounts(
        self,
        resource_group_name: str,
        name: str,
        azure_storage_accounts: _models.AzureStoragePropertyDictionaryResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param azure_storage_accounts: Azure storage accounts of the app. Required.
        :type azure_storage_accounts:
         ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_azure_storage_accounts(
        self,
        resource_group_name: str,
        name: str,
        azure_storage_accounts: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param azure_storage_accounts: Azure storage accounts of the app. Required.
        :type azure_storage_accounts: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_azure_storage_accounts(
        self,
        resource_group_name: str,
        name: str,
        azure_storage_accounts: Union[_models.AzureStoragePropertyDictionaryResource, IO],
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param azure_storage_accounts: Azure storage accounts of the app. Is either a
         AzureStoragePropertyDictionaryResource type or a IO type. Required.
        :type azure_storage_accounts:
         ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AzureStoragePropertyDictionaryResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(azure_storage_accounts, (IO, bytes)):
            _content = azure_storage_accounts
        else:
            _json = self._serialize.body(azure_storage_accounts, "AzureStoragePropertyDictionaryResource")

        request = build_update_azure_storage_accounts_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_azure_storage_accounts.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AzureStoragePropertyDictionaryResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_azure_storage_accounts.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/azurestorageaccounts"
    }

    @distributed_trace_async
    async def list_azure_storage_accounts(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Gets the Azure storage account configurations of an app.

        Gets the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.AzureStoragePropertyDictionaryResource] = kwargs.pop("cls", None)

        request = build_list_azure_storage_accounts_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_azure_storage_accounts.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AzureStoragePropertyDictionaryResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_azure_storage_accounts.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/azurestorageaccounts/list"
    }

    @overload
    async def update_backup_configuration(
        self,
        resource_group_name: str,
        name: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Edited backup configuration. Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_backup_configuration(
        self, resource_group_name: str, name: str, request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Edited backup configuration. Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_backup_configuration(
        self, resource_group_name: str, name: str, request: Union[_models.BackupRequest, IO], **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Edited backup configuration. Is either a BackupRequest type or a IO type.
         Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupRequest] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        request = build_update_backup_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_backup_configuration.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupRequest", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_backup_configuration.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup"
    }

    @distributed_trace_async
    async def delete_backup_configuration(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> None:
        """Deletes the backup configuration of an app.

        Deletes the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_backup_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_backup_configuration.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_backup_configuration.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup"
    }

    @distributed_trace_async
    async def get_backup_configuration(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.BackupRequest:
        """Gets the backup configuration of an app.

        Gets the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.BackupRequest] = kwargs.pop("cls", None)

        request = build_get_backup_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_backup_configuration.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupRequest", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_backup_configuration.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list"
    }

    @distributed_trace
    def get_app_settings_key_vault_references(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ApiKVReference"]:
        """Gets the config reference app settings and status of an app.

        Gets the config reference app settings and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ApiKVReference or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ApiKVReference]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ApiKVReferenceCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_app_settings_key_vault_references_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_app_settings_key_vault_references.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApiKVReferenceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_app_settings_key_vault_references.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/appsettings"
    }

    @distributed_trace_async
    async def get_app_setting_key_vault_reference(
        self, resource_group_name: str, name: str, app_setting_key: str, **kwargs: Any
    ) -> _models.ApiKVReference:
        """Gets the config reference and status of an app.

        Gets the config reference and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param app_setting_key: App Setting key name. Required.
        :type app_setting_key: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApiKVReference or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ApiKVReference
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ApiKVReference] = kwargs.pop("cls", None)

        request = build_get_app_setting_key_vault_reference_request(
            resource_group_name=resource_group_name,
            name=name,
            app_setting_key=app_setting_key,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_app_setting_key_vault_reference.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApiKVReference", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_app_setting_key_vault_reference.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/appsettings/{appSettingKey}"
    }

    @distributed_trace
    def get_site_connection_string_key_vault_references(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ApiKVReference"]:
        """Gets the config reference app settings and status of an app.

        Gets the config reference app settings and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ApiKVReference or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ApiKVReference]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ApiKVReferenceCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_site_connection_string_key_vault_references_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_site_connection_string_key_vault_references.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApiKVReferenceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_site_connection_string_key_vault_references.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/connectionstrings"
    }

    @distributed_trace_async
    async def get_site_connection_string_key_vault_reference(
        self, resource_group_name: str, name: str, connection_string_key: str, **kwargs: Any
    ) -> _models.ApiKVReference:
        """Gets the config reference and status of an app.

        Gets the config reference and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_string_key: Required.
        :type connection_string_key: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApiKVReference or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ApiKVReference
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ApiKVReference] = kwargs.pop("cls", None)

        request = build_get_site_connection_string_key_vault_reference_request(
            resource_group_name=resource_group_name,
            name=name,
            connection_string_key=connection_string_key,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_site_connection_string_key_vault_reference.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApiKVReference", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_connection_string_key_vault_reference.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/configreferences/connectionstrings/{connectionStringKey}"
    }

    @overload
    async def update_connection_strings(
        self,
        resource_group_name: str,
        name: str,
        connection_strings: _models.ConnectionStringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_strings: Connection strings of the app or deployment slot. See example.
         Required.
        :type connection_strings: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_connection_strings(
        self,
        resource_group_name: str,
        name: str,
        connection_strings: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_strings: Connection strings of the app or deployment slot. See example.
         Required.
        :type connection_strings: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_connection_strings(
        self,
        resource_group_name: str,
        name: str,
        connection_strings: Union[_models.ConnectionStringDictionary, IO],
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_strings: Connection strings of the app or deployment slot. See example. Is
         either a ConnectionStringDictionary type or a IO type. Required.
        :type connection_strings: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectionStringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_strings, (IO, bytes)):
            _content = connection_strings
        else:
            _json = self._serialize.body(connection_strings, "ConnectionStringDictionary")

        request = build_update_connection_strings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_connection_strings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ConnectionStringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_connection_strings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings"
    }

    @distributed_trace_async
    async def list_connection_strings(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Gets the connection strings of an app.

        Gets the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ConnectionStringDictionary] = kwargs.pop("cls", None)

        request = build_list_connection_strings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_connection_strings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ConnectionStringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_connection_strings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list"
    }

    @distributed_trace_async
    async def get_diagnostic_logs_configuration(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Gets the logging configuration of an app.

        Gets the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteLogsConfig] = kwargs.pop("cls", None)

        request = build_get_diagnostic_logs_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_diagnostic_logs_configuration.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteLogsConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_diagnostic_logs_configuration.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs"
    }

    @overload
    async def update_diagnostic_logs_config(
        self,
        resource_group_name: str,
        name: str,
        site_logs_config: _models.SiteLogsConfig,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Required.
        :type site_logs_config: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_diagnostic_logs_config(
        self,
        resource_group_name: str,
        name: str,
        site_logs_config: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Required.
        :type site_logs_config: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_diagnostic_logs_config(
        self, resource_group_name: str, name: str, site_logs_config: Union[_models.SiteLogsConfig, IO], **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Is either a SiteLogsConfig type or a IO type. Required.
        :type site_logs_config: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteLogsConfig] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_logs_config, (IO, bytes)):
            _content = site_logs_config
        else:
            _json = self._serialize.body(site_logs_config, "SiteLogsConfig")

        request = build_update_diagnostic_logs_config_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_diagnostic_logs_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteLogsConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_diagnostic_logs_config.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs"
    }

    @overload
    async def update_metadata(
        self,
        resource_group_name: str,
        name: str,
        metadata: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Required.
        :type metadata: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_metadata(
        self,
        resource_group_name: str,
        name: str,
        metadata: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Required.
        :type metadata: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_metadata(
        self, resource_group_name: str, name: str, metadata: Union[_models.StringDictionary, IO], **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Is either a
         StringDictionary type or a IO type. Required.
        :type metadata: ~azure.mgmt.web.v2021_01_15.models.StringDictionary or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(metadata, (IO, bytes)):
            _content = metadata
        else:
            _json = self._serialize.body(metadata, "StringDictionary")

        request = build_update_metadata_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_metadata.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_metadata.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata"
    }

    @distributed_trace_async
    async def list_metadata(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.StringDictionary:
        """Gets the metadata of an app.

        Gets the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        request = build_list_metadata_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_metadata.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_metadata.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list"
    }

    async def _list_publishing_credentials_initial(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.User:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.User] = kwargs.pop("cls", None)

        request = build_list_publishing_credentials_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._list_publishing_credentials_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("User", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _list_publishing_credentials_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list"
    }

    @distributed_trace_async
    async def begin_list_publishing_credentials(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.User]:
        """Gets the Git/FTP publishing credentials of an app.

        Gets the Git/FTP publishing credentials of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either User or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.User]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.User] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._list_publishing_credentials_initial(
                resource_group_name=resource_group_name,
                name=name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("User", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_list_publishing_credentials.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list"
    }

    @overload
    async def update_site_push_settings(
        self,
        resource_group_name: str,
        name: str,
        push_settings: _models.PushSettings,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PushSettings:
        """Updates the Push settings associated with web app.

        Updates the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param push_settings: Push settings associated with web app. Required.
        :type push_settings: ~azure.mgmt.web.v2021_01_15.models.PushSettings
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_site_push_settings(
        self,
        resource_group_name: str,
        name: str,
        push_settings: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PushSettings:
        """Updates the Push settings associated with web app.

        Updates the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param push_settings: Push settings associated with web app. Required.
        :type push_settings: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_site_push_settings(
        self, resource_group_name: str, name: str, push_settings: Union[_models.PushSettings, IO], **kwargs: Any
    ) -> _models.PushSettings:
        """Updates the Push settings associated with web app.

        Updates the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param push_settings: Push settings associated with web app. Is either a PushSettings type or a
         IO type. Required.
        :type push_settings: ~azure.mgmt.web.v2021_01_15.models.PushSettings or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PushSettings] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(push_settings, (IO, bytes)):
            _content = push_settings
        else:
            _json = self._serialize.body(push_settings, "PushSettings")

        request = build_update_site_push_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_site_push_settings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PushSettings", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_site_push_settings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings"
    }

    @distributed_trace_async
    async def list_site_push_settings(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.PushSettings:
        """Gets the Push settings associated with web app.

        Gets the Push settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PushSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PushSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PushSettings] = kwargs.pop("cls", None)

        request = build_list_site_push_settings_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_site_push_settings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PushSettings", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_site_push_settings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings/list"
    }

    @distributed_trace_async
    async def list_slot_configuration_names(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SlotConfigNamesResource:
        """Gets the names of app settings and connection strings that stick to the slot (not swapped).

        Gets the names of app settings and connection strings that stick to the slot (not swapped).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SlotConfigNamesResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SlotConfigNamesResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SlotConfigNamesResource] = kwargs.pop("cls", None)

        request = build_list_slot_configuration_names_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_slot_configuration_names.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SlotConfigNamesResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_slot_configuration_names.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames"
    }

    @overload
    async def update_slot_configuration_names(
        self,
        resource_group_name: str,
        name: str,
        slot_config_names: _models.SlotConfigNamesResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SlotConfigNamesResource:
        """Updates the names of application settings and connection string that remain with the slot
        during swap operation.

        Updates the names of application settings and connection string that remain with the slot
        during swap operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_config_names: Names of application settings and connection strings. See example.
         Required.
        :type slot_config_names: ~azure.mgmt.web.v2021_01_15.models.SlotConfigNamesResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SlotConfigNamesResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SlotConfigNamesResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_slot_configuration_names(
        self,
        resource_group_name: str,
        name: str,
        slot_config_names: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SlotConfigNamesResource:
        """Updates the names of application settings and connection string that remain with the slot
        during swap operation.

        Updates the names of application settings and connection string that remain with the slot
        during swap operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_config_names: Names of application settings and connection strings. See example.
         Required.
        :type slot_config_names: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SlotConfigNamesResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SlotConfigNamesResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_slot_configuration_names(
        self,
        resource_group_name: str,
        name: str,
        slot_config_names: Union[_models.SlotConfigNamesResource, IO],
        **kwargs: Any
    ) -> _models.SlotConfigNamesResource:
        """Updates the names of application settings and connection string that remain with the slot
        during swap operation.

        Updates the names of application settings and connection string that remain with the slot
        during swap operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot_config_names: Names of application settings and connection strings. See example. Is
         either a SlotConfigNamesResource type or a IO type. Required.
        :type slot_config_names: ~azure.mgmt.web.v2021_01_15.models.SlotConfigNamesResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SlotConfigNamesResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SlotConfigNamesResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SlotConfigNamesResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(slot_config_names, (IO, bytes)):
            _content = slot_config_names
        else:
            _json = self._serialize.body(slot_config_names, "SlotConfigNamesResource")

        request = build_update_slot_configuration_names_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_slot_configuration_names.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SlotConfigNamesResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_slot_configuration_names.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames"
    }

    @distributed_trace_async
    async def get_configuration(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.SiteConfigResource:
        """Gets the configuration of an app, such as platform version and bitness, default documents,
        virtual applications, Always On, etc.

        Gets the configuration of an app, such as platform version and bitness, default documents,
        virtual applications, Always On, etc.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        request = build_get_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_configuration.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_configuration.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web"
    }

    @overload
    async def create_or_update_configuration(
        self,
        resource_group_name: str,
        name: str,
        site_config: _models.SiteConfigResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_configuration(
        self,
        resource_group_name: str,
        name: str,
        site_config: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_configuration(
        self, resource_group_name: str, name: str, site_config: Union[_models.SiteConfigResource, IO], **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Is either a
         SiteConfigResource type or a IO type. Required.
        :type site_config: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_config, (IO, bytes)):
            _content = site_config
        else:
            _json = self._serialize.body(site_config, "SiteConfigResource")

        request = build_create_or_update_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_configuration.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_configuration.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web"
    }

    @overload
    async def update_configuration(
        self,
        resource_group_name: str,
        name: str,
        site_config: _models.SiteConfigResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_configuration(
        self,
        resource_group_name: str,
        name: str,
        site_config: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Required.
        :type site_config: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_configuration(
        self, resource_group_name: str, name: str, site_config: Union[_models.SiteConfigResource, IO], **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Updates the configuration of an app.

        Updates the configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param site_config: JSON representation of a SiteConfig object. See example. Is either a
         SiteConfigResource type or a IO type. Required.
        :type site_config: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_config, (IO, bytes)):
            _content = site_config
        else:
            _json = self._serialize.body(site_config, "SiteConfigResource")

        request = build_update_configuration_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_configuration.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_configuration.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web"
    }

    @distributed_trace
    def list_configuration_snapshot_info(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.SiteConfigurationSnapshotInfo"]:
        """Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
        timestamp and the ID of the snapshot.

        Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
        timestamp and the ID of the snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SiteConfigurationSnapshotInfo or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.SiteConfigurationSnapshotInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteConfigurationSnapshotInfoCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_configuration_snapshot_info_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_configuration_snapshot_info.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SiteConfigurationSnapshotInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_configuration_snapshot_info.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots"
    }

    @distributed_trace_async
    async def get_configuration_snapshot(
        self, resource_group_name: str, name: str, snapshot_id: str, **kwargs: Any
    ) -> _models.SiteConfigResource:
        """Gets a snapshot of the configuration of an app at a previous point in time.

        Gets a snapshot of the configuration of an app at a previous point in time.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param snapshot_id: The ID of the snapshot to read. Required.
        :type snapshot_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteConfigResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteConfigResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteConfigResource] = kwargs.pop("cls", None)

        request = build_get_configuration_snapshot_request(
            resource_group_name=resource_group_name,
            name=name,
            snapshot_id=snapshot_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_configuration_snapshot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteConfigResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_configuration_snapshot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}"
    }

    @distributed_trace_async
    async def recover_site_configuration_snapshot(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, snapshot_id: str, **kwargs: Any
    ) -> None:
        """Reverts the configuration of an app to a previous snapshot.

        Reverts the configuration of an app to a previous snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param snapshot_id: The ID of the snapshot to read. Required.
        :type snapshot_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_recover_site_configuration_snapshot_request(
            resource_group_name=resource_group_name,
            name=name,
            snapshot_id=snapshot_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.recover_site_configuration_snapshot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    recover_site_configuration_snapshot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web/snapshots/{snapshotId}/recover"
    }

    @distributed_trace_async
    async def get_web_site_container_logs(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> Optional[AsyncIterator[bytes]]:
        """Gets the last lines of docker logs for the given site.

        Gets the last lines of docker logs for the given site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Async iterator of the response bytes or None or the result of cls(response)
        :rtype: AsyncIterator[bytes] or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[Optional[AsyncIterator[bytes]]] = kwargs.pop("cls", None)

        request = build_get_web_site_container_logs_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_web_site_container_logs.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_web_site_container_logs.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs"
    }

    @distributed_trace_async
    async def get_container_logs_zip(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> Optional[AsyncIterator[bytes]]:
        """Gets the ZIP archived docker log files for the given site.

        Gets the ZIP archived docker log files for the given site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Async iterator of the response bytes or None or the result of cls(response)
        :rtype: AsyncIterator[bytes] or None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[Optional[AsyncIterator[bytes]]] = kwargs.pop("cls", None)

        request = build_get_container_logs_zip_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_container_logs_zip.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_container_logs_zip.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/containerlogs/zip/download"
    }

    @distributed_trace
    def list_continuous_web_jobs(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ContinuousWebJob"]:
        """List continuous web jobs for an app, or a deployment slot.

        List continuous web jobs for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ContinuousWebJob or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ContinuousWebJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ContinuousWebJobCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_continuous_web_jobs_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_continuous_web_jobs.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ContinuousWebJobCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_continuous_web_jobs.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs"
    }

    @distributed_trace_async
    async def get_continuous_web_job(
        self, resource_group_name: str, name: str, web_job_name: str, **kwargs: Any
    ) -> _models.ContinuousWebJob:
        """Gets a continuous web job by its ID for an app, or a deployment slot.

        Gets a continuous web job by its ID for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ContinuousWebJob or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ContinuousWebJob
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ContinuousWebJob] = kwargs.pop("cls", None)

        request = build_get_continuous_web_job_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_continuous_web_job.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ContinuousWebJob", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_continuous_web_job.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}"
    }

    @distributed_trace_async
    async def delete_continuous_web_job(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, web_job_name: str, **kwargs: Any
    ) -> None:
        """Delete a continuous web job by its ID for an app, or a deployment slot.

        Delete a continuous web job by its ID for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_continuous_web_job_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_continuous_web_job.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_continuous_web_job.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}"
    }

    @distributed_trace_async
    async def start_continuous_web_job(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, web_job_name: str, **kwargs: Any
    ) -> None:
        """Start a continuous web job for an app, or a deployment slot.

        Start a continuous web job for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_start_continuous_web_job_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.start_continuous_web_job.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    start_continuous_web_job.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}/start"
    }

    @distributed_trace_async
    async def stop_continuous_web_job(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, web_job_name: str, **kwargs: Any
    ) -> None:
        """Stop a continuous web job for an app, or a deployment slot.

        Stop a continuous web job for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param web_job_name: Name of Web Job. Required.
        :type web_job_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_stop_continuous_web_job_request(
            resource_group_name=resource_group_name,
            name=name,
            web_job_name=web_job_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.stop_continuous_web_job.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    stop_continuous_web_job.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/continuouswebjobs/{webJobName}/stop"
    }

    @distributed_trace
    def list_deployments(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.Deployment"]:
        """List deployments for an app, or a deployment slot.

        List deployments for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Deployment or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.Deployment]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.DeploymentCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_deployments_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_deployments.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DeploymentCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_deployments.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments"
    }

    @distributed_trace_async
    async def get_deployment(self, resource_group_name: str, name: str, id: str, **kwargs: Any) -> _models.Deployment:
        """Get a deployment by its ID for an app, or a deployment slot.

        Get a deployment by its ID for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: Deployment ID. Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Deployment or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Deployment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.Deployment] = kwargs.pop("cls", None)

        request = build_get_deployment_request(
            resource_group_name=resource_group_name,
            name=name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_deployment.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Deployment", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_deployment.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}"
    }

    @overload
    async def create_deployment(
        self,
        resource_group_name: str,
        name: str,
        id: str,
        deployment: _models.Deployment,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Deployment:
        """Create a deployment for an app, or a deployment slot.

        Create a deployment for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: ID of an existing deployment. Required.
        :type id: str
        :param deployment: Deployment details. Required.
        :type deployment: ~azure.mgmt.web.v2021_01_15.models.Deployment
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Deployment or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Deployment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_deployment(
        self,
        resource_group_name: str,
        name: str,
        id: str,
        deployment: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Deployment:
        """Create a deployment for an app, or a deployment slot.

        Create a deployment for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: ID of an existing deployment. Required.
        :type id: str
        :param deployment: Deployment details. Required.
        :type deployment: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Deployment or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Deployment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_deployment(
        self, resource_group_name: str, name: str, id: str, deployment: Union[_models.Deployment, IO], **kwargs: Any
    ) -> _models.Deployment:
        """Create a deployment for an app, or a deployment slot.

        Create a deployment for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: ID of an existing deployment. Required.
        :type id: str
        :param deployment: Deployment details. Is either a Deployment type or a IO type. Required.
        :type deployment: ~azure.mgmt.web.v2021_01_15.models.Deployment or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Deployment or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Deployment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Deployment] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(deployment, (IO, bytes)):
            _content = deployment
        else:
            _json = self._serialize.body(deployment, "Deployment")

        request = build_create_deployment_request(
            resource_group_name=resource_group_name,
            name=name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_deployment.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Deployment", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_deployment.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}"
    }

    @distributed_trace_async
    async def delete_deployment(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, id: str, **kwargs: Any
    ) -> None:
        """Delete a deployment by its ID for an app, or a deployment slot.

        Delete a deployment by its ID for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: Deployment ID. Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_deployment_request(
            resource_group_name=resource_group_name,
            name=name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_deployment.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_deployment.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}"
    }

    @distributed_trace_async
    async def list_deployment_log(
        self, resource_group_name: str, name: str, id: str, **kwargs: Any
    ) -> _models.Deployment:
        """List deployment log for specific deployment for an app, or a deployment slot.

        List deployment log for specific deployment for an app, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param id: The ID of a specific deployment. This is the value of the name property in the JSON
         response from "GET /api/sites/{siteName}/deployments". Required.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Deployment or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Deployment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.Deployment] = kwargs.pop("cls", None)

        request = build_list_deployment_log_request(
            resource_group_name=resource_group_name,
            name=name,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_deployment_log.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Deployment", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_deployment_log.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}/log"
    }

    @overload
    async def discover_backup(
        self,
        resource_group_name: str,
        name: str,
        request: _models.RestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RestoreRequest:
        """Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
        get information about the databases stored in a backup.

        Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
        get information about the databases stored in a backup.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: A RestoreRequest object that includes Azure storage URL and blog name for
         discovery of backup. Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RestoreRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def discover_backup(
        self, resource_group_name: str, name: str, request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.RestoreRequest:
        """Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
        get information about the databases stored in a backup.

        Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
        get information about the databases stored in a backup.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: A RestoreRequest object that includes Azure storage URL and blog name for
         discovery of backup. Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RestoreRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def discover_backup(
        self, resource_group_name: str, name: str, request: Union[_models.RestoreRequest, IO], **kwargs: Any
    ) -> _models.RestoreRequest:
        """Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
        get information about the databases stored in a backup.

        Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
        get information about the databases stored in a backup.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: A RestoreRequest object that includes Azure storage URL and blog name for
         discovery of backup. Is either a RestoreRequest type or a IO type. Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RestoreRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RestoreRequest] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "RestoreRequest")

        request = build_discover_backup_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.discover_backup.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RestoreRequest", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    discover_backup.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/discoverbackup"
    }

    @distributed_trace
    def list_domain_ownership_identifiers(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.Identifier"]:
        """Lists ownership identifiers for domain associated with web app.

        Lists ownership identifiers for domain associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Identifier or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.Identifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.IdentifierCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_domain_ownership_identifiers_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_domain_ownership_identifiers.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("IdentifierCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_domain_ownership_identifiers.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers"
    }

    @distributed_trace_async
    async def get_domain_ownership_identifier(
        self, resource_group_name: str, name: str, domain_ownership_identifier_name: str, **kwargs: Any
    ) -> _models.Identifier:
        """Get domain ownership identifier for web app.

        Get domain ownership identifier for web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.Identifier] = kwargs.pop("cls", None)

        request = build_get_domain_ownership_identifier_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_ownership_identifier_name=domain_ownership_identifier_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_domain_ownership_identifier.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Identifier", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_domain_ownership_identifier.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}"
    }

    @overload
    async def create_or_update_domain_ownership_identifier(
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: _models.Identifier,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2021_01_15.models.Identifier
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_domain_ownership_identifier(
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_domain_ownership_identifier(
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: Union[_models.Identifier, IO],
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Is either a Identifier type or a IO type. Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2021_01_15.models.Identifier or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Identifier] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(domain_ownership_identifier, (IO, bytes)):
            _content = domain_ownership_identifier
        else:
            _json = self._serialize.body(domain_ownership_identifier, "Identifier")

        request = build_create_or_update_domain_ownership_identifier_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_ownership_identifier_name=domain_ownership_identifier_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_domain_ownership_identifier.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Identifier", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_domain_ownership_identifier.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}"
    }

    @distributed_trace_async
    async def delete_domain_ownership_identifier(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, domain_ownership_identifier_name: str, **kwargs: Any
    ) -> None:
        """Deletes a domain ownership identifier for a web app.

        Deletes a domain ownership identifier for a web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_domain_ownership_identifier_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_ownership_identifier_name=domain_ownership_identifier_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_domain_ownership_identifier.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_domain_ownership_identifier.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}"
    }

    @overload
    async def update_domain_ownership_identifier(
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: _models.Identifier,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2021_01_15.models.Identifier
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_domain_ownership_identifier(
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_domain_ownership_identifier(
        self,
        resource_group_name: str,
        name: str,
        domain_ownership_identifier_name: str,
        domain_ownership_identifier: Union[_models.Identifier, IO],
        **kwargs: Any
    ) -> _models.Identifier:
        """Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        Creates a domain ownership identifier for web app, or updates an existing ownership identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param domain_ownership_identifier_name: Name of domain ownership identifier. Required.
        :type domain_ownership_identifier_name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Is either a Identifier type or a IO type. Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2021_01_15.models.Identifier or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Identifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Identifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Identifier] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(domain_ownership_identifier, (IO, bytes)):
            _content = domain_ownership_identifier
        else:
            _json = self._serialize.body(domain_ownership_identifier, "Identifier")

        request = build_update_domain_ownership_identifier_request(
            resource_group_name=resource_group_name,
            name=name,
            domain_ownership_identifier_name=domain_ownership_identifier_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_domain_ownership_identifier.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Identifier", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_domain_ownership_identifier.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/domainOwnershipIdentifiers/{domainOwnershipIdentifierName}"
    }

    @distributed_trace_async
    async def get_ms_deploy_status(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.MSDeployStatus:
        """Get the status of the last MSDeploy operation.

        Get the status of the last MSDeploy operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MSDeployStatus or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.MSDeployStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.MSDeployStatus] = kwargs.pop("cls", None)

        request = build_get_ms_deploy_status_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_ms_deploy_status.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MSDeployStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_ms_deploy_status.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy"
    }

    async def _create_ms_deploy_operation_initial(
        self, resource_group_name: str, name: str, ms_deploy: Union[_models.MSDeploy, IO], **kwargs: Any
    ) -> _models.MSDeployStatus:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            304: ResourceNotModifiedError,
            409: lambda response: ResourceExistsError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.MSDeployStatus] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(ms_deploy, (IO, bytes)):
            _content = ms_deploy
        else:
            _json = self._serialize.body(ms_deploy, "MSDeploy")

        request = build_create_ms_deploy_operation_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_ms_deploy_operation_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MSDeployStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_ms_deploy_operation_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy"
    }

    @overload
    async def begin_create_ms_deploy_operation(
        self,
        resource_group_name: str,
        name: str,
        ms_deploy: _models.MSDeploy,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param ms_deploy: Details of MSDeploy operation. Required.
        :type ms_deploy: ~azure.mgmt.web.v2021_01_15.models.MSDeploy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_ms_deploy_operation(
        self,
        resource_group_name: str,
        name: str,
        ms_deploy: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param ms_deploy: Details of MSDeploy operation. Required.
        :type ms_deploy: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_ms_deploy_operation(
        self, resource_group_name: str, name: str, ms_deploy: Union[_models.MSDeploy, IO], **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param ms_deploy: Details of MSDeploy operation. Is either a MSDeploy type or a IO type.
         Required.
        :type ms_deploy: ~azure.mgmt.web.v2021_01_15.models.MSDeploy or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.MSDeployStatus] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_ms_deploy_operation_initial(
                resource_group_name=resource_group_name,
                name=name,
                ms_deploy=ms_deploy,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("MSDeployStatus", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create_ms_deploy_operation.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy"
    }

    @distributed_trace_async
    async def get_ms_deploy_log(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.MSDeployLog:
        """Get the MSDeploy Log for the last MSDeploy operation.

        Get the MSDeploy Log for the last MSDeploy operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MSDeployLog or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.MSDeployLog
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.MSDeployLog] = kwargs.pop("cls", None)

        request = build_get_ms_deploy_log_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_ms_deploy_log.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MSDeployLog", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_ms_deploy_log.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/extensions/MSDeploy/log"
    }

    @distributed_trace
    def list_functions(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.FunctionEnvelope"]:
        """List the functions for a web site, or a deployment slot.

        List the functions for a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either FunctionEnvelope or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.FunctionEnvelope]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.FunctionEnvelopeCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_functions_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_functions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("FunctionEnvelopeCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_functions.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions"
    }

    @distributed_trace_async
    async def get_functions_admin_token(self, resource_group_name: str, name: str, **kwargs: Any) -> str:
        """Fetch a short lived token that can be exchanged for a master key.

        Fetch a short lived token that can be exchanged for a master key.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: str or the result of cls(response)
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[str] = kwargs.pop("cls", None)

        request = build_get_functions_admin_token_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_functions_admin_token.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("str", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_functions_admin_token.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/admin/token"
    }

    @distributed_trace_async
    async def get_function(
        self, resource_group_name: str, name: str, function_name: str, **kwargs: Any
    ) -> _models.FunctionEnvelope:
        """Get function information by its ID for web site, or a deployment slot.

        Get function information by its ID for web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: FunctionEnvelope or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.FunctionEnvelope
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.FunctionEnvelope] = kwargs.pop("cls", None)

        request = build_get_function_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_function.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("FunctionEnvelope", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_function.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}"
    }

    async def _create_function_initial(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        function_envelope: Union[_models.FunctionEnvelope, IO],
        **kwargs: Any
    ) -> _models.FunctionEnvelope:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FunctionEnvelope] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(function_envelope, (IO, bytes)):
            _content = function_envelope
        else:
            _json = self._serialize.body(function_envelope, "FunctionEnvelope")

        request = build_create_function_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_function_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("FunctionEnvelope", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_function_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}"
    }

    @overload
    async def begin_create_function(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        function_envelope: _models.FunctionEnvelope,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FunctionEnvelope]:
        """Create function for web site, or a deployment slot.

        Create function for web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :param function_envelope: Function details. Required.
        :type function_envelope: ~azure.mgmt.web.v2021_01_15.models.FunctionEnvelope
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either FunctionEnvelope or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.FunctionEnvelope]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_function(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        function_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FunctionEnvelope]:
        """Create function for web site, or a deployment slot.

        Create function for web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :param function_envelope: Function details. Required.
        :type function_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either FunctionEnvelope or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.FunctionEnvelope]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_function(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        function_envelope: Union[_models.FunctionEnvelope, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FunctionEnvelope]:
        """Create function for web site, or a deployment slot.

        Create function for web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :param function_envelope: Function details. Is either a FunctionEnvelope type or a IO type.
         Required.
        :type function_envelope: ~azure.mgmt.web.v2021_01_15.models.FunctionEnvelope or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either FunctionEnvelope or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.FunctionEnvelope]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FunctionEnvelope] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_function_initial(
                resource_group_name=resource_group_name,
                name=name,
                function_name=function_name,
                function_envelope=function_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("FunctionEnvelope", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create_function.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}"
    }

    @distributed_trace_async
    async def delete_function(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, function_name: str, **kwargs: Any
    ) -> None:
        """Delete a function for web site, or a deployment slot.

        Delete a function for web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_function_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_function.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_function.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}"
    }

    @overload
    async def create_or_update_function_secret(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        key_name: str,
        key: _models.KeyInfo,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a function secret.

        Add or update a function secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: The name of the function. Required.
        :type function_name: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Required.
        :type key: ~azure.mgmt.web.v2021_01_15.models.KeyInfo
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_function_secret(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        key_name: str,
        key: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a function secret.

        Add or update a function secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: The name of the function. Required.
        :type function_name: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Required.
        :type key: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_function_secret(
        self,
        resource_group_name: str,
        name: str,
        function_name: str,
        key_name: str,
        key: Union[_models.KeyInfo, IO],
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a function secret.

        Add or update a function secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: The name of the function. Required.
        :type function_name: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Is either a KeyInfo type or a IO type. Required.
        :type key: ~azure.mgmt.web.v2021_01_15.models.KeyInfo or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyInfo] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(key, (IO, bytes)):
            _content = key
        else:
            _json = self._serialize.body(key, "KeyInfo")

        request = build_create_or_update_function_secret_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            key_name=key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_function_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("KeyInfo", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("KeyInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create_or_update_function_secret.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/keys/{keyName}"
    }

    @distributed_trace_async
    async def delete_function_secret(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, function_name: str, key_name: str, **kwargs: Any
    ) -> None:
        """Delete a function secret.

        Delete a function secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: The name of the function. Required.
        :type function_name: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_function_secret_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            key_name=key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_function_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_function_secret.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/keys/{keyName}"
    }

    @distributed_trace_async
    async def list_function_keys(
        self, resource_group_name: str, name: str, function_name: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Get function keys for a function in a web site, or a deployment slot.

        Get function keys for a function in a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        request = build_list_function_keys_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_function_keys.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_function_keys.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listkeys"
    }

    @distributed_trace_async
    async def list_function_secrets(
        self, resource_group_name: str, name: str, function_name: str, **kwargs: Any
    ) -> _models.FunctionSecrets:
        """Get function secrets for a function in a web site, or a deployment slot.

        Get function secrets for a function in a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param function_name: Function name. Required.
        :type function_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: FunctionSecrets or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.FunctionSecrets
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.FunctionSecrets] = kwargs.pop("cls", None)

        request = build_list_function_secrets_request(
            resource_group_name=resource_group_name,
            name=name,
            function_name=function_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_function_secrets.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("FunctionSecrets", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_function_secrets.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/{functionName}/listsecrets"
    }

    @distributed_trace_async
    async def list_host_keys(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.HostKeys:
        """Get host secrets for a function app.

        Get host secrets for a function app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HostKeys or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HostKeys
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.HostKeys] = kwargs.pop("cls", None)

        request = build_list_host_keys_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_host_keys.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HostKeys", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_host_keys.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/listkeys"
    }

    @distributed_trace_async
    async def list_sync_status(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> None:
        """This is to allow calling via powershell and ARM template.

        This is to allow calling via powershell and ARM template.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_list_sync_status_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_sync_status.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    list_sync_status.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/listsyncstatus"
    }

    @distributed_trace_async
    async def sync_functions(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> None:
        """Syncs function trigger metadata to the management database.

        Syncs function trigger metadata to the management database.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_sync_functions_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.sync_functions.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    sync_functions.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/sync"
    }

    @overload
    async def create_or_update_host_secret(
        self,
        resource_group_name: str,
        name: str,
        key_type: str,
        key_name: str,
        key: _models.KeyInfo,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a host level secret.

        Add or update a host level secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param key_type: The type of host key. Required.
        :type key_type: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Required.
        :type key: ~azure.mgmt.web.v2021_01_15.models.KeyInfo
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_host_secret(
        self,
        resource_group_name: str,
        name: str,
        key_type: str,
        key_name: str,
        key: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a host level secret.

        Add or update a host level secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param key_type: The type of host key. Required.
        :type key_type: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Required.
        :type key: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_host_secret(
        self,
        resource_group_name: str,
        name: str,
        key_type: str,
        key_name: str,
        key: Union[_models.KeyInfo, IO],
        **kwargs: Any
    ) -> _models.KeyInfo:
        """Add or update a host level secret.

        Add or update a host level secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param key_type: The type of host key. Required.
        :type key_type: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :param key: The key to create or update. Is either a KeyInfo type or a IO type. Required.
        :type key: ~azure.mgmt.web.v2021_01_15.models.KeyInfo or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.KeyInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.KeyInfo] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(key, (IO, bytes)):
            _content = key
        else:
            _json = self._serialize.body(key, "KeyInfo")

        request = build_create_or_update_host_secret_request(
            resource_group_name=resource_group_name,
            name=name,
            key_type=key_type,
            key_name=key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_host_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("KeyInfo", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("KeyInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    create_or_update_host_secret.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/{keyType}/{keyName}"
    }

    @distributed_trace_async
    async def delete_host_secret(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, key_type: str, key_name: str, **kwargs: Any
    ) -> None:
        """Delete a host level secret.

        Delete a host level secret.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param key_type: The type of host key. Required.
        :type key_type: str
        :param key_name: The name of the key. Required.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_host_secret_request(
            resource_group_name=resource_group_name,
            name=name,
            key_type=key_type,
            key_name=key_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_host_secret.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_host_secret.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/host/default/{keyType}/{keyName}"
    }

    @distributed_trace
    def list_host_name_bindings(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.HostNameBinding"]:
        """Get hostname bindings for an app or a deployment slot.

        Get hostname bindings for an app or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either HostNameBinding or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.HostNameBinding]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.HostNameBindingCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_host_name_bindings_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_host_name_bindings.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("HostNameBindingCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_host_name_bindings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings"
    }

    @distributed_trace_async
    async def get_host_name_binding(
        self, resource_group_name: str, name: str, host_name: str, **kwargs: Any
    ) -> _models.HostNameBinding:
        """Get the named hostname binding for an app (or deployment slot, if specified).

        Get the named hostname binding for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param host_name: Hostname in the hostname binding. Required.
        :type host_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HostNameBinding or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HostNameBinding
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.HostNameBinding] = kwargs.pop("cls", None)

        request = build_get_host_name_binding_request(
            resource_group_name=resource_group_name,
            name=name,
            host_name=host_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_host_name_binding.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HostNameBinding", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_host_name_binding.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}"
    }

    @overload
    async def create_or_update_host_name_binding(
        self,
        resource_group_name: str,
        name: str,
        host_name: str,
        host_name_binding: _models.HostNameBinding,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HostNameBinding:
        """Creates a hostname binding for an app.

        Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param host_name: Hostname in the hostname binding. Required.
        :type host_name: str
        :param host_name_binding: Binding details. This is the JSON representation of a HostNameBinding
         object. Required.
        :type host_name_binding: ~azure.mgmt.web.v2021_01_15.models.HostNameBinding
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HostNameBinding or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HostNameBinding
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_host_name_binding(
        self,
        resource_group_name: str,
        name: str,
        host_name: str,
        host_name_binding: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HostNameBinding:
        """Creates a hostname binding for an app.

        Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param host_name: Hostname in the hostname binding. Required.
        :type host_name: str
        :param host_name_binding: Binding details. This is the JSON representation of a HostNameBinding
         object. Required.
        :type host_name_binding: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HostNameBinding or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HostNameBinding
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_host_name_binding(
        self,
        resource_group_name: str,
        name: str,
        host_name: str,
        host_name_binding: Union[_models.HostNameBinding, IO],
        **kwargs: Any
    ) -> _models.HostNameBinding:
        """Creates a hostname binding for an app.

        Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param host_name: Hostname in the hostname binding. Required.
        :type host_name: str
        :param host_name_binding: Binding details. This is the JSON representation of a HostNameBinding
         object. Is either a HostNameBinding type or a IO type. Required.
        :type host_name_binding: ~azure.mgmt.web.v2021_01_15.models.HostNameBinding or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HostNameBinding or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HostNameBinding
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.HostNameBinding] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(host_name_binding, (IO, bytes)):
            _content = host_name_binding
        else:
            _json = self._serialize.body(host_name_binding, "HostNameBinding")

        request = build_create_or_update_host_name_binding_request(
            resource_group_name=resource_group_name,
            name=name,
            host_name=host_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_host_name_binding.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HostNameBinding", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_host_name_binding.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}"
    }

    @distributed_trace_async
    async def delete_host_name_binding(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, host_name: str, **kwargs: Any
    ) -> None:
        """Deletes a hostname binding for an app.

        Deletes a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param host_name: Hostname in the hostname binding. Required.
        :type host_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_host_name_binding_request(
            resource_group_name=resource_group_name,
            name=name,
            host_name=host_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_host_name_binding.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_host_name_binding.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}"
    }

    @distributed_trace_async
    async def get_hybrid_connection(
        self, resource_group_name: str, name: str, namespace_name: str, relay_name: str, **kwargs: Any
    ) -> _models.HybridConnection:
        """Retrieves a specific Service Bus Hybrid Connection used by this Web App.

        Retrieves a specific Service Bus Hybrid Connection used by this Web App.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.HybridConnection] = kwargs.pop("cls", None)

        request = build_get_hybrid_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_hybrid_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_hybrid_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
    }

    @overload
    async def create_or_update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: _models.HybridConnection,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.HybridConnection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Required.
        :type connection_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: Union[_models.HybridConnection, IO],
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Is either a HybridConnection
         type or a IO type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.HybridConnection or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.HybridConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IO, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "HybridConnection")

        request = build_create_or_update_hybrid_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_hybrid_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_hybrid_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
    }

    @distributed_trace_async
    async def delete_hybrid_connection(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, namespace_name: str, relay_name: str, **kwargs: Any
    ) -> None:
        """Removes a Hybrid Connection from this site.

        Removes a Hybrid Connection from this site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_hybrid_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_hybrid_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_hybrid_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
    }

    @overload
    async def update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: _models.HybridConnection,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.HybridConnection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Required.
        :type connection_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_hybrid_connection(
        self,
        resource_group_name: str,
        name: str,
        namespace_name: str,
        relay_name: str,
        connection_envelope: Union[_models.HybridConnection, IO],
        **kwargs: Any
    ) -> _models.HybridConnection:
        """Creates a new Hybrid Connection using a Service Bus relay.

        Creates a new Hybrid Connection using a Service Bus relay.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param namespace_name: The namespace for this hybrid connection. Required.
        :type namespace_name: str
        :param relay_name: The relay name for this hybrid connection. Required.
        :type relay_name: str
        :param connection_envelope: The details of the hybrid connection. Is either a HybridConnection
         type or a IO type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.HybridConnection or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.HybridConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IO, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "HybridConnection")

        request = build_update_hybrid_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            namespace_name=namespace_name,
            relay_name=relay_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_hybrid_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_hybrid_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
    }

    @distributed_trace_async
    async def list_hybrid_connections(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.HybridConnection:
        """Retrieves all Service Bus Hybrid Connections used by this Web App.

        Retrieves all Service Bus Hybrid Connections used by this Web App.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HybridConnection or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.HybridConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.HybridConnection] = kwargs.pop("cls", None)

        request = build_list_hybrid_connections_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_hybrid_connections.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("HybridConnection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_hybrid_connections.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionRelays"
    }

    @distributed_trace_async
    async def list_relay_service_connections(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Gets hybrid connections configured for an app (or deployment slot, if specified).

        Gets hybrid connections configured for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.RelayServiceConnectionEntity] = kwargs.pop("cls", None)

        request = build_list_relay_service_connections_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_relay_service_connections.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RelayServiceConnectionEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_relay_service_connections.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection"
    }

    @distributed_trace_async
    async def get_relay_service_connection(
        self, resource_group_name: str, name: str, entity_name: str, **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Gets a hybrid connection configuration by its name.

        Gets a hybrid connection configuration by its name.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection. Required.
        :type entity_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.RelayServiceConnectionEntity] = kwargs.pop("cls", None)

        request = build_get_relay_service_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            entity_name=entity_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_relay_service_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RelayServiceConnectionEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_relay_service_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}"
    }

    @overload
    async def create_or_update_relay_service_connection(
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: _models.RelayServiceConnectionEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_relay_service_connection(
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Required.
        :type connection_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_relay_service_connection(
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: Union[_models.RelayServiceConnectionEntity, IO],
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Is either a
         RelayServiceConnectionEntity type or a IO type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity or
         IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RelayServiceConnectionEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IO, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "RelayServiceConnectionEntity")

        request = build_create_or_update_relay_service_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            entity_name=entity_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_relay_service_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RelayServiceConnectionEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_relay_service_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}"
    }

    @distributed_trace_async
    async def delete_relay_service_connection(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, entity_name: str, **kwargs: Any
    ) -> None:
        """Deletes a relay service connection by its name.

        Deletes a relay service connection by its name.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_relay_service_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            entity_name=entity_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_relay_service_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_relay_service_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}"
    }

    @overload
    async def update_relay_service_connection(
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: _models.RelayServiceConnectionEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_relay_service_connection(
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Required.
        :type connection_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_relay_service_connection(
        self,
        resource_group_name: str,
        name: str,
        entity_name: str,
        connection_envelope: Union[_models.RelayServiceConnectionEntity, IO],
        **kwargs: Any
    ) -> _models.RelayServiceConnectionEntity:
        """Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param entity_name: Name of the hybrid connection configuration. Required.
        :type entity_name: str
        :param connection_envelope: Details of the hybrid connection configuration. Is either a
         RelayServiceConnectionEntity type or a IO type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity or
         IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RelayServiceConnectionEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RelayServiceConnectionEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RelayServiceConnectionEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IO, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "RelayServiceConnectionEntity")

        request = build_update_relay_service_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            entity_name=entity_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_relay_service_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RelayServiceConnectionEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_relay_service_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}"
    }

    @distributed_trace
    def list_instance_identifiers(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.WebSiteInstanceStatus"]:
        """Gets all scale-out instances of an app.

        Gets all scale-out instances of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either WebSiteInstanceStatus or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.WebSiteInstanceStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.WebAppInstanceStatusCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_instance_identifiers_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_instance_identifiers.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("WebAppInstanceStatusCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_instance_identifiers.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances"
    }

    @distributed_trace_async
    async def get_instance_info(
        self, resource_group_name: str, name: str, instance_id: str, **kwargs: Any
    ) -> _models.WebSiteInstanceStatus:
        """Gets all scale-out instances of an app.

        Gets all scale-out instances of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param instance_id: Required.
        :type instance_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: WebSiteInstanceStatus or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.WebSiteInstanceStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.WebSiteInstanceStatus] = kwargs.pop("cls", None)

        request = build_get_instance_info_request(
            resource_group_name=resource_group_name,
            name=name,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_instance_info.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("WebSiteInstanceStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_instance_info.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}"
    }

    @distributed_trace_async
    async def get_instance_ms_deploy_status(
        self, resource_group_name: str, name: str, instance_id: str, **kwargs: Any
    ) -> _models.MSDeployStatus:
        """Get the status of the last MSDeploy operation.

        Get the status of the last MSDeploy operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param instance_id: ID of web app instance. Required.
        :type instance_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MSDeployStatus or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.MSDeployStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.MSDeployStatus] = kwargs.pop("cls", None)

        request = build_get_instance_ms_deploy_status_request(
            resource_group_name=resource_group_name,
            name=name,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_instance_ms_deploy_status.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MSDeployStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_instance_ms_deploy_status.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy"
    }

    async def _create_instance_ms_deploy_operation_initial(
        self,
        resource_group_name: str,
        name: str,
        instance_id: str,
        ms_deploy: Union[_models.MSDeploy, IO],
        **kwargs: Any
    ) -> _models.MSDeployStatus:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            304: ResourceNotModifiedError,
            409: lambda response: ResourceExistsError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.MSDeployStatus] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(ms_deploy, (IO, bytes)):
            _content = ms_deploy
        else:
            _json = self._serialize.body(ms_deploy, "MSDeploy")

        request = build_create_instance_ms_deploy_operation_request(
            resource_group_name=resource_group_name,
            name=name,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_instance_ms_deploy_operation_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MSDeployStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_instance_ms_deploy_operation_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy"
    }

    @overload
    async def begin_create_instance_ms_deploy_operation(
        self,
        resource_group_name: str,
        name: str,
        instance_id: str,
        ms_deploy: _models.MSDeploy,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param instance_id: ID of web app instance. Required.
        :type instance_id: str
        :param ms_deploy: Details of MSDeploy operation. Required.
        :type ms_deploy: ~azure.mgmt.web.v2021_01_15.models.MSDeploy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_instance_ms_deploy_operation(
        self,
        resource_group_name: str,
        name: str,
        instance_id: str,
        ms_deploy: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param instance_id: ID of web app instance. Required.
        :type instance_id: str
        :param ms_deploy: Details of MSDeploy operation. Required.
        :type ms_deploy: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_instance_ms_deploy_operation(
        self,
        resource_group_name: str,
        name: str,
        instance_id: str,
        ms_deploy: Union[_models.MSDeploy, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.MSDeployStatus]:
        """Invoke the MSDeploy web app extension.

        Invoke the MSDeploy web app extension.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param instance_id: ID of web app instance. Required.
        :type instance_id: str
        :param ms_deploy: Details of MSDeploy operation. Is either a MSDeploy type or a IO type.
         Required.
        :type ms_deploy: ~azure.mgmt.web.v2021_01_15.models.MSDeploy or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either MSDeployStatus or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.MSDeployStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.MSDeployStatus] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_instance_ms_deploy_operation_initial(
                resource_group_name=resource_group_name,
                name=name,
                instance_id=instance_id,
                ms_deploy=ms_deploy,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("MSDeployStatus", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create_instance_ms_deploy_operation.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy"
    }

    @distributed_trace_async
    async def get_instance_ms_deploy_log(
        self, resource_group_name: str, name: str, instance_id: str, **kwargs: Any
    ) -> _models.MSDeployLog:
        """Get the MSDeploy Log for the last MSDeploy operation.

        Get the MSDeploy Log for the last MSDeploy operation.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param instance_id: ID of web app instance. Required.
        :type instance_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MSDeployLog or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.MSDeployLog
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.MSDeployLog] = kwargs.pop("cls", None)

        request = build_get_instance_ms_deploy_log_request(
            resource_group_name=resource_group_name,
            name=name,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_instance_ms_deploy_log.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MSDeployLog", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_instance_ms_deploy_log.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/extensions/MSDeploy/log"
    }

    @distributed_trace
    def list_instance_processes(
        self, resource_group_name: str, name: str, instance_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessInfo"]:
        """Get list of processes for a web site, or a deployment slot, or for a specific scaled-out
        instance in a web site.

        Get list of processes for a web site, or a deployment slot, or for a specific scaled-out
        instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProcessInfo or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ProcessInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ProcessInfoCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_instance_processes_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    instance_id=instance_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_instance_processes.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_instance_processes.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes"
    }

    @distributed_trace_async
    async def get_instance_process(
        self, resource_group_name: str, name: str, process_id: str, instance_id: str, **kwargs: Any
    ) -> _models.ProcessInfo:
        """Get process information by its ID for a specific scaled-out instance in a web site.

        Get process information by its ID for a specific scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProcessInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ProcessInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ProcessInfo] = kwargs.pop("cls", None)

        request = build_get_instance_process_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_instance_process.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ProcessInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_instance_process.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}"
    }

    @distributed_trace_async
    async def delete_instance_process(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, process_id: str, instance_id: str, **kwargs: Any
    ) -> None:
        """Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
        instance in a web site.

        Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
        instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_instance_process_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_instance_process.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_instance_process.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}"
    }

    @distributed_trace_async
    async def get_instance_process_dump(
        self, resource_group_name: str, name: str, process_id: str, instance_id: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.

        Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Async iterator of the response bytes or the result of cls(response)
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        request = build_get_instance_process_dump_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_instance_process_dump.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    get_instance_process_dump.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/dump"
    }

    @distributed_trace
    def list_instance_process_modules(
        self, resource_group_name: str, name: str, process_id: str, instance_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessModuleInfo"]:
        """List module information for a process by its ID for a specific scaled-out instance in a web
        site.

        List module information for a process by its ID for a specific scaled-out instance in a web
        site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProcessModuleInfo or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ProcessModuleInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ProcessModuleInfoCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_instance_process_modules_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    process_id=process_id,
                    instance_id=instance_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_instance_process_modules.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessModuleInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_instance_process_modules.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules"
    }

    @distributed_trace_async
    async def get_instance_process_module(
        self, resource_group_name: str, name: str, process_id: str, base_address: str, instance_id: str, **kwargs: Any
    ) -> _models.ProcessModuleInfo:
        """Get process information by its ID for a specific scaled-out instance in a web site.

        Get process information by its ID for a specific scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param base_address: Module base address. Required.
        :type base_address: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProcessModuleInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ProcessModuleInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ProcessModuleInfo] = kwargs.pop("cls", None)

        request = build_get_instance_process_module_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            base_address=base_address,
            instance_id=instance_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_instance_process_module.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ProcessModuleInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_instance_process_module.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/modules/{baseAddress}"
    }

    @distributed_trace
    def list_instance_process_threads(
        self, resource_group_name: str, name: str, process_id: str, instance_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessThreadInfo"]:
        """List the threads in a process by its ID for a specific scaled-out instance in a web site.

        List the threads in a process by its ID for a specific scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param instance_id: ID of a specific scaled-out instance. This is the value of the name
         property in the JSON response from "GET api/sites/{siteName}/instances". Required.
        :type instance_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProcessThreadInfo or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ProcessThreadInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ProcessThreadInfoCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_instance_process_threads_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    process_id=process_id,
                    instance_id=instance_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_instance_process_threads.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessThreadInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_instance_process_threads.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/processes/{processId}/threads"
    }

    @distributed_trace_async
    async def is_cloneable(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.SiteCloneability:
        """Shows whether an app can be cloned to another resource group or subscription.

        Shows whether an app can be cloned to another resource group or subscription.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteCloneability or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteCloneability
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteCloneability] = kwargs.pop("cls", None)

        request = build_is_cloneable_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.is_cloneable.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteCloneability", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    is_cloneable.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable"
    }

    @distributed_trace
    def list_site_backups(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.BackupItem"]:
        """Gets existing backups of an app.

        Gets existing backups of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either BackupItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.BackupItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.BackupItemCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_site_backups_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_site_backups.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("BackupItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_site_backups.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/listbackups"
    }

    @distributed_trace_async
    async def list_sync_function_triggers(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.FunctionSecrets:
        """This is to allow calling via powershell and ARM template.

        This is to allow calling via powershell and ARM template.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: FunctionSecrets or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.FunctionSecrets
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.FunctionSecrets] = kwargs.pop("cls", None)

        request = build_list_sync_function_triggers_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_sync_function_triggers.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("FunctionSecrets", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_sync_function_triggers.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/listsyncfunctiontriggerstatus"
    }

    async def _migrate_storage_initial(
        self,
        subscription_name: str,
        resource_group_name: str,
        name: str,
        migration_options: Union[_models.StorageMigrationOptions, IO],
        **kwargs: Any
    ) -> _models.StorageMigrationResponse:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StorageMigrationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(migration_options, (IO, bytes)):
            _content = migration_options
        else:
            _json = self._serialize.body(migration_options, "StorageMigrationOptions")

        request = build_migrate_storage_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            subscription_name=subscription_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._migrate_storage_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StorageMigrationResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _migrate_storage_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migrate"
    }

    @overload
    async def begin_migrate_storage(
        self,
        subscription_name: str,
        resource_group_name: str,
        name: str,
        migration_options: _models.StorageMigrationOptions,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StorageMigrationResponse]:
        """Restores a web app.

        Restores a web app.

        :param subscription_name: Azure subscription. Required.
        :type subscription_name: str
        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_options: Migration migrationOptions. Required.
        :type migration_options: ~azure.mgmt.web.v2021_01_15.models.StorageMigrationOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either StorageMigrationResponse or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.StorageMigrationResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_migrate_storage(
        self,
        subscription_name: str,
        resource_group_name: str,
        name: str,
        migration_options: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StorageMigrationResponse]:
        """Restores a web app.

        Restores a web app.

        :param subscription_name: Azure subscription. Required.
        :type subscription_name: str
        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_options: Migration migrationOptions. Required.
        :type migration_options: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either StorageMigrationResponse or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.StorageMigrationResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_migrate_storage(
        self,
        subscription_name: str,
        resource_group_name: str,
        name: str,
        migration_options: Union[_models.StorageMigrationOptions, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.StorageMigrationResponse]:
        """Restores a web app.

        Restores a web app.

        :param subscription_name: Azure subscription. Required.
        :type subscription_name: str
        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_options: Migration migrationOptions. Is either a StorageMigrationOptions type
         or a IO type. Required.
        :type migration_options: ~azure.mgmt.web.v2021_01_15.models.StorageMigrationOptions or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either StorageMigrationResponse or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.StorageMigrationResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StorageMigrationResponse] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._migrate_storage_initial(
                subscription_name=subscription_name,
                resource_group_name=resource_group_name,
                name=name,
                migration_options=migration_options,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("StorageMigrationResponse", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_migrate_storage.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migrate"
    }

    async def _migrate_my_sql_initial(
        self,
        resource_group_name: str,
        name: str,
        migration_request_envelope: Union[_models.MigrateMySqlRequest, IO],
        **kwargs: Any
    ) -> _models.Operation:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Operation] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(migration_request_envelope, (IO, bytes)):
            _content = migration_request_envelope
        else:
            _json = self._serialize.body(migration_request_envelope, "MigrateMySqlRequest")

        request = build_migrate_my_sql_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._migrate_my_sql_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Operation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _migrate_my_sql_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql"
    }

    @overload
    async def begin_migrate_my_sql(
        self,
        resource_group_name: str,
        name: str,
        migration_request_envelope: _models.MigrateMySqlRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Operation]:
        """Migrates a local (in-app) MySql database to a remote MySql database.

        Migrates a local (in-app) MySql database to a remote MySql database.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_request_envelope: MySql migration options. Required.
        :type migration_request_envelope: ~azure.mgmt.web.v2021_01_15.models.MigrateMySqlRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Operation or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_migrate_my_sql(
        self,
        resource_group_name: str,
        name: str,
        migration_request_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Operation]:
        """Migrates a local (in-app) MySql database to a remote MySql database.

        Migrates a local (in-app) MySql database to a remote MySql database.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_request_envelope: MySql migration options. Required.
        :type migration_request_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Operation or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_migrate_my_sql(
        self,
        resource_group_name: str,
        name: str,
        migration_request_envelope: Union[_models.MigrateMySqlRequest, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Operation]:
        """Migrates a local (in-app) MySql database to a remote MySql database.

        Migrates a local (in-app) MySql database to a remote MySql database.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param migration_request_envelope: MySql migration options. Is either a MigrateMySqlRequest
         type or a IO type. Required.
        :type migration_request_envelope: ~azure.mgmt.web.v2021_01_15.models.MigrateMySqlRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Operation or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Operation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._migrate_my_sql_initial(
                resource_group_name=resource_group_name,
                name=name,
                migration_request_envelope=migration_request_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("Operation", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_migrate_my_sql.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql"
    }

    @distributed_trace_async
    async def get_migrate_my_sql_status(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.MigrateMySqlStatus:
        """Returns the status of MySql in app migration, if one is active, and whether or not MySql in app
        is enabled.

        Returns the status of MySql in app migration, if one is active, and whether or not MySql in app
        is enabled.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: MigrateMySqlStatus or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.MigrateMySqlStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.MigrateMySqlStatus] = kwargs.pop("cls", None)

        request = build_get_migrate_my_sql_status_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_migrate_my_sql_status.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MigrateMySqlStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_migrate_my_sql_status.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql/status"
    }

    @distributed_trace_async
    async def get_swift_virtual_network_connection(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Gets a Swift Virtual Network connection.

        Gets a Swift Virtual Network connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SwiftVirtualNetwork] = kwargs.pop("cls", None)

        request = build_get_swift_virtual_network_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_swift_virtual_network_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SwiftVirtualNetwork", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_swift_virtual_network_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork"
    }

    @overload
    async def create_or_update_swift_virtual_network_connection_with_check(
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: _models.SwiftVirtualNetwork,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example.
         Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_swift_virtual_network_connection_with_check(
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example.
         Required.
        :type connection_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_swift_virtual_network_connection_with_check(
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: Union[_models.SwiftVirtualNetwork, IO],
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example. Is
         either a SwiftVirtualNetwork type or a IO type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SwiftVirtualNetwork] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IO, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "SwiftVirtualNetwork")

        request = build_create_or_update_swift_virtual_network_connection_with_check_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_swift_virtual_network_connection_with_check.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SwiftVirtualNetwork", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_swift_virtual_network_connection_with_check.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork"
    }

    @distributed_trace_async
    async def delete_swift_virtual_network(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> None:
        """Deletes a Swift Virtual Network connection from an app (or deployment slot).

        Deletes a Swift Virtual Network connection from an app (or deployment slot).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_swift_virtual_network_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_swift_virtual_network.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_swift_virtual_network.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork"
    }

    @overload
    async def update_swift_virtual_network_connection_with_check(
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: _models.SwiftVirtualNetwork,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example.
         Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_swift_virtual_network_connection_with_check(
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example.
         Required.
        :type connection_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_swift_virtual_network_connection_with_check(
        self,
        resource_group_name: str,
        name: str,
        connection_envelope: Union[_models.SwiftVirtualNetwork, IO],
        **kwargs: Any
    ) -> _models.SwiftVirtualNetwork:
        """Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
        when doing a GET against this resource, and 2) that the target Subnet has already been
        delegated, and is not
        in use by another App Service Plan other than the one this App is in.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_envelope: Properties of the Virtual Network connection. See example. Is
         either a SwiftVirtualNetwork type or a IO type. Required.
        :type connection_envelope: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SwiftVirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SwiftVirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SwiftVirtualNetwork] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_envelope, (IO, bytes)):
            _content = connection_envelope
        else:
            _json = self._serialize.body(connection_envelope, "SwiftVirtualNetwork")

        request = build_update_swift_virtual_network_connection_with_check_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_swift_virtual_network_connection_with_check.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SwiftVirtualNetwork", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_swift_virtual_network_connection_with_check.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkConfig/virtualNetwork"
    }

    @distributed_trace_async
    async def list_network_features(
        self, resource_group_name: str, name: str, view: str, **kwargs: Any
    ) -> _models.NetworkFeatures:
        """Gets all network features used by the app (or deployment slot, if specified).

        Gets all network features used by the app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param view: The type of view. Only "summary" is supported at this time. Required.
        :type view: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: NetworkFeatures or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.NetworkFeatures
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.NetworkFeatures] = kwargs.pop("cls", None)

        request = build_list_network_features_request(
            resource_group_name=resource_group_name,
            name=name,
            view=view,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_network_features.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkFeatures", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_network_features.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}"
    }

    @distributed_trace_async
    async def get_network_trace_operation(
        self, resource_group_name: str, name: str, operation_id: str, **kwargs: Any
    ) -> List[_models.NetworkTrace]:
        """Gets a named operation for a network trace capturing (or deployment slot, if specified).

        Gets a named operation for a network trace capturing (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param operation_id: GUID of the operation. Required.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of NetworkTrace or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2021_01_15.models.NetworkTrace]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)

        request = build_get_network_trace_operation_request(
            resource_group_name=resource_group_name,
            name=name,
            operation_id=operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_network_trace_operation.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("[NetworkTrace]", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("[NetworkTrace]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    get_network_trace_operation.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/operationresults/{operationId}"
    }

    @distributed_trace_async
    async def start_web_site_network_trace(
        self,
        resource_group_name: str,
        name: str,
        duration_in_seconds: Optional[int] = None,
        max_frame_length: Optional[int] = None,
        sas_url: Optional[str] = None,
        **kwargs: Any
    ) -> str:
        """Start capturing network packets for the site (To be deprecated).

        Start capturing network packets for the site (To be deprecated).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param duration_in_seconds: The duration to keep capturing in seconds. Default value is None.
        :type duration_in_seconds: int
        :param max_frame_length: The maximum frame length in bytes (Optional). Default value is None.
        :type max_frame_length: int
        :param sas_url: The Blob URL to store capture file. Default value is None.
        :type sas_url: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: str or the result of cls(response)
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[str] = kwargs.pop("cls", None)

        request = build_start_web_site_network_trace_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            duration_in_seconds=duration_in_seconds,
            max_frame_length=max_frame_length,
            sas_url=sas_url,
            api_version=api_version,
            template_url=self.start_web_site_network_trace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("str", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    start_web_site_network_trace.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/start"
    }

    async def _start_web_site_network_trace_operation_initial(
        self,
        resource_group_name: str,
        name: str,
        duration_in_seconds: Optional[int] = None,
        max_frame_length: Optional[int] = None,
        sas_url: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.NetworkTrace]:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)

        request = build_start_web_site_network_trace_operation_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            duration_in_seconds=duration_in_seconds,
            max_frame_length=max_frame_length,
            sas_url=sas_url,
            api_version=api_version,
            template_url=self._start_web_site_network_trace_operation_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("[NetworkTrace]", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("[NetworkTrace]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _start_web_site_network_trace_operation_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/startOperation"
    }

    @distributed_trace_async
    async def begin_start_web_site_network_trace_operation(
        self,
        resource_group_name: str,
        name: str,
        duration_in_seconds: Optional[int] = None,
        max_frame_length: Optional[int] = None,
        sas_url: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[List[_models.NetworkTrace]]:
        """Start capturing network packets for the site.

        Start capturing network packets for the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param duration_in_seconds: The duration to keep capturing in seconds. Default value is None.
        :type duration_in_seconds: int
        :param max_frame_length: The maximum frame length in bytes (Optional). Default value is None.
        :type max_frame_length: int
        :param sas_url: The Blob URL to store capture file. Default value is None.
        :type sas_url: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either list of NetworkTrace or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[list[~azure.mgmt.web.v2021_01_15.models.NetworkTrace]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._start_web_site_network_trace_operation_initial(
                resource_group_name=resource_group_name,
                name=name,
                duration_in_seconds=duration_in_seconds,
                max_frame_length=max_frame_length,
                sas_url=sas_url,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("[NetworkTrace]", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_start_web_site_network_trace_operation.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/startOperation"
    }

    @distributed_trace_async
    async def stop_web_site_network_trace(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> None:
        """Stop ongoing capturing network packets for the site.

        Stop ongoing capturing network packets for the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_stop_web_site_network_trace_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.stop_web_site_network_trace.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    stop_web_site_network_trace.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/stop"
    }

    @distributed_trace_async
    async def get_network_traces(
        self, resource_group_name: str, name: str, operation_id: str, **kwargs: Any
    ) -> List[_models.NetworkTrace]:
        """Gets a named operation for a network trace capturing (or deployment slot, if specified).

        Gets a named operation for a network trace capturing (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param operation_id: GUID of the operation. Required.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of NetworkTrace or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2021_01_15.models.NetworkTrace]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)

        request = build_get_network_traces_request(
            resource_group_name=resource_group_name,
            name=name,
            operation_id=operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_network_traces.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[NetworkTrace]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_network_traces.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/{operationId}"
    }

    @distributed_trace_async
    async def get_network_trace_operation_v2(
        self, resource_group_name: str, name: str, operation_id: str, **kwargs: Any
    ) -> List[_models.NetworkTrace]:
        """Gets a named operation for a network trace capturing (or deployment slot, if specified).

        Gets a named operation for a network trace capturing (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param operation_id: GUID of the operation. Required.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of NetworkTrace or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2021_01_15.models.NetworkTrace]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)

        request = build_get_network_trace_operation_v2_request(
            resource_group_name=resource_group_name,
            name=name,
            operation_id=operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_network_trace_operation_v2.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("[NetworkTrace]", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("[NetworkTrace]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    get_network_trace_operation_v2.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTraces/current/operationresults/{operationId}"
    }

    @distributed_trace_async
    async def get_network_traces_v2(
        self, resource_group_name: str, name: str, operation_id: str, **kwargs: Any
    ) -> List[_models.NetworkTrace]:
        """Gets a named operation for a network trace capturing (or deployment slot, if specified).

        Gets a named operation for a network trace capturing (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param operation_id: GUID of the operation. Required.
        :type operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of NetworkTrace or the result of cls(response)
        :rtype: list[~azure.mgmt.web.v2021_01_15.models.NetworkTrace]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[List[_models.NetworkTrace]] = kwargs.pop("cls", None)

        request = build_get_network_traces_v2_request(
            resource_group_name=resource_group_name,
            name=name,
            operation_id=operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_network_traces_v2.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("[NetworkTrace]", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_network_traces_v2.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTraces/{operationId}"
    }

    @distributed_trace_async
    async def generate_new_site_publishing_password(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> None:
        """Generates a new publishing password for an app (or deployment slot, if specified).

        Generates a new publishing password for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_generate_new_site_publishing_password_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.generate_new_site_publishing_password.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    generate_new_site_publishing_password.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword"
    }

    @distributed_trace
    def list_perf_mon_counters(
        self, resource_group_name: str, name: str, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.PerfMonResponse"]:
        """Gets perfmon counters for web app.

        Gets perfmon counters for web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param filter: Return only usages/metrics specified in the filter. Filter conforms to odata
         syntax. Example: $filter=(startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z
         and timeGrain eq duration'[Hour|Minute|Day]'. Default value is None.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PerfMonResponse or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.PerfMonResponse]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PerfMonCounterCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_perf_mon_counters_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    filter=filter,
                    api_version=api_version,
                    template_url=self.list_perf_mon_counters.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PerfMonCounterCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_perf_mon_counters.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/perfcounters"
    }

    @distributed_trace_async
    async def get_site_php_error_log_flag(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.SitePhpErrorLogFlag:
        """Gets web app's event logs.

        Gets web app's event logs.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SitePhpErrorLogFlag or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SitePhpErrorLogFlag
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SitePhpErrorLogFlag] = kwargs.pop("cls", None)

        request = build_get_site_php_error_log_flag_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_site_php_error_log_flag.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SitePhpErrorLogFlag", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_php_error_log_flag.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/phplogging"
    }

    @distributed_trace_async
    async def list_premier_add_ons(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.PremierAddOn:
        """Gets the premier add-ons of an app.

        Gets the premier add-ons of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PremierAddOn] = kwargs.pop("cls", None)

        request = build_list_premier_add_ons_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_premier_add_ons.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PremierAddOn", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_premier_add_ons.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons"
    }

    @distributed_trace_async
    async def get_premier_add_on(
        self, resource_group_name: str, name: str, premier_add_on_name: str, **kwargs: Any
    ) -> _models.PremierAddOn:
        """Gets a named add-on of an app.

        Gets a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PremierAddOn] = kwargs.pop("cls", None)

        request = build_get_premier_add_on_request(
            resource_group_name=resource_group_name,
            name=name,
            premier_add_on_name=premier_add_on_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_premier_add_on.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PremierAddOn", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_premier_add_on.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}"
    }

    @overload
    async def add_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: _models.PremierAddOn,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Required.
        :type premier_add_on: ~azure.mgmt.web.v2021_01_15.models.PremierAddOn
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Required.
        :type premier_add_on: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: Union[_models.PremierAddOn, IO],
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Is either a
         PremierAddOn type or a IO type. Required.
        :type premier_add_on: ~azure.mgmt.web.v2021_01_15.models.PremierAddOn or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PremierAddOn] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(premier_add_on, (IO, bytes)):
            _content = premier_add_on
        else:
            _json = self._serialize.body(premier_add_on, "PremierAddOn")

        request = build_add_premier_add_on_request(
            resource_group_name=resource_group_name,
            name=name,
            premier_add_on_name=premier_add_on_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.add_premier_add_on.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PremierAddOn", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    add_premier_add_on.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}"
    }

    @distributed_trace_async
    async def delete_premier_add_on(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, premier_add_on_name: str, **kwargs: Any
    ) -> None:
        """Delete a premier add-on from an app.

        Delete a premier add-on from an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_premier_add_on_request(
            resource_group_name=resource_group_name,
            name=name,
            premier_add_on_name=premier_add_on_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_premier_add_on.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_premier_add_on.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}"
    }

    @overload
    async def update_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: _models.PremierAddOnPatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Required.
        :type premier_add_on: ~azure.mgmt.web.v2021_01_15.models.PremierAddOnPatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Required.
        :type premier_add_on: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_premier_add_on(
        self,
        resource_group_name: str,
        name: str,
        premier_add_on_name: str,
        premier_add_on: Union[_models.PremierAddOnPatchResource, IO],
        **kwargs: Any
    ) -> _models.PremierAddOn:
        """Updates a named add-on of an app.

        Updates a named add-on of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param premier_add_on_name: Add-on name. Required.
        :type premier_add_on_name: str
        :param premier_add_on: A JSON representation of the edited premier add-on. Is either a
         PremierAddOnPatchResource type or a IO type. Required.
        :type premier_add_on: ~azure.mgmt.web.v2021_01_15.models.PremierAddOnPatchResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PremierAddOn or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PremierAddOn
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PremierAddOn] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(premier_add_on, (IO, bytes)):
            _content = premier_add_on
        else:
            _json = self._serialize.body(premier_add_on, "PremierAddOnPatchResource")

        request = build_update_premier_add_on_request(
            resource_group_name=resource_group_name,
            name=name,
            premier_add_on_name=premier_add_on_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_premier_add_on.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PremierAddOn", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_premier_add_on.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}"
    }

    @distributed_trace_async
    async def get_private_access(self, resource_group_name: str, name: str, **kwargs: Any) -> _models.PrivateAccess:
        """Gets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        Gets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PrivateAccess or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PrivateAccess
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PrivateAccess] = kwargs.pop("cls", None)

        request = build_get_private_access_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_private_access.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PrivateAccess", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_private_access.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateAccess/virtualNetworks"
    }

    @overload
    async def put_private_access_vnet(
        self,
        resource_group_name: str,
        name: str,
        access: _models.PrivateAccess,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PrivateAccess:
        """Sets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        Sets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param access: The information for the private access. Required.
        :type access: ~azure.mgmt.web.v2021_01_15.models.PrivateAccess
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PrivateAccess or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PrivateAccess
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def put_private_access_vnet(
        self, resource_group_name: str, name: str, access: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.PrivateAccess:
        """Sets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        Sets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param access: The information for the private access. Required.
        :type access: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PrivateAccess or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PrivateAccess
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def put_private_access_vnet(
        self, resource_group_name: str, name: str, access: Union[_models.PrivateAccess, IO], **kwargs: Any
    ) -> _models.PrivateAccess:
        """Sets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        Sets data around private site access enablement and authorized Virtual Networks that can access
        the site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: The name of the web app. Required.
        :type name: str
        :param access: The information for the private access. Is either a PrivateAccess type or a IO
         type. Required.
        :type access: ~azure.mgmt.web.v2021_01_15.models.PrivateAccess or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PrivateAccess or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PrivateAccess
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PrivateAccess] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(access, (IO, bytes)):
            _content = access
        else:
            _json = self._serialize.body(access, "PrivateAccess")

        request = build_put_private_access_vnet_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.put_private_access_vnet.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PrivateAccess", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    put_private_access_vnet.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateAccess/virtualNetworks"
    }

    @distributed_trace
    def get_private_endpoint_connection_list(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.RemotePrivateEndpointConnectionARMResource"]:
        """Gets the list of private endpoint connections associated with a site.

        Gets the list of private endpoint connections associated with a site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either RemotePrivateEndpointConnectionARMResource or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PrivateEndpointConnectionCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_private_endpoint_connection_list_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_private_endpoint_connection_list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PrivateEndpointConnectionCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_private_endpoint_connection_list.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections"
    }

    @distributed_trace_async
    async def get_private_endpoint_connection(
        self, resource_group_name: str, name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> _models.RemotePrivateEndpointConnectionARMResource:
        """Gets a private endpoint connection.

        Gets a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :param private_endpoint_connection_name: Name of the private endpoint connection. Required.
        :type private_endpoint_connection_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.RemotePrivateEndpointConnectionARMResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.RemotePrivateEndpointConnectionARMResource] = kwargs.pop("cls", None)

        request = build_get_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_private_endpoint_connection.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RemotePrivateEndpointConnectionARMResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_private_endpoint_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
    }

    async def _approve_or_reject_private_endpoint_connection_initial(
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: Union[_models.PrivateLinkConnectionApprovalRequestResource, IO],
        **kwargs: Any
    ) -> _models.RemotePrivateEndpointConnectionARMResource:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RemotePrivateEndpointConnectionARMResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(private_endpoint_wrapper, (IO, bytes)):
            _content = private_endpoint_wrapper
        else:
            _json = self._serialize.body(private_endpoint_wrapper, "PrivateLinkConnectionApprovalRequestResource")

        request = build_approve_or_reject_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._approve_or_reject_private_endpoint_connection_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("RemotePrivateEndpointConnectionARMResource", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("RemotePrivateEndpointConnectionARMResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _approve_or_reject_private_endpoint_connection_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
    }

    @overload
    async def begin_approve_or_reject_private_endpoint_connection(
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: _models.PrivateLinkConnectionApprovalRequestResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource]:
        """Approves or rejects a private endpoint connection.

        Approves or rejects a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :param private_endpoint_connection_name: Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_wrapper: Required.
        :type private_endpoint_wrapper:
         ~azure.mgmt.web.v2021_01_15.models.PrivateLinkConnectionApprovalRequestResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either
         RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_approve_or_reject_private_endpoint_connection(
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource]:
        """Approves or rejects a private endpoint connection.

        Approves or rejects a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :param private_endpoint_connection_name: Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_wrapper: Required.
        :type private_endpoint_wrapper: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either
         RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_approve_or_reject_private_endpoint_connection(
        self,
        resource_group_name: str,
        name: str,
        private_endpoint_connection_name: str,
        private_endpoint_wrapper: Union[_models.PrivateLinkConnectionApprovalRequestResource, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RemotePrivateEndpointConnectionARMResource]:
        """Approves or rejects a private endpoint connection.

        Approves or rejects a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :param private_endpoint_connection_name: Required.
        :type private_endpoint_connection_name: str
        :param private_endpoint_wrapper: Is either a PrivateLinkConnectionApprovalRequestResource type
         or a IO type. Required.
        :type private_endpoint_wrapper:
         ~azure.mgmt.web.v2021_01_15.models.PrivateLinkConnectionApprovalRequestResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either
         RemotePrivateEndpointConnectionARMResource or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.RemotePrivateEndpointConnectionARMResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RemotePrivateEndpointConnectionARMResource] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._approve_or_reject_private_endpoint_connection_initial(
                resource_group_name=resource_group_name,
                name=name,
                private_endpoint_connection_name=private_endpoint_connection_name,
                private_endpoint_wrapper=private_endpoint_wrapper,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RemotePrivateEndpointConnectionARMResource", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_approve_or_reject_private_endpoint_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
    }

    async def _delete_private_endpoint_connection_initial(
        self, resource_group_name: str, name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> JSON:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_delete_private_endpoint_connection_request(
            resource_group_name=resource_group_name,
            name=name,
            private_endpoint_connection_name=private_endpoint_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._delete_private_endpoint_connection_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("object", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("object", pipeline_response)

        if response.status_code == 204:
            deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _delete_private_endpoint_connection_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
    }

    @distributed_trace_async
    async def begin_delete_private_endpoint_connection(
        self, resource_group_name: str, name: str, private_endpoint_connection_name: str, **kwargs: Any
    ) -> AsyncLROPoller[JSON]:
        """Deletes a private endpoint connection.

        Deletes a private endpoint connection.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :param private_endpoint_connection_name: Required.
        :type private_endpoint_connection_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either JSON or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_private_endpoint_connection_initial(
                resource_group_name=resource_group_name,
                name=name,
                private_endpoint_connection_name=private_endpoint_connection_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("object", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_delete_private_endpoint_connection.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateEndpointConnections/{privateEndpointConnectionName}"
    }

    @distributed_trace_async
    async def get_private_link_resources(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> _models.PrivateLinkResourcesWrapper:
        """Gets the private link resources.

        Gets the private link resources.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the site. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PrivateLinkResourcesWrapper or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PrivateLinkResourcesWrapper
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PrivateLinkResourcesWrapper] = kwargs.pop("cls", None)

        request = build_get_private_link_resources_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_private_link_resources.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PrivateLinkResourcesWrapper", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_private_link_resources.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/privateLinkResources"
    }

    @distributed_trace
    def list_processes(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessInfo"]:
        """Get list of processes for a web site, or a deployment slot, or for a specific scaled-out
        instance in a web site.

        Get list of processes for a web site, or a deployment slot, or for a specific scaled-out
        instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProcessInfo or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ProcessInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ProcessInfoCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_processes_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_processes.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_processes.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes"
    }

    @distributed_trace_async
    async def get_process(
        self, resource_group_name: str, name: str, process_id: str, **kwargs: Any
    ) -> _models.ProcessInfo:
        """Get process information by its ID for a specific scaled-out instance in a web site.

        Get process information by its ID for a specific scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProcessInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ProcessInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ProcessInfo] = kwargs.pop("cls", None)

        request = build_get_process_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_process.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ProcessInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_process.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}"
    }

    @distributed_trace_async
    async def delete_process(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, process_id: str, **kwargs: Any
    ) -> None:
        """Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
        instance in a web site.

        Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
        instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_process_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_process.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_process.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}"
    }

    @distributed_trace_async
    async def get_process_dump(
        self, resource_group_name: str, name: str, process_id: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.

        Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Async iterator of the response bytes or the result of cls(response)
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        request = build_get_process_dump_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_process_dump.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    get_process_dump.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/dump"
    }

    @distributed_trace
    def list_process_modules(
        self, resource_group_name: str, name: str, process_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessModuleInfo"]:
        """List module information for a process by its ID for a specific scaled-out instance in a web
        site.

        List module information for a process by its ID for a specific scaled-out instance in a web
        site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProcessModuleInfo or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ProcessModuleInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ProcessModuleInfoCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_process_modules_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    process_id=process_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_process_modules.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessModuleInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_process_modules.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules"
    }

    @distributed_trace_async
    async def get_process_module(
        self, resource_group_name: str, name: str, process_id: str, base_address: str, **kwargs: Any
    ) -> _models.ProcessModuleInfo:
        """Get process information by its ID for a specific scaled-out instance in a web site.

        Get process information by its ID for a specific scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :param base_address: Module base address. Required.
        :type base_address: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ProcessModuleInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ProcessModuleInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ProcessModuleInfo] = kwargs.pop("cls", None)

        request = build_get_process_module_request(
            resource_group_name=resource_group_name,
            name=name,
            process_id=process_id,
            base_address=base_address,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_process_module.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ProcessModuleInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_process_module.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/modules/{baseAddress}"
    }

    @distributed_trace
    def list_process_threads(
        self, resource_group_name: str, name: str, process_id: str, **kwargs: Any
    ) -> AsyncIterable["_models.ProcessThreadInfo"]:
        """List the threads in a process by its ID for a specific scaled-out instance in a web site.

        List the threads in a process by its ID for a specific scaled-out instance in a web site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param process_id: PID. Required.
        :type process_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProcessThreadInfo or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ProcessThreadInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ProcessThreadInfoCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_process_threads_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    process_id=process_id,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_process_threads.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ProcessThreadInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_process_threads.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/processes/{processId}/threads"
    }

    @distributed_trace
    def list_public_certificates(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.PublicCertificate"]:
        """Get public certificates for an app or a deployment slot.

        Get public certificates for an app or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PublicCertificate or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.PublicCertificate]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PublicCertificateCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_public_certificates_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_public_certificates.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PublicCertificateCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_public_certificates.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates"
    }

    @distributed_trace_async
    async def get_public_certificate(
        self, resource_group_name: str, name: str, public_certificate_name: str, **kwargs: Any
    ) -> _models.PublicCertificate:
        """Get the named public certificate for an app (or deployment slot, if specified).

        Get the named public certificate for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param public_certificate_name: Public certificate name. Required.
        :type public_certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PublicCertificate or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PublicCertificate
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PublicCertificate] = kwargs.pop("cls", None)

        request = build_get_public_certificate_request(
            resource_group_name=resource_group_name,
            name=name,
            public_certificate_name=public_certificate_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_public_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PublicCertificate", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_public_certificate.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}"
    }

    @overload
    async def create_or_update_public_certificate(
        self,
        resource_group_name: str,
        name: str,
        public_certificate_name: str,
        public_certificate: _models.PublicCertificate,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PublicCertificate:
        """Creates a hostname binding for an app.

        Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param public_certificate_name: Public certificate name. Required.
        :type public_certificate_name: str
        :param public_certificate: Public certificate details. This is the JSON representation of a
         PublicCertificate object. Required.
        :type public_certificate: ~azure.mgmt.web.v2021_01_15.models.PublicCertificate
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PublicCertificate or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PublicCertificate
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_public_certificate(
        self,
        resource_group_name: str,
        name: str,
        public_certificate_name: str,
        public_certificate: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.PublicCertificate:
        """Creates a hostname binding for an app.

        Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param public_certificate_name: Public certificate name. Required.
        :type public_certificate_name: str
        :param public_certificate: Public certificate details. This is the JSON representation of a
         PublicCertificate object. Required.
        :type public_certificate: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PublicCertificate or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PublicCertificate
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_public_certificate(
        self,
        resource_group_name: str,
        name: str,
        public_certificate_name: str,
        public_certificate: Union[_models.PublicCertificate, IO],
        **kwargs: Any
    ) -> _models.PublicCertificate:
        """Creates a hostname binding for an app.

        Creates a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param public_certificate_name: Public certificate name. Required.
        :type public_certificate_name: str
        :param public_certificate: Public certificate details. This is the JSON representation of a
         PublicCertificate object. Is either a PublicCertificate type or a IO type. Required.
        :type public_certificate: ~azure.mgmt.web.v2021_01_15.models.PublicCertificate or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PublicCertificate or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.PublicCertificate
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PublicCertificate] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(public_certificate, (IO, bytes)):
            _content = public_certificate
        else:
            _json = self._serialize.body(public_certificate, "PublicCertificate")

        request = build_create_or_update_public_certificate_request(
            resource_group_name=resource_group_name,
            name=name,
            public_certificate_name=public_certificate_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_public_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PublicCertificate", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_public_certificate.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}"
    }

    @distributed_trace_async
    async def delete_public_certificate(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, public_certificate_name: str, **kwargs: Any
    ) -> None:
        """Deletes a hostname binding for an app.

        Deletes a hostname binding for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param public_certificate_name: Public certificate name. Required.
        :type public_certificate_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_public_certificate_request(
            resource_group_name=resource_group_name,
            name=name,
            public_certificate_name=public_certificate_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_public_certificate.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_public_certificate.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publicCertificates/{publicCertificateName}"
    }

    @overload
    async def list_publishing_profile_xml_with_secrets(
        self,
        resource_group_name: str,
        name: str,
        publishing_profile_options: _models.CsmPublishingProfileOptions,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Gets the publishing profile for an app (or deployment slot, if specified).

        Gets the publishing profile for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param publishing_profile_options: Specifies publishingProfileOptions for publishing profile.
         For example, use {"format": "FileZilla3"} to get a FileZilla publishing profile. Required.
        :type publishing_profile_options:
         ~azure.mgmt.web.v2021_01_15.models.CsmPublishingProfileOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Async iterator of the response bytes or the result of cls(response)
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_publishing_profile_xml_with_secrets(
        self,
        resource_group_name: str,
        name: str,
        publishing_profile_options: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Gets the publishing profile for an app (or deployment slot, if specified).

        Gets the publishing profile for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param publishing_profile_options: Specifies publishingProfileOptions for publishing profile.
         For example, use {"format": "FileZilla3"} to get a FileZilla publishing profile. Required.
        :type publishing_profile_options: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Async iterator of the response bytes or the result of cls(response)
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_publishing_profile_xml_with_secrets(
        self,
        resource_group_name: str,
        name: str,
        publishing_profile_options: Union[_models.CsmPublishingProfileOptions, IO],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        """Gets the publishing profile for an app (or deployment slot, if specified).

        Gets the publishing profile for an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param publishing_profile_options: Specifies publishingProfileOptions for publishing profile.
         For example, use {"format": "FileZilla3"} to get a FileZilla publishing profile. Is either a
         CsmPublishingProfileOptions type or a IO type. Required.
        :type publishing_profile_options:
         ~azure.mgmt.web.v2021_01_15.models.CsmPublishingProfileOptions or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Async iterator of the response bytes or the result of cls(response)
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(publishing_profile_options, (IO, bytes)):
            _content = publishing_profile_options
        else:
            _json = self._serialize.body(publishing_profile_options, "CsmPublishingProfileOptions")

        request = build_list_publishing_profile_xml_with_secrets_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_publishing_profile_xml_with_secrets.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    list_publishing_profile_xml_with_secrets.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml"
    }

    @distributed_trace_async
    async def reset_production_slot_config(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> None:
        """Resets the configuration settings of the current slot if they were previously modified by
        calling the API with POST.

        Resets the configuration settings of the current slot if they were previously modified by
        calling the API with POST.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_reset_production_slot_config_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.reset_production_slot_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    reset_production_slot_config.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resetSlotConfig"
    }

    @distributed_trace_async
    async def restart(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        soft_restart: Optional[bool] = None,
        synchronous: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Restarts an app (or deployment slot, if specified).

        Restarts an app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param soft_restart: Specify true to apply the configuration settings and restarts the app only
         if necessary. By default, the API always restarts and reprovisions the app. Default value is
         None.
        :type soft_restart: bool
        :param synchronous: Specify true to block until the app is restarted. By default, it is set to
         false, and the API responds immediately (asynchronous). Default value is None.
        :type synchronous: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_restart_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            soft_restart=soft_restart,
            synchronous=synchronous,
            api_version=api_version,
            template_url=self.restart.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    restart.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restart"
    }

    async def _restore_from_backup_blob_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, request: Union[_models.RestoreRequest, IO], **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "RestoreRequest")

        request = build_restore_from_backup_blob_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._restore_from_backup_blob_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _restore_from_backup_blob_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromBackupBlob"
    }

    @overload
    async def begin_restore_from_backup_blob(
        self,
        resource_group_name: str,
        name: str,
        request: _models.RestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores an app from a backup blob in Azure Storage.

        Restores an app from a backup blob in Azure Storage.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Information on restore request . Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore_from_backup_blob(
        self, resource_group_name: str, name: str, request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores an app from a backup blob in Azure Storage.

        Restores an app from a backup blob in Azure Storage.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Information on restore request . Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore_from_backup_blob(
        self, resource_group_name: str, name: str, request: Union[_models.RestoreRequest, IO], **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores an app from a backup blob in Azure Storage.

        Restores an app from a backup blob in Azure Storage.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param request: Information on restore request . Is either a RestoreRequest type or a IO type.
         Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_from_backup_blob_initial(  # type: ignore
                resource_group_name=resource_group_name,
                name=name,
                request=request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_restore_from_backup_blob.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromBackupBlob"
    }

    async def _restore_from_deleted_app_initial(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        restore_request: Union[_models.DeletedAppRestoreRequest, IO],
        **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(restore_request, (IO, bytes)):
            _content = restore_request
        else:
            _json = self._serialize.body(restore_request, "DeletedAppRestoreRequest")

        request = build_restore_from_deleted_app_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._restore_from_deleted_app_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _restore_from_deleted_app_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromDeletedApp"
    }

    @overload
    async def begin_restore_from_deleted_app(
        self,
        resource_group_name: str,
        name: str,
        restore_request: _models.DeletedAppRestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a deleted web app to this web app.

        Restores a deleted web app to this web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Deleted web app restore information. Required.
        :type restore_request: ~azure.mgmt.web.v2021_01_15.models.DeletedAppRestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore_from_deleted_app(
        self,
        resource_group_name: str,
        name: str,
        restore_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a deleted web app to this web app.

        Restores a deleted web app to this web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Deleted web app restore information. Required.
        :type restore_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore_from_deleted_app(
        self,
        resource_group_name: str,
        name: str,
        restore_request: Union[_models.DeletedAppRestoreRequest, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a deleted web app to this web app.

        Restores a deleted web app to this web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Deleted web app restore information. Is either a
         DeletedAppRestoreRequest type or a IO type. Required.
        :type restore_request: ~azure.mgmt.web.v2021_01_15.models.DeletedAppRestoreRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_from_deleted_app_initial(  # type: ignore
                resource_group_name=resource_group_name,
                name=name,
                restore_request=restore_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_restore_from_deleted_app.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreFromDeletedApp"
    }

    async def _restore_snapshot_initial(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        restore_request: Union[_models.SnapshotRestoreRequest, IO],
        **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(restore_request, (IO, bytes)):
            _content = restore_request
        else:
            _json = self._serialize.body(restore_request, "SnapshotRestoreRequest")

        request = build_restore_snapshot_request(
            resource_group_name=resource_group_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._restore_snapshot_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _restore_snapshot_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreSnapshot"
    }

    @overload
    async def begin_restore_snapshot(
        self,
        resource_group_name: str,
        name: str,
        restore_request: _models.SnapshotRestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a web app from a snapshot.

        Restores a web app from a snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Snapshot restore settings. Snapshot information can be obtained by
         calling GetDeletedSites or GetSiteSnapshots API. Required.
        :type restore_request: ~azure.mgmt.web.v2021_01_15.models.SnapshotRestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore_snapshot(
        self,
        resource_group_name: str,
        name: str,
        restore_request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a web app from a snapshot.

        Restores a web app from a snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Snapshot restore settings. Snapshot information can be obtained by
         calling GetDeletedSites or GetSiteSnapshots API. Required.
        :type restore_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore_snapshot(
        self,
        resource_group_name: str,
        name: str,
        restore_request: Union[_models.SnapshotRestoreRequest, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a web app from a snapshot.

        Restores a web app from a snapshot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param restore_request: Snapshot restore settings. Snapshot information can be obtained by
         calling GetDeletedSites or GetSiteSnapshots API. Is either a SnapshotRestoreRequest type or a
         IO type. Required.
        :type restore_request: ~azure.mgmt.web.v2021_01_15.models.SnapshotRestoreRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_snapshot_initial(  # type: ignore
                resource_group_name=resource_group_name,
                name=name,
                restore_request=restore_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_restore_snapshot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restoreSnapshot"
    }

    @distributed_trace
    def list_site_extensions(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.SiteExtensionInfo"]:
        """Get list of siteextensions for a web site, or a deployment slot.

        Get list of siteextensions for a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SiteExtensionInfo or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.SiteExtensionInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteExtensionInfoCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_site_extensions_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_site_extensions.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SiteExtensionInfoCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_site_extensions.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions"
    }

    @distributed_trace_async
    async def get_site_extension(
        self, resource_group_name: str, name: str, site_extension_id: str, **kwargs: Any
    ) -> _models.SiteExtensionInfo:
        """Get site extension information by its ID for a web site, or a deployment slot.

        Get site extension information by its ID for a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param site_extension_id: Site extension name. Required.
        :type site_extension_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteExtensionInfo or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteExtensionInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteExtensionInfo] = kwargs.pop("cls", None)

        request = build_get_site_extension_request(
            resource_group_name=resource_group_name,
            name=name,
            site_extension_id=site_extension_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_site_extension.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteExtensionInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_extension.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}"
    }

    async def _install_site_extension_initial(
        self, resource_group_name: str, name: str, site_extension_id: str, **kwargs: Any
    ) -> _models.SiteExtensionInfo:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            429: lambda response: HttpResponseError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteExtensionInfo] = kwargs.pop("cls", None)

        request = build_install_site_extension_request(
            resource_group_name=resource_group_name,
            name=name,
            site_extension_id=site_extension_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self._install_site_extension_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("SiteExtensionInfo", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("SiteExtensionInfo", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _install_site_extension_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}"
    }

    @distributed_trace_async
    async def begin_install_site_extension(
        self, resource_group_name: str, name: str, site_extension_id: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.SiteExtensionInfo]:
        """Install site extension on a web site, or a deployment slot.

        Install site extension on a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param site_extension_id: Site extension name. Required.
        :type site_extension_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either SiteExtensionInfo or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.SiteExtensionInfo]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteExtensionInfo] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._install_site_extension_initial(
                resource_group_name=resource_group_name,
                name=name,
                site_extension_id=site_extension_id,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("SiteExtensionInfo", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_install_site_extension.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}"
    }

    @distributed_trace_async
    async def delete_site_extension(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, site_extension_id: str, **kwargs: Any
    ) -> None:
        """Remove a site extension from a web site, or a deployment slot.

        Remove a site extension from a web site, or a deployment slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Site name. Required.
        :type name: str
        :param site_extension_id: Site extension name. Required.
        :type site_extension_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_site_extension_request(
            resource_group_name=resource_group_name,
            name=name,
            site_extension_id=site_extension_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_site_extension.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_site_extension.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/siteextensions/{siteExtensionId}"
    }

    @distributed_trace
    def list_slots(self, resource_group_name: str, name: str, **kwargs: Any) -> AsyncIterable["_models.Site"]:
        """Gets an app's deployment slots.

        Gets an app's deployment slots.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Site or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.WebAppCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_slots_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_slots.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("WebAppCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_slots.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots"
    }

    @distributed_trace_async
    async def get_slot(self, resource_group_name: str, name: str, slot: str, **kwargs: Any) -> _models.Site:
        """Gets the details of a web, mobile, or API app.

        Gets the details of a web, mobile, or API app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. By default, this API returns the production slot.
         Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)

        request = build_get_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Site", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}"
    }

    async def _create_or_update_slot_initial(
        self, resource_group_name: str, name: str, slot: str, site_envelope: Union[_models.Site, IO], **kwargs: Any
    ) -> _models.Site:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_envelope, (IO, bytes)):
            _content = site_envelope
        else:
            _json = self._serialize.body(site_envelope, "Site")

        request = build_create_or_update_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_or_update_slot_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("Site", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("Site", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _create_or_update_slot_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}"
    }

    @overload
    async def begin_create_or_update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: _models.Site,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. The name 'production' is
         reserved. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: ~azure.mgmt.web.v2021_01_15.models.Site
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. The name 'production' is
         reserved. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update_slot(
        self, resource_group_name: str, name: str, slot: str, site_envelope: Union[_models.Site, IO], **kwargs: Any
    ) -> AsyncLROPoller[_models.Site]:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. The name 'production' is
         reserved. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Is either a
         Site type or a IO type. Required.
        :type site_envelope: ~azure.mgmt.web.v2021_01_15.models.Site or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Site or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Site]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_slot_initial(
                resource_group_name=resource_group_name,
                name=name,
                slot=slot,
                site_envelope=site_envelope,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("Site", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create_or_update_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}"
    }

    @distributed_trace_async
    async def delete_slot(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        delete_metrics: Optional[bool] = None,
        delete_empty_server_farm: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a web, mobile, or API app, or one of the deployment slots.

        Deletes a web, mobile, or API app, or one of the deployment slots.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app to delete. Required.
        :type name: str
        :param slot: Name of the deployment slot to delete. By default, the API deletes the production
         slot. Required.
        :type slot: str
        :param delete_metrics: If true, web app metrics are also deleted. Default value is None.
        :type delete_metrics: bool
        :param delete_empty_server_farm: Specify false if you want to keep empty App Service plan. By
         default, empty App Service plan is deleted. Default value is None.
        :type delete_empty_server_farm: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            delete_metrics=delete_metrics,
            delete_empty_server_farm=delete_empty_server_farm,
            api_version=api_version,
            template_url=self.delete_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}"
    }

    @overload
    async def update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: _models.SitePatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. The name 'production' is
         reserved. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: ~azure.mgmt.web.v2021_01_15.models.SitePatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. The name 'production' is
         reserved. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Required.
        :type site_envelope: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_envelope: Union[_models.SitePatchResource, IO],
        **kwargs: Any
    ) -> _models.Site:
        """Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        Creates a new web, mobile, or API app in an existing resource group, or updates an existing
        app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Unique name of the app to create or update. To create or update a deployment slot,
         use the {slot} parameter. Required.
        :type name: str
        :param slot: Name of the deployment slot to create or update. The name 'production' is
         reserved. Required.
        :type slot: str
        :param site_envelope: A JSON representation of the app properties. See example. Is either a
         SitePatchResource type or a IO type. Required.
        :type site_envelope: ~azure.mgmt.web.v2021_01_15.models.SitePatchResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Site or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Site
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Site] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_envelope, (IO, bytes)):
            _content = site_envelope
        else:
            _json = self._serialize.body(site_envelope, "SitePatchResource")

        request = build_update_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("Site", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("Site", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    update_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}"
    }

    @distributed_trace_async
    async def analyze_custom_hostname_slot(
        self, resource_group_name: str, name: str, slot: str, host_name: Optional[str] = None, **kwargs: Any
    ) -> _models.CustomHostnameAnalysisResult:
        """Analyze a custom hostname.

        Analyze a custom hostname.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param host_name: Custom hostname. Default value is None.
        :type host_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CustomHostnameAnalysisResult or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CustomHostnameAnalysisResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.CustomHostnameAnalysisResult] = kwargs.pop("cls", None)

        request = build_analyze_custom_hostname_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            host_name=host_name,
            api_version=api_version,
            template_url=self.analyze_custom_hostname_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CustomHostnameAnalysisResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    analyze_custom_hostname_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/analyzeCustomHostname"
    }

    @overload
    async def apply_slot_configuration_slot(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        slot_swap_entity: _models.CsmSlotEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the source slot. If a slot is not specified, the production slot is used
         as the source slot. Required.
        :type slot: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Required.
        :type slot_swap_entity: ~azure.mgmt.web.v2021_01_15.models.CsmSlotEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def apply_slot_configuration_slot(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        slot_swap_entity: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the source slot. If a slot is not specified, the production slot is used
         as the source slot. Required.
        :type slot: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Required.
        :type slot_swap_entity: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def apply_slot_configuration_slot(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        slot_swap_entity: Union[_models.CsmSlotEntity, IO],
        **kwargs: Any
    ) -> None:
        """Applies the configuration settings from the target slot onto the current slot.

        Applies the configuration settings from the target slot onto the current slot.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the source slot. If a slot is not specified, the production slot is used
         as the source slot. Required.
        :type slot: str
        :param slot_swap_entity: JSON object that contains the target slot name. See example. Is either
         a CsmSlotEntity type or a IO type. Required.
        :type slot_swap_entity: ~azure.mgmt.web.v2021_01_15.models.CsmSlotEntity or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(slot_swap_entity, (IO, bytes)):
            _content = slot_swap_entity
        else:
            _json = self._serialize.body(slot_swap_entity, "CsmSlotEntity")

        request = build_apply_slot_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.apply_slot_configuration_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    apply_slot_configuration_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig"
    }

    @overload
    async def backup_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will create a
         backup for the production slot. Required.
        :type slot: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def backup_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will create a
         backup for the production slot. Required.
        :type slot: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def backup_slot(
        self, resource_group_name: str, name: str, slot: str, request: Union[_models.BackupRequest, IO], **kwargs: Any
    ) -> _models.BackupItem:
        """Creates a backup of an app.

        Creates a backup of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will create a
         backup for the production slot. Required.
        :type slot: str
        :param request: Backup configuration. You can use the JSON response from the POST action as
         input here. Is either a BackupRequest type or a IO type. Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        request = build_backup_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.backup_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    backup_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup"
    }

    @distributed_trace
    def list_backups_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.BackupItem"]:
        """Gets existing backups of an app.

        Gets existing backups of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get backups
         of the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either BackupItem or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.BackupItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.BackupItemCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_backups_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_backups_slot.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("BackupItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_backups_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups"
    }

    @distributed_trace_async
    async def get_backup_status_slot(
        self, resource_group_name: str, name: str, backup_id: str, slot: str, **kwargs: Any
    ) -> _models.BackupItem:
        """Gets a backup of an app by its ID.

        Gets a backup of an app by its ID.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get a backup
         of the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        request = build_get_backup_status_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_backup_status_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_backup_status_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}"
    }

    @distributed_trace_async
    async def delete_backup_slot(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, backup_id: str, slot: str, **kwargs: Any
    ) -> None:
        """Deletes a backup of an app by its ID.

        Deletes a backup of an app by its ID.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will delete a
         backup of the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            404: lambda response: ResourceNotFoundError(response=response, error_format=ARMErrorFormat),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_backup_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_backup_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_backup_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}"
    }

    @overload
    async def list_backup_status_secrets_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param request: Information on backup request. Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_backup_status_secrets_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param request: Information on backup request. Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_backup_status_secrets_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: Union[_models.BackupRequest, IO],
        **kwargs: Any
    ) -> _models.BackupItem:
        """Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        Gets status of a web app backup that may be in progress, including secrets associated with the
        backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the
        backup if a new URL is passed in the request body.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param backup_id: ID of backup. Required.
        :type backup_id: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param request: Information on backup request. Is either a BackupRequest type or a IO type.
         Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupItem or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupItem] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        request = build_list_backup_status_secrets_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_backup_status_secrets_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupItem", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_backup_status_secrets_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list"
    }

    async def _restore_slot_initial(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: Union[_models.RestoreRequest, IO],
        **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "RestoreRequest")

        request = build_restore_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            backup_id=backup_id,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._restore_slot_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _restore_slot_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore"
    }

    @overload
    async def begin_restore_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: _models.RestoreRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will restore a
         backup of the production slot. Required.
        :type slot: str
        :param request: Information on restore request . Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_restore_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will restore a
         backup of the production slot. Required.
        :type slot: str
        :param request: Information on restore request . Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_restore_slot(
        self,
        resource_group_name: str,
        name: str,
        backup_id: str,
        slot: str,
        request: Union[_models.RestoreRequest, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Restores a specific backup to another app (or deployment slot, if specified).

        Restores a specific backup to another app (or deployment slot, if specified).

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param backup_id: ID of the backup. Required.
        :type backup_id: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will restore a
         backup of the production slot. Required.
        :type slot: str
        :param request: Information on restore request . Is either a RestoreRequest type or a IO type.
         Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.RestoreRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._restore_slot_initial(  # type: ignore
                resource_group_name=resource_group_name,
                name=name,
                backup_id=backup_id,
                slot=slot,
                request=request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_restore_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore"
    }

    @distributed_trace
    def list_basic_publishing_credentials_policies_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.CsmPublishingCredentialsPoliciesEntity"]:
        """Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.

        Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either CsmPublishingCredentialsPoliciesEntity or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.PublishingCredentialsPoliciesCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_basic_publishing_credentials_policies_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_basic_publishing_credentials_policies_slot.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PublishingCredentialsPoliciesCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_basic_publishing_credentials_policies_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies"
    }

    @distributed_trace_async
    async def get_ftp_allowed_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Returns whether FTP is allowed on the site or not.

        Returns whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        request = build_get_ftp_allowed_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_ftp_allowed_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_ftp_allowed_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies/ftp"
    }

    @overload
    async def update_ftp_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: _models.CsmPublishingCredentialsPoliciesEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_ftp_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_ftp_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: Union[_models.CsmPublishingCredentialsPoliciesEntity, IO],
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether FTP is allowed on the site or not.

        Updates whether FTP is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Is either a
         CsmPublishingCredentialsPoliciesEntity type or a IO type. Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(csm_publishing_access_policies_entity, (IO, bytes)):
            _content = csm_publishing_access_policies_entity
        else:
            _json = self._serialize.body(
                csm_publishing_access_policies_entity, "CsmPublishingCredentialsPoliciesEntity"
            )

        request = build_update_ftp_allowed_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_ftp_allowed_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_ftp_allowed_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies/ftp"
    }

    @distributed_trace_async
    async def get_scm_allowed_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Returns whether Scm basic auth is allowed on the site or not.

        Returns whether Scm basic auth is allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        request = build_get_scm_allowed_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_scm_allowed_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_scm_allowed_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies/scm"
    }

    @overload
    async def update_scm_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: _models.CsmPublishingCredentialsPoliciesEntity,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_scm_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Required.
        :type csm_publishing_access_policies_entity: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_scm_allowed_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        csm_publishing_access_policies_entity: Union[_models.CsmPublishingCredentialsPoliciesEntity, IO],
        **kwargs: Any
    ) -> _models.CsmPublishingCredentialsPoliciesEntity:
        """Updates whether user publishing credentials are allowed on the site or not.

        Updates whether user publishing credentials are allowed on the site or not.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :param csm_publishing_access_policies_entity: Is either a
         CsmPublishingCredentialsPoliciesEntity type or a IO type. Required.
        :type csm_publishing_access_policies_entity:
         ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CsmPublishingCredentialsPoliciesEntity or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.CsmPublishingCredentialsPoliciesEntity
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CsmPublishingCredentialsPoliciesEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(csm_publishing_access_policies_entity, (IO, bytes)):
            _content = csm_publishing_access_policies_entity
        else:
            _json = self._serialize.body(
                csm_publishing_access_policies_entity, "CsmPublishingCredentialsPoliciesEntity"
            )

        request = build_update_scm_allowed_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_scm_allowed_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CsmPublishingCredentialsPoliciesEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_scm_allowed_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/basicPublishingCredentialsPolicies/scm"
    }

    @distributed_trace
    def list_configurations_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.SiteConfigResource"]:
        """List the configurations of an app.

        List the configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will return
         configuration for the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either SiteConfigResource or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.SiteConfigResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteConfigResourceCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_configurations_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_configurations_slot.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SiteConfigResourceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_configurations_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config"
    }

    @overload
    async def update_application_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        app_settings: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         application settings for the production slot. Required.
        :type slot: str
        :param app_settings: Application settings of the app. Required.
        :type app_settings: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_application_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        app_settings: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         application settings for the production slot. Required.
        :type slot: str
        :param app_settings: Application settings of the app. Required.
        :type app_settings: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_application_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        app_settings: Union[_models.StringDictionary, IO],
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the application settings of an app.

        Replaces the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         application settings for the production slot. Required.
        :type slot: str
        :param app_settings: Application settings of the app. Is either a StringDictionary type or a IO
         type. Required.
        :type app_settings: ~azure.mgmt.web.v2021_01_15.models.StringDictionary or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(app_settings, (IO, bytes)):
            _content = app_settings
        else:
            _json = self._serialize.body(app_settings, "StringDictionary")

        request = build_update_application_settings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_application_settings_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_application_settings_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings"
    }

    @distributed_trace_async
    async def list_application_settings_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the application settings of an app.

        Gets the application settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         application settings for the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        request = build_list_application_settings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_application_settings_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_application_settings_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list"
    }

    @overload
    async def update_auth_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings: _models.SiteAuthSettings,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings: Auth settings associated with web app. Required.
        :type site_auth_settings: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_auth_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings: Auth settings associated with web app. Required.
        :type site_auth_settings: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_auth_settings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings: Union[_models.SiteAuthSettings, IO],
        **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Updates the Authentication / Authorization settings associated with web app.

        Updates the Authentication / Authorization settings associated with web app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings: Auth settings associated with web app. Is either a SiteAuthSettings
         type or a IO type. Required.
        :type site_auth_settings: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteAuthSettings] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_auth_settings, (IO, bytes)):
            _content = site_auth_settings
        else:
            _json = self._serialize.body(site_auth_settings, "SiteAuthSettings")

        request = build_update_auth_settings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_auth_settings_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettings", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_auth_settings_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings"
    }

    @distributed_trace_async
    async def get_auth_settings_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.SiteAuthSettings:
        """Gets the Authentication/Authorization settings of an app.

        Gets the Authentication/Authorization settings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         settings for the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettings or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteAuthSettings] = kwargs.pop("cls", None)

        request = build_get_auth_settings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_auth_settings_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettings", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_auth_settings_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list"
    }

    @overload
    async def update_auth_settings_v2_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings_v2: _models.SiteAuthSettingsV2,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Updates site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings_v2: Auth settings associated with web app. Required.
        :type site_auth_settings_v2: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_auth_settings_v2_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings_v2: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Updates site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings_v2: Auth settings associated with web app. Required.
        :type site_auth_settings_v2: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_auth_settings_v2_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_auth_settings_v2: Union[_models.SiteAuthSettingsV2, IO],
        **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Updates site's Authentication / Authorization settings for apps via the V2 format.

        Updates site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of web app. Required.
        :type name: str
        :param slot: Name of web app slot. If not specified then will default to production slot.
         Required.
        :type slot: str
        :param site_auth_settings_v2: Auth settings associated with web app. Is either a
         SiteAuthSettingsV2 type or a IO type. Required.
        :type site_auth_settings_v2: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2 or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteAuthSettingsV2] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_auth_settings_v2, (IO, bytes)):
            _content = site_auth_settings_v2
        else:
            _json = self._serialize.body(site_auth_settings_v2, "SiteAuthSettingsV2")

        request = build_update_auth_settings_v2_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_auth_settings_v2_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettingsV2", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_auth_settings_v2_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettingsV2"
    }

    @distributed_trace_async
    async def get_auth_settings_v2_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.SiteAuthSettingsV2:
        """Gets site's Authentication / Authorization settings for apps via the V2 format.

        Gets site's Authentication / Authorization settings for apps via the V2 format.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         settings for the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteAuthSettingsV2 or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteAuthSettingsV2
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteAuthSettingsV2] = kwargs.pop("cls", None)

        request = build_get_auth_settings_v2_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_auth_settings_v2_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteAuthSettingsV2", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_auth_settings_v2_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettingsV2/list"
    }

    @overload
    async def update_azure_storage_accounts_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        azure_storage_accounts: _models.AzureStoragePropertyDictionaryResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         Azure storage account configurations for the production slot. Required.
        :type slot: str
        :param azure_storage_accounts: Azure storage accounts of the app. Required.
        :type azure_storage_accounts:
         ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_azure_storage_accounts_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        azure_storage_accounts: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         Azure storage account configurations for the production slot. Required.
        :type slot: str
        :param azure_storage_accounts: Azure storage accounts of the app. Required.
        :type azure_storage_accounts: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_azure_storage_accounts_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        azure_storage_accounts: Union[_models.AzureStoragePropertyDictionaryResource, IO],
        **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Updates the Azure storage account configurations of an app.

        Updates the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         Azure storage account configurations for the production slot. Required.
        :type slot: str
        :param azure_storage_accounts: Azure storage accounts of the app. Is either a
         AzureStoragePropertyDictionaryResource type or a IO type. Required.
        :type azure_storage_accounts:
         ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AzureStoragePropertyDictionaryResource] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(azure_storage_accounts, (IO, bytes)):
            _content = azure_storage_accounts
        else:
            _json = self._serialize.body(azure_storage_accounts, "AzureStoragePropertyDictionaryResource")

        request = build_update_azure_storage_accounts_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_azure_storage_accounts_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AzureStoragePropertyDictionaryResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_azure_storage_accounts_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/azurestorageaccounts"
    }

    @distributed_trace_async
    async def list_azure_storage_accounts_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.AzureStoragePropertyDictionaryResource:
        """Gets the Azure storage account configurations of an app.

        Gets the Azure storage account configurations of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         Azure storage account configurations for the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AzureStoragePropertyDictionaryResource or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.AzureStoragePropertyDictionaryResource
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.AzureStoragePropertyDictionaryResource] = kwargs.pop("cls", None)

        request = build_list_azure_storage_accounts_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_azure_storage_accounts_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AzureStoragePropertyDictionaryResource", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_azure_storage_accounts_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/azurestorageaccounts/list"
    }

    @overload
    async def update_backup_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        request: _models.BackupRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         backup configuration for the production slot. Required.
        :type slot: str
        :param request: Edited backup configuration. Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_backup_configuration_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        request: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         backup configuration for the production slot. Required.
        :type slot: str
        :param request: Edited backup configuration. Required.
        :type request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_backup_configuration_slot(
        self, resource_group_name: str, name: str, slot: str, request: Union[_models.BackupRequest, IO], **kwargs: Any
    ) -> _models.BackupRequest:
        """Updates the backup configuration of an app.

        Updates the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         backup configuration for the production slot. Required.
        :type slot: str
        :param request: Edited backup configuration. Is either a BackupRequest type or a IO type.
         Required.
        :type request: ~azure.mgmt.web.v2021_01_15.models.BackupRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.BackupRequest] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(request, (IO, bytes)):
            _content = request
        else:
            _json = self._serialize.body(request, "BackupRequest")

        request = build_update_backup_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_backup_configuration_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupRequest", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_backup_configuration_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup"
    }

    @distributed_trace_async
    async def delete_backup_configuration_slot(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> None:
        """Deletes the backup configuration of an app.

        Deletes the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will delete the
         backup configuration for the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_backup_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_backup_configuration_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_backup_configuration_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup"
    }

    @distributed_trace_async
    async def get_backup_configuration_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.BackupRequest:
        """Gets the backup configuration of an app.

        Gets the backup configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         backup configuration for the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.BackupRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.BackupRequest] = kwargs.pop("cls", None)

        request = build_get_backup_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_backup_configuration_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackupRequest", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_backup_configuration_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list"
    }

    @distributed_trace
    def get_app_settings_key_vault_references_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.ApiKVReference"]:
        """Gets the config reference app settings and status of an app.

        Gets the config reference app settings and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ApiKVReference or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ApiKVReference]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ApiKVReferenceCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_app_settings_key_vault_references_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_app_settings_key_vault_references_slot.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApiKVReferenceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_app_settings_key_vault_references_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/appsettings"
    }

    @distributed_trace_async
    async def get_app_setting_key_vault_reference_slot(
        self, resource_group_name: str, name: str, app_setting_key: str, slot: str, **kwargs: Any
    ) -> _models.ApiKVReference:
        """Gets the config reference and status of an app.

        Gets the config reference and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param app_setting_key: App Setting key name. Required.
        :type app_setting_key: str
        :param slot: Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApiKVReference or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ApiKVReference
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ApiKVReference] = kwargs.pop("cls", None)

        request = build_get_app_setting_key_vault_reference_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            app_setting_key=app_setting_key,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_app_setting_key_vault_reference_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApiKVReference", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_app_setting_key_vault_reference_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/appsettings/{appSettingKey}"
    }

    @distributed_trace
    def get_site_connection_string_key_vault_references_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> AsyncIterable["_models.ApiKVReference"]:
        """Gets the config reference app settings and status of an app.

        Gets the config reference app settings and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ApiKVReference or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.ApiKVReference]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ApiKVReferenceCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_site_connection_string_key_vault_references_slot_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    slot=slot,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.get_site_connection_string_key_vault_references_slot.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApiKVReferenceCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_site_connection_string_key_vault_references_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/connectionstrings"
    }

    @distributed_trace_async
    async def get_site_connection_string_key_vault_reference_slot(
        self, resource_group_name: str, name: str, connection_string_key: str, slot: str, **kwargs: Any
    ) -> _models.ApiKVReference:
        """Gets the config reference and status of an app.

        Gets the config reference and status of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param connection_string_key: Required.
        :type connection_string_key: str
        :param slot: Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ApiKVReference or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ApiKVReference
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ApiKVReference] = kwargs.pop("cls", None)

        request = build_get_site_connection_string_key_vault_reference_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            connection_string_key=connection_string_key,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_site_connection_string_key_vault_reference_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApiKVReference", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_site_connection_string_key_vault_reference_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/configreferences/connectionstrings/{connectionStringKey}"
    }

    @overload
    async def update_connection_strings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        connection_strings: _models.ConnectionStringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         connection settings for the production slot. Required.
        :type slot: str
        :param connection_strings: Connection strings of the app or deployment slot. See example.
         Required.
        :type connection_strings: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_connection_strings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        connection_strings: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         connection settings for the production slot. Required.
        :type slot: str
        :param connection_strings: Connection strings of the app or deployment slot. See example.
         Required.
        :type connection_strings: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_connection_strings_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        connection_strings: Union[_models.ConnectionStringDictionary, IO],
        **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Replaces the connection strings of an app.

        Replaces the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         connection settings for the production slot. Required.
        :type slot: str
        :param connection_strings: Connection strings of the app or deployment slot. See example. Is
         either a ConnectionStringDictionary type or a IO type. Required.
        :type connection_strings: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectionStringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(connection_strings, (IO, bytes)):
            _content = connection_strings
        else:
            _json = self._serialize.body(connection_strings, "ConnectionStringDictionary")

        request = build_update_connection_strings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_connection_strings_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ConnectionStringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_connection_strings_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings"
    }

    @distributed_trace_async
    async def list_connection_strings_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.ConnectionStringDictionary:
        """Gets the connection strings of an app.

        Gets the connection strings of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         connection settings for the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ConnectionStringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.ConnectionStringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.ConnectionStringDictionary] = kwargs.pop("cls", None)

        request = build_list_connection_strings_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_connection_strings_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ConnectionStringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_connection_strings_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list"
    }

    @distributed_trace_async
    async def get_diagnostic_logs_configuration_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Gets the logging configuration of an app.

        Gets the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         logging configuration for the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.SiteLogsConfig] = kwargs.pop("cls", None)

        request = build_get_diagnostic_logs_configuration_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_diagnostic_logs_configuration_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteLogsConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_diagnostic_logs_configuration_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs"
    }

    @overload
    async def update_diagnostic_logs_config_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_logs_config: _models.SiteLogsConfig,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         logging configuration for the production slot. Required.
        :type slot: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Required.
        :type site_logs_config: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_diagnostic_logs_config_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_logs_config: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         logging configuration for the production slot. Required.
        :type slot: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Required.
        :type site_logs_config: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_diagnostic_logs_config_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        site_logs_config: Union[_models.SiteLogsConfig, IO],
        **kwargs: Any
    ) -> _models.SiteLogsConfig:
        """Updates the logging configuration of an app.

        Updates the logging configuration of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         logging configuration for the production slot. Required.
        :type slot: str
        :param site_logs_config: A SiteLogsConfig JSON object that contains the logging configuration
         to change in the "properties" property. Is either a SiteLogsConfig type or a IO type. Required.
        :type site_logs_config: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SiteLogsConfig or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.SiteLogsConfig
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SiteLogsConfig] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(site_logs_config, (IO, bytes)):
            _content = site_logs_config
        else:
            _json = self._serialize.body(site_logs_config, "SiteLogsConfig")

        request = build_update_diagnostic_logs_config_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_diagnostic_logs_config_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SiteLogsConfig", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_diagnostic_logs_config_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs"
    }

    @overload
    async def update_metadata_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        metadata: _models.StringDictionary,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         metadata for the production slot. Required.
        :type slot: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Required.
        :type metadata: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_metadata_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        metadata: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         metadata for the production slot. Required.
        :type slot: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Required.
        :type metadata: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_metadata_slot(
        self,
        resource_group_name: str,
        name: str,
        slot: str,
        metadata: Union[_models.StringDictionary, IO],
        **kwargs: Any
    ) -> _models.StringDictionary:
        """Replaces the metadata of an app.

        Replaces the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will update the
         metadata for the production slot. Required.
        :type slot: str
        :param metadata: Edited metadata of the app or deployment slot. See example. Is either a
         StringDictionary type or a IO type. Required.
        :type metadata: ~azure.mgmt.web.v2021_01_15.models.StringDictionary or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(metadata, (IO, bytes)):
            _content = metadata
        else:
            _json = self._serialize.body(metadata, "StringDictionary")

        request = build_update_metadata_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_metadata_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_metadata_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata"
    }

    @distributed_trace_async
    async def list_metadata_slot(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.StringDictionary:
        """Gets the metadata of an app.

        Gets the metadata of an app.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param name: Name of the app. Required.
        :type name: str
        :param slot: Name of the deployment slot. If a slot is not specified, the API will get the
         metadata for the production slot. Required.
        :type slot: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: StringDictionary or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.StringDictionary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.StringDictionary] = kwargs.pop("cls", None)

        request = build_list_metadata_slot_request(
            resource_group_name=resource_group_name,
            name=name,
            slot=slot,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.list_metadata_slot.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("StringDictionary", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_metadata_slot.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list"
    }

    async def _list_publishing_credentials_slot_initial(
        self, resource_group_name: str, name: str, slot: str, **kwargs: Any
    ) -> _models.User:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExist